# 用户认证开发概述

## 用户认证模块的定义

用户认证模块提供用户认证能力，对应用开发者而言，可使用该模块进行用户身份认证，用于设备解锁、支付、应用登录等身份认证场景。

当前用户认证提供人脸识别和指纹识别能力，设备具备哪种识别能力，取决于当前设备的硬件能力和技术实现。

## 基本概念

- 人脸识别：基于人的脸部特征信息进行身份识别的一种生物特征识别技术，用摄像机或摄像头采集含有人脸的图像或视频流，并自动在图像中检测和跟踪人脸，进而对检测到的人脸进行脸部识别，通常也叫做人像识别、面部识别、人脸认证。

- 指纹识别：基于人的指尖皮肤纹路进行身份识别的一种生物特征识别技术。当用户触摸指纹采集器件时，器件感知并获取到用户的指纹图像，然后传输到指纹识别模块进行一定的处理后与用户预先注册的指纹信息进行比对，从而识别出用户身份。

## 运作机制

人脸或指纹识别过程中，特征采集器件和TEE（Trusted Execution Environment）之间会建立安全通道，将采集的生物特征信息直接通过安全通道传递到TEE中，从而避免了恶意软件从REE（Rich Execution Environment）侧进行攻击。传输到TEE中的生物特征数据从活体检测、特征提取、特征存储、特征比对到特征销毁等处理都完全在TEE中完成，基于TrustZone进行安全隔离，提供API的服务框架只负责管理认证请求和处理认证结果等数据，不涉及生物特征数据本身。

用户注册的生物特征数据在TEE的安全存储区进行存储，采用高强度的密码算法进行加密和完整性保护，外部无法获取到加密生物特征数据的密钥，保证了用户生物特征数据的安全性。本能力采集和存储的生物特征数据不会在用户未授权的情况下被传出TEE。这意味着，用户未授权时，无论是系统应用还是三方应用都无法获得人脸和指纹等特征数据，也无法将这些特征数据传送或备份到任何外部存储介质。

## 约束与限制

- 当前版本提供的用户认证能力包含人脸识别和指纹识别，且只支持本地认证，不提供认证界面。
- 要求设备上具备相应的生物特征采集器，且对于人脸识别要求人脸图像分辨率大于100*100。
- 要求设备上具有TEE安全环境，人脸和指纹等生物特征信息高强度加密保存在TEE中。
- 对于面部特征相似的人、面部特征不断发育的儿童，人脸特征匹配率有所不同。如果对此担忧，可考虑其他认证方式。