# 系统能力SystemCapability列表

SysCap，全称SystemCapability，即系统能力，指操作系统中每一个相对独立的特性。

开发者使用某个接口进行开发前，建议先阅读[SysCap使用指南](syscap.md)，了解Syscap的定义和使用指导。再结合下文中的表格判断具体能力集是否支持某个设备，提高开发效率。

## SystemCapability.ArkUI.ArkUI.Full

ArKUI标准系统

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.ArkUI.ArkUI.Lite

ArkUI小型系统

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 是     | 是     | 是   | 是   | 是     | 是           | 否     |

## SystemCapability.ArkUI.ArkUI.Napi

napi功能

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.ArkUI.ArkUI.Libuv

libuv功能

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.ArkUI.UiAppearance

外观配置功能

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.BundleManager.BundleFramework

包管理服务

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.BundleManager.DistributedBundleFramework

分布式包管理服务

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.BundleManager.BundleTool

包管理命令行工具

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.BundleManager.Zlib

Zlib压缩、解压缩工具

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.BundleManager.PackingTool

包管理打包、拆包工具

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 是     | 是     | 是   | 是   | 是     | 是           | 否     |

## SystemCapability.Graphic.Graphic2D.WebGL

WebGL1.0 标准api

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Graphic.Graphic2D.WebGL2

WebGL2.0 标准api

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 否     | 否   | 否   | 否     | 否           | 否     |

## SystemCapability.WindowManager.WindowManager.Core

窗口管理

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.WindowManager.WindowManager.MutiScreen

多屏能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 否     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Notification.CommonEvent

公共事件

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Notification.Notification

通知

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Notification.ReminderAgent

后台代理提醒

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Notification.Emitter

事件处理服务

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Communication.IPC.Core

进程间通信

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 是           | 否     |

## SystemCapability.Communication.SoftBus.Core

软总线

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 是     | 是     | 是   | 是   | 是     | 是           | 是     |

## SystemCapability.Communication.NetManager.Core

网络管理基础服务

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Communication.NetManager.Extension

网络管理扩展服务

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 否     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Communication.NetStack

基础网络协议栈能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Communication.WiFi.Core

WIFI基础能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Communication.WiFi.STA

WIFI STA能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Communication.WiFi.AP.Core

WIFI AP能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Communication.WiFi.AP.Extension

WIFI AP扩展能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 否      | 否     | 否     | 否   | 否   | 否     | 否           | 是     |

## SystemCapability.Communication.WiFi.P2P

WIFI P2P能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Communication.Bluetooth.Core

蓝牙服务以及协议栈

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Communication.Bluetooth.Lite

蓝牙轻量级服务

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 是     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Communication.NFC.Core

NFC服务

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 否      | 否     | 否     | 否   | 否   | 否     | 否           | 否     |

## SystemCapability.Communication.ConnectedTag

有源NFC标签服务

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 否      | 否     | 否     | 否   | 否   | 否     | 否           | 否     |

## SystemCapability.Location.Location.Core

位置服务基础能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 否     | 否           | 否     |

## SystemCapability.Location.Location.Geocoder

地理编码能力
| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 否     | 否           | 否     |

## SystemCapability.Location.Location.Geofence

地理围栏能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 否     | 否           | 否     |

## SystemCapability.Location.Location.Gnss

GNSS硬件相关能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 否     | 否           | 否     |

## SystemCapability.Location.Location.Lite

位置服务轻设备能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 是     | 是     | 是   | 是   | 否     | 否           | 否     |

## SystemCapability.MultimodalInput.Input.Core

基本输入能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.MultimodalInput.Input.InputDevice

输入设备管理

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 否     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.MultimodalInput.Input.RemoteInputDevice

分布式输入设备管理

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 否     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.MultimodalInput.Input.InputMonitor

输入事件监听者

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 否     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.MultimodalInput.Input.InputConsumer

输入事件消费者

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.MultimodalInput.Input.InputSimulator

输入事件模拟者

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 否     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.MultimodalInput.Input.InputFilter

输入事件过滤器

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 否     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.PowerManager.BatteryManager.Extension

电池服务扩展能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 否   | 否     | 否           | 否     |

## SystemCapability.PowerManager.BatteryStatistics

耗电统计

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 否   | 否     | 否           | 否     |

## SystemCapability.PowerManager.DisplayPowerManager

显示能效管理

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 否   | 是     | 否           | 否     |

## SystemCapability.PowerManager.ThermalManager

温控服务

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.PowerManager.PowerManager.Core

系统电源管理服务核心能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.PowerManager.PowerManager.Lite

轻设备系统电源管理服务能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 否      | 是     | 否     | 否   | 否   | 否     | 是           | 是     |

## SystemCapability.PowerManager.BatteryManager.Core

电池服务核心能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 否   | 否     | 否           | 否     |

## SystemCapability.PowerManager.BatteryManager.Lite

轻设备电池服务能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 否      | 是     | 否     | 否   | 否   | 否     | 是           | 是     |

## SystemCapability.PowerManager.PowerManager.Extension

系统电源管理服务扩展能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 否   | 是     | 否           | 否     |

## SystemCapability.Multimedia.Media.Core

媒体基础能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Multimedia.Media.AudioPlayer

媒体音频播放引擎能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Multimedia.Media.AudioRecorder

媒体音频播录制引擎能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Multimedia.Media.VideoPlayer

媒体视频播放引擎能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Multimedia.Media.VideoRecorder

媒体视频录制引擎能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Multimedia.Media.CodecBase

媒体编解码基础能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Multimedia.Media.AudioDecoder

媒体音频解码能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Multimedia.Media.AudioEncoder

媒体音频编码能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Multimedia.Media.VideoDecoder

媒体视频解码能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Multimedia.Media.VideoEncoder

媒体视频编码能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Multimedia.Media.Spliter

媒体解封装能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Multimedia.Media.Muxer

媒体封装能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Multimedia.AVSession.Core

媒体会话基础能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Multimedia.AVSession.Manager

媒体会话管理能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Multimedia.Audio.Core

音频基础能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Multimedia.Audio.Renderer

音频输出能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Multimedia.Audio.Capturer

音频输入能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Multimedia.Audio.Device

音频设备管理能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Multimedia.Audio.Volume

音频音量管理能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Multimedia.Audio.Communication

音频通信能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Multimedia.Camera.Core

相机基础能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Multimedia.Camera.DistributedCore

相机分布式能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Multimedia.Image.Core

图片基础能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Multimedia.Image.ImageSource

图片源解码解析能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Multimedia.Image.ImagePacker

图片打包能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Multimedia.Image.ImageReceiver

图片接收能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Multimedia.MediaLibrary.Core

媒体库基础能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Multimedia.MediaLibrary.SmartAlbum

媒体库智慧相册能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Multimedia.MediaLibrary.DistributedCore

媒体库分布式能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Telephony.CoreService

蜂窝核心服务

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 否   | 否     | 否           | 否     |

## SystemCapability.Telephony.CallManager

通话管理服务

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 否     | 否           | 否     |

## SystemCapability.Telephony.CellularCall

蜂窝通话服务

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 否   | 否     | 否           | 否     |

## SystemCapability.Telephony.CellularData

蜂窝数据服务

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 否   | 否     | 否           | 否     |

## SystemCapability.Telephony.SmsMms

短彩信服务

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 否   | 否     | 否           | 否     |

## SystemCapability.Telephony.StateRegistry

蜂窝网络状态注册服务

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 否   | 否     | 否           | 否     |

## SystemCapability.Global.I18n

国际化

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Global.ResourceManager

资源管理

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Customization.ConfigPolicy

定制框架

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 是     | 是     | 是   | 是   | 是     | 是           | 是     |

## SystemCapability.Customization.EnterpriseDeviceManager

企业设备管理

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.BarrierFree.Accessibility.Core

提供开发辅助应用的能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.BarrierFree.Accessibility.Vision

无障碍视觉辅助能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.BarrierFree.Accessibility.Hearing

无障碍听觉辅助能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 否     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.BarrierFree.Accessibility.Interaction

无障碍行为辅助能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 否     | 是   | 否   | 是     | 否           | 否     |

## SystemCapability.ResourceSchedule.WorkScheduler

延迟任务调度

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.ResourceSchedule.BackgroundTaskManager.ContinuousTask

长时任务管理

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.ResourceSchedule.BackgroundTaskManager.TransientTask

短时任务管理

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.ResourceSchedule.UsageStatistics.App

应用使用信息统计

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.ResourceSchedule.UsageStatistics.AppGroup

应用使用活跃分组

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Utils.Lang

TS/JS语言基础库

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.HiviewDFX.HiLog

流水日志

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.HiviewDFX.HiLogLite

轻量级流水日志

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 否      | 是     | 否     | 否   | 否   | 否     | 是           | 是     |

## SystemCapability.HiviewDFX.HiTrace

分布式追踪

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.HiviewDFX.Hiview.FaultLogger

事件打点

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.HiviewDFX.HiviewLite

轻量级hiview服务

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 否      | 是     | 否     | 否   | 否   | 否     | 是           | 是     |

## SystemCapability.HiviewDFX.HiChecker

检测模式

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.HiviewDFX.HiCollie

卡死检测

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.HiviewDFX.HiDumper

系统信息导出

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.HiviewDFX.HiAppEvent

应用事件打点

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.HiviewDFX.HiSysEvent

系统事件打点

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.HiviewDFX.HiEventLite

轻量级事件打点

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 否      | 是     | 否     | 否   | 否   | 否     | 否           | 是     |

## SystemCapability.HiviewDFX.HiProfiler.HiDebug

调试调优

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Update.UpdateService

升级服务

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 是     | 是     | 是   | 是   | 是     | 是           | 是     |

## SystemCapability.DistributedHardware.DeviceManager

分布式设备管理

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 否   | 是     | 否           | 否     |

## SystemCapability.Security.DeviceAuth

设备互信认证

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 否   | 是     | 否           | 否     |

## SystemCapability.Security.DataTransitManager

数据传输管控策略库

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 否   | 是     | 否           | 否     |

## SystemCapability.Security.DeviceSecurityLevel

设备安全等级管理

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 否   | 是     | 否           | 否     |

## SystemCapability.Security.Huks

设备密钥管理

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 否   | 是     | 否           | 否     |

## SystemCapability.Security.AccessToken

访问控制

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Security.Cipher

加解密

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 否      | 否     | 否     | 否   | 否   | 否     | 是           | 否     |

## SystemCapability.Account.OsAccount

帐号

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Account.AppAccount

应用帐号

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.UserIAM.UserAuth.Core

统一用户认证

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 否   | 是     | 否           | 否     |

## SystemCapability.UserIAM.UserAuth.PinAuth

口令认证

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 否   | 是     | 否           | 否     |

## SystemCapability.UserIAM.UserAuth.FaceAuth

人脸认证

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 否   | 是     | 否           | 否     |

## SystemCapability.MiscServices.InputMethodFramework

输入法框架

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 否     | 是   | 否   | 否     | 否           | 否     |

## SystemCapability.MiscServices.Pasteboard

剪贴板服务

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 否     | 是   | 否   | 否     | 否           | 否     |

## SystemCapability.MiscServices.Time

时间时区定时

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 否   | 是     | 否           | 否     |

## SystemCapability.MiscServices.Wallpaper

壁纸框架

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 否     | 是   | 否   | 否     | 否           | 否     |

## SystemCapability.MiscServices.ScreenLock

锁屏服务

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 否     | 是   | 否   | 否     | 否           | 否     |

## SystemCapability.MiscServices.Upload

上传服务

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 否     | 是   | 否   | 否     | 否           | 否     |

## SystemCapability.MiscServices.Download

下载服务

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 否     | 是   | 否   | 否     | 否           | 否     |

## SystemCapability.FileManagement.StorageService.Backup

备份恢复

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 否     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.FileManagement.StorageService.SpatialStatistics

空间统计

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.FileManagement.StorageService.Volume

卷管理

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 否     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.FileManagement.StorageService.Encryption

文件加密能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 否     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.FileManagement.File.FileIO

基础文件IO接口

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 是     | 是     | 是   | 是   | 是     | 是           | 是     |

## SystemCapability.FileManagement.File.Environment

环境相关接口

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 是     | 是     | 是   | 是   | 是     | 是           | 是     |

## SystemCapability.FileManagement.File.DistributedFile

分布式文件扩展接口

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 否     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.FileManagement.AppFileService

应用文件分享

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 否     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.FileManagement.UserFileService

用户文件访问服务

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.USB.USBManager

usb服务

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 否     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Sensors.Sensor

传感器服务订阅

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 否   | 否     | 否           | 否     |

## SystemCapability.Sensors.MiscDevice

小器件-振感

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 否   | 否     | 否           | 否     |

## SystemCapability.Startup.SystemInfo

系统基本信息

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 是     | 是     | 是   | 是   | 是     | 是           | 是     |

## SystemCapability.DistributedDataManager.RelationalStore.Core

关系型数据库核心能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.DistributedDataManager.RelationalStore.Synchronize

关系型数据库分布式能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 否     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.DistributedDataManager.RelationalStore.Lite

轻量级关系型数据库

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 否      | 否     | 否     | 否   | 否   | 否     | 否           | 否     |

## SystemCapability.DistributedDataManager.KVStore.Core

Key-Value型数据库核心能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.DistributedDataManager.KVStore.Lite

轻量级Key-Value型数据库核心能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 否      | 否     | 否     | 否   | 否   | 否     | 否           | 否     |

## SystemCapability.DistributedDataManager.KVStore.DistributedKVStore

分布式Key-Value型数据库

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.DistributedDataManager.DataObject.DistributedObject

分布式对象

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.DistributedDataManager.Preferences.Core

偏好型数据存储核心能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.DistributedDataManager.DataShare.Core

跨进程数据共享，基础能力

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.DistributedDataManager.DataShare.Consumer

跨进程数据共享，数据消费者

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.DistributedDataManager.DataShare.Provider

跨进程数据共享，数据生产者

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Ability.AbilityBase

组件运行基础数据定义，主要包括组件通信数据的载体want、系统配置定义等

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Ability.AbilityRuntime.Core

组件运行核心基础功能模块，包括应用初始化、无界面组件运行等

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Ability.AbilityRuntime.FAModel

FA模型

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Ability.AbilityRuntime.AbilityCore

通用组件（有界面）

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Ability.AbilityRuntime.Mission

任务管理

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Ability.AbilityTools.AbilityAssistant

命令行工具

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Ability.Form

卡片管理

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Ability.DistributedAbilityManager

分布式流转管理（continuationManager）接口定义，支持打开互联面板、更新流转状态

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Applications.ContactsData

联系人数据库

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 否     | 否           | 否     |

## SystemCapability.Applications.Contacts

联系人

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 否     | 否           | 否     |

## SystemCapability.Applictaions.settings.Core

设置API

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Test.UiTest

UI测试框架能力支持

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 否     | 是   | 是   | 否     | 否           | 否     |

## SystemCapability.Web.Webview.Core

webview组件

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |

## SystemCapability.Cloud.AAID

AAID管理服务

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 是     | 是     | 是   | 是   | 是     | 是           | 是     |

## SystemCapability.Cloud.OAID

OAID管理服务

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 是     | 是     | 是   | 是   | 是     | 是           | 是     |

## SystemCapability.Cloud.VAID

VAID管理服务

| Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| 是      | 是     | 是     | 是   | 是   | 是     | 是           | 是     |
