# 输入法框架错误码

## 12800001 包管理服务异常

**错误信息**

Package manager error.

**错误描述**

当依赖包管理接口来获取一些信息失败时，系统会报此错误码。

**可能原因**

在调用getInputMethods、listCurrentInputMethodSubtype等接口获取输入法及子类型的时候，由于获取包管理服务异常时会报错。

**处理步骤**

无

## 12800002 输入法应用异常

**错误信息**

Input method engine error.

**错误描述**

用户调用输入法应用接口失败时，系统会报此错误码。

**可能原因**

在执行显示键盘、隐藏键盘等操作时，由于输入法应用进程死亡导致操作失败时会报错。

**处理步骤**

查看输入法应用进程是否正常。例如再次在普通应用（微信、联系人等第三方应用）中点击对话框看键盘能否被正常拉起。

## 12800003 客户端应用异常

**错误信息**

Input method client error.

**错误描述**

当三方应用（微信、设置、联系人等）的对话框等编辑控件调用显示键盘、隐藏键盘失败时，系统会报此错误码。

**可能原因**

三方应用客户端服务异常导致输入法应用与三方应用客户端断链。

**处理步骤**

重新将输入法应用与三方应用进行绑定：将三方应用后台进程杀死，重新启动三方应用，通过点击对话框等方式触发输入法键盘的显示，若键盘正常显示，则问题解决。

## 12800004 按键事件处理异常

**错误信息**

Key event processing error.

**错误描述**

当按键事件异常时，系统会报此错误码。

**可能原因**

按键事件分发、消费、监听异常时会报错。

**处理步骤**

无

## 12800005 配置固化失败

**错误信息**

Configuration persisting error.

**错误描述**

当保存配置失败时，系统会报此错误码。

**可能原因**

当调用切换输入法接口的时候，会保存输入法的配置参数，系统参数配置模块异常导致参数保存失败时会报错。

**处理步骤**

执行hdc shell param get persist.sys.default_ime查看默认输入法参数，若可查看，则系统参数配置模块正常，可重启设备进行尝试。

## 12800006 输入法控制器异常

**错误信息**

Input method controller error.

**错误描述**

当获取到输入法控制器失败时，系统会报此错误码。

**可能原因**

在调用getCotroller接口获取输入法控制器InputMethodController时发生异常时会报错。

**处理步骤**

无。

## 12800007 输入法设置器异常

**错误信息**

Input method settings extension error.

**错误描述**

当获取到输入法设置器发生错误时，系统会报此错误码。

**可能原因**

在调用getSetting接口获取输入法设置器InputMethodSetting时发生异常时会报错。

**处理步骤**

无。

## 12800008 输入法管理服务异常

**错误信息**

Input method manager service error.

**错误描述**

获取输入法管理服务异常时，系统会报此错误码。

**可能原因**

当调用[输入法框架](../apis/js-apis-inputmethod.md)中的任何接口都有可能由于依赖输入法管理服务，而服务找不到时发生此异常。

**处理步骤**

通过ps -A|grep inputmethod查看是否存在输入法服务的进程号，如果存在，则服务正常。