# 企业设备管理错误码

## 9200001 应用没有激活成设备管理器

**错误信息**

The application is not a administrator of the device.

**错误描述**

当应用没有激活成设备管理器时，则会产生此错误码。

**可能原因**

应用没有激活设备管理器。

**处理步骤**

请检查调用者是否成功激活过设备管理器，没有激活过的设备管理器的应用无法调用设备管理接口。

## 9200002 设备管理器权限不够

**错误信息**

The administrator application does not have permission to manage the device.

**错误描述**

当设备管理器调用高权限接口时，则会产生此错误码。

**可能原因**

激活成了DA管理器，调用了SDA管理器接口。

**处理步骤**

请检查调用者是否存在越权调用，即激活的设备管理器类型和调用的API要求的管理器类型是否一致。

## 9200003 指定的设备管理器元能力组件无效

**错误信息**

The administrator ability component is invalid.

**错误描述**

当应用传入参数中指定的设备管理器元能力组件无效，则会产生此错误码。

**可能原因**

该错误码表示指定的设备管理器元能力组件无效，可能原因如下。
1. 应用激活设备管理器时指定的设备管理器元能力组件不存在。
2. 设备管理器元能力组件不是合法的企业设备管理元能力组件。

**处理步骤**

1. 请检查激活时输入的设备管理器元能力组件name是否存在应用包中。
2. 请检查企业设备管理组件是否继承企业设备管理框架定义的EnterpriseAdminExtensionAbility组件。

## 9200004 激活设备管理器失败

**错误信息**

Failed to activate the administrator application of the device.

**错误描述**

当应用重复激活不同类型的设备管理器或激活多个管理器时，则会产生此错误码。

**可能原因**

该错误码表示激活设备管理器失败，可能原因如下。
1. 同时激活多个SDA设备管理器。
2. 重复激活设备管理器，且管理器类型发生变化。
3. 同一个应用多个设备管理器元能力组件激活。

**处理步骤**

1. 检查是否激活多个SDA设备管理器，SDA设备管理器只允许激活一个。
2. 检查指定的设备管理器是否已激活了，且重复激活时管理器类型发生变化，此时需要先去激活，再重新激活。
3. 检查待激活的设备管理器应用中是否已有设备管理元能力组件激活过，同一个应用只允许激活一个设备管理器元能力组件

## 9200005 去激活设备管理器失败

**错误信息**

Failed to deactivate the administrator application of the device.

**错误描述**

当应用没有激活过或者去激活其他设备管理器时，则会产生此错误码。

**可能原因**

该错误码表示去激活设备管理器失败，可能原因如下。
1. 去激活的设备管理器应用没有激活过。
2. 不能去激活其他设备管理器。

**处理步骤**

1. 检查去激活时设备管理应用是否激活过。
2. 检查去激活时设备管理应用中指定设备管理元能力组件是否激活过。
3. 检查调用者是否去激活自身，设备管理器应用不能去激活其他设备管理器应用。

## 9200006 指定的用户ID非法

**错误信息**

The specified user ID is invalid.

**错误描述**

当应用调用接口设置用户策略，指定的user id不存在、或者DA,SDA管理器跨用户设置时，则会产生此错误码。

**可能原因**

该错误码表示指定的用户ID非法，可能原因如下。
1. 调用接口设置用户策略时候，指定的user id不存在。
2. 指定的user id和调用者user id不同。DA,SDA管理器不允许跨用户设置。

**处理步骤**

1. 检查去调用接口中指定的user id是否是有效的user id。
2. 检查调用者user id和指定设置的user id是否是同一user id，非SDA模式下不允许跨用户设置策略。

## 9200007 系统服务工作异常

**错误信息**

The system ability work abnormally.

**错误描述**

当企业设备管理服务异常时，则会产生此错误码。

**可能原因**

该错误码表示系统服务工作异常，可能原因如下。
1. 企业设备管理服务没有正常启动。
2. 企业设备管理的RPC对象无法获取。
3. 企业设备管理依赖的其他服务没有正常启动或者RPC对象无法获取。
4. 企业设备管理运行过程中系统异常。

**处理步骤**

系统服务内部工作异常，请稍后重试，或者重启设备尝试。

## 9200008 系统订阅事件无效

**错误信息**

The specified system events enum is invalid.

**错误描述**

当企业设备管理暂不支持订阅此事件或系统订阅的事件无效时，则会产生此错误码。

**可能原因**

企业设备管理暂不支持订阅此事件或系统订阅的事件无效。

**处理步骤**

检查所订阅事件是企业设备管理所支持的有效管理事件。