# 分布式键值数据库错误码

## 15100001 超过最大订阅数量

**错误信息**

Over max subscribe limits.

**错误描述**

该错误码表示在调用数据库变化订阅on接口时，订阅数量已超过最大限制。

**可能原因**

在调用订阅数据库变化接口时，对数据库的订阅数量已超过最大限制。

**处理步骤**

取消对数据库的部分订阅后，再次尝试订阅。

## 15100002 打开已有数据库时参数配置发生变化

**错误信息**

Open existed database with changed options.

**错误描述**

该错误码表示在调用getKVStore接口打开已创建的数据库时，options配置参数发生变化。

**可能原因**

打开已创建的数据库时，options参数配置发生了变化，可能原因如下：
1. 期望新建数据库时，使用了已创建过的数据库名称storeId。
2. 期望改变已创建数据库的options参数配置。

**处理步骤**

1. 新建数据库前，请检查数据库名称storeId不与已创建数据库的storeId重名。
2. 期望改变已创建数据库的options参数配置时，当前不支持该操作，请自行删除数据库后使用新的options参数重新创建。

## 15100003 数据库损坏

**错误信息**

Database corrupted.

**错误描述**

该错误码表示在调用数据库增、删、查、数据同步等接口时，数据库已损坏。

**可能原因**

调用数据库增、删、查、数据同步等接口操作数据库时，数据库文件已损坏。

**处理步骤**

1. 如果之前备份过数据库，可尝试使用已备份的数据库文件恢复数据库。
2. 如果之前没有备份过数据库，可尝试删除数据库后重新创建。

## 15100004 未找到相关数据

**错误信息**

Not found.

**错误描述**

该错误码表示在调用数据库deleteKVStore、sync、get等接口时，未找到相关数据。

**可能原因**

在调用删除数据库、数据查询、数据同步等接口时未找到相关数据，可能原因如下。
1. 删除数据库操作时，数据库不存在或已删除。
2. 数据库数据查询操作时，相关数据不存在或已删除。
3. 数据库数据同步操作时，数据库不存在或已删除。

**处理步骤**

1. 在删除数据库操作前，请检查数据库名称是否正确或是否重复删除。
2. 在数据库数据查询操作前，请检查查询关键字是否正确。
3. 在数据库数据同步操作前，请检查相关数据库是否已经删除。

## 15100005 数据库或查询结果集已关闭

**错误信息**

Database or result set already closed.

**错误描述**

该错误码表示在调用数据库或查询结果集相关接口时，数据库或查询结果集为关闭状态。

**可能原因**

在数据库或查询结果集操作前，已经手动关闭了数据库或查询结果集。

**处理步骤**

1. 在数据库相关操作前，请重新打开数据库之后再重试当前操作。
2. 在查询结果集相关操作前，请重新查询获取结果集之后再重试当前操作。