# 关系型数据库错误码

## 14800010 数据库名称不合法

**错误信息**

Invalid database name.

**错误描述**

数据库名称不合法。

**可能原因**

无效的数据库名称，数据库名称为空或包含的字符超出1024字节。

**处理步骤**

检查传入数据库名称，检查数据库名称是否为空或包含的字符超出1024字节。

## 14800011 数据库文件损坏

**错误信息**

Database corrupted.

**错误描述**

该错误码表示在调用数据库增、删、查、数据同步等接口时，数据库已损坏。

**可能原因**

调用数据库增、删、查、数据同步等接口操作数据库时，数据库文件已损坏。

**处理步骤**

1. 如果之前备份过数据库，可尝试使用已备份的数据库文件恢复数据库。
2. 如果之前没有备份过数据库，可尝试删除数据库后重新创建。

## 14800012 结果集为空或指定位置不合法

**错误信息**

The result set is  empty or the specified location is invalid.

**错误描述**

结果集为空或指定位置不合法。

**可能原因**

结果集为空或结果集指定行号超出位置范围[0, m - 1]，m = resultsetV9.rowCount。

**处理步骤**

检查当前操作得到的结果集是否为空或指定的位置是否合法。

## 14800013 列值为空或列类型与当前调用接口不兼容

**错误信息**

The column value is  null or the column type is incompatible.

**错误描述**

列值为空或列类型与当前调用接口不兼容。

**可能原因**

1. 结果集为空。
2. 结果集当前行号超出范围[0, m - 1]，m = resultsetV9.rowCount。
3. 当前列号超出范围[0, n - 1]，n = resultsetV9.columnCount。
4. 当前列数据类型接口不支持。

**处理步骤**

1. 检查结果集是否为空。
2. 检查结果集当前行号、列号是否超出范围。
3. 检查当前列数据类型是否支持。
