# 元能力子系统错误码

## 16000001 指定的Ability名称不存在

**错误信息**

Input error. The specified ability name does not exist.

**错误描述**

当指定的Ability名称不存在时，方法将返回该错误码。

**可能原因**

所查询的Ability不存在。

**处理步骤**

1. 检查包名称是否正确。
2. 检查包名对应的Ability是否正确。

## 16000002 接口调用Ability类型错误

**错误信息**

Ability type error. The specified ability type is wrong.

**错误描述**

当接口调用Ability类型错误时，方法将返回该错误码。

**可能原因**

接口调用所在的Ability类型不支持该接口调用。

**处理步骤**

1. 检查包名对应的Ability是否正确。
2. 根据Ability类型调用不同接口。

## 16000003 指定的ID不存在

**错误信息**

Input error. The specified id does not exist.

**错误描述**

当指定的ID不存在时，方法将返回该错误码。

**可能原因**

操作的目标ID不存在。

**处理步骤**

确认操作的ID是否存在。

## 16000004 可见性校验失败

**错误信息**

Visibility verification failed.

**错误描述**

当可见性校验失败时，方法将返回该错误码。

**可能原因**

应用可见性校验失败。

**处理步骤**

请检查应用是否满足被拉起应用可见性限制。

## 16000006 不允许跨用户操作

**错误信息**

Can not cross user operations.

**错误描述**

当应用跨用户操作时，方法将返回该错误码。

**可能原因**

应用进行了跨用户操作。

**处理步骤**

确认是否进行了跨用户操作。

## 16000007 服务繁忙

**错误信息**

Service busyness. There are concurrent tasks, waiting for retry.

**错误描述**

当服务繁忙时，方法将返回该错误码。

**可能原因**

服务繁忙。

**处理步骤**

服务繁忙，请稍后重试。

## 16000008 众测应用到期

**错误信息**

Crowdtest App Expiration.

**错误描述**

当众测应用到期时，方法将返回该错误码。

**可能原因**

众测应用到期，无法打开。

**处理步骤**

请检查应用是否众测到期。

## 16000009 wukong模式，不允许启动/停止ability

**错误信息**

Can not start ability in wukong mode.

**错误描述**

当wukong模式下，启动/停止ability时，方法将返回该错误码。

**可能原因**

wukong模式，不允许启动/停止ability。

**处理步骤**

请勿在wukong模型下启动/停止Ability。

## 16000010 不允许带迁移flag

**错误信息**

Can not operation with continue flag.

**错误描述**

当调用携带迁移flag时，方法将返回该错误码。

**可能原因**

当前调用不允许携带迁移flag。

**处理步骤**

请检查是否携带迁移flag。

## 16000011 上下文对象不存在

**错误信息**

Context does not exist.

**错误描述**

当上下文对象不存在时，方法将返回该错误码。

**可能原因**

当前上下文对象不存在。

**处理步骤**

请检查上下文对象是否可用。

## 16000050 内部错误

**错误信息**

Internal Error.

**错误描述**

当内存申请、多线程处理异常等内部处理错误时，方法将返回该错误码。

**可能原因**

内存申请、多线程处理等内核通用错误。

**处理步骤**

确认系统内存是否足够。

## 16000051 网络异常

**错误信息**

Network error. The network is abnormal.

**错误描述**

当网络异常时，方法将返回该错误码。

**可能原因**

网络不可用。

**处理步骤**

网络异常，请稍后重试，或者重连网络尝试。

## 16000052 不支持免安装

**错误信息**

Free install not support. The applicaiotn dose not support free install.

**错误描述**

当前应用不支持免安装时，方法将返回该错误码。

**可能原因**

应用包不满足免安装要求，如包大小超过限制等。

**处理步骤**

请检查应用是否支持免安装。

## 16000053 非顶层应用

**错误信息**

Not top ability. The application is not top ability.

**错误描述**

当前应用未显示在界面顶层时，方法将返回该错误码。

**可能原因**

应用未显示在界面顶层。

**处理步骤**

请检查应用是否显示在界面顶层。

## 16000054 免安装服务繁忙

**错误信息**

Free install busyness. There are concurrent tasks, waiting for retry.

**错误描述**

当免安装服务繁忙时，方法将返回该错误码。

**可能原因**

已有相同免安装任务在执行。

**处理步骤**

免安装服务繁忙，请稍后重试。

## 16000055 免安装超时

**错误信息**

Free install timeout.

**错误描述**

当免安装超时时，方法将返回该错误码。

**可能原因**

免安装超时。

**处理步骤**

免安装超时，请稍后重试。

## 16000056 不允许免安装其他应用

**错误信息**

Can not free install other ability.

**错误描述**

当免安装其他应用时，方法将返回该错误码。

**可能原因**

不允许免安装其他应用。

**处理步骤**

确认免安装的是正确的应用。

## 16000057 不支持跨设备免安装

**错误信息**

Not support cross device free install.

**错误描述**

当持跨设备免安装时，方法将返回该错误码。

**可能原因**

不支持跨设备免安装。

**处理步骤**

确认为非跨设备免安装应用。

## 16000101 执行shell命令失败

**错误信息**

execute shell command failed.

**错误描述**

当命令不是有效的shell命令时，方法将返回该错误码。

**可能原因**

命令不是有效的shell命令。

**处理步骤**

检查命令是否为有效的shell命令。

## 16000151 无效wantAgent对象

**错误信息**

Invalid wantagent object.

**错误描述**

当传入接口的wantAgent对象无效时，方法将返回该错误码。

**可能原因**

传入接口的wantAgent对象无效。

**处理步骤**

检查传入接口的wantAgent对象。

## 16000152 未找到wantAgent对象

**错误信息**

wantAgent object not found.

**错误描述**

当传入接口的wantAgent对象不存在时，方法将返回该错误码。

**可能原因**

传入接口的wantAgent对象不存在。

**处理步骤**

检查传入接口的wantAgent对象是否合法。

## 16000153 wangAgent对象已取消

**错误信息**

wangAgent object canceled.

**错误描述**

当传入接口的wangAgent对象已取消时，方法将返回该错误码。

**可能原因**

传入接口的触发的wantAgent已取消。

**处理步骤**

检查触发的wantAgent对象是否已取消。

## 16100001 指定Uri的Ability不存在

**错误信息**

Input error. The specified uri does not exist.

**错误描述**

当指定Uri的Ability不存在时，方法将返回该错误码。

**可能原因**

所查询的Ability不存在。

**处理步骤**

确认查询的Ability是否存在。

## 16100002 接口调用Ability类型错误

**错误信息**

Ability type error. The specified ability type is wrong.

**错误描述**

当接口调用Ability类型错误时，方法将返回该错误码。

**可能原因**

接口调用所在的Ability类型不支持该接口调用。

**处理步骤**

1. 检查包名对应的Ability是否正确。
2. 根据Ability类型调用不同接口。

## 16200001 通用组件客户端(Caller)已回收

**错误信息**

Caller released. The caller has been released.

**错误描述**

当通用组件客户端(Caller)已回收时，方法将返回该错误码。

**可能原因**

通用组件客户端(Caller)已回收。

**处理步骤**

请重新注册有效通用组件客户端调用接口。

## 16200002 通用组件服务端(Callee)无效

**错误信息**

Callee Invalid. The callee does not exist.

**错误描述**

当通用组件服务端(Callee)无效时，方法将返回该错误码。

**可能原因**

通用组件服务端(Callee)不存在。

**处理步骤**

请检查通用组件服务端是否存在。

## 16200003 回收失败

**错误信息**

Release error. The caller does not call any callee.

**错误描述**

当回收失败时，方法将返回该错误码。

**可能原因**

通用组件客户端(Caller)对象未注册通用组件服务端(Callee)。

**处理步骤**

请检查是否已注册通用组件服务端。

## 16200004 方法已注册

**错误信息**

Method registered. The method has registered.

**错误描述**

当方法已注册时，方法将返回该错误码。

**可能原因**

方法已在通用组件服务端注册过。

**处理步骤**

请检查是否已注册该方法。

## 16200005 方法未注册

**错误信息**

Method not registered. The method has not registered.

**错误描述**

当方法未注册时，方法将返回该错误码。

**可能原因**

方法未在通用组件服务端注册。

**处理步骤**

请检查是否未注册该方法。

## 16300001 指定的任务不存在

**错误信息**

Mission id error. The specified mission id does not exist.

**错误描述**

当指定的任务不存在时，方法将返回该错误码。

**可能原因**

操作的目标任务不存在。

**处理步骤**

确认操作的任务是否存在。

## 16300002 指定的任务监听器不存在

**错误信息**

Input  error. The specified mission listener id does not exist.

**错误描述**

当指定的任务监听器不存在时，方法将返回该错误码。

**可能原因**

操作的目标任务监听器不存在。

**处理步骤**

确认操作的任务监听器是否存在。

## 18500001 指定的包名无效

**错误信息**

The specified bundleName is invalid.

**错误描述**

当指定的包名无效时，方法将返回该错误码。

**可能原因**

待查询的bundle不存在或未安装。

**处理步骤**

确认查询的应用是否已安装。

## 18500002 指定的补丁包无效

**错误信息**

The specified hqf is invalid. Hqf may not exist or inaccessible.

**错误描述**

当指定的补丁包无效，补丁包不存在或不可访问时，方法将返回该错误码。

**可能原因**

待安装的补丁包文件不存在或不可以访问。

**处理步骤**

1. 请检查传递的补丁包文件路径是否有效。
2. 请检查是否有权限访问此补丁包文件。

## 18500003 补丁包部署失败

**错误信息**

Deploy hqf failed.

**错误描述**

当补丁包部署失败时，方法将返回该错误码。

**可能原因**

1. patch.json中type只能为patch或者hotreload，否则部署失败。
2. 若对应bundleName的hap包未安装，部署失败。
3. bundleName、versionCode必须和已安装的hap应用相同，如果为patch类型，还需确保versionName相同，否则部署失败。
4. 如果已经部署过补丁包，新部署的补丁包的versionCode必须大于之前补丁包的versionCode，否则部署失败。
5. 对于patch类型的补丁会校验签名信息，使用的签名证书需要和应用相同，签名不一致，部署失败。
6. 在部署patch类型的补丁包时，如果是debug版本，先判断是否有在使用的补丁包，如果在使用的补丁包为hotreload类型，则部署失败。
7. 在部署hotreload类型的补丁包时，如果是debug版本，先判断是否有在使用的补丁包，如果在使用的补丁包为patch类型，则部署失败；如果是release版本，则部署失败。

**处理步骤**

请检查补丁包是否符合规则。

## 18500004 补丁包使能失败

**错误信息**

Switch hqf failed.

**错误描述**

当补丁包使能失败时，方法将返回该错误码。

**可能原因**

使能补丁时补丁包状态不正确。

**处理步骤**

请检查补丁包状态。

## 18500005 补丁包删除失败

**错误信息**

Delete hqf failed.

**错误描述**

当补丁包删除失败时，方法将返回该错误码。

**可能原因**

删除旧补丁时补丁包状态不正确。

**处理步骤**

请检查补丁包状态。

## 18500006 加载补丁失败

**错误信息**

Load patch failed.

**错误描述**

当加载补丁失败时，方法将返回该错误码。

**可能原因**

方舟引擎加载补丁失败。

**处理步骤**

请检查补丁包是否正确。

## 18500007 卸载旧补丁失败

**错误信息**

Unload patch failed.

**错误描述**

当方舟引擎卸载旧补丁失败时，方法将返回该错误码。

**可能原因**

方舟引擎加载补丁失败。

**处理步骤**

请检查补丁包是否正确。

## 18500008 快速修复内部错误

**错误信息**

Internal error.

**错误描述**

当内存申请、多线程处理异常等内部处理错误时，方法将返回该错误码。

**可能原因**

内存申请、多线程处理等内核通用错误。

**处理步骤**

确认系统内存是否足够。
