# 基于ArkTS的声明式开发范式

- [组件导读](ts-components-summary.md)
- 组件通用信息
  - 通用事件
    - [点击事件](ts-universal-events-click.md)
    - [触摸事件](ts-universal-events-touch.md)
    - [挂载卸载事件](ts-universal-events-show-hide.md)
    - [拖拽事件](ts-universal-events-drag-drop.md)
    - [按键事件](ts-universal-events-key.md)
    - [焦点事件](ts-universal-focus-event.md)
    - [鼠标事件](ts-universal-mouse-key.md)
    - [组件区域变化事件](ts-universal-component-area-change-event.md)
    - [组件可见区域变化事件](ts-universal-component-visible-area-change-event.md)
  - 通用属性
    - [尺寸设置](ts-universal-attributes-size.md)
    - [位置设置](ts-universal-attributes-location.md)
    - [布局约束](ts-universal-attributes-layout-constraints.md)
    - [Flex布局](ts-universal-attributes-flex-layout.md)
    - [边框设置](ts-universal-attributes-border.md)
    - [图片边框设置](ts-universal-attributes-border-image.md)
    - [背景设置](ts-universal-attributes-background.md)
    - [透明度设置](ts-universal-attributes-opacity.md)
    - [显隐控制](ts-universal-attributes-visibility.md)
    - [禁用控制](ts-universal-attributes-enable.md)
    - [浮层](ts-universal-attributes-overlay.md)
    - [Z序控制](ts-universal-attributes-z-order.md)
    - [图形变换](ts-universal-attributes-transformation.md)
    - [图像效果](ts-universal-attributes-image-effect.md)
    - [形状裁剪](ts-universal-attributes-sharp-clipping.md)
    - [文本样式设置](ts-universal-attributes-text-style.md)
    - [栅格设置](ts-universal-attributes-grid.md)
    - [颜色渐变](ts-universal-attributes-gradient-color.md)
    - [Popup控制](ts-universal-attributes-popup.md)
    - [Menu控制](ts-universal-attributes-menu.md)
    - [点击控制](ts-universal-attributes-click.md)
    - [焦点控制](ts-universal-attributes-focus.md)
    - [悬浮态效果](ts-universal-attributes-hover-effect.md)
    - [组件标识](ts-universal-attributes-component-id.md)
    - [触摸热区设置](ts-universal-attributes-touch-target.md)
    - [多态样式](ts-universal-attributes-polymorphic-style.md)
    - [触摸测试控制](ts-universal-attributes-hit-test-behavior.md)
    - [背景模糊设置](ts-universal-attributes-backgroundBlurStyle.md)
    - [分布式迁移标识](ts-universal-attributes-restoreId.md)
  - 手势处理
    - [绑定手势方法](ts-gesture-settings.md)
    - 基础手势
      - [TapGesture](ts-basic-gestures-tapgesture.md)
      - [LongPressGesture](ts-basic-gestures-longpressgesture.md)
      - [PanGesture](ts-basic-gestures-pangesture.md)
      - [PinchGesture](ts-basic-gestures-pinchgesture.md)
      - [RotationGesture](ts-basic-gestures-rotationgesture.md)
      - [SwipeGesture](ts-basic-gestures-swipegesture.md)
    - [组合手势](ts-combined-gestures.md)
- 基础组件
  - [Blank](ts-basic-components-blank.md)
  - [Button](ts-basic-components-button.md)
  - [Checkbox](ts-basic-components-checkbox.md)
  - [CheckboxGroup](ts-basic-components-checkboxgroup.md)
  - [DataPanel](ts-basic-components-datapanel.md)
  - [DatePicker](ts-basic-components-datepicker.md)
  - [Divider](ts-basic-components-divider.md)
  - [Gauge](ts-basic-components-gauge.md)
  - [Image](ts-basic-components-image.md)
  - [ImageAnimator](ts-basic-components-imageanimator.md)
  - [LoadingProgress](ts-basic-components-loadingprogress.md)
  - [Marquee](ts-basic-components-marquee.md)
  - [Navigation](ts-basic-components-navigation.md)
  - [NavRouter](ts-basic-components-navrouter.md)
  - [NavDestination](ts-basic-components-navdestination.md)
  - [PatternLock](ts-basic-components-patternlock.md)
  - [PluginComponent](ts-basic-components-plugincomponent.md)
  - [Progress](ts-basic-components-progress.md)
  - [QRCode](ts-basic-components-qrcode.md)
  - [Radio](ts-basic-components-radio.md)
  - [Rating](ts-basic-components-rating.md)
  - [RemoteWindow](ts-basic-components-remotewindow.md)
  - [RichText](ts-basic-components-richtext.md)
  - [ScrollBar](ts-basic-components-scrollbar.md)
  - [Search](ts-basic-components-search.md)
  - [Select](ts-basic-components-select.md)
  - [Slider](ts-basic-components-slider.md)
  - [Span](ts-basic-components-span.md)
  - [Stepper](ts-basic-components-stepper.md)
  - [StepperItem](ts-basic-components-stepperitem.md)
  - [Text](ts-basic-components-text.md)
  - [TextArea](ts-basic-components-textarea.md)
  - [TextClock](ts-basic-components-textclock.md)
  - [TextInput](ts-basic-components-textinput.md)
  - [TextPicker](ts-basic-components-textpicker.md)
  - [TextTimer](ts-basic-components-texttimer.md)
  - [TimePicker](ts-basic-components-timepicker.md)
  - [Toggle](ts-basic-components-toggle.md)
  - [Web](ts-basic-components-web.md)
  - [XComponent](ts-basic-components-xcomponent.md)
- 容器组件
  - [AbilityComponent](ts-container-ability-component.md)
  - [AlphabetIndexer](ts-container-alphabet-indexer.md)
  - [Badge](ts-container-badge.md)
  - [Column](ts-container-column.md)
  - [ColumnSplit](ts-container-columnsplit.md)
  - [Counter](ts-container-counter.md)
  - [Flex](ts-container-flex.md)
  - [GridCol](ts-container-gridcol.md)
  - [GridRow](ts-container-gridrow.md)
  - [Grid](ts-container-grid.md)
  - [GridItem](ts-container-griditem.md)
  - [List](ts-container-list.md)
  - [ListItem](ts-container-listitem.md)
  - [ListItemGroup](ts-container-listitemgroup.md)
  - [Navigator](ts-container-navigator.md)
  - [Panel](ts-container-panel.md)
  - [Refresh](ts-container-refresh.md)
  - [RelativeContainer](ts-container-relativecontainer.md)
  - [Row](ts-container-row.md)
  - [RowSplit](ts-container-rowsplit.md)
  - [Scroll](ts-container-scroll.md)
  - [SideBarContainer](ts-container-sidebarcontainer.md)
  - [Stack](ts-container-stack.md)
  - [Swiper](ts-container-swiper.md)
  - [Tabs](ts-container-tabs.md)
  - [TabContent](ts-container-tabcontent.md)
- 媒体组件
  - [Video](ts-media-components-video.md)
- 绘制组件
  - [Circle](ts-drawing-components-circle.md)
  - [Ellipse](ts-drawing-components-ellipse.md)
  - [Line](ts-drawing-components-line.md)
  - [Polyline](ts-drawing-components-polyline.md)
  - [Polygon](ts-drawing-components-polygon.md)
  - [Path](ts-drawing-components-path.md)
  - [Rect](ts-drawing-components-rect.md)
  - [Shape](ts-drawing-components-shape.md)
- 画布组件
  - [Canvas](ts-components-canvas-canvas.md)
  - [CanvasRenderingContext2D对象](ts-canvasrenderingcontext2d.md)
  - [CanvasGradient对象](ts-components-canvas-canvasgradient.md)
  - [ImageBitmap对象](ts-components-canvas-imagebitmap.md)
  - [ImageData对象](ts-components-canvas-imagedata.md)
  - [OffscreenCanvasRenderingContext2D对象](ts-offscreencanvasrenderingcontext2d.md)
  - [Path2D对象](ts-components-canvas-path2d.md)
  - [Lottie](ts-components-canvas-lottie.md)
- 动画
  - [属性动画](ts-animatorproperty.md)
  - [显式动画](ts-explicit-animation.md)
  - 转场动画
    - [页面间转场](ts-page-transition-animation.md)
    - [组件内转场](ts-transition-animation-component.md)
    - [共享元素转场](ts-transition-animation-shared-elements.md)
  - [路径动画](ts-motion-path-animation.md)
- 全局UI方法
  - 弹窗
    - [警告弹窗](ts-methods-alert-dialog-box.md)
    - [列表选择弹窗](ts-methods-action-sheet.md)
    - [自定义弹窗](ts-methods-custom-dialog-box.md)
    - [日期选择弹窗](ts-methods-datepicker-dialog.md)
    - [时间选择弹窗](ts-methods-timepicker-dialog.md)
    - [文本选择弹窗](ts-methods-textpicker-dialog.md)
  - [菜单](ts-methods-menu.md)
- [应用级变量的状态管理](ts-state-management.md)
- [像素单位](ts-pixel-units.md)
- [枚举说明](ts-appendix-enums.md)
- [类型说明](ts-types.md)
- 已停止维护的组件
  - [GridContainer](ts-container-gridcontainer.md)
