# 设计自检表


设计自检表详细列举出了在全场景设备设计和开发过程中应当注意的设计规则，这将帮助应用减少用户舆情且提升用户体验的一致性。


自检表的要求范围分为“必须”与“推荐”两个类别。必须类一般为已总结出的较优解决方案或效果，表示相关设计需要按照此原则统一执行；推荐类指可能受应用品牌风格或业务特殊性影响，可适量做出修改。


请参考以下表格范围内提出的要求对应用进行检查。

| **类型** | **条目**           | **说明**                                                     | **类别** |
| -------- | ------------------ | ------------------------------------------------------------ | ------ |
| 应用架构 | 导航结构           | 在各设备上页面导航结构保持一致（同时出多个设备的UX设计）。   | 推荐 |
| 布局     | 拉通设计           | 拉通各设备的布局设计，保证在不同尺寸和分辨率的设备上能够无错位/不截断/不变形/不过多空白（50%以上）/不过于拥挤（间距小于16vp，明显截断）/无大图大字体地正常显示。 | 必须 |
|          | 响应式设计         | 栅格布局只能占N列以及N列内部的Gutter，不包含N列两侧的Gutter。 | 必须 |
|          | 响应式设计         | 明确标注使用什么类型的栅格、给出在不同断点下栅格三要素取值。 | 推荐 |
|          | 响应式设计         | 按容器去对齐栅格，而不是内部子元素对齐栅格。                 | 必须 |
|          | 响应式设计         | 栅格除了页面布局设计外，在做局部栅格设计时，需要通过明显方式如颜色等进行标注区分，避免混淆。 | 推荐 |
|          | 响应式设计         | 禁止出现标注了栅格但实际没有通过栅格进行布局设计，避免混淆。 | 必须 |
|          | 自适应设计         | 非栅格设计场景下，明确标注自适应布局能力。自适应布局能力有：拉伸、均分、占比、缩放、延伸、隐藏、折行。 | 推荐 |
| 人机交互 | 输入方式           | 需保证在各设备上完整支持触摸、鼠标、触控、键盘、遥控器、摇杆等交互方式，并符合标准定义。 | 推荐 |
|          | 交互归一           | 应使用系统提供的控件以达到一致的交互体验。如有定制，需保证在各场景下，不同输入设备上的操作与指南要求一致。需特别注意鼠标行为。 | 推荐 |
| 视觉风格 | 单位               | 用于界面布局的单位应全部使用vp。只针对严格控制元素尺寸的场景使用px。 | 必须 |
|          | 色彩               | 用于色彩的赋值应使用分层参数。推荐支持深色模式，需保证界面在系统切换色彩模式时没有识别性问题。 | 推荐 |
|          | 字体               | 使用fp为文字大小单位，需要响应系统大字体模式，确保系统调节字体大小后，界面字体能响应变化大小，并且界面布局没有出现布局错乱问题。 | 必须 |
| 多态控件 | 支持常用的控件状态 | 确保控件不同状态下的视觉效果没有缺失。控件的常用状态有：正常态、不可用态、点击态、获焦态、激活态、悬停态。 | 推荐 |