# 应用开发

- [应用开发导读](application-dev-guide.md)
- 了解OpenHarmony
  - [了解OpenHarmony开源项目](../OpenHarmony-Overview_zh.md)
  - [术语](../glossary.md)
  - [版本说明](../release-notes/Readme.md)
- 入门
  - 快速入门
    - [开发准备](quick-start/start-overview.md)
    - [使用ArkTS语言开发（Stage模型）](quick-start/start-with-ets-stage.md)
    - [使用ArkTS语言开发（FA模型）](quick-start/start-with-ets-fa.md)
    - [使用JS语言开发（FA模型）](quick-start/start-with-js-fa.md)
  - 开发基础知识
    - 应用程序包基础知识
      - [应用程序包概述](quick-start/application-package-overview.md)
      - 应用程序包结构
        - [Stage模型应用程序包结构](quick-start/application-package-structure-stage.md)
        - [FA模型应用程序包结构](quick-start/application-package-structure-fa.md)
        - [HAR包结构](quick-start/har-structure.md)
      - 应用程序包多HAP机制
        - [多HAP机制设计目标](quick-start/multi-hap-objective.md)
        - [多HAP构建视图](quick-start/multi-hap-build-view.md)
        - [多HAP的开发调试与发布部署流程](quick-start/multi-hap-release-deployment.md)
        - [多HAP使用规则](quick-start/multi-hap-rules.md)
        - [多HAP运行机制及数据通信方式](quick-start/multi-hap-principles.md)
      - [应用程序包安装和卸载流程](quick-start/application-package-install-uninstall.md)
    - 应用配置文件（Stage模型）
      - [应用配置文件概述（Stage模型）](quick-start/application-configuration-file-overview-stage.md)
      - [app.json5配置文件](quick-start/app-configuration-file.md)
      - [module.json5配置文件](quick-start/module-configuration-file.md)
    - 应用配置文件（FA模型）
      - [应用配置文件概述（FA模型）](quick-start/application-configuration-file-overview-fa.md)
      - [app对象内部结构](quick-start/app-structure.md)
      - [deviceConfig内部结构](quick-start/deviceconfig-structure.md)
      - [module对象内部结构](quick-start/module-structure.md)
    - [资源分类与访问](quick-start/resource-categories-and-access.md)
  - 学习ArkTS语言
    - [初识ArkTS语言](quick-start/arkts-get-started.md)
    - ArkTS语法（声明式UI）
      - [基本UI描述](quick-start/arkts-basic-ui-description.md)
      - 状态管理
        - [基本概念](quick-start/arkts-state-mgmt-concepts.md)
        - [页面级变量的状态管理](quick-start/arkts-state-mgmt-page-level.md)
        - [应用级变量的状态管理](quick-start/arkts-state-mgmt-application-level.md)
      - [动态构建UI元素](quick-start/arkts-dynamic-ui-elememt-building.md)
      - [渲染控制](quick-start/arkts-rendering-control.md)
      - [使用限制与扩展](quick-start/arkts-restrictions-and-extensions.md)
- 开发
  - [应用模型](application-models/Readme-CN.md)
  - [UI开发](ui/Readme-CN.md)
  - [通知](notification/Readme-CN.md)
  - [窗口管理](windowmanager/Readme-CN.md)
  - [WebGL](webgl/Readme-CN.md)
  - [媒体](media/Readme-CN.md)
  - [安全](security/Readme-CN.md)
  - [网络与连接](connectivity/Readme-CN.md)
  - [数据管理](database/Readme-CN.md)
  - [文件管理](file-management/Readme-CN.md)
  - [电话服务](telephony/Readme-CN.md)
  - [任务管理](task-management/Readme-CN.md)
  - [设备管理](device/Readme-CN.md)
  - [设备使用信息统计](device-usage-statistics/Readme-CN.md)
  - [DFX](dfx/Readme-CN.md)
  - [国际化](internationalization/Readme-CN.md)
  - [应用测试](application-test/Readme-CN.md)
  - [一次开发，多端部署](key-features/multi-device-app-dev/Readme-CN.md)
  - [IDL工具规格及使用说明书](IDL/idl-guidelines.md)
  - [Native API的相关指导](napi/Readme-CN.md)
- 工具
  - [DevEco Studio（OpenHarmony）使用指南](quick-start/deveco-studio-user-guide-for-openharmony.md)
  - [调试工具](tools/Readme-CN.md)
- 示例教程
  - [示例代码](https://gitee.com/openharmony/applications_app_samples/blob/master/README_zh.md)
  - [Codelabs](https://gitee.com/openharmony/codelabs/blob/master/README.md)
- API参考
  - [系统能力SystemCapability使用指南](reference/syscap.md)
  - [系统能力SystemCapability列表](reference/syscap-list.md)
  - [组件参考（基于TS扩展的声明式开发范式）](reference/arkui-ts/Readme-CN.md)
  - [组件参考（基于JS扩展的类Web开发范式）](reference/arkui-js/Readme-CN.md)
  - [JS服务卡片UI组件参考](reference/js-service-widget-ui/Readme-CN.md)
  - 接口
    - [ArkTS及JS API参考](reference/apis/Readme-CN.md)
    - [错误码参考](reference/errorcodes/Readme-CN.md)
    - Native API
      - [Native API参考](reference/native-apis/Readme-CN.md)
      - [标准库](reference/native-lib/third_party_libc/musl.md)
      - [Node_API](reference/native-lib/third_party_napi/napi.md)
- [常见问题](faqs/Readme-CN.md)
- 贡献
  - [参与贡献](../contribute/贡献文档.md)
