# JS API Changes of the Security Subsystem

The table below lists the APIs changes of the security subsystem in OpenHarmony 3.2 Beta3 over OpenHarmony 3.2 Beta2.

## API Changes

| Module| Class| Method/Attribute/Enumeration/Constant| Change Type|
|---|---|---|---|
| ohos.privacyManager           | ActiveChangeResponse   | activeStatus: PermissionActiveStatus;                                                                                                                                                                      | Added|
| ohos.privacyManager           | ActiveChangeResponse   | deviceId: string;                                                                                                                                                                                          | Added|
| ohos.privacyManager           | ActiveChangeResponse   | permissionName: string;                                                                                                                                                                                    | Added|
| ohos.privacyManager           | ActiveChangeResponse   | tokenId: number;                                                                                                                                                                                           | Added|
| ohos.privacyManager           | PermissionActiveStatus | PERM_ACTIVE_IN_BACKGROUND = 2                                                                                                                                                                              | Added|
| ohos.privacyManager           | PermissionActiveStatus | PERM_ACTIVE_IN_FOREGROUND = 1                                                                                                                                                                              | Added|
| ohos.privacyManager           | PermissionActiveStatus | PERM_INACTIVE = 0                                                                                                                                                                                          | Added|
| ohos.privacyManager           | privacyManager         | off(type: 'activeStateChange', permissionNameList: Array\<string>, callback?: Callback\<ActiveChangeResponse>): void;                                                                             | Added|
| ohos.privacyManager           | privacyManager         | on(type: 'activeStateChange', permissionNameList: Array\<string>, callback: Callback\<ActiveChangeResponse>): void;                                                                               | Added|
| ohos.privacyManager           | privacyManager         | stopUsingPermission(tokenID: number, permissionName: string): Promise\<number>;<br>stopUsingPermission(tokenID: number, permissionName: string, callback: AsyncCallback\<number>): void; | Added|
| ohos.privacyManager           | privacyManager         | startUsingPermission(tokenID: number, permissionName: string): Promise\<number>;<br>startUsingPermission(tokenID: number, permissionName: string, callback: AsyncCallback\<number>): void; | Added|
| ohos.security.cryptoFramework | cryptoFramework        | createCertChainValidator(algorithm :string) : CertChainValidator;                                                                                                                                 | Added|
| ohos.security.cryptoFramework | CertChainValidator     | readonly algorithm : string;                                                                                                                                                                               | Added|
| ohos.security.cryptoFramework | CertChainValidator     | validate(certChain : CertChainData, callback : AsyncCallback\<void>) : void;<br>validate(certChain : CertChainData) : Promise\<void>;                                                                     | Added|
| ohos.security.cryptoFramework | cryptoFramework        | createX509Crl(inStream : EncodingBlob, callback : AsyncCallback\<X509Crl>) : void;<br>createX509Crl(inStream : EncodingBlob) : Promise\<X509Crl>;                                       | Added|
| ohos.security.cryptoFramework | X509Crl                | getSignatureAlgParams() : DataBlob;                                                                                                                                                                        | Added|
| ohos.security.cryptoFramework | X509Crl                | getSignatureAlgOid() : string;                                                                                                                                                                             | Added|
| ohos.security.cryptoFramework | X509Crl                | getSignatureAlgName() : string;                                                                                                                                                                            | Added|
| ohos.security.cryptoFramework | X509Crl                | getSignature() : DataBlob;                                                                                                                                                                                 | Added|
| ohos.security.cryptoFramework | X509Crl                | getTbsInfo(callback : AsyncCallback\<DataBlob>) : void;<br>getTbsInfo() : Promise\<DataBlob>;                                                                                                             | Added|
| ohos.security.cryptoFramework | X509Crl                | getRevokedCerts(callback : AsyncCallback\<Array\<X509CrlEntry>>) : void;<br>getRevokedCerts() : Promise\<Array\<X509CrlEntry>>;                                                                           | Added|
| ohos.security.cryptoFramework | X509Crl                | getRevokedCertWithCert(cert : X509Cert, callback : AsyncCallback\<X509CrlEntry>) : void;<br>getRevokedCertWithCert(cert : X509Cert) : Promise\<X509CrlEntry>;                                             | Added|
| ohos.security.cryptoFramework | X509Crl                | getRevokedCert(serialNumber : number, callback : AsyncCallback\<X509CrlEntry>) : void;<br>getRevokedCert(serialNumber : number) : Promise\<X509CrlEntry>;                                                 | Added|
| ohos.security.cryptoFramework | X509Crl                | getNextUpdate() : string;                                                                                                                                                                                  | Added|
| ohos.security.cryptoFramework | X509Crl                | getLastUpdate() : string;                                                                                                                                                                                  | Added|
| ohos.security.cryptoFramework | X509Crl                | getIssuerName() : DataBlob;                                                                                                                                                                                | Added|
| ohos.security.cryptoFramework | X509Crl                | getVersion() : number;                                                                                                                                                                                     | Added|
| ohos.security.cryptoFramework | X509Crl                | verify(key : PubKey, callback : AsyncCallback\<void>) : void;<br>verify(key : PubKey) : Promise\<void>;                                                                                                   | Added|
| ohos.security.cryptoFramework | X509Crl                | getEncoded(callback : AsyncCallback\<EncodingBlob>) : void;<br>getEncoded() : Promise\<EncodingBlob>;                                                                                                     | Added|
| ohos.security.cryptoFramework | X509Crl                | getType() : string;                                                                                                                                                                                        | Added|
| ohos.security.cryptoFramework | X509Crl                | isRevoked(cert : X509Cert, callback : AsyncCallback\<boolean>) : void;<br>isRevoked(cert : X509Cert) : Promise\<boolean>;                                                                                 | Added|
| ohos.security.cryptoFramework | X509CrlEntry           | getRevocationDate(callback : AsyncCallback\<string>) : void;<br>getRevocationDate() : Promise\<string>;                                                                                                   | Added|
| ohos.security.cryptoFramework | X509CrlEntry           | getCertIssuer(callback : AsyncCallback\<DataBlob>) : void;<br>getCertIssuer() : Promise\<DataBlob>;                                                                                                       | Added|
| ohos.security.cryptoFramework | X509CrlEntry           | getSerialNumber() : number;                                                                                                                                                                                | Added|
| ohos.security.cryptoFramework | X509CrlEntry           | getEncoded(callback : AsyncCallback\<EncodingBlob>) : void;<br>getEncoded() : Promise\<EncodingBlob>;                                                                                                     | Added|
| ohos.security.cryptoFramework | cryptoFramework        | createX509Cert(inStream : EncodingBlob, callback : AsyncCallback\<X509Cert>) : void;<br>createX509Cert(inStream : EncodingBlob) : Promise\<X509Cert>;                                   | Added|
| ohos.security.cryptoFramework | X509Cert               | getIssuerAltNames() : DataArray;                                                                                                                                                                           | Added|
| ohos.security.cryptoFramework | X509Cert               | getSubjectAltNames() : DataArray;                                                                                                                                                                          | Added|
| ohos.security.cryptoFramework | X509Cert               | getBasicConstraints() : number;                                                                                                                                                                            | Added|
| ohos.security.cryptoFramework | X509Cert               | getExtKeyUsage() : DataArray;                                                                                                                                                                              | Added|
| ohos.security.cryptoFramework | X509Cert               | getKeyUsage() : DataBlob;                                                                                                                                                                                  | Added|
| ohos.security.cryptoFramework | X509Cert               | getSignatureAlgParams() : DataBlob;                                                                                                                                                                        | Added|
| ohos.security.cryptoFramework | X509Cert               | getSignatureAlgOid() : string;                                                                                                                                                                             | Added|
| ohos.security.cryptoFramework | X509Cert               | getSignatureAlgName() : string;                                                                                                                                                                            | Added|
| ohos.security.cryptoFramework | X509Cert               | getSignature() : DataBlob;                                                                                                                                                                                 | Added|
| ohos.security.cryptoFramework | X509Cert               | getNotAfterTime() : string;                                                                                                                                                                                | Added|
| ohos.security.cryptoFramework | X509Cert               | getNotBeforeTime() : string;                                                                                                                                                                               | Added|
| ohos.security.cryptoFramework | X509Cert               | getSubjectName() : DataBlob;                                                                                                                                                                               | Added|
| ohos.security.cryptoFramework | X509Cert               | getIssuerName() : DataBlob;                                                                                                                                                                                | Added|
| ohos.security.cryptoFramework | X509Cert               | getSerialNumber() : number;                                                                                                                                                                                | Added|
| ohos.security.cryptoFramework | X509Cert               | getVersion() : number;                                                                                                                                                                                     | Added|
| ohos.security.cryptoFramework | X509Cert               | checkValidityWithDate(date: string, callback : AsyncCallback\<void>) : void;<br>checkValidityWithDate(date: string) : Promise\<void>;                                                                     | Added|
| ohos.security.cryptoFramework | X509Cert               | getPublicKey(callback : AsyncCallback\<PubKey>) : void;<br>getPublicKey() : Promise\<PubKey>;                                                                                                             | Added|
| ohos.security.cryptoFramework | X509Cert               | getEncoded(callback : AsyncCallback\<EncodingBlob>) : void;<br>getEncoded() : Promise\<EncodingBlob>;                                                                                                     | Added|
| ohos.security.cryptoFramework | X509Cert               | verify(key : PubKey, callback : AsyncCallback\<void>) : void;<br>verify(key : PubKey) : Promise\<void>;                                                                                                   | Added|
| ohos.security.cryptoFramework | cryptoFramework        | createKeyAgreement(algName : string) : KeyAgreement;                                                                                                                                              | Added|
| ohos.security.cryptoFramework | KeyAgreement           | readonly algName : string;                                                                                                                                                                                 | Added|
| ohos.security.cryptoFramework | KeyAgreement           | generateSecret(priKey : PriKey, pubKey : PubKey, callback : AsyncCallback\<DataBlob>) : void;<br>generateSecret(priKey : PriKey, pubKey : PubKey) : Promise\<DataBlob>;                                   | Added|
| ohos.security.cryptoFramework | cryptoFramework        | createVerify(algName : string) : Verify;                                                                                                                                                          | Added|
| ohos.security.cryptoFramework | cryptoFramework        | createSign(algName : string) : Sign;                                                                                                                                                              | Added|
| ohos.security.cryptoFramework | Verify                 | readonly algName : string;                                                                                                                                                                                 | Added|
| ohos.security.cryptoFramework | Verify                 | verify(data : DataBlob, signatureData : DataBlob, callback : AsyncCallback\<boolean>) : void;<br>verify(data : DataBlob, signatureData : DataBlob) : Promise\<boolean>;                                   | Added|
| ohos.security.cryptoFramework | Verify                 | update(data : DataBlob, callback : AsyncCallback\<void>) : void;<br>update(data : DataBlob) : Promise\<void>;                                                                                             | Added|
| ohos.security.cryptoFramework | Verify                 | init(pubKey : PubKey, callback : AsyncCallback\<void>) : void;<br>init(pubKey : PubKey) : Promise\<void>;                                                                                                 | Added|
| ohos.security.cryptoFramework | Sign                   | readonly algName : string;                                                                                                                                                                                 | Added|
| ohos.security.cryptoFramework | Sign                   | sign(data : DataBlob, callback : AsyncCallback\<DataBlob>) : void;<br>sign(data : DataBlob) : Promise\<DataBlob>;                                                                                         | Added|
| ohos.security.cryptoFramework | Sign                   | update(data : DataBlob, callback : AsyncCallback\<void>) : void;<br>update(data : DataBlob) : Promise\<void>;                                                                                             | Added|
| ohos.security.cryptoFramework | Sign                   | init(priKey : PriKey, callback : AsyncCallback\<void>) : void;<br>init(priKey : PriKey) : Promise\<void>;                                                                                                 | Added|
| ohos.security.cryptoFramework | cryptoFramework        | createCipher(transformation : string) : Cipher;                                                                                                                                                   | Added|
| ohos.security.cryptoFramework | Cipher                 | readonly algName : string;                                                                                                                                                                                 | Added|
| ohos.security.cryptoFramework | Cipher                 | doFinal(data : DataBlob, callback : AsyncCallback\<DataBlob>) : void;<br>doFinal(data : DataBlob) : Promise\<DataBlob>;                                                                                   | Added|
| ohos.security.cryptoFramework | Cipher                 | update(data : DataBlob, callback : AsyncCallback\<DataBlob>) : void;<br>update(data : DataBlob) : Promise\<DataBlob>;                                                                                     | Added|
| ohos.security.cryptoFramework | Cipher                 | init(opMode : CryptoMode, key : Key, params : ParamsSpec, callback : AsyncCallback\<void>) : void;<br>init(opMode : CryptoMode, key : Key, params : ParamsSpec) : Promise\<void>;                         | Added|
| ohos.security.cryptoFramework | cryptoFramework        | createMd(algName : string) : Md;                                                                                                                                                                  | Added|
| ohos.security.cryptoFramework | Md                     | readonly algName : string;                                                                                                                                                                                 | Added|
| ohos.security.cryptoFramework | Md                     | getMdLength() : number;                                                                                                                                                                                    | Added|
| ohos.security.cryptoFramework | Md                     | digest(callback : AsyncCallback\<DataBlob>) : void;<br>digest() : Promise\<DataBlob>;                                                                                                                     | Added|
| ohos.security.cryptoFramework | Md                     | update(input : DataBlob, callback : AsyncCallback\<void>) : void;<br>update(input : DataBlob) : Promise\<void>;                                                                                           | Added|
| ohos.security.cryptoFramework | cryptoFramework        | createMac(algName : string) : Mac;                                                                                                                                                                | Added|
| ohos.security.cryptoFramework | Mac                    | readonly algName : string;                                                                                                                                                                                 | Added|
| ohos.security.cryptoFramework | Mac                    | getMacLength() : number;                                                                                                                                                                                   | Added|
| ohos.security.cryptoFramework | Mac                    | doFinal(callback : AsyncCallback\<DataBlob>) : void;<br>doFinal() : Promise\<DataBlob>;                                                                                                                   | Added|
| ohos.security.cryptoFramework | Mac                    | update(input : DataBlob, callback : AsyncCallback\<void>) : void;<br>update(input : DataBlob) : Promise\<void>;                                                                                           | Added|
| ohos.security.cryptoFramework | Mac                    | init(key : SymKey, callback : AsyncCallback\<void>) : void;<br>init(key : SymKey) : Promise\<void>;                                                                                                       | Added|
| ohos.security.cryptoFramework | cryptoFramework        | createSymKeyGenerator(algName : string) : SymKeyGenerator;                                                                                                                                        | Added|
| ohos.security.cryptoFramework | cryptoFramework        | createAsyKeyGenerator(algName : string) : AsyKeyGenerator;                                                                                                                                        | Added|
| ohos.security.cryptoFramework | SymKeyGenerator        | readonly algName : string;                                                                                                                                                                                 | Added|
| ohos.security.cryptoFramework | SymKeyGenerator        | convertKey(key : DataBlob, callback : AsyncCallback\<SymKey>) : void;<br>convertKey(key : DataBlob) : Promise\<SymKey>;                                                                                   | Added|
| ohos.security.cryptoFramework | SymKeyGenerator        | generateSymKey(callback : AsyncCallback\<SymKey>) : void;<br>generateSymKey() : Promise\<SymKey>;                                                                                                         | Added|
| ohos.security.cryptoFramework | AsyKeyGenerator        | readonly algName : string;                                                                                                                                                                                 | Added|
| ohos.security.cryptoFramework | AsyKeyGenerator        | convertKey(pubKey : DataBlob, priKey : DataBlob, callback : AsyncCallback\<KeyPair>) : void;<br>convertKey(pubKey : DataBlob, priKey : DataBlob) : Promise\<KeyPair>;                                     | Added|
| ohos.security.cryptoFramework | AsyKeyGenerator        | generateKeyPair(callback : AsyncCallback\<KeyPair>) : void;<br>generateKeyPair() : Promise\<KeyPair>;                                                                                                     | Added|
| ohos.security.cryptoFramework | cryptoFramework        | createRandom() : Random;                                                                                                                                                                          | Added|
| ohos.security.cryptoFramework | Random                 | setSeed(seed : DataBlob, callback : AsyncCallback\<void>) : void;<br>setSeed(seed : DataBlob) : Promise\<void>;                                                                                           | Added|
| ohos.security.cryptoFramework | Random                 | generateRandom(len : number, callback: AsyncCallback\<DataBlob>) : void;<br>generateRandom(len : number) : Promise\<DataBlob>;                                                                            | Added|
| ohos.security.cryptoFramework | KeyPair                | readonly pubKey : PubKey;                                                                                                                                                                                  | Added|
| ohos.security.cryptoFramework | KeyPair                | readonly priKey : PriKey;                                                                                                                                                                                  | Added|
| ohos.security.cryptoFramework | PriKey                 | clearMem() : void;                                                                                                                                                                                         | Added|
| ohos.security.cryptoFramework | SymKey                 | clearMem() : void;                                                                                                                                                                                         | Added|
| ohos.security.cryptoFramework | Key                    | readonly algName : string;                                                                                                                                                                                 | Added|
| ohos.security.cryptoFramework | Key                    | readonly format : string;                                                                                                                                                                                  | Added|
| ohos.security.cryptoFramework | Key                    | getEncoded() : DataBlob;                                                                                                                                                                                   | Added|
| ohos.security.cryptoFramework | CryptoMode             | DECRYPT_MODE = 1                                                                                                                                                                                           | Added|
| ohos.security.cryptoFramework | CryptoMode             | ENCRYPT_MODE = 0                                                                                                                                                                                           | Added|
| ohos.security.cryptoFramework | CcmParamsSpec          | authTag : DataBlob;                                                                                                                                                                                        | Added|
| ohos.security.cryptoFramework | CcmParamsSpec          | aad : DataBlob;                                                                                                                                                                                            | Added|
| ohos.security.cryptoFramework | CcmParamsSpec          | iv : DataBlob;                                                                                                                                                                                             | Added|
| ohos.security.cryptoFramework | GcmParamsSpec          | authTag : DataBlob;                                                                                                                                                                                        | Added|
| ohos.security.cryptoFramework | GcmParamsSpec          | aad : DataBlob;                                                                                                                                                                                            | Added|
| ohos.security.cryptoFramework | GcmParamsSpec          | iv : DataBlob;                                                                                                                                                                                             | Added|
| ohos.security.cryptoFramework | IvParamsSpec           | iv : DataBlob;                                                                                                                                                                                             | Added|
| ohos.security.cryptoFramework | ParamsSpec             | algoName : string;                                                                                                                                                                                         | Added|
| ohos.security.cryptoFramework | CertChainData          | encodingFormat: EncodingFormat;                                                                                                                                                                            | Added|
| ohos.security.cryptoFramework | CertChainData          | count : number;                                                                                                                                                                                            | Added|
| ohos.security.cryptoFramework | CertChainData          | data: Uint8Array;                                                                                                                                                                                          | Added|
| ohos.security.cryptoFramework | EncodingBlob           | encodingFormat : EncodingFormat;                                                                                                                                                                           | Added|
| ohos.security.cryptoFramework | EncodingBlob           | data : Uint8Array;                                                                                                                                                                                         | Added|
| ohos.security.cryptoFramework | EncodingFormat         | FORMAT_PEM = 1                                                                                                                                                                                             | Added|
| ohos.security.cryptoFramework | EncodingFormat         | FORMAT_DER = 0                                                                                                                                                                                             | Added|
| ohos.security.cryptoFramework | DataArray              | data : Array\<Uint8Array>;                                                                                                                                                                                 | Added|
| ohos.security.cryptoFramework | DataBlob               | data : Uint8Array;                                                                                                                                                                                         | Added|
| ohos.security.cryptoFramework | Result                 | ERR_KEYUSAGE_NO_DIGITAL_SIGNATURE = 17630007                                                                                                                                                               | Added|
| ohos.security.cryptoFramework | Result                 | ERR_KEYUSAGE_NO_CERTSIGN = 17630006                                                                                                                                                                        | Added|
| ohos.security.cryptoFramework | Result                 | ERR_UNABLE_TO_GET_ISSUER_CERT_LOCALLY = 17630005                                                                                                                                                           | Added|
| ohos.security.cryptoFramework | Result                 | ERR_CERT_HAS_EXPIRED = 17630004                                                                                                                                                                            | Added|
| ohos.security.cryptoFramework | Result                 | ERR_CERT_NOT_YET_VALID = 17630003                                                                                                                                                                          | Added|
| ohos.security.cryptoFramework | Result                 | ERR_CERT_SIGNATURE_FAILURE = 17630002                                                                                                                                                                      | Added|
| ohos.security.cryptoFramework | Result                 | ERR_CRYPTO_OPERATION = 17630001                                                                                                                                                                            | Added|
| ohos.security.cryptoFramework | Result                 | ERR_EXTERNAL_ERROR = 17620002                                                                                                                                                                              | Added|
| ohos.security.cryptoFramework | Result                 | ERR_OUT_OF_MEMORY = 17620001                                                                                                                                                                               | Added|
| ohos.security.cryptoFramework | Result                 | NOT_SUPPORT = 801                                                                                                                                                                                          | Added|
| ohos.security.cryptoFramework | Result                 | INVALID_PARAMS = 401                                                                                                                                                                                       | Added|
| ohos.security.huks            | HuksTag                | HUKS_TAG_CHALLENGE_POS = HuksTagType.HUKS_TAG_TYPE_UINT | 310                                                                                                                                              |
| ohos.security.huks            | HuksTag                | HUKS_TAG_CHALLENGE_TYPE = HuksTagType.HUKS_TAG_TYPE_UINT | 309                                                                                                                                             |
| ohos.security.huks            | HuksTag                | HUKS_TAG_KEY_SECURE_SIGN_TYPE = HuksTagType.HUKS_TAG_TYPE_UINT | 308                                                                                                                                       |
| ohos.security.huks            | HuksTag                | HUKS_TAG_KEY_AUTH_ACCESS_TYPE = HuksTagType.HUKS_TAG_TYPE_UINT | 307                                                                                                                                       |
| ohos.security.huks            | HuksSecureSignType     | HUKS_SECURE_SIGN_WITH_AUTHINFO = 1                                                                                                                                                                         | Added|
| ohos.security.huks            | HuksChallengePosition  | HUKS_CHALLENGE_POS_3                                                                                                                                                                                       | Added|
| ohos.security.huks            | HuksChallengePosition  | HUKS_CHALLENGE_POS_2                                                                                                                                                                                       | Added|
| ohos.security.huks            | HuksChallengePosition  | HUKS_CHALLENGE_POS_1                                                                                                                                                                                       | Added|
| ohos.security.huks            | HuksChallengePosition  | HUKS_CHALLENGE_POS_0 = 0                                                                                                                                                                                   | Added|
| ohos.security.huks            | HuksChallengeType      | HUKS_CHALLENGE_TYPE_NONE = 2                                                                                                                                                                               | Added|
| ohos.security.huks            | HuksChallengeType      | HUKS_CHALLENGE_TYPE_CUSTOM = 1                                                                                                                                                                             | Added|
| ohos.security.huks            | HuksChallengeType      | HUKS_CHALLENGE_TYPE_NORMAL = 0                                                                                                                                                                             | Added|
| ohos.security.huks            | HuksAuthAccessType     | HUKS_AUTH_ACCESS_INVALID_NEW_BIO_ENROLL = 1 \<\< 1                                                                                                                                                         | Added|
| ohos.security.huks            | HuksAuthAccessType     | HUKS_AUTH_ACCESS_INVALID_CLEAR_PASSWORD = 1 \<\< 0                                                                                                                                                         | Added|
| ohos.security.huks            | HuksUserAuthType       | HUKS_USER_AUTH_TYPE_PIN = 1 \<\< 2                                                                                                                                                                         | Added|
| ohos.security.huks            | HuksUserAuthType       | HUKS_USER_AUTH_TYPE_FACE = 1 \<\< 1                                                                                                                                                                        | Added|
| ohos.security.huks            | HuksUserAuthType       | HUKS_USER_AUTH_TYPE_FINGERPRINT = 1 \<\< 0                                                                                                                                                                 | Added|
| ohos.security.huks            | HuksErrorCode          | HUKS_ERROR_DEVICE_NO_CREDENTIAL = -44                                                                                                                                                                      | Added|
| ohos.security.huks            | HuksErrorCode          | HUKS_ERROR_KEY_AUTH_FAILED = -43                                                                                                                                                                           | Added|
| ohos.security.huks            | HuksErrorCode          | HUKS_ERROR_USER_AUTH_TYPE_NOT_SUPPORT = -42                                                                                                                                                                | Added|
| ohos.security.huks            | HuksErrorCode          | HUKS_ERROR_GET_USERIAM_AUTHINFO_FAILED = -41                                                                                                                                                               | Added|
| ohos.security.huks            | HuksErrorCode          | HUKS_ERROR_GET_USERIAM_SECINFO_FAILED = -40                                                                                                                                                                | Added|
| ohos.security.huks            | huks                   | attestKey(keyAlias: string, options: HuksOptions, callback: AsyncCallback\<HuksResult>) : void;<br>attestKey(keyAlias: string, options: HuksOptions) : Promise\<HuksResult>;            | Added|
