# JS API Changes of the ArkUI Development Framework

The table below lists the APIs changes of the ArkUI development framework in OpenHarmony 3.2 Beta3 over OpenHarmony 3.2 Beta2.

## API Changes

| Module| Class| Method/Attribute/Enumeration/Constant| Change Type|
|---|---|---|---|
| ArkUI                                                                              | WebAttribute                | onClientAuthenticationRequest(callback: (event: {handler : ClientAuthenticationHandler, host : string, port : number, keyTypes : Array\<string>, issuers : Array\<string>}) => void): WebAttribute; | Added                         |
| ArkUI                                                                              | WebAttribute                | onSslErrorEventReceive(callback: (event: { handler: SslErrorHandler, error: SslError }) => void): WebAttribute;                                 | Added|
| ArkUI                                                                              | WebAttribute                | onScroll(callback: (event: {xOffset: number, yOffset: number}) => void): WebAttribute;                                                          | Added|
| ArkUI                                                                              | WebAttribute                | onSearchResultReceive(callback: (event?: {activeMatchOrdinal: number, numberOfMatches: number, isDoneCounting: boolean}) => void): WebAttribute | Added|
| ArkUI                                                                              | WebAttribute                | mediaPlayGestureAccess(access: boolean): WebAttribute;                                                                                          | Added|
| ArkUI                                                                              | WebAttribute                | onContextMenuShow(callback: (event?: { param: WebContextMenuParam, result: WebContextMenuResult }) => boolean): WebAttribute;                   | Added|
| ArkUI                                                                              | WebAttribute                | onPermissionRequest(callback: (event?: { request: PermissionRequest }) => void): WebAttribute;                                                  | Added|
| ArkUI                                                                              | WebAttribute                | textZoomRatio(textZoomRatio: number): WebAttribute;                                                                                             | Added|
| ArkUI                                                                              | WebController               | clearClientAuthenticationCache(): void;                                                                                                         | Added|
| ArkUI                                                                              | WebController               | clearSslCache(): void;                                                                                                                          | Added|
| ArkUI                                                                              | WebController               | searchNext(forward: boolean): void;                                                                                                             | Added|
| ArkUI                                                                              | WebController               | clearMatches(): void;                                                                                                                           | Added|
| ArkUI                                                                              | WebController               | searchAllAsync(searchString: string): void;                                                                                                     | Added|
| ArkUI                                                                              | WebController               | postMessage(options: { message: WebMessageEvent, uri: string}): void;                                                                           | Added|
| ArkUI                                                                              | WebController               | createWebMessagePorts(): Array\<WebMessagePort>;                                                                                                | Added|
| ArkUI                                                                              | WebContextMenuResult        | copyImage(): void;                                                                                                                              | Added|
| ArkUI                                                                              | WebContextMenuResult        | closeContextMenu(): void;                                                                                                                       | Added|
| ArkUI                                                                              | WebContextMenuResult        | constructor();                                                                                                                                  | Added|
| ArkUI                                                                              | WebContextMenuParam         | existsImageContents(): boolean;                                                                                                                 | Added|
| ArkUI                                                                              | WebContextMenuParam         | getSourceUrl(): string;                                                                                                                         | Added|
| ArkUI                                                                              | WebContextMenuParam         | getUnfilterendLinkUrl(): string;                                                                                                                | Added|
| ArkUI                                                                              | WebContextMenuParam         | getLinkUrl(): string;                                                                                                                           | Added|
| ArkUI                                                                              | WebContextMenuParam         | y(): number;                                                                                                                                    | Added|
| ArkUI                                                                              | WebContextMenuParam         | x(): number;                                                                                                                                    | Added|
| ArkUI                                                                              | WebContextMenuParam         | constructor();                                                                                                                                  | Added|
| ArkUI                                                                              | PermissionRequest           | grant(resources: Array\<string>): void;                                                                                                         | Added|
| ArkUI                                                                              | PermissionRequest           | getAccessibleResource(): Array\<string>;                                                                                                        | Added|
| ArkUI                                                                              | PermissionRequest           | getOrigin(): string;                                                                                                                            | Added|
| ArkUI                                                                              | PermissionRequest           | deny(): void;                                                                                                                                   | Added|
| ArkUI                                                                              | PermissionRequest           | constructor();                                                                                                                                  | Added|
| ArkUI                                                                              | ProtectedResourceType       | MidiSysex = "TYPE_MIDI_SYSEX"                                                                                                                   | Added|
| ArkUI                                                                              | ClientAuthenticationHandler | ignore(): void;                                                                                                                                 | Added|
| ArkUI                                                                              | ClientAuthenticationHandler | cancel(): void;                                                                                                                                 | Added|
| ArkUI                                                                              | ClientAuthenticationHandler | confirm(priKeyFile : string, certChainFile : string): void;                                                                                     | Added|
| ArkUI                                                                              | ClientAuthenticationHandler | constructor();                                                                                                                                  | Added|
| ArkUI                                                                              | SslErrorHandler             | handleCancel(): void;                                                                                                                           | Added|
| ArkUI                                                                              | SslErrorHandler             | handleConfirm(): void;                                                                                                                          | Added|
| ArkUI                                                                              | SslErrorHandler             | constructor();                                                                                                                                  | Added|
| ArkUI                                                                              | SslError                    | Untrusted                                                                                                                                       | Added|
| ArkUI                                                                              | SslError                    | DateInvalid                                                                                                                                     | Added|
| ArkUI                                                                              | SslError                    | HostMismatch                                                                                                                                    | Added|
| ArkUI                                                                              | SslError                    | Invalid                                                                                                                                         | Added|
| ArkUI                                                                              | WebMessageEvent             | setPorts(ports: Array\<WebMessagePort>): void;                                                                                                  | Added|
| ArkUI                                                                              | WebMessageEvent             | getPorts(): Array\<WebMessagePort>;                                                                                                             | Added|
| ArkUI                                                                              | WebMessageEvent             | setData(data: string): void;                                                                                                                    | Added|
| ArkUI                                                                              | WebMessageEvent             | getData(): string;                                                                                                                              | Added|
| ArkUI                                                                              | WebMessageEvent             | constructor();                                                                                                                                  | Added|
| ArkUI                                                                              | WebMessagePort              | onMessageEvent(callback: (result: string) => void): void;                                                                                       | Added|
| ArkUI                                                                              | WebMessagePort              | postMessageEvent(message: WebMessageEvent): void;                                                                                               | Added|
| ArkUI                                                                              | WebMessagePort              | close(): void;                                                                                                                                  | Added|
| ArkUI                                                                              | WebMessagePort              | constructor();                                                                                                                                  | Added|
| ArkUI                                                                              | ColorFilter                 | constructor(value: number[]);                                                                                                                   | Added|
| ArkUI                                                                              | TextInputAttribute          | style(value: TextInputStyle): TextInputAttribute;                                                                                               | Added|
| ArkUI                                                                              | TextInputStyle              | Inline                                                                                                                                          | Added|
| ArkUI                                                                              | TextInputStyle              | Default                                                                                                                                         | Added|
| ArkUI                                                                              | TabsAttribute               | barPosition(value: BarPosition): TabsAttribute;                                                                                                 | Added|
| ArkUI                                                                              | SideBarContainerAttribute   | sideBarPosition(value: SideBarPosition): SideBarContainerAttribute;                                                                             | Added|
| ArkUI                                                                              | SideBarPosition             | End                                                                                                                                             | Added|
| ArkUI                                                                              | SideBarPosition             | Start                                                                                                                                           | Added|
| ArkUI                                                                              | WindowAnimationTarget       | readonly missionId: number;                                                                                                                     | Added|
| ArkUI                                                                              | PanelAttribute              | onHeightChange(callback: (value: number) => void): PanelAttribute;                                                                              | Added|
| ArkUI                                                                              | PanelAttribute              | backgroundMask(color: ResourceColor): PanelAttribute;                                                                                           | Added|
| ArkUI                                                                              | ListItemGroupAttribute      | divider(value: {strokeWidth: Length;color?: ResourceColor;startMargin?: Length;endMargin?: Length;} \| null,): ListItemGroupAttribute;                                                      | Added                         |
| ArkUI                                                                              | ListItemGroupInterface      | (options?: ListItemGroupOptions): ListItemGroupAttribute;                                                                                       | Added|
| ArkUI                                                                              | ListItemGroupOptions        | space?: number \| string;                                                                                                                        | Added|
| ArkUI                                                                              | ListItemGroupOptions        | footer?: CustomBuilder;                                                                                                                         | Added|
| ArkUI                                                                              | ListItemGroupOptions        | header?: CustomBuilder;                                                                                                                         | Added|
| ArkUI                                                                              | ListItemAttribute           | swipeAction(value: SwipeActionOptions): ListItemAttribute;                                                                                      | Added|
| ArkUI                                                                              | SwipeActionOptions          | edgeEffect?: SwipeEdgeEffect;                                                                                                                   | Added|
| ArkUI                                                                              | SwipeActionOptions          | end?: CustomBuilder;                                                                                                                            | Added|
| ArkUI                                                                              | SwipeActionOptions          | start?: CustomBuilder;                                                                                                                          | Added|
| ArkUI                                                                              | SwipeEdgeEffect             | None                                                                                                                                            | Added|
| ArkUI                                                                              | SwipeEdgeEffect             | Spring                                                                                                                                          | Added|
| ArkUI                                                                              | ListAttribute               | sticky(value: StickyStyle): ListAttribute;                                                                                                      | Added|
| ArkUI                                                                              | StickyStyle                 | Footer = 2                                                                                                                                      | Added|
| ArkUI                                                                              | StickyStyle                 | Header = 1                                                                                                                                      | Added|
| ArkUI                                                                              | StickyStyle                 | None = 0                                                                                                                                        | Added|
| ArkUI                                                                              | ImageAttribute              | copyOption(value: CopyOptions): ImageAttribute;                                                                                                 | Added|
| ArkUI                                                                              | ImageAttribute              | colorFilter(value: ColorFilter): ImageAttribute;                                                                                                | Added|
| ArkUI                                                                              | GutterOption                | y?: Length \| GridRowSizeOption                                                                                                                  | Added|
| ArkUI                                                                              | GutterOption                | x?: Length \| GridRowSizeOption,                                                                                                                 | Added|
| ArkUI                                                                              | FormDimension               | Dimension_2_1                                                                                                                                   | Added|
| ArkUI                                                                              | HitTestMode                 | None                                                                                                                                            | Added|
| ArkUI                                                                              | HitTestMode                 | Transparent                                                                                                                                     | Added|
| ArkUI                                                                              | HitTestMode                 | Block                                                                                                                                           | Added|
| ArkUI                                                                              | HitTestMode                 | Default                                                                                                                                         | Added|
| ArkUI                                                                              | CopyOptions                 | LocalDevice = 2                                                                                                                                 | Added|
| ArkUI                                                                              | CopyOptions                 | InApp = 1                                                                                                                                       | Added|
| ArkUI                                                                              | CopyOptions                 | None = 0                                                                                                                                        | Added|
| ArkUI                                                                              | Color                       | Transparent                                                                                                                                     | Added|
| ArkUI                                                                              | CommonMethod                | focusOnTouch(value: boolean): T;                                                                                                                | Added|
| ArkUI                                                                              | CommonMethod                | groupDefaultFocus(value: boolean): T;                                                                                                           | Added|
| ArkUI                                                                              | CommonMethod                | defaultFocus(value: boolean): T;                                                                                                                | Added|
| ArkUI                                                                              | CommonMethod                | hitTestBehavior(value: HitTestMode): T;                                                                                                         | Added|
| ArkUI                                                                              | CustomPopupOptions          | arrowOffset?: Length;                                                                                                                           | Added|
| ArkUI                                                                              | PopupOptions                | arrowOffset?: Length;                                                                                                                           | Added|
| ArkUI                                                                              | focusControl                | function requestFocus(value: string): boolean;                                                                                                  | Added|
| basic                                                                              | BusinessError               | data?: T;                                                                                                                                       | Added|
| canvaspattern                                                                      | CanvasPattern               | setTransform(transform?: Matrix2D): void;                                                                                                       | Added|
| canvaspattern                                                                      | Matrix2D                    | scaleX?: number;                                                                                                                                | Added|
| canvaspattern                                                                      | Matrix2D                    | rotateY?: number;                                                                                                                               | Added|
| canvaspattern                                                                      | Matrix2D                    | rotateX?: number;                                                                                                                               | Added|
| canvaspattern                                                                      | Matrix2D                    | scaleY?: number;                                                                                                                                | Added|
| canvaspattern                                                                      | Matrix2D                    | translateX?: number;                                                                                                                            | Added|
| canvaspattern                                                                      | Matrix2D                    | translateY?: number;                                                                                                                            | Added|
| canvaspattern                                                                      | Matrix2D                    | identity(): Matrix2D;                                                                                                                           | Added|
| canvaspattern                                                                      | Matrix2D                    | invert(): Matrix2D;                                                                                                                             | Added|
| canvaspattern                                                                      | Matrix2D                    | multiply(other?: Matrix2D): Matrix2D;                                                                                                           | Added|
| canvaspattern                                                                      | Matrix2D                    | rotate(rx?: number, ry?: number): Matrix2D;                                                                                                     | Added|
| canvaspattern                                                                      | Matrix2D                    | translate(tx?: number, ty?: number): Matrix2D;                                                                                                  | Added|
| canvaspattern                                                                      | Matrix2D                    | scale(sx?: number, sy?: number): Matrix2D;                                                                                                      | Added|
| canvaspattern                                                                      | Matrix2D                    | constructor();                                                                                                                                  | Added|
| ohos.curves                                                                        | curves                      | function responsiveSpringMotion(response?: number, dampingFraction?: number, overlapDuration?: number): ICurve;                                 | Added|
| ohos.curves                                                                        | curves                      | function springMotion(response?: number, dampingFraction?: number, overlapDuration?: number): ICurve;                                           | Added|
| ArkUI | CanvasPattern | setTransform(transform?: Matrix2D): void; | Deleted|
| ArkUI | GetterOption  | y?: Length \| GridRowSizeOption            | Deleted|
| ArkUI | GetterOption  | x?: Length \| GridRowSizeOption,           | Deleted|
| ArkUI | CopyOption    | CrossDevice = 2                           | Deleted|
| ArkUI | CopyOption    | LocalDevice = 1                           | Deleted|
| ArkUI | CopyOption    | InApp = 0                                 | Deleted|
| ArkUI      | WebAttribute | textZoomAtio(textZoomAtio: number): WebAttribute;                   | Deprecated|
| ArkUI      | CommonMethod | touchable(value: boolean): T;                                       | Deprecated|
| system.app | App          | static requestFullWindow(options?: RequestFullWindowOptions): void; | Deprecated|
