# Universal Styles

You can set universal styles for components in the **style** attribute or **.css** files. None of the style attributes are mandatory.

> **NOTE**
>
> The APIs of this module are supported since API version 8. Updates will be marked with a superscript to indicate their earliest API version.


| Name| Type| Default Value| Description|
| -------- | -------- | -------- | -------- |
| width | &lt;length&gt; \| &lt;percentage&gt; | - | Component width.<br>If this attribute is not set, the width required for the element content is used.<br>If this attribute is not set, default value **0** is used.|
| height | &lt;length&gt; \| &lt;percentage&gt; | - | Component height.<br>If this attribute is not set, the height required for the element content is used.<br>If this attribute is not set, default value **0** is used.|
| min-width | &lt;length&gt; \| &lt;percentage&gt; | 0 | Minimum component width.|
| min-height | &lt;length&gt; \| &lt;percentage&gt; | 0 | Minimum component height.|
| max-width | &lt;length&gt; \| &lt;percentage&gt; | - | Maximum component width, which has no restriction by default.|
| max-height | &lt;length&gt; \| &lt;percentage&gt; | - | Maximum component height, which has no restriction by default.|
| padding | &lt;length&gt; \| &lt;percentage&gt; | 0 | Shorthand attribute to set the padding for all sides in a declaration.<br>The attribute can have one to four values:<br>- If you set only one value, it specifies the padding for all the four sides.<br>- If you set two values, the first value specifies the top and bottom padding, and the second value specifies the left and right padding.<br>- If you set three values, the first value specifies the top padding, the second value specifies the left and right padding, and the third value specifies the bottom padding.<br>- If you set four values, they respectively specify the top, right, bottom, and left paddings (in clockwise order). |
| padding-[left\|top\|right\|bottom] | &lt;length&gt; \| &lt;percentage&gt; | 0 | Left, top, right, and bottom padding.|
| padding-[start\|end] | &lt;length&gt; \| &lt;percentage&gt; | 0 | Start and end padding.|
| margin | &lt;length&gt; \| &lt;percentage&gt; | 0 | Shorthand attribute to set the margin for all sides in a declaration. The attribute can have one to four values:<br>- If you set only one value, it specifies the margin for all the four sides.<br>- If you set two values, the first value specifies the top and bottom margins, and the second value specifies the left and right margins.<br>- If you set three values, the first value specifies the top margin, the second value specifies the left and right margins, and the third value specifies the bottom margin.<br>- If you set four values, they respectively specify the top, right, bottom, and left margins (in clockwise order).|
| margin-[left\|top\|right\|bottom] | &lt;length&gt; \| &lt;percentage&gt; | 0 | Left, top, right, and bottom margins.|
| margin-[start\|end] | &lt;length&gt; \| &lt;percentage&gt; | 0 | Start and end margins.|
| border | - | 0 | Shorthand attribute to set all borders. Set **border-width**, **border-style**, and **border-color** in sequence. Default values are used for attributes that are not set.|
| border-style | string | solid | Shorthand attribute to set the style for all borders. Available values are as follows:<br>- **dotted**: dotted border. The radius of a dot is half of **border-width**.<br>- **dashed**: dashed border.<br>- **solid**: solid border.|
| border-[left\|top\|right\|bottom]-style | string | solid | Styles of the left, top, right, and bottom borders. The available values are **dotted**, **dashed**, and **solid**.|
| border-[left\|top\|right\|bottom] | - | - | Shorthand attribute to set the borders for every side respectively. Set **border-width**, **border-style**, and **border-color** in sequence. Default values are used for attributes that are not set.|
| border-width | &lt;length&gt; | 0 | Shorthand attribute to set the width for all borders, or separately set the width for each border.|
| border-[left\|top\|right\|bottom]-width | &lt;length&gt; | 0 | Attribute to set widths of left, top, right, and bottom borders.|
| border-color | &lt;color&gt; | black | Shorthand attribute to set the color for all borders, or separately set the color for each border.|
| border-[left\|top\|right\|bottom]-color | &lt;color&gt; | black | Attribute to set colors for left, top, right, and bottom borders.|
| border-radius | &lt;length&gt; | - | Attribute to set the radius for round borders of an element. This attribute cannot be used to set the width, color, or style of a specific border. You can use **border-width**, **border-color**, or **border-style** to set the color, width, or style for all the borders at the same time. |
| border-[top\|bottom]-[left\|right]-radius | &lt;length&gt; | - | Attribute to respectively set the radii of upper-left, upper-right, lower-right, and lower-left rounded corners. |
| background | &lt;linear-gradient&gt; | - | Background. This attribute supports [gradient styles](js-service-widget-common-gradient.md) only and is not compatible with **background-color** or **background-image**.|
| background-color | &lt;color&gt; | - | Background color.|
| background-image | string | - | Background image. This attribute is not compatible with **background-color** or **background**. Local image resources are supported.<br>Example:<br>- background-image: url("/common/background.png")<br>The SVG format is not supported.|
| background-size | - string<br>- &lt;length&gt; &lt;length&gt;<br>- &lt;percentage&gt; &lt;percentage&gt; | auto | Background image size.<br>- The available values of the **string** type are as follows:<br>  - **contain**: extends the image to the maximum size so that its height and width are fully applicable to the content area.<br>  - **cover**: extends the background image to a large enough size so that it completely covers the background area. Some parts of the image may not be displayed in the background area.<br>  - **auto**: retains the original aspect ratio of the image.<br>- The two **\<length>** values are as follows: <br>The first value indicates the width, and the second value indicates the height. If you only set one value, the other value is set to **auto** by default.<br>- The two **\<percentage>** values are as follows:<br>The first value indicates the width, and the second value indicates the height. If you only set one value, the other value is set to **auto** by default. |
| background-repeat | string | repeat | How a background image is repeatedly drawn. By default, a background image is repeated both horizontally and vertically.<br>- **repeat**: The image is repeated along both the x-axis and y-axis.<br>- **repeat-x**: The image is repeated along the x-axis.<br>- **repeat-y**: The image is repeated along the y-axis.<br>- **no-repeat**: The image is not repeated.|
| background-position | - string string<br>- &lt;length&gt; &lt;length&gt;<br>- &lt;percentage&gt; &lt;percentage&gt; | 0px 0px | - Using keywords: If only one keyword is specified, the other value is **center** by default. The two values define the horizontal position and vertical position, respectively.<br>  - **left**: leftmost in the horizontal direction.<br>  - **right**: rightmost in the horizontal direction.<br>  - **top**: top in the vertical direction.<br>  - **bottom**: bottom in the vertical direction.<br>  - **center**: center in the horizontal or vertical direction.<br>- Using **\<length>**: The first value indicates the horizontal position, and the second value indicates the vertical position. For the upper left corner, the value is 0 0 in px (**0px 0px**). If only one value is specified, the other one is **50%**.<br>- Using **\<percentage>**: The first value indicates the horizontal position, and the second value indicates the vertical position. For the upper left corner, the value is 0% 0%. For the lower right corner, the value is **100% 100%**. If only one value is specified, the other one is **50%**.<br>- Using both **\<percentage>** and **\<length>**.|
| box-shadow | string | 0 | Syntax: box-shadow: h-shadow v-shadow blur spread color<br>Shadow style of the current component. The value includes the horizontal position (mandatory), vertical position (mandatory), fuzzy radius (optional, default value: **0**), extension distance (optional, default value: **0**), and color (optional, default value: **black**) of the shadow.<br>Example:<br>- box-shadow :10px 20px 5px 10px \#888888<br>- box-shadow :100px 100px 30px red<br>- box-shadow :-100px -100px 0px 40px |
| filter | string | - | Syntax: filter: blur(px)<br>Radius of the blur area within the component layout. If this style is not set, the default value **0** (no blur) is used. Percentage values are not supported.<br>Example: filter: blur(10px)|
| backdrop-filter | string | - | Syntax: backdrop-filter: blur(px)<br>Radius of the background blur area within the component layout. If this style is not set, the default value **0** (no blur) is used. Percentage values are not supported.<br>Example: backdrop-filter: blur(10px)|
| opacity | number | 1 | Opacity of an element. The value ranges from **0** to **1**. The value **1** means opaque, and **0** means completely transparent.|
| display | string | flex | Type of the box containing an element. Available values are as follows:<br>- **flex**: flexible layout<br>- **none**: not rendered|
| visibility | string | visible | Whether to display the box containing an element. The invisible box occupies layout space. (To remove the box, set the **display** attribute to **none**.) Available values are as follows:<br>- **visible**: The element is visible.<br>- **hidden**: The box is hidden but still takes up space.<br>If both **visibility** and **display** are set, only **display** takes effect.|
| flex | number \| string | - | How to divide available space of the parent component for each child component.<br>You can set one to three values for this style.<br>Set one value in either of the following ways:<br>- A unitless number to set **flex-grow**.<br>- A valid width value to set **flex-basis**.<br>Set two values in the following ways:<br>The first value must be a unitless number used to set **flex-grow**. The second value must be either of the following:<br>- A unitless number to set **flex-shrink**.<br>- A valid width value to set **flex-basis**.<br>Set three values in the following ways:<br>The first value must be a unitless number used to set **flex-grow**. The second value must be a unitless number used to set **flex-shrink**. The third value must be a valid width value used to set **flex-basis**.<br>This style is valid when the parent container is **\<div>** or **\<list-item>**.|
| flex-grow | number | 0 | How much a child component will grow. The value specifies allocation of the remaining space on the main axis of the parent component. Size of available space = Container size - Total size of all child components. Value **0** indicates that the child component does not grow.<br>This style is valid when the parent container is **\<div>** or **\<list-item>**.|
| flex-shrink | number | 1 | How much a child component will shrink. The shrink occurs only when the sum of default child component widths is greater than that of the parent component. Value **0** indicates that the child component does not shrink.<br>This style is valid when the parent container is **\<div>** or **\<list-item>**.|
| flex-basis | &lt;length&gt; | - | Initial length of the flex item on the main axis.<br>This style is valid when the parent container is **\<div>** or **\<list-item>**.|
| align-self | string | - | Alignment mode on the cross axis of the parent element. This style overwrites the align-items style of the parent element. The align-items style is used only in the div and list styles of the parent container. Available values are as follows:<br>- **stretch**: Items are stretched to the same height or width as the container along the cross axis.<br>- **flex-start**: Items are packed toward the start edge of the cross axis.<br>- **flex-end**: Items are packed toward the end edge of the cross axis.<br>- **center**: Items are packed toward the center of the cross axis.<br>- **baseline**: Items are aligned at the baseline of the cross axis.|
| position | string | relative | Positioning type of the component. Dynamic changes are not supported.<br>- **fixed**: The component is positioned related to the browser window.<br>**absolute**: The component is positioned absolutely to its parent element.<br>- **relative**: The component is positioned relative to its normal position.<br>The **absolute** attribute takes effect only when the parent component is **\<div>**.|
| [left\|top\|right\|bottom | &lt;length&gt; \| &lt;percentage&gt; | - | left\|top\|right\|bottom must be used together with **position** to determine the offset of the component.<br>- The **left** attribute specifies the left edge position of the component. This attribute defines the offset between the left edge of the margin area of a positioned component and left edge of its containing block.<br>- The **top** attribute specifies the top edge position of the component. This attribute defines the offset between the top edge of a positioned component and that of a block included in the component.<br>- The **right** attribute specifies the right edge position of the component. This attribute defines the offset between the right edge of a positioned component and that of a block included in the component.<br>- The **bottom** attribute specifies the bottom edge position of the component. This attribute defines the offset between the bottom edge of a positioned component and that of a block included in the component.|
| [start \| end] | &lt;length&gt; \| &lt;percentage&gt; | - | start \|end must be used together with **position** to determine the offset of the component.<br>- The **start** attribute specifies the start edge position of the component. This attribute defines the offset between the start edge of a positioned component and that of a block included in the component.<br>- The **end** attribute specifies the end edge position of the component. This attribute defines the offset between the end edge of a positioned component and that of a block included in the component.|
| z-index | number | - | Render sequence of child nodes under the same parent node. A child node with a larger value will be rendered later.<br>This style does not support **auto**, and other styles, such as **opacity**, do not affect the render sequence of a child node.|
| image-fill | &lt;color&gt; | - | Fill color for SVG images. The following components (and attributes) are supported: **button** (**icon** attribute) and **image** (**src** attribute).<br>The **fill** color value in the SVG image file is replaced with the value of **image-fill** during rendering, and is valid only for the fill attribute that is declared in the SVG image.|
| clip-path | [ &lt;geometry-box&gt; \|&lt;basic-shape&gt; ] \| none | - | Clip area of the component. Only the content within this area is displayed.<br>**\<geometry-box>**: applicable scope of the clip area's width and height. The default value is **border-box**. Available values are as follows:<br>- **margin-box**: The width and height includes the margin.<br>- **border-box**: The width and height includes the border.<br>- **padding-box**: The width and height includes the padding.<br>- **content-box**: The width and height does not include any margin, border, or padding.<br>**\<basic-shape>**: shape of the clip area. Available values include:<br>- **inset**, in the format of inset( &lt;percentage&gt;{1,4} [ round &lt;'border-radius'&gt; ]? )<br>- **circle**, in the format of circle( [ &lt;percentage&gt; ]? [ at &lt;percentage&gt; &lt;percentage&gt; ]? )<br>- **ellipse**, in the format of ellipse( [ &lt;percentage&gt;{2} ]? [ at &lt;percentage&gt; &lt;percentage&gt; ]? )<br>- **polygon**, in the format of polygon( [ &lt;percentage&gt; &lt;percentage&gt; ]\# )<br>- **path**, in the format of path( &lt;string&gt; )|
| mask-image | - &lt;linear-gradient&gt;<br>- string | - | Image used for the mask of the component:<br>Gradient color mask, for example, **linear-gradient(to left, black, white)**.<br>Solid color mask, for example, **linear-gradient(to right, grey , grey)**.<br>Mask filled by a local SVG image, for example, **url(common/mask.svg)**|
| mask-size | - string<br>- &lt;length&gt;&lt;length&gt;<br>- &lt;percentage&gt; &lt;percentage&gt; | auto | Display size of the mask image. The setting is valid only when **mask-image** is set to an image source.<br>The **string** values are as follows:<br>- **contain**: extends the image to the maximum size so that its height and width are fully applicable to the content area.<br>- **cover**: extends the image to a large enough size so that it completely covers the background area. Some parts of the image may not be displayed in the background area.<br>- **auto**: retains the original aspect ratio of the image.<br>The two **\<length>** values are as follows: The first value indicates the width, and the second value indicates the height. If you only set one value, the other value is set to **auto** by default.<br>The two **\<percentage>** values indicate the image size in relative to the original image size. The first value indicates the width, and the second value indicates the height. If you only set one value, the other value is set to **auto** by default. |
| mask-position | - string string<br>- &lt;length&gt; &lt;length&gt;<br>- &lt;percentage&gt; &lt;percentage&gt; | 0px 0px | Display position of the mask image. The setting is valid only when **mask-image** is set to an image source. Using keywords: If only one keyword is specified, the other value is **center** by default. The two values define the horizontal position and vertical position, respectively.<br>The **string** values are as follows:<br>- **left**: leftmost in the horizontal direction.<br>- **right**: rightmost in the horizontal direction.<br>- **top**: top in the vertical direction.<br>- **bottom**: bottom in the vertical direction.<br>- **center**: center position.<br>Using **\<length>**: The first value indicates the horizontal position, and the second value indicates the vertical position. For the upper left corner, the value is 0 0 in px (**0px 0px**). If only one value is specified, the other one is **50%**.<br>Using **\<percentage>**: The first value indicates the horizontal position, and the second value indicates the vertical position. For the upper left corner, the value is 0% 0%. For the lower right corner, the value is **100% 100%**. If only one value is specified, the other one is **50%**.<br>Using both **\<percentage>** and **\<length>**.|
