# Application Models

- Application Model Overview
  - [Elements of the Application Model](application-model-composition.md)
  - [Interpretation of the Application Model](application-model-description.md)
- Stage Model Development
  - [Stage Model Development Overview](stage-model-development-overview.md)
  - Stage Mode Application Components
    - [Application- or Component-Level Configuration](application-component-configuration-stage.md)
    - UIAbility Component
      - [UIAbility Component Overview](uiability-overview.md)
      - [UIAbility Component Lifecycle](uiability-lifecycle.md)
      - [UIAbility Component Launch Type](uiability-launch-type.md)
      - [UIAbility Component Usage](uiability-usage.md)
      - [Data Synchronization Between UIAbility and UI](uiability-data-sync-with-ui.md)
      - [Interaction Between Intra-Device UIAbility Components](uiability-intra-device-interaction.md)
    - ExtensionAbility Component
      - [ExtensionAbility Component Overview](extensionability-overview.md)
      - [ServiceExtensionAbility](serviceextensionability.md)
      - [DataShareExtensionAbility](datashareextensionability.md)
      - [FormExtensionAbility (Widget)](widget-development-stage.md)
    - [AbilityStage Component Container](abilitystage.md)
    - [Context](application-context-stage.md)
    - Want
      - [Want Overview](want-overview.md)
      - [Matching Rules of Explicit Want and Implicit Want](explicit-implicit-want-mappings.md)
      - [Common action and entities Values](actions-entities.md)
      - [Using Explicit Want to Start an Ability](ability-startup-with-explicit-want.md)
      - [Using Implicit Want to Open a Website](ability-startup-with-implicit-want.md)
      - [Using Want to Share Data Between Applications](data-share-via-want.md)
    - [Component Startup Rules](component-startup-rules.md)
    - Inter-Device Application Component Interaction (Continuation) 
      - [Continuation Overview](inter-device-interaction-hop-overview.md)
      - [Cross-Device Migration](hop-cross-device-migration.md)
      - [Multi-device Collaboration](hop-multi-device-collaboration.md)
  - IPC
    - [Process Model](process-model-stage.md)
    - Common Events
      - [Introduction to Common Events](common-event-overview.md)
      - [Subscribing to Common Events](common-event-subscription.md)
      - [Publishing Common Events](common-event-publish.md)
      - [Unsubscribing from Common Events](common-event-unsubscription.md)
    - [Background Services](background-services.md)
  - Inter-Thread Communication
    - [Thread Model](thread-model-stage.md)
    - [Using Emitter for Inter-Thread Communication](itc-with-emitter.md)
    - [Using Worker for Inter-Thread Communication](itc-with-worker.md)
  - Mission Management
    - [Mission Management Scenarios](mission-management-overview.md)
    - [Mission Management and Launch Type](mission-management-launch-type.md)
    - [Page Stack and MissionList](page-mission-stack.md)
  - [Application Configuration File](config-file-stage.md)
- FA Model Development
  - [FA Model Development Overview](fa-model-development-overview.md)
  - FA Mode Application Components
    - [Application- or Component-Level Configuration](application-component-configuration-fa.md)
    - PageAbility Component Development
      - [PageAbility Component Overview](pageability-overview.md)
      - [PageAbility Component Configuration](pageability-configuration.md)
      - [PageAbility Lifecycle](pageability-lifecycle.md)
      - [PageAbility Launch Type](pageability-launch-type.md)
      - [Creating a PageAbility](create-pageability.md)
      - [Starting a Local PageAbility](start-local-pageability.md)
      - [Stopping a PageAbility](stop-pageability.md)
      - [Starting a Remote PageAbility](start-remote-pageability.md)
      - [Starting a Specified Page](start-page.md)
      - [Window Properties](window-properties.md)
      - [Requesting Permissions](request-permissions.md)
      - [Redirection Rules](redirection-rules.md)
    - ServiceAbility Component Development
      - [ServiceAbility Component Overview](serviceability-overview.md)
      - [ServiceAbility Component Configuration](serviceability-configuration.md)
      - [ServiceAbility Lifecycle](serviceability-lifecycle.md)
      - [Creating a ServiceAbility](create-serviceability.md)
      - [Starting a ServiceAbility](start-serviceability.md)
      - [Connecting to a ServiceAbility](connect-serviceability.md)
    - DataAbility Component Development
      - [DataAbility Component Overview](dataability-overview.md)
      - [DataAbility Component Configuration](dataability-configuration.md)
      - [DataAbility Lifecycle](dataability-lifecycle.md)
      - [Creating a DataAbility](create-dataability.md)
      - [Starting a DataAbility](start-dataability.md)
      - [Accessing a DataAbility](access-dataability.md)
      - [DataAbility Permission Control](dataability-permission-control.md)
    - [Widget Development](widget-development-fa.md)
    - [Context](application-context-fa.md)
    - [Want](want-fa.md)
    - [Component Startup Rules](component-startup-rules-fa.md)
  - IPC
    - [Process Model](process-model-fa.md)
    - [Common Events](common-event-fa.md)
    - [Background Services](rpc.md)
  - Inter-Thread Communication
    - [Thread Model](thread-model-fa.md)
    - [Inter-Thread Communication](itc-fa-overview.md)
  - [Mission Management](mission-management-fa.md)
  - [Application Configuration File](config-file-fa.md)
- Development of Component Interaction Between the FA Model and Stage Model
  - [Component Interaction Between the FA Model and Stage Model](fa-stage-interaction-overview.md)
  - [Starting a UIAbility from the FA Model](start-uiability-from-fa.md)
  - [Connecting to a ServiceExtensionAbility from the FA Model](bind-serviceextensionability-from-fa.md)
  - [Accessing a DataShareExtensionAbility from the FA Model](access-datashareextensionability-from-fa.md)
  - [Starting a PageAbility from the Stage Model](start-pageability-from-stage.md)
  - [Connecting to a ServiceAbility from the Stage Model](bind-serviceability-from-stage.md)
- Switching from the FA Model to the Stage Model
  - [Model Switching Overview](model-switch-overview.md)
  - Configuration File Switching
    - [Differences in Configuration Files](configuration-file-diff.md)
    - [Switching of app and deviceConfig](app-deviceconfig-switch.md)
    - [Switching of module](module-switch.md)
  - Component Switching
    - [PageAbility Switching](pageability-switch.md)
    - [ServiceAbility Switching](serviceability-switch.md)
    - [DataAbility Switching](dataability-switch.md)
  - [Widget Switching](widget-switch.md)
  - API Switching
    - [API Switching Overview](api-switch-overview.md)
    - [Context Switching](context-switch.md)
    - [featureAbility Switching](featureability-switch.md)
    - [particleAbility Switching](particleability-switch.md)
    - [LifecycleForm Switching](lifecycleform-switch.md)
    - [LifecycleApp Switching](lifecycleapp-switch.md)
    - [LifecycleService Switching](lifecycleservice-switch.md)
    - [LifecycleData Switching](lifecycledata-switch.md)
    - [DataAbilityHelper Switching](dataabilityhelper-switch.md)
    - [mediaLibrary Switching](medialibrary-switch.md)
    - [request Switching](request-switch.md)
    - [resourceManager Switching](resourcemanager-switch.md)
    - [window Switching](window-switch.md)
    - [Storage Switching](storage-switch.md)
