# kernel

- 内核
    - 轻量系统内核
        - [内核概述](kernel-mini-overview.md)
        - 基础内核
            - [中断管理](kernel-mini-basic-interrupt.md)
            - [任务管理](kernel-mini-basic-task.md)
            - 内存管理
                - [基本概念](kernel-mini-basic-memory-basic.md)
                - [静态内存](kernel-mini-basic-memory-static.md)
                - [动态内存](kernel-mini-basic-memory-dynamic.md)
            - 内核通信机制
                - [事件](kernel-mini-basic-ipc-event.md)
                - [互斥锁](kernel-mini-basic-ipc-mutex.md)
                - [消息队列](kernel-mini-basic-ipc-queue.md)
                - [信号量](kernel-mini-basic-ipc-sem.md)
            - [时间管理](kernel-basic-mini-time.md)
            - [软件定时器](kernel-mini-basic-soft.md)
        - 扩展组件
            - [C++支持](kernel-mini-extend-support.md)
            - [CPU占用率](kernel-mini-extend-cpup.md)
            - [动态加载](kernel-mini-extend-dynamic-loading.md)
            - 文件系统
                - [FAT](kernel-mini-extend-file-fat.md)
                - [LittleFS](kernel-mini-extend-file-lit.md)
        - 内核调测
            - 内存调测
                - [内存信息统计](kernel-mini-memory-debug-mes.md)
                - [内存泄漏检测](kernel-mini-imemory-debug-det.md)
                - [踩内存检测](kernel-mini-memory-debug-cet.md)
            - [异常调测](kernel-mini-memory-exception.md)
            - [Trace调测](kernel-mini-memory-trace.md)
            - [LMS调测](kernel-mini-memory-lms.md)
        - 附录
            - [内核编码规范](kernel-mini-appx-code.md)
            - [双向链表](kernel-mini-appx-data-list.md)
            - 标准库支持
                - [CMSIS支持](kernel-mini-appx-lib-cmsis.md)
                - [POSIX支持](kernel-mini-appx-lib-posix.md)
    - 小型系统内核
        - [内核概述](kernel-small-overview.md)
        - 内核启动
            - [内核态启动](kernel-small-start-kernel.md)
            - [用户态启动](kernel-small-start-user.md)
        - 基础内核
            - [中断及异常处理](kernel-small-basic-interrupt.md)
            - 进程管理
                - [进程](kernel-small-basic-process-process.md)
                - [任务](kernel-small-basic-process-thread.md)
                - [调度器](kernel-small-basic-process-scheduler.md)
            - 内存管理
                - [堆内存管理](kernel-small-basic-memory-heap.md)
                - [物理内存管理](kernel-small-basic-memory-physical.md)
                - [虚拟内存管理](kernel-small-basic-memory-virtual.md)
                - [虚实映射](kernel-small-basic-inner-reflect.md)
            - 内核通信机制
                - [事件](kernel-small-basic-trans-event.md)
                - [信号量](kernel-small-basic-trans-semaphore.md)
                - [互斥锁](kernel-small-basic-trans-mutex.md)
                - [消息队列](kernel-small-basic-trans-queue.md)
                - [读写锁](kernel-small-basic-trans-rwlock.md)
                - [用户态快速互斥锁](kernel-small-basic-trans-user-mutex.md)
                - [信号](kernel-small-basic-trans-user-signal.md)
            - [时间管理](kernel-small-basic-time.md)
            - [软件定时器](kernel-small-basic-softtimer.md)
            - [原子操作](kernel-small-basic-atomic.md)
        - 扩展组件
            - [系统调用](kernel-small-bundles-system.md)
            - [动态加载与链接](kernel-small-bundles-linking.md)
            - [虚拟动态共享库](kernel-small-bundles-share.md)
            - [轻量级进程间通信](kernel-small-bundles-ipc.md)
            - 文件系统
                - [虚拟文件系统](kernel-small-bundles-fs-virtual.md)
                - 支持的文件系统
                    - [FAT](kernel-small-bundles-fs-support-fat.md)
                    - [JFFS2](kernel-small-bundles-fs-support-jffs2.md)
                    - [NFS](kernel-small-bundles-fs-support-nfs.md)
                    - [Ramfs](kernel-small-bundles-fs-support-ramfs.md)
                    - [Procfs](kernel-small-bundles-fs-support-procfs.md)
                - [适配新的文件系统](kernel-small-bundles-fs-new.md)
        - 调测与工具
            - Shell
                - [Shell介绍](kernel-small-debug-shell-overview.md)
                - [Shell命令开发指导](kernel-small-debug-shell-guide.md)
                - [Shell命令编程实例](kernel-small-debug-shell-build.md)
                - Shell命令使用详解
                    - 系统命令
                        - [cpup](kernel-small-debug-shell-cmd-cpup.md)
                        - [date](kernel-small-debug-shell-cmd-date.md)
                        - [dmesg](kernel-small-debug-shell-cmd-dmesg.md)
                        - [exec](kernel-small-debug-shell-cmd-exec.md)
                        - [free](kernel-small-debug-shell-cmd-free.md)
                        - [help](kernel-small-debug-shell-cmd-help.md)
                        - [hwi](kernel-small-debug-shell-cmd-hwi.md)
                        - [kill](kernel-small-debug-shell-cmd-kill.md)
                        - [log](kernel-small-debug-shell-cmd-log.md)
                        - [memcheck](kernel-small-debug-shell-cmd-memcheck.md)
                        - [oom](kernel-small-debug-shell-cmd-oom.md)
                        - [pmm](kernel-small-debug-shell-cmd-pmm.md)
                        - [reset](kernel-small-debug-shell-cmd-reset.md)
                        - [sem](kernel-small-debug-shell-cmd-sem.md)
                        - [stack](kernel-small-debug-shell-cmd-stack.md)
                        - [su](kernel-small-debug-shell-cmd-su.md)
                        - [swtmr](kernel-small-debug-shell-cmd-swtmr.md)
                        - [systeminfo](kernel-small-debug-shell-cmd-sysinfo.md)
                        - [task](kernel-small-debug-shell-cmd-task.md)
                        - [uname](kernel-small-debug-shell-cmd-uname.md)
                        - [vmm](kernel-small-debug-shell-cmd-vmm.md)
                        - [watch](kernel-small-debug-shell-cmd-watch.md)
                        - [reboot](kernel-small-debug-shell-cmd-reboot.md)
                        - [top](kernel-small-debug-shell-cmd-top.md)
                    - 文件命令
                        - [cat](kernel-small-debug-shell-file-cat.md)
                        - [cd](kernel-small-debug-shell-file-cd.md)
                        - [chgrp](kernel-small-debug-shell-file-chgrp.md)
                        - [chmod](kernel-small-debug-shell-file-chmod.md)
                        - [chown](kernel-small-debug-shell-file-chown.md)
                        - [cp](kernel-small-debug-shell-file-cp.md)
                        - [format](kernel-small-debug-shell-file-format.md)
                        - [ls](kernel-small-debug-shell-file-ls.md)
                        - [lsfd](kernel-small-debug-shell-file-lsfd.md)
                        - [mkdir](kernel-small-debug-shell-file-mkdir.md)
                        - [mount](kernel-small-debug-shell-file-mount.md)
                        - [partinfo](kernel-small-debug-shell-file-partinfo.md)
                        - [partition](kernel-small-debug-shell-file-partition.md)
                        - [pwd](kernel-small-debug-shell-file-pwd.md)
                        - [rm](kernel-small-debug-shell-file-rm.md)
                        - [rmdir](kernel-small-debug-shell-file-rmdir.md)
                        - [statfs](kernel-small-debug-shell-file-statfs.md)
                        - [sync](kernel-small-debug-shell-file-sync.md)
                        - [touch](kernel-small-debug-shell-file-touch.md)
                        - [writeproc](kernel-small-debug-shell-file-write.md)
                        - [umount](kernel-small-debug-shell-file-umount.md)
                        - [du](kernel-small-debug-shell-file-du.md)
                        - [mv](kernel-small-debug-shell-file-mv.md)
                    - 网络命令
                        - [arp](kernel-small-debug-shell-net-arp.md)
                        - [dhclient](kernel-small-debug-shell-net-dhclient.md)
                        - [ifconfig](kernel-small-debug-shell-net-ifconfig.md)
                        - [ipdebug](kernel-small-debug-shell-net-ipdebug.md)
                        - [netstat](kernel-small-debug-shell-net-netstat.md)
                        - [ntpdate](kernel-small-debug-shell-net-ntpdate.md)
                        - [ping](kernel-small-debug-shell-net-ping.md)
                        - [ping6](kernel-small-debug-shell-net-ping6.md)
                        - [telnet](kernel-small-debug-shell-net-telnet.md)
                        - [tftp](kernel-small-debug-shell-net-tftp.md)
                - [魔法键使用方法](kernel-small-debug-shell-magickey.md)
                - [用户态异常信息说明](kernel-small-debug-shell-error.md)
            - [Trace](kernel-small-debug-trace.md)
            - [Perf调测](kernel-mini-memory-perf.md)
            - [LMS调测](kernel-small-memory-lms.md)
            - 进程调测
                - [CPU占用率](kernel-small-debug-process-cpu.md)
            - 内核态内存调测
                - [内存信息统计](kernel-small-debug-memory-info.md)
                - [内存泄漏检测](kernel-small-debug-memory-leak.md)
                - [踩内存检测](kernel-small-debug-memory-corrupt.md)
            - 用户态内存调测
                - [基本概念](kernel-small-debug-user-concept.md)
                - [运行机制](kernel-small-debug-user-function.md)
                - 使用指导
                    - [接口说明](kernel-small-debug-user-guide-api.md)
                    - 使用说明
                        - [接口调用方式](kernel-small-debug-user-guide-use-api.md)
                        - [命令行参数方式](kernel-small-debug-user-guide-use-cli.md)
                - [常见问题场景](kernel-small-debug-user-faqs.md)
            - 其他内核调测手段
                - [临终遗言](kernel-small-debug-trace-other-lastwords.md)
                - [常见问题定位方法](kernel-small-debug-trace-other-faqs.md)
        - 附录
            - 基本数据结构
                - [双向链表](kernel-small-apx-dll.md)
                - [位操作](kernel-small-apx-bitwise.md)
            - [标准库](kernel-small-apx-library.md)
    - 标准系统内核
        - [Linux内核概述](kernel-standard-overview.md)
        - [开发板Patch使用指导](kernel-standard-patch.md)
        - [Linux内核编译与构建指导](kernel-standard-build.md)
        - [内核增强特性](kernel-standard-enhanced-features.md)
            - [Enhanced SWAP特性介绍](kernel-standard-mm-eswap.md)
            - [任务调度](kernel-standard-sched.md)
                - [关联线程组调度](kernel-standard-sched-rtg.md)
                - [CPU轻量级隔离](kernel-standard-sched-cpuisolation.md)
