# ConfigurationConstant

> ![icon-note.gif](public_sys-resources/icon-note.gif) **NOTE**
> The initial APIs of this module are supported since API version 8. Newly added APIs will be marked with a superscript to indicate their earliest API version.


Defines enumerated values of the configuration for the environment where the ability is running.


## Modules to Import


```js
import ConfigurationConstant from '@ohos.application.ConfigurationConstant';
```


## ConfigurationConstant.ColorMode

The value is obtained through the **ConfigurationConstant.ColorMode** API.

**Example**

```
ConfigurationConstant.ColorMode.COLOR_MODE_LIGHT
```

**System capability**: SystemCapability.Ability.AbilityBase

| Name| Value| Description|
| -------- | -------- | -------- |
| COLOR_MODE_NOT_SET | -1 | Unspecified color mode.|
| COLOR_MODE_DARK | 0 | Dark mode.|
| COLOR_MODE_LIGHT | 1 | Light mode.|
