# display_type.h


## **概述**

**所属模块:**

[Display](_display.md)


## **汇总**


### 类

  | 类 | 描述 | 
| -------- | -------- |
| [DisplayInfo](_display_info.md) | 定义显示信息结构体&nbsp;[更多...](_display_info.md) | 
| [LayerInfo](_layer_info.md) | 定义图层信息结构体&nbsp;[更多...](_layer_info.md) | 
| [LayerAlpha](_layer_alpha.md) | 定义图层Alpha信息的结构体&nbsp;[更多...](_layer_alpha.md) | 
| [BufferData](_buffer_data.md) | 定义一层的缓冲区数据，包括虚拟和物理内存地址。&nbsp;[更多...](_buffer_data.md) | 
| [LayerBuffer](_layer_buffer.md) | 图层Buffer，用于存放图层数据。&nbsp;[更多...](_layer_buffer.md) | 
| [IRect](_i_rect.md) | 定义矩形信息&nbsp;[更多...](_i_rect.md) | 
| [ISurface](_i_surface.md) | 用于存放窗口相关信息的结构体定义，提供给硬件加速使用，例如图像合成，位图搬移等操作。&nbsp;[更多...](_i_surface.md) | 
| [ILine](_i_line.md) | 线条描述结构体定义，用于硬件加速绘制直线。&nbsp;[更多...](_i_line.md) | 
| [ICircle](_i_circle.md) | 圆形描述结构体定义，用于硬件加速绘制圆形。&nbsp;[更多...](_i_circle.md) | 
| [Rectangle](_rectangle.md) | 矩形描述结构体定义，用于硬件加速绘制矩形，&nbsp;[更多...](_rectangle.md) | 
| [GfxOpt](_gfx_opt.md) | 图像硬件加速相关的操作选项结构体定义，用于图像硬件加速时的操作选项。&nbsp;[更多...](_gfx_opt.md) | 
| [PropertyObject](_property_object.md) | 定义包含名称、属性ID和值的属性对象。&nbsp;[更多...](_property_object.md) | 
| [DisplayCapability](_display_capability.md) | 定义输出性能。&nbsp;[更多...](_display_capability.md) | 
| [DisplayModeInfo](_display_mode_info.md) | 定义输出模式信息。&nbsp;[更多...](_display_mode_info.md) | 
| [AllocInfo](_alloc_info.md) | 定义关于要分配的内存的信息。&nbsp;[更多...](_alloc_info.md) | 
| [HDRCapability](_h_d_r_capability.md) | HDR属性结构体定义&nbsp;[更多...](_h_d_r_capability.md) | 
| [HDRMetaData](_h_d_r_meta_data.md) | HDR元数据结构体定义&nbsp;[更多...](_h_d_r_meta_data.md) | 
| [VerifyAllocInfo](_verify_alloc_info.md) | 用于验证内存分配信息的结构体定义&nbsp;[更多...](_verify_alloc_info.md) | 
| [PresentTimestamp](_present_timestamp.md) | 上屏时间戳结构体定义&nbsp;[更多...](_present_timestamp.md) | 
| [__attribute__](____attribute____.md) | 扩展数据句柄结构体定义&nbsp;[更多...](____attribute____.md) | 


### 宏定义

  | 宏定义 | 描述 | 
| -------- | -------- |
| **PROPERTY_NAME_LEN**&nbsp;&nbsp;&nbsp;50 | 属性名称长度 | 


### 枚举

  | 枚举 | 枚举 | 描述 | 
| -------- | -------- | -------- |
| [DispErrCode](_display.md#disperrcode)&nbsp;{&nbsp;DISPLAY_SUCCESS&nbsp;=&nbsp;0,&nbsp;DISPLAY_FAILURE&nbsp;=&nbsp;-1,&nbsp;DISPLAY_FD_ERR&nbsp;=&nbsp;-2,&nbsp;DISPLAY_PARAM_ERR&nbsp;=&nbsp;-3,&nbsp;&nbsp;&nbsp;DISPLAY_NULL_PTR&nbsp;=&nbsp;-4,&nbsp;DISPLAY_NOT_SUPPORT&nbsp;=&nbsp;-5,&nbsp;DISPLAY_NOMEM&nbsp;=&nbsp;-6,&nbsp;DISPLAY_SYS_BUSY&nbsp;=&nbsp;-7,&nbsp;&nbsp;&nbsp;DISPLAY_NOT_PERM&nbsp;=&nbsp;-8&nbsp;} | [DispErrCode](_display.md#disperrcode)&nbsp;{&nbsp;&nbsp;&nbsp;[DISPLAY_SUCCESS](_display.md#gga12a925dadef7573cd74d63d06824f9b0a188daac95e787159d50ff9546536035b)&nbsp;=&nbsp;0,&nbsp;[DISPLAY_FAILURE](_display.md#gga12a925dadef7573cd74d63d06824f9b0afdffc20c71fb142c3e7f01323a31d742)&nbsp;=&nbsp;-1,&nbsp;[DISPLAY_FD_ERR](_display.md#gga12a925dadef7573cd74d63d06824f9b0a5bdb0a826a652f51e6c82685ae08ede8)&nbsp;=&nbsp;-2,&nbsp;[DISPLAY_PARAM_ERR](_display.md#gga12a925dadef7573cd74d63d06824f9b0a330e09be303bc7056f6115830bbd2370)&nbsp;=&nbsp;-3,&nbsp;&nbsp;&nbsp;[DISPLAY_NULL_PTR](_display.md#gga12a925dadef7573cd74d63d06824f9b0a82fbcdba6c699059bc04b491c92424ac)&nbsp;=&nbsp;-4,&nbsp;[DISPLAY_NOT_SUPPORT](_display.md#gga12a925dadef7573cd74d63d06824f9b0a950a7bc41e893450315da9e73208f8c2)&nbsp;=&nbsp;-5,&nbsp;[DISPLAY_NOMEM](_display.md#gga12a925dadef7573cd74d63d06824f9b0af186ab511133fa3280c54d2c44358882)&nbsp;=&nbsp;-6,&nbsp;[DISPLAY_SYS_BUSY](_display.md#gga12a925dadef7573cd74d63d06824f9b0ac11b678fc04745ff4d91f4398b83c427)&nbsp;=&nbsp;-7,&nbsp;&nbsp;&nbsp;[DISPLAY_NOT_PERM](_display.md#gga12a925dadef7573cd74d63d06824f9b0ad133674b9f3b857a12791479aaf58cf8)&nbsp;=&nbsp;-8&nbsp;} | 返回值类型定义。&nbsp;[更多...](_display.md#disperrcode) | 
| [LayerType](_display.md#layertype)&nbsp;{&nbsp;LAYER_TYPE_GRAPHIC,&nbsp;LAYER_TYPE_OVERLAY,&nbsp;LAYER_TYPE_SDIEBAND,&nbsp;LAYER_TYPE_CURSOR,&nbsp;&nbsp;&nbsp;LAYER_TYPE_BUTT&nbsp;} | [LayerType](_display.md#layertype)&nbsp;{&nbsp;&nbsp;&nbsp;[LAYER_TYPE_GRAPHIC](_display.md#gga56943a0946e5f15e5e58054b8e7a04a4a6ef157ea82a5d4c1715b3cddcca38d6f),&nbsp;[LAYER_TYPE_OVERLAY](_display.md#gga56943a0946e5f15e5e58054b8e7a04a4ac33e449941bc0e4d039b4b5bed853a78),&nbsp;[LAYER_TYPE_SDIEBAND](_display.md#gga56943a0946e5f15e5e58054b8e7a04a4a0aef2c460a206fa00c742219d65be477),&nbsp;[LAYER_TYPE_CURSOR](_display.md#gga56943a0946e5f15e5e58054b8e7a04a4a44b3a657e6bf4f1f5709c03a94a11019),&nbsp;&nbsp;&nbsp;[LAYER_TYPE_BUTT](_display.md#gga56943a0946e5f15e5e58054b8e7a04a4acd813c5ad9a2be97c85a97d4bdf1cb57)&nbsp;} | 图层类型定义。&nbsp;[更多...](_display.md#layertype) | 
| {&nbsp;HBM_USE_CPU_READ&nbsp;=&nbsp;(1&nbsp;&lt;&lt;&nbsp;0),&nbsp;HBM_USE_CPU_WRITE&nbsp;=&nbsp;(1&nbsp;&lt;&lt;&nbsp;1),&nbsp;HBM_USE_MEM_MMZ&nbsp;=&nbsp;(1&nbsp;&lt;&lt;&nbsp;2),&nbsp;HBM_USE_MEM_DMA&nbsp;=&nbsp;(1&nbsp;&lt;&lt;&nbsp;3),&nbsp;&nbsp;&nbsp;HBM_USE_MEM_SHARE&nbsp;=&nbsp;(1&nbsp;&lt;&lt;&nbsp;4),&nbsp;HBM_USE_MEM_MMZ_CACHE&nbsp;=&nbsp;(1&nbsp;&lt;&lt;&nbsp;5),&nbsp;HBM_USE_MEM_FB&nbsp;=&nbsp;(1&nbsp;&lt;&lt;&nbsp;6),&nbsp;HBM_USE_ASSIGN_SIZE&nbsp;=&nbsp;(1&nbsp;&lt;&lt;&nbsp;7)&nbsp;} | {[HBM_USE_CPU_READ](_display.md#ggadf764cbdea00d65edcd07bb9953ad2b7a9bb139ab93fcaceac48e52bac1be53dc)&nbsp;=&nbsp;(1&nbsp;&lt;&lt;&nbsp;0),&nbsp;[HBM_USE_CPU_WRITE](_display.md#ggadf764cbdea00d65edcd07bb9953ad2b7a29217cbafbb6666fe1e8d96f3c368a4d)&nbsp;=&nbsp;(1&nbsp;&lt;&lt;&nbsp;1),&nbsp;[HBM_USE_MEM_MMZ](_display.md#ggadf764cbdea00d65edcd07bb9953ad2b7a9126b10e53b48304a5d9c351b1ace6d4)&nbsp;=&nbsp;(1&nbsp;&lt;&lt;&nbsp;2),&nbsp;[HBM_USE_MEM_DMA](_display.md#ggadf764cbdea00d65edcd07bb9953ad2b7af7d33fd75c60375bef211629ff02d8c4)&nbsp;=&nbsp;(1&nbsp;&lt;&lt;&nbsp;3),&nbsp;&nbsp;&nbsp;[HBM_USE_MEM_SHARE](_display.md#ggadf764cbdea00d65edcd07bb9953ad2b7a16042b501b66017d663c3f5bcd24a20f)&nbsp;=&nbsp;(1&nbsp;&lt;&lt;&nbsp;4),&nbsp;[HBM_USE_MEM_MMZ_CACHE](_display.md#ggadf764cbdea00d65edcd07bb9953ad2b7a553664654199ebde6733a830cbe0a369)&nbsp;=&nbsp;(1&nbsp;&lt;&lt;&nbsp;5),&nbsp;[HBM_USE_MEM_FB](_display.md#ggadf764cbdea00d65edcd07bb9953ad2b7a110b955655861ef11167e907be5f18fc)&nbsp;=&nbsp;(1&nbsp;&lt;&lt;&nbsp;6),&nbsp;[HBM_USE_ASSIGN_SIZE](_display.md#ggadf764cbdea00d65edcd07bb9953ad2b7a44d0fd6e88dbbe9e78c44cc8e5bddc22)&nbsp;=&nbsp;(1&nbsp;&lt;&lt;&nbsp;7)&nbsp;} | 缓冲区定义。[更多...](_display.md#anonymous-enum) | 
| [PixelFormat](_display.md#pixelformat)&nbsp;{&nbsp;PIXEL_FMT_CLUT8&nbsp;=&nbsp;0,&nbsp;PIXEL_FMT_CLUT1,&nbsp;PIXEL_FMT_CLUT4,&nbsp;PIXEL_FMT_RGB_565,&nbsp;&nbsp;&nbsp;PIXEL_FMT_RGBA_5658,&nbsp;PIXEL_FMT_RGBX_4444,&nbsp;PIXEL_FMT_RGBA_4444,&nbsp;PIXEL_FMT_RGB_444,&nbsp;&nbsp;&nbsp;PIXEL_FMT_RGBX_5551,&nbsp;PIXEL_FMT_RGBA_5551,&nbsp;PIXEL_FMT_RGB_555,&nbsp;PIXEL_FMT_RGBX_8888,&nbsp;&nbsp;&nbsp;PIXEL_FMT_RGBA_8888,&nbsp;PIXEL_FMT_RGB_888,&nbsp;PIXEL_FMT_BGR_565,&nbsp;PIXEL_FMT_BGRX_4444,&nbsp;&nbsp;&nbsp;PIXEL_FMT_BGRA_4444,&nbsp;PIXEL_FMT_BGRX_5551,&nbsp;PIXEL_FMT_BGRA_5551,&nbsp;PIXEL_FMT_BGRX_8888,&nbsp;&nbsp;&nbsp;PIXEL_FMT_BGRA_8888,&nbsp;PIXEL_FMT_YUV_422_I,&nbsp;PIXEL_FMT_YCBCR_422_SP,&nbsp;PIXEL_FMT_YCRCB_422_SP,&nbsp;&nbsp;&nbsp;PIXEL_FMT_YCBCR_420_SP,&nbsp;PIXEL_FMT_YCRCB_420_SP,&nbsp;PIXEL_FMT_YCBCR_422_P,&nbsp;PIXEL_FMT_YCRCB_422_P,&nbsp;&nbsp;&nbsp;PIXEL_FMT_YCBCR_420_P,&nbsp;PIXEL_FMT_YCRCB_420_P,&nbsp;PIXEL_FMT_YUYV_422_PKG,&nbsp;PIXEL_FMT_UYVY_422_PKG,&nbsp;&nbsp;&nbsp;PIXEL_FMT_YVYU_422_PKG,&nbsp;PIXEL_FMT_VYUY_422_PKG,&nbsp;PIXEL_FMT_VENDER_MASK&nbsp;=&nbsp;0X7FFF0000,&nbsp;PIXEL_FMT_BUTT&nbsp;=&nbsp;0X7FFFFFFF&nbsp;} | [PixelFormat](_display.md#pixelformat)&nbsp;{&nbsp;&nbsp;&nbsp;[PIXEL_FMT_CLUT8](_display.md#gga60883d4958a60b91661e97027a85072aabdea255b6e5f2920977f11d21445b34a)&nbsp;=&nbsp;0,&nbsp;[PIXEL_FMT_CLUT1](_display.md#gga60883d4958a60b91661e97027a85072aa5740c66a546552c0c5a4bc06850af584),&nbsp;[PIXEL_FMT_CLUT4](_display.md#gga60883d4958a60b91661e97027a85072aabde13e8f357e39981973929309bb0e0e),&nbsp;[PIXEL_FMT_RGB_565](_display.md#gga60883d4958a60b91661e97027a85072aa5fae320872be3ffdda0d371cec048ec6),&nbsp;&nbsp;&nbsp;[PIXEL_FMT_RGBA_5658](_display.md#gga60883d4958a60b91661e97027a85072aa4c16147153b63d7ba71b257111afdd62),&nbsp;[PIXEL_FMT_RGBX_4444](_display.md#gga60883d4958a60b91661e97027a85072aaa479ac0d983fde9b4f7f0e1a3b3e230f),&nbsp;[PIXEL_FMT_RGBA_4444](_display.md#gga60883d4958a60b91661e97027a85072aacbb91256e8c45a51410a9f6caae2d04c),&nbsp;[PIXEL_FMT_RGB_444](_display.md#gga60883d4958a60b91661e97027a85072aa7d18a83da06902c104208031ed487942),&nbsp;&nbsp;&nbsp;[PIXEL_FMT_RGBX_5551](_display.md#gga60883d4958a60b91661e97027a85072aa85e5dd1a0e547c0031baffd02abb31a0),&nbsp;[PIXEL_FMT_RGBA_5551](_display.md#gga60883d4958a60b91661e97027a85072aadc1387526a271d8c6db7729de06474b1),&nbsp;[PIXEL_FMT_RGB_555](_display.md#gga60883d4958a60b91661e97027a85072aa720a429fa57133f6e27ef8c8fa1c404a),&nbsp;[PIXEL_FMT_RGBX_8888](_display.md#gga60883d4958a60b91661e97027a85072aa24a7181b7fb4019e7c19739bd9b65ff0),&nbsp;&nbsp;&nbsp;[PIXEL_FMT_RGBA_8888](_display.md#gga60883d4958a60b91661e97027a85072aa90b462672221691ed66cacb07dd2e05f),&nbsp;[PIXEL_FMT_RGB_888](_display.md#gga60883d4958a60b91661e97027a85072aa7ff77397bf2cf52b4614a46264f8ce01),&nbsp;[PIXEL_FMT_BGR_565](_display.md#gga60883d4958a60b91661e97027a85072aaec581b908c291e2bd0155e25169f9629),&nbsp;[PIXEL_FMT_BGRX_4444](_display.md#gga60883d4958a60b91661e97027a85072aa6b5a7b35e00fc25146de0c9bf88b0230),&nbsp;&nbsp;&nbsp;[PIXEL_FMT_BGRA_4444](_display.md#gga60883d4958a60b91661e97027a85072aa2f3d4ada099b2e8d84ec4501fbc8bed9),&nbsp;[PIXEL_FMT_BGRX_5551](_display.md#gga60883d4958a60b91661e97027a85072aaaf1a20dc0a597258cfe6aca806a8e0de),&nbsp;[PIXEL_FMT_BGRA_5551](_display.md#gga60883d4958a60b91661e97027a85072aa2319d4a75dae0b56776fa63d525e308b),&nbsp;[PIXEL_FMT_BGRX_8888](_display.md#gga60883d4958a60b91661e97027a85072aa1b19279f89c8cfb60e7d77ce23cd5f43),&nbsp;&nbsp;&nbsp;[PIXEL_FMT_BGRA_8888](_display.md#gga60883d4958a60b91661e97027a85072aaeb31c670120a1fbc96a0e0887997fe16),&nbsp;[PIXEL_FMT_YUV_422_I](_display.md#gga60883d4958a60b91661e97027a85072aac73c2a84907a53ed95a329007b5c8992),&nbsp;[PIXEL_FMT_YCBCR_422_SP](_display.md#gga60883d4958a60b91661e97027a85072aabdf1224848278508479ce97f637dd711),&nbsp;[PIXEL_FMT_YCRCB_422_SP](_display.md#gga60883d4958a60b91661e97027a85072aa8bf97d66e26b3aad7c83dfa70e2bc451),&nbsp;&nbsp;&nbsp;[PIXEL_FMT_YCBCR_420_SP](_display.md#gga60883d4958a60b91661e97027a85072aa0d1db50eb492f9073abdd2d662c56396),&nbsp;[PIXEL_FMT_YCRCB_420_SP](_display.md#gga60883d4958a60b91661e97027a85072aa1fa43c8a197d5c974a35b8bf02ab386e),&nbsp;[PIXEL_FMT_YCBCR_422_P](_display.md#gga60883d4958a60b91661e97027a85072aaa2fe085e63428ea76e1d975175001dc6),&nbsp;[PIXEL_FMT_YCRCB_422_P](_display.md#gga60883d4958a60b91661e97027a85072aab04eb6e1d940e42f3b4cc20c0a44c4ee),&nbsp;&nbsp;&nbsp;[PIXEL_FMT_YCBCR_420_P](_display.md#gga60883d4958a60b91661e97027a85072aa3d80e785bed28e2b3f5c7df563500962),&nbsp;[PIXEL_FMT_YCRCB_420_P](_display.md#gga60883d4958a60b91661e97027a85072aa3dc5a0a5ad2f21218b446c477277210a),&nbsp;[PIXEL_FMT_YUYV_422_PKG](_display.md#gga60883d4958a60b91661e97027a85072aa3980def5b133584bdb2982a71f07798e),&nbsp;[PIXEL_FMT_UYVY_422_PKG](_display.md#gga60883d4958a60b91661e97027a85072aadfd69bd5b421aad5bdd39d5f33317197),&nbsp;&nbsp;&nbsp;[PIXEL_FMT_YVYU_422_PKG](_display.md#gga60883d4958a60b91661e97027a85072aaf851031c336e8d9f57c940c5f52381f4),&nbsp;[PIXEL_FMT_VYUY_422_PKG](_display.md#gga60883d4958a60b91661e97027a85072aa317a761939335025379d382074a1541c),&nbsp;[PIXEL_FMT_VENDER_MASK](_display.md#gga60883d4958a60b91661e97027a85072aa67668ea067a31a8479aece94094bc547)&nbsp;=&nbsp;0X7FFF0000,&nbsp;[PIXEL_FMT_BUTT](_display.md#gga60883d4958a60b91661e97027a85072aa07086bb3356c9c88959eee00c0982684)&nbsp;=&nbsp;0X7FFFFFFF&nbsp;} | 像素格式类型定义。&nbsp;[更多...](_display.md#pixelformat) | 
| [TransformType](_display.md#transformtype)&nbsp;{&nbsp;ROTATE_NONE&nbsp;=&nbsp;0,&nbsp;ROTATE_90,&nbsp;ROTATE_180,&nbsp;ROTATE_270,&nbsp;&nbsp;&nbsp;ROTATE_BUTT&nbsp;} | [TransformType](_display.md#transformtype)&nbsp;{&nbsp;&nbsp;&nbsp;[ROTATE_NONE](_display.md#ggaa65f3b21a9a92ff022e435a7304126d2a68e349e9d45a8eba440e2a7a3ba31ec9)&nbsp;=&nbsp;0,&nbsp;[ROTATE_90](_display.md#ggaa65f3b21a9a92ff022e435a7304126d2a685062467b0c1a3164556335b467c886),&nbsp;[ROTATE_180](_display.md#ggaa65f3b21a9a92ff022e435a7304126d2a186263164422bb8f0eb5f7b7d195a3d1),&nbsp;[ROTATE_270](_display.md#ggaa65f3b21a9a92ff022e435a7304126d2a554e734d2a23790b248c5ce39816c18f),&nbsp;&nbsp;&nbsp;[ROTATE_BUTT](_display.md#ggaa65f3b21a9a92ff022e435a7304126d2a9b6ff871536aeef2a8e3ce4a753988ed)&nbsp;} | 图层变换类型定义。&nbsp;[更多...](_display.md#transformtype) | 
| [BlendType](_display.md#blendtype)&nbsp;{&nbsp;BLEND_NONE&nbsp;=&nbsp;0,&nbsp;BLEND_CLEAR,&nbsp;BLEND_SRC,&nbsp;BLEND_SRCOVER,&nbsp;&nbsp;&nbsp;BLEND_DSTOVER,&nbsp;BLEND_SRCIN,&nbsp;BLEND_DSTIN,&nbsp;BLEND_SRCOUT,&nbsp;&nbsp;&nbsp;BLEND_DSTOUT,&nbsp;BLEND_SRCATOP,&nbsp;BLEND_DSTATOP,&nbsp;BLEND_ADD,&nbsp;&nbsp;&nbsp;BLEND_XOR,&nbsp;BLEND_DST,&nbsp;BLEND_AKS,&nbsp;BLEND_AKD,&nbsp;&nbsp;&nbsp;BLEND_BUTT&nbsp;} | [BlendType](_display.md#blendtype)&nbsp;{&nbsp;&nbsp;&nbsp;[BLEND_NONE](_display.md#ggaab1839ed4aab1030dfda801a51e68817ae410edb34509ca21425fe5872bbc7e2f)&nbsp;=&nbsp;0,&nbsp;[BLEND_CLEAR](_display.md#ggaab1839ed4aab1030dfda801a51e68817a6330cee419fbdafc0b25f0aa068814e5),&nbsp;[BLEND_SRC](_display.md#ggaab1839ed4aab1030dfda801a51e68817af01da0c255cdbf67d0774a67c2d221b5),&nbsp;[BLEND_SRCOVER](_display.md#ggaab1839ed4aab1030dfda801a51e68817ad4c0cd02aa4b5f4849e2b29a26481dde),&nbsp;&nbsp;&nbsp;[BLEND_DSTOVER](_display.md#ggaab1839ed4aab1030dfda801a51e68817a21f03e8d04a58ed0684b39eb84bdb89f),&nbsp;[BLEND_SRCIN](_display.md#ggaab1839ed4aab1030dfda801a51e68817a74e681f6c9027bb2cf0bda3b72d2dd9e),&nbsp;[BLEND_DSTIN](_display.md#ggaab1839ed4aab1030dfda801a51e68817a19f528828d75c34e18375219f113d9bb),&nbsp;[BLEND_SRCOUT](_display.md#ggaab1839ed4aab1030dfda801a51e68817a404e05a118462520e878c23f89808199),&nbsp;&nbsp;&nbsp;[BLEND_DSTOUT](_display.md#ggaab1839ed4aab1030dfda801a51e68817ac0dc902b4928413d367376e4c842d909),&nbsp;[BLEND_SRCATOP](_display.md#ggaab1839ed4aab1030dfda801a51e68817ada473c7e3bf2b1102349489416aefefc),&nbsp;[BLEND_DSTATOP](_display.md#ggaab1839ed4aab1030dfda801a51e68817a0129b4506a06b1a6df297bcf685f5f89),&nbsp;[BLEND_ADD](_display.md#ggaab1839ed4aab1030dfda801a51e68817adbdb329830e5b4d9fa2b17d5d6d7894f),&nbsp;&nbsp;&nbsp;[BLEND_XOR](_display.md#ggaab1839ed4aab1030dfda801a51e68817a167c3b256e051244066d8e53cdd5529d),&nbsp;[BLEND_DST](_display.md#ggaab1839ed4aab1030dfda801a51e68817a4686a5f30c73982d625a05db021e9b15),&nbsp;[BLEND_AKS](_display.md#ggaab1839ed4aab1030dfda801a51e68817ae549aa3794365df8965a2c3853c8da99),&nbsp;[BLEND_AKD](_display.md#ggaab1839ed4aab1030dfda801a51e68817a3cc39f12fa8bceba626a33c2d82a8bf7),&nbsp;&nbsp;&nbsp;[BLEND_BUTT](_display.md#ggaab1839ed4aab1030dfda801a51e68817ad0650812ac2aa9eee228f48ac514b44a)&nbsp;} | 显示内存类型定义。&nbsp;[更多...](_display.md#blendtype) | 
| [RopType](_display.md#roptype)&nbsp;{&nbsp;ROP_BLACK&nbsp;=&nbsp;0,&nbsp;ROP_NOTMERGEPEN,&nbsp;ROP_MASKNOTPEN,&nbsp;ROP_NOTCOPYPEN,&nbsp;&nbsp;&nbsp;ROP_MASKPENNOT,&nbsp;ROP_NOT,&nbsp;ROP_XORPEN,&nbsp;ROP_NOTMASKPEN,&nbsp;&nbsp;&nbsp;ROP_MASKPEN,&nbsp;ROP_NOTXORPEN,&nbsp;ROP_NOP,&nbsp;ROP_MERGENOTPEN,&nbsp;&nbsp;&nbsp;ROP_COPYPE,&nbsp;ROP_MERGEPENNOT,&nbsp;ROP_MERGEPEN,&nbsp;ROP_WHITE,&nbsp;&nbsp;&nbsp;ROP_BUTT&nbsp;} | [RopType](_display.md#roptype)&nbsp;{&nbsp;&nbsp;&nbsp;[ROP_BLACK](_display.md#gga24265f7618fbdba53d3da4806d3097c4a6358a786ec3b81000a07b343424cee0d)&nbsp;=&nbsp;0,&nbsp;[ROP_NOTMERGEPEN](_display.md#gga24265f7618fbdba53d3da4806d3097c4a96c89f7b89a9048d355b4dc467224f4c),&nbsp;[ROP_MASKNOTPEN](_display.md#gga24265f7618fbdba53d3da4806d3097c4a54d054ea6920cb88f374f70e8d41f934),&nbsp;[ROP_NOTCOPYPEN](_display.md#gga24265f7618fbdba53d3da4806d3097c4af4a5d5dc0f15249001cff7ef32fadef1),&nbsp;&nbsp;&nbsp;[ROP_MASKPENNOT](_display.md#gga24265f7618fbdba53d3da4806d3097c4ad777eea18ba9f4e071b00aa060db00e3),&nbsp;[ROP_NOT](_display.md#gga24265f7618fbdba53d3da4806d3097c4afa63c8e2a6a39d50954cb6316576b4e9),&nbsp;[ROP_XORPEN](_display.md#gga24265f7618fbdba53d3da4806d3097c4a79433776e85bb80ad0306ced0b82947c),&nbsp;[ROP_NOTMASKPEN](_display.md#gga24265f7618fbdba53d3da4806d3097c4ad6c4d2458a9caaa079a3e5907d636e8a),&nbsp;&nbsp;&nbsp;[ROP_MASKPEN](_display.md#gga24265f7618fbdba53d3da4806d3097c4a2a069e2105c5b8d4dac5d174c76eb9d4),&nbsp;[ROP_NOTXORPEN](_display.md#gga24265f7618fbdba53d3da4806d3097c4a33c37c5ce718e876f43141dc5a028375),&nbsp;[ROP_NOP](_display.md#gga24265f7618fbdba53d3da4806d3097c4a2acacab882af44bba09878bd58e18695),&nbsp;[ROP_MERGENOTPEN](_display.md#gga24265f7618fbdba53d3da4806d3097c4afaea3c47612082914332b78ca8c331b3),&nbsp;&nbsp;&nbsp;[ROP_COPYPE](_display.md#gga24265f7618fbdba53d3da4806d3097c4a91bae697f9dea25ac4d7be011958a45d),&nbsp;[ROP_MERGEPENNOT](_display.md#gga24265f7618fbdba53d3da4806d3097c4a3580b77320e4829da046b8739c61d6b8),&nbsp;[ROP_MERGEPEN](_display.md#gga24265f7618fbdba53d3da4806d3097c4a8195ac0d37e0d69b2cd71dd7362d3fd3),&nbsp;[ROP_WHITE](_display.md#gga24265f7618fbdba53d3da4806d3097c4a533a614b27da8a81b67ada085b018618),&nbsp;&nbsp;&nbsp;[ROP_BUTT](_display.md#gga24265f7618fbdba53d3da4806d3097c4aa858b07e214a7f62625e24776806c74b)&nbsp;} | 硬件加速支持的ROP操作类型。&nbsp;[更多...](_display.md#roptype) | 
| [ColorKey](_display.md#colorkey)&nbsp;{&nbsp;CKEY_NONE&nbsp;=&nbsp;0,&nbsp;CKEY_SRC,&nbsp;CKEY_DST,&nbsp;CKEY_BUTT&nbsp;} | [ColorKey](_display.md#colorkey)&nbsp;{&nbsp;[CKEY_NONE](_display.md#gga4fe6fb05c7ba0048b1739d88f4d4878ea629b31de258db2ce01cb757b85bd5273)&nbsp;=&nbsp;0,&nbsp;[CKEY_SRC](_display.md#gga4fe6fb05c7ba0048b1739d88f4d4878ea5e3271e73dce39d0806ff8e9cba011bc),&nbsp;[CKEY_DST](_display.md#gga4fe6fb05c7ba0048b1739d88f4d4878ea6921c2c202aa69293467baa6c33fae05),&nbsp;[CKEY_BUTT](_display.md#gga4fe6fb05c7ba0048b1739d88f4d4878ea32cedc8986de2c290bf2ec193d88cabf)&nbsp;} | Color&nbsp;key操作类型定义，即硬件加速支持的Color&nbsp;key操作类型。&nbsp;[更多...](_display.md#colorkey) | 
| [MirrorType](_display.md#mirrortype)&nbsp;{&nbsp;MIRROR_NONE&nbsp;=&nbsp;0,&nbsp;MIRROR_LR,&nbsp;MIRROR_TB,&nbsp;MIRROR_BUTT&nbsp;} | [MirrorType](_display.md#mirrortype)&nbsp;{&nbsp;[MIRROR_NONE](_display.md#gga08d32376574b541d162d8534adb78fd0a5ad82fcc8af04f92571e185b61eeb309)&nbsp;=&nbsp;0,&nbsp;[MIRROR_LR](_display.md#gga08d32376574b541d162d8534adb78fd0ae35099d9fd28c2974661bcce36a9ea5c),&nbsp;[MIRROR_TB](_display.md#gga08d32376574b541d162d8534adb78fd0afd82e59546a645fd29bc779c50bfa733),&nbsp;[MIRROR_BUTT](_display.md#gga08d32376574b541d162d8534adb78fd0ad9e357a2c2f7dc0e3ca5a351ec457410)&nbsp;} | 硬件加速支持的镜像操作类型定义&nbsp;[更多...](_display.md#mirrortype) | 
| [Connection](_display.md#connection)&nbsp;{&nbsp;CON_INVALID&nbsp;=&nbsp;0,&nbsp;CONNECTED,&nbsp;DISCONNECTED&nbsp;} | [Connection](_display.md#connection)&nbsp;{&nbsp;[CON_INVALID](_display.md#ggab0845c0c8d309ee865c78b095b00e671ab5c8a92e6af2e63e769dd8f711564760)&nbsp;=&nbsp;0,&nbsp;[CONNECTED](_display.md#ggab0845c0c8d309ee865c78b095b00e671a7a691a2430ec26878897b5fbc9c22a4c),&nbsp;[DISCONNECTED](_display.md#ggab0845c0c8d309ee865c78b095b00e671acdaad1112073e3e2ea032424c38c34e1)&nbsp;} | 热插拔连接类型定义&nbsp;[更多...](_display.md#connection) | 
| [InterfaceType](_display.md#interfacetype)&nbsp;{&nbsp;DISP_INTF_HDMI&nbsp;=&nbsp;0,&nbsp;DISP_INTF_LCD,&nbsp;DISP_INTF_BT1120,&nbsp;DISP_INTF_BT656,&nbsp;&nbsp;&nbsp;DISP_INTF_YPBPR,&nbsp;DISP_INTF_RGB,&nbsp;DISP_INTF_CVBS,&nbsp;DISP_INTF_SVIDEO,&nbsp;&nbsp;&nbsp;DISP_INTF_VGA,&nbsp;DISP_INTF_MIPI,&nbsp;DISP_INTF_PANEL,&nbsp;DISP_INTF_BUTT&nbsp;} | [InterfaceType](_display.md#interfacetype)&nbsp;{&nbsp;&nbsp;&nbsp;[DISP_INTF_HDMI](_display.md#ggaf1ef2c97e255bd7f21d3b7614b283d9da717f9ae7960ba280c6c6b8822c6d8b66)&nbsp;=&nbsp;0,&nbsp;[DISP_INTF_LCD](_display.md#ggaf1ef2c97e255bd7f21d3b7614b283d9da210dbbea7e5c30b693515bba570474d4),&nbsp;[DISP_INTF_BT1120](_display.md#ggaf1ef2c97e255bd7f21d3b7614b283d9da89a4e456ceffa55cb93b2c6f4792c96b),&nbsp;[DISP_INTF_BT656](_display.md#ggaf1ef2c97e255bd7f21d3b7614b283d9daf23a0b7607d3fdc7eac791d62c5f9cd5),&nbsp;&nbsp;&nbsp;[DISP_INTF_YPBPR](_display.md#ggaf1ef2c97e255bd7f21d3b7614b283d9da54a83297ab61376574854e804a6158e1),&nbsp;[DISP_INTF_RGB](_display.md#ggaf1ef2c97e255bd7f21d3b7614b283d9da83ef625db890ee1ddb4e874d6155405f),&nbsp;[DISP_INTF_CVBS](_display.md#ggaf1ef2c97e255bd7f21d3b7614b283d9dabf3991ede75cb3bb454372174d63ec29),&nbsp;[DISP_INTF_SVIDEO](_display.md#ggaf1ef2c97e255bd7f21d3b7614b283d9daad740e6f901f40965d2824415fcb9041),&nbsp;&nbsp;&nbsp;[DISP_INTF_VGA](_display.md#ggaf1ef2c97e255bd7f21d3b7614b283d9da5db1f365e675d992f47ce797339beff5),&nbsp;[DISP_INTF_MIPI](_display.md#ggaf1ef2c97e255bd7f21d3b7614b283d9da5b9c7382dfdcc029e467c6339bf90915),&nbsp;[DISP_INTF_PANEL](_display.md#ggaf1ef2c97e255bd7f21d3b7614b283d9da4d64c32b687840c7e08e28a2892ac222),&nbsp;[DISP_INTF_BUTT](_display.md#p106611424171011)&nbsp;} | 枚举接口类型。&nbsp;[更多...](_display.md#interfacetype) | 
| [DispPowerStatus](_display.md#disppowerstatus)&nbsp;{&nbsp;POWER_STATUS_ON,&nbsp;POWER_STATUS_STANDBY,&nbsp;POWER_STATUS_SUSPEND,&nbsp;POWER_STATUS_OFF,&nbsp;&nbsp;&nbsp;POWER_STATUS_BUTT&nbsp;} | [DispPowerStatus](_display.md#disppowerstatus)&nbsp;{&nbsp;&nbsp;&nbsp;[POWER_STATUS_ON](_display.md#gga0f3c8af6e9d40730b0d2e0fbbf8e627da89e258c21283c662af2145bd3f9fc9a0),&nbsp;[POWER_STATUS_STANDBY](_display.md#gga0f3c8af6e9d40730b0d2e0fbbf8e627da604748a7de21aa992c1f72c252fc77a7),&nbsp;[POWER_STATUS_SUSPEND](_display.md#gga0f3c8af6e9d40730b0d2e0fbbf8e627da5605db047fd50c64fa0a13d8e558d479),&nbsp;[POWER_STATUS_OFF](_display.md#gga0f3c8af6e9d40730b0d2e0fbbf8e627daddd660122faa920f2adcd81e83d22c85),&nbsp;&nbsp;&nbsp;[POWER_STATUS_BUTT](_display.md#gga0f3c8af6e9d40730b0d2e0fbbf8e627dad1f590a00c02d7335bfc24edbea92037)&nbsp;} | 枚举显示状态&nbsp;[更多...](_display.md#disppowerstatus) | 
| [CompositionType](_display.md#compositiontype)&nbsp;{&nbsp;COMPOSITION_CLIENT,&nbsp;COMPOSITION_DEVICE,&nbsp;COMPOSITION_CURSOR,&nbsp;COMPOSITION_VIDEO,&nbsp;&nbsp;&nbsp;COMPOSITION_DEVICE_CLEAR,&nbsp;COMPOSITION_CLIENT_CLEAR,&nbsp;COMPOSITION_TUNNEL,&nbsp;COMPOSITION_BUTT&nbsp;} | [CompositionType](_display.md#compositiontype)&nbsp;{&nbsp;&nbsp;&nbsp;[COMPOSITION_CLIENT](_display.md#ggae5d7b642670cf3dc6654131dfa115fe5afc7ab4757f19ed87ea6d1603478edbe8),&nbsp;[COMPOSITION_DEVICE](_display.md#ggae5d7b642670cf3dc6654131dfa115fe5aa51390e0da602171f2d042a94c6b75bf),&nbsp;[COMPOSITION_CURSOR](_display.md#ggae5d7b642670cf3dc6654131dfa115fe5a663feec453d4509980f3bb34f641303b),&nbsp;[COMPOSITION_VIDEO](_display.md#ggae5d7b642670cf3dc6654131dfa115fe5a89ea30239d366a6968c7dff429a99aa9),&nbsp;&nbsp;&nbsp;[COMPOSITION_DEVICE_CLEAR](_display.md#ggae5d7b642670cf3dc6654131dfa115fe5a05f5ab2a5da295c0fdc7e19e9a121f3e),&nbsp;[COMPOSITION_CLIENT_CLEAR](_display.md#ggae5d7b642670cf3dc6654131dfa115fe5a7c1535ef8d388f878fae7c722d69855e),&nbsp;[COMPOSITION_TUNNEL](_display.md#ggae5d7b642670cf3dc6654131dfa115fe5a400576aea4b15e011ddd21748d16f9ca),&nbsp;[COMPOSITION_BUTT](_display.md#p488974221219)&nbsp;} | 枚举特殊层的组合类型。&nbsp;[更多...](_display.md#compositiontype) | 
| [ColorGamut](_display.md#colorgamut)&nbsp;{&nbsp;COLOR_GAMUT_INVALID&nbsp;=&nbsp;-1,&nbsp;COLOR_GAMUT_NATIVE&nbsp;=&nbsp;0,&nbsp;COLOR_GAMUT_SATNDARD_BT601&nbsp;=&nbsp;1,&nbsp;COLOR_GAMUT_STANDARD_BT709&nbsp;=&nbsp;2,&nbsp;&nbsp;&nbsp;COLOR_GAMUT_DCI_P3&nbsp;=&nbsp;3,&nbsp;COLOR_GAMUT_SRGB&nbsp;=&nbsp;4,&nbsp;COLOR_GAMUT_ADOBE_RGB&nbsp;=&nbsp;5,&nbsp;COLOR_GAMUT_DISPLAY_P3&nbsp;=&nbsp;6,&nbsp;&nbsp;&nbsp;COLOR_GAMUT_BT2020&nbsp;=&nbsp;7,&nbsp;COLOR_GAMUT_BT2100_PQ&nbsp;=&nbsp;8,&nbsp;COLOR_GAMUT_BT2100_HLG&nbsp;=&nbsp;9,&nbsp;COLOR_GAMUT_DISPLAY_BT2020&nbsp;=&nbsp;10&nbsp;} | [ColorGamut](_display.md#colorgamut)&nbsp;{&nbsp;&nbsp;&nbsp;[COLOR_GAMUT_INVALID](_display.md#gga7e865f6dbae09a004be2949b473fd7c3a7d7d95bebc0ddb4d10da05b449bab1bf)&nbsp;=&nbsp;-1,&nbsp;[COLOR_GAMUT_NATIVE](_display.md#gga7e865f6dbae09a004be2949b473fd7c3af0e1dba48215d4d19bd9a3536a736cdb)&nbsp;=&nbsp;0,&nbsp;[COLOR_GAMUT_SATNDARD_BT601](_display.md#gga7e865f6dbae09a004be2949b473fd7c3affa91ab208128bec9b981e7020bcbfa9)&nbsp;=&nbsp;1,&nbsp;[COLOR_GAMUT_STANDARD_BT709](_display.md#gga7e865f6dbae09a004be2949b473fd7c3a248480b6ae7ad6c5327dd7cb5cfd0a85)&nbsp;=&nbsp;2,&nbsp;&nbsp;&nbsp;[COLOR_GAMUT_DCI_P3](_display.md#gga7e865f6dbae09a004be2949b473fd7c3a98eb540d5a93ab3ad4256907eec89c4e)&nbsp;=&nbsp;3,&nbsp;[COLOR_GAMUT_SRGB](_display.md#gga7e865f6dbae09a004be2949b473fd7c3a8327e3fc0a79c9935dd9279c10c841c5)&nbsp;=&nbsp;4,&nbsp;[COLOR_GAMUT_ADOBE_RGB](_display.md#gga7e865f6dbae09a004be2949b473fd7c3a3377a7df82b495c65f3f7ab2b1655100)&nbsp;=&nbsp;5,&nbsp;[COLOR_GAMUT_DISPLAY_P3](_display.md#gga7e865f6dbae09a004be2949b473fd7c3ad79cdc9f86f3b581453c523a03a876d3)&nbsp;=&nbsp;6,&nbsp;&nbsp;&nbsp;[COLOR_GAMUT_BT2020](_display.md#gga7e865f6dbae09a004be2949b473fd7c3a79ff774719c5b83287b298d39ee274f3)&nbsp;=&nbsp;7,&nbsp;[COLOR_GAMUT_BT2100_PQ](_display.md#gga7e865f6dbae09a004be2949b473fd7c3aa8191f5fca2ad767fa56767b41f4dec5)&nbsp;=&nbsp;8,&nbsp;[COLOR_GAMUT_BT2100_HLG](_display.md#gga7e865f6dbae09a004be2949b473fd7c3ad4f624c7b578dacaa732cd9556724797)&nbsp;=&nbsp;9,&nbsp;[COLOR_GAMUT_DISPLAY_BT2020](_display.md#gga7e865f6dbae09a004be2949b473fd7c3a5d07e2f0d8e570c5e16ccff05e12cb29)&nbsp;=&nbsp;10&nbsp;} | 色域类型枚举值&nbsp;[更多...](_display.md#colorgamut) | 
| [GamutMap](_display.md#gamutmap)&nbsp;{&nbsp;GAMUT_MAP_CONSTANT&nbsp;=&nbsp;0,&nbsp;GAMUT_MAP_EXPANSION&nbsp;=&nbsp;1,&nbsp;GAMUT_MAP_HDR_CONSTANT&nbsp;=&nbsp;2,&nbsp;GAMUT_MAP_HDR_EXPANSION&nbsp;=&nbsp;3&nbsp;} | [GamutMap](_display.md#gamutmap)&nbsp;{&nbsp;[GAMUT_MAP_CONSTANT](_display.md#gga5700b58f1bc340e309a0962101ad7fa4acdf75e246ac2f53f37ef9e11b5561535)&nbsp;=&nbsp;0,&nbsp;[GAMUT_MAP_EXPANSION](_display.md#gga5700b58f1bc340e309a0962101ad7fa4af3824abcccbd8d85d28e34149e9aaa33)&nbsp;=&nbsp;1,&nbsp;[GAMUT_MAP_HDR_CONSTANT](_display.md#gga5700b58f1bc340e309a0962101ad7fa4afd4e1cb10b8032108ab070925b73e270)&nbsp;=&nbsp;2,&nbsp;[GAMUT_MAP_HDR_EXPANSION](_display.md#gga5700b58f1bc340e309a0962101ad7fa4ad0f9722a0efd51910ac5f2f63fd86a10)&nbsp;=&nbsp;3&nbsp;} | 枚举色域的映射类型&nbsp;[更多...](_display.md#gamutmap) | 
| [ColorDataSpace](_display.md#colordataspace)&nbsp;{&nbsp;&nbsp;&nbsp;COLOR_DATA_SPACE_UNKNOWN&nbsp;=&nbsp;0,&nbsp;GAMUT_BT601&nbsp;=&nbsp;0x00000001,&nbsp;GAMUT_BT709&nbsp;=&nbsp;0x00000002,&nbsp;GAMUT_DCI_P3&nbsp;=&nbsp;0x00000003,&nbsp;&nbsp;&nbsp;GAMUT_SRGB&nbsp;=&nbsp;0x00000004,&nbsp;GAMUT_ADOBE_RGB&nbsp;=&nbsp;0x00000005,&nbsp;GAMUT_DISPLAY_P3&nbsp;=&nbsp;0x00000006,&nbsp;GAMUT_BT2020&nbsp;=&nbsp;0x00000007,&nbsp;&nbsp;&nbsp;GAMUT_BT2100_PQ&nbsp;=&nbsp;0x00000008,&nbsp;GAMUT_BT2100_HLG&nbsp;=&nbsp;0x00000009,&nbsp;GAMUT_DISPLAY_BT2020&nbsp;=&nbsp;0x0000000a,&nbsp;TRANSFORM_FUNC_UNSPECIFIED&nbsp;=&nbsp;0x00000100,&nbsp;&nbsp;&nbsp;TRANSFORM_FUNC_LINEAR&nbsp;=&nbsp;0x00000200,&nbsp;TRANSFORM_FUNC_SRGB&nbsp;=&nbsp;0x00000300,&nbsp;TRANSFORM_FUNC_SMPTE_170M&nbsp;=&nbsp;0x00000400,&nbsp;TRANSFORM_FUNC_GM2_2&nbsp;=&nbsp;0x00000500,&nbsp;&nbsp;&nbsp;TRANSFORM_FUNC_GM2_6&nbsp;=&nbsp;0x00000600,&nbsp;TRANSFORM_FUNC_GM2_8&nbsp;=&nbsp;0x00000700,&nbsp;TRANSFORM_FUNC_ST2084&nbsp;=&nbsp;0x00000800,&nbsp;TRANSFORM_FUNC_HLG&nbsp;=&nbsp;0x00000900,&nbsp;&nbsp;&nbsp;PRECISION_UNSPECIFIED&nbsp;=&nbsp;0x00010000,&nbsp;PRECISION_FULL&nbsp;=&nbsp;0x00020000,&nbsp;PRESION_LIMITED&nbsp;=&nbsp;0x00030000,&nbsp;PRESION_EXTENDED&nbsp;=&nbsp;0x00040000,&nbsp;&nbsp;&nbsp;BT601_SMPTE170M_FULL&nbsp;=&nbsp;GAMUT_BT601&nbsp;\|&nbsp;TRANSFORM_FUNC_SMPTE_170M&nbsp;\|&nbsp;PRECISION_FULL,&nbsp;BT601_SMPTE170M_LIMITED&nbsp;=&nbsp;GAMUT_BT601&nbsp;\|&nbsp;TRANSFORM_FUNC_SMPTE_170M&nbsp;\|&nbsp;PRESION_LIMITED,&nbsp;BT709_LINEAR_FULL&nbsp;=&nbsp;GAMUT_BT709&nbsp;\|&nbsp;TRANSFORM_FUNC_LINEAR&nbsp;\|&nbsp;PRECISION_FULL,&nbsp;BT709_LINEAR_EXTENDED&nbsp;=&nbsp;GAMUT_BT709&nbsp;\|&nbsp;TRANSFORM_FUNC_LINEAR&nbsp;\|&nbsp;PRESION_EXTENDED,&nbsp;&nbsp;&nbsp;BT709_SRGB_FULL&nbsp;=&nbsp;GAMUT_BT709&nbsp;\|&nbsp;TRANSFORM_FUNC_SRGB&nbsp;\|&nbsp;PRECISION_FULL,&nbsp;BT709_SRGB_EXTENDED&nbsp;=&nbsp;GAMUT_BT709&nbsp;\|&nbsp;TRANSFORM_FUNC_SRGB&nbsp;\|&nbsp;PRESION_EXTENDED,&nbsp;BT709_SMPTE170M_LIMITED&nbsp;=&nbsp;GAMUT_BT709&nbsp;\|&nbsp;TRANSFORM_FUNC_SMPTE_170M&nbsp;\|&nbsp;PRESION_LIMITED,&nbsp;DCI_P3_LINEAR_FULL&nbsp;=&nbsp;GAMUT_DCI_P3&nbsp;\|&nbsp;TRANSFORM_FUNC_LINEAR&nbsp;\|&nbsp;PRECISION_FULL,&nbsp;&nbsp;&nbsp;DCI_P3_GAMMA26_FULL&nbsp;=&nbsp;GAMUT_DCI_P3&nbsp;\|&nbsp;TRANSFORM_FUNC_GM2_6&nbsp;\|&nbsp;PRECISION_FULL,&nbsp;DISPLAY_P3_LINEAR_FULL&nbsp;=&nbsp;GAMUT_DISPLAY_P3&nbsp;\|&nbsp;TRANSFORM_FUNC_LINEAR&nbsp;\|&nbsp;PRECISION_FULL,&nbsp;DCI_P3_SRGB_FULL&nbsp;=&nbsp;GAMUT_DCI_P3&nbsp;\|&nbsp;TRANSFORM_FUNC_SRGB&nbsp;\|&nbsp;PRECISION_FULL,&nbsp;ADOBE_RGB_GAMMA22_FULL&nbsp;=&nbsp;GAMUT_ADOBE_RGB&nbsp;\|&nbsp;TRANSFORM_FUNC_GM2_2&nbsp;\|&nbsp;PRECISION_FULL,&nbsp;&nbsp;&nbsp;BT2020_LINEAR_FULL&nbsp;=&nbsp;GAMUT_BT2020&nbsp;\|&nbsp;TRANSFORM_FUNC_LINEAR&nbsp;\|&nbsp;PRECISION_FULL,&nbsp;BT2020_SRGB_FULL&nbsp;=&nbsp;GAMUT_BT2020&nbsp;\|&nbsp;TRANSFORM_FUNC_SRGB&nbsp;\|&nbsp;PRECISION_FULL,&nbsp;BT2020_SMPTE170M_FULL&nbsp;=&nbsp;GAMUT_BT2020&nbsp;\|&nbsp;TRANSFORM_FUNC_SMPTE_170M&nbsp;\|&nbsp;PRECISION_FULL,&nbsp;BT2020_ST2084_FULL&nbsp;=&nbsp;GAMUT_BT2020&nbsp;\|&nbsp;TRANSFORM_FUNC_ST2084&nbsp;\|&nbsp;PRECISION_FULL,&nbsp;&nbsp;&nbsp;BT2020_HLG_FULL&nbsp;=&nbsp;GAMUT_BT2020&nbsp;\|&nbsp;TRANSFORM_FUNC_HLG&nbsp;\|&nbsp;PRECISION_FULL,&nbsp;BT2020_ST2084_LIMITED&nbsp;=&nbsp;GAMUT_BT2020&nbsp;\|&nbsp;TRANSFORM_FUNC_ST2084&nbsp;\|&nbsp;PRESION_LIMITED&nbsp;} | [ColorDataSpace](_display.md#colordataspace)&nbsp;{&nbsp;&nbsp;&nbsp;[COLOR_DATA_SPACE_UNKNOWN](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33cca5a0aa62f13715cbdf2b5ec1e26e76225)&nbsp;=&nbsp;0,&nbsp;[GAMUT_BT601](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33ccad778a31f4c8e3431f5240f98c70f577d)&nbsp;=&nbsp;0x00000001,&nbsp;[GAMUT_BT709](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33cca7d346fa865c56c76f62c7f6ab92511ec)&nbsp;=&nbsp;0x00000002,&nbsp;[GAMUT_DCI_P3](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33ccae29ccb674444c3f81f0a46361d7ce63c)&nbsp;=&nbsp;0x00000003,&nbsp;&nbsp;&nbsp;[GAMUT_SRGB](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33cca16c4c57e66f86b20269db0d5d6382ded)&nbsp;=&nbsp;0x00000004,&nbsp;[GAMUT_ADOBE_RGB](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33cca0a0a0c633a41a5f30596a5168a3267ca)&nbsp;=&nbsp;0x00000005,&nbsp;[GAMUT_DISPLAY_P3](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33cca3d4a0608dd5c682fc020bfc68a425e15)&nbsp;=&nbsp;0x00000006,&nbsp;[GAMUT_BT2020](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33ccaa6dc448a5d0d16a7d2610edb29fff407)&nbsp;=&nbsp;0x00000007,&nbsp;&nbsp;&nbsp;[GAMUT_BT2100_PQ](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33cca6b100b6876c7e77106df92b9c8cf7d2b)&nbsp;=&nbsp;0x00000008,&nbsp;[GAMUT_BT2100_HLG](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33cca53a60a5ed93129597841bde263e9a798)&nbsp;=&nbsp;0x00000009,&nbsp;[GAMUT_DISPLAY_BT2020](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33ccaa66ffaf12ec59488cccbd2170cc3d2c8)&nbsp;=&nbsp;0x0000000a,&nbsp;[TRANSFORM_FUNC_UNSPECIFIED](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33cca0fe652843eafbf7a93b645a71342dce0)&nbsp;=&nbsp;0x00000100,&nbsp;&nbsp;&nbsp;[TRANSFORM_FUNC_LINEAR](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33ccaa2e1f70b023dd5ae3a31771217d958cc)&nbsp;=&nbsp;0x00000200,&nbsp;[TRANSFORM_FUNC_SRGB](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33cca47dd20703e8d8135aedfb687b75ef66c)&nbsp;=&nbsp;0x00000300,&nbsp;[TRANSFORM_FUNC_SMPTE_170M](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33ccab031ec808cc46bee79d2c96460615206)&nbsp;=&nbsp;0x00000400,&nbsp;[TRANSFORM_FUNC_GM2_2](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33cca078b8dad4e1eb6720c81c841b3f417d9)&nbsp;=&nbsp;0x00000500,&nbsp;&nbsp;&nbsp;[TRANSFORM_FUNC_GM2_6](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33ccad6abe514be2fa6c57b2aec5a5eb6fc7d)&nbsp;=&nbsp;0x00000600,&nbsp;[TRANSFORM_FUNC_GM2_8](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33cca850b419cb0075b5bd44df5708fc9c87f)&nbsp;=&nbsp;0x00000700,&nbsp;[TRANSFORM_FUNC_ST2084](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33cca24a6d830fca211b067260df9583a1b2b)&nbsp;=&nbsp;0x00000800,&nbsp;[TRANSFORM_FUNC_HLG](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33cca4a6d68c7a2219cada2edf0e9d7bc46f8)&nbsp;=&nbsp;0x00000900,&nbsp;&nbsp;&nbsp;[PRECISION_UNSPECIFIED](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33cca77342396f1154be94079d0d76fc5e829)&nbsp;=&nbsp;0x00010000,&nbsp;[PRECISION_FULL](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33cca200541efc2ee0d21e37a7200e7a08a54)&nbsp;=&nbsp;0x00020000,&nbsp;[PRESION_LIMITED](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33ccab51307e81936be84b6504a98197fb1ee)&nbsp;=&nbsp;0x00030000,&nbsp;[PRESION_EXTENDED](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33ccafd6ac339ebbdbbdd7fee540a6fad5ec2)&nbsp;=&nbsp;0x00040000,&nbsp;&nbsp;&nbsp;[BT601_SMPTE170M_FULL](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33ccab640f36320dafb19066dfcaccc836999)&nbsp;=&nbsp;GAMUT_BT601&nbsp;\|&nbsp;TRANSFORM_FUNC_SMPTE_170M&nbsp;\|&nbsp;PRECISION_FULL,&nbsp;[BT601_SMPTE170M_LIMITED](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33cca6cd475c6421764e5d71d71f1de75d638)&nbsp;=&nbsp;GAMUT_BT601&nbsp;\|&nbsp;TRANSFORM_FUNC_SMPTE_170M&nbsp;\|&nbsp;PRESION_LIMITED,&nbsp;[BT709_LINEAR_FULL](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33ccad2bc96da52c18ef9bb26320507747176)&nbsp;=&nbsp;GAMUT_BT709&nbsp;\|&nbsp;TRANSFORM_FUNC_LINEAR&nbsp;\|&nbsp;PRECISION_FULL,&nbsp;[BT709_LINEAR_EXTENDED](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33cca03631fd75bc6ec7280ce2c68a129e4fd)&nbsp;=&nbsp;GAMUT_BT709&nbsp;\|&nbsp;TRANSFORM_FUNC_LINEAR&nbsp;\|&nbsp;PRESION_EXTENDED,&nbsp;&nbsp;&nbsp;[BT709_SRGB_FULL](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33ccaaffba49d9c1c335387cd8153becad65a)&nbsp;=&nbsp;GAMUT_BT709&nbsp;\|&nbsp;TRANSFORM_FUNC_SRGB&nbsp;\|&nbsp;PRECISION_FULL,&nbsp;[BT709_SRGB_EXTENDED](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33cca049878481c3ed46dbd6cfea995e2f0d5)&nbsp;=&nbsp;GAMUT_BT709&nbsp;\|&nbsp;TRANSFORM_FUNC_SRGB&nbsp;\|&nbsp;PRESION_EXTENDED,&nbsp;[BT709_SMPTE170M_LIMITED](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33cca14381e6d202b6bda3c90264b05d31838)&nbsp;=&nbsp;GAMUT_BT709&nbsp;\|&nbsp;TRANSFORM_FUNC_SMPTE_170M&nbsp;\|&nbsp;PRESION_LIMITED,&nbsp;[DCI_P3_LINEAR_FULL](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33ccad03af85a7ff4c1069a97bfb603f7d694)&nbsp;=&nbsp;GAMUT_DCI_P3&nbsp;\|&nbsp;TRANSFORM_FUNC_LINEAR&nbsp;\|&nbsp;PRECISION_FULL,&nbsp;&nbsp;&nbsp;[DCI_P3_GAMMA26_FULL](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33cca9de9b32e0e7c172c77922af8904ba3a2)&nbsp;=&nbsp;GAMUT_DCI_P3&nbsp;\|&nbsp;TRANSFORM_FUNC_GM2_6&nbsp;\|&nbsp;PRECISION_FULL,&nbsp;[DISPLAY_P3_LINEAR_FULL](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33cca8bcb3a4ed6039d158b9c32ba99fceaff)&nbsp;=&nbsp;GAMUT_DISPLAY_P3&nbsp;\|&nbsp;TRANSFORM_FUNC_LINEAR&nbsp;\|&nbsp;PRECISION_FULL,&nbsp;[DCI_P3_SRGB_FULL](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33cca2fac97f61868100034eb40fdba9a9d3f)&nbsp;=&nbsp;GAMUT_DCI_P3&nbsp;\|&nbsp;TRANSFORM_FUNC_SRGB&nbsp;\|&nbsp;PRECISION_FULL,&nbsp;[ADOBE_RGB_GAMMA22_FULL](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33cca1f855c7b4bd5f8a9cc29f3e335a9f2f4)&nbsp;=&nbsp;GAMUT_ADOBE_RGB&nbsp;\|&nbsp;TRANSFORM_FUNC_GM2_2&nbsp;\|&nbsp;PRECISION_FULL,&nbsp;&nbsp;&nbsp;[BT2020_LINEAR_FULL](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33cca27315309a3b866eda00f17825ee9532d)&nbsp;=&nbsp;GAMUT_BT2020&nbsp;\|&nbsp;TRANSFORM_FUNC_LINEAR&nbsp;\|&nbsp;PRECISION_FULL,&nbsp;[BT2020_SRGB_FULL](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33ccaa63d6a3a8bb1c6c5b383cb7010f61d72)&nbsp;=&nbsp;GAMUT_BT2020&nbsp;\|&nbsp;TRANSFORM_FUNC_SRGB&nbsp;\|&nbsp;PRECISION_FULL,&nbsp;[BT2020_SMPTE170M_FULL](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33cca6de02e882e01743ce5ca07a17d481930)&nbsp;=&nbsp;GAMUT_BT2020&nbsp;\|&nbsp;TRANSFORM_FUNC_SMPTE_170M&nbsp;\|&nbsp;PRECISION_FULL,&nbsp;[BT2020_ST2084_FULL](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33ccac2e37c91fc9bd29641cf95d74aa7862c)&nbsp;=&nbsp;GAMUT_BT2020&nbsp;\|&nbsp;TRANSFORM_FUNC_ST2084&nbsp;\|&nbsp;PRECISION_FULL,&nbsp;&nbsp;&nbsp;[BT2020_HLG_FULL](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33ccad5b0a069ac80df8d045265e88f9b5e71)&nbsp;=&nbsp;GAMUT_BT2020&nbsp;\|&nbsp;TRANSFORM_FUNC_HLG&nbsp;\|&nbsp;PRECISION_FULL,&nbsp;[BT2020_ST2084_LIMITED](_display.md#gga00fa6ca1bcfe5949dceaa3a77f8d33ccaeab2d55af8e3568130cf69fa614b3c9d)&nbsp;=&nbsp;GAMUT_BT2020&nbsp;\|&nbsp;TRANSFORM_FUNC_ST2084&nbsp;\|&nbsp;PRESION_LIMITED&nbsp;} | 枚举颜色空间的类型&nbsp;[更多...](_display.md#colordataspace) | 
| [HDRFormat](_display.md#hdrformat)&nbsp;{&nbsp;NOT_SUPPORT_HDR&nbsp;=&nbsp;0,&nbsp;DOLBY_VISION&nbsp;=&nbsp;1,&nbsp;HDR10&nbsp;=&nbsp;2,&nbsp;HLG&nbsp;=&nbsp;3,&nbsp;&nbsp;&nbsp;HDR10_PLUS&nbsp;=&nbsp;4,&nbsp;HDR_VIVID&nbsp;=&nbsp;5&nbsp;} | [HDRFormat](_display.md#hdrformat)&nbsp;{&nbsp;&nbsp;&nbsp;[NOT_SUPPORT_HDR](_display.md#ggabdc446aa6fa47c5dd8d1b7d87bed2566a0799ce04a1873f60ed59c3d30dcda69a)&nbsp;=&nbsp;0,&nbsp;[DOLBY_VISION](_display.md#ggabdc446aa6fa47c5dd8d1b7d87bed2566ac43f1175d92c85033e0a85c7a14266a7)&nbsp;=&nbsp;1,&nbsp;[HDR10](_display.md#ggabdc446aa6fa47c5dd8d1b7d87bed2566ada5b15b3c4b4cc64593452113ac1d4dc)&nbsp;=&nbsp;2,&nbsp;[HLG](_display.md#ggabdc446aa6fa47c5dd8d1b7d87bed2566a2c6e7224778e782cbbd478e4c11282e2)&nbsp;=&nbsp;3,&nbsp;&nbsp;&nbsp;[HDR10_PLUS](_display.md#ggabdc446aa6fa47c5dd8d1b7d87bed2566abc6f25afdafdebb03fd137de1917389d)&nbsp;=&nbsp;4,&nbsp;[HDR_VIVID](_display.md#ggabdc446aa6fa47c5dd8d1b7d87bed2566a84318c5a162e5b9b822e38e675117e42)&nbsp;=&nbsp;5&nbsp;} | 枚举HDR格式&nbsp;[更多...](_display.md#hdrformat) | 
| [HDRMetadataKey](_display.md#hdrmetadatakey)&nbsp;{&nbsp;MATAKEY_RED_PRIMARY_X&nbsp;=&nbsp;0,&nbsp;MATAKEY_RED_PRIMARY_Y&nbsp;=&nbsp;1,&nbsp;MATAKEY_GREEN_PRIMARY_X&nbsp;=&nbsp;2,&nbsp;MATAKEY_GREEN_PRIMARY_Y&nbsp;=&nbsp;3,&nbsp;&nbsp;&nbsp;MATAKEY_BLUE_PRIMARY_X&nbsp;=&nbsp;4,&nbsp;MATAKEY_BLUE_PRIMARY_Y&nbsp;=&nbsp;5,&nbsp;MATAKEY_WHITE_PRIMARY_X&nbsp;=&nbsp;6,&nbsp;MATAKEY_WHITE_PRIMARY_Y&nbsp;=&nbsp;7,&nbsp;&nbsp;&nbsp;MATAKEY_MAX_LUMINANCE&nbsp;=&nbsp;8,&nbsp;MATAKEY_MIN_LUMINANCE&nbsp;=&nbsp;9,&nbsp;MATAKEY_MAX_CONTENT_LIGHT_LEVEL&nbsp;=&nbsp;10,&nbsp;MATAKEY_MAX_FRAME_AVERAGE_LIGHT_LEVEL&nbsp;=&nbsp;11,&nbsp;&nbsp;&nbsp;MATAKEY_HDR10_PLUS&nbsp;=&nbsp;12,&nbsp;MATAKEY_HDR_VIVID&nbsp;=&nbsp;13&nbsp;} | [HDRMetadataKey](_display.md#hdrmetadatakey)&nbsp;{&nbsp;&nbsp;&nbsp;[MATAKEY_RED_PRIMARY_X](_display.md#gga5d7d90acb5c568e62a02b18446f37789a92c0f5eaba344bee22c657040b606fd3)&nbsp;=&nbsp;0,&nbsp;[MATAKEY_RED_PRIMARY_Y](_display.md#gga5d7d90acb5c568e62a02b18446f37789a405841a4999556bd36281870d579dc7e)&nbsp;=&nbsp;1,&nbsp;[MATAKEY_GREEN_PRIMARY_X](_display.md#gga5d7d90acb5c568e62a02b18446f37789a08f31a74e8df3253c6326879818dfe1b)&nbsp;=&nbsp;2,&nbsp;[MATAKEY_GREEN_PRIMARY_Y](_display.md#gga5d7d90acb5c568e62a02b18446f37789a19db3eede73e96c6a25dc4d31e5846e1)&nbsp;=&nbsp;3,&nbsp;&nbsp;&nbsp;[MATAKEY_BLUE_PRIMARY_X](_display.md#gga5d7d90acb5c568e62a02b18446f37789a23e7112a9c4aaf15bc2a529344a61939)&nbsp;=&nbsp;4,&nbsp;[MATAKEY_BLUE_PRIMARY_Y](_display.md#gga5d7d90acb5c568e62a02b18446f37789a5a34485b5884d8bd86273750b9d47b0b)&nbsp;=&nbsp;5,&nbsp;[MATAKEY_WHITE_PRIMARY_X](_display.md#gga5d7d90acb5c568e62a02b18446f37789ac12237b3de1eee6176c690e7f14ab339)&nbsp;=&nbsp;6,&nbsp;[MATAKEY_WHITE_PRIMARY_Y](_display.md#gga5d7d90acb5c568e62a02b18446f37789a331c8b69a7d9484c9eaea70e78a34921)&nbsp;=&nbsp;7,&nbsp;&nbsp;&nbsp;[MATAKEY_MAX_LUMINANCE](_display.md#gga5d7d90acb5c568e62a02b18446f37789ac27053151e1fa76e58dc3281d843ad74)&nbsp;=&nbsp;8,&nbsp;[MATAKEY_MIN_LUMINANCE](_display.md#gga5d7d90acb5c568e62a02b18446f37789a345f5cea142c7357e0b9de5ccfc86bed)&nbsp;=&nbsp;9,&nbsp;[MATAKEY_MAX_CONTENT_LIGHT_LEVEL](_display.md#gga5d7d90acb5c568e62a02b18446f37789a9897f53fcb179afc9c90f8c7ca0ac254)&nbsp;=&nbsp;10,&nbsp;[MATAKEY_MAX_FRAME_AVERAGE_LIGHT_LEVEL](_display.md#gga5d7d90acb5c568e62a02b18446f37789a8d285ea7b6246f62b7e7a65e5a870bfe)&nbsp;=&nbsp;11,&nbsp;&nbsp;&nbsp;[MATAKEY_HDR10_PLUS](_display.md#gga5d7d90acb5c568e62a02b18446f37789a89ef9c02321a94080f185c7fea3f6d1d)&nbsp;=&nbsp;12,&nbsp;[MATAKEY_HDR_VIVID](_display.md#gga5d7d90acb5c568e62a02b18446f37789ac99c4612b3aee2bfede23070fe32ac7e)&nbsp;=&nbsp;13&nbsp;} | 枚举HDR元数据关键字&nbsp;[更多...](_display.md#hdrmetadatakey) | 
| [PresentTimestampType](_display.md#presenttimestamptype)&nbsp;{&nbsp;HARDWARE_DISPLAY_PTS_UNSUPPORTED&nbsp;=&nbsp;0,&nbsp;HARDWARE_DISPLAY_PTS_DELAY&nbsp;=&nbsp;1&nbsp;&lt;&lt;&nbsp;0,&nbsp;HARDWARE_DISPLAY_PTS_TIMESTAMP&nbsp;=&nbsp;1&nbsp;&lt;&lt;&nbsp;1&nbsp;} | [PresentTimestampType](_display.md#presenttimestamptype)&nbsp;{&nbsp;[HARDWARE_DISPLAY_PTS_UNSUPPORTED](_display.md#ggabdba71665ea5ba4004ac1a9fbeb505f3ad6e47ab1a80ab94cccb5e465610ff45d)&nbsp;=&nbsp;0,&nbsp;[HARDWARE_DISPLAY_PTS_DELAY](_display.md#ggabdba71665ea5ba4004ac1a9fbeb505f3a5c06391b9583b69d37c7a0518dd10f09)&nbsp;=&nbsp;1&nbsp;&lt;&lt;&nbsp;0,&nbsp;[HARDWARE_DISPLAY_PTS_TIMESTAMP](_display.md#ggabdba71665ea5ba4004ac1a9fbeb505f3afd872c457c9dade672aaaec5de622ff7)&nbsp;=&nbsp;1&nbsp;&lt;&lt;&nbsp;1&nbsp;} | 上屏时间戳类型枚举值&nbsp;[更多...](_display.md#presenttimestamptype) | 


## **详细描述**

显示类型定义，定义显示驱动接口所使用的数据类型。

**Since：**

1.0

**Version：**

2.0
