# 烧录


烧录是指将编译后的程序文件下载到芯片开发板上的动作，为后续的程序调试提供基础。DevEco Device Tool提供一键烧录功能，操作简单，能快捷、高效的完成程序烧录，提升烧录的效率。

Hi3516DV300开发板小型系统的烧录方式包括USB烧录、网口烧录两种方式，本文采用USB方式进行烧录。


> ![icon-note.gif](public_sys-resources/icon-note.gif) **说明：**
> 使用USB烧录方式，在DevEco Device Tool 2.2 Beta2及更高版本中支持。


1. 请连接好电脑和待烧录开发板，需要连接USB口和串口，具体可参考[Hi3516DV300开发板介绍](quickstart-lite-introduction-hi3516.md)。

2. 根据[Hi3516DV300开发板串口驱动安装指导](https://gitee.com/link?target=https%3A%2F%2Fdevice.harmonyos.com%2Fcn%2Fdocs%2Fdocumentation%2Fguide%2Fhi3516_hi3518-drivers-0000001050743695)、[Hi3516DV300开发板USB驱动安装指导](https://device.harmonyos.com/cn/docs/documentation/guide/usb_driver-0000001058690393)安装USB驱动及USB转串口的驱动。若您的设备中已安装此驱动，请忽略该步骤。

3. 在DevEco Device Tool中，选择REMOTE DEVELOPMENT &gt; Local PC，查看远程计算机（Ubuntu开发环境）与本地计算机（Windows开发环境）的连接状态。

   - 如果Local PC右边连接按钮为![zh-cn_image_0000001261315939](figures/zh-cn_image_0000001261315939.png)，则远程计算机与本地计算机为已连接状态，不需要执行其他操作。
   - 如果Local PC右边连接按钮为![zh-cn_image_0000001261515989](figures/zh-cn_image_0000001261515989.png)，则点击绿色按钮进行连接。连接时DevEco Device Tool会重启服务，因此请不要在下载源码或源码编译过程中进行连接，否则会中断任务。

   ![zh-cn_image_0000001261395999](figures/zh-cn_image_0000001261395999.png)

4. 在菜单栏中点击**Project Settings**按钮，进入Hi3516DV300工程配置界面。

   ![zh-cn_image_0000001198566364](figures/zh-cn_image_0000001198566364.png)

5. 在“Tool Chain”页签，设置Uploader烧录器工具，可以通过Tool Chain页签中的Install按钮在线安装。

   ![zh-cn_image_0000001198566365](figures/zh-cn_image_0000001198566365.png)
   
6. 在“hi3516dv300”页签，设置烧录选项，包括upload_partitions、upload_port和upload_protocol。

   - upload_partitions：选择待烧录程序的配置文件（已预置默认的配置文件），该配置文件会指定烧录文件名称、起始烧录地址、地址长度等信息；同时请勾选**Enable to use upload_partitions_profile for upload**选项。

     > ![icon-note.gif](public_sys-resources/icon-note.gif) **说明：**
     >
     > 如需修改烧录profile文件，在设置烧录分区起始地址和分区长度时，应根据实际待烧录文件的大小进行设置，要求设置的烧录分区大小，要大于待烧录文件的大小；同时，各烧录文件的分区地址设置不能出现重叠。
     >
     > 首次烧录，请勾选**Enable to use upload_partitions_profile for upload**选项，会自动生成upload_partitions文件。再次烧录时，可根据实际情况选择生成upload_partitions文件进行自定义烧录，也可以再勾选**Enable to use upload_partitions_profile for upload**选项，使用upload_partitions_profile重新生成upload_partitions文件用于烧录。

   - upload_protocol：选择烧录协议，固定选择“hiburn-usb”。

   - upload_port：选择已查询的串口号。

   ![zh-cn_image_0000001177478136](figures/zh-cn_image_0000001177478136.png)

7. 所有的配置都修改完成后，在工程配置页签的顶部，点击**Save**进行保存。

8. 点击hi3516dv300下的**Upload**按钮。

   ![zh-cn_image_0000001267532292](figures/zh-cn_image_0000001267532292.png)

   此时待烧录文件会从Ubuntu系统传输到Windows下，传输完成后界面显示“Operation paused, Please press Enter key to continue”时，请点击**Enter**键启动烧录。

   ![zh-cn_image_0000001114129427](figures/zh-cn_image_0000001114129427.png)

9. 在终端窗口显示如下提示信息时，请在15秒内，按住Update键，插拔USB线，最后松开Update键启动烧录。

   ![zh-cn_image_0000001326412233.png](figures/zh-cn_image_0000001326412233.png)

   启动烧录后，界面提示**SUCCESS**信息时，表示烧录成功。

   ![zh-cn_image_0000001160649344](figures/zh-cn_image_0000001160649344.png)

11. 烧录成功后，请根据运行章节进行操作，启动系统。