# OpenHarmony应用开发文档
- [应用开发导读](application-dev-guide.md)
- 快速开始

  - 快速入门
    - [开发准备](quick-start/start-overview.md)
    - [使用eTS语言开发（传统代码方式）](quick-start/start-with-ets.md)
    - [使用eTS语言开发（低代码方式）](quick-start/start-with-ets-low-code.md)
    - [使用JS语言开发（传统代码方式）](quick-start/start-with-js.md)
    - [使用JS语言开发（低代码方式）](quick-start/start-with-js-low-code.md)

  - 开发基础知识
    - [应用包结构说明(FA模型)](quick-start/package-structure.md)
    - [应用包结构说明(Stage模型)](quick-start/stage-structure.md)
    - [SysCap说明](quick-start/syscap.md)
    - [HarmonyAppProvision配置文件](quick-start/app-provision-structure.md)
- 开发
  - Ability开发
    - [Ability框架概述](ability/ability-brief.md)
    - [应用上下文Context概述](ability/context-userguide.md)
    - FA模型
      - [FA模型综述](ability/fa-brief.md)
      - [PageAbility开发指导](ability/fa-pageability.md)
      - [ServiceAbility开发指导](ability/fa-serviceability.md)
      - [DataAbility开发指导](ability/fa-dataability.md)
      - [FA卡片开发指导](ability/fa-formability.md)
    - Stage模型
      - [Stage模型综述](ability/stage-brief.md)
      - [Ability开发指导](ability/stage-ability.md)
      - [ServiceExtensionAbility开发指导](ability/stage-serviceextension.md)
      - [跨端迁移开发指导](ability/stage-ability-continuation.md)
      - [Call调用开发指导](ability/stage-call.md)
      - [Stage卡片开发指导](ability/stage-formextension.md)
    - 其他
      - [WantAgent开发指导](ability/wantagent.md)
      - [Ability助手使用指导](ability/ability-assistant-guidelines.md)
      - [测试框架使用指导](ability/ability-delegator.md)
  - UI开发
    - [方舟开发框架（ArkUI）概述](ui/arkui-overview.md)
    - 基于JS扩展的类Web开发范式
      - [概述](ui/ui-js-overview.md)
      - 框架说明
        - [文件组织](ui/js-framework-file.md)
        - [js标签配置](ui/js-framework-js-tag.md)
        - [app.js](ui/js-framework-js-file.md)
        - 语法
          - [HML语法参考](ui/js-framework-syntax-hml.md)
          - [CSS语法参考](ui/js-framework-syntax-css.md)
          - [JS语法参考](ui/js-framework-syntax-js.md)
        - [生命周期](ui/js-framework-lifecycle.md)
        - [资源限定与访问](ui/js-framework-resource-restriction.md)
        - [多语言支持](ui/js-framework-multiple-languages.md)
      - 构建用户界面
        - [组件介绍](ui/ui-js-building-ui-component.md)
        - 构建布局
          - [布局说明](ui/ui-js-building-ui-layout-intro.md)
          - [添加标题行和文本区域](ui/ui-js-building-ui-layout-text.md)
          - [添加图片区域](ui/ui-js-building-ui-layout-image.md)
          - [添加留言区域](ui/ui-js-building-ui-layout-comment.md)
          - [添加容器](ui/ui-js-building-ui-layout-external-container.md)
        - [添加交互](ui/ui-js-building-ui-interactions.md)
        - [动画](ui/ui-js-building-ui-animation.md)
        - [手势事件](ui/ui-js-building-ui-event.md)
        - [页面路由](ui/ui-js-building-ui-routes.md)
      - 常见组件开发指导
        - 容器组件
          - [List开发指导](ui/ui-js-components-list.md)
          - [Dialog开发指导](ui/ui-js-components-dialog.md)
          - [Form开发指导](ui/ui-js-components-form.md)
          - [Stepper开发指导](ui/ui-js-components-stepper.md)
          - [Tabs开发指导](ui/ui-js-component-tabs.md)
          - [Swiper开发指导](ui/ui-js-components-swiper.md)
        - 基础组件
          - [Text开发指导](ui/ui-js-components-text.md)
          - [Input开发指导](ui/ui-js-components-input.md)
          - [Button开发指导](ui/ui-js-components-button.md)
          - [Picker开发指导](ui/ui-js-components-picker.md)
          - [Image开发指导](ui/ui-js-components-images.md)
          - [Image-animator开发指导](ui/ui-js-components-image-animator.md)
          - [Rating开发指导](ui/ui-js-components-rating.md)
          - [Slider开发指导](ui/ui-js-components-slider.md)
          - [Chart开发指导](ui/ui-js-components-chart.md)
          - [Switch开发指导](ui/ui-js-components-switch.md)
          - [Toolbar开发指导](ui/ui-js-components-toolbar.md)
          - [Menu开发指导](ui/ui-js-components-menu.md)
          - [Marquee开发指导](ui/ui-js-components-marquee.md)
          - [Qrcode开发指导](ui/ui-js-components-qrcode.md)
          - [Search开发指导](ui/ui-js-components-search.md)
        - Canvas开发指导
          - [Canvas对象](ui/ui-js-components-canvas.md)
          - [CanvasRenderingContext2D对象](ui/ui-js-components-canvasrenderingcontext2d.md)
          - [Path2D对象](ui/ui-js-components-path2d.md)
          - [OffscreenCanvas对象](ui/ui-js-components-offscreencanvas.md)
        - [栅格布局](ui/ui-js-components-grid.md)
        - Svg开发指导
          - [基础知识](ui/ui-js-components-svg-overview.md)
          - [绘制图形](ui/ui-js-components-svg-graphics.md)
          - [绘制路径](ui/ui-js-components-svg-path.md)
          - [绘制文本](ui/ui-js-components-svg-text.md)
      - 动效开发指导
        - CSS动画
          - [属性样式动画](ui/ui-js-animate-attribute-style.md)
          - [transform样式动画](ui/ui-js-animate-transform.md)
          - [background-position样式动画](ui/ui-js-animate-background-position-style.md)
          - [svg动画](ui/ui-js-animate-svg.md)
        - JS动画
          - [组件动画](ui/ui-js-animate-component.md)
          - 插值器动画
            - [动画动效](ui/ui-js-animate-dynamic-effects.md)
            - [动画帧](ui/ui-js-animate-frame.md)
      - [自定义组件](ui/ui-js-custom-components.md)
    - 基于TS扩展的声明式开发范式
      - [概述](ui/ui-ts-overview.md)
      - 框架说明
        - 文件组织
          - [目录结构](ui/ts-framework-directory.md)
          - [应用代码文件访问规则](ui/ts-framework-file-access-rules.md)
        - [js标签配置](ui/ts-framework-js-tag.md)
        - 资源管理
          - [资源文件的分类](ui/ui-ts-basic-resource-file-categories.md)
          - [资源访问](ui/ts-resource-access.md)
        - [像素单位](ui/ts-pixel-units.md)
        - [类型定义](ui/ts-types.md)
      - 声明式语法
        - [描述规范使用说明](ui/ts-syntax-intro.md)
        - 通用UI描述规范
          - [基本概念](ui/ts-general-ui-concepts.md)
          - 声明式UI描述规范
            - [无构造参数配置](ui/ts-parameterless-configuration.md)
            - [必选参数构造配置](ui/ts-configuration-with-mandatory-parameters.md)
            - [属性配置](ui/ts-attribution-configuration.md)
            - [事件配置](ui/ts-event-configuration.md)
            - [子组件配置](ui/ts-child-component-configuration.md)
          - 组件化
            - [@Component](ui/ts-component-based-component.md)
            - [@Entry](ui/ts-component-based-entry.md)
            - [@Preview](ui/ts-component-based-preview.md)
            - [@Builder](ui/ts-component-based-builder.md)
            - [@Extend](ui/ts-component-based-extend.md)
            - [@CustomDialog](ui/ts-component-based-customdialog.md)
            - [@Styles](ui/ts-component-based-styles.md)
        - UI状态管理
          - [基本概念](ui/ts-ui-state-mgmt-concepts.md)
          - 管理组件拥有的状态
            - [@State](ui/ts-component-states-state.md)
            - [@Prop](ui/ts-component-states-prop.md)
            - [@Link](ui/ts-component-states-link.md)
          - 管理应用程序的状态
            - [应用程序的数据存储](ui/ts-application-states-appstorage.md)
            - [Ability数据存储](ui/ui-ts-local-storage.md)
            - [持久化数据管理](ui/ts-application-states-apis-persistentstorage.md)
            - [环境变量](ui/ts-application-states-apis-environment.md)
          - 其他类目的状态管理
            - [Observed和ObjectLink数据管理](ui/ts-other-states-observed-objectlink.md)
            - [@Consume和@Provide数据管理](ui/ts-other-states-consume-provide.md)
            - [@Watch](ui/ts-other-states-watch.md)
        - 渲染控制语法
          - [条件渲染](ui/ts-rending-control-syntax-if-else.md)
          - [循环渲染](ui/ts-rending-control-syntax-foreach.md)
          - [数据懒加载](ui/ts-rending-control-syntax-lazyforeach.md)
        - 深入理解组件化
          - [build函数](ui/ts-function-build.md)
          - [自定义组件初始化](ui/ts-custom-component-initialization.md)
          - [自定义组件生命周期回调函数](ui/ts-custom-component-lifecycle-callbacks.md)
          - [组件创建和重新初始化示例](ui/ts-component-creation-re-initialization.md)
        - [语法糖](ui/ts-syntactic-sugar.md)
      - 常见组件开发指导
        - [Button开发指导](ui/ui-ts-basic-components-button.md)
        - [Web开发指导](ui/ui-ts-components-web.md)
      - 常见布局开发指导
        - [弹性布局](ui/ui-ts-layout-flex.md)
        - [栅格布局](ui/ui-ts-layout-grid-container.md)
        - [媒体查询](ui/ui-ts-layout-mediaquery.md)
      - 体验声明式UI
        - [创建声明式UI工程](ui/ui-ts-creating-project.md)
        - [初识Component](ui/ui-ts-components.md)
        - [创建简单视图](ui/ui-ts-creating-simple-page.md)
      - 页面布局与连接
        - [构建食物数据模型](ui/ui-ts-building-data-model.md)
        - [构建食物列表List布局](ui/ui-ts-building-category-list-layout.md)
        - [构建食物分类Grid布局](ui/ui-ts-building-category-grid-layout.md)
        - [页面跳转与数据传递](ui/ui-ts-page-redirection-data-transmission.md)
  - 公共事件与通知
    - [公共事件与通知概述](notification/notification-brief.md)
    - [公共事件开发指导](notification/common-event.md)
    - [通知开发指导](notification/notification-guidelines.md)
    - 后台提醒
      - [后台提醒开发概述](notification/background-agent-scheduled-reminder-overview.md)
      - [后台提醒开发指导](notification/background-agent-scheduled-reminder-guide.md)
    - [调试助手使用指导](notification/assistant-guidelines.md)
  - 窗口管理
    - 窗口
      - [窗口开发概述](windowmanager/window-overview.md)
      - [窗口开发指导](windowmanager/window-guidelines.md)
    - 屏幕属性
      - [屏幕属性开发概述](windowmanager/display-overview.md)
      - [屏幕属性开发指导](windowmanager/display-guidelines.md)
    - 屏幕截图
      - [屏幕截图开发概述](windowmanager/screenshot-overview.md)
      - [屏幕截图开发指导](windowmanager/screenshot-guidelines.md)
  - WebGL
    - [WebGL开发概述](webgl/webgl-overview.md)
    - [WebGL开发指导](webgl/webgl-guidelines.md)
  - 媒体
    - 音频
      - [音频开发概述](media/audio-overview.md)
      - [音频播放开发指导](media/audio-playback.md)
      - [音频录制开发指导](media/audio-recorder.md)
      - [音频渲染开发指导](media/audio-renderer.md)
      - [音频采集开发指导](media/audio-capturer.md)
      - [OpenSL ES播放开发指导](media/opensles-playback.md)
      - [OpenSL ES录音开发指导](media/opensles-capture.md)
      - [音频焦点模式开发指导](media/audio-interruptmode.md)
    - 视频
      - [视频播放开发指导](media/video-playback.md)
      - [视频录制开发指导](media/video-recorder.md)
    - 图片
      - [图片开发指导](media/image.md)
    - 相机
      - [相机开发指导](media/camera.md)
  - 安全
    - 访问控制
      - [访问控制开发概述](security/accesstoken-overview.md)
      - [访问控制开发指导](security/accesstoken-guidelines.md)
      - [权限定义列表](security/permission-list.md)
    - 用户认证
      - [用户认证开发概述](security/userauth-overview.md)
      - [用户认证开发指导](security/userauth-guidelines.md)
    - 密钥管理
      - [HUKS开发概述](security/huks-overview.md)
      - [HUKS开发指导](security/huks-guidelines.md)
    - Hap包签名工具
      - [Hap包签名工具概述](security/hapsigntool-overview.md)
      - [Hap包签名工具指导](security/hapsigntool-guidelines.md)
  - 网络与连接
    - 网络管理
      - [网络管理开发概述](connectivity/net-mgmt-overview.md)
      - [HTTP数据请求](connectivity/http-request.md)
      - [WebSocket连接](connectivity/websocket-connection.md)
      - [Socket连接](connectivity/socket-connection.md)
    - IPC与RPC通信
      - [IPC与RPC通信概述](connectivity/ipc-rpc-overview.md)
      - [IPC与RPC通信开发指导](connectivity/ipc-rpc-development-guideline.md)
      - [远端状态订阅开发实例](connectivity/subscribe-remote-state.md)
  - 电话服务
    - [电话服务开发概述](telephony/telephony-overview.md)
    - [跳转拨号界面](telephony/jumping-to-the-dial-screen.md)
    - [获取当前蜂窝网络信号信息](telephony/cellular-network-signal-info.md)
  - 数据管理
    - 分布式数据服务
      - [分布式数据服务概述](database/database-mdds-overview.md)
      - [分布式数据服务开发指导](database/database-mdds-guidelines.md)
    - 关系型数据库
      - [关系型数据库概述](database/database-relational-overview.md)
      - [关系型数据库开发指导](database/database-relational-guidelines.md)
    - 首选项
      - [首选项概述](database/database-preference-overview.md)
      - [首选项开发指导](database/database-preference-guidelines.md)
    - 分布式数据对象
      - [分布式数据对象概述](database/database-distributedobject-overview.md)
      - [分布式数据对象开发指导](database/database-distributedobject-guidelines.md)
    - 数据共享
      - [数据共享概述](database/database-datashare-overview.md)
      - [数据共享开发指导](database/database-datashare-guidelines.md)
  - 任务管理
    - 后台任务
      - [后台任务概述](task-management/background-task-overview.md)
      - [后台任务开发指导](task-management/background-task-dev-guide.md)
    - 延迟任务调度
      - [延迟任务调度概述](task-management/work-scheduler-overview.md)
      - [延迟任务调度开发指导](task-management/work-scheduler-dev-guide.md)
  - 设备管理
    - USB服务
      - [USB服务开发概述](device/usb-overview.md)
      - [USB服务开发指导](device/usb-guidelines.md)
    - 位置
      - [位置开发概述](device/device-location-overview.md)
      - [获取设备的位置信息](device/device-location-info.md)
      - [（逆）地理编码转化](device/device-location-geocoding.md)
    - 传感器
      - [传感器开发概述](device/sensor-overview.md)
      - [传感器开发指导](device/sensor-guidelines.md)
    - 振动
      - [振动开发概述](device/vibrator-overview.md)
      - [振动开发指导](device/vibrator-guidelines.md)
    - 升级服务
      - [示例服务器开发概述](device/sample-server-overview.md)
      - [示例服务器开发指导](device/sample-server-guidelines.md)
  - 设备使用信息统计
    - [设备使用信息统计概述](device-usage-statistics/device-usage-statistics-overview.md)
    - [设备使用信息统计开发指导](device-usage-statistics/device-usage-statistics-dev-guide.md)
  - DFX
    - 应用事件打点
      - [应用事件打点概述](dfx/hiappevent-overview.md)
      - [应用事件打点开发指导](dfx/hiappevent-guidelines.md)
    - 性能打点跟踪
      - [性能打点跟踪概述](dfx/hitracemeter-overview.md)
      - [性能打点跟踪开发指导](dfx/hitracemeter-guidelines.md)
    - 分布式跟踪
      - [分布式跟踪概述](dfx/hitracechain-overview.md)
      - [分布式跟踪开发指导](dfx/hitracechain-guidelines.md)
    - 错误管理
      - [错误管理开发指导](dfx/errormanager-guidelines.md)
  - 国际化
    - [国际化开发概述](internationalization/international-overview.md)
    - [Intl开发指导](internationalization/intl-guidelines.md)
    - [I18n开发指导](internationalization/i18n-guidelines.md)
  - 一次开发，多端部署
    - [前言](key-features/multi-device-app-dev/about-this-document.md)
    - [简介](key-features/multi-device-app-dev/introduction.md)
    - 应用UX设计
      - [设计原则和要点](key-features/multi-device-app-dev/design-principles.md)
      - 应用架构设计
        - [应用导航结构设计要求](key-features/multi-device-app-dev/navigation-design.md)
        - [应用页面结构设计](key-features/multi-device-app-dev/page-design.md)
      - 界面布局
        - [概述](key-features/multi-device-app-dev/layout-design-intro.md)
        - 布局基础
          - [栅格系统](key-features/multi-device-app-dev/layout-grid.md)
          - [自适应布局](key-features/multi-device-app-dev/layout-adaptive.md)
          - [响应式布局](key-features/multi-device-app-dev/layout-responsive.md)
        - [布局基础运用案例](key-features/multi-device-app-dev/layout-design-cases.md)
      - 人机交互
        - [交互基础](key-features/multi-device-app-dev/interaction-basics.md)
        - [常见输入方式](key-features/multi-device-app-dev/common-input-modes.md)
        - [交互事件归一](key-features/multi-device-app-dev/design-interaction-events-unification.md)
      - 视觉风格
        - [视觉基础](key-features/multi-device-app-dev/visual-style-basics.md)
        - [色彩](key-features/multi-device-app-dev/visual-style-color.md)
        - [字体](key-features/multi-device-app-dev/visual-style-font.md)
        - [图标](key-features/multi-device-app-dev/visual-style-icon.md)
      - [多态控件](key-features/multi-device-app-dev/design-polymorphic-components.md)
      - [设计自检表](key-features/multi-device-app-dev/design-checklist.md)
      - [资源](key-features/multi-device-app-dev/resource.md)
    - [IDE使用](key-features/multi-device-app-dev/ide-usage.md)
    - 一多能力的页面开发介绍
      - 布局能力
        - [布局能力简介](key-features/multi-device-app-dev/layout-intro.md)
        - 自适应布局
          - [自适应布局简介](key-features/multi-device-app-dev/adaptive-layout-intro.md)
          - [拉伸能力](key-features/multi-device-app-dev/adaptive-layout-stretching.md)
          - [均分能力](key-features/multi-device-app-dev/adaptive-layout-equalization.md)
          - [占比能力](key-features/multi-device-app-dev/adaptive-layout-proportion.md)
          - [缩放能力](key-features/multi-device-app-dev/adaptive-layout-scaling.md)
          - [延伸能力](key-features/multi-device-app-dev/adaptive-layout-extension.md)
          - [隐藏能力](key-features/multi-device-app-dev/adaptive-layout-hiding.md)
          - [折行能力](key-features/multi-device-app-dev/adaptive-layout-wrapping.md)
        - 响应式布局
          - [栅格断点系统](key-features/multi-device-app-dev/grid-breakpoint.md)
          - [媒体查询](key-features/multi-device-app-dev/media-query.md)
          - [典型场景](key-features/multi-device-app-dev/responsive-layout-cases.md)
      - [交互归一](key-features/multi-device-app-dev/interaction-events-unification.md)
      - [多态组件](key-features/multi-device-app-dev/polymorphic-components.md)
      - [资源使用](key-features/multi-device-app-dev/resource-usage.md)
    - [一多能力的功能开发介绍](key-features/multi-device-app-dev/development-intro.md)
    - 案例应用
      - 短信应用
        - [概览](key-features/multi-device-app-dev/sms-intro.md)
        - 会话详情页面
          - [页面结构](key-features/multi-device-app-dev/sms-session-page-structure.md)
          - [顶部标题栏](key-features/multi-device-app-dev/sms-session-page-title-bar.md)
          - [底部输入栏](key-features/multi-device-app-dev/sms-session-page-input-field.md)
          - [信息列表](key-features/multi-device-app-dev/sms-session-page-message-list.md)
          - [组合成型](key-features/multi-device-app-dev/sms-session-page-combined.md)
        - [总结](key-features/multi-device-app-dev/sms-session-summary.md)
      - [桌面应用](key-features/multi-device-app-dev/cases-home-screen.md)
    - [常见问题](key-features/multi-device-app-dev/faqs.md)
  - [IDL工具规格及使用说明书](IDL/idl-guidelines.md)
  - Native API的相关指导
    - [Native API在应用工程中的使用指导](napi/napi-guidelines.md)
    - [Drawing开发指导](napi/drawing-guidelines.md)
    - [Rawfile开发指导](napi/rawfile-guidelines.md)
    - [Window开发指导](napi/native-window-guidelines.md)
- 工具
  - [DevEco Studio（OpenHarmony）使用指南](quick-start/deveco-studio-user-guide-for-openharmony.md)
- 示例教程
  - [示例代码](https://gitee.com/openharmony/app_samples/blob/master/README_zh.md)
  - [Codelabs](https://gitee.com/openharmony/codelabs/blob/master/README.md)
- API参考
  - 组件参考（基于JS扩展的类Web开发范式）
    - 组件通用信息
      - [通用属性](reference/arkui-js/js-components-common-attributes.md)
      - [通用样式](reference/arkui-js/js-components-common-styles.md)
      - [通用事件](reference/arkui-js/js-components-common-events.md)
      - [通用方法](reference/arkui-js/js-components-common-methods.md)
      - [动画样式](reference/arkui-js/js-components-common-animation.md)
      - [渐变样式](reference/arkui-js/js-components-common-gradient.md)
      - [转场样式](reference/arkui-js/js-components-common-transition.md)
      - [媒体查询](reference/arkui-js/js-components-common-mediaquery.md)
      - [自定义字体样式](reference/arkui-js/js-components-common-customizing-font.md)
      - [原子布局](reference/arkui-js/js-components-common-atomic-layout.md)
    - 容器组件
      - [badge](reference/arkui-js/js-components-container-badge.md)
      - [dialog](reference/arkui-js/js-components-container-dialog.md)
      - [div](reference/arkui-js/js-components-container-div.md)
      - [form](reference/arkui-js/js-components-container-form.md)
      - [list](reference/arkui-js/js-components-container-list.md)
      - [list-item](reference/arkui-js/js-components-container-list-item.md)
      - [list-item-group](reference/arkui-js/js-components-container-list-item-group.md)
      - [panel](reference/arkui-js/js-components-container-panel.md)
      - [popup](reference/arkui-js/js-components-container-popup.md)
      - [refresh](reference/arkui-js/js-components-container-refresh.md)
      - [stack](reference/arkui-js/js-components-container-stack.md)
      - [stepper](reference/arkui-js/js-components-container-stepper.md)
      - [stepper-item](reference/arkui-js/js-components-container-stepper-item.md)
      - [swiper](reference/arkui-js/js-components-container-swiper.md)
      - [tabs](reference/arkui-js/js-components-container-tabs.md)
      - [tab-bar](reference/arkui-js/js-components-container-tab-bar.md)
      - [tab-content](reference/arkui-js/js-components-container-tab-content.md)
    - 基础组件
      - [button](reference/arkui-js/js-components-basic-button.md)
      - [chart](reference/arkui-js/js-components-basic-chart.md)
      - [divider](reference/arkui-js/js-components-basic-divider.md)
      - [image](reference/arkui-js/js-components-basic-image.md)
      - [image-animator](reference/arkui-js/js-components-basic-image-animator.md)
      - [input](reference/arkui-js/js-components-basic-input.md)
      - [label](reference/arkui-js/js-components-basic-label.md)
      - [marquee](reference/arkui-js/js-components-basic-marquee.md)
      - [menu](reference/arkui-js/js-components-basic-menu.md)
      - [option](reference/arkui-js/js-components-basic-option.md)
      - [picker](reference/arkui-js/js-components-basic-picker.md)
      - [picker-view](reference/arkui-js/js-components-basic-picker-view.md)
      - [piece](reference/arkui-js/js-components-basic-piece.md)
      - [progress](reference/arkui-js/js-components-basic-progress.md)
      - [qrcode](reference/arkui-js/js-components-basic-qrcode.md)
      - [rating](reference/arkui-js/js-components-basic-rating.md)
      - [richtext](reference/arkui-js/js-components-basic-richtext.md)
      - [search](reference/arkui-js/js-components-basic-search.md)
      - [select](reference/arkui-js/js-components-basic-select.md)
      - [slider](reference/arkui-js/js-components-basic-slider.md)
      - [span](reference/arkui-js/js-components-basic-span.md)
      - [switch](reference/arkui-js/js-components-basic-switch.md)
      - [text](reference/arkui-js/js-components-basic-text.md)
      - [textarea](reference/arkui-js/js-components-basic-textarea.md)
      - [toolbar](reference/arkui-js/js-components-basic-toolbar.md)
      - [toolbar-item](reference/arkui-js/js-components-basic-toolbar-item.md)
      - [toggle](reference/arkui-js/js-components-basic-toggle.md)
      - [web](reference/arkui-js/js-components-basic-web.md)
      - [xcomponent](reference/arkui-js/js-components-basic-xcomponent.md)
    - 媒体组件
      - [video](reference/arkui-js/js-components-media-video.md)
    - 画布组件
      - [canvas组件](reference/arkui-js/js-components-canvas-canvas.md)
      - [CanvasRenderingContext2D对象](reference/arkui-js/js-components-canvas-canvasrenderingcontext2d.md)
      - [Image对象](reference/arkui-js/js-components-canvas-image.md)
      - [CanvasGradient对象](reference/arkui-js/js-components-canvas-canvasgradient.md)
      - [ImageData对象](reference/arkui-js/js-components-canvas-imagedata.md)
      - [Path2D对象](reference/arkui-js/js-components-canvas-path2d.md)
      - [ImageBitmap对象](reference/arkui-js/js-components-canvas-imagebitmap.md)
      - [OffscreenCanvas对象](reference/arkui-js/js-components-canvas-offscreencanvas.md)
      - [OffscreenCanvasRenderingContext2D对象](reference/arkui-js/js-offscreencanvasrenderingcontext2d.md)
    - 栅格组件
      - [基本概念](reference/arkui-js/js-components-grid-basic-concepts.md)
      - [grid-container](reference/arkui-js/js-components-grid-container.md)
      - [grid-row](reference/arkui-js/js-components-grid-row.md)
      - [grid-col](reference/arkui-js/js-components-grid-col.md)
    - svg组件
      - [通用属性](reference/arkui-js/js-components-svg-common-attributes.md)
      - [svg](reference/arkui-js/js-components-svg.md)
      - [rect](reference/arkui-js/js-components-svg-rect.md)
      - [circle](reference/arkui-js/js-components-svg-circle.md)
      - [ellipse](reference/arkui-js/js-components-svg-ellipse.md)
      - [path](reference/arkui-js/js-components-svg-path.md)
      - [line](reference/arkui-js/js-components-svg-line.md)
      - [polyline](reference/arkui-js/js-components-svg-polyline.md)
      - [polygon](reference/arkui-js/js-components-svg-polygon.md)
      - [text](reference/arkui-js/js-components-svg-text.md)
      - [tspan](reference/arkui-js/js-components-svg-tspan.md)
      - [textPath](reference/arkui-js/js-components-svg-textpath.md)
      - [animate](reference/arkui-js/js-components-svg-animate.md)
      - [animateMotion](reference/arkui-js/js-components-svg-animatemotion.md)
      - [animateTransform](reference/arkui-js/js-components-svg-animatetransform.md)
    - 自定义组件
      - [基本用法](reference/arkui-js/js-components-custom-basic-usage.md)
      - [继承样式](reference/arkui-js/js-components-custom-style.md)
      - [自定义事件](reference/arkui-js/js-components-custom-events.md)
      - [Props](reference/arkui-js/js-components-custom-props.md)
      - [事件参数](reference/arkui-js/js-components-custom-event-parameter.md)
      - [slot插槽](reference/arkui-js/js-components-custom-slot.md)
      - [生命周期定义](reference/arkui-js/js-components-custom-lifecycle.md)
    - [数据类型说明](reference/arkui-js/js-appendix-types.md)
  - 组件参考（基于TS扩展的声明式开发范式）
    - 组件通用信息
      - 通用事件
        - [点击事件](reference/arkui-ts/ts-universal-events-click.md)
        - [触摸事件](reference/arkui-ts/ts-universal-events-touch.md)
        - [挂载卸载事件](reference/arkui-ts/ts-universal-events-show-hide.md)
        - [拖拽事件](reference/arkui-ts/ts-universal-events-drag-drop.md)
        - [按键事件](reference/arkui-ts/ts-universal-events-key.md)
        - [焦点事件](reference/arkui-ts/ts-universal-focus-event.md)
        - [鼠标事件](reference/arkui-ts/ts-universal-mouse-key.md)
        - [组件区域变化事件](reference/arkui-ts/ts-universal-component-area-change-event.md)
        - [组件可见区域变化事件](reference/arkui-ts/ts-universal-component-visible-area-change-event.md)
      - 通用属性
        - [尺寸设置](reference/arkui-ts/ts-universal-attributes-size.md)
        - [位置设置](reference/arkui-ts/ts-universal-attributes-location.md)
        - [布局约束](reference/arkui-ts/ts-universal-attributes-layout-constraints.md)
        - [Flex布局](reference/arkui-ts/ts-universal-attributes-flex-layout.md)
        - [边框设置](reference/arkui-ts/ts-universal-attributes-border.md)
        - [图片边框设置](reference/arkui-ts/ts-universal-attributes-border-image.md)
        - [背景设置](reference/arkui-ts/ts-universal-attributes-background.md)
        - [透明度设置](reference/arkui-ts/ts-universal-attributes-opacity.md)
        - [显隐控制](reference/arkui-ts/ts-universal-attributes-visibility.md)
        - [禁用控制](reference/arkui-ts/ts-universal-attributes-enable.md)
        - [浮层](reference/arkui-ts/ts-universal-attributes-overlay.md)
        - [Z序控制](reference/arkui-ts/ts-universal-attributes-z-order.md)
        - [图形变换](reference/arkui-ts/ts-universal-attributes-transformation.md)
        - [图像效果](reference/arkui-ts/ts-universal-attributes-image-effect.md)
        - [形状裁剪](reference/arkui-ts/ts-universal-attributes-sharp-clipping.md)
        - [文本样式设置](reference/arkui-ts/ts-universal-attributes-text-style.md)
        - [栅格设置](reference/arkui-ts/ts-universal-attributes-grid.md)
        - [颜色渐变](reference/arkui-ts/ts-universal-attributes-gradient-color.md)
        - [Popup控制](reference/arkui-ts/ts-universal-attributes-popup.md)
        - [Menu控制](reference/arkui-ts/ts-universal-attributes-menu.md)
        - [点击控制](reference/arkui-ts/ts-universal-attributes-click.md)
        - [焦点控制](reference/arkui-ts/ts-universal-attributes-focus.md)
        - [悬浮态效果](reference/arkui-ts/ts-universal-attributes-hover-effect.md)
        - [组件标识](reference/arkui-ts/ts-universal-attributes-component-id.md)
        - [触摸热区设置](reference/arkui-ts/ts-universal-attributes-touch-target.md)
        - [多态样式](reference/arkui-ts/ts-universal-attributes-polymorphic-style.md)
      - 手势处理
        - [绑定手势方法](reference/arkui-ts/ts-gesture-settings.md)
        - 基础手势
          - [TapGesture](reference/arkui-ts/ts-basic-gestures-tapgesture.md)
          - [LongPressGesture](reference/arkui-ts/ts-basic-gestures-longpressgesture.md)
          - [PanGesture](reference/arkui-ts/ts-basic-gestures-pangesture.md)
          - [PinchGesture](reference/arkui-ts/ts-basic-gestures-pinchgesture.md)
          - [RotationGesture](reference/arkui-ts/ts-basic-gestures-rotationgesture.md)
          - [SwipeGesture](reference/arkui-ts/ts-basic-gestures-swipegesture.md)
        - [组合手势](reference/arkui-ts/ts-combined-gestures.md)
    - 基础组件
      - [Blank](reference/arkui-ts/ts-basic-components-blank.md)
      - [Button](reference/arkui-ts/ts-basic-components-button.md)
      - [Checkbox](reference/arkui-ts/ts-basic-components-checkbox.md)
      - [CheckboxGroup](reference/arkui-ts/ts-basic-components-checkboxgroup.md)
      - [DataPanel](reference/arkui-ts/ts-basic-components-datapanel.md)
      - [DatePicker](reference/arkui-ts/ts-basic-components-datepicker.md)
      - [Divider](reference/arkui-ts/ts-basic-components-divider.md)
      - [Gauge](reference/arkui-ts/ts-basic-components-gauge.md)
      - [Image](reference/arkui-ts/ts-basic-components-image.md)
      - [ImageAnimator](reference/arkui-ts/ts-basic-components-imageanimator.md)
      - [LoadingProgress](reference/arkui-ts/ts-basic-components-loadingprogress.md)
      - [Marquee](reference/arkui-ts/ts-basic-components-marquee.md)
      - [Navigation](reference/arkui-ts/ts-basic-components-navigation.md)
      - [PatternLock](reference/arkui-ts/ts-basic-components-patternlock.md)
      - [PluginComponent](reference/arkui-ts/ts-basic-components-plugincomponent.md)
      - [Progress](reference/arkui-ts/ts-basic-components-progress.md)
      - [QRCode](reference/arkui-ts/ts-basic-components-qrcode.md)
      - [Radio](reference/arkui-ts/ts-basic-components-radio.md)
      - [Rating](reference/arkui-ts/ts-basic-components-rating.md)
      - [RemoteWindow](reference/arkui-ts/ts-basic-components-remotewindow.md)
      - [RichText](reference/arkui-ts/ts-basic-components-richtext.md)
      - [ScrollBar](reference/arkui-ts/ts-basic-components-scrollbar.md)
      - [Search](reference/arkui-ts/ts-basic-components-search.md)
      - [Select](reference/arkui-ts/ts-basic-components-select.md)
      - [Slider](reference/arkui-ts/ts-basic-components-slider.md)
      - [Span](reference/arkui-ts/ts-basic-components-span.md)
      - [Stepper](reference/arkui-ts/ts-basic-components-stepper.md)
      - [StepperItem](reference/arkui-ts/ts-basic-components-stepperitem.md)
      - [Text](reference/arkui-ts/ts-basic-components-text.md)
      - [TextArea](reference/arkui-ts/ts-basic-components-textarea.md)
      - [TextClock](reference/arkui-ts/ts-basic-components-textclock.md)
      - [TextInput](reference/arkui-ts/ts-basic-components-textinput.md)
      - [TextPicker](reference/arkui-ts/ts-basic-components-textpicker.md)
      - [TextTimer](reference/arkui-ts/ts-basic-components-texttimer.md)
      - [TimePicker](reference/arkui-ts/ts-basic-components-timepicker.md)
      - [Toggle](reference/arkui-ts/ts-basic-components-toggle.md)
      - [Web](reference/arkui-ts/ts-basic-components-web.md)
      - [XComponent](reference/arkui-ts/ts-basic-components-xcomponent.md)
    - 容器组件
      - [AbilityComponent](reference/arkui-ts/ts-container-ability-component.md)
      - [AlphabetIndexer](reference/arkui-ts/ts-container-alphabet-indexer.md)
      - [Badge](reference/arkui-ts/ts-container-badge.md)
      - [Column](reference/arkui-ts/ts-container-column.md)
      - [ColumnSplit](reference/arkui-ts/ts-container-columnsplit.md)
      - [Counter](reference/arkui-ts/ts-container-counter.md)
      - [Flex](reference/arkui-ts/ts-container-flex.md)
      - [GridContainer](reference/arkui-ts/ts-container-gridcontainer.md)
      - [Grid](reference/arkui-ts/ts-container-grid.md)
      - [GridItem](reference/arkui-ts/ts-container-griditem.md)
      - [List](reference/arkui-ts/ts-container-list.md)
      - [ListItem](reference/arkui-ts/ts-container-listitem.md)
      - [Navigator](reference/arkui-ts/ts-container-navigator.md)
      - [Panel](reference/arkui-ts/ts-container-panel.md)
      - [Refresh](reference/arkui-ts/ts-container-refresh.md)
      - [RelativeContainer](reference/arkui-ts/ts-container-relativecontainer.md)
      - [Row](reference/arkui-ts/ts-container-row.md)
      - [RowSplit](reference/arkui-ts/ts-container-rowsplit.md)
      - [Scroll](reference/arkui-ts/ts-container-scroll.md)
      - [SideBarContainer](reference/arkui-ts/ts-container-sidebarcontainer.md)
      - [Stack](reference/arkui-ts/ts-container-stack.md)
      - [Swiper](reference/arkui-ts/ts-container-swiper.md)
      - [Tabs](reference/arkui-ts/ts-container-tabs.md)
      - [TabContent](reference/arkui-ts/ts-container-tabcontent.md)
    - 媒体组件
      - [Video](reference/arkui-ts/ts-media-components-video.md)
    - 绘制组件
      - [Circle](reference/arkui-ts/ts-drawing-components-circle.md)
      - [Ellipse](reference/arkui-ts/ts-drawing-components-ellipse.md)
      - [Line](reference/arkui-ts/ts-drawing-components-line.md)
      - [Polyline](reference/arkui-ts/ts-drawing-components-polyline.md)
      - [Polygon](reference/arkui-ts/ts-drawing-components-polygon.md)
      - [Path](reference/arkui-ts/ts-drawing-components-path.md)
      - [Rect](reference/arkui-ts/ts-drawing-components-rect.md)
      - [Shape](reference/arkui-ts/ts-drawing-components-shape.md)
    - 画布组件
      - [Canvas](reference/arkui-ts/ts-components-canvas-canvas.md)
      - [CanvasRenderingContext2D对象](reference/arkui-ts/ts-canvasrenderingcontext2d.md)
      - [OffscreenCanvasRenderingConxt2D对象](reference/arkui-ts/ts-offscreencanvasrenderingcontext2d.md)
      - [Lottie](reference/arkui-ts/ts-components-canvas-lottie.md)
      - [Path2D对象](reference/arkui-ts/ts-components-canvas-path2d.md)
      - [CanvasGradient对象](reference/arkui-ts/ts-components-canvas-canvasgradient.md)
      - [ImageBitmap对象](reference/arkui-ts/ts-components-canvas-imagebitmap.md)
      - [ImageData对象](reference/arkui-ts/ts-components-canvas-imagedata.md)
    - 动画
      - [属性动画](reference/arkui-ts/ts-animatorproperty.md)
      - [显式动画](reference/arkui-ts/ts-explicit-animation.md)
      - 转场动画
        - [页面间转场](reference/arkui-ts/ts-page-transition-animation.md)
        - [组件内转场](reference/arkui-ts/ts-transition-animation-component.md)
        - [共享元素转场](reference/arkui-ts/ts-transition-animation-shared-elements.md)
      - [路径动画](reference/arkui-ts/ts-motion-path-animation.md)
      - [矩阵变换](reference/arkui-ts/ts-matrix-transformation.md)
      - [插值计算](reference/arkui-ts/ts-interpolation-calculation.md)
    - 全局UI方法
      - 弹窗
        - [警告弹窗](reference/arkui-ts/ts-methods-alert-dialog-box.md)
        - [列表选择弹窗](reference/arkui-ts/ts-methods-action-sheet.md)
        - [自定义弹窗](reference/arkui-ts/ts-methods-custom-dialog-box.md)
        - [日期选择弹窗](reference/arkui-ts/ts-methods-datepicker-dialog.md)
        - [时间选择弹窗](reference/arkui-ts/ts-methods-timepicker-dialog.md)
        - [文本选择弹窗](reference/arkui-ts/ts-methods-textpicker-dialog.md)
      - [菜单](reference/arkui-ts/ts-methods-menu.md)
    - [文档中涉及到的内置枚举值](reference/arkui-ts/ts-appendix-enums.md)
  - 接口参考（JS及TS API）
    - [开发说明](reference/apis/development-intro.md)
    - Ability框架
      - FA模型
        - [@ohos.ability.featureAbility (FeatureAbility模块)](reference/apis/js-apis-featureAbility.md)
        - [@ohos.ability.particleAbility (particleAbility模块)](reference/apis/js-apis-particleAbility.md)
        - [dataAbilityHelper (DataAbilityHelper模块)](reference/apis/js-apis-dataAbilityHelper.md)
        - [context (Context模块)](reference/apis/js-apis-Context.md)
      - Stage模型
        - [@ohos.application.Ability (Ability)](reference/apis/js-apis-application-ability.md)
        - [@ohos.application.AbilityConstant (AbilityConstant)](reference/apis/js-apis-application-abilityConstant.md)
        - [@ohos.application.AbilityStage (AbilityStage)](reference/apis/js-apis-application-abilitystage.md)
        - [@ohos.application.abilityLifecycleCallback (AbilityLifecycleCallback)](reference/apis/js-apis-application-abilityLifecycleCallback.md)
        - [@ohos.application.DataShareExtensionAbility (数据共享扩展能力)](reference/apis/js-apis-application-DataShareExtensionAbility.md)
        - [@ohos.application.FormExtension (FormExtension)](reference/apis/js-apis-formextension.md)
        - [@ohos.application.ServiceExtensionAbility (ServiceExtensionAbility)](reference/apis/js-apis-service-extension-ability.md)
        - [@ohos.application.StartOptions (StartOptions)](reference/apis/js-apis-application-StartOptions.md)
        - [@ohos.application.StaticSubscriberExtensionAbility (StaticSubscriberExtensionAbility)](reference/apis/js-apis-application-staticSubscriberExtensionAbility.md)
        - [@ohos.application.WindowExtensionAbility (窗口扩展能力)](reference/apis/js-apis-application-WindowExtensionAbility.md)
        - [AbilityContext (AbilityContext)](reference/apis/js-apis-ability-context.md)
        - [ApplicationContext (ApplicationContext)](reference/apis/js-apis-application-applicationContext.md)
        - [AbilityStageContext (AbilityStageContext)](reference/apis/js-apis-abilitystagecontext.md)
        - [Context (Context)](reference/apis/js-apis-application-context.md)
        - [ExtensionContext (ExtensionContext)](reference/apis/js-apis-extension-context.md)
        - [FormExtensionContext (FormExtensionContext)](reference/apis/js-apis-formextensioncontext.md)
        - [PermissionRequestResult (PermissionRequestResult)](reference/apis/js-apis-permissionrequestresult.md)
        - [ServiceExtensionContext (ServiceExtensionContext)](reference/apis/js-apis-service-extension-context.md)
      - 通用
        - [@ohos.ability.dataUriUtils (DataUriUtils模块)](reference/apis/js-apis-DataUriUtils.md)
        - [@ohos.ability.errorCode (ErrorCode)](reference/apis/js-apis-ability-errorCode.md)
        - [@ohos.ability.wantConstant (wantConstant)](reference/apis/js-apis-ability-wantConstant.md)
        - [@ohos.application.abilityDelegatorRegistry (AbilityDelegatorRegistry)](reference/apis/js-apis-abilityDelegatorRegistry.md)
        - [@ohos.application.abilityManager (AbilityManager)](reference/apis/js-apis-application-abilityManager.md)
        - [@ohos.application.AccessibilityExtensionAbility (AccessibilityExtensionContext)](reference/apis/js-apis-accessibility-extension-context.md)
        - [@ohos.application.AccessibilityExtensionAbility (辅助功能扩展能力)](reference/apis/js-apis-application-AccessibilityExtensionAbility.md)
        - [@ohos.application.appManager (appManager)](reference/apis/js-apis-appmanager.md)
        - [@ohos.application.Configuration (Configuration)](reference/apis/js-apis-configuration.md)
        - [@ohos.application.ConfigurationConstant (ConfigurationConstant)](reference/apis/js-apis-configurationconstant.md)
        - [@ohos.application.EnvironmentCallback (EnvironmentCallback)](reference/apis/js-apis-application-EnvironmentCallback.md)
        - [@ohos.application.errorManager (ErrorManager)](reference/apis/js-apis-errorManager.md)
        - [@ohos.application.formBindingData (卡片数据绑定类)](reference/apis/js-apis-formbindingdata.md)
        - [@ohos.application.formError (FormError)](reference/apis/js-apis-formerror.md)
        - [@ohos.application.formHost (FormHost)](reference/apis/js-apis-formhost.md)
        - [@ohos.application.formInfo (FormInfo)](reference/apis/js-apis-formInfo.md)
        - [@ohos.application.formProvider (FormProvider)](reference/apis/js-apis-formprovider.md)
        - [@ohos.application.missionManager (missionManager)](reference/apis/js-apis-missionManager.md)
        - [@ohos.application.Want (Want)](reference/apis/js-apis-application-Want.md)
        - [@ohos.continuation.continuationManager (ContinuationExtraParams)](reference/apis/js-apis-continuation-continuationExtraParams.md)
        - [@ohos.continuation.continuationManager (continuationManager)](reference/apis/js-apis-continuation-continuationManager.md)
        - [@ohos.wantAgent (WantAgent模块)](reference/apis/js-apis-wantAgent.md)
        - [abilityDelegator (AbilityDelegator)](reference/apis/js-apis-application-abilityDelegator.md)
        - [abilityDelegatorArgs (AbilityDelegatorArgs)](reference/apis/js-apis-application-abilityDelegatorArgs.md)
        - [abilityMonitor (AbilityMonitor)](reference/apis/js-apis-application-abilityMonitor.md)
        - [AbilityRunningInfo (AbilityRunningInfo)](reference/apis/js-apis-abilityrunninginfo.md)
        - [ExtensionRunningInfo (ExtensionRunningInfo)](reference/apis/js-apis-extensionrunninginfo.md)
        - [MissionSnapshot (MissionSnapshot)](reference/apis/js-apis-application-MissionSnapshot.md)
        - [ProcessRunningInfo (ProcessRunningInfo)](reference/apis/js-apis-processrunninginfo.md)
        - [shellCmdResult (ShellCmdResult)](reference/apis/js-apis-application-shellCmdResult.md)
        - [ContinuationResult (ContinuationResult)](reference/apis/js-apis-continuation-continuationResult.md)
    - 公共事件与通知
      - [@ohos.commonEvent (公共事件模块)](reference/apis/js-apis-commonEvent.md)
      - [@ohos.events.emitter (Emitter)](reference/apis/js-apis-emitter.md)
      - [@ohos.notification (Notification模块)](reference/apis/js-apis-notification.md)
      - [@ohos.reminderAgent (后台代理提醒)](reference/apis/js-apis-reminderAgent.md)
      - [EventHub (EventHub)](reference/apis/js-apis-eventhub.md)
    - 应用程序包管理
      - [@ohos.bundle (Bundle模块)](reference/apis/js-apis-Bundle.md)
      - [@ohos.bundle.defaultAppManager (Bundle模块)](reference/apis/js-apis-bundle-defaultAppManager.md)
      - [@ohos.bundle.innerBundleManager (innerBundleManager模块(JS端SDK接口))](reference/apis/js-apis-Bundle-InnerBundleManager.md)
      - [@ohos.bundleState (设备使用信息统计)](reference/apis/js-apis-deviceUsageStatistics.md)
      - [@ohos.distributedBundle (distributedBundle模块(JS端SDK接口))](reference/apis/js-apis-Bundle-distributedBundle.md)
      - [@ohos.zlib (Zip模块)](reference/apis/js-apis-zlib.md)
      - [AbilityInfo (AbilityInfo)](reference/apis/js-apis-bundle-AbilityInfo.md)
      - [ApplicationInfo (ApplicationInfo)](reference/apis/js-apis-bundle-ApplicationInfo.md)
      - [BundleInfo (BundleInfo)](reference/apis/js-apis-bundle-BundleInfo.md)
      - [BundleInstaller (BundleInstaller)](reference/apis/js-apis-bundle-BundleInstaller.md)
      - [CustomizeData (CustomizeData)](reference/apis/js-apis-bundle-CustomizeData.md)
      - [DispatchInfo (DispatchInfo)](reference/apis/js-apis-dispatchInfo.md)
      - [ElementName (ElementName)](reference/apis/js-apis-bundle-ElementName.md)
      - [ExtensionAbilityInfo (ExtensionAbilityInfo)](reference/apis/js-apis-bundle-ExtensionAbilityInfo.md)
      - [HapModuleInfo (HapModuleInfo)](reference/apis/js-apis-bundle-HapModuleInfo.md)
      - [LauncherAbilityInfo (LauncherAbilityInfo)](reference/apis/js-apis-bundle-LauncherAbilityInfo.md)
      - [Metadata (Metadata)](reference/apis/js-apis-bundle-Metadata.md)
      - [ModuleInfo (ModuleInfo)](reference/apis/js-apis-bundle-ModuleInfo.md)
      - [PermissionDef (PermissionDef)](reference/apis/js-apis-bundle-PermissionDef.md)
      - [RemoteAbilityInfo (RemoteAbilityInfo)](reference/apis/js-apis-bundle-remoteAbilityInfo.md)
      - [ShortcutInfo (ShortcutInfo)](reference/apis/js-apis-bundle-ShortcutInfo.md)
    - UI界面
      - [@ohos.animator (动画)](reference/apis/js-apis-animator.md)
      - [@ohos.mediaquery (媒体查询)](reference/apis/js-apis-mediaquery.md)
      - [@ohos.prompt (弹窗)](reference/apis/js-apis-prompt.md)
      - [@ohos.router (页面路由)](reference/apis/js-apis-router.md)
      - [@ohos.uiAppearance(用户界面外观)](reference/apis/js-apis-uiappearance.md)
    - 图形图像
      - [@ohos.animation.windowAnimationManager (窗口动画管理)](reference/apis/js-apis-windowAnimationManager.md)
      - [@ohos.display (屏幕属性)](reference/apis/js-apis-display.md)
      - [@ohos.effectKit (图像效果)](reference/apis/js-apis-effectKit.md)
      - [@ohos.screen (屏幕)](reference/apis/js-apis-screen.md)
      - [@ohos.screenshot (屏幕截图)](reference/apis/js-apis-screenshot.md)
      - [@ohos.window (窗口)](reference/apis/js-apis-window.md)
      - [webgl (WebGL)](reference/apis/js-apis-webgl.md)
      - [webgl2 (WebGL2)](reference/apis/js-apis-webgl2.md)
    - 媒体
      - [@ohos.multimedia.audio (音频管理)](reference/apis/js-apis-audio.md)
      - [@ohos.multimedia.camera (相机管理)](reference/apis/js-apis-camera.md)
      - [@ohos.multimedia.image (图片处理)](reference/apis/js-apis-image.md)
      - [@ohos.multimedia.media (媒体服务)](reference/apis/js-apis-media.md)
      - [@ohos.multimedia.medialibrary (媒体库管理)](reference/apis/js-apis-medialibrary.md)
    - 资源管理
      - [@ohos.i18n (国际化-I18n)](reference/apis/js-apis-i18n.md)
      - [@ohos.intl (国际化-Intl)](reference/apis/js-apis-intl.md)
      - [@ohos.resourceManager (资源管理)](reference/apis/js-apis-resource-manager.md)
    - 资源调度
      - [@ohos.backgroundTaskManager (后台任务管理)](reference/apis/js-apis-backgroundTaskManager.md)
      - [@ohos.distributedMissionManager (distributedMissionManager)](reference/apis/js-apis-distributedMissionManager.md)
      - [@ohos.workScheduler (延迟任务调度)](reference/apis/js-apis-workScheduler.md)
      - [@ohos.WorkSchedulerExtensionAbility (延迟任务调度回调)](reference/apis/js-apis-WorkSchedulerExtensionAbility.md)
    - 定制管理
      - [@ohos.configPolicy (配置策略)](reference/apis/js-apis-config-policy.md)
      - [@ohos.enterpriseDeviceManager (企业设备管理)](reference/apis/js-apis-enterprise-device-manager.md)
      - [@ohos.EnterpriseAdminExtensionAbility (EnterpriseAdminExtensionAbility)](reference/apis/js-apis-EnterpriseAdminExtensionAbility.md)
    - 安全
      - [@ohos.abilityAccessCtrl (访问控制管理)](reference/apis/js-apis-abilityAccessCtrl.md)
      - [@ohos.privacyManager (隐私管理)](reference/apis/js-apis-privacyManager.md)
      - [@ohos.security.huks (通用密钥库系统)](reference/apis/js-apis-huks.md)
      - [@ohos.userIAM.userAuth (用户认证)](reference/apis/js-apis-useriam-userauth.md)
      - [@system.cipher (加密算法)](reference/apis/js-apis-system-cipher.md)
    - 数据管理
      - [@ohos.data.dataAbility (DataAbility谓词)](reference/apis/js-apis-data-ability.md)
      - [@ohos.data.dataShare (数据共享)](reference/apis/js-apis-data-dataShare.md)
      - [@ohos.data.dataSharePredicates (数据共享谓词)](reference/apis/js-apis-data-dataSharePredicates.md)
      - [@ohos.data.dataShareResultSet (数据共享结果集)](reference/apis/js-apis-data-DataShareResultSet.md)
      - [@ohos.data.distributedData (分布式数据管理)](reference/apis/js-apis-distributed-data.md)
      - [@ohos.data.distributedDataObject (分布式数据对象)](reference/apis/js-apis-data-distributedobject.md)
      - [@ohos.data.preferences (首选项)](reference/apis/js-apis-data-preferences.md)
      - [@ohos.data.rdb (关系型数据库)](reference/apis/js-apis-data-rdb.md)
      - [@ohos.data.ValuesBucket (数据集)](reference/apis/js-apis-data-ValuesBucket.md)
      - [resultSet (结果集)](reference/apis/js-apis-data-resultset.md)
    - 文件管理
      - [@ohos.document (文件交互)](reference/apis/js-apis-document.md)
      - [@ohos.environment (目录环境能力)](reference/apis/js-apis-environment.md)
      - [@ohos.fileio (文件管理)](reference/apis/js-apis-fileio.md)
      - [@ohos.fileManager (公共文件访问与管理)](reference/apis/js-apis-filemanager.md)
      - [@ohos.statfs (statfs)](reference/apis/js-apis-statfs.md)
      - [@ohos.storageStatistics (应用空间统计)](reference/apis/js-apis-storage-statistics.md)
      - [@ohos.volumeManager (卷管理)](reference/apis/js-apis-volumemanager.md)
      - [@ohos.securityLabel (数据标签)](reference/apis/js-apis-securityLabel.md)
    - 电话服务
      - [@ohos.contact (联系人)](reference/apis/js-apis-contact.md)
      - [@ohos.telephony.call (拨打电话)](reference/apis/js-apis-call.md)
      - [@ohos.telephony.observer (observer)](reference/apis/js-apis-observer.md)
      - [@ohos.telephony.radio (网络搜索)](reference/apis/js-apis-radio.md)
      - [@ohos.telephony.sim (SIM卡管理)](reference/apis/js-apis-sim.md)
      - [@ohos.telephony.sms (短信服务)](reference/apis/js-apis-sms.md)
      - [@ohos.telephony.data (蜂窝数据)](reference/apis/js-apis-telephony-data.md)
    - 网络管理
      - [@ohos.net.connection (网络连接管理)](reference/apis/js-apis-net-connection.md)
      - [@ohos.net.http (数据请求)](reference/apis/js-apis-http.md)
      - [@ohos.request (上传下载)](reference/apis/js-apis-request.md)
      - [@ohos.net.socket (Socket连接)](reference/apis/js-apis-socket.md)
      - [@ohos.net.webSocket (WebSocket连接)](reference/apis/js-apis-webSocket.md)
    - 通信与连接
      - [@ohos.bluetooth (蓝牙)](reference/apis/js-apis-bluetooth.md)
      - [@ohos.connectedTag (有源标签)](reference/apis/js-apis-connectedTag.md)
      - [@ohos.nfc.cardEmulation (标准NFC-cardEmulation)](reference/apis/js-apis-cardEmulation.md)
      - [@ohos.nfc.controller (标准NFC)](reference/apis/js-apis-nfcController.md)
      - [@ohos.nfc.tag (标准NFC-Tag)](reference/apis/js-apis-nfcTag.md)
      - [@ohos.rpc (RPC通信)](reference/apis/js-apis-rpc.md)
      - [@ohos.wifi (WLAN)](reference/apis/js-apis-wifi.md)
      - [@ohos.wifiext (WLAN)](reference/apis/js-apis-wifiext.md)
    - 系统基础能力
      - [@ohos.accessibility (辅助功能)](reference/apis/js-apis-accessibility.md)
      - [@ohos.faultLogger (故障日志获取)](reference/apis/js-apis-faultLogger.md)
      - [@ohos.hiAppEvent (应用打点)](reference/apis/js-apis-hiappevent.md)
      - [@ohos.hichecker (检测模式)](reference/apis/js-apis-hichecker.md)
      - [@ohos.hidebug (Debug调试)](reference/apis/js-apis-hidebug.md)
      - [@ohos.hilog (日志打印)](reference/apis/js-apis-hilog.md)
      - [@ohos.hiSysEvent (系统事件打点)](reference/apis/js-apis-hisysevent.md)
      - [@ohos.hiTraceChain (分布式跟踪)](reference/apis/js-apis-hitracechain.md)
      - [@ohos.hiTraceMeter (性能打点)](reference/apis/js-apis-hitracemeter.md)
      - [@ohos.inputMethod (输入法框架)](reference/apis/js-apis-inputmethod.md)
      - [@ohos.inputMethodEngine (输入法服务)](reference/apis/js-apis-inputmethodengine.md)
      - [@ohos.pasteboard (剪贴板)](reference/apis/js-apis-pasteboard.md)
      - [@ohos.screenLock (锁屏管理)](reference/apis/js-apis-screen-lock.md)
      - [@ohos.systemTime (设置系统时间)](reference/apis/js-apis-system-time.md)
      - [@ohos.wallpaper (壁纸)](reference/apis/js-apis-wallpaper.md)
      - [Timer (定时器)](reference/apis/js-apis-timer.md)
    - 设备管理
      - [@ohos.batteryInfo (电量信息)](reference/apis/js-apis-battery-info.md)
      - [@ohos.brightness (屏幕亮度)](reference/apis/js-apis-brightness.md)
      - [@ohos.deviceInfo (设备信息)](reference/apis/js-apis-device-info.md)
      - [@ohos.distributedHardware.deviceManager (设备管理)](reference/apis/js-apis-device-manager.md)
      - [@ohos.geolocation (位置服务)](reference/apis/js-apis-geolocation.md)
      - [@ohos.multimodalInput.inputConsumer (组合按键)](reference/apis/js-apis-inputconsumer.md)
      - [@ohos.multimodalInput.inputDevice (输入设备)](reference/apis/js-apis-inputdevice.md)
      - [@ohos.multimodalInput.inputEvent (输入事件)](reference/apis/js-apis-inputevent.md)
      - [@ohos.multimodalInput.inputEventClient (注入按键)](reference/apis/js-apis-inputeventclient.md)
      - [@ohos.multimodalInput.inputMonitor (输入监听)](reference/apis/js-apis-inputmonitor.md)
      - [@ohos.multimodalInput.keyCode (键值)](reference/apis/js-apis-keycode.md)
      - [@ohos.multimodalInput.keyEvent (按键输入事件)](reference/apis/js-apis-keyevent.md)
      - [@ohos.multimodalInput.mouseEvent (鼠标输入事件)](reference/apis/js-apis-mouseevent.md)
      - [@ohos.multimodalInput.touchEvent (触摸输入事件)](reference/apis/js-apis-touchevent.md)
      - [@ohos.power (系统电源管理)](reference/apis/js-apis-power.md)
      - [@ohos.runningLock (Runninglock锁)](reference/apis/js-apis-runninglock.md)
      - [@ohos.sensor (传感器)](reference/apis/js-apis-sensor.md)
      - [@ohos.settings (设置数据项名称)](reference/apis/js-apis-settings.md)
      - [@ohos.systemParameter (系统属性)](reference/apis/js-apis-system-parameter.md)
      - [@ohos.thermal (热管理)](reference/apis/js-apis-thermal.md)
      - [@ohos.update (升级)](reference/apis/js-apis-update.md)
      - [@ohos.usb (USB管理)](reference/apis/js-apis-usb.md)
      - [@ohos.vibrator (振动)](reference/apis/js-apis-vibrator.md)
    - 帐号管理
      - [@ohos.account.appAccount (应用帐号管理)](reference/apis/js-apis-appAccount.md)
      - [@ohos.account.distributedAccount (分布式帐号管理)](reference/apis/js-apis-distributed-account.md)
      - [@ohos.account.osAccount (系统帐号管理)](reference/apis/js-apis-osAccount.md)
    - 语言基础类库
      - [@ohos.convertxml (xml转换JavaScript)](reference/apis/js-apis-convertxml.md)
      - [@ohos.process (获取进程相关的信息)](reference/apis/js-apis-process.md)
      - [@ohos.uri (URI字符串解析)](reference/apis/js-apis-uri.md)
      - [@ohos.url (URL字符串解析)](reference/apis/js-apis-url.md)
      - [@ohos.util (util工具函数)](reference/apis/js-apis-util.md)
      - [@ohos.util.ArrayList (线性容器ArrayList)](reference/apis/js-apis-arraylist.md)
      - [@ohos.util.Deque (线性容器Deque)](reference/apis/js-apis-deque.md)
      - [@ohos.util.HashMap (非线性容器HashMap)](reference/apis/js-apis-hashmap.md)
      - [@ohos.util.HashSet (非线性容器HashSet)](reference/apis/js-apis-hashset.md)
      - [@ohos.util.LightWeightMap (非线性容器LightWeightMap)](reference/apis/js-apis-lightweightmap.md)
      - [@ohos.util.LightWeightSet (非线性容器LightWeightSet)](reference/apis/js-apis-lightweightset.md)
      - [@ohos.util.LinkedList (线性容器LinkedList)](reference/apis/js-apis-linkedlist.md)
      - [@ohos.util.List (线性容器List)](reference/apis/js-apis-list.md)
      - [@ohos.util.PlainArray (非线性容器PlainArray)](reference/apis/js-apis-plainarray.md)
      - [@ohos.util.Queue (线性容器Queue)](reference/apis/js-apis-queue.md)
      - [@ohos.util.Stack (线性容器Stack)](reference/apis/js-apis-stack.md)
      - [@ohos.util.TreeMap (非线性容器TreeMap)](reference/apis/js-apis-treemap.md)
      - [@ohos.util.TreeSet (非线性容器TreeSet)](reference/apis/js-apis-treeset.md)
      - [@ohos.util.Vector (线性容器Vector)](reference/apis/js-apis-vector.md)
      - [@ohos.worker (启动一个Worker)](reference/apis/js-apis-worker.md)
      - [@ohos.xml (xml解析与生成)](reference/apis/js-apis-xml.md)
    - 测试
      - [@ohos.application.testRunner (TestRunner)](reference/apis/js-apis-testRunner.md)
      - [@ohos.uitest (UiTest)](reference/apis/js-apis-uitest.md)
    - 已停止维护的接口
      - [@ohos.bytrace (性能打点)](reference/apis/js-apis-bytrace.md)
      - [@ohos.data.storage (轻量级存储)](reference/apis/js-apis-data-storage.md)
      - [@system.app (应用上下文)](reference/apis/js-apis-system-app.md)
      - [@system.battery (电量信息)](reference/apis/js-apis-system-battery.md)
      - [@system.bluetooth (蓝牙)](reference/apis/js-apis-system-bluetooth.md)
      - [@system.brightness (屏幕亮度)](reference/apis/js-apis-system-brightness.md)
      - [@system.configuration (应用配置)](reference/apis/js-apis-system-configuration.md)
      - [@system.device (设备信息)](reference/apis/js-apis-system-device.md)
      - [@system.fetch (数据请求)](reference/apis/js-apis-system-fetch.md)
      - [@system.file (文件存储)](reference/apis/js-apis-system-file.md)
      - [@system.geolocation (地理位置)](reference/apis/js-apis-system-location.md)
      - [@system.mediaquery (媒体查询)](reference/apis/js-apis-system-mediaquery.md)
      - [@system.network (网络状态)](reference/apis/js-apis-system-network.md)
      - [@system.notification (通知消息)](reference/apis/js-apis-system-notification.md)
      - [@system.package (应用管理)](reference/apis/js-apis-system-package.md)
      - [@system.prompt (弹窗)](reference/apis/js-apis-system-prompt.md)
      - [@system.request (上传下载)](reference/apis/js-apis-system-request.md)
      - [@system.router (页面路由)](reference/apis/js-apis-system-router.md)
      - [@system.sensor (传感器)](reference/apis/js-apis-system-sensor.md)
      - [@system.storage (数据存储)](reference/apis/js-apis-system-storage.md)
      - [@system.vibrator (振动)](reference/apis/js-apis-system-vibrate.md)
      - [console (日志打印)](reference/apis/js-apis-logs.md)
  - 接口参考（Native API）
    - 模块
      - [Native XComponent](reference/native-apis/_o_h___native_x_component.md)
      - [Native_Bundle](reference/native-apis/_native___bundle.md)
      - [HiLog](reference/native-apis/_hi_log.md)
      - [NativeWindow](reference/native-apis/_native_window.md)
      - [Drawing](reference/native-apis/_drawing.md)
      - [Rawfile](reference/native-apis/rawfile.md)
    - 头文件
      - [drawing_bitmap.h](reference/native-apis/drawing__bitmap_8h.md)
      - [drawing_brush.h](reference/native-apis/drawing__brush_8h.md)
      - [drawing_canvas.h](reference/native-apis/drawing__canvas_8h.md)
      - [drawing_color.h](reference/native-apis/drawing__color_8h.md)
      - [drawing_font_collection.h](reference/native-apis/drawing__font__collection_8h.md)
      - [drawing_path.h](reference/native-apis/drawing__path_8h.md)
      - [drawing_pen.h](reference/native-apis/drawing__pen_8h.md)
      - [drawing_text_declaration.h](reference/native-apis/drawing__text__declaration_8h.md)
      - [drawing_text_typography.h](reference/native-apis/drawing__text__typography_8h.md)
      - [drawing_types.h](reference/native-apis/drawing__types_8h.md)
      - [external_window.h](reference/native-apis/external__window_8h.md)
      - [log.h](reference/native-apis/log_8h.md)
      - [native_interface_bundle.h](reference/native-apis/native__interface__bundle_8h.md)
      - [native_interface_xcomponent.h](reference/native-apis/native__interface__xcomponent_8h.md)
      - [raw_dir.h](reference/native-apis/raw__dir_8h.md)
      - [raw_file.h](reference/native-apis/raw__file_8h.md)
    - 结构体
      - [OH_Drawing_BitmapFormat](reference/native-apis/_o_h___drawing___bitmap_format.md)
      - [OH_NativeXComponent_Callback](reference/native-apis/_o_h___native_x_component___callback.md)
      - [OH_NativeXComponent_TouchEvent](reference/native-apis/_o_h___native_x_component___touch_event.md)
      - [OH_NativeXComponent_TouchPoint](reference/native-apis/_o_h___native_x_component___touch_point.md)
      - [RawFileDescriptor](reference/native-apis/_raw_file_descriptor.md)