# UI开发

- [方舟开发框架（ArkUI）概述](arkui-overview.md)
- 基于JS扩展的类Web开发范式
    - [概述](ui-js-overview.md)
    - 框架说明
        - [文件组织](js-framework-file.md)
        - [js标签配置](js-framework-js-tag.md)
        - [app.js](js-framework-js-file.md)
        - 语法
            - [HML语法参考](js-framework-syntax-hml.md)
            - [CSS语法参考](js-framework-syntax-css.md)
            - [JS语法参考](js-framework-syntax-js.md)
        - [生命周期](js-framework-lifecycle.md)
        - [资源限定与访问](js-framework-resource-restriction.md)
        - [多语言支持](js-framework-multiple-languages.md)
    - 构建用户界面
        - [组件介绍](ui-js-building-ui-component.md)
        - 构建布局
            - [布局说明](ui-js-building-ui-layout-intro.md)
            - [添加标题行和文本区域](ui-js-building-ui-layout-text.md)
            - [添加图片区域](ui-js-building-ui-layout-image.md)
            - [添加留言区域](ui-js-building-ui-layout-comment.md)
            - [添加容器](ui-js-building-ui-layout-external-container.md)
        - [添加交互](ui-js-building-ui-interactions.md)
        - [动画](ui-js-building-ui-animation.md)
        - [手势事件](ui-js-building-ui-event.md)
        - [页面路由](ui-js-building-ui-routes.md)
    - 常见组件开发指导
        - 容器组件
            - [List开发指导](ui-js-components-list.md)
            - [Dialog开发指导](ui-js-components-dialog.md)
            - [Form开发指导](ui-js-components-form.md)
            - [Stepper开发指导](ui-js-components-stepper.md)
            - [Tabs开发指导](ui-js-component-tabs.md)
            - [Swiper开发指导](ui-js-components-swiper.md)
        - 基础组件
            - [Text开发指导](ui-js-components-text.md)
            - [Input开发指导](ui-js-components-input.md)
            - [Button开发指导](ui-js-components-button.md)
            - [Picker开发指导](ui-js-components-picker.md)
            - [Image开发指导](ui-js-components-images.md)
            - [Image-animator开发指导](ui-js-components-image-animator.md)
            - [Rating开发指导](ui-js-components-rating.md)
            - [Slider开发指导](ui-js-components-slider.md)
            - [Chart开发指导](ui-js-components-chart.md)
            - [Switch开发指导](ui-js-components-switch.md)
            - [Toolbar开发指导](ui-js-components-toolbar.md)
            - [Menu开发指导](ui-js-components-menu.md)
            - [Marquee开发指导](ui-js-components-marquee.md)
            - [Qrcode开发指导](ui-js-components-qrcode.md)
            - [Search开发指导](ui-js-components-search.md)
        - Canvas开发指导
            - [Canvas对象](ui-js-components-canvas.md)
            - [CanvasRenderingContext2D对象](ui-js-components-canvasrenderingcontext2d.md)
            - [Path2D对象](ui-js-components-path2d.md)
            - [OffscreenCanvas对象](ui-js-components-offscreencanvas.md)
        - [栅格布局](ui-js-components-grid.md)
        - Svg开发指导
            - [基础知识](ui-js-components-svg-overview.md)
            - [绘制图形](ui-js-components-svg-graphics.md)
            - [绘制路径](ui-js-components-svg-path.md)
            - [绘制文本](ui-js-components-svg-text.md)
    - 动效开发指导
        - CSS动画
            - [属性样式动画](ui-js-animate-attribute-style.md)
            - [transform样式动画](ui-js-animate-transform.md)
            - [background-position样式动画](ui-js-animate-background-position-style.md)
            - [svg动画](ui-js-animate-svg.md)
        - JS动画
            - [组件动画](ui-js-animate-component.md)
            - 插值器动画
                - [动画动效](ui-js-animate-dynamic-effects.md)
                - [动画帧](ui-js-animate-frame.md)
    - [自定义组件](ui-js-custom-components.md)
- 基于TS扩展的声明式开发范式
    - [概述](ui-ts-overview.md)
    - 框架说明
        - 文件组织
            - [目录结构](ts-framework-directory.md)
            - [应用代码文件访问规则](ts-framework-file-access-rules.md)
        - [js标签配置](ts-framework-js-tag.md)
        - 资源管理
            - [资源文件的分类](ui-ts-basic-resource-file-categories.md)
            - [资源访问](ts-resource-access.md)
        - [像素单位](ts-pixel-units.md)
        - [类型定义](ts-types.md)
    - 声明式语法
        - [描述规范使用说明](ts-syntax-intro.md)
        - 通用UI描述规范
            - [基本概念](ts-general-ui-concepts.md)
            - 声明式UI描述规范
                - [无构造参数配置](ts-parameterless-configuration.md)
                - [必选参数构造配置](ts-configuration-with-mandatory-parameters.md)
                - [属性配置](ts-attribution-configuration.md)
                - [事件配置](ts-event-configuration.md)
                - [子组件配置](ts-child-component-configuration.md)
            - 组件化
                - [@Component](ts-component-based-component.md)
                - [@Entry](ts-component-based-entry.md)
                - [@Preview](ts-component-based-preview.md)
                - [@Builder](ts-component-based-builder.md)
                - [@Extend](ts-component-based-extend.md)
                - [@CustomDialog](ts-component-based-customdialog.md)
                - [@Styles](ts-component-based-styles.md)
        - UI状态管理
            - [基本概念](ts-ui-state-mgmt-concepts.md)
            - 管理组件拥有的状态
                - [@State](ts-component-states-state.md)
                - [@Prop](ts-component-states-prop.md)
                - [@Link](ts-component-states-link.md)
            - 管理应用程序的状态
                - [应用程序的数据存储](ts-application-states-appstorage.md)
                - [Ability数据存储](ui-ts-local-storage.md)
                - [持久化数据管理](ts-application-states-apis-persistentstorage.md)
                - [环境变量](ts-application-states-apis-environment.md)
            - 其他类目的状态管理
                - [Observed和ObjectLink数据管理](ts-other-states-observed-objectlink.md)
                - [@Consume和@Provide数据管理](ts-other-states-consume-provide.md)
                - [@Watch](ts-other-states-watch.md)
        - 渲染控制语法
            - [条件渲染](ts-rending-control-syntax-if-else.md)
            - [循环渲染](ts-rending-control-syntax-foreach.md)
            - [数据懒加载](ts-rending-control-syntax-lazyforeach.md)
        - 深入理解组件化
            - [build函数](ts-function-build.md)
            - [自定义组件初始化](ts-custom-component-initialization.md)
            - [自定义组件生命周期回调函数](ts-custom-component-lifecycle-callbacks.md)
            - [组件创建和重新初始化示例](ts-component-creation-re-initialization.md)
        - [语法糖](ts-syntactic-sugar.md)
    - 常见组件开发指导
        - [Button开发指导](ui-ts-basic-components-button.md)
        - [Web开发指导](ui-ts-components-web.md)
    - 常见布局开发指导
        - [弹性布局](ui-ts-layout-flex.md)
        - [栅格布局](ui-ts-layout-grid-container.md)
        - [媒体查询](ui-ts-layout-mediaquery.md)
    - 体验声明式UI
        - [创建声明式UI工程](ui-ts-creating-project.md)
        - [初识Component](ui-ts-components.md)
        - [创建简单视图](ui-ts-creating-simple-page.md)
    - 页面布局与连接
        - [构建食物数据模型](ui-ts-building-data-model.md)
        - [构建食物列表List布局](ui-ts-building-category-list-layout.md)
        - [构建食物分类Grid布局](ui-ts-building-category-grid-layout.md)
        - [页面跳转与数据传递](ui-ts-page-redirection-data-transmission.md)
