# 概览


[短信](https://gitee.com/openharmony/applications_mms/tree/master)是OpenHarmony中预置的系统应用，主要包含信息查看、发送短信、接收短信、短信送达报告、删除短信等功能。在不同类型设备上，短信应用的功能完全相同，故短信应用适合使用[部署模型A](introduction.md#部署模型)（即：不同类型的设备上安装运行相同的HAP包或HAP包组合）。


本案例中，在会话详情页面利用[方舟开发框架](introduction.md#方舟开发框架)提供的“一多”能力，用一套代码同时适配默认设备和平板。


## 工程结构

短信应用的工程结构如下图所示，当前该应用的功能较少，所以直接使用了DevEco Studio创建出的默认工程结构。具体采用何种形式的工程结构，并不影响应用的开发。但是使用推荐的工程结构，目录结构更清晰，拓展性也更好。

短信应用UI相关的逻辑集中在views和pages两个目录，分别存放公共组件及页面。当前短信应用主要包含如下页面：

- 信息列表页面：首页，展示信息列表。

- 通知信息列表页面：将通知类信息集中在一起展示，与信息列表页面类似。

- 会话详情页面：展示与某联系人的所有信息往来。

- 报告详情页面：信息发送报告的详情页面。

- 设置页面：消息设置页面，如是否展示送达报告等。

  
```
/Mms/
 ├── doc                                        # 资料
 ├── entry
 │   └── src
 │       └── main
 │           ├── resources                      # 资源配置文件存放目录
 │           ├── config.json                    # 全局配置文件
 │           └── ets                            # ets代码目录
 │               ├── ServiceAbility             # 后台常驻服务
 │               └── default                    # 业务代码目录
 │                   ├── data                   # 自定义数据类型
 │                   ├── model                  # 对接数据库
 │                   ├── pages                  # 所有页面
 │                   │   ├── conversation       # 会话详情页面
 │                   │   ├── conversationlist   # 信息列表页面
 │                   │   ├── index              # 初始页面
 │                   │   ├── info_msg           # 通知信息列表页面
 │                   │   ├── query_report       # 报告详情页面
 │                   │   └── settings           # 设置页面
 │                   ├── service                # 业务逻辑
 │                   ├── utils                  # 工具类
 │                   ├── views                  # 自定义组件
 │                   └── app.ets                # 应用生命周期
 ├── signs                                      # 签名
 └── LICENSE
```

短信应用在开发阶段，采用了一层工程结构。由于功能较为简单，所以并没有规划共用的feature和common目录，仅采用了一层product目录。

- 业务形态层（product）
  该目录采用IDE工程默认创建的entry目录，开发者可根据需要在创建Module时自行更改该目录名。不同产品形态，编译出相同的短信HAP包。
