# rating<a name="EN-US_TOPIC_0000001173324645"></a>

The  **<rating\>**  component provides a rating bar used for reviews and ratings.

## Required Permissions<a name="section11257113618419"></a>

None

## Child Components<a name="section9288143101012"></a>

Not supported

## Attributes<a name="section2907183951110"></a>

In addition to the attributes in  [Universal Attributes](js-components-common-attributes.md), the following attributes are supported.

<a name="table20633101642315"></a>
<table><thead align="left"><tr id="row663331618238"><th class="cellrowborder" valign="top" width="23.119999999999997%" id="mcps1.1.6.1.1"><p id="aa872998ac2d84843a3c5161889afffef"><a name="aa872998ac2d84843a3c5161889afffef"></a><a name="aa872998ac2d84843a3c5161889afffef"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="23.119999999999997%" id="mcps1.1.6.1.2"><p id="ab2111648ee0e4f6d881be8954e7acaab"><a name="ab2111648ee0e4f6d881be8954e7acaab"></a><a name="ab2111648ee0e4f6d881be8954e7acaab"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="10.48%" id="mcps1.1.6.1.3"><p id="ab377d1c90900478ea4ecab51e9a058af"><a name="ab377d1c90900478ea4ecab51e9a058af"></a><a name="ab377d1c90900478ea4ecab51e9a058af"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="7.5200000000000005%" id="mcps1.1.6.1.4"><p id="p824610360217"><a name="p824610360217"></a><a name="p824610360217"></a>Mandatory</p>
</th>
<th class="cellrowborder" valign="top" width="35.76%" id="mcps1.1.6.1.5"><p id="a1d574a0044ed42ec8a2603bc82734232"><a name="a1d574a0044ed42ec8a2603bc82734232"></a><a name="a1d574a0044ed42ec8a2603bc82734232"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row5141051050"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p157381413961"><a name="p157381413961"></a><a name="p157381413961"></a>numstars</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p973881313619"><a name="p973881313619"></a><a name="p973881313619"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p1973871314616"><a name="p1973871314616"></a><a name="p1973871314616"></a>5</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p473891317617"><a name="p473891317617"></a><a name="p473891317617"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p173811138611"><a name="p173811138611"></a><a name="p173811138611"></a>Maximum number of rating stars.</p>
</td>
</tr>
<tr id="row11475954"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p1973821316618"><a name="p1973821316618"></a><a name="p1973821316618"></a>rating</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p19738131320620"><a name="p19738131320620"></a><a name="p19738131320620"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p07386135610"><a name="p07386135610"></a><a name="p07386135610"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p1673831319613"><a name="p1673831319613"></a><a name="p1673831319613"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p107382131366"><a name="p107382131366"></a><a name="p107382131366"></a>Current rating stars.</p>
</td>
</tr>
<tr id="row1372245811411"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p5738101319611"><a name="p5738101319611"></a><a name="p5738101319611"></a>stepsize</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p77381713261"><a name="p77381713261"></a><a name="p77381713261"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p1073831312620"><a name="p1073831312620"></a><a name="p1073831312620"></a>0.5</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p5738613465"><a name="p5738613465"></a><a name="p5738613465"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p27381813364"><a name="p27381813364"></a><a name="p27381813364"></a>Step to increment the rating value.</p>
<div class="note" id="note1249472985312"><a name="note1249472985312"></a><a name="note1249472985312"></a><span class="notetitle"> </span><div class="notebody"><p id="p749462910531"><a name="p749462910531"></a><a name="p749462910531"></a></p>
</div></div>
</td>
</tr>
<tr id="row192599563412"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p16738813966"><a name="p16738813966"></a><a name="p16738813966"></a>indicator</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p47381313769"><a name="p47381313769"></a><a name="p47381313769"></a>boolean</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p1273815131861"><a name="p1273815131861"></a><a name="p1273815131861"></a>false</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p1073912131165"><a name="p1073912131165"></a><a name="p1073912131165"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p87391131166"><a name="p87391131166"></a><a name="p87391131166"></a>Whether to make the rating icons as an indicator (not-editable by users).</p>
</td>
</tr>
</tbody>
</table>

## Styles<a name="section5775351116"></a>

In addition to the styles in  [Universal Styles](js-components-common-styles.md), the following styles are supported.

<a name="table179091550174914"></a>
<table><thead align="left"><tr id="row1190955064913"><th class="cellrowborder" valign="top" width="20.71792820717928%" id="mcps1.1.6.1.1"><p id="p119091450154913"><a name="p119091450154913"></a><a name="p119091450154913"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="20.80791920807919%" id="mcps1.1.6.1.2"><p id="p390945020497"><a name="p390945020497"></a><a name="p390945020497"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="10.93890610938906%" id="mcps1.1.6.1.3"><p id="p2090917504493"><a name="p2090917504493"></a><a name="p2090917504493"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="7.519248075192481%" id="mcps1.1.6.1.4"><p id="p189091750114910"><a name="p189091750114910"></a><a name="p189091750114910"></a>Mandatory</p>
</th>
<th class="cellrowborder" valign="top" width="40.01599840015999%" id="mcps1.1.6.1.5"><p id="p79091750124917"><a name="p79091750124917"></a><a name="p79091750124917"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row17909450124912"><td class="cellrowborder" valign="top" width="20.71792820717928%" headers="mcps1.1.6.1.1 "><p id="p790935084914"><a name="p790935084914"></a><a name="p790935084914"></a>star-background</p>
</td>
<td class="cellrowborder" valign="top" width="20.80791920807919%" headers="mcps1.1.6.1.2 "><p id="p129091350164920"><a name="p129091350164920"></a><a name="p129091350164920"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="10.93890610938906%" headers="mcps1.1.6.1.3 "><p id="p99099503496"><a name="p99099503496"></a><a name="p99099503496"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.519248075192481%" headers="mcps1.1.6.1.4 "><p id="p1909125019497"><a name="p1909125019497"></a><a name="p1909125019497"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="40.01599840015999%" headers="mcps1.1.6.1.5 "><p id="p79091050184910"><a name="p79091050184910"></a><a name="p79091050184910"></a>Background image when a rating star is unselected. Only PNG and JPG images in a local path are supported.</p>
</td>
</tr>
<tr id="row139092504495"><td class="cellrowborder" valign="top" width="20.71792820717928%" headers="mcps1.1.6.1.1 "><p id="p19909185044919"><a name="p19909185044919"></a><a name="p19909185044919"></a>star-foreground</p>
</td>
<td class="cellrowborder" valign="top" width="20.80791920807919%" headers="mcps1.1.6.1.2 "><p id="p18909145064913"><a name="p18909145064913"></a><a name="p18909145064913"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="10.93890610938906%" headers="mcps1.1.6.1.3 "><p id="p11909550204915"><a name="p11909550204915"></a><a name="p11909550204915"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.519248075192481%" headers="mcps1.1.6.1.4 "><p id="p99101508497"><a name="p99101508497"></a><a name="p99101508497"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="40.01599840015999%" headers="mcps1.1.6.1.5 "><p id="p1091015502499"><a name="p1091015502499"></a><a name="p1091015502499"></a>Foreground image when a rating star is selected. Only PNG and JPG images in a local path are supported.</p>
</td>
</tr>
<tr id="row15910185012492"><td class="cellrowborder" valign="top" width="20.71792820717928%" headers="mcps1.1.6.1.1 "><p id="p2910145018491"><a name="p2910145018491"></a><a name="p2910145018491"></a>star-secondary</p>
</td>
<td class="cellrowborder" valign="top" width="20.80791920807919%" headers="mcps1.1.6.1.2 "><p id="p16910145024916"><a name="p16910145024916"></a><a name="p16910145024916"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="10.93890610938906%" headers="mcps1.1.6.1.3 "><p id="p7910125064915"><a name="p7910125064915"></a><a name="p7910125064915"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.519248075192481%" headers="mcps1.1.6.1.4 "><p id="p8910150204910"><a name="p8910150204910"></a><a name="p8910150204910"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="40.01599840015999%" headers="mcps1.1.6.1.5 "><p id="p391095015494"><a name="p391095015494"></a><a name="p391095015494"></a>Secondary background image when a rating star is partially selected. This image will cover the background image and can only be a PNG or JPG image from a local path.</p>
</td>
</tr>
<tr id="row12910155014493"><td class="cellrowborder" valign="top" width="20.71792820717928%" headers="mcps1.1.6.1.1 "><p id="p7910135054915"><a name="p7910135054915"></a><a name="p7910135054915"></a>width</p>
</td>
<td class="cellrowborder" valign="top" width="20.80791920807919%" headers="mcps1.1.6.1.2 "><p id="p69101950104910"><a name="p69101950104910"></a><a name="p69101950104910"></a>&lt;length&gt;|&lt;percentage&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="10.93890610938906%" headers="mcps1.1.6.1.3 "><p id="p391015084913"><a name="p391015084913"></a><a name="p391015084913"></a>120 px</p>
<p id="p1391055012499"><a name="p1391055012499"></a><a name="p1391055012499"></a>60 px (cannot be edited)</p>
</td>
<td class="cellrowborder" valign="top" width="7.519248075192481%" headers="mcps1.1.6.1.4 "><p id="p13910125064911"><a name="p13910125064911"></a><a name="p13910125064911"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="40.01599840015999%" headers="mcps1.1.6.1.5 "><p id="p1591035014911"><a name="p1591035014911"></a><a name="p1591035014911"></a>Image width. The default value is the width of the default image for five-star ratings. If you do not set the maximum rating value and background images of the rating stars, the default value will be used.</p>
</td>
</tr>
<tr id="row79101550124915"><td class="cellrowborder" valign="top" width="20.71792820717928%" headers="mcps1.1.6.1.1 "><p id="p1591005054915"><a name="p1591005054915"></a><a name="p1591005054915"></a>height</p>
</td>
<td class="cellrowborder" valign="top" width="20.80791920807919%" headers="mcps1.1.6.1.2 "><p id="p2091095024920"><a name="p2091095024920"></a><a name="p2091095024920"></a>&lt;length&gt;|&lt;percentage&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="10.93890610938906%" headers="mcps1.1.6.1.3 "><p id="p20910155014915"><a name="p20910155014915"></a><a name="p20910155014915"></a>24px</p>
<p id="p29101650104920"><a name="p29101650104920"></a><a name="p29101650104920"></a>12 px (cannot be edited)</p>
</td>
<td class="cellrowborder" valign="top" width="7.519248075192481%" headers="mcps1.1.6.1.4 "><p id="p491055024914"><a name="p491055024914"></a><a name="p491055024914"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="40.01599840015999%" headers="mcps1.1.6.1.5 "><p id="p1491065074910"><a name="p1491065074910"></a><a name="p1491065074910"></a>Image height. The default value is the height of the default image for five-star ratings. If you do not set the maximum rating value and background images of the rating stars, the default value will be used.</p>
</td>
</tr>
<tr id="row791012500491"><td class="cellrowborder" valign="top" width="20.71792820717928%" headers="mcps1.1.6.1.1 "><p id="p29108504492"><a name="p29108504492"></a><a name="p29108504492"></a>rtl-flip</p>
</td>
<td class="cellrowborder" valign="top" width="20.80791920807919%" headers="mcps1.1.6.1.2 "><p id="p109107509490"><a name="p109107509490"></a><a name="p109107509490"></a>boolean</p>
</td>
<td class="cellrowborder" valign="top" width="10.93890610938906%" headers="mcps1.1.6.1.3 "><p id="p391065018494"><a name="p391065018494"></a><a name="p391065018494"></a>true</p>
</td>
<td class="cellrowborder" valign="top" width="7.519248075192481%" headers="mcps1.1.6.1.4 "><p id="p1891015034920"><a name="p1891015034920"></a><a name="p1891015034920"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="40.01599840015999%" headers="mcps1.1.6.1.5 "><p id="p391011508492"><a name="p391011508492"></a><a name="p391011508492"></a>Whether the image source is automatically flipped in the RTL text direction.</p>
</td>
</tr>
</tbody>
</table>

>![](../../public_sys-resources/icon-note.gif) **NOTE:** 
>You must set  **star-background**,  **star-secondary**, and  **star-foreground**. Otherwise, the rating star is gray, indicating that the image is set incorrectly.

## Events<a name="section124498406719"></a>

In addition to the events in  [Universal Events](js-components-common-events.md), the following events are supported.

<a name="table836435619510"></a>
<table><thead align="left"><tr id="row153658563517"><th class="cellrowborder" valign="top" width="24.852485248524854%" id="mcps1.1.4.1.1"><p id="a426b8903842d48fa8012a24ff3c997eb"><a name="a426b8903842d48fa8012a24ff3c997eb"></a><a name="a426b8903842d48fa8012a24ff3c997eb"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="29.552955295529554%" id="mcps1.1.4.1.2"><p id="a53448ba47e5e4ae9bf7774c90820e970"><a name="a53448ba47e5e4ae9bf7774c90820e970"></a><a name="a53448ba47e5e4ae9bf7774c90820e970"></a>Parameter</p>
</th>
<th class="cellrowborder" valign="top" width="45.5945594559456%" id="mcps1.1.4.1.3"><p id="add489ff50c444f24b759162c7f4bad9a"><a name="add489ff50c444f24b759162c7f4bad9a"></a><a name="add489ff50c444f24b759162c7f4bad9a"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row518915212082"><td class="cellrowborder" valign="top" width="24.852485248524854%" headers="mcps1.1.4.1.1 "><p id="p125587286811"><a name="p125587286811"></a><a name="p125587286811"></a>change</p>
</td>
<td class="cellrowborder" valign="top" width="29.552955295529554%" headers="mcps1.1.4.1.2 "><p id="p255820281687"><a name="p255820281687"></a><a name="p255820281687"></a>{ rating:  number }</p>
</td>
<td class="cellrowborder" valign="top" width="45.5945594559456%" headers="mcps1.1.4.1.3 "><p id="p10558228886"><a name="p10558228886"></a><a name="p10558228886"></a>Triggered when the rating value changes.</p>
</td>
</tr>
</tbody>
</table>

## Methods<a name="section2279124532420"></a>

Methods in  [Universal Methods](js-components-common-methods.md)  are supported.

## Example<a name="section1715414253487"></a>

```
<!-- xxx.hml -->
<div class="container">
  <rating numstars="5" rating="5" @change="changeRating" id="rating">
  </rating>
</div>
```

```
/* xxx.css */
.container {
  display: flex;
  justify-content: center;
  align-items: center;
}
rating {
  width: 200px;
}
```

```
// xxx.js
import prompt from '@system.prompt';
export default {
    changeRating(e){
        prompt.showToast({
            message: e.rating
        });
    }
}
```

![](figures/1-6.png)

