# 内核子系统<a name="ZH-CN_TOPIC_0000001051340509"></a>

-   [简介](#section12995104752113)
-   [目录](#section1121775732114)
-   [约束](#section1967115154223)
-   [使用](#section1821123352217)
-   [相关仓](#section2392425183215)

## 简介<a name="section12995104752113"></a>

OpenHarmony内核是面向IoT领域的实时操作系统内核，它同时具备RTOS轻快和Linux易用的特点。

OpenHarmony内核主要包括进程和线程调度、内存管理、IPC机制、timer管理等内核基本功能。

OpenHarmony内核的源代码分为 kernel\_liteos\_a 和 kernel\_liteos\_m 这2个代码仓库，其中kernel\_liteos\_a主要针对标准设备（standard），而kernel\_liteos\_m则主要针对微设备（tiny）及迷你设备（mini），下面主要针对kernel\_liteos\_a代码仓库进行介绍。图1为OpenHarmony LiteOS-A内核架构图：

**图 1**  OpenHarmony LiteOS-A内核架构图<a name="fig115631528152315"></a>  
![](figures/OpenHarmony-LiteOS-A内核架构图.png "OpenHarmony-LiteOS-A内核架构图")

## 目录<a name="section1121775732114"></a>

```
/kernel/liteos_a
├── apps                   # 用户态的init和shell应用程序
├── arch                   # 体系架构的目录，如arm等
│   └── arm                # arm架构代码
├── bsd                    # freebsd相关的驱动和适配层模块代码引入，例如USB等
├── compat                 # 内核接口兼容性目录
│   └── posix              # posix相关接口
├── drivers                # 内核驱动
│   └── char               # 字符设备
│       ├── mem            # 访问物理IO设备驱动
│       ├── quickstart     # 系统快速启动接口目录
│       ├── random         # 随机数设备驱动
│       └── video          # framebuffer驱动框架
├── fs                     # 文件系统模块，主要来源于NuttX开源项目
│   ├── fat                # fat文件系统
│   ├── jffs2              # jffs2文件系统
│   ├── include            # 对外暴露头文件存放目录
│   ├── nfs                # nfs文件系统
│   ├── proc               # proc文件系统
│   ├── ramfs              # ramfs文件系统
│   └── vfs                # vfs层
├── kernel                 # 进程、内存、IPC等模块
│   ├── base               # 基础内核，包括调度、内存等模块
│   ├── common             # 内核通用组件
│   ├── extended           # 扩展内核，包括动态加载、vdso、liteipc等模块
│   ├── include            # 对外暴露头文件存放目录
│   └── user               # 加载init进程
├── lib                    # 内核的lib库
├── net                    # 网络模块，主要来源于lwip开源项目
├── platform               # 支持不同的芯片平台代码，如Hi3516DV300等
│   ├── hw                 # 时钟与中断相关逻辑代码
│   ├── include            # 对外暴露头文件存放目录
│   └── uart               # 串口相关逻辑代码
├── platform               # 支持不同的芯片平台代码，如Hi3516DV300等
├── security               # 安全特性相关的代码，包括进程权限管理和虚拟id映射管理
├── syscall                # 系统调用
└── tools                  # 构建工具及相关配置和代码
```

## 约束<a name="section1967115154223"></a>

Hi3518EV300默认使用jffs2文件系统，Hi3516DV300默认使用FAT文件系统。若要使用其他文件系统，需要新增适配。

## 使用<a name="section1821123352217"></a>

参见LiteOS-A内核[README](https://gitee.com/openharmony/kernel_liteos_a/blob/master/README_zh.md)和LiteOS-M内核[README](https://gitee.com/openharmony/kernel_liteos_m/blob/master/README_zh.md)的“使用说明”章节。

## 相关仓<a name="section2392425183215"></a>

**内核子系统**

[drivers\_liteos](https://gitee.com/openharmony/drivers_liteos/blob/master/README_zh.md)

[kernel\_liteos\_a](https://gitee.com/openharmony/kernel_liteos_a/blob/master/README_zh.md)

[kernel\_liteos\_m](https://gitee.com/openharmony/kernel_liteos_m/blob/master/README_zh.md)

[device\_qemu](https://gitee.com/openharmony/device_qemu/blob/master/README_zh.md)

[prebuilts\_lite\_sysroot](https://gitee.com/openharmony/prebuilts_lite_sysroot/blob/master/README_zh.md)

