# 编译构建概述<a name="ZH-CN_TOPIC_0000001060646620"></a>

-   [基本概念](#section175012297491)
-   [使用指导](#section193961322175011)
-   [约束与限制](#section2029921310472)

一个基于gn和ninja的支持OpenHarmony组件化开发的编译框架，主要提供以下功能：

-   构建已有产品。

-   独立构建芯片厂商源码。
-   独立构建单个组件。

## 基本概念<a name="section175012297491"></a>

在开发编译构建前，应了解如下基本概念：

-   组件

    可复用的软件单元，它可包含源码、配置文件、资源文件和编译脚本等。

-   gn

    Generate ninja的缩写，用于产生ninja文件。

-   ninja

    ninja是一个专注于速度的小型构建系统。


## 使用指导<a name="section193961322175011"></a>

1.  **构建流程**

    编译构建流程如[图1 ](#fig9744112715161)所示，主要包括设置和编译两步：

    **图 1**  编译构建流程<a name="fig9744112715161"></a>  
    ![](figures/编译构建流程.jpg "编译构建流程")

    1.  hb set: 设置OpenHarmony源码目录和要编译的产品。
    2.  hb build: 编译产品、开发板或者组件。解决方案编译实现如下：
        -   读取开发板配置：主要包括开发板使用的编译工具链、编译链接命令和选项等。
        -   调用gn：调用gn gen命令，读取产品配置\(主要包括开发板、内核和系统组件\)生成解决方案out目录和ninja文件。
        -   调用ninja：调用ninja -C out/company/product启动编译。
        -   系统镜像打包：将组件编译产物打包，制作文件系统镜像。


2.  **编译命令**

    1.  **hb set**

        ```
        hb set -h
        usage: hb set [-h] [-root [ROOT_PATH]] [-p]
        
        optional arguments:
          -h, --help            show this help message and exit
          -root [ROOT_PATH], --root_path [ROOT_PATH]
                                Set OHOS root path
          -p, --product         Set OHOS board and kernel
        ```

        -   hb set 后无参数，进入默认设置流程
        -   hb set -root dir可直接设置代码根目录
        -   hb set -p设置要编译的产品

    2.  **hb env**

        查看当前设置信息

        ```
        hb env
        [OHOS INFO] root path: xxx
        [OHOS INFO] board: hispark_taurus
        [OHOS INFO] kernel: liteos
        [OHOS INFO] product: ipcamera
        [OHOS INFO] product path: xxx/vendor/hisilicon/ipcamera
        [OHOS INFO] device path: xxx/device/hisilicon/hispark_taurus/sdk_linux_4.19
        ```

    3.  **hb build**

        ```
        hb build -h
        usage: hb build [-h] [-b BUILD_TYPE] [-c COMPILER] [-t [TEST [TEST ...]]]
                        [--dmverity] [-p PRODUCT] [-f] [-n]
                        [component [component ...]]
        
        positional arguments:
          component             name of the component
        
        optional arguments:
          -h, --help            show this help message and exit
          -b BUILD_TYPE, --build_type BUILD_TYPE
                                release or debug version
          -c COMPILER, --compiler COMPILER
                                specify compiler
          -t [TEST [TEST ...]], --test [TEST [TEST ...]]
                                compile test suit
          --dmverity            Enable dmverity
          -p PRODUCT, --product PRODUCT
                                build a specified product with
                                {product_name}@{company}, eg: ipcamera@hisilcon
          -f, --full            full code compilation
        ```

        -   hb build后无参数，会按照设置好的代码路径、产品进行编译，编译选项使用与之前保持一致。-f 选项将删除当前产品所有编译产品，等同于hb clean + hb build.
        -   hb build \{component\_name\}：基于设置好的产品对应的单板、内核，单独编译组件（e.g.：hb build kv\_store\)。
        -   hb build -p ipcamera@hisilicon：免set编译产品，该命令可以跳过set步骤，直接编译产品。
        -   在device/device\_company/board下单独执行hb build会进入内核选择界面，选择完成后会根据当前路径的单板、选择的内核编译出仅包含内核、驱动的镜像。

    4.  **hb clean**

        清除out目录对应产品的编译产物，仅保留args.gn、build.log。清除指定路径可输入路径参数：hb clean xxx/out/xxx，否则将清除hb set的产品对应out路径。


    ```
    hb clean
    usage: hb clean [-h] [out_path]
    
    positional arguments:
      out_path    clean a specified path.
    
    optional arguments:
      -h, --help  show this help message and exit
    ```


## 约束与限制<a name="section2029921310472"></a>

开发环境需预装gn、ninja构建工具、python 3.7.4及以上和hb，并下载完整代码。

