# 编译构建开发指导<a name="ZH-CN_TOPIC_0000001060378721"></a>

-   [目录结构](#section56731811102915)
-   [组件化开发步骤](#section4207112818418)

## 目录结构<a name="section56731811102915"></a>

```
build/lite                      # 编译构建主目录
├── components                  # 组件描述文件。
├── hb                          # hb pip安装包源码。
├── make_rootfs                 # 文件系统制作脚本。
├── config                      # 编译相关的配置项
│   ├── component               # 组件相关的模板定义。包括：静态库、动态库、扩展组件、模拟器库等
│   ├── kernel                  # 内核的编译配置参数
│   └── subsystem               # 子系统模板
├── ndk                         # NDK相关编译脚本与配置参数
└── toolchain                   # 编译工具链相关，包括：编译器路径、编译选项、链接选项等。
```

## 组件化开发步骤<a name="section4207112818418"></a>

1.  添加组件编译脚本。

    组件的编译脚本语言为gn，gn的基本用法请见[gn快速入门](https://gn.googlesource.com/gn/+/master/docs/quick_start.md)。组件即为gn中的编译单元，可以为静态库、动态库或可执行文件。

    以编译组件hello\_world可执行文件为例：

    ```
    executable("hello_world") {
      include_dirs = [
        "include",
       ]
      sources = [
        "src/hello_world.c"
      ]
    }
    ```

    如上编译脚本，可编译出一个可在OpenHarmony上运行的名为hello\_world的可执行文件。

2.  添加组件描述。

    组件描述位于build/lite/components下，新增的组件需加入对应子系统的json文件中。一个组件描述必选的字段有：

    -   component：组件名称。
    -   description：组件的一句话功能描述。
    -   optional：组件是否为系统可选。
    -   dirs：组件源码路径。
    -   targets：组件编译入口。

    以将hello\_world组件加入应用子系统为例，在applications.json中添加hello\_world对象：

    ```
    {
      "components": [
        {
          "component": hello_world",
          "description": "Hello world.",
          "optional": "true",
          "dirs": [
            "applications/sample/hello_world"
          ],
          "targets": [
            "//applications/sample/hello_world"
          ]
        },
        ...
       ]
    }
    ```

3.  将组件配置到产品。

    产品的配置文件位于位于vendor/company/下，产品配置文件需包含产品名称、OpenHarmony版本号、device厂商、开发板名称、内核类型、内核版本号，以及配置的子系统和组件。以将hello\_world组件加入产品配置文件my\_product.json中为例，加入hello\_wolrd对象：

    ```
    {
        "product_name": "hello_world_test",
        "ohos_version": "OpenHarmony 1.0",
        "device_company": "hisilicon",
        "board": "hispark_taurus",
        "kernel_type": "liteos_a",
        "kernel_version": "1.0.0",
        "subsystems": [
          {
            "subsystem": "applications",
            "components": [
              { "component": "hello_world", "features":[] }
            ]
          },
          ...
        ]
    }
    ```

4.  编译组件或者产品。

    1. 输入hb set选择hello\_world\_test@hisilicon

    2. 编译hello\_world组件：hb build hello\_world

    3. 编译hello\_world\_test产品：hb build


