# 第三方开源软件引入指导

## 目的
提供易用、高质量的开源软件是OpenHarmony的重要目标，因第三方开源软件数量多，而社区开发人员同样数量多、分布广，为确保OpenHarmony项目的整体质量，特别拟定本指南，供社区贡献者参考。

## 范围
本指导适用于所有引入到OpenHarmony项目中的第三方开源软件。

## 规则

### 基本要求
为便于第三方开源软件的维护与演进，在引入第三方开源软件时请参考如下原则：</BR>

1. 若需要使用的开源软件在OpenHarmony项目中已存在，请使用OpenHarmony项目中维护的版本。
2. 引入新的第三方开源软件到OpenHarmony项目时，请将其放置到单独的代码仓或目录中，并且软件名称和其官网保持一致。
3. 第三方开源软件仓应当完整保留该开源软件官方代码仓的目录结构、许可证及Copyright信息。
4. 不建议引入未发布正式版本（如只发布Beta版本）的开源软件。
5. 若需针对引入的开源软件进行修改，请将修改的代码放在该开源软件仓中，并确保满足该开源软件的许可证要求。

如因特殊原因不能满足上述要求但又需要引入，请请联系邮箱：law@openatom.org。

### 第三方开源软件许可证要求
1. 第三方开源软件许可证类型必须是[OSI](https://opensource.org/osd-annotated) 明确定义的。
2. 第三方开源软件许可证必须与使用该开源软件的代码仓许可证兼容。
3. 如下类型许可证可以引入到OpenHarmony项目中：
* Apache License 2.0
* Mulan Permissive Software License，Version 2
* BSD 2-clause
* BSD 3-clause
* DOM4J License
* PostgreSQL License
* Eclipse Distribution License 1.0
* MIT
* ISC
* ICU
* University of Illinois/NCSA
* W3C Software License
* zlib/libpng
* Academic Free License 3.0
* Python Software Foundation License
* Python Imaging Library Software License
* Boost Software License Version 1.0
* WTF Public License
* UNICODE, INC. LICENSE AGREEMENT - DATA FILES AND SOFTWARE
* Zope Public License 2.0

4. 如下类型许可证不建议引入到OpenHarmony项目中:
* GNU GPL 1, 2, 3
* GNU Affero GPL 3
* GNU LGPL 2, 2.1, 3
* QPL
* Sleepycat License
* Server Side Public License (SSPL) version 1
* Code Project Open License (CPOL)
* BSD-4-Clause/BSD-4-Clause (University of California-Specific)
* Facebook BSD+Patents license
* NPL 1.0/NPL 1.1
* The Solipsistic Eclipse Public License
* The "Don't Be A Dick" Public License
* JSON License
* Binary Code License (BCL)
* Intel Simplified Software License
* JSR-275 License
* Microsoft Limited Public License
* Amazon Software License (ASL)
* Java SDK for Satori RTM license
* Redis Source Available License (RSAL)
* Booz Allen Public License
* Creative Commons Non-Commercial
* Sun Community Source License 3.0
* Common Development and Distribution Licenses: CDDL 1.0 and CDDL 1.1
* Common Public License: CPL 1.0
* Eclipse Public License: EPL 1.0
* IBM Public License: IPL 1.0
* Mozilla Public Licenses: MPL 1.0, MPL 1.1, and MPL 2.0
* Sun Public License: SPL 1.0
* Open Software License 3.0
* Erlang Public License
* UnRAR License 
* SIL Open Font License
* Ubuntu Font License Version 1.0
* IPA Font License Agreement v1.0
* Ruby License
* Eclipse Public License 2.0: EPL 2.0

如要引入其它类型License或上述（4）所列License，请联系邮箱：law@openatom.org。

## 本指导的改进及修订说明
本指导的变更由PMC维护，随着OpenHarmony的演进该指导可能不断刷新、完善，请社区贡献者关注最新版本的指导。