/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2019 Hisilicon Limited, All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http:
 */

#ifndef __RASC_REG_OFFSET_H__
#define __RASC_REG_OFFSET_H__

/* RASC Base address of Module's Register */
#define DDRC_RASC_BASE (0x1800)

/******************************************************************************/
/*					  xxx RASC Registers' Definitions */
/******************************************************************************/

#define DDRC_RASC_RASC_CTRL_MODE_REG (DDRC_RASC_BASE + 0x0)
#define DDRC_RASC_RASC_CTRL_ADDDC_REG (DDRC_RASC_BASE + 0x4)
#define DDRC_RASC_RASC_CTRL_PASCRUB_REG (DDRC_RASC_BASE + 0x8)
#define DDRC_RASC_RASC_CTRL_SPARING_REG (DDRC_RASC_BASE + 0xC)
#define DDRC_RASC_RASC_CTRL_FLUSH_REG (DDRC_RASC_BASE + 0x10)
#define DDRC_RASC_RASC_CTRL_ERRINJ_REG (DDRC_RASC_BASE + 0x14)
#define DDRC_RASC_RASC_CTRL_FUNNEL_REG (DDRC_RASC_BASE + 0x18)
#define DDRC_RASC_RASC_CFG_MODE_REG (DDRC_RASC_BASE + 0x20)
#define DDRC_RASC_RASC_CFG_RANKMAP_REG (DDRC_RASC_BASE + 0x30)
#define DDRC_RASC_RASC_CFG_CLR_REG (DDRC_RASC_BASE + 0x54)
#define DDRC_RASC_RASC_CFG_INFO_RNK_REG (DDRC_RASC_BASE + 0x58)
#define DDRC_RASC_RASC_CFG_INFO_DEVIDX_REG (DDRC_RASC_BASE + 0x5C)
#define DDRC_RASC_RASC_CFG_INFO_BNKIDX_REG (DDRC_RASC_BASE + 0x60)
#define DDRC_RASC_RASC_CFG_PASTART_REG (DDRC_RASC_BASE + 0x70)
#define DDRC_RASC_RASC_CFG_PAEND_REG (DDRC_RASC_BASE + 0x80)
#define DDRC_RASC_RASC_CFG_PS_REG (DDRC_RASC_BASE + 0x90)
#define DDRC_RASC_RASC_CFG_ADDDC_REGION0_REG (DDRC_RASC_BASE + 0xA0)
#define DDRC_RASC_RASC_CFG_ADDDC_REGION1_REG (DDRC_RASC_BASE + 0xA4)
#define DDRC_RASC_RASC_CFG_ADDDC_RVLS_REG (DDRC_RASC_BASE + 0xA8)
#define DDRC_RASC_RASC_CFG_VLS_INTERVAL_REG (DDRC_RASC_BASE + 0xAC)
#define DDRC_RASC_RASC_CFG_VLS_X8_REG (DDRC_RASC_BASE + 0xB0)
#define DDRC_RASC_RASC_CFG_SP_REG (DDRC_RASC_BASE + 0xC0)
#define DDRC_RASC_RASC_CFG_SPR_INTERVAL_REG (DDRC_RASC_BASE + 0xC4)
#define DDRC_RASC_RASC_CFG_SPR_OUTSTANDING_REG (DDRC_RASC_BASE + 0xC8)
#define DDRC_RASC_RASC_CFG_CE_LVL_REG (DDRC_RASC_BASE + 0xD4)
#define DDRC_RASC_RASC_CFG_FUNNEL_BASE_REG (DDRC_RASC_BASE + 0xE0)
#define DDRC_RASC_RASC_CFG_FUNNEL_TH_REG (DDRC_RASC_BASE + 0xE4)
#define DDRC_RASC_RASC_CFG_ERRINJMODE_REG (DDRC_RASC_BASE + 0xF0)
#define DDRC_RASC_RASC_CFG_ERRINJ_ADDR_L_REG (DDRC_RASC_BASE + 0xF4)
#define DDRC_RASC_RASC_CFG_ERRINJ_ADDR_H_REG (DDRC_RASC_BASE + 0xF8)
#define DDRC_RASC_RASC_CFG_ERRINJ_ADDRMSK_L_REG (DDRC_RASC_BASE + 0xFC)
#define DDRC_RASC_RASC_CFG_ERRINJ_ADDRMSK_H_REG (DDRC_RASC_BASE + 0x100)
#define DDRC_RASC_RASC_CFG_ERR_BUF_SEL_REG (DDRC_RASC_BASE + 0x104)
#define DDRC_RASC_RASC_CFG_ERRINJ_DMSK_REG (DDRC_RASC_BASE + 0x110)
#define DDRC_RASC_RASC_CFG_POISON_REG (DDRC_RASC_BASE + 0x140)
#define DDRC_RASC_RASC_CFG_RAM_ERRINJ_REG (DDRC_RASC_BASE + 0x150)
#define DDRC_RASC_RASC_CFG_RAM_TMOD_REG (DDRC_RASC_BASE + 0x154)
#define DDRC_RASC_RASC_CFG_CORR_TH_REG (DDRC_RASC_BASE + 0x160)
#define DDRC_RASC_RASC_CFG_RH_REG (DDRC_RASC_BASE + 0x164)
#define DDRC_RASC_RASC_CFG_RH_ADJA_OP_REG (DDRC_RASC_BASE + 0x168)
#define DDRC_RASC_RASC_CFG_RH_ADJA_UP_LV1_REG (DDRC_RASC_BASE + 0x16C)
#define DDRC_RASC_RASC_CFG_RH_ADJA_UP_LV2_REG (DDRC_RASC_BASE + 0x170)
#define DDRC_RASC_RASC_CFG_RH_ADJA_UP_LV3_REG (DDRC_RASC_BASE + 0x174)
#define DDRC_RASC_RASC_CFG_RH_ADJA_UP_LV4_REG (DDRC_RASC_BASE + 0x178)
#define DDRC_RASC_RASC_CFG_RH_ADJA_DOWN_LV1_REG (DDRC_RASC_BASE + 0x17C)
#define DDRC_RASC_RASC_CFG_RH_ADJA_DOWN_LV2_REG (DDRC_RASC_BASE + 0x180)
#define DDRC_RASC_RASC_CFG_RH_ADJA_DOWN_LV3_REG (DDRC_RASC_BASE + 0x184)
#define DDRC_RASC_RASC_CFG_RH_ADJA_DOWN_LV4_REG (DDRC_RASC_BASE + 0x188)
#define DDRC_RASC_RASC_CFG_RH_SCRAM_UP_REG (DDRC_RASC_BASE + 0x18C)
#define DDRC_RASC_RASC_CFG_RH_SCRAM_DOWN_REG (DDRC_RASC_BASE + 0x190)
#define DDRC_RASC_RASC_CFG_RH_SCRAM_MSK_LV1_REG (DDRC_RASC_BASE + 0x194)
#define DDRC_RASC_RASC_CFG_RH_SCRAM_MSK_LV2_REG (DDRC_RASC_BASE + 0x198)
#define DDRC_RASC_RASC_CFG_RH_SCRAM_MSK_LV3_REG (DDRC_RASC_BASE + 0x19C)
#define DDRC_RASC_RASC_CFG_RH_SCRAM_MSK_LV4_REG (DDRC_RASC_BASE + 0x1A0)
#define DDRC_RASC_RASC_CFG_RH_TCAL_REG (DDRC_RASC_BASE + 0x1A4)
#define DDRC_RASC_RASC_CFG_RES0_REG (DDRC_RASC_BASE + 0x1F0)
#define DDRC_RASC_RASC_CFG_RES1_REG (DDRC_RASC_BASE + 0x1F4)
#define DDRC_RASC_RASC_CFG_RES2_REG (DDRC_RASC_BASE + 0x1F8)
#define DDRC_RASC_RASC_CFG_RES3_REG (DDRC_RASC_BASE + 0x1FC)
#define DDRC_RASC_RASC_INTMSK_REG (DDRC_RASC_BASE + 0x200)
#define DDRC_RASC_RASC_RINT_REG (DDRC_RASC_BASE + 0x204)
#define DDRC_RASC_RASC_INTSTS_REG (DDRC_RASC_BASE + 0x208)
#define DDRC_RASC_RASC_CURR_STATUS_REG (DDRC_RASC_BASE + 0x220)
#define DDRC_RASC_RASC_CURR_ERRSTATUS_REG (DDRC_RASC_BASE + 0x224)
#define DDRC_RASC_RASC_CURR_SPRNK_STA_REG (DDRC_RASC_BASE + 0x228)
#define DDRC_RASC_RASC_CURR_SPDEV_STA_REG (DDRC_RASC_BASE + 0x22C)
#define DDRC_RASC_RASC_CURR_SPDEV_DEV1_REG (DDRC_RASC_BASE + 0x230)
#define DDRC_RASC_RASC_CURR_CMD_CNT_REG (DDRC_RASC_BASE + 0x234)
#define DDRC_RASC_RASC_CURR_ADDDC_STA_REG (DDRC_RASC_BASE + 0x238)
#define DDRC_RASC_RASC_HIS_UNCORR_CNT_REG (DDRC_RASC_BASE + 0x240)
#define DDRC_RASC_RASC_HIS_CORR_CNT_REG (DDRC_RASC_BASE + 0x244)
#define DDRC_RASC_RASC_HIS_HAERR_CNT_REG (DDRC_RASC_BASE + 0x250)
#define DDRC_RASC_RASC_HIS_PAERR_CNT_REG (DDRC_RASC_BASE + 0x258)
#define DDRC_RASC_RASC_HIS_SPERR_CNT_REG (DDRC_RASC_BASE + 0x25C)
#define DDRC_RASC_RASC_HIS_SPRBERR_CNT_REG (DDRC_RASC_BASE + 0x260)
#define DDRC_RASC_RASC_HIS_VLSERR_CNT_REG (DDRC_RASC_BASE + 0x264)
#define DDRC_RASC_RASC_HIS_RVLSERR_CNT_REG (DDRC_RASC_BASE + 0x268)
#define DDRC_RASC_RASC_HIS_RANKCNT_INF_REG (DDRC_RASC_BASE + 0x280)
#define DDRC_RASC_RASC_HIS_HA_RANKCNT_INF_REG (DDRC_RASC_BASE + 0x284)
#define DDRC_RASC_RASC_HIS_RANK_ERR_REG (DDRC_RASC_BASE + 0x28C)
#define DDRC_RASC_RASC_HIS_OFFSET_ERR_REG (DDRC_RASC_BASE + 0x290)
#define DDRC_RASC_RASC_HIS_SEG_ERR_REG (DDRC_RASC_BASE + 0x2A0)
#define DDRC_RASC_RASC_HIS_WORST_DEV_REG (DDRC_RASC_BASE + 0x2D4)
#define DDRC_RASC_RASC_HIS_WORST_BNK_REG (DDRC_RASC_BASE + 0x2D8)
#define DDRC_RASC_RASC_HIS_RCDTYP_REG (DDRC_RASC_BASE + 0x300)
#define DDRC_RASC_RASC_HIS_UNCORR_ADDR_L_REG (DDRC_RASC_BASE + 0x310)
#define DDRC_RASC_RASC_HIS_UNCORR_ADDR_H_REG (DDRC_RASC_BASE + 0x314)
#define DDRC_RASC_RASC_HIS_UNCORR_RDATA_REG (DDRC_RASC_BASE + 0x320)
#define DDRC_RASC_RASC_HIS_UNCORR_RDATA_CWH_REG (DDRC_RASC_BASE + 0x350)
#define DDRC_RASC_RASC_HIS_CORR_ADDR_L_REG (DDRC_RASC_BASE + 0x380)
#define DDRC_RASC_RASC_HIS_CORR_ADDR_H_REG (DDRC_RASC_BASE + 0x384)
#define DDRC_RASC_RASC_HIS_CORR_RDATA_REG (DDRC_RASC_BASE + 0x390)
#define DDRC_RASC_RASC_HIS_CORR_RDATA_CWH_REG (DDRC_RASC_BASE + 0x3C0)
#define DDRC_RASC_RASC_HIS_CORR_EXPDATA_REG (DDRC_RASC_BASE + 0x400)
#define DDRC_RASC_RASC_HIS_CORR_EXPDATA_CWH_REG (DDRC_RASC_BASE + 0x430)
#define DDRC_RASC_RASC_HIS_ERRINJ_CNT_REG (DDRC_RASC_BASE + 0x460)

#endif
