/* SPDX-License-Identifier: GPL-2.0+ */
/*  Copyright (c) 2016-2017 Hisilicon Limited. */

#ifndef __HCLGE_ERR_H
#define __HCLGE_ERR_H

#include "hclge_main.h"

#define HCLGE_RAS_PF_OTHER_INT_STS_REG   0x20B00
#define HCLGE_RAS_IMP_RD_POISON_MASK \
	BIT(HCLGE_VECTOR0_IMP_RD_POISON_B)
#define HCLGE_RAS_IMP_CMDQ_ERR_MASK \
	BIT(HCLGE_VECTOR0_IMP_CMDQ_ERR_B)
#define HCLGE_RAS_REG_NFE_MASK   0xFF00
#define HCLGE_RAS_REG_ROCEE_ERR_MASK   0x3000000

#define HCLGE_VECTOR0_PF_OTHER_INT_STS_REG   0x20800
#define HCLGE_VECTOR0_REG_MSIX_MASK   0x1FF00

#define HCLGE_IMP_TCM_ECC_ERR_INT_EN	0xFFFF0000
#define HCLGE_IMP_TCM_ECC_ERR_INT_EN_MASK	0xFFFF0000
#define HCLGE_IMP_ITCM4_ECC_ERR_INT_EN	0x300
#define HCLGE_IMP_ITCM4_ECC_ERR_INT_EN_MASK	0x300
#define HCLGE_CMDQ_NIC_ECC_ERR_INT_EN	0xFFFF
#define HCLGE_CMDQ_NIC_ECC_ERR_INT_EN_MASK	0xFFFF
#define HCLGE_CMDQ_ROCEE_ECC_ERR_INT_EN	0xFFFF0000
#define HCLGE_CMDQ_ROCEE_ECC_ERR_INT_EN_MASK	0xFFFF0000
#define HCLGE_IMP_RD_POISON_ERR_INT_EN	0x0100
#define HCLGE_IMP_RD_POISON_ERR_INT_EN_MASK	0x0100
#define HCLGE_TQP_ECC_ERR_INT_EN	0x0FFF
#define HCLGE_TQP_ECC_ERR_INT_EN_MASK	0x0FFF
#define HCLGE_MSIX_SRAM_ECC_ERR_INT_EN_MASK	0x0F000000
#define HCLGE_MSIX_SRAM_ECC_ERR_INT_EN	0x0F000000
#define HCLGE_IGU_ERR_INT_EN	0x0000066F
#define HCLGE_IGU_ERR_INT_EN_MASK	0x000F
#define HCLGE_IGU_TNL_ERR_INT_EN    0x0002AABF
#define HCLGE_IGU_TNL_ERR_INT_EN_MASK  0x003F
#define HCLGE_PPP_MPF_ECC_ERR_INT0_EN	0xFFFFFFFF
#define HCLGE_PPP_MPF_ECC_ERR_INT0_EN_MASK	0xFFFFFFFF
#define HCLGE_PPP_MPF_ECC_ERR_INT1_EN	0xFFFFFFFF
#define HCLGE_PPP_MPF_ECC_ERR_INT1_EN_MASK	0xFFFFFFFF
#define HCLGE_PPP_PF_ERR_INT_EN	0x0003
#define HCLGE_PPP_PF_ERR_INT_EN_MASK	0x0003
#define HCLGE_PPP_MPF_ECC_ERR_INT2_EN	0x003F
#define HCLGE_PPP_MPF_ECC_ERR_INT2_EN_MASK	0x003F
#define HCLGE_PPP_MPF_ECC_ERR_INT3_EN	0x003F
#define HCLGE_PPP_MPF_ECC_ERR_INT3_EN_MASK	0x003F
#define HCLGE_TM_SCH_ECC_ERR_INT_EN	0x3
#define HCLGE_TM_QCN_MEM_ERR_INT_EN	0xFFFFFF
#define HCLGE_NCSI_ERR_INT_EN	0x3
#define HCLGE_NCSI_ERR_INT_TYPE	0x9
#define HCLGE_MAC_COMMON_ERR_INT_EN		0x107FF
#define HCLGE_MAC_COMMON_ERR_INT_EN_MASK	0x107FF
#define HCLGE_MAC_TNL_INT_EN			GENMASK(9, 0)
#define HCLGE_MAC_TNL_INT_EN_MASK		GENMASK(9, 0)
#define HCLGE_MAC_TNL_INT_CLR			GENMASK(9, 0)
#define HCLGE_PPU_MPF_ABNORMAL_INT0_EN		GENMASK(31, 0)
#define HCLGE_PPU_MPF_ABNORMAL_INT0_EN_MASK	GENMASK(31, 0)
#define HCLGE_PPU_MPF_ABNORMAL_INT1_EN		GENMASK(31, 0)
#define HCLGE_PPU_MPF_ABNORMAL_INT1_EN_MASK	GENMASK(31, 0)
#define HCLGE_PPU_MPF_ABNORMAL_INT2_EN		0x3FFF3FFF
#define HCLGE_PPU_MPF_ABNORMAL_INT2_EN_MASK	0x3FFF3FFF
#define HCLGE_PPU_MPF_ABNORMAL_INT2_EN2		0xB
#define HCLGE_PPU_MPF_ABNORMAL_INT2_EN2_MASK	0xB
#define HCLGE_PPU_MPF_ABNORMAL_INT3_EN		GENMASK(7, 0)
#define HCLGE_PPU_MPF_ABNORMAL_INT3_EN_MASK	GENMASK(23, 16)
#define HCLGE_PPU_PF_ABNORMAL_INT_EN		GENMASK(5, 0)
#define HCLGE_PPU_PF_ABNORMAL_INT_EN_MASK	GENMASK(5, 0)
#define HCLGE_SSU_1BIT_ECC_ERR_INT_EN		GENMASK(31, 0)
#define HCLGE_SSU_1BIT_ECC_ERR_INT_EN_MASK	GENMASK(31, 0)
#define HCLGE_SSU_MULTI_BIT_ECC_ERR_INT_EN	GENMASK(31, 0)
#define HCLGE_SSU_MULTI_BIT_ECC_ERR_INT_EN_MASK	GENMASK(31, 0)
#define HCLGE_SSU_BIT32_ECC_ERR_INT_EN		0x0101
#define HCLGE_SSU_BIT32_ECC_ERR_INT_EN_MASK	0x0101
#define HCLGE_SSU_COMMON_INT_EN			GENMASK(9, 0)
#define HCLGE_SSU_COMMON_INT_EN_MASK		GENMASK(9, 0)
#define HCLGE_SSU_PORT_BASED_ERR_INT_EN		0x0BFF
#define HCLGE_SSU_PORT_BASED_ERR_INT_EN_MASK	0x0BFF0000
#define HCLGE_SSU_FIFO_OVERFLOW_ERR_INT_EN	GENMASK(23, 0)
#define HCLGE_SSU_FIFO_OVERFLOW_ERR_INT_EN_MASK	GENMASK(23, 0)

#define HCLGE_SSU_COMMON_ERR_INT_MASK	GENMASK(9, 0)
#define HCLGE_SSU_PORT_INT_MSIX_MASK	0x7BFF
#define HCLGE_IGU_INT_MASK		GENMASK(3, 0)
#define HCLGE_IGU_EGU_TNL_INT_MASK	GENMASK(5, 0)
#define HCLGE_PPP_MPF_INT_ST3_MASK	GENMASK(5, 0)
#define HCLGE_PPU_MPF_INT_ST3_MASK	GENMASK(7, 0)
#define HCLGE_PPU_MPF_INT_ST2_MSIX_MASK	BIT(29)
#define HCLGE_PPU_PF_INT_RAS_MASK	0x18
#define HCLGE_PPU_PF_INT_MSIX_MASK	0x26
#define HCLGE_PPU_PF_OVER_8BD_ERR_MASK	0x01
#define HCLGE_QCN_FIFO_INT_MASK		GENMASK(17, 0)
#define HCLGE_QCN_ECC_INT_MASK		GENMASK(21, 0)
#define HCLGE_NCSI_ECC_INT_MASK		GENMASK(1, 0)

#define HCLGE_ROCEE_RAS_NFE_INT_EN		0xF
#define HCLGE_ROCEE_RAS_CE_INT_EN		0x1
#define HCLGE_ROCEE_RAS_NFE_INT_EN_MASK		0xF
#define HCLGE_ROCEE_RAS_CE_INT_EN_MASK		0x1
#define HCLGE_ROCEE_RERR_INT_MASK		BIT(0)
#define HCLGE_ROCEE_BERR_INT_MASK		BIT(1)
#define HCLGE_ROCEE_AXI_ERR_INT_MASK		GENMASK(1, 0)
#define HCLGE_ROCEE_ECC_INT_MASK		BIT(2)
#define HCLGE_ROCEE_OVF_INT_MASK		BIT(3)
#define HCLGE_ROCEE_OVF_ERR_INT_MASK		0x10000
#define HCLGE_ROCEE_OVF_ERR_TYPE_MASK		0x3F

enum hclge_err_int_type {
	HCLGE_ERR_INT_MSIX = 0,
	HCLGE_ERR_INT_RAS_CE = 1,
	HCLGE_ERR_INT_RAS_NFE = 2,
	HCLGE_ERR_INT_RAS_FE = 3,
};

struct hclge_hw_blk {
	u32 msk;
	const char *name;
	int (*config_err_int)(struct hclge_dev *hdev, bool en);
};

struct hclge_hw_error {
	u32 int_msk;
	const char *msg;
	enum hnae3_reset_type reset_level;
};

struct hclge_bd_num {
	u32 mpf_bd_num;
	u32 pf_bd_num;
	u32 max_bd_num;
};

extern const struct hclge_hw_error hclge_imp_tcm_ecc_int[];
extern const struct hclge_hw_error hclge_cmdq_nic_mem_ecc_int[];
extern const struct hclge_hw_error hclge_tqp_int_ecc_int[];
extern const struct hclge_hw_error hclge_msix_sram_ecc_int[];
extern const struct hclge_hw_error hclge_igu_int[];
extern const struct hclge_hw_error hclge_igu_egu_tnl_int[];
extern const struct hclge_hw_error hclge_ncsi_err_int[];
extern const struct hclge_hw_error hclge_ppp_mpf_abnormal_int_st1[];
extern const struct hclge_hw_error hclge_ppp_pf_abnormal_int[];
extern const struct hclge_hw_error hclge_ppp_mpf_abnormal_int_st3[];
extern const struct hclge_hw_error hclge_tm_sch_rint[];
extern const struct hclge_hw_error hclge_qcn_fifo_rint[];
extern const struct hclge_hw_error hclge_qcn_ecc_rint[];
extern const struct hclge_hw_error hclge_mac_afifo_tnl_int[];
extern const struct hclge_hw_error hclge_ppu_mpf_abnormal_int_st2[];
extern const struct hclge_hw_error hclge_ppu_mpf_abnormal_int_st3[];
extern const struct hclge_hw_error hclge_ppu_pf_abnormal_int[];
extern const struct hclge_hw_error hclge_ssu_com_err_int[];
extern const struct hclge_hw_error hclge_ssu_mem_ecc_err_int[];
extern const struct hclge_hw_error hclge_ssu_port_based_err_int[];
extern const struct hclge_hw_error hclge_ssu_fifo_overflow_int[];
extern const struct hclge_hw_error hclge_ssu_ets_tcg_int[];
extern const struct hclge_hw_error hclge_ssu_port_based_pf_int[];
extern const struct hclge_hw_error hclge_rocee_qmm_ovf_err_int[];

int hclge_config_mac_tnl_int(struct hclge_dev *hdev, bool en);
int hclge_config_nic_hw_error(struct hclge_dev *hdev, bool state);
int hclge_config_rocee_ras_interrupt(struct hclge_dev *hdev, bool en);
void hclge_handle_all_hns_hw_errors(struct hnae3_ae_dev *ae_dev);
pci_ers_result_t hclge_handle_hw_ras_error(struct hnae3_ae_dev *ae_dev);
int hclge_handle_hw_msix_error(struct hclge_dev *hdev,
			       unsigned long *reset_requests);
int hclge_handle_all_ras_errors(struct hclge_dev *hdev);
int hclge_handle_rocee_ras_error(struct hnae3_ae_dev *ae_dev);
void hclge_log_error(struct device *dev, char *reg,
		     const struct hclge_hw_error *err,
		     u32 err_sts, unsigned long *reset_requests);
struct hclge_desc *hclge_query_bd_num(struct hclge_dev *hdev,
				      struct hclge_bd_num *bd_num,
				      enum hclge_opcode_type opcode);
#endif
