/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2019 Hisilicon Limited, All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef __HLLC_PCS_REG_OFFSET_H__
#define __HLLC_PCS_REG_OFFSET_H__

/* HLLC_PCS Base address of Module's Register */
#define HLLC_HLLC_PCS_BASE (0x0)

/******************************************************************************/
/*					  xxx HLLC_PCS Registers' Definitions */
/******************************************************************************/

#define HLLC_HLLC_PCS_PCS_GLOBAL_CFG_REG (HLLC_HLLC_PCS_BASE + 0x0)
#define HLLC_HLLC_PCS_PCS_MISC_CFG_REG (HLLC_HLLC_PCS_BASE + 0x4)
#define HLLC_HLLC_PCS_PCS_POLARITY_CFG_REG (HLLC_HLLC_PCS_BASE + 0x8)
#define HLLC_HLLC_PCS_PCS_TRAINING_CFG_REG (HLLC_HLLC_PCS_BASE + 0xC)
#define HLLC_HLLC_PCS_PLL_PHASE_ADJUST_PARAM_CFG_REG (HLLC_HLLC_PCS_BASE + 0x10)
#define HLLC_HLLC_PCS_PCS_PHASE_ADJUST_MODE_CTRL_REG (HLLC_HLLC_PCS_BASE + 0x14)
#define HLLC_HLLC_PCS_PCS_SRC_SYNC_PD_EN_CFG_REG (HLLC_HLLC_PCS_BASE + 0x18)
#define HLLC_HLLC_PCS_PCS_SRC_SYNC_RD_PTR_MODE_CFG_REG (HLLC_HLLC_PCS_BASE + 0x1C)
#define HLLC_HLLC_PCS_PCS_SRC_SYNC_RD_PTR_CFG_REG (HLLC_HLLC_PCS_BASE + 0x20)
#define HLLC_HLLC_PCS_PCS_PARALLEL_LOOPBACK_CFG_REG (HLLC_HLLC_PCS_BASE + 0x24)
#define HLLC_HLLC_PCS_PCS_TRAINING_TIMEOUT_CFG_REG (HLLC_HLLC_PCS_BASE + 0x28)
#define HLLC_HLLC_PCS_RAS_INT_MASK_REG (HLLC_HLLC_PCS_BASE + 0x3C)
#define HLLC_HLLC_PCS_RAS_INT_STATUS_REG (HLLC_HLLC_PCS_BASE + 0x40)
#define HLLC_HLLC_PCS_HILINK_STATUS_REG (HLLC_HLLC_PCS_BASE + 0x44)
#define HLLC_HLLC_PCS_PCS_TX_TRAINING_STS_0_REG (HLLC_HLLC_PCS_BASE + 0x48)
#define HLLC_HLLC_PCS_PCS_TX_TRAINING_STS_1_REG (HLLC_HLLC_PCS_BASE + 0x4C)
#define HLLC_HLLC_PCS_PCS_TX_TRAINING_STS_2_REG (HLLC_HLLC_PCS_BASE + 0x50)
#define HLLC_HLLC_PCS_PCS_TX_TRAINING_STS_3_REG (HLLC_HLLC_PCS_BASE + 0x54)
#define HLLC_HLLC_PCS_PCS_TX_TRAINING_STS_4_REG (HLLC_HLLC_PCS_BASE + 0x58)
#define HLLC_HLLC_PCS_PCS_TX_TRAINING_STS_5_REG (HLLC_HLLC_PCS_BASE + 0x5C)
#define HLLC_HLLC_PCS_PCS_TX_TRAINING_STS_6_REG (HLLC_HLLC_PCS_BASE + 0x60)
#define HLLC_HLLC_PCS_PCS_TX_TRAINING_STS_7_REG (HLLC_HLLC_PCS_BASE + 0x64)
#define HLLC_HLLC_PCS_PCS_RX_TRAINING_STS_0_REG (HLLC_HLLC_PCS_BASE + 0x68)
#define HLLC_HLLC_PCS_PCS_RX_TRAINING_STS_1_REG (HLLC_HLLC_PCS_BASE + 0x6C)
#define HLLC_HLLC_PCS_PCS_RX_TRAINING_STS_2_REG (HLLC_HLLC_PCS_BASE + 0x70)
#define HLLC_HLLC_PCS_PCS_RX_TRAINING_STS_3_REG (HLLC_HLLC_PCS_BASE + 0x74)
#define HLLC_HLLC_PCS_PCS_RX_TRAINING_STS_4_REG (HLLC_HLLC_PCS_BASE + 0x78)
#define HLLC_HLLC_PCS_PCS_RX_TRAINING_STS_5_REG (HLLC_HLLC_PCS_BASE + 0x7C)
#define HLLC_HLLC_PCS_PCS_RX_TRAINING_STS_6_REG (HLLC_HLLC_PCS_BASE + 0x80)
#define HLLC_HLLC_PCS_PCS_RX_TRAINING_STS_7_REG (HLLC_HLLC_PCS_BASE + 0x84)
#define HLLC_HLLC_PCS_PCS_PHASE_ADJUST_STATUS_REG (HLLC_HLLC_PCS_BASE + 0x90)
#define HLLC_HLLC_PCS_PCS_PHASE_ADJUST_PD_STATUS_REG (HLLC_HLLC_PCS_BASE + 0x94)
#define HLLC_HLLC_PCS_PCS_PHASE_ADJUST_CNT_REG (HLLC_HLLC_PCS_BASE + 0x98)
#define HLLC_HLLC_PCS_PCS_SRC_SYNC_PD_STATUS_0_REG (HLLC_HLLC_PCS_BASE + 0xA0)
#define HLLC_HLLC_PCS_PCS_SRC_SYNC_PD_STATUS_1_REG (HLLC_HLLC_PCS_BASE + 0xA4)
#define HLLC_HLLC_PCS_PCS_SRC_SYNC_PD_STATUS_2_REG (HLLC_HLLC_PCS_BASE + 0xA8)
#define HLLC_HLLC_PCS_PCS_SRC_SYNC_PD_STATUS_3_REG (HLLC_HLLC_PCS_BASE + 0xAC)
#define HLLC_HLLC_PCS_PCS_SRC_SYNC_PD_STATUS_4_REG (HLLC_HLLC_PCS_BASE + 0xB0)
#define HLLC_HLLC_PCS_PCS_SRC_SYNC_PD_STATUS_5_REG (HLLC_HLLC_PCS_BASE + 0xB4)
#define HLLC_HLLC_PCS_PCS_SRC_SYNC_PD_STATUS_6_REG (HLLC_HLLC_PCS_BASE + 0xB8)
#define HLLC_HLLC_PCS_PCS_SRC_SYNC_PD_STATUS_7_REG (HLLC_HLLC_PCS_BASE + 0xBC)
#define HLLC_HLLC_PCS_PCS_RX_DESKEW_CNT_0_REG (HLLC_HLLC_PCS_BASE + 0xD0)
#define HLLC_HLLC_PCS_PCS_RX_DESKEW_CNT_1_REG (HLLC_HLLC_PCS_BASE + 0xD4)
#define HLLC_HLLC_PCS_PCS_RX_DESKEW_CNT_2_REG (HLLC_HLLC_PCS_BASE + 0xD8)
#define HLLC_HLLC_PCS_PCS_RX_DESKEW_CNT_3_REG (HLLC_HLLC_PCS_BASE + 0xDC)
#define HLLC_HLLC_PCS_PCS_RX_DESKEW_CNT_4_REG (HLLC_HLLC_PCS_BASE + 0xE0)
#define HLLC_HLLC_PCS_PCS_RX_DESKEW_CNT_5_REG (HLLC_HLLC_PCS_BASE + 0xE4)
#define HLLC_HLLC_PCS_PCS_RX_DESKEW_CNT_6_REG (HLLC_HLLC_PCS_BASE + 0xE8)
#define HLLC_HLLC_PCS_PCS_RX_DESKEW_CNT_7_REG (HLLC_HLLC_PCS_BASE + 0xEC)
#define HLLC_HLLC_PCS_PCS_RX_HEAD_ILLEGAL_STATUS_REG (HLLC_HLLC_PCS_BASE + 0xF0)
#define HLLC_HLLC_PCS_PCS_BIST_START_REG (HLLC_HLLC_PCS_BASE + 0x100)
#define HLLC_HLLC_PCS_PCS_TEST_END_REG (HLLC_HLLC_PCS_BASE + 0x104)
#define HLLC_HLLC_PCS_PCS_BIST_CTRL_CFG_REG (HLLC_HLLC_PCS_BASE + 0x108)
#define HLLC_HLLC_PCS_PCS_BIST_MODE_CFG_REG (HLLC_HLLC_PCS_BASE + 0x10C)
#define HLLC_HLLC_PCS_PCS_BIST_PRBS_STS_0_REG (HLLC_HLLC_PCS_BASE + 0x110)
#define HLLC_HLLC_PCS_PCS_BIST_PRBS_STS_1_REG (HLLC_HLLC_PCS_BASE + 0x114)
#define HLLC_HLLC_PCS_PCS_BIST_PRBS_STS_2_REG (HLLC_HLLC_PCS_BASE + 0x118)
#define HLLC_HLLC_PCS_PCS_BIST_PRBS_STS_3_REG (HLLC_HLLC_PCS_BASE + 0x11C)
#define HLLC_HLLC_PCS_PCS_BIST_PRBS_STS_4_REG (HLLC_HLLC_PCS_BASE + 0x120)
#define HLLC_HLLC_PCS_PCS_BIST_PRBS_STS_5_REG (HLLC_HLLC_PCS_BASE + 0x124)
#define HLLC_HLLC_PCS_PCS_BIST_PRBS_STS_6_REG (HLLC_HLLC_PCS_BASE + 0x128)
#define HLLC_HLLC_PCS_PCS_BIST_PRBS_STS_7_REG (HLLC_HLLC_PCS_BASE + 0x12C)
#define HLLC_HLLC_PCS_PCS_BIST_FLIT_STS_REG (HLLC_HLLC_PCS_BASE + 0x130)
#define HLLC_HLLC_PCS_PCS_BIST_SLICE_STS_0_REG (HLLC_HLLC_PCS_BASE + 0x134)
#define HLLC_HLLC_PCS_PCS_BIST_SLICE_STS_1_REG (HLLC_HLLC_PCS_BASE + 0x138)
#define HLLC_HLLC_PCS_PCS_BIST_SLICE_STS_2_REG (HLLC_HLLC_PCS_BASE + 0x13C)
#define HLLC_HLLC_PCS_PCS_BIST_SLICE_STS_3_REG (HLLC_HLLC_PCS_BASE + 0x140)
#define HLLC_HLLC_PCS_PCS_BIST_SLICE_STS_4_REG (HLLC_HLLC_PCS_BASE + 0x144)
#define HLLC_HLLC_PCS_PCS_BIST_SLICE_STS_5_REG (HLLC_HLLC_PCS_BASE + 0x148)
#define HLLC_HLLC_PCS_PCS_BIST_SLICE_STS_6_REG (HLLC_HLLC_PCS_BASE + 0x14C)
#define HLLC_HLLC_PCS_PCS_BIST_SLICE_STS_7_REG (HLLC_HLLC_PCS_BASE + 0x150)
#endif
