/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2019 Hisilicon Limited, All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef __PA_REG_OFFSET_H__
#define __PA_REG_OFFSET_H__

/* PA Base address of Module's Register */
#define PA_PA_BASE (0x0)

/******************************************************************************/
/*					  xxx PA Registers' Definitions */
/******************************************************************************/

#define PA_PA_ID_MAPPING_CFG_REG (PA_PA_BASE + 0x0)
#define PA_PA_GLOBAL_CFG_REG (PA_PA_BASE + 0x4)
#define PA_PA_LINK_DOWN_CFG_REG (PA_PA_BASE + 0x8)
#define PA_PA_HYDRA_PORT0_MISC_CFG0_REG (PA_PA_BASE + 0xC)
#define PA_PA_HYDRA_PORT1_MISC_CFG0_REG (PA_PA_BASE + 0x10)
#define PA_PA_HYDRA_PORT2_MISC_CFG0_REG (PA_PA_BASE + 0x14)
#define PA_PA_HYDRA_PORT0_MISC_CFG1_REG (PA_PA_BASE + 0x18)
#define PA_PA_HYDRA_PORT1_MISC_CFG1_REG (PA_PA_BASE + 0x1C)
#define PA_PA_HYDRA_PORT2_MISC_CFG1_REG (PA_PA_BASE + 0x20)
#define PA_PA_TX_HALT_CFG_REG (PA_PA_BASE + 0x24)
#define PA_PA_RX_REQHALT_CFG_REG (PA_PA_BASE + 0x28)
#define PA_PA_RX_SNPHALT_CFG_REG (PA_PA_BASE + 0x2C)
#define PA_PA_RX_RSPHALT_CFG_REG (PA_PA_BASE + 0x30)
#define PA_PA_RX_DATHALT_CFG_REG (PA_PA_BASE + 0x34)
#define PA_PA_MEM_ECC_CORRECT_CFG_REG (PA_PA_BASE + 0x38)
#define PA_PA_DAW_BYP_TGTID_CFG_REG (PA_PA_BASE + 0x3C)
#define PA_PA_DDR_UTL_UPDATE_PERIOD_CFG_REG (PA_PA_BASE + 0x40)
#define PA_PA_STREAM_WRITE_SRCID0_CFG_REG (PA_PA_BASE + 0x44)
#define PA_PA_STREAM_WRITE_SRCID1_CFG_REG (PA_PA_BASE + 0x48)
#define PA_PA_COPYBACK_BP_TH_CFG_REG (PA_PA_BASE + 0x4C)
#define PA_PA_EXTEND_DEFAULT_SLV_TGTID_CFG_REG (PA_PA_BASE + 0x50)
#define PA_PA_IO_PERF_OPT_SRCID_CFG_REG (PA_PA_BASE + 0x54)
#define PA_PA_IO_PER_OPT_CTRL_CFG_REG (PA_PA_BASE + 0x58)
#define PA_PA_PREFETCH_TGT_CFG_REG (PA_PA_BASE + 0x5C)
#define PA_PA_ECO_RSV_REG1_REG (PA_PA_BASE + 0x60)
#define PA_PA_EMU_VERSION_REG_REG (PA_PA_BASE + 0x64)
#define PA_PA_FPGA_VERSION_REG_REG (PA_PA_BASE + 0x68)
#define PA_PA_INTMASK_REG (PA_PA_BASE + 0x70)
#define PA_PA_RAWINT_REG (PA_PA_BASE + 0x74)
#define PA_PA_INTSTS_REG (PA_PA_BASE + 0x78)
#define PA_PA_INTCLR_REG (PA_PA_BASE + 0x7C)
#define PA_PA_H0_TX_REQ_CURR_CNT_REG (PA_PA_BASE + 0x400)
#define PA_PA_H0_TX_CA_REQ_CURR_CNT_REG (PA_PA_BASE + 0x404)
#define PA_PA_H0_TX_NC_REQ_CURR_CNT_REG (PA_PA_BASE + 0x408)
#define PA_PA_H0_TX_P2P_CURR_CNT_REG (PA_PA_BASE + 0x40C)
#define PA_PA_H0_TX_FWD_CURR_CNT_REG (PA_PA_BASE + 0x410)
#define PA_PA_H1_TX_REQ_CURR_CNT_REG (PA_PA_BASE + 0x420)
#define PA_PA_H1_TX_CA_REQ_CURR_CNT_REG (PA_PA_BASE + 0x424)
#define PA_PA_H1_TX_NC_REQ_CURR_CNT_REG (PA_PA_BASE + 0x428)
#define PA_PA_H1_TX_P2P_CURR_CNT_REG (PA_PA_BASE + 0x42C)
#define PA_PA_H1_TX_FWD_CURR_CNT_REG (PA_PA_BASE + 0x430)
#define PA_PA_H2_TX_REQ_CURR_CNT_REG (PA_PA_BASE + 0x440)
#define PA_PA_H2_TX_CA_REQ_CURR_CNT_REG (PA_PA_BASE + 0x444)
#define PA_PA_H2_TX_NC_REQ_CURR_CNT_REG (PA_PA_BASE + 0x448)
#define PA_PA_H2_TX_P2P_CURR_CNT_REG (PA_PA_BASE + 0x44C)
#define PA_PA_H2_TX_FWD_CURR_CNT_REG (PA_PA_BASE + 0x450)
#define PA_PA_TX_REQ_CNT_REG (PA_PA_BASE + 0x460)
#define PA_PA_TX_SNP_CNT_REG (PA_PA_BASE + 0x464)
#define PA_PA_TX_RSP_CNT_REG (PA_PA_BASE + 0x468)
#define PA_PA_TX_DAT_CNT_REG (PA_PA_BASE + 0x46C)
#define PA_PA_TX_CA_RETRYACK_CNT_REG (PA_PA_BASE + 0x470)
#define PA_PA_TX_NC_RETRYACK_CNT_REG (PA_PA_BASE + 0x474)
#define PA_PA_TX_P2P_RETRYACK_CNT_REG (PA_PA_BASE + 0x478)
#define PA_PA_TX_CA_PGNT_CNT_REG (PA_PA_BASE + 0x47C)
#define PA_PA_TX_NC_PGNT_CNT_REG (PA_PA_BASE + 0x480)
#define PA_PA_TX_P2P_PGNT_CNT_REG (PA_PA_BASE + 0x484)
#define PA_PA_TX_PCRDRETURN_CNT_REG (PA_PA_BASE + 0x488)
#define PA_PA_TX_MEM_ERR_CNT_REG (PA_PA_BASE + 0x48C)
#define PA_PA_TX_MEM_ERR_HIS_ST_REG (PA_PA_BASE + 0x490)
#define PA_PA_TX_HYDRA_BP_HIS_ST_REG (PA_PA_BASE + 0x494)
#define PA_PA_TX_BUFF_HALT_HIS_ST_REG (PA_PA_BASE + 0x498)
#define PA_PA_TX_BUFF_FIFO_ST_REG (PA_PA_BASE + 0x49C)
#define PA_PA_H0_TX_FIFO_EMPTY_ST_REG (PA_PA_BASE + 0x4A0)
#define PA_PA_H1_TX_FIFO_EMPTY_ST_REG (PA_PA_BASE + 0x4A4)
#define PA_PA_H2_TX_FIFO_EMPTY_ST_REG (PA_PA_BASE + 0x4A8)
#define PA_PA_H0_TX_FIFO_FULL_ST_REG (PA_PA_BASE + 0x4AC)
#define PA_PA_H1_TX_FIFO_FULL_ST_REG (PA_PA_BASE + 0x4B0)
#define PA_PA_H2_TX_FIFO_FULL_ST_REG (PA_PA_BASE + 0x4B4)
#define PA_PA_H0_TX_MEM_ERR_ADDR_REG (PA_PA_BASE + 0x4B8)
#define PA_PA_H1_TX_MEM_ERR_ADDR_REG (PA_PA_BASE + 0x4BC)
#define PA_PA_H2_TX_MEM_ERR_ADDR_REG (PA_PA_BASE + 0x4C0)
#define PA_PA_H0_TX_RSP_ERR_INFO_REG (PA_PA_BASE + 0x4C4)
#define PA_PA_H1_TX_RSP_ERR_INFO_REG (PA_PA_BASE + 0x4C8)
#define PA_PA_H2_TX_RSP_ERR_INFO_REG (PA_PA_BASE + 0x4CC)
#define PA_PA_TX_BUFF_FIFO_OF_HIS_ST_REG (PA_PA_BASE + 0x4D0)
#define PA_PA_H0_TX_FIFO_OF_HIS_ST_REG (PA_PA_BASE + 0x4D4)
#define PA_PA_H1_TX_FIFO_OF_HIS_ST_REG (PA_PA_BASE + 0x4D8)
#define PA_PA_H2_TX_FIFO_OF_HIS_ST_REG (PA_PA_BASE + 0x4DC)
#define PA_PA_H0_TX_REQ_ERR_INFO_REG (PA_PA_BASE + 0x4E0)
#define PA_PA_H1_TX_REQ_ERR_INFO_REG (PA_PA_BASE + 0x4E4)
#define PA_PA_H2_TX_REQ_ERR_INFO_REG (PA_PA_BASE + 0x4E8)
#define PA_PA_H0_RX_REQ_WDATA_BUFF_CNT_REG (PA_PA_BASE + 0x500)
#define PA_PA_H0_RX_REQ_CA_CURR_CNT_REG (PA_PA_BASE + 0x504)
#define PA_PA_H0_RX_REQ_SW_CURR_CNT_REG (PA_PA_BASE + 0x508)
#define PA_PA_H0_RX_REQ_CA_ADDR_CNT_REG (PA_PA_BASE + 0x50C)
#define PA_PA_H0_RX_REQ_NC_CURR_CNT_REG (PA_PA_BASE + 0x510)
#define PA_PA_H0_RX_REQ_NCFWD_CURR_CNT_REG (PA_PA_BASE + 0x514)
#define PA_PA_H0_RX_SNP_CURR_CNT_REG (PA_PA_BASE + 0x518)
#define PA_PA_H0_RX_COMPDBID_CURR_CNT_REG (PA_PA_BASE + 0x51C)
#define PA_PA_H0_RX_SNPRSP_BUFF_CNT_REG (PA_PA_BASE + 0x520)
#define PA_PA_H0_RX_REQ_RETRY_ACK_CNT_REG (PA_PA_BASE + 0x524)
#define PA_PA_H0_RX_REQ_PGNT_CNT_REG (PA_PA_BASE + 0x528)
#define PA_PA_H0_RX_FIFO_EMPTY_ST_REG (PA_PA_BASE + 0x52C)
#define PA_PA_H0_RX_FIFO_FULL_ST_REG (PA_PA_BASE + 0x530)
#define PA_PA_H0_RX_REQ_DAW_ERR_INFO_REG (PA_PA_BASE + 0x534)
#define PA_PA_H0_RX_REQ_MEM_ERR_ADDR_REG (PA_PA_BASE + 0x538)
#define PA_PA_H0_RX_SNPRSP_MEM_ERR_ADDR_REG (PA_PA_BASE + 0x53C)
#define PA_PA_H0_RX_SNP_RSP_MEM_ERR_ADDR_REG (PA_PA_BASE + 0x540)
#define PA_PA_H0_RX_STREAM_WR_BUFF_CNT_REG (PA_PA_BASE + 0x544)
#define PA_PA_H0_RX_BUFF_OF_HIS_ST_REG (PA_PA_BASE + 0x548)
#define PA_PA_H1_RX_REQ_WDATA_BUFF_CNT_REG (PA_PA_BASE + 0x600)
#define PA_PA_H1_RX_REQ_CA_CURR_CNT_REG (PA_PA_BASE + 0x604)
#define PA_PA_H1_RX_REQ_SW_CURR_CNT_REG (PA_PA_BASE + 0x608)
#define PA_PA_H1_RX_REQ_CA_ADDR_CNT_REG (PA_PA_BASE + 0x60C)
#define PA_PA_H1_RX_REQ_NC_CURR_CNT_REG (PA_PA_BASE + 0x610)
#define PA_PA_H1_RX_REQ_NCFWD_CURR_CNT_REG (PA_PA_BASE + 0x614)
#define PA_PA_H1_RX_SNP_CURR_CNT_REG (PA_PA_BASE + 0x618)
#define PA_PA_H1_RX_COMPDBID_CURR_CNT_REG (PA_PA_BASE + 0x61C)
#define PA_PA_H1_RX_SNPRSP_BUFF_CNT_REG (PA_PA_BASE + 0x620)
#define PA_PA_H1_RX_REQ_RETRY_ACK_CNT_REG (PA_PA_BASE + 0x624)
#define PA_PA_H1_RX_REQ_PGNT_CNT_REG (PA_PA_BASE + 0x628)
#define PA_PA_H1_RX_FIFO_EMPTY_ST_REG (PA_PA_BASE + 0x62C)
#define PA_PA_H1_RX_FIFO_FULL_ST_REG (PA_PA_BASE + 0x630)
#define PA_PA_H1_RX_REQ_DAW_ERR_INFO_REG (PA_PA_BASE + 0x634)
#define PA_PA_H1_RX_REQ_MEM_ERR_ADDR_REG (PA_PA_BASE + 0x638)
#define PA_PA_H1_RX_SNPRSP_MEM_ERR_ADDR_REG (PA_PA_BASE + 0x63C)
#define PA_PA_H1_RX_SNP_RSP_MEM_ERR_ADDR_REG (PA_PA_BASE + 0x640)
#define PA_PA_H1_RX_STREAM_WR_BUFF_CNT_REG (PA_PA_BASE + 0x644)
#define PA_PA_H1_RX_BUFF_OF_HIS_ST_REG (PA_PA_BASE + 0x648)
#define PA_PA_H2_RX_REQ_WDATA_BUFF_CNT_REG (PA_PA_BASE + 0x700)
#define PA_PA_H2_RX_REQ_CA_CURR_CNT_REG (PA_PA_BASE + 0x704)
#define PA_PA_H2_RX_REQ_SW_CURR_CNT_REG (PA_PA_BASE + 0x708)
#define PA_PA_H2_RX_REQ_CA_ADDR_CNT_REG (PA_PA_BASE + 0x70C)
#define PA_PA_H2_RX_REQ_NC_CURR_CNT_REG (PA_PA_BASE + 0x710)
#define PA_PA_H2_RX_REQ_NCFWD_CURR_CNT_REG (PA_PA_BASE + 0x714)
#define PA_PA_H2_RX_SNP_CURR_CNT_REG (PA_PA_BASE + 0x718)
#define PA_PA_H2_RX_COMPDBID_CURR_CNT_REG (PA_PA_BASE + 0x71C)
#define PA_PA_H2_RX_SNPRSP_BUFF_CNT_REG (PA_PA_BASE + 0x720)
#define PA_PA_H2_RX_REQ_RETRY_ACK_CNT_REG (PA_PA_BASE + 0x724)
#define PA_PA_H2_RX_REQ_PGNT_CNT_REG (PA_PA_BASE + 0x728)
#define PA_PA_H2_RX_FIFO_EMPTY_ST_REG (PA_PA_BASE + 0x72C)
#define PA_PA_H2_RX_FIFO_FULL_ST_REG (PA_PA_BASE + 0x730)
#define PA_PA_H2_RX_REQ_DAW_ERR_INFO_REG (PA_PA_BASE + 0x734)
#define PA_PA_H2_RX_REQ_MEM_ERR_ADDR_REG (PA_PA_BASE + 0x738)
#define PA_PA_H2_RX_SNPRSP_MEM_ERR_ADDR_REG (PA_PA_BASE + 0x73C)
#define PA_PA_H2_RX_SNP_RSP_MEM_ERR_ADDR_REG (PA_PA_BASE + 0x740)
#define PA_PA_H2_RX_STREAM_WR_BUFF_CNT_REG (PA_PA_BASE + 0x744)
#define PA_PA_H2_RX_BUFF_OF_HIS_ST_REG (PA_PA_BASE + 0x748)
#define PA_PA_RX_REQ_CNT_REG (PA_PA_BASE + 0x800)
#define PA_PA_RX_SNP_CNT_REG (PA_PA_BASE + 0x804)
#define PA_PA_RX_RSP_CNT_REG (PA_PA_BASE + 0x808)
#define PA_PA_RX_DAT_CNT_REG (PA_PA_BASE + 0x80C)
#define PA_PA_RX_RETINFO_SCH_FIFO_EMPTY_ST_REG (PA_PA_BASE + 0x810)
#define PA_PA_RX_RETINFO_SCH_FIFO_FULL_ST_REG (PA_PA_BASE + 0x814)
#define PA_PA_RX_REQ_SCH_FIFO_ST_REG (PA_PA_BASE + 0x818)
#define PA_PA_RX_SNP_SCH_FIFO_ST_REG (PA_PA_BASE + 0x81C)
#define PA_PA_RX_RSP_SCH_FIFO_ST_REG (PA_PA_BASE + 0x820)
#define PA_PA_RX_DAT_SCH_FIFO_ST_REG (PA_PA_BASE + 0x824)
#define PA_PA_RX_MEM_ECC_1BIT_ERR_HIS_ST_REG (PA_PA_BASE + 0x828)
#define PA_PA_RX_MEM_ECC_2BIT_ERR_HIS_ST_REG (PA_PA_BASE + 0x82C)
#define PA_PA_RX_MEM_ERR_CNT_REG (PA_PA_BASE + 0x830)
#define PA_PA_RX_SKY_LINK_BP_ST_REG (PA_PA_BASE + 0x834)
#define PA_PA_RX_SKY_LINK_BP_HIS_ST_REG (PA_PA_BASE + 0x838)
#define PA_PA_RX_BUFF_HALT_HIS_ST_REG (PA_PA_BASE + 0x83C)
#define PA_PA_RX_SCH_FIFO_OF_HIS_ST_REG (PA_PA_BASE + 0x840)
#define PA_PA_RX_RETINFO_FIFO_OF_HIS_ST_REG (PA_PA_BASE + 0x844)
#define PA_PA_MEM_ERR_INJECT_CFG_REG (PA_PA_BASE + 0x850)
#define PA_PA_DID_HHA_ID_CFG0_REG (PA_PA_BASE + 0x860)
#define PA_PA_DID_HHA_ID_CFG1_REG (PA_PA_BASE + 0x864)
#define PA_PA_DID_HHA_ID_CFG2_REG (PA_PA_BASE + 0x868)
#define PA_PA_DID_HHA_ID_CFG3_REG (PA_PA_BASE + 0x86C)
#define PA_PA_DID_L3T_ID_CFG_REG (PA_PA_BASE + 0x870)
#define PA_PA_DID_DEFAULT_SLV_ID_CFG_REG (PA_PA_BASE + 0x874)
#define PA_PA_CER_IDR_REG (PA_PA_BASE + 0xC10)
#define PA_PA_CER_IDR_MODIFY_EN_REG (PA_PA_BASE + 0xC14)
#define PA_PA_ERR_FRL_REG (PA_PA_BASE + 0x2000)
#define PA_PA_ERR_FRH_REG (PA_PA_BASE + 0x2004)
#define PA_PA_ERR_CTRLL_REG (PA_PA_BASE + 0x2008)
#define PA_PA_ERR_CTRLH_REG (PA_PA_BASE + 0x200C)
#define PA_PA_ERR_STATUSL_REG (PA_PA_BASE + 0x2010)
#define PA_PA_ERR_STATUSH_REG (PA_PA_BASE + 0x2014)
#define PA_PA_ERR_ADDRL_REG (PA_PA_BASE + 0x2018)
#define PA_PA_ERR_ADDRH_REG (PA_PA_BASE + 0x201C)
#define PA_PA_ERR_MISC0L_REG (PA_PA_BASE + 0x2020)
#define PA_PA_ERR_MISC0H_REG (PA_PA_BASE + 0x2024)
#define PA_PA_ERR_MISC1L_REG (PA_PA_BASE + 0x2028)
#define PA_PA_ERR_MISC1H_REG (PA_PA_BASE + 0x202C)

#endif
