/*
 * arch/arm/mach-ixp4xx/include/mach/irqs.h 
 *
 * IRQ definitions for IXP4XX based systems
 *
 * Copyright (C) 2002 Intel Corporation.
 * Copyright (C) 2003 MontaVista Software, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

#ifndef _ARCH_IXP4XX_IRQS_H_
#define _ARCH_IXP4XX_IRQS_H_

#define IRQ_IXP4XX_BASE		16

#define IRQ_IXP4XX_NPEA		(IRQ_IXP4XX_BASE + 0)
#define IRQ_IXP4XX_NPEB		(IRQ_IXP4XX_BASE + 1)
#define IRQ_IXP4XX_NPEC		(IRQ_IXP4XX_BASE + 2)
#define IRQ_IXP4XX_QM1		(IRQ_IXP4XX_BASE + 3)
#define IRQ_IXP4XX_QM2		(IRQ_IXP4XX_BASE + 4)
#define IRQ_IXP4XX_TIMER1	(IRQ_IXP4XX_BASE + 5)
#define IRQ_IXP4XX_GPIO0	(IRQ_IXP4XX_BASE + 6)
#define IRQ_IXP4XX_GPIO1	(IRQ_IXP4XX_BASE + 7)
#define IRQ_IXP4XX_PCI_INT	(IRQ_IXP4XX_BASE + 8)
#define IRQ_IXP4XX_PCI_DMA1	(IRQ_IXP4XX_BASE + 9)
#define IRQ_IXP4XX_PCI_DMA2	(IRQ_IXP4XX_BASE + 10)
#define IRQ_IXP4XX_TIMER2	(IRQ_IXP4XX_BASE + 11)
#define IRQ_IXP4XX_USB		(IRQ_IXP4XX_BASE + 12)
#define IRQ_IXP4XX_UART2	(IRQ_IXP4XX_BASE + 13)
#define IRQ_IXP4XX_TIMESTAMP	(IRQ_IXP4XX_BASE + 14)
#define IRQ_IXP4XX_UART1	(IRQ_IXP4XX_BASE + 15)
#define IRQ_IXP4XX_WDOG		(IRQ_IXP4XX_BASE + 16)
#define IRQ_IXP4XX_AHB_PMU	(IRQ_IXP4XX_BASE + 17)
#define IRQ_IXP4XX_XSCALE_PMU	(IRQ_IXP4XX_BASE + 18)
#define IRQ_IXP4XX_GPIO2	(IRQ_IXP4XX_BASE + 19)
#define IRQ_IXP4XX_GPIO3	(IRQ_IXP4XX_BASE + 20)
#define IRQ_IXP4XX_GPIO4	(IRQ_IXP4XX_BASE + 21)
#define IRQ_IXP4XX_GPIO5	(IRQ_IXP4XX_BASE + 22)
#define IRQ_IXP4XX_GPIO6	(IRQ_IXP4XX_BASE + 23)
#define IRQ_IXP4XX_GPIO7	(IRQ_IXP4XX_BASE + 24)
#define IRQ_IXP4XX_GPIO8	(IRQ_IXP4XX_BASE + 25)
#define IRQ_IXP4XX_GPIO9	(IRQ_IXP4XX_BASE + 26)
#define IRQ_IXP4XX_GPIO10	(IRQ_IXP4XX_BASE + 27)
#define IRQ_IXP4XX_GPIO11	(IRQ_IXP4XX_BASE + 28)
#define IRQ_IXP4XX_GPIO12	(IRQ_IXP4XX_BASE + 29)
#define IRQ_IXP4XX_SW_INT1	(IRQ_IXP4XX_BASE + 30)
#define IRQ_IXP4XX_SW_INT2	(IRQ_IXP4XX_BASE + 31)
#define IRQ_IXP4XX_USB_HOST	(IRQ_IXP4XX_BASE + 32)
#define IRQ_IXP4XX_I2C		(IRQ_IXP4XX_BASE + 33)
#define IRQ_IXP4XX_SSP		(IRQ_IXP4XX_BASE + 34)
#define IRQ_IXP4XX_TSYNC	(IRQ_IXP4XX_BASE + 35)
#define IRQ_IXP4XX_EAU_DONE	(IRQ_IXP4XX_BASE + 36)
#define IRQ_IXP4XX_SHA_DONE	(IRQ_IXP4XX_BASE + 37)
#define IRQ_IXP4XX_SWCP_PE	(IRQ_IXP4XX_BASE + 58)
#define IRQ_IXP4XX_QM_PE	(IRQ_IXP4XX_BASE + 60)
#define IRQ_IXP4XX_MCU_ECC	(IRQ_IXP4XX_BASE + 61)
#define IRQ_IXP4XX_EXP_PE	(IRQ_IXP4XX_BASE + 62)

#define _IXP4XX_GPIO_IRQ(n)	(IRQ_IXP4XX_GPIO ## n)
#define IXP4XX_GPIO_IRQ(n)	_IXP4XX_GPIO_IRQ(n)

#define	XSCALE_PMU_IRQ		(IRQ_IXP4XX_XSCALE_PMU)

#endif
