// SPDX-License-Identifier: GPL-2.0

//! C types for the bindings.
//!
//! The bindings generated by `bindgen` use these types to map to the C ones.
//!
//! C's standard integer types may differ in width depending on
//! the architecture, thus we need to conditionally compile those.

#![allow(non_camel_case_types)]

#[cfg(any(target_arch = "arm", target_arch = "x86", target_arch = "riscv32",))]
mod c {
    /// C `void` type.
    pub type c_void = core::ffi::c_void;

    /// C `char` type.
    pub type c_char = i8;

    /// C `signed char` type.
    pub type c_schar = i8;

    /// C `unsigned char` type.
    pub type c_uchar = u8;

    /// C `short` type.
    pub type c_short = i16;

    /// C `unsigned short` type.
    pub type c_ushort = u16;

    /// C `int` type.
    pub type c_int = i32;

    /// C `unsigned int` type.
    pub type c_uint = u32;

    /// C `long` type.
    pub type c_long = i32;

    /// C `unsigned long` type.
    pub type c_ulong = u32;

    /// C `long long` type.
    pub type c_longlong = i64;

    /// C `unsigned long long` type.
    pub type c_ulonglong = u64;

    /// C `ssize_t` type (typically defined in `<sys/types.h>` by POSIX).
    ///
    /// For some 32-bit architectures like this one, the kernel defines it as
    /// `int`, i.e. it is an [`i32`].
    pub type c_ssize_t = isize;

    /// C `size_t` type (typically defined in `<stddef.h>`).
    ///
    /// For some 32-bit architectures like this one, the kernel defines it as
    /// `unsigned int`, i.e. it is an [`u32`].
    pub type c_size_t = usize;
}

#[cfg(any(
    target_arch = "aarch64",
    target_arch = "x86_64",
    target_arch = "powerpc64",
    target_arch = "riscv64",
))]
mod c {
    /// C `void` type.
    pub type c_void = core::ffi::c_void;

    /// C `char` type.
    pub type c_char = i8;

    /// C `signed char` type.
    pub type c_schar = i8;

    /// C `unsigned char` type.
    pub type c_uchar = u8;

    /// C `short` type.
    pub type c_short = i16;

    /// C `unsigned short` type.
    pub type c_ushort = u16;

    /// C `int` type.
    pub type c_int = i32;

    /// C `unsigned int` type.
    pub type c_uint = u32;

    /// C `long` type.
    pub type c_long = i64;

    /// C `unsigned long` type.
    pub type c_ulong = u64;

    /// C `long long` type.
    pub type c_longlong = i64;

    /// C `unsigned long long` type.
    pub type c_ulonglong = u64;

    /// C `ssize_t` type (typically defined in `<sys/types.h>` by POSIX).
    ///
    /// For 64-bit architectures like this one, the kernel defines it as
    /// `long`, i.e. it is an [`i64`].
    pub type c_ssize_t = isize;

    /// C `size_t` type (typically defined in `<stddef.h>`).
    ///
    /// For 64-bit architectures like this one, the kernel defines it as
    /// `unsigned long`, i.e. it is an [`u64`].
    pub type c_size_t = usize;
}

pub use c::*;
