/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2019 Hisilicon Limited, All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef __DMC_REG_OFFSET_H__
#define __DMC_REG_OFFSET_H__

/* DMC Base address of Module's Register */
#define DMC_DMC_BASE (0x0)

/******************************************************************************/
/*					  xxx DMC Registers' Definitions */
/******************************************************************************/
#define DMC_DMC_DDRC_CTRL_SREF_REG (DMC_DMC_BASE + 0x0)
#define DMC_DMC_DDRC_CTRL_INIT_REG (DMC_DMC_BASE + 0x4)
#define DMC_DMC_DDRC_CTRL_DDRRST_REG (DMC_DMC_BASE + 0x8)
#define DMC_DMC_DDRC_CTRL_SFC_REG (DMC_DMC_BASE + 0xC)
#define DMC_DMC_DDRC_CTRL_PERF_REG (DMC_DMC_BASE + 0x10)
#define DMC_DMC_DDRC_CTRL_MTEST_REG (DMC_DMC_BASE + 0x14)
#define DMC_DMC_DDRC_CFG_LP_REG (DMC_DMC_BASE + 0x1C)
#define DMC_DMC_DDRC_CFG_SREF_REG (DMC_DMC_BASE + 0x20)
#define DMC_DMC_DDRC_CFG_PD_REG (DMC_DMC_BASE + 0x28)
#define DMC_DMC_DDRC_CFG_AREF_REG (DMC_DMC_BASE + 0x2C)
#define DMC_DMC_DDRC_CFG_ECC_REG (DMC_DMC_BASE + 0x30)
#define DMC_DMC_DDRC_CFG_ERRINJ_REG (DMC_DMC_BASE + 0x34)
#define DMC_DMC_DDRC_CFG_FIFO_ERRINJ_REG (DMC_DMC_BASE + 0x38)
#define DMC_DMC_DDRC_CFG_OPENPAGE_REG (DMC_DMC_BASE + 0x3C)
#define DMC_DMC_DDRC_CFG_WORKMODE_REG (DMC_DMC_BASE + 0x40)
#define DMC_DMC_DDRC_CFG_WORKMODE2_REG (DMC_DMC_BASE + 0x44)
#define DMC_DMC_DDRC_CFG_WORKMODE3_REG (DMC_DMC_BASE + 0x48)
#define DMC_DMC_DDRC_CFG_DDRMODE_REG (DMC_DMC_BASE + 0x50)
#define DMC_DMC_DDRC_CFG_DIMM_REG (DMC_DMC_BASE + 0x54)
#define DMC_DMC_DDRC_CFG_SCRAMB_REG (DMC_DMC_BASE + 0x58)
#define DMC_DMC_DDRC_CFG_RNKVOL_REG (DMC_DMC_BASE + 0x60)
#define DMC_DMC_DDRC_CFG_ODT_REG (DMC_DMC_BASE + 0xA0)
#define DMC_DMC_DDRC_CFG_CA_ODT_REG (DMC_DMC_BASE + 0xE0)
#define DMC_DMC_DDRC_CFG_TIMING0_REG (DMC_DMC_BASE + 0x100)
#define DMC_DMC_DDRC_CFG_TIMING1_REG (DMC_DMC_BASE + 0x104)
#define DMC_DMC_DDRC_CFG_TIMING2_REG (DMC_DMC_BASE + 0x108)
#define DMC_DMC_DDRC_CFG_TIMING3_REG (DMC_DMC_BASE + 0x10C)
#define DMC_DMC_DDRC_CFG_TIMING4_REG (DMC_DMC_BASE + 0x110)
#define DMC_DMC_DDRC_CFG_TIMING5_REG (DMC_DMC_BASE + 0x114)
#define DMC_DMC_DDRC_CFG_TIMING6_REG (DMC_DMC_BASE + 0x118)
#define DMC_DMC_DDRC_CFG_TIMING7_REG (DMC_DMC_BASE + 0x11C)
#define DMC_DMC_DDRC_CFG_TIMING8_REG (DMC_DMC_BASE + 0x120)
#define DMC_DMC_DDRC_CFG_NXT_TIMING0_REG (DMC_DMC_BASE + 0x124)
#define DMC_DMC_DDRC_CFG_NXT_TIMING1_REG (DMC_DMC_BASE + 0x128)
#define DMC_DMC_DDRC_CFG_NXT_TIMING2_REG (DMC_DMC_BASE + 0x12C)
#define DMC_DMC_DDRC_CFG_NXT_TIMING3_REG (DMC_DMC_BASE + 0x130)
#define DMC_DMC_DDRC_CFG_NXT_TIMING4_REG (DMC_DMC_BASE + 0x134)
#define DMC_DMC_DDRC_CFG_NXT_TIMING5_REG (DMC_DMC_BASE + 0x138)
#define DMC_DMC_DDRC_CFG_NXT_TIMING6_REG (DMC_DMC_BASE + 0x13C)
#define DMC_DMC_DDRC_CFG_NXT_TIMING7_REG (DMC_DMC_BASE + 0x140)
#define DMC_DMC_DDRC_CFG_NXT_TIMING8_REG (DMC_DMC_BASE + 0x144)
#define DMC_DMC_DDRC_CFG_BLDATA_REG (DMC_DMC_BASE + 0x148)
#define DMC_DMC_DDRC_CFG_DMCLVL_REG (DMC_DMC_BASE + 0x14C)
#define DMC_DMC_DDRC_CFG_TIMEOUT_REG (DMC_DMC_BASE + 0x150)
#define DMC_DMC_DDRC_CFG_QOS_REG (DMC_DMC_BASE + 0x154)
#define DMC_DMC_DDRC_CFG_EXMBIST_CMD_REG (DMC_DMC_BASE + 0x158)
#define DMC_DMC_DDRC_CFG_EXMBIST_DAT_REG (DMC_DMC_BASE + 0x15C)
#define DMC_DMC_DDRC_CFG_MBIST_REG (DMC_DMC_BASE + 0x160)
#define DMC_DMC_DDRC_CFG_EXMBIST_CLK_MODE_REG (DMC_DMC_BASE + 0x164)
#define DMC_DMC_DDRC_CFG_OSC_PRD_REG (DMC_DMC_BASE + 0x178)
#define DMC_DMC_DDRC_CFG_OSC_CFG_REG (DMC_DMC_BASE + 0x17C)
#define DMC_DMC_DDRC_CFG_TRAIN_REG (DMC_DMC_BASE + 0x180)
#define DMC_DMC_DDRC_CFG_DFI_LAT0_REG (DMC_DMC_BASE + 0x184)
#define DMC_DMC_DDRC_CFG_DFI_LAT1_REG (DMC_DMC_BASE + 0x188)
#define DMC_DMC_DDRC_CFG_REC0_REG (DMC_DMC_BASE + 0x190)
#define DMC_DMC_DDRC_CFG_REC1_REG (DMC_DMC_BASE + 0x194)
#define DMC_DMC_DDRC_CFG_CRC_REG (DMC_DMC_BASE + 0x198)
#define DMC_DMC_DDRC_CFG_CRC_ERRINJ0_REG (DMC_DMC_BASE + 0x1A0)
#define DMC_DMC_DDRC_CFG_CRC_ERRINJ1_REG (DMC_DMC_BASE + 0x1A4)
#define DMC_DMC_DDRC_CFG_PAR_ERRINJ0_REG (DMC_DMC_BASE + 0x1A8)
#define DMC_DMC_DDRC_CFG_PAR_ERRINJ1_REG (DMC_DMC_BASE + 0x1AC)
#define DMC_DMC_DDRC_CFG_DDRPHY_REG (DMC_DMC_BASE + 0x200)
#define DMC_DMC_DDRC_CFG_AGING_REG (DMC_DMC_BASE + 0x204)
#define DMC_DMC_DDRC_CFG_SFC_TIM_REG (DMC_DMC_BASE + 0x20C)
#define DMC_DMC_DDRC_CFG_SFC_REG (DMC_DMC_BASE + 0x210)
#define DMC_DMC_DDRC_CFG_SFC_ADDR0_REG (DMC_DMC_BASE + 0x214)
#define DMC_DMC_DDRC_CFG_SFC_ADDR1_REG (DMC_DMC_BASE + 0x218)
#define DMC_DMC_DDRC_CFG_SFC_WDATA_REG (DMC_DMC_BASE + 0x21C)
#define DMC_DMC_DDRC_CFG_SFC_WCTRL_REG (DMC_DMC_BASE + 0x220)
#define DMC_DMC_DDRC_CFG_SFC_MASK0_REG (DMC_DMC_BASE + 0x224)
#define DMC_DMC_DDRC_CFG_SFC_MASK1_REG (DMC_DMC_BASE + 0x228)
#define DMC_DMC_DDRC_CFG_TMON_REG (DMC_DMC_BASE + 0x240)
#define DMC_DMC_DDRC_CFG_TMON_RANK_REG (DMC_DMC_BASE + 0x244)
#define DMC_DMC_DDRC_CFG_TMON_AREF_REG (DMC_DMC_BASE + 0x248)
#define DMC_DMC_DDRC_CFG_EXRESP_REG (DMC_DMC_BASE + 0x24C)
#define DMC_DMC_DDRC_CFG_MRR_MAP_REG (DMC_DMC_BASE + 0x250)
#define DMC_DMC_DDRC_CFG_STADAT_REG (DMC_DMC_BASE + 0x254)
#define DMC_DMC_DDRC_CFG_DATMIN_REG (DMC_DMC_BASE + 0x258)
#define DMC_DMC_DDRC_CFG_DATMAX_REG (DMC_DMC_BASE + 0x25C)
#define DMC_DMC_DDRC_CFG_STACMD_REG (DMC_DMC_BASE + 0x260)
#define DMC_DMC_DDRC_CFG_CMDMIN_REG (DMC_DMC_BASE + 0x264)
#define DMC_DMC_DDRC_CFG_CMDMAX_REG (DMC_DMC_BASE + 0x268)
#define DMC_DMC_DDRC_CFG_PERF_REG (DMC_DMC_BASE + 0x26C)
#define DMC_DMC_DDRC_CFG_STAID_REG (DMC_DMC_BASE + 0x270)
#define DMC_DMC_DDRC_CFG_STAIDMSK_REG (DMC_DMC_BASE + 0x274)
#define DMC_DMC_DDRC_CFG_DUM_EN_REG (DMC_DMC_BASE + 0x278)
#define DMC_DMC_DDRC_CFG_DUM_CFG_REG (DMC_DMC_BASE + 0x27C)
#define DMC_DMC_DDRC_INTMSK_REG (DMC_DMC_BASE + 0x280)
#define DMC_DMC_DDRC_RINT_REG (DMC_DMC_BASE + 0x284)
#define DMC_DMC_DDRC_INTSTS_REG (DMC_DMC_BASE + 0x288)
#define DMC_DMC_DDRC_CURR_STATUS_REG (DMC_DMC_BASE + 0x290)
#define DMC_DMC_DDRC_CURR_FUNC_REG (DMC_DMC_BASE + 0x294)
#define DMC_DMC_DDRC_CURR_FUNC2_REG (DMC_DMC_BASE + 0x298)
#define DMC_DMC_DDRC_CURR_FUNC3_REG (DMC_DMC_BASE + 0x29C)
#define DMC_DMC_DDRC_CURR_EXECST_REG (DMC_DMC_BASE + 0x2A0)
#define DMC_DMC_DDRC_CURR_WGFIFOST_REG (DMC_DMC_BASE + 0x2A4)
#define DMC_DMC_DDRC_CFG_ECC_CTRL_REG (DMC_DMC_BASE + 0x2A8)
#define DMC_DMC_DDRC_HIS_SERR_ID_REG (DMC_DMC_BASE + 0x2AC)
#define DMC_DMC_DDRC_HIS_SERR_ADR0_REG (DMC_DMC_BASE + 0x2D0)
#define DMC_DMC_DDRC_HIS_SERR_ADR1_REG (DMC_DMC_BASE + 0x2D4)
#define DMC_DMC_DDRC_HIS_SERR_RDATA0_REG (DMC_DMC_BASE + 0x2D8)
#define DMC_DMC_DDRC_HIS_SERR_RDATA1_REG (DMC_DMC_BASE + 0x2DC)
#define DMC_DMC_DDRC_HIS_SERR_RDATA2_REG (DMC_DMC_BASE + 0x2E0)
#define DMC_DMC_DDRC_HIS_SERR_RDATA3_REG (DMC_DMC_BASE + 0x2E4)
#define DMC_DMC_DDRC_HIS_SERR_RDATA4_REG (DMC_DMC_BASE + 0x2E8)
#define DMC_DMC_DDRC_HIS_SERR_RDATA5_REG (DMC_DMC_BASE + 0x2EC)
#define DMC_DMC_DDRC_HIS_SERR_RDATA6_REG (DMC_DMC_BASE + 0x2F0)
#define DMC_DMC_DDRC_HIS_SERR_RDATA7_REG (DMC_DMC_BASE + 0x2F4)
#define DMC_DMC_DDRC_HIS_SERR_RDATA8_REG (DMC_DMC_BASE + 0x2F8)
#define DMC_DMC_DDRC_HIS_SERR_EXPDATA0_REG (DMC_DMC_BASE + 0x2FC)
#define DMC_DMC_DDRC_HIS_SERR_EXPDATA1_REG (DMC_DMC_BASE + 0x300)
#define DMC_DMC_DDRC_HIS_SERR_EXPDATA2_REG (DMC_DMC_BASE + 0x304)
#define DMC_DMC_DDRC_HIS_SERR_EXPDATA3_REG (DMC_DMC_BASE + 0x308)
#define DMC_DMC_DDRC_HIS_SERR_EXPDATA4_REG (DMC_DMC_BASE + 0x30C)
#define DMC_DMC_DDRC_HIS_SERR_EXPDATA5_REG (DMC_DMC_BASE + 0x310)
#define DMC_DMC_DDRC_HIS_SERR_EXPDATA6_REG (DMC_DMC_BASE + 0x314)
#define DMC_DMC_DDRC_HIS_SERR_EXPDATA7_REG (DMC_DMC_BASE + 0x318)
#define DMC_DMC_DDRC_HIS_SERR_EXPDATA8_REG (DMC_DMC_BASE + 0x31C)
#define DMC_DMC_DDRC_HIS_MERR_ADR0_REG (DMC_DMC_BASE + 0x320)
#define DMC_DMC_DDRC_HIS_MERR_ADR1_REG (DMC_DMC_BASE + 0x324)
#define DMC_DMC_DDRC_HIS_MERR_ID_REG (DMC_DMC_BASE + 0x328)
#define DMC_DMC_DDRC_HIS_MERR_RDATA0_REG (DMC_DMC_BASE + 0x330)
#define DMC_DMC_DDRC_HIS_MERR_RDATA1_REG (DMC_DMC_BASE + 0x334)
#define DMC_DMC_DDRC_HIS_MERR_RDATA2_REG (DMC_DMC_BASE + 0x338)
#define DMC_DMC_DDRC_HIS_MERR_RDATA3_REG (DMC_DMC_BASE + 0x33C)
#define DMC_DMC_DDRC_HIS_MERR_RDATA4_REG (DMC_DMC_BASE + 0x340)
#define DMC_DMC_DDRC_HIS_MERR_RDATA5_REG (DMC_DMC_BASE + 0x344)
#define DMC_DMC_DDRC_HIS_MERR_RDATA6_REG (DMC_DMC_BASE + 0x348)
#define DMC_DMC_DDRC_HIS_MERR_RDATA7_REG (DMC_DMC_BASE + 0x34C)
#define DMC_DMC_DDRC_HIS_MERR_RDATA8_REG (DMC_DMC_BASE + 0x350)
#define DMC_DMC_DDRC_HIS_MERR_EXPDATA0_REG (DMC_DMC_BASE + 0x354)
#define DMC_DMC_DDRC_HIS_MERR_EXPDATA1_REG (DMC_DMC_BASE + 0x358)
#define DMC_DMC_DDRC_HIS_MERR_EXPDATA2_REG (DMC_DMC_BASE + 0x35C)
#define DMC_DMC_DDRC_HIS_MERR_EXPDATA3_REG (DMC_DMC_BASE + 0x360)
#define DMC_DMC_DDRC_HIS_MERR_EXPDATA4_REG (DMC_DMC_BASE + 0x364)
#define DMC_DMC_DDRC_HIS_MERR_EXPDATA5_REG (DMC_DMC_BASE + 0x368)
#define DMC_DMC_DDRC_HIS_MERR_EXPDATA6_REG (DMC_DMC_BASE + 0x36C)
#define DMC_DMC_DDRC_HIS_MERR_EXPDATA7_REG (DMC_DMC_BASE + 0x370)
#define DMC_DMC_DDRC_HIS_MERR_EXPDATA8_REG (DMC_DMC_BASE + 0x374)
#define DMC_DMC_DDRC_HIS_SERRCNT_REG (DMC_DMC_BASE + 0x378)
#define DMC_DMC_DDRC_HIS_MERRCNT_REG (DMC_DMC_BASE + 0x37C)
#define DMC_DMC_DDRC_HIS_FLUX_WR_REG (DMC_DMC_BASE + 0x380)
#define DMC_DMC_DDRC_HIS_FLUX_RD_REG (DMC_DMC_BASE + 0x384)
#define DMC_DMC_DDRC_HIS_FLUX_WCMD_REG (DMC_DMC_BASE + 0x388)
#define DMC_DMC_DDRC_HIS_FLUX_RCMD_REG (DMC_DMC_BASE + 0x38C)
#define DMC_DMC_DDRC_HIS_FLUXID_WR_REG (DMC_DMC_BASE + 0x390)
#define DMC_DMC_DDRC_HIS_FLUXID_RD_REG (DMC_DMC_BASE + 0x394)
#define DMC_DMC_DDRC_HIS_FLUXID_WCMD_REG (DMC_DMC_BASE + 0x398)
#define DMC_DMC_DDRC_HIS_FLUXID_RCMD_REG (DMC_DMC_BASE + 0x39C)
#define DMC_DMC_DDRC_HIS_WLATCNT0_REG (DMC_DMC_BASE + 0x3A0)
#define DMC_DMC_DDRC_HIS_WLATCNT1_REG (DMC_DMC_BASE + 0x3A4)
#define DMC_DMC_DDRC_HIS_RLATCNT0_REG (DMC_DMC_BASE + 0x3A8)
#define DMC_DMC_DDRC_HIS_RLATCNT1_REG (DMC_DMC_BASE + 0x3AC)
#define DMC_DMC_DDRC_HIS_INHERE_RLAT_CNT_REG (DMC_DMC_BASE + 0x3B0)
#define DMC_DMC_DDRC_STAT_RPT_REG (DMC_DMC_BASE + 0x3B4)
#define DMC_DMC_DDRC_HIS_CMD_SUM_REG (DMC_DMC_BASE + 0x3B8)
#define DMC_DMC_DDRC_HIS_DAT_SUM_REG (DMC_DMC_BASE + 0x3BC)
#define DMC_DMC_DDRC_HIS_PRE_CMD_REG (DMC_DMC_BASE + 0x3C0)
#define DMC_DMC_DDRC_HIS_ACT_CMD_REG (DMC_DMC_BASE + 0x3C4)
#define DMC_DMC_DDRC_HIS_BNK_CHG_REG (DMC_DMC_BASE + 0x3C8)
#define DMC_DMC_DDRC_HIS_RNK_CHG_REG (DMC_DMC_BASE + 0x3CC)
#define DMC_DMC_DDRC_HIS_RW_CHG_REG (DMC_DMC_BASE + 0x3D0)
#define DMC_DMC_DDRC_HIS_TMON_ERR_REG (DMC_DMC_BASE + 0x3E0)
#define DMC_DMC_DDRC_HIS_RERR_ADDRL_REG (DMC_DMC_BASE + 0x3F0)
#define DMC_DMC_DDRC_HIS_RERR_ADDRH_REG (DMC_DMC_BASE + 0x3F4)
#define DMC_DMC_DDRC_HIS_RERR_ID_REG (DMC_DMC_BASE + 0x3F8)
#define DMC_DMC_DDRC_HIS_RERR_CNT_REG (DMC_DMC_BASE + 0x3FC)
#define DMC_DMC_DDRC_HIS_REC_ERR0_REG (DMC_DMC_BASE + 0x400)
#define DMC_DMC_DDRC_HIS_REC_ERR1_REG (DMC_DMC_BASE + 0x404)
#define DMC_DMC_DDRC_HIS_EXMBIST_STATUS_REG (DMC_DMC_BASE + 0x40C)
#define DMC_DMC_DDRC_HIS_SFC_RDATA_REG (DMC_DMC_BASE + 0x4A8)
#define DMC_DMC_DDRC_SFC_RCTRL_REG (DMC_DMC_BASE + 0x4AC)
#define DMC_DMC_DDRC_HIS_SFC_RDATA0_DBI_REG (DMC_DMC_BASE + 0x4C8)
#define DMC_DMC_DDRC_HIS_SFC_RDATA1_DBI_REG (DMC_DMC_BASE + 0x4CC)
#define DMC_DMC_DDRC_HIS_SFC_RDATA_ECC_DBI_REG (DMC_DMC_BASE + 0x4D0)
#define DMC_DMC_DDRC_FUNC_STAT0_REG (DMC_DMC_BASE + 0x4D4)
#define DMC_DMC_DDRC_FUNC_STAT1_REG (DMC_DMC_BASE + 0x4D8)
#define DMC_DMC_DDRC_FUNC_STAT2_REG (DMC_DMC_BASE + 0x4DC)
#define DMC_DMC_DDRC_FUNC_STAT3_REG (DMC_DMC_BASE + 0x4E0)
#define DMC_DMC_DDRC_FUNC_STAT4_REG (DMC_DMC_BASE + 0x4E4)
#define DMC_DMC_DDRC_FUNC_STAT5_REG (DMC_DMC_BASE + 0x4E8)
#define DMC_DMC_DDRC_FUNC_STAT6_REG (DMC_DMC_BASE + 0x4EC)
#define DMC_DMC_DDRC_FUNC_STAT7_REG (DMC_DMC_BASE + 0x4F0)
#define DMC_DMC_DDRC_FUNC_STAT8_REG (DMC_DMC_BASE + 0x4F4)
#define DMC_DMC_DDRC_FUNC_STAT9_REG (DMC_DMC_BASE + 0x4F8)
#define DMC_DMC_DDRC_FUNC_STAT10_REG (DMC_DMC_BASE + 0x4FC)
#define DMC_DMC_DDRC_FUNC_STAT11_REG (DMC_DMC_BASE + 0x500)
#define DMC_DMC_DDRC_DMC_STAT12_REG (DMC_DMC_BASE + 0x504)
#define DMC_DMC_DDRC_TEST_RAM_TMOD_REG (DMC_DMC_BASE + 0x508)
#define DMC_DMC_DDRC_TEST_RTL_CFG0_REG (DMC_DMC_BASE + 0x510)
#define DMC_DMC_DDRC_TEST_RTL_CFG1_REG (DMC_DMC_BASE + 0x514)
#define DMC_DMC_DDRC_TEST_RTL_CFG2_REG (DMC_DMC_BASE + 0x518)
#define DMC_DMC_DDRC_OSC_COUNT_REG (DMC_DMC_BASE + 0x520)
#define DMC_DMC_DDRC_EDXN_DQMAP_REG (DMC_DMC_BASE + 0x580)
#define DMC_DMC_DDRC_ODXN_DQMAP_REG (DMC_DMC_BASE + 0x584)
#define DMC_DMC_DDRC_CFG_SFC_EXTCMD_CTRL_REG (DMC_DMC_BASE + 0x600)
#define DMC_DMC_DDRC_CFG_SFC_LOOP_CTRL_REG (DMC_DMC_BASE + 0x604)
#define DMC_DMC_DDRC_CFG_SFC_BER_RD_RPT_REG (DMC_DMC_BASE + 0x608)
#define DMC_DMC_DDRC_CFG_SFC_HEAD_TAIL_CUT_REG (DMC_DMC_BASE + 0x60C)
#define DMC_DMC_DDRC_CFG_SFC_PAT_PRD_REG (DMC_DMC_BASE + 0x610)
#define DMC_DMC_DDRC_CFG_SFC_WL_CTRL_REG (DMC_DMC_BASE + 0x614)
#define DMC_DMC_DDRC_CFG_SFC_ADDR2_REG (DMC_DMC_BASE + 0x618)
#define DMC_DMC_DDRC_CFG_SFC_ADDR3_REG (DMC_DMC_BASE + 0x61C)
#define DMC_DMC_DDRC_CFG_SFC_PAT_SEL_REG (DMC_DMC_BASE + 0x620)
#define DMC_DMC_DDRC_CFG_SFC_PAT_SEL_PTR_REG (DMC_DMC_BASE + 0x624)
#define DMC_DMC_DDRC_CFG_SFC_CMP_MASK_REG (DMC_DMC_BASE + 0x628)
#define DMC_DMC_DDRC_CFG_SFC_CMP_MASK_PTR_REG (DMC_DMC_BASE + 0x62C)
#define DMC_DMC_DDRC_CFG_SFC_TIM2_REG (DMC_DMC_BASE + 0x630)
#define DMC_DMC_DDRC_CFG_SFC_INIT_SEED_REG (DMC_DMC_BASE + 0x634)
#define DMC_DMC_DDRC_CFG_SFC_INIT_SEED1_REG (DMC_DMC_BASE + 0x638)
#define DMC_DMC_DDRC_CFG_SFC_INIT_SEED2_REG (DMC_DMC_BASE + 0x63C)
#define DMC_DMC_DDRC_CFG_SFC_INIT_SEED3_REG (DMC_DMC_BASE + 0x640)
#define DMC_DMC_DDRC_CFG_SFC_INIT_SEED4_REG (DMC_DMC_BASE + 0x644)
#define DMC_DMC_DDRC_CFG_SFC_INIT_SEED5_REG (DMC_DMC_BASE + 0x648)
#define DMC_DMC_DDRC_CFG_SFC_INIT_SEED6_REG (DMC_DMC_BASE + 0x64C)
#define DMC_DMC_DDRC_CFG_SFC_INIT_SEED7_REG (DMC_DMC_BASE + 0x650)
#define DMC_DMC_DDRC_HIS_SFC_DQS_POS_ERR_0_REG (DMC_DMC_BASE + 0x654)
#define DMC_DMC_DDRC_HIS_SFC_DQS_POS_ERR_1_REG (DMC_DMC_BASE + 0x658)
#define DMC_DMC_DDRC_HIS_SFC_DQS_POS_ERR_2_REG (DMC_DMC_BASE + 0x65C)
#define DMC_DMC_DDRC_HIS_SFC_DQS_NEG_ERR_0_REG (DMC_DMC_BASE + 0x660)
#define DMC_DMC_DDRC_HIS_SFC_DQS_NEG_ERR_1_REG (DMC_DMC_BASE + 0x664)
#define DMC_DMC_DDRC_HIS_SFC_DQS_NEG_ERR_2_REG (DMC_DMC_BASE + 0x668)
#define DMC_DMC_DDRC_HIS_SFC_PER_NIB_ERR_REG (DMC_DMC_BASE + 0x66C)
#define DMC_DMC_DDRC_HIS_SFC_PER_BYTE_ERR_REG (DMC_DMC_BASE + 0x670)
#define DMC_DMC_DDRC_HIS_SFC_ANY_ERR_REG (DMC_DMC_BASE + 0x674)
#define DMC_DMC_DDRC_HIS_SFC_QUE_CUR_PTR_REG (DMC_DMC_BASE + 0x678)
#define DMC_DMC_DDRC_HIS_SFC_ERR_NUM_REG (DMC_DMC_BASE + 0x67C)
#define DMC_DMC_DDRC_CFG_AC_ISI_PAT_REG (DMC_DMC_BASE + 0x680)
#define DMC_DMC_DDRC_CFG_AC_ISI_PTR_REG (DMC_DMC_BASE + 0x684)
#define DMC_DMC_DDRC_HIS_BG_CHG_REG (DMC_DMC_BASE + 0x688)
#define DMC_DMC_DDRC_CURR_EXEC_STATE_REG (DMC_DMC_BASE + 0x68C)
#define DMC_DMC_DDRC_PHYUPD_REQ_CNT_REG (DMC_DMC_BASE + 0x690)
#define DMC_DMC_DDRC_PHYUPD_EXIT_WAIT_REG (DMC_DMC_BASE + 0x694)
#define DMC_DMC_DDRC_CFG_TIMING9_REG (DMC_DMC_BASE + 0x698)
#define DMC_DMC_DDRC_CFG_NXT_TIMING9_REG (DMC_DMC_BASE + 0x69C)
#define DMC_DMC_DDRC_CFG_CE_CNT_TH_REG (DMC_DMC_BASE + 0x6A0)
#define DMC_DMC_DDRC_CFG_FUNNEL_CTRL_REG (DMC_DMC_BASE + 0x6A4)
#define DMC_DMC_DDRC_CFG_FUNNEL_BASE_REG (DMC_DMC_BASE + 0x6A8)
#define DMC_DMC_DDRC_CFG_FUNNEL_TH_REG (DMC_DMC_BASE + 0x6AC)
#define DMC_DMC_DDRC_HIS_SRAM_CE_CNT_REG (DMC_DMC_BASE + 0x6B0)
#define DMC_DMC_DDRC_HIS_DP_CE_CNT_REG (DMC_DMC_BASE + 0x6B4)
#define DMC_DMC_DDRC_CFG_AC_PIPE_REG (DMC_DMC_BASE + 0x6B8)
#define DMC_DMC_DDRC_HIS_AREF_PSTPND_CNT_REG (DMC_DMC_BASE + 0x6BC)
#define DMC_DMC_DDRC_PERF_EVENT_EN_REG (DMC_DMC_BASE + 0x6C0)
#define DMC_DMC_DDRC_PERF_INTR_REG (DMC_DMC_BASE + 0x6C4)
#define DMC_DMC_DDRC_PERF_INTM_REG (DMC_DMC_BASE + 0x6C8)
#define DMC_DMC_DDRC_PERF_INTS_REG (DMC_DMC_BASE + 0x6CC)
#define DMC_DMC_DDRC_PERF_INTC_REG (DMC_DMC_BASE + 0x6D0)
#define DMC_DMC_DDRC_CFG_RES0_REG (DMC_DMC_BASE + 0x700)
#define DMC_DMC_DDRC_CFG_RES1_REG (DMC_DMC_BASE + 0x704)
#define DMC_DMC_DDRC_CFG_RES2_REG (DMC_DMC_BASE + 0x708)
#define DMC_DMC_DDRC_CFG_RES3_REG (DMC_DMC_BASE + 0x70C)
#define DMC_DMC_DDRC_CFG_RES4_REG (DMC_DMC_BASE + 0x710)
#define DMC_DMC_DDRC_CFG_RES5_REG (DMC_DMC_BASE + 0x714)
#define DMC_DMC_DDRC_CFG_RES6_REG (DMC_DMC_BASE + 0x718)
#define DMC_DMC_DDRC_CFG_RES7_REG (DMC_DMC_BASE + 0x71C)
#define DMC_DMC_DDRC_CFG_MAGIC_WORD_REG (DMC_DMC_BASE + 0x7F0)
#define DMC_DMC_DDRC_CFG_VERSION_REG (DMC_DMC_BASE + 0xC10)

#endif
