/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2019 Hisilicon Limited, All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef __HLLC_REGS_REG_OFFSET_H__
#define __HLLC_REGS_REG_OFFSET_H__

/* HLLC_REGS Base address of Module's Register */
#define HLLC_HLLC_REGS_BASE (0x0)

/******************************************************************************/
/*					  xxx HLLC_REGS Registers' Definitions */
/******************************************************************************/

#define HLLC_HLLC_REGS_HLLC_HYDRA_RX_AFULL_TH_CFG_REG (HLLC_HLLC_REGS_BASE + 0x0)
#define HLLC_HLLC_REGS_HLLC_TOKEN_CFG_REG (HLLC_HLLC_REGS_BASE + 0x100)
#define HLLC_HLLC_REGS_HLLC_RETRAINING_CFG0_REG (HLLC_HLLC_REGS_BASE + 0x300)
#define HLLC_HLLC_REGS_HLLC_RETRAINING_CFG1_REG (HLLC_HLLC_REGS_BASE + 0x304)
#define HLLC_HLLC_REGS_HLLC_RETRAINING_CFG2_REG (HLLC_HLLC_REGS_BASE + 0x308)
#define HLLC_HLLC_REGS_HLLC_PHY_RX_CRD_RET_CFG_REG (HLLC_HLLC_REGS_BASE + 0x400)
#define HLLC_HLLC_REGS_HLLC_SYS_MAGIC_WORD_REG (HLLC_HLLC_REGS_BASE + 0x7F0)
#define HLLC_HLLC_REGS_HLLC_INT0_SRC_REG (HLLC_HLLC_REGS_BASE + 0x800)
#define HLLC_HLLC_REGS_HLLC_INT0_MSK_REG (HLLC_HLLC_REGS_BASE + 0x804)
#define HLLC_HLLC_REGS_HLLC_INT0_ST_REG (HLLC_HLLC_REGS_BASE + 0x808)
#define HLLC_HLLC_REGS_HLLC_INT0_CLR_REG (HLLC_HLLC_REGS_BASE + 0x80C)
#define HLLC_HLLC_REGS_HLLC_INT1_SRC_REG (HLLC_HLLC_REGS_BASE + 0x810)
#define HLLC_HLLC_REGS_HLLC_INT1_MSK_REG (HLLC_HLLC_REGS_BASE + 0x814)
#define HLLC_HLLC_REGS_HLLC_INT1_ST_REG (HLLC_HLLC_REGS_BASE + 0x818)
#define HLLC_HLLC_REGS_HLLC_INT1_CLR_REG (HLLC_HLLC_REGS_BASE + 0x81C)
#define HLLC_HLLC_REGS_HLLC_ECO0_REG (HLLC_HLLC_REGS_BASE + 0xC00)
#define HLLC_HLLC_REGS_HLLC_ECO1_REG (HLLC_HLLC_REGS_BASE + 0xC04)
#define HLLC_HLLC_REGS_HLLC_ECO2_REG (HLLC_HLLC_REGS_BASE + 0xC08)
#define HLLC_HLLC_REGS_HLLC_ECO3_REG (HLLC_HLLC_REGS_BASE + 0xC0C)
#define HLLC_HLLC_REGS_HLLC_SYS_VERSION_REG (HLLC_HLLC_REGS_BASE + 0xC10)
#define HLLC_HLLC_REGS_HLLC_CNT_EN_REG (HLLC_HLLC_REGS_BASE + 0x1040)
#define HLLC_HLLC_REGS_HLLC_CNT_CLR_REG (HLLC_HLLC_REGS_BASE + 0x1044)
#define HLLC_HLLC_REGS_HLLC_HYDRA_RX_BP_ST_REG (HLLC_HLLC_REGS_BASE + 0x1100)
#define HLLC_HLLC_REGS_HLLC_HYDRA_RX_CH0_BP_CNT_REG (HLLC_HLLC_REGS_BASE + 0x1140)
#define HLLC_HLLC_REGS_HLLC_HYDRA_RX_CH1_BP_CNT_REG (HLLC_HLLC_REGS_BASE + 0x1148)
#define HLLC_HLLC_REGS_HLLC_HYDRA_RX_CH2_BP_CNT_REG (HLLC_HLLC_REGS_BASE + 0x1150)
#define HLLC_HLLC_REGS_HLLC_HYDRA_RX_CH0_BP_MAX_DURATION_REG (HLLC_HLLC_REGS_BASE + 0x1160)
#define HLLC_HLLC_REGS_HLLC_HYDRA_RX_CH1_BP_MAX_DURATION_REG (HLLC_HLLC_REGS_BASE + 0x1168)
#define HLLC_HLLC_REGS_HLLC_HYDRA_RX_CH2_BP_MAX_DURATION_REG (HLLC_HLLC_REGS_BASE + 0x1170)
#define HLLC_HLLC_REGS_HLLC_HYDRA_RX_BUF_ST_REG (HLLC_HLLC_REGS_BASE + 0x1180)
#define HLLC_HLLC_REGS_HLLC_HYDRA_RX_CH0_FLIT_CNT_REG (HLLC_HLLC_REGS_BASE + 0x11C0)
#define HLLC_HLLC_REGS_HLLC_HYDRA_RX_CH1_FLIT_CNT_REG (HLLC_HLLC_REGS_BASE + 0x11C8)
#define HLLC_HLLC_REGS_HLLC_HYDRA_RX_CH2_FLIT_CNT_REG (HLLC_HLLC_REGS_BASE + 0x11D0)
#define HLLC_HLLC_REGS_HLLC_PHY_TX_CRD_NUM_REG (HLLC_HLLC_REGS_BASE + 0x1200)
#define HLLC_HLLC_REGS_HLLC_PHY_TX_BP_ST_REG (HLLC_HLLC_REGS_BASE + 0x1220)
#define HLLC_HLLC_REGS_HLLC_PHY_TX_RMT_ACK_NUM_REG (HLLC_HLLC_REGS_BASE + 0x1240)
#define HLLC_HLLC_REGS_HLLC_PHY_TX_RETRY_ST_REG (HLLC_HLLC_REGS_BASE + 0x1280)
#define HLLC_HLLC_REGS_HLLC_PHY_TX_RETRY_BUF_ST_REG (HLLC_HLLC_REGS_BASE + 0x1284)
#define HLLC_HLLC_REGS_HLLC_LOC_PHY_TX_RETRY_WR_PTR_REG (HLLC_HLLC_REGS_BASE + 0x1290)
#define HLLC_HLLC_REGS_HLLC_RMT_PHY_RX_RETRY_REQ_CNT_REG (HLLC_HLLC_REGS_BASE + 0x12A0)
#define HLLC_HLLC_REGS_HLLC_RMT_PHY_RX_RETRY_ACK_CNT_REG (HLLC_HLLC_REGS_BASE + 0x12A8)
#define HLLC_HLLC_REGS_PHY_TX_CH0_FLIT_CNT_REG (HLLC_HLLC_REGS_BASE + 0x12C0)
#define HLLC_HLLC_REGS_PHY_TX_CH1_FLIT_CNT_REG (HLLC_HLLC_REGS_BASE + 0x12C8)
#define HLLC_HLLC_REGS_PHY_TX_CH2_FLIT_CNT_REG (HLLC_HLLC_REGS_BASE + 0x12D0)
#define HLLC_HLLC_REGS_PHY_TX_IDLE_FLIT_CNT_REG (HLLC_HLLC_REGS_BASE + 0x12D8)
#define HLLC_HLLC_REGS_HLLC_RETRAINING_REQ_CNT_REG (HLLC_HLLC_REGS_BASE + 0x1300)
#define HLLC_HLLC_REGS_HLLC_RETRAINING_ACK_CNT_REG (HLLC_HLLC_REGS_BASE + 0x1308)
#define HLLC_HLLC_REGS_HLLC_PHY_RX_CRD_NUM_REG (HLLC_HLLC_REGS_BASE + 0x1400)
#define HLLC_HLLC_REGS_HLLC_PHY_RX_BP_ST_REG (HLLC_HLLC_REGS_BASE + 0x1420)
#define HLLC_HLLC_REGS_HLLC_PHY_RX_LOC_ACK_NUM_REG (HLLC_HLLC_REGS_BASE + 0x1440)
#define HLLC_HLLC_REGS_HLLC_PHY_RX_RETRY_ST_REG (HLLC_HLLC_REGS_BASE + 0x1480)
#define HLLC_HLLC_REGS_HLLC_LOC_PHY_RX_RETRY_RD_PTR_REG (HLLC_HLLC_REGS_BASE + 0x1490)
#define HLLC_HLLC_REGS_HLLC_LOC_PHY_RX_RETRY_REQ_CNT_REG (HLLC_HLLC_REGS_BASE + 0x14A0)
#define HLLC_HLLC_REGS_HLLC_LOC_PHY_RX_RETRY_ACK_CNT_REG (HLLC_HLLC_REGS_BASE + 0x14A8)
#define HLLC_HLLC_REGS_PHY_RX_CH0_FLIT_CNT_REG (HLLC_HLLC_REGS_BASE + 0x14C0)
#define HLLC_HLLC_REGS_PHY_RX_CH1_FLIT_CNT_REG (HLLC_HLLC_REGS_BASE + 0x14C8)
#define HLLC_HLLC_REGS_PHY_RX_CH2_FLIT_CNT_REG (HLLC_HLLC_REGS_BASE + 0x14D0)
#define HLLC_HLLC_REGS_PHY_RX_IDLE_FLIT_CNT_REG (HLLC_HLLC_REGS_BASE + 0x14D8)
#define HLLC_HLLC_REGS_HLLC_HYDRA_TX_BP_ST_REG (HLLC_HLLC_REGS_BASE + 0x1500)
#define HLLC_HLLC_REGS_HLLC_HYDRA_TX_BUF_ST_REG (HLLC_HLLC_REGS_BASE + 0x1580)
#define HLLC_HLLC_REGS_HLLC_HYDRA_TX_CH0_FLIT_CNT_REG (HLLC_HLLC_REGS_BASE + 0x15C0)
#define HLLC_HLLC_REGS_HLLC_HYDRA_TX_CH1_FLIT_CNT_REG (HLLC_HLLC_REGS_BASE + 0x15C8)
#define HLLC_HLLC_REGS_HLLC_HYDRA_TX_CH2_FLIT_CNT_REG (HLLC_HLLC_REGS_BASE + 0x15D0)
#define HLLC_HLLC_REGS_HLLC_INJECT_ECC_TYPE_REG (HLLC_HLLC_REGS_BASE + 0x1600)
#define HLLC_HLLC_REGS_HLLC_INJECT_ECC_EN_REG (HLLC_HLLC_REGS_BASE + 0x1604)
#define HLLC_HLLC_REGS_HLLC_HYDRA_RX_2BIT_ECC_ERR_ADDR_REG (HLLC_HLLC_REGS_BASE + 0x1680)
#define HLLC_HLLC_REGS_HLLC_HYDRA_RX_CH0_1BIT_ECC_ERR_CNT_REG (HLLC_HLLC_REGS_BASE + 0x1688)
#define HLLC_HLLC_REGS_HLLC_HYDRA_RX_CH1_1BIT_ECC_ERR_CNT_REG (HLLC_HLLC_REGS_BASE + 0x1690)
#define HLLC_HLLC_REGS_HLLC_HYDRA_RX_CH2_1BIT_ECC_ERR_CNT_REG (HLLC_HLLC_REGS_BASE + 0x1698)
#define HLLC_HLLC_REGS_HLLC_PHY_TX_RETRY_2BIT_ECC_ERR_ADDR_REG (HLLC_HLLC_REGS_BASE + 0x16A0)
#define HLLC_HLLC_REGS_HLLC_PHY_TX_RETRY_1BIT_ECC_ERR_CNT_REG (HLLC_HLLC_REGS_BASE + 0x16A8)
#define HLLC_HLLC_REGS_HLLC_HYDRA_TX_2BIT_ECC_ERR_ADDR_REG (HLLC_HLLC_REGS_BASE + 0x16C0)
#define HLLC_HLLC_REGS_HLLC_HYDRA_TX_CH0_1BIT_ECC_ERR_CNT_REG (HLLC_HLLC_REGS_BASE + 0x16C8)
#define HLLC_HLLC_REGS_HLLC_HYDRA_TX_CH1_1BIT_ECC_ERR_CNT_REG (HLLC_HLLC_REGS_BASE + 0x16D0)
#define HLLC_HLLC_REGS_HLLC_HYDRA_TX_CH2_1BIT_ECC_ERR_CNT_REG (HLLC_HLLC_REGS_BASE + 0x16D8)
#define HLLC_HLLC_REGS_HLLC_PHY_TX_INJECT_1BIT_CRC_ERR_EN_REG (HLLC_HLLC_REGS_BASE + 0x1700)
#define HLLC_HLLC_REGS_HLLC_PHY_TX_INJECT_1BIT_CRC_ERR_TIMES_REG (HLLC_HLLC_REGS_BASE + 0x1704)
#define HLLC_HLLC_REGS_HLLC_PHY_TX_INJECT_1BIT_CRC_ERR_DONE_REG (HLLC_HLLC_REGS_BASE + 0x1780)
#define HLLC_HLLC_REGS_HLLC_PHY_TX_INJECT_1BIT_CRC_ERR_CNT_REG (HLLC_HLLC_REGS_BASE + 0x17A0)
#define HLLC_HLLC_REGS_HLLC_PHY_RX_FLIT_CRC_ERR_CNT_REG (HLLC_HLLC_REGS_BASE + 0x17C0)
#define HLLC_HLLC_REGS_HLLC_PHY_RX_PERFORMANCE_TEST_EN_REG (HLLC_HLLC_REGS_BASE + 0x1800)
#define HLLC_HLLC_REGS_HLLC_PHY_RX_PERFORMANCE_TEST_PERIOD_REG (HLLC_HLLC_REGS_BASE + 0x1808)
#define HLLC_HLLC_REGS_HLLC_PHY_RX_PERFORMANCE_TEST_DONE_REG (HLLC_HLLC_REGS_BASE + 0x1880)
#define HLLC_HLLC_REGS_PHY_RX_CH0_FLIT_PERFORMANCE_CNT_REG (HLLC_HLLC_REGS_BASE + 0x18A0)
#define HLLC_HLLC_REGS_PHY_RX_CH1_FLIT_PERFORMANCE_CNT_REG (HLLC_HLLC_REGS_BASE + 0x18A8)
#define HLLC_HLLC_REGS_PHY_RX_CH2_FLIT_PERFORMANCE_CNT_REG (HLLC_HLLC_REGS_BASE + 0x18B0)
#define HLLC_HLLC_REGS_PHY_RX_IDLE_FLIT_PERFORMANCE_CNT_REG (HLLC_HLLC_REGS_BASE + 0x18B8)
#define HLLC_HLLC_REGS_PHY_RX_NULL_FLIT_PERFORMANCE_CNT_REG (HLLC_HLLC_REGS_BASE + 0x18C0)
#define HLLC_HLLC_REGS_HLLC_DEBUG_ECC_CFG_REG (HLLC_HLLC_REGS_BASE + 0x1900)
#define HLLC_HLLC_REGS_HLLC_DEBUG_CRC_CFG_REG (HLLC_HLLC_REGS_BASE + 0x1904)
#define HLLC_HLLC_REGS_HLLC_HYDRA_RX_CH0_1BIT_ECC_ERR_CNT_TMP_REG (HLLC_HLLC_REGS_BASE + 0x1980)
#define HLLC_HLLC_REGS_HLLC_HYDRA_RX_CH1_1BIT_ECC_ERR_CNT_TMP_REG (HLLC_HLLC_REGS_BASE + 0x1984)
#define HLLC_HLLC_REGS_HLLC_HYDRA_RX_CH2_1BIT_ECC_ERR_CNT_TMP_REG (HLLC_HLLC_REGS_BASE + 0x1988)
#define HLLC_HLLC_REGS_HLLC_PHY_TX_RETRY_1BIT_ECC_ERR_CNT_TMP_REG (HLLC_HLLC_REGS_BASE + 0x1990)
#define HLLC_HLLC_REGS_HLLC_HYDRA_TX_CH0_1BIT_ECC_ERR_CNT_TMP_REG (HLLC_HLLC_REGS_BASE + 0x19A0)
#define HLLC_HLLC_REGS_HLLC_HYDRA_TX_CH1_1BIT_ECC_ERR_CNT_TMP_REG (HLLC_HLLC_REGS_BASE + 0x19A4)
#define HLLC_HLLC_REGS_HLLC_HYDRA_TX_CH2_1BIT_ECC_ERR_CNT_TMP_REG (HLLC_HLLC_REGS_BASE + 0x19A8)
#define HLLC_HLLC_REGS_HLLC_HYDRA_RX_CH0_1BIT_ECC_ERR_CNT_SNAPSHOT_REG (HLLC_HLLC_REGS_BASE + 0x19C0)
#define HLLC_HLLC_REGS_HLLC_HYDRA_RX_CH1_1BIT_ECC_ERR_CNT_SNAPSHOT_REG (HLLC_HLLC_REGS_BASE + 0x19C4)
#define HLLC_HLLC_REGS_HLLC_HYDRA_RX_CH2_1BIT_ECC_ERR_CNT_SNAPSHOT_REG (HLLC_HLLC_REGS_BASE + 0x19C8)
#define HLLC_HLLC_REGS_HLLC_PHY_TX_RETRY_1BIT_ECC_ERR_CNT_SNAPSHOT_REG (HLLC_HLLC_REGS_BASE + 0x19D0)
#define HLLC_HLLC_REGS_HLLC_HYDRA_TX_CH0_1BIT_ECC_ERR_CNT_SNAPSHOT_REG (HLLC_HLLC_REGS_BASE + 0x19E0)
#define HLLC_HLLC_REGS_HLLC_HYDRA_TX_CH1_1BIT_ECC_ERR_CNT_SNAPSHOT_REG (HLLC_HLLC_REGS_BASE + 0x19E4)
#define HLLC_HLLC_REGS_HLLC_HYDRA_TX_CH2_1BIT_ECC_ERR_CNT_SNAPSHOT_REG (HLLC_HLLC_REGS_BASE + 0x19E8)
#define HLLC_HLLC_REGS_HLLC_PHY_RX_FLIT_CRC_ERR_CNT_SNAPSHOT_REG (HLLC_HLLC_REGS_BASE + 0x19F0)

#endif
