/* SPDX-License-Identifier: GPL-2.0 */
/* Copyright (c) 2018-2019 HiSilicon Limited. */

#ifndef __HISI_SEC_V2_CRYPTO_H
#define __HISI_SEC_V2_CRYPTO_H

#define SEC_IV_SIZE		24
#define SEC_MAX_KEY_SIZE	64
#define SEC_COMM_SCENE		0

#define SEC_DEF_FUSION		1
#define SEC_FUSION_LIMIT		64
#define SEC_DEF_FUSION_TIME_NS	(400 * 1000)

enum sec_calg {
	SEC_CALG_3DES = 0x1,
	SEC_CALG_AES  = 0x2,
	SEC_CALG_SM4  = 0x3,
};

enum sec_cmode {
	SEC_CMODE_ECB    = 0x0,
	SEC_CMODE_CBC    = 0x1,
	SEC_CMODE_CTR    = 0x4,
	SEC_CMODE_XTS    = 0x7,
};

enum sec_ckey_type {
	SEC_CKEY_128BIT = 0x0,
	SEC_CKEY_192BIT = 0x1,
	SEC_CKEY_256BIT = 0x2,
	SEC_CKEY_3DES_3KEY = 0x1,
	SEC_CKEY_3DES_2KEY = 0x3,
};

enum sec_bd_type {
	SEC_BD_TYPE1 = 0x1,
	SEC_BD_TYPE2 = 0x2,
};

enum sec_cipher_dir {
	SEC_CIPHER_ENC = 0x1,
	SEC_CIPHER_DEC = 0x2,
};

enum sec_addr_type {
	SEC_PBUF = 0x0,
	SEC_SGL  = 0x1,
	SEC_PRP  = 0x2,
};

enum sec_ci_gen {
	SEC_CI_GEN_BY_ADDR = 0x0,
	SEC_CI_GEN_BY_LBA  = 0X3,
};

enum sec_scene {
	SEC_SCENE_IPSEC   = 0x0,
	SEC_SCENE_STORAGE = 0x5,
};

enum sec_work_mode {
	SEC_NO_FUSION = 0x0,
	SEC_IV_FUSION = 0x1,
	SEC_FUSION_BUTT
};

enum sec_req_ops_type {
	SEC_OPS_SKCIPHER_ALG = 0x0,
	SEC_OPS_DMCRYPT      = 0x1,
	SEC_OPS_MULTI_IV     = 0x2,
	SEC_OPS_BUTT
};

struct sec_sqe_type2 {

	/*
	 * mac_len: 0~5 bits
	 * a_key_len: 6~10 bits
	 * a_alg: 11~16 bits
	 */
	__le32 mac_key_alg;

	/*
	 * c_icv_len: 0~5 bits
	 * c_width: 6~8 bits
	 * c_key_len: 9~11 bits
	 * c_mode: 12~15 bits
	 */
	__le16 icvw_kmode;

	/* c_alg: 0~3 bits */
	__u8 c_alg;
	__u8 rsvd4;

	/*
	 * a_len: 0~23 bits
	 * iv_offset_l: 24~31 bits
	 */
	__le32 alen_ivllen;

	/*
	 * c_len: 0~23 bits
	 * iv_offset_h: 24~31 bits
	 */
	__le32 clen_ivhlen;

	__le16 auth_src_offset;
	__le16 cipher_src_offset;
	__le16 cs_ip_header_offset;
	__le16 cs_udp_header_offset;
	__le16 pass_word_len;
	__le16 dk_len;
	__u8 salt3;
	__u8 salt2;
	__u8 salt1;
	__u8 salt0;

	__le16 tag;
	__le16 rsvd5;

	/*
	 * c_pad_type: 0~3 bits
	 * c_pad_len: 4~11 bits
	 * c_pad_data_type: 12~15 bits
	 */
	__le16 cph_pad;

	/* c_pad_len_field: 0~1 bits */
	__le16 c_pad_len_field;


	__le64 long_a_data_len;
	__le64 a_ivin_addr;
	__le64 a_key_addr;
	__le64 mac_addr;
	__le64 c_ivin_addr;
	__le64 c_key_addr;

	__le64 data_src_addr;
	__le64 data_dst_addr;

	/*
	 * done: 0 bit
	 * icv: 1~3 bits
	 * csc: 4~6 bits
	 * flag: 7-10 bits
	 * dif_check: 11~13 bits
	 */
	__le16 done_flag;

	__u8 error_type;
	__u8 warning_type;
	__u8 mac_i3;
	__u8 mac_i2;
	__u8 mac_i1;
	__u8 mac_i0;
	__le16 check_sum_i;
	__u8 tls_pad_len_i;
	__u8 rsvd12;
	__le32 counter;
};

#ifdef CONFIG_CRYPTO_DEV_HISI_SEC2_FUSION
struct sec_sqe_type1 {
	/*
	 * mac_len: 0~5 bits
	 * a_key_len: 6~10 bits
	 * a_alg: 11~16 bits
	 */
	__le32 mac_key_alg;

	/*
	 * c_icv_len: 0~5 bits
	 * c_width: 6~8 bits
	 * c_key_len: 9~11 bits
	 * c_mode: 12~15 bits
	 */
	__le16 icvw_kmode;

	/* cipher alg: 0~3 */
	__le16 c_alg;

	/* auth gran size: 0~23 */
	__le32 auth_gran_size;

	/* cipher gran size: 0~23 */
	__le32 cipher_gran_size;

	__le16 auth_src_offset;
	__le16 cipher_src_offset;

	__le16 gran_num;
	__le16 rsvd0;

	/* src buffer skip data len: 0~23 */
	__le32 src_skip_data_len;

	/* dst buffer skip data len: 0~23 */
	__le32 dst_skip_data_len;

	__le16 tag;
	__le16 rsvd1;

	/*
	 * gen_page_pad_ctrl: 0~3 bits
	 * gen_grd_ctrl: 4~7 bits
	 * gen_ver_ctrl: 8~11 bits
	 * gen_app_ctrl: 12~15 bits
	 * gen_ver_val: 16~23 bits
	 * gen_app_val: 24~31 bits
	 */
	__le32 gen_pgvava_area;

	__le32 private_info;

	/*
	 * gen_ref_ctrl: 0~3 bits
	 * page_pad_type: 4~5 bits
	 */
	__u8 grctrl_pptype;

	/*
	 * chk_grd_ctrl: 0~3 bits
	 * chk_ref_ctrl: 4~7 bits
	 */
	__u8 cgrd_cref_ctrl;
	__le16 block_size;
	__le64 lba;
	__le64 a_key_addr;
	__le64 mac_addr;
	__le64 c_ivin_addr;
	__le64 c_key_addr;
	__le64 data_src_addr;
	__le64 data_dst_addr;

	/*
	 * done: 0 bit
	 * icv: 1~3 bits
	 * flag: 7~10 bits
	 * dif_check: 11~13 bits
	 */
	__le16 dn_icvflg_dif;
	__u8 error_type;
	__u8 warning_type;
	__le32 dw29;
	__le32 dw30;
	__le32 dw31;
};
#endif

struct sec_sqe {
	/*
	 * type:	0~3 bits
	 * cipher:	4~5 bits
	 * auth:	6~7 bit s
	 */
	__u8 type_cipher_auth;

	/*
	 * seq:	0 bit
	 * de:	1~2 bits
	 * scene:	3~6 bits
	 * src_addr_type: ~7 bit, with sdm_addr_type 0-1 bits
	 */
	__u8 sds_sa_type;

	/*
	 * src_addr_type: 0~1 bits, not used now,
	 * if support PRP, set this field, or set zero.
	 * dst_addr_type: 2~4 bits
	 * mac_addr_type: 5~7 bits
	 */
	__u8 sdm_addr_type;
	__u8 rsvd0;

	/*
	 * nonce_len(type2): 0~3 bits
	 * huk(type2): 4 bit
	 * key_s(type2): 5 bit
	 * ci_gen: 6~7 bits
	 */
	__u8 huk_key_ci;

	/*
	 * ai_gen: 0~1 bits
	 * a_pad(type2): 2~3 bits
	 * c_s(type2): 4~5 bits
	 */
	__u8 ai_apd_cs;

	/*
	 * rhf(type2): 0 bit
	 * c_key_type: 1~2 bits
	 * a_key_type: 3~4 bits
	 * write_frame_len(type2): 5~7 bits
	 */
	__u8 rca_key_frm;

	/*
	 * cal_iv_addr_en(type2): 0 bit
	 * tls_up(type2): 1 bit
	 * inveld: 7 bit
	 */
	__u8 iv_tls_ld;

	union {
#ifdef CONFIG_CRYPTO_DEV_HISI_SEC2_FUSION
		struct sec_sqe_type1 type1;
#endif
		struct sec_sqe_type2 type2;
	};
};

int sec_register_to_crypto(void);
void sec_unregister_from_crypto(void);
#endif
