/*
 * Copyright (C) 2019  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef _gc_10_3_0_OFFSET_HEADER
#define _gc_10_3_0_OFFSET_HEADER

#define mmSQ_DEBUG_STS_GLOBAL                                                                          0x10A9
#define mmSQ_DEBUG_STS_GLOBAL_BASE_IDX                                                                 0
#define mmSQ_DEBUG_STS_GLOBAL2                                                                         0x10B0
#define mmSQ_DEBUG_STS_GLOBAL2_BASE_IDX                                                                0

// addressBlock: gc_sdma0_sdma0dec
// base address: 0x4980
#define mmSDMA0_DEC_START                                                                              0x0000
#define mmSDMA0_DEC_START_BASE_IDX                                                                     0
#define mmSDMA0_GLOBAL_TIMESTAMP_LO                                                                    0x000f
#define mmSDMA0_GLOBAL_TIMESTAMP_LO_BASE_IDX                                                           0
#define mmSDMA0_GLOBAL_TIMESTAMP_HI                                                                    0x0010
#define mmSDMA0_GLOBAL_TIMESTAMP_HI_BASE_IDX                                                           0
#define mmSDMA0_PG_CNTL                                                                                0x0016
#define mmSDMA0_PG_CNTL_BASE_IDX                                                                       0
#define mmSDMA0_PG_CTX_LO                                                                              0x0017
#define mmSDMA0_PG_CTX_LO_BASE_IDX                                                                     0
#define mmSDMA0_PG_CTX_HI                                                                              0x0018
#define mmSDMA0_PG_CTX_HI_BASE_IDX                                                                     0
#define mmSDMA0_PG_CTX_CNTL                                                                            0x0019
#define mmSDMA0_PG_CTX_CNTL_BASE_IDX                                                                   0
#define mmSDMA0_POWER_CNTL                                                                             0x001a
#define mmSDMA0_POWER_CNTL_BASE_IDX                                                                    0
#define mmSDMA0_CLK_CTRL                                                                               0x001b
#define mmSDMA0_CLK_CTRL_BASE_IDX                                                                      0
#define mmSDMA0_CNTL                                                                                   0x001c
#define mmSDMA0_CNTL_BASE_IDX                                                                          0
#define mmSDMA0_CHICKEN_BITS                                                                           0x001d
#define mmSDMA0_CHICKEN_BITS_BASE_IDX                                                                  0
#define mmSDMA0_GB_ADDR_CONFIG                                                                         0x001e
#define mmSDMA0_GB_ADDR_CONFIG_BASE_IDX                                                                0
#define mmSDMA0_GB_ADDR_CONFIG_READ                                                                    0x001f
#define mmSDMA0_GB_ADDR_CONFIG_READ_BASE_IDX                                                           0
#define mmSDMA0_RB_RPTR_FETCH_HI                                                                       0x0020
#define mmSDMA0_RB_RPTR_FETCH_HI_BASE_IDX                                                              0
#define mmSDMA0_SEM_WAIT_FAIL_TIMER_CNTL                                                               0x0021
#define mmSDMA0_SEM_WAIT_FAIL_TIMER_CNTL_BASE_IDX                                                      0
#define mmSDMA0_RB_RPTR_FETCH                                                                          0x0022
#define mmSDMA0_RB_RPTR_FETCH_BASE_IDX                                                                 0
#define mmSDMA0_IB_OFFSET_FETCH                                                                        0x0023
#define mmSDMA0_IB_OFFSET_FETCH_BASE_IDX                                                               0
#define mmSDMA0_PROGRAM                                                                                0x0024
#define mmSDMA0_PROGRAM_BASE_IDX                                                                       0
#define mmSDMA0_STATUS_REG                                                                             0x0025
#define mmSDMA0_STATUS_REG_BASE_IDX                                                                    0
#define mmSDMA0_STATUS1_REG                                                                            0x0026
#define mmSDMA0_STATUS1_REG_BASE_IDX                                                                   0
#define mmSDMA0_RD_BURST_CNTL                                                                          0x0027
#define mmSDMA0_RD_BURST_CNTL_BASE_IDX                                                                 0
#define mmSDMA0_HBM_PAGE_CONFIG                                                                        0x0028
#define mmSDMA0_HBM_PAGE_CONFIG_BASE_IDX                                                               0
#define mmSDMA0_UCODE_CHECKSUM                                                                         0x0029
#define mmSDMA0_UCODE_CHECKSUM_BASE_IDX                                                                0
#define mmSDMA0_F32_CNTL                                                                               0x002a
#define mmSDMA0_F32_CNTL_BASE_IDX                                                                      0
#define mmSDMA0_FREEZE                                                                                 0x002b
#define mmSDMA0_FREEZE_BASE_IDX                                                                        0
#define mmSDMA0_PHASE0_QUANTUM                                                                         0x002c
#define mmSDMA0_PHASE0_QUANTUM_BASE_IDX                                                                0
#define mmSDMA0_PHASE1_QUANTUM                                                                         0x002d
#define mmSDMA0_PHASE1_QUANTUM_BASE_IDX                                                                0
#define mmSDMA0_EDC_CONFIG                                                                             0x0032
#define mmSDMA0_EDC_CONFIG_BASE_IDX                                                                    0
#define mmSDMA0_BA_THRESHOLD                                                                           0x0033
#define mmSDMA0_BA_THRESHOLD_BASE_IDX                                                                  0
#define mmSDMA0_ID                                                                                     0x0034
#define mmSDMA0_ID_BASE_IDX                                                                            0
#define mmSDMA0_VERSION                                                                                0x0035
#define mmSDMA0_VERSION_BASE_IDX                                                                       0
#define mmSDMA0_EDC_COUNTER                                                                            0x0036
#define mmSDMA0_EDC_COUNTER_BASE_IDX                                                                   0
#define mmSDMA0_EDC_COUNTER_CLEAR                                                                      0x0037
#define mmSDMA0_EDC_COUNTER_CLEAR_BASE_IDX                                                             0
#define mmSDMA0_STATUS2_REG                                                                            0x0038
#define mmSDMA0_STATUS2_REG_BASE_IDX                                                                   0
#define mmSDMA0_ATOMIC_CNTL                                                                            0x0039
#define mmSDMA0_ATOMIC_CNTL_BASE_IDX                                                                   0
#define mmSDMA0_ATOMIC_PREOP_LO                                                                        0x003a
#define mmSDMA0_ATOMIC_PREOP_LO_BASE_IDX                                                               0
#define mmSDMA0_ATOMIC_PREOP_HI                                                                        0x003b
#define mmSDMA0_ATOMIC_PREOP_HI_BASE_IDX                                                               0
#define mmSDMA0_UTCL1_CNTL                                                                             0x003c
#define mmSDMA0_UTCL1_CNTL_BASE_IDX                                                                    0
#define mmSDMA0_UTCL1_WATERMK                                                                          0x003d
#define mmSDMA0_UTCL1_WATERMK_BASE_IDX                                                                 0
#define mmSDMA0_UTCL1_RD_STATUS                                                                        0x003e
#define mmSDMA0_UTCL1_RD_STATUS_BASE_IDX                                                               0
#define mmSDMA0_UTCL1_WR_STATUS                                                                        0x003f
#define mmSDMA0_UTCL1_WR_STATUS_BASE_IDX                                                               0
#define mmSDMA0_UTCL1_INV0                                                                             0x0040
#define mmSDMA0_UTCL1_INV0_BASE_IDX                                                                    0
#define mmSDMA0_UTCL1_INV1                                                                             0x0041
#define mmSDMA0_UTCL1_INV1_BASE_IDX                                                                    0
#define mmSDMA0_UTCL1_INV2                                                                             0x0042
#define mmSDMA0_UTCL1_INV2_BASE_IDX                                                                    0
#define mmSDMA0_UTCL1_RD_XNACK0                                                                        0x0043
#define mmSDMA0_UTCL1_RD_XNACK0_BASE_IDX                                                               0
#define mmSDMA0_UTCL1_RD_XNACK1                                                                        0x0044
#define mmSDMA0_UTCL1_RD_XNACK1_BASE_IDX                                                               0
#define mmSDMA0_UTCL1_WR_XNACK0                                                                        0x0045
#define mmSDMA0_UTCL1_WR_XNACK0_BASE_IDX                                                               0
#define mmSDMA0_UTCL1_WR_XNACK1                                                                        0x0046
#define mmSDMA0_UTCL1_WR_XNACK1_BASE_IDX                                                               0
#define mmSDMA0_UTCL1_TIMEOUT                                                                          0x0047
#define mmSDMA0_UTCL1_TIMEOUT_BASE_IDX                                                                 0
#define mmSDMA0_UTCL1_PAGE                                                                             0x0048
#define mmSDMA0_UTCL1_PAGE_BASE_IDX                                                                    0
#define mmSDMA0_RELAX_ORDERING_LUT                                                                     0x004a
#define mmSDMA0_RELAX_ORDERING_LUT_BASE_IDX                                                            0
#define mmSDMA0_CHICKEN_BITS_2                                                                         0x004b
#define mmSDMA0_CHICKEN_BITS_2_BASE_IDX                                                                0
#define mmSDMA0_STATUS3_REG                                                                            0x004c
#define mmSDMA0_STATUS3_REG_BASE_IDX                                                                   0
#define mmSDMA0_PHYSICAL_ADDR_LO                                                                       0x004d
#define mmSDMA0_PHYSICAL_ADDR_LO_BASE_IDX                                                              0
#define mmSDMA0_PHYSICAL_ADDR_HI                                                                       0x004e
#define mmSDMA0_PHYSICAL_ADDR_HI_BASE_IDX                                                              0
#define mmSDMA0_PHASE2_QUANTUM                                                                         0x004f
#define mmSDMA0_PHASE2_QUANTUM_BASE_IDX                                                                0
#define mmSDMA0_ERROR_LOG                                                                              0x0050
#define mmSDMA0_ERROR_LOG_BASE_IDX                                                                     0
#define mmSDMA0_PUB_DUMMY_REG0                                                                         0x0051
#define mmSDMA0_PUB_DUMMY_REG0_BASE_IDX                                                                0
#define mmSDMA0_PUB_DUMMY_REG1                                                                         0x0052
#define mmSDMA0_PUB_DUMMY_REG1_BASE_IDX                                                                0
#define mmSDMA0_PUB_DUMMY_REG2                                                                         0x0053
#define mmSDMA0_PUB_DUMMY_REG2_BASE_IDX                                                                0
#define mmSDMA0_PUB_DUMMY_REG3                                                                         0x0054
#define mmSDMA0_PUB_DUMMY_REG3_BASE_IDX                                                                0
#define mmSDMA0_F32_COUNTER                                                                            0x0055
#define mmSDMA0_F32_COUNTER_BASE_IDX                                                                   0
#define mmSDMA0_CRD_CNTL                                                                               0x005b
#define mmSDMA0_CRD_CNTL_BASE_IDX                                                                      0
#define mmSDMA0_AQL_STATUS                                                                             0x005f
#define mmSDMA0_AQL_STATUS_BASE_IDX                                                                    0
#define mmSDMA0_EA_DBIT_ADDR_DATA                                                                      0x0060
#define mmSDMA0_EA_DBIT_ADDR_DATA_BASE_IDX                                                             0
#define mmSDMA0_EA_DBIT_ADDR_INDEX                                                                     0x0061
#define mmSDMA0_EA_DBIT_ADDR_INDEX_BASE_IDX                                                            0
#define mmSDMA0_TLBI_GCR_CNTL                                                                          0x0062
#define mmSDMA0_TLBI_GCR_CNTL_BASE_IDX                                                                 0
#define mmSDMA0_TILING_CONFIG                                                                          0x0063
#define mmSDMA0_TILING_CONFIG_BASE_IDX                                                                 0
#define mmSDMA0_INT_STATUS                                                                             0x0070
#define mmSDMA0_INT_STATUS_BASE_IDX                                                                    0
#define mmSDMA0_HOLE_ADDR_LO                                                                           0x0072
#define mmSDMA0_HOLE_ADDR_LO_BASE_IDX                                                                  0
#define mmSDMA0_HOLE_ADDR_HI                                                                           0x0073
#define mmSDMA0_HOLE_ADDR_HI_BASE_IDX                                                                  0
#define mmSDMA0_CLOCK_GATING_REG                                                                       0x0075
#define mmSDMA0_CLOCK_GATING_REG_BASE_IDX                                                              0
#define mmSDMA0_STATUS4_REG                                                                            0x0076
#define mmSDMA0_STATUS4_REG_BASE_IDX                                                                   0
#define mmSDMA0_SCRATCH_RAM_DATA                                                                       0x0077
#define mmSDMA0_SCRATCH_RAM_DATA_BASE_IDX                                                              0
#define mmSDMA0_SCRATCH_RAM_ADDR                                                                       0x0078
#define mmSDMA0_SCRATCH_RAM_ADDR_BASE_IDX                                                              0
#define mmSDMA0_TIMESTAMP_CNTL                                                                         0x0079
#define mmSDMA0_TIMESTAMP_CNTL_BASE_IDX                                                                0
#define mmSDMA0_STATUS5_REG                                                                            0x007a
#define mmSDMA0_STATUS5_REG_BASE_IDX                                                                   0
#define mmSDMA0_QUEUE_RESET_REQ                                                                        0x007b
#define mmSDMA0_QUEUE_RESET_REQ_BASE_IDX                                                               0
#define mmSDMA0_GFX_RB_CNTL                                                                            0x0080
#define mmSDMA0_GFX_RB_CNTL_BASE_IDX                                                                   0
#define mmSDMA0_GFX_RB_BASE                                                                            0x0081
#define mmSDMA0_GFX_RB_BASE_BASE_IDX                                                                   0
#define mmSDMA0_GFX_RB_BASE_HI                                                                         0x0082
#define mmSDMA0_GFX_RB_BASE_HI_BASE_IDX                                                                0
#define mmSDMA0_GFX_RB_RPTR                                                                            0x0083
#define mmSDMA0_GFX_RB_RPTR_BASE_IDX                                                                   0
#define mmSDMA0_GFX_RB_RPTR_HI                                                                         0x0084
#define mmSDMA0_GFX_RB_RPTR_HI_BASE_IDX                                                                0
#define mmSDMA0_GFX_RB_WPTR                                                                            0x0085
#define mmSDMA0_GFX_RB_WPTR_BASE_IDX                                                                   0
#define mmSDMA0_GFX_RB_WPTR_HI                                                                         0x0086
#define mmSDMA0_GFX_RB_WPTR_HI_BASE_IDX                                                                0
#define mmSDMA0_GFX_RB_WPTR_POLL_CNTL                                                                  0x0087
#define mmSDMA0_GFX_RB_WPTR_POLL_CNTL_BASE_IDX                                                         0
#define mmSDMA0_GFX_RB_RPTR_ADDR_HI                                                                    0x0088
#define mmSDMA0_GFX_RB_RPTR_ADDR_HI_BASE_IDX                                                           0
#define mmSDMA0_GFX_RB_RPTR_ADDR_LO                                                                    0x0089
#define mmSDMA0_GFX_RB_RPTR_ADDR_LO_BASE_IDX                                                           0
#define mmSDMA0_GFX_IB_CNTL                                                                            0x008a
#define mmSDMA0_GFX_IB_CNTL_BASE_IDX                                                                   0
#define mmSDMA0_GFX_IB_RPTR                                                                            0x008b
#define mmSDMA0_GFX_IB_RPTR_BASE_IDX                                                                   0
#define mmSDMA0_GFX_IB_OFFSET                                                                          0x008c
#define mmSDMA0_GFX_IB_OFFSET_BASE_IDX                                                                 0
#define mmSDMA0_GFX_IB_BASE_LO                                                                         0x008d
#define mmSDMA0_GFX_IB_BASE_LO_BASE_IDX                                                                0
#define mmSDMA0_GFX_IB_BASE_HI                                                                         0x008e
#define mmSDMA0_GFX_IB_BASE_HI_BASE_IDX                                                                0
#define mmSDMA0_GFX_IB_SIZE                                                                            0x008f
#define mmSDMA0_GFX_IB_SIZE_BASE_IDX                                                                   0
#define mmSDMA0_GFX_SKIP_CNTL                                                                          0x0090
#define mmSDMA0_GFX_SKIP_CNTL_BASE_IDX                                                                 0
#define mmSDMA0_GFX_CONTEXT_STATUS                                                                     0x0091
#define mmSDMA0_GFX_CONTEXT_STATUS_BASE_IDX                                                            0
#define mmSDMA0_GFX_DOORBELL                                                                           0x0092
#define mmSDMA0_GFX_DOORBELL_BASE_IDX                                                                  0
#define mmSDMA0_GFX_CONTEXT_CNTL                                                                       0x0093
#define mmSDMA0_GFX_CONTEXT_CNTL_BASE_IDX                                                              0
#define mmSDMA0_GFX_STATUS                                                                             0x00a8
#define mmSDMA0_GFX_STATUS_BASE_IDX                                                                    0
#define mmSDMA0_GFX_DOORBELL_LOG                                                                       0x00a9
#define mmSDMA0_GFX_DOORBELL_LOG_BASE_IDX                                                              0
#define mmSDMA0_GFX_WATERMARK                                                                          0x00aa
#define mmSDMA0_GFX_WATERMARK_BASE_IDX                                                                 0
#define mmSDMA0_GFX_DOORBELL_OFFSET                                                                    0x00ab
#define mmSDMA0_GFX_DOORBELL_OFFSET_BASE_IDX                                                           0
#define mmSDMA0_GFX_CSA_ADDR_LO                                                                        0x00ac
#define mmSDMA0_GFX_CSA_ADDR_LO_BASE_IDX                                                               0
#define mmSDMA0_GFX_CSA_ADDR_HI                                                                        0x00ad
#define mmSDMA0_GFX_CSA_ADDR_HI_BASE_IDX                                                               0
#define mmSDMA0_GFX_IB_SUB_REMAIN                                                                      0x00af
#define mmSDMA0_GFX_IB_SUB_REMAIN_BASE_IDX                                                             0
#define mmSDMA0_GFX_PREEMPT                                                                            0x00b0
#define mmSDMA0_GFX_PREEMPT_BASE_IDX                                                                   0
#define mmSDMA0_GFX_DUMMY_REG                                                                          0x00b1
#define mmSDMA0_GFX_DUMMY_REG_BASE_IDX                                                                 0
#define mmSDMA0_GFX_RB_WPTR_POLL_ADDR_HI                                                               0x00b2
#define mmSDMA0_GFX_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                      0
#define mmSDMA0_GFX_RB_WPTR_POLL_ADDR_LO                                                               0x00b3
#define mmSDMA0_GFX_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                      0
#define mmSDMA0_GFX_RB_AQL_CNTL                                                                        0x00b4
#define mmSDMA0_GFX_RB_AQL_CNTL_BASE_IDX                                                               0
#define mmSDMA0_GFX_MINOR_PTR_UPDATE                                                                   0x00b5
#define mmSDMA0_GFX_MINOR_PTR_UPDATE_BASE_IDX                                                          0
#define mmSDMA0_GFX_MIDCMD_DATA0                                                                       0x00c0
#define mmSDMA0_GFX_MIDCMD_DATA0_BASE_IDX                                                              0
#define mmSDMA0_GFX_MIDCMD_DATA1                                                                       0x00c1
#define mmSDMA0_GFX_MIDCMD_DATA1_BASE_IDX                                                              0
#define mmSDMA0_GFX_MIDCMD_DATA2                                                                       0x00c2
#define mmSDMA0_GFX_MIDCMD_DATA2_BASE_IDX                                                              0
#define mmSDMA0_GFX_MIDCMD_DATA3                                                                       0x00c3
#define mmSDMA0_GFX_MIDCMD_DATA3_BASE_IDX                                                              0
#define mmSDMA0_GFX_MIDCMD_DATA4                                                                       0x00c4
#define mmSDMA0_GFX_MIDCMD_DATA4_BASE_IDX                                                              0
#define mmSDMA0_GFX_MIDCMD_DATA5                                                                       0x00c5
#define mmSDMA0_GFX_MIDCMD_DATA5_BASE_IDX                                                              0
#define mmSDMA0_GFX_MIDCMD_DATA6                                                                       0x00c6
#define mmSDMA0_GFX_MIDCMD_DATA6_BASE_IDX                                                              0
#define mmSDMA0_GFX_MIDCMD_DATA7                                                                       0x00c7
#define mmSDMA0_GFX_MIDCMD_DATA7_BASE_IDX                                                              0
#define mmSDMA0_GFX_MIDCMD_DATA8                                                                       0x00c8
#define mmSDMA0_GFX_MIDCMD_DATA8_BASE_IDX                                                              0
#define mmSDMA0_GFX_MIDCMD_DATA9                                                                       0x00c9
#define mmSDMA0_GFX_MIDCMD_DATA9_BASE_IDX                                                              0
#define mmSDMA0_GFX_MIDCMD_DATA10                                                                      0x00ca
#define mmSDMA0_GFX_MIDCMD_DATA10_BASE_IDX                                                             0
#define mmSDMA0_GFX_MIDCMD_CNTL                                                                        0x00cb
#define mmSDMA0_GFX_MIDCMD_CNTL_BASE_IDX                                                               0
#define mmSDMA0_PAGE_RB_CNTL                                                                           0x00d8
#define mmSDMA0_PAGE_RB_CNTL_BASE_IDX                                                                  0
#define mmSDMA0_PAGE_RB_BASE                                                                           0x00d9
#define mmSDMA0_PAGE_RB_BASE_BASE_IDX                                                                  0
#define mmSDMA0_PAGE_RB_BASE_HI                                                                        0x00da
#define mmSDMA0_PAGE_RB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA0_PAGE_RB_RPTR                                                                           0x00db
#define mmSDMA0_PAGE_RB_RPTR_BASE_IDX                                                                  0
#define mmSDMA0_PAGE_RB_RPTR_HI                                                                        0x00dc
#define mmSDMA0_PAGE_RB_RPTR_HI_BASE_IDX                                                               0
#define mmSDMA0_PAGE_RB_WPTR                                                                           0x00dd
#define mmSDMA0_PAGE_RB_WPTR_BASE_IDX                                                                  0
#define mmSDMA0_PAGE_RB_WPTR_HI                                                                        0x00de
#define mmSDMA0_PAGE_RB_WPTR_HI_BASE_IDX                                                               0
#define mmSDMA0_PAGE_RB_WPTR_POLL_CNTL                                                                 0x00df
#define mmSDMA0_PAGE_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define mmSDMA0_PAGE_RB_RPTR_ADDR_HI                                                                   0x00e0
#define mmSDMA0_PAGE_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define mmSDMA0_PAGE_RB_RPTR_ADDR_LO                                                                   0x00e1
#define mmSDMA0_PAGE_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define mmSDMA0_PAGE_IB_CNTL                                                                           0x00e2
#define mmSDMA0_PAGE_IB_CNTL_BASE_IDX                                                                  0
#define mmSDMA0_PAGE_IB_RPTR                                                                           0x00e3
#define mmSDMA0_PAGE_IB_RPTR_BASE_IDX                                                                  0
#define mmSDMA0_PAGE_IB_OFFSET                                                                         0x00e4
#define mmSDMA0_PAGE_IB_OFFSET_BASE_IDX                                                                0
#define mmSDMA0_PAGE_IB_BASE_LO                                                                        0x00e5
#define mmSDMA0_PAGE_IB_BASE_LO_BASE_IDX                                                               0
#define mmSDMA0_PAGE_IB_BASE_HI                                                                        0x00e6
#define mmSDMA0_PAGE_IB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA0_PAGE_IB_SIZE                                                                           0x00e7
#define mmSDMA0_PAGE_IB_SIZE_BASE_IDX                                                                  0
#define mmSDMA0_PAGE_SKIP_CNTL                                                                         0x00e8
#define mmSDMA0_PAGE_SKIP_CNTL_BASE_IDX                                                                0
#define mmSDMA0_PAGE_CONTEXT_STATUS                                                                    0x00e9
#define mmSDMA0_PAGE_CONTEXT_STATUS_BASE_IDX                                                           0
#define mmSDMA0_PAGE_DOORBELL                                                                          0x00ea
#define mmSDMA0_PAGE_DOORBELL_BASE_IDX                                                                 0
#define mmSDMA0_PAGE_STATUS                                                                            0x0100
#define mmSDMA0_PAGE_STATUS_BASE_IDX                                                                   0
#define mmSDMA0_PAGE_DOORBELL_LOG                                                                      0x0101
#define mmSDMA0_PAGE_DOORBELL_LOG_BASE_IDX                                                             0
#define mmSDMA0_PAGE_WATERMARK                                                                         0x0102
#define mmSDMA0_PAGE_WATERMARK_BASE_IDX                                                                0
#define mmSDMA0_PAGE_DOORBELL_OFFSET                                                                   0x0103
#define mmSDMA0_PAGE_DOORBELL_OFFSET_BASE_IDX                                                          0
#define mmSDMA0_PAGE_CSA_ADDR_LO                                                                       0x0104
#define mmSDMA0_PAGE_CSA_ADDR_LO_BASE_IDX                                                              0
#define mmSDMA0_PAGE_CSA_ADDR_HI                                                                       0x0105
#define mmSDMA0_PAGE_CSA_ADDR_HI_BASE_IDX                                                              0
#define mmSDMA0_PAGE_IB_SUB_REMAIN                                                                     0x0107
#define mmSDMA0_PAGE_IB_SUB_REMAIN_BASE_IDX                                                            0
#define mmSDMA0_PAGE_PREEMPT                                                                           0x0108
#define mmSDMA0_PAGE_PREEMPT_BASE_IDX                                                                  0
#define mmSDMA0_PAGE_DUMMY_REG                                                                         0x0109
#define mmSDMA0_PAGE_DUMMY_REG_BASE_IDX                                                                0
#define mmSDMA0_PAGE_RB_WPTR_POLL_ADDR_HI                                                              0x010a
#define mmSDMA0_PAGE_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define mmSDMA0_PAGE_RB_WPTR_POLL_ADDR_LO                                                              0x010b
#define mmSDMA0_PAGE_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define mmSDMA0_PAGE_RB_AQL_CNTL                                                                       0x010c
#define mmSDMA0_PAGE_RB_AQL_CNTL_BASE_IDX                                                              0
#define mmSDMA0_PAGE_MINOR_PTR_UPDATE                                                                  0x010d
#define mmSDMA0_PAGE_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define mmSDMA0_PAGE_MIDCMD_DATA0                                                                      0x0118
#define mmSDMA0_PAGE_MIDCMD_DATA0_BASE_IDX                                                             0
#define mmSDMA0_PAGE_MIDCMD_DATA1                                                                      0x0119
#define mmSDMA0_PAGE_MIDCMD_DATA1_BASE_IDX                                                             0
#define mmSDMA0_PAGE_MIDCMD_DATA2                                                                      0x011a
#define mmSDMA0_PAGE_MIDCMD_DATA2_BASE_IDX                                                             0
#define mmSDMA0_PAGE_MIDCMD_DATA3                                                                      0x011b
#define mmSDMA0_PAGE_MIDCMD_DATA3_BASE_IDX                                                             0
#define mmSDMA0_PAGE_MIDCMD_DATA4                                                                      0x011c
#define mmSDMA0_PAGE_MIDCMD_DATA4_BASE_IDX                                                             0
#define mmSDMA0_PAGE_MIDCMD_DATA5                                                                      0x011d
#define mmSDMA0_PAGE_MIDCMD_DATA5_BASE_IDX                                                             0
#define mmSDMA0_PAGE_MIDCMD_DATA6                                                                      0x011e
#define mmSDMA0_PAGE_MIDCMD_DATA6_BASE_IDX                                                             0
#define mmSDMA0_PAGE_MIDCMD_DATA7                                                                      0x011f
#define mmSDMA0_PAGE_MIDCMD_DATA7_BASE_IDX                                                             0
#define mmSDMA0_PAGE_MIDCMD_DATA8                                                                      0x0120
#define mmSDMA0_PAGE_MIDCMD_DATA8_BASE_IDX                                                             0
#define mmSDMA0_PAGE_MIDCMD_DATA9                                                                      0x0121
#define mmSDMA0_PAGE_MIDCMD_DATA9_BASE_IDX                                                             0
#define mmSDMA0_PAGE_MIDCMD_DATA10                                                                     0x0122
#define mmSDMA0_PAGE_MIDCMD_DATA10_BASE_IDX                                                            0
#define mmSDMA0_PAGE_MIDCMD_CNTL                                                                       0x0123
#define mmSDMA0_PAGE_MIDCMD_CNTL_BASE_IDX                                                              0
#define mmSDMA0_RLC0_RB_CNTL                                                                           0x0130
#define mmSDMA0_RLC0_RB_CNTL_BASE_IDX                                                                  0
#define mmSDMA0_RLC0_RB_BASE                                                                           0x0131
#define mmSDMA0_RLC0_RB_BASE_BASE_IDX                                                                  0
#define mmSDMA0_RLC0_RB_BASE_HI                                                                        0x0132
#define mmSDMA0_RLC0_RB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA0_RLC0_RB_RPTR                                                                           0x0133
#define mmSDMA0_RLC0_RB_RPTR_BASE_IDX                                                                  0
#define mmSDMA0_RLC0_RB_RPTR_HI                                                                        0x0134
#define mmSDMA0_RLC0_RB_RPTR_HI_BASE_IDX                                                               0
#define mmSDMA0_RLC0_RB_WPTR                                                                           0x0135
#define mmSDMA0_RLC0_RB_WPTR_BASE_IDX                                                                  0
#define mmSDMA0_RLC0_RB_WPTR_HI                                                                        0x0136
#define mmSDMA0_RLC0_RB_WPTR_HI_BASE_IDX                                                               0
#define mmSDMA0_RLC0_RB_WPTR_POLL_CNTL                                                                 0x0137
#define mmSDMA0_RLC0_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define mmSDMA0_RLC0_RB_RPTR_ADDR_HI                                                                   0x0138
#define mmSDMA0_RLC0_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define mmSDMA0_RLC0_RB_RPTR_ADDR_LO                                                                   0x0139
#define mmSDMA0_RLC0_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define mmSDMA0_RLC0_IB_CNTL                                                                           0x013a
#define mmSDMA0_RLC0_IB_CNTL_BASE_IDX                                                                  0
#define mmSDMA0_RLC0_IB_RPTR                                                                           0x013b
#define mmSDMA0_RLC0_IB_RPTR_BASE_IDX                                                                  0
#define mmSDMA0_RLC0_IB_OFFSET                                                                         0x013c
#define mmSDMA0_RLC0_IB_OFFSET_BASE_IDX                                                                0
#define mmSDMA0_RLC0_IB_BASE_LO                                                                        0x013d
#define mmSDMA0_RLC0_IB_BASE_LO_BASE_IDX                                                               0
#define mmSDMA0_RLC0_IB_BASE_HI                                                                        0x013e
#define mmSDMA0_RLC0_IB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA0_RLC0_IB_SIZE                                                                           0x013f
#define mmSDMA0_RLC0_IB_SIZE_BASE_IDX                                                                  0
#define mmSDMA0_RLC0_SKIP_CNTL                                                                         0x0140
#define mmSDMA0_RLC0_SKIP_CNTL_BASE_IDX                                                                0
#define mmSDMA0_RLC0_CONTEXT_STATUS                                                                    0x0141
#define mmSDMA0_RLC0_CONTEXT_STATUS_BASE_IDX                                                           0
#define mmSDMA0_RLC0_DOORBELL                                                                          0x0142
#define mmSDMA0_RLC0_DOORBELL_BASE_IDX                                                                 0
#define mmSDMA0_RLC0_STATUS                                                                            0x0158
#define mmSDMA0_RLC0_STATUS_BASE_IDX                                                                   0
#define mmSDMA0_RLC0_DOORBELL_LOG                                                                      0x0159
#define mmSDMA0_RLC0_DOORBELL_LOG_BASE_IDX                                                             0
#define mmSDMA0_RLC0_WATERMARK                                                                         0x015a
#define mmSDMA0_RLC0_WATERMARK_BASE_IDX                                                                0
#define mmSDMA0_RLC0_DOORBELL_OFFSET                                                                   0x015b
#define mmSDMA0_RLC0_DOORBELL_OFFSET_BASE_IDX                                                          0
#define mmSDMA0_RLC0_CSA_ADDR_LO                                                                       0x015c
#define mmSDMA0_RLC0_CSA_ADDR_LO_BASE_IDX                                                              0
#define mmSDMA0_RLC0_CSA_ADDR_HI                                                                       0x015d
#define mmSDMA0_RLC0_CSA_ADDR_HI_BASE_IDX                                                              0
#define mmSDMA0_RLC0_IB_SUB_REMAIN                                                                     0x015f
#define mmSDMA0_RLC0_IB_SUB_REMAIN_BASE_IDX                                                            0
#define mmSDMA0_RLC0_PREEMPT                                                                           0x0160
#define mmSDMA0_RLC0_PREEMPT_BASE_IDX                                                                  0
#define mmSDMA0_RLC0_DUMMY_REG                                                                         0x0161
#define mmSDMA0_RLC0_DUMMY_REG_BASE_IDX                                                                0
#define mmSDMA0_RLC0_RB_WPTR_POLL_ADDR_HI                                                              0x0162
#define mmSDMA0_RLC0_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define mmSDMA0_RLC0_RB_WPTR_POLL_ADDR_LO                                                              0x0163
#define mmSDMA0_RLC0_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define mmSDMA0_RLC0_RB_AQL_CNTL                                                                       0x0164
#define mmSDMA0_RLC0_RB_AQL_CNTL_BASE_IDX                                                              0
#define mmSDMA0_RLC0_MINOR_PTR_UPDATE                                                                  0x0165
#define mmSDMA0_RLC0_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define mmSDMA0_RLC0_MIDCMD_DATA0                                                                      0x0170
#define mmSDMA0_RLC0_MIDCMD_DATA0_BASE_IDX                                                             0
#define mmSDMA0_RLC0_MIDCMD_DATA1                                                                      0x0171
#define mmSDMA0_RLC0_MIDCMD_DATA1_BASE_IDX                                                             0
#define mmSDMA0_RLC0_MIDCMD_DATA2                                                                      0x0172
#define mmSDMA0_RLC0_MIDCMD_DATA2_BASE_IDX                                                             0
#define mmSDMA0_RLC0_MIDCMD_DATA3                                                                      0x0173
#define mmSDMA0_RLC0_MIDCMD_DATA3_BASE_IDX                                                             0
#define mmSDMA0_RLC0_MIDCMD_DATA4                                                                      0x0174
#define mmSDMA0_RLC0_MIDCMD_DATA4_BASE_IDX                                                             0
#define mmSDMA0_RLC0_MIDCMD_DATA5                                                                      0x0175
#define mmSDMA0_RLC0_MIDCMD_DATA5_BASE_IDX                                                             0
#define mmSDMA0_RLC0_MIDCMD_DATA6                                                                      0x0176
#define mmSDMA0_RLC0_MIDCMD_DATA6_BASE_IDX                                                             0
#define mmSDMA0_RLC0_MIDCMD_DATA7                                                                      0x0177
#define mmSDMA0_RLC0_MIDCMD_DATA7_BASE_IDX                                                             0
#define mmSDMA0_RLC0_MIDCMD_DATA8                                                                      0x0178
#define mmSDMA0_RLC0_MIDCMD_DATA8_BASE_IDX                                                             0
#define mmSDMA0_RLC0_MIDCMD_DATA9                                                                      0x0179
#define mmSDMA0_RLC0_MIDCMD_DATA9_BASE_IDX                                                             0
#define mmSDMA0_RLC0_MIDCMD_DATA10                                                                     0x017a
#define mmSDMA0_RLC0_MIDCMD_DATA10_BASE_IDX                                                            0
#define mmSDMA0_RLC0_MIDCMD_CNTL                                                                       0x017b
#define mmSDMA0_RLC0_MIDCMD_CNTL_BASE_IDX                                                              0
#define mmSDMA0_RLC1_RB_CNTL                                                                           0x0188
#define mmSDMA0_RLC1_RB_CNTL_BASE_IDX                                                                  0
#define mmSDMA0_RLC1_RB_BASE                                                                           0x0189
#define mmSDMA0_RLC1_RB_BASE_BASE_IDX                                                                  0
#define mmSDMA0_RLC1_RB_BASE_HI                                                                        0x018a
#define mmSDMA0_RLC1_RB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA0_RLC1_RB_RPTR                                                                           0x018b
#define mmSDMA0_RLC1_RB_RPTR_BASE_IDX                                                                  0
#define mmSDMA0_RLC1_RB_RPTR_HI                                                                        0x018c
#define mmSDMA0_RLC1_RB_RPTR_HI_BASE_IDX                                                               0
#define mmSDMA0_RLC1_RB_WPTR                                                                           0x018d
#define mmSDMA0_RLC1_RB_WPTR_BASE_IDX                                                                  0
#define mmSDMA0_RLC1_RB_WPTR_HI                                                                        0x018e
#define mmSDMA0_RLC1_RB_WPTR_HI_BASE_IDX                                                               0
#define mmSDMA0_RLC1_RB_WPTR_POLL_CNTL                                                                 0x018f
#define mmSDMA0_RLC1_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define mmSDMA0_RLC1_RB_RPTR_ADDR_HI                                                                   0x0190
#define mmSDMA0_RLC1_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define mmSDMA0_RLC1_RB_RPTR_ADDR_LO                                                                   0x0191
#define mmSDMA0_RLC1_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define mmSDMA0_RLC1_IB_CNTL                                                                           0x0192
#define mmSDMA0_RLC1_IB_CNTL_BASE_IDX                                                                  0
#define mmSDMA0_RLC1_IB_RPTR                                                                           0x0193
#define mmSDMA0_RLC1_IB_RPTR_BASE_IDX                                                                  0
#define mmSDMA0_RLC1_IB_OFFSET                                                                         0x0194
#define mmSDMA0_RLC1_IB_OFFSET_BASE_IDX                                                                0
#define mmSDMA0_RLC1_IB_BASE_LO                                                                        0x0195
#define mmSDMA0_RLC1_IB_BASE_LO_BASE_IDX                                                               0
#define mmSDMA0_RLC1_IB_BASE_HI                                                                        0x0196
#define mmSDMA0_RLC1_IB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA0_RLC1_IB_SIZE                                                                           0x0197
#define mmSDMA0_RLC1_IB_SIZE_BASE_IDX                                                                  0
#define mmSDMA0_RLC1_SKIP_CNTL                                                                         0x0198
#define mmSDMA0_RLC1_SKIP_CNTL_BASE_IDX                                                                0
#define mmSDMA0_RLC1_CONTEXT_STATUS                                                                    0x0199
#define mmSDMA0_RLC1_CONTEXT_STATUS_BASE_IDX                                                           0
#define mmSDMA0_RLC1_DOORBELL                                                                          0x019a
#define mmSDMA0_RLC1_DOORBELL_BASE_IDX                                                                 0
#define mmSDMA0_RLC1_STATUS                                                                            0x01b0
#define mmSDMA0_RLC1_STATUS_BASE_IDX                                                                   0
#define mmSDMA0_RLC1_DOORBELL_LOG                                                                      0x01b1
#define mmSDMA0_RLC1_DOORBELL_LOG_BASE_IDX                                                             0
#define mmSDMA0_RLC1_WATERMARK                                                                         0x01b2
#define mmSDMA0_RLC1_WATERMARK_BASE_IDX                                                                0
#define mmSDMA0_RLC1_DOORBELL_OFFSET                                                                   0x01b3
#define mmSDMA0_RLC1_DOORBELL_OFFSET_BASE_IDX                                                          0
#define mmSDMA0_RLC1_CSA_ADDR_LO                                                                       0x01b4
#define mmSDMA0_RLC1_CSA_ADDR_LO_BASE_IDX                                                              0
#define mmSDMA0_RLC1_CSA_ADDR_HI                                                                       0x01b5
#define mmSDMA0_RLC1_CSA_ADDR_HI_BASE_IDX                                                              0
#define mmSDMA0_RLC1_IB_SUB_REMAIN                                                                     0x01b7
#define mmSDMA0_RLC1_IB_SUB_REMAIN_BASE_IDX                                                            0
#define mmSDMA0_RLC1_PREEMPT                                                                           0x01b8
#define mmSDMA0_RLC1_PREEMPT_BASE_IDX                                                                  0
#define mmSDMA0_RLC1_DUMMY_REG                                                                         0x01b9
#define mmSDMA0_RLC1_DUMMY_REG_BASE_IDX                                                                0
#define mmSDMA0_RLC1_RB_WPTR_POLL_ADDR_HI                                                              0x01ba
#define mmSDMA0_RLC1_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define mmSDMA0_RLC1_RB_WPTR_POLL_ADDR_LO                                                              0x01bb
#define mmSDMA0_RLC1_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define mmSDMA0_RLC1_RB_AQL_CNTL                                                                       0x01bc
#define mmSDMA0_RLC1_RB_AQL_CNTL_BASE_IDX                                                              0
#define mmSDMA0_RLC1_MINOR_PTR_UPDATE                                                                  0x01bd
#define mmSDMA0_RLC1_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define mmSDMA0_RLC1_MIDCMD_DATA0                                                                      0x01c8
#define mmSDMA0_RLC1_MIDCMD_DATA0_BASE_IDX                                                             0
#define mmSDMA0_RLC1_MIDCMD_DATA1                                                                      0x01c9
#define mmSDMA0_RLC1_MIDCMD_DATA1_BASE_IDX                                                             0
#define mmSDMA0_RLC1_MIDCMD_DATA2                                                                      0x01ca
#define mmSDMA0_RLC1_MIDCMD_DATA2_BASE_IDX                                                             0
#define mmSDMA0_RLC1_MIDCMD_DATA3                                                                      0x01cb
#define mmSDMA0_RLC1_MIDCMD_DATA3_BASE_IDX                                                             0
#define mmSDMA0_RLC1_MIDCMD_DATA4                                                                      0x01cc
#define mmSDMA0_RLC1_MIDCMD_DATA4_BASE_IDX                                                             0
#define mmSDMA0_RLC1_MIDCMD_DATA5                                                                      0x01cd
#define mmSDMA0_RLC1_MIDCMD_DATA5_BASE_IDX                                                             0
#define mmSDMA0_RLC1_MIDCMD_DATA6                                                                      0x01ce
#define mmSDMA0_RLC1_MIDCMD_DATA6_BASE_IDX                                                             0
#define mmSDMA0_RLC1_MIDCMD_DATA7                                                                      0x01cf
#define mmSDMA0_RLC1_MIDCMD_DATA7_BASE_IDX                                                             0
#define mmSDMA0_RLC1_MIDCMD_DATA8                                                                      0x01d0
#define mmSDMA0_RLC1_MIDCMD_DATA8_BASE_IDX                                                             0
#define mmSDMA0_RLC1_MIDCMD_DATA9                                                                      0x01d1
#define mmSDMA0_RLC1_MIDCMD_DATA9_BASE_IDX                                                             0
#define mmSDMA0_RLC1_MIDCMD_DATA10                                                                     0x01d2
#define mmSDMA0_RLC1_MIDCMD_DATA10_BASE_IDX                                                            0
#define mmSDMA0_RLC1_MIDCMD_CNTL                                                                       0x01d3
#define mmSDMA0_RLC1_MIDCMD_CNTL_BASE_IDX                                                              0
#define mmSDMA0_RLC2_RB_CNTL                                                                           0x01e0
#define mmSDMA0_RLC2_RB_CNTL_BASE_IDX                                                                  0
#define mmSDMA0_RLC2_RB_BASE                                                                           0x01e1
#define mmSDMA0_RLC2_RB_BASE_BASE_IDX                                                                  0
#define mmSDMA0_RLC2_RB_BASE_HI                                                                        0x01e2
#define mmSDMA0_RLC2_RB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA0_RLC2_RB_RPTR                                                                           0x01e3
#define mmSDMA0_RLC2_RB_RPTR_BASE_IDX                                                                  0
#define mmSDMA0_RLC2_RB_RPTR_HI                                                                        0x01e4
#define mmSDMA0_RLC2_RB_RPTR_HI_BASE_IDX                                                               0
#define mmSDMA0_RLC2_RB_WPTR                                                                           0x01e5
#define mmSDMA0_RLC2_RB_WPTR_BASE_IDX                                                                  0
#define mmSDMA0_RLC2_RB_WPTR_HI                                                                        0x01e6
#define mmSDMA0_RLC2_RB_WPTR_HI_BASE_IDX                                                               0
#define mmSDMA0_RLC2_RB_WPTR_POLL_CNTL                                                                 0x01e7
#define mmSDMA0_RLC2_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define mmSDMA0_RLC2_RB_RPTR_ADDR_HI                                                                   0x01e8
#define mmSDMA0_RLC2_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define mmSDMA0_RLC2_RB_RPTR_ADDR_LO                                                                   0x01e9
#define mmSDMA0_RLC2_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define mmSDMA0_RLC2_IB_CNTL                                                                           0x01ea
#define mmSDMA0_RLC2_IB_CNTL_BASE_IDX                                                                  0
#define mmSDMA0_RLC2_IB_RPTR                                                                           0x01eb
#define mmSDMA0_RLC2_IB_RPTR_BASE_IDX                                                                  0
#define mmSDMA0_RLC2_IB_OFFSET                                                                         0x01ec
#define mmSDMA0_RLC2_IB_OFFSET_BASE_IDX                                                                0
#define mmSDMA0_RLC2_IB_BASE_LO                                                                        0x01ed
#define mmSDMA0_RLC2_IB_BASE_LO_BASE_IDX                                                               0
#define mmSDMA0_RLC2_IB_BASE_HI                                                                        0x01ee
#define mmSDMA0_RLC2_IB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA0_RLC2_IB_SIZE                                                                           0x01ef
#define mmSDMA0_RLC2_IB_SIZE_BASE_IDX                                                                  0
#define mmSDMA0_RLC2_SKIP_CNTL                                                                         0x01f0
#define mmSDMA0_RLC2_SKIP_CNTL_BASE_IDX                                                                0
#define mmSDMA0_RLC2_CONTEXT_STATUS                                                                    0x01f1
#define mmSDMA0_RLC2_CONTEXT_STATUS_BASE_IDX                                                           0
#define mmSDMA0_RLC2_DOORBELL                                                                          0x01f2
#define mmSDMA0_RLC2_DOORBELL_BASE_IDX                                                                 0
#define mmSDMA0_RLC2_STATUS                                                                            0x0208
#define mmSDMA0_RLC2_STATUS_BASE_IDX                                                                   0
#define mmSDMA0_RLC2_DOORBELL_LOG                                                                      0x0209
#define mmSDMA0_RLC2_DOORBELL_LOG_BASE_IDX                                                             0
#define mmSDMA0_RLC2_WATERMARK                                                                         0x020a
#define mmSDMA0_RLC2_WATERMARK_BASE_IDX                                                                0
#define mmSDMA0_RLC2_DOORBELL_OFFSET                                                                   0x020b
#define mmSDMA0_RLC2_DOORBELL_OFFSET_BASE_IDX                                                          0
#define mmSDMA0_RLC2_CSA_ADDR_LO                                                                       0x020c
#define mmSDMA0_RLC2_CSA_ADDR_LO_BASE_IDX                                                              0
#define mmSDMA0_RLC2_CSA_ADDR_HI                                                                       0x020d
#define mmSDMA0_RLC2_CSA_ADDR_HI_BASE_IDX                                                              0
#define mmSDMA0_RLC2_IB_SUB_REMAIN                                                                     0x020f
#define mmSDMA0_RLC2_IB_SUB_REMAIN_BASE_IDX                                                            0
#define mmSDMA0_RLC2_PREEMPT                                                                           0x0210
#define mmSDMA0_RLC2_PREEMPT_BASE_IDX                                                                  0
#define mmSDMA0_RLC2_DUMMY_REG                                                                         0x0211
#define mmSDMA0_RLC2_DUMMY_REG_BASE_IDX                                                                0
#define mmSDMA0_RLC2_RB_WPTR_POLL_ADDR_HI                                                              0x0212
#define mmSDMA0_RLC2_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define mmSDMA0_RLC2_RB_WPTR_POLL_ADDR_LO                                                              0x0213
#define mmSDMA0_RLC2_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define mmSDMA0_RLC2_RB_AQL_CNTL                                                                       0x0214
#define mmSDMA0_RLC2_RB_AQL_CNTL_BASE_IDX                                                              0
#define mmSDMA0_RLC2_MINOR_PTR_UPDATE                                                                  0x0215
#define mmSDMA0_RLC2_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define mmSDMA0_RLC2_MIDCMD_DATA0                                                                      0x0220
#define mmSDMA0_RLC2_MIDCMD_DATA0_BASE_IDX                                                             0
#define mmSDMA0_RLC2_MIDCMD_DATA1                                                                      0x0221
#define mmSDMA0_RLC2_MIDCMD_DATA1_BASE_IDX                                                             0
#define mmSDMA0_RLC2_MIDCMD_DATA2                                                                      0x0222
#define mmSDMA0_RLC2_MIDCMD_DATA2_BASE_IDX                                                             0
#define mmSDMA0_RLC2_MIDCMD_DATA3                                                                      0x0223
#define mmSDMA0_RLC2_MIDCMD_DATA3_BASE_IDX                                                             0
#define mmSDMA0_RLC2_MIDCMD_DATA4                                                                      0x0224
#define mmSDMA0_RLC2_MIDCMD_DATA4_BASE_IDX                                                             0
#define mmSDMA0_RLC2_MIDCMD_DATA5                                                                      0x0225
#define mmSDMA0_RLC2_MIDCMD_DATA5_BASE_IDX                                                             0
#define mmSDMA0_RLC2_MIDCMD_DATA6                                                                      0x0226
#define mmSDMA0_RLC2_MIDCMD_DATA6_BASE_IDX                                                             0
#define mmSDMA0_RLC2_MIDCMD_DATA7                                                                      0x0227
#define mmSDMA0_RLC2_MIDCMD_DATA7_BASE_IDX                                                             0
#define mmSDMA0_RLC2_MIDCMD_DATA8                                                                      0x0228
#define mmSDMA0_RLC2_MIDCMD_DATA8_BASE_IDX                                                             0
#define mmSDMA0_RLC2_MIDCMD_DATA9                                                                      0x0229
#define mmSDMA0_RLC2_MIDCMD_DATA9_BASE_IDX                                                             0
#define mmSDMA0_RLC2_MIDCMD_DATA10                                                                     0x022a
#define mmSDMA0_RLC2_MIDCMD_DATA10_BASE_IDX                                                            0
#define mmSDMA0_RLC2_MIDCMD_CNTL                                                                       0x022b
#define mmSDMA0_RLC2_MIDCMD_CNTL_BASE_IDX                                                              0
#define mmSDMA0_RLC3_RB_CNTL                                                                           0x0238
#define mmSDMA0_RLC3_RB_CNTL_BASE_IDX                                                                  0
#define mmSDMA0_RLC3_RB_BASE                                                                           0x0239
#define mmSDMA0_RLC3_RB_BASE_BASE_IDX                                                                  0
#define mmSDMA0_RLC3_RB_BASE_HI                                                                        0x023a
#define mmSDMA0_RLC3_RB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA0_RLC3_RB_RPTR                                                                           0x023b
#define mmSDMA0_RLC3_RB_RPTR_BASE_IDX                                                                  0
#define mmSDMA0_RLC3_RB_RPTR_HI                                                                        0x023c
#define mmSDMA0_RLC3_RB_RPTR_HI_BASE_IDX                                                               0
#define mmSDMA0_RLC3_RB_WPTR                                                                           0x023d
#define mmSDMA0_RLC3_RB_WPTR_BASE_IDX                                                                  0
#define mmSDMA0_RLC3_RB_WPTR_HI                                                                        0x023e
#define mmSDMA0_RLC3_RB_WPTR_HI_BASE_IDX                                                               0
#define mmSDMA0_RLC3_RB_WPTR_POLL_CNTL                                                                 0x023f
#define mmSDMA0_RLC3_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define mmSDMA0_RLC3_RB_RPTR_ADDR_HI                                                                   0x0240
#define mmSDMA0_RLC3_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define mmSDMA0_RLC3_RB_RPTR_ADDR_LO                                                                   0x0241
#define mmSDMA0_RLC3_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define mmSDMA0_RLC3_IB_CNTL                                                                           0x0242
#define mmSDMA0_RLC3_IB_CNTL_BASE_IDX                                                                  0
#define mmSDMA0_RLC3_IB_RPTR                                                                           0x0243
#define mmSDMA0_RLC3_IB_RPTR_BASE_IDX                                                                  0
#define mmSDMA0_RLC3_IB_OFFSET                                                                         0x0244
#define mmSDMA0_RLC3_IB_OFFSET_BASE_IDX                                                                0
#define mmSDMA0_RLC3_IB_BASE_LO                                                                        0x0245
#define mmSDMA0_RLC3_IB_BASE_LO_BASE_IDX                                                               0
#define mmSDMA0_RLC3_IB_BASE_HI                                                                        0x0246
#define mmSDMA0_RLC3_IB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA0_RLC3_IB_SIZE                                                                           0x0247
#define mmSDMA0_RLC3_IB_SIZE_BASE_IDX                                                                  0
#define mmSDMA0_RLC3_SKIP_CNTL                                                                         0x0248
#define mmSDMA0_RLC3_SKIP_CNTL_BASE_IDX                                                                0
#define mmSDMA0_RLC3_CONTEXT_STATUS                                                                    0x0249
#define mmSDMA0_RLC3_CONTEXT_STATUS_BASE_IDX                                                           0
#define mmSDMA0_RLC3_DOORBELL                                                                          0x024a
#define mmSDMA0_RLC3_DOORBELL_BASE_IDX                                                                 0
#define mmSDMA0_RLC3_STATUS                                                                            0x0260
#define mmSDMA0_RLC3_STATUS_BASE_IDX                                                                   0
#define mmSDMA0_RLC3_DOORBELL_LOG                                                                      0x0261
#define mmSDMA0_RLC3_DOORBELL_LOG_BASE_IDX                                                             0
#define mmSDMA0_RLC3_WATERMARK                                                                         0x0262
#define mmSDMA0_RLC3_WATERMARK_BASE_IDX                                                                0
#define mmSDMA0_RLC3_DOORBELL_OFFSET                                                                   0x0263
#define mmSDMA0_RLC3_DOORBELL_OFFSET_BASE_IDX                                                          0
#define mmSDMA0_RLC3_CSA_ADDR_LO                                                                       0x0264
#define mmSDMA0_RLC3_CSA_ADDR_LO_BASE_IDX                                                              0
#define mmSDMA0_RLC3_CSA_ADDR_HI                                                                       0x0265
#define mmSDMA0_RLC3_CSA_ADDR_HI_BASE_IDX                                                              0
#define mmSDMA0_RLC3_IB_SUB_REMAIN                                                                     0x0267
#define mmSDMA0_RLC3_IB_SUB_REMAIN_BASE_IDX                                                            0
#define mmSDMA0_RLC3_PREEMPT                                                                           0x0268
#define mmSDMA0_RLC3_PREEMPT_BASE_IDX                                                                  0
#define mmSDMA0_RLC3_DUMMY_REG                                                                         0x0269
#define mmSDMA0_RLC3_DUMMY_REG_BASE_IDX                                                                0
#define mmSDMA0_RLC3_RB_WPTR_POLL_ADDR_HI                                                              0x026a
#define mmSDMA0_RLC3_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define mmSDMA0_RLC3_RB_WPTR_POLL_ADDR_LO                                                              0x026b
#define mmSDMA0_RLC3_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define mmSDMA0_RLC3_RB_AQL_CNTL                                                                       0x026c
#define mmSDMA0_RLC3_RB_AQL_CNTL_BASE_IDX                                                              0
#define mmSDMA0_RLC3_MINOR_PTR_UPDATE                                                                  0x026d
#define mmSDMA0_RLC3_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define mmSDMA0_RLC3_MIDCMD_DATA0                                                                      0x0278
#define mmSDMA0_RLC3_MIDCMD_DATA0_BASE_IDX                                                             0
#define mmSDMA0_RLC3_MIDCMD_DATA1                                                                      0x0279
#define mmSDMA0_RLC3_MIDCMD_DATA1_BASE_IDX                                                             0
#define mmSDMA0_RLC3_MIDCMD_DATA2                                                                      0x027a
#define mmSDMA0_RLC3_MIDCMD_DATA2_BASE_IDX                                                             0
#define mmSDMA0_RLC3_MIDCMD_DATA3                                                                      0x027b
#define mmSDMA0_RLC3_MIDCMD_DATA3_BASE_IDX                                                             0
#define mmSDMA0_RLC3_MIDCMD_DATA4                                                                      0x027c
#define mmSDMA0_RLC3_MIDCMD_DATA4_BASE_IDX                                                             0
#define mmSDMA0_RLC3_MIDCMD_DATA5                                                                      0x027d
#define mmSDMA0_RLC3_MIDCMD_DATA5_BASE_IDX                                                             0
#define mmSDMA0_RLC3_MIDCMD_DATA6                                                                      0x027e
#define mmSDMA0_RLC3_MIDCMD_DATA6_BASE_IDX                                                             0
#define mmSDMA0_RLC3_MIDCMD_DATA7                                                                      0x027f
#define mmSDMA0_RLC3_MIDCMD_DATA7_BASE_IDX                                                             0
#define mmSDMA0_RLC3_MIDCMD_DATA8                                                                      0x0280
#define mmSDMA0_RLC3_MIDCMD_DATA8_BASE_IDX                                                             0
#define mmSDMA0_RLC3_MIDCMD_DATA9                                                                      0x0281
#define mmSDMA0_RLC3_MIDCMD_DATA9_BASE_IDX                                                             0
#define mmSDMA0_RLC3_MIDCMD_DATA10                                                                     0x0282
#define mmSDMA0_RLC3_MIDCMD_DATA10_BASE_IDX                                                            0
#define mmSDMA0_RLC3_MIDCMD_CNTL                                                                       0x0283
#define mmSDMA0_RLC3_MIDCMD_CNTL_BASE_IDX                                                              0
#define mmSDMA0_RLC4_RB_CNTL                                                                           0x0290
#define mmSDMA0_RLC4_RB_CNTL_BASE_IDX                                                                  0
#define mmSDMA0_RLC4_RB_BASE                                                                           0x0291
#define mmSDMA0_RLC4_RB_BASE_BASE_IDX                                                                  0
#define mmSDMA0_RLC4_RB_BASE_HI                                                                        0x0292
#define mmSDMA0_RLC4_RB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA0_RLC4_RB_RPTR                                                                           0x0293
#define mmSDMA0_RLC4_RB_RPTR_BASE_IDX                                                                  0
#define mmSDMA0_RLC4_RB_RPTR_HI                                                                        0x0294
#define mmSDMA0_RLC4_RB_RPTR_HI_BASE_IDX                                                               0
#define mmSDMA0_RLC4_RB_WPTR                                                                           0x0295
#define mmSDMA0_RLC4_RB_WPTR_BASE_IDX                                                                  0
#define mmSDMA0_RLC4_RB_WPTR_HI                                                                        0x0296
#define mmSDMA0_RLC4_RB_WPTR_HI_BASE_IDX                                                               0
#define mmSDMA0_RLC4_RB_WPTR_POLL_CNTL                                                                 0x0297
#define mmSDMA0_RLC4_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define mmSDMA0_RLC4_RB_RPTR_ADDR_HI                                                                   0x0298
#define mmSDMA0_RLC4_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define mmSDMA0_RLC4_RB_RPTR_ADDR_LO                                                                   0x0299
#define mmSDMA0_RLC4_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define mmSDMA0_RLC4_IB_CNTL                                                                           0x029a
#define mmSDMA0_RLC4_IB_CNTL_BASE_IDX                                                                  0
#define mmSDMA0_RLC4_IB_RPTR                                                                           0x029b
#define mmSDMA0_RLC4_IB_RPTR_BASE_IDX                                                                  0
#define mmSDMA0_RLC4_IB_OFFSET                                                                         0x029c
#define mmSDMA0_RLC4_IB_OFFSET_BASE_IDX                                                                0
#define mmSDMA0_RLC4_IB_BASE_LO                                                                        0x029d
#define mmSDMA0_RLC4_IB_BASE_LO_BASE_IDX                                                               0
#define mmSDMA0_RLC4_IB_BASE_HI                                                                        0x029e
#define mmSDMA0_RLC4_IB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA0_RLC4_IB_SIZE                                                                           0x029f
#define mmSDMA0_RLC4_IB_SIZE_BASE_IDX                                                                  0
#define mmSDMA0_RLC4_SKIP_CNTL                                                                         0x02a0
#define mmSDMA0_RLC4_SKIP_CNTL_BASE_IDX                                                                0
#define mmSDMA0_RLC4_CONTEXT_STATUS                                                                    0x02a1
#define mmSDMA0_RLC4_CONTEXT_STATUS_BASE_IDX                                                           0
#define mmSDMA0_RLC4_DOORBELL                                                                          0x02a2
#define mmSDMA0_RLC4_DOORBELL_BASE_IDX                                                                 0
#define mmSDMA0_RLC4_STATUS                                                                            0x02b8
#define mmSDMA0_RLC4_STATUS_BASE_IDX                                                                   0
#define mmSDMA0_RLC4_DOORBELL_LOG                                                                      0x02b9
#define mmSDMA0_RLC4_DOORBELL_LOG_BASE_IDX                                                             0
#define mmSDMA0_RLC4_WATERMARK                                                                         0x02ba
#define mmSDMA0_RLC4_WATERMARK_BASE_IDX                                                                0
#define mmSDMA0_RLC4_DOORBELL_OFFSET                                                                   0x02bb
#define mmSDMA0_RLC4_DOORBELL_OFFSET_BASE_IDX                                                          0
#define mmSDMA0_RLC4_CSA_ADDR_LO                                                                       0x02bc
#define mmSDMA0_RLC4_CSA_ADDR_LO_BASE_IDX                                                              0
#define mmSDMA0_RLC4_CSA_ADDR_HI                                                                       0x02bd
#define mmSDMA0_RLC4_CSA_ADDR_HI_BASE_IDX                                                              0
#define mmSDMA0_RLC4_IB_SUB_REMAIN                                                                     0x02bf
#define mmSDMA0_RLC4_IB_SUB_REMAIN_BASE_IDX                                                            0
#define mmSDMA0_RLC4_PREEMPT                                                                           0x02c0
#define mmSDMA0_RLC4_PREEMPT_BASE_IDX                                                                  0
#define mmSDMA0_RLC4_DUMMY_REG                                                                         0x02c1
#define mmSDMA0_RLC4_DUMMY_REG_BASE_IDX                                                                0
#define mmSDMA0_RLC4_RB_WPTR_POLL_ADDR_HI                                                              0x02c2
#define mmSDMA0_RLC4_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define mmSDMA0_RLC4_RB_WPTR_POLL_ADDR_LO                                                              0x02c3
#define mmSDMA0_RLC4_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define mmSDMA0_RLC4_RB_AQL_CNTL                                                                       0x02c4
#define mmSDMA0_RLC4_RB_AQL_CNTL_BASE_IDX                                                              0
#define mmSDMA0_RLC4_MINOR_PTR_UPDATE                                                                  0x02c5
#define mmSDMA0_RLC4_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define mmSDMA0_RLC4_MIDCMD_DATA0                                                                      0x02d0
#define mmSDMA0_RLC4_MIDCMD_DATA0_BASE_IDX                                                             0
#define mmSDMA0_RLC4_MIDCMD_DATA1                                                                      0x02d1
#define mmSDMA0_RLC4_MIDCMD_DATA1_BASE_IDX                                                             0
#define mmSDMA0_RLC4_MIDCMD_DATA2                                                                      0x02d2
#define mmSDMA0_RLC4_MIDCMD_DATA2_BASE_IDX                                                             0
#define mmSDMA0_RLC4_MIDCMD_DATA3                                                                      0x02d3
#define mmSDMA0_RLC4_MIDCMD_DATA3_BASE_IDX                                                             0
#define mmSDMA0_RLC4_MIDCMD_DATA4                                                                      0x02d4
#define mmSDMA0_RLC4_MIDCMD_DATA4_BASE_IDX                                                             0
#define mmSDMA0_RLC4_MIDCMD_DATA5                                                                      0x02d5
#define mmSDMA0_RLC4_MIDCMD_DATA5_BASE_IDX                                                             0
#define mmSDMA0_RLC4_MIDCMD_DATA6                                                                      0x02d6
#define mmSDMA0_RLC4_MIDCMD_DATA6_BASE_IDX                                                             0
#define mmSDMA0_RLC4_MIDCMD_DATA7                                                                      0x02d7
#define mmSDMA0_RLC4_MIDCMD_DATA7_BASE_IDX                                                             0
#define mmSDMA0_RLC4_MIDCMD_DATA8                                                                      0x02d8
#define mmSDMA0_RLC4_MIDCMD_DATA8_BASE_IDX                                                             0
#define mmSDMA0_RLC4_MIDCMD_DATA9                                                                      0x02d9
#define mmSDMA0_RLC4_MIDCMD_DATA9_BASE_IDX                                                             0
#define mmSDMA0_RLC4_MIDCMD_DATA10                                                                     0x02da
#define mmSDMA0_RLC4_MIDCMD_DATA10_BASE_IDX                                                            0
#define mmSDMA0_RLC4_MIDCMD_CNTL                                                                       0x02db
#define mmSDMA0_RLC4_MIDCMD_CNTL_BASE_IDX                                                              0
#define mmSDMA0_RLC5_RB_CNTL                                                                           0x02e8
#define mmSDMA0_RLC5_RB_CNTL_BASE_IDX                                                                  0
#define mmSDMA0_RLC5_RB_BASE                                                                           0x02e9
#define mmSDMA0_RLC5_RB_BASE_BASE_IDX                                                                  0
#define mmSDMA0_RLC5_RB_BASE_HI                                                                        0x02ea
#define mmSDMA0_RLC5_RB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA0_RLC5_RB_RPTR                                                                           0x02eb
#define mmSDMA0_RLC5_RB_RPTR_BASE_IDX                                                                  0
#define mmSDMA0_RLC5_RB_RPTR_HI                                                                        0x02ec
#define mmSDMA0_RLC5_RB_RPTR_HI_BASE_IDX                                                               0
#define mmSDMA0_RLC5_RB_WPTR                                                                           0x02ed
#define mmSDMA0_RLC5_RB_WPTR_BASE_IDX                                                                  0
#define mmSDMA0_RLC5_RB_WPTR_HI                                                                        0x02ee
#define mmSDMA0_RLC5_RB_WPTR_HI_BASE_IDX                                                               0
#define mmSDMA0_RLC5_RB_WPTR_POLL_CNTL                                                                 0x02ef
#define mmSDMA0_RLC5_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define mmSDMA0_RLC5_RB_RPTR_ADDR_HI                                                                   0x02f0
#define mmSDMA0_RLC5_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define mmSDMA0_RLC5_RB_RPTR_ADDR_LO                                                                   0x02f1
#define mmSDMA0_RLC5_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define mmSDMA0_RLC5_IB_CNTL                                                                           0x02f2
#define mmSDMA0_RLC5_IB_CNTL_BASE_IDX                                                                  0
#define mmSDMA0_RLC5_IB_RPTR                                                                           0x02f3
#define mmSDMA0_RLC5_IB_RPTR_BASE_IDX                                                                  0
#define mmSDMA0_RLC5_IB_OFFSET                                                                         0x02f4
#define mmSDMA0_RLC5_IB_OFFSET_BASE_IDX                                                                0
#define mmSDMA0_RLC5_IB_BASE_LO                                                                        0x02f5
#define mmSDMA0_RLC5_IB_BASE_LO_BASE_IDX                                                               0
#define mmSDMA0_RLC5_IB_BASE_HI                                                                        0x02f6
#define mmSDMA0_RLC5_IB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA0_RLC5_IB_SIZE                                                                           0x02f7
#define mmSDMA0_RLC5_IB_SIZE_BASE_IDX                                                                  0
#define mmSDMA0_RLC5_SKIP_CNTL                                                                         0x02f8
#define mmSDMA0_RLC5_SKIP_CNTL_BASE_IDX                                                                0
#define mmSDMA0_RLC5_CONTEXT_STATUS                                                                    0x02f9
#define mmSDMA0_RLC5_CONTEXT_STATUS_BASE_IDX                                                           0
#define mmSDMA0_RLC5_DOORBELL                                                                          0x02fa
#define mmSDMA0_RLC5_DOORBELL_BASE_IDX                                                                 0
#define mmSDMA0_RLC5_STATUS                                                                            0x0310
#define mmSDMA0_RLC5_STATUS_BASE_IDX                                                                   0
#define mmSDMA0_RLC5_DOORBELL_LOG                                                                      0x0311
#define mmSDMA0_RLC5_DOORBELL_LOG_BASE_IDX                                                             0
#define mmSDMA0_RLC5_WATERMARK                                                                         0x0312
#define mmSDMA0_RLC5_WATERMARK_BASE_IDX                                                                0
#define mmSDMA0_RLC5_DOORBELL_OFFSET                                                                   0x0313
#define mmSDMA0_RLC5_DOORBELL_OFFSET_BASE_IDX                                                          0
#define mmSDMA0_RLC5_CSA_ADDR_LO                                                                       0x0314
#define mmSDMA0_RLC5_CSA_ADDR_LO_BASE_IDX                                                              0
#define mmSDMA0_RLC5_CSA_ADDR_HI                                                                       0x0315
#define mmSDMA0_RLC5_CSA_ADDR_HI_BASE_IDX                                                              0
#define mmSDMA0_RLC5_IB_SUB_REMAIN                                                                     0x0317
#define mmSDMA0_RLC5_IB_SUB_REMAIN_BASE_IDX                                                            0
#define mmSDMA0_RLC5_PREEMPT                                                                           0x0318
#define mmSDMA0_RLC5_PREEMPT_BASE_IDX                                                                  0
#define mmSDMA0_RLC5_DUMMY_REG                                                                         0x0319
#define mmSDMA0_RLC5_DUMMY_REG_BASE_IDX                                                                0
#define mmSDMA0_RLC5_RB_WPTR_POLL_ADDR_HI                                                              0x031a
#define mmSDMA0_RLC5_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define mmSDMA0_RLC5_RB_WPTR_POLL_ADDR_LO                                                              0x031b
#define mmSDMA0_RLC5_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define mmSDMA0_RLC5_RB_AQL_CNTL                                                                       0x031c
#define mmSDMA0_RLC5_RB_AQL_CNTL_BASE_IDX                                                              0
#define mmSDMA0_RLC5_MINOR_PTR_UPDATE                                                                  0x031d
#define mmSDMA0_RLC5_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define mmSDMA0_RLC5_MIDCMD_DATA0                                                                      0x0328
#define mmSDMA0_RLC5_MIDCMD_DATA0_BASE_IDX                                                             0
#define mmSDMA0_RLC5_MIDCMD_DATA1                                                                      0x0329
#define mmSDMA0_RLC5_MIDCMD_DATA1_BASE_IDX                                                             0
#define mmSDMA0_RLC5_MIDCMD_DATA2                                                                      0x032a
#define mmSDMA0_RLC5_MIDCMD_DATA2_BASE_IDX                                                             0
#define mmSDMA0_RLC5_MIDCMD_DATA3                                                                      0x032b
#define mmSDMA0_RLC5_MIDCMD_DATA3_BASE_IDX                                                             0
#define mmSDMA0_RLC5_MIDCMD_DATA4                                                                      0x032c
#define mmSDMA0_RLC5_MIDCMD_DATA4_BASE_IDX                                                             0
#define mmSDMA0_RLC5_MIDCMD_DATA5                                                                      0x032d
#define mmSDMA0_RLC5_MIDCMD_DATA5_BASE_IDX                                                             0
#define mmSDMA0_RLC5_MIDCMD_DATA6                                                                      0x032e
#define mmSDMA0_RLC5_MIDCMD_DATA6_BASE_IDX                                                             0
#define mmSDMA0_RLC5_MIDCMD_DATA7                                                                      0x032f
#define mmSDMA0_RLC5_MIDCMD_DATA7_BASE_IDX                                                             0
#define mmSDMA0_RLC5_MIDCMD_DATA8                                                                      0x0330
#define mmSDMA0_RLC5_MIDCMD_DATA8_BASE_IDX                                                             0
#define mmSDMA0_RLC5_MIDCMD_DATA9                                                                      0x0331
#define mmSDMA0_RLC5_MIDCMD_DATA9_BASE_IDX                                                             0
#define mmSDMA0_RLC5_MIDCMD_DATA10                                                                     0x0332
#define mmSDMA0_RLC5_MIDCMD_DATA10_BASE_IDX                                                            0
#define mmSDMA0_RLC5_MIDCMD_CNTL                                                                       0x0333
#define mmSDMA0_RLC5_MIDCMD_CNTL_BASE_IDX                                                              0
#define mmSDMA0_RLC6_RB_CNTL                                                                           0x0340
#define mmSDMA0_RLC6_RB_CNTL_BASE_IDX                                                                  0
#define mmSDMA0_RLC6_RB_BASE                                                                           0x0341
#define mmSDMA0_RLC6_RB_BASE_BASE_IDX                                                                  0
#define mmSDMA0_RLC6_RB_BASE_HI                                                                        0x0342
#define mmSDMA0_RLC6_RB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA0_RLC6_RB_RPTR                                                                           0x0343
#define mmSDMA0_RLC6_RB_RPTR_BASE_IDX                                                                  0
#define mmSDMA0_RLC6_RB_RPTR_HI                                                                        0x0344
#define mmSDMA0_RLC6_RB_RPTR_HI_BASE_IDX                                                               0
#define mmSDMA0_RLC6_RB_WPTR                                                                           0x0345
#define mmSDMA0_RLC6_RB_WPTR_BASE_IDX                                                                  0
#define mmSDMA0_RLC6_RB_WPTR_HI                                                                        0x0346
#define mmSDMA0_RLC6_RB_WPTR_HI_BASE_IDX                                                               0
#define mmSDMA0_RLC6_RB_WPTR_POLL_CNTL                                                                 0x0347
#define mmSDMA0_RLC6_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define mmSDMA0_RLC6_RB_RPTR_ADDR_HI                                                                   0x0348
#define mmSDMA0_RLC6_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define mmSDMA0_RLC6_RB_RPTR_ADDR_LO                                                                   0x0349
#define mmSDMA0_RLC6_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define mmSDMA0_RLC6_IB_CNTL                                                                           0x034a
#define mmSDMA0_RLC6_IB_CNTL_BASE_IDX                                                                  0
#define mmSDMA0_RLC6_IB_RPTR                                                                           0x034b
#define mmSDMA0_RLC6_IB_RPTR_BASE_IDX                                                                  0
#define mmSDMA0_RLC6_IB_OFFSET                                                                         0x034c
#define mmSDMA0_RLC6_IB_OFFSET_BASE_IDX                                                                0
#define mmSDMA0_RLC6_IB_BASE_LO                                                                        0x034d
#define mmSDMA0_RLC6_IB_BASE_LO_BASE_IDX                                                               0
#define mmSDMA0_RLC6_IB_BASE_HI                                                                        0x034e
#define mmSDMA0_RLC6_IB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA0_RLC6_IB_SIZE                                                                           0x034f
#define mmSDMA0_RLC6_IB_SIZE_BASE_IDX                                                                  0
#define mmSDMA0_RLC6_SKIP_CNTL                                                                         0x0350
#define mmSDMA0_RLC6_SKIP_CNTL_BASE_IDX                                                                0
#define mmSDMA0_RLC6_CONTEXT_STATUS                                                                    0x0351
#define mmSDMA0_RLC6_CONTEXT_STATUS_BASE_IDX                                                           0
#define mmSDMA0_RLC6_DOORBELL                                                                          0x0352
#define mmSDMA0_RLC6_DOORBELL_BASE_IDX                                                                 0
#define mmSDMA0_RLC6_STATUS                                                                            0x0368
#define mmSDMA0_RLC6_STATUS_BASE_IDX                                                                   0
#define mmSDMA0_RLC6_DOORBELL_LOG                                                                      0x0369
#define mmSDMA0_RLC6_DOORBELL_LOG_BASE_IDX                                                             0
#define mmSDMA0_RLC6_WATERMARK                                                                         0x036a
#define mmSDMA0_RLC6_WATERMARK_BASE_IDX                                                                0
#define mmSDMA0_RLC6_DOORBELL_OFFSET                                                                   0x036b
#define mmSDMA0_RLC6_DOORBELL_OFFSET_BASE_IDX                                                          0
#define mmSDMA0_RLC6_CSA_ADDR_LO                                                                       0x036c
#define mmSDMA0_RLC6_CSA_ADDR_LO_BASE_IDX                                                              0
#define mmSDMA0_RLC6_CSA_ADDR_HI                                                                       0x036d
#define mmSDMA0_RLC6_CSA_ADDR_HI_BASE_IDX                                                              0
#define mmSDMA0_RLC6_IB_SUB_REMAIN                                                                     0x036f
#define mmSDMA0_RLC6_IB_SUB_REMAIN_BASE_IDX                                                            0
#define mmSDMA0_RLC6_PREEMPT                                                                           0x0370
#define mmSDMA0_RLC6_PREEMPT_BASE_IDX                                                                  0
#define mmSDMA0_RLC6_DUMMY_REG                                                                         0x0371
#define mmSDMA0_RLC6_DUMMY_REG_BASE_IDX                                                                0
#define mmSDMA0_RLC6_RB_WPTR_POLL_ADDR_HI                                                              0x0372
#define mmSDMA0_RLC6_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define mmSDMA0_RLC6_RB_WPTR_POLL_ADDR_LO                                                              0x0373
#define mmSDMA0_RLC6_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define mmSDMA0_RLC6_RB_AQL_CNTL                                                                       0x0374
#define mmSDMA0_RLC6_RB_AQL_CNTL_BASE_IDX                                                              0
#define mmSDMA0_RLC6_MINOR_PTR_UPDATE                                                                  0x0375
#define mmSDMA0_RLC6_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define mmSDMA0_RLC6_MIDCMD_DATA0                                                                      0x0380
#define mmSDMA0_RLC6_MIDCMD_DATA0_BASE_IDX                                                             0
#define mmSDMA0_RLC6_MIDCMD_DATA1                                                                      0x0381
#define mmSDMA0_RLC6_MIDCMD_DATA1_BASE_IDX                                                             0
#define mmSDMA0_RLC6_MIDCMD_DATA2                                                                      0x0382
#define mmSDMA0_RLC6_MIDCMD_DATA2_BASE_IDX                                                             0
#define mmSDMA0_RLC6_MIDCMD_DATA3                                                                      0x0383
#define mmSDMA0_RLC6_MIDCMD_DATA3_BASE_IDX                                                             0
#define mmSDMA0_RLC6_MIDCMD_DATA4                                                                      0x0384
#define mmSDMA0_RLC6_MIDCMD_DATA4_BASE_IDX                                                             0
#define mmSDMA0_RLC6_MIDCMD_DATA5                                                                      0x0385
#define mmSDMA0_RLC6_MIDCMD_DATA5_BASE_IDX                                                             0
#define mmSDMA0_RLC6_MIDCMD_DATA6                                                                      0x0386
#define mmSDMA0_RLC6_MIDCMD_DATA6_BASE_IDX                                                             0
#define mmSDMA0_RLC6_MIDCMD_DATA7                                                                      0x0387
#define mmSDMA0_RLC6_MIDCMD_DATA7_BASE_IDX                                                             0
#define mmSDMA0_RLC6_MIDCMD_DATA8                                                                      0x0388
#define mmSDMA0_RLC6_MIDCMD_DATA8_BASE_IDX                                                             0
#define mmSDMA0_RLC6_MIDCMD_DATA9                                                                      0x0389
#define mmSDMA0_RLC6_MIDCMD_DATA9_BASE_IDX                                                             0
#define mmSDMA0_RLC6_MIDCMD_DATA10                                                                     0x038a
#define mmSDMA0_RLC6_MIDCMD_DATA10_BASE_IDX                                                            0
#define mmSDMA0_RLC6_MIDCMD_CNTL                                                                       0x038b
#define mmSDMA0_RLC6_MIDCMD_CNTL_BASE_IDX                                                              0
#define mmSDMA0_RLC7_RB_CNTL                                                                           0x0398
#define mmSDMA0_RLC7_RB_CNTL_BASE_IDX                                                                  0
#define mmSDMA0_RLC7_RB_BASE                                                                           0x0399
#define mmSDMA0_RLC7_RB_BASE_BASE_IDX                                                                  0
#define mmSDMA0_RLC7_RB_BASE_HI                                                                        0x039a
#define mmSDMA0_RLC7_RB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA0_RLC7_RB_RPTR                                                                           0x039b
#define mmSDMA0_RLC7_RB_RPTR_BASE_IDX                                                                  0
#define mmSDMA0_RLC7_RB_RPTR_HI                                                                        0x039c
#define mmSDMA0_RLC7_RB_RPTR_HI_BASE_IDX                                                               0
#define mmSDMA0_RLC7_RB_WPTR                                                                           0x039d
#define mmSDMA0_RLC7_RB_WPTR_BASE_IDX                                                                  0
#define mmSDMA0_RLC7_RB_WPTR_HI                                                                        0x039e
#define mmSDMA0_RLC7_RB_WPTR_HI_BASE_IDX                                                               0
#define mmSDMA0_RLC7_RB_WPTR_POLL_CNTL                                                                 0x039f
#define mmSDMA0_RLC7_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define mmSDMA0_RLC7_RB_RPTR_ADDR_HI                                                                   0x03a0
#define mmSDMA0_RLC7_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define mmSDMA0_RLC7_RB_RPTR_ADDR_LO                                                                   0x03a1
#define mmSDMA0_RLC7_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define mmSDMA0_RLC7_IB_CNTL                                                                           0x03a2
#define mmSDMA0_RLC7_IB_CNTL_BASE_IDX                                                                  0
#define mmSDMA0_RLC7_IB_RPTR                                                                           0x03a3
#define mmSDMA0_RLC7_IB_RPTR_BASE_IDX                                                                  0
#define mmSDMA0_RLC7_IB_OFFSET                                                                         0x03a4
#define mmSDMA0_RLC7_IB_OFFSET_BASE_IDX                                                                0
#define mmSDMA0_RLC7_IB_BASE_LO                                                                        0x03a5
#define mmSDMA0_RLC7_IB_BASE_LO_BASE_IDX                                                               0
#define mmSDMA0_RLC7_IB_BASE_HI                                                                        0x03a6
#define mmSDMA0_RLC7_IB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA0_RLC7_IB_SIZE                                                                           0x03a7
#define mmSDMA0_RLC7_IB_SIZE_BASE_IDX                                                                  0
#define mmSDMA0_RLC7_SKIP_CNTL                                                                         0x03a8
#define mmSDMA0_RLC7_SKIP_CNTL_BASE_IDX                                                                0
#define mmSDMA0_RLC7_CONTEXT_STATUS                                                                    0x03a9
#define mmSDMA0_RLC7_CONTEXT_STATUS_BASE_IDX                                                           0
#define mmSDMA0_RLC7_DOORBELL                                                                          0x03aa
#define mmSDMA0_RLC7_DOORBELL_BASE_IDX                                                                 0
#define mmSDMA0_RLC7_STATUS                                                                            0x03c0
#define mmSDMA0_RLC7_STATUS_BASE_IDX                                                                   0
#define mmSDMA0_RLC7_DOORBELL_LOG                                                                      0x03c1
#define mmSDMA0_RLC7_DOORBELL_LOG_BASE_IDX                                                             0
#define mmSDMA0_RLC7_WATERMARK                                                                         0x03c2
#define mmSDMA0_RLC7_WATERMARK_BASE_IDX                                                                0
#define mmSDMA0_RLC7_DOORBELL_OFFSET                                                                   0x03c3
#define mmSDMA0_RLC7_DOORBELL_OFFSET_BASE_IDX                                                          0
#define mmSDMA0_RLC7_CSA_ADDR_LO                                                                       0x03c4
#define mmSDMA0_RLC7_CSA_ADDR_LO_BASE_IDX                                                              0
#define mmSDMA0_RLC7_CSA_ADDR_HI                                                                       0x03c5
#define mmSDMA0_RLC7_CSA_ADDR_HI_BASE_IDX                                                              0
#define mmSDMA0_RLC7_IB_SUB_REMAIN                                                                     0x03c7
#define mmSDMA0_RLC7_IB_SUB_REMAIN_BASE_IDX                                                            0
#define mmSDMA0_RLC7_PREEMPT                                                                           0x03c8
#define mmSDMA0_RLC7_PREEMPT_BASE_IDX                                                                  0
#define mmSDMA0_RLC7_DUMMY_REG                                                                         0x03c9
#define mmSDMA0_RLC7_DUMMY_REG_BASE_IDX                                                                0
#define mmSDMA0_RLC7_RB_WPTR_POLL_ADDR_HI                                                              0x03ca
#define mmSDMA0_RLC7_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define mmSDMA0_RLC7_RB_WPTR_POLL_ADDR_LO                                                              0x03cb
#define mmSDMA0_RLC7_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define mmSDMA0_RLC7_RB_AQL_CNTL                                                                       0x03cc
#define mmSDMA0_RLC7_RB_AQL_CNTL_BASE_IDX                                                              0
#define mmSDMA0_RLC7_MINOR_PTR_UPDATE                                                                  0x03cd
#define mmSDMA0_RLC7_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define mmSDMA0_RLC7_MIDCMD_DATA0                                                                      0x03d8
#define mmSDMA0_RLC7_MIDCMD_DATA0_BASE_IDX                                                             0
#define mmSDMA0_RLC7_MIDCMD_DATA1                                                                      0x03d9
#define mmSDMA0_RLC7_MIDCMD_DATA1_BASE_IDX                                                             0
#define mmSDMA0_RLC7_MIDCMD_DATA2                                                                      0x03da
#define mmSDMA0_RLC7_MIDCMD_DATA2_BASE_IDX                                                             0
#define mmSDMA0_RLC7_MIDCMD_DATA3                                                                      0x03db
#define mmSDMA0_RLC7_MIDCMD_DATA3_BASE_IDX                                                             0
#define mmSDMA0_RLC7_MIDCMD_DATA4                                                                      0x03dc
#define mmSDMA0_RLC7_MIDCMD_DATA4_BASE_IDX                                                             0
#define mmSDMA0_RLC7_MIDCMD_DATA5                                                                      0x03dd
#define mmSDMA0_RLC7_MIDCMD_DATA5_BASE_IDX                                                             0
#define mmSDMA0_RLC7_MIDCMD_DATA6                                                                      0x03de
#define mmSDMA0_RLC7_MIDCMD_DATA6_BASE_IDX                                                             0
#define mmSDMA0_RLC7_MIDCMD_DATA7                                                                      0x03df
#define mmSDMA0_RLC7_MIDCMD_DATA7_BASE_IDX                                                             0
#define mmSDMA0_RLC7_MIDCMD_DATA8                                                                      0x03e0
#define mmSDMA0_RLC7_MIDCMD_DATA8_BASE_IDX                                                             0
#define mmSDMA0_RLC7_MIDCMD_DATA9                                                                      0x03e1
#define mmSDMA0_RLC7_MIDCMD_DATA9_BASE_IDX                                                             0
#define mmSDMA0_RLC7_MIDCMD_DATA10                                                                     0x03e2
#define mmSDMA0_RLC7_MIDCMD_DATA10_BASE_IDX                                                            0
#define mmSDMA0_RLC7_MIDCMD_CNTL                                                                       0x03e3
#define mmSDMA0_RLC7_MIDCMD_CNTL_BASE_IDX                                                              0


// addressBlock: gc_sdma1_sdma1dec
// base address: 0x6180
#define mmSDMA1_DEC_START                                                                              0x0600
#define mmSDMA1_DEC_START_BASE_IDX                                                                     0
#define mmSDMA1_GLOBAL_TIMESTAMP_LO                                                                    0x060f
#define mmSDMA1_GLOBAL_TIMESTAMP_LO_BASE_IDX                                                           0
#define mmSDMA1_GLOBAL_TIMESTAMP_HI                                                                    0x0610
#define mmSDMA1_GLOBAL_TIMESTAMP_HI_BASE_IDX                                                           0
#define mmSDMA1_PG_CNTL                                                                                0x0616
#define mmSDMA1_PG_CNTL_BASE_IDX                                                                       0
#define mmSDMA1_PG_CTX_LO                                                                              0x0617
#define mmSDMA1_PG_CTX_LO_BASE_IDX                                                                     0
#define mmSDMA1_PG_CTX_HI                                                                              0x0618
#define mmSDMA1_PG_CTX_HI_BASE_IDX                                                                     0
#define mmSDMA1_PG_CTX_CNTL                                                                            0x0619
#define mmSDMA1_PG_CTX_CNTL_BASE_IDX                                                                   0
#define mmSDMA1_POWER_CNTL                                                                             0x061a
#define mmSDMA1_POWER_CNTL_BASE_IDX                                                                    0
#define mmSDMA1_CLK_CTRL                                                                               0x061b
#define mmSDMA1_CLK_CTRL_BASE_IDX                                                                      0
#define mmSDMA1_CNTL                                                                                   0x061c
#define mmSDMA1_CNTL_BASE_IDX                                                                          0
#define mmSDMA1_CHICKEN_BITS                                                                           0x061d
#define mmSDMA1_CHICKEN_BITS_BASE_IDX                                                                  0
#define mmSDMA1_GB_ADDR_CONFIG                                                                         0x061e
#define mmSDMA1_GB_ADDR_CONFIG_BASE_IDX                                                                0
#define mmSDMA1_GB_ADDR_CONFIG_READ                                                                    0x061f
#define mmSDMA1_GB_ADDR_CONFIG_READ_BASE_IDX                                                           0
#define mmSDMA1_RB_RPTR_FETCH_HI                                                                       0x0620
#define mmSDMA1_RB_RPTR_FETCH_HI_BASE_IDX                                                              0
#define mmSDMA1_SEM_WAIT_FAIL_TIMER_CNTL                                                               0x0621
#define mmSDMA1_SEM_WAIT_FAIL_TIMER_CNTL_BASE_IDX                                                      0
#define mmSDMA1_RB_RPTR_FETCH                                                                          0x0622
#define mmSDMA1_RB_RPTR_FETCH_BASE_IDX                                                                 0
#define mmSDMA1_IB_OFFSET_FETCH                                                                        0x0623
#define mmSDMA1_IB_OFFSET_FETCH_BASE_IDX                                                               0
#define mmSDMA1_PROGRAM                                                                                0x0624
#define mmSDMA1_PROGRAM_BASE_IDX                                                                       0
#define mmSDMA1_STATUS_REG                                                                             0x0625
#define mmSDMA1_STATUS_REG_BASE_IDX                                                                    0
#define mmSDMA1_STATUS1_REG                                                                            0x0626
#define mmSDMA1_STATUS1_REG_BASE_IDX                                                                   0
#define mmSDMA1_RD_BURST_CNTL                                                                          0x0627
#define mmSDMA1_RD_BURST_CNTL_BASE_IDX                                                                 0
#define mmSDMA1_HBM_PAGE_CONFIG                                                                        0x0628
#define mmSDMA1_HBM_PAGE_CONFIG_BASE_IDX                                                               0
#define mmSDMA1_UCODE_CHECKSUM                                                                         0x0629
#define mmSDMA1_UCODE_CHECKSUM_BASE_IDX                                                                0
#define mmSDMA1_F32_CNTL                                                                               0x062a
#define mmSDMA1_F32_CNTL_BASE_IDX                                                                      0
#define mmSDMA1_FREEZE                                                                                 0x062b
#define mmSDMA1_FREEZE_BASE_IDX                                                                        0
#define mmSDMA1_PHASE0_QUANTUM                                                                         0x062c
#define mmSDMA1_PHASE0_QUANTUM_BASE_IDX                                                                0
#define mmSDMA1_PHASE1_QUANTUM                                                                         0x062d
#define mmSDMA1_PHASE1_QUANTUM_BASE_IDX                                                                0
#define mmSDMA1_EDC_CONFIG                                                                             0x0632
#define mmSDMA1_EDC_CONFIG_BASE_IDX                                                                    0
#define mmSDMA1_BA_THRESHOLD                                                                           0x0633
#define mmSDMA1_BA_THRESHOLD_BASE_IDX                                                                  0
#define mmSDMA1_ID                                                                                     0x0634
#define mmSDMA1_ID_BASE_IDX                                                                            0
#define mmSDMA1_VERSION                                                                                0x0635
#define mmSDMA1_VERSION_BASE_IDX                                                                       0
#define mmSDMA1_EDC_COUNTER                                                                            0x0636
#define mmSDMA1_EDC_COUNTER_BASE_IDX                                                                   0
#define mmSDMA1_EDC_COUNTER_CLEAR                                                                      0x0637
#define mmSDMA1_EDC_COUNTER_CLEAR_BASE_IDX                                                             0
#define mmSDMA1_STATUS2_REG                                                                            0x0638
#define mmSDMA1_STATUS2_REG_BASE_IDX                                                                   0
#define mmSDMA1_ATOMIC_CNTL                                                                            0x0639
#define mmSDMA1_ATOMIC_CNTL_BASE_IDX                                                                   0
#define mmSDMA1_ATOMIC_PREOP_LO                                                                        0x063a
#define mmSDMA1_ATOMIC_PREOP_LO_BASE_IDX                                                               0
#define mmSDMA1_ATOMIC_PREOP_HI                                                                        0x063b
#define mmSDMA1_ATOMIC_PREOP_HI_BASE_IDX                                                               0
#define mmSDMA1_UTCL1_CNTL                                                                             0x063c
#define mmSDMA1_UTCL1_CNTL_BASE_IDX                                                                    0
#define mmSDMA1_UTCL1_WATERMK                                                                          0x063d
#define mmSDMA1_UTCL1_WATERMK_BASE_IDX                                                                 0
#define mmSDMA1_UTCL1_RD_STATUS                                                                        0x063e
#define mmSDMA1_UTCL1_RD_STATUS_BASE_IDX                                                               0
#define mmSDMA1_UTCL1_WR_STATUS                                                                        0x063f
#define mmSDMA1_UTCL1_WR_STATUS_BASE_IDX                                                               0
#define mmSDMA1_UTCL1_INV0                                                                             0x0640
#define mmSDMA1_UTCL1_INV0_BASE_IDX                                                                    0
#define mmSDMA1_UTCL1_INV1                                                                             0x0641
#define mmSDMA1_UTCL1_INV1_BASE_IDX                                                                    0
#define mmSDMA1_UTCL1_INV2                                                                             0x0642
#define mmSDMA1_UTCL1_INV2_BASE_IDX                                                                    0
#define mmSDMA1_UTCL1_RD_XNACK0                                                                        0x0643
#define mmSDMA1_UTCL1_RD_XNACK0_BASE_IDX                                                               0
#define mmSDMA1_UTCL1_RD_XNACK1                                                                        0x0644
#define mmSDMA1_UTCL1_RD_XNACK1_BASE_IDX                                                               0
#define mmSDMA1_UTCL1_WR_XNACK0                                                                        0x0645
#define mmSDMA1_UTCL1_WR_XNACK0_BASE_IDX                                                               0
#define mmSDMA1_UTCL1_WR_XNACK1                                                                        0x0646
#define mmSDMA1_UTCL1_WR_XNACK1_BASE_IDX                                                               0
#define mmSDMA1_UTCL1_TIMEOUT                                                                          0x0647
#define mmSDMA1_UTCL1_TIMEOUT_BASE_IDX                                                                 0
#define mmSDMA1_UTCL1_PAGE                                                                             0x0648
#define mmSDMA1_UTCL1_PAGE_BASE_IDX                                                                    0
#define mmSDMA1_RELAX_ORDERING_LUT                                                                     0x064a
#define mmSDMA1_RELAX_ORDERING_LUT_BASE_IDX                                                            0
#define mmSDMA1_CHICKEN_BITS_2                                                                         0x064b
#define mmSDMA1_CHICKEN_BITS_2_BASE_IDX                                                                0
#define mmSDMA1_STATUS3_REG                                                                            0x064c
#define mmSDMA1_STATUS3_REG_BASE_IDX                                                                   0
#define mmSDMA1_PHYSICAL_ADDR_LO                                                                       0x064d
#define mmSDMA1_PHYSICAL_ADDR_LO_BASE_IDX                                                              0
#define mmSDMA1_PHYSICAL_ADDR_HI                                                                       0x064e
#define mmSDMA1_PHYSICAL_ADDR_HI_BASE_IDX                                                              0
#define mmSDMA1_PHASE2_QUANTUM                                                                         0x064f
#define mmSDMA1_PHASE2_QUANTUM_BASE_IDX                                                                0
#define mmSDMA1_ERROR_LOG                                                                              0x0650
#define mmSDMA1_ERROR_LOG_BASE_IDX                                                                     0
#define mmSDMA1_PUB_DUMMY_REG0                                                                         0x0651
#define mmSDMA1_PUB_DUMMY_REG0_BASE_IDX                                                                0
#define mmSDMA1_PUB_DUMMY_REG1                                                                         0x0652
#define mmSDMA1_PUB_DUMMY_REG1_BASE_IDX                                                                0
#define mmSDMA1_PUB_DUMMY_REG2                                                                         0x0653
#define mmSDMA1_PUB_DUMMY_REG2_BASE_IDX                                                                0
#define mmSDMA1_PUB_DUMMY_REG3                                                                         0x0654
#define mmSDMA1_PUB_DUMMY_REG3_BASE_IDX                                                                0
#define mmSDMA1_F32_COUNTER                                                                            0x0655
#define mmSDMA1_F32_COUNTER_BASE_IDX                                                                   0
#define mmSDMA1_CRD_CNTL                                                                               0x065b
#define mmSDMA1_CRD_CNTL_BASE_IDX                                                                      0
#define mmSDMA1_AQL_STATUS                                                                             0x065f
#define mmSDMA1_AQL_STATUS_BASE_IDX                                                                    0
#define mmSDMA1_EA_DBIT_ADDR_DATA                                                                      0x0660
#define mmSDMA1_EA_DBIT_ADDR_DATA_BASE_IDX                                                             0
#define mmSDMA1_EA_DBIT_ADDR_INDEX                                                                     0x0661
#define mmSDMA1_EA_DBIT_ADDR_INDEX_BASE_IDX                                                            0
#define mmSDMA1_TLBI_GCR_CNTL                                                                          0x0662
#define mmSDMA1_TLBI_GCR_CNTL_BASE_IDX                                                                 0
#define mmSDMA1_TILING_CONFIG                                                                          0x0663
#define mmSDMA1_TILING_CONFIG_BASE_IDX                                                                 0
#define mmSDMA1_INT_STATUS                                                                             0x0670
#define mmSDMA1_INT_STATUS_BASE_IDX                                                                    0
#define mmSDMA1_HOLE_ADDR_LO                                                                           0x0672
#define mmSDMA1_HOLE_ADDR_LO_BASE_IDX                                                                  0
#define mmSDMA1_HOLE_ADDR_HI                                                                           0x0673
#define mmSDMA1_HOLE_ADDR_HI_BASE_IDX                                                                  0
#define mmSDMA1_CLOCK_GATING_REG                                                                       0x0675
#define mmSDMA1_CLOCK_GATING_REG_BASE_IDX                                                              0
#define mmSDMA1_STATUS4_REG                                                                            0x0676
#define mmSDMA1_STATUS4_REG_BASE_IDX                                                                   0
#define mmSDMA1_SCRATCH_RAM_DATA                                                                       0x0677
#define mmSDMA1_SCRATCH_RAM_DATA_BASE_IDX                                                              0
#define mmSDMA1_SCRATCH_RAM_ADDR                                                                       0x0678
#define mmSDMA1_SCRATCH_RAM_ADDR_BASE_IDX                                                              0
#define mmSDMA1_TIMESTAMP_CNTL                                                                         0x0679
#define mmSDMA1_TIMESTAMP_CNTL_BASE_IDX                                                                0
#define mmSDMA1_STATUS5_REG                                                                            0x067a
#define mmSDMA1_STATUS5_REG_BASE_IDX                                                                   0
#define mmSDMA1_QUEUE_RESET_REQ                                                                        0x067b
#define mmSDMA1_QUEUE_RESET_REQ_BASE_IDX                                                               0
#define mmSDMA1_GFX_RB_CNTL                                                                            0x0680
#define mmSDMA1_GFX_RB_CNTL_BASE_IDX                                                                   0
#define mmSDMA1_GFX_RB_BASE                                                                            0x0681
#define mmSDMA1_GFX_RB_BASE_BASE_IDX                                                                   0
#define mmSDMA1_GFX_RB_BASE_HI                                                                         0x0682
#define mmSDMA1_GFX_RB_BASE_HI_BASE_IDX                                                                0
#define mmSDMA1_GFX_RB_RPTR                                                                            0x0683
#define mmSDMA1_GFX_RB_RPTR_BASE_IDX                                                                   0
#define mmSDMA1_GFX_RB_RPTR_HI                                                                         0x0684
#define mmSDMA1_GFX_RB_RPTR_HI_BASE_IDX                                                                0
#define mmSDMA1_GFX_RB_WPTR                                                                            0x0685
#define mmSDMA1_GFX_RB_WPTR_BASE_IDX                                                                   0
#define mmSDMA1_GFX_RB_WPTR_HI                                                                         0x0686
#define mmSDMA1_GFX_RB_WPTR_HI_BASE_IDX                                                                0
#define mmSDMA1_GFX_RB_WPTR_POLL_CNTL                                                                  0x0687
#define mmSDMA1_GFX_RB_WPTR_POLL_CNTL_BASE_IDX                                                         0
#define mmSDMA1_GFX_RB_RPTR_ADDR_HI                                                                    0x0688
#define mmSDMA1_GFX_RB_RPTR_ADDR_HI_BASE_IDX                                                           0
#define mmSDMA1_GFX_RB_RPTR_ADDR_LO                                                                    0x0689
#define mmSDMA1_GFX_RB_RPTR_ADDR_LO_BASE_IDX                                                           0
#define mmSDMA1_GFX_IB_CNTL                                                                            0x068a
#define mmSDMA1_GFX_IB_CNTL_BASE_IDX                                                                   0
#define mmSDMA1_GFX_IB_RPTR                                                                            0x068b
#define mmSDMA1_GFX_IB_RPTR_BASE_IDX                                                                   0
#define mmSDMA1_GFX_IB_OFFSET                                                                          0x068c
#define mmSDMA1_GFX_IB_OFFSET_BASE_IDX                                                                 0
#define mmSDMA1_GFX_IB_BASE_LO                                                                         0x068d
#define mmSDMA1_GFX_IB_BASE_LO_BASE_IDX                                                                0
#define mmSDMA1_GFX_IB_BASE_HI                                                                         0x068e
#define mmSDMA1_GFX_IB_BASE_HI_BASE_IDX                                                                0
#define mmSDMA1_GFX_IB_SIZE                                                                            0x068f
#define mmSDMA1_GFX_IB_SIZE_BASE_IDX                                                                   0
#define mmSDMA1_GFX_SKIP_CNTL                                                                          0x0690
#define mmSDMA1_GFX_SKIP_CNTL_BASE_IDX                                                                 0
#define mmSDMA1_GFX_CONTEXT_STATUS                                                                     0x0691
#define mmSDMA1_GFX_CONTEXT_STATUS_BASE_IDX                                                            0
#define mmSDMA1_GFX_DOORBELL                                                                           0x0692
#define mmSDMA1_GFX_DOORBELL_BASE_IDX                                                                  0
#define mmSDMA1_GFX_CONTEXT_CNTL                                                                       0x0693
#define mmSDMA1_GFX_CONTEXT_CNTL_BASE_IDX                                                              0
#define mmSDMA1_GFX_STATUS                                                                             0x06a8
#define mmSDMA1_GFX_STATUS_BASE_IDX                                                                    0
#define mmSDMA1_GFX_DOORBELL_LOG                                                                       0x06a9
#define mmSDMA1_GFX_DOORBELL_LOG_BASE_IDX                                                              0
#define mmSDMA1_GFX_WATERMARK                                                                          0x06aa
#define mmSDMA1_GFX_WATERMARK_BASE_IDX                                                                 0
#define mmSDMA1_GFX_DOORBELL_OFFSET                                                                    0x06ab
#define mmSDMA1_GFX_DOORBELL_OFFSET_BASE_IDX                                                           0
#define mmSDMA1_GFX_CSA_ADDR_LO                                                                        0x06ac
#define mmSDMA1_GFX_CSA_ADDR_LO_BASE_IDX                                                               0
#define mmSDMA1_GFX_CSA_ADDR_HI                                                                        0x06ad
#define mmSDMA1_GFX_CSA_ADDR_HI_BASE_IDX                                                               0
#define mmSDMA1_GFX_IB_SUB_REMAIN                                                                      0x06af
#define mmSDMA1_GFX_IB_SUB_REMAIN_BASE_IDX                                                             0
#define mmSDMA1_GFX_PREEMPT                                                                            0x06b0
#define mmSDMA1_GFX_PREEMPT_BASE_IDX                                                                   0
#define mmSDMA1_GFX_DUMMY_REG                                                                          0x06b1
#define mmSDMA1_GFX_DUMMY_REG_BASE_IDX                                                                 0
#define mmSDMA1_GFX_RB_WPTR_POLL_ADDR_HI                                                               0x06b2
#define mmSDMA1_GFX_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                      0
#define mmSDMA1_GFX_RB_WPTR_POLL_ADDR_LO                                                               0x06b3
#define mmSDMA1_GFX_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                      0
#define mmSDMA1_GFX_RB_AQL_CNTL                                                                        0x06b4
#define mmSDMA1_GFX_RB_AQL_CNTL_BASE_IDX                                                               0
#define mmSDMA1_GFX_MINOR_PTR_UPDATE                                                                   0x06b5
#define mmSDMA1_GFX_MINOR_PTR_UPDATE_BASE_IDX                                                          0
#define mmSDMA1_GFX_MIDCMD_DATA0                                                                       0x06c0
#define mmSDMA1_GFX_MIDCMD_DATA0_BASE_IDX                                                              0
#define mmSDMA1_GFX_MIDCMD_DATA1                                                                       0x06c1
#define mmSDMA1_GFX_MIDCMD_DATA1_BASE_IDX                                                              0
#define mmSDMA1_GFX_MIDCMD_DATA2                                                                       0x06c2
#define mmSDMA1_GFX_MIDCMD_DATA2_BASE_IDX                                                              0
#define mmSDMA1_GFX_MIDCMD_DATA3                                                                       0x06c3
#define mmSDMA1_GFX_MIDCMD_DATA3_BASE_IDX                                                              0
#define mmSDMA1_GFX_MIDCMD_DATA4                                                                       0x06c4
#define mmSDMA1_GFX_MIDCMD_DATA4_BASE_IDX                                                              0
#define mmSDMA1_GFX_MIDCMD_DATA5                                                                       0x06c5
#define mmSDMA1_GFX_MIDCMD_DATA5_BASE_IDX                                                              0
#define mmSDMA1_GFX_MIDCMD_DATA6                                                                       0x06c6
#define mmSDMA1_GFX_MIDCMD_DATA6_BASE_IDX                                                              0
#define mmSDMA1_GFX_MIDCMD_DATA7                                                                       0x06c7
#define mmSDMA1_GFX_MIDCMD_DATA7_BASE_IDX                                                              0
#define mmSDMA1_GFX_MIDCMD_DATA8                                                                       0x06c8
#define mmSDMA1_GFX_MIDCMD_DATA8_BASE_IDX                                                              0
#define mmSDMA1_GFX_MIDCMD_DATA9                                                                       0x06c9
#define mmSDMA1_GFX_MIDCMD_DATA9_BASE_IDX                                                              0
#define mmSDMA1_GFX_MIDCMD_DATA10                                                                      0x06ca
#define mmSDMA1_GFX_MIDCMD_DATA10_BASE_IDX                                                             0
#define mmSDMA1_GFX_MIDCMD_CNTL                                                                        0x06cb
#define mmSDMA1_GFX_MIDCMD_CNTL_BASE_IDX                                                               0
#define mmSDMA1_PAGE_RB_CNTL                                                                           0x06d8
#define mmSDMA1_PAGE_RB_CNTL_BASE_IDX                                                                  0
#define mmSDMA1_PAGE_RB_BASE                                                                           0x06d9
#define mmSDMA1_PAGE_RB_BASE_BASE_IDX                                                                  0
#define mmSDMA1_PAGE_RB_BASE_HI                                                                        0x06da
#define mmSDMA1_PAGE_RB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA1_PAGE_RB_RPTR                                                                           0x06db
#define mmSDMA1_PAGE_RB_RPTR_BASE_IDX                                                                  0
#define mmSDMA1_PAGE_RB_RPTR_HI                                                                        0x06dc
#define mmSDMA1_PAGE_RB_RPTR_HI_BASE_IDX                                                               0
#define mmSDMA1_PAGE_RB_WPTR                                                                           0x06dd
#define mmSDMA1_PAGE_RB_WPTR_BASE_IDX                                                                  0
#define mmSDMA1_PAGE_RB_WPTR_HI                                                                        0x06de
#define mmSDMA1_PAGE_RB_WPTR_HI_BASE_IDX                                                               0
#define mmSDMA1_PAGE_RB_WPTR_POLL_CNTL                                                                 0x06df
#define mmSDMA1_PAGE_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define mmSDMA1_PAGE_RB_RPTR_ADDR_HI                                                                   0x06e0
#define mmSDMA1_PAGE_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define mmSDMA1_PAGE_RB_RPTR_ADDR_LO                                                                   0x06e1
#define mmSDMA1_PAGE_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define mmSDMA1_PAGE_IB_CNTL                                                                           0x06e2
#define mmSDMA1_PAGE_IB_CNTL_BASE_IDX                                                                  0
#define mmSDMA1_PAGE_IB_RPTR                                                                           0x06e3
#define mmSDMA1_PAGE_IB_RPTR_BASE_IDX                                                                  0
#define mmSDMA1_PAGE_IB_OFFSET                                                                         0x06e4
#define mmSDMA1_PAGE_IB_OFFSET_BASE_IDX                                                                0
#define mmSDMA1_PAGE_IB_BASE_LO                                                                        0x06e5
#define mmSDMA1_PAGE_IB_BASE_LO_BASE_IDX                                                               0
#define mmSDMA1_PAGE_IB_BASE_HI                                                                        0x06e6
#define mmSDMA1_PAGE_IB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA1_PAGE_IB_SIZE                                                                           0x06e7
#define mmSDMA1_PAGE_IB_SIZE_BASE_IDX                                                                  0
#define mmSDMA1_PAGE_SKIP_CNTL                                                                         0x06e8
#define mmSDMA1_PAGE_SKIP_CNTL_BASE_IDX                                                                0
#define mmSDMA1_PAGE_CONTEXT_STATUS                                                                    0x06e9
#define mmSDMA1_PAGE_CONTEXT_STATUS_BASE_IDX                                                           0
#define mmSDMA1_PAGE_DOORBELL                                                                          0x06ea
#define mmSDMA1_PAGE_DOORBELL_BASE_IDX                                                                 0
#define mmSDMA1_PAGE_STATUS                                                                            0x0700
#define mmSDMA1_PAGE_STATUS_BASE_IDX                                                                   0
#define mmSDMA1_PAGE_DOORBELL_LOG                                                                      0x0701
#define mmSDMA1_PAGE_DOORBELL_LOG_BASE_IDX                                                             0
#define mmSDMA1_PAGE_WATERMARK                                                                         0x0702
#define mmSDMA1_PAGE_WATERMARK_BASE_IDX                                                                0
#define mmSDMA1_PAGE_DOORBELL_OFFSET                                                                   0x0703
#define mmSDMA1_PAGE_DOORBELL_OFFSET_BASE_IDX                                                          0
#define mmSDMA1_PAGE_CSA_ADDR_LO                                                                       0x0704
#define mmSDMA1_PAGE_CSA_ADDR_LO_BASE_IDX                                                              0
#define mmSDMA1_PAGE_CSA_ADDR_HI                                                                       0x0705
#define mmSDMA1_PAGE_CSA_ADDR_HI_BASE_IDX                                                              0
#define mmSDMA1_PAGE_IB_SUB_REMAIN                                                                     0x0707
#define mmSDMA1_PAGE_IB_SUB_REMAIN_BASE_IDX                                                            0
#define mmSDMA1_PAGE_PREEMPT                                                                           0x0708
#define mmSDMA1_PAGE_PREEMPT_BASE_IDX                                                                  0
#define mmSDMA1_PAGE_DUMMY_REG                                                                         0x0709
#define mmSDMA1_PAGE_DUMMY_REG_BASE_IDX                                                                0
#define mmSDMA1_PAGE_RB_WPTR_POLL_ADDR_HI                                                              0x070a
#define mmSDMA1_PAGE_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define mmSDMA1_PAGE_RB_WPTR_POLL_ADDR_LO                                                              0x070b
#define mmSDMA1_PAGE_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define mmSDMA1_PAGE_RB_AQL_CNTL                                                                       0x070c
#define mmSDMA1_PAGE_RB_AQL_CNTL_BASE_IDX                                                              0
#define mmSDMA1_PAGE_MINOR_PTR_UPDATE                                                                  0x070d
#define mmSDMA1_PAGE_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define mmSDMA1_PAGE_MIDCMD_DATA0                                                                      0x0718
#define mmSDMA1_PAGE_MIDCMD_DATA0_BASE_IDX                                                             0
#define mmSDMA1_PAGE_MIDCMD_DATA1                                                                      0x0719
#define mmSDMA1_PAGE_MIDCMD_DATA1_BASE_IDX                                                             0
#define mmSDMA1_PAGE_MIDCMD_DATA2                                                                      0x071a
#define mmSDMA1_PAGE_MIDCMD_DATA2_BASE_IDX                                                             0
#define mmSDMA1_PAGE_MIDCMD_DATA3                                                                      0x071b
#define mmSDMA1_PAGE_MIDCMD_DATA3_BASE_IDX                                                             0
#define mmSDMA1_PAGE_MIDCMD_DATA4                                                                      0x071c
#define mmSDMA1_PAGE_MIDCMD_DATA4_BASE_IDX                                                             0
#define mmSDMA1_PAGE_MIDCMD_DATA5                                                                      0x071d
#define mmSDMA1_PAGE_MIDCMD_DATA5_BASE_IDX                                                             0
#define mmSDMA1_PAGE_MIDCMD_DATA6                                                                      0x071e
#define mmSDMA1_PAGE_MIDCMD_DATA6_BASE_IDX                                                             0
#define mmSDMA1_PAGE_MIDCMD_DATA7                                                                      0x071f
#define mmSDMA1_PAGE_MIDCMD_DATA7_BASE_IDX                                                             0
#define mmSDMA1_PAGE_MIDCMD_DATA8                                                                      0x0720
#define mmSDMA1_PAGE_MIDCMD_DATA8_BASE_IDX                                                             0
#define mmSDMA1_PAGE_MIDCMD_DATA9                                                                      0x0721
#define mmSDMA1_PAGE_MIDCMD_DATA9_BASE_IDX                                                             0
#define mmSDMA1_PAGE_MIDCMD_DATA10                                                                     0x0722
#define mmSDMA1_PAGE_MIDCMD_DATA10_BASE_IDX                                                            0
#define mmSDMA1_PAGE_MIDCMD_CNTL                                                                       0x0723
#define mmSDMA1_PAGE_MIDCMD_CNTL_BASE_IDX                                                              0
#define mmSDMA1_RLC0_RB_CNTL                                                                           0x0730
#define mmSDMA1_RLC0_RB_CNTL_BASE_IDX                                                                  0
#define mmSDMA1_RLC0_RB_BASE                                                                           0x0731
#define mmSDMA1_RLC0_RB_BASE_BASE_IDX                                                                  0
#define mmSDMA1_RLC0_RB_BASE_HI                                                                        0x0732
#define mmSDMA1_RLC0_RB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA1_RLC0_RB_RPTR                                                                           0x0733
#define mmSDMA1_RLC0_RB_RPTR_BASE_IDX                                                                  0
#define mmSDMA1_RLC0_RB_RPTR_HI                                                                        0x0734
#define mmSDMA1_RLC0_RB_RPTR_HI_BASE_IDX                                                               0
#define mmSDMA1_RLC0_RB_WPTR                                                                           0x0735
#define mmSDMA1_RLC0_RB_WPTR_BASE_IDX                                                                  0
#define mmSDMA1_RLC0_RB_WPTR_HI                                                                        0x0736
#define mmSDMA1_RLC0_RB_WPTR_HI_BASE_IDX                                                               0
#define mmSDMA1_RLC0_RB_WPTR_POLL_CNTL                                                                 0x0737
#define mmSDMA1_RLC0_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define mmSDMA1_RLC0_RB_RPTR_ADDR_HI                                                                   0x0738
#define mmSDMA1_RLC0_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define mmSDMA1_RLC0_RB_RPTR_ADDR_LO                                                                   0x0739
#define mmSDMA1_RLC0_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define mmSDMA1_RLC0_IB_CNTL                                                                           0x073a
#define mmSDMA1_RLC0_IB_CNTL_BASE_IDX                                                                  0
#define mmSDMA1_RLC0_IB_RPTR                                                                           0x073b
#define mmSDMA1_RLC0_IB_RPTR_BASE_IDX                                                                  0
#define mmSDMA1_RLC0_IB_OFFSET                                                                         0x073c
#define mmSDMA1_RLC0_IB_OFFSET_BASE_IDX                                                                0
#define mmSDMA1_RLC0_IB_BASE_LO                                                                        0x073d
#define mmSDMA1_RLC0_IB_BASE_LO_BASE_IDX                                                               0
#define mmSDMA1_RLC0_IB_BASE_HI                                                                        0x073e
#define mmSDMA1_RLC0_IB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA1_RLC0_IB_SIZE                                                                           0x073f
#define mmSDMA1_RLC0_IB_SIZE_BASE_IDX                                                                  0
#define mmSDMA1_RLC0_SKIP_CNTL                                                                         0x0740
#define mmSDMA1_RLC0_SKIP_CNTL_BASE_IDX                                                                0
#define mmSDMA1_RLC0_CONTEXT_STATUS                                                                    0x0741
#define mmSDMA1_RLC0_CONTEXT_STATUS_BASE_IDX                                                           0
#define mmSDMA1_RLC0_DOORBELL                                                                          0x0742
#define mmSDMA1_RLC0_DOORBELL_BASE_IDX                                                                 0
#define mmSDMA1_RLC0_STATUS                                                                            0x0758
#define mmSDMA1_RLC0_STATUS_BASE_IDX                                                                   0
#define mmSDMA1_RLC0_DOORBELL_LOG                                                                      0x0759
#define mmSDMA1_RLC0_DOORBELL_LOG_BASE_IDX                                                             0
#define mmSDMA1_RLC0_WATERMARK                                                                         0x075a
#define mmSDMA1_RLC0_WATERMARK_BASE_IDX                                                                0
#define mmSDMA1_RLC0_DOORBELL_OFFSET                                                                   0x075b
#define mmSDMA1_RLC0_DOORBELL_OFFSET_BASE_IDX                                                          0
#define mmSDMA1_RLC0_CSA_ADDR_LO                                                                       0x075c
#define mmSDMA1_RLC0_CSA_ADDR_LO_BASE_IDX                                                              0
#define mmSDMA1_RLC0_CSA_ADDR_HI                                                                       0x075d
#define mmSDMA1_RLC0_CSA_ADDR_HI_BASE_IDX                                                              0
#define mmSDMA1_RLC0_IB_SUB_REMAIN                                                                     0x075f
#define mmSDMA1_RLC0_IB_SUB_REMAIN_BASE_IDX                                                            0
#define mmSDMA1_RLC0_PREEMPT                                                                           0x0760
#define mmSDMA1_RLC0_PREEMPT_BASE_IDX                                                                  0
#define mmSDMA1_RLC0_DUMMY_REG                                                                         0x0761
#define mmSDMA1_RLC0_DUMMY_REG_BASE_IDX                                                                0
#define mmSDMA1_RLC0_RB_WPTR_POLL_ADDR_HI                                                              0x0762
#define mmSDMA1_RLC0_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define mmSDMA1_RLC0_RB_WPTR_POLL_ADDR_LO                                                              0x0763
#define mmSDMA1_RLC0_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define mmSDMA1_RLC0_RB_AQL_CNTL                                                                       0x0764
#define mmSDMA1_RLC0_RB_AQL_CNTL_BASE_IDX                                                              0
#define mmSDMA1_RLC0_MINOR_PTR_UPDATE                                                                  0x0765
#define mmSDMA1_RLC0_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define mmSDMA1_RLC0_MIDCMD_DATA0                                                                      0x0770
#define mmSDMA1_RLC0_MIDCMD_DATA0_BASE_IDX                                                             0
#define mmSDMA1_RLC0_MIDCMD_DATA1                                                                      0x0771
#define mmSDMA1_RLC0_MIDCMD_DATA1_BASE_IDX                                                             0
#define mmSDMA1_RLC0_MIDCMD_DATA2                                                                      0x0772
#define mmSDMA1_RLC0_MIDCMD_DATA2_BASE_IDX                                                             0
#define mmSDMA1_RLC0_MIDCMD_DATA3                                                                      0x0773
#define mmSDMA1_RLC0_MIDCMD_DATA3_BASE_IDX                                                             0
#define mmSDMA1_RLC0_MIDCMD_DATA4                                                                      0x0774
#define mmSDMA1_RLC0_MIDCMD_DATA4_BASE_IDX                                                             0
#define mmSDMA1_RLC0_MIDCMD_DATA5                                                                      0x0775
#define mmSDMA1_RLC0_MIDCMD_DATA5_BASE_IDX                                                             0
#define mmSDMA1_RLC0_MIDCMD_DATA6                                                                      0x0776
#define mmSDMA1_RLC0_MIDCMD_DATA6_BASE_IDX                                                             0
#define mmSDMA1_RLC0_MIDCMD_DATA7                                                                      0x0777
#define mmSDMA1_RLC0_MIDCMD_DATA7_BASE_IDX                                                             0
#define mmSDMA1_RLC0_MIDCMD_DATA8                                                                      0x0778
#define mmSDMA1_RLC0_MIDCMD_DATA8_BASE_IDX                                                             0
#define mmSDMA1_RLC0_MIDCMD_DATA9                                                                      0x0779
#define mmSDMA1_RLC0_MIDCMD_DATA9_BASE_IDX                                                             0
#define mmSDMA1_RLC0_MIDCMD_DATA10                                                                     0x077a
#define mmSDMA1_RLC0_MIDCMD_DATA10_BASE_IDX                                                            0
#define mmSDMA1_RLC0_MIDCMD_CNTL                                                                       0x077b
#define mmSDMA1_RLC0_MIDCMD_CNTL_BASE_IDX                                                              0
#define mmSDMA1_RLC1_RB_CNTL                                                                           0x0788
#define mmSDMA1_RLC1_RB_CNTL_BASE_IDX                                                                  0
#define mmSDMA1_RLC1_RB_BASE                                                                           0x0789
#define mmSDMA1_RLC1_RB_BASE_BASE_IDX                                                                  0
#define mmSDMA1_RLC1_RB_BASE_HI                                                                        0x078a
#define mmSDMA1_RLC1_RB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA1_RLC1_RB_RPTR                                                                           0x078b
#define mmSDMA1_RLC1_RB_RPTR_BASE_IDX                                                                  0
#define mmSDMA1_RLC1_RB_RPTR_HI                                                                        0x078c
#define mmSDMA1_RLC1_RB_RPTR_HI_BASE_IDX                                                               0
#define mmSDMA1_RLC1_RB_WPTR                                                                           0x078d
#define mmSDMA1_RLC1_RB_WPTR_BASE_IDX                                                                  0
#define mmSDMA1_RLC1_RB_WPTR_HI                                                                        0x078e
#define mmSDMA1_RLC1_RB_WPTR_HI_BASE_IDX                                                               0
#define mmSDMA1_RLC1_RB_WPTR_POLL_CNTL                                                                 0x078f
#define mmSDMA1_RLC1_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define mmSDMA1_RLC1_RB_RPTR_ADDR_HI                                                                   0x0790
#define mmSDMA1_RLC1_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define mmSDMA1_RLC1_RB_RPTR_ADDR_LO                                                                   0x0791
#define mmSDMA1_RLC1_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define mmSDMA1_RLC1_IB_CNTL                                                                           0x0792
#define mmSDMA1_RLC1_IB_CNTL_BASE_IDX                                                                  0
#define mmSDMA1_RLC1_IB_RPTR                                                                           0x0793
#define mmSDMA1_RLC1_IB_RPTR_BASE_IDX                                                                  0
#define mmSDMA1_RLC1_IB_OFFSET                                                                         0x0794
#define mmSDMA1_RLC1_IB_OFFSET_BASE_IDX                                                                0
#define mmSDMA1_RLC1_IB_BASE_LO                                                                        0x0795
#define mmSDMA1_RLC1_IB_BASE_LO_BASE_IDX                                                               0
#define mmSDMA1_RLC1_IB_BASE_HI                                                                        0x0796
#define mmSDMA1_RLC1_IB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA1_RLC1_IB_SIZE                                                                           0x0797
#define mmSDMA1_RLC1_IB_SIZE_BASE_IDX                                                                  0
#define mmSDMA1_RLC1_SKIP_CNTL                                                                         0x0798
#define mmSDMA1_RLC1_SKIP_CNTL_BASE_IDX                                                                0
#define mmSDMA1_RLC1_CONTEXT_STATUS                                                                    0x0799
#define mmSDMA1_RLC1_CONTEXT_STATUS_BASE_IDX                                                           0
#define mmSDMA1_RLC1_DOORBELL                                                                          0x079a
#define mmSDMA1_RLC1_DOORBELL_BASE_IDX                                                                 0
#define mmSDMA1_RLC1_STATUS                                                                            0x07b0
#define mmSDMA1_RLC1_STATUS_BASE_IDX                                                                   0
#define mmSDMA1_RLC1_DOORBELL_LOG                                                                      0x07b1
#define mmSDMA1_RLC1_DOORBELL_LOG_BASE_IDX                                                             0
#define mmSDMA1_RLC1_WATERMARK                                                                         0x07b2
#define mmSDMA1_RLC1_WATERMARK_BASE_IDX                                                                0
#define mmSDMA1_RLC1_DOORBELL_OFFSET                                                                   0x07b3
#define mmSDMA1_RLC1_DOORBELL_OFFSET_BASE_IDX                                                          0
#define mmSDMA1_RLC1_CSA_ADDR_LO                                                                       0x07b4
#define mmSDMA1_RLC1_CSA_ADDR_LO_BASE_IDX                                                              0
#define mmSDMA1_RLC1_CSA_ADDR_HI                                                                       0x07b5
#define mmSDMA1_RLC1_CSA_ADDR_HI_BASE_IDX                                                              0
#define mmSDMA1_RLC1_IB_SUB_REMAIN                                                                     0x07b7
#define mmSDMA1_RLC1_IB_SUB_REMAIN_BASE_IDX                                                            0
#define mmSDMA1_RLC1_PREEMPT                                                                           0x07b8
#define mmSDMA1_RLC1_PREEMPT_BASE_IDX                                                                  0
#define mmSDMA1_RLC1_DUMMY_REG                                                                         0x07b9
#define mmSDMA1_RLC1_DUMMY_REG_BASE_IDX                                                                0
#define mmSDMA1_RLC1_RB_WPTR_POLL_ADDR_HI                                                              0x07ba
#define mmSDMA1_RLC1_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define mmSDMA1_RLC1_RB_WPTR_POLL_ADDR_LO                                                              0x07bb
#define mmSDMA1_RLC1_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define mmSDMA1_RLC1_RB_AQL_CNTL                                                                       0x07bc
#define mmSDMA1_RLC1_RB_AQL_CNTL_BASE_IDX                                                              0
#define mmSDMA1_RLC1_MINOR_PTR_UPDATE                                                                  0x07bd
#define mmSDMA1_RLC1_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define mmSDMA1_RLC1_MIDCMD_DATA0                                                                      0x07c8
#define mmSDMA1_RLC1_MIDCMD_DATA0_BASE_IDX                                                             0
#define mmSDMA1_RLC1_MIDCMD_DATA1                                                                      0x07c9
#define mmSDMA1_RLC1_MIDCMD_DATA1_BASE_IDX                                                             0
#define mmSDMA1_RLC1_MIDCMD_DATA2                                                                      0x07ca
#define mmSDMA1_RLC1_MIDCMD_DATA2_BASE_IDX                                                             0
#define mmSDMA1_RLC1_MIDCMD_DATA3                                                                      0x07cb
#define mmSDMA1_RLC1_MIDCMD_DATA3_BASE_IDX                                                             0
#define mmSDMA1_RLC1_MIDCMD_DATA4                                                                      0x07cc
#define mmSDMA1_RLC1_MIDCMD_DATA4_BASE_IDX                                                             0
#define mmSDMA1_RLC1_MIDCMD_DATA5                                                                      0x07cd
#define mmSDMA1_RLC1_MIDCMD_DATA5_BASE_IDX                                                             0
#define mmSDMA1_RLC1_MIDCMD_DATA6                                                                      0x07ce
#define mmSDMA1_RLC1_MIDCMD_DATA6_BASE_IDX                                                             0
#define mmSDMA1_RLC1_MIDCMD_DATA7                                                                      0x07cf
#define mmSDMA1_RLC1_MIDCMD_DATA7_BASE_IDX                                                             0
#define mmSDMA1_RLC1_MIDCMD_DATA8                                                                      0x07d0
#define mmSDMA1_RLC1_MIDCMD_DATA8_BASE_IDX                                                             0
#define mmSDMA1_RLC1_MIDCMD_DATA9                                                                      0x07d1
#define mmSDMA1_RLC1_MIDCMD_DATA9_BASE_IDX                                                             0
#define mmSDMA1_RLC1_MIDCMD_DATA10                                                                     0x07d2
#define mmSDMA1_RLC1_MIDCMD_DATA10_BASE_IDX                                                            0
#define mmSDMA1_RLC1_MIDCMD_CNTL                                                                       0x07d3
#define mmSDMA1_RLC1_MIDCMD_CNTL_BASE_IDX                                                              0
#define mmSDMA1_RLC2_RB_CNTL                                                                           0x07e0
#define mmSDMA1_RLC2_RB_CNTL_BASE_IDX                                                                  0
#define mmSDMA1_RLC2_RB_BASE                                                                           0x07e1
#define mmSDMA1_RLC2_RB_BASE_BASE_IDX                                                                  0
#define mmSDMA1_RLC2_RB_BASE_HI                                                                        0x07e2
#define mmSDMA1_RLC2_RB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA1_RLC2_RB_RPTR                                                                           0x07e3
#define mmSDMA1_RLC2_RB_RPTR_BASE_IDX                                                                  0
#define mmSDMA1_RLC2_RB_RPTR_HI                                                                        0x07e4
#define mmSDMA1_RLC2_RB_RPTR_HI_BASE_IDX                                                               0
#define mmSDMA1_RLC2_RB_WPTR                                                                           0x07e5
#define mmSDMA1_RLC2_RB_WPTR_BASE_IDX                                                                  0
#define mmSDMA1_RLC2_RB_WPTR_HI                                                                        0x07e6
#define mmSDMA1_RLC2_RB_WPTR_HI_BASE_IDX                                                               0
#define mmSDMA1_RLC2_RB_WPTR_POLL_CNTL                                                                 0x07e7
#define mmSDMA1_RLC2_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define mmSDMA1_RLC2_RB_RPTR_ADDR_HI                                                                   0x07e8
#define mmSDMA1_RLC2_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define mmSDMA1_RLC2_RB_RPTR_ADDR_LO                                                                   0x07e9
#define mmSDMA1_RLC2_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define mmSDMA1_RLC2_IB_CNTL                                                                           0x07ea
#define mmSDMA1_RLC2_IB_CNTL_BASE_IDX                                                                  0
#define mmSDMA1_RLC2_IB_RPTR                                                                           0x07eb
#define mmSDMA1_RLC2_IB_RPTR_BASE_IDX                                                                  0
#define mmSDMA1_RLC2_IB_OFFSET                                                                         0x07ec
#define mmSDMA1_RLC2_IB_OFFSET_BASE_IDX                                                                0
#define mmSDMA1_RLC2_IB_BASE_LO                                                                        0x07ed
#define mmSDMA1_RLC2_IB_BASE_LO_BASE_IDX                                                               0
#define mmSDMA1_RLC2_IB_BASE_HI                                                                        0x07ee
#define mmSDMA1_RLC2_IB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA1_RLC2_IB_SIZE                                                                           0x07ef
#define mmSDMA1_RLC2_IB_SIZE_BASE_IDX                                                                  0
#define mmSDMA1_RLC2_SKIP_CNTL                                                                         0x07f0
#define mmSDMA1_RLC2_SKIP_CNTL_BASE_IDX                                                                0
#define mmSDMA1_RLC2_CONTEXT_STATUS                                                                    0x07f1
#define mmSDMA1_RLC2_CONTEXT_STATUS_BASE_IDX                                                           0
#define mmSDMA1_RLC2_DOORBELL                                                                          0x07f2
#define mmSDMA1_RLC2_DOORBELL_BASE_IDX                                                                 0
#define mmSDMA1_RLC2_STATUS                                                                            0x0808
#define mmSDMA1_RLC2_STATUS_BASE_IDX                                                                   0
#define mmSDMA1_RLC2_DOORBELL_LOG                                                                      0x0809
#define mmSDMA1_RLC2_DOORBELL_LOG_BASE_IDX                                                             0
#define mmSDMA1_RLC2_WATERMARK                                                                         0x080a
#define mmSDMA1_RLC2_WATERMARK_BASE_IDX                                                                0
#define mmSDMA1_RLC2_DOORBELL_OFFSET                                                                   0x080b
#define mmSDMA1_RLC2_DOORBELL_OFFSET_BASE_IDX                                                          0
#define mmSDMA1_RLC2_CSA_ADDR_LO                                                                       0x080c
#define mmSDMA1_RLC2_CSA_ADDR_LO_BASE_IDX                                                              0
#define mmSDMA1_RLC2_CSA_ADDR_HI                                                                       0x080d
#define mmSDMA1_RLC2_CSA_ADDR_HI_BASE_IDX                                                              0
#define mmSDMA1_RLC2_IB_SUB_REMAIN                                                                     0x080f
#define mmSDMA1_RLC2_IB_SUB_REMAIN_BASE_IDX                                                            0
#define mmSDMA1_RLC2_PREEMPT                                                                           0x0810
#define mmSDMA1_RLC2_PREEMPT_BASE_IDX                                                                  0
#define mmSDMA1_RLC2_DUMMY_REG                                                                         0x0811
#define mmSDMA1_RLC2_DUMMY_REG_BASE_IDX                                                                0
#define mmSDMA1_RLC2_RB_WPTR_POLL_ADDR_HI                                                              0x0812
#define mmSDMA1_RLC2_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define mmSDMA1_RLC2_RB_WPTR_POLL_ADDR_LO                                                              0x0813
#define mmSDMA1_RLC2_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define mmSDMA1_RLC2_RB_AQL_CNTL                                                                       0x0814
#define mmSDMA1_RLC2_RB_AQL_CNTL_BASE_IDX                                                              0
#define mmSDMA1_RLC2_MINOR_PTR_UPDATE                                                                  0x0815
#define mmSDMA1_RLC2_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define mmSDMA1_RLC2_MIDCMD_DATA0                                                                      0x0820
#define mmSDMA1_RLC2_MIDCMD_DATA0_BASE_IDX                                                             0
#define mmSDMA1_RLC2_MIDCMD_DATA1                                                                      0x0821
#define mmSDMA1_RLC2_MIDCMD_DATA1_BASE_IDX                                                             0
#define mmSDMA1_RLC2_MIDCMD_DATA2                                                                      0x0822
#define mmSDMA1_RLC2_MIDCMD_DATA2_BASE_IDX                                                             0
#define mmSDMA1_RLC2_MIDCMD_DATA3                                                                      0x0823
#define mmSDMA1_RLC2_MIDCMD_DATA3_BASE_IDX                                                             0
#define mmSDMA1_RLC2_MIDCMD_DATA4                                                                      0x0824
#define mmSDMA1_RLC2_MIDCMD_DATA4_BASE_IDX                                                             0
#define mmSDMA1_RLC2_MIDCMD_DATA5                                                                      0x0825
#define mmSDMA1_RLC2_MIDCMD_DATA5_BASE_IDX                                                             0
#define mmSDMA1_RLC2_MIDCMD_DATA6                                                                      0x0826
#define mmSDMA1_RLC2_MIDCMD_DATA6_BASE_IDX                                                             0
#define mmSDMA1_RLC2_MIDCMD_DATA7                                                                      0x0827
#define mmSDMA1_RLC2_MIDCMD_DATA7_BASE_IDX                                                             0
#define mmSDMA1_RLC2_MIDCMD_DATA8                                                                      0x0828
#define mmSDMA1_RLC2_MIDCMD_DATA8_BASE_IDX                                                             0
#define mmSDMA1_RLC2_MIDCMD_DATA9                                                                      0x0829
#define mmSDMA1_RLC2_MIDCMD_DATA9_BASE_IDX                                                             0
#define mmSDMA1_RLC2_MIDCMD_DATA10                                                                     0x082a
#define mmSDMA1_RLC2_MIDCMD_DATA10_BASE_IDX                                                            0
#define mmSDMA1_RLC2_MIDCMD_CNTL                                                                       0x082b
#define mmSDMA1_RLC2_MIDCMD_CNTL_BASE_IDX                                                              0
#define mmSDMA1_RLC3_RB_CNTL                                                                           0x0838
#define mmSDMA1_RLC3_RB_CNTL_BASE_IDX                                                                  0
#define mmSDMA1_RLC3_RB_BASE                                                                           0x0839
#define mmSDMA1_RLC3_RB_BASE_BASE_IDX                                                                  0
#define mmSDMA1_RLC3_RB_BASE_HI                                                                        0x083a
#define mmSDMA1_RLC3_RB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA1_RLC3_RB_RPTR                                                                           0x083b
#define mmSDMA1_RLC3_RB_RPTR_BASE_IDX                                                                  0
#define mmSDMA1_RLC3_RB_RPTR_HI                                                                        0x083c
#define mmSDMA1_RLC3_RB_RPTR_HI_BASE_IDX                                                               0
#define mmSDMA1_RLC3_RB_WPTR                                                                           0x083d
#define mmSDMA1_RLC3_RB_WPTR_BASE_IDX                                                                  0
#define mmSDMA1_RLC3_RB_WPTR_HI                                                                        0x083e
#define mmSDMA1_RLC3_RB_WPTR_HI_BASE_IDX                                                               0
#define mmSDMA1_RLC3_RB_WPTR_POLL_CNTL                                                                 0x083f
#define mmSDMA1_RLC3_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define mmSDMA1_RLC3_RB_RPTR_ADDR_HI                                                                   0x0840
#define mmSDMA1_RLC3_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define mmSDMA1_RLC3_RB_RPTR_ADDR_LO                                                                   0x0841
#define mmSDMA1_RLC3_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define mmSDMA1_RLC3_IB_CNTL                                                                           0x0842
#define mmSDMA1_RLC3_IB_CNTL_BASE_IDX                                                                  0
#define mmSDMA1_RLC3_IB_RPTR                                                                           0x0843
#define mmSDMA1_RLC3_IB_RPTR_BASE_IDX                                                                  0
#define mmSDMA1_RLC3_IB_OFFSET                                                                         0x0844
#define mmSDMA1_RLC3_IB_OFFSET_BASE_IDX                                                                0
#define mmSDMA1_RLC3_IB_BASE_LO                                                                        0x0845
#define mmSDMA1_RLC3_IB_BASE_LO_BASE_IDX                                                               0
#define mmSDMA1_RLC3_IB_BASE_HI                                                                        0x0846
#define mmSDMA1_RLC3_IB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA1_RLC3_IB_SIZE                                                                           0x0847
#define mmSDMA1_RLC3_IB_SIZE_BASE_IDX                                                                  0
#define mmSDMA1_RLC3_SKIP_CNTL                                                                         0x0848
#define mmSDMA1_RLC3_SKIP_CNTL_BASE_IDX                                                                0
#define mmSDMA1_RLC3_CONTEXT_STATUS                                                                    0x0849
#define mmSDMA1_RLC3_CONTEXT_STATUS_BASE_IDX                                                           0
#define mmSDMA1_RLC3_DOORBELL                                                                          0x084a
#define mmSDMA1_RLC3_DOORBELL_BASE_IDX                                                                 0
#define mmSDMA1_RLC3_STATUS                                                                            0x0860
#define mmSDMA1_RLC3_STATUS_BASE_IDX                                                                   0
#define mmSDMA1_RLC3_DOORBELL_LOG                                                                      0x0861
#define mmSDMA1_RLC3_DOORBELL_LOG_BASE_IDX                                                             0
#define mmSDMA1_RLC3_WATERMARK                                                                         0x0862
#define mmSDMA1_RLC3_WATERMARK_BASE_IDX                                                                0
#define mmSDMA1_RLC3_DOORBELL_OFFSET                                                                   0x0863
#define mmSDMA1_RLC3_DOORBELL_OFFSET_BASE_IDX                                                          0
#define mmSDMA1_RLC3_CSA_ADDR_LO                                                                       0x0864
#define mmSDMA1_RLC3_CSA_ADDR_LO_BASE_IDX                                                              0
#define mmSDMA1_RLC3_CSA_ADDR_HI                                                                       0x0865
#define mmSDMA1_RLC3_CSA_ADDR_HI_BASE_IDX                                                              0
#define mmSDMA1_RLC3_IB_SUB_REMAIN                                                                     0x0867
#define mmSDMA1_RLC3_IB_SUB_REMAIN_BASE_IDX                                                            0
#define mmSDMA1_RLC3_PREEMPT                                                                           0x0868
#define mmSDMA1_RLC3_PREEMPT_BASE_IDX                                                                  0
#define mmSDMA1_RLC3_DUMMY_REG                                                                         0x0869
#define mmSDMA1_RLC3_DUMMY_REG_BASE_IDX                                                                0
#define mmSDMA1_RLC3_RB_WPTR_POLL_ADDR_HI                                                              0x086a
#define mmSDMA1_RLC3_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define mmSDMA1_RLC3_RB_WPTR_POLL_ADDR_LO                                                              0x086b
#define mmSDMA1_RLC3_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define mmSDMA1_RLC3_RB_AQL_CNTL                                                                       0x086c
#define mmSDMA1_RLC3_RB_AQL_CNTL_BASE_IDX                                                              0
#define mmSDMA1_RLC3_MINOR_PTR_UPDATE                                                                  0x086d
#define mmSDMA1_RLC3_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define mmSDMA1_RLC3_MIDCMD_DATA0                                                                      0x0878
#define mmSDMA1_RLC3_MIDCMD_DATA0_BASE_IDX                                                             0
#define mmSDMA1_RLC3_MIDCMD_DATA1                                                                      0x0879
#define mmSDMA1_RLC3_MIDCMD_DATA1_BASE_IDX                                                             0
#define mmSDMA1_RLC3_MIDCMD_DATA2                                                                      0x087a
#define mmSDMA1_RLC3_MIDCMD_DATA2_BASE_IDX                                                             0
#define mmSDMA1_RLC3_MIDCMD_DATA3                                                                      0x087b
#define mmSDMA1_RLC3_MIDCMD_DATA3_BASE_IDX                                                             0
#define mmSDMA1_RLC3_MIDCMD_DATA4                                                                      0x087c
#define mmSDMA1_RLC3_MIDCMD_DATA4_BASE_IDX                                                             0
#define mmSDMA1_RLC3_MIDCMD_DATA5                                                                      0x087d
#define mmSDMA1_RLC3_MIDCMD_DATA5_BASE_IDX                                                             0
#define mmSDMA1_RLC3_MIDCMD_DATA6                                                                      0x087e
#define mmSDMA1_RLC3_MIDCMD_DATA6_BASE_IDX                                                             0
#define mmSDMA1_RLC3_MIDCMD_DATA7                                                                      0x087f
#define mmSDMA1_RLC3_MIDCMD_DATA7_BASE_IDX                                                             0
#define mmSDMA1_RLC3_MIDCMD_DATA8                                                                      0x0880
#define mmSDMA1_RLC3_MIDCMD_DATA8_BASE_IDX                                                             0
#define mmSDMA1_RLC3_MIDCMD_DATA9                                                                      0x0881
#define mmSDMA1_RLC3_MIDCMD_DATA9_BASE_IDX                                                             0
#define mmSDMA1_RLC3_MIDCMD_DATA10                                                                     0x0882
#define mmSDMA1_RLC3_MIDCMD_DATA10_BASE_IDX                                                            0
#define mmSDMA1_RLC3_MIDCMD_CNTL                                                                       0x0883
#define mmSDMA1_RLC3_MIDCMD_CNTL_BASE_IDX                                                              0
#define mmSDMA1_RLC4_RB_CNTL                                                                           0x0890
#define mmSDMA1_RLC4_RB_CNTL_BASE_IDX                                                                  0
#define mmSDMA1_RLC4_RB_BASE                                                                           0x0891
#define mmSDMA1_RLC4_RB_BASE_BASE_IDX                                                                  0
#define mmSDMA1_RLC4_RB_BASE_HI                                                                        0x0892
#define mmSDMA1_RLC4_RB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA1_RLC4_RB_RPTR                                                                           0x0893
#define mmSDMA1_RLC4_RB_RPTR_BASE_IDX                                                                  0
#define mmSDMA1_RLC4_RB_RPTR_HI                                                                        0x0894
#define mmSDMA1_RLC4_RB_RPTR_HI_BASE_IDX                                                               0
#define mmSDMA1_RLC4_RB_WPTR                                                                           0x0895
#define mmSDMA1_RLC4_RB_WPTR_BASE_IDX                                                                  0
#define mmSDMA1_RLC4_RB_WPTR_HI                                                                        0x0896
#define mmSDMA1_RLC4_RB_WPTR_HI_BASE_IDX                                                               0
#define mmSDMA1_RLC4_RB_WPTR_POLL_CNTL                                                                 0x0897
#define mmSDMA1_RLC4_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define mmSDMA1_RLC4_RB_RPTR_ADDR_HI                                                                   0x0898
#define mmSDMA1_RLC4_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define mmSDMA1_RLC4_RB_RPTR_ADDR_LO                                                                   0x0899
#define mmSDMA1_RLC4_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define mmSDMA1_RLC4_IB_CNTL                                                                           0x089a
#define mmSDMA1_RLC4_IB_CNTL_BASE_IDX                                                                  0
#define mmSDMA1_RLC4_IB_RPTR                                                                           0x089b
#define mmSDMA1_RLC4_IB_RPTR_BASE_IDX                                                                  0
#define mmSDMA1_RLC4_IB_OFFSET                                                                         0x089c
#define mmSDMA1_RLC4_IB_OFFSET_BASE_IDX                                                                0
#define mmSDMA1_RLC4_IB_BASE_LO                                                                        0x089d
#define mmSDMA1_RLC4_IB_BASE_LO_BASE_IDX                                                               0
#define mmSDMA1_RLC4_IB_BASE_HI                                                                        0x089e
#define mmSDMA1_RLC4_IB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA1_RLC4_IB_SIZE                                                                           0x089f
#define mmSDMA1_RLC4_IB_SIZE_BASE_IDX                                                                  0
#define mmSDMA1_RLC4_SKIP_CNTL                                                                         0x08a0
#define mmSDMA1_RLC4_SKIP_CNTL_BASE_IDX                                                                0
#define mmSDMA1_RLC4_CONTEXT_STATUS                                                                    0x08a1
#define mmSDMA1_RLC4_CONTEXT_STATUS_BASE_IDX                                                           0
#define mmSDMA1_RLC4_DOORBELL                                                                          0x08a2
#define mmSDMA1_RLC4_DOORBELL_BASE_IDX                                                                 0
#define mmSDMA1_RLC4_STATUS                                                                            0x08b8
#define mmSDMA1_RLC4_STATUS_BASE_IDX                                                                   0
#define mmSDMA1_RLC4_DOORBELL_LOG                                                                      0x08b9
#define mmSDMA1_RLC4_DOORBELL_LOG_BASE_IDX                                                             0
#define mmSDMA1_RLC4_WATERMARK                                                                         0x08ba
#define mmSDMA1_RLC4_WATERMARK_BASE_IDX                                                                0
#define mmSDMA1_RLC4_DOORBELL_OFFSET                                                                   0x08bb
#define mmSDMA1_RLC4_DOORBELL_OFFSET_BASE_IDX                                                          0
#define mmSDMA1_RLC4_CSA_ADDR_LO                                                                       0x08bc
#define mmSDMA1_RLC4_CSA_ADDR_LO_BASE_IDX                                                              0
#define mmSDMA1_RLC4_CSA_ADDR_HI                                                                       0x08bd
#define mmSDMA1_RLC4_CSA_ADDR_HI_BASE_IDX                                                              0
#define mmSDMA1_RLC4_IB_SUB_REMAIN                                                                     0x08bf
#define mmSDMA1_RLC4_IB_SUB_REMAIN_BASE_IDX                                                            0
#define mmSDMA1_RLC4_PREEMPT                                                                           0x08c0
#define mmSDMA1_RLC4_PREEMPT_BASE_IDX                                                                  0
#define mmSDMA1_RLC4_DUMMY_REG                                                                         0x08c1
#define mmSDMA1_RLC4_DUMMY_REG_BASE_IDX                                                                0
#define mmSDMA1_RLC4_RB_WPTR_POLL_ADDR_HI                                                              0x08c2
#define mmSDMA1_RLC4_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define mmSDMA1_RLC4_RB_WPTR_POLL_ADDR_LO                                                              0x08c3
#define mmSDMA1_RLC4_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define mmSDMA1_RLC4_RB_AQL_CNTL                                                                       0x08c4
#define mmSDMA1_RLC4_RB_AQL_CNTL_BASE_IDX                                                              0
#define mmSDMA1_RLC4_MINOR_PTR_UPDATE                                                                  0x08c5
#define mmSDMA1_RLC4_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define mmSDMA1_RLC4_MIDCMD_DATA0                                                                      0x08d0
#define mmSDMA1_RLC4_MIDCMD_DATA0_BASE_IDX                                                             0
#define mmSDMA1_RLC4_MIDCMD_DATA1                                                                      0x08d1
#define mmSDMA1_RLC4_MIDCMD_DATA1_BASE_IDX                                                             0
#define mmSDMA1_RLC4_MIDCMD_DATA2                                                                      0x08d2
#define mmSDMA1_RLC4_MIDCMD_DATA2_BASE_IDX                                                             0
#define mmSDMA1_RLC4_MIDCMD_DATA3                                                                      0x08d3
#define mmSDMA1_RLC4_MIDCMD_DATA3_BASE_IDX                                                             0
#define mmSDMA1_RLC4_MIDCMD_DATA4                                                                      0x08d4
#define mmSDMA1_RLC4_MIDCMD_DATA4_BASE_IDX                                                             0
#define mmSDMA1_RLC4_MIDCMD_DATA5                                                                      0x08d5
#define mmSDMA1_RLC4_MIDCMD_DATA5_BASE_IDX                                                             0
#define mmSDMA1_RLC4_MIDCMD_DATA6                                                                      0x08d6
#define mmSDMA1_RLC4_MIDCMD_DATA6_BASE_IDX                                                             0
#define mmSDMA1_RLC4_MIDCMD_DATA7                                                                      0x08d7
#define mmSDMA1_RLC4_MIDCMD_DATA7_BASE_IDX                                                             0
#define mmSDMA1_RLC4_MIDCMD_DATA8                                                                      0x08d8
#define mmSDMA1_RLC4_MIDCMD_DATA8_BASE_IDX                                                             0
#define mmSDMA1_RLC4_MIDCMD_DATA9                                                                      0x08d9
#define mmSDMA1_RLC4_MIDCMD_DATA9_BASE_IDX                                                             0
#define mmSDMA1_RLC4_MIDCMD_DATA10                                                                     0x08da
#define mmSDMA1_RLC4_MIDCMD_DATA10_BASE_IDX                                                            0
#define mmSDMA1_RLC4_MIDCMD_CNTL                                                                       0x08db
#define mmSDMA1_RLC4_MIDCMD_CNTL_BASE_IDX                                                              0
#define mmSDMA1_RLC5_RB_CNTL                                                                           0x08e8
#define mmSDMA1_RLC5_RB_CNTL_BASE_IDX                                                                  0
#define mmSDMA1_RLC5_RB_BASE                                                                           0x08e9
#define mmSDMA1_RLC5_RB_BASE_BASE_IDX                                                                  0
#define mmSDMA1_RLC5_RB_BASE_HI                                                                        0x08ea
#define mmSDMA1_RLC5_RB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA1_RLC5_RB_RPTR                                                                           0x08eb
#define mmSDMA1_RLC5_RB_RPTR_BASE_IDX                                                                  0
#define mmSDMA1_RLC5_RB_RPTR_HI                                                                        0x08ec
#define mmSDMA1_RLC5_RB_RPTR_HI_BASE_IDX                                                               0
#define mmSDMA1_RLC5_RB_WPTR                                                                           0x08ed
#define mmSDMA1_RLC5_RB_WPTR_BASE_IDX                                                                  0
#define mmSDMA1_RLC5_RB_WPTR_HI                                                                        0x08ee
#define mmSDMA1_RLC5_RB_WPTR_HI_BASE_IDX                                                               0
#define mmSDMA1_RLC5_RB_WPTR_POLL_CNTL                                                                 0x08ef
#define mmSDMA1_RLC5_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define mmSDMA1_RLC5_RB_RPTR_ADDR_HI                                                                   0x08f0
#define mmSDMA1_RLC5_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define mmSDMA1_RLC5_RB_RPTR_ADDR_LO                                                                   0x08f1
#define mmSDMA1_RLC5_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define mmSDMA1_RLC5_IB_CNTL                                                                           0x08f2
#define mmSDMA1_RLC5_IB_CNTL_BASE_IDX                                                                  0
#define mmSDMA1_RLC5_IB_RPTR                                                                           0x08f3
#define mmSDMA1_RLC5_IB_RPTR_BASE_IDX                                                                  0
#define mmSDMA1_RLC5_IB_OFFSET                                                                         0x08f4
#define mmSDMA1_RLC5_IB_OFFSET_BASE_IDX                                                                0
#define mmSDMA1_RLC5_IB_BASE_LO                                                                        0x08f5
#define mmSDMA1_RLC5_IB_BASE_LO_BASE_IDX                                                               0
#define mmSDMA1_RLC5_IB_BASE_HI                                                                        0x08f6
#define mmSDMA1_RLC5_IB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA1_RLC5_IB_SIZE                                                                           0x08f7
#define mmSDMA1_RLC5_IB_SIZE_BASE_IDX                                                                  0
#define mmSDMA1_RLC5_SKIP_CNTL                                                                         0x08f8
#define mmSDMA1_RLC5_SKIP_CNTL_BASE_IDX                                                                0
#define mmSDMA1_RLC5_CONTEXT_STATUS                                                                    0x08f9
#define mmSDMA1_RLC5_CONTEXT_STATUS_BASE_IDX                                                           0
#define mmSDMA1_RLC5_DOORBELL                                                                          0x08fa
#define mmSDMA1_RLC5_DOORBELL_BASE_IDX                                                                 0
#define mmSDMA1_RLC5_STATUS                                                                            0x0910
#define mmSDMA1_RLC5_STATUS_BASE_IDX                                                                   0
#define mmSDMA1_RLC5_DOORBELL_LOG                                                                      0x0911
#define mmSDMA1_RLC5_DOORBELL_LOG_BASE_IDX                                                             0
#define mmSDMA1_RLC5_WATERMARK                                                                         0x0912
#define mmSDMA1_RLC5_WATERMARK_BASE_IDX                                                                0
#define mmSDMA1_RLC5_DOORBELL_OFFSET                                                                   0x0913
#define mmSDMA1_RLC5_DOORBELL_OFFSET_BASE_IDX                                                          0
#define mmSDMA1_RLC5_CSA_ADDR_LO                                                                       0x0914
#define mmSDMA1_RLC5_CSA_ADDR_LO_BASE_IDX                                                              0
#define mmSDMA1_RLC5_CSA_ADDR_HI                                                                       0x0915
#define mmSDMA1_RLC5_CSA_ADDR_HI_BASE_IDX                                                              0
#define mmSDMA1_RLC5_IB_SUB_REMAIN                                                                     0x0917
#define mmSDMA1_RLC5_IB_SUB_REMAIN_BASE_IDX                                                            0
#define mmSDMA1_RLC5_PREEMPT                                                                           0x0918
#define mmSDMA1_RLC5_PREEMPT_BASE_IDX                                                                  0
#define mmSDMA1_RLC5_DUMMY_REG                                                                         0x0919
#define mmSDMA1_RLC5_DUMMY_REG_BASE_IDX                                                                0
#define mmSDMA1_RLC5_RB_WPTR_POLL_ADDR_HI                                                              0x091a
#define mmSDMA1_RLC5_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define mmSDMA1_RLC5_RB_WPTR_POLL_ADDR_LO                                                              0x091b
#define mmSDMA1_RLC5_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define mmSDMA1_RLC5_RB_AQL_CNTL                                                                       0x091c
#define mmSDMA1_RLC5_RB_AQL_CNTL_BASE_IDX                                                              0
#define mmSDMA1_RLC5_MINOR_PTR_UPDATE                                                                  0x091d
#define mmSDMA1_RLC5_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define mmSDMA1_RLC5_MIDCMD_DATA0                                                                      0x0928
#define mmSDMA1_RLC5_MIDCMD_DATA0_BASE_IDX                                                             0
#define mmSDMA1_RLC5_MIDCMD_DATA1                                                                      0x0929
#define mmSDMA1_RLC5_MIDCMD_DATA1_BASE_IDX                                                             0
#define mmSDMA1_RLC5_MIDCMD_DATA2                                                                      0x092a
#define mmSDMA1_RLC5_MIDCMD_DATA2_BASE_IDX                                                             0
#define mmSDMA1_RLC5_MIDCMD_DATA3                                                                      0x092b
#define mmSDMA1_RLC5_MIDCMD_DATA3_BASE_IDX                                                             0
#define mmSDMA1_RLC5_MIDCMD_DATA4                                                                      0x092c
#define mmSDMA1_RLC5_MIDCMD_DATA4_BASE_IDX                                                             0
#define mmSDMA1_RLC5_MIDCMD_DATA5                                                                      0x092d
#define mmSDMA1_RLC5_MIDCMD_DATA5_BASE_IDX                                                             0
#define mmSDMA1_RLC5_MIDCMD_DATA6                                                                      0x092e
#define mmSDMA1_RLC5_MIDCMD_DATA6_BASE_IDX                                                             0
#define mmSDMA1_RLC5_MIDCMD_DATA7                                                                      0x092f
#define mmSDMA1_RLC5_MIDCMD_DATA7_BASE_IDX                                                             0
#define mmSDMA1_RLC5_MIDCMD_DATA8                                                                      0x0930
#define mmSDMA1_RLC5_MIDCMD_DATA8_BASE_IDX                                                             0
#define mmSDMA1_RLC5_MIDCMD_DATA9                                                                      0x0931
#define mmSDMA1_RLC5_MIDCMD_DATA9_BASE_IDX                                                             0
#define mmSDMA1_RLC5_MIDCMD_DATA10                                                                     0x0932
#define mmSDMA1_RLC5_MIDCMD_DATA10_BASE_IDX                                                            0
#define mmSDMA1_RLC5_MIDCMD_CNTL                                                                       0x0933
#define mmSDMA1_RLC5_MIDCMD_CNTL_BASE_IDX                                                              0
#define mmSDMA1_RLC6_RB_CNTL                                                                           0x0940
#define mmSDMA1_RLC6_RB_CNTL_BASE_IDX                                                                  0
#define mmSDMA1_RLC6_RB_BASE                                                                           0x0941
#define mmSDMA1_RLC6_RB_BASE_BASE_IDX                                                                  0
#define mmSDMA1_RLC6_RB_BASE_HI                                                                        0x0942
#define mmSDMA1_RLC6_RB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA1_RLC6_RB_RPTR                                                                           0x0943
#define mmSDMA1_RLC6_RB_RPTR_BASE_IDX                                                                  0
#define mmSDMA1_RLC6_RB_RPTR_HI                                                                        0x0944
#define mmSDMA1_RLC6_RB_RPTR_HI_BASE_IDX                                                               0
#define mmSDMA1_RLC6_RB_WPTR                                                                           0x0945
#define mmSDMA1_RLC6_RB_WPTR_BASE_IDX                                                                  0
#define mmSDMA1_RLC6_RB_WPTR_HI                                                                        0x0946
#define mmSDMA1_RLC6_RB_WPTR_HI_BASE_IDX                                                               0
#define mmSDMA1_RLC6_RB_WPTR_POLL_CNTL                                                                 0x0947
#define mmSDMA1_RLC6_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define mmSDMA1_RLC6_RB_RPTR_ADDR_HI                                                                   0x0948
#define mmSDMA1_RLC6_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define mmSDMA1_RLC6_RB_RPTR_ADDR_LO                                                                   0x0949
#define mmSDMA1_RLC6_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define mmSDMA1_RLC6_IB_CNTL                                                                           0x094a
#define mmSDMA1_RLC6_IB_CNTL_BASE_IDX                                                                  0
#define mmSDMA1_RLC6_IB_RPTR                                                                           0x094b
#define mmSDMA1_RLC6_IB_RPTR_BASE_IDX                                                                  0
#define mmSDMA1_RLC6_IB_OFFSET                                                                         0x094c
#define mmSDMA1_RLC6_IB_OFFSET_BASE_IDX                                                                0
#define mmSDMA1_RLC6_IB_BASE_LO                                                                        0x094d
#define mmSDMA1_RLC6_IB_BASE_LO_BASE_IDX                                                               0
#define mmSDMA1_RLC6_IB_BASE_HI                                                                        0x094e
#define mmSDMA1_RLC6_IB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA1_RLC6_IB_SIZE                                                                           0x094f
#define mmSDMA1_RLC6_IB_SIZE_BASE_IDX                                                                  0
#define mmSDMA1_RLC6_SKIP_CNTL                                                                         0x0950
#define mmSDMA1_RLC6_SKIP_CNTL_BASE_IDX                                                                0
#define mmSDMA1_RLC6_CONTEXT_STATUS                                                                    0x0951
#define mmSDMA1_RLC6_CONTEXT_STATUS_BASE_IDX                                                           0
#define mmSDMA1_RLC6_DOORBELL                                                                          0x0952
#define mmSDMA1_RLC6_DOORBELL_BASE_IDX                                                                 0
#define mmSDMA1_RLC6_STATUS                                                                            0x0968
#define mmSDMA1_RLC6_STATUS_BASE_IDX                                                                   0
#define mmSDMA1_RLC6_DOORBELL_LOG                                                                      0x0969
#define mmSDMA1_RLC6_DOORBELL_LOG_BASE_IDX                                                             0
#define mmSDMA1_RLC6_WATERMARK                                                                         0x096a
#define mmSDMA1_RLC6_WATERMARK_BASE_IDX                                                                0
#define mmSDMA1_RLC6_DOORBELL_OFFSET                                                                   0x096b
#define mmSDMA1_RLC6_DOORBELL_OFFSET_BASE_IDX                                                          0
#define mmSDMA1_RLC6_CSA_ADDR_LO                                                                       0x096c
#define mmSDMA1_RLC6_CSA_ADDR_LO_BASE_IDX                                                              0
#define mmSDMA1_RLC6_CSA_ADDR_HI                                                                       0x096d
#define mmSDMA1_RLC6_CSA_ADDR_HI_BASE_IDX                                                              0
#define mmSDMA1_RLC6_IB_SUB_REMAIN                                                                     0x096f
#define mmSDMA1_RLC6_IB_SUB_REMAIN_BASE_IDX                                                            0
#define mmSDMA1_RLC6_PREEMPT                                                                           0x0970
#define mmSDMA1_RLC6_PREEMPT_BASE_IDX                                                                  0
#define mmSDMA1_RLC6_DUMMY_REG                                                                         0x0971
#define mmSDMA1_RLC6_DUMMY_REG_BASE_IDX                                                                0
#define mmSDMA1_RLC6_RB_WPTR_POLL_ADDR_HI                                                              0x0972
#define mmSDMA1_RLC6_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define mmSDMA1_RLC6_RB_WPTR_POLL_ADDR_LO                                                              0x0973
#define mmSDMA1_RLC6_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define mmSDMA1_RLC6_RB_AQL_CNTL                                                                       0x0974
#define mmSDMA1_RLC6_RB_AQL_CNTL_BASE_IDX                                                              0
#define mmSDMA1_RLC6_MINOR_PTR_UPDATE                                                                  0x0975
#define mmSDMA1_RLC6_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define mmSDMA1_RLC6_MIDCMD_DATA0                                                                      0x0980
#define mmSDMA1_RLC6_MIDCMD_DATA0_BASE_IDX                                                             0
#define mmSDMA1_RLC6_MIDCMD_DATA1                                                                      0x0981
#define mmSDMA1_RLC6_MIDCMD_DATA1_BASE_IDX                                                             0
#define mmSDMA1_RLC6_MIDCMD_DATA2                                                                      0x0982
#define mmSDMA1_RLC6_MIDCMD_DATA2_BASE_IDX                                                             0
#define mmSDMA1_RLC6_MIDCMD_DATA3                                                                      0x0983
#define mmSDMA1_RLC6_MIDCMD_DATA3_BASE_IDX                                                             0
#define mmSDMA1_RLC6_MIDCMD_DATA4                                                                      0x0984
#define mmSDMA1_RLC6_MIDCMD_DATA4_BASE_IDX                                                             0
#define mmSDMA1_RLC6_MIDCMD_DATA5                                                                      0x0985
#define mmSDMA1_RLC6_MIDCMD_DATA5_BASE_IDX                                                             0
#define mmSDMA1_RLC6_MIDCMD_DATA6                                                                      0x0986
#define mmSDMA1_RLC6_MIDCMD_DATA6_BASE_IDX                                                             0
#define mmSDMA1_RLC6_MIDCMD_DATA7                                                                      0x0987
#define mmSDMA1_RLC6_MIDCMD_DATA7_BASE_IDX                                                             0
#define mmSDMA1_RLC6_MIDCMD_DATA8                                                                      0x0988
#define mmSDMA1_RLC6_MIDCMD_DATA8_BASE_IDX                                                             0
#define mmSDMA1_RLC6_MIDCMD_DATA9                                                                      0x0989
#define mmSDMA1_RLC6_MIDCMD_DATA9_BASE_IDX                                                             0
#define mmSDMA1_RLC6_MIDCMD_DATA10                                                                     0x098a
#define mmSDMA1_RLC6_MIDCMD_DATA10_BASE_IDX                                                            0
#define mmSDMA1_RLC6_MIDCMD_CNTL                                                                       0x098b
#define mmSDMA1_RLC6_MIDCMD_CNTL_BASE_IDX                                                              0
#define mmSDMA1_RLC7_RB_CNTL                                                                           0x0998
#define mmSDMA1_RLC7_RB_CNTL_BASE_IDX                                                                  0
#define mmSDMA1_RLC7_RB_BASE                                                                           0x0999
#define mmSDMA1_RLC7_RB_BASE_BASE_IDX                                                                  0
#define mmSDMA1_RLC7_RB_BASE_HI                                                                        0x099a
#define mmSDMA1_RLC7_RB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA1_RLC7_RB_RPTR                                                                           0x099b
#define mmSDMA1_RLC7_RB_RPTR_BASE_IDX                                                                  0
#define mmSDMA1_RLC7_RB_RPTR_HI                                                                        0x099c
#define mmSDMA1_RLC7_RB_RPTR_HI_BASE_IDX                                                               0
#define mmSDMA1_RLC7_RB_WPTR                                                                           0x099d
#define mmSDMA1_RLC7_RB_WPTR_BASE_IDX                                                                  0
#define mmSDMA1_RLC7_RB_WPTR_HI                                                                        0x099e
#define mmSDMA1_RLC7_RB_WPTR_HI_BASE_IDX                                                               0
#define mmSDMA1_RLC7_RB_WPTR_POLL_CNTL                                                                 0x099f
#define mmSDMA1_RLC7_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define mmSDMA1_RLC7_RB_RPTR_ADDR_HI                                                                   0x09a0
#define mmSDMA1_RLC7_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define mmSDMA1_RLC7_RB_RPTR_ADDR_LO                                                                   0x09a1
#define mmSDMA1_RLC7_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define mmSDMA1_RLC7_IB_CNTL                                                                           0x09a2
#define mmSDMA1_RLC7_IB_CNTL_BASE_IDX                                                                  0
#define mmSDMA1_RLC7_IB_RPTR                                                                           0x09a3
#define mmSDMA1_RLC7_IB_RPTR_BASE_IDX                                                                  0
#define mmSDMA1_RLC7_IB_OFFSET                                                                         0x09a4
#define mmSDMA1_RLC7_IB_OFFSET_BASE_IDX                                                                0
#define mmSDMA1_RLC7_IB_BASE_LO                                                                        0x09a5
#define mmSDMA1_RLC7_IB_BASE_LO_BASE_IDX                                                               0
#define mmSDMA1_RLC7_IB_BASE_HI                                                                        0x09a6
#define mmSDMA1_RLC7_IB_BASE_HI_BASE_IDX                                                               0
#define mmSDMA1_RLC7_IB_SIZE                                                                           0x09a7
#define mmSDMA1_RLC7_IB_SIZE_BASE_IDX                                                                  0
#define mmSDMA1_RLC7_SKIP_CNTL                                                                         0x09a8
#define mmSDMA1_RLC7_SKIP_CNTL_BASE_IDX                                                                0
#define mmSDMA1_RLC7_CONTEXT_STATUS                                                                    0x09a9
#define mmSDMA1_RLC7_CONTEXT_STATUS_BASE_IDX                                                           0
#define mmSDMA1_RLC7_DOORBELL                                                                          0x09aa
#define mmSDMA1_RLC7_DOORBELL_BASE_IDX                                                                 0
#define mmSDMA1_RLC7_STATUS                                                                            0x09c0
#define mmSDMA1_RLC7_STATUS_BASE_IDX                                                                   0
#define mmSDMA1_RLC7_DOORBELL_LOG                                                                      0x09c1
#define mmSDMA1_RLC7_DOORBELL_LOG_BASE_IDX                                                             0
#define mmSDMA1_RLC7_WATERMARK                                                                         0x09c2
#define mmSDMA1_RLC7_WATERMARK_BASE_IDX                                                                0
#define mmSDMA1_RLC7_DOORBELL_OFFSET                                                                   0x09c3
#define mmSDMA1_RLC7_DOORBELL_OFFSET_BASE_IDX                                                          0
#define mmSDMA1_RLC7_CSA_ADDR_LO                                                                       0x09c4
#define mmSDMA1_RLC7_CSA_ADDR_LO_BASE_IDX                                                              0
#define mmSDMA1_RLC7_CSA_ADDR_HI                                                                       0x09c5
#define mmSDMA1_RLC7_CSA_ADDR_HI_BASE_IDX                                                              0
#define mmSDMA1_RLC7_IB_SUB_REMAIN                                                                     0x09c7
#define mmSDMA1_RLC7_IB_SUB_REMAIN_BASE_IDX                                                            0
#define mmSDMA1_RLC7_PREEMPT                                                                           0x09c8
#define mmSDMA1_RLC7_PREEMPT_BASE_IDX                                                                  0
#define mmSDMA1_RLC7_DUMMY_REG                                                                         0x09c9
#define mmSDMA1_RLC7_DUMMY_REG_BASE_IDX                                                                0
#define mmSDMA1_RLC7_RB_WPTR_POLL_ADDR_HI                                                              0x09ca
#define mmSDMA1_RLC7_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define mmSDMA1_RLC7_RB_WPTR_POLL_ADDR_LO                                                              0x09cb
#define mmSDMA1_RLC7_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define mmSDMA1_RLC7_RB_AQL_CNTL                                                                       0x09cc
#define mmSDMA1_RLC7_RB_AQL_CNTL_BASE_IDX                                                              0
#define mmSDMA1_RLC7_MINOR_PTR_UPDATE                                                                  0x09cd
#define mmSDMA1_RLC7_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define mmSDMA1_RLC7_MIDCMD_DATA0                                                                      0x09d8
#define mmSDMA1_RLC7_MIDCMD_DATA0_BASE_IDX                                                             0
#define mmSDMA1_RLC7_MIDCMD_DATA1                                                                      0x09d9
#define mmSDMA1_RLC7_MIDCMD_DATA1_BASE_IDX                                                             0
#define mmSDMA1_RLC7_MIDCMD_DATA2                                                                      0x09da
#define mmSDMA1_RLC7_MIDCMD_DATA2_BASE_IDX                                                             0
#define mmSDMA1_RLC7_MIDCMD_DATA3                                                                      0x09db
#define mmSDMA1_RLC7_MIDCMD_DATA3_BASE_IDX                                                             0
#define mmSDMA1_RLC7_MIDCMD_DATA4                                                                      0x09dc
#define mmSDMA1_RLC7_MIDCMD_DATA4_BASE_IDX                                                             0
#define mmSDMA1_RLC7_MIDCMD_DATA5                                                                      0x09dd
#define mmSDMA1_RLC7_MIDCMD_DATA5_BASE_IDX                                                             0
#define mmSDMA1_RLC7_MIDCMD_DATA6                                                                      0x09de
#define mmSDMA1_RLC7_MIDCMD_DATA6_BASE_IDX                                                             0
#define mmSDMA1_RLC7_MIDCMD_DATA7                                                                      0x09df
#define mmSDMA1_RLC7_MIDCMD_DATA7_BASE_IDX                                                             0
#define mmSDMA1_RLC7_MIDCMD_DATA8                                                                      0x09e0
#define mmSDMA1_RLC7_MIDCMD_DATA8_BASE_IDX                                                             0
#define mmSDMA1_RLC7_MIDCMD_DATA9                                                                      0x09e1
#define mmSDMA1_RLC7_MIDCMD_DATA9_BASE_IDX                                                             0
#define mmSDMA1_RLC7_MIDCMD_DATA10                                                                     0x09e2
#define mmSDMA1_RLC7_MIDCMD_DATA10_BASE_IDX                                                            0
#define mmSDMA1_RLC7_MIDCMD_CNTL                                                                       0x09e3
#define mmSDMA1_RLC7_MIDCMD_CNTL_BASE_IDX                                                              0


// addressBlock: gc_grbmdec
// base address: 0x8000
#define mmGRBM_CNTL                                                                                    0x0da0
#define mmGRBM_CNTL_BASE_IDX                                                                           0
#define mmGRBM_SKEW_CNTL                                                                               0x0da1
#define mmGRBM_SKEW_CNTL_BASE_IDX                                                                      0
#define mmGRBM_STATUS2                                                                                 0x0da2
#define mmGRBM_STATUS2_BASE_IDX                                                                        0
#define mmGRBM_PWR_CNTL                                                                                0x0da3
#define mmGRBM_PWR_CNTL_BASE_IDX                                                                       0
#define mmGRBM_STATUS                                                                                  0x0da4
#define mmGRBM_STATUS_BASE_IDX                                                                         0
#define mmGRBM_STATUS_SE0                                                                              0x0da5
#define mmGRBM_STATUS_SE0_BASE_IDX                                                                     0
#define mmGRBM_STATUS_SE1                                                                              0x0da6
#define mmGRBM_STATUS_SE1_BASE_IDX                                                                     0
#define mmGRBM_STATUS3                                                                                 0x0da7
#define mmGRBM_STATUS3_BASE_IDX                                                                        0
#define mmGRBM_SOFT_RESET                                                                              0x0da8
#define mmGRBM_SOFT_RESET_BASE_IDX                                                                     0
#define mmGRBM_GFX_CLKEN_CNTL                                                                          0x0dac
#define mmGRBM_GFX_CLKEN_CNTL_BASE_IDX                                                                 0
#define mmGRBM_WAIT_IDLE_CLOCKS                                                                        0x0dad
#define mmGRBM_WAIT_IDLE_CLOCKS_BASE_IDX                                                               0
#define mmGRBM_STATUS_SE2                                                                              0x0dae
#define mmGRBM_STATUS_SE2_BASE_IDX                                                                     0
#define mmGRBM_STATUS_SE3                                                                              0x0daf
#define mmGRBM_STATUS_SE3_BASE_IDX                                                                     0
#define mmGRBM_READ_ERROR                                                                              0x0db6
#define mmGRBM_READ_ERROR_BASE_IDX                                                                     0
#define mmGRBM_READ_ERROR2                                                                             0x0db7
#define mmGRBM_READ_ERROR2_BASE_IDX                                                                    0
#define mmGRBM_INT_CNTL                                                                                0x0db8
#define mmGRBM_INT_CNTL_BASE_IDX                                                                       0
#define mmGRBM_TRAP_OP                                                                                 0x0db9
#define mmGRBM_TRAP_OP_BASE_IDX                                                                        0
#define mmGRBM_TRAP_ADDR                                                                               0x0dba
#define mmGRBM_TRAP_ADDR_BASE_IDX                                                                      0
#define mmGRBM_TRAP_ADDR_MSK                                                                           0x0dbb
#define mmGRBM_TRAP_ADDR_MSK_BASE_IDX                                                                  0
#define mmGRBM_TRAP_WD                                                                                 0x0dbc
#define mmGRBM_TRAP_WD_BASE_IDX                                                                        0
#define mmGRBM_TRAP_WD_MSK                                                                             0x0dbd
#define mmGRBM_TRAP_WD_MSK_BASE_IDX                                                                    0
#define mmGRBM_DSM_BYPASS                                                                              0x0dbe
#define mmGRBM_DSM_BYPASS_BASE_IDX                                                                     0
#define mmGRBM_WRITE_ERROR                                                                             0x0dbf
#define mmGRBM_WRITE_ERROR_BASE_IDX                                                                    0
#define mmGRBM_CHIP_REVISION                                                                           0x0dc1
#define mmGRBM_CHIP_REVISION_BASE_IDX                                                                  0
#define mmGRBM_GFX_CNTL                                                                                0x0dc2
#define mmGRBM_GFX_CNTL_BASE_IDX                                                                       0
#define mmGRBM_IH_CREDIT                                                                               0x0dc4
#define mmGRBM_IH_CREDIT_BASE_IDX                                                                      0
#define mmGRBM_PWR_CNTL2                                                                               0x0dc5
#define mmGRBM_PWR_CNTL2_BASE_IDX                                                                      0
#define mmGRBM_UTCL2_INVAL_RANGE_START                                                                 0x0dc6
#define mmGRBM_UTCL2_INVAL_RANGE_START_BASE_IDX                                                        0
#define mmGRBM_UTCL2_INVAL_RANGE_END                                                                   0x0dc7
#define mmGRBM_UTCL2_INVAL_RANGE_END_BASE_IDX                                                          0
#define mmGRBM_FENCE_RANGE0                                                                            0x0dca
#define mmGRBM_FENCE_RANGE0_BASE_IDX                                                                   0
#define mmGRBM_FENCE_RANGE1                                                                            0x0dcb
#define mmGRBM_FENCE_RANGE1_BASE_IDX                                                                   0
#define mmGRBM_NOWHERE                                                                                 0x0ddf
#define mmGRBM_NOWHERE_BASE_IDX                                                                        0
#define mmGRBM_SCRATCH_REG0                                                                            0x0de0
#define mmGRBM_SCRATCH_REG0_BASE_IDX                                                                   0
#define mmGRBM_SCRATCH_REG1                                                                            0x0de1
#define mmGRBM_SCRATCH_REG1_BASE_IDX                                                                   0
#define mmGRBM_SCRATCH_REG2                                                                            0x0de2
#define mmGRBM_SCRATCH_REG2_BASE_IDX                                                                   0
#define mmGRBM_SCRATCH_REG3                                                                            0x0de3
#define mmGRBM_SCRATCH_REG3_BASE_IDX                                                                   0
#define mmGRBM_SCRATCH_REG4                                                                            0x0de4
#define mmGRBM_SCRATCH_REG4_BASE_IDX                                                                   0
#define mmGRBM_SCRATCH_REG5                                                                            0x0de5
#define mmGRBM_SCRATCH_REG5_BASE_IDX                                                                   0
#define mmGRBM_SCRATCH_REG6                                                                            0x0de6
#define mmGRBM_SCRATCH_REG6_BASE_IDX                                                                   0
#define mmGRBM_SCRATCH_REG7                                                                            0x0de7
#define mmGRBM_SCRATCH_REG7_BASE_IDX                                                                   0
#define mmVIOLATION_DATA_ASYNC_VF_PROG                                                                 0x0df1
#define mmVIOLATION_DATA_ASYNC_VF_PROG_BASE_IDX                                                        0


// addressBlock: gc_cpdec
// base address: 0x8200
#define mmCP_CPC_STATUS                                                                                0x0e24
#define mmCP_CPC_STATUS_BASE_IDX                                                                       0
#define mmCP_CPC_BUSY_STAT                                                                             0x0e25
#define mmCP_CPC_BUSY_STAT_BASE_IDX                                                                    0
#define mmCP_CPC_STALLED_STAT1                                                                         0x0e26
#define mmCP_CPC_STALLED_STAT1_BASE_IDX                                                                0
#define mmCP_CPF_STATUS                                                                                0x0e27
#define mmCP_CPF_STATUS_BASE_IDX                                                                       0
#define mmCP_CPF_BUSY_STAT                                                                             0x0e28
#define mmCP_CPF_BUSY_STAT_BASE_IDX                                                                    0
#define mmCP_CPF_STALLED_STAT1                                                                         0x0e29
#define mmCP_CPF_STALLED_STAT1_BASE_IDX                                                                0
#define mmCP_CPC_BUSY_STAT2                                                                            0x0e2a
#define mmCP_CPC_BUSY_STAT2_BASE_IDX                                                                   0
#define mmCP_CPC_GRBM_FREE_COUNT                                                                       0x0e2b
#define mmCP_CPC_GRBM_FREE_COUNT_BASE_IDX                                                              0
#define mmCP_CPC_PRIV_VIOLATION_ADDR                                                                   0x0e2c
#define mmCP_CPC_PRIV_VIOLATION_ADDR_BASE_IDX                                                          0
#define mmCP_MEC_ME1_HEADER_DUMP                                                                       0x0e2e
#define mmCP_MEC_ME1_HEADER_DUMP_BASE_IDX                                                              0
#define mmCP_MEC_ME2_HEADER_DUMP                                                                       0x0e2f
#define mmCP_MEC_ME2_HEADER_DUMP_BASE_IDX                                                              0
#define mmCP_CPC_SCRATCH_INDEX                                                                         0x0e30
#define mmCP_CPC_SCRATCH_INDEX_BASE_IDX                                                                0
#define mmCP_CPC_SCRATCH_DATA                                                                          0x0e31
#define mmCP_CPC_SCRATCH_DATA_BASE_IDX                                                                 0
#define mmCP_CPF_GRBM_FREE_COUNT                                                                       0x0e32
#define mmCP_CPF_GRBM_FREE_COUNT_BASE_IDX                                                              0
#define mmCP_CPF_BUSY_STAT2                                                                            0x0e33
#define mmCP_CPF_BUSY_STAT2_BASE_IDX                                                                   0
#define mmCONFIG_RESERVED_REG0                                                                         0x0e34
#define mmCONFIG_RESERVED_REG0_BASE_IDX                                                                0
#define mmCONFIG_RESERVED_REG1                                                                         0x0e35
#define mmCONFIG_RESERVED_REG1_BASE_IDX                                                                0
#define mmCP_CPC_HALT_HYST_COUNT                                                                       0x0e47
#define mmCP_CPC_HALT_HYST_COUNT_BASE_IDX                                                              0
#define mmCP_CE_COMPARE_COUNT                                                                          0x0e60
#define mmCP_CE_COMPARE_COUNT_BASE_IDX                                                                 0
#define mmCP_CE_DE_COUNT                                                                               0x0e61
#define mmCP_CE_DE_COUNT_BASE_IDX                                                                      0
#define mmCP_DE_CE_COUNT                                                                               0x0e62
#define mmCP_DE_CE_COUNT_BASE_IDX                                                                      0
#define mmCP_DE_LAST_INVAL_COUNT                                                                       0x0e63
#define mmCP_DE_LAST_INVAL_COUNT_BASE_IDX                                                              0
#define mmCP_DE_DE_COUNT                                                                               0x0e64
#define mmCP_DE_DE_COUNT_BASE_IDX                                                                      0
#define mmCP_STALLED_STAT3                                                                             0x0f3c
#define mmCP_STALLED_STAT3_BASE_IDX                                                                    0
#define mmCP_STALLED_STAT1                                                                             0x0f3d
#define mmCP_STALLED_STAT1_BASE_IDX                                                                    0
#define mmCP_STALLED_STAT2                                                                             0x0f3e
#define mmCP_STALLED_STAT2_BASE_IDX                                                                    0
#define mmCP_BUSY_STAT                                                                                 0x0f3f
#define mmCP_BUSY_STAT_BASE_IDX                                                                        0
#define mmCP_STAT                                                                                      0x0f40
#define mmCP_STAT_BASE_IDX                                                                             0
#define mmCP_ME_HEADER_DUMP                                                                            0x0f41
#define mmCP_ME_HEADER_DUMP_BASE_IDX                                                                   0
#define mmCP_PFP_HEADER_DUMP                                                                           0x0f42
#define mmCP_PFP_HEADER_DUMP_BASE_IDX                                                                  0
#define mmCP_GRBM_FREE_COUNT                                                                           0x0f43
#define mmCP_GRBM_FREE_COUNT_BASE_IDX                                                                  0
#define mmCP_CE_HEADER_DUMP                                                                            0x0f44
#define mmCP_CE_HEADER_DUMP_BASE_IDX                                                                   0
#define mmCP_PFP_INSTR_PNTR                                                                            0x0f45
#define mmCP_PFP_INSTR_PNTR_BASE_IDX                                                                   0
#define mmCP_ME_INSTR_PNTR                                                                             0x0f46
#define mmCP_ME_INSTR_PNTR_BASE_IDX                                                                    0
#define mmCP_CE_INSTR_PNTR                                                                             0x0f47
#define mmCP_CE_INSTR_PNTR_BASE_IDX                                                                    0
#define mmCP_MEC1_INSTR_PNTR                                                                           0x0f48
#define mmCP_MEC1_INSTR_PNTR_BASE_IDX                                                                  0
#define mmCP_MEC2_INSTR_PNTR                                                                           0x0f49
#define mmCP_MEC2_INSTR_PNTR_BASE_IDX                                                                  0
#define mmCP_CSF_STAT                                                                                  0x0f54
#define mmCP_CSF_STAT_BASE_IDX                                                                         0
#define mmCP_MEC_CNTL                                                                                  0x0f55
#define mmCP_MEC_CNTL_BASE_IDX                                                                         0
#define mmCP_ME_CNTL                                                                                   0x0f56
#define mmCP_ME_CNTL_BASE_IDX                                                                          0
#define mmCP_CNTX_STAT                                                                                 0x0f58
#define mmCP_CNTX_STAT_BASE_IDX                                                                        0
#define mmCP_ME_PREEMPTION                                                                             0x0f59
#define mmCP_ME_PREEMPTION_BASE_IDX                                                                    0
#define mmCP_ROQ_THRESHOLDS                                                                            0x0f5c
#define mmCP_ROQ_THRESHOLDS_BASE_IDX                                                                   0
#define mmCP_MEQ_STQ_THRESHOLD                                                                         0x0f5d
#define mmCP_MEQ_STQ_THRESHOLD_BASE_IDX                                                                0
#define mmCP_RB2_RPTR                                                                                  0x0f5e
#define mmCP_RB2_RPTR_BASE_IDX                                                                         0
#define mmCP_RB1_RPTR                                                                                  0x0f5f
#define mmCP_RB1_RPTR_BASE_IDX                                                                         0
#define mmCP_RB0_RPTR                                                                                  0x0f60
#define mmCP_RB0_RPTR_BASE_IDX                                                                         0
#define mmCP_RB_RPTR                                                                                   0x0f60
#define mmCP_RB_RPTR_BASE_IDX                                                                          0
#define mmCP_RB_WPTR_DELAY                                                                             0x0f61
#define mmCP_RB_WPTR_DELAY_BASE_IDX                                                                    0
#define mmCP_RB_WPTR_POLL_CNTL                                                                         0x0f62
#define mmCP_RB_WPTR_POLL_CNTL_BASE_IDX                                                                0
#define mmCP_ROQ1_THRESHOLDS                                                                           0x0f75
#define mmCP_ROQ1_THRESHOLDS_BASE_IDX                                                                  0
#define mmCP_ROQ2_THRESHOLDS                                                                           0x0f76
#define mmCP_ROQ2_THRESHOLDS_BASE_IDX                                                                  0
#define mmCP_STQ_THRESHOLDS                                                                            0x0f77
#define mmCP_STQ_THRESHOLDS_BASE_IDX                                                                   0
#define mmCP_QUEUE_THRESHOLDS                                                                          0x0f78
#define mmCP_QUEUE_THRESHOLDS_BASE_IDX                                                                 0
#define mmCP_MEQ_THRESHOLDS                                                                            0x0f79
#define mmCP_MEQ_THRESHOLDS_BASE_IDX                                                                   0
#define mmCP_ROQ_AVAIL                                                                                 0x0f7a
#define mmCP_ROQ_AVAIL_BASE_IDX                                                                        0
#define mmCP_STQ_AVAIL                                                                                 0x0f7b
#define mmCP_STQ_AVAIL_BASE_IDX                                                                        0
#define mmCP_ROQ2_AVAIL                                                                                0x0f7c
#define mmCP_ROQ2_AVAIL_BASE_IDX                                                                       0
#define mmCP_MEQ_AVAIL                                                                                 0x0f7d
#define mmCP_MEQ_AVAIL_BASE_IDX                                                                        0
#define mmCP_CMD_INDEX                                                                                 0x0f7e
#define mmCP_CMD_INDEX_BASE_IDX                                                                        0
#define mmCP_CMD_DATA                                                                                  0x0f7f
#define mmCP_CMD_DATA_BASE_IDX                                                                         0
#define mmCP_ROQ_RB_STAT                                                                               0x0f80
#define mmCP_ROQ_RB_STAT_BASE_IDX                                                                      0
#define mmCP_ROQ_IB1_STAT                                                                              0x0f81
#define mmCP_ROQ_IB1_STAT_BASE_IDX                                                                     0
#define mmCP_ROQ_IB2_STAT                                                                              0x0f82
#define mmCP_ROQ_IB2_STAT_BASE_IDX                                                                     0
#define mmCP_STQ_STAT                                                                                  0x0f83
#define mmCP_STQ_STAT_BASE_IDX                                                                         0
#define mmCP_STQ_WR_STAT                                                                               0x0f84
#define mmCP_STQ_WR_STAT_BASE_IDX                                                                      0
#define mmCP_MEQ_STAT                                                                                  0x0f85
#define mmCP_MEQ_STAT_BASE_IDX                                                                         0
#define mmCP_CEQ1_AVAIL                                                                                0x0f86
#define mmCP_CEQ1_AVAIL_BASE_IDX                                                                       0
#define mmCP_CEQ2_AVAIL                                                                                0x0f87
#define mmCP_CEQ2_AVAIL_BASE_IDX                                                                       0
#define mmCP_CE_ROQ_RB_STAT                                                                            0x0f88
#define mmCP_CE_ROQ_RB_STAT_BASE_IDX                                                                   0
#define mmCP_CE_ROQ_IB1_STAT                                                                           0x0f89
#define mmCP_CE_ROQ_IB1_STAT_BASE_IDX                                                                  0
#define mmCP_CE_ROQ_IB2_STAT                                                                           0x0f8a
#define mmCP_CE_ROQ_IB2_STAT_BASE_IDX                                                                  0
#define mmCP_CE_ROQ_DB_STAT                                                                            0x0f8b
#define mmCP_CE_ROQ_DB_STAT_BASE_IDX                                                                   0
#define mmCP_ROQ3_THRESHOLDS                                                                           0x0f8c
#define mmCP_ROQ3_THRESHOLDS_BASE_IDX                                                                  0
#define mmCP_ROQ_DB_STAT                                                                               0x0f8d
#define mmCP_ROQ_DB_STAT_BASE_IDX                                                                      0
#define mmCP_PRIV_VIOLATION_ADDR                                                                       0x0f9a
#define mmCP_PRIV_VIOLATION_ADDR_BASE_IDX                                                              0


// addressBlock: gc_padec
// base address: 0x8800
#define mmVGT_CACHE_INVALIDATION                                                                       0x0fc0
#define mmVGT_CACHE_INVALIDATION_BASE_IDX                                                              0
#define mmVGT_ESGS_RING_SIZE                                                                           0x0fc1
#define mmVGT_ESGS_RING_SIZE_BASE_IDX                                                                  0
#define mmVGT_GSVS_RING_SIZE                                                                           0x0fc2
#define mmVGT_GSVS_RING_SIZE_BASE_IDX                                                                  0
#define mmVGT_TF_RING_SIZE                                                                             0x0fc3
#define mmVGT_TF_RING_SIZE_BASE_IDX                                                                    0
#define mmVGT_HS_OFFCHIP_PARAM                                                                         0x0fc4
#define mmVGT_HS_OFFCHIP_PARAM_BASE_IDX                                                                0
#define mmVGT_TF_MEMORY_BASE                                                                           0x0fc5
#define mmVGT_TF_MEMORY_BASE_BASE_IDX                                                                  0
#define mmVGT_TF_MEMORY_BASE_HI                                                                        0x0fc6
#define mmVGT_TF_MEMORY_BASE_HI_BASE_IDX                                                               0
#define mmVGT_VTX_VECT_EJECT_REG                                                                       0x0fcc
#define mmVGT_VTX_VECT_EJECT_REG_BASE_IDX                                                              0
#define mmVGT_DMA_DATA_FIFO_DEPTH                                                                      0x0fcd
#define mmVGT_DMA_DATA_FIFO_DEPTH_BASE_IDX                                                             0
#define mmVGT_DMA_REQ_FIFO_DEPTH                                                                       0x0fce
#define mmVGT_DMA_REQ_FIFO_DEPTH_BASE_IDX                                                              0
#define mmVGT_DRAW_INIT_FIFO_DEPTH                                                                     0x0fcf
#define mmVGT_DRAW_INIT_FIFO_DEPTH_BASE_IDX                                                            0
#define mmVGT_LAST_COPY_STATE                                                                          0x0fd0
#define mmVGT_LAST_COPY_STATE_BASE_IDX                                                                 0
#define mmVGT_FIFO_DEPTHS                                                                              0x0fd4
#define mmVGT_FIFO_DEPTHS_BASE_IDX                                                                     0
#define mmVGT_GS_VERTEX_REUSE                                                                          0x0fd5
#define mmVGT_GS_VERTEX_REUSE_BASE_IDX                                                                 0
#define mmVGT_MC_LAT_CNTL                                                                              0x0fd6
#define mmVGT_MC_LAT_CNTL_BASE_IDX                                                                     0
#define mmIA_UTCL1_STATUS_2                                                                            0x0fd7
#define mmIA_UTCL1_STATUS_2_BASE_IDX                                                                   0
#define mmWD_CNTL_STATUS                                                                               0x0fdf
#define mmWD_CNTL_STATUS_BASE_IDX                                                                      0
#define mmCC_GC_PRIM_CONFIG                                                                            0x0fe0
#define mmCC_GC_PRIM_CONFIG_BASE_IDX                                                                   0
#define mmGC_USER_PRIM_CONFIG                                                                          0x0fe1
#define mmGC_USER_PRIM_CONFIG_BASE_IDX                                                                 0
#define mmWD_QOS                                                                                       0x0fe2
#define mmWD_QOS_BASE_IDX                                                                              0
#define mmWD_UTCL1_CNTL                                                                                0x0fe3
#define mmWD_UTCL1_CNTL_BASE_IDX                                                                       0
#define mmWD_UTCL1_STATUS                                                                              0x0fe4
#define mmWD_UTCL1_STATUS_BASE_IDX                                                                     0
#define mmGE_PC_CNTL                                                                                   0x0fe5
#define mmGE_PC_CNTL_BASE_IDX                                                                          0
#define mmIA_UTCL1_CNTL                                                                                0x0fe6
#define mmIA_UTCL1_CNTL_BASE_IDX                                                                       0
#define mmIA_UTCL1_STATUS                                                                              0x0fe7
#define mmIA_UTCL1_STATUS_BASE_IDX                                                                     0
#define mmCC_GC_SA_UNIT_DISABLE                                                                        0x0fe9
#define mmCC_GC_SA_UNIT_DISABLE_BASE_IDX                                                               0
#define mmGC_USER_SA_UNIT_DISABLE                                                                      0x0fea
#define mmGC_USER_SA_UNIT_DISABLE_BASE_IDX                                                             0
#define mmVGT_SYS_CONFIG                                                                               0x1003
#define mmVGT_SYS_CONFIG_BASE_IDX                                                                      0
#define mmGE_PRIV_CONTROL                                                                              0x1004
#define mmGE_PRIV_CONTROL_BASE_IDX                                                                     0
#define mmGE_STATUS                                                                                    0x1005
#define mmGE_STATUS_BASE_IDX                                                                           0
#define mmVGT_VS_MAX_WAVE_ID                                                                           0x1008
#define mmVGT_VS_MAX_WAVE_ID_BASE_IDX                                                                  0
#define mmVGT_GS_MAX_WAVE_ID                                                                           0x1009
#define mmVGT_GS_MAX_WAVE_ID_BASE_IDX                                                                  0
#define mmCC_GC_SHADER_ARRAY_CONFIG_GEN1                                                               0x100a
#define mmCC_GC_SHADER_ARRAY_CONFIG_GEN1_BASE_IDX                                                      0
#define mmCC_GC_SHADER_ARRAY_CONFIG_GEN0                                                               0x100b
#define mmCC_GC_SHADER_ARRAY_CONFIG_GEN0_BASE_IDX                                                      0
#define mmGFX_PIPE_CONTROL                                                                             0x100d
#define mmGFX_PIPE_CONTROL_BASE_IDX                                                                    0
#define mmCC_GC_SHADER_ARRAY_CONFIG                                                                    0x100f
#define mmCC_GC_SHADER_ARRAY_CONFIG_BASE_IDX                                                           0
#define mmGC_USER_SHADER_ARRAY_CONFIG                                                                  0x1010
#define mmGC_USER_SHADER_ARRAY_CONFIG_BASE_IDX                                                         0
#define mmVGT_DMA_PRIMITIVE_TYPE                                                                       0x1011
#define mmVGT_DMA_PRIMITIVE_TYPE_BASE_IDX                                                              0
#define mmVGT_DMA_CONTROL                                                                              0x1012
#define mmVGT_DMA_CONTROL_BASE_IDX                                                                     0
#define mmVGT_DMA_LS_HS_CONFIG                                                                         0x1013
#define mmVGT_DMA_LS_HS_CONFIG_BASE_IDX                                                                0
#define mmVGT_STRMOUT_DELAY                                                                            0x1015
#define mmVGT_STRMOUT_DELAY_BASE_IDX                                                                   0
#define mmWD_BUF_RESOURCE_1                                                                            0x1016
#define mmWD_BUF_RESOURCE_1_BASE_IDX                                                                   0
#define mmWD_BUF_RESOURCE_2                                                                            0x1017
#define mmWD_BUF_RESOURCE_2_BASE_IDX                                                                   0
#define mmPA_CL_CNTL_STATUS                                                                            0x1024
#define mmPA_CL_CNTL_STATUS_BASE_IDX                                                                   0
#define mmPA_CL_ENHANCE                                                                                0x1025
#define mmPA_CL_ENHANCE_BASE_IDX                                                                       0
#define mmPA_SU_CNTL_STATUS                                                                            0x1034
#define mmPA_SU_CNTL_STATUS_BASE_IDX                                                                   0
#define mmPA_SC_FIFO_DEPTH_CNTL                                                                        0x1035
#define mmPA_SC_FIFO_DEPTH_CNTL_BASE_IDX                                                               0
#define mmPA_SC_P3D_TRAP_SCREEN_HV_LOCK                                                                0x1060
#define mmPA_SC_P3D_TRAP_SCREEN_HV_LOCK_BASE_IDX                                                       0
#define mmPA_SC_HP3D_TRAP_SCREEN_HV_LOCK                                                               0x1061
#define mmPA_SC_HP3D_TRAP_SCREEN_HV_LOCK_BASE_IDX                                                      0
#define mmPA_SC_TRAP_SCREEN_HV_LOCK                                                                    0x1062
#define mmPA_SC_TRAP_SCREEN_HV_LOCK_BASE_IDX                                                           0
#define mmPA_SC_FORCE_EOV_MAX_CNTS                                                                     0x1069
#define mmPA_SC_FORCE_EOV_MAX_CNTS_BASE_IDX                                                            0
#define mmPA_SC_BINNER_EVENT_CNTL_0                                                                    0x106c
#define mmPA_SC_BINNER_EVENT_CNTL_0_BASE_IDX                                                           0
#define mmPA_SC_BINNER_EVENT_CNTL_1                                                                    0x106d
#define mmPA_SC_BINNER_EVENT_CNTL_1_BASE_IDX                                                           0
#define mmPA_SC_BINNER_EVENT_CNTL_2                                                                    0x106e
#define mmPA_SC_BINNER_EVENT_CNTL_2_BASE_IDX                                                           0
#define mmPA_SC_BINNER_EVENT_CNTL_3                                                                    0x106f
#define mmPA_SC_BINNER_EVENT_CNTL_3_BASE_IDX                                                           0
#define mmPA_SC_BINNER_TIMEOUT_COUNTER                                                                 0x1070
#define mmPA_SC_BINNER_TIMEOUT_COUNTER_BASE_IDX                                                        0
#define mmPA_SC_BINNER_PERF_CNTL_0                                                                     0x1071
#define mmPA_SC_BINNER_PERF_CNTL_0_BASE_IDX                                                            0
#define mmPA_SC_BINNER_PERF_CNTL_1                                                                     0x1072
#define mmPA_SC_BINNER_PERF_CNTL_1_BASE_IDX                                                            0
#define mmPA_SC_BINNER_PERF_CNTL_2                                                                     0x1073
#define mmPA_SC_BINNER_PERF_CNTL_2_BASE_IDX                                                            0
#define mmPA_SC_BINNER_PERF_CNTL_3                                                                     0x1074
#define mmPA_SC_BINNER_PERF_CNTL_3_BASE_IDX                                                            0
#define mmPA_SC_ENHANCE_2                                                                              0x107c
#define mmPA_SC_ENHANCE_2_BASE_IDX                                                                     0
#define mmPA_SC_ENHANCE_INTERNAL                                                                       0x107d
#define mmPA_SC_ENHANCE_INTERNAL_BASE_IDX                                                              0
#define mmPA_SC_BINNER_CNTL_OVERRIDE                                                                   0x107e
#define mmPA_SC_BINNER_CNTL_OVERRIDE_BASE_IDX                                                          0
#define mmPA_SC_PBB_OVERRIDE_FLAG                                                                      0x107f
#define mmPA_SC_PBB_OVERRIDE_FLAG_BASE_IDX                                                             0
#define mmPA_PH_INTERFACE_FIFO_SIZE                                                                    0x1080
#define mmPA_PH_INTERFACE_FIFO_SIZE_BASE_IDX                                                           0
#define mmPA_PH_ENHANCE                                                                                0x1081
#define mmPA_PH_ENHANCE_BASE_IDX                                                                       0
#define mmPA_SC_BC_WAVE_BREAK                                                                          0x1084
#define mmPA_SC_BC_WAVE_BREAK_BASE_IDX                                                                 0
#define mmPA_SC_ENHANCE_3                                                                              0x1085
#define mmPA_SC_ENHANCE_3_BASE_IDX                                                                     0
#define mmPA_SC_FIFO_SIZE                                                                              0x1093
#define mmPA_SC_FIFO_SIZE_BASE_IDX                                                                     0
#define mmPA_SC_IF_FIFO_SIZE                                                                           0x1095
#define mmPA_SC_IF_FIFO_SIZE_BASE_IDX                                                                  0
#define mmPA_SC_PKR_WAVE_TABLE_CNTL                                                                    0x1098
#define mmPA_SC_PKR_WAVE_TABLE_CNTL_BASE_IDX                                                           0
#define mmPA_SIDEBAND_REQUEST_DELAYS                                                                   0x109b
#define mmPA_SIDEBAND_REQUEST_DELAYS_BASE_IDX                                                          0
#define mmPA_SC_ENHANCE                                                                                0x109c
#define mmPA_SC_ENHANCE_BASE_IDX                                                                       0
#define mmPA_SC_ENHANCE_1                                                                              0x109d
#define mmPA_SC_ENHANCE_1_BASE_IDX                                                                     0
#define mmPA_SC_DSM_CNTL                                                                               0x109e
#define mmPA_SC_DSM_CNTL_BASE_IDX                                                                      0
#define mmPA_SC_TILE_STEERING_CREST_OVERRIDE                                                           0x109f
#define mmPA_SC_TILE_STEERING_CREST_OVERRIDE_BASE_IDX                                                  0


// addressBlock: gc_sqdec
// base address: 0x8c00
#define mmSQ_CONFIG                                                                                    0x10a0
#define mmSQ_CONFIG_BASE_IDX                                                                           0
#define mmSQC_CONFIG                                                                                   0x10a1
#define mmSQC_CONFIG_BASE_IDX                                                                          0
#define mmLDS_CONFIG                                                                                   0x10a2
#define mmLDS_CONFIG_BASE_IDX                                                                          0
#define mmSQ_RANDOM_WAVE_PRI                                                                           0x10a3
#define mmSQ_RANDOM_WAVE_PRI_BASE_IDX                                                                  0
#define mmSQG_STATUS                                                                                   0x10a4
#define mmSQG_STATUS_BASE_IDX                                                                          0
#define mmSQ_FIFO_SIZES                                                                                0x10a5
#define mmSQ_FIFO_SIZES_BASE_IDX                                                                       0
#define mmSQ_DSM_CNTL                                                                                  0x10a6
#define mmSQ_DSM_CNTL_BASE_IDX                                                                         0
#define mmSQ_DSM_CNTL2                                                                                 0x10a7
#define mmSQ_DSM_CNTL2_BASE_IDX                                                                        0
#define mmSQ_RUNTIME_CONFIG                                                                            0x10a8
#define mmSQ_RUNTIME_CONFIG_BASE_IDX                                                                   0
#define mmSH_MEM_BASES                                                                                 0x10aa
#define mmSH_MEM_BASES_BASE_IDX                                                                        0
#define mmSP_CONFIG                                                                                    0x10ab
#define mmSP_CONFIG_BASE_IDX                                                                           0
#define mmSQ_ARB_CONFIG                                                                                0x10ac
#define mmSQ_ARB_CONFIG_BASE_IDX                                                                       0
#define mmSH_MEM_CONFIG                                                                                0x10ad
#define mmSH_MEM_CONFIG_BASE_IDX                                                                       0
#define mmSQ_SHADER_TBA_LO                                                                             0x10b2
#define mmSQ_SHADER_TBA_LO_BASE_IDX                                                                    0
#define mmSQ_SHADER_TBA_HI                                                                             0x10b3
#define mmSQ_SHADER_TBA_HI_BASE_IDX                                                                    0
#define mmSQ_SHADER_TMA_LO                                                                             0x10b4
#define mmSQ_SHADER_TMA_LO_BASE_IDX                                                                    0
#define mmSQ_SHADER_TMA_HI                                                                             0x10b5
#define mmSQ_SHADER_TMA_HI_BASE_IDX                                                                    0
#define mmSQG_UTCL0_CNTL1                                                                              0x10b7
#define mmSQG_UTCL0_CNTL1_BASE_IDX                                                                     0
#define mmSQG_UTCL0_CNTL2                                                                              0x10b8
#define mmSQG_UTCL0_CNTL2_BASE_IDX                                                                     0
#define mmSQG_UTCL0_STATUS                                                                             0x10b9
#define mmSQG_UTCL0_STATUS_BASE_IDX                                                                    0
#define mmSQG_CONFIG                                                                                   0x10ba
#define mmSQG_CONFIG_BASE_IDX                                                                          0
#define mmCC_GC_SHADER_RATE_CONFIG                                                                     0x10bc
#define mmCC_GC_SHADER_RATE_CONFIG_BASE_IDX                                                            0
#define mmGC_USER_SHADER_RATE_CONFIG                                                                   0x10bd
#define mmGC_USER_SHADER_RATE_CONFIG_BASE_IDX                                                          0
#define mmSQ_INTERRUPT_AUTO_MASK                                                                       0x10be
#define mmSQ_INTERRUPT_AUTO_MASK_BASE_IDX                                                              0
#define mmSQ_INTERRUPT_MSG_CTRL                                                                        0x10bf
#define mmSQ_INTERRUPT_MSG_CTRL_BASE_IDX                                                               0
#define mmSQ_WATCH0_ADDR_H                                                                             0x10d0
#define mmSQ_WATCH0_ADDR_H_BASE_IDX                                                                    0
#define mmSQ_WATCH0_ADDR_L                                                                             0x10d1
#define mmSQ_WATCH0_ADDR_L_BASE_IDX                                                                    0
#define mmSQ_WATCH0_CNTL                                                                               0x10d2
#define mmSQ_WATCH0_CNTL_BASE_IDX                                                                      0
#define mmSQ_WATCH1_ADDR_H                                                                             0x10d3
#define mmSQ_WATCH1_ADDR_H_BASE_IDX                                                                    0
#define mmSQ_WATCH1_ADDR_L                                                                             0x10d4
#define mmSQ_WATCH1_ADDR_L_BASE_IDX                                                                    0
#define mmSQ_WATCH1_CNTL                                                                               0x10d5
#define mmSQ_WATCH1_CNTL_BASE_IDX                                                                      0
#define mmSQ_WATCH2_ADDR_H                                                                             0x10d6
#define mmSQ_WATCH2_ADDR_H_BASE_IDX                                                                    0
#define mmSQ_WATCH2_ADDR_L                                                                             0x10d7
#define mmSQ_WATCH2_ADDR_L_BASE_IDX                                                                    0
#define mmSQ_WATCH2_CNTL                                                                               0x10d8
#define mmSQ_WATCH2_CNTL_BASE_IDX                                                                      0
#define mmSQ_WATCH3_ADDR_H                                                                             0x10d9
#define mmSQ_WATCH3_ADDR_H_BASE_IDX                                                                    0
#define mmSQ_WATCH3_ADDR_L                                                                             0x10da
#define mmSQ_WATCH3_ADDR_L_BASE_IDX                                                                    0
#define mmSQ_WATCH3_CNTL                                                                               0x10db
#define mmSQ_WATCH3_CNTL_BASE_IDX                                                                      0
#define mmSQ_THREAD_TRACE_BUF0_BASE                                                                    0x10e0
#define mmSQ_THREAD_TRACE_BUF0_BASE_BASE_IDX                                                           0
#define mmSQ_THREAD_TRACE_BUF0_SIZE                                                                    0x10e1
#define mmSQ_THREAD_TRACE_BUF0_SIZE_BASE_IDX                                                           0
#define mmSQ_THREAD_TRACE_BUF1_BASE                                                                    0x10e2
#define mmSQ_THREAD_TRACE_BUF1_BASE_BASE_IDX                                                           0
#define mmSQ_THREAD_TRACE_BUF1_SIZE                                                                    0x10e3
#define mmSQ_THREAD_TRACE_BUF1_SIZE_BASE_IDX                                                           0
#define mmSQ_THREAD_TRACE_WPTR                                                                         0x10e4
#define mmSQ_THREAD_TRACE_WPTR_BASE_IDX                                                                0
#define mmSQ_THREAD_TRACE_MASK                                                                         0x10e5
#define mmSQ_THREAD_TRACE_MASK_BASE_IDX                                                                0
#define mmSQ_THREAD_TRACE_TOKEN_MASK                                                                   0x10e6
#define mmSQ_THREAD_TRACE_TOKEN_MASK_BASE_IDX                                                          0
#define mmSQ_THREAD_TRACE_CTRL                                                                         0x10e7
#define mmSQ_THREAD_TRACE_CTRL_BASE_IDX                                                                0
#define mmSQ_THREAD_TRACE_STATUS                                                                       0x10e8
#define mmSQ_THREAD_TRACE_STATUS_BASE_IDX                                                              0
#define mmSQ_THREAD_TRACE_DROPPED_CNTR                                                                 0x10e9
#define mmSQ_THREAD_TRACE_DROPPED_CNTR_BASE_IDX                                                        0
#define mmSQ_THREAD_TRACE_GFX_DRAW_CNTR                                                                0x10eb
#define mmSQ_THREAD_TRACE_GFX_DRAW_CNTR_BASE_IDX                                                       0
#define mmSQ_THREAD_TRACE_GFX_MARKER_CNTR                                                              0x10ec
#define mmSQ_THREAD_TRACE_GFX_MARKER_CNTR_BASE_IDX                                                     0
#define mmSQ_THREAD_TRACE_HP3D_DRAW_CNTR                                                               0x10ed
#define mmSQ_THREAD_TRACE_HP3D_DRAW_CNTR_BASE_IDX                                                      0
#define mmSQ_THREAD_TRACE_HP3D_MARKER_CNTR                                                             0x10ee
#define mmSQ_THREAD_TRACE_HP3D_MARKER_CNTR_BASE_IDX                                                    0
#define mmSQ_THREAD_TRACE_STATUS2                                                                      0x10ef
#define mmSQ_THREAD_TRACE_STATUS2_BASE_IDX                                                             0
#define mmSQ_IND_INDEX                                                                                 0x1118
#define mmSQ_IND_INDEX_BASE_IDX                                                                        0
#define mmSQ_IND_DATA                                                                                  0x1119
#define mmSQ_IND_DATA_BASE_IDX                                                                         0
#define mmSQ_CMD                                                                                       0x111b
#define mmSQ_CMD_BASE_IDX                                                                              0
#define mmSQ_TIME_HI                                                                                   0x111c
#define mmSQ_TIME_HI_BASE_IDX                                                                          0
#define mmSQ_TIME_LO                                                                                   0x111d
#define mmSQ_TIME_LO_BASE_IDX                                                                          0
#define mmSQ_LB_CTR_CTRL                                                                               0x1138
#define mmSQ_LB_CTR_CTRL_BASE_IDX                                                                      0
#define mmSQ_LB_DATA0                                                                                  0x1139
#define mmSQ_LB_DATA0_BASE_IDX                                                                         0
#define mmSQ_LB_DATA1                                                                                  0x113a
#define mmSQ_LB_DATA1_BASE_IDX                                                                         0
#define mmSQ_LB_DATA2                                                                                  0x113b
#define mmSQ_LB_DATA2_BASE_IDX                                                                         0
#define mmSQ_LB_DATA3                                                                                  0x113c
#define mmSQ_LB_DATA3_BASE_IDX                                                                         0
#define mmSQ_LB_CTR_SEL0                                                                               0x113d
#define mmSQ_LB_CTR_SEL0_BASE_IDX                                                                      0
#define mmSQ_LB_CTR_SEL1                                                                               0x113e
#define mmSQ_LB_CTR_SEL1_BASE_IDX                                                                      0
#define mmSQ_EDC_CNT                                                                                   0x1146
#define mmSQ_EDC_CNT_BASE_IDX                                                                          0
#define mmSQ_EDC_FUE_CNTL                                                                              0x1147
#define mmSQ_EDC_FUE_CNTL_BASE_IDX                                                                     0
#define mmSQ_WREXEC_EXEC_HI                                                                            0x1151
#define mmSQ_WREXEC_EXEC_HI_BASE_IDX                                                                   0
#define mmSQ_WREXEC_EXEC_LO                                                                            0x1151
#define mmSQ_WREXEC_EXEC_LO_BASE_IDX                                                                   0
#define mmSQC_ICACHE_UTCL0_CNTL1                                                                       0x1173
#define mmSQC_ICACHE_UTCL0_CNTL1_BASE_IDX                                                              0
#define mmSQC_ICACHE_UTCL0_CNTL2                                                                       0x1174
#define mmSQC_ICACHE_UTCL0_CNTL2_BASE_IDX                                                              0
#define mmSQC_DCACHE_UTCL0_CNTL1                                                                       0x1175
#define mmSQC_DCACHE_UTCL0_CNTL1_BASE_IDX                                                              0
#define mmSQC_DCACHE_UTCL0_CNTL2                                                                       0x1176
#define mmSQC_DCACHE_UTCL0_CNTL2_BASE_IDX                                                              0
#define mmSQC_ICACHE_UTCL0_STATUS                                                                      0x1177
#define mmSQC_ICACHE_UTCL0_STATUS_BASE_IDX                                                             0
#define mmSQC_DCACHE_UTCL0_STATUS                                                                      0x1178
#define mmSQC_DCACHE_UTCL0_STATUS_BASE_IDX                                                             0


// addressBlock: gc_shsdec
// base address: 0x9000
#define mmSX_DEBUG_1                                                                                   0x11b8
#define mmSX_DEBUG_1_BASE_IDX                                                                          0
#define mmSPI_PS_MAX_WAVE_ID                                                                           0x11da
#define mmSPI_PS_MAX_WAVE_ID_BASE_IDX                                                                  0
#define mmSPI_START_PHASE                                                                              0x11db
#define mmSPI_START_PHASE_BASE_IDX                                                                     0
#define mmSPI_GFX_CNTL                                                                                 0x11dc
#define mmSPI_GFX_CNTL_BASE_IDX                                                                        0
#define mmSPI_DSM_CNTL                                                                                 0x11e3
#define mmSPI_DSM_CNTL_BASE_IDX                                                                        0
#define mmSPI_DSM_CNTL2                                                                                0x11e4
#define mmSPI_DSM_CNTL2_BASE_IDX                                                                       0
#define mmSPI_EDC_CNT                                                                                  0x11e5
#define mmSPI_EDC_CNT_BASE_IDX                                                                         0
#define mmSPI_USER_ACCUM_VMID_CNTL                                                                     0x11eb
#define mmSPI_USER_ACCUM_VMID_CNTL_BASE_IDX                                                            0
#define mmSPI_CONFIG_CNTL                                                                              0x11ec
#define mmSPI_CONFIG_CNTL_BASE_IDX                                                                     0
#define mmSPI_WAVE_LIMIT_CNTL                                                                          0x11ed
#define mmSPI_WAVE_LIMIT_CNTL_BASE_IDX                                                                 0
#define mmSPI_CONFIG_CNTL_2                                                                            0x11ee
#define mmSPI_CONFIG_CNTL_2_BASE_IDX                                                                   0
#define mmSPI_CONFIG_CNTL_1                                                                            0x11ef
#define mmSPI_CONFIG_CNTL_1_BASE_IDX                                                                   0
#define mmSPI_CONFIG_PS_CU_EN                                                                          0x11f2
#define mmSPI_CONFIG_PS_CU_EN_BASE_IDX                                                                 0
#define mmSPI_WF_LIFETIME_CNTL                                                                         0x124a
#define mmSPI_WF_LIFETIME_CNTL_BASE_IDX                                                                0
#define mmSPI_WF_LIFETIME_LIMIT_0                                                                      0x124b
#define mmSPI_WF_LIFETIME_LIMIT_0_BASE_IDX                                                             0
#define mmSPI_WF_LIFETIME_LIMIT_1                                                                      0x124c
#define mmSPI_WF_LIFETIME_LIMIT_1_BASE_IDX                                                             0
#define mmSPI_WF_LIFETIME_LIMIT_2                                                                      0x124d
#define mmSPI_WF_LIFETIME_LIMIT_2_BASE_IDX                                                             0
#define mmSPI_WF_LIFETIME_LIMIT_3                                                                      0x124e
#define mmSPI_WF_LIFETIME_LIMIT_3_BASE_IDX                                                             0
#define mmSPI_WF_LIFETIME_LIMIT_4                                                                      0x124f
#define mmSPI_WF_LIFETIME_LIMIT_4_BASE_IDX                                                             0
#define mmSPI_WF_LIFETIME_LIMIT_5                                                                      0x1250
#define mmSPI_WF_LIFETIME_LIMIT_5_BASE_IDX                                                             0
#define mmSPI_WF_LIFETIME_STATUS_0                                                                     0x1255
#define mmSPI_WF_LIFETIME_STATUS_0_BASE_IDX                                                            0
#define mmSPI_WF_LIFETIME_STATUS_1                                                                     0x1256
#define mmSPI_WF_LIFETIME_STATUS_1_BASE_IDX                                                            0
#define mmSPI_WF_LIFETIME_STATUS_2                                                                     0x1257
#define mmSPI_WF_LIFETIME_STATUS_2_BASE_IDX                                                            0
#define mmSPI_WF_LIFETIME_STATUS_4                                                                     0x1259
#define mmSPI_WF_LIFETIME_STATUS_4_BASE_IDX                                                            0
#define mmSPI_WF_LIFETIME_STATUS_6                                                                     0x125b
#define mmSPI_WF_LIFETIME_STATUS_6_BASE_IDX                                                            0
#define mmSPI_WF_LIFETIME_STATUS_7                                                                     0x125c
#define mmSPI_WF_LIFETIME_STATUS_7_BASE_IDX                                                            0
#define mmSPI_WF_LIFETIME_STATUS_8                                                                     0x125d
#define mmSPI_WF_LIFETIME_STATUS_8_BASE_IDX                                                            0
#define mmSPI_WF_LIFETIME_STATUS_9                                                                     0x125e
#define mmSPI_WF_LIFETIME_STATUS_9_BASE_IDX                                                            0
#define mmSPI_WF_LIFETIME_STATUS_11                                                                    0x1260
#define mmSPI_WF_LIFETIME_STATUS_11_BASE_IDX                                                           0
#define mmSPI_WF_LIFETIME_STATUS_13                                                                    0x1262
#define mmSPI_WF_LIFETIME_STATUS_13_BASE_IDX                                                           0
#define mmSPI_WF_LIFETIME_STATUS_14                                                                    0x1263
#define mmSPI_WF_LIFETIME_STATUS_14_BASE_IDX                                                           0
#define mmSPI_WF_LIFETIME_STATUS_15                                                                    0x1264
#define mmSPI_WF_LIFETIME_STATUS_15_BASE_IDX                                                           0
#define mmSPI_WF_LIFETIME_STATUS_16                                                                    0x1265
#define mmSPI_WF_LIFETIME_STATUS_16_BASE_IDX                                                           0
#define mmSPI_WF_LIFETIME_STATUS_17                                                                    0x1266
#define mmSPI_WF_LIFETIME_STATUS_17_BASE_IDX                                                           0
#define mmSPI_WF_LIFETIME_STATUS_18                                                                    0x1267
#define mmSPI_WF_LIFETIME_STATUS_18_BASE_IDX                                                           0
#define mmSPI_WF_LIFETIME_STATUS_19                                                                    0x1268
#define mmSPI_WF_LIFETIME_STATUS_19_BASE_IDX                                                           0
#define mmSPI_WF_LIFETIME_STATUS_20                                                                    0x1269
#define mmSPI_WF_LIFETIME_STATUS_20_BASE_IDX                                                           0
#define mmSPI_WF_LIFETIME_STATUS_21                                                                    0x126b
#define mmSPI_WF_LIFETIME_STATUS_21_BASE_IDX                                                           0
#define mmSPI_LB_CTR_CTRL                                                                              0x1274
#define mmSPI_LB_CTR_CTRL_BASE_IDX                                                                     0
#define mmSPI_LB_WGP_MASK                                                                              0x1275
#define mmSPI_LB_WGP_MASK_BASE_IDX                                                                     0
#define mmSPI_LB_DATA_REG                                                                              0x1276
#define mmSPI_LB_DATA_REG_BASE_IDX                                                                     0
#define mmSPI_PG_ENABLE_STATIC_WGP_MASK                                                                0x1277
#define mmSPI_PG_ENABLE_STATIC_WGP_MASK_BASE_IDX                                                       0
#define mmSPI_GDS_CREDITS                                                                              0x1278
#define mmSPI_GDS_CREDITS_BASE_IDX                                                                     0
#define mmSPI_SX_EXPORT_BUFFER_SIZES                                                                   0x1279
#define mmSPI_SX_EXPORT_BUFFER_SIZES_BASE_IDX                                                          0
#define mmSPI_SX_SCOREBOARD_BUFFER_SIZES                                                               0x127a
#define mmSPI_SX_SCOREBOARD_BUFFER_SIZES_BASE_IDX                                                      0
#define mmSPI_CSQ_WF_ACTIVE_STATUS                                                                     0x127b
#define mmSPI_CSQ_WF_ACTIVE_STATUS_BASE_IDX                                                            0
#define mmSPI_CSQ_WF_ACTIVE_COUNT_0                                                                    0x127c
#define mmSPI_CSQ_WF_ACTIVE_COUNT_0_BASE_IDX                                                           0
#define mmSPI_CSQ_WF_ACTIVE_COUNT_1                                                                    0x127d
#define mmSPI_CSQ_WF_ACTIVE_COUNT_1_BASE_IDX                                                           0
#define mmSPI_CSQ_WF_ACTIVE_COUNT_2                                                                    0x127e
#define mmSPI_CSQ_WF_ACTIVE_COUNT_2_BASE_IDX                                                           0
#define mmSPI_CSQ_WF_ACTIVE_COUNT_3                                                                    0x127f
#define mmSPI_CSQ_WF_ACTIVE_COUNT_3_BASE_IDX                                                           0
#define mmSPI_LB_DATA_WAVES                                                                            0x1284
#define mmSPI_LB_DATA_WAVES_BASE_IDX                                                                   0
#define mmSPI_LB_DATA_PERWGP_WAVE_HSGS                                                                 0x1285
#define mmSPI_LB_DATA_PERWGP_WAVE_HSGS_BASE_IDX                                                        0
#define mmSPI_LB_DATA_PERWGP_WAVE_VSPS                                                                 0x1286
#define mmSPI_LB_DATA_PERWGP_WAVE_VSPS_BASE_IDX                                                        0
#define mmSPI_LB_DATA_PERWGP_WAVE_CS                                                                   0x1287
#define mmSPI_LB_DATA_PERWGP_WAVE_CS_BASE_IDX                                                          0
#define mmSPI_P0_TRAP_SCREEN_PSBA_LO                                                                   0x128c
#define mmSPI_P0_TRAP_SCREEN_PSBA_LO_BASE_IDX                                                          0
#define mmSPI_P0_TRAP_SCREEN_PSBA_HI                                                                   0x128d
#define mmSPI_P0_TRAP_SCREEN_PSBA_HI_BASE_IDX                                                          0
#define mmSPI_P0_TRAP_SCREEN_PSMA_LO                                                                   0x128e
#define mmSPI_P0_TRAP_SCREEN_PSMA_LO_BASE_IDX                                                          0
#define mmSPI_P0_TRAP_SCREEN_PSMA_HI                                                                   0x128f
#define mmSPI_P0_TRAP_SCREEN_PSMA_HI_BASE_IDX                                                          0
#define mmSPI_P0_TRAP_SCREEN_GPR_MIN                                                                   0x1290
#define mmSPI_P0_TRAP_SCREEN_GPR_MIN_BASE_IDX                                                          0
#define mmSPI_P1_TRAP_SCREEN_PSBA_LO                                                                   0x1291
#define mmSPI_P1_TRAP_SCREEN_PSBA_LO_BASE_IDX                                                          0
#define mmSPI_P1_TRAP_SCREEN_PSBA_HI                                                                   0x1292
#define mmSPI_P1_TRAP_SCREEN_PSBA_HI_BASE_IDX                                                          0
#define mmSPI_P1_TRAP_SCREEN_PSMA_LO                                                                   0x1293
#define mmSPI_P1_TRAP_SCREEN_PSMA_LO_BASE_IDX                                                          0
#define mmSPI_P1_TRAP_SCREEN_PSMA_HI                                                                   0x1294
#define mmSPI_P1_TRAP_SCREEN_PSMA_HI_BASE_IDX                                                          0
#define mmSPI_P1_TRAP_SCREEN_GPR_MIN                                                                   0x1295
#define mmSPI_P1_TRAP_SCREEN_GPR_MIN_BASE_IDX                                                          0


// addressBlock: gc_tpdec
// base address: 0x9400
#define mmTD_STATUS                                                                                    0x12c6
#define mmTD_STATUS_BASE_IDX                                                                           0
#define mmTD_DSM_CNTL                                                                                  0x12cf
#define mmTD_DSM_CNTL_BASE_IDX                                                                         0
#define mmTD_DSM_CNTL2                                                                                 0x12d0
#define mmTD_DSM_CNTL2_BASE_IDX                                                                        0
#define mmTD_SCRATCH                                                                                   0x12d3
#define mmTD_SCRATCH_BASE_IDX                                                                          0
#define mmTA_CNTL                                                                                      0x12e1
#define mmTA_CNTL_BASE_IDX                                                                             0
#define mmTA_RESERVED_010C                                                                             0x12e3
#define mmTA_RESERVED_010C_BASE_IDX                                                                    0
#define mmTA_STATUS                                                                                    0x12e8
#define mmTA_STATUS_BASE_IDX                                                                           0
#define mmTA_SCRATCH                                                                                   0x1304
#define mmTA_SCRATCH_BASE_IDX                                                                          0


// addressBlock: gc_gdsdec
// base address: 0x9700
#define mmGDS_CONFIG                                                                                   0x1360
#define mmGDS_CONFIG_BASE_IDX                                                                          0
#define mmGDS_CNTL_STATUS                                                                              0x1361
#define mmGDS_CNTL_STATUS_BASE_IDX                                                                     0
#define mmGDS_ENHANCE                                                                                  0x1362
#define mmGDS_ENHANCE_BASE_IDX                                                                         0
#define mmGDS_PROTECTION_FAULT                                                                         0x1363
#define mmGDS_PROTECTION_FAULT_BASE_IDX                                                                0
#define mmGDS_VM_PROTECTION_FAULT                                                                      0x1364
#define mmGDS_VM_PROTECTION_FAULT_BASE_IDX                                                             0
#define mmGDS_EDC_CNT                                                                                  0x1365
#define mmGDS_EDC_CNT_BASE_IDX                                                                         0
#define mmGDS_EDC_GRBM_CNT                                                                             0x1366
#define mmGDS_EDC_GRBM_CNT_BASE_IDX                                                                    0
#define mmGDS_EDC_OA_DED                                                                               0x1367
#define mmGDS_EDC_OA_DED_BASE_IDX                                                                      0
#define mmGDS_DSM_CNTL                                                                                 0x136a
#define mmGDS_DSM_CNTL_BASE_IDX                                                                        0
#define mmGDS_EDC_OA_PHY_CNT                                                                           0x136b
#define mmGDS_EDC_OA_PHY_CNT_BASE_IDX                                                                  0
#define mmGDS_EDC_OA_PIPE_CNT                                                                          0x136c
#define mmGDS_EDC_OA_PIPE_CNT_BASE_IDX                                                                 0
#define mmGDS_DSM_CNTL2                                                                                0x136d
#define mmGDS_DSM_CNTL2_BASE_IDX                                                                       0
#define mmGDS_WD_GDS_CSB                                                                               0x136e
#define mmGDS_WD_GDS_CSB_BASE_IDX                                                                      0


// addressBlock: gc_rbdec
// base address: 0x9800
#define mmDB_DEBUG                                                                                     0x13ac
#define mmDB_DEBUG_BASE_IDX                                                                            0
#define mmDB_DEBUG2                                                                                    0x13ad
#define mmDB_DEBUG2_BASE_IDX                                                                           0
#define mmDB_DEBUG3                                                                                    0x13ae
#define mmDB_DEBUG3_BASE_IDX                                                                           0
#define mmDB_DEBUG4                                                                                    0x13af
#define mmDB_DEBUG4_BASE_IDX                                                                           0
#define mmDB_ETILE_STUTTER_CONTROL                                                                     0x13b0
#define mmDB_ETILE_STUTTER_CONTROL_BASE_IDX                                                            0
#define mmDB_LTILE_STUTTER_CONTROL                                                                     0x13b1
#define mmDB_LTILE_STUTTER_CONTROL_BASE_IDX                                                            0
#define mmDB_EQUAD_STUTTER_CONTROL                                                                     0x13b2
#define mmDB_EQUAD_STUTTER_CONTROL_BASE_IDX                                                            0
#define mmDB_LQUAD_STUTTER_CONTROL                                                                     0x13b3
#define mmDB_LQUAD_STUTTER_CONTROL_BASE_IDX                                                            0
#define mmDB_CREDIT_LIMIT                                                                              0x13b4
#define mmDB_CREDIT_LIMIT_BASE_IDX                                                                     0
#define mmDB_WATERMARKS                                                                                0x13b5
#define mmDB_WATERMARKS_BASE_IDX                                                                       0
#define mmDB_SUBTILE_CONTROL                                                                           0x13b6
#define mmDB_SUBTILE_CONTROL_BASE_IDX                                                                  0
#define mmDB_FREE_CACHELINES                                                                           0x13b7
#define mmDB_FREE_CACHELINES_BASE_IDX                                                                  0
#define mmDB_FIFO_DEPTH1                                                                               0x13b8
#define mmDB_FIFO_DEPTH1_BASE_IDX                                                                      0
#define mmDB_FIFO_DEPTH2                                                                               0x13b9
#define mmDB_FIFO_DEPTH2_BASE_IDX                                                                      0
#define mmDB_LAST_OF_BURST_CONFIG                                                                      0x13ba
#define mmDB_LAST_OF_BURST_CONFIG_BASE_IDX                                                             0
#define mmDB_RING_CONTROL                                                                              0x13bb
#define mmDB_RING_CONTROL_BASE_IDX                                                                     0
#define mmDB_MEM_ARB_WATERMARKS                                                                        0x13bc
#define mmDB_MEM_ARB_WATERMARKS_BASE_IDX                                                               0
#define mmDB_FIFO_DEPTH3                                                                               0x13bd
#define mmDB_FIFO_DEPTH3_BASE_IDX                                                                      0
#define mmDB_RMI_BC_GL2_CACHE_CONTROL                                                                  0x13be
#define mmDB_RMI_BC_GL2_CACHE_CONTROL_BASE_IDX                                                         0
#define mmDB_EXCEPTION_CONTROL                                                                         0x13bf
#define mmDB_EXCEPTION_CONTROL_BASE_IDX                                                                0
#define mmDB_DFSM_CONFIG                                                                               0x13d0
#define mmDB_DFSM_CONFIG_BASE_IDX                                                                      0
#define mmDB_DEBUG5                                                                                    0x13d1
#define mmDB_DEBUG5_BASE_IDX                                                                           0
#define mmDB_DFSM_TILES_IN_FLIGHT                                                                      0x13d2
#define mmDB_DFSM_TILES_IN_FLIGHT_BASE_IDX                                                             0
#define mmDB_DFSM_PRIMS_IN_FLIGHT                                                                      0x13d3
#define mmDB_DFSM_PRIMS_IN_FLIGHT_BASE_IDX                                                             0
#define mmDB_DFSM_WATCHDOG                                                                             0x13d4
#define mmDB_DFSM_WATCHDOG_BASE_IDX                                                                    0
#define mmDB_DFSM_FLUSH_ENABLE                                                                         0x13d5
#define mmDB_DFSM_FLUSH_ENABLE_BASE_IDX                                                                0
#define mmDB_DFSM_FLUSH_AUX_EVENT                                                                      0x13d6
#define mmDB_DFSM_FLUSH_AUX_EVENT_BASE_IDX                                                             0
#define mmDB_FGCG_SRAMS_CLK_CTRL                                                                       0x13d7
#define mmDB_FGCG_SRAMS_CLK_CTRL_BASE_IDX                                                              0
#define mmDB_FGCG_INTERFACES_CLK_CTRL                                                                  0x13d8
#define mmDB_FGCG_INTERFACES_CLK_CTRL_BASE_IDX                                                         0
#define mmCC_RB_REDUNDANCY                                                                             0x13dc
#define mmCC_RB_REDUNDANCY_BASE_IDX                                                                    0
#define mmCC_RB_BACKEND_DISABLE                                                                        0x13dd
#define mmCC_RB_BACKEND_DISABLE_BASE_IDX                                                               0
#define mmGB_ADDR_CONFIG                                                                               0x13de
#define mmGB_ADDR_CONFIG_BASE_IDX                                                                      0
#define mmGB_BACKEND_MAP                                                                               0x13df
#define mmGB_BACKEND_MAP_BASE_IDX                                                                      0
#define mmGB_GPU_ID                                                                                    0x13e0
#define mmGB_GPU_ID_BASE_IDX                                                                           0
#define mmCC_RB_DAISY_CHAIN                                                                            0x13e1
#define mmCC_RB_DAISY_CHAIN_BASE_IDX                                                                   0
#define mmGB_ADDR_CONFIG_READ                                                                          0x13e2
#define mmGB_ADDR_CONFIG_READ_BASE_IDX                                                                 0
#define mmCB_HW_CONTROL_4                                                                              0x1422
#define mmCB_HW_CONTROL_4_BASE_IDX                                                                     0
#define mmCB_HW_CONTROL_3                                                                              0x1423
#define mmCB_HW_CONTROL_3_BASE_IDX                                                                     0
#define mmCB_HW_CONTROL                                                                                0x1424
#define mmCB_HW_CONTROL_BASE_IDX                                                                       0
#define mmCB_HW_CONTROL_1                                                                              0x1425
#define mmCB_HW_CONTROL_1_BASE_IDX                                                                     0
#define mmCB_HW_CONTROL_2                                                                              0x1426
#define mmCB_HW_CONTROL_2_BASE_IDX                                                                     0
#define mmCB_DCC_CONFIG                                                                                0x1427
#define mmCB_DCC_CONFIG_BASE_IDX                                                                       0
#define mmCB_HW_MEM_ARBITER_RD                                                                         0x1428
#define mmCB_HW_MEM_ARBITER_RD_BASE_IDX                                                                0
#define mmCB_HW_MEM_ARBITER_WR                                                                         0x1429
#define mmCB_HW_MEM_ARBITER_WR_BASE_IDX                                                                0
#define mmCB_RMI_BC_GL2_CACHE_CONTROL                                                                  0x142a
#define mmCB_RMI_BC_GL2_CACHE_CONTROL_BASE_IDX                                                         0
#define mmCB_STUTTER_CONTROL_CMASK_RDLAT                                                               0x142b
#define mmCB_STUTTER_CONTROL_CMASK_RDLAT_BASE_IDX                                                      0
#define mmCB_STUTTER_CONTROL_FMASK_RDLAT                                                               0x142c
#define mmCB_STUTTER_CONTROL_FMASK_RDLAT_BASE_IDX                                                      0
#define mmCB_STUTTER_CONTROL_COLOR_RDLAT                                                               0x142d
#define mmCB_STUTTER_CONTROL_COLOR_RDLAT_BASE_IDX                                                      0
#define mmCB_CACHE_EVICT_POINTS                                                                        0x142e
#define mmCB_CACHE_EVICT_POINTS_BASE_IDX                                                               0
#define mmGC_USER_RB_REDUNDANCY                                                                        0x147e
#define mmGC_USER_RB_REDUNDANCY_BASE_IDX                                                               0
#define mmGC_USER_RB_BACKEND_DISABLE                                                                   0x147f
#define mmGC_USER_RB_BACKEND_DISABLE_BASE_IDX                                                          0


// addressBlock: gc_gceadec2
// base address: 0x9c00
#define mmGCEA_MISC                                                                                    0x14a2
#define mmGCEA_MISC_BASE_IDX                                                                           0
#define mmGCEA_LATENCY_SAMPLING                                                                        0x14a3
#define mmGCEA_LATENCY_SAMPLING_BASE_IDX                                                               0
#define mmGCEA_DSM_CNTL                                                                                0x14b4
#define mmGCEA_DSM_CNTL_BASE_IDX                                                                       0
#define mmGCEA_DSM_CNTLA                                                                               0x14b5
#define mmGCEA_DSM_CNTLA_BASE_IDX                                                                      0
#define mmGCEA_DSM_CNTLB                                                                               0x14b6
#define mmGCEA_DSM_CNTLB_BASE_IDX                                                                      0
#define mmGCEA_DSM_CNTL2                                                                               0x14b7
#define mmGCEA_DSM_CNTL2_BASE_IDX                                                                      0
#define mmGCEA_DSM_CNTL2A                                                                              0x14b8
#define mmGCEA_DSM_CNTL2A_BASE_IDX                                                                     0
#define mmGCEA_DSM_CNTL2B                                                                              0x14b9
#define mmGCEA_DSM_CNTL2B_BASE_IDX                                                                     0
#define mmGCEA_GL2C_XBR_CREDITS                                                                        0x14ba
#define mmGCEA_GL2C_XBR_CREDITS_BASE_IDX                                                               0
#define mmGCEA_GL2C_XBR_MAXBURST                                                                       0x14bb
#define mmGCEA_GL2C_XBR_MAXBURST_BASE_IDX                                                              0
#define mmGCEA_PROBE_CNTL                                                                              0x14bc
#define mmGCEA_PROBE_CNTL_BASE_IDX                                                                     0
#define mmGCEA_PROBE_MAP                                                                               0x14bd
#define mmGCEA_PROBE_MAP_BASE_IDX                                                                      0
#define mmGCEA_ERR_STATUS                                                                              0x14be
#define mmGCEA_ERR_STATUS_BASE_IDX                                                                     0
#define mmGCEA_MISC2                                                                                   0x14bf
#define mmGCEA_MISC2_BASE_IDX                                                                          0


// addressBlock: gc_spipdec2
// base address: 0x9c80
#define mmSPI_PQEV_CTRL                                                                                0x14c0
#define mmSPI_PQEV_CTRL_BASE_IDX                                                                       0
#define mmSPI_EXP_THROTTLE_CTRL                                                                        0x14c3
#define mmSPI_EXP_THROTTLE_CTRL_BASE_IDX                                                               0


// addressBlock: gc_gceadec3
// base address: 0x9dc0
#define mmGCEA_RRET_MEM_RESERVE                                                                        0x1518
#define mmGCEA_RRET_MEM_RESERVE_BASE_IDX                                                               0


// addressBlock: gc_rmi_rmidec
// base address: 0x9e00
#define mmRMI_GENERAL_CNTL                                                                             0x1520
#define mmRMI_GENERAL_CNTL_BASE_IDX                                                                    0
#define mmRMI_GENERAL_CNTL1                                                                            0x1521
#define mmRMI_GENERAL_CNTL1_BASE_IDX                                                                   0
#define mmRMI_GENERAL_STATUS                                                                           0x1522
#define mmRMI_GENERAL_STATUS_BASE_IDX                                                                  0
#define mmRMI_SUBBLOCK_STATUS0                                                                         0x1523
#define mmRMI_SUBBLOCK_STATUS0_BASE_IDX                                                                0
#define mmRMI_SUBBLOCK_STATUS1                                                                         0x1524
#define mmRMI_SUBBLOCK_STATUS1_BASE_IDX                                                                0
#define mmRMI_SUBBLOCK_STATUS2                                                                         0x1525
#define mmRMI_SUBBLOCK_STATUS2_BASE_IDX                                                                0
#define mmRMI_SUBBLOCK_STATUS3                                                                         0x1526
#define mmRMI_SUBBLOCK_STATUS3_BASE_IDX                                                                0
#define mmRMI_XBAR_CONFIG                                                                              0x1527
#define mmRMI_XBAR_CONFIG_BASE_IDX                                                                     0
#define mmRMI_PROBE_POP_LOGIC_CNTL                                                                     0x1528
#define mmRMI_PROBE_POP_LOGIC_CNTL_BASE_IDX                                                            0
#define mmRMI_UTC_XNACK_N_MISC_CNTL                                                                    0x1529
#define mmRMI_UTC_XNACK_N_MISC_CNTL_BASE_IDX                                                           0
#define mmRMI_DEMUX_CNTL                                                                               0x152a
#define mmRMI_DEMUX_CNTL_BASE_IDX                                                                      0
#define mmRMI_UTCL1_CNTL1                                                                              0x152b
#define mmRMI_UTCL1_CNTL1_BASE_IDX                                                                     0
#define mmRMI_UTCL1_CNTL2                                                                              0x152c
#define mmRMI_UTCL1_CNTL2_BASE_IDX                                                                     0
#define mmRMI_UTC_UNIT_CONFIG                                                                          0x152d
#define mmRMI_UTC_UNIT_CONFIG_BASE_IDX                                                                 0
#define mmRMI_TCIW_FORMATTER0_CNTL                                                                     0x152e
#define mmRMI_TCIW_FORMATTER0_CNTL_BASE_IDX                                                            0
#define mmRMI_TCIW_FORMATTER1_CNTL                                                                     0x152f
#define mmRMI_TCIW_FORMATTER1_CNTL_BASE_IDX                                                            0
#define mmRMI_SCOREBOARD_CNTL                                                                          0x1530
#define mmRMI_SCOREBOARD_CNTL_BASE_IDX                                                                 0
#define mmRMI_SCOREBOARD_STATUS0                                                                       0x1531
#define mmRMI_SCOREBOARD_STATUS0_BASE_IDX                                                              0
#define mmRMI_SCOREBOARD_STATUS1                                                                       0x1532
#define mmRMI_SCOREBOARD_STATUS1_BASE_IDX                                                              0
#define mmRMI_SCOREBOARD_STATUS2                                                                       0x1533
#define mmRMI_SCOREBOARD_STATUS2_BASE_IDX                                                              0
#define mmRMI_XBAR_ARBITER_CONFIG                                                                      0x1534
#define mmRMI_XBAR_ARBITER_CONFIG_BASE_IDX                                                             0
#define mmRMI_XBAR_ARBITER_CONFIG_1                                                                    0x1535
#define mmRMI_XBAR_ARBITER_CONFIG_1_BASE_IDX                                                           0
#define mmRMI_CLOCK_CNTRL                                                                              0x1536
#define mmRMI_CLOCK_CNTRL_BASE_IDX                                                                     0
#define mmRMI_UTCL1_STATUS                                                                             0x1537
#define mmRMI_UTCL1_STATUS_BASE_IDX                                                                    0
#define mmRMI_RB_GLX_CID_MAP                                                                           0x1538
#define mmRMI_RB_GLX_CID_MAP_BASE_IDX                                                                  0
#define mmRMI_SPARE                                                                                    0x153f
#define mmRMI_SPARE_BASE_IDX                                                                           0
#define mmRMI_SPARE_1                                                                                  0x1540
#define mmRMI_SPARE_1_BASE_IDX                                                                         0
#define mmRMI_SPARE_2                                                                                  0x1541
#define mmRMI_SPARE_2_BASE_IDX                                                                         0
#define mmCC_RMI_REDUNDANCY                                                                            0x1542
#define mmCC_RMI_REDUNDANCY_BASE_IDX                                                                   0
#define mmGC_USER_RMI_REDUNDANCY                                                                       0x1543
#define mmGC_USER_RMI_REDUNDANCY_BASE_IDX                                                              0


// addressBlock: gc_dbgu_gfx_dbgudec
// base address: 0x9f00


// addressBlock: gc_pmmdec
// base address: 0x9f80
#define mmGCR_GENERAL_CNTL                                                                             0x1580
#define mmGCR_GENERAL_CNTL_BASE_IDX                                                                    0
#define mmGCR_CMD_STATUS                                                                               0x1582
#define mmGCR_CMD_STATUS_BASE_IDX                                                                      0
#define mmGCR_SPARE                                                                                    0x1583
#define mmGCR_SPARE_BASE_IDX                                                                           0
#define mmPMM_GENERAL_CNTL                                                                             0x1585
#define mmPMM_GENERAL_CNTL_BASE_IDX                                                                    0
#define mmGCR_PIO_CNTL                                                                                 0x1586
#define mmGCR_PIO_CNTL_BASE_IDX                                                                        0
#define mmGCR_PIO_DATA                                                                                 0x1587
#define mmGCR_PIO_DATA_BASE_IDX                                                                        0


// addressBlock: gc_utcl1dec
// base address: 0x9fa0
#define mmUTCL1_CTRL                                                                                   0x1588
#define mmUTCL1_CTRL_BASE_IDX                                                                          0
#define mmUTCL1_ALOG                                                                                   0x1589
#define mmUTCL1_ALOG_BASE_IDX                                                                          0
#define mmUTCL1_UTCL0_INVREQ_DISABLE                                                                   0x158a
#define mmUTCL1_UTCL0_INVREQ_DISABLE_BASE_IDX                                                          0
#define mmGCRD_SA_TARGETS_DISABLE                                                                      0x158b
#define mmGCRD_SA_TARGETS_DISABLE_BASE_IDX                                                             0
#define mmUTCL1_STATUS                                                                                 0x158c
#define mmUTCL1_STATUS_BASE_IDX                                                                        0


// addressBlock: gc_gcvml2pfdec
// base address: 0xa070
#define mmGCVM_L2_CNTL                                                                                 0x15bc
#define mmGCVM_L2_CNTL_BASE_IDX                                                                        0
#define mmGCVM_L2_CNTL2                                                                                0x15bd
#define mmGCVM_L2_CNTL2_BASE_IDX                                                                       0
#define mmGCVM_L2_CNTL3                                                                                0x15be
#define mmGCVM_L2_CNTL3_BASE_IDX                                                                       0
#define mmGCVM_L2_STATUS                                                                               0x15bf
#define mmGCVM_L2_STATUS_BASE_IDX                                                                      0
#define mmGCVM_DUMMY_PAGE_FAULT_CNTL                                                                   0x15c0
#define mmGCVM_DUMMY_PAGE_FAULT_CNTL_BASE_IDX                                                          0
#define mmGCVM_DUMMY_PAGE_FAULT_ADDR_LO32                                                              0x15c1
#define mmGCVM_DUMMY_PAGE_FAULT_ADDR_LO32_BASE_IDX                                                     0
#define mmGCVM_DUMMY_PAGE_FAULT_ADDR_HI32                                                              0x15c2
#define mmGCVM_DUMMY_PAGE_FAULT_ADDR_HI32_BASE_IDX                                                     0
#define mmGCVM_INVALIDATE_CNTL                                                                         0x15c3
#define mmGCVM_INVALIDATE_CNTL_BASE_IDX                                                                0
#define mmGCVM_L2_PROTECTION_FAULT_CNTL                                                                0x15c4
#define mmGCVM_L2_PROTECTION_FAULT_CNTL_BASE_IDX                                                       0
#define mmGCVM_L2_PROTECTION_FAULT_CNTL2                                                               0x15c5
#define mmGCVM_L2_PROTECTION_FAULT_CNTL2_BASE_IDX                                                      0
#define mmGCVM_L2_PROTECTION_FAULT_MM_CNTL3                                                            0x15c6
#define mmGCVM_L2_PROTECTION_FAULT_MM_CNTL3_BASE_IDX                                                   0
#define mmGCVM_L2_PROTECTION_FAULT_MM_CNTL4                                                            0x15c7
#define mmGCVM_L2_PROTECTION_FAULT_MM_CNTL4_BASE_IDX                                                   0
#define mmGCVM_L2_PROTECTION_FAULT_STATUS                                                              0x15c8
#define mmGCVM_L2_PROTECTION_FAULT_STATUS_BASE_IDX                                                     0
#define mmGCVM_L2_PROTECTION_FAULT_ADDR_LO32                                                           0x15c9
#define mmGCVM_L2_PROTECTION_FAULT_ADDR_LO32_BASE_IDX                                                  0
#define mmGCVM_L2_PROTECTION_FAULT_ADDR_HI32                                                           0x15ca
#define mmGCVM_L2_PROTECTION_FAULT_ADDR_HI32_BASE_IDX                                                  0
#define mmGCVM_L2_PROTECTION_FAULT_DEFAULT_ADDR_LO32                                                   0x15cb
#define mmGCVM_L2_PROTECTION_FAULT_DEFAULT_ADDR_LO32_BASE_IDX                                          0
#define mmGCVM_L2_PROTECTION_FAULT_DEFAULT_ADDR_HI32                                                   0x15cc
#define mmGCVM_L2_PROTECTION_FAULT_DEFAULT_ADDR_HI32_BASE_IDX                                          0
#define mmGCVM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR_LO32                                             0x15ce
#define mmGCVM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR_LO32_BASE_IDX                                    0
#define mmGCVM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR_HI32                                             0x15cf
#define mmGCVM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR_HI32_BASE_IDX                                    0
#define mmGCVM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR_LO32                                            0x15d0
#define mmGCVM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR_LO32_BASE_IDX                                   0
#define mmGCVM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR_HI32                                            0x15d1
#define mmGCVM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR_HI32_BASE_IDX                                   0
#define mmGCVM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET_LO32                                                0x15d2
#define mmGCVM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET_LO32_BASE_IDX                                       0
#define mmGCVM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET_HI32                                                0x15d3
#define mmGCVM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET_HI32_BASE_IDX                                       0
#define mmGCVM_L2_CNTL4                                                                                0x15d4
#define mmGCVM_L2_CNTL4_BASE_IDX                                                                       0
#define mmGCVM_L2_MM_GROUP_RT_CLASSES                                                                  0x15d5
#define mmGCVM_L2_MM_GROUP_RT_CLASSES_BASE_IDX                                                         0
#define mmGCVM_L2_BANK_SELECT_RESERVED_CID                                                             0x15d6
#define mmGCVM_L2_BANK_SELECT_RESERVED_CID_BASE_IDX                                                    0
#define mmGCVM_L2_BANK_SELECT_RESERVED_CID2                                                            0x15d7
#define mmGCVM_L2_BANK_SELECT_RESERVED_CID2_BASE_IDX                                                   0
#define mmGCVM_L2_CACHE_PARITY_CNTL                                                                    0x15d8
#define mmGCVM_L2_CACHE_PARITY_CNTL_BASE_IDX                                                           0
#define mmGCVM_L2_CNTL5                                                                                0x15dc
#define mmGCVM_L2_CNTL5_BASE_IDX                                                                       0
#define mmGCVM_L2_GCR_CNTL                                                                             0x15dd
#define mmGCVM_L2_GCR_CNTL_BASE_IDX                                                                    0
#define mmGCVML2_WALKER_MACRO_THROTTLE_TIME                                                            0x15de
#define mmGCVML2_WALKER_MACRO_THROTTLE_TIME_BASE_IDX                                                   0
#define mmGCVML2_WALKER_MACRO_THROTTLE_FETCH_LIMIT                                                     0x15df
#define mmGCVML2_WALKER_MACRO_THROTTLE_FETCH_LIMIT_BASE_IDX                                            0
#define mmGCVML2_WALKER_MICRO_THROTTLE_TIME                                                            0x15e0
#define mmGCVML2_WALKER_MICRO_THROTTLE_TIME_BASE_IDX                                                   0
#define mmGCVML2_WALKER_MICRO_THROTTLE_FETCH_LIMIT                                                     0x15e1
#define mmGCVML2_WALKER_MICRO_THROTTLE_FETCH_LIMIT_BASE_IDX                                            0
#define mmGCVM_L2_PTE_CACHE_DUMP_CNTL                                                                  0x15e3
#define mmGCVM_L2_PTE_CACHE_DUMP_CNTL_BASE_IDX                                                         0
#define mmGCVM_L2_PTE_CACHE_DUMP_READ                                                                  0x15e4
#define mmGCVM_L2_PTE_CACHE_DUMP_READ_BASE_IDX                                                         0


// addressBlock: gc_gcvml2vcdec
// base address: 0xa170
#define mmGCVM_CONTEXT0_CNTL                                                                           0x15fc
#define mmGCVM_CONTEXT0_CNTL_BASE_IDX                                                                  0
#define mmGCVM_CONTEXT1_CNTL                                                                           0x15fd
#define mmGCVM_CONTEXT1_CNTL_BASE_IDX                                                                  0
#define mmGCVM_CONTEXT2_CNTL                                                                           0x15fe
#define mmGCVM_CONTEXT2_CNTL_BASE_IDX                                                                  0
#define mmGCVM_CONTEXT3_CNTL                                                                           0x15ff
#define mmGCVM_CONTEXT3_CNTL_BASE_IDX                                                                  0
#define mmGCVM_CONTEXT4_CNTL                                                                           0x1600
#define mmGCVM_CONTEXT4_CNTL_BASE_IDX                                                                  0
#define mmGCVM_CONTEXT5_CNTL                                                                           0x1601
#define mmGCVM_CONTEXT5_CNTL_BASE_IDX                                                                  0
#define mmGCVM_CONTEXT6_CNTL                                                                           0x1602
#define mmGCVM_CONTEXT6_CNTL_BASE_IDX                                                                  0
#define mmGCVM_CONTEXT7_CNTL                                                                           0x1603
#define mmGCVM_CONTEXT7_CNTL_BASE_IDX                                                                  0
#define mmGCVM_CONTEXT8_CNTL                                                                           0x1604
#define mmGCVM_CONTEXT8_CNTL_BASE_IDX                                                                  0
#define mmGCVM_CONTEXT9_CNTL                                                                           0x1605
#define mmGCVM_CONTEXT9_CNTL_BASE_IDX                                                                  0
#define mmGCVM_CONTEXT10_CNTL                                                                          0x1606
#define mmGCVM_CONTEXT10_CNTL_BASE_IDX                                                                 0
#define mmGCVM_CONTEXT11_CNTL                                                                          0x1607
#define mmGCVM_CONTEXT11_CNTL_BASE_IDX                                                                 0
#define mmGCVM_CONTEXT12_CNTL                                                                          0x1608
#define mmGCVM_CONTEXT12_CNTL_BASE_IDX                                                                 0
#define mmGCVM_CONTEXT13_CNTL                                                                          0x1609
#define mmGCVM_CONTEXT13_CNTL_BASE_IDX                                                                 0
#define mmGCVM_CONTEXT14_CNTL                                                                          0x160a
#define mmGCVM_CONTEXT14_CNTL_BASE_IDX                                                                 0
#define mmGCVM_CONTEXT15_CNTL                                                                          0x160b
#define mmGCVM_CONTEXT15_CNTL_BASE_IDX                                                                 0
#define mmGCVM_CONTEXTS_DISABLE                                                                        0x160c
#define mmGCVM_CONTEXTS_DISABLE_BASE_IDX                                                               0
#define mmGCVM_INVALIDATE_ENG0_SEM                                                                     0x160d
#define mmGCVM_INVALIDATE_ENG0_SEM_BASE_IDX                                                            0
#define mmGCVM_INVALIDATE_ENG1_SEM                                                                     0x160e
#define mmGCVM_INVALIDATE_ENG1_SEM_BASE_IDX                                                            0
#define mmGCVM_INVALIDATE_ENG2_SEM                                                                     0x160f
#define mmGCVM_INVALIDATE_ENG2_SEM_BASE_IDX                                                            0
#define mmGCVM_INVALIDATE_ENG3_SEM                                                                     0x1610
#define mmGCVM_INVALIDATE_ENG3_SEM_BASE_IDX                                                            0
#define mmGCVM_INVALIDATE_ENG4_SEM                                                                     0x1611
#define mmGCVM_INVALIDATE_ENG4_SEM_BASE_IDX                                                            0
#define mmGCVM_INVALIDATE_ENG5_SEM                                                                     0x1612
#define mmGCVM_INVALIDATE_ENG5_SEM_BASE_IDX                                                            0
#define mmGCVM_INVALIDATE_ENG6_SEM                                                                     0x1613
#define mmGCVM_INVALIDATE_ENG6_SEM_BASE_IDX                                                            0
#define mmGCVM_INVALIDATE_ENG7_SEM                                                                     0x1614
#define mmGCVM_INVALIDATE_ENG7_SEM_BASE_IDX                                                            0
#define mmGCVM_INVALIDATE_ENG8_SEM                                                                     0x1615
#define mmGCVM_INVALIDATE_ENG8_SEM_BASE_IDX                                                            0
#define mmGCVM_INVALIDATE_ENG9_SEM                                                                     0x1616
#define mmGCVM_INVALIDATE_ENG9_SEM_BASE_IDX                                                            0
#define mmGCVM_INVALIDATE_ENG10_SEM                                                                    0x1617
#define mmGCVM_INVALIDATE_ENG10_SEM_BASE_IDX                                                           0
#define mmGCVM_INVALIDATE_ENG11_SEM                                                                    0x1618
#define mmGCVM_INVALIDATE_ENG11_SEM_BASE_IDX                                                           0
#define mmGCVM_INVALIDATE_ENG12_SEM                                                                    0x1619
#define mmGCVM_INVALIDATE_ENG12_SEM_BASE_IDX                                                           0
#define mmGCVM_INVALIDATE_ENG13_SEM                                                                    0x161a
#define mmGCVM_INVALIDATE_ENG13_SEM_BASE_IDX                                                           0
#define mmGCVM_INVALIDATE_ENG14_SEM                                                                    0x161b
#define mmGCVM_INVALIDATE_ENG14_SEM_BASE_IDX                                                           0
#define mmGCVM_INVALIDATE_ENG15_SEM                                                                    0x161c
#define mmGCVM_INVALIDATE_ENG15_SEM_BASE_IDX                                                           0
#define mmGCVM_INVALIDATE_ENG16_SEM                                                                    0x161d
#define mmGCVM_INVALIDATE_ENG16_SEM_BASE_IDX                                                           0
#define mmGCVM_INVALIDATE_ENG17_SEM                                                                    0x161e
#define mmGCVM_INVALIDATE_ENG17_SEM_BASE_IDX                                                           0
#define mmGCVM_INVALIDATE_ENG0_REQ                                                                     0x161f
#define mmGCVM_INVALIDATE_ENG0_REQ_BASE_IDX                                                            0
#define mmGCVM_INVALIDATE_ENG1_REQ                                                                     0x1620
#define mmGCVM_INVALIDATE_ENG1_REQ_BASE_IDX                                                            0
#define mmGCVM_INVALIDATE_ENG2_REQ                                                                     0x1621
#define mmGCVM_INVALIDATE_ENG2_REQ_BASE_IDX                                                            0
#define mmGCVM_INVALIDATE_ENG3_REQ                                                                     0x1622
#define mmGCVM_INVALIDATE_ENG3_REQ_BASE_IDX                                                            0
#define mmGCVM_INVALIDATE_ENG4_REQ                                                                     0x1623
#define mmGCVM_INVALIDATE_ENG4_REQ_BASE_IDX                                                            0
#define mmGCVM_INVALIDATE_ENG5_REQ                                                                     0x1624
#define mmGCVM_INVALIDATE_ENG5_REQ_BASE_IDX                                                            0
#define mmGCVM_INVALIDATE_ENG6_REQ                                                                     0x1625
#define mmGCVM_INVALIDATE_ENG6_REQ_BASE_IDX                                                            0
#define mmGCVM_INVALIDATE_ENG7_REQ                                                                     0x1626
#define mmGCVM_INVALIDATE_ENG7_REQ_BASE_IDX                                                            0
#define mmGCVM_INVALIDATE_ENG8_REQ                                                                     0x1627
#define mmGCVM_INVALIDATE_ENG8_REQ_BASE_IDX                                                            0
#define mmGCVM_INVALIDATE_ENG9_REQ                                                                     0x1628
#define mmGCVM_INVALIDATE_ENG9_REQ_BASE_IDX                                                            0
#define mmGCVM_INVALIDATE_ENG10_REQ                                                                    0x1629
#define mmGCVM_INVALIDATE_ENG10_REQ_BASE_IDX                                                           0
#define mmGCVM_INVALIDATE_ENG11_REQ                                                                    0x162a
#define mmGCVM_INVALIDATE_ENG11_REQ_BASE_IDX                                                           0
#define mmGCVM_INVALIDATE_ENG12_REQ                                                                    0x162b
#define mmGCVM_INVALIDATE_ENG12_REQ_BASE_IDX                                                           0
#define mmGCVM_INVALIDATE_ENG13_REQ                                                                    0x162c
#define mmGCVM_INVALIDATE_ENG13_REQ_BASE_IDX                                                           0
#define mmGCVM_INVALIDATE_ENG14_REQ                                                                    0x162d
#define mmGCVM_INVALIDATE_ENG14_REQ_BASE_IDX                                                           0
#define mmGCVM_INVALIDATE_ENG15_REQ                                                                    0x162e
#define mmGCVM_INVALIDATE_ENG15_REQ_BASE_IDX                                                           0
#define mmGCVM_INVALIDATE_ENG16_REQ                                                                    0x162f
#define mmGCVM_INVALIDATE_ENG16_REQ_BASE_IDX                                                           0
#define mmGCVM_INVALIDATE_ENG17_REQ                                                                    0x1630
#define mmGCVM_INVALIDATE_ENG17_REQ_BASE_IDX                                                           0
#define mmGCVM_INVALIDATE_ENG0_ACK                                                                     0x1631
#define mmGCVM_INVALIDATE_ENG0_ACK_BASE_IDX                                                            0
#define mmGCVM_INVALIDATE_ENG1_ACK                                                                     0x1632
#define mmGCVM_INVALIDATE_ENG1_ACK_BASE_IDX                                                            0
#define mmGCVM_INVALIDATE_ENG2_ACK                                                                     0x1633
#define mmGCVM_INVALIDATE_ENG2_ACK_BASE_IDX                                                            0
#define mmGCVM_INVALIDATE_ENG3_ACK                                                                     0x1634
#define mmGCVM_INVALIDATE_ENG3_ACK_BASE_IDX                                                            0
#define mmGCVM_INVALIDATE_ENG4_ACK                                                                     0x1635
#define mmGCVM_INVALIDATE_ENG4_ACK_BASE_IDX                                                            0
#define mmGCVM_INVALIDATE_ENG5_ACK                                                                     0x1636
#define mmGCVM_INVALIDATE_ENG5_ACK_BASE_IDX                                                            0
#define mmGCVM_INVALIDATE_ENG6_ACK                                                                     0x1637
#define mmGCVM_INVALIDATE_ENG6_ACK_BASE_IDX                                                            0
#define mmGCVM_INVALIDATE_ENG7_ACK                                                                     0x1638
#define mmGCVM_INVALIDATE_ENG7_ACK_BASE_IDX                                                            0
#define mmGCVM_INVALIDATE_ENG8_ACK                                                                     0x1639
#define mmGCVM_INVALIDATE_ENG8_ACK_BASE_IDX                                                            0
#define mmGCVM_INVALIDATE_ENG9_ACK                                                                     0x163a
#define mmGCVM_INVALIDATE_ENG9_ACK_BASE_IDX                                                            0
#define mmGCVM_INVALIDATE_ENG10_ACK                                                                    0x163b
#define mmGCVM_INVALIDATE_ENG10_ACK_BASE_IDX                                                           0
#define mmGCVM_INVALIDATE_ENG11_ACK                                                                    0x163c
#define mmGCVM_INVALIDATE_ENG11_ACK_BASE_IDX                                                           0
#define mmGCVM_INVALIDATE_ENG12_ACK                                                                    0x163d
#define mmGCVM_INVALIDATE_ENG12_ACK_BASE_IDX                                                           0
#define mmGCVM_INVALIDATE_ENG13_ACK                                                                    0x163e
#define mmGCVM_INVALIDATE_ENG13_ACK_BASE_IDX                                                           0
#define mmGCVM_INVALIDATE_ENG14_ACK                                                                    0x163f
#define mmGCVM_INVALIDATE_ENG14_ACK_BASE_IDX                                                           0
#define mmGCVM_INVALIDATE_ENG15_ACK                                                                    0x1640
#define mmGCVM_INVALIDATE_ENG15_ACK_BASE_IDX                                                           0
#define mmGCVM_INVALIDATE_ENG16_ACK                                                                    0x1641
#define mmGCVM_INVALIDATE_ENG16_ACK_BASE_IDX                                                           0
#define mmGCVM_INVALIDATE_ENG17_ACK                                                                    0x1642
#define mmGCVM_INVALIDATE_ENG17_ACK_BASE_IDX                                                           0
#define mmGCVM_INVALIDATE_ENG0_ADDR_RANGE_LO32                                                         0x1643
#define mmGCVM_INVALIDATE_ENG0_ADDR_RANGE_LO32_BASE_IDX                                                0
#define mmGCVM_INVALIDATE_ENG0_ADDR_RANGE_HI32                                                         0x1644
#define mmGCVM_INVALIDATE_ENG0_ADDR_RANGE_HI32_BASE_IDX                                                0
#define mmGCVM_INVALIDATE_ENG1_ADDR_RANGE_LO32                                                         0x1645
#define mmGCVM_INVALIDATE_ENG1_ADDR_RANGE_LO32_BASE_IDX                                                0
#define mmGCVM_INVALIDATE_ENG1_ADDR_RANGE_HI32                                                         0x1646
#define mmGCVM_INVALIDATE_ENG1_ADDR_RANGE_HI32_BASE_IDX                                                0
#define mmGCVM_INVALIDATE_ENG2_ADDR_RANGE_LO32                                                         0x1647
#define mmGCVM_INVALIDATE_ENG2_ADDR_RANGE_LO32_BASE_IDX                                                0
#define mmGCVM_INVALIDATE_ENG2_ADDR_RANGE_HI32                                                         0x1648
#define mmGCVM_INVALIDATE_ENG2_ADDR_RANGE_HI32_BASE_IDX                                                0
#define mmGCVM_INVALIDATE_ENG3_ADDR_RANGE_LO32                                                         0x1649
#define mmGCVM_INVALIDATE_ENG3_ADDR_RANGE_LO32_BASE_IDX                                                0
#define mmGCVM_INVALIDATE_ENG3_ADDR_RANGE_HI32                                                         0x164a
#define mmGCVM_INVALIDATE_ENG3_ADDR_RANGE_HI32_BASE_IDX                                                0
#define mmGCVM_INVALIDATE_ENG4_ADDR_RANGE_LO32                                                         0x164b
#define mmGCVM_INVALIDATE_ENG4_ADDR_RANGE_LO32_BASE_IDX                                                0
#define mmGCVM_INVALIDATE_ENG4_ADDR_RANGE_HI32                                                         0x164c
#define mmGCVM_INVALIDATE_ENG4_ADDR_RANGE_HI32_BASE_IDX                                                0
#define mmGCVM_INVALIDATE_ENG5_ADDR_RANGE_LO32                                                         0x164d
#define mmGCVM_INVALIDATE_ENG5_ADDR_RANGE_LO32_BASE_IDX                                                0
#define mmGCVM_INVALIDATE_ENG5_ADDR_RANGE_HI32                                                         0x164e
#define mmGCVM_INVALIDATE_ENG5_ADDR_RANGE_HI32_BASE_IDX                                                0
#define mmGCVM_INVALIDATE_ENG6_ADDR_RANGE_LO32                                                         0x164f
#define mmGCVM_INVALIDATE_ENG6_ADDR_RANGE_LO32_BASE_IDX                                                0
#define mmGCVM_INVALIDATE_ENG6_ADDR_RANGE_HI32                                                         0x1650
#define mmGCVM_INVALIDATE_ENG6_ADDR_RANGE_HI32_BASE_IDX                                                0
#define mmGCVM_INVALIDATE_ENG7_ADDR_RANGE_LO32                                                         0x1651
#define mmGCVM_INVALIDATE_ENG7_ADDR_RANGE_LO32_BASE_IDX                                                0
#define mmGCVM_INVALIDATE_ENG7_ADDR_RANGE_HI32                                                         0x1652
#define mmGCVM_INVALIDATE_ENG7_ADDR_RANGE_HI32_BASE_IDX                                                0
#define mmGCVM_INVALIDATE_ENG8_ADDR_RANGE_LO32                                                         0x1653
#define mmGCVM_INVALIDATE_ENG8_ADDR_RANGE_LO32_BASE_IDX                                                0
#define mmGCVM_INVALIDATE_ENG8_ADDR_RANGE_HI32                                                         0x1654
#define mmGCVM_INVALIDATE_ENG8_ADDR_RANGE_HI32_BASE_IDX                                                0
#define mmGCVM_INVALIDATE_ENG9_ADDR_RANGE_LO32                                                         0x1655
#define mmGCVM_INVALIDATE_ENG9_ADDR_RANGE_LO32_BASE_IDX                                                0
#define mmGCVM_INVALIDATE_ENG9_ADDR_RANGE_HI32                                                         0x1656
#define mmGCVM_INVALIDATE_ENG9_ADDR_RANGE_HI32_BASE_IDX                                                0
#define mmGCVM_INVALIDATE_ENG10_ADDR_RANGE_LO32                                                        0x1657
#define mmGCVM_INVALIDATE_ENG10_ADDR_RANGE_LO32_BASE_IDX                                               0
#define mmGCVM_INVALIDATE_ENG10_ADDR_RANGE_HI32                                                        0x1658
#define mmGCVM_INVALIDATE_ENG10_ADDR_RANGE_HI32_BASE_IDX                                               0
#define mmGCVM_INVALIDATE_ENG11_ADDR_RANGE_LO32                                                        0x1659
#define mmGCVM_INVALIDATE_ENG11_ADDR_RANGE_LO32_BASE_IDX                                               0
#define mmGCVM_INVALIDATE_ENG11_ADDR_RANGE_HI32                                                        0x165a
#define mmGCVM_INVALIDATE_ENG11_ADDR_RANGE_HI32_BASE_IDX                                               0
#define mmGCVM_INVALIDATE_ENG12_ADDR_RANGE_LO32                                                        0x165b
#define mmGCVM_INVALIDATE_ENG12_ADDR_RANGE_LO32_BASE_IDX                                               0
#define mmGCVM_INVALIDATE_ENG12_ADDR_RANGE_HI32                                                        0x165c
#define mmGCVM_INVALIDATE_ENG12_ADDR_RANGE_HI32_BASE_IDX                                               0
#define mmGCVM_INVALIDATE_ENG13_ADDR_RANGE_LO32                                                        0x165d
#define mmGCVM_INVALIDATE_ENG13_ADDR_RANGE_LO32_BASE_IDX                                               0
#define mmGCVM_INVALIDATE_ENG13_ADDR_RANGE_HI32                                                        0x165e
#define mmGCVM_INVALIDATE_ENG13_ADDR_RANGE_HI32_BASE_IDX                                               0
#define mmGCVM_INVALIDATE_ENG14_ADDR_RANGE_LO32                                                        0x165f
#define mmGCVM_INVALIDATE_ENG14_ADDR_RANGE_LO32_BASE_IDX                                               0
#define mmGCVM_INVALIDATE_ENG14_ADDR_RANGE_HI32                                                        0x1660
#define mmGCVM_INVALIDATE_ENG14_ADDR_RANGE_HI32_BASE_IDX                                               0
#define mmGCVM_INVALIDATE_ENG15_ADDR_RANGE_LO32                                                        0x1661
#define mmGCVM_INVALIDATE_ENG15_ADDR_RANGE_LO32_BASE_IDX                                               0
#define mmGCVM_INVALIDATE_ENG15_ADDR_RANGE_HI32                                                        0x1662
#define mmGCVM_INVALIDATE_ENG15_ADDR_RANGE_HI32_BASE_IDX                                               0
#define mmGCVM_INVALIDATE_ENG16_ADDR_RANGE_LO32                                                        0x1663
#define mmGCVM_INVALIDATE_ENG16_ADDR_RANGE_LO32_BASE_IDX                                               0
#define mmGCVM_INVALIDATE_ENG16_ADDR_RANGE_HI32                                                        0x1664
#define mmGCVM_INVALIDATE_ENG16_ADDR_RANGE_HI32_BASE_IDX                                               0
#define mmGCVM_INVALIDATE_ENG17_ADDR_RANGE_LO32                                                        0x1665
#define mmGCVM_INVALIDATE_ENG17_ADDR_RANGE_LO32_BASE_IDX                                               0
#define mmGCVM_INVALIDATE_ENG17_ADDR_RANGE_HI32                                                        0x1666
#define mmGCVM_INVALIDATE_ENG17_ADDR_RANGE_HI32_BASE_IDX                                               0
#define mmGCVM_CONTEXT0_PAGE_TABLE_BASE_ADDR_LO32                                                      0x1667
#define mmGCVM_CONTEXT0_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                             0
#define mmGCVM_CONTEXT0_PAGE_TABLE_BASE_ADDR_HI32                                                      0x1668
#define mmGCVM_CONTEXT0_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                             0
#define mmGCVM_CONTEXT1_PAGE_TABLE_BASE_ADDR_LO32                                                      0x1669
#define mmGCVM_CONTEXT1_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                             0
#define mmGCVM_CONTEXT1_PAGE_TABLE_BASE_ADDR_HI32                                                      0x166a
#define mmGCVM_CONTEXT1_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                             0
#define mmGCVM_CONTEXT2_PAGE_TABLE_BASE_ADDR_LO32                                                      0x166b
#define mmGCVM_CONTEXT2_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                             0
#define mmGCVM_CONTEXT2_PAGE_TABLE_BASE_ADDR_HI32                                                      0x166c
#define mmGCVM_CONTEXT2_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                             0
#define mmGCVM_CONTEXT3_PAGE_TABLE_BASE_ADDR_LO32                                                      0x166d
#define mmGCVM_CONTEXT3_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                             0
#define mmGCVM_CONTEXT3_PAGE_TABLE_BASE_ADDR_HI32                                                      0x166e
#define mmGCVM_CONTEXT3_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                             0
#define mmGCVM_CONTEXT4_PAGE_TABLE_BASE_ADDR_LO32                                                      0x166f
#define mmGCVM_CONTEXT4_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                             0
#define mmGCVM_CONTEXT4_PAGE_TABLE_BASE_ADDR_HI32                                                      0x1670
#define mmGCVM_CONTEXT4_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                             0
#define mmGCVM_CONTEXT5_PAGE_TABLE_BASE_ADDR_LO32                                                      0x1671
#define mmGCVM_CONTEXT5_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                             0
#define mmGCVM_CONTEXT5_PAGE_TABLE_BASE_ADDR_HI32                                                      0x1672
#define mmGCVM_CONTEXT5_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                             0
#define mmGCVM_CONTEXT6_PAGE_TABLE_BASE_ADDR_LO32                                                      0x1673
#define mmGCVM_CONTEXT6_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                             0
#define mmGCVM_CONTEXT6_PAGE_TABLE_BASE_ADDR_HI32                                                      0x1674
#define mmGCVM_CONTEXT6_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                             0
#define mmGCVM_CONTEXT7_PAGE_TABLE_BASE_ADDR_LO32                                                      0x1675
#define mmGCVM_CONTEXT7_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                             0
#define mmGCVM_CONTEXT7_PAGE_TABLE_BASE_ADDR_HI32                                                      0x1676
#define mmGCVM_CONTEXT7_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                             0
#define mmGCVM_CONTEXT8_PAGE_TABLE_BASE_ADDR_LO32                                                      0x1677
#define mmGCVM_CONTEXT8_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                             0
#define mmGCVM_CONTEXT8_PAGE_TABLE_BASE_ADDR_HI32                                                      0x1678
#define mmGCVM_CONTEXT8_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                             0
#define mmGCVM_CONTEXT9_PAGE_TABLE_BASE_ADDR_LO32                                                      0x1679
#define mmGCVM_CONTEXT9_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                             0
#define mmGCVM_CONTEXT9_PAGE_TABLE_BASE_ADDR_HI32                                                      0x167a
#define mmGCVM_CONTEXT9_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                             0
#define mmGCVM_CONTEXT10_PAGE_TABLE_BASE_ADDR_LO32                                                     0x167b
#define mmGCVM_CONTEXT10_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                            0
#define mmGCVM_CONTEXT10_PAGE_TABLE_BASE_ADDR_HI32                                                     0x167c
#define mmGCVM_CONTEXT10_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                            0
#define mmGCVM_CONTEXT11_PAGE_TABLE_BASE_ADDR_LO32                                                     0x167d
#define mmGCVM_CONTEXT11_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                            0
#define mmGCVM_CONTEXT11_PAGE_TABLE_BASE_ADDR_HI32                                                     0x167e
#define mmGCVM_CONTEXT11_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                            0
#define mmGCVM_CONTEXT12_PAGE_TABLE_BASE_ADDR_LO32                                                     0x167f
#define mmGCVM_CONTEXT12_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                            0
#define mmGCVM_CONTEXT12_PAGE_TABLE_BASE_ADDR_HI32                                                     0x1680
#define mmGCVM_CONTEXT12_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                            0
#define mmGCVM_CONTEXT13_PAGE_TABLE_BASE_ADDR_LO32                                                     0x1681
#define mmGCVM_CONTEXT13_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                            0
#define mmGCVM_CONTEXT13_PAGE_TABLE_BASE_ADDR_HI32                                                     0x1682
#define mmGCVM_CONTEXT13_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                            0
#define mmGCVM_CONTEXT14_PAGE_TABLE_BASE_ADDR_LO32                                                     0x1683
#define mmGCVM_CONTEXT14_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                            0
#define mmGCVM_CONTEXT14_PAGE_TABLE_BASE_ADDR_HI32                                                     0x1684
#define mmGCVM_CONTEXT14_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                            0
#define mmGCVM_CONTEXT15_PAGE_TABLE_BASE_ADDR_LO32                                                     0x1685
#define mmGCVM_CONTEXT15_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                            0
#define mmGCVM_CONTEXT15_PAGE_TABLE_BASE_ADDR_HI32                                                     0x1686
#define mmGCVM_CONTEXT15_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                            0
#define mmGCVM_CONTEXT0_PAGE_TABLE_START_ADDR_LO32                                                     0x1687
#define mmGCVM_CONTEXT0_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                            0
#define mmGCVM_CONTEXT0_PAGE_TABLE_START_ADDR_HI32                                                     0x1688
#define mmGCVM_CONTEXT0_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                            0
#define mmGCVM_CONTEXT1_PAGE_TABLE_START_ADDR_LO32                                                     0x1689
#define mmGCVM_CONTEXT1_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                            0
#define mmGCVM_CONTEXT1_PAGE_TABLE_START_ADDR_HI32                                                     0x168a
#define mmGCVM_CONTEXT1_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                            0
#define mmGCVM_CONTEXT2_PAGE_TABLE_START_ADDR_LO32                                                     0x168b
#define mmGCVM_CONTEXT2_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                            0
#define mmGCVM_CONTEXT2_PAGE_TABLE_START_ADDR_HI32                                                     0x168c
#define mmGCVM_CONTEXT2_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                            0
#define mmGCVM_CONTEXT3_PAGE_TABLE_START_ADDR_LO32                                                     0x168d
#define mmGCVM_CONTEXT3_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                            0
#define mmGCVM_CONTEXT3_PAGE_TABLE_START_ADDR_HI32                                                     0x168e
#define mmGCVM_CONTEXT3_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                            0
#define mmGCVM_CONTEXT4_PAGE_TABLE_START_ADDR_LO32                                                     0x168f
#define mmGCVM_CONTEXT4_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                            0
#define mmGCVM_CONTEXT4_PAGE_TABLE_START_ADDR_HI32                                                     0x1690
#define mmGCVM_CONTEXT4_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                            0
#define mmGCVM_CONTEXT5_PAGE_TABLE_START_ADDR_LO32                                                     0x1691
#define mmGCVM_CONTEXT5_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                            0
#define mmGCVM_CONTEXT5_PAGE_TABLE_START_ADDR_HI32                                                     0x1692
#define mmGCVM_CONTEXT5_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                            0
#define mmGCVM_CONTEXT6_PAGE_TABLE_START_ADDR_LO32                                                     0x1693
#define mmGCVM_CONTEXT6_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                            0
#define mmGCVM_CONTEXT6_PAGE_TABLE_START_ADDR_HI32                                                     0x1694
#define mmGCVM_CONTEXT6_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                            0
#define mmGCVM_CONTEXT7_PAGE_TABLE_START_ADDR_LO32                                                     0x1695
#define mmGCVM_CONTEXT7_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                            0
#define mmGCVM_CONTEXT7_PAGE_TABLE_START_ADDR_HI32                                                     0x1696
#define mmGCVM_CONTEXT7_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                            0
#define mmGCVM_CONTEXT8_PAGE_TABLE_START_ADDR_LO32                                                     0x1697
#define mmGCVM_CONTEXT8_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                            0
#define mmGCVM_CONTEXT8_PAGE_TABLE_START_ADDR_HI32                                                     0x1698
#define mmGCVM_CONTEXT8_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                            0
#define mmGCVM_CONTEXT9_PAGE_TABLE_START_ADDR_LO32                                                     0x1699
#define mmGCVM_CONTEXT9_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                            0
#define mmGCVM_CONTEXT9_PAGE_TABLE_START_ADDR_HI32                                                     0x169a
#define mmGCVM_CONTEXT9_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                            0
#define mmGCVM_CONTEXT10_PAGE_TABLE_START_ADDR_LO32                                                    0x169b
#define mmGCVM_CONTEXT10_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                           0
#define mmGCVM_CONTEXT10_PAGE_TABLE_START_ADDR_HI32                                                    0x169c
#define mmGCVM_CONTEXT10_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                           0
#define mmGCVM_CONTEXT11_PAGE_TABLE_START_ADDR_LO32                                                    0x169d
#define mmGCVM_CONTEXT11_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                           0
#define mmGCVM_CONTEXT11_PAGE_TABLE_START_ADDR_HI32                                                    0x169e
#define mmGCVM_CONTEXT11_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                           0
#define mmGCVM_CONTEXT12_PAGE_TABLE_START_ADDR_LO32                                                    0x169f
#define mmGCVM_CONTEXT12_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                           0
#define mmGCVM_CONTEXT12_PAGE_TABLE_START_ADDR_HI32                                                    0x16a0
#define mmGCVM_CONTEXT12_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                           0
#define mmGCVM_CONTEXT13_PAGE_TABLE_START_ADDR_LO32                                                    0x16a1
#define mmGCVM_CONTEXT13_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                           0
#define mmGCVM_CONTEXT13_PAGE_TABLE_START_ADDR_HI32                                                    0x16a2
#define mmGCVM_CONTEXT13_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                           0
#define mmGCVM_CONTEXT14_PAGE_TABLE_START_ADDR_LO32                                                    0x16a3
#define mmGCVM_CONTEXT14_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                           0
#define mmGCVM_CONTEXT14_PAGE_TABLE_START_ADDR_HI32                                                    0x16a4
#define mmGCVM_CONTEXT14_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                           0
#define mmGCVM_CONTEXT15_PAGE_TABLE_START_ADDR_LO32                                                    0x16a5
#define mmGCVM_CONTEXT15_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                           0
#define mmGCVM_CONTEXT15_PAGE_TABLE_START_ADDR_HI32                                                    0x16a6
#define mmGCVM_CONTEXT15_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                           0
#define mmGCVM_CONTEXT0_PAGE_TABLE_END_ADDR_LO32                                                       0x16a7
#define mmGCVM_CONTEXT0_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                              0
#define mmGCVM_CONTEXT0_PAGE_TABLE_END_ADDR_HI32                                                       0x16a8
#define mmGCVM_CONTEXT0_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                              0
#define mmGCVM_CONTEXT1_PAGE_TABLE_END_ADDR_LO32                                                       0x16a9
#define mmGCVM_CONTEXT1_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                              0
#define mmGCVM_CONTEXT1_PAGE_TABLE_END_ADDR_HI32                                                       0x16aa
#define mmGCVM_CONTEXT1_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                              0
#define mmGCVM_CONTEXT2_PAGE_TABLE_END_ADDR_LO32                                                       0x16ab
#define mmGCVM_CONTEXT2_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                              0
#define mmGCVM_CONTEXT2_PAGE_TABLE_END_ADDR_HI32                                                       0x16ac
#define mmGCVM_CONTEXT2_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                              0
#define mmGCVM_CONTEXT3_PAGE_TABLE_END_ADDR_LO32                                                       0x16ad
#define mmGCVM_CONTEXT3_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                              0
#define mmGCVM_CONTEXT3_PAGE_TABLE_END_ADDR_HI32                                                       0x16ae
#define mmGCVM_CONTEXT3_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                              0
#define mmGCVM_CONTEXT4_PAGE_TABLE_END_ADDR_LO32                                                       0x16af
#define mmGCVM_CONTEXT4_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                              0
#define mmGCVM_CONTEXT4_PAGE_TABLE_END_ADDR_HI32                                                       0x16b0
#define mmGCVM_CONTEXT4_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                              0
#define mmGCVM_CONTEXT5_PAGE_TABLE_END_ADDR_LO32                                                       0x16b1
#define mmGCVM_CONTEXT5_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                              0
#define mmGCVM_CONTEXT5_PAGE_TABLE_END_ADDR_HI32                                                       0x16b2
#define mmGCVM_CONTEXT5_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                              0
#define mmGCVM_CONTEXT6_PAGE_TABLE_END_ADDR_LO32                                                       0x16b3
#define mmGCVM_CONTEXT6_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                              0
#define mmGCVM_CONTEXT6_PAGE_TABLE_END_ADDR_HI32                                                       0x16b4
#define mmGCVM_CONTEXT6_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                              0
#define mmGCVM_CONTEXT7_PAGE_TABLE_END_ADDR_LO32                                                       0x16b5
#define mmGCVM_CONTEXT7_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                              0
#define mmGCVM_CONTEXT7_PAGE_TABLE_END_ADDR_HI32                                                       0x16b6
#define mmGCVM_CONTEXT7_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                              0
#define mmGCVM_CONTEXT8_PAGE_TABLE_END_ADDR_LO32                                                       0x16b7
#define mmGCVM_CONTEXT8_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                              0
#define mmGCVM_CONTEXT8_PAGE_TABLE_END_ADDR_HI32                                                       0x16b8
#define mmGCVM_CONTEXT8_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                              0
#define mmGCVM_CONTEXT9_PAGE_TABLE_END_ADDR_LO32                                                       0x16b9
#define mmGCVM_CONTEXT9_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                              0
#define mmGCVM_CONTEXT9_PAGE_TABLE_END_ADDR_HI32                                                       0x16ba
#define mmGCVM_CONTEXT9_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                              0
#define mmGCVM_CONTEXT10_PAGE_TABLE_END_ADDR_LO32                                                      0x16bb
#define mmGCVM_CONTEXT10_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                             0
#define mmGCVM_CONTEXT10_PAGE_TABLE_END_ADDR_HI32                                                      0x16bc
#define mmGCVM_CONTEXT10_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                             0
#define mmGCVM_CONTEXT11_PAGE_TABLE_END_ADDR_LO32                                                      0x16bd
#define mmGCVM_CONTEXT11_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                             0
#define mmGCVM_CONTEXT11_PAGE_TABLE_END_ADDR_HI32                                                      0x16be
#define mmGCVM_CONTEXT11_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                             0
#define mmGCVM_CONTEXT12_PAGE_TABLE_END_ADDR_LO32                                                      0x16bf
#define mmGCVM_CONTEXT12_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                             0
#define mmGCVM_CONTEXT12_PAGE_TABLE_END_ADDR_HI32                                                      0x16c0
#define mmGCVM_CONTEXT12_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                             0
#define mmGCVM_CONTEXT13_PAGE_TABLE_END_ADDR_LO32                                                      0x16c1
#define mmGCVM_CONTEXT13_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                             0
#define mmGCVM_CONTEXT13_PAGE_TABLE_END_ADDR_HI32                                                      0x16c2
#define mmGCVM_CONTEXT13_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                             0
#define mmGCVM_CONTEXT14_PAGE_TABLE_END_ADDR_LO32                                                      0x16c3
#define mmGCVM_CONTEXT14_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                             0
#define mmGCVM_CONTEXT14_PAGE_TABLE_END_ADDR_HI32                                                      0x16c4
#define mmGCVM_CONTEXT14_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                             0
#define mmGCVM_CONTEXT15_PAGE_TABLE_END_ADDR_LO32                                                      0x16c5
#define mmGCVM_CONTEXT15_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                             0
#define mmGCVM_CONTEXT15_PAGE_TABLE_END_ADDR_HI32                                                      0x16c6
#define mmGCVM_CONTEXT15_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                             0
#define mmGCVM_L2_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                                    0x16c7
#define mmGCVM_L2_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                           0
#define mmGCVM_L2_CONTEXT0_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                           0x16c8
#define mmGCVM_L2_CONTEXT0_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                  0
#define mmGCVM_L2_CONTEXT1_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                           0x16c9
#define mmGCVM_L2_CONTEXT1_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                  0
#define mmGCVM_L2_CONTEXT2_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                           0x16ca
#define mmGCVM_L2_CONTEXT2_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                  0
#define mmGCVM_L2_CONTEXT3_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                           0x16cb
#define mmGCVM_L2_CONTEXT3_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                  0
#define mmGCVM_L2_CONTEXT4_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                           0x16cc
#define mmGCVM_L2_CONTEXT4_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                  0
#define mmGCVM_L2_CONTEXT5_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                           0x16cd
#define mmGCVM_L2_CONTEXT5_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                  0
#define mmGCVM_L2_CONTEXT6_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                           0x16ce
#define mmGCVM_L2_CONTEXT6_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                  0
#define mmGCVM_L2_CONTEXT7_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                           0x16cf
#define mmGCVM_L2_CONTEXT7_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                  0
#define mmGCVM_L2_CONTEXT8_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                           0x16d0
#define mmGCVM_L2_CONTEXT8_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                  0
#define mmGCVM_L2_CONTEXT9_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                           0x16d1
#define mmGCVM_L2_CONTEXT9_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                  0
#define mmGCVM_L2_CONTEXT10_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                          0x16d2
#define mmGCVM_L2_CONTEXT10_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                 0
#define mmGCVM_L2_CONTEXT11_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                          0x16d3
#define mmGCVM_L2_CONTEXT11_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                 0
#define mmGCVM_L2_CONTEXT12_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                          0x16d4
#define mmGCVM_L2_CONTEXT12_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                 0
#define mmGCVM_L2_CONTEXT13_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                          0x16d5
#define mmGCVM_L2_CONTEXT13_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                 0
#define mmGCVM_L2_CONTEXT14_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                          0x16d6
#define mmGCVM_L2_CONTEXT14_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                 0
#define mmGCVM_L2_CONTEXT15_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                          0x16d7
#define mmGCVM_L2_CONTEXT15_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                 0


// addressBlock: gc_gcvmsharedpfdec
// base address: 0xa500
#define mmGCMC_VM_NB_MMIOBASE                                                                          0x16e0
#define mmGCMC_VM_NB_MMIOBASE_BASE_IDX                                                                 0
#define mmGCMC_VM_NB_MMIOLIMIT                                                                         0x16e1
#define mmGCMC_VM_NB_MMIOLIMIT_BASE_IDX                                                                0
#define mmGCMC_VM_NB_PCI_CTRL                                                                          0x16e2
#define mmGCMC_VM_NB_PCI_CTRL_BASE_IDX                                                                 0
#define mmGCMC_VM_NB_PCI_ARB                                                                           0x16e3
#define mmGCMC_VM_NB_PCI_ARB_BASE_IDX                                                                  0
#define mmGCMC_VM_NB_TOP_OF_DRAM_SLOT1                                                                 0x16e4
#define mmGCMC_VM_NB_TOP_OF_DRAM_SLOT1_BASE_IDX                                                        0
#define mmGCMC_VM_NB_LOWER_TOP_OF_DRAM2                                                                0x16e5
#define mmGCMC_VM_NB_LOWER_TOP_OF_DRAM2_BASE_IDX                                                       0
#define mmGCMC_VM_NB_UPPER_TOP_OF_DRAM2                                                                0x16e6
#define mmGCMC_VM_NB_UPPER_TOP_OF_DRAM2_BASE_IDX                                                       0
#define mmGCMC_VM_FB_OFFSET                                                                            0x16e7
#define mmGCMC_VM_FB_OFFSET_BASE_IDX                                                                   0
#define mmGCMC_VM_SYSTEM_APERTURE_DEFAULT_ADDR_LSB                                                     0x16e8
#define mmGCMC_VM_SYSTEM_APERTURE_DEFAULT_ADDR_LSB_BASE_IDX                                            0
#define mmGCMC_VM_SYSTEM_APERTURE_DEFAULT_ADDR_MSB                                                     0x16e9
#define mmGCMC_VM_SYSTEM_APERTURE_DEFAULT_ADDR_MSB_BASE_IDX                                            0
#define mmGCMC_VM_STEERING                                                                             0x16ea
#define mmGCMC_VM_STEERING_BASE_IDX                                                                    0
#define mmGCMC_SHARED_VIRT_RESET_REQ                                                                   0x16eb
#define mmGCMC_SHARED_VIRT_RESET_REQ_BASE_IDX                                                          0
#define mmGCMC_MEM_POWER_LS                                                                            0x16ec
#define mmGCMC_MEM_POWER_LS_BASE_IDX                                                                   0
#define mmGCMC_VM_CACHEABLE_DRAM_ADDRESS_START                                                         0x16ed
#define mmGCMC_VM_CACHEABLE_DRAM_ADDRESS_START_BASE_IDX                                                0
#define mmGCMC_VM_CACHEABLE_DRAM_ADDRESS_END                                                           0x16ee
#define mmGCMC_VM_CACHEABLE_DRAM_ADDRESS_END_BASE_IDX                                                  0
#define mmGCMC_VM_APT_CNTL                                                                             0x16ef
#define mmGCMC_VM_APT_CNTL_BASE_IDX                                                                    0
#define mmGCMC_VM_LOCAL_HBM_ADDRESS_LOCK_CNTL                                                          0x16f0
#define mmGCMC_VM_LOCAL_HBM_ADDRESS_LOCK_CNTL_BASE_IDX                                                 0
#define mmGCMC_VM_LOCAL_HBM_ADDRESS_START                                                              0x16f1
#define mmGCMC_VM_LOCAL_HBM_ADDRESS_START_BASE_IDX                                                     0
#define mmGCMC_VM_LOCAL_HBM_ADDRESS_END                                                                0x16f2
#define mmGCMC_VM_LOCAL_HBM_ADDRESS_END_BASE_IDX                                                       0
#define mmGCMC_SHARED_ACTIVE_FCN_ID                                                                    0x16f4
#define mmGCMC_SHARED_ACTIVE_FCN_ID_BASE_IDX                                                           0
#define mmGCMC_SHARED_VIRT_RESET_REQ2                                                                  0x16f5
#define mmGCMC_SHARED_VIRT_RESET_REQ2_BASE_IDX                                                         0
#define mmGCMC_VM_XGMI_LFB_CNTL                                                                        0x16f7
#define mmGCMC_VM_XGMI_LFB_CNTL_BASE_IDX                                                               0
#define mmGCMC_VM_XGMI_LFB_SIZE                                                                        0x16f8
#define mmGCMC_VM_XGMI_LFB_SIZE_BASE_IDX                                                               0
#define mmGCUTCL2_HARVEST_BYPASS_GROUPS                                                                0x16fa
#define mmGCUTCL2_HARVEST_BYPASS_GROUPS_BASE_IDX                                                       0


// addressBlock: gc_gcvmsharedvcdec
// base address: 0xa570
#define mmGCMC_VM_FB_LOCATION_BASE                                                                     0x16fc
#define mmGCMC_VM_FB_LOCATION_BASE_BASE_IDX                                                            0
#define mmGCMC_VM_FB_LOCATION_TOP                                                                      0x16fd
#define mmGCMC_VM_FB_LOCATION_TOP_BASE_IDX                                                             0
#define mmGCMC_VM_AGP_TOP                                                                              0x16fe
#define mmGCMC_VM_AGP_TOP_BASE_IDX                                                                     0
#define mmGCMC_VM_AGP_BOT                                                                              0x16ff
#define mmGCMC_VM_AGP_BOT_BASE_IDX                                                                     0
#define mmGCMC_VM_AGP_BASE                                                                             0x1700
#define mmGCMC_VM_AGP_BASE_BASE_IDX                                                                    0
#define mmGCMC_VM_SYSTEM_APERTURE_LOW_ADDR                                                             0x1701
#define mmGCMC_VM_SYSTEM_APERTURE_LOW_ADDR_BASE_IDX                                                    0
#define mmGCMC_VM_SYSTEM_APERTURE_HIGH_ADDR                                                            0x1702
#define mmGCMC_VM_SYSTEM_APERTURE_HIGH_ADDR_BASE_IDX                                                   0
#define mmGCMC_VM_MX_L1_TLB_CNTL                                                                       0x1703
#define mmGCMC_VM_MX_L1_TLB_CNTL_BASE_IDX                                                              0


// addressBlock: gc_gceadec
// base address: 0xa800
#define mmGCEA_DRAM_RD_CLI2GRP_MAP0                                                                    0x17a0
#define mmGCEA_DRAM_RD_CLI2GRP_MAP0_BASE_IDX                                                           0
#define mmGCEA_DRAM_RD_CLI2GRP_MAP1                                                                    0x17a1
#define mmGCEA_DRAM_RD_CLI2GRP_MAP1_BASE_IDX                                                           0
#define mmGCEA_DRAM_WR_CLI2GRP_MAP0                                                                    0x17a2
#define mmGCEA_DRAM_WR_CLI2GRP_MAP0_BASE_IDX                                                           0
#define mmGCEA_DRAM_WR_CLI2GRP_MAP1                                                                    0x17a3
#define mmGCEA_DRAM_WR_CLI2GRP_MAP1_BASE_IDX                                                           0
#define mmGCEA_DRAM_RD_GRP2VC_MAP                                                                      0x17a4
#define mmGCEA_DRAM_RD_GRP2VC_MAP_BASE_IDX                                                             0
#define mmGCEA_DRAM_WR_GRP2VC_MAP                                                                      0x17a5
#define mmGCEA_DRAM_WR_GRP2VC_MAP_BASE_IDX                                                             0
#define mmGCEA_DRAM_RD_LAZY                                                                            0x17a6
#define mmGCEA_DRAM_RD_LAZY_BASE_IDX                                                                   0
#define mmGCEA_DRAM_WR_LAZY                                                                            0x17a7
#define mmGCEA_DRAM_WR_LAZY_BASE_IDX                                                                   0
#define mmGCEA_DRAM_RD_CAM_CNTL                                                                        0x17a8
#define mmGCEA_DRAM_RD_CAM_CNTL_BASE_IDX                                                               0
#define mmGCEA_DRAM_WR_CAM_CNTL                                                                        0x17a9
#define mmGCEA_DRAM_WR_CAM_CNTL_BASE_IDX                                                               0
#define mmGCEA_DRAM_PAGE_BURST                                                                         0x17aa
#define mmGCEA_DRAM_PAGE_BURST_BASE_IDX                                                                0
#define mmGCEA_DRAM_RD_PRI_AGE                                                                         0x17ab
#define mmGCEA_DRAM_RD_PRI_AGE_BASE_IDX                                                                0
#define mmGCEA_DRAM_WR_PRI_AGE                                                                         0x17ac
#define mmGCEA_DRAM_WR_PRI_AGE_BASE_IDX                                                                0
#define mmGCEA_DRAM_RD_PRI_QUEUING                                                                     0x17ad
#define mmGCEA_DRAM_RD_PRI_QUEUING_BASE_IDX                                                            0
#define mmGCEA_DRAM_WR_PRI_QUEUING                                                                     0x17ae
#define mmGCEA_DRAM_WR_PRI_QUEUING_BASE_IDX                                                            0
#define mmGCEA_DRAM_RD_PRI_FIXED                                                                       0x17af
#define mmGCEA_DRAM_RD_PRI_FIXED_BASE_IDX                                                              0
#define mmGCEA_DRAM_WR_PRI_FIXED                                                                       0x17b0
#define mmGCEA_DRAM_WR_PRI_FIXED_BASE_IDX                                                              0
#define mmGCEA_DRAM_RD_PRI_URGENCY                                                                     0x17b1
#define mmGCEA_DRAM_RD_PRI_URGENCY_BASE_IDX                                                            0
#define mmGCEA_DRAM_WR_PRI_URGENCY                                                                     0x17b2
#define mmGCEA_DRAM_WR_PRI_URGENCY_BASE_IDX                                                            0
#define mmGCEA_DRAM_RD_PRI_QUANT_PRI1                                                                  0x17b3
#define mmGCEA_DRAM_RD_PRI_QUANT_PRI1_BASE_IDX                                                         0
#define mmGCEA_DRAM_RD_PRI_QUANT_PRI2                                                                  0x17b4
#define mmGCEA_DRAM_RD_PRI_QUANT_PRI2_BASE_IDX                                                         0
#define mmGCEA_DRAM_RD_PRI_QUANT_PRI3                                                                  0x17b5
#define mmGCEA_DRAM_RD_PRI_QUANT_PRI3_BASE_IDX                                                         0
#define mmGCEA_DRAM_WR_PRI_QUANT_PRI1                                                                  0x17b6
#define mmGCEA_DRAM_WR_PRI_QUANT_PRI1_BASE_IDX                                                         0
#define mmGCEA_DRAM_WR_PRI_QUANT_PRI2                                                                  0x17b7
#define mmGCEA_DRAM_WR_PRI_QUANT_PRI2_BASE_IDX                                                         0
#define mmGCEA_DRAM_WR_PRI_QUANT_PRI3                                                                  0x17b8
#define mmGCEA_DRAM_WR_PRI_QUANT_PRI3_BASE_IDX                                                         0
#define mmGCEA_IO_RD_CLI2GRP_MAP0                                                                      0x187d
#define mmGCEA_IO_RD_CLI2GRP_MAP0_BASE_IDX                                                             0
#define mmGCEA_IO_RD_CLI2GRP_MAP1                                                                      0x187e
#define mmGCEA_IO_RD_CLI2GRP_MAP1_BASE_IDX                                                             0
#define mmGCEA_IO_WR_CLI2GRP_MAP0                                                                      0x187f
#define mmGCEA_IO_WR_CLI2GRP_MAP0_BASE_IDX                                                             0
#define mmGCEA_IO_WR_CLI2GRP_MAP1                                                                      0x1880
#define mmGCEA_IO_WR_CLI2GRP_MAP1_BASE_IDX                                                             0
#define mmGCEA_IO_RD_COMBINE_FLUSH                                                                     0x1881
#define mmGCEA_IO_RD_COMBINE_FLUSH_BASE_IDX                                                            0
#define mmGCEA_IO_WR_COMBINE_FLUSH                                                                     0x1882
#define mmGCEA_IO_WR_COMBINE_FLUSH_BASE_IDX                                                            0
#define mmGCEA_IO_GROUP_BURST                                                                          0x1883
#define mmGCEA_IO_GROUP_BURST_BASE_IDX                                                                 0
#define mmGCEA_IO_RD_PRI_AGE                                                                           0x1884
#define mmGCEA_IO_RD_PRI_AGE_BASE_IDX                                                                  0
#define mmGCEA_IO_WR_PRI_AGE                                                                           0x1885
#define mmGCEA_IO_WR_PRI_AGE_BASE_IDX                                                                  0
#define mmGCEA_IO_RD_PRI_QUEUING                                                                       0x1886
#define mmGCEA_IO_RD_PRI_QUEUING_BASE_IDX                                                              0
#define mmGCEA_IO_WR_PRI_QUEUING                                                                       0x1887
#define mmGCEA_IO_WR_PRI_QUEUING_BASE_IDX                                                              0
#define mmGCEA_IO_RD_PRI_FIXED                                                                         0x1888
#define mmGCEA_IO_RD_PRI_FIXED_BASE_IDX                                                                0
#define mmGCEA_IO_WR_PRI_FIXED                                                                         0x1889
#define mmGCEA_IO_WR_PRI_FIXED_BASE_IDX                                                                0
#define mmGCEA_IO_RD_PRI_URGENCY                                                                       0x188a
#define mmGCEA_IO_RD_PRI_URGENCY_BASE_IDX                                                              0
#define mmGCEA_IO_WR_PRI_URGENCY                                                                       0x188b
#define mmGCEA_IO_WR_PRI_URGENCY_BASE_IDX                                                              0
#define mmGCEA_IO_RD_PRI_URGENCY_MASKING                                                               0x188c
#define mmGCEA_IO_RD_PRI_URGENCY_MASKING_BASE_IDX                                                      0
#define mmGCEA_IO_WR_PRI_URGENCY_MASKING                                                               0x188d
#define mmGCEA_IO_WR_PRI_URGENCY_MASKING_BASE_IDX                                                      0
#define mmGCEA_IO_RD_PRI_QUANT_PRI1                                                                    0x188e
#define mmGCEA_IO_RD_PRI_QUANT_PRI1_BASE_IDX                                                           0
#define mmGCEA_IO_RD_PRI_QUANT_PRI2                                                                    0x188f
#define mmGCEA_IO_RD_PRI_QUANT_PRI2_BASE_IDX                                                           0
#define mmGCEA_IO_RD_PRI_QUANT_PRI3                                                                    0x1890
#define mmGCEA_IO_RD_PRI_QUANT_PRI3_BASE_IDX                                                           0
#define mmGCEA_IO_WR_PRI_QUANT_PRI1                                                                    0x1891
#define mmGCEA_IO_WR_PRI_QUANT_PRI1_BASE_IDX                                                           0
#define mmGCEA_IO_WR_PRI_QUANT_PRI2                                                                    0x1892
#define mmGCEA_IO_WR_PRI_QUANT_PRI2_BASE_IDX                                                           0
#define mmGCEA_IO_WR_PRI_QUANT_PRI3                                                                    0x1893
#define mmGCEA_IO_WR_PRI_QUANT_PRI3_BASE_IDX                                                           0


// addressBlock: gc_tcdec
// base address: 0xac00
#define mmTCP_INVALIDATE                                                                               0x18a0
#define mmTCP_INVALIDATE_BASE_IDX                                                                      0
#define mmTCP_STATUS                                                                                   0x18a1
#define mmTCP_STATUS_BASE_IDX                                                                          0
#define mmTCP_EDC_CNT                                                                                  0x18b7
#define mmTCP_EDC_CNT_BASE_IDX                                                                         0
#define mmTCI_STATUS                                                                                   0x1901
#define mmTCI_STATUS_BASE_IDX                                                                          0
#define mmTCI_CNTL_1                                                                                   0x1902
#define mmTCI_CNTL_1_BASE_IDX                                                                          0
#define mmTCI_CNTL_2                                                                                   0x1903
#define mmTCI_CNTL_2_BASE_IDX                                                                          0


// addressBlock: gc_shdec
// base address: 0xb000
#define mmSPI_SHADER_PGM_RSRC4_PS                                                                      0x19a1
#define mmSPI_SHADER_PGM_RSRC4_PS_BASE_IDX                                                             0
#define mmSPI_SHADER_PGM_CHKSUM_PS                                                                     0x19a6
#define mmSPI_SHADER_PGM_CHKSUM_PS_BASE_IDX                                                            0
#define mmSPI_SHADER_PGM_RSRC3_PS                                                                      0x19a7
#define mmSPI_SHADER_PGM_RSRC3_PS_BASE_IDX                                                             0
#define mmSPI_SHADER_PGM_LO_PS                                                                         0x19a8
#define mmSPI_SHADER_PGM_LO_PS_BASE_IDX                                                                0
#define mmSPI_SHADER_PGM_HI_PS                                                                         0x19a9
#define mmSPI_SHADER_PGM_HI_PS_BASE_IDX                                                                0
#define mmSPI_SHADER_PGM_RSRC1_PS                                                                      0x19aa
#define mmSPI_SHADER_PGM_RSRC1_PS_BASE_IDX                                                             0
#define mmSPI_SHADER_PGM_RSRC2_PS                                                                      0x19ab
#define mmSPI_SHADER_PGM_RSRC2_PS_BASE_IDX                                                             0
#define mmSPI_SHADER_USER_DATA_PS_0                                                                    0x19ac
#define mmSPI_SHADER_USER_DATA_PS_0_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_PS_1                                                                    0x19ad
#define mmSPI_SHADER_USER_DATA_PS_1_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_PS_2                                                                    0x19ae
#define mmSPI_SHADER_USER_DATA_PS_2_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_PS_3                                                                    0x19af
#define mmSPI_SHADER_USER_DATA_PS_3_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_PS_4                                                                    0x19b0
#define mmSPI_SHADER_USER_DATA_PS_4_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_PS_5                                                                    0x19b1
#define mmSPI_SHADER_USER_DATA_PS_5_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_PS_6                                                                    0x19b2
#define mmSPI_SHADER_USER_DATA_PS_6_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_PS_7                                                                    0x19b3
#define mmSPI_SHADER_USER_DATA_PS_7_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_PS_8                                                                    0x19b4
#define mmSPI_SHADER_USER_DATA_PS_8_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_PS_9                                                                    0x19b5
#define mmSPI_SHADER_USER_DATA_PS_9_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_PS_10                                                                   0x19b6
#define mmSPI_SHADER_USER_DATA_PS_10_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_11                                                                   0x19b7
#define mmSPI_SHADER_USER_DATA_PS_11_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_12                                                                   0x19b8
#define mmSPI_SHADER_USER_DATA_PS_12_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_13                                                                   0x19b9
#define mmSPI_SHADER_USER_DATA_PS_13_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_14                                                                   0x19ba
#define mmSPI_SHADER_USER_DATA_PS_14_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_15                                                                   0x19bb
#define mmSPI_SHADER_USER_DATA_PS_15_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_16                                                                   0x19bc
#define mmSPI_SHADER_USER_DATA_PS_16_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_17                                                                   0x19bd
#define mmSPI_SHADER_USER_DATA_PS_17_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_18                                                                   0x19be
#define mmSPI_SHADER_USER_DATA_PS_18_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_19                                                                   0x19bf
#define mmSPI_SHADER_USER_DATA_PS_19_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_20                                                                   0x19c0
#define mmSPI_SHADER_USER_DATA_PS_20_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_21                                                                   0x19c1
#define mmSPI_SHADER_USER_DATA_PS_21_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_22                                                                   0x19c2
#define mmSPI_SHADER_USER_DATA_PS_22_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_23                                                                   0x19c3
#define mmSPI_SHADER_USER_DATA_PS_23_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_24                                                                   0x19c4
#define mmSPI_SHADER_USER_DATA_PS_24_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_25                                                                   0x19c5
#define mmSPI_SHADER_USER_DATA_PS_25_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_26                                                                   0x19c6
#define mmSPI_SHADER_USER_DATA_PS_26_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_27                                                                   0x19c7
#define mmSPI_SHADER_USER_DATA_PS_27_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_28                                                                   0x19c8
#define mmSPI_SHADER_USER_DATA_PS_28_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_29                                                                   0x19c9
#define mmSPI_SHADER_USER_DATA_PS_29_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_30                                                                   0x19ca
#define mmSPI_SHADER_USER_DATA_PS_30_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_31                                                                   0x19cb
#define mmSPI_SHADER_USER_DATA_PS_31_BASE_IDX                                                          0
#define mmSPI_SHADER_REQ_CTRL_PS                                                                       0x19d0
#define mmSPI_SHADER_REQ_CTRL_PS_BASE_IDX                                                              0
#define mmSPI_SHADER_USER_ACCUM_PS_0                                                                   0x19d2
#define mmSPI_SHADER_USER_ACCUM_PS_0_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_ACCUM_PS_1                                                                   0x19d3
#define mmSPI_SHADER_USER_ACCUM_PS_1_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_ACCUM_PS_2                                                                   0x19d4
#define mmSPI_SHADER_USER_ACCUM_PS_2_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_ACCUM_PS_3                                                                   0x19d5
#define mmSPI_SHADER_USER_ACCUM_PS_3_BASE_IDX                                                          0
#define mmSPI_SHADER_PGM_RSRC4_VS                                                                      0x19e1
#define mmSPI_SHADER_PGM_RSRC4_VS_BASE_IDX                                                             0
#define mmSPI_SHADER_PGM_CHKSUM_VS                                                                     0x19e5
#define mmSPI_SHADER_PGM_CHKSUM_VS_BASE_IDX                                                            0
#define mmSPI_SHADER_PGM_RSRC3_VS                                                                      0x19e6
#define mmSPI_SHADER_PGM_RSRC3_VS_BASE_IDX                                                             0
#define mmSPI_SHADER_LATE_ALLOC_VS                                                                     0x19e7
#define mmSPI_SHADER_LATE_ALLOC_VS_BASE_IDX                                                            0
#define mmSPI_SHADER_PGM_LO_VS                                                                         0x19e8
#define mmSPI_SHADER_PGM_LO_VS_BASE_IDX                                                                0
#define mmSPI_SHADER_PGM_HI_VS                                                                         0x19e9
#define mmSPI_SHADER_PGM_HI_VS_BASE_IDX                                                                0
#define mmSPI_SHADER_PGM_RSRC1_VS                                                                      0x19ea
#define mmSPI_SHADER_PGM_RSRC1_VS_BASE_IDX                                                             0
#define mmSPI_SHADER_PGM_RSRC2_VS                                                                      0x19eb
#define mmSPI_SHADER_PGM_RSRC2_VS_BASE_IDX                                                             0
#define mmSPI_SHADER_USER_DATA_VS_0                                                                    0x19ec
#define mmSPI_SHADER_USER_DATA_VS_0_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_VS_1                                                                    0x19ed
#define mmSPI_SHADER_USER_DATA_VS_1_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_VS_2                                                                    0x19ee
#define mmSPI_SHADER_USER_DATA_VS_2_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_VS_3                                                                    0x19ef
#define mmSPI_SHADER_USER_DATA_VS_3_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_VS_4                                                                    0x19f0
#define mmSPI_SHADER_USER_DATA_VS_4_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_VS_5                                                                    0x19f1
#define mmSPI_SHADER_USER_DATA_VS_5_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_VS_6                                                                    0x19f2
#define mmSPI_SHADER_USER_DATA_VS_6_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_VS_7                                                                    0x19f3
#define mmSPI_SHADER_USER_DATA_VS_7_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_VS_8                                                                    0x19f4
#define mmSPI_SHADER_USER_DATA_VS_8_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_VS_9                                                                    0x19f5
#define mmSPI_SHADER_USER_DATA_VS_9_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_VS_10                                                                   0x19f6
#define mmSPI_SHADER_USER_DATA_VS_10_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_11                                                                   0x19f7
#define mmSPI_SHADER_USER_DATA_VS_11_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_12                                                                   0x19f8
#define mmSPI_SHADER_USER_DATA_VS_12_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_13                                                                   0x19f9
#define mmSPI_SHADER_USER_DATA_VS_13_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_14                                                                   0x19fa
#define mmSPI_SHADER_USER_DATA_VS_14_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_15                                                                   0x19fb
#define mmSPI_SHADER_USER_DATA_VS_15_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_16                                                                   0x19fc
#define mmSPI_SHADER_USER_DATA_VS_16_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_17                                                                   0x19fd
#define mmSPI_SHADER_USER_DATA_VS_17_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_18                                                                   0x19fe
#define mmSPI_SHADER_USER_DATA_VS_18_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_19                                                                   0x19ff
#define mmSPI_SHADER_USER_DATA_VS_19_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_20                                                                   0x1a00
#define mmSPI_SHADER_USER_DATA_VS_20_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_21                                                                   0x1a01
#define mmSPI_SHADER_USER_DATA_VS_21_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_22                                                                   0x1a02
#define mmSPI_SHADER_USER_DATA_VS_22_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_23                                                                   0x1a03
#define mmSPI_SHADER_USER_DATA_VS_23_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_24                                                                   0x1a04
#define mmSPI_SHADER_USER_DATA_VS_24_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_25                                                                   0x1a05
#define mmSPI_SHADER_USER_DATA_VS_25_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_26                                                                   0x1a06
#define mmSPI_SHADER_USER_DATA_VS_26_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_27                                                                   0x1a07
#define mmSPI_SHADER_USER_DATA_VS_27_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_28                                                                   0x1a08
#define mmSPI_SHADER_USER_DATA_VS_28_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_29                                                                   0x1a09
#define mmSPI_SHADER_USER_DATA_VS_29_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_30                                                                   0x1a0a
#define mmSPI_SHADER_USER_DATA_VS_30_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_31                                                                   0x1a0b
#define mmSPI_SHADER_USER_DATA_VS_31_BASE_IDX                                                          0
#define mmSPI_SHADER_REQ_CTRL_VS                                                                       0x1a10
#define mmSPI_SHADER_REQ_CTRL_VS_BASE_IDX                                                              0
#define mmSPI_SHADER_USER_ACCUM_VS_0                                                                   0x1a12
#define mmSPI_SHADER_USER_ACCUM_VS_0_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_ACCUM_VS_1                                                                   0x1a13
#define mmSPI_SHADER_USER_ACCUM_VS_1_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_ACCUM_VS_2                                                                   0x1a14
#define mmSPI_SHADER_USER_ACCUM_VS_2_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_ACCUM_VS_3                                                                   0x1a15
#define mmSPI_SHADER_USER_ACCUM_VS_3_BASE_IDX                                                          0
#define mmSPI_SHADER_PGM_RSRC2_GS_VS                                                                   0x1a1b
#define mmSPI_SHADER_PGM_RSRC2_GS_VS_BASE_IDX                                                          0
#define mmSPI_SHADER_PGM_CHKSUM_GS                                                                     0x1a20
#define mmSPI_SHADER_PGM_CHKSUM_GS_BASE_IDX                                                            0
#define mmSPI_SHADER_PGM_RSRC4_GS                                                                      0x1a21
#define mmSPI_SHADER_PGM_RSRC4_GS_BASE_IDX                                                             0
#define mmSPI_SHADER_USER_DATA_ADDR_LO_GS                                                              0x1a22
#define mmSPI_SHADER_USER_DATA_ADDR_LO_GS_BASE_IDX                                                     0
#define mmSPI_SHADER_USER_DATA_ADDR_HI_GS                                                              0x1a23
#define mmSPI_SHADER_USER_DATA_ADDR_HI_GS_BASE_IDX                                                     0
#define mmSPI_SHADER_PGM_LO_ES_GS                                                                      0x1a24
#define mmSPI_SHADER_PGM_LO_ES_GS_BASE_IDX                                                             0
#define mmSPI_SHADER_PGM_HI_ES_GS                                                                      0x1a25
#define mmSPI_SHADER_PGM_HI_ES_GS_BASE_IDX                                                             0
#define mmSPI_SHADER_PGM_RSRC3_GS                                                                      0x1a27
#define mmSPI_SHADER_PGM_RSRC3_GS_BASE_IDX                                                             0
#define mmSPI_SHADER_PGM_LO_GS                                                                         0x1a28
#define mmSPI_SHADER_PGM_LO_GS_BASE_IDX                                                                0
#define mmSPI_SHADER_PGM_HI_GS                                                                         0x1a29
#define mmSPI_SHADER_PGM_HI_GS_BASE_IDX                                                                0
#define mmSPI_SHADER_PGM_RSRC1_GS                                                                      0x1a2a
#define mmSPI_SHADER_PGM_RSRC1_GS_BASE_IDX                                                             0
#define mmSPI_SHADER_PGM_RSRC2_GS                                                                      0x1a2b
#define mmSPI_SHADER_PGM_RSRC2_GS_BASE_IDX                                                             0
#define mmSPI_SHADER_USER_DATA_GS_0                                                                    0x1a2c
#define mmSPI_SHADER_USER_DATA_GS_0_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_GS_1                                                                    0x1a2d
#define mmSPI_SHADER_USER_DATA_GS_1_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_GS_2                                                                    0x1a2e
#define mmSPI_SHADER_USER_DATA_GS_2_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_GS_3                                                                    0x1a2f
#define mmSPI_SHADER_USER_DATA_GS_3_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_GS_4                                                                    0x1a30
#define mmSPI_SHADER_USER_DATA_GS_4_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_GS_5                                                                    0x1a31
#define mmSPI_SHADER_USER_DATA_GS_5_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_GS_6                                                                    0x1a32
#define mmSPI_SHADER_USER_DATA_GS_6_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_GS_7                                                                    0x1a33
#define mmSPI_SHADER_USER_DATA_GS_7_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_GS_8                                                                    0x1a34
#define mmSPI_SHADER_USER_DATA_GS_8_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_GS_9                                                                    0x1a35
#define mmSPI_SHADER_USER_DATA_GS_9_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_GS_10                                                                   0x1a36
#define mmSPI_SHADER_USER_DATA_GS_10_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_GS_11                                                                   0x1a37
#define mmSPI_SHADER_USER_DATA_GS_11_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_GS_12                                                                   0x1a38
#define mmSPI_SHADER_USER_DATA_GS_12_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_GS_13                                                                   0x1a39
#define mmSPI_SHADER_USER_DATA_GS_13_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_GS_14                                                                   0x1a3a
#define mmSPI_SHADER_USER_DATA_GS_14_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_GS_15                                                                   0x1a3b
#define mmSPI_SHADER_USER_DATA_GS_15_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_GS_16                                                                   0x1a3c
#define mmSPI_SHADER_USER_DATA_GS_16_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_GS_17                                                                   0x1a3d
#define mmSPI_SHADER_USER_DATA_GS_17_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_GS_18                                                                   0x1a3e
#define mmSPI_SHADER_USER_DATA_GS_18_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_GS_19                                                                   0x1a3f
#define mmSPI_SHADER_USER_DATA_GS_19_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_GS_20                                                                   0x1a40
#define mmSPI_SHADER_USER_DATA_GS_20_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_GS_21                                                                   0x1a41
#define mmSPI_SHADER_USER_DATA_GS_21_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_GS_22                                                                   0x1a42
#define mmSPI_SHADER_USER_DATA_GS_22_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_GS_23                                                                   0x1a43
#define mmSPI_SHADER_USER_DATA_GS_23_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_GS_24                                                                   0x1a44
#define mmSPI_SHADER_USER_DATA_GS_24_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_GS_25                                                                   0x1a45
#define mmSPI_SHADER_USER_DATA_GS_25_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_GS_26                                                                   0x1a46
#define mmSPI_SHADER_USER_DATA_GS_26_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_GS_27                                                                   0x1a47
#define mmSPI_SHADER_USER_DATA_GS_27_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_GS_28                                                                   0x1a48
#define mmSPI_SHADER_USER_DATA_GS_28_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_GS_29                                                                   0x1a49
#define mmSPI_SHADER_USER_DATA_GS_29_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_GS_30                                                                   0x1a4a
#define mmSPI_SHADER_USER_DATA_GS_30_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_GS_31                                                                   0x1a4b
#define mmSPI_SHADER_USER_DATA_GS_31_BASE_IDX                                                          0
#define mmSPI_SHADER_REQ_CTRL_ESGS                                                                     0x1a50
#define mmSPI_SHADER_REQ_CTRL_ESGS_BASE_IDX                                                            0
#define mmSPI_SHADER_USER_ACCUM_ESGS_0                                                                 0x1a52
#define mmSPI_SHADER_USER_ACCUM_ESGS_0_BASE_IDX                                                        0
#define mmSPI_SHADER_USER_ACCUM_ESGS_1                                                                 0x1a53
#define mmSPI_SHADER_USER_ACCUM_ESGS_1_BASE_IDX                                                        0
#define mmSPI_SHADER_USER_ACCUM_ESGS_2                                                                 0x1a54
#define mmSPI_SHADER_USER_ACCUM_ESGS_2_BASE_IDX                                                        0
#define mmSPI_SHADER_USER_ACCUM_ESGS_3                                                                 0x1a55
#define mmSPI_SHADER_USER_ACCUM_ESGS_3_BASE_IDX                                                        0
#define mmSPI_SHADER_PGM_LO_ES                                                                         0x1a68
#define mmSPI_SHADER_PGM_LO_ES_BASE_IDX                                                                0
#define mmSPI_SHADER_PGM_HI_ES                                                                         0x1a69
#define mmSPI_SHADER_PGM_HI_ES_BASE_IDX                                                                0
#define mmSPI_SHADER_PGM_CHKSUM_HS                                                                     0x1aa0
#define mmSPI_SHADER_PGM_CHKSUM_HS_BASE_IDX                                                            0
#define mmSPI_SHADER_PGM_RSRC4_HS                                                                      0x1aa1
#define mmSPI_SHADER_PGM_RSRC4_HS_BASE_IDX                                                             0
#define mmSPI_SHADER_USER_DATA_ADDR_LO_HS                                                              0x1aa2
#define mmSPI_SHADER_USER_DATA_ADDR_LO_HS_BASE_IDX                                                     0
#define mmSPI_SHADER_USER_DATA_ADDR_HI_HS                                                              0x1aa3
#define mmSPI_SHADER_USER_DATA_ADDR_HI_HS_BASE_IDX                                                     0
#define mmSPI_SHADER_PGM_LO_LS_HS                                                                      0x1aa4
#define mmSPI_SHADER_PGM_LO_LS_HS_BASE_IDX                                                             0
#define mmSPI_SHADER_PGM_HI_LS_HS                                                                      0x1aa5
#define mmSPI_SHADER_PGM_HI_LS_HS_BASE_IDX                                                             0
#define mmSPI_SHADER_PGM_RSRC3_HS                                                                      0x1aa7
#define mmSPI_SHADER_PGM_RSRC3_HS_BASE_IDX                                                             0
#define mmSPI_SHADER_PGM_LO_HS                                                                         0x1aa8
#define mmSPI_SHADER_PGM_LO_HS_BASE_IDX                                                                0
#define mmSPI_SHADER_PGM_HI_HS                                                                         0x1aa9
#define mmSPI_SHADER_PGM_HI_HS_BASE_IDX                                                                0
#define mmSPI_SHADER_PGM_RSRC1_HS                                                                      0x1aaa
#define mmSPI_SHADER_PGM_RSRC1_HS_BASE_IDX                                                             0
#define mmSPI_SHADER_PGM_RSRC2_HS                                                                      0x1aab
#define mmSPI_SHADER_PGM_RSRC2_HS_BASE_IDX                                                             0
#define mmSPI_SHADER_USER_DATA_HS_0                                                                    0x1aac
#define mmSPI_SHADER_USER_DATA_HS_0_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_HS_1                                                                    0x1aad
#define mmSPI_SHADER_USER_DATA_HS_1_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_HS_2                                                                    0x1aae
#define mmSPI_SHADER_USER_DATA_HS_2_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_HS_3                                                                    0x1aaf
#define mmSPI_SHADER_USER_DATA_HS_3_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_HS_4                                                                    0x1ab0
#define mmSPI_SHADER_USER_DATA_HS_4_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_HS_5                                                                    0x1ab1
#define mmSPI_SHADER_USER_DATA_HS_5_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_HS_6                                                                    0x1ab2
#define mmSPI_SHADER_USER_DATA_HS_6_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_HS_7                                                                    0x1ab3
#define mmSPI_SHADER_USER_DATA_HS_7_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_HS_8                                                                    0x1ab4
#define mmSPI_SHADER_USER_DATA_HS_8_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_HS_9                                                                    0x1ab5
#define mmSPI_SHADER_USER_DATA_HS_9_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_HS_10                                                                   0x1ab6
#define mmSPI_SHADER_USER_DATA_HS_10_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_HS_11                                                                   0x1ab7
#define mmSPI_SHADER_USER_DATA_HS_11_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_HS_12                                                                   0x1ab8
#define mmSPI_SHADER_USER_DATA_HS_12_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_HS_13                                                                   0x1ab9
#define mmSPI_SHADER_USER_DATA_HS_13_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_HS_14                                                                   0x1aba
#define mmSPI_SHADER_USER_DATA_HS_14_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_HS_15                                                                   0x1abb
#define mmSPI_SHADER_USER_DATA_HS_15_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_HS_16                                                                   0x1abc
#define mmSPI_SHADER_USER_DATA_HS_16_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_HS_17                                                                   0x1abd
#define mmSPI_SHADER_USER_DATA_HS_17_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_HS_18                                                                   0x1abe
#define mmSPI_SHADER_USER_DATA_HS_18_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_HS_19                                                                   0x1abf
#define mmSPI_SHADER_USER_DATA_HS_19_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_HS_20                                                                   0x1ac0
#define mmSPI_SHADER_USER_DATA_HS_20_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_HS_21                                                                   0x1ac1
#define mmSPI_SHADER_USER_DATA_HS_21_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_HS_22                                                                   0x1ac2
#define mmSPI_SHADER_USER_DATA_HS_22_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_HS_23                                                                   0x1ac3
#define mmSPI_SHADER_USER_DATA_HS_23_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_HS_24                                                                   0x1ac4
#define mmSPI_SHADER_USER_DATA_HS_24_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_HS_25                                                                   0x1ac5
#define mmSPI_SHADER_USER_DATA_HS_25_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_HS_26                                                                   0x1ac6
#define mmSPI_SHADER_USER_DATA_HS_26_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_HS_27                                                                   0x1ac7
#define mmSPI_SHADER_USER_DATA_HS_27_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_HS_28                                                                   0x1ac8
#define mmSPI_SHADER_USER_DATA_HS_28_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_HS_29                                                                   0x1ac9
#define mmSPI_SHADER_USER_DATA_HS_29_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_HS_30                                                                   0x1aca
#define mmSPI_SHADER_USER_DATA_HS_30_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_HS_31                                                                   0x1acb
#define mmSPI_SHADER_USER_DATA_HS_31_BASE_IDX                                                          0
#define mmSPI_SHADER_REQ_CTRL_LSHS                                                                     0x1ad0
#define mmSPI_SHADER_REQ_CTRL_LSHS_BASE_IDX                                                            0
#define mmSPI_SHADER_USER_ACCUM_LSHS_0                                                                 0x1ad2
#define mmSPI_SHADER_USER_ACCUM_LSHS_0_BASE_IDX                                                        0
#define mmSPI_SHADER_USER_ACCUM_LSHS_1                                                                 0x1ad3
#define mmSPI_SHADER_USER_ACCUM_LSHS_1_BASE_IDX                                                        0
#define mmSPI_SHADER_USER_ACCUM_LSHS_2                                                                 0x1ad4
#define mmSPI_SHADER_USER_ACCUM_LSHS_2_BASE_IDX                                                        0
#define mmSPI_SHADER_USER_ACCUM_LSHS_3                                                                 0x1ad5
#define mmSPI_SHADER_USER_ACCUM_LSHS_3_BASE_IDX                                                        0
#define mmSPI_SHADER_PGM_LO_LS                                                                         0x1ae8
#define mmSPI_SHADER_PGM_LO_LS_BASE_IDX                                                                0
#define mmSPI_SHADER_PGM_HI_LS                                                                         0x1ae9
#define mmSPI_SHADER_PGM_HI_LS_BASE_IDX                                                                0
#define mmCOMPUTE_DISPATCH_INITIATOR                                                                   0x1ba0
#define mmCOMPUTE_DISPATCH_INITIATOR_BASE_IDX                                                          0
#define mmCOMPUTE_DIM_X                                                                                0x1ba1
#define mmCOMPUTE_DIM_X_BASE_IDX                                                                       0
#define mmCOMPUTE_DIM_Y                                                                                0x1ba2
#define mmCOMPUTE_DIM_Y_BASE_IDX                                                                       0
#define mmCOMPUTE_DIM_Z                                                                                0x1ba3
#define mmCOMPUTE_DIM_Z_BASE_IDX                                                                       0
#define mmCOMPUTE_START_X                                                                              0x1ba4
#define mmCOMPUTE_START_X_BASE_IDX                                                                     0
#define mmCOMPUTE_START_Y                                                                              0x1ba5
#define mmCOMPUTE_START_Y_BASE_IDX                                                                     0
#define mmCOMPUTE_START_Z                                                                              0x1ba6
#define mmCOMPUTE_START_Z_BASE_IDX                                                                     0
#define mmCOMPUTE_NUM_THREAD_X                                                                         0x1ba7
#define mmCOMPUTE_NUM_THREAD_X_BASE_IDX                                                                0
#define mmCOMPUTE_NUM_THREAD_Y                                                                         0x1ba8
#define mmCOMPUTE_NUM_THREAD_Y_BASE_IDX                                                                0
#define mmCOMPUTE_NUM_THREAD_Z                                                                         0x1ba9
#define mmCOMPUTE_NUM_THREAD_Z_BASE_IDX                                                                0
#define mmCOMPUTE_PIPELINESTAT_ENABLE                                                                  0x1baa
#define mmCOMPUTE_PIPELINESTAT_ENABLE_BASE_IDX                                                         0
#define mmCOMPUTE_PERFCOUNT_ENABLE                                                                     0x1bab
#define mmCOMPUTE_PERFCOUNT_ENABLE_BASE_IDX                                                            0
#define mmCOMPUTE_PGM_LO                                                                               0x1bac
#define mmCOMPUTE_PGM_LO_BASE_IDX                                                                      0
#define mmCOMPUTE_PGM_HI                                                                               0x1bad
#define mmCOMPUTE_PGM_HI_BASE_IDX                                                                      0
#define mmCOMPUTE_DISPATCH_PKT_ADDR_LO                                                                 0x1bae
#define mmCOMPUTE_DISPATCH_PKT_ADDR_LO_BASE_IDX                                                        0
#define mmCOMPUTE_DISPATCH_PKT_ADDR_HI                                                                 0x1baf
#define mmCOMPUTE_DISPATCH_PKT_ADDR_HI_BASE_IDX                                                        0
#define mmCOMPUTE_DISPATCH_SCRATCH_BASE_LO                                                             0x1bb0
#define mmCOMPUTE_DISPATCH_SCRATCH_BASE_LO_BASE_IDX                                                    0
#define mmCOMPUTE_DISPATCH_SCRATCH_BASE_HI                                                             0x1bb1
#define mmCOMPUTE_DISPATCH_SCRATCH_BASE_HI_BASE_IDX                                                    0
#define mmCOMPUTE_PGM_RSRC1                                                                            0x1bb2
#define mmCOMPUTE_PGM_RSRC1_BASE_IDX                                                                   0
#define mmCOMPUTE_PGM_RSRC2                                                                            0x1bb3
#define mmCOMPUTE_PGM_RSRC2_BASE_IDX                                                                   0
#define mmCOMPUTE_VMID                                                                                 0x1bb4
#define mmCOMPUTE_VMID_BASE_IDX                                                                        0
#define mmCOMPUTE_RESOURCE_LIMITS                                                                      0x1bb5
#define mmCOMPUTE_RESOURCE_LIMITS_BASE_IDX                                                             0
#define mmCOMPUTE_DESTINATION_EN_SE0                                                                   0x1bb6
#define mmCOMPUTE_DESTINATION_EN_SE0_BASE_IDX                                                          0
#define mmCOMPUTE_STATIC_THREAD_MGMT_SE0                                                               0x1bb6
#define mmCOMPUTE_STATIC_THREAD_MGMT_SE0_BASE_IDX                                                      0
#define mmCOMPUTE_DESTINATION_EN_SE1                                                                   0x1bb7
#define mmCOMPUTE_DESTINATION_EN_SE1_BASE_IDX                                                          0
#define mmCOMPUTE_STATIC_THREAD_MGMT_SE1                                                               0x1bb7
#define mmCOMPUTE_STATIC_THREAD_MGMT_SE1_BASE_IDX                                                      0
#define mmCOMPUTE_TMPRING_SIZE                                                                         0x1bb8
#define mmCOMPUTE_TMPRING_SIZE_BASE_IDX                                                                0
#define mmCOMPUTE_DESTINATION_EN_SE2                                                                   0x1bb9
#define mmCOMPUTE_DESTINATION_EN_SE2_BASE_IDX                                                          0
#define mmCOMPUTE_STATIC_THREAD_MGMT_SE2                                                               0x1bb9
#define mmCOMPUTE_STATIC_THREAD_MGMT_SE2_BASE_IDX                                                      0
#define mmCOMPUTE_DESTINATION_EN_SE3                                                                   0x1bba
#define mmCOMPUTE_DESTINATION_EN_SE3_BASE_IDX                                                          0
#define mmCOMPUTE_STATIC_THREAD_MGMT_SE3                                                               0x1bba
#define mmCOMPUTE_STATIC_THREAD_MGMT_SE3_BASE_IDX                                                      0
#define mmCOMPUTE_RESTART_X                                                                            0x1bbb
#define mmCOMPUTE_RESTART_X_BASE_IDX                                                                   0
#define mmCOMPUTE_RESTART_Y                                                                            0x1bbc
#define mmCOMPUTE_RESTART_Y_BASE_IDX                                                                   0
#define mmCOMPUTE_RESTART_Z                                                                            0x1bbd
#define mmCOMPUTE_RESTART_Z_BASE_IDX                                                                   0
#define mmCOMPUTE_THREAD_TRACE_ENABLE                                                                  0x1bbe
#define mmCOMPUTE_THREAD_TRACE_ENABLE_BASE_IDX                                                         0
#define mmCOMPUTE_MISC_RESERVED                                                                        0x1bbf
#define mmCOMPUTE_MISC_RESERVED_BASE_IDX                                                               0
#define mmCOMPUTE_DISPATCH_ID                                                                          0x1bc0
#define mmCOMPUTE_DISPATCH_ID_BASE_IDX                                                                 0
#define mmCOMPUTE_THREADGROUP_ID                                                                       0x1bc1
#define mmCOMPUTE_THREADGROUP_ID_BASE_IDX                                                              0
#define mmCOMPUTE_REQ_CTRL                                                                             0x1bc2
#define mmCOMPUTE_REQ_CTRL_BASE_IDX                                                                    0
#define mmCOMPUTE_USER_ACCUM_0                                                                         0x1bc4
#define mmCOMPUTE_USER_ACCUM_0_BASE_IDX                                                                0
#define mmCOMPUTE_USER_ACCUM_1                                                                         0x1bc5
#define mmCOMPUTE_USER_ACCUM_1_BASE_IDX                                                                0
#define mmCOMPUTE_USER_ACCUM_2                                                                         0x1bc6
#define mmCOMPUTE_USER_ACCUM_2_BASE_IDX                                                                0
#define mmCOMPUTE_USER_ACCUM_3                                                                         0x1bc7
#define mmCOMPUTE_USER_ACCUM_3_BASE_IDX                                                                0
#define mmCOMPUTE_PGM_RSRC3                                                                            0x1bc8
#define mmCOMPUTE_PGM_RSRC3_BASE_IDX                                                                   0
#define mmCOMPUTE_DDID_INDEX                                                                           0x1bc9
#define mmCOMPUTE_DDID_INDEX_BASE_IDX                                                                  0
#define mmCOMPUTE_SHADER_CHKSUM                                                                        0x1bca
#define mmCOMPUTE_SHADER_CHKSUM_BASE_IDX                                                               0
#define mmCOMPUTE_RELAUNCH                                                                             0x1bcb
#define mmCOMPUTE_RELAUNCH_BASE_IDX                                                                    0
#define mmCOMPUTE_WAVE_RESTORE_ADDR_LO                                                                 0x1bcc
#define mmCOMPUTE_WAVE_RESTORE_ADDR_LO_BASE_IDX                                                        0
#define mmCOMPUTE_WAVE_RESTORE_ADDR_HI                                                                 0x1bcd
#define mmCOMPUTE_WAVE_RESTORE_ADDR_HI_BASE_IDX                                                        0
#define mmCOMPUTE_RELAUNCH2                                                                            0x1bce
#define mmCOMPUTE_RELAUNCH2_BASE_IDX                                                                   0
#define mmCOMPUTE_USER_DATA_0                                                                          0x1be0
#define mmCOMPUTE_USER_DATA_0_BASE_IDX                                                                 0
#define mmCOMPUTE_USER_DATA_1                                                                          0x1be1
#define mmCOMPUTE_USER_DATA_1_BASE_IDX                                                                 0
#define mmCOMPUTE_USER_DATA_2                                                                          0x1be2
#define mmCOMPUTE_USER_DATA_2_BASE_IDX                                                                 0
#define mmCOMPUTE_USER_DATA_3                                                                          0x1be3
#define mmCOMPUTE_USER_DATA_3_BASE_IDX                                                                 0
#define mmCOMPUTE_USER_DATA_4                                                                          0x1be4
#define mmCOMPUTE_USER_DATA_4_BASE_IDX                                                                 0
#define mmCOMPUTE_USER_DATA_5                                                                          0x1be5
#define mmCOMPUTE_USER_DATA_5_BASE_IDX                                                                 0
#define mmCOMPUTE_USER_DATA_6                                                                          0x1be6
#define mmCOMPUTE_USER_DATA_6_BASE_IDX                                                                 0
#define mmCOMPUTE_USER_DATA_7                                                                          0x1be7
#define mmCOMPUTE_USER_DATA_7_BASE_IDX                                                                 0
#define mmCOMPUTE_USER_DATA_8                                                                          0x1be8
#define mmCOMPUTE_USER_DATA_8_BASE_IDX                                                                 0
#define mmCOMPUTE_USER_DATA_9                                                                          0x1be9
#define mmCOMPUTE_USER_DATA_9_BASE_IDX                                                                 0
#define mmCOMPUTE_USER_DATA_10                                                                         0x1bea
#define mmCOMPUTE_USER_DATA_10_BASE_IDX                                                                0
#define mmCOMPUTE_USER_DATA_11                                                                         0x1beb
#define mmCOMPUTE_USER_DATA_11_BASE_IDX                                                                0
#define mmCOMPUTE_USER_DATA_12                                                                         0x1bec
#define mmCOMPUTE_USER_DATA_12_BASE_IDX                                                                0
#define mmCOMPUTE_USER_DATA_13                                                                         0x1bed
#define mmCOMPUTE_USER_DATA_13_BASE_IDX                                                                0
#define mmCOMPUTE_USER_DATA_14                                                                         0x1bee
#define mmCOMPUTE_USER_DATA_14_BASE_IDX                                                                0
#define mmCOMPUTE_USER_DATA_15                                                                         0x1bef
#define mmCOMPUTE_USER_DATA_15_BASE_IDX                                                                0
#define mmCOMPUTE_DISPATCH_TUNNEL                                                                      0x1c1d
#define mmCOMPUTE_DISPATCH_TUNNEL_BASE_IDX                                                             0
#define mmCOMPUTE_DISPATCH_END                                                                         0x1c1e
#define mmCOMPUTE_DISPATCH_END_BASE_IDX                                                                0
#define mmCOMPUTE_NOWHERE                                                                              0x1c1f
#define mmCOMPUTE_NOWHERE_BASE_IDX                                                                     0
#define mmSH_RESERVED_REG0                                                                             0x1c20
#define mmSH_RESERVED_REG0_BASE_IDX                                                                    0
#define mmSH_RESERVED_REG1                                                                             0x1c21
#define mmSH_RESERVED_REG1_BASE_IDX                                                                    0


// addressBlock: gc_cppdec
// base address: 0xc080
#define mmCP_EOPQ_WAIT_TIME                                                                            0x1dd5
#define mmCP_EOPQ_WAIT_TIME_BASE_IDX                                                                   0
#define mmCP_CPC_MGCG_SYNC_CNTL                                                                        0x1dd6
#define mmCP_CPC_MGCG_SYNC_CNTL_BASE_IDX                                                               0
#define mmCPC_INT_INFO                                                                                 0x1dd7
#define mmCPC_INT_INFO_BASE_IDX                                                                        0
#define mmCP_VIRT_STATUS                                                                               0x1dd8
#define mmCP_VIRT_STATUS_BASE_IDX                                                                      0
#define mmCPC_INT_ADDR                                                                                 0x1dd9
#define mmCPC_INT_ADDR_BASE_IDX                                                                        0
#define mmCPC_INT_PASID                                                                                0x1dda
#define mmCPC_INT_PASID_BASE_IDX                                                                       0
#define mmCP_GFX_ERROR                                                                                 0x1ddb
#define mmCP_GFX_ERROR_BASE_IDX                                                                        0
#define mmCPG_UTCL1_CNTL                                                                               0x1ddc
#define mmCPG_UTCL1_CNTL_BASE_IDX                                                                      0
#define mmCPC_UTCL1_CNTL                                                                               0x1ddd
#define mmCPC_UTCL1_CNTL_BASE_IDX                                                                      0
#define mmCPF_UTCL1_CNTL                                                                               0x1dde
#define mmCPF_UTCL1_CNTL_BASE_IDX                                                                      0
#define mmCP_AQL_SMM_STATUS                                                                            0x1ddf
#define mmCP_AQL_SMM_STATUS_BASE_IDX                                                                   0
#define mmCP_RB0_BASE                                                                                  0x1de0
#define mmCP_RB0_BASE_BASE_IDX                                                                         0
#define mmCP_RB_BASE                                                                                   0x1de0
#define mmCP_RB_BASE_BASE_IDX                                                                          0
#define mmCP_RB0_CNTL                                                                                  0x1de1
#define mmCP_RB0_CNTL_BASE_IDX                                                                         0
#define mmCP_RB_CNTL                                                                                   0x1de1
#define mmCP_RB_CNTL_BASE_IDX                                                                          0
#define mmCP_RB_RPTR_WR                                                                                0x1de2
#define mmCP_RB_RPTR_WR_BASE_IDX                                                                       0
#define mmCP_RB0_RPTR_ADDR                                                                             0x1de3
#define mmCP_RB0_RPTR_ADDR_BASE_IDX                                                                    0
#define mmCP_RB_RPTR_ADDR                                                                              0x1de3
#define mmCP_RB_RPTR_ADDR_BASE_IDX                                                                     0
#define mmCP_RB0_RPTR_ADDR_HI                                                                          0x1de4
#define mmCP_RB0_RPTR_ADDR_HI_BASE_IDX                                                                 0
#define mmCP_RB_RPTR_ADDR_HI                                                                           0x1de4
#define mmCP_RB_RPTR_ADDR_HI_BASE_IDX                                                                  0
#define mmCP_RB0_BUFSZ_MASK                                                                            0x1de5
#define mmCP_RB0_BUFSZ_MASK_BASE_IDX                                                                   0
#define mmCP_RB_BUFSZ_MASK                                                                             0x1de5
#define mmCP_RB_BUFSZ_MASK_BASE_IDX                                                                    0
#define mmCP_INT_CNTL                                                                                  0x1de9
#define mmCP_INT_CNTL_BASE_IDX                                                                         0
#define mmCP_INT_STATUS                                                                                0x1dea
#define mmCP_INT_STATUS_BASE_IDX                                                                       0
#define mmCP_DEVICE_ID                                                                                 0x1deb
#define mmCP_DEVICE_ID_BASE_IDX                                                                        0
#define mmCP_ME0_PIPE_PRIORITY_CNTS                                                                    0x1dec
#define mmCP_ME0_PIPE_PRIORITY_CNTS_BASE_IDX                                                           0
#define mmCP_RING_PRIORITY_CNTS                                                                        0x1dec
#define mmCP_RING_PRIORITY_CNTS_BASE_IDX                                                               0
#define mmCP_ME0_PIPE0_PRIORITY                                                                        0x1ded
#define mmCP_ME0_PIPE0_PRIORITY_BASE_IDX                                                               0
#define mmCP_RING0_PRIORITY                                                                            0x1ded
#define mmCP_RING0_PRIORITY_BASE_IDX                                                                   0
#define mmCP_ME0_PIPE1_PRIORITY                                                                        0x1dee
#define mmCP_ME0_PIPE1_PRIORITY_BASE_IDX                                                               0
#define mmCP_RING1_PRIORITY                                                                            0x1dee
#define mmCP_RING1_PRIORITY_BASE_IDX                                                                   0
#define mmCP_ME0_PIPE2_PRIORITY                                                                        0x1def
#define mmCP_ME0_PIPE2_PRIORITY_BASE_IDX                                                               0
#define mmCP_RING2_PRIORITY                                                                            0x1def
#define mmCP_RING2_PRIORITY_BASE_IDX                                                                   0
#define mmCP_FATAL_ERROR                                                                               0x1df0
#define mmCP_FATAL_ERROR_BASE_IDX                                                                      0
#define mmCP_RB_VMID                                                                                   0x1df1
#define mmCP_RB_VMID_BASE_IDX                                                                          0
#define mmCP_ME0_PIPE0_VMID                                                                            0x1df2
#define mmCP_ME0_PIPE0_VMID_BASE_IDX                                                                   0
#define mmCP_ME0_PIPE1_VMID                                                                            0x1df3
#define mmCP_ME0_PIPE1_VMID_BASE_IDX                                                                   0
#define mmCP_RB0_WPTR                                                                                  0x1df4
#define mmCP_RB0_WPTR_BASE_IDX                                                                         0
#define mmCP_RB_WPTR                                                                                   0x1df4
#define mmCP_RB_WPTR_BASE_IDX                                                                          0
#define mmCP_RB0_WPTR_HI                                                                               0x1df5
#define mmCP_RB0_WPTR_HI_BASE_IDX                                                                      0
#define mmCP_RB_WPTR_HI                                                                                0x1df5
#define mmCP_RB_WPTR_HI_BASE_IDX                                                                       0
#define mmCP_RB1_WPTR                                                                                  0x1df6
#define mmCP_RB1_WPTR_BASE_IDX                                                                         0
#define mmCP_RB1_WPTR_HI                                                                               0x1df7
#define mmCP_RB1_WPTR_HI_BASE_IDX                                                                      0
#define mmCP_RB2_WPTR                                                                                  0x1df8
#define mmCP_RB2_WPTR_BASE_IDX                                                                         0
#define mmCP_PROCESS_QUANTUM                                                                           0x1df9
#define mmCP_PROCESS_QUANTUM_BASE_IDX                                                                  0
#define mmCP_RB_DOORBELL_RANGE_LOWER                                                                   0x1dfa
#define mmCP_RB_DOORBELL_RANGE_LOWER_BASE_IDX                                                          0
#define mmCP_RB_DOORBELL_RANGE_UPPER                                                                   0x1dfb
#define mmCP_RB_DOORBELL_RANGE_UPPER_BASE_IDX                                                          0
#define mmCP_MEC_DOORBELL_RANGE_LOWER                                                                  0x1dfc
#define mmCP_MEC_DOORBELL_RANGE_LOWER_BASE_IDX                                                         0
#define mmCP_MEC_DOORBELL_RANGE_UPPER                                                                  0x1dfd
#define mmCP_MEC_DOORBELL_RANGE_UPPER_BASE_IDX                                                         0
#define mmCPG_UTCL1_ERROR                                                                              0x1dfe
#define mmCPG_UTCL1_ERROR_BASE_IDX                                                                     0
#define mmCPC_UTCL1_ERROR                                                                              0x1dff
#define mmCPC_UTCL1_ERROR_BASE_IDX                                                                     0
#define mmCP_RB1_BASE                                                                                  0x1e00
#define mmCP_RB1_BASE_BASE_IDX                                                                         0
#define mmCP_RB1_CNTL                                                                                  0x1e01
#define mmCP_RB1_CNTL_BASE_IDX                                                                         0
#define mmCP_RB1_RPTR_ADDR                                                                             0x1e02
#define mmCP_RB1_RPTR_ADDR_BASE_IDX                                                                    0
#define mmCP_RB1_RPTR_ADDR_HI                                                                          0x1e03
#define mmCP_RB1_RPTR_ADDR_HI_BASE_IDX                                                                 0
#define mmCP_RB1_BUFSZ_MASK                                                                            0x1e04
#define mmCP_RB1_BUFSZ_MASK_BASE_IDX                                                                   0
#define mmCP_RB2_BASE                                                                                  0x1e05
#define mmCP_RB2_BASE_BASE_IDX                                                                         0
#define mmCP_RB2_CNTL                                                                                  0x1e06
#define mmCP_RB2_CNTL_BASE_IDX                                                                         0
#define mmCP_RB2_RPTR_ADDR                                                                             0x1e07
#define mmCP_RB2_RPTR_ADDR_BASE_IDX                                                                    0
#define mmCP_RB2_RPTR_ADDR_HI                                                                          0x1e08
#define mmCP_RB2_RPTR_ADDR_HI_BASE_IDX                                                                 0
#define mmCP_INT_CNTL_RING0                                                                            0x1e0a
#define mmCP_INT_CNTL_RING0_BASE_IDX                                                                   0
#define mmCP_INT_CNTL_RING1                                                                            0x1e0b
#define mmCP_INT_CNTL_RING1_BASE_IDX                                                                   0
#define mmCP_INT_CNTL_RING2                                                                            0x1e0c
#define mmCP_INT_CNTL_RING2_BASE_IDX                                                                   0
#define mmCP_INT_STATUS_RING0                                                                          0x1e0d
#define mmCP_INT_STATUS_RING0_BASE_IDX                                                                 0
#define mmCP_INT_STATUS_RING1                                                                          0x1e0e
#define mmCP_INT_STATUS_RING1_BASE_IDX                                                                 0
#define mmCP_INT_STATUS_RING2                                                                          0x1e0f
#define mmCP_INT_STATUS_RING2_BASE_IDX                                                                 0
#define mmCP_ME_F32_INTERRUPT                                                                          0x1e13
#define mmCP_ME_F32_INTERRUPT_BASE_IDX                                                                 0
#define mmCP_PFP_F32_INTERRUPT                                                                         0x1e14
#define mmCP_PFP_F32_INTERRUPT_BASE_IDX                                                                0
#define mmCP_CE_F32_INTERRUPT                                                                          0x1e15
#define mmCP_CE_F32_INTERRUPT_BASE_IDX                                                                 0
#define mmCP_MEC1_F32_INTERRUPT                                                                        0x1e16
#define mmCP_MEC1_F32_INTERRUPT_BASE_IDX                                                               0
#define mmCP_MEC2_F32_INTERRUPT                                                                        0x1e17
#define mmCP_MEC2_F32_INTERRUPT_BASE_IDX                                                               0
#define mmCP_PWR_CNTL                                                                                  0x1e18
#define mmCP_PWR_CNTL_BASE_IDX                                                                         0
#define mmCP_MEM_SLP_CNTL                                                                              0x1e19
#define mmCP_MEM_SLP_CNTL_BASE_IDX                                                                     0
#define mmCP_ECC_FIRSTOCCURRENCE                                                                       0x1e1a
#define mmCP_ECC_FIRSTOCCURRENCE_BASE_IDX                                                              0
#define mmCP_ECC_FIRSTOCCURRENCE_RING0                                                                 0x1e1b
#define mmCP_ECC_FIRSTOCCURRENCE_RING0_BASE_IDX                                                        0
#define mmCP_ECC_FIRSTOCCURRENCE_RING1                                                                 0x1e1c
#define mmCP_ECC_FIRSTOCCURRENCE_RING1_BASE_IDX                                                        0
#define mmCP_ECC_FIRSTOCCURRENCE_RING2                                                                 0x1e1d
#define mmCP_ECC_FIRSTOCCURRENCE_RING2_BASE_IDX                                                        0
#define mmGB_EDC_MODE                                                                                  0x1e1e
#define mmGB_EDC_MODE_BASE_IDX                                                                         0
#define mmCP_PQ_WPTR_POLL_CNTL                                                                         0x1e23
#define mmCP_PQ_WPTR_POLL_CNTL_BASE_IDX                                                                0
#define mmCP_PQ_WPTR_POLL_CNTL1                                                                        0x1e24
#define mmCP_PQ_WPTR_POLL_CNTL1_BASE_IDX                                                               0
#define mmCP_ME1_PIPE0_INT_CNTL                                                                        0x1e25
#define mmCP_ME1_PIPE0_INT_CNTL_BASE_IDX                                                               0
#define mmCP_ME1_PIPE1_INT_CNTL                                                                        0x1e26
#define mmCP_ME1_PIPE1_INT_CNTL_BASE_IDX                                                               0
#define mmCP_ME1_PIPE2_INT_CNTL                                                                        0x1e27
#define mmCP_ME1_PIPE2_INT_CNTL_BASE_IDX                                                               0
#define mmCP_ME1_PIPE3_INT_CNTL                                                                        0x1e28
#define mmCP_ME1_PIPE3_INT_CNTL_BASE_IDX                                                               0
#define mmCP_ME2_PIPE0_INT_CNTL                                                                        0x1e29
#define mmCP_ME2_PIPE0_INT_CNTL_BASE_IDX                                                               0
#define mmCP_ME2_PIPE1_INT_CNTL                                                                        0x1e2a
#define mmCP_ME2_PIPE1_INT_CNTL_BASE_IDX                                                               0
#define mmCP_ME2_PIPE2_INT_CNTL                                                                        0x1e2b
#define mmCP_ME2_PIPE2_INT_CNTL_BASE_IDX                                                               0
#define mmCP_ME2_PIPE3_INT_CNTL                                                                        0x1e2c
#define mmCP_ME2_PIPE3_INT_CNTL_BASE_IDX                                                               0
#define mmCP_ME1_PIPE0_INT_STATUS                                                                      0x1e2d
#define mmCP_ME1_PIPE0_INT_STATUS_BASE_IDX                                                             0
#define mmCP_ME1_PIPE1_INT_STATUS                                                                      0x1e2e
#define mmCP_ME1_PIPE1_INT_STATUS_BASE_IDX                                                             0
#define mmCP_ME1_PIPE2_INT_STATUS                                                                      0x1e2f
#define mmCP_ME1_PIPE2_INT_STATUS_BASE_IDX                                                             0
#define mmCP_ME1_PIPE3_INT_STATUS                                                                      0x1e30
#define mmCP_ME1_PIPE3_INT_STATUS_BASE_IDX                                                             0
#define mmCP_ME2_PIPE0_INT_STATUS                                                                      0x1e31
#define mmCP_ME2_PIPE0_INT_STATUS_BASE_IDX                                                             0
#define mmCP_ME2_PIPE1_INT_STATUS                                                                      0x1e32
#define mmCP_ME2_PIPE1_INT_STATUS_BASE_IDX                                                             0
#define mmCP_ME2_PIPE2_INT_STATUS                                                                      0x1e33
#define mmCP_ME2_PIPE2_INT_STATUS_BASE_IDX                                                             0
#define mmCP_ME2_PIPE3_INT_STATUS                                                                      0x1e34
#define mmCP_ME2_PIPE3_INT_STATUS_BASE_IDX                                                             0
#define mmCP_GFX_QUEUE_INDEX                                                                           0x1e37
#define mmCP_GFX_QUEUE_INDEX_BASE_IDX                                                                  0
#define mmCC_GC_EDC_CONFIG                                                                             0x1e38
#define mmCC_GC_EDC_CONFIG_BASE_IDX                                                                    0
#define mmCP_ME1_PIPE_PRIORITY_CNTS                                                                    0x1e39
#define mmCP_ME1_PIPE_PRIORITY_CNTS_BASE_IDX                                                           0
#define mmCP_ME1_PIPE0_PRIORITY                                                                        0x1e3a
#define mmCP_ME1_PIPE0_PRIORITY_BASE_IDX                                                               0
#define mmCP_ME1_PIPE1_PRIORITY                                                                        0x1e3b
#define mmCP_ME1_PIPE1_PRIORITY_BASE_IDX                                                               0
#define mmCP_ME1_PIPE2_PRIORITY                                                                        0x1e3c
#define mmCP_ME1_PIPE2_PRIORITY_BASE_IDX                                                               0
#define mmCP_ME1_PIPE3_PRIORITY                                                                        0x1e3d
#define mmCP_ME1_PIPE3_PRIORITY_BASE_IDX                                                               0
#define mmCP_ME2_PIPE_PRIORITY_CNTS                                                                    0x1e3e
#define mmCP_ME2_PIPE_PRIORITY_CNTS_BASE_IDX                                                           0
#define mmCP_ME2_PIPE0_PRIORITY                                                                        0x1e3f
#define mmCP_ME2_PIPE0_PRIORITY_BASE_IDX                                                               0
#define mmCP_ME2_PIPE1_PRIORITY                                                                        0x1e40
#define mmCP_ME2_PIPE1_PRIORITY_BASE_IDX                                                               0
#define mmCP_ME2_PIPE2_PRIORITY                                                                        0x1e41
#define mmCP_ME2_PIPE2_PRIORITY_BASE_IDX                                                               0
#define mmCP_ME2_PIPE3_PRIORITY                                                                        0x1e42
#define mmCP_ME2_PIPE3_PRIORITY_BASE_IDX                                                               0
#define mmCP_CE_PRGRM_CNTR_START                                                                       0x1e43
#define mmCP_CE_PRGRM_CNTR_START_BASE_IDX                                                              0
#define mmCP_PFP_PRGRM_CNTR_START                                                                      0x1e44
#define mmCP_PFP_PRGRM_CNTR_START_BASE_IDX                                                             0
#define mmCP_ME_PRGRM_CNTR_START                                                                       0x1e45
#define mmCP_ME_PRGRM_CNTR_START_BASE_IDX                                                              0
#define mmCP_MEC1_PRGRM_CNTR_START                                                                     0x1e46
#define mmCP_MEC1_PRGRM_CNTR_START_BASE_IDX                                                            0
#define mmCP_MEC2_PRGRM_CNTR_START                                                                     0x1e47
#define mmCP_MEC2_PRGRM_CNTR_START_BASE_IDX                                                            0
#define mmCP_CE_INTR_ROUTINE_START                                                                     0x1e48
#define mmCP_CE_INTR_ROUTINE_START_BASE_IDX                                                            0
#define mmCP_PFP_INTR_ROUTINE_START                                                                    0x1e49
#define mmCP_PFP_INTR_ROUTINE_START_BASE_IDX                                                           0
#define mmCP_ME_INTR_ROUTINE_START                                                                     0x1e4a
#define mmCP_ME_INTR_ROUTINE_START_BASE_IDX                                                            0
#define mmCP_MEC1_INTR_ROUTINE_START                                                                   0x1e4b
#define mmCP_MEC1_INTR_ROUTINE_START_BASE_IDX                                                          0
#define mmCP_MEC2_INTR_ROUTINE_START                                                                   0x1e4c
#define mmCP_MEC2_INTR_ROUTINE_START_BASE_IDX                                                          0
#define mmCP_CONTEXT_CNTL                                                                              0x1e4d
#define mmCP_CONTEXT_CNTL_BASE_IDX                                                                     0
#define mmCP_MAX_CONTEXT                                                                               0x1e4e
#define mmCP_MAX_CONTEXT_BASE_IDX                                                                      0
#define mmCP_IQ_WAIT_TIME1                                                                             0x1e4f
#define mmCP_IQ_WAIT_TIME1_BASE_IDX                                                                    0
#define mmCP_IQ_WAIT_TIME2                                                                             0x1e50
#define mmCP_IQ_WAIT_TIME2_BASE_IDX                                                                    0
#define mmCP_RB0_BASE_HI                                                                               0x1e51
#define mmCP_RB0_BASE_HI_BASE_IDX                                                                      0
#define mmCP_RB1_BASE_HI                                                                               0x1e52
#define mmCP_RB1_BASE_HI_BASE_IDX                                                                      0
#define mmCP_VMID_RESET                                                                                0x1e53
#define mmCP_VMID_RESET_BASE_IDX                                                                       0
#define mmCPC_INT_CNTL                                                                                 0x1e54
#define mmCPC_INT_CNTL_BASE_IDX                                                                        0
#define mmCPC_INT_STATUS                                                                               0x1e55
#define mmCPC_INT_STATUS_BASE_IDX                                                                      0
#define mmCP_VMID_PREEMPT                                                                              0x1e56
#define mmCP_VMID_PREEMPT_BASE_IDX                                                                     0
#define mmCPC_INT_CNTX_ID                                                                              0x1e57
#define mmCPC_INT_CNTX_ID_BASE_IDX                                                                     0
#define mmCP_PQ_STATUS                                                                                 0x1e58
#define mmCP_PQ_STATUS_BASE_IDX                                                                        0
#define mmCP_MEC1_F32_INT_DIS                                                                          0x1e5d
#define mmCP_MEC1_F32_INT_DIS_BASE_IDX                                                                 0
#define mmCP_MEC2_F32_INT_DIS                                                                          0x1e5e
#define mmCP_MEC2_F32_INT_DIS_BASE_IDX                                                                 0
#define mmCP_VMID_STATUS                                                                               0x1e5f
#define mmCP_VMID_STATUS_BASE_IDX                                                                      0
#define mmCPC_SUSPEND_CTX_SAVE_BASE_ADDR_LO                                                            0x1e60
#define mmCPC_SUSPEND_CTX_SAVE_BASE_ADDR_LO_BASE_IDX                                                   0
#define mmCPC_SUSPEND_CTX_SAVE_BASE_ADDR_HI                                                            0x1e61
#define mmCPC_SUSPEND_CTX_SAVE_BASE_ADDR_HI_BASE_IDX                                                   0
#define mmCPC_SUSPEND_CTX_SAVE_CONTROL                                                                 0x1e62
#define mmCPC_SUSPEND_CTX_SAVE_CONTROL_BASE_IDX                                                        0
#define mmCPC_SUSPEND_CNTL_STACK_OFFSET                                                                0x1e63
#define mmCPC_SUSPEND_CNTL_STACK_OFFSET_BASE_IDX                                                       0
#define mmCPC_SUSPEND_CNTL_STACK_SIZE                                                                  0x1e64
#define mmCPC_SUSPEND_CNTL_STACK_SIZE_BASE_IDX                                                         0
#define mmCPC_SUSPEND_WG_STATE_OFFSET                                                                  0x1e65
#define mmCPC_SUSPEND_WG_STATE_OFFSET_BASE_IDX                                                         0
#define mmCPC_SUSPEND_CTX_SAVE_SIZE                                                                    0x1e66
#define mmCPC_SUSPEND_CTX_SAVE_SIZE_BASE_IDX                                                           0
#define mmCPC_OS_PIPES                                                                                 0x1e67
#define mmCPC_OS_PIPES_BASE_IDX                                                                        0
#define mmCP_SUSPEND_RESUME_REQ                                                                        0x1e68
#define mmCP_SUSPEND_RESUME_REQ_BASE_IDX                                                               0
#define mmCP_SUSPEND_CNTL                                                                              0x1e69
#define mmCP_SUSPEND_CNTL_BASE_IDX                                                                     0
#define mmCP_IQ_WAIT_TIME3                                                                             0x1e6a
#define mmCP_IQ_WAIT_TIME3_BASE_IDX                                                                    0
#define mmCPC_DDID_BASE_ADDR_LO                                                                        0x1e6b
#define mmCPC_DDID_BASE_ADDR_LO_BASE_IDX                                                               0
#define mmCP_DDID_BASE_ADDR_LO                                                                         0x1e6b
#define mmCP_DDID_BASE_ADDR_LO_BASE_IDX                                                                0
#define mmCPC_DDID_BASE_ADDR_HI                                                                        0x1e6c
#define mmCPC_DDID_BASE_ADDR_HI_BASE_IDX                                                               0
#define mmCP_DDID_BASE_ADDR_HI                                                                         0x1e6c
#define mmCP_DDID_BASE_ADDR_HI_BASE_IDX                                                                0
#define mmCPC_DDID_CNTL                                                                                0x1e6d
#define mmCPC_DDID_CNTL_BASE_IDX                                                                       0
#define mmCP_DDID_CNTL                                                                                 0x1e6d
#define mmCP_DDID_CNTL_BASE_IDX                                                                        0
#define mmCP_GFX_DDID_INFLIGHT_COUNT                                                                   0x1e6e
#define mmCP_GFX_DDID_INFLIGHT_COUNT_BASE_IDX                                                          0
#define mmCP_GFX_DDID_WPTR                                                                             0x1e6f
#define mmCP_GFX_DDID_WPTR_BASE_IDX                                                                    0
#define mmCP_GFX_DDID_RPTR                                                                             0x1e70
#define mmCP_GFX_DDID_RPTR_BASE_IDX                                                                    0
#define mmCP_GFX_DDID_DELTA_RPT_COUNT                                                                  0x1e71
#define mmCP_GFX_DDID_DELTA_RPT_COUNT_BASE_IDX                                                         0
#define mmCP_GFX_HPD_STATUS0                                                                           0x1e72
#define mmCP_GFX_HPD_STATUS0_BASE_IDX                                                                  0
#define mmCP_GFX_HPD_CONTROL0                                                                          0x1e73
#define mmCP_GFX_HPD_CONTROL0_BASE_IDX                                                                 0
#define mmCP_GFX_HPD_OSPRE_FENCE_ADDR_LO                                                               0x1e74
#define mmCP_GFX_HPD_OSPRE_FENCE_ADDR_LO_BASE_IDX                                                      0
#define mmCP_GFX_HPD_OSPRE_FENCE_ADDR_HI                                                               0x1e75
#define mmCP_GFX_HPD_OSPRE_FENCE_ADDR_HI_BASE_IDX                                                      0
#define mmCP_GFX_HPD_OSPRE_FENCE_DATA_LO                                                               0x1e76
#define mmCP_GFX_HPD_OSPRE_FENCE_DATA_LO_BASE_IDX                                                      0
#define mmCP_GFX_HPD_OSPRE_FENCE_DATA_HI                                                               0x1e77
#define mmCP_GFX_HPD_OSPRE_FENCE_DATA_HI_BASE_IDX                                                      0
#define mmCP_GFX_INDEX_MUTEX                                                                           0x1e78
#define mmCP_GFX_INDEX_MUTEX_BASE_IDX                                                                  0
#define mmCP_GFX_MQD_BASE_ADDR                                                                         0x1e7e
#define mmCP_GFX_MQD_BASE_ADDR_BASE_IDX                                                                0
#define mmCP_GFX_MQD_BASE_ADDR_HI                                                                      0x1e7f
#define mmCP_GFX_MQD_BASE_ADDR_HI_BASE_IDX                                                             0
#define mmCP_GFX_HQD_ACTIVE                                                                            0x1e80
#define mmCP_GFX_HQD_ACTIVE_BASE_IDX                                                                   0
#define mmCP_GFX_HQD_VMID                                                                              0x1e81
#define mmCP_GFX_HQD_VMID_BASE_IDX                                                                     0
#define mmCP_GFX_HQD_QUEUE_PRIORITY                                                                    0x1e84
#define mmCP_GFX_HQD_QUEUE_PRIORITY_BASE_IDX                                                           0
#define mmCP_GFX_HQD_QUANTUM                                                                           0x1e85
#define mmCP_GFX_HQD_QUANTUM_BASE_IDX                                                                  0
#define mmCP_GFX_HQD_BASE                                                                              0x1e86
#define mmCP_GFX_HQD_BASE_BASE_IDX                                                                     0
#define mmCP_GFX_HQD_BASE_HI                                                                           0x1e87
#define mmCP_GFX_HQD_BASE_HI_BASE_IDX                                                                  0
#define mmCP_GFX_HQD_RPTR                                                                              0x1e88
#define mmCP_GFX_HQD_RPTR_BASE_IDX                                                                     0
#define mmCP_GFX_HQD_RPTR_ADDR                                                                         0x1e89
#define mmCP_GFX_HQD_RPTR_ADDR_BASE_IDX                                                                0
#define mmCP_GFX_HQD_RPTR_ADDR_HI                                                                      0x1e8a
#define mmCP_GFX_HQD_RPTR_ADDR_HI_BASE_IDX                                                             0
#define mmCP_RB_WPTR_POLL_ADDR_LO                                                                      0x1e8b
#define mmCP_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                             0
#define mmCP_RB_WPTR_POLL_ADDR_HI                                                                      0x1e8c
#define mmCP_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                             0
#define mmCP_RB_DOORBELL_CONTROL                                                                       0x1e8d
#define mmCP_RB_DOORBELL_CONTROL_BASE_IDX                                                              0
#define mmCP_GFX_HQD_OFFSET                                                                            0x1e8e
#define mmCP_GFX_HQD_OFFSET_BASE_IDX                                                                   0
#define mmCP_GFX_HQD_CNTL                                                                              0x1e8f
#define mmCP_GFX_HQD_CNTL_BASE_IDX                                                                     0
#define mmCP_GFX_HQD_CSMD_RPTR                                                                         0x1e90
#define mmCP_GFX_HQD_CSMD_RPTR_BASE_IDX                                                                0
#define mmCP_GFX_HQD_WPTR                                                                              0x1e91
#define mmCP_GFX_HQD_WPTR_BASE_IDX                                                                     0
#define mmCP_GFX_HQD_WPTR_HI                                                                           0x1e92
#define mmCP_GFX_HQD_WPTR_HI_BASE_IDX                                                                  0
#define mmCP_GFX_HQD_DEQUEUE_REQUEST                                                                   0x1e93
#define mmCP_GFX_HQD_DEQUEUE_REQUEST_BASE_IDX                                                          0
#define mmCP_GFX_HQD_MAPPED                                                                            0x1e94
#define mmCP_GFX_HQD_MAPPED_BASE_IDX                                                                   0
#define mmCP_GFX_HQD_QUE_MGR_CONTROL                                                                   0x1e95
#define mmCP_GFX_HQD_QUE_MGR_CONTROL_BASE_IDX                                                          0
#define mmCP_GFX_HQD_HQ_STATUS0                                                                        0x1e98
#define mmCP_GFX_HQD_HQ_STATUS0_BASE_IDX                                                               0
#define mmCP_GFX_HQD_HQ_CONTROL0                                                                       0x1e99
#define mmCP_GFX_HQD_HQ_CONTROL0_BASE_IDX                                                              0
#define mmCP_GFX_MQD_CONTROL                                                                           0x1e9a
#define mmCP_GFX_MQD_CONTROL_BASE_IDX                                                                  0
#define mmCP_HQD_GFX_CONTROL                                                                           0x1e9f
#define mmCP_HQD_GFX_CONTROL_BASE_IDX                                                                  0
#define mmCP_HQD_GFX_STATUS                                                                            0x1ea0
#define mmCP_HQD_GFX_STATUS_BASE_IDX                                                                   0
#define mmCP_GFX_HQD_CE_RPTR_WR                                                                        0x1ea1
#define mmCP_GFX_HQD_CE_RPTR_WR_BASE_IDX                                                               0
#define mmCP_GFX_HQD_CE_BASE                                                                           0x1ea2
#define mmCP_GFX_HQD_CE_BASE_BASE_IDX                                                                  0
#define mmCP_GFX_HQD_CE_BASE_HI                                                                        0x1ea3
#define mmCP_GFX_HQD_CE_BASE_HI_BASE_IDX                                                               0
#define mmCP_GFX_HQD_CE_RPTR                                                                           0x1ea4
#define mmCP_GFX_HQD_CE_RPTR_BASE_IDX                                                                  0
#define mmCP_GFX_HQD_CE_RPTR_ADDR                                                                      0x1ea5
#define mmCP_GFX_HQD_CE_RPTR_ADDR_BASE_IDX                                                             0
#define mmCP_GFX_HQD_CE_RPTR_ADDR_HI                                                                   0x1ea6
#define mmCP_GFX_HQD_CE_RPTR_ADDR_HI_BASE_IDX                                                          0
#define mmCP_GFX_HQD_CE_WPTR_POLL_ADDR_LO                                                              0x1ea7
#define mmCP_GFX_HQD_CE_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define mmCP_GFX_HQD_CE_WPTR_POLL_ADDR_HI                                                              0x1ea8
#define mmCP_GFX_HQD_CE_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define mmCP_GFX_HQD_CE_OFFSET                                                                         0x1ea9
#define mmCP_GFX_HQD_CE_OFFSET_BASE_IDX                                                                0
#define mmCP_GFX_HQD_CE_CNTL                                                                           0x1eaa
#define mmCP_GFX_HQD_CE_CNTL_BASE_IDX                                                                  0
#define mmCP_GFX_HQD_CE_CSMD_RPTR                                                                      0x1eab
#define mmCP_GFX_HQD_CE_CSMD_RPTR_BASE_IDX                                                             0
#define mmCP_GFX_HQD_CE_WPTR                                                                           0x1eac
#define mmCP_GFX_HQD_CE_WPTR_BASE_IDX                                                                  0
#define mmCP_GFX_HQD_CE_WPTR_HI                                                                        0x1ead
#define mmCP_GFX_HQD_CE_WPTR_HI_BASE_IDX                                                               0
#define mmCP_CE_DOORBELL_CONTROL                                                                       0x1eae
#define mmCP_CE_DOORBELL_CONTROL_BASE_IDX                                                              0
#define mmCP_DMA_WATCH0_ADDR_LO                                                                        0x1ec0
#define mmCP_DMA_WATCH0_ADDR_LO_BASE_IDX                                                               0
#define mmCP_DMA_WATCH0_ADDR_HI                                                                        0x1ec1
#define mmCP_DMA_WATCH0_ADDR_HI_BASE_IDX                                                               0
#define mmCP_DMA_WATCH0_MASK                                                                           0x1ec2
#define mmCP_DMA_WATCH0_MASK_BASE_IDX                                                                  0
#define mmCP_DMA_WATCH0_CNTL                                                                           0x1ec3
#define mmCP_DMA_WATCH0_CNTL_BASE_IDX                                                                  0
#define mmCP_DMA_WATCH1_ADDR_LO                                                                        0x1ec4
#define mmCP_DMA_WATCH1_ADDR_LO_BASE_IDX                                                               0
#define mmCP_DMA_WATCH1_ADDR_HI                                                                        0x1ec5
#define mmCP_DMA_WATCH1_ADDR_HI_BASE_IDX                                                               0
#define mmCP_DMA_WATCH1_MASK                                                                           0x1ec6
#define mmCP_DMA_WATCH1_MASK_BASE_IDX                                                                  0
#define mmCP_DMA_WATCH1_CNTL                                                                           0x1ec7
#define mmCP_DMA_WATCH1_CNTL_BASE_IDX                                                                  0
#define mmCP_DMA_WATCH2_ADDR_LO                                                                        0x1ec8
#define mmCP_DMA_WATCH2_ADDR_LO_BASE_IDX                                                               0
#define mmCP_DMA_WATCH2_ADDR_HI                                                                        0x1ec9
#define mmCP_DMA_WATCH2_ADDR_HI_BASE_IDX                                                               0
#define mmCP_DMA_WATCH2_MASK                                                                           0x1eca
#define mmCP_DMA_WATCH2_MASK_BASE_IDX                                                                  0
#define mmCP_DMA_WATCH2_CNTL                                                                           0x1ecb
#define mmCP_DMA_WATCH2_CNTL_BASE_IDX                                                                  0
#define mmCP_DMA_WATCH3_ADDR_LO                                                                        0x1ecc
#define mmCP_DMA_WATCH3_ADDR_LO_BASE_IDX                                                               0
#define mmCP_DMA_WATCH3_ADDR_HI                                                                        0x1ecd
#define mmCP_DMA_WATCH3_ADDR_HI_BASE_IDX                                                               0
#define mmCP_DMA_WATCH3_MASK                                                                           0x1ece
#define mmCP_DMA_WATCH3_MASK_BASE_IDX                                                                  0
#define mmCP_DMA_WATCH3_CNTL                                                                           0x1ecf
#define mmCP_DMA_WATCH3_CNTL_BASE_IDX                                                                  0
#define mmCP_DMA_WATCH_STAT_ADDR_LO                                                                    0x1ed0
#define mmCP_DMA_WATCH_STAT_ADDR_LO_BASE_IDX                                                           0
#define mmCP_DMA_WATCH_STAT_ADDR_HI                                                                    0x1ed1
#define mmCP_DMA_WATCH_STAT_ADDR_HI_BASE_IDX                                                           0
#define mmCP_DMA_WATCH_STAT                                                                            0x1ed2
#define mmCP_DMA_WATCH_STAT_BASE_IDX                                                                   0
#define mmCP_PFP_JT_STAT                                                                               0x1ed3
#define mmCP_PFP_JT_STAT_BASE_IDX                                                                      0
#define mmCP_CE_JT_STAT                                                                                0x1ed4
#define mmCP_CE_JT_STAT_BASE_IDX                                                                       0
#define mmCP_MEC_JT_STAT                                                                               0x1ed5
#define mmCP_MEC_JT_STAT_BASE_IDX                                                                      0
#define mmCP_FETCHER_SOURCE                                                                            0x1f1e
#define mmCP_FETCHER_SOURCE_BASE_IDX                                                                   0
#define mmCP_CE_CS_PARTITION_INDEX                                                                     0x1f1f
#define mmCP_CE_CS_PARTITION_INDEX_BASE_IDX                                                            0
#define mmCP_RB_DOORBELL_CLEAR                                                                         0x1f28
#define mmCP_RB_DOORBELL_CLEAR_BASE_IDX                                                                0
#define mmCP_RB0_ACTIVE                                                                                0x1f40
#define mmCP_RB0_ACTIVE_BASE_IDX                                                                       0
#define mmCP_RB_ACTIVE                                                                                 0x1f40
#define mmCP_RB_ACTIVE_BASE_IDX                                                                        0
#define mmCP_RB1_ACTIVE                                                                                0x1f41
#define mmCP_RB1_ACTIVE_BASE_IDX                                                                       0
#define mmCP_RB_STATUS                                                                                 0x1f43
#define mmCP_RB_STATUS_BASE_IDX                                                                        0
#define mmCPG_RCIU_CAM_INDEX                                                                           0x1f44
#define mmCPG_RCIU_CAM_INDEX_BASE_IDX                                                                  0
#define mmCPG_RCIU_CAM_DATA                                                                            0x1f45
#define mmCPG_RCIU_CAM_DATA_BASE_IDX                                                                   0
#define mmCPG_RCIU_CAM_DATA_PHASE0                                                                     0x1f45
#define mmCPG_RCIU_CAM_DATA_PHASE0_BASE_IDX                                                            0
#define mmCPG_RCIU_CAM_DATA_PHASE1                                                                     0x1f45
#define mmCPG_RCIU_CAM_DATA_PHASE1_BASE_IDX                                                            0
#define mmCPG_RCIU_CAM_DATA_PHASE2                                                                     0x1f45
#define mmCPG_RCIU_CAM_DATA_PHASE2_BASE_IDX                                                            0
#define mmCP_GPU_TIMESTAMP_OFFSET_LO                                                                   0x1f4c
#define mmCP_GPU_TIMESTAMP_OFFSET_LO_BASE_IDX                                                          0
#define mmCP_GPU_TIMESTAMP_OFFSET_HI                                                                   0x1f4d
#define mmCP_GPU_TIMESTAMP_OFFSET_HI_BASE_IDX                                                          0
#define mmCPF_GCR_CNTL                                                                                 0x1f53
#define mmCPF_GCR_CNTL_BASE_IDX                                                                        0
#define mmCPG_UTCL1_STATUS                                                                             0x1f54
#define mmCPG_UTCL1_STATUS_BASE_IDX                                                                    0
#define mmCPC_UTCL1_STATUS                                                                             0x1f55
#define mmCPC_UTCL1_STATUS_BASE_IDX                                                                    0
#define mmCPF_UTCL1_STATUS                                                                             0x1f56
#define mmCPF_UTCL1_STATUS_BASE_IDX                                                                    0
#define mmCP_SD_CNTL                                                                                   0x1f57
#define mmCP_SD_CNTL_BASE_IDX                                                                          0
#define mmCP_SOFT_RESET_CNTL                                                                           0x1f59
#define mmCP_SOFT_RESET_CNTL_BASE_IDX                                                                  0
#define mmCP_CPC_GFX_CNTL                                                                              0x1f5a
#define mmCP_CPC_GFX_CNTL_BASE_IDX                                                                     0


// addressBlock: gc_spipdec
// base address: 0xc700
#define mmSPI_ARB_PRIORITY                                                                             0x1f60
#define mmSPI_ARB_PRIORITY_BASE_IDX                                                                    0
#define mmSPI_ARB_CYCLES_0                                                                             0x1f61
#define mmSPI_ARB_CYCLES_0_BASE_IDX                                                                    0
#define mmSPI_ARB_CYCLES_1                                                                             0x1f62
#define mmSPI_ARB_CYCLES_1_BASE_IDX                                                                    0
#define mmSPI_WCL_PIPE_PERCENT_GFX                                                                     0x1f67
#define mmSPI_WCL_PIPE_PERCENT_GFX_BASE_IDX                                                            0
#define mmSPI_WCL_PIPE_PERCENT_HP3D                                                                    0x1f68
#define mmSPI_WCL_PIPE_PERCENT_HP3D_BASE_IDX                                                           0
#define mmSPI_WCL_PIPE_PERCENT_CS0                                                                     0x1f69
#define mmSPI_WCL_PIPE_PERCENT_CS0_BASE_IDX                                                            0
#define mmSPI_WCL_PIPE_PERCENT_CS1                                                                     0x1f6a
#define mmSPI_WCL_PIPE_PERCENT_CS1_BASE_IDX                                                            0
#define mmSPI_WCL_PIPE_PERCENT_CS2                                                                     0x1f6b
#define mmSPI_WCL_PIPE_PERCENT_CS2_BASE_IDX                                                            0
#define mmSPI_WCL_PIPE_PERCENT_CS3                                                                     0x1f6c
#define mmSPI_WCL_PIPE_PERCENT_CS3_BASE_IDX                                                            0
#define mmSPI_GDBG_WAVE_CNTL                                                                           0x1f71
#define mmSPI_GDBG_WAVE_CNTL_BASE_IDX                                                                  0
#define mmSPI_GDBG_TRAP_MASK                                                                           0x1f73
#define mmSPI_GDBG_TRAP_MASK_BASE_IDX                                                                  0
#define mmSPI_GDBG_WAVE_CNTL2                                                                          0x1f74
#define mmSPI_GDBG_WAVE_CNTL2_BASE_IDX                                                                 0
#define mmSPI_COMPUTE_QUEUE_RESET                                                                      0x1f7b
#define mmSPI_COMPUTE_QUEUE_RESET_BASE_IDX                                                             0
#define mmSPI_RESOURCE_RESERVE_CU_0                                                                    0x1f7c
#define mmSPI_RESOURCE_RESERVE_CU_0_BASE_IDX                                                           0
#define mmSPI_RESOURCE_RESERVE_CU_1                                                                    0x1f7d
#define mmSPI_RESOURCE_RESERVE_CU_1_BASE_IDX                                                           0
#define mmSPI_RESOURCE_RESERVE_CU_2                                                                    0x1f7e
#define mmSPI_RESOURCE_RESERVE_CU_2_BASE_IDX                                                           0
#define mmSPI_RESOURCE_RESERVE_CU_3                                                                    0x1f7f
#define mmSPI_RESOURCE_RESERVE_CU_3_BASE_IDX                                                           0
#define mmSPI_RESOURCE_RESERVE_CU_4                                                                    0x1f80
#define mmSPI_RESOURCE_RESERVE_CU_4_BASE_IDX                                                           0
#define mmSPI_RESOURCE_RESERVE_CU_5                                                                    0x1f81
#define mmSPI_RESOURCE_RESERVE_CU_5_BASE_IDX                                                           0
#define mmSPI_RESOURCE_RESERVE_CU_6                                                                    0x1f82
#define mmSPI_RESOURCE_RESERVE_CU_6_BASE_IDX                                                           0
#define mmSPI_RESOURCE_RESERVE_CU_7                                                                    0x1f83
#define mmSPI_RESOURCE_RESERVE_CU_7_BASE_IDX                                                           0
#define mmSPI_RESOURCE_RESERVE_CU_8                                                                    0x1f84
#define mmSPI_RESOURCE_RESERVE_CU_8_BASE_IDX                                                           0
#define mmSPI_RESOURCE_RESERVE_CU_9                                                                    0x1f85
#define mmSPI_RESOURCE_RESERVE_CU_9_BASE_IDX                                                           0
#define mmSPI_RESOURCE_RESERVE_EN_CU_0                                                                 0x1f86
#define mmSPI_RESOURCE_RESERVE_EN_CU_0_BASE_IDX                                                        0
#define mmSPI_RESOURCE_RESERVE_EN_CU_1                                                                 0x1f87
#define mmSPI_RESOURCE_RESERVE_EN_CU_1_BASE_IDX                                                        0
#define mmSPI_RESOURCE_RESERVE_EN_CU_2                                                                 0x1f88
#define mmSPI_RESOURCE_RESERVE_EN_CU_2_BASE_IDX                                                        0
#define mmSPI_RESOURCE_RESERVE_EN_CU_3                                                                 0x1f89
#define mmSPI_RESOURCE_RESERVE_EN_CU_3_BASE_IDX                                                        0
#define mmSPI_RESOURCE_RESERVE_EN_CU_4                                                                 0x1f8a
#define mmSPI_RESOURCE_RESERVE_EN_CU_4_BASE_IDX                                                        0
#define mmSPI_RESOURCE_RESERVE_EN_CU_5                                                                 0x1f8b
#define mmSPI_RESOURCE_RESERVE_EN_CU_5_BASE_IDX                                                        0
#define mmSPI_RESOURCE_RESERVE_EN_CU_6                                                                 0x1f8c
#define mmSPI_RESOURCE_RESERVE_EN_CU_6_BASE_IDX                                                        0
#define mmSPI_RESOURCE_RESERVE_EN_CU_7                                                                 0x1f8d
#define mmSPI_RESOURCE_RESERVE_EN_CU_7_BASE_IDX                                                        0
#define mmSPI_RESOURCE_RESERVE_EN_CU_8                                                                 0x1f8e
#define mmSPI_RESOURCE_RESERVE_EN_CU_8_BASE_IDX                                                        0
#define mmSPI_RESOURCE_RESERVE_EN_CU_9                                                                 0x1f8f
#define mmSPI_RESOURCE_RESERVE_EN_CU_9_BASE_IDX                                                        0
#define mmSPI_COMPUTE_WF_CTX_SAVE                                                                      0x1f9c
#define mmSPI_COMPUTE_WF_CTX_SAVE_BASE_IDX                                                             0
#define mmSPI_ARB_CNTL_0                                                                               0x1f9d
#define mmSPI_ARB_CNTL_0_BASE_IDX                                                                      0
#define mmSPI_FEATURE_CTRL                                                                             0x1f9e
#define mmSPI_FEATURE_CTRL_BASE_IDX                                                                    0
#define mmSPI_SHADER_RSRC_LIMIT_CTRL                                                                   0x1f9f
#define mmSPI_SHADER_RSRC_LIMIT_CTRL_BASE_IDX                                                          0


// addressBlock: gc_cpphqddec
// base address: 0xc800
#define mmCP_HPD_MES_ROQ_OFFSETS                                                                       0x1fa4
#define mmCP_HPD_MES_ROQ_OFFSETS_BASE_IDX                                                              0
#define mmCP_HPD_ROQ_OFFSETS                                                                           0x1fa4
#define mmCP_HPD_ROQ_OFFSETS_BASE_IDX                                                                  0
#define mmCP_HPD_STATUS0                                                                               0x1fa5
#define mmCP_HPD_STATUS0_BASE_IDX                                                                      0
#define mmCP_HPD_UTCL1_CNTL                                                                            0x1fa6
#define mmCP_HPD_UTCL1_CNTL_BASE_IDX                                                                   0
#define mmCP_HPD_UTCL1_ERROR                                                                           0x1fa7
#define mmCP_HPD_UTCL1_ERROR_BASE_IDX                                                                  0
#define mmCP_HPD_UTCL1_ERROR_ADDR                                                                      0x1fa8
#define mmCP_HPD_UTCL1_ERROR_ADDR_BASE_IDX                                                             0
#define mmCP_MQD_BASE_ADDR                                                                             0x1fa9
#define mmCP_MQD_BASE_ADDR_BASE_IDX                                                                    0
#define mmCP_MQD_BASE_ADDR_HI                                                                          0x1faa
#define mmCP_MQD_BASE_ADDR_HI_BASE_IDX                                                                 0
#define mmCP_HQD_ACTIVE                                                                                0x1fab
#define mmCP_HQD_ACTIVE_BASE_IDX                                                                       0
#define mmCP_HQD_VMID                                                                                  0x1fac
#define mmCP_HQD_VMID_BASE_IDX                                                                         0
#define mmCP_HQD_PERSISTENT_STATE                                                                      0x1fad
#define mmCP_HQD_PERSISTENT_STATE_BASE_IDX                                                             0
#define mmCP_HQD_PIPE_PRIORITY                                                                         0x1fae
#define mmCP_HQD_PIPE_PRIORITY_BASE_IDX                                                                0
#define mmCP_HQD_QUEUE_PRIORITY                                                                        0x1faf
#define mmCP_HQD_QUEUE_PRIORITY_BASE_IDX                                                               0
#define mmCP_HQD_QUANTUM                                                                               0x1fb0
#define mmCP_HQD_QUANTUM_BASE_IDX                                                                      0
#define mmCP_HQD_PQ_BASE                                                                               0x1fb1
#define mmCP_HQD_PQ_BASE_BASE_IDX                                                                      0
#define mmCP_HQD_PQ_BASE_HI                                                                            0x1fb2
#define mmCP_HQD_PQ_BASE_HI_BASE_IDX                                                                   0
#define mmCP_HQD_PQ_RPTR                                                                               0x1fb3
#define mmCP_HQD_PQ_RPTR_BASE_IDX                                                                      0
#define mmCP_HQD_PQ_RPTR_REPORT_ADDR                                                                   0x1fb4
#define mmCP_HQD_PQ_RPTR_REPORT_ADDR_BASE_IDX                                                          0
#define mmCP_HQD_PQ_RPTR_REPORT_ADDR_HI                                                                0x1fb5
#define mmCP_HQD_PQ_RPTR_REPORT_ADDR_HI_BASE_IDX                                                       0
#define mmCP_HQD_PQ_WPTR_POLL_ADDR                                                                     0x1fb6
#define mmCP_HQD_PQ_WPTR_POLL_ADDR_BASE_IDX                                                            0
#define mmCP_HQD_PQ_WPTR_POLL_ADDR_HI                                                                  0x1fb7
#define mmCP_HQD_PQ_WPTR_POLL_ADDR_HI_BASE_IDX                                                         0
#define mmCP_HQD_PQ_DOORBELL_CONTROL                                                                   0x1fb8
#define mmCP_HQD_PQ_DOORBELL_CONTROL_BASE_IDX                                                          0
#define mmCP_HQD_PQ_CONTROL                                                                            0x1fba
#define mmCP_HQD_PQ_CONTROL_BASE_IDX                                                                   0
#define mmCP_HQD_IB_BASE_ADDR                                                                          0x1fbb
#define mmCP_HQD_IB_BASE_ADDR_BASE_IDX                                                                 0
#define mmCP_HQD_IB_BASE_ADDR_HI                                                                       0x1fbc
#define mmCP_HQD_IB_BASE_ADDR_HI_BASE_IDX                                                              0
#define mmCP_HQD_IB_RPTR                                                                               0x1fbd
#define mmCP_HQD_IB_RPTR_BASE_IDX                                                                      0
#define mmCP_HQD_IB_CONTROL                                                                            0x1fbe
#define mmCP_HQD_IB_CONTROL_BASE_IDX                                                                   0
#define mmCP_HQD_IQ_TIMER                                                                              0x1fbf
#define mmCP_HQD_IQ_TIMER_BASE_IDX                                                                     0
#define mmCP_HQD_IQ_RPTR                                                                               0x1fc0
#define mmCP_HQD_IQ_RPTR_BASE_IDX                                                                      0
#define mmCP_HQD_DEQUEUE_REQUEST                                                                       0x1fc1
#define mmCP_HQD_DEQUEUE_REQUEST_BASE_IDX                                                              0
#define mmCP_HQD_DMA_OFFLOAD                                                                           0x1fc2
#define mmCP_HQD_DMA_OFFLOAD_BASE_IDX                                                                  0
#define mmCP_HQD_OFFLOAD                                                                               0x1fc2
#define mmCP_HQD_OFFLOAD_BASE_IDX                                                                      0
#define mmCP_HQD_SEMA_CMD                                                                              0x1fc3
#define mmCP_HQD_SEMA_CMD_BASE_IDX                                                                     0
#define mmCP_HQD_MSG_TYPE                                                                              0x1fc4
#define mmCP_HQD_MSG_TYPE_BASE_IDX                                                                     0
#define mmCP_HQD_ATOMIC0_PREOP_LO                                                                      0x1fc5
#define mmCP_HQD_ATOMIC0_PREOP_LO_BASE_IDX                                                             0
#define mmCP_HQD_ATOMIC0_PREOP_HI                                                                      0x1fc6
#define mmCP_HQD_ATOMIC0_PREOP_HI_BASE_IDX                                                             0
#define mmCP_HQD_ATOMIC1_PREOP_LO                                                                      0x1fc7
#define mmCP_HQD_ATOMIC1_PREOP_LO_BASE_IDX                                                             0
#define mmCP_HQD_ATOMIC1_PREOP_HI                                                                      0x1fc8
#define mmCP_HQD_ATOMIC1_PREOP_HI_BASE_IDX                                                             0
#define mmCP_HQD_HQ_SCHEDULER0                                                                         0x1fc9
#define mmCP_HQD_HQ_SCHEDULER0_BASE_IDX                                                                0
#define mmCP_HQD_HQ_STATUS0                                                                            0x1fc9
#define mmCP_HQD_HQ_STATUS0_BASE_IDX                                                                   0
#define mmCP_HQD_HQ_CONTROL0                                                                           0x1fca
#define mmCP_HQD_HQ_CONTROL0_BASE_IDX                                                                  0
#define mmCP_HQD_HQ_SCHEDULER1                                                                         0x1fca
#define mmCP_HQD_HQ_SCHEDULER1_BASE_IDX                                                                0
#define mmCP_MQD_CONTROL                                                                               0x1fcb
#define mmCP_MQD_CONTROL_BASE_IDX                                                                      0
#define mmCP_HQD_HQ_STATUS1                                                                            0x1fcc
#define mmCP_HQD_HQ_STATUS1_BASE_IDX                                                                   0
#define mmCP_HQD_HQ_CONTROL1                                                                           0x1fcd
#define mmCP_HQD_HQ_CONTROL1_BASE_IDX                                                                  0
#define mmCP_HQD_EOP_BASE_ADDR                                                                         0x1fce
#define mmCP_HQD_EOP_BASE_ADDR_BASE_IDX                                                                0
#define mmCP_HQD_EOP_BASE_ADDR_HI                                                                      0x1fcf
#define mmCP_HQD_EOP_BASE_ADDR_HI_BASE_IDX                                                             0
#define mmCP_HQD_EOP_CONTROL                                                                           0x1fd0
#define mmCP_HQD_EOP_CONTROL_BASE_IDX                                                                  0
#define mmCP_HQD_EOP_RPTR                                                                              0x1fd1
#define mmCP_HQD_EOP_RPTR_BASE_IDX                                                                     0
#define mmCP_HQD_EOP_WPTR                                                                              0x1fd2
#define mmCP_HQD_EOP_WPTR_BASE_IDX                                                                     0
#define mmCP_HQD_EOP_EVENTS                                                                            0x1fd3
#define mmCP_HQD_EOP_EVENTS_BASE_IDX                                                                   0
#define mmCP_HQD_CTX_SAVE_BASE_ADDR_LO                                                                 0x1fd4
#define mmCP_HQD_CTX_SAVE_BASE_ADDR_LO_BASE_IDX                                                        0
#define mmCP_HQD_CTX_SAVE_BASE_ADDR_HI                                                                 0x1fd5
#define mmCP_HQD_CTX_SAVE_BASE_ADDR_HI_BASE_IDX                                                        0
#define mmCP_HQD_CTX_SAVE_CONTROL                                                                      0x1fd6
#define mmCP_HQD_CTX_SAVE_CONTROL_BASE_IDX                                                             0
#define mmCP_HQD_CNTL_STACK_OFFSET                                                                     0x1fd7
#define mmCP_HQD_CNTL_STACK_OFFSET_BASE_IDX                                                            0
#define mmCP_HQD_CNTL_STACK_SIZE                                                                       0x1fd8
#define mmCP_HQD_CNTL_STACK_SIZE_BASE_IDX                                                              0
#define mmCP_HQD_WG_STATE_OFFSET                                                                       0x1fd9
#define mmCP_HQD_WG_STATE_OFFSET_BASE_IDX                                                              0
#define mmCP_HQD_CTX_SAVE_SIZE                                                                         0x1fda
#define mmCP_HQD_CTX_SAVE_SIZE_BASE_IDX                                                                0
#define mmCP_HQD_GDS_RESOURCE_STATE                                                                    0x1fdb
#define mmCP_HQD_GDS_RESOURCE_STATE_BASE_IDX                                                           0
#define mmCP_HQD_ERROR                                                                                 0x1fdc
#define mmCP_HQD_ERROR_BASE_IDX                                                                        0
#define mmCP_HQD_EOP_WPTR_MEM                                                                          0x1fdd
#define mmCP_HQD_EOP_WPTR_MEM_BASE_IDX                                                                 0
#define mmCP_HQD_AQL_CONTROL                                                                           0x1fde
#define mmCP_HQD_AQL_CONTROL_BASE_IDX                                                                  0
#define mmCP_HQD_PQ_WPTR_LO                                                                            0x1fdf
#define mmCP_HQD_PQ_WPTR_LO_BASE_IDX                                                                   0
#define mmCP_HQD_PQ_WPTR_HI                                                                            0x1fe0
#define mmCP_HQD_PQ_WPTR_HI_BASE_IDX                                                                   0
#define mmCP_HQD_SUSPEND_CNTL_STACK_OFFSET                                                             0x1fe1
#define mmCP_HQD_SUSPEND_CNTL_STACK_OFFSET_BASE_IDX                                                    0
#define mmCP_HQD_SUSPEND_CNTL_STACK_DW_CNT                                                             0x1fe2
#define mmCP_HQD_SUSPEND_CNTL_STACK_DW_CNT_BASE_IDX                                                    0
#define mmCP_HQD_SUSPEND_WG_STATE_OFFSET                                                               0x1fe3
#define mmCP_HQD_SUSPEND_WG_STATE_OFFSET_BASE_IDX                                                      0
#define mmCP_HQD_DDID_RPTR                                                                             0x1fe4
#define mmCP_HQD_DDID_RPTR_BASE_IDX                                                                    0
#define mmCP_HQD_DDID_WPTR                                                                             0x1fe5
#define mmCP_HQD_DDID_WPTR_BASE_IDX                                                                    0
#define mmCP_HQD_DDID_INFLIGHT_COUNT                                                                   0x1fe6
#define mmCP_HQD_DDID_INFLIGHT_COUNT_BASE_IDX                                                          0
#define mmCP_HQD_DDID_DELTA_RPT_COUNT                                                                  0x1fe7
#define mmCP_HQD_DDID_DELTA_RPT_COUNT_BASE_IDX                                                         0
#define mmCP_HQD_DEQUEUE_STATUS                                                                        0x1fe8
#define mmCP_HQD_DEQUEUE_STATUS_BASE_IDX                                                               0


// addressBlock: gc_didtdec
// base address: 0xca00
#define mmDIDT_IND_INDEX                                                                               0x2020
#define mmDIDT_IND_INDEX_BASE_IDX                                                                      0
#define mmDIDT_IND_DATA                                                                                0x2021
#define mmDIDT_IND_DATA_BASE_IDX                                                                       0
#define mmDIDT_INDEX_AUTO_INCR_EN                                                                      0x2022
#define mmDIDT_INDEX_AUTO_INCR_EN_BASE_IDX                                                             0


// addressBlock: gc_gccacdec
// base address: 0xca10
#define mmGC_CAC_CTRL_1                                                                                0x2024
#define mmGC_CAC_CTRL_1_BASE_IDX                                                                       0
#define mmGC_CAC_CTRL_2                                                                                0x2025
#define mmGC_CAC_CTRL_2_BASE_IDX                                                                       0
#define mmGC_CAC_AGGR_LOWER                                                                            0x2026
#define mmGC_CAC_AGGR_LOWER_BASE_IDX                                                                   0
#define mmGC_CAC_AGGR_UPPER                                                                            0x2027
#define mmGC_CAC_AGGR_UPPER_BASE_IDX                                                                   0
#define mmGC_CAC_SOFT_CTRL                                                                             0x202a
#define mmGC_CAC_SOFT_CTRL_BASE_IDX                                                                    0
#define mmGC_EDC_CTRL                                                                                  0x202b
#define mmGC_EDC_CTRL_BASE_IDX                                                                         0
#define mmGC_EDC_THRESHOLD                                                                             0x202c
#define mmGC_EDC_THRESHOLD_BASE_IDX                                                                    0
#define mmGC_EDC_STATUS                                                                                0x202d
#define mmGC_EDC_STATUS_BASE_IDX                                                                       0
#define mmGC_EDC_OVERFLOW                                                                              0x202e
#define mmGC_EDC_OVERFLOW_BASE_IDX                                                                     0
#define mmGC_EDC_ROLLING_POWER_DELTA                                                                   0x202f
#define mmGC_EDC_ROLLING_POWER_DELTA_BASE_IDX                                                          0
#define mmGC_THROTTLE_CTRL                                                                             0x2030
#define mmGC_THROTTLE_CTRL_BASE_IDX                                                                    0
#define mmGC_THROTTLE_CTRL1                                                                            0x2031
#define mmGC_THROTTLE_CTRL1_BASE_IDX                                                                   0
#define mmGC_THROTTLE_STATUS                                                                           0x2032
#define mmGC_THROTTLE_STATUS_BASE_IDX                                                                  0
#define mmEDC_PERF_COUNTER                                                                             0x2033
#define mmEDC_PERF_COUNTER_BASE_IDX                                                                    0
#define mmPCC_PERF_COUNTER                                                                             0x2034
#define mmPCC_PERF_COUNTER_BASE_IDX                                                                    0
#define mmPWRBRK_PERF_COUNTER                                                                          0x2035
#define mmPWRBRK_PERF_COUNTER_BASE_IDX                                                                 0
#define mmGC_EDC_STRETCH_CTRL                                                                          0x2036
#define mmGC_EDC_STRETCH_CTRL_BASE_IDX                                                                 0
#define mmGC_EDC_STRETCH_THRESHOLD                                                                     0x2037
#define mmGC_EDC_STRETCH_THRESHOLD_BASE_IDX                                                            0
#define mmEDC_HYSTERESIS_CNTL                                                                          0x2038
#define mmEDC_HYSTERESIS_CNTL_BASE_IDX                                                                 0
#define mmEDC_HYSTERESIS_STAT                                                                          0x2039
#define mmEDC_HYSTERESIS_STAT_BASE_IDX                                                                 0
#define mmGC_CAC_IND_INDEX                                                                             0x203c
#define mmGC_CAC_IND_INDEX_BASE_IDX                                                                    0
#define mmGC_CAC_IND_DATA                                                                              0x203d
#define mmGC_CAC_IND_DATA_BASE_IDX                                                                     0
#define mmSE_CAC_IND_INDEX                                                                             0x203e
#define mmSE_CAC_IND_INDEX_BASE_IDX                                                                    0
#define mmSE_CAC_IND_DATA                                                                              0x203f
#define mmSE_CAC_IND_DATA_BASE_IDX                                                                     0


// addressBlock: gc_tcpdec
// base address: 0xca80
#define mmTCP_WATCH0_ADDR_H                                                                            0x2040
#define mmTCP_WATCH0_ADDR_H_BASE_IDX                                                                   0
#define mmTCP_WATCH0_ADDR_L                                                                            0x2041
#define mmTCP_WATCH0_ADDR_L_BASE_IDX                                                                   0
#define mmTCP_WATCH0_CNTL                                                                              0x2042
#define mmTCP_WATCH0_CNTL_BASE_IDX                                                                     0
#define mmTCP_WATCH1_ADDR_H                                                                            0x2043
#define mmTCP_WATCH1_ADDR_H_BASE_IDX                                                                   0
#define mmTCP_WATCH1_ADDR_L                                                                            0x2044
#define mmTCP_WATCH1_ADDR_L_BASE_IDX                                                                   0
#define mmTCP_WATCH1_CNTL                                                                              0x2045
#define mmTCP_WATCH1_CNTL_BASE_IDX                                                                     0
#define mmTCP_WATCH2_ADDR_H                                                                            0x2046
#define mmTCP_WATCH2_ADDR_H_BASE_IDX                                                                   0
#define mmTCP_WATCH2_ADDR_L                                                                            0x2047
#define mmTCP_WATCH2_ADDR_L_BASE_IDX                                                                   0
#define mmTCP_WATCH2_CNTL                                                                              0x2048
#define mmTCP_WATCH2_CNTL_BASE_IDX                                                                     0
#define mmTCP_WATCH3_ADDR_H                                                                            0x2049
#define mmTCP_WATCH3_ADDR_H_BASE_IDX                                                                   0
#define mmTCP_WATCH3_ADDR_L                                                                            0x204a
#define mmTCP_WATCH3_ADDR_L_BASE_IDX                                                                   0
#define mmTCP_WATCH3_CNTL                                                                              0x204b
#define mmTCP_WATCH3_CNTL_BASE_IDX                                                                     0
#define mmTCP_PERFCOUNTER_FILTER                                                                       0x2059
#define mmTCP_PERFCOUNTER_FILTER_BASE_IDX                                                              0
#define mmTCP_PERFCOUNTER_FILTER_EN                                                                    0x205a
#define mmTCP_PERFCOUNTER_FILTER_EN_BASE_IDX                                                           0
#define mmTCP_PERFCOUNTER_FILTER2                                                                      0x205b
#define mmTCP_PERFCOUNTER_FILTER2_BASE_IDX                                                             0


// addressBlock: gc_gdspdec
// base address: 0xcc00
#define mmGDS_VMID0_BASE                                                                               0x20a0
#define mmGDS_VMID0_BASE_BASE_IDX                                                                      0
#define mmGDS_VMID0_SIZE                                                                               0x20a1
#define mmGDS_VMID0_SIZE_BASE_IDX                                                                      0
#define mmGDS_VMID1_BASE                                                                               0x20a2
#define mmGDS_VMID1_BASE_BASE_IDX                                                                      0
#define mmGDS_VMID1_SIZE                                                                               0x20a3
#define mmGDS_VMID1_SIZE_BASE_IDX                                                                      0
#define mmGDS_VMID2_BASE                                                                               0x20a4
#define mmGDS_VMID2_BASE_BASE_IDX                                                                      0
#define mmGDS_VMID2_SIZE                                                                               0x20a5
#define mmGDS_VMID2_SIZE_BASE_IDX                                                                      0
#define mmGDS_VMID3_BASE                                                                               0x20a6
#define mmGDS_VMID3_BASE_BASE_IDX                                                                      0
#define mmGDS_VMID3_SIZE                                                                               0x20a7
#define mmGDS_VMID3_SIZE_BASE_IDX                                                                      0
#define mmGDS_VMID4_BASE                                                                               0x20a8
#define mmGDS_VMID4_BASE_BASE_IDX                                                                      0
#define mmGDS_VMID4_SIZE                                                                               0x20a9
#define mmGDS_VMID4_SIZE_BASE_IDX                                                                      0
#define mmGDS_VMID5_BASE                                                                               0x20aa
#define mmGDS_VMID5_BASE_BASE_IDX                                                                      0
#define mmGDS_VMID5_SIZE                                                                               0x20ab
#define mmGDS_VMID5_SIZE_BASE_IDX                                                                      0
#define mmGDS_VMID6_BASE                                                                               0x20ac
#define mmGDS_VMID6_BASE_BASE_IDX                                                                      0
#define mmGDS_VMID6_SIZE                                                                               0x20ad
#define mmGDS_VMID6_SIZE_BASE_IDX                                                                      0
#define mmGDS_VMID7_BASE                                                                               0x20ae
#define mmGDS_VMID7_BASE_BASE_IDX                                                                      0
#define mmGDS_VMID7_SIZE                                                                               0x20af
#define mmGDS_VMID7_SIZE_BASE_IDX                                                                      0
#define mmGDS_VMID8_BASE                                                                               0x20b0
#define mmGDS_VMID8_BASE_BASE_IDX                                                                      0
#define mmGDS_VMID8_SIZE                                                                               0x20b1
#define mmGDS_VMID8_SIZE_BASE_IDX                                                                      0
#define mmGDS_VMID9_BASE                                                                               0x20b2
#define mmGDS_VMID9_BASE_BASE_IDX                                                                      0
#define mmGDS_VMID9_SIZE                                                                               0x20b3
#define mmGDS_VMID9_SIZE_BASE_IDX                                                                      0
#define mmGDS_VMID10_BASE                                                                              0x20b4
#define mmGDS_VMID10_BASE_BASE_IDX                                                                     0
#define mmGDS_VMID10_SIZE                                                                              0x20b5
#define mmGDS_VMID10_SIZE_BASE_IDX                                                                     0
#define mmGDS_VMID11_BASE                                                                              0x20b6
#define mmGDS_VMID11_BASE_BASE_IDX                                                                     0
#define mmGDS_VMID11_SIZE                                                                              0x20b7
#define mmGDS_VMID11_SIZE_BASE_IDX                                                                     0
#define mmGDS_VMID12_BASE                                                                              0x20b8
#define mmGDS_VMID12_BASE_BASE_IDX                                                                     0
#define mmGDS_VMID12_SIZE                                                                              0x20b9
#define mmGDS_VMID12_SIZE_BASE_IDX                                                                     0
#define mmGDS_VMID13_BASE                                                                              0x20ba
#define mmGDS_VMID13_BASE_BASE_IDX                                                                     0
#define mmGDS_VMID13_SIZE                                                                              0x20bb
#define mmGDS_VMID13_SIZE_BASE_IDX                                                                     0
#define mmGDS_VMID14_BASE                                                                              0x20bc
#define mmGDS_VMID14_BASE_BASE_IDX                                                                     0
#define mmGDS_VMID14_SIZE                                                                              0x20bd
#define mmGDS_VMID14_SIZE_BASE_IDX                                                                     0
#define mmGDS_VMID15_BASE                                                                              0x20be
#define mmGDS_VMID15_BASE_BASE_IDX                                                                     0
#define mmGDS_VMID15_SIZE                                                                              0x20bf
#define mmGDS_VMID15_SIZE_BASE_IDX                                                                     0
#define mmGDS_GWS_VMID0                                                                                0x20c0
#define mmGDS_GWS_VMID0_BASE_IDX                                                                       0
#define mmGDS_GWS_VMID1                                                                                0x20c1
#define mmGDS_GWS_VMID1_BASE_IDX                                                                       0
#define mmGDS_GWS_VMID2                                                                                0x20c2
#define mmGDS_GWS_VMID2_BASE_IDX                                                                       0
#define mmGDS_GWS_VMID3                                                                                0x20c3
#define mmGDS_GWS_VMID3_BASE_IDX                                                                       0
#define mmGDS_GWS_VMID4                                                                                0x20c4
#define mmGDS_GWS_VMID4_BASE_IDX                                                                       0
#define mmGDS_GWS_VMID5                                                                                0x20c5
#define mmGDS_GWS_VMID5_BASE_IDX                                                                       0
#define mmGDS_GWS_VMID6                                                                                0x20c6
#define mmGDS_GWS_VMID6_BASE_IDX                                                                       0
#define mmGDS_GWS_VMID7                                                                                0x20c7
#define mmGDS_GWS_VMID7_BASE_IDX                                                                       0
#define mmGDS_GWS_VMID8                                                                                0x20c8
#define mmGDS_GWS_VMID8_BASE_IDX                                                                       0
#define mmGDS_GWS_VMID9                                                                                0x20c9
#define mmGDS_GWS_VMID9_BASE_IDX                                                                       0
#define mmGDS_GWS_VMID10                                                                               0x20ca
#define mmGDS_GWS_VMID10_BASE_IDX                                                                      0
#define mmGDS_GWS_VMID11                                                                               0x20cb
#define mmGDS_GWS_VMID11_BASE_IDX                                                                      0
#define mmGDS_GWS_VMID12                                                                               0x20cc
#define mmGDS_GWS_VMID12_BASE_IDX                                                                      0
#define mmGDS_GWS_VMID13                                                                               0x20cd
#define mmGDS_GWS_VMID13_BASE_IDX                                                                      0
#define mmGDS_GWS_VMID14                                                                               0x20ce
#define mmGDS_GWS_VMID14_BASE_IDX                                                                      0
#define mmGDS_GWS_VMID15                                                                               0x20cf
#define mmGDS_GWS_VMID15_BASE_IDX                                                                      0
#define mmGDS_OA_VMID0                                                                                 0x20d0
#define mmGDS_OA_VMID0_BASE_IDX                                                                        0
#define mmGDS_OA_VMID1                                                                                 0x20d1
#define mmGDS_OA_VMID1_BASE_IDX                                                                        0
#define mmGDS_OA_VMID2                                                                                 0x20d2
#define mmGDS_OA_VMID2_BASE_IDX                                                                        0
#define mmGDS_OA_VMID3                                                                                 0x20d3
#define mmGDS_OA_VMID3_BASE_IDX                                                                        0
#define mmGDS_OA_VMID4                                                                                 0x20d4
#define mmGDS_OA_VMID4_BASE_IDX                                                                        0
#define mmGDS_OA_VMID5                                                                                 0x20d5
#define mmGDS_OA_VMID5_BASE_IDX                                                                        0
#define mmGDS_OA_VMID6                                                                                 0x20d6
#define mmGDS_OA_VMID6_BASE_IDX                                                                        0
#define mmGDS_OA_VMID7                                                                                 0x20d7
#define mmGDS_OA_VMID7_BASE_IDX                                                                        0
#define mmGDS_OA_VMID8                                                                                 0x20d8
#define mmGDS_OA_VMID8_BASE_IDX                                                                        0
#define mmGDS_OA_VMID9                                                                                 0x20d9
#define mmGDS_OA_VMID9_BASE_IDX                                                                        0
#define mmGDS_OA_VMID10                                                                                0x20da
#define mmGDS_OA_VMID10_BASE_IDX                                                                       0
#define mmGDS_OA_VMID11                                                                                0x20db
#define mmGDS_OA_VMID11_BASE_IDX                                                                       0
#define mmGDS_OA_VMID12                                                                                0x20dc
#define mmGDS_OA_VMID12_BASE_IDX                                                                       0
#define mmGDS_OA_VMID13                                                                                0x20dd
#define mmGDS_OA_VMID13_BASE_IDX                                                                       0
#define mmGDS_OA_VMID14                                                                                0x20de
#define mmGDS_OA_VMID14_BASE_IDX                                                                       0
#define mmGDS_OA_VMID15                                                                                0x20df
#define mmGDS_OA_VMID15_BASE_IDX                                                                       0
#define mmGDS_GWS_RESET0                                                                               0x20e4
#define mmGDS_GWS_RESET0_BASE_IDX                                                                      0
#define mmGDS_GWS_RESET1                                                                               0x20e5
#define mmGDS_GWS_RESET1_BASE_IDX                                                                      0
#define mmGDS_GWS_RESOURCE_RESET                                                                       0x20e6
#define mmGDS_GWS_RESOURCE_RESET_BASE_IDX                                                              0
#define mmGDS_COMPUTE_MAX_WAVE_ID                                                                      0x20e8
#define mmGDS_COMPUTE_MAX_WAVE_ID_BASE_IDX                                                             0
#define mmGDS_OA_RESET_MASK                                                                            0x20e9
#define mmGDS_OA_RESET_MASK_BASE_IDX                                                                   0
#define mmGDS_OA_RESET                                                                                 0x20ea
#define mmGDS_OA_RESET_BASE_IDX                                                                        0
#define mmGDS_ENHANCE2                                                                                 0x20eb
#define mmGDS_ENHANCE2_BASE_IDX                                                                        0
#define mmGDS_OA_CGPG_RESTORE                                                                          0x20ec
#define mmGDS_OA_CGPG_RESTORE_BASE_IDX                                                                 0
#define mmGDS_CS_CTXSW_STATUS                                                                          0x20ed
#define mmGDS_CS_CTXSW_STATUS_BASE_IDX                                                                 0
#define mmGDS_CS_CTXSW_CNT0                                                                            0x20ee
#define mmGDS_CS_CTXSW_CNT0_BASE_IDX                                                                   0
#define mmGDS_CS_CTXSW_CNT1                                                                            0x20ef
#define mmGDS_CS_CTXSW_CNT1_BASE_IDX                                                                   0
#define mmGDS_CS_CTXSW_CNT2                                                                            0x20f0
#define mmGDS_CS_CTXSW_CNT2_BASE_IDX                                                                   0
#define mmGDS_CS_CTXSW_CNT3                                                                            0x20f1
#define mmGDS_CS_CTXSW_CNT3_BASE_IDX                                                                   0
#define mmGDS_GFX_CTXSW_STATUS                                                                         0x20f2
#define mmGDS_GFX_CTXSW_STATUS_BASE_IDX                                                                0
#define mmGDS_VS_CTXSW_CNT0                                                                            0x20f3
#define mmGDS_VS_CTXSW_CNT0_BASE_IDX                                                                   0
#define mmGDS_VS_CTXSW_CNT1                                                                            0x20f4
#define mmGDS_VS_CTXSW_CNT1_BASE_IDX                                                                   0
#define mmGDS_VS_CTXSW_CNT2                                                                            0x20f5
#define mmGDS_VS_CTXSW_CNT2_BASE_IDX                                                                   0
#define mmGDS_VS_CTXSW_CNT3                                                                            0x20f6
#define mmGDS_VS_CTXSW_CNT3_BASE_IDX                                                                   0
#define mmGDS_PS_CTXSW_CNT0                                                                            0x20f7
#define mmGDS_PS_CTXSW_CNT0_BASE_IDX                                                                   0
#define mmGDS_PS_CTXSW_CNT1                                                                            0x20f8
#define mmGDS_PS_CTXSW_CNT1_BASE_IDX                                                                   0
#define mmGDS_PS_CTXSW_CNT2                                                                            0x20f9
#define mmGDS_PS_CTXSW_CNT2_BASE_IDX                                                                   0
#define mmGDS_PS_CTXSW_CNT3                                                                            0x20fa
#define mmGDS_PS_CTXSW_CNT3_BASE_IDX                                                                   0
#define mmGDS_PS_CTXSW_IDX                                                                             0x20fb
#define mmGDS_PS_CTXSW_IDX_BASE_IDX                                                                    0
#define mmGDS_GS_CTXSW_CNT0                                                                            0x2117
#define mmGDS_GS_CTXSW_CNT0_BASE_IDX                                                                   0
#define mmGDS_GS_CTXSW_CNT1                                                                            0x2118
#define mmGDS_GS_CTXSW_CNT1_BASE_IDX                                                                   0
#define mmGDS_GS_CTXSW_CNT2                                                                            0x2119
#define mmGDS_GS_CTXSW_CNT2_BASE_IDX                                                                   0
#define mmGDS_GS_CTXSW_CNT3                                                                            0x211a
#define mmGDS_GS_CTXSW_CNT3_BASE_IDX                                                                   0
#define mmGDS_MEMORY_CLEAN                                                                             0x211f
#define mmGDS_MEMORY_CLEAN_BASE_IDX                                                                    0


// addressBlock: gc_gfxdec0
// base address: 0x28000
#define mmDB_RENDER_CONTROL                                                                            0x0000
#define mmDB_RENDER_CONTROL_BASE_IDX                                                                   1
#define mmDB_COUNT_CONTROL                                                                             0x0001
#define mmDB_COUNT_CONTROL_BASE_IDX                                                                    1
#define mmDB_DEPTH_VIEW                                                                                0x0002
#define mmDB_DEPTH_VIEW_BASE_IDX                                                                       1
#define mmDB_RENDER_OVERRIDE                                                                           0x0003
#define mmDB_RENDER_OVERRIDE_BASE_IDX                                                                  1
#define mmDB_RENDER_OVERRIDE2                                                                          0x0004
#define mmDB_RENDER_OVERRIDE2_BASE_IDX                                                                 1
#define mmDB_HTILE_DATA_BASE                                                                           0x0005
#define mmDB_HTILE_DATA_BASE_BASE_IDX                                                                  1
#define mmDB_DEPTH_SIZE_XY                                                                             0x0007
#define mmDB_DEPTH_SIZE_XY_BASE_IDX                                                                    1
#define mmDB_DEPTH_BOUNDS_MIN                                                                          0x0008
#define mmDB_DEPTH_BOUNDS_MIN_BASE_IDX                                                                 1
#define mmDB_DEPTH_BOUNDS_MAX                                                                          0x0009
#define mmDB_DEPTH_BOUNDS_MAX_BASE_IDX                                                                 1
#define mmDB_STENCIL_CLEAR                                                                             0x000a
#define mmDB_STENCIL_CLEAR_BASE_IDX                                                                    1
#define mmDB_DEPTH_CLEAR                                                                               0x000b
#define mmDB_DEPTH_CLEAR_BASE_IDX                                                                      1
#define mmPA_SC_SCREEN_SCISSOR_TL                                                                      0x000c
#define mmPA_SC_SCREEN_SCISSOR_TL_BASE_IDX                                                             1
#define mmPA_SC_SCREEN_SCISSOR_BR                                                                      0x000d
#define mmPA_SC_SCREEN_SCISSOR_BR_BASE_IDX                                                             1
#define mmDB_DFSM_CONTROL                                                                              0x000e
#define mmDB_DFSM_CONTROL_BASE_IDX                                                                     1
#define mmDB_RESERVED_REG_2                                                                            0x000f
#define mmDB_RESERVED_REG_2_BASE_IDX                                                                   1
#define mmDB_Z_INFO                                                                                    0x0010
#define mmDB_Z_INFO_BASE_IDX                                                                           1
#define mmDB_STENCIL_INFO                                                                              0x0011
#define mmDB_STENCIL_INFO_BASE_IDX                                                                     1
#define mmDB_Z_READ_BASE                                                                               0x0012
#define mmDB_Z_READ_BASE_BASE_IDX                                                                      1
#define mmDB_STENCIL_READ_BASE                                                                         0x0013
#define mmDB_STENCIL_READ_BASE_BASE_IDX                                                                1
#define mmDB_Z_WRITE_BASE                                                                              0x0014
#define mmDB_Z_WRITE_BASE_BASE_IDX                                                                     1
#define mmDB_STENCIL_WRITE_BASE                                                                        0x0015
#define mmDB_STENCIL_WRITE_BASE_BASE_IDX                                                               1
#define mmDB_RESERVED_REG_1                                                                            0x0016
#define mmDB_RESERVED_REG_1_BASE_IDX                                                                   1
#define mmDB_RESERVED_REG_3                                                                            0x0017
#define mmDB_RESERVED_REG_3_BASE_IDX                                                                   1
#define mmDB_Z_READ_BASE_HI                                                                            0x001a
#define mmDB_Z_READ_BASE_HI_BASE_IDX                                                                   1
#define mmDB_STENCIL_READ_BASE_HI                                                                      0x001b
#define mmDB_STENCIL_READ_BASE_HI_BASE_IDX                                                             1
#define mmDB_Z_WRITE_BASE_HI                                                                           0x001c
#define mmDB_Z_WRITE_BASE_HI_BASE_IDX                                                                  1
#define mmDB_STENCIL_WRITE_BASE_HI                                                                     0x001d
#define mmDB_STENCIL_WRITE_BASE_HI_BASE_IDX                                                            1
#define mmDB_HTILE_DATA_BASE_HI                                                                        0x001e
#define mmDB_HTILE_DATA_BASE_HI_BASE_IDX                                                               1
#define mmDB_RMI_L2_CACHE_CONTROL                                                                      0x001f
#define mmDB_RMI_L2_CACHE_CONTROL_BASE_IDX                                                             1
#define mmTA_BC_BASE_ADDR                                                                              0x0020
#define mmTA_BC_BASE_ADDR_BASE_IDX                                                                     1
#define mmTA_BC_BASE_ADDR_HI                                                                           0x0021
#define mmTA_BC_BASE_ADDR_HI_BASE_IDX                                                                  1
#define mmCOHER_DEST_BASE_HI_0                                                                         0x007a
#define mmCOHER_DEST_BASE_HI_0_BASE_IDX                                                                1
#define mmCOHER_DEST_BASE_HI_1                                                                         0x007b
#define mmCOHER_DEST_BASE_HI_1_BASE_IDX                                                                1
#define mmCOHER_DEST_BASE_HI_2                                                                         0x007c
#define mmCOHER_DEST_BASE_HI_2_BASE_IDX                                                                1
#define mmCOHER_DEST_BASE_HI_3                                                                         0x007d
#define mmCOHER_DEST_BASE_HI_3_BASE_IDX                                                                1
#define mmCOHER_DEST_BASE_2                                                                            0x007e
#define mmCOHER_DEST_BASE_2_BASE_IDX                                                                   1
#define mmCOHER_DEST_BASE_3                                                                            0x007f
#define mmCOHER_DEST_BASE_3_BASE_IDX                                                                   1
#define mmPA_SC_WINDOW_OFFSET                                                                          0x0080
#define mmPA_SC_WINDOW_OFFSET_BASE_IDX                                                                 1
#define mmPA_SC_WINDOW_SCISSOR_TL                                                                      0x0081
#define mmPA_SC_WINDOW_SCISSOR_TL_BASE_IDX                                                             1
#define mmPA_SC_WINDOW_SCISSOR_BR                                                                      0x0082
#define mmPA_SC_WINDOW_SCISSOR_BR_BASE_IDX                                                             1
#define mmPA_SC_CLIPRECT_RULE                                                                          0x0083
#define mmPA_SC_CLIPRECT_RULE_BASE_IDX                                                                 1
#define mmPA_SC_CLIPRECT_0_TL                                                                          0x0084
#define mmPA_SC_CLIPRECT_0_TL_BASE_IDX                                                                 1
#define mmPA_SC_CLIPRECT_0_BR                                                                          0x0085
#define mmPA_SC_CLIPRECT_0_BR_BASE_IDX                                                                 1
#define mmPA_SC_CLIPRECT_1_TL                                                                          0x0086
#define mmPA_SC_CLIPRECT_1_TL_BASE_IDX                                                                 1
#define mmPA_SC_CLIPRECT_1_BR                                                                          0x0087
#define mmPA_SC_CLIPRECT_1_BR_BASE_IDX                                                                 1
#define mmPA_SC_CLIPRECT_2_TL                                                                          0x0088
#define mmPA_SC_CLIPRECT_2_TL_BASE_IDX                                                                 1
#define mmPA_SC_CLIPRECT_2_BR                                                                          0x0089
#define mmPA_SC_CLIPRECT_2_BR_BASE_IDX                                                                 1
#define mmPA_SC_CLIPRECT_3_TL                                                                          0x008a
#define mmPA_SC_CLIPRECT_3_TL_BASE_IDX                                                                 1
#define mmPA_SC_CLIPRECT_3_BR                                                                          0x008b
#define mmPA_SC_CLIPRECT_3_BR_BASE_IDX                                                                 1
#define mmPA_SC_EDGERULE                                                                               0x008c
#define mmPA_SC_EDGERULE_BASE_IDX                                                                      1
#define mmPA_SU_HARDWARE_SCREEN_OFFSET                                                                 0x008d
#define mmPA_SU_HARDWARE_SCREEN_OFFSET_BASE_IDX                                                        1
#define mmCB_TARGET_MASK                                                                               0x008e
#define mmCB_TARGET_MASK_BASE_IDX                                                                      1
#define mmCB_SHADER_MASK                                                                               0x008f
#define mmCB_SHADER_MASK_BASE_IDX                                                                      1
#define mmPA_SC_GENERIC_SCISSOR_TL                                                                     0x0090
#define mmPA_SC_GENERIC_SCISSOR_TL_BASE_IDX                                                            1
#define mmPA_SC_GENERIC_SCISSOR_BR                                                                     0x0091
#define mmPA_SC_GENERIC_SCISSOR_BR_BASE_IDX                                                            1
#define mmCOHER_DEST_BASE_0                                                                            0x0092
#define mmCOHER_DEST_BASE_0_BASE_IDX                                                                   1
#define mmCOHER_DEST_BASE_1                                                                            0x0093
#define mmCOHER_DEST_BASE_1_BASE_IDX                                                                   1
#define mmPA_SC_VPORT_SCISSOR_0_TL                                                                     0x0094
#define mmPA_SC_VPORT_SCISSOR_0_TL_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_0_BR                                                                     0x0095
#define mmPA_SC_VPORT_SCISSOR_0_BR_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_1_TL                                                                     0x0096
#define mmPA_SC_VPORT_SCISSOR_1_TL_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_1_BR                                                                     0x0097
#define mmPA_SC_VPORT_SCISSOR_1_BR_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_2_TL                                                                     0x0098
#define mmPA_SC_VPORT_SCISSOR_2_TL_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_2_BR                                                                     0x0099
#define mmPA_SC_VPORT_SCISSOR_2_BR_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_3_TL                                                                     0x009a
#define mmPA_SC_VPORT_SCISSOR_3_TL_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_3_BR                                                                     0x009b
#define mmPA_SC_VPORT_SCISSOR_3_BR_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_4_TL                                                                     0x009c
#define mmPA_SC_VPORT_SCISSOR_4_TL_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_4_BR                                                                     0x009d
#define mmPA_SC_VPORT_SCISSOR_4_BR_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_5_TL                                                                     0x009e
#define mmPA_SC_VPORT_SCISSOR_5_TL_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_5_BR                                                                     0x009f
#define mmPA_SC_VPORT_SCISSOR_5_BR_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_6_TL                                                                     0x00a0
#define mmPA_SC_VPORT_SCISSOR_6_TL_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_6_BR                                                                     0x00a1
#define mmPA_SC_VPORT_SCISSOR_6_BR_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_7_TL                                                                     0x00a2
#define mmPA_SC_VPORT_SCISSOR_7_TL_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_7_BR                                                                     0x00a3
#define mmPA_SC_VPORT_SCISSOR_7_BR_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_8_TL                                                                     0x00a4
#define mmPA_SC_VPORT_SCISSOR_8_TL_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_8_BR                                                                     0x00a5
#define mmPA_SC_VPORT_SCISSOR_8_BR_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_9_TL                                                                     0x00a6
#define mmPA_SC_VPORT_SCISSOR_9_TL_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_9_BR                                                                     0x00a7
#define mmPA_SC_VPORT_SCISSOR_9_BR_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_10_TL                                                                    0x00a8
#define mmPA_SC_VPORT_SCISSOR_10_TL_BASE_IDX                                                           1
#define mmPA_SC_VPORT_SCISSOR_10_BR                                                                    0x00a9
#define mmPA_SC_VPORT_SCISSOR_10_BR_BASE_IDX                                                           1
#define mmPA_SC_VPORT_SCISSOR_11_TL                                                                    0x00aa
#define mmPA_SC_VPORT_SCISSOR_11_TL_BASE_IDX                                                           1
#define mmPA_SC_VPORT_SCISSOR_11_BR                                                                    0x00ab
#define mmPA_SC_VPORT_SCISSOR_11_BR_BASE_IDX                                                           1
#define mmPA_SC_VPORT_SCISSOR_12_TL                                                                    0x00ac
#define mmPA_SC_VPORT_SCISSOR_12_TL_BASE_IDX                                                           1
#define mmPA_SC_VPORT_SCISSOR_12_BR                                                                    0x00ad
#define mmPA_SC_VPORT_SCISSOR_12_BR_BASE_IDX                                                           1
#define mmPA_SC_VPORT_SCISSOR_13_TL                                                                    0x00ae
#define mmPA_SC_VPORT_SCISSOR_13_TL_BASE_IDX                                                           1
#define mmPA_SC_VPORT_SCISSOR_13_BR                                                                    0x00af
#define mmPA_SC_VPORT_SCISSOR_13_BR_BASE_IDX                                                           1
#define mmPA_SC_VPORT_SCISSOR_14_TL                                                                    0x00b0
#define mmPA_SC_VPORT_SCISSOR_14_TL_BASE_IDX                                                           1
#define mmPA_SC_VPORT_SCISSOR_14_BR                                                                    0x00b1
#define mmPA_SC_VPORT_SCISSOR_14_BR_BASE_IDX                                                           1
#define mmPA_SC_VPORT_SCISSOR_15_TL                                                                    0x00b2
#define mmPA_SC_VPORT_SCISSOR_15_TL_BASE_IDX                                                           1
#define mmPA_SC_VPORT_SCISSOR_15_BR                                                                    0x00b3
#define mmPA_SC_VPORT_SCISSOR_15_BR_BASE_IDX                                                           1
#define mmPA_SC_VPORT_ZMIN_0                                                                           0x00b4
#define mmPA_SC_VPORT_ZMIN_0_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMAX_0                                                                           0x00b5
#define mmPA_SC_VPORT_ZMAX_0_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMIN_1                                                                           0x00b6
#define mmPA_SC_VPORT_ZMIN_1_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMAX_1                                                                           0x00b7
#define mmPA_SC_VPORT_ZMAX_1_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMIN_2                                                                           0x00b8
#define mmPA_SC_VPORT_ZMIN_2_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMAX_2                                                                           0x00b9
#define mmPA_SC_VPORT_ZMAX_2_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMIN_3                                                                           0x00ba
#define mmPA_SC_VPORT_ZMIN_3_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMAX_3                                                                           0x00bb
#define mmPA_SC_VPORT_ZMAX_3_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMIN_4                                                                           0x00bc
#define mmPA_SC_VPORT_ZMIN_4_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMAX_4                                                                           0x00bd
#define mmPA_SC_VPORT_ZMAX_4_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMIN_5                                                                           0x00be
#define mmPA_SC_VPORT_ZMIN_5_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMAX_5                                                                           0x00bf
#define mmPA_SC_VPORT_ZMAX_5_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMIN_6                                                                           0x00c0
#define mmPA_SC_VPORT_ZMIN_6_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMAX_6                                                                           0x00c1
#define mmPA_SC_VPORT_ZMAX_6_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMIN_7                                                                           0x00c2
#define mmPA_SC_VPORT_ZMIN_7_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMAX_7                                                                           0x00c3
#define mmPA_SC_VPORT_ZMAX_7_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMIN_8                                                                           0x00c4
#define mmPA_SC_VPORT_ZMIN_8_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMAX_8                                                                           0x00c5
#define mmPA_SC_VPORT_ZMAX_8_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMIN_9                                                                           0x00c6
#define mmPA_SC_VPORT_ZMIN_9_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMAX_9                                                                           0x00c7
#define mmPA_SC_VPORT_ZMAX_9_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMIN_10                                                                          0x00c8
#define mmPA_SC_VPORT_ZMIN_10_BASE_IDX                                                                 1
#define mmPA_SC_VPORT_ZMAX_10                                                                          0x00c9
#define mmPA_SC_VPORT_ZMAX_10_BASE_IDX                                                                 1
#define mmPA_SC_VPORT_ZMIN_11                                                                          0x00ca
#define mmPA_SC_VPORT_ZMIN_11_BASE_IDX                                                                 1
#define mmPA_SC_VPORT_ZMAX_11                                                                          0x00cb
#define mmPA_SC_VPORT_ZMAX_11_BASE_IDX                                                                 1
#define mmPA_SC_VPORT_ZMIN_12                                                                          0x00cc
#define mmPA_SC_VPORT_ZMIN_12_BASE_IDX                                                                 1
#define mmPA_SC_VPORT_ZMAX_12                                                                          0x00cd
#define mmPA_SC_VPORT_ZMAX_12_BASE_IDX                                                                 1
#define mmPA_SC_VPORT_ZMIN_13                                                                          0x00ce
#define mmPA_SC_VPORT_ZMIN_13_BASE_IDX                                                                 1
#define mmPA_SC_VPORT_ZMAX_13                                                                          0x00cf
#define mmPA_SC_VPORT_ZMAX_13_BASE_IDX                                                                 1
#define mmPA_SC_VPORT_ZMIN_14                                                                          0x00d0
#define mmPA_SC_VPORT_ZMIN_14_BASE_IDX                                                                 1
#define mmPA_SC_VPORT_ZMAX_14                                                                          0x00d1
#define mmPA_SC_VPORT_ZMAX_14_BASE_IDX                                                                 1
#define mmPA_SC_VPORT_ZMIN_15                                                                          0x00d2
#define mmPA_SC_VPORT_ZMIN_15_BASE_IDX                                                                 1
#define mmPA_SC_VPORT_ZMAX_15                                                                          0x00d3
#define mmPA_SC_VPORT_ZMAX_15_BASE_IDX                                                                 1
#define mmPA_SC_RASTER_CONFIG                                                                          0x00d4
#define mmPA_SC_RASTER_CONFIG_BASE_IDX                                                                 1
#define mmPA_SC_RASTER_CONFIG_1                                                                        0x00d5
#define mmPA_SC_RASTER_CONFIG_1_BASE_IDX                                                               1
#define mmPA_SC_SCREEN_EXTENT_CONTROL                                                                  0x00d6
#define mmPA_SC_SCREEN_EXTENT_CONTROL_BASE_IDX                                                         1
#define mmPA_SC_TILE_STEERING_OVERRIDE                                                                 0x00d7
#define mmPA_SC_TILE_STEERING_OVERRIDE_BASE_IDX                                                        1
#define mmCP_PERFMON_CNTX_CNTL                                                                         0x00d8
#define mmCP_PERFMON_CNTX_CNTL_BASE_IDX                                                                1
#define mmCP_PIPEID                                                                                    0x00d9
#define mmCP_PIPEID_BASE_IDX                                                                           1
#define mmCP_RINGID                                                                                    0x00d9
#define mmCP_RINGID_BASE_IDX                                                                           1
#define mmCP_VMID                                                                                      0x00da
#define mmCP_VMID_BASE_IDX                                                                             1
#define mmCONTEXT_RESERVED_REG0                                                                        0x00db
#define mmCONTEXT_RESERVED_REG0_BASE_IDX                                                               1
#define mmCONTEXT_RESERVED_REG1                                                                        0x00dc
#define mmCONTEXT_RESERVED_REG1_BASE_IDX                                                               1
#define mmVGT_MAX_VTX_INDX                                                                             0x0100
#define mmVGT_MAX_VTX_INDX_BASE_IDX                                                                    1
#define mmVGT_MIN_VTX_INDX                                                                             0x0101
#define mmVGT_MIN_VTX_INDX_BASE_IDX                                                                    1
#define mmVGT_INDX_OFFSET                                                                              0x0102
#define mmVGT_INDX_OFFSET_BASE_IDX                                                                     1
#define mmVGT_MULTI_PRIM_IB_RESET_INDX                                                                 0x0103
#define mmVGT_MULTI_PRIM_IB_RESET_INDX_BASE_IDX                                                        1
#define mmCB_RMI_GL2_CACHE_CONTROL                                                                     0x0104
#define mmCB_RMI_GL2_CACHE_CONTROL_BASE_IDX                                                            1
#define mmCB_BLEND_RED                                                                                 0x0105
#define mmCB_BLEND_RED_BASE_IDX                                                                        1
#define mmCB_BLEND_GREEN                                                                               0x0106
#define mmCB_BLEND_GREEN_BASE_IDX                                                                      1
#define mmCB_BLEND_BLUE                                                                                0x0107
#define mmCB_BLEND_BLUE_BASE_IDX                                                                       1
#define mmCB_BLEND_ALPHA                                                                               0x0108
#define mmCB_BLEND_ALPHA_BASE_IDX                                                                      1
#define mmCB_DCC_CONTROL                                                                               0x0109
#define mmCB_DCC_CONTROL_BASE_IDX                                                                      1
#define mmCB_COVERAGE_OUT_CONTROL                                                                      0x010a
#define mmCB_COVERAGE_OUT_CONTROL_BASE_IDX                                                             1
#define mmDB_STENCIL_CONTROL                                                                           0x010b
#define mmDB_STENCIL_CONTROL_BASE_IDX                                                                  1
#define mmDB_STENCILREFMASK                                                                            0x010c
#define mmDB_STENCILREFMASK_BASE_IDX                                                                   1
#define mmDB_STENCILREFMASK_BF                                                                         0x010d
#define mmDB_STENCILREFMASK_BF_BASE_IDX                                                                1
#define mmPA_CL_VPORT_XSCALE                                                                           0x010f
#define mmPA_CL_VPORT_XSCALE_BASE_IDX                                                                  1
#define mmPA_CL_VPORT_XOFFSET                                                                          0x0110
#define mmPA_CL_VPORT_XOFFSET_BASE_IDX                                                                 1
#define mmPA_CL_VPORT_YSCALE                                                                           0x0111
#define mmPA_CL_VPORT_YSCALE_BASE_IDX                                                                  1
#define mmPA_CL_VPORT_YOFFSET                                                                          0x0112
#define mmPA_CL_VPORT_YOFFSET_BASE_IDX                                                                 1
#define mmPA_CL_VPORT_ZSCALE                                                                           0x0113
#define mmPA_CL_VPORT_ZSCALE_BASE_IDX                                                                  1
#define mmPA_CL_VPORT_ZOFFSET                                                                          0x0114
#define mmPA_CL_VPORT_ZOFFSET_BASE_IDX                                                                 1
#define mmPA_CL_VPORT_XSCALE_1                                                                         0x0115
#define mmPA_CL_VPORT_XSCALE_1_BASE_IDX                                                                1
#define mmPA_CL_VPORT_XOFFSET_1                                                                        0x0116
#define mmPA_CL_VPORT_XOFFSET_1_BASE_IDX                                                               1
#define mmPA_CL_VPORT_YSCALE_1                                                                         0x0117
#define mmPA_CL_VPORT_YSCALE_1_BASE_IDX                                                                1
#define mmPA_CL_VPORT_YOFFSET_1                                                                        0x0118
#define mmPA_CL_VPORT_YOFFSET_1_BASE_IDX                                                               1
#define mmPA_CL_VPORT_ZSCALE_1                                                                         0x0119
#define mmPA_CL_VPORT_ZSCALE_1_BASE_IDX                                                                1
#define mmPA_CL_VPORT_ZOFFSET_1                                                                        0x011a
#define mmPA_CL_VPORT_ZOFFSET_1_BASE_IDX                                                               1
#define mmPA_CL_VPORT_XSCALE_2                                                                         0x011b
#define mmPA_CL_VPORT_XSCALE_2_BASE_IDX                                                                1
#define mmPA_CL_VPORT_XOFFSET_2                                                                        0x011c
#define mmPA_CL_VPORT_XOFFSET_2_BASE_IDX                                                               1
#define mmPA_CL_VPORT_YSCALE_2                                                                         0x011d
#define mmPA_CL_VPORT_YSCALE_2_BASE_IDX                                                                1
#define mmPA_CL_VPORT_YOFFSET_2                                                                        0x011e
#define mmPA_CL_VPORT_YOFFSET_2_BASE_IDX                                                               1
#define mmPA_CL_VPORT_ZSCALE_2                                                                         0x011f
#define mmPA_CL_VPORT_ZSCALE_2_BASE_IDX                                                                1
#define mmPA_CL_VPORT_ZOFFSET_2                                                                        0x0120
#define mmPA_CL_VPORT_ZOFFSET_2_BASE_IDX                                                               1
#define mmPA_CL_VPORT_XSCALE_3                                                                         0x0121
#define mmPA_CL_VPORT_XSCALE_3_BASE_IDX                                                                1
#define mmPA_CL_VPORT_XOFFSET_3                                                                        0x0122
#define mmPA_CL_VPORT_XOFFSET_3_BASE_IDX                                                               1
#define mmPA_CL_VPORT_YSCALE_3                                                                         0x0123
#define mmPA_CL_VPORT_YSCALE_3_BASE_IDX                                                                1
#define mmPA_CL_VPORT_YOFFSET_3                                                                        0x0124
#define mmPA_CL_VPORT_YOFFSET_3_BASE_IDX                                                               1
#define mmPA_CL_VPORT_ZSCALE_3                                                                         0x0125
#define mmPA_CL_VPORT_ZSCALE_3_BASE_IDX                                                                1
#define mmPA_CL_VPORT_ZOFFSET_3                                                                        0x0126
#define mmPA_CL_VPORT_ZOFFSET_3_BASE_IDX                                                               1
#define mmPA_CL_VPORT_XSCALE_4                                                                         0x0127
#define mmPA_CL_VPORT_XSCALE_4_BASE_IDX                                                                1
#define mmPA_CL_VPORT_XOFFSET_4                                                                        0x0128
#define mmPA_CL_VPORT_XOFFSET_4_BASE_IDX                                                               1
#define mmPA_CL_VPORT_YSCALE_4                                                                         0x0129
#define mmPA_CL_VPORT_YSCALE_4_BASE_IDX                                                                1
#define mmPA_CL_VPORT_YOFFSET_4                                                                        0x012a
#define mmPA_CL_VPORT_YOFFSET_4_BASE_IDX                                                               1
#define mmPA_CL_VPORT_ZSCALE_4                                                                         0x012b
#define mmPA_CL_VPORT_ZSCALE_4_BASE_IDX                                                                1
#define mmPA_CL_VPORT_ZOFFSET_4                                                                        0x012c
#define mmPA_CL_VPORT_ZOFFSET_4_BASE_IDX                                                               1
#define mmPA_CL_VPORT_XSCALE_5                                                                         0x012d
#define mmPA_CL_VPORT_XSCALE_5_BASE_IDX                                                                1
#define mmPA_CL_VPORT_XOFFSET_5                                                                        0x012e
#define mmPA_CL_VPORT_XOFFSET_5_BASE_IDX                                                               1
#define mmPA_CL_VPORT_YSCALE_5                                                                         0x012f
#define mmPA_CL_VPORT_YSCALE_5_BASE_IDX                                                                1
#define mmPA_CL_VPORT_YOFFSET_5                                                                        0x0130
#define mmPA_CL_VPORT_YOFFSET_5_BASE_IDX                                                               1
#define mmPA_CL_VPORT_ZSCALE_5                                                                         0x0131
#define mmPA_CL_VPORT_ZSCALE_5_BASE_IDX                                                                1
#define mmPA_CL_VPORT_ZOFFSET_5                                                                        0x0132
#define mmPA_CL_VPORT_ZOFFSET_5_BASE_IDX                                                               1
#define mmPA_CL_VPORT_XSCALE_6                                                                         0x0133
#define mmPA_CL_VPORT_XSCALE_6_BASE_IDX                                                                1
#define mmPA_CL_VPORT_XOFFSET_6                                                                        0x0134
#define mmPA_CL_VPORT_XOFFSET_6_BASE_IDX                                                               1
#define mmPA_CL_VPORT_YSCALE_6                                                                         0x0135
#define mmPA_CL_VPORT_YSCALE_6_BASE_IDX                                                                1
#define mmPA_CL_VPORT_YOFFSET_6                                                                        0x0136
#define mmPA_CL_VPORT_YOFFSET_6_BASE_IDX                                                               1
#define mmPA_CL_VPORT_ZSCALE_6                                                                         0x0137
#define mmPA_CL_VPORT_ZSCALE_6_BASE_IDX                                                                1
#define mmPA_CL_VPORT_ZOFFSET_6                                                                        0x0138
#define mmPA_CL_VPORT_ZOFFSET_6_BASE_IDX                                                               1
#define mmPA_CL_VPORT_XSCALE_7                                                                         0x0139
#define mmPA_CL_VPORT_XSCALE_7_BASE_IDX                                                                1
#define mmPA_CL_VPORT_XOFFSET_7                                                                        0x013a
#define mmPA_CL_VPORT_XOFFSET_7_BASE_IDX                                                               1
#define mmPA_CL_VPORT_YSCALE_7                                                                         0x013b
#define mmPA_CL_VPORT_YSCALE_7_BASE_IDX                                                                1
#define mmPA_CL_VPORT_YOFFSET_7                                                                        0x013c
#define mmPA_CL_VPORT_YOFFSET_7_BASE_IDX                                                               1
#define mmPA_CL_VPORT_ZSCALE_7                                                                         0x013d
#define mmPA_CL_VPORT_ZSCALE_7_BASE_IDX                                                                1
#define mmPA_CL_VPORT_ZOFFSET_7                                                                        0x013e
#define mmPA_CL_VPORT_ZOFFSET_7_BASE_IDX                                                               1
#define mmPA_CL_VPORT_XSCALE_8                                                                         0x013f
#define mmPA_CL_VPORT_XSCALE_8_BASE_IDX                                                                1
#define mmPA_CL_VPORT_XOFFSET_8                                                                        0x0140
#define mmPA_CL_VPORT_XOFFSET_8_BASE_IDX                                                               1
#define mmPA_CL_VPORT_YSCALE_8                                                                         0x0141
#define mmPA_CL_VPORT_YSCALE_8_BASE_IDX                                                                1
#define mmPA_CL_VPORT_YOFFSET_8                                                                        0x0142
#define mmPA_CL_VPORT_YOFFSET_8_BASE_IDX                                                               1
#define mmPA_CL_VPORT_ZSCALE_8                                                                         0x0143
#define mmPA_CL_VPORT_ZSCALE_8_BASE_IDX                                                                1
#define mmPA_CL_VPORT_ZOFFSET_8                                                                        0x0144
#define mmPA_CL_VPORT_ZOFFSET_8_BASE_IDX                                                               1
#define mmPA_CL_VPORT_XSCALE_9                                                                         0x0145
#define mmPA_CL_VPORT_XSCALE_9_BASE_IDX                                                                1
#define mmPA_CL_VPORT_XOFFSET_9                                                                        0x0146
#define mmPA_CL_VPORT_XOFFSET_9_BASE_IDX                                                               1
#define mmPA_CL_VPORT_YSCALE_9                                                                         0x0147
#define mmPA_CL_VPORT_YSCALE_9_BASE_IDX                                                                1
#define mmPA_CL_VPORT_YOFFSET_9                                                                        0x0148
#define mmPA_CL_VPORT_YOFFSET_9_BASE_IDX                                                               1
#define mmPA_CL_VPORT_ZSCALE_9                                                                         0x0149
#define mmPA_CL_VPORT_ZSCALE_9_BASE_IDX                                                                1
#define mmPA_CL_VPORT_ZOFFSET_9                                                                        0x014a
#define mmPA_CL_VPORT_ZOFFSET_9_BASE_IDX                                                               1
#define mmPA_CL_VPORT_XSCALE_10                                                                        0x014b
#define mmPA_CL_VPORT_XSCALE_10_BASE_IDX                                                               1
#define mmPA_CL_VPORT_XOFFSET_10                                                                       0x014c
#define mmPA_CL_VPORT_XOFFSET_10_BASE_IDX                                                              1
#define mmPA_CL_VPORT_YSCALE_10                                                                        0x014d
#define mmPA_CL_VPORT_YSCALE_10_BASE_IDX                                                               1
#define mmPA_CL_VPORT_YOFFSET_10                                                                       0x014e
#define mmPA_CL_VPORT_YOFFSET_10_BASE_IDX                                                              1
#define mmPA_CL_VPORT_ZSCALE_10                                                                        0x014f
#define mmPA_CL_VPORT_ZSCALE_10_BASE_IDX                                                               1
#define mmPA_CL_VPORT_ZOFFSET_10                                                                       0x0150
#define mmPA_CL_VPORT_ZOFFSET_10_BASE_IDX                                                              1
#define mmPA_CL_VPORT_XSCALE_11                                                                        0x0151
#define mmPA_CL_VPORT_XSCALE_11_BASE_IDX                                                               1
#define mmPA_CL_VPORT_XOFFSET_11                                                                       0x0152
#define mmPA_CL_VPORT_XOFFSET_11_BASE_IDX                                                              1
#define mmPA_CL_VPORT_YSCALE_11                                                                        0x0153
#define mmPA_CL_VPORT_YSCALE_11_BASE_IDX                                                               1
#define mmPA_CL_VPORT_YOFFSET_11                                                                       0x0154
#define mmPA_CL_VPORT_YOFFSET_11_BASE_IDX                                                              1
#define mmPA_CL_VPORT_ZSCALE_11                                                                        0x0155
#define mmPA_CL_VPORT_ZSCALE_11_BASE_IDX                                                               1
#define mmPA_CL_VPORT_ZOFFSET_11                                                                       0x0156
#define mmPA_CL_VPORT_ZOFFSET_11_BASE_IDX                                                              1
#define mmPA_CL_VPORT_XSCALE_12                                                                        0x0157
#define mmPA_CL_VPORT_XSCALE_12_BASE_IDX                                                               1
#define mmPA_CL_VPORT_XOFFSET_12                                                                       0x0158
#define mmPA_CL_VPORT_XOFFSET_12_BASE_IDX                                                              1
#define mmPA_CL_VPORT_YSCALE_12                                                                        0x0159
#define mmPA_CL_VPORT_YSCALE_12_BASE_IDX                                                               1
#define mmPA_CL_VPORT_YOFFSET_12                                                                       0x015a
#define mmPA_CL_VPORT_YOFFSET_12_BASE_IDX                                                              1
#define mmPA_CL_VPORT_ZSCALE_12                                                                        0x015b
#define mmPA_CL_VPORT_ZSCALE_12_BASE_IDX                                                               1
#define mmPA_CL_VPORT_ZOFFSET_12                                                                       0x015c
#define mmPA_CL_VPORT_ZOFFSET_12_BASE_IDX                                                              1
#define mmPA_CL_VPORT_XSCALE_13                                                                        0x015d
#define mmPA_CL_VPORT_XSCALE_13_BASE_IDX                                                               1
#define mmPA_CL_VPORT_XOFFSET_13                                                                       0x015e
#define mmPA_CL_VPORT_XOFFSET_13_BASE_IDX                                                              1
#define mmPA_CL_VPORT_YSCALE_13                                                                        0x015f
#define mmPA_CL_VPORT_YSCALE_13_BASE_IDX                                                               1
#define mmPA_CL_VPORT_YOFFSET_13                                                                       0x0160
#define mmPA_CL_VPORT_YOFFSET_13_BASE_IDX                                                              1
#define mmPA_CL_VPORT_ZSCALE_13                                                                        0x0161
#define mmPA_CL_VPORT_ZSCALE_13_BASE_IDX                                                               1
#define mmPA_CL_VPORT_ZOFFSET_13                                                                       0x0162
#define mmPA_CL_VPORT_ZOFFSET_13_BASE_IDX                                                              1
#define mmPA_CL_VPORT_XSCALE_14                                                                        0x0163
#define mmPA_CL_VPORT_XSCALE_14_BASE_IDX                                                               1
#define mmPA_CL_VPORT_XOFFSET_14                                                                       0x0164
#define mmPA_CL_VPORT_XOFFSET_14_BASE_IDX                                                              1
#define mmPA_CL_VPORT_YSCALE_14                                                                        0x0165
#define mmPA_CL_VPORT_YSCALE_14_BASE_IDX                                                               1
#define mmPA_CL_VPORT_YOFFSET_14                                                                       0x0166
#define mmPA_CL_VPORT_YOFFSET_14_BASE_IDX                                                              1
#define mmPA_CL_VPORT_ZSCALE_14                                                                        0x0167
#define mmPA_CL_VPORT_ZSCALE_14_BASE_IDX                                                               1
#define mmPA_CL_VPORT_ZOFFSET_14                                                                       0x0168
#define mmPA_CL_VPORT_ZOFFSET_14_BASE_IDX                                                              1
#define mmPA_CL_VPORT_XSCALE_15                                                                        0x0169
#define mmPA_CL_VPORT_XSCALE_15_BASE_IDX                                                               1
#define mmPA_CL_VPORT_XOFFSET_15                                                                       0x016a
#define mmPA_CL_VPORT_XOFFSET_15_BASE_IDX                                                              1
#define mmPA_CL_VPORT_YSCALE_15                                                                        0x016b
#define mmPA_CL_VPORT_YSCALE_15_BASE_IDX                                                               1
#define mmPA_CL_VPORT_YOFFSET_15                                                                       0x016c
#define mmPA_CL_VPORT_YOFFSET_15_BASE_IDX                                                              1
#define mmPA_CL_VPORT_ZSCALE_15                                                                        0x016d
#define mmPA_CL_VPORT_ZSCALE_15_BASE_IDX                                                               1
#define mmPA_CL_VPORT_ZOFFSET_15                                                                       0x016e
#define mmPA_CL_VPORT_ZOFFSET_15_BASE_IDX                                                              1
#define mmPA_CL_UCP_0_X                                                                                0x016f
#define mmPA_CL_UCP_0_X_BASE_IDX                                                                       1
#define mmPA_CL_UCP_0_Y                                                                                0x0170
#define mmPA_CL_UCP_0_Y_BASE_IDX                                                                       1
#define mmPA_CL_UCP_0_Z                                                                                0x0171
#define mmPA_CL_UCP_0_Z_BASE_IDX                                                                       1
#define mmPA_CL_UCP_0_W                                                                                0x0172
#define mmPA_CL_UCP_0_W_BASE_IDX                                                                       1
#define mmPA_CL_UCP_1_X                                                                                0x0173
#define mmPA_CL_UCP_1_X_BASE_IDX                                                                       1
#define mmPA_CL_UCP_1_Y                                                                                0x0174
#define mmPA_CL_UCP_1_Y_BASE_IDX                                                                       1
#define mmPA_CL_UCP_1_Z                                                                                0x0175
#define mmPA_CL_UCP_1_Z_BASE_IDX                                                                       1
#define mmPA_CL_UCP_1_W                                                                                0x0176
#define mmPA_CL_UCP_1_W_BASE_IDX                                                                       1
#define mmPA_CL_UCP_2_X                                                                                0x0177
#define mmPA_CL_UCP_2_X_BASE_IDX                                                                       1
#define mmPA_CL_UCP_2_Y                                                                                0x0178
#define mmPA_CL_UCP_2_Y_BASE_IDX                                                                       1
#define mmPA_CL_UCP_2_Z                                                                                0x0179
#define mmPA_CL_UCP_2_Z_BASE_IDX                                                                       1
#define mmPA_CL_UCP_2_W                                                                                0x017a
#define mmPA_CL_UCP_2_W_BASE_IDX                                                                       1
#define mmPA_CL_UCP_3_X                                                                                0x017b
#define mmPA_CL_UCP_3_X_BASE_IDX                                                                       1
#define mmPA_CL_UCP_3_Y                                                                                0x017c
#define mmPA_CL_UCP_3_Y_BASE_IDX                                                                       1
#define mmPA_CL_UCP_3_Z                                                                                0x017d
#define mmPA_CL_UCP_3_Z_BASE_IDX                                                                       1
#define mmPA_CL_UCP_3_W                                                                                0x017e
#define mmPA_CL_UCP_3_W_BASE_IDX                                                                       1
#define mmPA_CL_UCP_4_X                                                                                0x017f
#define mmPA_CL_UCP_4_X_BASE_IDX                                                                       1
#define mmPA_CL_UCP_4_Y                                                                                0x0180
#define mmPA_CL_UCP_4_Y_BASE_IDX                                                                       1
#define mmPA_CL_UCP_4_Z                                                                                0x0181
#define mmPA_CL_UCP_4_Z_BASE_IDX                                                                       1
#define mmPA_CL_UCP_4_W                                                                                0x0182
#define mmPA_CL_UCP_4_W_BASE_IDX                                                                       1
#define mmPA_CL_UCP_5_X                                                                                0x0183
#define mmPA_CL_UCP_5_X_BASE_IDX                                                                       1
#define mmPA_CL_UCP_5_Y                                                                                0x0184
#define mmPA_CL_UCP_5_Y_BASE_IDX                                                                       1
#define mmPA_CL_UCP_5_Z                                                                                0x0185
#define mmPA_CL_UCP_5_Z_BASE_IDX                                                                       1
#define mmPA_CL_UCP_5_W                                                                                0x0186
#define mmPA_CL_UCP_5_W_BASE_IDX                                                                       1
#define mmPA_CL_PROG_NEAR_CLIP_Z                                                                       0x0187
#define mmPA_CL_PROG_NEAR_CLIP_Z_BASE_IDX                                                              1
#define mmSPI_PS_INPUT_CNTL_0                                                                          0x0191
#define mmSPI_PS_INPUT_CNTL_0_BASE_IDX                                                                 1
#define mmSPI_PS_INPUT_CNTL_1                                                                          0x0192
#define mmSPI_PS_INPUT_CNTL_1_BASE_IDX                                                                 1
#define mmSPI_PS_INPUT_CNTL_2                                                                          0x0193
#define mmSPI_PS_INPUT_CNTL_2_BASE_IDX                                                                 1
#define mmSPI_PS_INPUT_CNTL_3                                                                          0x0194
#define mmSPI_PS_INPUT_CNTL_3_BASE_IDX                                                                 1
#define mmSPI_PS_INPUT_CNTL_4                                                                          0x0195
#define mmSPI_PS_INPUT_CNTL_4_BASE_IDX                                                                 1
#define mmSPI_PS_INPUT_CNTL_5                                                                          0x0196
#define mmSPI_PS_INPUT_CNTL_5_BASE_IDX                                                                 1
#define mmSPI_PS_INPUT_CNTL_6                                                                          0x0197
#define mmSPI_PS_INPUT_CNTL_6_BASE_IDX                                                                 1
#define mmSPI_PS_INPUT_CNTL_7                                                                          0x0198
#define mmSPI_PS_INPUT_CNTL_7_BASE_IDX                                                                 1
#define mmSPI_PS_INPUT_CNTL_8                                                                          0x0199
#define mmSPI_PS_INPUT_CNTL_8_BASE_IDX                                                                 1
#define mmSPI_PS_INPUT_CNTL_9                                                                          0x019a
#define mmSPI_PS_INPUT_CNTL_9_BASE_IDX                                                                 1
#define mmSPI_PS_INPUT_CNTL_10                                                                         0x019b
#define mmSPI_PS_INPUT_CNTL_10_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_11                                                                         0x019c
#define mmSPI_PS_INPUT_CNTL_11_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_12                                                                         0x019d
#define mmSPI_PS_INPUT_CNTL_12_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_13                                                                         0x019e
#define mmSPI_PS_INPUT_CNTL_13_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_14                                                                         0x019f
#define mmSPI_PS_INPUT_CNTL_14_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_15                                                                         0x01a0
#define mmSPI_PS_INPUT_CNTL_15_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_16                                                                         0x01a1
#define mmSPI_PS_INPUT_CNTL_16_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_17                                                                         0x01a2
#define mmSPI_PS_INPUT_CNTL_17_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_18                                                                         0x01a3
#define mmSPI_PS_INPUT_CNTL_18_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_19                                                                         0x01a4
#define mmSPI_PS_INPUT_CNTL_19_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_20                                                                         0x01a5
#define mmSPI_PS_INPUT_CNTL_20_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_21                                                                         0x01a6
#define mmSPI_PS_INPUT_CNTL_21_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_22                                                                         0x01a7
#define mmSPI_PS_INPUT_CNTL_22_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_23                                                                         0x01a8
#define mmSPI_PS_INPUT_CNTL_23_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_24                                                                         0x01a9
#define mmSPI_PS_INPUT_CNTL_24_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_25                                                                         0x01aa
#define mmSPI_PS_INPUT_CNTL_25_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_26                                                                         0x01ab
#define mmSPI_PS_INPUT_CNTL_26_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_27                                                                         0x01ac
#define mmSPI_PS_INPUT_CNTL_27_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_28                                                                         0x01ad
#define mmSPI_PS_INPUT_CNTL_28_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_29                                                                         0x01ae
#define mmSPI_PS_INPUT_CNTL_29_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_30                                                                         0x01af
#define mmSPI_PS_INPUT_CNTL_30_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_31                                                                         0x01b0
#define mmSPI_PS_INPUT_CNTL_31_BASE_IDX                                                                1
#define mmSPI_VS_OUT_CONFIG                                                                            0x01b1
#define mmSPI_VS_OUT_CONFIG_BASE_IDX                                                                   1
#define mmSPI_PS_INPUT_ENA                                                                             0x01b3
#define mmSPI_PS_INPUT_ENA_BASE_IDX                                                                    1
#define mmSPI_PS_INPUT_ADDR                                                                            0x01b4
#define mmSPI_PS_INPUT_ADDR_BASE_IDX                                                                   1
#define mmSPI_INTERP_CONTROL_0                                                                         0x01b5
#define mmSPI_INTERP_CONTROL_0_BASE_IDX                                                                1
#define mmSPI_PS_IN_CONTROL                                                                            0x01b6
#define mmSPI_PS_IN_CONTROL_BASE_IDX                                                                   1
#define mmSPI_BARYC_CNTL                                                                               0x01b8
#define mmSPI_BARYC_CNTL_BASE_IDX                                                                      1
#define mmSPI_TMPRING_SIZE                                                                             0x01ba
#define mmSPI_TMPRING_SIZE_BASE_IDX                                                                    1
#define mmSPI_SHADER_IDX_FORMAT                                                                        0x01c2
#define mmSPI_SHADER_IDX_FORMAT_BASE_IDX                                                               1
#define mmSPI_SHADER_POS_FORMAT                                                                        0x01c3
#define mmSPI_SHADER_POS_FORMAT_BASE_IDX                                                               1
#define mmSPI_SHADER_Z_FORMAT                                                                          0x01c4
#define mmSPI_SHADER_Z_FORMAT_BASE_IDX                                                                 1
#define mmSPI_SHADER_COL_FORMAT                                                                        0x01c5
#define mmSPI_SHADER_COL_FORMAT_BASE_IDX                                                               1
#define mmSX_PS_DOWNCONVERT_CONTROL                                                                    0x01d4
#define mmSX_PS_DOWNCONVERT_CONTROL_BASE_IDX                                                           1
#define mmSX_PS_DOWNCONVERT                                                                            0x01d5
#define mmSX_PS_DOWNCONVERT_BASE_IDX                                                                   1
#define mmSX_BLEND_OPT_EPSILON                                                                         0x01d6
#define mmSX_BLEND_OPT_EPSILON_BASE_IDX                                                                1
#define mmSX_BLEND_OPT_CONTROL                                                                         0x01d7
#define mmSX_BLEND_OPT_CONTROL_BASE_IDX                                                                1
#define mmSX_MRT0_BLEND_OPT                                                                            0x01d8
#define mmSX_MRT0_BLEND_OPT_BASE_IDX                                                                   1
#define mmSX_MRT1_BLEND_OPT                                                                            0x01d9
#define mmSX_MRT1_BLEND_OPT_BASE_IDX                                                                   1
#define mmSX_MRT2_BLEND_OPT                                                                            0x01da
#define mmSX_MRT2_BLEND_OPT_BASE_IDX                                                                   1
#define mmSX_MRT3_BLEND_OPT                                                                            0x01db
#define mmSX_MRT3_BLEND_OPT_BASE_IDX                                                                   1
#define mmSX_MRT4_BLEND_OPT                                                                            0x01dc
#define mmSX_MRT4_BLEND_OPT_BASE_IDX                                                                   1
#define mmSX_MRT5_BLEND_OPT                                                                            0x01dd
#define mmSX_MRT5_BLEND_OPT_BASE_IDX                                                                   1
#define mmSX_MRT6_BLEND_OPT                                                                            0x01de
#define mmSX_MRT6_BLEND_OPT_BASE_IDX                                                                   1
#define mmSX_MRT7_BLEND_OPT                                                                            0x01df
#define mmSX_MRT7_BLEND_OPT_BASE_IDX                                                                   1
#define mmCB_BLEND0_CONTROL                                                                            0x01e0
#define mmCB_BLEND0_CONTROL_BASE_IDX                                                                   1
#define mmCB_BLEND1_CONTROL                                                                            0x01e1
#define mmCB_BLEND1_CONTROL_BASE_IDX                                                                   1
#define mmCB_BLEND2_CONTROL                                                                            0x01e2
#define mmCB_BLEND2_CONTROL_BASE_IDX                                                                   1
#define mmCB_BLEND3_CONTROL                                                                            0x01e3
#define mmCB_BLEND3_CONTROL_BASE_IDX                                                                   1
#define mmCB_BLEND4_CONTROL                                                                            0x01e4
#define mmCB_BLEND4_CONTROL_BASE_IDX                                                                   1
#define mmCB_BLEND5_CONTROL                                                                            0x01e5
#define mmCB_BLEND5_CONTROL_BASE_IDX                                                                   1
#define mmCB_BLEND6_CONTROL                                                                            0x01e6
#define mmCB_BLEND6_CONTROL_BASE_IDX                                                                   1
#define mmCB_BLEND7_CONTROL                                                                            0x01e7
#define mmCB_BLEND7_CONTROL_BASE_IDX                                                                   1
#define mmCS_COPY_STATE                                                                                0x01f3
#define mmCS_COPY_STATE_BASE_IDX                                                                       1
#define mmGFX_COPY_STATE                                                                               0x01f4
#define mmGFX_COPY_STATE_BASE_IDX                                                                      1
#define mmPA_CL_POINT_X_RAD                                                                            0x01f5
#define mmPA_CL_POINT_X_RAD_BASE_IDX                                                                   1
#define mmPA_CL_POINT_Y_RAD                                                                            0x01f6
#define mmPA_CL_POINT_Y_RAD_BASE_IDX                                                                   1
#define mmPA_CL_POINT_SIZE                                                                             0x01f7
#define mmPA_CL_POINT_SIZE_BASE_IDX                                                                    1
#define mmPA_CL_POINT_CULL_RAD                                                                         0x01f8
#define mmPA_CL_POINT_CULL_RAD_BASE_IDX                                                                1
#define mmVGT_DMA_BASE_HI                                                                              0x01f9
#define mmVGT_DMA_BASE_HI_BASE_IDX                                                                     1
#define mmVGT_DMA_BASE                                                                                 0x01fa
#define mmVGT_DMA_BASE_BASE_IDX                                                                        1
#define mmVGT_DRAW_INITIATOR                                                                           0x01fc
#define mmVGT_DRAW_INITIATOR_BASE_IDX                                                                  1
#define mmVGT_IMMED_DATA                                                                               0x01fd
#define mmVGT_IMMED_DATA_BASE_IDX                                                                      1
#define mmVGT_EVENT_ADDRESS_REG                                                                        0x01fe
#define mmVGT_EVENT_ADDRESS_REG_BASE_IDX                                                               1
#define mmGE_MAX_OUTPUT_PER_SUBGROUP                                                                   0x01ff
#define mmGE_MAX_OUTPUT_PER_SUBGROUP_BASE_IDX                                                          1
#define mmDB_DEPTH_CONTROL                                                                             0x0200
#define mmDB_DEPTH_CONTROL_BASE_IDX                                                                    1
#define mmDB_EQAA                                                                                      0x0201
#define mmDB_EQAA_BASE_IDX                                                                             1
#define mmCB_COLOR_CONTROL                                                                             0x0202
#define mmCB_COLOR_CONTROL_BASE_IDX                                                                    1
#define mmDB_SHADER_CONTROL                                                                            0x0203
#define mmDB_SHADER_CONTROL_BASE_IDX                                                                   1
#define mmPA_CL_CLIP_CNTL                                                                              0x0204
#define mmPA_CL_CLIP_CNTL_BASE_IDX                                                                     1
#define mmPA_SU_SC_MODE_CNTL                                                                           0x0205
#define mmPA_SU_SC_MODE_CNTL_BASE_IDX                                                                  1
#define mmPA_CL_VTE_CNTL                                                                               0x0206
#define mmPA_CL_VTE_CNTL_BASE_IDX                                                                      1
#define mmPA_CL_VS_OUT_CNTL                                                                            0x0207
#define mmPA_CL_VS_OUT_CNTL_BASE_IDX                                                                   1
#define mmPA_CL_NANINF_CNTL                                                                            0x0208
#define mmPA_CL_NANINF_CNTL_BASE_IDX                                                                   1
#define mmPA_SU_LINE_STIPPLE_CNTL                                                                      0x0209
#define mmPA_SU_LINE_STIPPLE_CNTL_BASE_IDX                                                             1
#define mmPA_SU_LINE_STIPPLE_SCALE                                                                     0x020a
#define mmPA_SU_LINE_STIPPLE_SCALE_BASE_IDX                                                            1
#define mmPA_SU_PRIM_FILTER_CNTL                                                                       0x020b
#define mmPA_SU_PRIM_FILTER_CNTL_BASE_IDX                                                              1
#define mmPA_SU_SMALL_PRIM_FILTER_CNTL                                                                 0x020c
#define mmPA_SU_SMALL_PRIM_FILTER_CNTL_BASE_IDX                                                        1
#define mmPA_CL_NGG_CNTL                                                                               0x020e
#define mmPA_CL_NGG_CNTL_BASE_IDX                                                                      1
#define mmPA_SU_OVER_RASTERIZATION_CNTL                                                                0x020f
#define mmPA_SU_OVER_RASTERIZATION_CNTL_BASE_IDX                                                       1
#define mmPA_STEREO_CNTL                                                                               0x0210
#define mmPA_STEREO_CNTL_BASE_IDX                                                                      1
#define mmPA_STATE_STEREO_X                                                                            0x0211
#define mmPA_STATE_STEREO_X_BASE_IDX                                                                   1
#define mmPA_SU_POINT_SIZE                                                                             0x0280
#define mmPA_SU_POINT_SIZE_BASE_IDX                                                                    1
#define mmPA_SU_POINT_MINMAX                                                                           0x0281
#define mmPA_SU_POINT_MINMAX_BASE_IDX                                                                  1
#define mmPA_SU_LINE_CNTL                                                                              0x0282
#define mmPA_SU_LINE_CNTL_BASE_IDX                                                                     1
#define mmPA_SC_LINE_STIPPLE                                                                           0x0283
#define mmPA_SC_LINE_STIPPLE_BASE_IDX                                                                  1
#define mmVGT_OUTPUT_PATH_CNTL                                                                         0x0284
#define mmVGT_OUTPUT_PATH_CNTL_BASE_IDX                                                                1
#define mmVGT_HOS_CNTL                                                                                 0x0285
#define mmVGT_HOS_CNTL_BASE_IDX                                                                        1
#define mmVGT_HOS_MAX_TESS_LEVEL                                                                       0x0286
#define mmVGT_HOS_MAX_TESS_LEVEL_BASE_IDX                                                              1
#define mmVGT_HOS_MIN_TESS_LEVEL                                                                       0x0287
#define mmVGT_HOS_MIN_TESS_LEVEL_BASE_IDX                                                              1
#define mmVGT_HOS_REUSE_DEPTH                                                                          0x0288
#define mmVGT_HOS_REUSE_DEPTH_BASE_IDX                                                                 1
#define mmVGT_GROUP_PRIM_TYPE                                                                          0x0289
#define mmVGT_GROUP_PRIM_TYPE_BASE_IDX                                                                 1
#define mmVGT_GROUP_FIRST_DECR                                                                         0x028a
#define mmVGT_GROUP_FIRST_DECR_BASE_IDX                                                                1
#define mmVGT_GROUP_DECR                                                                               0x028b
#define mmVGT_GROUP_DECR_BASE_IDX                                                                      1
#define mmVGT_GROUP_VECT_0_CNTL                                                                        0x028c
#define mmVGT_GROUP_VECT_0_CNTL_BASE_IDX                                                               1
#define mmVGT_GROUP_VECT_1_CNTL                                                                        0x028d
#define mmVGT_GROUP_VECT_1_CNTL_BASE_IDX                                                               1
#define mmVGT_GROUP_VECT_0_FMT_CNTL                                                                    0x028e
#define mmVGT_GROUP_VECT_0_FMT_CNTL_BASE_IDX                                                           1
#define mmVGT_GROUP_VECT_1_FMT_CNTL                                                                    0x028f
#define mmVGT_GROUP_VECT_1_FMT_CNTL_BASE_IDX                                                           1
#define mmVGT_GS_MODE                                                                                  0x0290
#define mmVGT_GS_MODE_BASE_IDX                                                                         1
#define mmVGT_GS_ONCHIP_CNTL                                                                           0x0291
#define mmVGT_GS_ONCHIP_CNTL_BASE_IDX                                                                  1
#define mmPA_SC_MODE_CNTL_0                                                                            0x0292
#define mmPA_SC_MODE_CNTL_0_BASE_IDX                                                                   1
#define mmPA_SC_MODE_CNTL_1                                                                            0x0293
#define mmPA_SC_MODE_CNTL_1_BASE_IDX                                                                   1
#define mmVGT_ENHANCE                                                                                  0x0294
#define mmVGT_ENHANCE_BASE_IDX                                                                         1
#define mmVGT_GS_PER_ES                                                                                0x0295
#define mmVGT_GS_PER_ES_BASE_IDX                                                                       1
#define mmVGT_ES_PER_GS                                                                                0x0296
#define mmVGT_ES_PER_GS_BASE_IDX                                                                       1
#define mmVGT_GS_PER_VS                                                                                0x0297
#define mmVGT_GS_PER_VS_BASE_IDX                                                                       1
#define mmVGT_GSVS_RING_OFFSET_1                                                                       0x0298
#define mmVGT_GSVS_RING_OFFSET_1_BASE_IDX                                                              1
#define mmVGT_GSVS_RING_OFFSET_2                                                                       0x0299
#define mmVGT_GSVS_RING_OFFSET_2_BASE_IDX                                                              1
#define mmVGT_GSVS_RING_OFFSET_3                                                                       0x029a
#define mmVGT_GSVS_RING_OFFSET_3_BASE_IDX                                                              1
#define mmVGT_GS_OUT_PRIM_TYPE                                                                         0x029b
#define mmVGT_GS_OUT_PRIM_TYPE_BASE_IDX                                                                1
#define mmIA_ENHANCE                                                                                   0x029c
#define mmIA_ENHANCE_BASE_IDX                                                                          1
#define mmVGT_DMA_SIZE                                                                                 0x029d
#define mmVGT_DMA_SIZE_BASE_IDX                                                                        1
#define mmVGT_DMA_MAX_SIZE                                                                             0x029e
#define mmVGT_DMA_MAX_SIZE_BASE_IDX                                                                    1
#define mmVGT_DMA_INDEX_TYPE                                                                           0x029f
#define mmVGT_DMA_INDEX_TYPE_BASE_IDX                                                                  1
#define mmWD_ENHANCE                                                                                   0x02a0
#define mmWD_ENHANCE_BASE_IDX                                                                          1
#define mmVGT_PRIMITIVEID_EN                                                                           0x02a1
#define mmVGT_PRIMITIVEID_EN_BASE_IDX                                                                  1
#define mmVGT_DMA_NUM_INSTANCES                                                                        0x02a2
#define mmVGT_DMA_NUM_INSTANCES_BASE_IDX                                                               1
#define mmVGT_PRIMITIVEID_RESET                                                                        0x02a3
#define mmVGT_PRIMITIVEID_RESET_BASE_IDX                                                               1
#define mmVGT_EVENT_INITIATOR                                                                          0x02a4
#define mmVGT_EVENT_INITIATOR_BASE_IDX                                                                 1
#define mmVGT_MULTI_PRIM_IB_RESET_EN                                                                   0x02a5
#define mmVGT_MULTI_PRIM_IB_RESET_EN_BASE_IDX                                                          1
#define mmVGT_DRAW_PAYLOAD_CNTL                                                                        0x02a6
#define mmVGT_DRAW_PAYLOAD_CNTL_BASE_IDX                                                               1
#define mmVGT_INSTANCE_STEP_RATE_0                                                                     0x02a8
#define mmVGT_INSTANCE_STEP_RATE_0_BASE_IDX                                                            1
#define mmVGT_INSTANCE_STEP_RATE_1                                                                     0x02a9
#define mmVGT_INSTANCE_STEP_RATE_1_BASE_IDX                                                            1
#define mmIA_MULTI_VGT_PARAM                                                                           0x02aa
#define mmIA_MULTI_VGT_PARAM_BASE_IDX                                                                  1
#define mmVGT_ESGS_RING_ITEMSIZE                                                                       0x02ab
#define mmVGT_ESGS_RING_ITEMSIZE_BASE_IDX                                                              1
#define mmVGT_GSVS_RING_ITEMSIZE                                                                       0x02ac
#define mmVGT_GSVS_RING_ITEMSIZE_BASE_IDX                                                              1
#define mmVGT_REUSE_OFF                                                                                0x02ad
#define mmVGT_REUSE_OFF_BASE_IDX                                                                       1
#define mmVGT_VTX_CNT_EN                                                                               0x02ae
#define mmVGT_VTX_CNT_EN_BASE_IDX                                                                      1
#define mmDB_HTILE_SURFACE                                                                             0x02af
#define mmDB_HTILE_SURFACE_BASE_IDX                                                                    1
#define mmDB_SRESULTS_COMPARE_STATE0                                                                   0x02b0
#define mmDB_SRESULTS_COMPARE_STATE0_BASE_IDX                                                          1
#define mmDB_SRESULTS_COMPARE_STATE1                                                                   0x02b1
#define mmDB_SRESULTS_COMPARE_STATE1_BASE_IDX                                                          1
#define mmDB_PRELOAD_CONTROL                                                                           0x02b2
#define mmDB_PRELOAD_CONTROL_BASE_IDX                                                                  1
#define mmVGT_STRMOUT_BUFFER_SIZE_0                                                                    0x02b4
#define mmVGT_STRMOUT_BUFFER_SIZE_0_BASE_IDX                                                           1
#define mmVGT_STRMOUT_VTX_STRIDE_0                                                                     0x02b5
#define mmVGT_STRMOUT_VTX_STRIDE_0_BASE_IDX                                                            1
#define mmVGT_STRMOUT_BUFFER_OFFSET_0                                                                  0x02b7
#define mmVGT_STRMOUT_BUFFER_OFFSET_0_BASE_IDX                                                         1
#define mmVGT_STRMOUT_BUFFER_SIZE_1                                                                    0x02b8
#define mmVGT_STRMOUT_BUFFER_SIZE_1_BASE_IDX                                                           1
#define mmVGT_STRMOUT_VTX_STRIDE_1                                                                     0x02b9
#define mmVGT_STRMOUT_VTX_STRIDE_1_BASE_IDX                                                            1
#define mmVGT_STRMOUT_BUFFER_OFFSET_1                                                                  0x02bb
#define mmVGT_STRMOUT_BUFFER_OFFSET_1_BASE_IDX                                                         1
#define mmVGT_STRMOUT_BUFFER_SIZE_2                                                                    0x02bc
#define mmVGT_STRMOUT_BUFFER_SIZE_2_BASE_IDX                                                           1
#define mmVGT_STRMOUT_VTX_STRIDE_2                                                                     0x02bd
#define mmVGT_STRMOUT_VTX_STRIDE_2_BASE_IDX                                                            1
#define mmVGT_STRMOUT_BUFFER_OFFSET_2                                                                  0x02bf
#define mmVGT_STRMOUT_BUFFER_OFFSET_2_BASE_IDX                                                         1
#define mmVGT_STRMOUT_BUFFER_SIZE_3                                                                    0x02c0
#define mmVGT_STRMOUT_BUFFER_SIZE_3_BASE_IDX                                                           1
#define mmVGT_STRMOUT_VTX_STRIDE_3                                                                     0x02c1
#define mmVGT_STRMOUT_VTX_STRIDE_3_BASE_IDX                                                            1
#define mmVGT_STRMOUT_BUFFER_OFFSET_3                                                                  0x02c3
#define mmVGT_STRMOUT_BUFFER_OFFSET_3_BASE_IDX                                                         1
#define mmVGT_STRMOUT_DRAW_OPAQUE_OFFSET                                                               0x02ca
#define mmVGT_STRMOUT_DRAW_OPAQUE_OFFSET_BASE_IDX                                                      1
#define mmVGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE                                                   0x02cb
#define mmVGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE_BASE_IDX                                          1
#define mmVGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE                                                        0x02cc
#define mmVGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE_BASE_IDX                                               1
#define mmVGT_GS_MAX_VERT_OUT                                                                          0x02ce
#define mmVGT_GS_MAX_VERT_OUT_BASE_IDX                                                                 1
#define mmGE_NGG_SUBGRP_CNTL                                                                           0x02d3
#define mmGE_NGG_SUBGRP_CNTL_BASE_IDX                                                                  1
#define mmVGT_TESS_DISTRIBUTION                                                                        0x02d4
#define mmVGT_TESS_DISTRIBUTION_BASE_IDX                                                               1
#define mmVGT_SHADER_STAGES_EN                                                                         0x02d5
#define mmVGT_SHADER_STAGES_EN_BASE_IDX                                                                1
#define mmVGT_LS_HS_CONFIG                                                                             0x02d6
#define mmVGT_LS_HS_CONFIG_BASE_IDX                                                                    1
#define mmVGT_GS_VERT_ITEMSIZE                                                                         0x02d7
#define mmVGT_GS_VERT_ITEMSIZE_BASE_IDX                                                                1
#define mmVGT_GS_VERT_ITEMSIZE_1                                                                       0x02d8
#define mmVGT_GS_VERT_ITEMSIZE_1_BASE_IDX                                                              1
#define mmVGT_GS_VERT_ITEMSIZE_2                                                                       0x02d9
#define mmVGT_GS_VERT_ITEMSIZE_2_BASE_IDX                                                              1
#define mmVGT_GS_VERT_ITEMSIZE_3                                                                       0x02da
#define mmVGT_GS_VERT_ITEMSIZE_3_BASE_IDX                                                              1
#define mmVGT_TF_PARAM                                                                                 0x02db
#define mmVGT_TF_PARAM_BASE_IDX                                                                        1
#define mmDB_ALPHA_TO_MASK                                                                             0x02dc
#define mmDB_ALPHA_TO_MASK_BASE_IDX                                                                    1
#define mmVGT_DISPATCH_DRAW_INDEX                                                                      0x02dd
#define mmVGT_DISPATCH_DRAW_INDEX_BASE_IDX                                                             1
#define mmPA_SU_POLY_OFFSET_DB_FMT_CNTL                                                                0x02de
#define mmPA_SU_POLY_OFFSET_DB_FMT_CNTL_BASE_IDX                                                       1
#define mmPA_SU_POLY_OFFSET_CLAMP                                                                      0x02df
#define mmPA_SU_POLY_OFFSET_CLAMP_BASE_IDX                                                             1
#define mmPA_SU_POLY_OFFSET_FRONT_SCALE                                                                0x02e0
#define mmPA_SU_POLY_OFFSET_FRONT_SCALE_BASE_IDX                                                       1
#define mmPA_SU_POLY_OFFSET_FRONT_OFFSET                                                               0x02e1
#define mmPA_SU_POLY_OFFSET_FRONT_OFFSET_BASE_IDX                                                      1
#define mmPA_SU_POLY_OFFSET_BACK_SCALE                                                                 0x02e2
#define mmPA_SU_POLY_OFFSET_BACK_SCALE_BASE_IDX                                                        1
#define mmPA_SU_POLY_OFFSET_BACK_OFFSET                                                                0x02e3
#define mmPA_SU_POLY_OFFSET_BACK_OFFSET_BASE_IDX                                                       1
#define mmVGT_GS_INSTANCE_CNT                                                                          0x02e4
#define mmVGT_GS_INSTANCE_CNT_BASE_IDX                                                                 1
#define mmVGT_STRMOUT_CONFIG                                                                           0x02e5
#define mmVGT_STRMOUT_CONFIG_BASE_IDX                                                                  1
#define mmVGT_STRMOUT_BUFFER_CONFIG                                                                    0x02e6
#define mmVGT_STRMOUT_BUFFER_CONFIG_BASE_IDX                                                           1
#define mmVGT_DMA_EVENT_INITIATOR                                                                      0x02e7
#define mmVGT_DMA_EVENT_INITIATOR_BASE_IDX                                                             1
#define mmPA_SC_CENTROID_PRIORITY_0                                                                    0x02f5
#define mmPA_SC_CENTROID_PRIORITY_0_BASE_IDX                                                           1
#define mmPA_SC_CENTROID_PRIORITY_1                                                                    0x02f6
#define mmPA_SC_CENTROID_PRIORITY_1_BASE_IDX                                                           1
#define mmPA_SC_LINE_CNTL                                                                              0x02f7
#define mmPA_SC_LINE_CNTL_BASE_IDX                                                                     1
#define mmPA_SC_AA_CONFIG                                                                              0x02f8
#define mmPA_SC_AA_CONFIG_BASE_IDX                                                                     1
#define mmPA_SU_VTX_CNTL                                                                               0x02f9
#define mmPA_SU_VTX_CNTL_BASE_IDX                                                                      1
#define mmPA_CL_GB_VERT_CLIP_ADJ                                                                       0x02fa
#define mmPA_CL_GB_VERT_CLIP_ADJ_BASE_IDX                                                              1
#define mmPA_CL_GB_VERT_DISC_ADJ                                                                       0x02fb
#define mmPA_CL_GB_VERT_DISC_ADJ_BASE_IDX                                                              1
#define mmPA_CL_GB_HORZ_CLIP_ADJ                                                                       0x02fc
#define mmPA_CL_GB_HORZ_CLIP_ADJ_BASE_IDX                                                              1
#define mmPA_CL_GB_HORZ_DISC_ADJ                                                                       0x02fd
#define mmPA_CL_GB_HORZ_DISC_ADJ_BASE_IDX                                                              1
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0                                                            0x02fe
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0_BASE_IDX                                                   1
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1                                                            0x02ff
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1_BASE_IDX                                                   1
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2                                                            0x0300
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2_BASE_IDX                                                   1
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3                                                            0x0301
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3_BASE_IDX                                                   1
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0                                                            0x0302
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0_BASE_IDX                                                   1
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1                                                            0x0303
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1_BASE_IDX                                                   1
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2                                                            0x0304
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2_BASE_IDX                                                   1
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3                                                            0x0305
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3_BASE_IDX                                                   1
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0                                                            0x0306
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0_BASE_IDX                                                   1
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1                                                            0x0307
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1_BASE_IDX                                                   1
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2                                                            0x0308
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2_BASE_IDX                                                   1
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3                                                            0x0309
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3_BASE_IDX                                                   1
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0                                                            0x030a
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0_BASE_IDX                                                   1
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1                                                            0x030b
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1_BASE_IDX                                                   1
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2                                                            0x030c
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2_BASE_IDX                                                   1
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3                                                            0x030d
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3_BASE_IDX                                                   1
#define mmPA_SC_AA_MASK_X0Y0_X1Y0                                                                      0x030e
#define mmPA_SC_AA_MASK_X0Y0_X1Y0_BASE_IDX                                                             1
#define mmPA_SC_AA_MASK_X0Y1_X1Y1                                                                      0x030f
#define mmPA_SC_AA_MASK_X0Y1_X1Y1_BASE_IDX                                                             1
#define mmPA_SC_SHADER_CONTROL                                                                         0x0310
#define mmPA_SC_SHADER_CONTROL_BASE_IDX                                                                1
#define mmPA_SC_BINNER_CNTL_0                                                                          0x0311
#define mmPA_SC_BINNER_CNTL_0_BASE_IDX                                                                 1
#define mmPA_SC_BINNER_CNTL_1                                                                          0x0312
#define mmPA_SC_BINNER_CNTL_1_BASE_IDX                                                                 1
#define mmPA_SC_CONSERVATIVE_RASTERIZATION_CNTL                                                        0x0313
#define mmPA_SC_CONSERVATIVE_RASTERIZATION_CNTL_BASE_IDX                                               1
#define mmPA_SC_NGG_MODE_CNTL                                                                          0x0314
#define mmPA_SC_NGG_MODE_CNTL_BASE_IDX                                                                 1
#define mmVGT_VERTEX_REUSE_BLOCK_CNTL                                                                  0x0316
#define mmVGT_VERTEX_REUSE_BLOCK_CNTL_BASE_IDX                                                         1
#define mmVGT_OUT_DEALLOC_CNTL                                                                         0x0317
#define mmVGT_OUT_DEALLOC_CNTL_BASE_IDX                                                                1
#define mmCB_COLOR0_BASE                                                                               0x0318
#define mmCB_COLOR0_BASE_BASE_IDX                                                                      1
#define mmCB_COLOR0_PITCH                                                                              0x0319
#define mmCB_COLOR0_PITCH_BASE_IDX                                                                     1
#define mmCB_COLOR0_SLICE                                                                              0x031a
#define mmCB_COLOR0_SLICE_BASE_IDX                                                                     1
#define mmCB_COLOR0_VIEW                                                                               0x031b
#define mmCB_COLOR0_VIEW_BASE_IDX                                                                      1
#define mmCB_COLOR0_INFO                                                                               0x031c
#define mmCB_COLOR0_INFO_BASE_IDX                                                                      1
#define mmCB_COLOR0_ATTRIB                                                                             0x031d
#define mmCB_COLOR0_ATTRIB_BASE_IDX                                                                    1
#define mmCB_COLOR0_DCC_CONTROL                                                                        0x031e
#define mmCB_COLOR0_DCC_CONTROL_BASE_IDX                                                               1
#define mmCB_COLOR0_CMASK                                                                              0x031f
#define mmCB_COLOR0_CMASK_BASE_IDX                                                                     1
#define mmCB_COLOR0_CMASK_SLICE                                                                        0x0320
#define mmCB_COLOR0_CMASK_SLICE_BASE_IDX                                                               1
#define mmCB_COLOR0_FMASK                                                                              0x0321
#define mmCB_COLOR0_FMASK_BASE_IDX                                                                     1
#define mmCB_COLOR0_FMASK_SLICE                                                                        0x0322
#define mmCB_COLOR0_FMASK_SLICE_BASE_IDX                                                               1
#define mmCB_COLOR0_CLEAR_WORD0                                                                        0x0323
#define mmCB_COLOR0_CLEAR_WORD0_BASE_IDX                                                               1
#define mmCB_COLOR0_CLEAR_WORD1                                                                        0x0324
#define mmCB_COLOR0_CLEAR_WORD1_BASE_IDX                                                               1
#define mmCB_COLOR0_DCC_BASE                                                                           0x0325
#define mmCB_COLOR0_DCC_BASE_BASE_IDX                                                                  1
#define mmCB_COLOR1_BASE                                                                               0x0327
#define mmCB_COLOR1_BASE_BASE_IDX                                                                      1
#define mmCB_COLOR1_PITCH                                                                              0x0328
#define mmCB_COLOR1_PITCH_BASE_IDX                                                                     1
#define mmCB_COLOR1_SLICE                                                                              0x0329
#define mmCB_COLOR1_SLICE_BASE_IDX                                                                     1
#define mmCB_COLOR1_VIEW                                                                               0x032a
#define mmCB_COLOR1_VIEW_BASE_IDX                                                                      1
#define mmCB_COLOR1_INFO                                                                               0x032b
#define mmCB_COLOR1_INFO_BASE_IDX                                                                      1
#define mmCB_COLOR1_ATTRIB                                                                             0x032c
#define mmCB_COLOR1_ATTRIB_BASE_IDX                                                                    1
#define mmCB_COLOR1_DCC_CONTROL                                                                        0x032d
#define mmCB_COLOR1_DCC_CONTROL_BASE_IDX                                                               1
#define mmCB_COLOR1_CMASK                                                                              0x032e
#define mmCB_COLOR1_CMASK_BASE_IDX                                                                     1
#define mmCB_COLOR1_CMASK_SLICE                                                                        0x032f
#define mmCB_COLOR1_CMASK_SLICE_BASE_IDX                                                               1
#define mmCB_COLOR1_FMASK                                                                              0x0330
#define mmCB_COLOR1_FMASK_BASE_IDX                                                                     1
#define mmCB_COLOR1_FMASK_SLICE                                                                        0x0331
#define mmCB_COLOR1_FMASK_SLICE_BASE_IDX                                                               1
#define mmCB_COLOR1_CLEAR_WORD0                                                                        0x0332
#define mmCB_COLOR1_CLEAR_WORD0_BASE_IDX                                                               1
#define mmCB_COLOR1_CLEAR_WORD1                                                                        0x0333
#define mmCB_COLOR1_CLEAR_WORD1_BASE_IDX                                                               1
#define mmCB_COLOR1_DCC_BASE                                                                           0x0334
#define mmCB_COLOR1_DCC_BASE_BASE_IDX                                                                  1
#define mmCB_COLOR2_BASE                                                                               0x0336
#define mmCB_COLOR2_BASE_BASE_IDX                                                                      1
#define mmCB_COLOR2_PITCH                                                                              0x0337
#define mmCB_COLOR2_PITCH_BASE_IDX                                                                     1
#define mmCB_COLOR2_SLICE                                                                              0x0338
#define mmCB_COLOR2_SLICE_BASE_IDX                                                                     1
#define mmCB_COLOR2_VIEW                                                                               0x0339
#define mmCB_COLOR2_VIEW_BASE_IDX                                                                      1
#define mmCB_COLOR2_INFO                                                                               0x033a
#define mmCB_COLOR2_INFO_BASE_IDX                                                                      1
#define mmCB_COLOR2_ATTRIB                                                                             0x033b
#define mmCB_COLOR2_ATTRIB_BASE_IDX                                                                    1
#define mmCB_COLOR2_DCC_CONTROL                                                                        0x033c
#define mmCB_COLOR2_DCC_CONTROL_BASE_IDX                                                               1
#define mmCB_COLOR2_CMASK                                                                              0x033d
#define mmCB_COLOR2_CMASK_BASE_IDX                                                                     1
#define mmCB_COLOR2_CMASK_SLICE                                                                        0x033e
#define mmCB_COLOR2_CMASK_SLICE_BASE_IDX                                                               1
#define mmCB_COLOR2_FMASK                                                                              0x033f
#define mmCB_COLOR2_FMASK_BASE_IDX                                                                     1
#define mmCB_COLOR2_FMASK_SLICE                                                                        0x0340
#define mmCB_COLOR2_FMASK_SLICE_BASE_IDX                                                               1
#define mmCB_COLOR2_CLEAR_WORD0                                                                        0x0341
#define mmCB_COLOR2_CLEAR_WORD0_BASE_IDX                                                               1
#define mmCB_COLOR2_CLEAR_WORD1                                                                        0x0342
#define mmCB_COLOR2_CLEAR_WORD1_BASE_IDX                                                               1
#define mmCB_COLOR2_DCC_BASE                                                                           0x0343
#define mmCB_COLOR2_DCC_BASE_BASE_IDX                                                                  1
#define mmCB_COLOR3_BASE                                                                               0x0345
#define mmCB_COLOR3_BASE_BASE_IDX                                                                      1
#define mmCB_COLOR3_PITCH                                                                              0x0346
#define mmCB_COLOR3_PITCH_BASE_IDX                                                                     1
#define mmCB_COLOR3_SLICE                                                                              0x0347
#define mmCB_COLOR3_SLICE_BASE_IDX                                                                     1
#define mmCB_COLOR3_VIEW                                                                               0x0348
#define mmCB_COLOR3_VIEW_BASE_IDX                                                                      1
#define mmCB_COLOR3_INFO                                                                               0x0349
#define mmCB_COLOR3_INFO_BASE_IDX                                                                      1
#define mmCB_COLOR3_ATTRIB                                                                             0x034a
#define mmCB_COLOR3_ATTRIB_BASE_IDX                                                                    1
#define mmCB_COLOR3_DCC_CONTROL                                                                        0x034b
#define mmCB_COLOR3_DCC_CONTROL_BASE_IDX                                                               1
#define mmCB_COLOR3_CMASK                                                                              0x034c
#define mmCB_COLOR3_CMASK_BASE_IDX                                                                     1
#define mmCB_COLOR3_CMASK_SLICE                                                                        0x034d
#define mmCB_COLOR3_CMASK_SLICE_BASE_IDX                                                               1
#define mmCB_COLOR3_FMASK                                                                              0x034e
#define mmCB_COLOR3_FMASK_BASE_IDX                                                                     1
#define mmCB_COLOR3_FMASK_SLICE                                                                        0x034f
#define mmCB_COLOR3_FMASK_SLICE_BASE_IDX                                                               1
#define mmCB_COLOR3_CLEAR_WORD0                                                                        0x0350
#define mmCB_COLOR3_CLEAR_WORD0_BASE_IDX                                                               1
#define mmCB_COLOR3_CLEAR_WORD1                                                                        0x0351
#define mmCB_COLOR3_CLEAR_WORD1_BASE_IDX                                                               1
#define mmCB_COLOR3_DCC_BASE                                                                           0x0352
#define mmCB_COLOR3_DCC_BASE_BASE_IDX                                                                  1
#define mmCB_COLOR4_BASE                                                                               0x0354
#define mmCB_COLOR4_BASE_BASE_IDX                                                                      1
#define mmCB_COLOR4_PITCH                                                                              0x0355
#define mmCB_COLOR4_PITCH_BASE_IDX                                                                     1
#define mmCB_COLOR4_SLICE                                                                              0x0356
#define mmCB_COLOR4_SLICE_BASE_IDX                                                                     1
#define mmCB_COLOR4_VIEW                                                                               0x0357
#define mmCB_COLOR4_VIEW_BASE_IDX                                                                      1
#define mmCB_COLOR4_INFO                                                                               0x0358
#define mmCB_COLOR4_INFO_BASE_IDX                                                                      1
#define mmCB_COLOR4_ATTRIB                                                                             0x0359
#define mmCB_COLOR4_ATTRIB_BASE_IDX                                                                    1
#define mmCB_COLOR4_DCC_CONTROL                                                                        0x035a
#define mmCB_COLOR4_DCC_CONTROL_BASE_IDX                                                               1
#define mmCB_COLOR4_CMASK                                                                              0x035b
#define mmCB_COLOR4_CMASK_BASE_IDX                                                                     1
#define mmCB_COLOR4_CMASK_SLICE                                                                        0x035c
#define mmCB_COLOR4_CMASK_SLICE_BASE_IDX                                                               1
#define mmCB_COLOR4_FMASK                                                                              0x035d
#define mmCB_COLOR4_FMASK_BASE_IDX                                                                     1
#define mmCB_COLOR4_FMASK_SLICE                                                                        0x035e
#define mmCB_COLOR4_FMASK_SLICE_BASE_IDX                                                               1
#define mmCB_COLOR4_CLEAR_WORD0                                                                        0x035f
#define mmCB_COLOR4_CLEAR_WORD0_BASE_IDX                                                               1
#define mmCB_COLOR4_CLEAR_WORD1                                                                        0x0360
#define mmCB_COLOR4_CLEAR_WORD1_BASE_IDX                                                               1
#define mmCB_COLOR4_DCC_BASE                                                                           0x0361
#define mmCB_COLOR4_DCC_BASE_BASE_IDX                                                                  1
#define mmCB_COLOR5_BASE                                                                               0x0363
#define mmCB_COLOR5_BASE_BASE_IDX                                                                      1
#define mmCB_COLOR5_PITCH                                                                              0x0364
#define mmCB_COLOR5_PITCH_BASE_IDX                                                                     1
#define mmCB_COLOR5_SLICE                                                                              0x0365
#define mmCB_COLOR5_SLICE_BASE_IDX                                                                     1
#define mmCB_COLOR5_VIEW                                                                               0x0366
#define mmCB_COLOR5_VIEW_BASE_IDX                                                                      1
#define mmCB_COLOR5_INFO                                                                               0x0367
#define mmCB_COLOR5_INFO_BASE_IDX                                                                      1
#define mmCB_COLOR5_ATTRIB                                                                             0x0368
#define mmCB_COLOR5_ATTRIB_BASE_IDX                                                                    1
#define mmCB_COLOR5_DCC_CONTROL                                                                        0x0369
#define mmCB_COLOR5_DCC_CONTROL_BASE_IDX                                                               1
#define mmCB_COLOR5_CMASK                                                                              0x036a
#define mmCB_COLOR5_CMASK_BASE_IDX                                                                     1
#define mmCB_COLOR5_CMASK_SLICE                                                                        0x036b
#define mmCB_COLOR5_CMASK_SLICE_BASE_IDX                                                               1
#define mmCB_COLOR5_FMASK                                                                              0x036c
#define mmCB_COLOR5_FMASK_BASE_IDX                                                                     1
#define mmCB_COLOR5_FMASK_SLICE                                                                        0x036d
#define mmCB_COLOR5_FMASK_SLICE_BASE_IDX                                                               1
#define mmCB_COLOR5_CLEAR_WORD0                                                                        0x036e
#define mmCB_COLOR5_CLEAR_WORD0_BASE_IDX                                                               1
#define mmCB_COLOR5_CLEAR_WORD1                                                                        0x036f
#define mmCB_COLOR5_CLEAR_WORD1_BASE_IDX                                                               1
#define mmCB_COLOR5_DCC_BASE                                                                           0x0370
#define mmCB_COLOR5_DCC_BASE_BASE_IDX                                                                  1
#define mmCB_COLOR6_BASE                                                                               0x0372
#define mmCB_COLOR6_BASE_BASE_IDX                                                                      1
#define mmCB_COLOR6_PITCH                                                                              0x0373
#define mmCB_COLOR6_PITCH_BASE_IDX                                                                     1
#define mmCB_COLOR6_SLICE                                                                              0x0374
#define mmCB_COLOR6_SLICE_BASE_IDX                                                                     1
#define mmCB_COLOR6_VIEW                                                                               0x0375
#define mmCB_COLOR6_VIEW_BASE_IDX                                                                      1
#define mmCB_COLOR6_INFO                                                                               0x0376
#define mmCB_COLOR6_INFO_BASE_IDX                                                                      1
#define mmCB_COLOR6_ATTRIB                                                                             0x0377
#define mmCB_COLOR6_ATTRIB_BASE_IDX                                                                    1
#define mmCB_COLOR6_DCC_CONTROL                                                                        0x0378
#define mmCB_COLOR6_DCC_CONTROL_BASE_IDX                                                               1
#define mmCB_COLOR6_CMASK                                                                              0x0379
#define mmCB_COLOR6_CMASK_BASE_IDX                                                                     1
#define mmCB_COLOR6_CMASK_SLICE                                                                        0x037a
#define mmCB_COLOR6_CMASK_SLICE_BASE_IDX                                                               1
#define mmCB_COLOR6_FMASK                                                                              0x037b
#define mmCB_COLOR6_FMASK_BASE_IDX                                                                     1
#define mmCB_COLOR6_FMASK_SLICE                                                                        0x037c
#define mmCB_COLOR6_FMASK_SLICE_BASE_IDX                                                               1
#define mmCB_COLOR6_CLEAR_WORD0                                                                        0x037d
#define mmCB_COLOR6_CLEAR_WORD0_BASE_IDX                                                               1
#define mmCB_COLOR6_CLEAR_WORD1                                                                        0x037e
#define mmCB_COLOR6_CLEAR_WORD1_BASE_IDX                                                               1
#define mmCB_COLOR6_DCC_BASE                                                                           0x037f
#define mmCB_COLOR6_DCC_BASE_BASE_IDX                                                                  1
#define mmCB_COLOR7_BASE                                                                               0x0381
#define mmCB_COLOR7_BASE_BASE_IDX                                                                      1
#define mmCB_COLOR7_PITCH                                                                              0x0382
#define mmCB_COLOR7_PITCH_BASE_IDX                                                                     1
#define mmCB_COLOR7_SLICE                                                                              0x0383
#define mmCB_COLOR7_SLICE_BASE_IDX                                                                     1
#define mmCB_COLOR7_VIEW                                                                               0x0384
#define mmCB_COLOR7_VIEW_BASE_IDX                                                                      1
#define mmCB_COLOR7_INFO                                                                               0x0385
#define mmCB_COLOR7_INFO_BASE_IDX                                                                      1
#define mmCB_COLOR7_ATTRIB                                                                             0x0386
#define mmCB_COLOR7_ATTRIB_BASE_IDX                                                                    1
#define mmCB_COLOR7_DCC_CONTROL                                                                        0x0387
#define mmCB_COLOR7_DCC_CONTROL_BASE_IDX                                                               1
#define mmCB_COLOR7_CMASK                                                                              0x0388
#define mmCB_COLOR7_CMASK_BASE_IDX                                                                     1
#define mmCB_COLOR7_CMASK_SLICE                                                                        0x0389
#define mmCB_COLOR7_CMASK_SLICE_BASE_IDX                                                               1
#define mmCB_COLOR7_FMASK                                                                              0x038a
#define mmCB_COLOR7_FMASK_BASE_IDX                                                                     1
#define mmCB_COLOR7_FMASK_SLICE                                                                        0x038b
#define mmCB_COLOR7_FMASK_SLICE_BASE_IDX                                                               1
#define mmCB_COLOR7_CLEAR_WORD0                                                                        0x038c
#define mmCB_COLOR7_CLEAR_WORD0_BASE_IDX                                                               1
#define mmCB_COLOR7_CLEAR_WORD1                                                                        0x038d
#define mmCB_COLOR7_CLEAR_WORD1_BASE_IDX                                                               1
#define mmCB_COLOR7_DCC_BASE                                                                           0x038e
#define mmCB_COLOR7_DCC_BASE_BASE_IDX                                                                  1
#define mmCB_COLOR0_BASE_EXT                                                                           0x0390
#define mmCB_COLOR0_BASE_EXT_BASE_IDX                                                                  1
#define mmCB_COLOR1_BASE_EXT                                                                           0x0391
#define mmCB_COLOR1_BASE_EXT_BASE_IDX                                                                  1
#define mmCB_COLOR2_BASE_EXT                                                                           0x0392
#define mmCB_COLOR2_BASE_EXT_BASE_IDX                                                                  1
#define mmCB_COLOR3_BASE_EXT                                                                           0x0393
#define mmCB_COLOR3_BASE_EXT_BASE_IDX                                                                  1
#define mmCB_COLOR4_BASE_EXT                                                                           0x0394
#define mmCB_COLOR4_BASE_EXT_BASE_IDX                                                                  1
#define mmCB_COLOR5_BASE_EXT                                                                           0x0395
#define mmCB_COLOR5_BASE_EXT_BASE_IDX                                                                  1
#define mmCB_COLOR6_BASE_EXT                                                                           0x0396
#define mmCB_COLOR6_BASE_EXT_BASE_IDX                                                                  1
#define mmCB_COLOR7_BASE_EXT                                                                           0x0397
#define mmCB_COLOR7_BASE_EXT_BASE_IDX                                                                  1
#define mmCB_COLOR0_CMASK_BASE_EXT                                                                     0x0398
#define mmCB_COLOR0_CMASK_BASE_EXT_BASE_IDX                                                            1
#define mmCB_COLOR1_CMASK_BASE_EXT                                                                     0x0399
#define mmCB_COLOR1_CMASK_BASE_EXT_BASE_IDX                                                            1
#define mmCB_COLOR2_CMASK_BASE_EXT                                                                     0x039a
#define mmCB_COLOR2_CMASK_BASE_EXT_BASE_IDX                                                            1
#define mmCB_COLOR3_CMASK_BASE_EXT                                                                     0x039b
#define mmCB_COLOR3_CMASK_BASE_EXT_BASE_IDX                                                            1
#define mmCB_COLOR4_CMASK_BASE_EXT                                                                     0x039c
#define mmCB_COLOR4_CMASK_BASE_EXT_BASE_IDX                                                            1
#define mmCB_COLOR5_CMASK_BASE_EXT                                                                     0x039d
#define mmCB_COLOR5_CMASK_BASE_EXT_BASE_IDX                                                            1
#define mmCB_COLOR6_CMASK_BASE_EXT                                                                     0x039e
#define mmCB_COLOR6_CMASK_BASE_EXT_BASE_IDX                                                            1
#define mmCB_COLOR7_CMASK_BASE_EXT                                                                     0x039f
#define mmCB_COLOR7_CMASK_BASE_EXT_BASE_IDX                                                            1
#define mmCB_COLOR0_FMASK_BASE_EXT                                                                     0x03a0
#define mmCB_COLOR0_FMASK_BASE_EXT_BASE_IDX                                                            1
#define mmCB_COLOR1_FMASK_BASE_EXT                                                                     0x03a1
#define mmCB_COLOR1_FMASK_BASE_EXT_BASE_IDX                                                            1
#define mmCB_COLOR2_FMASK_BASE_EXT                                                                     0x03a2
#define mmCB_COLOR2_FMASK_BASE_EXT_BASE_IDX                                                            1
#define mmCB_COLOR3_FMASK_BASE_EXT                                                                     0x03a3
#define mmCB_COLOR3_FMASK_BASE_EXT_BASE_IDX                                                            1
#define mmCB_COLOR4_FMASK_BASE_EXT                                                                     0x03a4
#define mmCB_COLOR4_FMASK_BASE_EXT_BASE_IDX                                                            1
#define mmCB_COLOR5_FMASK_BASE_EXT                                                                     0x03a5
#define mmCB_COLOR5_FMASK_BASE_EXT_BASE_IDX                                                            1
#define mmCB_COLOR6_FMASK_BASE_EXT                                                                     0x03a6
#define mmCB_COLOR6_FMASK_BASE_EXT_BASE_IDX                                                            1
#define mmCB_COLOR7_FMASK_BASE_EXT                                                                     0x03a7
#define mmCB_COLOR7_FMASK_BASE_EXT_BASE_IDX                                                            1
#define mmCB_COLOR0_DCC_BASE_EXT                                                                       0x03a8
#define mmCB_COLOR0_DCC_BASE_EXT_BASE_IDX                                                              1
#define mmCB_COLOR1_DCC_BASE_EXT                                                                       0x03a9
#define mmCB_COLOR1_DCC_BASE_EXT_BASE_IDX                                                              1
#define mmCB_COLOR2_DCC_BASE_EXT                                                                       0x03aa
#define mmCB_COLOR2_DCC_BASE_EXT_BASE_IDX                                                              1
#define mmCB_COLOR3_DCC_BASE_EXT                                                                       0x03ab
#define mmCB_COLOR3_DCC_BASE_EXT_BASE_IDX                                                              1
#define mmCB_COLOR4_DCC_BASE_EXT                                                                       0x03ac
#define mmCB_COLOR4_DCC_BASE_EXT_BASE_IDX                                                              1
#define mmCB_COLOR5_DCC_BASE_EXT                                                                       0x03ad
#define mmCB_COLOR5_DCC_BASE_EXT_BASE_IDX                                                              1
#define mmCB_COLOR6_DCC_BASE_EXT                                                                       0x03ae
#define mmCB_COLOR6_DCC_BASE_EXT_BASE_IDX                                                              1
#define mmCB_COLOR7_DCC_BASE_EXT                                                                       0x03af
#define mmCB_COLOR7_DCC_BASE_EXT_BASE_IDX                                                              1
#define mmCB_COLOR0_ATTRIB2                                                                            0x03b0
#define mmCB_COLOR0_ATTRIB2_BASE_IDX                                                                   1
#define mmCB_COLOR1_ATTRIB2                                                                            0x03b1
#define mmCB_COLOR1_ATTRIB2_BASE_IDX                                                                   1
#define mmCB_COLOR2_ATTRIB2                                                                            0x03b2
#define mmCB_COLOR2_ATTRIB2_BASE_IDX                                                                   1
#define mmCB_COLOR3_ATTRIB2                                                                            0x03b3
#define mmCB_COLOR3_ATTRIB2_BASE_IDX                                                                   1
#define mmCB_COLOR4_ATTRIB2                                                                            0x03b4
#define mmCB_COLOR4_ATTRIB2_BASE_IDX                                                                   1
#define mmCB_COLOR5_ATTRIB2                                                                            0x03b5
#define mmCB_COLOR5_ATTRIB2_BASE_IDX                                                                   1
#define mmCB_COLOR6_ATTRIB2                                                                            0x03b6
#define mmCB_COLOR6_ATTRIB2_BASE_IDX                                                                   1
#define mmCB_COLOR7_ATTRIB2                                                                            0x03b7
#define mmCB_COLOR7_ATTRIB2_BASE_IDX                                                                   1
#define mmCB_COLOR0_ATTRIB3                                                                            0x03b8
#define mmCB_COLOR0_ATTRIB3_BASE_IDX                                                                   1
#define mmCB_COLOR1_ATTRIB3                                                                            0x03b9
#define mmCB_COLOR1_ATTRIB3_BASE_IDX                                                                   1
#define mmCB_COLOR2_ATTRIB3                                                                            0x03ba
#define mmCB_COLOR2_ATTRIB3_BASE_IDX                                                                   1
#define mmCB_COLOR3_ATTRIB3                                                                            0x03bb
#define mmCB_COLOR3_ATTRIB3_BASE_IDX                                                                   1
#define mmCB_COLOR4_ATTRIB3                                                                            0x03bc
#define mmCB_COLOR4_ATTRIB3_BASE_IDX                                                                   1
#define mmCB_COLOR5_ATTRIB3                                                                            0x03bd
#define mmCB_COLOR5_ATTRIB3_BASE_IDX                                                                   1
#define mmCB_COLOR6_ATTRIB3                                                                            0x03be
#define mmCB_COLOR6_ATTRIB3_BASE_IDX                                                                   1
#define mmCB_COLOR7_ATTRIB3                                                                            0x03bf
#define mmCB_COLOR7_ATTRIB3_BASE_IDX                                                                   1


// addressBlock: gc_gfxudec
// base address: 0x30000
#define mmCP_EOP_DONE_ADDR_LO                                                                          0x2000
#define mmCP_EOP_DONE_ADDR_LO_BASE_IDX                                                                 1
#define mmCP_EOP_DONE_ADDR_HI                                                                          0x2001
#define mmCP_EOP_DONE_ADDR_HI_BASE_IDX                                                                 1
#define mmCP_EOP_DONE_DATA_LO                                                                          0x2002
#define mmCP_EOP_DONE_DATA_LO_BASE_IDX                                                                 1
#define mmCP_EOP_DONE_DATA_HI                                                                          0x2003
#define mmCP_EOP_DONE_DATA_HI_BASE_IDX                                                                 1
#define mmCP_EOP_LAST_FENCE_LO                                                                         0x2004
#define mmCP_EOP_LAST_FENCE_LO_BASE_IDX                                                                1
#define mmCP_EOP_LAST_FENCE_HI                                                                         0x2005
#define mmCP_EOP_LAST_FENCE_HI_BASE_IDX                                                                1
#define mmCP_STREAM_OUT_ADDR_LO                                                                        0x2006
#define mmCP_STREAM_OUT_ADDR_LO_BASE_IDX                                                               1
#define mmCP_STREAM_OUT_ADDR_HI                                                                        0x2007
#define mmCP_STREAM_OUT_ADDR_HI_BASE_IDX                                                               1
#define mmCP_NUM_PRIM_WRITTEN_COUNT0_LO                                                                0x2008
#define mmCP_NUM_PRIM_WRITTEN_COUNT0_LO_BASE_IDX                                                       1
#define mmCP_NUM_PRIM_WRITTEN_COUNT0_HI                                                                0x2009
#define mmCP_NUM_PRIM_WRITTEN_COUNT0_HI_BASE_IDX                                                       1
#define mmCP_NUM_PRIM_NEEDED_COUNT0_LO                                                                 0x200a
#define mmCP_NUM_PRIM_NEEDED_COUNT0_LO_BASE_IDX                                                        1
#define mmCP_NUM_PRIM_NEEDED_COUNT0_HI                                                                 0x200b
#define mmCP_NUM_PRIM_NEEDED_COUNT0_HI_BASE_IDX                                                        1
#define mmCP_NUM_PRIM_WRITTEN_COUNT1_LO                                                                0x200c
#define mmCP_NUM_PRIM_WRITTEN_COUNT1_LO_BASE_IDX                                                       1
#define mmCP_NUM_PRIM_WRITTEN_COUNT1_HI                                                                0x200d
#define mmCP_NUM_PRIM_WRITTEN_COUNT1_HI_BASE_IDX                                                       1
#define mmCP_NUM_PRIM_NEEDED_COUNT1_LO                                                                 0x200e
#define mmCP_NUM_PRIM_NEEDED_COUNT1_LO_BASE_IDX                                                        1
#define mmCP_NUM_PRIM_NEEDED_COUNT1_HI                                                                 0x200f
#define mmCP_NUM_PRIM_NEEDED_COUNT1_HI_BASE_IDX                                                        1
#define mmCP_NUM_PRIM_WRITTEN_COUNT2_LO                                                                0x2010
#define mmCP_NUM_PRIM_WRITTEN_COUNT2_LO_BASE_IDX                                                       1
#define mmCP_NUM_PRIM_WRITTEN_COUNT2_HI                                                                0x2011
#define mmCP_NUM_PRIM_WRITTEN_COUNT2_HI_BASE_IDX                                                       1
#define mmCP_NUM_PRIM_NEEDED_COUNT2_LO                                                                 0x2012
#define mmCP_NUM_PRIM_NEEDED_COUNT2_LO_BASE_IDX                                                        1
#define mmCP_NUM_PRIM_NEEDED_COUNT2_HI                                                                 0x2013
#define mmCP_NUM_PRIM_NEEDED_COUNT2_HI_BASE_IDX                                                        1
#define mmCP_NUM_PRIM_WRITTEN_COUNT3_LO                                                                0x2014
#define mmCP_NUM_PRIM_WRITTEN_COUNT3_LO_BASE_IDX                                                       1
#define mmCP_NUM_PRIM_WRITTEN_COUNT3_HI                                                                0x2015
#define mmCP_NUM_PRIM_WRITTEN_COUNT3_HI_BASE_IDX                                                       1
#define mmCP_NUM_PRIM_NEEDED_COUNT3_LO                                                                 0x2016
#define mmCP_NUM_PRIM_NEEDED_COUNT3_LO_BASE_IDX                                                        1
#define mmCP_NUM_PRIM_NEEDED_COUNT3_HI                                                                 0x2017
#define mmCP_NUM_PRIM_NEEDED_COUNT3_HI_BASE_IDX                                                        1
#define mmCP_PIPE_STATS_ADDR_LO                                                                        0x2018
#define mmCP_PIPE_STATS_ADDR_LO_BASE_IDX                                                               1
#define mmCP_PIPE_STATS_ADDR_HI                                                                        0x2019
#define mmCP_PIPE_STATS_ADDR_HI_BASE_IDX                                                               1
#define mmCP_VGT_IAVERT_COUNT_LO                                                                       0x201a
#define mmCP_VGT_IAVERT_COUNT_LO_BASE_IDX                                                              1
#define mmCP_VGT_IAVERT_COUNT_HI                                                                       0x201b
#define mmCP_VGT_IAVERT_COUNT_HI_BASE_IDX                                                              1
#define mmCP_VGT_IAPRIM_COUNT_LO                                                                       0x201c
#define mmCP_VGT_IAPRIM_COUNT_LO_BASE_IDX                                                              1
#define mmCP_VGT_IAPRIM_COUNT_HI                                                                       0x201d
#define mmCP_VGT_IAPRIM_COUNT_HI_BASE_IDX                                                              1
#define mmCP_VGT_GSPRIM_COUNT_LO                                                                       0x201e
#define mmCP_VGT_GSPRIM_COUNT_LO_BASE_IDX                                                              1
#define mmCP_VGT_GSPRIM_COUNT_HI                                                                       0x201f
#define mmCP_VGT_GSPRIM_COUNT_HI_BASE_IDX                                                              1
#define mmCP_VGT_VSINVOC_COUNT_LO                                                                      0x2020
#define mmCP_VGT_VSINVOC_COUNT_LO_BASE_IDX                                                             1
#define mmCP_VGT_VSINVOC_COUNT_HI                                                                      0x2021
#define mmCP_VGT_VSINVOC_COUNT_HI_BASE_IDX                                                             1
#define mmCP_VGT_GSINVOC_COUNT_LO                                                                      0x2022
#define mmCP_VGT_GSINVOC_COUNT_LO_BASE_IDX                                                             1
#define mmCP_VGT_GSINVOC_COUNT_HI                                                                      0x2023
#define mmCP_VGT_GSINVOC_COUNT_HI_BASE_IDX                                                             1
#define mmCP_VGT_HSINVOC_COUNT_LO                                                                      0x2024
#define mmCP_VGT_HSINVOC_COUNT_LO_BASE_IDX                                                             1
#define mmCP_VGT_HSINVOC_COUNT_HI                                                                      0x2025
#define mmCP_VGT_HSINVOC_COUNT_HI_BASE_IDX                                                             1
#define mmCP_VGT_DSINVOC_COUNT_LO                                                                      0x2026
#define mmCP_VGT_DSINVOC_COUNT_LO_BASE_IDX                                                             1
#define mmCP_VGT_DSINVOC_COUNT_HI                                                                      0x2027
#define mmCP_VGT_DSINVOC_COUNT_HI_BASE_IDX                                                             1
#define mmCP_PA_CINVOC_COUNT_LO                                                                        0x2028
#define mmCP_PA_CINVOC_COUNT_LO_BASE_IDX                                                               1
#define mmCP_PA_CINVOC_COUNT_HI                                                                        0x2029
#define mmCP_PA_CINVOC_COUNT_HI_BASE_IDX                                                               1
#define mmCP_PA_CPRIM_COUNT_LO                                                                         0x202a
#define mmCP_PA_CPRIM_COUNT_LO_BASE_IDX                                                                1
#define mmCP_PA_CPRIM_COUNT_HI                                                                         0x202b
#define mmCP_PA_CPRIM_COUNT_HI_BASE_IDX                                                                1
#define mmCP_SC_PSINVOC_COUNT0_LO                                                                      0x202c
#define mmCP_SC_PSINVOC_COUNT0_LO_BASE_IDX                                                             1
#define mmCP_SC_PSINVOC_COUNT0_HI                                                                      0x202d
#define mmCP_SC_PSINVOC_COUNT0_HI_BASE_IDX                                                             1
#define mmCP_SC_PSINVOC_COUNT1_LO                                                                      0x202e
#define mmCP_SC_PSINVOC_COUNT1_LO_BASE_IDX                                                             1
#define mmCP_SC_PSINVOC_COUNT1_HI                                                                      0x202f
#define mmCP_SC_PSINVOC_COUNT1_HI_BASE_IDX                                                             1
#define mmCP_VGT_CSINVOC_COUNT_LO                                                                      0x2030
#define mmCP_VGT_CSINVOC_COUNT_LO_BASE_IDX                                                             1
#define mmCP_VGT_CSINVOC_COUNT_HI                                                                      0x2031
#define mmCP_VGT_CSINVOC_COUNT_HI_BASE_IDX                                                             1
#define mmCP_PIPE_STATS_CONTROL                                                                        0x203d
#define mmCP_PIPE_STATS_CONTROL_BASE_IDX                                                               1
#define mmCP_STREAM_OUT_CONTROL                                                                        0x203e
#define mmCP_STREAM_OUT_CONTROL_BASE_IDX                                                               1
#define mmCP_STRMOUT_CNTL                                                                              0x203f
#define mmCP_STRMOUT_CNTL_BASE_IDX                                                                     1
#define mmSCRATCH_REG0                                                                                 0x2040
#define mmSCRATCH_REG0_BASE_IDX                                                                        1
#define mmSCRATCH_REG1                                                                                 0x2041
#define mmSCRATCH_REG1_BASE_IDX                                                                        1
#define mmSCRATCH_REG2                                                                                 0x2042
#define mmSCRATCH_REG2_BASE_IDX                                                                        1
#define mmSCRATCH_REG3                                                                                 0x2043
#define mmSCRATCH_REG3_BASE_IDX                                                                        1
#define mmSCRATCH_REG4                                                                                 0x2044
#define mmSCRATCH_REG4_BASE_IDX                                                                        1
#define mmSCRATCH_REG5                                                                                 0x2045
#define mmSCRATCH_REG5_BASE_IDX                                                                        1
#define mmSCRATCH_REG6                                                                                 0x2046
#define mmSCRATCH_REG6_BASE_IDX                                                                        1
#define mmSCRATCH_REG7                                                                                 0x2047
#define mmSCRATCH_REG7_BASE_IDX                                                                        1
#define mmSCRATCH_REG_ATOMIC                                                                           0x2048
#define mmSCRATCH_REG_ATOMIC_BASE_IDX                                                                  1
#define mmSCRATCH_REG_CMPSWAP_ATOMIC                                                                   0x2048
#define mmSCRATCH_REG_CMPSWAP_ATOMIC_BASE_IDX                                                          1
#define mmCP_APPEND_DDID_CNT                                                                           0x204b
#define mmCP_APPEND_DDID_CNT_BASE_IDX                                                                  1
#define mmCP_APPEND_DATA_HI                                                                            0x204c
#define mmCP_APPEND_DATA_HI_BASE_IDX                                                                   1
#define mmCP_APPEND_LAST_CS_FENCE_HI                                                                   0x204d
#define mmCP_APPEND_LAST_CS_FENCE_HI_BASE_IDX                                                          1
#define mmCP_APPEND_LAST_PS_FENCE_HI                                                                   0x204e
#define mmCP_APPEND_LAST_PS_FENCE_HI_BASE_IDX                                                          1
#define mmSCRATCH_UMSK                                                                                 0x2050
#define mmSCRATCH_UMSK_BASE_IDX                                                                        1
#define mmSCRATCH_ADDR                                                                                 0x2051
#define mmSCRATCH_ADDR_BASE_IDX                                                                        1
#define mmCP_PFP_ATOMIC_PREOP_LO                                                                       0x2052
#define mmCP_PFP_ATOMIC_PREOP_LO_BASE_IDX                                                              1
#define mmCP_PFP_ATOMIC_PREOP_HI                                                                       0x2053
#define mmCP_PFP_ATOMIC_PREOP_HI_BASE_IDX                                                              1
#define mmCP_PFP_GDS_ATOMIC0_PREOP_LO                                                                  0x2054
#define mmCP_PFP_GDS_ATOMIC0_PREOP_LO_BASE_IDX                                                         1
#define mmCP_PFP_GDS_ATOMIC0_PREOP_HI                                                                  0x2055
#define mmCP_PFP_GDS_ATOMIC0_PREOP_HI_BASE_IDX                                                         1
#define mmCP_PFP_GDS_ATOMIC1_PREOP_LO                                                                  0x2056
#define mmCP_PFP_GDS_ATOMIC1_PREOP_LO_BASE_IDX                                                         1
#define mmCP_PFP_GDS_ATOMIC1_PREOP_HI                                                                  0x2057
#define mmCP_PFP_GDS_ATOMIC1_PREOP_HI_BASE_IDX                                                         1
#define mmCP_APPEND_ADDR_LO                                                                            0x2058
#define mmCP_APPEND_ADDR_LO_BASE_IDX                                                                   1
#define mmCP_APPEND_ADDR_HI                                                                            0x2059
#define mmCP_APPEND_ADDR_HI_BASE_IDX                                                                   1
#define mmCP_APPEND_DATA                                                                               0x205a
#define mmCP_APPEND_DATA_BASE_IDX                                                                      1
#define mmCP_APPEND_DATA_LO                                                                            0x205a
#define mmCP_APPEND_DATA_LO_BASE_IDX                                                                   1
#define mmCP_APPEND_LAST_CS_FENCE                                                                      0x205b
#define mmCP_APPEND_LAST_CS_FENCE_BASE_IDX                                                             1
#define mmCP_APPEND_LAST_CS_FENCE_LO                                                                   0x205b
#define mmCP_APPEND_LAST_CS_FENCE_LO_BASE_IDX                                                          1
#define mmCP_APPEND_LAST_PS_FENCE                                                                      0x205c
#define mmCP_APPEND_LAST_PS_FENCE_BASE_IDX                                                             1
#define mmCP_APPEND_LAST_PS_FENCE_LO                                                                   0x205c
#define mmCP_APPEND_LAST_PS_FENCE_LO_BASE_IDX                                                          1
#define mmCP_ATOMIC_PREOP_LO                                                                           0x205d
#define mmCP_ATOMIC_PREOP_LO_BASE_IDX                                                                  1
#define mmCP_ME_ATOMIC_PREOP_LO                                                                        0x205d
#define mmCP_ME_ATOMIC_PREOP_LO_BASE_IDX                                                               1
#define mmCP_ATOMIC_PREOP_HI                                                                           0x205e
#define mmCP_ATOMIC_PREOP_HI_BASE_IDX                                                                  1
#define mmCP_ME_ATOMIC_PREOP_HI                                                                        0x205e
#define mmCP_ME_ATOMIC_PREOP_HI_BASE_IDX                                                               1
#define mmCP_GDS_ATOMIC0_PREOP_LO                                                                      0x205f
#define mmCP_GDS_ATOMIC0_PREOP_LO_BASE_IDX                                                             1
#define mmCP_ME_GDS_ATOMIC0_PREOP_LO                                                                   0x205f
#define mmCP_ME_GDS_ATOMIC0_PREOP_LO_BASE_IDX                                                          1
#define mmCP_GDS_ATOMIC0_PREOP_HI                                                                      0x2060
#define mmCP_GDS_ATOMIC0_PREOP_HI_BASE_IDX                                                             1
#define mmCP_ME_GDS_ATOMIC0_PREOP_HI                                                                   0x2060
#define mmCP_ME_GDS_ATOMIC0_PREOP_HI_BASE_IDX                                                          1
#define mmCP_GDS_ATOMIC1_PREOP_LO                                                                      0x2061
#define mmCP_GDS_ATOMIC1_PREOP_LO_BASE_IDX                                                             1
#define mmCP_ME_GDS_ATOMIC1_PREOP_LO                                                                   0x2061
#define mmCP_ME_GDS_ATOMIC1_PREOP_LO_BASE_IDX                                                          1
#define mmCP_GDS_ATOMIC1_PREOP_HI                                                                      0x2062
#define mmCP_GDS_ATOMIC1_PREOP_HI_BASE_IDX                                                             1
#define mmCP_ME_GDS_ATOMIC1_PREOP_HI                                                                   0x2062
#define mmCP_ME_GDS_ATOMIC1_PREOP_HI_BASE_IDX                                                          1
#define mmCP_ME_MC_WADDR_LO                                                                            0x2069
#define mmCP_ME_MC_WADDR_LO_BASE_IDX                                                                   1
#define mmCP_ME_MC_WADDR_HI                                                                            0x206a
#define mmCP_ME_MC_WADDR_HI_BASE_IDX                                                                   1
#define mmCP_ME_MC_WDATA_LO                                                                            0x206b
#define mmCP_ME_MC_WDATA_LO_BASE_IDX                                                                   1
#define mmCP_ME_MC_WDATA_HI                                                                            0x206c
#define mmCP_ME_MC_WDATA_HI_BASE_IDX                                                                   1
#define mmCP_ME_MC_RADDR_LO                                                                            0x206d
#define mmCP_ME_MC_RADDR_LO_BASE_IDX                                                                   1
#define mmCP_ME_MC_RADDR_HI                                                                            0x206e
#define mmCP_ME_MC_RADDR_HI_BASE_IDX                                                                   1
#define mmCP_SEM_WAIT_TIMER                                                                            0x206f
#define mmCP_SEM_WAIT_TIMER_BASE_IDX                                                                   1
#define mmCP_SIG_SEM_ADDR_LO                                                                           0x2070
#define mmCP_SIG_SEM_ADDR_LO_BASE_IDX                                                                  1
#define mmCP_SIG_SEM_ADDR_HI                                                                           0x2071
#define mmCP_SIG_SEM_ADDR_HI_BASE_IDX                                                                  1
#define mmCP_WAIT_REG_MEM_TIMEOUT                                                                      0x2074
#define mmCP_WAIT_REG_MEM_TIMEOUT_BASE_IDX                                                             1
#define mmCP_WAIT_SEM_ADDR_LO                                                                          0x2075
#define mmCP_WAIT_SEM_ADDR_LO_BASE_IDX                                                                 1
#define mmCP_WAIT_SEM_ADDR_HI                                                                          0x2076
#define mmCP_WAIT_SEM_ADDR_HI_BASE_IDX                                                                 1
#define mmCP_DMA_PFP_CONTROL                                                                           0x2077
#define mmCP_DMA_PFP_CONTROL_BASE_IDX                                                                  1
#define mmCP_DMA_ME_CONTROL                                                                            0x2078
#define mmCP_DMA_ME_CONTROL_BASE_IDX                                                                   1
#define mmCP_COHER_BASE_HI                                                                             0x2079
#define mmCP_COHER_BASE_HI_BASE_IDX                                                                    1
#define mmCP_COHER_START_DELAY                                                                         0x207b
#define mmCP_COHER_START_DELAY_BASE_IDX                                                                1
#define mmCP_COHER_CNTL                                                                                0x207c
#define mmCP_COHER_CNTL_BASE_IDX                                                                       1
#define mmCP_COHER_SIZE                                                                                0x207d
#define mmCP_COHER_SIZE_BASE_IDX                                                                       1
#define mmCP_COHER_BASE                                                                                0x207e
#define mmCP_COHER_BASE_BASE_IDX                                                                       1
#define mmCP_COHER_STATUS                                                                              0x207f
#define mmCP_COHER_STATUS_BASE_IDX                                                                     1
#define mmCP_DMA_ME_SRC_ADDR                                                                           0x2080
#define mmCP_DMA_ME_SRC_ADDR_BASE_IDX                                                                  1
#define mmCP_DMA_ME_SRC_ADDR_HI                                                                        0x2081
#define mmCP_DMA_ME_SRC_ADDR_HI_BASE_IDX                                                               1
#define mmCP_DMA_ME_DST_ADDR                                                                           0x2082
#define mmCP_DMA_ME_DST_ADDR_BASE_IDX                                                                  1
#define mmCP_DMA_ME_DST_ADDR_HI                                                                        0x2083
#define mmCP_DMA_ME_DST_ADDR_HI_BASE_IDX                                                               1
#define mmCP_DMA_ME_COMMAND                                                                            0x2084
#define mmCP_DMA_ME_COMMAND_BASE_IDX                                                                   1
#define mmCP_DMA_PFP_SRC_ADDR                                                                          0x2085
#define mmCP_DMA_PFP_SRC_ADDR_BASE_IDX                                                                 1
#define mmCP_DMA_PFP_SRC_ADDR_HI                                                                       0x2086
#define mmCP_DMA_PFP_SRC_ADDR_HI_BASE_IDX                                                              1
#define mmCP_DMA_PFP_DST_ADDR                                                                          0x2087
#define mmCP_DMA_PFP_DST_ADDR_BASE_IDX                                                                 1
#define mmCP_DMA_PFP_DST_ADDR_HI                                                                       0x2088
#define mmCP_DMA_PFP_DST_ADDR_HI_BASE_IDX                                                              1
#define mmCP_DMA_PFP_COMMAND                                                                           0x2089
#define mmCP_DMA_PFP_COMMAND_BASE_IDX                                                                  1
#define mmCP_DMA_CNTL                                                                                  0x208a
#define mmCP_DMA_CNTL_BASE_IDX                                                                         1
#define mmCP_DMA_READ_TAGS                                                                             0x208b
#define mmCP_DMA_READ_TAGS_BASE_IDX                                                                    1
#define mmCP_COHER_SIZE_HI                                                                             0x208c
#define mmCP_COHER_SIZE_HI_BASE_IDX                                                                    1
#define mmCP_PFP_IB_CONTROL                                                                            0x208d
#define mmCP_PFP_IB_CONTROL_BASE_IDX                                                                   1
#define mmCP_PFP_LOAD_CONTROL                                                                          0x208e
#define mmCP_PFP_LOAD_CONTROL_BASE_IDX                                                                 1
#define mmCP_SCRATCH_INDEX                                                                             0x208f
#define mmCP_SCRATCH_INDEX_BASE_IDX                                                                    1
#define mmCP_SCRATCH_DATA                                                                              0x2090
#define mmCP_SCRATCH_DATA_BASE_IDX                                                                     1
#define mmCP_RB_OFFSET                                                                                 0x2091
#define mmCP_RB_OFFSET_BASE_IDX                                                                        1
#define mmCP_IB2_OFFSET                                                                                0x2093
#define mmCP_IB2_OFFSET_BASE_IDX                                                                       1
#define mmCP_IB2_PREAMBLE_BEGIN                                                                        0x2096
#define mmCP_IB2_PREAMBLE_BEGIN_BASE_IDX                                                               1
#define mmCP_IB2_PREAMBLE_END                                                                          0x2097
#define mmCP_IB2_PREAMBLE_END_BASE_IDX                                                                 1
#define mmCP_CE_IB1_OFFSET                                                                             0x2098
#define mmCP_CE_IB1_OFFSET_BASE_IDX                                                                    1
#define mmCP_CE_IB2_OFFSET                                                                             0x2099
#define mmCP_CE_IB2_OFFSET_BASE_IDX                                                                    1
#define mmCP_CE_COUNTER                                                                                0x209a
#define mmCP_CE_COUNTER_BASE_IDX                                                                       1
#define mmCP_DMA_ME_CMD_ADDR_LO                                                                        0x209c
#define mmCP_DMA_ME_CMD_ADDR_LO_BASE_IDX                                                               1
#define mmCP_DMA_ME_CMD_ADDR_HI                                                                        0x209d
#define mmCP_DMA_ME_CMD_ADDR_HI_BASE_IDX                                                               1
#define mmCP_DMA_PFP_CMD_ADDR_LO                                                                       0x209e
#define mmCP_DMA_PFP_CMD_ADDR_LO_BASE_IDX                                                              1
#define mmCP_DMA_PFP_CMD_ADDR_HI                                                                       0x209f
#define mmCP_DMA_PFP_CMD_ADDR_HI_BASE_IDX                                                              1
#define mmCP_APPEND_CMD_ADDR_LO                                                                        0x20a0
#define mmCP_APPEND_CMD_ADDR_LO_BASE_IDX                                                               1
#define mmCP_APPEND_CMD_ADDR_HI                                                                        0x20a1
#define mmCP_APPEND_CMD_ADDR_HI_BASE_IDX                                                               1
#define mmUCONFIG_RESERVED_REG0                                                                        0x20a2
#define mmUCONFIG_RESERVED_REG0_BASE_IDX                                                               1
#define mmUCONFIG_RESERVED_REG1                                                                        0x20a3
#define mmUCONFIG_RESERVED_REG1_BASE_IDX                                                               1
#define mmCP_CE_ATOMIC_PREOP_LO                                                                        0x20a8
#define mmCP_CE_ATOMIC_PREOP_LO_BASE_IDX                                                               1
#define mmCP_CE_ATOMIC_PREOP_HI                                                                        0x20a9
#define mmCP_CE_ATOMIC_PREOP_HI_BASE_IDX                                                               1
#define mmCP_CE_GDS_ATOMIC0_PREOP_LO                                                                   0x20aa
#define mmCP_CE_GDS_ATOMIC0_PREOP_LO_BASE_IDX                                                          1
#define mmCP_CE_GDS_ATOMIC0_PREOP_HI                                                                   0x20ab
#define mmCP_CE_GDS_ATOMIC0_PREOP_HI_BASE_IDX                                                          1
#define mmCP_CE_GDS_ATOMIC1_PREOP_LO                                                                   0x20ac
#define mmCP_CE_GDS_ATOMIC1_PREOP_LO_BASE_IDX                                                          1
#define mmCP_CE_GDS_ATOMIC1_PREOP_HI                                                                   0x20ad
#define mmCP_CE_GDS_ATOMIC1_PREOP_HI_BASE_IDX                                                          1
#define mmCP_CE_INIT_CMD_BUFSZ                                                                         0x20bd
#define mmCP_CE_INIT_CMD_BUFSZ_BASE_IDX                                                                1
#define mmCP_CE_IB1_CMD_BUFSZ                                                                          0x20be
#define mmCP_CE_IB1_CMD_BUFSZ_BASE_IDX                                                                 1
#define mmCP_CE_IB2_CMD_BUFSZ                                                                          0x20bf
#define mmCP_CE_IB2_CMD_BUFSZ_BASE_IDX                                                                 1
#define mmCP_IB2_CMD_BUFSZ                                                                             0x20c1
#define mmCP_IB2_CMD_BUFSZ_BASE_IDX                                                                    1
#define mmCP_ST_CMD_BUFSZ                                                                              0x20c2
#define mmCP_ST_CMD_BUFSZ_BASE_IDX                                                                     1
#define mmCP_CE_INIT_BASE_LO                                                                           0x20c3
#define mmCP_CE_INIT_BASE_LO_BASE_IDX                                                                  1
#define mmCP_CE_INIT_BASE_HI                                                                           0x20c4
#define mmCP_CE_INIT_BASE_HI_BASE_IDX                                                                  1
#define mmCP_CE_INIT_BUFSZ                                                                             0x20c5
#define mmCP_CE_INIT_BUFSZ_BASE_IDX                                                                    1
#define mmCP_CE_IB1_BASE_LO                                                                            0x20c6
#define mmCP_CE_IB1_BASE_LO_BASE_IDX                                                                   1
#define mmCP_CE_IB1_BASE_HI                                                                            0x20c7
#define mmCP_CE_IB1_BASE_HI_BASE_IDX                                                                   1
#define mmCP_CE_IB1_BUFSZ                                                                              0x20c8
#define mmCP_CE_IB1_BUFSZ_BASE_IDX                                                                     1
#define mmCP_CE_IB2_BASE_LO                                                                            0x20c9
#define mmCP_CE_IB2_BASE_LO_BASE_IDX                                                                   1
#define mmCP_CE_IB2_BASE_HI                                                                            0x20ca
#define mmCP_CE_IB2_BASE_HI_BASE_IDX                                                                   1
#define mmCP_CE_IB2_BUFSZ                                                                              0x20cb
#define mmCP_CE_IB2_BUFSZ_BASE_IDX                                                                     1
#define mmCP_IB2_BASE_LO                                                                               0x20cf
#define mmCP_IB2_BASE_LO_BASE_IDX                                                                      1
#define mmCP_IB2_BASE_HI                                                                               0x20d0
#define mmCP_IB2_BASE_HI_BASE_IDX                                                                      1
#define mmCP_IB2_BUFSZ                                                                                 0x20d1
#define mmCP_IB2_BUFSZ_BASE_IDX                                                                        1
#define mmCP_ST_BASE_LO                                                                                0x20d2
#define mmCP_ST_BASE_LO_BASE_IDX                                                                       1
#define mmCP_ST_BASE_HI                                                                                0x20d3
#define mmCP_ST_BASE_HI_BASE_IDX                                                                       1
#define mmCP_ST_BUFSZ                                                                                  0x20d4
#define mmCP_ST_BUFSZ_BASE_IDX                                                                         1
#define mmCP_EOP_DONE_EVENT_CNTL                                                                       0x20d5
#define mmCP_EOP_DONE_EVENT_CNTL_BASE_IDX                                                              1
#define mmCP_EOP_DONE_DATA_CNTL                                                                        0x20d6
#define mmCP_EOP_DONE_DATA_CNTL_BASE_IDX                                                               1
#define mmCP_EOP_DONE_CNTX_ID                                                                          0x20d7
#define mmCP_EOP_DONE_CNTX_ID_BASE_IDX                                                                 1
#define mmCP_DB_BASE_LO                                                                                0x20d8
#define mmCP_DB_BASE_LO_BASE_IDX                                                                       1
#define mmCP_DB_BASE_HI                                                                                0x20d9
#define mmCP_DB_BASE_HI_BASE_IDX                                                                       1
#define mmCP_DB_BUFSZ                                                                                  0x20da
#define mmCP_DB_BUFSZ_BASE_IDX                                                                         1
#define mmCP_DB_CMD_BUFSZ                                                                              0x20db
#define mmCP_DB_CMD_BUFSZ_BASE_IDX                                                                     1
#define mmCP_CE_DB_BASE_LO                                                                             0x20dc
#define mmCP_CE_DB_BASE_LO_BASE_IDX                                                                    1
#define mmCP_CE_DB_BASE_HI                                                                             0x20dd
#define mmCP_CE_DB_BASE_HI_BASE_IDX                                                                    1
#define mmCP_CE_DB_BUFSZ                                                                               0x20de
#define mmCP_CE_DB_BUFSZ_BASE_IDX                                                                      1
#define mmCP_CE_DB_CMD_BUFSZ                                                                           0x20df
#define mmCP_CE_DB_CMD_BUFSZ_BASE_IDX                                                                  1
#define mmCP_PFP_COMPLETION_STATUS                                                                     0x20ec
#define mmCP_PFP_COMPLETION_STATUS_BASE_IDX                                                            1
#define mmCP_CE_COMPLETION_STATUS                                                                      0x20ed
#define mmCP_CE_COMPLETION_STATUS_BASE_IDX                                                             1
#define mmCP_PRED_NOT_VISIBLE                                                                          0x20ee
#define mmCP_PRED_NOT_VISIBLE_BASE_IDX                                                                 1
#define mmCP_PFP_METADATA_BASE_ADDR                                                                    0x20f0
#define mmCP_PFP_METADATA_BASE_ADDR_BASE_IDX                                                           1
#define mmCP_PFP_METADATA_BASE_ADDR_HI                                                                 0x20f1
#define mmCP_PFP_METADATA_BASE_ADDR_HI_BASE_IDX                                                        1
#define mmCP_CE_METADATA_BASE_ADDR                                                                     0x20f2
#define mmCP_CE_METADATA_BASE_ADDR_BASE_IDX                                                            1
#define mmCP_CE_METADATA_BASE_ADDR_HI                                                                  0x20f3
#define mmCP_CE_METADATA_BASE_ADDR_HI_BASE_IDX                                                         1
#define mmCP_DRAW_INDX_INDR_ADDR                                                                       0x20f4
#define mmCP_DRAW_INDX_INDR_ADDR_BASE_IDX                                                              1
#define mmCP_DRAW_INDX_INDR_ADDR_HI                                                                    0x20f5
#define mmCP_DRAW_INDX_INDR_ADDR_HI_BASE_IDX                                                           1
#define mmCP_DISPATCH_INDR_ADDR                                                                        0x20f6
#define mmCP_DISPATCH_INDR_ADDR_BASE_IDX                                                               1
#define mmCP_DISPATCH_INDR_ADDR_HI                                                                     0x20f7
#define mmCP_DISPATCH_INDR_ADDR_HI_BASE_IDX                                                            1
#define mmCP_INDEX_BASE_ADDR                                                                           0x20f8
#define mmCP_INDEX_BASE_ADDR_BASE_IDX                                                                  1
#define mmCP_INDEX_BASE_ADDR_HI                                                                        0x20f9
#define mmCP_INDEX_BASE_ADDR_HI_BASE_IDX                                                               1
#define mmCP_INDEX_TYPE                                                                                0x20fa
#define mmCP_INDEX_TYPE_BASE_IDX                                                                       1
#define mmCP_GDS_BKUP_ADDR                                                                             0x20fb
#define mmCP_GDS_BKUP_ADDR_BASE_IDX                                                                    1
#define mmCP_GDS_BKUP_ADDR_HI                                                                          0x20fc
#define mmCP_GDS_BKUP_ADDR_HI_BASE_IDX                                                                 1
#define mmCP_SAMPLE_STATUS                                                                             0x20fd
#define mmCP_SAMPLE_STATUS_BASE_IDX                                                                    1
#define mmCP_ME_COHER_CNTL                                                                             0x20fe
#define mmCP_ME_COHER_CNTL_BASE_IDX                                                                    1
#define mmCP_ME_COHER_SIZE                                                                             0x20ff
#define mmCP_ME_COHER_SIZE_BASE_IDX                                                                    1
#define mmCP_ME_COHER_SIZE_HI                                                                          0x2100
#define mmCP_ME_COHER_SIZE_HI_BASE_IDX                                                                 1
#define mmCP_ME_COHER_BASE                                                                             0x2101
#define mmCP_ME_COHER_BASE_BASE_IDX                                                                    1
#define mmCP_ME_COHER_BASE_HI                                                                          0x2102
#define mmCP_ME_COHER_BASE_HI_BASE_IDX                                                                 1
#define mmCP_ME_COHER_STATUS                                                                           0x2103
#define mmCP_ME_COHER_STATUS_BASE_IDX                                                                  1
#define mmRLC_GPM_PERF_COUNT_0                                                                         0x2140
#define mmRLC_GPM_PERF_COUNT_0_BASE_IDX                                                                1
#define mmRLC_GPM_PERF_COUNT_1                                                                         0x2141
#define mmRLC_GPM_PERF_COUNT_1_BASE_IDX                                                                1
#define mmGRBM_GFX_INDEX                                                                               0x2200
#define mmGRBM_GFX_INDEX_BASE_IDX                                                                      1
#define mmVGT_ESGS_RING_SIZE_UMD                                                                       0x2240
#define mmVGT_ESGS_RING_SIZE_UMD_BASE_IDX                                                              1
#define mmVGT_GSVS_RING_SIZE_UMD                                                                       0x2241
#define mmVGT_GSVS_RING_SIZE_UMD_BASE_IDX                                                              1
#define mmVGT_PRIMITIVE_TYPE                                                                           0x2242
#define mmVGT_PRIMITIVE_TYPE_BASE_IDX                                                                  1
#define mmVGT_INDEX_TYPE                                                                               0x2243
#define mmVGT_INDEX_TYPE_BASE_IDX                                                                      1
#define mmVGT_STRMOUT_BUFFER_FILLED_SIZE_0                                                             0x2244
#define mmVGT_STRMOUT_BUFFER_FILLED_SIZE_0_BASE_IDX                                                    1
#define mmVGT_STRMOUT_BUFFER_FILLED_SIZE_1                                                             0x2245
#define mmVGT_STRMOUT_BUFFER_FILLED_SIZE_1_BASE_IDX                                                    1
#define mmVGT_STRMOUT_BUFFER_FILLED_SIZE_2                                                             0x2246
#define mmVGT_STRMOUT_BUFFER_FILLED_SIZE_2_BASE_IDX                                                    1
#define mmVGT_STRMOUT_BUFFER_FILLED_SIZE_3                                                             0x2247
#define mmVGT_STRMOUT_BUFFER_FILLED_SIZE_3_BASE_IDX                                                    1
#define mmGE_MIN_VTX_INDX                                                                              0x2249
#define mmGE_MIN_VTX_INDX_BASE_IDX                                                                     1
#define mmGE_INDX_OFFSET                                                                               0x224a
#define mmGE_INDX_OFFSET_BASE_IDX                                                                      1
#define mmGE_MULTI_PRIM_IB_RESET_EN                                                                    0x224b
#define mmGE_MULTI_PRIM_IB_RESET_EN_BASE_IDX                                                           1
#define mmVGT_NUM_INDICES                                                                              0x224c
#define mmVGT_NUM_INDICES_BASE_IDX                                                                     1
#define mmVGT_NUM_INSTANCES                                                                            0x224d
#define mmVGT_NUM_INSTANCES_BASE_IDX                                                                   1
#define mmVGT_TF_RING_SIZE_UMD                                                                         0x224e
#define mmVGT_TF_RING_SIZE_UMD_BASE_IDX                                                                1
#define mmVGT_HS_OFFCHIP_PARAM_UMD                                                                     0x224f
#define mmVGT_HS_OFFCHIP_PARAM_UMD_BASE_IDX                                                            1
#define mmVGT_TF_MEMORY_BASE_UMD                                                                       0x2250
#define mmVGT_TF_MEMORY_BASE_UMD_BASE_IDX                                                              1
#define mmGE_DMA_FIRST_INDEX                                                                           0x2251
#define mmGE_DMA_FIRST_INDEX_BASE_IDX                                                                  1
#define mmWD_POS_BUF_BASE                                                                              0x2252
#define mmWD_POS_BUF_BASE_BASE_IDX                                                                     1
#define mmWD_POS_BUF_BASE_HI                                                                           0x2253
#define mmWD_POS_BUF_BASE_HI_BASE_IDX                                                                  1
#define mmWD_CNTL_SB_BUF_BASE                                                                          0x2254
#define mmWD_CNTL_SB_BUF_BASE_BASE_IDX                                                                 1
#define mmWD_CNTL_SB_BUF_BASE_HI                                                                       0x2255
#define mmWD_CNTL_SB_BUF_BASE_HI_BASE_IDX                                                              1
#define mmWD_INDEX_BUF_BASE                                                                            0x2256
#define mmWD_INDEX_BUF_BASE_BASE_IDX                                                                   1
#define mmWD_INDEX_BUF_BASE_HI                                                                         0x2257
#define mmWD_INDEX_BUF_BASE_HI_BASE_IDX                                                                1
#define mmIA_MULTI_VGT_PARAM_PIPED                                                                     0x2258
#define mmIA_MULTI_VGT_PARAM_PIPED_BASE_IDX                                                            1
#define mmGE_MAX_VTX_INDX                                                                              0x2259
#define mmGE_MAX_VTX_INDX_BASE_IDX                                                                     1
#define mmVGT_INSTANCE_BASE_ID                                                                         0x225a
#define mmVGT_INSTANCE_BASE_ID_BASE_IDX                                                                1
#define mmGE_CNTL                                                                                      0x225b
#define mmGE_CNTL_BASE_IDX                                                                             1
#define mmGE_USER_VGPR1                                                                                0x225c
#define mmGE_USER_VGPR1_BASE_IDX                                                                       1
#define mmGE_USER_VGPR2                                                                                0x225d
#define mmGE_USER_VGPR2_BASE_IDX                                                                       1
#define mmGE_USER_VGPR3                                                                                0x225e
#define mmGE_USER_VGPR3_BASE_IDX                                                                       1
#define mmGE_STEREO_CNTL                                                                               0x225f
#define mmGE_STEREO_CNTL_BASE_IDX                                                                      1
#define mmGE_PC_ALLOC                                                                                  0x2260
#define mmGE_PC_ALLOC_BASE_IDX                                                                         1
#define mmVGT_TF_MEMORY_BASE_HI_UMD                                                                    0x2261
#define mmVGT_TF_MEMORY_BASE_HI_UMD_BASE_IDX                                                           1
#define mmGE_USER_VGPR_EN                                                                              0x2262
#define mmGE_USER_VGPR_EN_BASE_IDX                                                                     1
#define mmPA_SU_LINE_STIPPLE_VALUE                                                                     0x2280
#define mmPA_SU_LINE_STIPPLE_VALUE_BASE_IDX                                                            1
#define mmPA_SC_LINE_STIPPLE_STATE                                                                     0x2281
#define mmPA_SC_LINE_STIPPLE_STATE_BASE_IDX                                                            1
#define mmPA_SC_SCREEN_EXTENT_MIN_0                                                                    0x2284
#define mmPA_SC_SCREEN_EXTENT_MIN_0_BASE_IDX                                                           1
#define mmPA_SC_SCREEN_EXTENT_MAX_0                                                                    0x2285
#define mmPA_SC_SCREEN_EXTENT_MAX_0_BASE_IDX                                                           1
#define mmPA_SC_SCREEN_EXTENT_MIN_1                                                                    0x2286
#define mmPA_SC_SCREEN_EXTENT_MIN_1_BASE_IDX                                                           1
#define mmPA_SC_SCREEN_EXTENT_MAX_1                                                                    0x228b
#define mmPA_SC_SCREEN_EXTENT_MAX_1_BASE_IDX                                                           1
#define mmPA_SC_P3D_TRAP_SCREEN_HV_EN                                                                  0x22a0
#define mmPA_SC_P3D_TRAP_SCREEN_HV_EN_BASE_IDX                                                         1
#define mmPA_SC_P3D_TRAP_SCREEN_H                                                                      0x22a1
#define mmPA_SC_P3D_TRAP_SCREEN_H_BASE_IDX                                                             1
#define mmPA_SC_P3D_TRAP_SCREEN_V                                                                      0x22a2
#define mmPA_SC_P3D_TRAP_SCREEN_V_BASE_IDX                                                             1
#define mmPA_SC_P3D_TRAP_SCREEN_OCCURRENCE                                                             0x22a3
#define mmPA_SC_P3D_TRAP_SCREEN_OCCURRENCE_BASE_IDX                                                    1
#define mmPA_SC_P3D_TRAP_SCREEN_COUNT                                                                  0x22a4
#define mmPA_SC_P3D_TRAP_SCREEN_COUNT_BASE_IDX                                                         1
#define mmPA_SC_HP3D_TRAP_SCREEN_HV_EN                                                                 0x22a8
#define mmPA_SC_HP3D_TRAP_SCREEN_HV_EN_BASE_IDX                                                        1
#define mmPA_SC_HP3D_TRAP_SCREEN_H                                                                     0x22a9
#define mmPA_SC_HP3D_TRAP_SCREEN_H_BASE_IDX                                                            1
#define mmPA_SC_HP3D_TRAP_SCREEN_V                                                                     0x22aa
#define mmPA_SC_HP3D_TRAP_SCREEN_V_BASE_IDX                                                            1
#define mmPA_SC_HP3D_TRAP_SCREEN_OCCURRENCE                                                            0x22ab
#define mmPA_SC_HP3D_TRAP_SCREEN_OCCURRENCE_BASE_IDX                                                   1
#define mmPA_SC_HP3D_TRAP_SCREEN_COUNT                                                                 0x22ac
#define mmPA_SC_HP3D_TRAP_SCREEN_COUNT_BASE_IDX                                                        1
#define mmPA_SC_TRAP_SCREEN_HV_EN                                                                      0x22b0
#define mmPA_SC_TRAP_SCREEN_HV_EN_BASE_IDX                                                             1
#define mmPA_SC_TRAP_SCREEN_H                                                                          0x22b1
#define mmPA_SC_TRAP_SCREEN_H_BASE_IDX                                                                 1
#define mmPA_SC_TRAP_SCREEN_V                                                                          0x22b2
#define mmPA_SC_TRAP_SCREEN_V_BASE_IDX                                                                 1
#define mmPA_SC_TRAP_SCREEN_OCCURRENCE                                                                 0x22b3
#define mmPA_SC_TRAP_SCREEN_OCCURRENCE_BASE_IDX                                                        1
#define mmPA_SC_TRAP_SCREEN_COUNT                                                                      0x22b4
#define mmPA_SC_TRAP_SCREEN_COUNT_BASE_IDX                                                             1
#define mmSQ_THREAD_TRACE_USERDATA_0                                                                   0x2340
#define mmSQ_THREAD_TRACE_USERDATA_0_BASE_IDX                                                          1
#define mmSQ_THREAD_TRACE_USERDATA_1                                                                   0x2341
#define mmSQ_THREAD_TRACE_USERDATA_1_BASE_IDX                                                          1
#define mmSQ_THREAD_TRACE_USERDATA_2                                                                   0x2342
#define mmSQ_THREAD_TRACE_USERDATA_2_BASE_IDX                                                          1
#define mmSQ_THREAD_TRACE_USERDATA_3                                                                   0x2343
#define mmSQ_THREAD_TRACE_USERDATA_3_BASE_IDX                                                          1
#define mmSQ_THREAD_TRACE_USERDATA_4                                                                   0x2344
#define mmSQ_THREAD_TRACE_USERDATA_4_BASE_IDX                                                          1
#define mmSQ_THREAD_TRACE_USERDATA_5                                                                   0x2345
#define mmSQ_THREAD_TRACE_USERDATA_5_BASE_IDX                                                          1
#define mmSQ_THREAD_TRACE_USERDATA_6                                                                   0x2346
#define mmSQ_THREAD_TRACE_USERDATA_6_BASE_IDX                                                          1
#define mmSQ_THREAD_TRACE_USERDATA_7                                                                   0x2347
#define mmSQ_THREAD_TRACE_USERDATA_7_BASE_IDX                                                          1
#define mmSQC_CACHES                                                                                   0x2348
#define mmSQC_CACHES_BASE_IDX                                                                          1
#define mmTA_CS_BC_BASE_ADDR                                                                           0x2380
#define mmTA_CS_BC_BASE_ADDR_BASE_IDX                                                                  1
#define mmTA_CS_BC_BASE_ADDR_HI                                                                        0x2381
#define mmTA_CS_BC_BASE_ADDR_HI_BASE_IDX                                                               1
#define mmDB_OCCLUSION_COUNT0_LOW                                                                      0x23c0
#define mmDB_OCCLUSION_COUNT0_LOW_BASE_IDX                                                             1
#define mmDB_OCCLUSION_COUNT0_HI                                                                       0x23c1
#define mmDB_OCCLUSION_COUNT0_HI_BASE_IDX                                                              1
#define mmDB_OCCLUSION_COUNT1_LOW                                                                      0x23c2
#define mmDB_OCCLUSION_COUNT1_LOW_BASE_IDX                                                             1
#define mmDB_OCCLUSION_COUNT1_HI                                                                       0x23c3
#define mmDB_OCCLUSION_COUNT1_HI_BASE_IDX                                                              1
#define mmDB_OCCLUSION_COUNT2_LOW                                                                      0x23c4
#define mmDB_OCCLUSION_COUNT2_LOW_BASE_IDX                                                             1
#define mmDB_OCCLUSION_COUNT2_HI                                                                       0x23c5
#define mmDB_OCCLUSION_COUNT2_HI_BASE_IDX                                                              1
#define mmDB_OCCLUSION_COUNT3_LOW                                                                      0x23c6
#define mmDB_OCCLUSION_COUNT3_LOW_BASE_IDX                                                             1
#define mmDB_OCCLUSION_COUNT3_HI                                                                       0x23c7
#define mmDB_OCCLUSION_COUNT3_HI_BASE_IDX                                                              1
#define mmDB_ZPASS_COUNT_LOW                                                                           0x23fe
#define mmDB_ZPASS_COUNT_LOW_BASE_IDX                                                                  1
#define mmDB_ZPASS_COUNT_HI                                                                            0x23ff
#define mmDB_ZPASS_COUNT_HI_BASE_IDX                                                                   1
#define mmGDS_RD_ADDR                                                                                  0x2400
#define mmGDS_RD_ADDR_BASE_IDX                                                                         1
#define mmGDS_RD_DATA                                                                                  0x2401
#define mmGDS_RD_DATA_BASE_IDX                                                                         1
#define mmGDS_RD_BURST_ADDR                                                                            0x2402
#define mmGDS_RD_BURST_ADDR_BASE_IDX                                                                   1
#define mmGDS_RD_BURST_COUNT                                                                           0x2403
#define mmGDS_RD_BURST_COUNT_BASE_IDX                                                                  1
#define mmGDS_RD_BURST_DATA                                                                            0x2404
#define mmGDS_RD_BURST_DATA_BASE_IDX                                                                   1
#define mmGDS_WR_ADDR                                                                                  0x2405
#define mmGDS_WR_ADDR_BASE_IDX                                                                         1
#define mmGDS_WR_DATA                                                                                  0x2406
#define mmGDS_WR_DATA_BASE_IDX                                                                         1
#define mmGDS_WR_BURST_ADDR                                                                            0x2407
#define mmGDS_WR_BURST_ADDR_BASE_IDX                                                                   1
#define mmGDS_WR_BURST_DATA                                                                            0x2408
#define mmGDS_WR_BURST_DATA_BASE_IDX                                                                   1
#define mmGDS_WRITE_COMPLETE                                                                           0x2409
#define mmGDS_WRITE_COMPLETE_BASE_IDX                                                                  1
#define mmGDS_ATOM_CNTL                                                                                0x240a
#define mmGDS_ATOM_CNTL_BASE_IDX                                                                       1
#define mmGDS_ATOM_COMPLETE                                                                            0x240b
#define mmGDS_ATOM_COMPLETE_BASE_IDX                                                                   1
#define mmGDS_ATOM_BASE                                                                                0x240c
#define mmGDS_ATOM_BASE_BASE_IDX                                                                       1
#define mmGDS_ATOM_SIZE                                                                                0x240d
#define mmGDS_ATOM_SIZE_BASE_IDX                                                                       1
#define mmGDS_ATOM_OFFSET0                                                                             0x240e
#define mmGDS_ATOM_OFFSET0_BASE_IDX                                                                    1
#define mmGDS_ATOM_OFFSET1                                                                             0x240f
#define mmGDS_ATOM_OFFSET1_BASE_IDX                                                                    1
#define mmGDS_ATOM_DST                                                                                 0x2410
#define mmGDS_ATOM_DST_BASE_IDX                                                                        1
#define mmGDS_ATOM_OP                                                                                  0x2411
#define mmGDS_ATOM_OP_BASE_IDX                                                                         1
#define mmGDS_ATOM_SRC0                                                                                0x2412
#define mmGDS_ATOM_SRC0_BASE_IDX                                                                       1
#define mmGDS_ATOM_SRC0_U                                                                              0x2413
#define mmGDS_ATOM_SRC0_U_BASE_IDX                                                                     1
#define mmGDS_ATOM_SRC1                                                                                0x2414
#define mmGDS_ATOM_SRC1_BASE_IDX                                                                       1
#define mmGDS_ATOM_SRC1_U                                                                              0x2415
#define mmGDS_ATOM_SRC1_U_BASE_IDX                                                                     1
#define mmGDS_ATOM_READ0                                                                               0x2416
#define mmGDS_ATOM_READ0_BASE_IDX                                                                      1
#define mmGDS_ATOM_READ0_U                                                                             0x2417
#define mmGDS_ATOM_READ0_U_BASE_IDX                                                                    1
#define mmGDS_ATOM_READ1                                                                               0x2418
#define mmGDS_ATOM_READ1_BASE_IDX                                                                      1
#define mmGDS_ATOM_READ1_U                                                                             0x2419
#define mmGDS_ATOM_READ1_U_BASE_IDX                                                                    1
#define mmGDS_GWS_RESOURCE_CNTL                                                                        0x241a
#define mmGDS_GWS_RESOURCE_CNTL_BASE_IDX                                                               1
#define mmGDS_GWS_RESOURCE                                                                             0x241b
#define mmGDS_GWS_RESOURCE_BASE_IDX                                                                    1
#define mmGDS_GWS_RESOURCE_CNT                                                                         0x241c
#define mmGDS_GWS_RESOURCE_CNT_BASE_IDX                                                                1
#define mmGDS_OA_CNTL                                                                                  0x241d
#define mmGDS_OA_CNTL_BASE_IDX                                                                         1
#define mmGDS_OA_COUNTER                                                                               0x241e
#define mmGDS_OA_COUNTER_BASE_IDX                                                                      1
#define mmGDS_OA_ADDRESS                                                                               0x241f
#define mmGDS_OA_ADDRESS_BASE_IDX                                                                      1
#define mmGDS_OA_INCDEC                                                                                0x2420
#define mmGDS_OA_INCDEC_BASE_IDX                                                                       1
#define mmGDS_OA_RING_SIZE                                                                             0x2421
#define mmGDS_OA_RING_SIZE_BASE_IDX                                                                    1
#define mmSPI_CONFIG_CNTL_REMAP                                                                        0x2440
#define mmSPI_CONFIG_CNTL_REMAP_BASE_IDX                                                               1
#define mmSPI_CONFIG_CNTL_1_REMAP                                                                      0x2441
#define mmSPI_CONFIG_CNTL_1_REMAP_BASE_IDX                                                             1
#define mmSPI_CONFIG_CNTL_2_REMAP                                                                      0x2442
#define mmSPI_CONFIG_CNTL_2_REMAP_BASE_IDX                                                             1
#define mmSPI_WAVE_LIMIT_CNTL_REMAP                                                                    0x2443
#define mmSPI_WAVE_LIMIT_CNTL_REMAP_BASE_IDX                                                           1


// addressBlock: gc_cprs64dec
// base address: 0x32000
#define mmCP_MES_PRGRM_CNTR_START                                                                      0x2800
#define mmCP_MES_PRGRM_CNTR_START_BASE_IDX                                                             1
#define mmCP_MES_INTR_ROUTINE_START                                                                    0x2801
#define mmCP_MES_INTR_ROUTINE_START_BASE_IDX                                                           1
#define mmCP_MES_MTVEC_LO                                                                              0x2801
#define mmCP_MES_MTVEC_LO_BASE_IDX                                                                     1
#define mmCP_MES_MTVEC_HI                                                                              0x2802
#define mmCP_MES_MTVEC_HI_BASE_IDX                                                                     1
#define mmCP_MES_CNTL                                                                                  0x2807
#define mmCP_MES_CNTL_BASE_IDX                                                                         1
#define mmCP_MES_PIPE_PRIORITY_CNTS                                                                    0x2808
#define mmCP_MES_PIPE_PRIORITY_CNTS_BASE_IDX                                                           1
#define mmCP_MES_PIPE0_PRIORITY                                                                        0x2809
#define mmCP_MES_PIPE0_PRIORITY_BASE_IDX                                                               1
#define mmCP_MES_PIPE1_PRIORITY                                                                        0x280a
#define mmCP_MES_PIPE1_PRIORITY_BASE_IDX                                                               1
#define mmCP_MES_PIPE2_PRIORITY                                                                        0x280b
#define mmCP_MES_PIPE2_PRIORITY_BASE_IDX                                                               1
#define mmCP_MES_PIPE3_PRIORITY                                                                        0x280c
#define mmCP_MES_PIPE3_PRIORITY_BASE_IDX                                                               1
#define mmCP_MES_HEADER_DUMP                                                                           0x280d
#define mmCP_MES_HEADER_DUMP_BASE_IDX                                                                  1
#define mmCP_MES_MIE_LO                                                                                0x280e
#define mmCP_MES_MIE_LO_BASE_IDX                                                                       1
#define mmCP_MES_MIE_HI                                                                                0x280f
#define mmCP_MES_MIE_HI_BASE_IDX                                                                       1
#define mmCP_MES_INTERRUPT                                                                             0x2810
#define mmCP_MES_INTERRUPT_BASE_IDX                                                                    1
#define mmCP_MES_SCRATCH_INDEX                                                                         0x2811
#define mmCP_MES_SCRATCH_INDEX_BASE_IDX                                                                1
#define mmCP_MES_SCRATCH_DATA                                                                          0x2812
#define mmCP_MES_SCRATCH_DATA_BASE_IDX                                                                 1
#define mmCP_MES_INSTR_PNTR                                                                            0x2813
#define mmCP_MES_INSTR_PNTR_BASE_IDX                                                                   1
#define mmCP_MES_MSCRATCH_HI                                                                           0x2814
#define mmCP_MES_MSCRATCH_HI_BASE_IDX                                                                  1
#define mmCP_MES_MSCRATCH_LO                                                                           0x2815
#define mmCP_MES_MSCRATCH_LO_BASE_IDX                                                                  1
#define mmCP_MES_MSTATUS_LO                                                                            0x2816
#define mmCP_MES_MSTATUS_LO_BASE_IDX                                                                   1
#define mmCP_MES_MSTATUS_HI                                                                            0x2817
#define mmCP_MES_MSTATUS_HI_BASE_IDX                                                                   1
#define mmCP_MES_MEPC_LO                                                                               0x2818
#define mmCP_MES_MEPC_LO_BASE_IDX                                                                      1
#define mmCP_MES_MEPC_HI                                                                               0x2819
#define mmCP_MES_MEPC_HI_BASE_IDX                                                                      1
#define mmCP_MES_MCAUSE_LO                                                                             0x281a
#define mmCP_MES_MCAUSE_LO_BASE_IDX                                                                    1
#define mmCP_MES_MCAUSE_HI                                                                             0x281b
#define mmCP_MES_MCAUSE_HI_BASE_IDX                                                                    1
#define mmCP_MES_MBADADDR_LO                                                                           0x281c
#define mmCP_MES_MBADADDR_LO_BASE_IDX                                                                  1
#define mmCP_MES_MBADADDR_HI                                                                           0x281d
#define mmCP_MES_MBADADDR_HI_BASE_IDX                                                                  1
#define mmCP_MES_MIP_LO                                                                                0x281e
#define mmCP_MES_MIP_LO_BASE_IDX                                                                       1
#define mmCP_MES_MIP_HI                                                                                0x281f
#define mmCP_MES_MIP_HI_BASE_IDX                                                                       1
#define mmCP_MES_IC_OP_CNTL                                                                            0x2820
#define mmCP_MES_IC_OP_CNTL_BASE_IDX                                                                   1
#define mmCP_MES_MCYCLE_LO                                                                             0x2826
#define mmCP_MES_MCYCLE_LO_BASE_IDX                                                                    1
#define mmCP_MES_MCYCLE_HI                                                                             0x2827
#define mmCP_MES_MCYCLE_HI_BASE_IDX                                                                    1
#define mmCP_MES_MTIME_LO                                                                              0x2828
#define mmCP_MES_MTIME_LO_BASE_IDX                                                                     1
#define mmCP_MES_MTIME_HI                                                                              0x2829
#define mmCP_MES_MTIME_HI_BASE_IDX                                                                     1
#define mmCP_MES_MINSTRET_LO                                                                           0x282a
#define mmCP_MES_MINSTRET_LO_BASE_IDX                                                                  1
#define mmCP_MES_MINSTRET_HI                                                                           0x282b
#define mmCP_MES_MINSTRET_HI_BASE_IDX                                                                  1
#define mmCP_MES_MISA_LO                                                                               0x282c
#define mmCP_MES_MISA_LO_BASE_IDX                                                                      1
#define mmCP_MES_MISA_HI                                                                               0x282d
#define mmCP_MES_MISA_HI_BASE_IDX                                                                      1
#define mmCP_MES_MVENDORID_LO                                                                          0x282e
#define mmCP_MES_MVENDORID_LO_BASE_IDX                                                                 1
#define mmCP_MES_MVENDORID_HI                                                                          0x282f
#define mmCP_MES_MVENDORID_HI_BASE_IDX                                                                 1
#define mmCP_MES_MARCHID_LO                                                                            0x2830
#define mmCP_MES_MARCHID_LO_BASE_IDX                                                                   1
#define mmCP_MES_MARCHID_HI                                                                            0x2831
#define mmCP_MES_MARCHID_HI_BASE_IDX                                                                   1
#define mmCP_MES_MIMPID_LO                                                                             0x2832
#define mmCP_MES_MIMPID_LO_BASE_IDX                                                                    1
#define mmCP_MES_MIMPID_HI                                                                             0x2833
#define mmCP_MES_MIMPID_HI_BASE_IDX                                                                    1
#define mmCP_MES_MHARTID_LO                                                                            0x2834
#define mmCP_MES_MHARTID_LO_BASE_IDX                                                                   1
#define mmCP_MES_MHARTID_HI                                                                            0x2835
#define mmCP_MES_MHARTID_HI_BASE_IDX                                                                   1
#define mmCP_MES_DC_BASE_CNTL                                                                          0x2836
#define mmCP_MES_DC_BASE_CNTL_BASE_IDX                                                                 1
#define mmCP_MES_DC_OP_CNTL                                                                            0x2837
#define mmCP_MES_DC_OP_CNTL_BASE_IDX                                                                   1
#define mmCP_MES_MTIMECMP_LO                                                                           0x2838
#define mmCP_MES_MTIMECMP_LO_BASE_IDX                                                                  1
#define mmCP_MES_MTIMECMP_HI                                                                           0x2839
#define mmCP_MES_MTIMECMP_HI_BASE_IDX                                                                  1
#define mmCP_MES_PROCESS_QUANTUM_PIPE0                                                                 0x283a
#define mmCP_MES_PROCESS_QUANTUM_PIPE0_BASE_IDX                                                        1
#define mmCP_MES_PROCESS_QUANTUM_PIPE1                                                                 0x283b
#define mmCP_MES_PROCESS_QUANTUM_PIPE1_BASE_IDX                                                        1
#define mmCP_MES_DOORBELL_CONTROL1                                                                     0x283c
#define mmCP_MES_DOORBELL_CONTROL1_BASE_IDX                                                            1
#define mmCP_MES_DOORBELL_CONTROL2                                                                     0x283d
#define mmCP_MES_DOORBELL_CONTROL2_BASE_IDX                                                            1
#define mmCP_MES_DOORBELL_CONTROL3                                                                     0x283e
#define mmCP_MES_DOORBELL_CONTROL3_BASE_IDX                                                            1
#define mmCP_MES_DOORBELL_CONTROL4                                                                     0x283f
#define mmCP_MES_DOORBELL_CONTROL4_BASE_IDX                                                            1
#define mmCP_MES_DOORBELL_CONTROL5                                                                     0x2840
#define mmCP_MES_DOORBELL_CONTROL5_BASE_IDX                                                            1
#define mmCP_MES_DOORBELL_CONTROL6                                                                     0x2841
#define mmCP_MES_DOORBELL_CONTROL6_BASE_IDX                                                            1
#define mmCP_MES_GP0_LO                                                                                0x2843
#define mmCP_MES_GP0_LO_BASE_IDX                                                                       1
#define mmCP_MES_GP0_HI                                                                                0x2844
#define mmCP_MES_GP0_HI_BASE_IDX                                                                       1
#define mmCP_MES_GP1_LO                                                                                0x2845
#define mmCP_MES_GP1_LO_BASE_IDX                                                                       1
#define mmCP_MES_GP1_HI                                                                                0x2846
#define mmCP_MES_GP1_HI_BASE_IDX                                                                       1
#define mmCP_MES_GP2_LO                                                                                0x2847
#define mmCP_MES_GP2_LO_BASE_IDX                                                                       1
#define mmCP_MES_GP2_HI                                                                                0x2848
#define mmCP_MES_GP2_HI_BASE_IDX                                                                       1
#define mmCP_MES_GP3_LO                                                                                0x2849
#define mmCP_MES_GP3_LO_BASE_IDX                                                                       1
#define mmCP_MES_GP3_HI                                                                                0x284a
#define mmCP_MES_GP3_HI_BASE_IDX                                                                       1
#define mmCP_MES_GP4_LO                                                                                0x284b
#define mmCP_MES_GP4_LO_BASE_IDX                                                                       1
#define mmCP_MES_GP4_HI                                                                                0x284c
#define mmCP_MES_GP4_HI_BASE_IDX                                                                       1
#define mmCP_MES_GP5_LO                                                                                0x284d
#define mmCP_MES_GP5_LO_BASE_IDX                                                                       1
#define mmCP_MES_GP5_HI                                                                                0x284e
#define mmCP_MES_GP5_HI_BASE_IDX                                                                       1
#define mmCP_MES_GP6_LO                                                                                0x284f
#define mmCP_MES_GP6_LO_BASE_IDX                                                                       1
#define mmCP_MES_GP6_HI                                                                                0x2850
#define mmCP_MES_GP6_HI_BASE_IDX                                                                       1
#define mmCP_MES_GP7_LO                                                                                0x2851
#define mmCP_MES_GP7_LO_BASE_IDX                                                                       1
#define mmCP_MES_GP7_HI                                                                                0x2852
#define mmCP_MES_GP7_HI_BASE_IDX                                                                       1
#define mmCP_MES_GP8_LO                                                                                0x2853
#define mmCP_MES_GP8_LO_BASE_IDX                                                                       1
#define mmCP_MES_GP8_HI                                                                                0x2854
#define mmCP_MES_GP8_HI_BASE_IDX                                                                       1
#define mmCP_MES_GP9_LO                                                                                0x2855
#define mmCP_MES_GP9_LO_BASE_IDX                                                                       1
#define mmCP_MES_GP9_HI                                                                                0x2856
#define mmCP_MES_GP9_HI_BASE_IDX                                                                       1
#define mmCP_MES_DM_INDEX_ADDR                                                                         0x2880
#define mmCP_MES_DM_INDEX_ADDR_BASE_IDX                                                                1
#define mmCP_MES_DM_INDEX_DATA                                                                         0x2881
#define mmCP_MES_DM_INDEX_DATA_BASE_IDX                                                                1
#define mmCP_MES_PERFCOUNT_CNTL                                                                        0x2899
#define mmCP_MES_PERFCOUNT_CNTL_BASE_IDX                                                               1
#define mmCP_MES_PENDING_INTERRUPT                                                                     0x289a
#define mmCP_MES_PENDING_INTERRUPT_BASE_IDX                                                            1


// addressBlock: gc_gusdec
// base address: 0x33000
#define mmGUS_IO_RD_COMBINE_FLUSH                                                                      0x2c00
#define mmGUS_IO_RD_COMBINE_FLUSH_BASE_IDX                                                             1
#define mmGUS_IO_WR_COMBINE_FLUSH                                                                      0x2c01
#define mmGUS_IO_WR_COMBINE_FLUSH_BASE_IDX                                                             1
#define mmGUS_IO_RD_PRI_AGE_RATE                                                                       0x2c02
#define mmGUS_IO_RD_PRI_AGE_RATE_BASE_IDX                                                              1
#define mmGUS_IO_WR_PRI_AGE_RATE                                                                       0x2c03
#define mmGUS_IO_WR_PRI_AGE_RATE_BASE_IDX                                                              1
#define mmGUS_IO_RD_PRI_AGE_COEFF                                                                      0x2c04
#define mmGUS_IO_RD_PRI_AGE_COEFF_BASE_IDX                                                             1
#define mmGUS_IO_WR_PRI_AGE_COEFF                                                                      0x2c05
#define mmGUS_IO_WR_PRI_AGE_COEFF_BASE_IDX                                                             1
#define mmGUS_IO_RD_PRI_QUEUING                                                                        0x2c06
#define mmGUS_IO_RD_PRI_QUEUING_BASE_IDX                                                               1
#define mmGUS_IO_WR_PRI_QUEUING                                                                        0x2c07
#define mmGUS_IO_WR_PRI_QUEUING_BASE_IDX                                                               1
#define mmGUS_IO_RD_PRI_FIXED                                                                          0x2c08
#define mmGUS_IO_RD_PRI_FIXED_BASE_IDX                                                                 1
#define mmGUS_IO_WR_PRI_FIXED                                                                          0x2c09
#define mmGUS_IO_WR_PRI_FIXED_BASE_IDX                                                                 1
#define mmGUS_IO_RD_PRI_URGENCY_COEFF                                                                  0x2c0a
#define mmGUS_IO_RD_PRI_URGENCY_COEFF_BASE_IDX                                                         1
#define mmGUS_IO_WR_PRI_URGENCY_COEFF                                                                  0x2c0b
#define mmGUS_IO_WR_PRI_URGENCY_COEFF_BASE_IDX                                                         1
#define mmGUS_IO_RD_PRI_URGENCY_MODE                                                                   0x2c0c
#define mmGUS_IO_RD_PRI_URGENCY_MODE_BASE_IDX                                                          1
#define mmGUS_IO_WR_PRI_URGENCY_MODE                                                                   0x2c0d
#define mmGUS_IO_WR_PRI_URGENCY_MODE_BASE_IDX                                                          1
#define mmGUS_IO_RD_PRI_QUANT_PRI1                                                                     0x2c0e
#define mmGUS_IO_RD_PRI_QUANT_PRI1_BASE_IDX                                                            1
#define mmGUS_IO_RD_PRI_QUANT_PRI2                                                                     0x2c0f
#define mmGUS_IO_RD_PRI_QUANT_PRI2_BASE_IDX                                                            1
#define mmGUS_IO_RD_PRI_QUANT_PRI3                                                                     0x2c10
#define mmGUS_IO_RD_PRI_QUANT_PRI3_BASE_IDX                                                            1
#define mmGUS_IO_RD_PRI_QUANT_PRI4                                                                     0x2c11
#define mmGUS_IO_RD_PRI_QUANT_PRI4_BASE_IDX                                                            1
#define mmGUS_IO_WR_PRI_QUANT_PRI1                                                                     0x2c12
#define mmGUS_IO_WR_PRI_QUANT_PRI1_BASE_IDX                                                            1
#define mmGUS_IO_WR_PRI_QUANT_PRI2                                                                     0x2c13
#define mmGUS_IO_WR_PRI_QUANT_PRI2_BASE_IDX                                                            1
#define mmGUS_IO_WR_PRI_QUANT_PRI3                                                                     0x2c14
#define mmGUS_IO_WR_PRI_QUANT_PRI3_BASE_IDX                                                            1
#define mmGUS_IO_WR_PRI_QUANT_PRI4                                                                     0x2c15
#define mmGUS_IO_WR_PRI_QUANT_PRI4_BASE_IDX                                                            1
#define mmGUS_IO_RD_PRI_QUANT1_PRI1                                                                    0x2c16
#define mmGUS_IO_RD_PRI_QUANT1_PRI1_BASE_IDX                                                           1
#define mmGUS_IO_RD_PRI_QUANT1_PRI2                                                                    0x2c17
#define mmGUS_IO_RD_PRI_QUANT1_PRI2_BASE_IDX                                                           1
#define mmGUS_IO_RD_PRI_QUANT1_PRI3                                                                    0x2c18
#define mmGUS_IO_RD_PRI_QUANT1_PRI3_BASE_IDX                                                           1
#define mmGUS_IO_RD_PRI_QUANT1_PRI4                                                                    0x2c19
#define mmGUS_IO_RD_PRI_QUANT1_PRI4_BASE_IDX                                                           1
#define mmGUS_IO_WR_PRI_QUANT1_PRI1                                                                    0x2c1a
#define mmGUS_IO_WR_PRI_QUANT1_PRI1_BASE_IDX                                                           1
#define mmGUS_IO_WR_PRI_QUANT1_PRI2                                                                    0x2c1b
#define mmGUS_IO_WR_PRI_QUANT1_PRI2_BASE_IDX                                                           1
#define mmGUS_IO_WR_PRI_QUANT1_PRI3                                                                    0x2c1c
#define mmGUS_IO_WR_PRI_QUANT1_PRI3_BASE_IDX                                                           1
#define mmGUS_IO_WR_PRI_QUANT1_PRI4                                                                    0x2c1d
#define mmGUS_IO_WR_PRI_QUANT1_PRI4_BASE_IDX                                                           1
#define mmGUS_DRAM_COMBINE_FLUSH                                                                       0x2c1e
#define mmGUS_DRAM_COMBINE_FLUSH_BASE_IDX                                                              1
#define mmGUS_DRAM_COMBINE_RD_WR_EN                                                                    0x2c1f
#define mmGUS_DRAM_COMBINE_RD_WR_EN_BASE_IDX                                                           1
#define mmGUS_DRAM_PRI_AGE_RATE                                                                        0x2c20
#define mmGUS_DRAM_PRI_AGE_RATE_BASE_IDX                                                               1
#define mmGUS_DRAM_PRI_AGE_COEFF                                                                       0x2c21
#define mmGUS_DRAM_PRI_AGE_COEFF_BASE_IDX                                                              1
#define mmGUS_DRAM_PRI_QUEUING                                                                         0x2c22
#define mmGUS_DRAM_PRI_QUEUING_BASE_IDX                                                                1
#define mmGUS_DRAM_PRI_FIXED                                                                           0x2c23
#define mmGUS_DRAM_PRI_FIXED_BASE_IDX                                                                  1
#define mmGUS_DRAM_PRI_URGENCY_COEFF                                                                   0x2c24
#define mmGUS_DRAM_PRI_URGENCY_COEFF_BASE_IDX                                                          1
#define mmGUS_DRAM_PRI_URGENCY_MODE                                                                    0x2c25
#define mmGUS_DRAM_PRI_URGENCY_MODE_BASE_IDX                                                           1
#define mmGUS_DRAM_PRI_QUANT_PRI1                                                                      0x2c26
#define mmGUS_DRAM_PRI_QUANT_PRI1_BASE_IDX                                                             1
#define mmGUS_DRAM_PRI_QUANT_PRI2                                                                      0x2c27
#define mmGUS_DRAM_PRI_QUANT_PRI2_BASE_IDX                                                             1
#define mmGUS_DRAM_PRI_QUANT_PRI3                                                                      0x2c28
#define mmGUS_DRAM_PRI_QUANT_PRI3_BASE_IDX                                                             1
#define mmGUS_DRAM_PRI_QUANT_PRI4                                                                      0x2c29
#define mmGUS_DRAM_PRI_QUANT_PRI4_BASE_IDX                                                             1
#define mmGUS_DRAM_PRI_QUANT_PRI5                                                                      0x2c2a
#define mmGUS_DRAM_PRI_QUANT_PRI5_BASE_IDX                                                             1
#define mmGUS_DRAM_PRI_QUANT1_PRI1                                                                     0x2c2b
#define mmGUS_DRAM_PRI_QUANT1_PRI1_BASE_IDX                                                            1
#define mmGUS_DRAM_PRI_QUANT1_PRI2                                                                     0x2c2c
#define mmGUS_DRAM_PRI_QUANT1_PRI2_BASE_IDX                                                            1
#define mmGUS_DRAM_PRI_QUANT1_PRI3                                                                     0x2c2d
#define mmGUS_DRAM_PRI_QUANT1_PRI3_BASE_IDX                                                            1
#define mmGUS_DRAM_PRI_QUANT1_PRI4                                                                     0x2c2e
#define mmGUS_DRAM_PRI_QUANT1_PRI4_BASE_IDX                                                            1
#define mmGUS_DRAM_PRI_QUANT1_PRI5                                                                     0x2c2f
#define mmGUS_DRAM_PRI_QUANT1_PRI5_BASE_IDX                                                            1
#define mmGUS_IO_GROUP_BURST                                                                           0x2c30
#define mmGUS_IO_GROUP_BURST_BASE_IDX                                                                  1
#define mmGUS_DRAM_GROUP_BURST                                                                         0x2c31
#define mmGUS_DRAM_GROUP_BURST_BASE_IDX                                                                1
#define mmGUS_SDP_ARB_FINAL                                                                            0x2c32
#define mmGUS_SDP_ARB_FINAL_BASE_IDX                                                                   1
#define mmGUS_SDP_QOS_VC_PRIORITY                                                                      0x2c33
#define mmGUS_SDP_QOS_VC_PRIORITY_BASE_IDX                                                             1
#define mmGUS_SDP_CREDITS                                                                              0x2c34
#define mmGUS_SDP_CREDITS_BASE_IDX                                                                     1
#define mmGUS_SDP_TAG_RESERVE0                                                                         0x2c35
#define mmGUS_SDP_TAG_RESERVE0_BASE_IDX                                                                1
#define mmGUS_SDP_TAG_RESERVE1                                                                         0x2c36
#define mmGUS_SDP_TAG_RESERVE1_BASE_IDX                                                                1
#define mmGUS_SDP_VCC_RESERVE0                                                                         0x2c37
#define mmGUS_SDP_VCC_RESERVE0_BASE_IDX                                                                1
#define mmGUS_SDP_VCC_RESERVE1                                                                         0x2c38
#define mmGUS_SDP_VCC_RESERVE1_BASE_IDX                                                                1
#define mmGUS_SDP_VCD_RESERVE0                                                                         0x2c39
#define mmGUS_SDP_VCD_RESERVE0_BASE_IDX                                                                1
#define mmGUS_SDP_VCD_RESERVE1                                                                         0x2c3a
#define mmGUS_SDP_VCD_RESERVE1_BASE_IDX                                                                1
#define mmGUS_SDP_REQ_CNTL                                                                             0x2c3b
#define mmGUS_SDP_REQ_CNTL_BASE_IDX                                                                    1
#define mmGUS_MISC                                                                                     0x2c3c
#define mmGUS_MISC_BASE_IDX                                                                            1
#define mmGUS_LATENCY_SAMPLING                                                                         0x2c3d
#define mmGUS_LATENCY_SAMPLING_BASE_IDX                                                                1
#define mmGUS_ERR_STATUS                                                                               0x2c3e
#define mmGUS_ERR_STATUS_BASE_IDX                                                                      1
#define mmGUS_MISC2                                                                                    0x2c3f
#define mmGUS_MISC2_BASE_IDX                                                                           1
#define mmGUS_SDP_ENABLE                                                                               0x2c45
#define mmGUS_SDP_ENABLE_BASE_IDX                                                                      1
#define mmGUS_L1_CH0_CMD_IN                                                                            0x2c46
#define mmGUS_L1_CH0_CMD_IN_BASE_IDX                                                                   1
#define mmGUS_L1_CH0_CMD_OUT                                                                           0x2c47
#define mmGUS_L1_CH0_CMD_OUT_BASE_IDX                                                                  1
#define mmGUS_L1_CH0_DATA_IN                                                                           0x2c48
#define mmGUS_L1_CH0_DATA_IN_BASE_IDX                                                                  1
#define mmGUS_L1_CH0_DATA_OUT                                                                          0x2c49
#define mmGUS_L1_CH0_DATA_OUT_BASE_IDX                                                                 1
#define mmGUS_L1_CH0_DATA_U_IN                                                                         0x2c4a
#define mmGUS_L1_CH0_DATA_U_IN_BASE_IDX                                                                1
#define mmGUS_L1_CH0_DATA_U_OUT                                                                        0x2c4b
#define mmGUS_L1_CH0_DATA_U_OUT_BASE_IDX                                                               1
#define mmGUS_L1_CH1_CMD_IN                                                                            0x2c4c
#define mmGUS_L1_CH1_CMD_IN_BASE_IDX                                                                   1
#define mmGUS_L1_CH1_CMD_OUT                                                                           0x2c4d
#define mmGUS_L1_CH1_CMD_OUT_BASE_IDX                                                                  1
#define mmGUS_L1_CH1_DATA_IN                                                                           0x2c4e
#define mmGUS_L1_CH1_DATA_IN_BASE_IDX                                                                  1
#define mmGUS_L1_CH1_DATA_OUT                                                                          0x2c4f
#define mmGUS_L1_CH1_DATA_OUT_BASE_IDX                                                                 1
#define mmGUS_L1_CH1_DATA_U_IN                                                                         0x2c50
#define mmGUS_L1_CH1_DATA_U_IN_BASE_IDX                                                                1
#define mmGUS_L1_CH1_DATA_U_OUT                                                                        0x2c51
#define mmGUS_L1_CH1_DATA_U_OUT_BASE_IDX                                                               1
#define mmGUS_L1_SA0_CMD_IN                                                                            0x2c52
#define mmGUS_L1_SA0_CMD_IN_BASE_IDX                                                                   1
#define mmGUS_L1_SA0_CMD_OUT                                                                           0x2c53
#define mmGUS_L1_SA0_CMD_OUT_BASE_IDX                                                                  1
#define mmGUS_L1_SA0_DATA_IN                                                                           0x2c54
#define mmGUS_L1_SA0_DATA_IN_BASE_IDX                                                                  1
#define mmGUS_L1_SA0_DATA_OUT                                                                          0x2c55
#define mmGUS_L1_SA0_DATA_OUT_BASE_IDX                                                                 1
#define mmGUS_L1_SA0_DATA_U_IN                                                                         0x2c56
#define mmGUS_L1_SA0_DATA_U_IN_BASE_IDX                                                                1
#define mmGUS_L1_SA0_DATA_U_OUT                                                                        0x2c57
#define mmGUS_L1_SA0_DATA_U_OUT_BASE_IDX                                                               1
#define mmGUS_L1_SA1_CMD_IN                                                                            0x2c58
#define mmGUS_L1_SA1_CMD_IN_BASE_IDX                                                                   1
#define mmGUS_L1_SA1_CMD_OUT                                                                           0x2c59
#define mmGUS_L1_SA1_CMD_OUT_BASE_IDX                                                                  1
#define mmGUS_L1_SA1_DATA_IN                                                                           0x2c5a
#define mmGUS_L1_SA1_DATA_IN_BASE_IDX                                                                  1
#define mmGUS_L1_SA1_DATA_OUT                                                                          0x2c5b
#define mmGUS_L1_SA1_DATA_OUT_BASE_IDX                                                                 1
#define mmGUS_L1_SA1_DATA_U_IN                                                                         0x2c5c
#define mmGUS_L1_SA1_DATA_U_IN_BASE_IDX                                                                1
#define mmGUS_L1_SA1_DATA_U_OUT                                                                        0x2c5d
#define mmGUS_L1_SA1_DATA_U_OUT_BASE_IDX                                                               1
#define mmGUS_L1_SA2_CMD_IN                                                                            0x2c5e
#define mmGUS_L1_SA2_CMD_IN_BASE_IDX                                                                   1
#define mmGUS_L1_SA2_CMD_OUT                                                                           0x2c5f
#define mmGUS_L1_SA2_CMD_OUT_BASE_IDX                                                                  1
#define mmGUS_L1_SA2_DATA_IN                                                                           0x2c60
#define mmGUS_L1_SA2_DATA_IN_BASE_IDX                                                                  1
#define mmGUS_L1_SA2_DATA_OUT                                                                          0x2c61
#define mmGUS_L1_SA2_DATA_OUT_BASE_IDX                                                                 1
#define mmGUS_L1_SA2_DATA_U_IN                                                                         0x2c62
#define mmGUS_L1_SA2_DATA_U_IN_BASE_IDX                                                                1
#define mmGUS_L1_SA2_DATA_U_OUT                                                                        0x2c63
#define mmGUS_L1_SA2_DATA_U_OUT_BASE_IDX                                                               1
#define mmGUS_L1_SA3_CMD_IN                                                                            0x2c64
#define mmGUS_L1_SA3_CMD_IN_BASE_IDX                                                                   1
#define mmGUS_L1_SA3_CMD_OUT                                                                           0x2c65
#define mmGUS_L1_SA3_CMD_OUT_BASE_IDX                                                                  1
#define mmGUS_L1_SA3_DATA_IN                                                                           0x2c66
#define mmGUS_L1_SA3_DATA_IN_BASE_IDX                                                                  1
#define mmGUS_L1_SA3_DATA_OUT                                                                          0x2c67
#define mmGUS_L1_SA3_DATA_OUT_BASE_IDX                                                                 1
#define mmGUS_L1_SA3_DATA_U_IN                                                                         0x2c68
#define mmGUS_L1_SA3_DATA_U_IN_BASE_IDX                                                                1
#define mmGUS_L1_SA3_DATA_U_OUT                                                                        0x2c69
#define mmGUS_L1_SA3_DATA_U_OUT_BASE_IDX                                                               1
#define mmGUS_MISC3                                                                                    0x2c6a
#define mmGUS_MISC3_BASE_IDX                                                                           1
#define mmGUS_WRRSP_FIFO_CNTL                                                                          0x2c6b
#define mmGUS_WRRSP_FIFO_CNTL_BASE_IDX                                                                 1


// addressBlock: gc_gl1dec
// base address: 0x33400
#define mmGL1_DRAM_BURST_MASK                                                                          0x2d02
#define mmGL1_DRAM_BURST_MASK_BASE_IDX                                                                 1
#define mmGL1_ARB_STATUS                                                                               0x2d03
#define mmGL1_ARB_STATUS_BASE_IDX                                                                      1
#define mmGL1_PIPE_STEER                                                                               0x2d10
#define mmGL1_PIPE_STEER_BASE_IDX                                                                      1
#define mmGL1C_STATUS                                                                                  0x2d41
#define mmGL1C_STATUS_BASE_IDX                                                                         1
#define mmGL1C_UTCL0_CNTL2                                                                             0x2d43
#define mmGL1C_UTCL0_CNTL2_BASE_IDX                                                                    1
#define mmGL1C_UTCL0_STATUS                                                                            0x2d44
#define mmGL1C_UTCL0_STATUS_BASE_IDX                                                                   1
#define mmGL1C_UTCL0_RETRY                                                                             0x2d45
#define mmGL1C_UTCL0_RETRY_BASE_IDX                                                                    1


// addressBlock: gc_chdec
// base address: 0x33600
#define mmCH_ARB_CTRL                                                                                  0x2d80
#define mmCH_ARB_CTRL_BASE_IDX                                                                         1
#define mmCH_DRAM_BURST_MASK                                                                           0x2d82
#define mmCH_DRAM_BURST_MASK_BASE_IDX                                                                  1
#define mmCH_ARB_STATUS                                                                                0x2d83
#define mmCH_ARB_STATUS_BASE_IDX                                                                       1
#define mmCH_DRAM_BURST_CTRL                                                                           0x2d84
#define mmCH_DRAM_BURST_CTRL_BASE_IDX                                                                  1
#define mmCHA_CHC_CREDITS                                                                              0x2d88
#define mmCHA_CHC_CREDITS_BASE_IDX                                                                     1
#define mmCHA_CLIENT_FREE_DELAY                                                                        0x2d89
#define mmCHA_CLIENT_FREE_DELAY_BASE_IDX                                                               1
#define mmCH_PIPE_STEER                                                                                0x2d90
#define mmCH_PIPE_STEER_BASE_IDX                                                                       1
#define mmCH_VC5_ENABLE                                                                                0x2d94
#define mmCH_VC5_ENABLE_BASE_IDX                                                                       1
#define mmCHC_CTRL                                                                                     0x2dc0
#define mmCHC_CTRL_BASE_IDX                                                                            1
#define mmCHC_STATUS                                                                                   0x2dc1
#define mmCHC_STATUS_BASE_IDX                                                                          1
#define mmCHCG_CTRL                                                                                    0x2dc2
#define mmCHCG_CTRL_BASE_IDX                                                                           1
#define mmCHCG_STATUS                                                                                  0x2dc3
#define mmCHCG_STATUS_BASE_IDX                                                                         1


// addressBlock: gc_gl2dec
// base address: 0x33800
#define mmGL2C_CTRL                                                                                    0x2e00
#define mmGL2C_CTRL_BASE_IDX                                                                           1
#define mmGL2C_CTRL2                                                                                   0x2e01
#define mmGL2C_CTRL2_BASE_IDX                                                                          1
#define mmGL2C_ADDR_MATCH_MASK                                                                         0x2e03
#define mmGL2C_ADDR_MATCH_MASK_BASE_IDX                                                                1
#define mmGL2C_ADDR_MATCH_SIZE                                                                         0x2e04
#define mmGL2C_ADDR_MATCH_SIZE_BASE_IDX                                                                1
#define mmGL2C_WBINVL2                                                                                 0x2e05
#define mmGL2C_WBINVL2_BASE_IDX                                                                        1
#define mmGL2C_SOFT_RESET                                                                              0x2e06
#define mmGL2C_SOFT_RESET_BASE_IDX                                                                     1
#define mmGL2C_CM_CTRL0                                                                                0x2e07
#define mmGL2C_CM_CTRL0_BASE_IDX                                                                       1
#define mmGL2C_CM_CTRL1                                                                                0x2e08
#define mmGL2C_CM_CTRL1_BASE_IDX                                                                       1
#define mmGL2C_CM_STALL                                                                                0x2e09
#define mmGL2C_CM_STALL_BASE_IDX                                                                       1
#define mmGL2C_MDC_PF_FLAG_CTRL                                                                        0x2e0a
#define mmGL2C_MDC_PF_FLAG_CTRL_BASE_IDX                                                               1
#define mmGL2C_LB_CTR_CTRL                                                                             0x2e0d
#define mmGL2C_LB_CTR_CTRL_BASE_IDX                                                                    1
#define mmGL2C_LB_DATA0                                                                                0x2e0e
#define mmGL2C_LB_DATA0_BASE_IDX                                                                       1
#define mmGL2C_LB_DATA1                                                                                0x2e0f
#define mmGL2C_LB_DATA1_BASE_IDX                                                                       1
#define mmGL2C_LB_DATA2                                                                                0x2e10
#define mmGL2C_LB_DATA2_BASE_IDX                                                                       1
#define mmGL2C_LB_DATA3                                                                                0x2e11
#define mmGL2C_LB_DATA3_BASE_IDX                                                                       1
#define mmGL2C_LB_CTR_SEL0                                                                             0x2e12
#define mmGL2C_LB_CTR_SEL0_BASE_IDX                                                                    1
#define mmGL2C_LB_CTR_SEL1                                                                             0x2e13
#define mmGL2C_LB_CTR_SEL1_BASE_IDX                                                                    1
#define mmGL2A_ADDR_MATCH_CTRL                                                                         0x2e20
#define mmGL2A_ADDR_MATCH_CTRL_BASE_IDX                                                                1
#define mmGL2A_ADDR_MATCH_MASK                                                                         0x2e21
#define mmGL2A_ADDR_MATCH_MASK_BASE_IDX                                                                1
#define mmGL2A_ADDR_MATCH_SIZE                                                                         0x2e22
#define mmGL2A_ADDR_MATCH_SIZE_BASE_IDX                                                                1
#define mmGL2A_PRIORITY_CTRL                                                                           0x2e23
#define mmGL2A_PRIORITY_CTRL_BASE_IDX                                                                  1
#define mmGL2_PIPE_STEER_0                                                                             0x2e25
#define mmGL2_PIPE_STEER_0_BASE_IDX                                                                    1
#define mmGL2_PIPE_STEER_1                                                                             0x2e26
#define mmGL2_PIPE_STEER_1_BASE_IDX                                                                    1


// addressBlock: gc_perfddec
// base address: 0x34000
#define mmCPG_PERFCOUNTER1_LO                                                                          0x3000
#define mmCPG_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define mmCPG_PERFCOUNTER1_HI                                                                          0x3001
#define mmCPG_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define mmCPG_PERFCOUNTER0_LO                                                                          0x3002
#define mmCPG_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define mmCPG_PERFCOUNTER0_HI                                                                          0x3003
#define mmCPG_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define mmCPC_PERFCOUNTER1_LO                                                                          0x3004
#define mmCPC_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define mmCPC_PERFCOUNTER1_HI                                                                          0x3005
#define mmCPC_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define mmCPC_PERFCOUNTER0_LO                                                                          0x3006
#define mmCPC_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define mmCPC_PERFCOUNTER0_HI                                                                          0x3007
#define mmCPC_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define mmCPF_PERFCOUNTER1_LO                                                                          0x3008
#define mmCPF_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define mmCPF_PERFCOUNTER1_HI                                                                          0x3009
#define mmCPF_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define mmCPF_PERFCOUNTER0_LO                                                                          0x300a
#define mmCPF_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define mmCPF_PERFCOUNTER0_HI                                                                          0x300b
#define mmCPF_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define mmCPF_LATENCY_STATS_DATA                                                                       0x300c
#define mmCPF_LATENCY_STATS_DATA_BASE_IDX                                                              1
#define mmCPG_LATENCY_STATS_DATA                                                                       0x300d
#define mmCPG_LATENCY_STATS_DATA_BASE_IDX                                                              1
#define mmCPC_LATENCY_STATS_DATA                                                                       0x300e
#define mmCPC_LATENCY_STATS_DATA_BASE_IDX                                                              1
#define mmGRBM_PERFCOUNTER0_LO                                                                         0x3040
#define mmGRBM_PERFCOUNTER0_LO_BASE_IDX                                                                1
#define mmGRBM_PERFCOUNTER0_HI                                                                         0x3041
#define mmGRBM_PERFCOUNTER0_HI_BASE_IDX                                                                1
#define mmGRBM_PERFCOUNTER1_LO                                                                         0x3043
#define mmGRBM_PERFCOUNTER1_LO_BASE_IDX                                                                1
#define mmGRBM_PERFCOUNTER1_HI                                                                         0x3044
#define mmGRBM_PERFCOUNTER1_HI_BASE_IDX                                                                1
#define mmGRBM_SE0_PERFCOUNTER_LO                                                                      0x3045
#define mmGRBM_SE0_PERFCOUNTER_LO_BASE_IDX                                                             1
#define mmGRBM_SE0_PERFCOUNTER_HI                                                                      0x3046
#define mmGRBM_SE0_PERFCOUNTER_HI_BASE_IDX                                                             1
#define mmGRBM_SE1_PERFCOUNTER_LO                                                                      0x3047
#define mmGRBM_SE1_PERFCOUNTER_LO_BASE_IDX                                                             1
#define mmGRBM_SE1_PERFCOUNTER_HI                                                                      0x3048
#define mmGRBM_SE1_PERFCOUNTER_HI_BASE_IDX                                                             1
#define mmGRBM_SE2_PERFCOUNTER_LO                                                                      0x3049
#define mmGRBM_SE2_PERFCOUNTER_LO_BASE_IDX                                                             1
#define mmGRBM_SE2_PERFCOUNTER_HI                                                                      0x304a
#define mmGRBM_SE2_PERFCOUNTER_HI_BASE_IDX                                                             1
#define mmGRBM_SE3_PERFCOUNTER_LO                                                                      0x304b
#define mmGRBM_SE3_PERFCOUNTER_LO_BASE_IDX                                                             1
#define mmGRBM_SE3_PERFCOUNTER_HI                                                                      0x304c
#define mmGRBM_SE3_PERFCOUNTER_HI_BASE_IDX                                                             1
#define mmGE1_PERFCOUNTER0_LO                                                                          0x30a4
#define mmGE1_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define mmGE1_PERFCOUNTER0_HI                                                                          0x30a5
#define mmGE1_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define mmGE1_PERFCOUNTER1_LO                                                                          0x30a6
#define mmGE1_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define mmGE1_PERFCOUNTER1_HI                                                                          0x30a7
#define mmGE1_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define mmGE1_PERFCOUNTER2_LO                                                                          0x30a8
#define mmGE1_PERFCOUNTER2_LO_BASE_IDX                                                                 1
#define mmGE1_PERFCOUNTER2_HI                                                                          0x30a9
#define mmGE1_PERFCOUNTER2_HI_BASE_IDX                                                                 1
#define mmGE1_PERFCOUNTER3_LO                                                                          0x30aa
#define mmGE1_PERFCOUNTER3_LO_BASE_IDX                                                                 1
#define mmGE1_PERFCOUNTER3_HI                                                                          0x30ab
#define mmGE1_PERFCOUNTER3_HI_BASE_IDX                                                                 1
#define mmGE2_DIST_PERFCOUNTER0_LO                                                                     0x30ac
#define mmGE2_DIST_PERFCOUNTER0_LO_BASE_IDX                                                            1
#define mmGE2_DIST_PERFCOUNTER0_HI                                                                     0x30ad
#define mmGE2_DIST_PERFCOUNTER0_HI_BASE_IDX                                                            1
#define mmGE2_DIST_PERFCOUNTER1_LO                                                                     0x30ae
#define mmGE2_DIST_PERFCOUNTER1_LO_BASE_IDX                                                            1
#define mmGE2_DIST_PERFCOUNTER1_HI                                                                     0x30af
#define mmGE2_DIST_PERFCOUNTER1_HI_BASE_IDX                                                            1
#define mmGE2_DIST_PERFCOUNTER2_LO                                                                     0x30b0
#define mmGE2_DIST_PERFCOUNTER2_LO_BASE_IDX                                                            1
#define mmGE2_DIST_PERFCOUNTER2_HI                                                                     0x30b1
#define mmGE2_DIST_PERFCOUNTER2_HI_BASE_IDX                                                            1
#define mmGE2_DIST_PERFCOUNTER3_LO                                                                     0x30b2
#define mmGE2_DIST_PERFCOUNTER3_LO_BASE_IDX                                                            1
#define mmGE2_DIST_PERFCOUNTER3_HI                                                                     0x30b3
#define mmGE2_DIST_PERFCOUNTER3_HI_BASE_IDX                                                            1
#define mmGE2_SE_PERFCOUNTER0_LO                                                                       0x30b4
#define mmGE2_SE_PERFCOUNTER0_LO_BASE_IDX                                                              1
#define mmGE2_SE_PERFCOUNTER0_HI                                                                       0x30b5
#define mmGE2_SE_PERFCOUNTER0_HI_BASE_IDX                                                              1
#define mmGE2_SE_PERFCOUNTER1_LO                                                                       0x30b6
#define mmGE2_SE_PERFCOUNTER1_LO_BASE_IDX                                                              1
#define mmGE2_SE_PERFCOUNTER1_HI                                                                       0x30b7
#define mmGE2_SE_PERFCOUNTER1_HI_BASE_IDX                                                              1
#define mmGE2_SE_PERFCOUNTER2_LO                                                                       0x30b8
#define mmGE2_SE_PERFCOUNTER2_LO_BASE_IDX                                                              1
#define mmGE2_SE_PERFCOUNTER2_HI                                                                       0x30b9
#define mmGE2_SE_PERFCOUNTER2_HI_BASE_IDX                                                              1
#define mmGE2_SE_PERFCOUNTER3_LO                                                                       0x30ba
#define mmGE2_SE_PERFCOUNTER3_LO_BASE_IDX                                                              1
#define mmGE2_SE_PERFCOUNTER3_HI                                                                       0x30bb
#define mmGE2_SE_PERFCOUNTER3_HI_BASE_IDX                                                              1
#define mmPA_SU_PERFCOUNTER0_LO                                                                        0x3100
#define mmPA_SU_PERFCOUNTER0_LO_BASE_IDX                                                               1
#define mmPA_SU_PERFCOUNTER0_HI                                                                        0x3101
#define mmPA_SU_PERFCOUNTER0_HI_BASE_IDX                                                               1
#define mmPA_SU_PERFCOUNTER1_LO                                                                        0x3102
#define mmPA_SU_PERFCOUNTER1_LO_BASE_IDX                                                               1
#define mmPA_SU_PERFCOUNTER1_HI                                                                        0x3103
#define mmPA_SU_PERFCOUNTER1_HI_BASE_IDX                                                               1
#define mmPA_SU_PERFCOUNTER2_LO                                                                        0x3104
#define mmPA_SU_PERFCOUNTER2_LO_BASE_IDX                                                               1
#define mmPA_SU_PERFCOUNTER2_HI                                                                        0x3105
#define mmPA_SU_PERFCOUNTER2_HI_BASE_IDX                                                               1
#define mmPA_SU_PERFCOUNTER3_LO                                                                        0x3106
#define mmPA_SU_PERFCOUNTER3_LO_BASE_IDX                                                               1
#define mmPA_SU_PERFCOUNTER3_HI                                                                        0x3107
#define mmPA_SU_PERFCOUNTER3_HI_BASE_IDX                                                               1
#define mmPA_SC_PERFCOUNTER0_LO                                                                        0x3140
#define mmPA_SC_PERFCOUNTER0_LO_BASE_IDX                                                               1
#define mmPA_SC_PERFCOUNTER0_HI                                                                        0x3141
#define mmPA_SC_PERFCOUNTER0_HI_BASE_IDX                                                               1
#define mmPA_SC_PERFCOUNTER1_LO                                                                        0x3142
#define mmPA_SC_PERFCOUNTER1_LO_BASE_IDX                                                               1
#define mmPA_SC_PERFCOUNTER1_HI                                                                        0x3143
#define mmPA_SC_PERFCOUNTER1_HI_BASE_IDX                                                               1
#define mmPA_SC_PERFCOUNTER2_LO                                                                        0x3144
#define mmPA_SC_PERFCOUNTER2_LO_BASE_IDX                                                               1
#define mmPA_SC_PERFCOUNTER2_HI                                                                        0x3145
#define mmPA_SC_PERFCOUNTER2_HI_BASE_IDX                                                               1
#define mmPA_SC_PERFCOUNTER3_LO                                                                        0x3146
#define mmPA_SC_PERFCOUNTER3_LO_BASE_IDX                                                               1
#define mmPA_SC_PERFCOUNTER3_HI                                                                        0x3147
#define mmPA_SC_PERFCOUNTER3_HI_BASE_IDX                                                               1
#define mmPA_SC_PERFCOUNTER4_LO                                                                        0x3148
#define mmPA_SC_PERFCOUNTER4_LO_BASE_IDX                                                               1
#define mmPA_SC_PERFCOUNTER4_HI                                                                        0x3149
#define mmPA_SC_PERFCOUNTER4_HI_BASE_IDX                                                               1
#define mmPA_SC_PERFCOUNTER5_LO                                                                        0x314a
#define mmPA_SC_PERFCOUNTER5_LO_BASE_IDX                                                               1
#define mmPA_SC_PERFCOUNTER5_HI                                                                        0x314b
#define mmPA_SC_PERFCOUNTER5_HI_BASE_IDX                                                               1
#define mmPA_SC_PERFCOUNTER6_LO                                                                        0x314c
#define mmPA_SC_PERFCOUNTER6_LO_BASE_IDX                                                               1
#define mmPA_SC_PERFCOUNTER6_HI                                                                        0x314d
#define mmPA_SC_PERFCOUNTER6_HI_BASE_IDX                                                               1
#define mmPA_SC_PERFCOUNTER7_LO                                                                        0x314e
#define mmPA_SC_PERFCOUNTER7_LO_BASE_IDX                                                               1
#define mmPA_SC_PERFCOUNTER7_HI                                                                        0x314f
#define mmPA_SC_PERFCOUNTER7_HI_BASE_IDX                                                               1
#define mmSPI_PERFCOUNTER0_HI                                                                          0x3180
#define mmSPI_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define mmSPI_PERFCOUNTER0_LO                                                                          0x3181
#define mmSPI_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define mmSPI_PERFCOUNTER1_HI                                                                          0x3182
#define mmSPI_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define mmSPI_PERFCOUNTER1_LO                                                                          0x3183
#define mmSPI_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define mmSPI_PERFCOUNTER2_HI                                                                          0x3184
#define mmSPI_PERFCOUNTER2_HI_BASE_IDX                                                                 1
#define mmSPI_PERFCOUNTER2_LO                                                                          0x3185
#define mmSPI_PERFCOUNTER2_LO_BASE_IDX                                                                 1
#define mmSPI_PERFCOUNTER3_HI                                                                          0x3186
#define mmSPI_PERFCOUNTER3_HI_BASE_IDX                                                                 1
#define mmSPI_PERFCOUNTER3_LO                                                                          0x3187
#define mmSPI_PERFCOUNTER3_LO_BASE_IDX                                                                 1
#define mmSPI_PERFCOUNTER4_HI                                                                          0x3188
#define mmSPI_PERFCOUNTER4_HI_BASE_IDX                                                                 1
#define mmSPI_PERFCOUNTER4_LO                                                                          0x3189
#define mmSPI_PERFCOUNTER4_LO_BASE_IDX                                                                 1
#define mmSPI_PERFCOUNTER5_HI                                                                          0x318a
#define mmSPI_PERFCOUNTER5_HI_BASE_IDX                                                                 1
#define mmSPI_PERFCOUNTER5_LO                                                                          0x318b
#define mmSPI_PERFCOUNTER5_LO_BASE_IDX                                                                 1
#define mmSQ_PERFCOUNTER0_LO                                                                           0x31c0
#define mmSQ_PERFCOUNTER0_LO_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER0_HI                                                                           0x31c1
#define mmSQ_PERFCOUNTER0_HI_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER1_LO                                                                           0x31c2
#define mmSQ_PERFCOUNTER1_LO_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER1_HI                                                                           0x31c3
#define mmSQ_PERFCOUNTER1_HI_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER2_LO                                                                           0x31c4
#define mmSQ_PERFCOUNTER2_LO_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER2_HI                                                                           0x31c5
#define mmSQ_PERFCOUNTER2_HI_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER3_LO                                                                           0x31c6
#define mmSQ_PERFCOUNTER3_LO_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER3_HI                                                                           0x31c7
#define mmSQ_PERFCOUNTER3_HI_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER4_LO                                                                           0x31c8
#define mmSQ_PERFCOUNTER4_LO_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER4_HI                                                                           0x31c9
#define mmSQ_PERFCOUNTER4_HI_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER5_LO                                                                           0x31ca
#define mmSQ_PERFCOUNTER5_LO_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER5_HI                                                                           0x31cb
#define mmSQ_PERFCOUNTER5_HI_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER6_LO                                                                           0x31cc
#define mmSQ_PERFCOUNTER6_LO_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER6_HI                                                                           0x31cd
#define mmSQ_PERFCOUNTER6_HI_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER7_LO                                                                           0x31ce
#define mmSQ_PERFCOUNTER7_LO_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER7_HI                                                                           0x31cf
#define mmSQ_PERFCOUNTER7_HI_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER8_LO                                                                           0x31d0
#define mmSQ_PERFCOUNTER8_LO_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER8_HI                                                                           0x31d1
#define mmSQ_PERFCOUNTER8_HI_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER9_LO                                                                           0x31d2
#define mmSQ_PERFCOUNTER9_LO_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER9_HI                                                                           0x31d3
#define mmSQ_PERFCOUNTER9_HI_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER10_LO                                                                          0x31d4
#define mmSQ_PERFCOUNTER10_LO_BASE_IDX                                                                 1
#define mmSQ_PERFCOUNTER10_HI                                                                          0x31d5
#define mmSQ_PERFCOUNTER10_HI_BASE_IDX                                                                 1
#define mmSQ_PERFCOUNTER11_LO                                                                          0x31d6
#define mmSQ_PERFCOUNTER11_LO_BASE_IDX                                                                 1
#define mmSQ_PERFCOUNTER11_HI                                                                          0x31d7
#define mmSQ_PERFCOUNTER11_HI_BASE_IDX                                                                 1
#define mmSQ_PERFCOUNTER12_LO                                                                          0x31d8
#define mmSQ_PERFCOUNTER12_LO_BASE_IDX                                                                 1
#define mmSQ_PERFCOUNTER12_HI                                                                          0x31d9
#define mmSQ_PERFCOUNTER12_HI_BASE_IDX                                                                 1
#define mmSQ_PERFCOUNTER13_LO                                                                          0x31da
#define mmSQ_PERFCOUNTER13_LO_BASE_IDX                                                                 1
#define mmSQ_PERFCOUNTER13_HI                                                                          0x31db
#define mmSQ_PERFCOUNTER13_HI_BASE_IDX                                                                 1
#define mmSQ_PERFCOUNTER14_LO                                                                          0x31dc
#define mmSQ_PERFCOUNTER14_LO_BASE_IDX                                                                 1
#define mmSQ_PERFCOUNTER14_HI                                                                          0x31dd
#define mmSQ_PERFCOUNTER14_HI_BASE_IDX                                                                 1
#define mmSQ_PERFCOUNTER15_LO                                                                          0x31de
#define mmSQ_PERFCOUNTER15_LO_BASE_IDX                                                                 1
#define mmSQ_PERFCOUNTER15_HI                                                                          0x31df
#define mmSQ_PERFCOUNTER15_HI_BASE_IDX                                                                 1
#define mmSX_PERFCOUNTER0_LO                                                                           0x3240
#define mmSX_PERFCOUNTER0_LO_BASE_IDX                                                                  1
#define mmSX_PERFCOUNTER0_HI                                                                           0x3241
#define mmSX_PERFCOUNTER0_HI_BASE_IDX                                                                  1
#define mmSX_PERFCOUNTER1_LO                                                                           0x3242
#define mmSX_PERFCOUNTER1_LO_BASE_IDX                                                                  1
#define mmSX_PERFCOUNTER1_HI                                                                           0x3243
#define mmSX_PERFCOUNTER1_HI_BASE_IDX                                                                  1
#define mmSX_PERFCOUNTER2_LO                                                                           0x3244
#define mmSX_PERFCOUNTER2_LO_BASE_IDX                                                                  1
#define mmSX_PERFCOUNTER2_HI                                                                           0x3245
#define mmSX_PERFCOUNTER2_HI_BASE_IDX                                                                  1
#define mmSX_PERFCOUNTER3_LO                                                                           0x3246
#define mmSX_PERFCOUNTER3_LO_BASE_IDX                                                                  1
#define mmSX_PERFCOUNTER3_HI                                                                           0x3247
#define mmSX_PERFCOUNTER3_HI_BASE_IDX                                                                  1
#define mmGCEA_PERFCOUNTER2_LO                                                                         0x3260
#define mmGCEA_PERFCOUNTER2_LO_BASE_IDX                                                                1
#define mmGCEA_PERFCOUNTER2_HI                                                                         0x3261
#define mmGCEA_PERFCOUNTER2_HI_BASE_IDX                                                                1
#define mmGCEA_PERFCOUNTER_LO                                                                          0x3262
#define mmGCEA_PERFCOUNTER_LO_BASE_IDX                                                                 1
#define mmGCEA_PERFCOUNTER_HI                                                                          0x3263
#define mmGCEA_PERFCOUNTER_HI_BASE_IDX                                                                 1
#define mmGDS_PERFCOUNTER0_LO                                                                          0x3280
#define mmGDS_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define mmGDS_PERFCOUNTER0_HI                                                                          0x3281
#define mmGDS_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define mmGDS_PERFCOUNTER1_LO                                                                          0x3282
#define mmGDS_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define mmGDS_PERFCOUNTER1_HI                                                                          0x3283
#define mmGDS_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define mmGDS_PERFCOUNTER2_LO                                                                          0x3284
#define mmGDS_PERFCOUNTER2_LO_BASE_IDX                                                                 1
#define mmGDS_PERFCOUNTER2_HI                                                                          0x3285
#define mmGDS_PERFCOUNTER2_HI_BASE_IDX                                                                 1
#define mmGDS_PERFCOUNTER3_LO                                                                          0x3286
#define mmGDS_PERFCOUNTER3_LO_BASE_IDX                                                                 1
#define mmGDS_PERFCOUNTER3_HI                                                                          0x3287
#define mmGDS_PERFCOUNTER3_HI_BASE_IDX                                                                 1
#define mmTA_PERFCOUNTER0_LO                                                                           0x32c0
#define mmTA_PERFCOUNTER0_LO_BASE_IDX                                                                  1
#define mmTA_PERFCOUNTER0_HI                                                                           0x32c1
#define mmTA_PERFCOUNTER0_HI_BASE_IDX                                                                  1
#define mmTA_PERFCOUNTER1_LO                                                                           0x32c2
#define mmTA_PERFCOUNTER1_LO_BASE_IDX                                                                  1
#define mmTA_PERFCOUNTER1_HI                                                                           0x32c3
#define mmTA_PERFCOUNTER1_HI_BASE_IDX                                                                  1
#define mmTD_PERFCOUNTER0_LO                                                                           0x3300
#define mmTD_PERFCOUNTER0_LO_BASE_IDX                                                                  1
#define mmTD_PERFCOUNTER0_HI                                                                           0x3301
#define mmTD_PERFCOUNTER0_HI_BASE_IDX                                                                  1
#define mmTD_PERFCOUNTER1_LO                                                                           0x3302
#define mmTD_PERFCOUNTER1_LO_BASE_IDX                                                                  1
#define mmTD_PERFCOUNTER1_HI                                                                           0x3303
#define mmTD_PERFCOUNTER1_HI_BASE_IDX                                                                  1
#define mmTCP_PERFCOUNTER0_LO                                                                          0x3340
#define mmTCP_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define mmTCP_PERFCOUNTER0_HI                                                                          0x3341
#define mmTCP_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define mmTCP_PERFCOUNTER1_LO                                                                          0x3342
#define mmTCP_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define mmTCP_PERFCOUNTER1_HI                                                                          0x3343
#define mmTCP_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define mmTCP_PERFCOUNTER2_LO                                                                          0x3344
#define mmTCP_PERFCOUNTER2_LO_BASE_IDX                                                                 1
#define mmTCP_PERFCOUNTER2_HI                                                                          0x3345
#define mmTCP_PERFCOUNTER2_HI_BASE_IDX                                                                 1
#define mmTCP_PERFCOUNTER3_LO                                                                          0x3346
#define mmTCP_PERFCOUNTER3_LO_BASE_IDX                                                                 1
#define mmTCP_PERFCOUNTER3_HI                                                                          0x3347
#define mmTCP_PERFCOUNTER3_HI_BASE_IDX                                                                 1
#define mmGL2C_PERFCOUNTER0_LO                                                                         0x3380
#define mmGL2C_PERFCOUNTER0_LO_BASE_IDX                                                                1
#define mmGL2C_PERFCOUNTER0_HI                                                                         0x3381
#define mmGL2C_PERFCOUNTER0_HI_BASE_IDX                                                                1
#define mmGL2C_PERFCOUNTER1_LO                                                                         0x3382
#define mmGL2C_PERFCOUNTER1_LO_BASE_IDX                                                                1
#define mmGL2C_PERFCOUNTER1_HI                                                                         0x3383
#define mmGL2C_PERFCOUNTER1_HI_BASE_IDX                                                                1
#define mmGL2C_PERFCOUNTER2_LO                                                                         0x3384
#define mmGL2C_PERFCOUNTER2_LO_BASE_IDX                                                                1
#define mmGL2C_PERFCOUNTER2_HI                                                                         0x3385
#define mmGL2C_PERFCOUNTER2_HI_BASE_IDX                                                                1
#define mmGL2C_PERFCOUNTER3_LO                                                                         0x3386
#define mmGL2C_PERFCOUNTER3_LO_BASE_IDX                                                                1
#define mmGL2C_PERFCOUNTER3_HI                                                                         0x3387
#define mmGL2C_PERFCOUNTER3_HI_BASE_IDX                                                                1
#define mmGL2A_PERFCOUNTER0_LO                                                                         0x3390
#define mmGL2A_PERFCOUNTER0_LO_BASE_IDX                                                                1
#define mmGL2A_PERFCOUNTER0_HI                                                                         0x3391
#define mmGL2A_PERFCOUNTER0_HI_BASE_IDX                                                                1
#define mmGL2A_PERFCOUNTER1_LO                                                                         0x3392
#define mmGL2A_PERFCOUNTER1_LO_BASE_IDX                                                                1
#define mmGL2A_PERFCOUNTER1_HI                                                                         0x3393
#define mmGL2A_PERFCOUNTER1_HI_BASE_IDX                                                                1
#define mmGL2A_PERFCOUNTER2_LO                                                                         0x3394
#define mmGL2A_PERFCOUNTER2_LO_BASE_IDX                                                                1
#define mmGL2A_PERFCOUNTER2_HI                                                                         0x3395
#define mmGL2A_PERFCOUNTER2_HI_BASE_IDX                                                                1
#define mmGL2A_PERFCOUNTER3_LO                                                                         0x3396
#define mmGL2A_PERFCOUNTER3_LO_BASE_IDX                                                                1
#define mmGL2A_PERFCOUNTER3_HI                                                                         0x3397
#define mmGL2A_PERFCOUNTER3_HI_BASE_IDX                                                                1
#define mmGL1C_PERFCOUNTER0_LO                                                                         0x33a0
#define mmGL1C_PERFCOUNTER0_LO_BASE_IDX                                                                1
#define mmGL1C_PERFCOUNTER0_HI                                                                         0x33a1
#define mmGL1C_PERFCOUNTER0_HI_BASE_IDX                                                                1
#define mmGL1C_PERFCOUNTER1_LO                                                                         0x33a2
#define mmGL1C_PERFCOUNTER1_LO_BASE_IDX                                                                1
#define mmGL1C_PERFCOUNTER1_HI                                                                         0x33a3
#define mmGL1C_PERFCOUNTER1_HI_BASE_IDX                                                                1
#define mmGL1C_PERFCOUNTER2_LO                                                                         0x33a4
#define mmGL1C_PERFCOUNTER2_LO_BASE_IDX                                                                1
#define mmGL1C_PERFCOUNTER2_HI                                                                         0x33a5
#define mmGL1C_PERFCOUNTER2_HI_BASE_IDX                                                                1
#define mmGL1C_PERFCOUNTER3_LO                                                                         0x33a6
#define mmGL1C_PERFCOUNTER3_LO_BASE_IDX                                                                1
#define mmGL1C_PERFCOUNTER3_HI                                                                         0x33a7
#define mmGL1C_PERFCOUNTER3_HI_BASE_IDX                                                                1
#define mmCHC_PERFCOUNTER0_LO                                                                          0x33c0
#define mmCHC_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define mmCHC_PERFCOUNTER0_HI                                                                          0x33c1
#define mmCHC_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define mmCHC_PERFCOUNTER1_LO                                                                          0x33c2
#define mmCHC_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define mmCHC_PERFCOUNTER1_HI                                                                          0x33c3
#define mmCHC_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define mmCHC_PERFCOUNTER2_LO                                                                          0x33c4
#define mmCHC_PERFCOUNTER2_LO_BASE_IDX                                                                 1
#define mmCHC_PERFCOUNTER2_HI                                                                          0x33c5
#define mmCHC_PERFCOUNTER2_HI_BASE_IDX                                                                 1
#define mmCHC_PERFCOUNTER3_LO                                                                          0x33c6
#define mmCHC_PERFCOUNTER3_LO_BASE_IDX                                                                 1
#define mmCHC_PERFCOUNTER3_HI                                                                          0x33c7
#define mmCHC_PERFCOUNTER3_HI_BASE_IDX                                                                 1
#define mmCHCG_PERFCOUNTER0_LO                                                                         0x33c8
#define mmCHCG_PERFCOUNTER0_LO_BASE_IDX                                                                1
#define mmCHCG_PERFCOUNTER0_HI                                                                         0x33c9
#define mmCHCG_PERFCOUNTER0_HI_BASE_IDX                                                                1
#define mmCHCG_PERFCOUNTER1_LO                                                                         0x33ca
#define mmCHCG_PERFCOUNTER1_LO_BASE_IDX                                                                1
#define mmCHCG_PERFCOUNTER1_HI                                                                         0x33cb
#define mmCHCG_PERFCOUNTER1_HI_BASE_IDX                                                                1
#define mmCHCG_PERFCOUNTER2_LO                                                                         0x33cc
#define mmCHCG_PERFCOUNTER2_LO_BASE_IDX                                                                1
#define mmCHCG_PERFCOUNTER2_HI                                                                         0x33cd
#define mmCHCG_PERFCOUNTER2_HI_BASE_IDX                                                                1
#define mmCHCG_PERFCOUNTER3_LO                                                                         0x33ce
#define mmCHCG_PERFCOUNTER3_LO_BASE_IDX                                                                1
#define mmCHCG_PERFCOUNTER3_HI                                                                         0x33cf
#define mmCHCG_PERFCOUNTER3_HI_BASE_IDX                                                                1
#define mmCB_PERFCOUNTER0_LO                                                                           0x3406
#define mmCB_PERFCOUNTER0_LO_BASE_IDX                                                                  1
#define mmCB_PERFCOUNTER0_HI                                                                           0x3407
#define mmCB_PERFCOUNTER0_HI_BASE_IDX                                                                  1
#define mmCB_PERFCOUNTER1_LO                                                                           0x3408
#define mmCB_PERFCOUNTER1_LO_BASE_IDX                                                                  1
#define mmCB_PERFCOUNTER1_HI                                                                           0x3409
#define mmCB_PERFCOUNTER1_HI_BASE_IDX                                                                  1
#define mmCB_PERFCOUNTER2_LO                                                                           0x340a
#define mmCB_PERFCOUNTER2_LO_BASE_IDX                                                                  1
#define mmCB_PERFCOUNTER2_HI                                                                           0x340b
#define mmCB_PERFCOUNTER2_HI_BASE_IDX                                                                  1
#define mmCB_PERFCOUNTER3_LO                                                                           0x340c
#define mmCB_PERFCOUNTER3_LO_BASE_IDX                                                                  1
#define mmCB_PERFCOUNTER3_HI                                                                           0x340d
#define mmCB_PERFCOUNTER3_HI_BASE_IDX                                                                  1
#define mmDB_PERFCOUNTER0_LO                                                                           0x3440
#define mmDB_PERFCOUNTER0_LO_BASE_IDX                                                                  1
#define mmDB_PERFCOUNTER0_HI                                                                           0x3441
#define mmDB_PERFCOUNTER0_HI_BASE_IDX                                                                  1
#define mmDB_PERFCOUNTER1_LO                                                                           0x3442
#define mmDB_PERFCOUNTER1_LO_BASE_IDX                                                                  1
#define mmDB_PERFCOUNTER1_HI                                                                           0x3443
#define mmDB_PERFCOUNTER1_HI_BASE_IDX                                                                  1
#define mmDB_PERFCOUNTER2_LO                                                                           0x3444
#define mmDB_PERFCOUNTER2_LO_BASE_IDX                                                                  1
#define mmDB_PERFCOUNTER2_HI                                                                           0x3445
#define mmDB_PERFCOUNTER2_HI_BASE_IDX                                                                  1
#define mmDB_PERFCOUNTER3_LO                                                                           0x3446
#define mmDB_PERFCOUNTER3_LO_BASE_IDX                                                                  1
#define mmDB_PERFCOUNTER3_HI                                                                           0x3447
#define mmDB_PERFCOUNTER3_HI_BASE_IDX                                                                  1
#define mmRLC_PERFCOUNTER0_LO                                                                          0x3480
#define mmRLC_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define mmRLC_PERFCOUNTER0_HI                                                                          0x3481
#define mmRLC_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define mmRLC_PERFCOUNTER1_LO                                                                          0x3482
#define mmRLC_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define mmRLC_PERFCOUNTER1_HI                                                                          0x3483
#define mmRLC_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define mmRMI_PERFCOUNTER0_LO                                                                          0x34c0
#define mmRMI_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define mmRMI_PERFCOUNTER0_HI                                                                          0x34c1
#define mmRMI_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define mmRMI_PERFCOUNTER1_LO                                                                          0x34c2
#define mmRMI_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define mmRMI_PERFCOUNTER1_HI                                                                          0x34c3
#define mmRMI_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define mmRMI_PERFCOUNTER2_LO                                                                          0x34c4
#define mmRMI_PERFCOUNTER2_LO_BASE_IDX                                                                 1
#define mmRMI_PERFCOUNTER2_HI                                                                          0x34c5
#define mmRMI_PERFCOUNTER2_HI_BASE_IDX                                                                 1
#define mmRMI_PERFCOUNTER3_LO                                                                          0x34c6
#define mmRMI_PERFCOUNTER3_LO_BASE_IDX                                                                 1
#define mmRMI_PERFCOUNTER3_HI                                                                          0x34c7
#define mmRMI_PERFCOUNTER3_HI_BASE_IDX                                                                 1
#define mmUTCL1_PERFCOUNTER0_LO                                                                        0x351c
#define mmUTCL1_PERFCOUNTER0_LO_BASE_IDX                                                               1
#define mmUTCL1_PERFCOUNTER0_HI                                                                        0x351d
#define mmUTCL1_PERFCOUNTER0_HI_BASE_IDX                                                               1
#define mmUTCL1_PERFCOUNTER1_LO                                                                        0x351e
#define mmUTCL1_PERFCOUNTER1_LO_BASE_IDX                                                               1
#define mmUTCL1_PERFCOUNTER1_HI                                                                        0x351f
#define mmUTCL1_PERFCOUNTER1_HI_BASE_IDX                                                               1
#define mmGCR_PERFCOUNTER0_LO                                                                          0x3520
#define mmGCR_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define mmGCR_PERFCOUNTER0_HI                                                                          0x3521
#define mmGCR_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define mmGCR_PERFCOUNTER1_LO                                                                          0x3522
#define mmGCR_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define mmGCR_PERFCOUNTER1_HI                                                                          0x3523
#define mmGCR_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define mmPA_PH_PERFCOUNTER0_LO                                                                        0x3580
#define mmPA_PH_PERFCOUNTER0_LO_BASE_IDX                                                               1
#define mmPA_PH_PERFCOUNTER0_HI                                                                        0x3581
#define mmPA_PH_PERFCOUNTER0_HI_BASE_IDX                                                               1
#define mmPA_PH_PERFCOUNTER1_LO                                                                        0x3582
#define mmPA_PH_PERFCOUNTER1_LO_BASE_IDX                                                               1
#define mmPA_PH_PERFCOUNTER1_HI                                                                        0x3583
#define mmPA_PH_PERFCOUNTER1_HI_BASE_IDX                                                               1
#define mmPA_PH_PERFCOUNTER2_LO                                                                        0x3584
#define mmPA_PH_PERFCOUNTER2_LO_BASE_IDX                                                               1
#define mmPA_PH_PERFCOUNTER2_HI                                                                        0x3585
#define mmPA_PH_PERFCOUNTER2_HI_BASE_IDX                                                               1
#define mmPA_PH_PERFCOUNTER3_LO                                                                        0x3586
#define mmPA_PH_PERFCOUNTER3_LO_BASE_IDX                                                               1
#define mmPA_PH_PERFCOUNTER3_HI                                                                        0x3587
#define mmPA_PH_PERFCOUNTER3_HI_BASE_IDX                                                               1
#define mmPA_PH_PERFCOUNTER4_LO                                                                        0x3588
#define mmPA_PH_PERFCOUNTER4_LO_BASE_IDX                                                               1
#define mmPA_PH_PERFCOUNTER4_HI                                                                        0x3589
#define mmPA_PH_PERFCOUNTER4_HI_BASE_IDX                                                               1
#define mmPA_PH_PERFCOUNTER5_LO                                                                        0x358a
#define mmPA_PH_PERFCOUNTER5_LO_BASE_IDX                                                               1
#define mmPA_PH_PERFCOUNTER5_HI                                                                        0x358b
#define mmPA_PH_PERFCOUNTER5_HI_BASE_IDX                                                               1
#define mmPA_PH_PERFCOUNTER6_LO                                                                        0x358c
#define mmPA_PH_PERFCOUNTER6_LO_BASE_IDX                                                               1
#define mmPA_PH_PERFCOUNTER6_HI                                                                        0x358d
#define mmPA_PH_PERFCOUNTER6_HI_BASE_IDX                                                               1
#define mmPA_PH_PERFCOUNTER7_LO                                                                        0x358e
#define mmPA_PH_PERFCOUNTER7_LO_BASE_IDX                                                               1
#define mmPA_PH_PERFCOUNTER7_HI                                                                        0x358f
#define mmPA_PH_PERFCOUNTER7_HI_BASE_IDX                                                               1
#define mmGL1A_PERFCOUNTER0_LO                                                                         0x35c0
#define mmGL1A_PERFCOUNTER0_LO_BASE_IDX                                                                1
#define mmGL1A_PERFCOUNTER0_HI                                                                         0x35c1
#define mmGL1A_PERFCOUNTER0_HI_BASE_IDX                                                                1
#define mmGL1A_PERFCOUNTER1_LO                                                                         0x35c2
#define mmGL1A_PERFCOUNTER1_LO_BASE_IDX                                                                1
#define mmGL1A_PERFCOUNTER1_HI                                                                         0x35c3
#define mmGL1A_PERFCOUNTER1_HI_BASE_IDX                                                                1
#define mmGL1A_PERFCOUNTER2_LO                                                                         0x35c4
#define mmGL1A_PERFCOUNTER2_LO_BASE_IDX                                                                1
#define mmGL1A_PERFCOUNTER2_HI                                                                         0x35c5
#define mmGL1A_PERFCOUNTER2_HI_BASE_IDX                                                                1
#define mmGL1A_PERFCOUNTER3_LO                                                                         0x35c6
#define mmGL1A_PERFCOUNTER3_LO_BASE_IDX                                                                1
#define mmGL1A_PERFCOUNTER3_HI                                                                         0x35c7
#define mmGL1A_PERFCOUNTER3_HI_BASE_IDX                                                                1
#define mmCHA_PERFCOUNTER0_LO                                                                          0x3600
#define mmCHA_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define mmCHA_PERFCOUNTER0_HI                                                                          0x3601
#define mmCHA_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define mmCHA_PERFCOUNTER1_LO                                                                          0x3602
#define mmCHA_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define mmCHA_PERFCOUNTER1_HI                                                                          0x3603
#define mmCHA_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define mmCHA_PERFCOUNTER2_LO                                                                          0x3604
#define mmCHA_PERFCOUNTER2_LO_BASE_IDX                                                                 1
#define mmCHA_PERFCOUNTER2_HI                                                                          0x3605
#define mmCHA_PERFCOUNTER2_HI_BASE_IDX                                                                 1
#define mmCHA_PERFCOUNTER3_LO                                                                          0x3606
#define mmCHA_PERFCOUNTER3_LO_BASE_IDX                                                                 1
#define mmCHA_PERFCOUNTER3_HI                                                                          0x3607
#define mmCHA_PERFCOUNTER3_HI_BASE_IDX                                                                 1
#define mmGUS_PERFCOUNTER2_LO                                                                          0x3640
#define mmGUS_PERFCOUNTER2_LO_BASE_IDX                                                                 1
#define mmGUS_PERFCOUNTER2_HI                                                                          0x3641
#define mmGUS_PERFCOUNTER2_HI_BASE_IDX                                                                 1
#define mmGUS_PERFCOUNTER_LO                                                                           0x3642
#define mmGUS_PERFCOUNTER_LO_BASE_IDX                                                                  1
#define mmGUS_PERFCOUNTER_HI                                                                           0x3643
#define mmGUS_PERFCOUNTER_HI_BASE_IDX                                                                  1


// addressBlock: gc_gcvml2prdec
// base address: 0x353a0
#define mmGCMC_VM_L2_PERFCOUNTER_LO                                                                    0x34e8
#define mmGCMC_VM_L2_PERFCOUNTER_LO_BASE_IDX                                                           1
#define mmGCMC_VM_L2_PERFCOUNTER_HI                                                                    0x34e9
#define mmGCMC_VM_L2_PERFCOUNTER_HI_BASE_IDX                                                           1
#define mmGCUTCL2_PERFCOUNTER_LO                                                                       0x34ea
#define mmGCUTCL2_PERFCOUNTER_LO_BASE_IDX                                                              1
#define mmGCUTCL2_PERFCOUNTER_HI                                                                       0x34eb
#define mmGCUTCL2_PERFCOUNTER_HI_BASE_IDX                                                              1


// addressBlock: gc_gcvml2perfddec
// base address: 0x353e0
#define mmGCVML2_PERFCOUNTER2_0_LO                                                                     0x34f8
#define mmGCVML2_PERFCOUNTER2_0_LO_BASE_IDX                                                            1
#define mmGCVML2_PERFCOUNTER2_1_LO                                                                     0x34f9
#define mmGCVML2_PERFCOUNTER2_1_LO_BASE_IDX                                                            1
#define mmGCVML2_PERFCOUNTER2_0_HI                                                                     0x34fa
#define mmGCVML2_PERFCOUNTER2_0_HI_BASE_IDX                                                            1
#define mmGCVML2_PERFCOUNTER2_1_HI                                                                     0x34fb
#define mmGCVML2_PERFCOUNTER2_1_HI_BASE_IDX                                                            1


// addressBlock: gc_sdma0_sdma0perfddec
// base address: 0x35980
#define mmSDMA0_PERFCNT_PERFCOUNTER_LO                                                                 0x3660
#define mmSDMA0_PERFCNT_PERFCOUNTER_LO_BASE_IDX                                                        1
#define mmSDMA0_PERFCNT_PERFCOUNTER_HI                                                                 0x3661
#define mmSDMA0_PERFCNT_PERFCOUNTER_HI_BASE_IDX                                                        1
#define mmSDMA0_PERFCOUNTER0_LO                                                                        0x3662
#define mmSDMA0_PERFCOUNTER0_LO_BASE_IDX                                                               1
#define mmSDMA0_PERFCOUNTER0_HI                                                                        0x3663
#define mmSDMA0_PERFCOUNTER0_HI_BASE_IDX                                                               1
#define mmSDMA0_PERFCOUNTER1_LO                                                                        0x3664
#define mmSDMA0_PERFCOUNTER1_LO_BASE_IDX                                                               1
#define mmSDMA0_PERFCOUNTER1_HI                                                                        0x3665
#define mmSDMA0_PERFCOUNTER1_HI_BASE_IDX                                                               1


// addressBlock: gc_sdma1_sdma1perfddec
// base address: 0x359b0
#define mmSDMA1_PERFCNT_PERFCOUNTER_LO                                                                 0x366c
#define mmSDMA1_PERFCNT_PERFCOUNTER_LO_BASE_IDX                                                        1
#define mmSDMA1_PERFCNT_PERFCOUNTER_HI                                                                 0x366d
#define mmSDMA1_PERFCNT_PERFCOUNTER_HI_BASE_IDX                                                        1
#define mmSDMA1_PERFCOUNTER0_LO                                                                        0x366e
#define mmSDMA1_PERFCOUNTER0_LO_BASE_IDX                                                               1
#define mmSDMA1_PERFCOUNTER0_HI                                                                        0x366f
#define mmSDMA1_PERFCOUNTER0_HI_BASE_IDX                                                               1
#define mmSDMA1_PERFCOUNTER1_LO                                                                        0x3670
#define mmSDMA1_PERFCOUNTER1_LO_BASE_IDX                                                               1
#define mmSDMA1_PERFCOUNTER1_HI                                                                        0x3671
#define mmSDMA1_PERFCOUNTER1_HI_BASE_IDX                                                               1


// addressBlock: gc_sdma2_sdma2perfddec
// base address: 0x359e0
#define mmSDMA2_PERFCNT_PERFCOUNTER_LO                                                                 0x3678
#define mmSDMA2_PERFCNT_PERFCOUNTER_LO_BASE_IDX                                                        1
#define mmSDMA2_PERFCNT_PERFCOUNTER_HI                                                                 0x3679
#define mmSDMA2_PERFCNT_PERFCOUNTER_HI_BASE_IDX                                                        1
#define mmSDMA2_PERFCOUNTER0_LO                                                                        0x367a
#define mmSDMA2_PERFCOUNTER0_LO_BASE_IDX                                                               1
#define mmSDMA2_PERFCOUNTER0_HI                                                                        0x367b
#define mmSDMA2_PERFCOUNTER0_HI_BASE_IDX                                                               1
#define mmSDMA2_PERFCOUNTER1_LO                                                                        0x367c
#define mmSDMA2_PERFCOUNTER1_LO_BASE_IDX                                                               1
#define mmSDMA2_PERFCOUNTER1_HI                                                                        0x367d
#define mmSDMA2_PERFCOUNTER1_HI_BASE_IDX                                                               1


// addressBlock: gc_sdma3_sdma3perfddec
// base address: 0x35a10
#define mmSDMA3_PERFCNT_PERFCOUNTER_LO                                                                 0x3684
#define mmSDMA3_PERFCNT_PERFCOUNTER_LO_BASE_IDX                                                        1
#define mmSDMA3_PERFCNT_PERFCOUNTER_HI                                                                 0x3685
#define mmSDMA3_PERFCNT_PERFCOUNTER_HI_BASE_IDX                                                        1
#define mmSDMA3_PERFCOUNTER0_LO                                                                        0x3686
#define mmSDMA3_PERFCOUNTER0_LO_BASE_IDX                                                               1
#define mmSDMA3_PERFCOUNTER0_HI                                                                        0x3687
#define mmSDMA3_PERFCOUNTER0_HI_BASE_IDX                                                               1
#define mmSDMA3_PERFCOUNTER1_LO                                                                        0x3688
#define mmSDMA3_PERFCOUNTER1_LO_BASE_IDX                                                               1
#define mmSDMA3_PERFCOUNTER1_HI                                                                        0x3689
#define mmSDMA3_PERFCOUNTER1_HI_BASE_IDX                                                               1


// addressBlock: gc_perfsdec
// base address: 0x36000
#define mmCPG_PERFCOUNTER1_SELECT                                                                      0x3800
#define mmCPG_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define mmCPG_PERFCOUNTER0_SELECT1                                                                     0x3801
#define mmCPG_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define mmCPG_PERFCOUNTER0_SELECT                                                                      0x3802
#define mmCPG_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define mmCPC_PERFCOUNTER1_SELECT                                                                      0x3803
#define mmCPC_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define mmCPC_PERFCOUNTER0_SELECT1                                                                     0x3804
#define mmCPC_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define mmCPF_PERFCOUNTER1_SELECT                                                                      0x3805
#define mmCPF_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define mmCPF_PERFCOUNTER0_SELECT1                                                                     0x3806
#define mmCPF_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define mmCPF_PERFCOUNTER0_SELECT                                                                      0x3807
#define mmCPF_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define mmCP_PERFMON_CNTL                                                                              0x3808
#define mmCP_PERFMON_CNTL_BASE_IDX                                                                     1
#define mmCPC_PERFCOUNTER0_SELECT                                                                      0x3809
#define mmCPC_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define mmCPF_TC_PERF_COUNTER_WINDOW_SELECT                                                            0x380a
#define mmCPF_TC_PERF_COUNTER_WINDOW_SELECT_BASE_IDX                                                   1
#define mmCPG_TC_PERF_COUNTER_WINDOW_SELECT                                                            0x380b
#define mmCPG_TC_PERF_COUNTER_WINDOW_SELECT_BASE_IDX                                                   1
#define mmCPF_LATENCY_STATS_SELECT                                                                     0x380c
#define mmCPF_LATENCY_STATS_SELECT_BASE_IDX                                                            1
#define mmCPG_LATENCY_STATS_SELECT                                                                     0x380d
#define mmCPG_LATENCY_STATS_SELECT_BASE_IDX                                                            1
#define mmCPC_LATENCY_STATS_SELECT                                                                     0x380e
#define mmCPC_LATENCY_STATS_SELECT_BASE_IDX                                                            1
#define mmCP_DRAW_OBJECT                                                                               0x3810
#define mmCP_DRAW_OBJECT_BASE_IDX                                                                      1
#define mmCP_DRAW_OBJECT_COUNTER                                                                       0x3811
#define mmCP_DRAW_OBJECT_COUNTER_BASE_IDX                                                              1
#define mmCP_DRAW_WINDOW_MASK_HI                                                                       0x3812
#define mmCP_DRAW_WINDOW_MASK_HI_BASE_IDX                                                              1
#define mmCP_DRAW_WINDOW_HI                                                                            0x3813
#define mmCP_DRAW_WINDOW_HI_BASE_IDX                                                                   1
#define mmCP_DRAW_WINDOW_LO                                                                            0x3814
#define mmCP_DRAW_WINDOW_LO_BASE_IDX                                                                   1
#define mmCP_DRAW_WINDOW_CNTL                                                                          0x3815
#define mmCP_DRAW_WINDOW_CNTL_BASE_IDX                                                                 1
#define mmGRBM_PERFCOUNTER0_SELECT                                                                     0x3840
#define mmGRBM_PERFCOUNTER0_SELECT_BASE_IDX                                                            1
#define mmGRBM_PERFCOUNTER1_SELECT                                                                     0x3841
#define mmGRBM_PERFCOUNTER1_SELECT_BASE_IDX                                                            1
#define mmGRBM_SE0_PERFCOUNTER_SELECT                                                                  0x3842
#define mmGRBM_SE0_PERFCOUNTER_SELECT_BASE_IDX                                                         1
#define mmGRBM_SE1_PERFCOUNTER_SELECT                                                                  0x3843
#define mmGRBM_SE1_PERFCOUNTER_SELECT_BASE_IDX                                                         1
#define mmGRBM_SE2_PERFCOUNTER_SELECT                                                                  0x3844
#define mmGRBM_SE2_PERFCOUNTER_SELECT_BASE_IDX                                                         1
#define mmGRBM_SE3_PERFCOUNTER_SELECT                                                                  0x3845
#define mmGRBM_SE3_PERFCOUNTER_SELECT_BASE_IDX                                                         1
#define mmGRBM_PERFCOUNTER0_SELECT_HI                                                                  0x384d
#define mmGRBM_PERFCOUNTER0_SELECT_HI_BASE_IDX                                                         1
#define mmGRBM_PERFCOUNTER1_SELECT_HI                                                                  0x384e
#define mmGRBM_PERFCOUNTER1_SELECT_HI_BASE_IDX                                                         1
#define mmGE1_PERFCOUNTER0_SELECT                                                                      0x38a4
#define mmGE1_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define mmGE1_PERFCOUNTER0_SELECT1                                                                     0x38a5
#define mmGE1_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define mmGE1_PERFCOUNTER1_SELECT                                                                      0x38a6
#define mmGE1_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define mmGE1_PERFCOUNTER1_SELECT1                                                                     0x38a7
#define mmGE1_PERFCOUNTER1_SELECT1_BASE_IDX                                                            1
#define mmGE1_PERFCOUNTER2_SELECT                                                                      0x38a8
#define mmGE1_PERFCOUNTER2_SELECT_BASE_IDX                                                             1
#define mmGE1_PERFCOUNTER2_SELECT1                                                                     0x38a9
#define mmGE1_PERFCOUNTER2_SELECT1_BASE_IDX                                                            1
#define mmGE1_PERFCOUNTER3_SELECT                                                                      0x38aa
#define mmGE1_PERFCOUNTER3_SELECT_BASE_IDX                                                             1
#define mmGE1_PERFCOUNTER3_SELECT1                                                                     0x38ab
#define mmGE1_PERFCOUNTER3_SELECT1_BASE_IDX                                                            1
#define mmGE2_DIST_PERFCOUNTER0_SELECT                                                                 0x38ac
#define mmGE2_DIST_PERFCOUNTER0_SELECT_BASE_IDX                                                        1
#define mmGE2_DIST_PERFCOUNTER0_SELECT1                                                                0x38ad
#define mmGE2_DIST_PERFCOUNTER0_SELECT1_BASE_IDX                                                       1
#define mmGE2_DIST_PERFCOUNTER1_SELECT                                                                 0x38ae
#define mmGE2_DIST_PERFCOUNTER1_SELECT_BASE_IDX                                                        1
#define mmGE2_DIST_PERFCOUNTER1_SELECT1                                                                0x38af
#define mmGE2_DIST_PERFCOUNTER1_SELECT1_BASE_IDX                                                       1
#define mmGE2_DIST_PERFCOUNTER2_SELECT                                                                 0x38b0
#define mmGE2_DIST_PERFCOUNTER2_SELECT_BASE_IDX                                                        1
#define mmGE2_DIST_PERFCOUNTER2_SELECT1                                                                0x38b1
#define mmGE2_DIST_PERFCOUNTER2_SELECT1_BASE_IDX                                                       1
#define mmGE2_DIST_PERFCOUNTER3_SELECT                                                                 0x38b2
#define mmGE2_DIST_PERFCOUNTER3_SELECT_BASE_IDX                                                        1
#define mmGE2_DIST_PERFCOUNTER3_SELECT1                                                                0x38b3
#define mmGE2_DIST_PERFCOUNTER3_SELECT1_BASE_IDX                                                       1
#define mmGE2_SE_PERFCOUNTER0_SELECT                                                                   0x38b4
#define mmGE2_SE_PERFCOUNTER0_SELECT_BASE_IDX                                                          1
#define mmGE2_SE_PERFCOUNTER0_SELECT1                                                                  0x38b5
#define mmGE2_SE_PERFCOUNTER0_SELECT1_BASE_IDX                                                         1
#define mmGE2_SE_PERFCOUNTER1_SELECT                                                                   0x38b6
#define mmGE2_SE_PERFCOUNTER1_SELECT_BASE_IDX                                                          1
#define mmGE2_SE_PERFCOUNTER1_SELECT1                                                                  0x38b7
#define mmGE2_SE_PERFCOUNTER1_SELECT1_BASE_IDX                                                         1
#define mmGE2_SE_PERFCOUNTER2_SELECT                                                                   0x38b8
#define mmGE2_SE_PERFCOUNTER2_SELECT_BASE_IDX                                                          1
#define mmGE2_SE_PERFCOUNTER2_SELECT1                                                                  0x38b9
#define mmGE2_SE_PERFCOUNTER2_SELECT1_BASE_IDX                                                         1
#define mmGE2_SE_PERFCOUNTER3_SELECT                                                                   0x38ba
#define mmGE2_SE_PERFCOUNTER3_SELECT_BASE_IDX                                                          1
#define mmGE2_SE_PERFCOUNTER3_SELECT1                                                                  0x38bb
#define mmGE2_SE_PERFCOUNTER3_SELECT1_BASE_IDX                                                         1
#define mmPA_SU_PERFCOUNTER0_SELECT                                                                    0x3900
#define mmPA_SU_PERFCOUNTER0_SELECT_BASE_IDX                                                           1
#define mmPA_SU_PERFCOUNTER0_SELECT1                                                                   0x3901
#define mmPA_SU_PERFCOUNTER0_SELECT1_BASE_IDX                                                          1
#define mmPA_SU_PERFCOUNTER1_SELECT                                                                    0x3902
#define mmPA_SU_PERFCOUNTER1_SELECT_BASE_IDX                                                           1
#define mmPA_SU_PERFCOUNTER1_SELECT1                                                                   0x3903
#define mmPA_SU_PERFCOUNTER1_SELECT1_BASE_IDX                                                          1
#define mmPA_SU_PERFCOUNTER2_SELECT                                                                    0x3904
#define mmPA_SU_PERFCOUNTER2_SELECT_BASE_IDX                                                           1
#define mmPA_SU_PERFCOUNTER2_SELECT1                                                                   0x3905
#define mmPA_SU_PERFCOUNTER2_SELECT1_BASE_IDX                                                          1
#define mmPA_SU_PERFCOUNTER3_SELECT                                                                    0x3906
#define mmPA_SU_PERFCOUNTER3_SELECT_BASE_IDX                                                           1
#define mmPA_SU_PERFCOUNTER3_SELECT1                                                                   0x3907
#define mmPA_SU_PERFCOUNTER3_SELECT1_BASE_IDX                                                          1
#define mmPA_SC_PERFCOUNTER0_SELECT                                                                    0x3940
#define mmPA_SC_PERFCOUNTER0_SELECT_BASE_IDX                                                           1
#define mmPA_SC_PERFCOUNTER0_SELECT1                                                                   0x3941
#define mmPA_SC_PERFCOUNTER0_SELECT1_BASE_IDX                                                          1
#define mmPA_SC_PERFCOUNTER1_SELECT                                                                    0x3942
#define mmPA_SC_PERFCOUNTER1_SELECT_BASE_IDX                                                           1
#define mmPA_SC_PERFCOUNTER2_SELECT                                                                    0x3943
#define mmPA_SC_PERFCOUNTER2_SELECT_BASE_IDX                                                           1
#define mmPA_SC_PERFCOUNTER3_SELECT                                                                    0x3944
#define mmPA_SC_PERFCOUNTER3_SELECT_BASE_IDX                                                           1
#define mmPA_SC_PERFCOUNTER4_SELECT                                                                    0x3945
#define mmPA_SC_PERFCOUNTER4_SELECT_BASE_IDX                                                           1
#define mmPA_SC_PERFCOUNTER5_SELECT                                                                    0x3946
#define mmPA_SC_PERFCOUNTER5_SELECT_BASE_IDX                                                           1
#define mmPA_SC_PERFCOUNTER6_SELECT                                                                    0x3947
#define mmPA_SC_PERFCOUNTER6_SELECT_BASE_IDX                                                           1
#define mmPA_SC_PERFCOUNTER7_SELECT                                                                    0x3948
#define mmPA_SC_PERFCOUNTER7_SELECT_BASE_IDX                                                           1
#define mmSPI_PERFCOUNTER0_SELECT                                                                      0x3980
#define mmSPI_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define mmSPI_PERFCOUNTER1_SELECT                                                                      0x3981
#define mmSPI_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define mmSPI_PERFCOUNTER2_SELECT                                                                      0x3982
#define mmSPI_PERFCOUNTER2_SELECT_BASE_IDX                                                             1
#define mmSPI_PERFCOUNTER3_SELECT                                                                      0x3983
#define mmSPI_PERFCOUNTER3_SELECT_BASE_IDX                                                             1
#define mmSPI_PERFCOUNTER0_SELECT1                                                                     0x3984
#define mmSPI_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define mmSPI_PERFCOUNTER1_SELECT1                                                                     0x3985
#define mmSPI_PERFCOUNTER1_SELECT1_BASE_IDX                                                            1
#define mmSPI_PERFCOUNTER2_SELECT1                                                                     0x3986
#define mmSPI_PERFCOUNTER2_SELECT1_BASE_IDX                                                            1
#define mmSPI_PERFCOUNTER3_SELECT1                                                                     0x3987
#define mmSPI_PERFCOUNTER3_SELECT1_BASE_IDX                                                            1
#define mmSPI_PERFCOUNTER4_SELECT                                                                      0x3988
#define mmSPI_PERFCOUNTER4_SELECT_BASE_IDX                                                             1
#define mmSPI_PERFCOUNTER5_SELECT                                                                      0x3989
#define mmSPI_PERFCOUNTER5_SELECT_BASE_IDX                                                             1
#define mmSPI_PERFCOUNTER_BINS                                                                         0x398a
#define mmSPI_PERFCOUNTER_BINS_BASE_IDX                                                                1
#define mmSQ_PERFCOUNTER0_SELECT                                                                       0x39c0
#define mmSQ_PERFCOUNTER0_SELECT_BASE_IDX                                                              1
#define mmSQ_PERFCOUNTER1_SELECT                                                                       0x39c1
#define mmSQ_PERFCOUNTER1_SELECT_BASE_IDX                                                              1
#define mmSQ_PERFCOUNTER2_SELECT                                                                       0x39c2
#define mmSQ_PERFCOUNTER2_SELECT_BASE_IDX                                                              1
#define mmSQ_PERFCOUNTER3_SELECT                                                                       0x39c3
#define mmSQ_PERFCOUNTER3_SELECT_BASE_IDX                                                              1
#define mmSQ_PERFCOUNTER4_SELECT                                                                       0x39c4
#define mmSQ_PERFCOUNTER4_SELECT_BASE_IDX                                                              1
#define mmSQ_PERFCOUNTER5_SELECT                                                                       0x39c5
#define mmSQ_PERFCOUNTER5_SELECT_BASE_IDX                                                              1
#define mmSQ_PERFCOUNTER6_SELECT                                                                       0x39c6
#define mmSQ_PERFCOUNTER6_SELECT_BASE_IDX                                                              1
#define mmSQ_PERFCOUNTER7_SELECT                                                                       0x39c7
#define mmSQ_PERFCOUNTER7_SELECT_BASE_IDX                                                              1
#define mmSQ_PERFCOUNTER8_SELECT                                                                       0x39c8
#define mmSQ_PERFCOUNTER8_SELECT_BASE_IDX                                                              1
#define mmSQ_PERFCOUNTER9_SELECT                                                                       0x39c9
#define mmSQ_PERFCOUNTER9_SELECT_BASE_IDX                                                              1
#define mmSQ_PERFCOUNTER10_SELECT                                                                      0x39ca
#define mmSQ_PERFCOUNTER10_SELECT_BASE_IDX                                                             1
#define mmSQ_PERFCOUNTER11_SELECT                                                                      0x39cb
#define mmSQ_PERFCOUNTER11_SELECT_BASE_IDX                                                             1
#define mmSQ_PERFCOUNTER12_SELECT                                                                      0x39cc
#define mmSQ_PERFCOUNTER12_SELECT_BASE_IDX                                                             1
#define mmSQ_PERFCOUNTER13_SELECT                                                                      0x39cd
#define mmSQ_PERFCOUNTER13_SELECT_BASE_IDX                                                             1
#define mmSQ_PERFCOUNTER14_SELECT                                                                      0x39ce
#define mmSQ_PERFCOUNTER14_SELECT_BASE_IDX                                                             1
#define mmSQ_PERFCOUNTER15_SELECT                                                                      0x39cf
#define mmSQ_PERFCOUNTER15_SELECT_BASE_IDX                                                             1
#define mmSQ_PERFCOUNTER_CTRL                                                                          0x39e0
#define mmSQ_PERFCOUNTER_CTRL_BASE_IDX                                                                 1
#define mmSQ_PERFCOUNTER_CTRL2                                                                         0x39e2
#define mmSQ_PERFCOUNTER_CTRL2_BASE_IDX                                                                1
#define mmGCEA_PERFCOUNTER2_SELECT                                                                     0x3a00
#define mmGCEA_PERFCOUNTER2_SELECT_BASE_IDX                                                            1
#define mmGCEA_PERFCOUNTER2_SELECT1                                                                    0x3a01
#define mmGCEA_PERFCOUNTER2_SELECT1_BASE_IDX                                                           1
#define mmGCEA_PERFCOUNTER2_MODE                                                                       0x3a02
#define mmGCEA_PERFCOUNTER2_MODE_BASE_IDX                                                              1
#define mmGCEA_PERFCOUNTER0_CFG                                                                        0x3a03
#define mmGCEA_PERFCOUNTER0_CFG_BASE_IDX                                                               1
#define mmGCEA_PERFCOUNTER1_CFG                                                                        0x3a04
#define mmGCEA_PERFCOUNTER1_CFG_BASE_IDX                                                               1
#define mmGCEA_PERFCOUNTER_RSLT_CNTL                                                                   0x3a05
#define mmGCEA_PERFCOUNTER_RSLT_CNTL_BASE_IDX                                                          1
#define mmSX_PERFCOUNTER0_SELECT                                                                       0x3a40
#define mmSX_PERFCOUNTER0_SELECT_BASE_IDX                                                              1
#define mmSX_PERFCOUNTER1_SELECT                                                                       0x3a41
#define mmSX_PERFCOUNTER1_SELECT_BASE_IDX                                                              1
#define mmSX_PERFCOUNTER2_SELECT                                                                       0x3a42
#define mmSX_PERFCOUNTER2_SELECT_BASE_IDX                                                              1
#define mmSX_PERFCOUNTER3_SELECT                                                                       0x3a43
#define mmSX_PERFCOUNTER3_SELECT_BASE_IDX                                                              1
#define mmSX_PERFCOUNTER0_SELECT1                                                                      0x3a44
#define mmSX_PERFCOUNTER0_SELECT1_BASE_IDX                                                             1
#define mmSX_PERFCOUNTER1_SELECT1                                                                      0x3a45
#define mmSX_PERFCOUNTER1_SELECT1_BASE_IDX                                                             1
#define mmGDS_PERFCOUNTER0_SELECT                                                                      0x3a80
#define mmGDS_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define mmGDS_PERFCOUNTER1_SELECT                                                                      0x3a81
#define mmGDS_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define mmGDS_PERFCOUNTER2_SELECT                                                                      0x3a82
#define mmGDS_PERFCOUNTER2_SELECT_BASE_IDX                                                             1
#define mmGDS_PERFCOUNTER3_SELECT                                                                      0x3a83
#define mmGDS_PERFCOUNTER3_SELECT_BASE_IDX                                                             1
#define mmGDS_PERFCOUNTER0_SELECT1                                                                     0x3a84
#define mmGDS_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define mmGDS_PERFCOUNTER1_SELECT1                                                                     0x3a85
#define mmGDS_PERFCOUNTER1_SELECT1_BASE_IDX                                                            1
#define mmGDS_PERFCOUNTER2_SELECT1                                                                     0x3a86
#define mmGDS_PERFCOUNTER2_SELECT1_BASE_IDX                                                            1
#define mmGDS_PERFCOUNTER3_SELECT1                                                                     0x3a87
#define mmGDS_PERFCOUNTER3_SELECT1_BASE_IDX                                                            1
#define mmTA_PERFCOUNTER0_SELECT                                                                       0x3ac0
#define mmTA_PERFCOUNTER0_SELECT_BASE_IDX                                                              1
#define mmTA_PERFCOUNTER0_SELECT1                                                                      0x3ac1
#define mmTA_PERFCOUNTER0_SELECT1_BASE_IDX                                                             1
#define mmTA_PERFCOUNTER1_SELECT                                                                       0x3ac2
#define mmTA_PERFCOUNTER1_SELECT_BASE_IDX                                                              1
#define mmTD_PERFCOUNTER0_SELECT                                                                       0x3b00
#define mmTD_PERFCOUNTER0_SELECT_BASE_IDX                                                              1
#define mmTD_PERFCOUNTER0_SELECT1                                                                      0x3b01
#define mmTD_PERFCOUNTER0_SELECT1_BASE_IDX                                                             1
#define mmTD_PERFCOUNTER1_SELECT                                                                       0x3b02
#define mmTD_PERFCOUNTER1_SELECT_BASE_IDX                                                              1
#define mmTCP_PERFCOUNTER0_SELECT                                                                      0x3b40
#define mmTCP_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define mmTCP_PERFCOUNTER0_SELECT1                                                                     0x3b41
#define mmTCP_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define mmTCP_PERFCOUNTER1_SELECT                                                                      0x3b42
#define mmTCP_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define mmTCP_PERFCOUNTER1_SELECT1                                                                     0x3b43
#define mmTCP_PERFCOUNTER1_SELECT1_BASE_IDX                                                            1
#define mmTCP_PERFCOUNTER2_SELECT                                                                      0x3b44
#define mmTCP_PERFCOUNTER2_SELECT_BASE_IDX                                                             1
#define mmTCP_PERFCOUNTER3_SELECT                                                                      0x3b45
#define mmTCP_PERFCOUNTER3_SELECT_BASE_IDX                                                             1
#define mmGL2C_PERFCOUNTER0_SELECT                                                                     0x3b80
#define mmGL2C_PERFCOUNTER0_SELECT_BASE_IDX                                                            1
#define mmGL2C_PERFCOUNTER0_SELECT1                                                                    0x3b81
#define mmGL2C_PERFCOUNTER0_SELECT1_BASE_IDX                                                           1
#define mmGL2C_PERFCOUNTER1_SELECT                                                                     0x3b82
#define mmGL2C_PERFCOUNTER1_SELECT_BASE_IDX                                                            1
#define mmGL2C_PERFCOUNTER1_SELECT1                                                                    0x3b83
#define mmGL2C_PERFCOUNTER1_SELECT1_BASE_IDX                                                           1
#define mmGL2C_PERFCOUNTER2_SELECT                                                                     0x3b84
#define mmGL2C_PERFCOUNTER2_SELECT_BASE_IDX                                                            1
#define mmGL2C_PERFCOUNTER3_SELECT                                                                     0x3b85
#define mmGL2C_PERFCOUNTER3_SELECT_BASE_IDX                                                            1
#define mmGL2A_PERFCOUNTER0_SELECT                                                                     0x3b90
#define mmGL2A_PERFCOUNTER0_SELECT_BASE_IDX                                                            1
#define mmGL2A_PERFCOUNTER0_SELECT1                                                                    0x3b91
#define mmGL2A_PERFCOUNTER0_SELECT1_BASE_IDX                                                           1
#define mmGL2A_PERFCOUNTER1_SELECT                                                                     0x3b92
#define mmGL2A_PERFCOUNTER1_SELECT_BASE_IDX                                                            1
#define mmGL2A_PERFCOUNTER1_SELECT1                                                                    0x3b93
#define mmGL2A_PERFCOUNTER1_SELECT1_BASE_IDX                                                           1
#define mmGL2A_PERFCOUNTER2_SELECT                                                                     0x3b94
#define mmGL2A_PERFCOUNTER2_SELECT_BASE_IDX                                                            1
#define mmGL2A_PERFCOUNTER3_SELECT                                                                     0x3b95
#define mmGL2A_PERFCOUNTER3_SELECT_BASE_IDX                                                            1
#define mmGL1C_PERFCOUNTER0_SELECT                                                                     0x3ba0
#define mmGL1C_PERFCOUNTER0_SELECT_BASE_IDX                                                            1
#define mmGL1C_PERFCOUNTER0_SELECT1                                                                    0x3ba1
#define mmGL1C_PERFCOUNTER0_SELECT1_BASE_IDX                                                           1
#define mmGL1C_PERFCOUNTER1_SELECT                                                                     0x3ba2
#define mmGL1C_PERFCOUNTER1_SELECT_BASE_IDX                                                            1
#define mmGL1C_PERFCOUNTER2_SELECT                                                                     0x3ba3
#define mmGL1C_PERFCOUNTER2_SELECT_BASE_IDX                                                            1
#define mmGL1C_PERFCOUNTER3_SELECT                                                                     0x3ba4
#define mmGL1C_PERFCOUNTER3_SELECT_BASE_IDX                                                            1
#define mmCHC_PERFCOUNTER0_SELECT                                                                      0x3bc0
#define mmCHC_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define mmCHC_PERFCOUNTER0_SELECT1                                                                     0x3bc1
#define mmCHC_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define mmCHC_PERFCOUNTER1_SELECT                                                                      0x3bc2
#define mmCHC_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define mmCHC_PERFCOUNTER2_SELECT                                                                      0x3bc3
#define mmCHC_PERFCOUNTER2_SELECT_BASE_IDX                                                             1
#define mmCHC_PERFCOUNTER3_SELECT                                                                      0x3bc4
#define mmCHC_PERFCOUNTER3_SELECT_BASE_IDX                                                             1
#define mmCHCG_PERFCOUNTER0_SELECT                                                                     0x3bc6
#define mmCHCG_PERFCOUNTER0_SELECT_BASE_IDX                                                            1
#define mmCHCG_PERFCOUNTER0_SELECT1                                                                    0x3bc7
#define mmCHCG_PERFCOUNTER0_SELECT1_BASE_IDX                                                           1
#define mmCHCG_PERFCOUNTER1_SELECT                                                                     0x3bc8
#define mmCHCG_PERFCOUNTER1_SELECT_BASE_IDX                                                            1
#define mmCHCG_PERFCOUNTER2_SELECT                                                                     0x3bc9
#define mmCHCG_PERFCOUNTER2_SELECT_BASE_IDX                                                            1
#define mmCHCG_PERFCOUNTER3_SELECT                                                                     0x3bca
#define mmCHCG_PERFCOUNTER3_SELECT_BASE_IDX                                                            1
#define mmCB_PERFCOUNTER_FILTER                                                                        0x3c00
#define mmCB_PERFCOUNTER_FILTER_BASE_IDX                                                               1
#define mmCB_PERFCOUNTER0_SELECT                                                                       0x3c01
#define mmCB_PERFCOUNTER0_SELECT_BASE_IDX                                                              1
#define mmCB_PERFCOUNTER0_SELECT1                                                                      0x3c02
#define mmCB_PERFCOUNTER0_SELECT1_BASE_IDX                                                             1
#define mmCB_PERFCOUNTER1_SELECT                                                                       0x3c03
#define mmCB_PERFCOUNTER1_SELECT_BASE_IDX                                                              1
#define mmCB_PERFCOUNTER2_SELECT                                                                       0x3c04
#define mmCB_PERFCOUNTER2_SELECT_BASE_IDX                                                              1
#define mmCB_PERFCOUNTER3_SELECT                                                                       0x3c05
#define mmCB_PERFCOUNTER3_SELECT_BASE_IDX                                                              1
#define mmDB_PERFCOUNTER0_SELECT                                                                       0x3c40
#define mmDB_PERFCOUNTER0_SELECT_BASE_IDX                                                              1
#define mmDB_PERFCOUNTER0_SELECT1                                                                      0x3c41
#define mmDB_PERFCOUNTER0_SELECT1_BASE_IDX                                                             1
#define mmDB_PERFCOUNTER1_SELECT                                                                       0x3c42
#define mmDB_PERFCOUNTER1_SELECT_BASE_IDX                                                              1
#define mmDB_PERFCOUNTER1_SELECT1                                                                      0x3c43
#define mmDB_PERFCOUNTER1_SELECT1_BASE_IDX                                                             1
#define mmDB_PERFCOUNTER2_SELECT                                                                       0x3c44
#define mmDB_PERFCOUNTER2_SELECT_BASE_IDX                                                              1
#define mmDB_PERFCOUNTER3_SELECT                                                                       0x3c46
#define mmDB_PERFCOUNTER3_SELECT_BASE_IDX                                                              1
#define mmRLC_SPM_PERFMON_CNTL                                                                         0x3c80
#define mmRLC_SPM_PERFMON_CNTL_BASE_IDX                                                                1
#define mmRLC_SPM_PERFMON_RING_BASE_LO                                                                 0x3c81
#define mmRLC_SPM_PERFMON_RING_BASE_LO_BASE_IDX                                                        1
#define mmRLC_SPM_PERFMON_RING_BASE_HI                                                                 0x3c82
#define mmRLC_SPM_PERFMON_RING_BASE_HI_BASE_IDX                                                        1
#define mmRLC_SPM_PERFMON_RING_SIZE                                                                    0x3c83
#define mmRLC_SPM_PERFMON_RING_SIZE_BASE_IDX                                                           1
#define mmRLC_SPM_PERFMON_SEGMENT_SIZE                                                                 0x3c84
#define mmRLC_SPM_PERFMON_SEGMENT_SIZE_BASE_IDX                                                        1
#define mmRLC_SPM_RING_RDPTR                                                                           0x3c85
#define mmRLC_SPM_RING_RDPTR_BASE_IDX                                                                  1
#define mmRLC_SPM_SEGMENT_THRESHOLD                                                                    0x3c86
#define mmRLC_SPM_SEGMENT_THRESHOLD_BASE_IDX                                                           1
#define mmRLC_SPM_SE_MUXSEL_ADDR                                                                       0x3c87
#define mmRLC_SPM_SE_MUXSEL_ADDR_BASE_IDX                                                              1
#define mmRLC_SPM_SE_MUXSEL_DATA                                                                       0x3c88
#define mmRLC_SPM_SE_MUXSEL_DATA_BASE_IDX                                                              1
#define mmRLC_SPM_GLOBAL_MUXSEL_ADDR                                                                   0x3c89
#define mmRLC_SPM_GLOBAL_MUXSEL_ADDR_BASE_IDX                                                          1
#define mmRLC_SPM_GLOBAL_MUXSEL_DATA                                                                   0x3c8a
#define mmRLC_SPM_GLOBAL_MUXSEL_DATA_BASE_IDX                                                          1
#define mmRLC_SPM_DESER_START_SKEW                                                                     0x3c8b
#define mmRLC_SPM_DESER_START_SKEW_BASE_IDX                                                            1
#define mmRLC_SPM_GLOBALS_SAMPLE_SKEW                                                                  0x3c8c
#define mmRLC_SPM_GLOBALS_SAMPLE_SKEW_BASE_IDX                                                         1
#define mmRLC_SPM_GLOBALS_MUXSEL_SKEW                                                                  0x3c8d
#define mmRLC_SPM_GLOBALS_MUXSEL_SKEW_BASE_IDX                                                         1
#define mmRLC_SPM_SE_SAMPLE_SKEW                                                                       0x3c8e
#define mmRLC_SPM_SE_SAMPLE_SKEW_BASE_IDX                                                              1
#define mmRLC_SPM_SE_MUXSEL_SKEW                                                                       0x3c8f
#define mmRLC_SPM_SE_MUXSEL_SKEW_BASE_IDX                                                              1
#define mmRLC_SPM_GLB_SAMPLEDELAY_IND_ADDR                                                             0x3c90
#define mmRLC_SPM_GLB_SAMPLEDELAY_IND_ADDR_BASE_IDX                                                    1
#define mmRLC_SPM_GLB_SAMPLEDELAY_IND_DATA                                                             0x3c91
#define mmRLC_SPM_GLB_SAMPLEDELAY_IND_DATA_BASE_IDX                                                    1
#define mmRLC_SPM_SE_SAMPLEDELAY_IND_ADDR                                                              0x3c92
#define mmRLC_SPM_SE_SAMPLEDELAY_IND_ADDR_BASE_IDX                                                     1
#define mmRLC_SPM_SE_SAMPLEDELAY_IND_DATA                                                              0x3c93
#define mmRLC_SPM_SE_SAMPLEDELAY_IND_DATA_BASE_IDX                                                     1
#define mmRLC_SPM_RING_WRPTR                                                                           0x3c94
#define mmRLC_SPM_RING_WRPTR_BASE_IDX                                                                  1
#define mmRLC_SPM_ACCUM_DATARAM_ADDR                                                                   0x3c95
#define mmRLC_SPM_ACCUM_DATARAM_ADDR_BASE_IDX                                                          1
#define mmRLC_SPM_ACCUM_DATARAM_DATA                                                                   0x3c96
#define mmRLC_SPM_ACCUM_DATARAM_DATA_BASE_IDX                                                          1
#define mmRLC_SPM_ACCUM_CTRLRAM_ADDR                                                                   0x3c97
#define mmRLC_SPM_ACCUM_CTRLRAM_ADDR_BASE_IDX                                                          1
#define mmRLC_SPM_ACCUM_CTRLRAM_DATA                                                                   0x3c98
#define mmRLC_SPM_ACCUM_CTRLRAM_DATA_BASE_IDX                                                          1
#define mmRLC_SPM_ACCUM_STATUS                                                                         0x3c99
#define mmRLC_SPM_ACCUM_STATUS_BASE_IDX                                                                1
#define mmRLC_SPM_ACCUM_CTRL                                                                           0x3c9a
#define mmRLC_SPM_ACCUM_CTRL_BASE_IDX                                                                  1
#define mmRLC_SPM_ACCUM_MODE                                                                           0x3c9b
#define mmRLC_SPM_ACCUM_MODE_BASE_IDX                                                                  1
#define mmRLC_SPM_ACCUM_THRESHOLD                                                                      0x3c9c
#define mmRLC_SPM_ACCUM_THRESHOLD_BASE_IDX                                                             1
#define mmRLC_SPM_ACCUM_SAMPLES_REQUESTED                                                              0x3c9d
#define mmRLC_SPM_ACCUM_SAMPLES_REQUESTED_BASE_IDX                                                     1
#define mmRLC_SPM_ACCUM_DATARAM_WRCOUNT                                                                0x3c9e
#define mmRLC_SPM_ACCUM_DATARAM_WRCOUNT_BASE_IDX                                                       1
#define mmRLC_SPM_PERFMON_SE3TO0_SEGMENT_SIZE                                                          0x3c9f
#define mmRLC_SPM_PERFMON_SE3TO0_SEGMENT_SIZE_BASE_IDX                                                 1
#define mmRLC_SPM_PERFMON_GLB_SEGMENT_SIZE                                                             0x3ca0
#define mmRLC_SPM_PERFMON_GLB_SEGMENT_SIZE_BASE_IDX                                                    1
#define mmRLC_SPM_VIRT_CTRL                                                                            0x3ca1
#define mmRLC_SPM_VIRT_CTRL_BASE_IDX                                                                   1
#define mmRLC_SPM_PERFMON_SWA_SEGMENT_SIZE                                                             0x3ca2
#define mmRLC_SPM_PERFMON_SWA_SEGMENT_SIZE_BASE_IDX                                                    1
#define mmRLC_SPM_VIRT_STATUS                                                                          0x3ca3
#define mmRLC_SPM_VIRT_STATUS_BASE_IDX                                                                 1
#define mmRLC_SPM_GFXCLOCK_HIGHCOUNT                                                                   0x3ca4
#define mmRLC_SPM_GFXCLOCK_HIGHCOUNT_BASE_IDX                                                          1
#define mmRLC_SPM_GFXCLOCK_LOWCOUNT                                                                    0x3ca5
#define mmRLC_SPM_GFXCLOCK_LOWCOUNT_BASE_IDX                                                           1
#define mmRLC_SPM_PERFMON_SWA_SE3TO0_SEGMENT_SIZE                                                      0x3ca6
#define mmRLC_SPM_PERFMON_SWA_SE3TO0_SEGMENT_SIZE_BASE_IDX                                             1
#define mmRLC_SPM_GLOBAL_MUXSEL_ADDR_OFFSET                                                            0x3ca7
#define mmRLC_SPM_GLOBAL_MUXSEL_ADDR_OFFSET_BASE_IDX                                                   1
#define mmRLC_SPM_SE_MUXSEL_ADDR_OFFSET                                                                0x3ca8
#define mmRLC_SPM_SE_MUXSEL_ADDR_OFFSET_BASE_IDX                                                       1
#define mmRLC_SPM_ACCUM_SWA_DATARAM_ADDR                                                               0x3ca9
#define mmRLC_SPM_ACCUM_SWA_DATARAM_ADDR_BASE_IDX                                                      1
#define mmRLC_SPM_ACCUM_SWA_DATARAM_DATA                                                               0x3caa
#define mmRLC_SPM_ACCUM_SWA_DATARAM_DATA_BASE_IDX                                                      1
#define mmRLC_SPM_ACCUM_CTRLRAM_ADDR_OFFSET                                                            0x3cab
#define mmRLC_SPM_ACCUM_CTRLRAM_ADDR_OFFSET_BASE_IDX                                                   1
#define mmRLC_SPM_PERFMON_SWA_GLB_SEGMENT_SIZE                                                         0x3cac
#define mmRLC_SPM_PERFMON_SWA_GLB_SEGMENT_SIZE_BASE_IDX                                                1
#define mmRLC_SPM_ACCUM_DATARAM_32BITCNTRS_REGIONS                                                     0x3cad
#define mmRLC_SPM_ACCUM_DATARAM_32BITCNTRS_REGIONS_BASE_IDX                                            1
#define mmRLC_PERFMON_CNTL                                                                             0x3cc0
#define mmRLC_PERFMON_CNTL_BASE_IDX                                                                    1
#define mmRLC_PERFCOUNTER0_SELECT                                                                      0x3cc1
#define mmRLC_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define mmRLC_PERFCOUNTER1_SELECT                                                                      0x3cc2
#define mmRLC_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define mmRLC_GPU_IOV_PERF_CNT_CNTL                                                                    0x3cc3
#define mmRLC_GPU_IOV_PERF_CNT_CNTL_BASE_IDX                                                           1
#define mmRLC_GPU_IOV_PERF_CNT_WR_ADDR                                                                 0x3cc4
#define mmRLC_GPU_IOV_PERF_CNT_WR_ADDR_BASE_IDX                                                        1
#define mmRLC_GPU_IOV_PERF_CNT_WR_DATA                                                                 0x3cc5
#define mmRLC_GPU_IOV_PERF_CNT_WR_DATA_BASE_IDX                                                        1
#define mmRLC_GPU_IOV_PERF_CNT_RD_ADDR                                                                 0x3cc6
#define mmRLC_GPU_IOV_PERF_CNT_RD_ADDR_BASE_IDX                                                        1
#define mmRLC_GPU_IOV_PERF_CNT_RD_DATA                                                                 0x3cc7
#define mmRLC_GPU_IOV_PERF_CNT_RD_DATA_BASE_IDX                                                        1
#define mmRLC_PERFMON_CLK_CNTL                                                                         0x3ce4
#define mmRLC_PERFMON_CLK_CNTL_BASE_IDX                                                                1
#define mmRMI_PERFCOUNTER0_SELECT                                                                      0x3d00
#define mmRMI_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define mmRMI_PERFCOUNTER0_SELECT1                                                                     0x3d01
#define mmRMI_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define mmRMI_PERFCOUNTER1_SELECT                                                                      0x3d02
#define mmRMI_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define mmRMI_PERFCOUNTER2_SELECT                                                                      0x3d03
#define mmRMI_PERFCOUNTER2_SELECT_BASE_IDX                                                             1
#define mmRMI_PERFCOUNTER2_SELECT1                                                                     0x3d04
#define mmRMI_PERFCOUNTER2_SELECT1_BASE_IDX                                                            1
#define mmRMI_PERFCOUNTER3_SELECT                                                                      0x3d05
#define mmRMI_PERFCOUNTER3_SELECT_BASE_IDX                                                             1
#define mmRMI_PERF_COUNTER_CNTL                                                                        0x3d06
#define mmRMI_PERF_COUNTER_CNTL_BASE_IDX                                                               1
#define mmGCR_PERFCOUNTER0_SELECT                                                                      0x3d60
#define mmGCR_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define mmGCR_PERFCOUNTER0_SELECT1                                                                     0x3d61
#define mmGCR_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define mmGCR_PERFCOUNTER1_SELECT                                                                      0x3d62
#define mmGCR_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define mmUTCL1_PERFCOUNTER0_SELECT                                                                    0x3d63
#define mmUTCL1_PERFCOUNTER0_SELECT_BASE_IDX                                                           1
#define mmUTCL1_PERFCOUNTER1_SELECT                                                                    0x3d64
#define mmUTCL1_PERFCOUNTER1_SELECT_BASE_IDX                                                           1
#define mmPA_PH_PERFCOUNTER0_SELECT                                                                    0x3d80
#define mmPA_PH_PERFCOUNTER0_SELECT_BASE_IDX                                                           1
#define mmPA_PH_PERFCOUNTER0_SELECT1                                                                   0x3d81
#define mmPA_PH_PERFCOUNTER0_SELECT1_BASE_IDX                                                          1
#define mmPA_PH_PERFCOUNTER1_SELECT                                                                    0x3d82
#define mmPA_PH_PERFCOUNTER1_SELECT_BASE_IDX                                                           1
#define mmPA_PH_PERFCOUNTER2_SELECT                                                                    0x3d83
#define mmPA_PH_PERFCOUNTER2_SELECT_BASE_IDX                                                           1
#define mmPA_PH_PERFCOUNTER3_SELECT                                                                    0x3d84
#define mmPA_PH_PERFCOUNTER3_SELECT_BASE_IDX                                                           1
#define mmPA_PH_PERFCOUNTER4_SELECT                                                                    0x3d85
#define mmPA_PH_PERFCOUNTER4_SELECT_BASE_IDX                                                           1
#define mmPA_PH_PERFCOUNTER5_SELECT                                                                    0x3d86
#define mmPA_PH_PERFCOUNTER5_SELECT_BASE_IDX                                                           1
#define mmPA_PH_PERFCOUNTER6_SELECT                                                                    0x3d87
#define mmPA_PH_PERFCOUNTER6_SELECT_BASE_IDX                                                           1
#define mmPA_PH_PERFCOUNTER7_SELECT                                                                    0x3d88
#define mmPA_PH_PERFCOUNTER7_SELECT_BASE_IDX                                                           1
#define mmPA_PH_PERFCOUNTER1_SELECT1                                                                   0x3d90
#define mmPA_PH_PERFCOUNTER1_SELECT1_BASE_IDX                                                          1
#define mmPA_PH_PERFCOUNTER2_SELECT1                                                                   0x3d91
#define mmPA_PH_PERFCOUNTER2_SELECT1_BASE_IDX                                                          1
#define mmPA_PH_PERFCOUNTER3_SELECT1                                                                   0x3d92
#define mmPA_PH_PERFCOUNTER3_SELECT1_BASE_IDX                                                          1
#define mmGL1A_PERFCOUNTER0_SELECT                                                                     0x3dc0
#define mmGL1A_PERFCOUNTER0_SELECT_BASE_IDX                                                            1
#define mmGL1A_PERFCOUNTER0_SELECT1                                                                    0x3dc1
#define mmGL1A_PERFCOUNTER0_SELECT1_BASE_IDX                                                           1
#define mmGL1A_PERFCOUNTER1_SELECT                                                                     0x3dc2
#define mmGL1A_PERFCOUNTER1_SELECT_BASE_IDX                                                            1
#define mmGL1A_PERFCOUNTER2_SELECT                                                                     0x3dc3
#define mmGL1A_PERFCOUNTER2_SELECT_BASE_IDX                                                            1
#define mmGL1A_PERFCOUNTER3_SELECT                                                                     0x3dc4
#define mmGL1A_PERFCOUNTER3_SELECT_BASE_IDX                                                            1
#define mmCHA_PERFCOUNTER0_SELECT                                                                      0x3de0
#define mmCHA_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define mmCHA_PERFCOUNTER0_SELECT1                                                                     0x3de1
#define mmCHA_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define mmCHA_PERFCOUNTER1_SELECT                                                                      0x3de2
#define mmCHA_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define mmCHA_PERFCOUNTER2_SELECT                                                                      0x3de3
#define mmCHA_PERFCOUNTER2_SELECT_BASE_IDX                                                             1
#define mmCHA_PERFCOUNTER3_SELECT                                                                      0x3de4
#define mmCHA_PERFCOUNTER3_SELECT_BASE_IDX                                                             1
#define mmGUS_PERFCOUNTER2_SELECT                                                                      0x3e00
#define mmGUS_PERFCOUNTER2_SELECT_BASE_IDX                                                             1
#define mmGUS_PERFCOUNTER2_SELECT1                                                                     0x3e01
#define mmGUS_PERFCOUNTER2_SELECT1_BASE_IDX                                                            1
#define mmGUS_PERFCOUNTER2_MODE                                                                        0x3e02
#define mmGUS_PERFCOUNTER2_MODE_BASE_IDX                                                               1
#define mmGUS_PERFCOUNTER0_CFG                                                                         0x3e03
#define mmGUS_PERFCOUNTER0_CFG_BASE_IDX                                                                1
#define mmGUS_PERFCOUNTER1_CFG                                                                         0x3e04
#define mmGUS_PERFCOUNTER1_CFG_BASE_IDX                                                                1
#define mmGUS_PERFCOUNTER_RSLT_CNTL                                                                    0x3e05
#define mmGUS_PERFCOUNTER_RSLT_CNTL_BASE_IDX                                                           1


// addressBlock: gc_gcvml2pldec
// base address: 0x374b0
#define mmGCMC_VM_L2_PERFCOUNTER0_CFG                                                                  0x3d2c
#define mmGCMC_VM_L2_PERFCOUNTER0_CFG_BASE_IDX                                                         1
#define mmGCMC_VM_L2_PERFCOUNTER1_CFG                                                                  0x3d2d
#define mmGCMC_VM_L2_PERFCOUNTER1_CFG_BASE_IDX                                                         1
#define mmGCMC_VM_L2_PERFCOUNTER2_CFG                                                                  0x3d2e
#define mmGCMC_VM_L2_PERFCOUNTER2_CFG_BASE_IDX                                                         1
#define mmGCMC_VM_L2_PERFCOUNTER3_CFG                                                                  0x3d2f
#define mmGCMC_VM_L2_PERFCOUNTER3_CFG_BASE_IDX                                                         1
#define mmGCMC_VM_L2_PERFCOUNTER4_CFG                                                                  0x3d30
#define mmGCMC_VM_L2_PERFCOUNTER4_CFG_BASE_IDX                                                         1
#define mmGCMC_VM_L2_PERFCOUNTER5_CFG                                                                  0x3d31
#define mmGCMC_VM_L2_PERFCOUNTER5_CFG_BASE_IDX                                                         1
#define mmGCMC_VM_L2_PERFCOUNTER6_CFG                                                                  0x3d32
#define mmGCMC_VM_L2_PERFCOUNTER6_CFG_BASE_IDX                                                         1
#define mmGCMC_VM_L2_PERFCOUNTER7_CFG                                                                  0x3d33
#define mmGCMC_VM_L2_PERFCOUNTER7_CFG_BASE_IDX                                                         1
#define mmGCMC_VM_L2_PERFCOUNTER_RSLT_CNTL                                                             0x3d34
#define mmGCMC_VM_L2_PERFCOUNTER_RSLT_CNTL_BASE_IDX                                                    1
#define mmGCUTCL2_PERFCOUNTER0_CFG                                                                     0x3d35
#define mmGCUTCL2_PERFCOUNTER0_CFG_BASE_IDX                                                            1
#define mmGCUTCL2_PERFCOUNTER1_CFG                                                                     0x3d36
#define mmGCUTCL2_PERFCOUNTER1_CFG_BASE_IDX                                                            1
#define mmGCUTCL2_PERFCOUNTER2_CFG                                                                     0x3d37
#define mmGCUTCL2_PERFCOUNTER2_CFG_BASE_IDX                                                            1
#define mmGCUTCL2_PERFCOUNTER3_CFG                                                                     0x3d38
#define mmGCUTCL2_PERFCOUNTER3_CFG_BASE_IDX                                                            1
#define mmGCUTCL2_PERFCOUNTER_RSLT_CNTL                                                                0x3d39
#define mmGCUTCL2_PERFCOUNTER_RSLT_CNTL_BASE_IDX                                                       1


// addressBlock: gc_gcvml2perfsdec
// base address: 0x374f0
#define mmGCVML2_PERFCOUNTER2_0_SELECT                                                                 0x3d3c
#define mmGCVML2_PERFCOUNTER2_0_SELECT_BASE_IDX                                                        1
#define mmGCVML2_PERFCOUNTER2_1_SELECT                                                                 0x3d3d
#define mmGCVML2_PERFCOUNTER2_1_SELECT_BASE_IDX                                                        1
#define mmGCVML2_PERFCOUNTER2_0_SELECT1                                                                0x3d3e
#define mmGCVML2_PERFCOUNTER2_0_SELECT1_BASE_IDX                                                       1
#define mmGCVML2_PERFCOUNTER2_1_SELECT1                                                                0x3d3f
#define mmGCVML2_PERFCOUNTER2_1_SELECT1_BASE_IDX                                                       1
#define mmGCVML2_PERFCOUNTER2_0_MODE                                                                   0x3d40
#define mmGCVML2_PERFCOUNTER2_0_MODE_BASE_IDX                                                          1
#define mmGCVML2_PERFCOUNTER2_1_MODE                                                                   0x3d41
#define mmGCVML2_PERFCOUNTER2_1_MODE_BASE_IDX                                                          1


// addressBlock: gc_sdma0_sdma0perfsdec
// base address: 0x37880
#define mmSDMA0_PERFCNT_PERFCOUNTER0_CFG                                                               0x3e20
#define mmSDMA0_PERFCNT_PERFCOUNTER0_CFG_BASE_IDX                                                      1
#define mmSDMA0_PERFCNT_PERFCOUNTER1_CFG                                                               0x3e21
#define mmSDMA0_PERFCNT_PERFCOUNTER1_CFG_BASE_IDX                                                      1
#define mmSDMA0_PERFCNT_PERFCOUNTER_RSLT_CNTL                                                          0x3e22
#define mmSDMA0_PERFCNT_PERFCOUNTER_RSLT_CNTL_BASE_IDX                                                 1
#define mmSDMA0_PERFCNT_MISC_CNTL                                                                      0x3e23
#define mmSDMA0_PERFCNT_MISC_CNTL_BASE_IDX                                                             1
#define mmSDMA0_PERFCOUNTER0_SELECT                                                                    0x3e24
#define mmSDMA0_PERFCOUNTER0_SELECT_BASE_IDX                                                           1
#define mmSDMA0_PERFCOUNTER0_SELECT1                                                                   0x3e25
#define mmSDMA0_PERFCOUNTER0_SELECT1_BASE_IDX                                                          1
#define mmSDMA0_PERFCOUNTER1_SELECT                                                                    0x3e26
#define mmSDMA0_PERFCOUNTER1_SELECT_BASE_IDX                                                           1
#define mmSDMA0_PERFCOUNTER1_SELECT1                                                                   0x3e27
#define mmSDMA0_PERFCOUNTER1_SELECT1_BASE_IDX                                                          1


// addressBlock: gc_sdma1_sdma1perfsdec
// base address: 0x378b0
#define mmSDMA1_PERFCNT_PERFCOUNTER0_CFG                                                               0x3e2c
#define mmSDMA1_PERFCNT_PERFCOUNTER0_CFG_BASE_IDX                                                      1
#define mmSDMA1_PERFCNT_PERFCOUNTER1_CFG                                                               0x3e2d
#define mmSDMA1_PERFCNT_PERFCOUNTER1_CFG_BASE_IDX                                                      1
#define mmSDMA1_PERFCNT_PERFCOUNTER_RSLT_CNTL                                                          0x3e2e
#define mmSDMA1_PERFCNT_PERFCOUNTER_RSLT_CNTL_BASE_IDX                                                 1
#define mmSDMA1_PERFCNT_MISC_CNTL                                                                      0x3e2f
#define mmSDMA1_PERFCNT_MISC_CNTL_BASE_IDX                                                             1
#define mmSDMA1_PERFCOUNTER0_SELECT                                                                    0x3e30
#define mmSDMA1_PERFCOUNTER0_SELECT_BASE_IDX                                                           1
#define mmSDMA1_PERFCOUNTER0_SELECT1                                                                   0x3e31
#define mmSDMA1_PERFCOUNTER0_SELECT1_BASE_IDX                                                          1
#define mmSDMA1_PERFCOUNTER1_SELECT                                                                    0x3e32
#define mmSDMA1_PERFCOUNTER1_SELECT_BASE_IDX                                                           1
#define mmSDMA1_PERFCOUNTER1_SELECT1                                                                   0x3e33
#define mmSDMA1_PERFCOUNTER1_SELECT1_BASE_IDX                                                          1


// addressBlock: gc_sdma2_sdma2perfsdec
// base address: 0x378e0
#define mmSDMA2_PERFCNT_PERFCOUNTER0_CFG                                                               0x3e38
#define mmSDMA2_PERFCNT_PERFCOUNTER0_CFG_BASE_IDX                                                      1
#define mmSDMA2_PERFCNT_PERFCOUNTER1_CFG                                                               0x3e39
#define mmSDMA2_PERFCNT_PERFCOUNTER1_CFG_BASE_IDX                                                      1
#define mmSDMA2_PERFCNT_PERFCOUNTER_RSLT_CNTL                                                          0x3e3a
#define mmSDMA2_PERFCNT_PERFCOUNTER_RSLT_CNTL_BASE_IDX                                                 1
#define mmSDMA2_PERFCNT_MISC_CNTL                                                                      0x3e3b
#define mmSDMA2_PERFCNT_MISC_CNTL_BASE_IDX                                                             1
#define mmSDMA2_PERFCOUNTER0_SELECT                                                                    0x3e3c
#define mmSDMA2_PERFCOUNTER0_SELECT_BASE_IDX                                                           1
#define mmSDMA2_PERFCOUNTER0_SELECT1                                                                   0x3e3d
#define mmSDMA2_PERFCOUNTER0_SELECT1_BASE_IDX                                                          1
#define mmSDMA2_PERFCOUNTER1_SELECT                                                                    0x3e3e
#define mmSDMA2_PERFCOUNTER1_SELECT_BASE_IDX                                                           1
#define mmSDMA2_PERFCOUNTER1_SELECT1                                                                   0x3e3f
#define mmSDMA2_PERFCOUNTER1_SELECT1_BASE_IDX                                                          1


// addressBlock: gc_sdma3_sdma3perfsdec
// base address: 0x37910
#define mmSDMA3_PERFCNT_PERFCOUNTER0_CFG                                                               0x3e44
#define mmSDMA3_PERFCNT_PERFCOUNTER0_CFG_BASE_IDX                                                      1
#define mmSDMA3_PERFCNT_PERFCOUNTER1_CFG                                                               0x3e45
#define mmSDMA3_PERFCNT_PERFCOUNTER1_CFG_BASE_IDX                                                      1
#define mmSDMA3_PERFCNT_PERFCOUNTER_RSLT_CNTL                                                          0x3e46
#define mmSDMA3_PERFCNT_PERFCOUNTER_RSLT_CNTL_BASE_IDX                                                 1
#define mmSDMA3_PERFCNT_MISC_CNTL                                                                      0x3e47
#define mmSDMA3_PERFCNT_MISC_CNTL_BASE_IDX                                                             1
#define mmSDMA3_PERFCOUNTER0_SELECT                                                                    0x3e48
#define mmSDMA3_PERFCOUNTER0_SELECT_BASE_IDX                                                           1
#define mmSDMA3_PERFCOUNTER0_SELECT1                                                                   0x3e49
#define mmSDMA3_PERFCOUNTER0_SELECT1_BASE_IDX                                                          1
#define mmSDMA3_PERFCOUNTER1_SELECT                                                                    0x3e4a
#define mmSDMA3_PERFCOUNTER1_SELECT_BASE_IDX                                                           1
#define mmSDMA3_PERFCOUNTER1_SELECT1                                                                   0x3e4b
#define mmSDMA3_PERFCOUNTER1_SELECT1_BASE_IDX                                                          1


// base address: 0x3a000


// addressBlock: gc_grtavfsdec
// base address: 0x3ac00
#define mmGRTAVFS_RTAVFS_REG_ADDR                                                                      0x4b00
#define mmGRTAVFS_RTAVFS_REG_ADDR_BASE_IDX                                                             1
#define mmRTAVFS_RTAVFS_REG_ADDR                                                                       0x4b00
#define mmRTAVFS_RTAVFS_REG_ADDR_BASE_IDX                                                              1
#define mmGRTAVFS_RTAVFS_WR_DATA                                                                       0x4b01
#define mmGRTAVFS_RTAVFS_WR_DATA_BASE_IDX                                                              1
#define mmRTAVFS_RTAVFS_WR_DATA                                                                        0x4b01
#define mmRTAVFS_RTAVFS_WR_DATA_BASE_IDX                                                               1
#define mmGRTAVFS_GENERAL_0                                                                            0x4b02
#define mmGRTAVFS_GENERAL_0_BASE_IDX                                                                   1
#define mmGRTAVFS_RTAVFS_RD_DATA                                                                       0x4b03
#define mmGRTAVFS_RTAVFS_RD_DATA_BASE_IDX                                                              1
#define mmGRTAVFS_RTAVFS_REG_CTRL                                                                      0x4b04
#define mmGRTAVFS_RTAVFS_REG_CTRL_BASE_IDX                                                             1
#define mmGRTAVFS_RTAVFS_REG_STATUS                                                                    0x4b05
#define mmGRTAVFS_RTAVFS_REG_STATUS_BASE_IDX                                                           1
#define mmGRTAVFS_TARG_FREQ                                                                            0x4b06
#define mmGRTAVFS_TARG_FREQ_BASE_IDX                                                                   1
#define mmGRTAVFS_TARG_VOLT                                                                            0x4b07
#define mmGRTAVFS_TARG_VOLT_BASE_IDX                                                                   1
#define mmGRTAVFS_SOFT_RESET                                                                           0x4b0f
#define mmGRTAVFS_SOFT_RESET_BASE_IDX                                                                  1
#define mmGRTAVFS_PSM_CNTL                                                                             0x4b10
#define mmGRTAVFS_PSM_CNTL_BASE_IDX                                                                    1
#define mmGRTAVFS_CLK_CNTL                                                                             0x4b11
#define mmGRTAVFS_CLK_CNTL_BASE_IDX                                                                    1


// addressBlock: gc_rlcdec
// base address: 0x3b000
#define mmRLC_CNTL                                                                                     0x4c00
#define mmRLC_CNTL_BASE_IDX                                                                            1
#define mmRLC_F32_UCODE_VERSION                                                                        0x4c03
#define mmRLC_F32_UCODE_VERSION_BASE_IDX                                                               1
#define mmRLC_STAT                                                                                     0x4c04
#define mmRLC_STAT_BASE_IDX                                                                            1
#define mmRLC_MEM_SLP_CNTL                                                                             0x4c06
#define mmRLC_MEM_SLP_CNTL_BASE_IDX                                                                    1
#define mmSMU_RLC_RESPONSE                                                                             0x4c07
#define mmSMU_RLC_RESPONSE_BASE_IDX                                                                    1
#define mmRLC_RLCV_SAFE_MODE                                                                           0x4c08
#define mmRLC_RLCV_SAFE_MODE_BASE_IDX                                                                  1
#define mmRLC_SMU_SAFE_MODE                                                                            0x4c09
#define mmRLC_SMU_SAFE_MODE_BASE_IDX                                                                   1
#define mmRLC_RLCV_COMMAND                                                                             0x4c0a
#define mmRLC_RLCV_COMMAND_BASE_IDX                                                                    1
#define mmRLC_REFCLOCK_TIMESTAMP_LSB                                                                   0x4c0c
#define mmRLC_REFCLOCK_TIMESTAMP_LSB_BASE_IDX                                                          1
#define mmRLC_REFCLOCK_TIMESTAMP_MSB                                                                   0x4c0d
#define mmRLC_REFCLOCK_TIMESTAMP_MSB_BASE_IDX                                                          1
#define mmRLC_GPM_TIMER_INT_0                                                                          0x4c0e
#define mmRLC_GPM_TIMER_INT_0_BASE_IDX                                                                 1
#define mmRLC_GPM_TIMER_INT_1                                                                          0x4c0f
#define mmRLC_GPM_TIMER_INT_1_BASE_IDX                                                                 1
#define mmRLC_GPM_TIMER_INT_2                                                                          0x4c10
#define mmRLC_GPM_TIMER_INT_2_BASE_IDX                                                                 1
#define mmRLC_GPM_TIMER_CTRL                                                                           0x4c11
#define mmRLC_GPM_TIMER_CTRL_BASE_IDX                                                                  1
#define mmRLC_LB_CNTR_MAX_1                                                                            0x4c12
#define mmRLC_LB_CNTR_MAX_1_BASE_IDX                                                                   1
#define mmRLC_GPM_TIMER_STAT                                                                           0x4c13
#define mmRLC_GPM_TIMER_STAT_BASE_IDX                                                                  1
#define mmRLC_GPM_TIMER_INT_3                                                                          0x4c15
#define mmRLC_GPM_TIMER_INT_3_BASE_IDX                                                                 1
#define mmRLC_GPM_LEGACY_INT_STAT                                                                      0x4c16
#define mmRLC_GPM_LEGACY_INT_STAT_BASE_IDX                                                             1
#define mmRLC_GPM_LEGACY_INT_CLEAR                                                                     0x4c17
#define mmRLC_GPM_LEGACY_INT_CLEAR_BASE_IDX                                                            1
#define mmRLC_INT_STAT                                                                                 0x4c18
#define mmRLC_INT_STAT_BASE_IDX                                                                        1
#define mmRLC_LB_CNTL                                                                                  0x4c19
#define mmRLC_LB_CNTL_BASE_IDX                                                                         1
#define mmRLC_MGCG_CTRL                                                                                0x4c1a
#define mmRLC_MGCG_CTRL_BASE_IDX                                                                       1
#define mmRLC_LB_CNTR_INIT_1                                                                           0x4c1b
#define mmRLC_LB_CNTR_INIT_1_BASE_IDX                                                                  1
#define mmRLC_LB_CNTR_1                                                                                0x4c1c
#define mmRLC_LB_CNTR_1_BASE_IDX                                                                       1
#define mmRLC_JUMP_TABLE_RESTORE                                                                       0x4c1e
#define mmRLC_JUMP_TABLE_RESTORE_BASE_IDX                                                              1
#define mmRLC_PG_DELAY_2                                                                               0x4c1f
#define mmRLC_PG_DELAY_2_BASE_IDX                                                                      1
#define mmRLC_GPU_CLOCK_COUNT_LSB                                                                      0x4c24
#define mmRLC_GPU_CLOCK_COUNT_LSB_BASE_IDX                                                             1
#define mmRLC_GPU_CLOCK_COUNT_MSB                                                                      0x4c25
#define mmRLC_GPU_CLOCK_COUNT_MSB_BASE_IDX                                                             1
#define mmRLC_CAPTURE_GPU_CLOCK_COUNT                                                                  0x4c26
#define mmRLC_CAPTURE_GPU_CLOCK_COUNT_BASE_IDX                                                         1
#define mmRLC_UCODE_CNTL                                                                               0x4c27
#define mmRLC_UCODE_CNTL_BASE_IDX                                                                      1
#define mmRLC_GPM_THREAD_RESET                                                                         0x4c28
#define mmRLC_GPM_THREAD_RESET_BASE_IDX                                                                1
#define mmRLC_GPM_CP_DMA_COMPLETE_T0                                                                   0x4c29
#define mmRLC_GPM_CP_DMA_COMPLETE_T0_BASE_IDX                                                          1
#define mmRLC_GPM_CP_DMA_COMPLETE_T1                                                                   0x4c2a
#define mmRLC_GPM_CP_DMA_COMPLETE_T1_BASE_IDX                                                          1
#define mmRLC_LB_CNTR_INIT_2                                                                           0x4c2b
#define mmRLC_LB_CNTR_INIT_2_BASE_IDX                                                                  1
#define mmRLC_LB_CNTR_MAX_2                                                                            0x4c2c
#define mmRLC_LB_CNTR_MAX_2_BASE_IDX                                                                   1
#define mmRLC_LB_CONFIG_5                                                                              0x4c2e
#define mmRLC_LB_CONFIG_5_BASE_IDX                                                                     1
#define mmRLC_GPM_TIMER_INT_4                                                                          0x4c2f
#define mmRLC_GPM_TIMER_INT_4_BASE_IDX                                                                 1
#define mmRLC_CLK_COUNT_GFXCLK_LSB                                                                     0x4c30
#define mmRLC_CLK_COUNT_GFXCLK_LSB_BASE_IDX                                                            1
#define mmRLC_CLK_COUNT_GFXCLK_MSB                                                                     0x4c31
#define mmRLC_CLK_COUNT_GFXCLK_MSB_BASE_IDX                                                            1
#define mmRLC_CLK_COUNT_REFCLK_LSB                                                                     0x4c32
#define mmRLC_CLK_COUNT_REFCLK_LSB_BASE_IDX                                                            1
#define mmRLC_CLK_COUNT_REFCLK_MSB                                                                     0x4c33
#define mmRLC_CLK_COUNT_REFCLK_MSB_BASE_IDX                                                            1
#define mmRLC_CLK_COUNT_CTRL                                                                           0x4c34
#define mmRLC_CLK_COUNT_CTRL_BASE_IDX                                                                  1
#define mmRLC_CLK_COUNT_STAT                                                                           0x4c35
#define mmRLC_CLK_COUNT_STAT_BASE_IDX                                                                  1
#define mmRLC_RLCG_DOORBELL_CNTL                                                                       0x4c36
#define mmRLC_RLCG_DOORBELL_CNTL_BASE_IDX                                                              1
#define mmRLC_RLCG_DOORBELL_STAT                                                                       0x4c37
#define mmRLC_RLCG_DOORBELL_STAT_BASE_IDX                                                              1
#define mmRLC_RLCG_DOORBELL_0_DATA_LO                                                                  0x4c38
#define mmRLC_RLCG_DOORBELL_0_DATA_LO_BASE_IDX                                                         1
#define mmRLC_RLCG_DOORBELL_0_DATA_HI                                                                  0x4c39
#define mmRLC_RLCG_DOORBELL_0_DATA_HI_BASE_IDX                                                         1
#define mmRLC_RLCG_DOORBELL_1_DATA_LO                                                                  0x4c3a
#define mmRLC_RLCG_DOORBELL_1_DATA_LO_BASE_IDX                                                         1
#define mmRLC_RLCG_DOORBELL_1_DATA_HI                                                                  0x4c3b
#define mmRLC_RLCG_DOORBELL_1_DATA_HI_BASE_IDX                                                         1
#define mmRLC_RLCG_DOORBELL_2_DATA_LO                                                                  0x4c3c
#define mmRLC_RLCG_DOORBELL_2_DATA_LO_BASE_IDX                                                         1
#define mmRLC_RLCG_DOORBELL_2_DATA_HI                                                                  0x4c3d
#define mmRLC_RLCG_DOORBELL_2_DATA_HI_BASE_IDX                                                         1
#define mmRLC_RLCG_DOORBELL_3_DATA_LO                                                                  0x4c3e
#define mmRLC_RLCG_DOORBELL_3_DATA_LO_BASE_IDX                                                         1
#define mmRLC_RLCG_DOORBELL_3_DATA_HI                                                                  0x4c3f
#define mmRLC_RLCG_DOORBELL_3_DATA_HI_BASE_IDX                                                         1
#define mmRLC_GPU_CLOCK_32_RES_SEL                                                                     0x4c41
#define mmRLC_GPU_CLOCK_32_RES_SEL_BASE_IDX                                                            1
#define mmRLC_GPU_CLOCK_32                                                                             0x4c42
#define mmRLC_GPU_CLOCK_32_BASE_IDX                                                                    1
#define mmRLC_PG_CNTL                                                                                  0x4c43
#define mmRLC_PG_CNTL_BASE_IDX                                                                         1
#define mmRLC_GPM_THREAD_PRIORITY                                                                      0x4c44
#define mmRLC_GPM_THREAD_PRIORITY_BASE_IDX                                                             1
#define mmRLC_GPM_THREAD_ENABLE                                                                        0x4c45
#define mmRLC_GPM_THREAD_ENABLE_BASE_IDX                                                               1
#define mmRLC_RLCG_DOORBELL_RANGE                                                                      0x4c47
#define mmRLC_RLCG_DOORBELL_RANGE_BASE_IDX                                                             1
#define mmRLC_CGCG_CGLS_CTRL                                                                           0x4c49
#define mmRLC_CGCG_CGLS_CTRL_BASE_IDX                                                                  1
#define mmRLC_CGCG_RAMP_CTRL                                                                           0x4c4a
#define mmRLC_CGCG_RAMP_CTRL_BASE_IDX                                                                  1
#define mmRLC_DYN_PG_STATUS                                                                            0x4c4b
#define mmRLC_DYN_PG_STATUS_BASE_IDX                                                                   1
#define mmRLC_DYN_PG_REQUEST                                                                           0x4c4c
#define mmRLC_DYN_PG_REQUEST_BASE_IDX                                                                  1
#define mmRLC_PG_DELAY                                                                                 0x4c4d
#define mmRLC_PG_DELAY_BASE_IDX                                                                        1
#define mmRLC_WGP_STATUS                                                                               0x4c4e
#define mmRLC_WGP_STATUS_BASE_IDX                                                                      1
#define mmRLC_LB_INIT_WGP_MASK                                                                         0x4c4f
#define mmRLC_LB_INIT_WGP_MASK_BASE_IDX                                                                1
#define mmRLC_LB_ALWAYS_ACTIVE_WGP_MASK                                                                0x4c50
#define mmRLC_LB_ALWAYS_ACTIVE_WGP_MASK_BASE_IDX                                                       1
#define mmRLC_LB_PARAMS                                                                                0x4c51
#define mmRLC_LB_PARAMS_BASE_IDX                                                                       1
#define mmRLC_LB_DELAY                                                                                 0x4c52
#define mmRLC_LB_DELAY_BASE_IDX                                                                        1
#define mmRLC_PG_ALWAYS_ON_WGP_MASK                                                                    0x4c53
#define mmRLC_PG_ALWAYS_ON_WGP_MASK_BASE_IDX                                                           1
#define mmRLC_MAX_PG_WGP                                                                               0x4c54
#define mmRLC_MAX_PG_WGP_BASE_IDX                                                                      1
#define mmRLC_AUTO_PG_CTRL                                                                             0x4c55
#define mmRLC_AUTO_PG_CTRL_BASE_IDX                                                                    1
#define mmRLC_SMU_GRBM_REG_SAVE_CTRL                                                                   0x4c56
#define mmRLC_SMU_GRBM_REG_SAVE_CTRL_BASE_IDX                                                          1
#define mmRLC_SERDES_RD_INDEX                                                                          0x4c59
#define mmRLC_SERDES_RD_INDEX_BASE_IDX                                                                 1
#define mmRLC_SERDES_RD_DATA_0                                                                         0x4c5a
#define mmRLC_SERDES_RD_DATA_0_BASE_IDX                                                                1
#define mmRLC_SERDES_RD_DATA_1                                                                         0x4c5b
#define mmRLC_SERDES_RD_DATA_1_BASE_IDX                                                                1
#define mmRLC_SERDES_RD_DATA_2                                                                         0x4c5c
#define mmRLC_SERDES_RD_DATA_2_BASE_IDX                                                                1
#define mmRLC_SERDES_RD_DATA_3                                                                         0x4c5d
#define mmRLC_SERDES_RD_DATA_3_BASE_IDX                                                                1
#define mmRLC_SERDES_MASK                                                                              0x4c5e
#define mmRLC_SERDES_MASK_BASE_IDX                                                                     1
#define mmRLC_SERDES_CTRL                                                                              0x4c5f
#define mmRLC_SERDES_CTRL_BASE_IDX                                                                     1
#define mmRLC_SERDES_DATA                                                                              0x4c60
#define mmRLC_SERDES_DATA_BASE_IDX                                                                     1
#define mmRLC_SERDES_BUSY                                                                              0x4c61
#define mmRLC_SERDES_BUSY_BASE_IDX                                                                     1
#define mmRLC_GPM_GENERAL_0                                                                            0x4c63
#define mmRLC_GPM_GENERAL_0_BASE_IDX                                                                   1
#define mmRLC_GPM_GENERAL_1                                                                            0x4c64
#define mmRLC_GPM_GENERAL_1_BASE_IDX                                                                   1
#define mmRLC_GPM_GENERAL_2                                                                            0x4c65
#define mmRLC_GPM_GENERAL_2_BASE_IDX                                                                   1
#define mmRLC_GPM_GENERAL_3                                                                            0x4c66
#define mmRLC_GPM_GENERAL_3_BASE_IDX                                                                   1
#define mmRLC_GPM_GENERAL_4                                                                            0x4c67
#define mmRLC_GPM_GENERAL_4_BASE_IDX                                                                   1
#define mmRLC_GPM_GENERAL_5                                                                            0x4c68
#define mmRLC_GPM_GENERAL_5_BASE_IDX                                                                   1
#define mmRLC_GPM_GENERAL_6                                                                            0x4c69
#define mmRLC_GPM_GENERAL_6_BASE_IDX                                                                   1
#define mmRLC_GPM_GENERAL_7                                                                            0x4c6a
#define mmRLC_GPM_GENERAL_7_BASE_IDX                                                                   1
#define mmRLC_STATIC_PG_STATUS                                                                         0x4c6e
#define mmRLC_STATIC_PG_STATUS_BASE_IDX                                                                1
#define mmRLC_SPM_INT_INFO_1                                                                           0x4c6f
#define mmRLC_SPM_INT_INFO_1_BASE_IDX                                                                  1
#define mmRLC_SPM_INT_INFO_2                                                                           0x4c70
#define mmRLC_SPM_INT_INFO_2_BASE_IDX                                                                  1
#define mmRLC_SPM_MC_CNTL                                                                              0x4c71
#define mmRLC_SPM_MC_CNTL_BASE_IDX                                                                     1
#define mmRLC_SPM_INT_CNTL                                                                             0x4c72
#define mmRLC_SPM_INT_CNTL_BASE_IDX                                                                    1
#define mmRLC_SPM_INT_STATUS                                                                           0x4c73
#define mmRLC_SPM_INT_STATUS_BASE_IDX                                                                  1
#define mmRLC_SMU_MESSAGE                                                                              0x4c76
#define mmRLC_SMU_MESSAGE_BASE_IDX                                                                     1
#define mmRLC_GPM_LOG_SIZE                                                                             0x4c77
#define mmRLC_GPM_LOG_SIZE_BASE_IDX                                                                    1
#define mmRLC_PG_DELAY_3                                                                               0x4c78
#define mmRLC_PG_DELAY_3_BASE_IDX                                                                      1
#define mmRLC_GPR_REG1                                                                                 0x4c79
#define mmRLC_GPR_REG1_BASE_IDX                                                                        1
#define mmRLC_GPR_REG2                                                                                 0x4c7a
#define mmRLC_GPR_REG2_BASE_IDX                                                                        1
#define mmRLC_GPM_LOG_CONT                                                                             0x4c7b
#define mmRLC_GPM_LOG_CONT_BASE_IDX                                                                    1
#define mmRLC_GPM_INT_DISABLE_TH0                                                                      0x4c7c
#define mmRLC_GPM_INT_DISABLE_TH0_BASE_IDX                                                             1
#define mmRLC_GPM_LEGACY_INT_DISABLE                                                                   0x4c7d
#define mmRLC_GPM_LEGACY_INT_DISABLE_BASE_IDX                                                          1
#define mmRLC_GPM_INT_FORCE_TH0                                                                        0x4c7e
#define mmRLC_GPM_INT_FORCE_TH0_BASE_IDX                                                               1
#define mmRLC_SRM_CNTL                                                                                 0x4c80
#define mmRLC_SRM_CNTL_BASE_IDX                                                                        1
#define mmRLC_SRM_GPM_COMMAND                                                                          0x4c87
#define mmRLC_SRM_GPM_COMMAND_BASE_IDX                                                                 1
#define mmRLC_SRM_GPM_COMMAND_STATUS                                                                   0x4c88
#define mmRLC_SRM_GPM_COMMAND_STATUS_BASE_IDX                                                          1
#define mmRLC_SRM_RLCV_COMMAND                                                                         0x4c89
#define mmRLC_SRM_RLCV_COMMAND_BASE_IDX                                                                1
#define mmRLC_SRM_RLCV_COMMAND_STATUS                                                                  0x4c8a
#define mmRLC_SRM_RLCV_COMMAND_STATUS_BASE_IDX                                                         1
#define mmRLC_SRM_INDEX_CNTL_ADDR_0                                                                    0x4c8b
#define mmRLC_SRM_INDEX_CNTL_ADDR_0_BASE_IDX                                                           1
#define mmRLC_SRM_INDEX_CNTL_ADDR_1                                                                    0x4c8c
#define mmRLC_SRM_INDEX_CNTL_ADDR_1_BASE_IDX                                                           1
#define mmRLC_SRM_INDEX_CNTL_ADDR_2                                                                    0x4c8d
#define mmRLC_SRM_INDEX_CNTL_ADDR_2_BASE_IDX                                                           1
#define mmRLC_SRM_INDEX_CNTL_ADDR_3                                                                    0x4c8e
#define mmRLC_SRM_INDEX_CNTL_ADDR_3_BASE_IDX                                                           1
#define mmRLC_SRM_INDEX_CNTL_ADDR_4                                                                    0x4c8f
#define mmRLC_SRM_INDEX_CNTL_ADDR_4_BASE_IDX                                                           1
#define mmRLC_SRM_INDEX_CNTL_ADDR_5                                                                    0x4c90
#define mmRLC_SRM_INDEX_CNTL_ADDR_5_BASE_IDX                                                           1
#define mmRLC_SRM_INDEX_CNTL_ADDR_6                                                                    0x4c91
#define mmRLC_SRM_INDEX_CNTL_ADDR_6_BASE_IDX                                                           1
#define mmRLC_SRM_INDEX_CNTL_ADDR_7                                                                    0x4c92
#define mmRLC_SRM_INDEX_CNTL_ADDR_7_BASE_IDX                                                           1
#define mmRLC_SRM_INDEX_CNTL_DATA_0                                                                    0x4c93
#define mmRLC_SRM_INDEX_CNTL_DATA_0_BASE_IDX                                                           1
#define mmRLC_SRM_INDEX_CNTL_DATA_1                                                                    0x4c94
#define mmRLC_SRM_INDEX_CNTL_DATA_1_BASE_IDX                                                           1
#define mmRLC_SRM_INDEX_CNTL_DATA_2                                                                    0x4c95
#define mmRLC_SRM_INDEX_CNTL_DATA_2_BASE_IDX                                                           1
#define mmRLC_SRM_INDEX_CNTL_DATA_3                                                                    0x4c96
#define mmRLC_SRM_INDEX_CNTL_DATA_3_BASE_IDX                                                           1
#define mmRLC_SRM_INDEX_CNTL_DATA_4                                                                    0x4c97
#define mmRLC_SRM_INDEX_CNTL_DATA_4_BASE_IDX                                                           1
#define mmRLC_SRM_INDEX_CNTL_DATA_5                                                                    0x4c98
#define mmRLC_SRM_INDEX_CNTL_DATA_5_BASE_IDX                                                           1
#define mmRLC_SRM_INDEX_CNTL_DATA_6                                                                    0x4c99
#define mmRLC_SRM_INDEX_CNTL_DATA_6_BASE_IDX                                                           1
#define mmRLC_SRM_INDEX_CNTL_DATA_7                                                                    0x4c9a
#define mmRLC_SRM_INDEX_CNTL_DATA_7_BASE_IDX                                                           1
#define mmRLC_SRM_STAT                                                                                 0x4c9b
#define mmRLC_SRM_STAT_BASE_IDX                                                                        1
#define mmRLC_SRM_GPM_ABORT                                                                            0x4c9c
#define mmRLC_SRM_GPM_ABORT_BASE_IDX                                                                   1
#define mmRLC_SPARE_INT_2                                                                              0x4c9d
#define mmRLC_SPARE_INT_2_BASE_IDX                                                                     1
#define mmRLC_RLCV_SPARE_INT_1                                                                         0x4c9e
#define mmRLC_RLCV_SPARE_INT_1_BASE_IDX                                                                1
#define mmRLC_PACE_SPARE_INT_1                                                                         0x4c9f
#define mmRLC_PACE_SPARE_INT_1_BASE_IDX                                                                1
#define mmRLC_SAFE_MODE                                                                                0x4ca0
#define mmRLC_SAFE_MODE_BASE_IDX                                                                       1
#define mmRLC_CP_SCHEDULERS                                                                            0x4ca1
#define mmRLC_CP_SCHEDULERS_BASE_IDX                                                                   1
#define mmRLC_CSIB_ADDR_LO                                                                             0x4ca2
#define mmRLC_CSIB_ADDR_LO_BASE_IDX                                                                    1
#define mmRLC_CSIB_ADDR_HI                                                                             0x4ca3
#define mmRLC_CSIB_ADDR_HI_BASE_IDX                                                                    1
#define mmRLC_CSIB_LENGTH                                                                              0x4ca4
#define mmRLC_CSIB_LENGTH_BASE_IDX                                                                     1
#define mmRLC_SPARE_INT_0                                                                              0x4ca5
#define mmRLC_SPARE_INT_0_BASE_IDX                                                                     1
#define mmRLC_CP_EOF_INT_CNT                                                                           0x4ca6
#define mmRLC_CP_EOF_INT_CNT_BASE_IDX                                                                  1
#define mmRLC_CP_EOF_INT                                                                               0x4ca7
#define mmRLC_CP_EOF_INT_BASE_IDX                                                                      1
#define mmRLC_SMU_COMMAND                                                                              0x4ca9
#define mmRLC_SMU_COMMAND_BASE_IDX                                                                     1
#define mmRLC_SMU_ARGUMENT_1                                                                           0x4cab
#define mmRLC_SMU_ARGUMENT_1_BASE_IDX                                                                  1
#define mmRLC_SMU_ARGUMENT_2                                                                           0x4cac
#define mmRLC_SMU_ARGUMENT_2_BASE_IDX                                                                  1
#define mmRLC_GPM_GENERAL_8                                                                            0x4cad
#define mmRLC_GPM_GENERAL_8_BASE_IDX                                                                   1
#define mmRLC_GPM_GENERAL_9                                                                            0x4cae
#define mmRLC_GPM_GENERAL_9_BASE_IDX                                                                   1
#define mmRLC_GPM_GENERAL_10                                                                           0x4caf
#define mmRLC_GPM_GENERAL_10_BASE_IDX                                                                  1
#define mmRLC_GPM_GENERAL_11                                                                           0x4cb0
#define mmRLC_GPM_GENERAL_11_BASE_IDX                                                                  1
#define mmRLC_GPM_GENERAL_12                                                                           0x4cb1
#define mmRLC_GPM_GENERAL_12_BASE_IDX                                                                  1
#define mmRLC_GPM_UTCL1_CNTL_0                                                                         0x4cb2
#define mmRLC_GPM_UTCL1_CNTL_0_BASE_IDX                                                                1
#define mmRLC_GPM_UTCL1_CNTL_1                                                                         0x4cb3
#define mmRLC_GPM_UTCL1_CNTL_1_BASE_IDX                                                                1
#define mmRLC_GPM_UTCL1_CNTL_2                                                                         0x4cb4
#define mmRLC_GPM_UTCL1_CNTL_2_BASE_IDX                                                                1
#define mmRLC_SPM_UTCL1_CNTL                                                                           0x4cb5
#define mmRLC_SPM_UTCL1_CNTL_BASE_IDX                                                                  1
#define mmRLC_UTCL1_STATUS_2                                                                           0x4cb6
#define mmRLC_UTCL1_STATUS_2_BASE_IDX                                                                  1
#define mmRLC_LB_CONFIG_2                                                                              0x4cb8
#define mmRLC_LB_CONFIG_2_BASE_IDX                                                                     1
#define mmRLC_LB_CONFIG_3                                                                              0x4cb9
#define mmRLC_LB_CONFIG_3_BASE_IDX                                                                     1
#define mmRLC_LB_CONFIG_4                                                                              0x4cba
#define mmRLC_LB_CONFIG_4_BASE_IDX                                                                     1
#define mmRLC_SPM_UTCL1_ERROR_1                                                                        0x4cbc
#define mmRLC_SPM_UTCL1_ERROR_1_BASE_IDX                                                               1
#define mmRLC_SPM_UTCL1_ERROR_2                                                                        0x4cbd
#define mmRLC_SPM_UTCL1_ERROR_2_BASE_IDX                                                               1
#define mmRLC_GPM_UTCL1_TH0_ERROR_1                                                                    0x4cbe
#define mmRLC_GPM_UTCL1_TH0_ERROR_1_BASE_IDX                                                           1
#define mmRLC_LB_CONFIG_1                                                                              0x4cbf
#define mmRLC_LB_CONFIG_1_BASE_IDX                                                                     1
#define mmRLC_GPM_UTCL1_TH0_ERROR_2                                                                    0x4cc0
#define mmRLC_GPM_UTCL1_TH0_ERROR_2_BASE_IDX                                                           1
#define mmRLC_GPM_UTCL1_TH1_ERROR_1                                                                    0x4cc1
#define mmRLC_GPM_UTCL1_TH1_ERROR_1_BASE_IDX                                                           1
#define mmRLC_GPM_UTCL1_TH1_ERROR_2                                                                    0x4cc2
#define mmRLC_GPM_UTCL1_TH1_ERROR_2_BASE_IDX                                                           1
#define mmRLC_GPM_UTCL1_TH2_ERROR_1                                                                    0x4cc3
#define mmRLC_GPM_UTCL1_TH2_ERROR_1_BASE_IDX                                                           1
#define mmRLC_GPM_UTCL1_TH2_ERROR_2                                                                    0x4cc4
#define mmRLC_GPM_UTCL1_TH2_ERROR_2_BASE_IDX                                                           1
#define mmRLC_CGCG_CGLS_CTRL_3D                                                                        0x4cc5
#define mmRLC_CGCG_CGLS_CTRL_3D_BASE_IDX                                                               1
#define mmRLC_CGCG_RAMP_CTRL_3D                                                                        0x4cc6
#define mmRLC_CGCG_RAMP_CTRL_3D_BASE_IDX                                                               1
#define mmRLC_SEMAPHORE_0                                                                              0x4cc7
#define mmRLC_SEMAPHORE_0_BASE_IDX                                                                     1
#define mmRLC_SEMAPHORE_1                                                                              0x4cc8
#define mmRLC_SEMAPHORE_1_BASE_IDX                                                                     1
#define mmRLC_PACE_INT_STAT                                                                            0x4ccc
#define mmRLC_PACE_INT_STAT_BASE_IDX                                                                   1
#define mmRLC_PREWALKER_UTCL1_CNTL                                                                     0x4ccd
#define mmRLC_PREWALKER_UTCL1_CNTL_BASE_IDX                                                            1
#define mmRLC_PREWALKER_UTCL1_TRIG                                                                     0x4cce
#define mmRLC_PREWALKER_UTCL1_TRIG_BASE_IDX                                                            1
#define mmRLC_PREWALKER_UTCL1_ADDR_LSB                                                                 0x4ccf
#define mmRLC_PREWALKER_UTCL1_ADDR_LSB_BASE_IDX                                                        1
#define mmRLC_PREWALKER_UTCL1_ADDR_MSB                                                                 0x4cd0
#define mmRLC_PREWALKER_UTCL1_ADDR_MSB_BASE_IDX                                                        1
#define mmRLC_PREWALKER_UTCL1_SIZE_LSB                                                                 0x4cd1
#define mmRLC_PREWALKER_UTCL1_SIZE_LSB_BASE_IDX                                                        1
#define mmRLC_PREWALKER_UTCL1_SIZE_MSB                                                                 0x4cd2
#define mmRLC_PREWALKER_UTCL1_SIZE_MSB_BASE_IDX                                                        1
#define mmRLC_UTCL1_STATUS                                                                             0x4cd4
#define mmRLC_UTCL1_STATUS_BASE_IDX                                                                    1
#define mmRLC_R2I_CNTL_0                                                                               0x4cd5
#define mmRLC_R2I_CNTL_0_BASE_IDX                                                                      1
#define mmRLC_R2I_CNTL_1                                                                               0x4cd6
#define mmRLC_R2I_CNTL_1_BASE_IDX                                                                      1
#define mmRLC_R2I_CNTL_2                                                                               0x4cd7
#define mmRLC_R2I_CNTL_2_BASE_IDX                                                                      1
#define mmRLC_R2I_CNTL_3                                                                               0x4cd8
#define mmRLC_R2I_CNTL_3_BASE_IDX                                                                      1
#define mmRLC_LB_WGP_STAT                                                                              0x4cda
#define mmRLC_LB_WGP_STAT_BASE_IDX                                                                     1
#define mmRLC_GPM_INT_STAT_TH0                                                                         0x4cdc
#define mmRLC_GPM_INT_STAT_TH0_BASE_IDX                                                                1
#define mmRLC_GPM_GENERAL_13                                                                           0x4cdd
#define mmRLC_GPM_GENERAL_13_BASE_IDX                                                                  1
#define mmRLC_GPM_GENERAL_14                                                                           0x4cde
#define mmRLC_GPM_GENERAL_14_BASE_IDX                                                                  1
#define mmRLC_GPM_GENERAL_15                                                                           0x4cdf
#define mmRLC_GPM_GENERAL_15_BASE_IDX                                                                  1
#define mmRLC_SPARE_INT_1                                                                              0x4ce0
#define mmRLC_SPARE_INT_1_BASE_IDX                                                                     1
#define mmRLC_SEMAPHORE_2                                                                              0x4ce3
#define mmRLC_SEMAPHORE_2_BASE_IDX                                                                     1
#define mmRLC_SEMAPHORE_3                                                                              0x4ce4
#define mmRLC_SEMAPHORE_3_BASE_IDX                                                                     1
#define mmRLC_SMU_ARGUMENT_3                                                                           0x4ce5
#define mmRLC_SMU_ARGUMENT_3_BASE_IDX                                                                  1
#define mmRLC_SMU_ARGUMENT_4                                                                           0x4ce6
#define mmRLC_SMU_ARGUMENT_4_BASE_IDX                                                                  1
#define mmRLC_GPU_CLOCK_COUNT_LSB_1                                                                    0x4ce8
#define mmRLC_GPU_CLOCK_COUNT_LSB_1_BASE_IDX                                                           1
#define mmRLC_GPU_CLOCK_COUNT_MSB_1                                                                    0x4ce9
#define mmRLC_GPU_CLOCK_COUNT_MSB_1_BASE_IDX                                                           1
#define mmRLC_CAPTURE_GPU_CLOCK_COUNT_1                                                                0x4cea
#define mmRLC_CAPTURE_GPU_CLOCK_COUNT_1_BASE_IDX                                                       1
#define mmRLC_GPU_CLOCK_COUNT_LSB_2                                                                    0x4ceb
#define mmRLC_GPU_CLOCK_COUNT_LSB_2_BASE_IDX                                                           1
#define mmRLC_GPU_CLOCK_COUNT_MSB_2                                                                    0x4cec
#define mmRLC_GPU_CLOCK_COUNT_MSB_2_BASE_IDX                                                           1
#define mmRLC_PACE_INT_DISABLE                                                                         0x4ced
#define mmRLC_PACE_INT_DISABLE_BASE_IDX                                                                1
#define mmRLC_CAPTURE_GPU_CLOCK_COUNT_2                                                                0x4cef
#define mmRLC_CAPTURE_GPU_CLOCK_COUNT_2_BASE_IDX                                                       1
#define mmRLC_RLCV_DOORBELL_RANGE                                                                      0x4cf0
#define mmRLC_RLCV_DOORBELL_RANGE_BASE_IDX                                                             1
#define mmRLC_RLCV_DOORBELL_CNTL                                                                       0x4cf1
#define mmRLC_RLCV_DOORBELL_CNTL_BASE_IDX                                                              1
#define mmRLC_RLCV_DOORBELL_STAT                                                                       0x4cf2
#define mmRLC_RLCV_DOORBELL_STAT_BASE_IDX                                                              1
#define mmRLC_RLCV_DOORBELL_0_DATA_LO                                                                  0x4cf3
#define mmRLC_RLCV_DOORBELL_0_DATA_LO_BASE_IDX                                                         1
#define mmRLC_RLCV_DOORBELL_0_DATA_HI                                                                  0x4cf4
#define mmRLC_RLCV_DOORBELL_0_DATA_HI_BASE_IDX                                                         1
#define mmRLC_RLCV_DOORBELL_1_DATA_LO                                                                  0x4cf5
#define mmRLC_RLCV_DOORBELL_1_DATA_LO_BASE_IDX                                                         1
#define mmRLC_RLCV_DOORBELL_1_DATA_HI                                                                  0x4cf6
#define mmRLC_RLCV_DOORBELL_1_DATA_HI_BASE_IDX                                                         1
#define mmRLC_RLCV_DOORBELL_2_DATA_LO                                                                  0x4cf7
#define mmRLC_RLCV_DOORBELL_2_DATA_LO_BASE_IDX                                                         1
#define mmRLC_RLCV_DOORBELL_2_DATA_HI                                                                  0x4cf8
#define mmRLC_RLCV_DOORBELL_2_DATA_HI_BASE_IDX                                                         1
#define mmRLC_RLCV_DOORBELL_3_DATA_LO                                                                  0x4cf9
#define mmRLC_RLCV_DOORBELL_3_DATA_LO_BASE_IDX                                                         1
#define mmRLC_RLCV_DOORBELL_3_DATA_HI                                                                  0x4cfa
#define mmRLC_RLCV_DOORBELL_3_DATA_HI_BASE_IDX                                                         1
#define mmRLC_RLCV_SPARE_INT                                                                           0x4d00
#define mmRLC_RLCV_SPARE_INT_BASE_IDX                                                                  1
#define mmRLC_PACE_TIMER_INT_0                                                                         0x4d04
#define mmRLC_PACE_TIMER_INT_0_BASE_IDX                                                                1
#define mmRLC_PACE_TIMER_CTRL                                                                          0x4d05
#define mmRLC_PACE_TIMER_CTRL_BASE_IDX                                                                 1
#define mmRLC_PACE_TIMER_INT_1                                                                         0x4d06
#define mmRLC_PACE_TIMER_INT_1_BASE_IDX                                                                1
#define mmRLC_PACE_SPARE_INT                                                                           0x4d07
#define mmRLC_PACE_SPARE_INT_BASE_IDX                                                                  1
#define mmRLC_SMU_CLK_REQ                                                                              0x4d08
#define mmRLC_SMU_CLK_REQ_BASE_IDX                                                                     1
#define mmRLC_CP_STAT_INVAL_STAT                                                                       0x4d09
#define mmRLC_CP_STAT_INVAL_STAT_BASE_IDX                                                              1
#define mmRLC_CP_STAT_INVAL_CTRL                                                                       0x4d0a
#define mmRLC_CP_STAT_INVAL_CTRL_BASE_IDX                                                              1
#define mmRLC_CLK_STATUS                                                                               0x4d0b
#define mmRLC_CLK_STATUS_BASE_IDX                                                                      1
#define mmRLC_SPP_CTRL                                                                                 0x4d0c
#define mmRLC_SPP_CTRL_BASE_IDX                                                                        1
#define mmRLC_SPP_SHADER_PROFILE_EN                                                                    0x4d0d
#define mmRLC_SPP_SHADER_PROFILE_EN_BASE_IDX                                                           1
#define mmRLC_SPP_SSF_CAPTURE_EN                                                                       0x4d0e
#define mmRLC_SPP_SSF_CAPTURE_EN_BASE_IDX                                                              1
#define mmRLC_SPP_SSF_