/* SPDX-License-Identifier: BSD-3-Clause */
/* Copyright (C) 2022 Microchip Technology Inc. and its subsidiaries.
 * Microchip VCAP API
 */

/* This file is autogenerated by cml-utils 2022-10-13 10:04:41 +0200.
 * Commit ID: fd7cafd175899f0672c73afb3a30fc872500ae86
 */

#ifndef __VCAP_AG_API__
#define __VCAP_AG_API__

enum vcap_type {
	VCAP_TYPE_IS2,
	VCAP_TYPE_MAX
};

/* Keyfieldset names with origin information */
enum vcap_keyfield_set {
	VCAP_KFS_NO_VALUE,          /* initial value */
	VCAP_KFS_ARP,               /* sparx5 is2 X6 */
	VCAP_KFS_IP4_OTHER,         /* sparx5 is2 X6 */
	VCAP_KFS_IP4_TCP_UDP,       /* sparx5 is2 X6 */
	VCAP_KFS_IP6_STD,           /* sparx5 is2 X6 */
	VCAP_KFS_IP_7TUPLE,         /* sparx5 is2 X12 */
	VCAP_KFS_MAC_ETYPE,         /* sparx5 is2 X6 */
};

/* List of keyfields with description
 *
 * Keys ending in _IS are booleans derived from frame data
 * Keys ending in _CLS are classified frame data
 *
 * VCAP_KF_8021Q_DEI_CLS: W1, sparx5: is2
 *   Classified DEI
 * VCAP_KF_8021Q_PCP_CLS: W3, sparx5: is2
 *   Classified PCP
 * VCAP_KF_8021Q_VID_CLS: W13, sparx5: is2
 *   Classified VID
 * VCAP_KF_8021Q_VLAN_TAGGED_IS: W1, sparx5: is2
 *   Sparx5: Set if frame was received with a VLAN tag, LAN966x: Set if frame has
 *   one or more Q-tags. Independent of port VLAN awareness
 * VCAP_KF_ARP_ADDR_SPACE_OK_IS: W1, sparx5: is2
 *   Set if hardware address is Ethernet
 * VCAP_KF_ARP_LEN_OK_IS: W1, sparx5: is2
 *   Set if hardware address length = 6 (Ethernet) and IP address length = 4 (IP).
 * VCAP_KF_ARP_OPCODE: W2, sparx5: is2
 *   ARP opcode
 * VCAP_KF_ARP_OPCODE_UNKNOWN_IS: W1, sparx5: is2
 *   Set if not one of the codes defined in VCAP_KF_ARP_OPCODE
 * VCAP_KF_ARP_PROTO_SPACE_OK_IS: W1, sparx5: is2
 *   Set if protocol address space is 0x0800
 * VCAP_KF_ARP_SENDER_MATCH_IS: W1, sparx5: is2
 *   Sender Hardware Address = SMAC (ARP)
 * VCAP_KF_ARP_TGT_MATCH_IS: W1, sparx5: is2
 *   Target Hardware Address = SMAC (RARP)
 * VCAP_KF_ETYPE: W16, sparx5: is2
 *   Ethernet type
 * VCAP_KF_ETYPE_LEN_IS: W1, sparx5: is2
 *   Set if frame has EtherType >= 0x600
 * VCAP_KF_IF_IGR_PORT_MASK: sparx5 is2 W32, sparx5 is2 W65
 *   Ingress port mask, one bit per port/erleg
 * VCAP_KF_IF_IGR_PORT_MASK_L3: W1, sparx5: is2
 *   If set, IF_IGR_PORT_MASK, IF_IGR_PORT_MASK_RNG, and IF_IGR_PORT_MASK_SEL are
 *   used to specify L3 interfaces
 * VCAP_KF_IF_IGR_PORT_MASK_RNG: W4, sparx5: is2
 *   Range selector for IF_IGR_PORT_MASK.  Specifies which group of 32 ports are
 *   available in IF_IGR_PORT_MASK
 * VCAP_KF_IF_IGR_PORT_MASK_SEL: W2, sparx5: is2
 *   Mode selector for IF_IGR_PORT_MASK, applicable when IF_IGR_PORT_MASK_L3 == 0.
 *   Mapping: 0: DEFAULT 1: LOOPBACK 2: MASQUERADE 3: CPU_VD
 * VCAP_KF_IP4_IS: W1, sparx5: is2
 *   Set if frame has EtherType = 0x800 and IP version = 4
 * VCAP_KF_ISDX_CLS: W12, sparx5: is2
 *   Classified ISDX
 * VCAP_KF_ISDX_GT0_IS: W1, sparx5: is2
 *   Set if classified ISDX > 0
 * VCAP_KF_L2_BC_IS: W1, sparx5: is2
 *   Set if frame’s destination MAC address is the broadcast address
 *   (FF-FF-FF-FF-FF-FF).
 * VCAP_KF_L2_DMAC: W48, sparx5: is2
 *   Destination MAC address
 * VCAP_KF_L2_FWD_IS: W1, sparx5: is2
 *   Set if the frame is allowed to be forwarded to front ports
 * VCAP_KF_L2_MC_IS: W1, sparx5: is2
 *   Set if frame’s destination MAC address is a multicast address (bit 40 = 1).
 * VCAP_KF_L2_PAYLOAD_ETYPE: W64, sparx5: is2
 *   Byte 0-7 of L2 payload after Type/Len field and overloading for OAM
 * VCAP_KF_L2_SMAC: W48, sparx5: is2
 *   Source MAC address
 * VCAP_KF_L3_DIP_EQ_SIP_IS: W1, sparx5: is2
 *   Set if Src IP matches Dst IP address
 * VCAP_KF_L3_DST_IS: W1, sparx5: is2
 *   Set if lookup is done for egress router leg
 * VCAP_KF_L3_FRAGMENT_TYPE: W2, sparx5: is2
 *   L3 Fragmentation type (none, initial, suspicious, valid follow up)
 * VCAP_KF_L3_FRAG_INVLD_L4_LEN: W1, sparx5: is2
 *   Set if frame's L4 length is less than ANA_CL:COMMON:CLM_FRAGMENT_CFG.L4_MIN_L
 *   EN
 * VCAP_KF_L3_IP4_DIP: W32, sparx5: is2
 *   Destination IPv4 Address
 * VCAP_KF_L3_IP4_SIP: W32, sparx5: is2
 *   Source IPv4 Address
 * VCAP_KF_L3_IP6_DIP: W128, sparx5: is2
 *   Sparx5: Full IPv6 DIP, LAN966x: Either Full IPv6 DIP or a subset depending on
 *   frame type
 * VCAP_KF_L3_IP6_SIP: W128, sparx5: is2
 *   Sparx5: Full IPv6 SIP, LAN966x: Either Full IPv6 SIP or a subset depending on
 *   frame type
 * VCAP_KF_L3_IP_PROTO: W8, sparx5: is2
 *   IPv4 frames: IP protocol. IPv6 frames: Next header, same as for IPV4
 * VCAP_KF_L3_OPTIONS_IS: W1, sparx5: is2
 *   Set if IPv4 frame contains options (IP len > 5)
 * VCAP_KF_L3_PAYLOAD: sparx5 is2 W96, sparx5 is2 W40
 *   Sparx5: Payload bytes after IP header. IPv4: IPv4 options are not parsed so
 *   payload is always taken 20 bytes after the start of the IPv4 header, LAN966x:
 *   Bytes 0-6 after IP header
 * VCAP_KF_L3_RT_IS: W1, sparx5: is2
 *   Set if frame has hit a router leg
 * VCAP_KF_L3_TOS: W8, sparx5: is2
 *   Sparx5: Frame's IPv4/IPv6 DSCP and ECN fields, LAN966x: IP TOS field
 * VCAP_KF_L3_TTL_GT0: W1, sparx5: is2
 *   Set if IPv4 TTL / IPv6 hop limit is greater than 0
 * VCAP_KF_L4_ACK: W1, sparx5: is2
 *   Sparx5 and LAN966x: TCP flag ACK, LAN966x only: PTP over UDP: flagField bit 2
 *   (unicastFlag)
 * VCAP_KF_L4_DPORT: W16, sparx5: is2
 *   Sparx5: TCP/UDP destination port. Overloading for IP_7TUPLE: Non-TCP/UDP IP
 *   frames: L4_DPORT = L3_IP_PROTO, LAN966x: TCP/UDP destination port
 * VCAP_KF_L4_FIN: W1, sparx5: is2
 *   TCP flag FIN, LAN966x: TCP flag FIN, and for PTP over UDP: messageType bit 1
 * VCAP_KF_L4_PAYLOAD: W64, sparx5: is2
 *   Payload bytes after TCP/UDP header Overloading for IP_7TUPLE: Non TCP/UDP
 *   frames: Payload bytes 0–7 after IP header. IPv4 options are not parsed so
 *   payload is always taken 20 bytes after the start of the IPv4 header for non
 *   TCP/UDP IPv4 frames
 * VCAP_KF_L4_PSH: W1, sparx5: is2
 *   Sparx5: TCP flag PSH, LAN966x: TCP: TCP flag PSH. PTP over UDP: flagField bit
 *   1 (twoStepFlag)
 * VCAP_KF_L4_RNG: W16, sparx5: is2
 *   Range checker bitmask (one for each range checker). Input into range checkers
 *   is taken from classified results (VID, DSCP) and frame (SPORT, DPORT, ETYPE,
 *   outer VID, inner VID)
 * VCAP_KF_L4_RST: W1, sparx5: is2
 *   Sparx5: TCP flag RST , LAN966x: TCP: TCP flag RST. PTP over UDP: messageType
 *   bit 3
 * VCAP_KF_L4_SEQUENCE_EQ0_IS: W1, sparx5: is2
 *   Set if TCP sequence number is 0, LAN966x: Overlayed with PTP over UDP:
 *   messageType bit 0
 * VCAP_KF_L4_SPORT: W16, sparx5: is2
 *   TCP/UDP source port
 * VCAP_KF_L4_SPORT_EQ_DPORT_IS: W1, sparx5: is2
 *   Set if UDP or TCP source port equals UDP or TCP destination port
 * VCAP_KF_L4_SYN: W1, sparx5: is2
 *   Sparx5: TCP flag SYN, LAN966x: TCP: TCP flag SYN. PTP over UDP: messageType
 *   bit 2
 * VCAP_KF_L4_URG: W1, sparx5: is2
 *   Sparx5: TCP flag URG, LAN966x: TCP: TCP flag URG. PTP over UDP: flagField bit
 *   7 (reserved)
 * VCAP_KF_LOOKUP_FIRST_IS: W1, sparx5: is2
 *   Selects between entries relevant for first and second lookup. Set for first
 *   lookup, cleared for second lookup.
 * VCAP_KF_LOOKUP_PAG: W8, sparx5: is2
 *   Classified Policy Association Group: chains rules from IS1/CLM to IS2
 * VCAP_KF_OAM_CCM_CNTS_EQ0: W1, sparx5: is2
 *   Dual-ended loss measurement counters in CCM frames are all zero
 * VCAP_KF_OAM_Y1731_IS: W1, sparx5: is2
 *   Set if frame’s EtherType = 0x8902
 * VCAP_KF_TCP_IS: W1, sparx5: is2
 *   Set if frame is IPv4 TCP frame (IP protocol = 6) or IPv6 TCP frames (Next
 *   header = 6)
 * VCAP_KF_TCP_UDP_IS: W1, sparx5: is2
 *   Set if frame is IPv4/IPv6 TCP or UDP frame (IP protocol/next header equals 6
 *   or 17)
 * VCAP_KF_TYPE: sparx5 is2 W4, sparx5 is2 W2
 *   Keyset type id - set by the API
 */

/* Keyfield names */
enum vcap_key_field {
	VCAP_KF_NO_VALUE,  /* initial value */
	VCAP_KF_8021Q_DEI_CLS,
	VCAP_KF_8021Q_PCP_CLS,
	VCAP_KF_8021Q_VID_CLS,
	VCAP_KF_8021Q_VLAN_TAGGED_IS,
	VCAP_KF_ARP_ADDR_SPACE_OK_IS,
	VCAP_KF_ARP_LEN_OK_IS,
	VCAP_KF_ARP_OPCODE,
	VCAP_KF_ARP_OPCODE_UNKNOWN_IS,
	VCAP_KF_ARP_PROTO_SPACE_OK_IS,
	VCAP_KF_ARP_SENDER_MATCH_IS,
	VCAP_KF_ARP_TGT_MATCH_IS,
	VCAP_KF_ETYPE,
	VCAP_KF_ETYPE_LEN_IS,
	VCAP_KF_IF_IGR_PORT_MASK,
	VCAP_KF_IF_IGR_PORT_MASK_L3,
	VCAP_KF_IF_IGR_PORT_MASK_RNG,
	VCAP_KF_IF_IGR_PORT_MASK_SEL,
	VCAP_KF_IP4_IS,
	VCAP_KF_ISDX_CLS,
	VCAP_KF_ISDX_GT0_IS,
	VCAP_KF_L2_BC_IS,
	VCAP_KF_L2_DMAC,
	VCAP_KF_L2_FWD_IS,
	VCAP_KF_L2_MC_IS,
	VCAP_KF_L2_PAYLOAD_ETYPE,
	VCAP_KF_L2_SMAC,
	VCAP_KF_L3_DIP_EQ_SIP_IS,
	VCAP_KF_L3_DST_IS,
	VCAP_KF_L3_FRAGMENT_TYPE,
	VCAP_KF_L3_FRAG_INVLD_L4_LEN,
	VCAP_KF_L3_IP4_DIP,
	VCAP_KF_L3_IP4_SIP,
	VCAP_KF_L3_IP6_DIP,
	VCAP_KF_L3_IP6_SIP,
	VCAP_KF_L3_IP_PROTO,
	VCAP_KF_L3_OPTIONS_IS,
	VCAP_KF_L3_PAYLOAD,
	VCAP_KF_L3_RT_IS,
	VCAP_KF_L3_TOS,
	VCAP_KF_L3_TTL_GT0,
	VCAP_KF_L4_ACK,
	VCAP_KF_L4_DPORT,
	VCAP_KF_L4_FIN,
	VCAP_KF_L4_PAYLOAD,
	VCAP_KF_L4_PSH,
	VCAP_KF_L4_RNG,
	VCAP_KF_L4_RST,
	VCAP_KF_L4_SEQUENCE_EQ0_IS,
	VCAP_KF_L4_SPORT,
	VCAP_KF_L4_SPORT_EQ_DPORT_IS,
	VCAP_KF_L4_SYN,
	VCAP_KF_L4_URG,
	VCAP_KF_LOOKUP_FIRST_IS,
	VCAP_KF_LOOKUP_PAG,
	VCAP_KF_OAM_CCM_CNTS_EQ0,
	VCAP_KF_OAM_Y1731_IS,
	VCAP_KF_TCP_IS,
	VCAP_KF_TCP_UDP_IS,
	VCAP_KF_TYPE,
};

/* Actionset names with origin information */
enum vcap_actionfield_set {
	VCAP_AFS_NO_VALUE,          /* initial value */
	VCAP_AFS_BASE_TYPE,         /* sparx5 is2 X3 */
};

/* List of actionfields with description
 *
 * VCAP_AF_CNT_ID: W12, sparx5: is2
 *   Counter ID, used per lookup to index the 4K frame counters (ANA_ACL:CNT_TBL).
 *   Multiple VCAP IS2 entries can use the same counter.
 * VCAP_AF_CPU_COPY_ENA: W1, sparx5: is2
 *   Setting this bit to 1 causes all frames that hit this action to be copied to
 *   the CPU extraction queue specified in CPU_QUEUE_NUM.
 * VCAP_AF_CPU_QUEUE_NUM: W3, sparx5: is2
 *   CPU queue number. Used when CPU_COPY_ENA is set.
 * VCAP_AF_HIT_ME_ONCE: W1, sparx5: is2
 *   Setting this bit to 1 causes the first frame that hits this action where the
 *   HIT_CNT counter is zero to be copied to the CPU extraction queue specified in
 *   CPU_QUEUE_NUM. The HIT_CNT counter is then incremented and any frames that
 *   hit this action later are not copied to the CPU. To re-enable the HIT_ME_ONCE
 *   functionality, the HIT_CNT counter must be cleared.
 * VCAP_AF_IGNORE_PIPELINE_CTRL: W1, sparx5: is2
 *   Ignore ingress pipeline control. This enforces the use of the VCAP IS2 action
 *   even when the pipeline control has terminated the frame before VCAP IS2.
 * VCAP_AF_INTR_ENA: W1, sparx5: is2
 *   If set, an interrupt is triggered when this rule is hit
 * VCAP_AF_LRN_DIS: W1, sparx5: is2
 *   Setting this bit to 1 disables learning of frames hitting this action.
 * VCAP_AF_MASK_MODE: W3, sparx5: is2
 *   Controls the PORT_MASK use. Sparx5: 0: OR_DSTMASK, 1: AND_VLANMASK, 2:
 *   REPLACE_PGID, 3: REPLACE_ALL, 4: REDIR_PGID, 5: OR_PGID_MASK, 6: VSTAX, 7:
 *   Not applicable. LAN966X: 0: No action, 1: Permit/deny (AND), 2: Policy
 *   forwarding (DMAC lookup), 3: Redirect. The CPU port is untouched by
 *   MASK_MODE.
 * VCAP_AF_MATCH_ID: W16, sparx5: is2
 *   Logical ID for the entry. The MATCH_ID is extracted together with the frame
 *   if the frame is forwarded to the CPU (CPU_COPY_ENA). The result is placed in
 *   IFH.CL_RSLT.
 * VCAP_AF_MATCH_ID_MASK: W16, sparx5: is2
 *   Mask used by MATCH_ID.
 * VCAP_AF_MIRROR_PROBE: W2, sparx5: is2
 *   Mirroring performed according to configuration of a mirror probe. 0: No
 *   mirroring. 1: Mirror probe 0. 2: Mirror probe 1. 3: Mirror probe 2
 * VCAP_AF_PIPELINE_FORCE_ENA: W1, sparx5: is2
 *   If set, use PIPELINE_PT unconditionally and set PIPELINE_ACT = NONE if
 *   PIPELINE_PT == NONE. Overrules previous settings of pipeline point.
 * VCAP_AF_PIPELINE_PT: W5, sparx5: is2
 *   Pipeline point used if PIPELINE_FORCE_ENA is set
 * VCAP_AF_POLICE_ENA: W1, sparx5: is2
 *   Setting this bit to 1 causes frames that hit this action to be policed by the
 *   ACL policer specified in POLICE_IDX. Only applies to the first lookup.
 * VCAP_AF_POLICE_IDX: W6, sparx5: is2
 *   Selects VCAP policer used when policing frames (POLICE_ENA)
 * VCAP_AF_PORT_MASK: W68, sparx5: is2
 *   Port mask applied to the forwarding decision based on MASK_MODE.
 * VCAP_AF_RT_DIS: W1, sparx5: is2
 *   If set, routing is disallowed. Only applies when IS_INNER_ACL is 0. See also
 *   IGR_ACL_ENA, EGR_ACL_ENA, and RLEG_STAT_IDX.
 */

/* Actionfield names */
enum vcap_action_field {
	VCAP_AF_NO_VALUE,  /* initial value */
	VCAP_AF_CNT_ID,
	VCAP_AF_CPU_COPY_ENA,
	VCAP_AF_CPU_QUEUE_NUM,
	VCAP_AF_HIT_ME_ONCE,
	VCAP_AF_IGNORE_PIPELINE_CTRL,
	VCAP_AF_INTR_ENA,
	VCAP_AF_LRN_DIS,
	VCAP_AF_MASK_MODE,
	VCAP_AF_MATCH_ID,
	VCAP_AF_MATCH_ID_MASK,
	VCAP_AF_MIRROR_PROBE,
	VCAP_AF_PIPELINE_FORCE_ENA,
	VCAP_AF_PIPELINE_PT,
	VCAP_AF_POLICE_ENA,
	VCAP_AF_POLICE_IDX,
	VCAP_AF_PORT_MASK,
	VCAP_AF_RT_DIS,
};

#endif /* __VCAP_AG_API__ */
