/*
 * Copyright (c) 2016-2017 Hisilicon Limited.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#ifndef _HNS_ROCE_HW_V2_H
#define _HNS_ROCE_HW_V2_H

#include <linux/bitops.h>

#define HNS_ROCE_V2_MAX_QP_NUM			0x1000
#define HNS_ROCE_V2_MAX_QPC_TIMER_NUM		0x200
#define HNS_ROCE_V2_MAX_WQE_NUM			0x8000
#define HNS_ROCE_V2_MAX_SRQ_WR			0x8000
#define HNS_ROCE_V2_MAX_SRQ_SGE			64
#define HNS_ROCE_V2_MAX_CQ_NUM			0x100000
#define HNS_ROCE_V2_MAX_CQC_TIMER_BT_NUM	0x100
#define HNS_ROCE_V2_MAX_SRQ_NUM			0x100000
#define HNS_ROCE_V2_MAX_CQE_NUM			0x400000
#define HNS_ROCE_V2_MAX_RQ_SGE_NUM		64
#define HNS_ROCE_V2_MAX_SQ_SGE_NUM		64
#define HNS_ROCE_V2_MAX_EXTEND_SGE_NUM		0x200000
#define HNS_ROCE_V2_MAX_SQ_INLINE		0x20
#define HNS_ROCE_V3_MAX_SQ_INLINE		0x400
#define HNS_ROCE_V2_MAX_RC_INL_INN_SZ		32
#define HNS_ROCE_V2_UAR_NUM			256
#define HNS_ROCE_V2_PHY_UAR_NUM			1
#define HNS_ROCE_V2_AEQE_VEC_NUM		1
#define HNS_ROCE_V2_ABNORMAL_VEC_NUM		1
#define HNS_ROCE_V2_MAX_MTPT_NUM		0x100000
#define HNS_ROCE_V2_MAX_MTT_SEGS		0x1000000
#define HNS_ROCE_V2_MAX_SRQWQE_SEGS		0x1000000
#define HNS_ROCE_V2_MAX_IDX_SEGS		0x1000000
#define HNS_ROCE_V2_MAX_PD_NUM			0x1000000
#define HNS_ROCE_V2_MAX_XRCD_NUM		0x1000000
#define HNS_ROCE_V2_RSV_XRCD_NUM		0
#define HNS_ROCE_V2_MAX_QP_INIT_RDMA		128
#define HNS_ROCE_V2_MAX_QP_DEST_RDMA		128
#define HNS_ROCE_V2_MAX_SQ_DESC_SZ		64
#define HNS_ROCE_V2_MAX_RQ_DESC_SZ		16
#define HNS_ROCE_V2_MAX_SRQ_DESC_SZ		64
#define HNS_ROCE_V2_IRRL_ENTRY_SZ		64
#define HNS_ROCE_V2_EXT_ATOMIC_TRRL_ENTRY_SZ	100
#define HNS_ROCE_V2_CQC_ENTRY_SZ		64
#define HNS_ROCE_V2_SRQC_ENTRY_SZ		64
#define HNS_ROCE_V2_MTPT_ENTRY_SZ		64
#define HNS_ROCE_V2_MTT_ENTRY_SZ		64
#define HNS_ROCE_V2_IDX_ENTRY_SZ		4

#define HNS_ROCE_V2_SCCC_SZ			32
#define HNS_ROCE_V3_SCCC_SZ			64
#define HNS_ROCE_V3_GMV_ENTRY_SZ		32

#define HNS_ROCE_V2_EXT_LLM_ENTRY_SZ		8
#define HNS_ROCE_V2_EXT_LLM_MAX_DEPTH		4096

#define HNS_ROCE_V2_QPC_TIMER_ENTRY_SZ		PAGE_SIZE
#define HNS_ROCE_V2_CQC_TIMER_ENTRY_SZ		PAGE_SIZE
#define HNS_ROCE_V2_PAGE_SIZE_SUPPORTED		0xFFFFF000
#define HNS_ROCE_V2_MAX_INNER_MTPT_NUM		2
#define HNS_ROCE_INVALID_LKEY			0x0
#define HNS_ROCE_INVALID_SGE_LENGTH		0x80000000
#define HNS_ROCE_CMQ_TX_TIMEOUT			30000
#define HNS_ROCE_V2_RSV_QPS			8

#define HNS_ROCE_V2_HW_RST_TIMEOUT		1000
#define HNS_ROCE_V2_HW_RST_UNINT_DELAY		100

#define HNS_ROCE_V2_HW_RST_COMPLETION_WAIT	20

#define HNS_ROCE_CONTEXT_HOP_NUM		1
#define HNS_ROCE_SCCC_HOP_NUM			1
#define HNS_ROCE_MTT_HOP_NUM			1
#define HNS_ROCE_CQE_HOP_NUM			1
#define HNS_ROCE_SRQWQE_HOP_NUM			1
#define HNS_ROCE_PBL_HOP_NUM			2
#define HNS_ROCE_IDX_HOP_NUM			1
#define HNS_ROCE_SQWQE_HOP_NUM			2
#define HNS_ROCE_EXT_SGE_HOP_NUM		1
#define HNS_ROCE_RQWQE_HOP_NUM			2

#define HNS_ROCE_V2_EQE_HOP_NUM			2
#define HNS_ROCE_V3_EQE_HOP_NUM			1

#define HNS_ROCE_BA_PG_SZ_SUPPORTED_256K	6
#define HNS_ROCE_BA_PG_SZ_SUPPORTED_16K		2
#define HNS_ROCE_V2_GID_INDEX_NUM		16

#define HNS_ROCE_V2_TABLE_CHUNK_SIZE		(1 << 18)

enum {
	HNS_ROCE_CMD_FLAG_IN = BIT(0),
	HNS_ROCE_CMD_FLAG_OUT = BIT(1),
	HNS_ROCE_CMD_FLAG_NEXT = BIT(2),
	HNS_ROCE_CMD_FLAG_WR = BIT(3),
	HNS_ROCE_CMD_FLAG_ERR_INTR = BIT(5),
};

#define HNS_ROCE_CMQ_DESC_NUM_S		3

#define HNS_ROCE_CMQ_SCC_CLR_DONE_CNT		5

#define HNS_ROCE_CONG_SIZE 64

#define check_whether_last_step(hop_num, step_idx) \
	((step_idx == 0 && hop_num == HNS_ROCE_HOP_NUM_0) || \
	(step_idx == 1 && hop_num == 1) || \
	(step_idx == 2 && hop_num == 2))
#define HNS_ICL_SWITCH_CMD_ROCEE_SEL_SHIFT	0
#define HNS_ICL_SWITCH_CMD_ROCEE_SEL	BIT(HNS_ICL_SWITCH_CMD_ROCEE_SEL_SHIFT)

#define CMD_CSQ_DESC_NUM		1024
#define CMD_CRQ_DESC_NUM		1024

enum {
	NO_ARMED = 0x0,
	REG_NXT_CEQE = 0x2,
	REG_NXT_SE_CEQE = 0x3
};

enum {
	CQE_SIZE_32B = 0x0,
	CQE_SIZE_64B = 0x1
};

#define V2_CQ_DB_REQ_NOT_SOL			0
#define V2_CQ_DB_REQ_NOT			1

#define V2_CQ_STATE_VALID			1
#define V2_QKEY_VAL				0x80010000

#define	GID_LEN_V2				16

enum {
	HNS_ROCE_V2_WQE_OP_SEND				= 0x0,
	HNS_ROCE_V2_WQE_OP_SEND_WITH_INV		= 0x1,
	HNS_ROCE_V2_WQE_OP_SEND_WITH_IMM		= 0x2,
	HNS_ROCE_V2_WQE_OP_RDMA_WRITE			= 0x3,
	HNS_ROCE_V2_WQE_OP_RDMA_WRITE_WITH_IMM		= 0x4,
	HNS_ROCE_V2_WQE_OP_RDMA_READ			= 0x5,
	HNS_ROCE_V2_WQE_OP_ATOM_CMP_AND_SWAP		= 0x6,
	HNS_ROCE_V2_WQE_OP_ATOM_FETCH_AND_ADD		= 0x7,
	HNS_ROCE_V2_WQE_OP_ATOM_MSK_CMP_AND_SWAP	= 0x8,
	HNS_ROCE_V2_WQE_OP_ATOM_MSK_FETCH_AND_ADD	= 0x9,
	HNS_ROCE_V2_WQE_OP_FAST_REG_PMR			= 0xa,
	HNS_ROCE_V2_WQE_OP_LOCAL_INV			= 0xb,
	HNS_ROCE_V2_WQE_OP_BIND_MW			= 0xc,
	HNS_ROCE_V2_WQE_OP_MASK				= 0x1f,
};

enum {
	/* rq operations */
	HNS_ROCE_V2_OPCODE_RDMA_WRITE_IMM = 0x0,
	HNS_ROCE_V2_OPCODE_SEND = 0x1,
	HNS_ROCE_V2_OPCODE_SEND_WITH_IMM = 0x2,
	HNS_ROCE_V2_OPCODE_SEND_WITH_INV = 0x3,
};

enum {
	HNS_ROCE_V2_SQ_DB,
	HNS_ROCE_V2_RQ_DB,
	HNS_ROCE_V2_SRQ_DB,
	HNS_ROCE_V2_CQ_DB,
	HNS_ROCE_V2_CQ_DB_NOTIFY
};

enum {
	HNS_ROCE_CQE_V2_SUCCESS				= 0x00,
	HNS_ROCE_CQE_V2_LOCAL_LENGTH_ERR		= 0x01,
	HNS_ROCE_CQE_V2_LOCAL_QP_OP_ERR			= 0x02,
	HNS_ROCE_CQE_V2_LOCAL_PROT_ERR			= 0x04,
	HNS_ROCE_CQE_V2_WR_FLUSH_ERR			= 0x05,
	HNS_ROCE_CQE_V2_MW_BIND_ERR			= 0x06,
	HNS_ROCE_CQE_V2_BAD_RESP_ERR			= 0x10,
	HNS_ROCE_CQE_V2_LOCAL_ACCESS_ERR		= 0x11,
	HNS_ROCE_CQE_V2_REMOTE_INVAL_REQ_ERR		= 0x12,
	HNS_ROCE_CQE_V2_REMOTE_ACCESS_ERR		= 0x13,
	HNS_ROCE_CQE_V2_REMOTE_OP_ERR			= 0x14,
	HNS_ROCE_CQE_V2_TRANSPORT_RETRY_EXC_ERR		= 0x15,
	HNS_ROCE_CQE_V2_RNR_RETRY_EXC_ERR		= 0x16,
	HNS_ROCE_CQE_V2_REMOTE_ABORT_ERR		= 0x22,
	HNS_ROCE_CQE_V2_GENERAL_ERR			= 0x23,

	HNS_ROCE_V2_CQE_STATUS_MASK			= 0xff,
};

/* CMQ command */
enum hns_roce_opcode_type {
	HNS_QUERY_FW_VER				= 0x0001,
	HNS_ROCE_OPC_QUERY_HW_VER			= 0x8000,
	HNS_ROCE_OPC_CFG_GLOBAL_PARAM			= 0x8001,
	HNS_ROCE_OPC_ALLOC_PF_RES			= 0x8004,
	HNS_ROCE_OPC_QUERY_PF_RES			= 0x8400,
	HNS_ROCE_OPC_ALLOC_VF_RES			= 0x8401,
	HNS_ROCE_OPC_CFG_EXT_LLM			= 0x8403,
	HNS_ROCE_OPC_QUERY_PF_TIMER_RES			= 0x8406,
	HNS_ROCE_OPC_QUERY_FUNC_INFO			= 0x8407,
	HNS_ROCE_OPC_QUERY_PF_CAPS_NUM                  = 0x8408,
	HNS_ROCE_OPC_CFG_ENTRY_SIZE			= 0x8409,
	HNS_ROCE_OPC_CFG_SGID_TB			= 0x8500,
	HNS_ROCE_OPC_CFG_SMAC_TB			= 0x8501,
	HNS_ROCE_OPC_POST_MB				= 0x8504,
	HNS_ROCE_OPC_QUERY_MB_ST			= 0x8505,
	HNS_ROCE_OPC_CFG_BT_ATTR			= 0x8506,
	HNS_ROCE_OPC_FUNC_CLEAR				= 0x8508,
	HNS_ROCE_OPC_CLR_SCCC				= 0x8509,
	HNS_ROCE_OPC_QUERY_SCCC				= 0x850a,
	HNS_ROCE_OPC_RESET_SCCC				= 0x850b,
	HNS_ROCE_OPC_CLEAR_EXTDB_LIST_INFO		= 0x850d,
	HNS_ROCE_OPC_QUERY_VF_RES			= 0x850e,
	HNS_ROCE_OPC_CFG_GMV_TBL			= 0x850f,
	HNS_ROCE_OPC_CFG_GMV_BT				= 0x8510,
	HNS_ROCE_OPC_EXT_CFG				= 0x8512,
	HNS_ROCE_QUERY_RAM_ECC				= 0x8513,
	HNS_SWITCH_PARAMETER_CFG			= 0x1033,
};

enum {
	TYPE_CRQ,
	TYPE_CSQ,
};

enum hns_roce_cmd_return_status {
	CMD_EXEC_SUCCESS,
	CMD_NO_AUTH,
	CMD_NOT_EXIST,
	CMD_CRQ_FULL,
	CMD_NEXT_ERR,
	CMD_NOT_EXEC,
	CMD_PARA_ERR,
	CMD_RESULT_ERR,
	CMD_TIMEOUT,
	CMD_HILINK_ERR,
	CMD_INFO_ILLEGAL,
	CMD_INVALID,
	CMD_ROH_CHECK_FAIL,
	CMD_OTHER_ERR = 0xff
};

enum hns_roce_sgid_type {
	GID_TYPE_FLAG_ROCE_V1 = 0,
	GID_TYPE_FLAG_ROCE_V2_IPV4,
	GID_TYPE_FLAG_ROCE_V2_IPV6,
};

struct hns_roce_v2_cq_context {
	__le32 byte_4_pg_ceqn;
	__le32 byte_8_cqn;
	__le32 cqe_cur_blk_addr;
	__le32 byte_16_hop_addr;
	__le32 cqe_nxt_blk_addr;
	__le32 byte_24_pgsz_addr;
	__le32 byte_28_cq_pi;
	__le32 byte_32_cq_ci;
	__le32 cqe_ba;
	__le32 byte_40_cqe_ba;
	__le32 byte_44_db_record;
	__le32 db_record_addr;
	__le32 byte_52_cqe_cnt;
	__le32 byte_56_cqe_period_maxcnt;
	__le32 cqe_report_timer;
	__le32 byte_64_se_cqe_idx;
};

#define HNS_ROCE_V2_CQ_DEFAULT_BURST_NUM 0x0
#define HNS_ROCE_V2_CQ_DEFAULT_INTERVAL	0x0

#define CQC_FIELD_LOC(h, l) FIELD_LOC(struct hns_roce_v2_cq_context, h, l)

#define CQC_CQ_ST CQC_FIELD_LOC(1, 0)
#define CQC_POLL CQC_FIELD_LOC(2, 2)
#define CQC_SE CQC_FIELD_LOC(3, 3)
#define CQC_OVER_IGNORE CQC_FIELD_LOC(4, 4)
#define CQC_ARM_ST CQC_FIELD_LOC(7, 6)
#define CQC_SHIFT CQC_FIELD_LOC(12, 8)
#define CQC_CMD_SN CQC_FIELD_LOC(14, 13)
#define CQC_CEQN CQC_FIELD_LOC(23, 15)
#define CQC_CQN CQC_FIELD_LOC(55, 32)
#define CQC_POE_EN CQC_FIELD_LOC(56, 56)
#define CQC_POE_NUM CQC_FIELD_LOC(58, 57)
#define CQC_CQE_SIZE CQC_FIELD_LOC(60, 59)
#define CQC_CQ_CNT_MODE CQC_FIELD_LOC(61, 61)
#define CQC_STASH CQC_FIELD_LOC(63, 63)
#define CQC_CQE_CUR_BLK_ADDR_L CQC_FIELD_LOC(95, 64)
#define CQC_CQE_CUR_BLK_ADDR_H CQC_FIELD_LOC(115, 96)
#define CQC_POE_QID CQC_FIELD_LOC(125, 116)
#define CQC_CQE_HOP_NUM CQC_FIELD_LOC(127, 126)
#define CQC_CQE_NEX_BLK_ADDR_L CQC_FIELD_LOC(159, 128)
#define CQC_CQE_NEX_BLK_ADDR_H CQC_FIELD_LOC(179, 160)
#define CQC_CQE_BAR_PG_SZ CQC_FIELD_LOC(187, 184)
#define CQC_CQE_BUF_PG_SZ CQC_FIELD_LOC(191, 188)
#define CQC_CQ_PRODUCER_IDX CQC_FIELD_LOC(215, 192)
#define CQC_CQ_CONSUMER_IDX CQC_FIELD_LOC(247, 224)
#define CQC_CQE_BA_L CQC_FIELD_LOC(287, 256)
#define CQC_CQE_BA_H CQC_FIELD_LOC(316, 288)
#define CQC_POE_QID_H_0 CQC_FIELD_LOC(319, 317)
#define CQC_DB_RECORD_EN CQC_FIELD_LOC(320, 320)
#define CQC_CQE_DB_RECORD_ADDR_L CQC_FIELD_LOC(351, 321)
#define CQC_CQE_DB_RECORD_ADDR_H CQC_FIELD_LOC(383, 352)
#define CQC_CQE_CNT CQC_FIELD_LOC(407, 384)
#define CQC_CQ_MAX_CNT CQC_FIELD_LOC(431, 416)
#define CQC_CQ_PERIOD CQC_FIELD_LOC(447, 432)
#define CQC_CQE_REPORT_TIMER CQC_FIELD_LOC(471, 448)
#define CQC_WR_CQE_IDX CQC_FIELD_LOC(479, 472)
#define CQC_SE_CQE_IDX CQC_FIELD_LOC(503, 480)
#define CQC_POE_QID_H_1 CQC_FIELD_LOC(511, 511)

struct hns_roce_srq_context {
	__le32 data[16];
};

#define SRQC_FIELD_LOC(h, l) FIELD_LOC(struct hns_roce_srq_context, h, l)

#define SRQC_SRQ_ST SRQC_FIELD_LOC(1, 0)
#define SRQC_WQE_HOP_NUM SRQC_FIELD_LOC(3, 2)
#define SRQC_SHIFT SRQC_FIELD_LOC(7, 4)
#define SRQC_SRQN SRQC_FIELD_LOC(31, 8)
#define SRQC_LIMIT_WL SRQC_FIELD_LOC(47, 32)
#define SRQC_RSV0 SRQC_FIELD_LOC(63, 48)
#define SRQC_XRCD SRQC_FIELD_LOC(87, 64)
#define SRQC_RSV1 SRQC_FIELD_LOC(95, 88)
#define SRQC_PRODUCER_IDX SRQC_FIELD_LOC(111, 96)
#define SRQC_CONSUMER_IDX SRQC_FIELD_LOC(127, 112)
#define SRQC_WQE_BT_BA_L SRQC_FIELD_LOC(159, 128)
#define SRQC_WQE_BT_BA_H SRQC_FIELD_LOC(188, 160)
#define SRQC_RSV2 SRQC_FIELD_LOC(190, 189)
#define SRQC_SRQ_TYPE SRQC_FIELD_LOC(191, 191)
#define SRQC_PD SRQC_FIELD_LOC(215, 192)
#define SRQC_RQWS SRQC_FIELD_LOC(219, 216)
#define SRQC_RSV3 SRQC_FIELD_LOC(223, 220)
#define SRQC_IDX_BT_BA_L SRQC_FIELD_LOC(255, 224)
#define SRQC_IDX_BT_BA_H SRQC_FIELD_LOC(284, 256)
#define SRQC_RSV4 SRQC_FIELD_LOC(287, 285)
#define SRQC_IDX_CUR_BLK_ADDR_L SRQC_FIELD_LOC(319, 288)
#define SRQC_IDX_CUR_BLK_ADDR_H SRQC_FIELD_LOC(339, 320)
#define SRQC_RSV5 SRQC_FIELD_LOC(341, 340)
#define SRQC_IDX_HOP_NUM SRQC_FIELD_LOC(343, 342)
#define SRQC_IDX_BA_PG_SZ SRQC_FIELD_LOC(347, 344)
#define SRQC_IDX_BUF_PG_SZ SRQC_FIELD_LOC(351, 348)
#define SRQC_IDX_NXT_BLK_ADDR_L SRQC_FIELD_LOC(383, 352)
#define SRQC_IDX_NXT_BLK_ADDR_H SRQC_FIELD_LOC(403, 384)
#define SRQC_RSV6 SRQC_FIELD_LOC(415, 404)
#define SRQC_XRC_CQN SRQC_FIELD_LOC(439, 416)
#define SRQC_WQE_BA_PG_SZ SRQC_FIELD_LOC(443, 440)
#define SRQC_WQE_BUF_PG_SZ SRQC_FIELD_LOC(447, 444)
#define SRQC_DB_RECORD_EN SRQC_FIELD_LOC(448, 448)
#define SRQC_DB_RECORD_ADDR_L SRQC_FIELD_LOC(479, 449)
#define SRQC_DB_RECORD_ADDR_H SRQC_FIELD_LOC(511, 480)

enum {
	V2_MPT_ST_VALID = 0x1,
	V2_MPT_ST_FREE	= 0x2,
};

enum hns_roce_v2_qp_state {
	HNS_ROCE_QP_ST_RST,
	HNS_ROCE_QP_ST_INIT,
	HNS_ROCE_QP_ST_RTR,
	HNS_ROCE_QP_ST_RTS,
	HNS_ROCE_QP_ST_SQD,
	HNS_ROCE_QP_ST_SQER,
	HNS_ROCE_QP_ST_ERR,
	HNS_ROCE_QP_ST_SQ_DRAINING,
	HNS_ROCE_QP_NUM_ST
};

struct hns_roce_v2_qp_context_ex {
	__le32 data[64];
};
struct hns_roce_v2_qp_context {
	__le32 byte_4_sqpn_tst;
	__le32 wqe_sge_ba;
	__le32 byte_12_sq_hop;
	__le32 byte_16_buf_ba_pg_sz;
	__le32 byte_20_smac_sgid_idx;
	__le32 byte_24_mtu_tc;
	__le32 byte_28_at_fl;
	u8 dgid[GID_LEN_V2];
	__le32 dmac;
	__le32 byte_52_udpspn_dmac;
	__le32 byte_56_dqpn_err;
	__le32 byte_60_qpst_tempid;
	__le32 qkey_xrcd;
	__le32 byte_68_rq_db;
	__le32 rq_db_record_addr;
	__le32 byte_76_srqn_op_en;
	__le32 byte_80_rnr_rx_cqn;
	__le32 byte_84_rq_ci_pi;
	__le32 rq_cur_blk_addr;
	__le32 byte_92_srq_info;
	__le32 byte_96_rx_reqmsn;
	__le32 rq_nxt_blk_addr;
	__le32 byte_104_rq_sge;
	__le32 byte_108_rx_reqepsn;
	__le32 rq_rnr_timer;
	__le32 rx_msg_len;
	__le32 rx_rkey_pkt_info;
	__le64 rx_va;
	__le32 byte_132_trrl;
	__le32 trrl_ba;
	__le32 byte_140_raq;
	__le32 byte_144_raq;
	__le32 byte_148_raq;
	__le32 byte_152_raq;
	__le32 byte_156_raq;
	__le32 byte_160_sq_ci_pi;
	__le32 sq_cur_blk_addr;
	__le32 byte_168_irrl_idx;
	__le32 byte_172_sq_psn;
	__le32 byte_176_msg_pktn;
	__le32 sq_cur_sge_blk_addr;
	__le32 byte_184_irrl_idx;
	__le32 cur_sge_offset;
	__le32 byte_192_ext_sge;
	__le32 byte_196_sq_psn;
	__le32 byte_200_sq_max;
	__le32 irrl_ba;
	__le32 byte_208_irrl;
	__le32 byte_212_lsn;
	__le32 sq_timer;
	__le32 byte_220_retry_psn_msn;
	__le32 byte_224_retry_msg;
	__le32 rx_sq_cur_blk_addr;
	__le32 byte_232_irrl_sge;
	__le32 irrl_cur_sge_offset;
	__le32 byte_240_irrl_tail;
	__le32 byte_244_rnr_rxack;
	__le32 byte_248_ack_psn;
	__le32 byte_252_err_txcqn;
	__le32 byte_256_sqflush_rqcqe;

	struct hns_roce_v2_qp_context_ex ext;
};

#define QPC_FIELD_LOC(h, l) FIELD_LOC(struct hns_roce_v2_qp_context, h, l)

#define QPC_TST QPC_FIELD_LOC(2, 0)
#define QPC_SGE_SHIFT QPC_FIELD_LOC(7, 3)
#define QPC_CNP_TIMER QPC_FIELD_LOC(31, 8)
#define QPC_WQE_SGE_BA_L QPC_FIELD_LOC(63, 32)
#define QPC_WQE_SGE_BA_H QPC_FIELD_LOC(92, 64)
#define QPC_SQ_HOP_NUM QPC_FIELD_LOC(94, 93)
#define QPC_CIRE_EN QPC_FIELD_LOC(95, 95)
#define QPC_WQE_SGE_BA_PG_SZ QPC_FIELD_LOC(99, 96)
#define QPC_WQE_SGE_BUF_PG_SZ QPC_FIELD_LOC(103, 100)
#define QPC_PD QPC_FIELD_LOC(127, 104)
#define QPC_RQ_HOP_NUM QPC_FIELD_LOC(129, 128)
#define QPC_SGE_HOP_NUM QPC_FIELD_LOC(131, 130)
#define QPC_RQWS QPC_FIELD_LOC(135, 132)
#define QPC_SQ_SHIFT QPC_FIELD_LOC(139, 136)
#define QPC_RQ_SHIFT QPC_FIELD_LOC(143, 140)
#define QPC_GMV_IDX QPC_FIELD_LOC(159, 144)
#define QPC_HOPLIMIT QPC_FIELD_LOC(167, 160)
#define QPC_TC QPC_FIELD_LOC(175, 168)
#define QPC_VLAN_ID QPC_FIELD_LOC(187, 176)
#define QPC_MTU QPC_FIELD_LOC(191, 188)
#define QPC_FL QPC_FIELD_LOC(211, 192)
#define QPC_SL QPC_FIELD_LOC(215, 212)
#define QPC_CNP_TX_FLAG QPC_FIELD_LOC(216, 216)
#define QPC_CE_FLAG QPC_FIELD_LOC(217, 217)
#define QPC_LBI QPC_FIELD_LOC(218, 218)
#define QPC_AT QPC_FIELD_LOC(223, 219)
#define QPC_DGID QPC_FIELD_LOC(351, 224)
#define QPC_DMAC_L QPC_FIELD_LOC(383, 352)
#define QPC_DMAC_H QPC_FIELD_LOC(399, 384)
#define QPC_UDPSPN QPC_FIELD_LOC(415, 400)
#define QPC_DQPN QPC_FIELD_LOC(439, 416)
#define QPC_SQ_TX_ERR QPC_FIELD_LOC(440, 440)
#define QPC_SQ_RX_ERR QPC_FIELD_LOC(441, 441)
#define QPC_RQ_TX_ERR QPC_FIELD_LOC(442, 442)
#define QPC_RQ_RX_ERR QPC_FIELD_LOC(443, 443)
#define QPC_LP_PKTN_INI QPC_FIELD_LOC(447, 444)
#define QPC_CONG_ALGO_TMPL_ID QPC_FIELD_LOC(455, 448)
#define QPC_SCC_TOKEN QPC_FIELD_LOC(474, 456)
#define QPC_SQ_DB_DOING QPC_FIELD_LOC(475, 475)
#define QPC_RQ_DB_DOING QPC_FIELD_LOC(476, 476)
#define QPC_QP_ST QPC_FIELD_LOC(479, 477)
#define QPC_QKEY_XRCD QPC_FIELD_LOC(511, 480)
#define QPC_RQ_RECORD_EN QPC_FIELD_LOC(512, 512)
#define QPC_RQ_DB_RECORD_ADDR_L QPC_FIELD_LOC(543, 513)
#define QPC_RQ_DB_RECORD_ADDR_H QPC_FIELD_LOC(575, 544)
#define QPC_SRQN QPC_FIELD_LOC(599, 576)
#define QPC_SRQ_EN QPC_FIELD_LOC(600, 600)
#define QPC_RRE QPC_FIELD_LOC(601, 601)
#define QPC_RWE QPC_FIELD_LOC(602, 602)
#define QPC_ATE QPC_FIELD_LOC(603, 603)
#define QPC_RQIE QPC_FIELD_LOC(604, 604)
#define QPC_EXT_ATE QPC_FIELD_LOC(605, 605)
#define QPC_RQ_VLAN_EN QPC_FIELD_LOC(606, 606)
#define QPC_RQ_RTY_TX_ERR QPC_FIELD_LOC(607, 607)
#define QPC_RX_CQN QPC_FIELD_LOC(631, 608)
#define QPC_XRC_QP_TYPE QPC_FIELD_LOC(632, 632)
#define QPC_RSV3 QPC_FIELD_LOC(634, 633)
#define QPC_MIN_RNR_TIME QPC_FIELD_LOC(639, 635)
#define QPC_RQ_PRODUCER_IDX QPC_FIELD_LOC(655, 640)
#define QPC_RQ_CONSUMER_IDX QPC_FIELD_LOC(671, 656)
#define QPC_RQ_CUR_BLK_ADDR_L QPC_FIELD_LOC(703, 672)
#define QPC_RQ_CUR_BLK_ADDR_H QPC_FIELD_LOC(723, 704)
#define QPC_SRQ_INFO QPC_FIELD_LOC(735, 724)
#define QPC_RX_REQ_MSN QPC_FIELD_LOC(759, 736)
#define QPC_REDUCE_CODE QPC_FIELD_LOC(766, 760)
#define QPC_RX_XRC_PKT_CQE_FLG QPC_FIELD_LOC(767, 767)
#define QPC_RQ_NXT_BLK_ADDR_L QPC_FIELD_LOC(799, 768)
#define QPC_RQ_NXT_BLK_ADDR_H QPC_FIELD_LOC(819, 800)
#define QPC_REDUCE_EN QPC_FIELD_LOC(820, 820)
#define QPC_FLUSH_EN QPC_FIELD_LOC(821, 821)
#define QPC_AW_EN QPC_FIELD_LOC(822, 822)
#define QPC_WN_EN QPC_FIELD_LOC(823, 823)
#define QPC_RQ_CUR_WQE_SGE_NUM QPC_FIELD_LOC(831, 824)
#define QPC_INV_CREDIT QPC_FIELD_LOC(832, 832)
#define QPC_LAST_WRITE_TYPE QPC_FIELD_LOC(834, 833)
#define QPC_RX_REQ_PSN_ERR QPC_FIELD_LOC(835, 835)
#define QPC_RX_REQ_LAST_OPTYPE QPC_FIELD_LOC(838, 836)
#define QPC_RX_REQ_RNR QPC_FIELD_LOC(839, 839)
#define QPC_RX_REQ_EPSN QPC_FIELD_LOC(863, 840)
#define QPC_RQ_RNR_TIMER QPC_FIELD_LOC(895, 864)
#define QPC_RX_MSG_LEN QPC_FIELD_LOC(927, 896)
#define QPC_RX_RKEY_PKT_INFO QPC_FIELD_LOC(959, 928)
#define QPC_RX_VA QPC_FIELD_LOC(1023, 960)
#define QPC_TRRL_HEAD_MAX QPC_FIELD_LOC(1031, 1024)
#define QPC_TRRL_TAIL_MAX QPC_FIELD_LOC(1039, 1032)
#define QPC_TRRL_BA_L QPC_FIELD_LOC(1055, 1040)
#define QPC_TRRL_BA_M QPC_FIELD_LOC(1087, 1056)
#define QPC_TRRL_BA_H QPC_FIELD_LOC(1099, 1088)
#define QPC_RR_MAX QPC_FIELD_LOC(1102, 1100)
#define QPC_RQ_RTY_WAIT_DO QPC_FIELD_LOC(1103, 1103)
#define QPC_RAQ_TRRL_HEAD QPC_FIELD_LOC(1111, 1104)
#define QPC_RAQ_TRRL_TAIL QPC_FIELD_LOC(1119, 1112)
#define QPC_RAQ_RTY_INI_PSN QPC_FIELD_LOC(1143, 1120)
#define QPC_CIRE_SLV_RQ_EN QPC_FIELD_LOC(1144, 1144)
#define QPC_RAQ_CREDIT QPC_FIELD_LOC(1149, 1145)
#define QPC_RQ_DB_IN_EXT QPC_FIELD_LOC(1150, 1150)
#define QPC_RESP_RTY_FLG QPC_FIELD_LOC(1151, 1151)
#define QPC_RAQ_MSN QPC_FIELD_LOC(1175, 1152)
#define QPC_RAQ_SYNDROME QPC_FIELD_LOC(1183, 1176)
#define QPC_RAQ_PSN QPC_FIELD_LOC(1207, 1184)
#define QPC_RAQ_TRRL_RTY_HEAD QPC_FIELD_LOC(1215, 1208)
#define QPC_RAQ_USE_PKTN QPC_FIELD_LOC(1239, 1216)
#define QPC_RQ_SCC_TOKEN QPC_FIELD_LOC(1245, 1240)
#define QPC_RVD10 QPC_FIELD_LOC(1247, 1246)
#define QPC_SQ_PRODUCER_IDX QPC_FIELD_LOC(1263, 1248)
#define QPC_SQ_CONSUMER_IDX QPC_FIELD_LOC(1279, 1264)
#define QPC_SQ_CUR_BLK_ADDR_L QPC_FIELD_LOC(1311, 1280)
#define QPC_SQ_CUR_BLK_ADDR_H QPC_FIELD_LOC(1331, 1312)
#define QPC_MSG_RTY_LP_FLG QPC_FIELD_LOC(1332, 1332)
#define QPC_SQ_INVLD_FLG QPC_FIELD_LOC(1333, 1333)
#define QPC_LP_SGEN_INI QPC_FIELD_LOC(1335, 1334)
#define QPC_SQ_VLAN_EN QPC_FIELD_LOC(1336, 1336)
#define QPC_POLL_DB_WAIT_DO QPC_FIELD_LOC(1337, 1337)
#define QPC_SCC_TOKEN_FORBID_SQ_DEQ QPC_FIELD_LOC(1338, 1338)
#define QPC_WAIT_ACK_TIMEOUT QPC_FIELD_LOC(1339, 1339)
#define QPC_IRRL_IDX_LSB QPC_FIELD_LOC(1343, 1340)
#define QPC_ACK_REQ_FREQ QPC_FIELD_LOC(1349, 1344)
#define QPC_MSG_RNR_FLG QPC_FIELD_LOC(1350, 1350)
#define QPC_FRE QPC_FIELD_LOC(1351, 1351)
#define QPC_SQ_CUR_PSN QPC_FIELD_LOC(1375, 1352)
#define QPC_MSG_USE_PKTN QPC_FIELD_LOC(1399, 1376)
#define QPC_IRRL_HEAD_PRE QPC_FIELD_LOC(1407, 1400)
#define QPC_SQ_CUR_SGE_BLK_ADDR_L QPC_FIELD_LOC(1439, 1408)
#define QPC_SQ_CUR_SGE_BLK_ADDR_H QPC_FIELD_LOC(1459, 1440)
#define QPC_IRRL_IDX_MSB QPC_FIELD_LOC(1471, 1460)
#define QPC_CUR_SGE_OFFSET QPC_FIELD_LOC(1503, 1472)
#define QPC_CUR_SGE_IDX QPC_FIELD_LOC(1527, 1504)
#define QPC_EXT_SGE_NUM_LEFT QPC_FIELD_LOC(1535, 1528)
#define QPC_OWNER_MODE QPC_FIELD_LOC(1536, 1536)
#define QPC_CIRE_SLV_SQ_EN QPC_FIELD_LOC(1537, 1537)
#define QPC_CIRE_DOING QPC_FIELD_LOC(1538, 1538)
#define QPC_CIRE_RESULT QPC_FIELD_LOC(1539, 1539)
#define QPC_OWNER_DB_WAIT_DO QPC_FIELD_LOC(1540, 1540)
#define QPC_SQ_WQE_INVLD QPC_FIELD_LOC(1541, 1541)
#define QPC_DCA_MODE QPC_FIELD_LOC(1542, 1542)
#define QPC_RTY_OWNER_NOCHK QPC_FIELD_LOC(1543, 1543)
#define QPC_V2_IRRL_HEAD QPC_FIELD_LOC(1543, 1536)
#define QPC_SQ_MAX_PSN QPC_FIELD_LOC(1567, 1544)
#define QPC_SQ_MAX_IDX QPC_FIELD_LOC(1583, 1568)
#define QPC_LCL_OPERATED_CNT QPC_FIELD_LOC(1599, 1584)
#define QPC_IRRL_BA_L QPC_FIELD_LOC(1631, 1600)
#define QPC_IRRL_BA_H QPC_FIELD_LOC(1657, 1632)
#define QPC_PKT_RNR_FLG QPC_FIELD_LOC(1658, 1658)
#define QPC_PKT_RTY_FLG QPC_FIELD_LOC(1659, 1659)
#define QPC_RMT_E2E QPC_FIELD_LOC(1660, 1660)
#define QPC_SR_MAX QPC_FIELD_LOC(1663, 1661)
#define QPC_LSN QPC_FIELD_LOC(1687, 1664)
#define QPC_RETRY_NUM_INIT QPC_FIELD_LOC(1690, 1688)
#define QPC_CHECK_FLG QPC_FIELD_LOC(1692, 1691)
#define QPC_RETRY_CNT QPC_FIELD_LOC(1695, 1693)
#define QPC_SQ_TIMER QPC_FIELD_LOC(1727, 1696)
#define QPC_RETRY_MSG_MSN QPC_FIELD_LOC(1743, 1728)
#define QPC_RETRY_MSG_PSN_L QPC_FIELD_LOC(1759, 1744)
#define QPC_RETRY_MSG_PSN_H QPC_FIELD_LOC(1767, 1760)
#define QPC_RETRY_MSG_FPKT_PSN QPC_FIELD_LOC(1791, 1768)
#define QPC_RX_SQ_CUR_BLK_ADDR_L QPC_FIELD_LOC(1823, 1792)
#define QPC_RX_SQ_CUR_BLK_ADDR_H QPC_FIELD_LOC(1843, 1824)
#define QPC_IRRL_SGE_IDX QPC_FIELD_LOC(1851, 1844)
#define QPC_LSAN_EN QPC_FIELD_LOC(1852, 1852)
#define QPC_SO_LP_VLD QPC_FIELD_LOC(1853, 1853)
#define QPC_FENCE_LP_VLD QPC_FIELD_LOC(1854, 1854)
#define QPC_IRRL_LP_VLD QPC_FIELD_LOC(1855, 1855)
#define QPC_IRRL_CUR_SGE_OFFSET QPC_FIELD_LOC(1887, 1856)
#define QPC_IRRL_TAIL_REAL QPC_FIELD_LOC(1895, 1888)
#define QPC_IRRL_TAIL_RD QPC_FIELD_LOC(1903, 1896)
#define QPC_RX_ACK_MSN QPC_FIELD_LOC(1919, 1904)
#define QPC_RX_ACK_EPSN QPC_FIELD_LOC(1943, 1920)
#define QPC_RNR_NUM_INIT QPC_FIELD_LOC(1946, 1944)
#define QPC_RNR_CNT QPC_FIELD_LOC(1949, 1947)
#define QPC_LCL_OP_FLG QPC_FIELD_LOC(1950, 1950)
#define QPC_IRRL_RD_FLG QPC_FIELD_LOC(1951, 1951)
#define QPC_IRRL_PSN QPC_FIELD_LOC(1975, 1952)
#define QPC_ACK_PSN_ERR QPC_FIELD_LOC(1976, 1976)
#define QPC_ACK_LAST_OPTYPE QPC_FIELD_LOC(1978, 1977)
#define QPC_IRRL_PSN_VLD QPC_FIELD_LOC(1979, 1979)
#define QPC_RNR_RETRY_FLAG QPC_FIELD_LOC(1980, 1980)
#define QPC_SQ_RTY_TX_ERR QPC_FIELD_LOC(1981, 1981)
#define QPC_LAST_IND QPC_FIELD_LOC(1982, 1982)
#define QPC_CQ_ERR_IND QPC_FIELD_LOC(1983, 1983)
#define QPC_TX_CQN QPC_FIELD_LOC(2007, 1984)
#define QPC_SIG_TYPE QPC_FIELD_LOC(2008, 2008)
#define QPC_ERR_TYPE QPC_FIELD_LOC(2015, 2009)
#define QPC_RQ_CQE_IDX QPC_FIELD_LOC(2031, 2016)
#define QPC_SQ_FLUSH_IDX QPC_FIELD_LOC(2047, 2032)

#define RETRY_MSG_PSN_SHIFT 16

#define QPCEX_FIELD_LOC(h, l) FIELD_LOC(struct hns_roce_v2_qp_context_ex, h, l)

#define QPCEX_CONG_ALG_SEL QPCEX_FIELD_LOC(0, 0)
#define QPCEX_CONG_ALG_SUB_SEL QPCEX_FIELD_LOC(1, 1)
#define QPCEX_DIP_CTX_IDX_VLD QPCEX_FIELD_LOC(2, 2)
#define QPCEX_DIP_CTX_IDX QPCEX_FIELD_LOC(22, 3)
#define QPCEX_SQ_RQ_NOT_FORBID_EN QPCEX_FIELD_LOC(23, 23)
#define QPCEX_STASH QPCEX_FIELD_LOC(82, 82)

#define	V2_QP_RWE_S 1 /* rdma write enable */
#define	V2_QP_RRE_S 2 /* rdma read enable */
#define	V2_QP_ATE_S 3 /* rdma atomic enable */

struct hns_roce_v2_cqe {
	__le32	byte_4;
	union {
		__le32 rkey;
		__le32 immtdata;
	};
	__le32	byte_12;
	__le32	byte_16;
	__le32	byte_cnt;
	u8	smac[4];
	__le32	byte_28;
	__le32	byte_32;
	__le32	rsv[8];
};

#define CQE_FIELD_LOC(h, l) FIELD_LOC(struct hns_roce_v2_cqe, h, l)

#define CQE_OPCODE CQE_FIELD_LOC(4, 0)
#define CQE_RQ_INLINE CQE_FIELD_LOC(5, 5)
#define CQE_S_R CQE_FIELD_LOC(6, 6)
#define CQE_OWNER CQE_FIELD_LOC(7, 7)
#define CQE_STATUS CQE_FIELD_LOC(15, 8)
#define CQE_WQE_IDX CQE_FIELD_LOC(31, 16)
#define CQE_RKEY_IMMTDATA CQE_FIELD_LOC(63, 32)
#define CQE_XRC_SRQN CQE_FIELD_LOC(87, 64)
#define CQE_RSV0 CQE_FIELD_LOC(95, 88)
#define CQE_LCL_QPN CQE_FIELD_LOC(119, 96)
#define CQE_SUB_STATUS CQE_FIELD_LOC(127, 120)
#define CQE_BYTE_CNT CQE_FIELD_LOC(159, 128)
#define CQE_SMAC CQE_FIELD_LOC(207, 160)
#define CQE_PORT_TYPE CQE_FIELD_LOC(209, 208)
#define CQE_VID CQE_FIELD_LOC(221, 210)
#define CQE_VID_VLD CQE_FIELD_LOC(222, 222)
#define CQE_RSV2 CQE_FIELD_LOC(223, 223)
#define CQE_RMT_QPN CQE_FIELD_LOC(247, 224)
#define CQE_SL CQE_FIELD_LOC(250, 248)
#define CQE_PORTN CQE_FIELD_LOC(253, 251)
#define CQE_GRH CQE_FIELD_LOC(254, 254)
#define CQE_LPK CQE_FIELD_LOC(255, 255)
#define CQE_RSV3 CQE_FIELD_LOC(511, 256)

struct hns_roce_v2_mpt_entry {
	__le32	byte_4_pd_hop_st;
	__le32	byte_8_mw_cnt_en;
	__le32	byte_12_mw_pa;
	__le32	bound_lkey;
	__le32	len_l;
	__le32	len_h;
	__le32	lkey;
	__le32	va_l;
	__le32	va_h;
	__le32	pbl_size;
	__le32	pbl_ba_l;
	__le32	byte_48_mode_ba;
	__le32	pa0_l;
	__le32	byte_56_pa0_h;
	__le32	pa1_l;
	__le32	byte_64_buf_pa1;
};

#define MPT_FIELD_LOC(h, l) FIELD_LOC(struct hns_roce_v2_mpt_entry, h, l)

#define MPT_ST MPT_FIELD_LOC(1, 0)
#define MPT_PBL_HOP_NUM MPT_FIELD_LOC(3, 2)
#define MPT_PBL_BA_PG_SZ MPT_FIELD_LOC(7, 4)
#define MPT_PD MPT_FIELD_LOC(31, 8)
#define MPT_RA_EN MPT_FIELD_LOC(32, 32)
#define MPT_R_INV_EN MPT_FIELD_LOC(33, 33)
#define MPT_L_INV_EN MPT_FIELD_LOC(34, 34)
#define MPT_BIND_EN MPT_FIELD_LOC(35, 35)
#define MPT_ATOMIC_EN MPT_FIELD_LOC(36, 36)
#define MPT_RR_EN MPT_FIELD_LOC(37, 37)
#define MPT_RW_EN MPT_FIELD_LOC(38, 38)
#define MPT_LW_EN MPT_FIELD_LOC(39, 39)
#define MPT_MW_CNT MPT_FIELD_LOC(63, 40)
#define MPT_FRE MPT_FIELD_LOC(64, 64)
#define MPT_PA MPT_FIELD_LOC(65, 65)
#define MPT_ZBVA MPT_FIELD_LOC(66, 66)
#define MPT_SHARE MPT_FIELD_LOC(67, 67)
#define MPT_MR_MW MPT_FIELD_LOC(68, 68)
#define MPT_BPD MPT_FIELD_LOC(69, 69)
#define MPT_BQP MPT_FIELD_LOC(70, 70)
#define MPT_INNER_PA_VLD MPT_FIELD_LOC(71, 71)
#define MPT_MW_BIND_QPN MPT_FIELD_LOC(95, 72)
#define MPT_BOUND_LKEY MPT_FIELD_LOC(127, 96)
#define MPT_LEN MPT_FIELD_LOC(191, 128)
#define MPT_LKEY MPT_FIELD_LOC(223, 192)
#define MPT_VA MPT_FIELD_LOC(287, 224)
#define MPT_PBL_SIZE MPT_FIELD_LOC(319, 288)
#define MPT_PBL_BA_L MPT_FIELD_LOC(351, 320)
#define MPT_PBL_BA_H MPT_FIELD_LOC(380, 352)
#define MPT_BLK_MODE MPT_FIELD_LOC(381, 381)
#define MPT_RSV0 MPT_FIELD_LOC(383, 382)
#define MPT_PA0_L MPT_FIELD_LOC(415, 384)
#define MPT_PA0_H MPT_FIELD_LOC(441, 416)
#define MPT_BOUND_VA MPT_FIELD_LOC(447, 442)
#define MPT_PA1_L MPT_FIELD_LOC(479, 448)
#define MPT_PA1_H MPT_FIELD_LOC(505, 480)
#define MPT_PERSIST_EN MPT_FIELD_LOC(506, 506)
#define MPT_RSV2 MPT_FIELD_LOC(507, 507)
#define MPT_PBL_BUF_PG_SZ MPT_FIELD_LOC(511, 508)

#define V2_MPT_BYTE_4_MPT_ST_S 0
#define V2_MPT_BYTE_4_MPT_ST_M GENMASK(1, 0)

#define V2_MPT_BYTE_4_PBL_HOP_NUM_S 2
#define V2_MPT_BYTE_4_PBL_HOP_NUM_M GENMASK(3, 2)

#define V2_MPT_BYTE_4_PBL_BA_PG_SZ_S 4
#define V2_MPT_BYTE_4_PBL_BA_PG_SZ_M GENMASK(7, 4)

#define V2_MPT_BYTE_4_PD_S 8
#define V2_MPT_BYTE_4_PD_M GENMASK(31, 8)

#define V2_MPT_BYTE_8_RA_EN_S 0

#define V2_MPT_BYTE_8_R_INV_EN_S 1

#define V2_MPT_BYTE_8_L_INV_EN_S 2

#define V2_MPT_BYTE_8_BIND_EN_S 3

#define V2_MPT_BYTE_8_ATOMIC_EN_S 4

#define V2_MPT_BYTE_8_RR_EN_S 5

#define V2_MPT_BYTE_8_RW_EN_S 6

#define V2_MPT_BYTE_8_LW_EN_S 7

#define V2_MPT_BYTE_8_MW_CNT_S 8
#define V2_MPT_BYTE_8_MW_CNT_M GENMASK(31, 8)

#define V2_MPT_BYTE_12_FRE_S 0

#define V2_MPT_BYTE_12_PA_S 1

#define V2_MPT_BYTE_12_MR_MW_S 4

#define V2_MPT_BYTE_12_BPD_S 5

#define V2_MPT_BYTE_12_BQP_S 6

#define V2_MPT_BYTE_12_INNER_PA_VLD_S 7

#define V2_MPT_BYTE_12_MW_BIND_QPN_S 8
#define V2_MPT_BYTE_12_MW_BIND_QPN_M GENMASK(31, 8)

#define V2_MPT_BYTE_48_PBL_BA_H_S 0
#define V2_MPT_BYTE_48_PBL_BA_H_M GENMASK(28, 0)

#define V2_MPT_BYTE_48_BLK_MODE_S 29

#define V2_MPT_BYTE_56_PA0_H_S 0
#define V2_MPT_BYTE_56_PA0_H_M GENMASK(25, 0)

#define V2_MPT_BYTE_64_PA1_H_S 0
#define V2_MPT_BYTE_64_PA1_H_M GENMASK(25, 0)

#define V2_MPT_BYTE_64_PBL_BUF_PG_SZ_S 28
#define V2_MPT_BYTE_64_PBL_BUF_PG_SZ_M GENMASK(31, 28)

struct hns_roce_v2_db {
	__le32	data[2];
};

#define DB_FIELD_LOC(h, l) FIELD_LOC(struct hns_roce_v2_db, h, l)

#define DB_TAG DB_FIELD_LOC(23, 0)
#define DB_CMD DB_FIELD_LOC(27, 24)
#define DB_FLAG DB_FIELD_LOC(31, 31)
#define DB_PI DB_FIELD_LOC(47, 32)
#define DB_SL DB_FIELD_LOC(50, 48)
#define DB_CQ_CI DB_FIELD_LOC(55, 32)
#define DB_CQ_NOTIFY DB_FIELD_LOC(56, 56)
#define DB_CQ_CMD_SN DB_FIELD_LOC(58, 57)
#define EQ_DB_TAG DB_FIELD_LOC(7, 0)
#define EQ_DB_CMD DB_FIELD_LOC(17, 16)
#define EQ_DB_CI DB_FIELD_LOC(55, 32)

#define V2_DB_PRODUCER_IDX_S 0
#define V2_DB_PRODUCER_IDX_M GENMASK(15, 0)

#define V2_CQ_DB_CONS_IDX_S 0
#define V2_CQ_DB_CONS_IDX_M GENMASK(23, 0)

struct hns_roce_v2_ud_send_wqe {
	__le32	byte_4;
	__le32	msg_len;
	__le32	immtdata;
	__le32	byte_16;
	__le32	byte_20;
	__le32	byte_24;
	__le32	qkey;
	__le32	byte_32;
	__le32	byte_36;
	__le32	byte_40;
	u8	dmac[ETH_ALEN];
	u8	sgid_index;
	u8	smac_index;
	u8	dgid[GID_LEN_V2];
};

#define UD_SEND_WQE_FIELD_LOC(h, l) FIELD_LOC(struct hns_roce_v2_ud_send_wqe, h, l)

#define UD_SEND_WQE_OPCODE UD_SEND_WQE_FIELD_LOC(4, 0)
#define UD_SEND_WQE_OWNER UD_SEND_WQE_FIELD_LOC(7, 7)
#define UD_SEND_WQE_CQE UD_SEND_WQE_FIELD_LOC(8, 8)
#define UD_SEND_WQE_SE UD_SEND_WQE_FIELD_LOC(11, 11)
#define UD_SEND_WQE_PD UD_SEND_WQE_FIELD_LOC(119, 96)
#define UD_SEND_WQE_SGE_NUM UD_SEND_WQE_FIELD_LOC(127, 120)
#define UD_SEND_WQE_MSG_START_SGE_IDX UD_SEND_WQE_FIELD_LOC(151, 128)
#define UD_SEND_WQE_UDPSPN UD_SEND_WQE_FIELD_LOC(191, 176)
#define UD_SEND_WQE_DQPN UD_SEND_WQE_FIELD_LOC(247, 224)
#define UD_SEND_WQE_VLAN UD_SEND_WQE_FIELD_LOC(271, 256)
#define UD_SEND_WQE_HOPLIMIT UD_SEND_WQE_FIELD_LOC(279, 272)
#define UD_SEND_WQE_TCLASS UD_SEND_WQE_FIELD_LOC(287, 280)
#define UD_SEND_WQE_FLOW_LABEL UD_SEND_WQE_FIELD_LOC(307, 288)
#define UD_SEND_WQE_SL UD_SEND_WQE_FIELD_LOC(311, 308)
#define UD_SEND_WQE_VLAN_EN UD_SEND_WQE_FIELD_LOC(318, 318)
#define UD_SEND_WQE_LBI UD_SEND_WQE_FIELD_LOC(319, 319)

struct hns_roce_v2_rc_send_wqe {
	__le32		byte_4;
	__le32		msg_len;
	union {
		__le32  inv_key;
		__le32  immtdata;
	};
	__le32		byte_16;
	__le32		byte_20;
	__le32		rkey;
	__le64		va;
};

#define RC_SEND_WQE_FIELD_LOC(h, l) FIELD_LOC(struct hns_roce_v2_rc_send_wqe, h, l)

#define RC_SEND_WQE_OPCODE RC_SEND_WQE_FIELD_LOC(4, 0)
#define RC_SEND_WQE_DB_SL_L RC_SEND_WQE_FIELD_LOC(6, 5)
#define RC_SEND_WQE_DB_SL_H RC_SEND_WQE_FIELD_LOC(14, 13)
#define RC_SEND_WQE_OWNER RC_SEND_WQE_FIELD_LOC(7, 7)
#define RC_SEND_WQE_CQE RC_SEND_WQE_FIELD_LOC(8, 8)
#define RC_SEND_WQE_FENCE RC_SEND_WQE_FIELD_LOC(9, 9)
#define RC_SEND_WQE_SO RC_SEND_WQE_FIELD_LOC(10, 10)
#define RC_SEND_WQE_SE RC_SEND_WQE_FIELD_LOC(11, 11)
#define RC_SEND_WQE_INLINE RC_SEND_WQE_FIELD_LOC(12, 12)
#define RC_SEND_WQE_WQE_INDEX RC_SEND_WQE_FIELD_LOC(30, 15)
#define RC_SEND_WQE_FLAG RC_SEND_WQE_FIELD_LOC(31, 31)
#define RC_SEND_WQE_XRC_SRQN RC_SEND_WQE_FIELD_LOC(119, 96)
#define RC_SEND_WQE_SGE_NUM RC_SEND_WQE_FIELD_LOC(127, 120)
#define RC_SEND_WQE_MSG_START_SGE_IDX RC_SEND_WQE_FIELD_LOC(151, 128)
#define RC_SEND_WQE_INL_TYPE RC_SEND_WQE_FIELD_LOC(159, 159)

struct hns_roce_wqe_frmr_seg {
	__le32	pbl_size;
	__le32	byte_40;
};

#define FRMR_WQE_FIELD_LOC(h, l) FIELD_LOC(struct hns_roce_wqe_frmr_seg, h, l)

#define FRMR_PBL_SIZE FRMR_WQE_FIELD_LOC(31, 0)
#define FRMR_BLOCK_SIZE FRMR_WQE_FIELD_LOC(35, 32)
#define FRMR_PBL_BUF_PG_SZ FRMR_WQE_FIELD_LOC(39, 36)
#define FRMR_BLK_MODE FRMR_WQE_FIELD_LOC(40, 40)
#define FRMR_ZBVA FRMR_WQE_FIELD_LOC(41, 41)
#define FRMR_BIND_EN FRMR_WQE_FIELD_LOC(42, 42)
#define FRMR_ATOMIC FRMR_WQE_FIELD_LOC(43, 43)
#define FRMR_RR FRMR_WQE_FIELD_LOC(44, 44)
#define FRMR_RW FRMR_WQE_FIELD_LOC(45, 45)
#define FRMR_LW FRMR_WQE_FIELD_LOC(46, 46)

struct hns_roce_v2_wqe_data_seg {
	__le32    len;
	__le32    lkey;
	__le64    addr;
};

struct hns_roce_query_version {
	__le16 rocee_vendor_id;
	__le16 rocee_hw_version;
	__le32 rsv[5];
};

struct hns_roce_query_fw_info {
	__le32 fw_ver;
	__le32 rsv[5];
};

struct hns_roce_func_clear {
	__le32 rst_funcid_en;
	__le32 func_done;
	__le32 rsv[4];
};

#define FUNC_CLEAR_FIELD_LOC(h, l) FIELD_LOC(struct hns_roce_func_clear, h, l)

#define FUNC_CLEAR_RST_FUN_DONE FUNC_CLEAR_FIELD_LOC(32, 32)

/* Each physical function manages up to 248 virtual functions, it takes up to
 * 100ms for each function to execute clear. If an abnormal reset occurs, it is
 * executed twice at most, so it takes up to 249 * 2 * 100ms.
 */
#define HNS_ROCE_V2_FUNC_CLEAR_TIMEOUT_MSECS	(249 * 2 * 100)
#define HNS_ROCE_V2_READ_FUNC_CLEAR_FLAG_INTERVAL	40
#define HNS_ROCE_V2_READ_FUNC_CLEAR_FLAG_FAIL_WAIT	20

/* Fields of HNS_ROCE_OPC_EXT_CFG */
#define EXT_CFG_VF_ID CMQ_REQ_FIELD_LOC(31, 0)
#define EXT_CFG_QP_PI_IDX CMQ_REQ_FIELD_LOC(45, 32)
#define EXT_CFG_QP_PI_NUM CMQ_REQ_FIELD_LOC(63, 48)
#define EXT_CFG_QP_NUM CMQ_REQ_FIELD_LOC(87, 64)
#define EXT_CFG_QP_IDX CMQ_REQ_FIELD_LOC(119, 96)
#define EXT_CFG_LLM_IDX CMQ_REQ_FIELD_LOC(139, 128)
#define EXT_CFG_LLM_NUM CMQ_REQ_FIELD_LOC(156, 144)

#define CFG_LLM_A_BA_L CMQ_REQ_FIELD_LOC(31, 0)
#define CFG_LLM_A_BA_H CMQ_REQ_FIELD_LOC(63, 32)
#define CFG_LLM_A_DEPTH CMQ_REQ_FIELD_LOC(76, 64)
#define CFG_LLM_A_PGSZ CMQ_REQ_FIELD_LOC(83, 80)
#define CFG_LLM_A_INIT_EN CMQ_REQ_FIELD_LOC(84, 84)
#define CFG_LLM_A_HEAD_BA_L CMQ_REQ_FIELD_LOC(127, 96)
#define CFG_LLM_A_HEAD_BA_H CMQ_REQ_FIELD_LOC(147, 128)
#define CFG_LLM_A_HEAD_NXTPTR CMQ_REQ_FIELD_LOC(159, 148)
#define CFG_LLM_A_HEAD_PTR CMQ_REQ_FIELD_LOC(171, 160)
#define CFG_LLM_B_TAIL_BA_L CMQ_REQ_FIELD_LOC(31, 0)
#define CFG_LLM_B_TAIL_BA_H CMQ_REQ_FIELD_LOC(63, 32)
#define CFG_LLM_B_TAIL_PTR CMQ_REQ_FIELD_LOC(75, 64)

/* Fields of HNS_ROCE_OPC_CFG_GLOBAL_PARAM */
#define CFG_GLOBAL_PARAM_1US_CYCLES CMQ_REQ_FIELD_LOC(9, 0)
#define CFG_GLOBAL_PARAM_UDP_PORT CMQ_REQ_FIELD_LOC(31, 16)

/*
 * Fields of HNS_ROCE_OPC_QUERY_PF_RES, HNS_ROCE_OPC_QUERY_VF_RES
 * and HNS_ROCE_OPC_ALLOC_VF_RES
 */
#define FUNC_RES_A_VF_ID CMQ_REQ_FIELD_LOC(7, 0)
#define FUNC_RES_A_QPC_BT_IDX CMQ_REQ_FIELD_LOC(42, 32)
#define FUNC_RES_A_QPC_BT_NUM CMQ_REQ_FIELD_LOC(59, 48)
#define FUNC_RES_A_SRQC_BT_IDX CMQ_REQ_FIELD_LOC(72, 64)
#define FUNC_RES_A_SRQC_BT_NUM CMQ_REQ_FIELD_LOC(89, 80)
#define FUNC_RES_A_CQC_BT_IDX CMQ_REQ_FIELD_LOC(104, 96)
#define FUNC_RES_A_CQC_BT_NUM CMQ_REQ_FIELD_LOC(121, 112)
#define FUNC_RES_A_MPT_BT_IDX CMQ_REQ_FIELD_LOC(136, 128)
#define FUNC_RES_A_MPT_BT_NUM CMQ_REQ_FIELD_LOC(153, 144)
#define FUNC_RES_A_EQC_BT_IDX CMQ_REQ_FIELD_LOC(168, 160)
#define FUNC_RES_A_EQC_BT_NUM CMQ_REQ_FIELD_LOC(185, 176)
#define FUNC_RES_B_SMAC_IDX CMQ_REQ_FIELD_LOC(39, 32)
#define FUNC_RES_B_SMAC_NUM CMQ_REQ_FIELD_LOC(48, 40)
#define FUNC_RES_B_SGID_IDX CMQ_REQ_FIELD_LOC(71, 64)
#define FUNC_RES_B_SGID_NUM CMQ_REQ_FIELD_LOC(80, 72)
#define FUNC_RES_B_QID_IDX CMQ_REQ_FIELD_LOC(105, 96)
#define FUNC_RES_B_QID_NUM CMQ_REQ_FIELD_LOC(122, 112)
#define FUNC_RES_V_QID_NUM CMQ_REQ_FIELD_LOC(115, 112)

#define FUNC_RES_B_SCCC_BT_IDX CMQ_REQ_FIELD_LOC(136, 128)
#define FUNC_RES_B_SCCC_BT_NUM CMQ_REQ_FIELD_LOC(145, 137)
#define FUNC_RES_B_GMV_BT_IDX CMQ_REQ_FIELD_LOC(167, 160)
#define FUNC_RES_B_GMV_BT_NUM CMQ_REQ_FIELD_LOC(176, 168)
#define FUNC_RES_V_GMV_BT_NUM CMQ_REQ_FIELD_LOC(184, 176)

/* Fields of HNS_ROCE_OPC_QUERY_PF_TIMER_RES */
#define PF_TIMER_RES_QPC_ITEM_IDX CMQ_REQ_FIELD_LOC(43, 32)
#define PF_TIMER_RES_QPC_ITEM_NUM CMQ_REQ_FIELD_LOC(60, 48)
#define PF_TIMER_RES_CQC_ITEM_IDX CMQ_REQ_FIELD_LOC(74, 64)
#define PF_TIMER_RES_CQC_ITEM_NUM CMQ_REQ_FIELD_LOC(91, 80)

struct hns_roce_vf_switch {
	__le32 rocee_sel;
	__le32 fun_id;
	__le32 cfg;
	__le32 resv1;
	__le32 resv2;
	__le32 resv3;
};

#define VF_SWITCH_FIELD_LOC(h, l) FIELD_LOC(struct hns_roce_vf_switch, h, l)

#define VF_SWITCH_VF_ID VF_SWITCH_FIELD_LOC(42, 35)
#define VF_SWITCH_ALW_LPBK VF_SWITCH_FIELD_LOC(65, 65)
#define VF_SWITCH_ALW_LCL_LPBK VF_SWITCH_FIELD_LOC(66, 66)
#define VF_SWITCH_ALW_DST_OVRD VF_SWITCH_FIELD_LOC(67, 67)

struct hns_roce_post_mbox {
	__le32	in_param_l;
	__le32	in_param_h;
	__le32	out_param_l;
	__le32	out_param_h;
	__le32	cmd_tag;
	__le32	token_event_en;
};

struct hns_roce_mbox_status {
	__le32	mb_status_hw_run;
	__le32	rsv[5];
};

#define HNS_ROCE_V2_GO_BIT_TIMEOUT_MSECS 10000

#define MB_ST_HW_RUN_M BIT(31)
#define MB_ST_COMPLETE_M GENMASK(7, 0)

#define MB_ST_COMPLETE_SUCC 1

/* Fields of HNS_ROCE_OPC_CFG_BT_ATTR */
#define CFG_BT_ATTR_QPC_BA_PGSZ CMQ_REQ_FIELD_LOC(3, 0)
#define CFG_BT_ATTR_QPC_BUF_PGSZ CMQ_REQ_FIELD_LOC(7, 4)
#define CFG_BT_ATTR_QPC_HOPNUM CMQ_REQ_FIELD_LOC(9, 8)
#define CFG_BT_ATTR_SRQC_BA_PGSZ CMQ_REQ_FIELD_LOC(35, 32)
#define CFG_BT_ATTR_SRQC_BUF_PGSZ CMQ_REQ_FIELD_LOC(39, 36)
#define CFG_BT_ATTR_SRQC_HOPNUM CMQ_REQ_FIELD_LOC(41, 40)
#define CFG_BT_ATTR_CQC_BA_PGSZ CMQ_REQ_FIELD_LOC(67, 64)
#define CFG_BT_ATTR_CQC_BUF_PGSZ CMQ_REQ_FIELD_LOC(71, 68)
#define CFG_BT_ATTR_CQC_HOPNUM CMQ_REQ_FIELD_LOC(73, 72)
#define CFG_BT_ATTR_MPT_BA_PGSZ CMQ_REQ_FIELD_LOC(99, 96)
#define CFG_BT_ATTR_MPT_BUF_PGSZ CMQ_REQ_FIELD_LOC(103, 100)
#define CFG_BT_ATTR_MPT_HOPNUM CMQ_REQ_FIELD_LOC(105, 104)
#define CFG_BT_ATTR_SCCC_BA_PGSZ CMQ_REQ_FIELD_LOC(131, 128)
#define CFG_BT_ATTR_SCCC_BUF_PGSZ CMQ_REQ_FIELD_LOC(135, 132)
#define CFG_BT_ATTR_SCCC_HOPNUM CMQ_REQ_FIELD_LOC(137, 136)

/* Fields of HNS_ROCE_OPC_CFG_ENTRY_SIZE */
#define CFG_HEM_ENTRY_SIZE_TYPE CMQ_REQ_FIELD_LOC(31, 0)
enum {
	HNS_ROCE_CFG_QPC_SIZE = BIT(0),
	HNS_ROCE_CFG_SCCC_SIZE = BIT(1),
};

#define CFG_HEM_ENTRY_SIZE_VALUE CMQ_REQ_FIELD_LOC(191, 160)

/* Fields of HNS_ROCE_OPC_CFG_GMV_BT */
#define CFG_GMV_BT_BA_L CMQ_REQ_FIELD_LOC(31, 0)
#define CFG_GMV_BT_BA_H CMQ_REQ_FIELD_LOC(51, 32)
#define CFG_GMV_BT_IDX CMQ_REQ_FIELD_LOC(95, 64)

/* Fields of HNS_ROCE_QUERY_RAM_ECC */
#define QUERY_RAM_ECC_1BIT_ERR CMQ_REQ_FIELD_LOC(31, 0)
#define QUERY_RAM_ECC_RES_TYPE CMQ_REQ_FIELD_LOC(63, 32)
#define QUERY_RAM_ECC_TAG CMQ_REQ_FIELD_LOC(95, 64)

struct hns_roce_cfg_sgid_tb {
	__le32	table_idx_rsv;
	__le32	vf_sgid_l;
	__le32	vf_sgid_ml;
	__le32	vf_sgid_mh;
	__le32	vf_sgid_h;
	__le32	vf_sgid_type_rsv;
};

#define SGID_TB_FIELD_LOC(h, l) FIELD_LOC(struct hns_roce_cfg_sgid_tb, h, l)

#define CFG_SGID_TB_TABLE_IDX SGID_TB_FIELD_LOC(7, 0)
#define CFG_SGID_TB_VF_SGID_TYPE SGID_TB_FIELD_LOC(161, 160)

struct hns_roce_cfg_smac_tb {
	__le32	tb_idx_rsv;
	__le32	vf_smac_l;
	__le32	vf_smac_h_rsv;
	__le32	rsv[3];
};

#define SMAC_TB_FIELD_LOC(h, l) FIELD_LOC(struct hns_roce_cfg_smac_tb, h, l)

#define CFG_SMAC_TB_IDX SMAC_TB_FIELD_LOC(7, 0)
#define CFG_SMAC_TB_VF_SMAC_H SMAC_TB_FIELD_LOC(79, 64)

struct hns_roce_cfg_gmv_tb_a {
	__le32 vf_sgid_l;
	__le32 vf_sgid_ml;
	__le32 vf_sgid_mh;
	__le32 vf_sgid_h;
	__le32 vf_sgid_type_vlan;
	__le32 resv;
};

#define GMV_TB_A_FIELD_LOC(h, l) FIELD_LOC(struct hns_roce_cfg_gmv_tb_a, h, l)

#define GMV_TB_A_VF_SGID_TYPE GMV_TB_A_FIELD_LOC(129, 128)
#define GMV_TB_A_VF_VLAN_EN GMV_TB_A_FIELD_LOC(130, 130)
#define GMV_TB_A_VF_VLAN_ID GMV_TB_A_FIELD_LOC(155, 144)

struct hns_roce_cfg_gmv_tb_b {
	__le32	vf_smac_l;
	__le32	vf_smac_h;
	__le32	table_idx_rsv;
	__le32	resv[3];
};

#define GMV_TB_B_FIELD_LOC(h, l) FIELD_LOC(struct hns_roce_cfg_gmv_tb_b, h, l)

#define GMV_TB_B_SMAC_H GMV_TB_B_FIELD_LOC(47, 32)
#define GMV_TB_B_SGID_IDX GMV_TB_B_FIELD_LOC(71, 64)

#define HNS_ROCE_QUERY_PF_CAPS_CMD_NUM 5
struct hns_roce_query_pf_caps_a {
	u8 number_ports;
	u8 local_ca_ack_delay;
	__le16 max_sq_sg;
	__le16 max_sq_inline;
	__le16 max_rq_sg;
	__le32 max_extend_sg;
	__le16 num_qpc_timer;
	__le16 num_cqc_timer;
	__le16 max_srq_sges;
	u8 num_aeq_vectors;
	u8 num_other_vectors;
	u8 max_sq_desc_sz;
	u8 max_rq_desc_sz;
	u8 max_srq_desc_sz;
	u8 cqe_sz;
};

struct hns_roce_query_pf_caps_b {
	u8 mtpt_entry_sz;
	u8 irrl_entry_sz;
	u8 trrl_entry_sz;
	u8 cqc_entry_sz;
	u8 srqc_entry_sz;
	u8 idx_entry_sz;
	u8 sccc_sz;
	u8 max_mtu;
	__le16 qpc_sz;
	__le16 qpc_timer_entry_sz;
	__le16 cqc_timer_entry_sz;
	u8 min_cqes;
	u8 min_wqes;
	__le32 page_size_cap;
	u8 pkey_table_len;
	u8 phy_num_uars;
	u8 ctx_hop_num;
	u8 pbl_hop_num;
};

struct hns_roce_query_pf_caps_c {
	__le32 cap_flags_num_pds;
	__le32 max_gid_num_cqs;
	__le32 cq_depth;
	__le32 num_mrws;
	__le32 ord_num_qps;
	__le16 sq_depth;
	__le16 rq_depth;
};

#define PF_CAPS_C_FIELD_LOC(h, l) \
	FIELD_LOC(struct hns_roce_query_pf_caps_c, h, l)

#define PF_CAPS_C_NUM_PDS PF_CAPS_C_FIELD_LOC(19, 0)
#define PF_CAPS_C_CAP_FLAGS PF_CAPS_C_FIELD_LOC(31, 20)
#define PF_CAPS_C_NUM_CQS PF_CAPS_C_FIELD_LOC(51, 32)
#define PF_CAPS_C_MAX_GID PF_CAPS_C_FIELD_LOC(60, 52)
#define PF_CAPS_C_CQ_DEPTH PF_CAPS_C_FIELD_LOC(86, 64)
#define PF_CAPS_C_NUM_MRWS PF_CAPS_C_FIELD_LOC(115, 96)
#define PF_CAPS_C_NUM_QPS PF_CAPS_C_FIELD_LOC(147, 128)
#define PF_CAPS_C_MAX_ORD PF_CAPS_C_FIELD_LOC(155, 148)

struct hns_roce_query_pf_caps_d {
	__le32 wq_hop_num_max_srqs;
	__le16 srq_depth;
	__le16 cap_flags_ex;
	__le32 num_ceqs_ceq_depth;
	__le32 arm_st_aeq_depth;
	__le32 num_uars_rsv_pds;
	__le32 rsv_uars_rsv_qps;
};

#define PF_CAPS_D_FIELD_LOC(h, l) \
	FIELD_LOC(struct hns_roce_query_pf_caps_d, h, l)

#define PF_CAPS_D_NUM_SRQS PF_CAPS_D_FIELD_LOC(19, 0)
#define PF_CAPS_D_RQWQE_HOP_NUM PF_CAPS_D_FIELD_LOC(21, 20)
#define PF_CAPS_D_EX_SGE_HOP_NUM PF_CAPS_D_FIELD_LOC(23, 22)
#define PF_CAPS_D_SQWQE_HOP_NUM PF_CAPS_D_FIELD_LOC(25, 24)
#define PF_CAPS_D_CONG_TYPE PF_CAPS_D_FIELD_LOC(29, 26)
#define PF_CAPS_D_CEQ_DEPTH PF_CAPS_D_FIELD_LOC(85, 64)
#define PF_CAPS_D_NUM_CEQS PF_CAPS_D_FIELD_LOC(95, 86)
#define PF_CAPS_D_AEQ_DEPTH PF_CAPS_D_FIELD_LOC(117, 96)
#define PF_CAPS_D_AEQ_ARM_ST PF_CAPS_D_FIELD_LOC(119, 118)
#define PF_CAPS_D_CEQ_ARM_ST PF_CAPS_D_FIELD_LOC(121, 120)
#define PF_CAPS_D_RSV_PDS PF_CAPS_D_FIELD_LOC(147, 128)
#define PF_CAPS_D_NUM_UARS PF_CAPS_D_FIELD_LOC(155, 148)
#define PF_CAPS_D_RSV_QPS PF_CAPS_D_FIELD_LOC(179, 160)
#define PF_CAPS_D_RSV_UARS PF_CAPS_D_FIELD_LOC(187, 180)

#define HNS_ROCE_CAP_FLAGS_EX_SHIFT 12

struct hns_roce_congestion_algorithm {
	u8 alg_sel;
	u8 alg_sub_sel;
	u8 dip_vld;
	u8 wnd_mode_sel;
};

struct hns_roce_query_pf_caps_e {
	__le32 chunk_size_shift_rsv_mrws;
	__le32 rsv_cqs;
	__le32 rsv_srqs;
	__le32 rsv_lkey;
	__le16 ceq_max_cnt;
	__le16 ceq_period;
	__le16 aeq_max_cnt;
	__le16 aeq_period;
};

#define PF_CAPS_E_FIELD_LOC(h, l) \
	FIELD_LOC(struct hns_roce_query_pf_caps_e, h, l)

#define PF_CAPS_E_RSV_MRWS PF_CAPS_E_FIELD_LOC(19, 0)
#define PF_CAPS_E_CHUNK_SIZE_SHIFT PF_CAPS_E_FIELD_LOC(31, 20)
#define PF_CAPS_E_RSV_CQS PF_CAPS_E_FIELD_LOC(51, 32)
#define PF_CAPS_E_RSV_SRQS PF_CAPS_E_FIELD_LOC(83, 64)
#define PF_CAPS_E_RSV_LKEYS PF_CAPS_E_FIELD_LOC(115, 96)

struct hns_roce_cmq_req {
	__le32 data[6];
};

#define CMQ_REQ_FIELD_LOC(h, l) FIELD_LOC(struct hns_roce_cmq_req, h, l)

struct hns_roce_cmq_desc {
	__le16 opcode;
	__le16 flag;
	__le16 retval;
	__le16 rsv;
	union {
		__le32 data[6];
		struct {
			__le32 own_func_num;
			__le32 own_mac_id;
			__le32 rsv[4];
		} func_info;
	};
};

struct hns_roce_v2_cmq_ring {
	dma_addr_t desc_dma_addr;
	struct hns_roce_cmq_desc *desc;
	u32 head;
	u16 buf_size;
	u16 desc_num;
	u8 flag;
	spinlock_t lock; /* command queue lock */
};

struct hns_roce_v2_cmq {
	struct hns_roce_v2_cmq_ring csq;
	u16 tx_timeout;
};

struct hns_roce_link_table {
	struct hns_roce_buf_list table;
	struct hns_roce_buf *buf;
};

#define HNS_ROCE_EXT_LLM_ENTRY(addr, id) (((id) << (64 - 12)) | ((addr) >> 12))
#define HNS_ROCE_EXT_LLM_MIN_PAGES(que_num) ((que_num) * 4 + 2)

struct hns_roce_v2_priv {
	struct hnae3_handle *handle;
	struct hns_roce_v2_cmq cmq;
	struct hns_roce_link_table ext_llm;
};

struct hns_roce_dip {
	u8 dgid[GID_LEN_V2];
	u32 dip_idx;
	struct list_head node; /* all dips are on a list */
};

struct fmea_ram_ecc {
	u32	is_ecc_err;
	u32	res_type;
	u32	index;
};


#define HNS_ROCE_AEQ_DEFAULT_BURST_NUM	0x0
#define HNS_ROCE_AEQ_DEFAULT_INTERVAL	0x0
#define HNS_ROCE_CEQ_DEFAULT_BURST_NUM	0x0
#define HNS_ROCE_CEQ_DEFAULT_INTERVAL	0x0

#define HNS_ROCE_V2_EQ_STATE_INVALID		0
#define HNS_ROCE_V2_EQ_STATE_VALID		1
#define HNS_ROCE_V2_EQ_STATE_OVERFLOW		2
#define HNS_ROCE_V2_EQ_STATE_FAILURE		3

#define HNS_ROCE_V2_EQ_OVER_IGNORE_0		0
#define HNS_ROCE_V2_EQ_OVER_IGNORE_1		1

#define HNS_ROCE_V2_EQ_COALESCE_0		0
#define HNS_ROCE_V2_EQ_COALESCE_1		1

#define HNS_ROCE_V2_EQ_FIRED			0
#define HNS_ROCE_V2_EQ_ARMED			1
#define HNS_ROCE_V2_EQ_ALWAYS_ARMED		3

#define HNS_ROCE_EQ_INIT_EQE_CNT		0
#define HNS_ROCE_EQ_INIT_PROD_IDX		0
#define HNS_ROCE_EQ_INIT_REPORT_TIMER		0
#define HNS_ROCE_EQ_INIT_MSI_IDX		0
#define HNS_ROCE_EQ_INIT_CONS_IDX		0
#define HNS_ROCE_EQ_INIT_NXT_EQE_BA		0

#define HNS_ROCE_V2_COMP_EQE_NUM		0x1000
#define HNS_ROCE_V2_ASYNC_EQE_NUM		0x1000

#define HNS_ROCE_V2_VF_INT_ST_AEQ_OVERFLOW_S	0

#define HNS_ROCE_EQ_DB_CMD_AEQ			0x0
#define HNS_ROCE_EQ_DB_CMD_AEQ_ARMED		0x1
#define HNS_ROCE_EQ_DB_CMD_CEQ			0x2
#define HNS_ROCE_EQ_DB_CMD_CEQ_ARMED		0x3

#define EQ_ENABLE				1
#define EQ_DISABLE				0

#define EQ_REG_OFFSET				0x4

#define HNS_ROCE_INT_NAME_LEN			32
#define HNS_ROCE_V2_EQN_M GENMASK(23, 0)

#define HNS_ROCE_V2_VF_ABN_INT_EN_S 0
#define HNS_ROCE_V2_VF_ABN_INT_EN_M GENMASK(0, 0)
#define HNS_ROCE_V2_VF_ABN_INT_ST_M GENMASK(2, 0)
#define HNS_ROCE_V2_VF_ABN_INT_CFG_M GENMASK(2, 0)
#define HNS_ROCE_V2_VF_EVENT_INT_EN_M GENMASK(0, 0)

struct hns_roce_eq_context {
	__le32	data[16];
};

#define EQC_FIELD_LOC(h, l) FIELD_LOC(struct hns_roce_eq_context, h, l)

#define EQC_EQ_ST EQC_FIELD_LOC(1, 0)
#define EQC_EQE_HOP_NUM EQC_FIELD_LOC(3, 2)
#define EQC_OVER_IGNORE EQC_FIELD_LOC(4, 4)
#define EQC_COALESCE EQC_FIELD_LOC(5, 5)
#define EQC_ARM_ST EQC_FIELD_LOC(7, 6)
#define EQC_EQN EQC_FIELD_LOC(15, 8)
#define EQC_EQE_CNT EQC_FIELD_LOC(31, 16)
#define EQC_EQE_BA_PG_SZ EQC_FIELD_LOC(35, 32)
#define EQC_EQE_BUF_PG_SZ EQC_FIELD_LOC(39, 36)
#define EQC_EQ_PROD_INDX EQC_FIELD_LOC(63, 40)
#define EQC_EQ_MAX_CNT EQC_FIELD_LOC(79, 64)
#define EQC_EQ_PERIOD EQC_FIELD_LOC(95, 80)
#define EQC_EQE_REPORT_TIMER EQC_FIELD_LOC(127, 96)
#define EQC_EQE_BA_L EQC_FIELD_LOC(159, 128)
#define EQC_EQE_BA_H EQC_FIELD_LOC(188, 160)
#define EQC_SHIFT EQC_FIELD_LOC(199, 192)
#define EQC_MSI_INDX EQC_FIELD_LOC(207, 200)
#define EQC_CUR_EQE_BA_L EQC_FIELD_LOC(223, 208)
#define EQC_CUR_EQE_BA_M EQC_FIELD_LOC(255, 224)
#define EQC_CUR_EQE_BA_H EQC_FIELD_LOC(259, 256)
#define EQC_EQ_CONS_INDX EQC_FIELD_LOC(287, 264)
#define EQC_NEX_EQE_BA_L EQC_FIELD_LOC(319, 288)
#define EQC_NEX_EQE_BA_H EQC_FIELD_LOC(339, 320)
#define EQC_EQE_SIZE EQC_FIELD_LOC(341, 340)

#define MAX_SERVICE_LEVEL 0x7

struct hns_roce_wqe_atomic_seg {
	__le64          fetchadd_swap_data;
	__le64          cmp_data;
};

struct hns_roce_sccc_clr {
	__le32 qpn;
	__le32 rsv[5];
};

struct hns_roce_sccc_clr_done {
	__le32 clr_done;
	__le32 rsv[5];
};

int hns_roce_v2_query_cqc_info(struct hns_roce_dev *hr_dev, u32 cqn,
			       int *buffer);

static inline void hns_roce_write64(struct hns_roce_dev *hr_dev, __le32 val[2],
				    void __iomem *dest)
{
	struct hns_roce_v2_priv *priv = hr_dev->priv;
	struct hnae3_handle *handle = priv->handle;
	const struct hnae3_ae_ops *ops = handle->ae_algo->ops;

	if (!hr_dev->dis_db && !ops->get_hw_reset_stat(handle))
		hns_roce_write64_k(val, dest);
}

#endif
