/*
 * Broadcom NetXtreme-E RoCE driver.
 *
 * Copyright (c) 2016 - 2017, Broadcom. All rights reserved.  The term
 * Broadcom refers to Broadcom Limited and/or its subsidiaries.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * BSD license below:
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Description: RoCE HSI File - Autogenerated
 */

#ifndef __BNXT_RE_HSI_H__
#define __BNXT_RE_HSI_H__

/* include bnxt_hsi.h from bnxt_en driver */
#include "bnxt_hsi.h"

/* CMP Door Bell Format (4 bytes) */
struct cmpl_doorbell {
	__le32 key_mask_valid_idx;
	#define CMPL_DOORBELL_IDX_MASK				    0xffffffUL
	#define CMPL_DOORBELL_IDX_SFT				    0
	#define CMPL_DOORBELL_RESERVED_MASK			    0x3000000UL
	#define CMPL_DOORBELL_RESERVED_SFT			    24
	#define CMPL_DOORBELL_IDX_VALID			    0x4000000UL
	#define CMPL_DOORBELL_MASK				    0x8000000UL
	#define CMPL_DOORBELL_KEY_MASK				    0xf0000000UL
	#define CMPL_DOORBELL_KEY_SFT				    28
	#define CMPL_DOORBELL_KEY_CMPL				   (0x2UL << 28)
};

/* Status Door Bell Format (4 bytes) */
struct status_doorbell {
	__le32 key_idx;
	#define STATUS_DOORBELL_IDX_MASK			    0xffffffUL
	#define STATUS_DOORBELL_IDX_SFT			    0
	#define STATUS_DOORBELL_RESERVED_MASK			    0xf000000UL
	#define STATUS_DOORBELL_RESERVED_SFT			    24
	#define STATUS_DOORBELL_KEY_MASK			    0xf0000000UL
	#define STATUS_DOORBELL_KEY_SFT			    28
	#define STATUS_DOORBELL_KEY_STAT			   (0x3UL << 28)
};

/* RoCE Host Structures */

/* Doorbell Structures */
/* 64b Doorbell Format (8 bytes) */
struct dbr_dbr {
	__le32 index;
	#define DBR_DBR_INDEX_MASK				    0xfffffUL
	#define DBR_DBR_INDEX_SFT				    0
	#define DBR_DBR_RESERVED12_MASK			    0xfff00000UL
	#define DBR_DBR_RESERVED12_SFT				    20
	__le32 type_xid;
	#define DBR_DBR_XID_MASK				    0xfffffUL
	#define DBR_DBR_XID_SFT				    0
	#define DBR_DBR_RESERVED8_MASK				    0xff00000UL
	#define DBR_DBR_RESERVED8_SFT				    20
	#define DBR_DBR_TYPE_MASK				    0xf0000000UL
	#define DBR_DBR_TYPE_SFT				    28
	#define DBR_DBR_TYPE_SQ				   (0x0UL << 28)
	#define DBR_DBR_TYPE_RQ				   (0x1UL << 28)
	#define DBR_DBR_TYPE_SRQ				   (0x2UL << 28)
	#define DBR_DBR_TYPE_SRQ_ARM				   (0x3UL << 28)
	#define DBR_DBR_TYPE_CQ				   (0x4UL << 28)
	#define DBR_DBR_TYPE_CQ_ARMSE				   (0x5UL << 28)
	#define DBR_DBR_TYPE_CQ_ARMALL				   (0x6UL << 28)
	#define DBR_DBR_TYPE_CQ_ARMENA				   (0x7UL << 28)
	#define DBR_DBR_TYPE_SRQ_ARMENA			   (0x8UL << 28)
	#define DBR_DBR_TYPE_CQ_CUTOFF_ACK			   (0x9UL << 28)
	#define DBR_DBR_TYPE_NULL				   (0xfUL << 28)
};

/* 32b Doorbell Format (4 bytes) */
struct dbr_dbr32 {
	__le32 type_abs_incr_xid;
	#define DBR_DBR32_XID_MASK				    0xfffffUL
	#define DBR_DBR32_XID_SFT				    0
	#define DBR_DBR32_RESERVED4_MASK			    0xf00000UL
	#define DBR_DBR32_RESERVED4_SFT			    20
	#define DBR_DBR32_INCR_MASK				    0xf000000UL
	#define DBR_DBR32_INCR_SFT				    24
	#define DBR_DBR32_ABS					    0x10000000UL
	#define DBR_DBR32_TYPE_MASK				    0xe0000000UL
	#define DBR_DBR32_TYPE_SFT				    29
	#define DBR_DBR32_TYPE_SQ				   (0x0UL << 29)
};

/* SQ WQE Structures */
/* Base SQ WQE (8 bytes) */
struct sq_base {
	u8 wqe_type;
	#define SQ_BASE_WQE_TYPE_SEND				   0x0UL
	#define SQ_BASE_WQE_TYPE_SEND_W_IMMEAD			   0x1UL
	#define SQ_BASE_WQE_TYPE_SEND_W_INVALID		   0x2UL
	#define SQ_BASE_WQE_TYPE_WRITE_WQE			   0x4UL
	#define SQ_BASE_WQE_TYPE_WRITE_W_IMMEAD		   0x5UL
	#define SQ_BASE_WQE_TYPE_READ_WQE			   0x6UL
	#define SQ_BASE_WQE_TYPE_ATOMIC_CS			   0x8UL
	#define SQ_BASE_WQE_TYPE_ATOMIC_FA			   0xbUL
	#define SQ_BASE_WQE_TYPE_LOCAL_INVALID			   0xcUL
	#define SQ_BASE_WQE_TYPE_FR_PMR			   0xdUL
	#define SQ_BASE_WQE_TYPE_BIND				   0xeUL
	u8 unused_0[7];
};

/* WQE SGE (16 bytes) */
struct sq_sge {
	__le64 va_or_pa;
	__le32 l_key;
	__le32 size;
};

/* PSN Search Structure (8 bytes) */
struct sq_psn_search {
	__le32 opcode_start_psn;
	#define SQ_PSN_SEARCH_START_PSN_MASK			    0xffffffUL
	#define SQ_PSN_SEARCH_START_PSN_SFT			    0
	#define SQ_PSN_SEARCH_OPCODE_MASK			    0xff000000UL
	#define SQ_PSN_SEARCH_OPCODE_SFT			    24
	__le32 flags_next_psn;
	#define SQ_PSN_SEARCH_NEXT_PSN_MASK			    0xffffffUL
	#define SQ_PSN_SEARCH_NEXT_PSN_SFT			    0
	#define SQ_PSN_SEARCH_FLAGS_MASK			    0xff000000UL
	#define SQ_PSN_SEARCH_FLAGS_SFT			    24
};

/* Send SQ WQE (40 bytes) */
struct sq_send {
	u8 wqe_type;
	#define SQ_SEND_WQE_TYPE_SEND				   0x0UL
	#define SQ_SEND_WQE_TYPE_SEND_W_IMMEAD			   0x1UL
	#define SQ_SEND_WQE_TYPE_SEND_W_INVALID		   0x2UL
	u8 flags;
	#define SQ_SEND_FLAGS_SIGNAL_COMP			    0x1UL
	#define SQ_SEND_FLAGS_RD_OR_ATOMIC_FENCE		    0x2UL
	#define SQ_SEND_FLAGS_UC_FENCE				    0x4UL
	#define SQ_SEND_FLAGS_SE				    0x8UL
	#define SQ_SEND_FLAGS_INLINE				    0x10UL
	u8 wqe_size;
	u8 reserved8_1;
	__le32 inv_key_or_imm_data;
	__le32 length;
	__le32 q_key;
	__le32 dst_qp;
	#define SQ_SEND_DST_QP_MASK				    0xffffffUL
	#define SQ_SEND_DST_QP_SFT				    0
	#define SQ_SEND_RESERVED8_2_MASK			    0xff000000UL
	#define SQ_SEND_RESERVED8_2_SFT			    24
	__le32 avid;
	#define SQ_SEND_AVID_MASK				    0xfffffUL
	#define SQ_SEND_AVID_SFT				    0
	#define SQ_SEND_RESERVED_AVID_MASK			    0xfff00000UL
	#define SQ_SEND_RESERVED_AVID_SFT			    20
	__le64 reserved64;
	__le32 data[24];
};

/* Send Raw Ethernet and QP1 SQ WQE (40 bytes) */
struct sq_send_raweth_qp1 {
	u8 wqe_type;
	#define SQ_SEND_RAWETH_QP1_WQE_TYPE_SEND		   0x0UL
	u8 flags;
	#define SQ_SEND_RAWETH_QP1_FLAGS_SIGNAL_COMP		    0x1UL
	#define SQ_SEND_RAWETH_QP1_FLAGS_RD_OR_ATOMIC_FENCE	    0x2UL
	#define SQ_SEND_RAWETH_QP1_FLAGS_UC_FENCE		    0x4UL
	#define SQ_SEND_RAWETH_QP1_FLAGS_SE			    0x8UL
	#define SQ_SEND_RAWETH_QP1_FLAGS_INLINE		    0x10UL
	u8 wqe_size;
	u8 reserved8;
	__le16 lflags;
	#define SQ_SEND_RAWETH_QP1_LFLAGS_TCP_UDP_CHKSUM	    0x1UL
	#define SQ_SEND_RAWETH_QP1_LFLAGS_IP_CHKSUM		    0x2UL
	#define SQ_SEND_RAWETH_QP1_LFLAGS_NOCRC		    0x4UL
	#define SQ_SEND_RAWETH_QP1_LFLAGS_STAMP		    0x8UL
	#define SQ_SEND_RAWETH_QP1_LFLAGS_T_IP_CHKSUM		    0x10UL
	#define SQ_SEND_RAWETH_QP1_LFLAGS_RESERVED1_1		    0x20UL
	#define SQ_SEND_RAWETH_QP1_LFLAGS_RESERVED1_2		    0x40UL
	#define SQ_SEND_RAWETH_QP1_LFLAGS_RESERVED1_3		    0x80UL
	#define SQ_SEND_RAWETH_QP1_LFLAGS_ROCE_CRC		    0x100UL
	#define SQ_SEND_RAWETH_QP1_LFLAGS_FCOE_CRC		    0x200UL
	__le16 cfa_action;
	__le32 length;
	__le32 reserved32_1;
	__le32 cfa_meta;
	#define SQ_SEND_RAWETH_QP1_CFA_META_VLAN_VID_MASK	    0xfffUL
	#define SQ_SEND_RAWETH_QP1_CFA_META_VLAN_VID_SFT	    0
	#define SQ_SEND_RAWETH_QP1_CFA_META_VLAN_DE		    0x1000UL
	#define SQ_SEND_RAWETH_QP1_CFA_META_VLAN_PRI_MASK	    0xe000UL
	#define SQ_SEND_RAWETH_QP1_CFA_META_VLAN_PRI_SFT	    13
	#define SQ_SEND_RAWETH_QP1_CFA_META_VLAN_TPID_MASK	    0x70000UL
	#define SQ_SEND_RAWETH_QP1_CFA_META_VLAN_TPID_SFT	    16
	#define SQ_SEND_RAWETH_QP1_CFA_META_VLAN_TPID_TPID88A8    (0x0UL << 16)
	#define SQ_SEND_RAWETH_QP1_CFA_META_VLAN_TPID_TPID8100    (0x1UL << 16)
	#define SQ_SEND_RAWETH_QP1_CFA_META_VLAN_TPID_TPID9100    (0x2UL << 16)
	#define SQ_SEND_RAWETH_QP1_CFA_META_VLAN_TPID_TPID9200    (0x3UL << 16)
	#define SQ_SEND_RAWETH_QP1_CFA_META_VLAN_TPID_TPID9300    (0x4UL << 16)
	#define SQ_SEND_RAWETH_QP1_CFA_META_VLAN_TPID_TPIDCFG     (0x5UL << 16)
	#define SQ_SEND_RAWETH_QP1_CFA_META_VLAN_TPID_LAST	\
				SQ_SEND_RAWETH_QP1_CFA_META_VLAN_TPID_TPIDCFG
	#define SQ_SEND_RAWETH_QP1_CFA_META_VLAN_RESERVED_MASK     0xff80000UL
	#define SQ_SEND_RAWETH_QP1_CFA_META_VLAN_RESERVED_SFT      19
	#define SQ_SEND_RAWETH_QP1_CFA_META_KEY_MASK		    0xf0000000UL
	#define SQ_SEND_RAWETH_QP1_CFA_META_KEY_SFT		    28
	#define SQ_SEND_RAWETH_QP1_CFA_META_KEY_NONE		   (0x0UL << 28)
	#define SQ_SEND_RAWETH_QP1_CFA_META_KEY_VLAN_TAG	   (0x1UL << 28)
	#define SQ_SEND_RAWETH_QP1_CFA_META_KEY_LAST		\
				SQ_SEND_RAWETH_QP1_CFA_META_KEY_VLAN_TAG
	__le32 reserved32_2;
	__le64 reserved64;
	__le32 data[24];
};

/* RDMA SQ WQE (40 bytes) */
struct sq_rdma {
	u8 wqe_type;
	#define SQ_RDMA_WQE_TYPE_WRITE_WQE			   0x4UL
	#define SQ_RDMA_WQE_TYPE_WRITE_W_IMMEAD		   0x5UL
	#define SQ_RDMA_WQE_TYPE_READ_WQE			   0x6UL
	u8 flags;
	#define SQ_RDMA_FLAGS_SIGNAL_COMP			    0x1UL
	#define SQ_RDMA_FLAGS_RD_OR_ATOMIC_FENCE		    0x2UL
	#define SQ_RDMA_FLAGS_UC_FENCE				    0x4UL
	#define SQ_RDMA_FLAGS_SE				    0x8UL
	#define SQ_RDMA_FLAGS_INLINE				    0x10UL
	u8 wqe_size;
	u8 reserved8;
	__le32 imm_data;
	__le32 length;
	__le32 reserved32_1;
	__le64 remote_va;
	__le32 remote_key;
	__le32 reserved32_2;
	__le32 data[24];
};

/* Atomic SQ WQE (40 bytes) */
struct sq_atomic {
	u8 wqe_type;
	#define SQ_ATOMIC_WQE_TYPE_ATOMIC_CS			   0x8UL
	#define SQ_ATOMIC_WQE_TYPE_ATOMIC_FA			   0xbUL
	u8 flags;
	#define SQ_ATOMIC_FLAGS_SIGNAL_COMP			    0x1UL
	#define SQ_ATOMIC_FLAGS_RD_OR_ATOMIC_FENCE		    0x2UL
	#define SQ_ATOMIC_FLAGS_UC_FENCE			    0x4UL
	#define SQ_ATOMIC_FLAGS_SE				    0x8UL
	#define SQ_ATOMIC_FLAGS_INLINE				    0x10UL
	__le16 reserved16;
	__le32 remote_key;
	__le64 remote_va;
	__le64 swap_data;
	__le64 cmp_data;
	__le32 data[24];
};

/* Local Invalidate SQ WQE (40 bytes) */
struct sq_localinvalidate {
	u8 wqe_type;
	#define SQ_LOCALINVALIDATE_WQE_TYPE_LOCAL_INVALID	   0xcUL
	u8 flags;
	#define SQ_LOCALINVALIDATE_FLAGS_SIGNAL_COMP		    0x1UL
	#define SQ_LOCALINVALIDATE_FLAGS_RD_OR_ATOMIC_FENCE	    0x2UL
	#define SQ_LOCALINVALIDATE_FLAGS_UC_FENCE		    0x4UL
	#define SQ_LOCALINVALIDATE_FLAGS_SE			    0x8UL
	#define SQ_LOCALINVALIDATE_FLAGS_INLINE		    0x10UL
	__le16 reserved16;
	__le32 inv_l_key;
	__le64 reserved64;
	__le32 reserved128[4];
	__le32 data[24];
};

/* FR-PMR SQ WQE (40 bytes) */
struct sq_fr_pmr {
	u8 wqe_type;
	#define SQ_FR_PMR_WQE_TYPE_FR_PMR			   0xdUL
	u8 flags;
	#define SQ_FR_PMR_FLAGS_SIGNAL_COMP			    0x1UL
	#define SQ_FR_PMR_FLAGS_RD_OR_ATOMIC_FENCE		    0x2UL
	#define SQ_FR_PMR_FLAGS_UC_FENCE			    0x4UL
	#define SQ_FR_PMR_FLAGS_SE				    0x8UL
	#define SQ_FR_PMR_FLAGS_INLINE				    0x10UL
	u8 access_cntl;
	#define SQ_FR_PMR_ACCESS_CNTL_LOCAL_WRITE		    0x1UL
	#define SQ_FR_PMR_ACCESS_CNTL_REMOTE_READ		    0x2UL
	#define SQ_FR_PMR_ACCESS_CNTL_REMOTE_WRITE		    0x4UL
	#define SQ_FR_PMR_ACCESS_CNTL_REMOTE_ATOMIC		    0x8UL
	#define SQ_FR_PMR_ACCESS_CNTL_WINDOW_BIND		    0x10UL
	u8 zero_based_page_size_log;
	#define SQ_FR_PMR_PAGE_SIZE_LOG_MASK			    0x1fUL
	#define SQ_FR_PMR_PAGE_SIZE_LOG_SFT			    0
	#define SQ_FR_PMR_PAGE_SIZE_LOG_PGSZ_4K		   0x0UL
	#define SQ_FR_PMR_PAGE_SIZE_LOG_PGSZ_8K		   0x1UL
	#define SQ_FR_PMR_PAGE_SIZE_LOG_PGSZ_64K		   0x4UL
	#define SQ_FR_PMR_PAGE_SIZE_LOG_PGSZ_256K		   0x6UL
	#define SQ_FR_PMR_PAGE_SIZE_LOG_PGSZ_1M		   0x8UL
	#define SQ_FR_PMR_PAGE_SIZE_LOG_PGSZ_2M		   0x9UL
	#define SQ_FR_PMR_PAGE_SIZE_LOG_PGSZ_4M		   0xaUL
	#define SQ_FR_PMR_PAGE_SIZE_LOG_PGSZ_1G		   0x12UL
	#define SQ_FR_PMR_ZERO_BASED				    0x20UL
	#define SQ_FR_PMR_RESERVED2_MASK			    0xc0UL
	#define SQ_FR_PMR_RESERVED2_SFT			    6
	__le32 l_key;
	u8 length[5];
	u8 reserved8_1;
	u8 reserved8_2;
	u8 numlevels_pbl_page_size_log;
	#define SQ_FR_PMR_PBL_PAGE_SIZE_LOG_MASK		    0x1fUL
	#define SQ_FR_PMR_PBL_PAGE_SIZE_LOG_SFT		    0
	#define SQ_FR_PMR_PBL_PAGE_SIZE_LOG_PGSZ_4K		   0x0UL
	#define SQ_FR_PMR_PBL_PAGE_SIZE_LOG_PGSZ_8K		   0x1UL
	#define SQ_FR_PMR_PBL_PAGE_SIZE_LOG_PGSZ_64K		   0x4UL
	#define SQ_FR_PMR_PBL_PAGE_SIZE_LOG_PGSZ_256K		   0x6UL
	#define SQ_FR_PMR_PBL_PAGE_SIZE_LOG_PGSZ_1M		   0x8UL
	#define SQ_FR_PMR_PBL_PAGE_SIZE_LOG_PGSZ_2M		   0x9UL
	#define SQ_FR_PMR_PBL_PAGE_SIZE_LOG_PGSZ_4M		   0xaUL
	#define SQ_FR_PMR_PBL_PAGE_SIZE_LOG_PGSZ_1G		   0x12UL
	#define SQ_FR_PMR_RESERVED1				    0x20UL
	#define SQ_FR_PMR_NUMLEVELS_MASK			    0xc0UL
	#define SQ_FR_PMR_NUMLEVELS_SFT			    6
	#define SQ_FR_PMR_NUMLEVELS_PHYSICAL			   (0x0UL << 6)
	#define SQ_FR_PMR_NUMLEVELS_LAYER1			   (0x1UL << 6)
	#define SQ_FR_PMR_NUMLEVELS_LAYER2			   (0x2UL << 6)
	__le64 pblptr;
	__le64 va;
	__le32 data[24];
};

/* Bind SQ WQE (40 bytes) */
struct sq_bind {
	u8 wqe_type;
	#define SQ_BIND_WQE_TYPE_BIND				   0xeUL
	u8 flags;
	#define SQ_BIND_FLAGS_SIGNAL_COMP			    0x1UL
	#define SQ_BIND_FLAGS_RD_OR_ATOMIC_FENCE		    0x2UL
	#define SQ_BIND_FLAGS_UC_FENCE				    0x4UL
	#define SQ_BIND_FLAGS_SE				    0x8UL
	#define SQ_BIND_FLAGS_INLINE				    0x10UL
	u8 access_cntl;
	#define SQ_BIND_ACCESS_CNTL_LOCAL_WRITE		    0x1UL
	#define SQ_BIND_ACCESS_CNTL_REMOTE_READ		    0x2UL
	#define SQ_BIND_ACCESS_CNTL_REMOTE_WRITE		    0x4UL
	#define SQ_BIND_ACCESS_CNTL_REMOTE_ATOMIC		    0x8UL
	#define SQ_BIND_ACCESS_CNTL_WINDOW_BIND		    0x10UL
	u8 reserved8_1;
	u8 mw_type_zero_based;
	#define SQ_BIND_ZERO_BASED				    0x1UL
	#define SQ_BIND_MW_TYPE				    0x2UL
	#define SQ_BIND_MW_TYPE_TYPE1				   (0x0UL << 1)
	#define SQ_BIND_MW_TYPE_TYPE2				   (0x1UL << 1)
	#define SQ_BIND_RESERVED6_MASK				    0xfcUL
	#define SQ_BIND_RESERVED6_SFT				    2
	u8 reserved8_2;
	__le16 reserved16;
	__le32 parent_l_key;
	__le32 l_key;
	__le64 va;
	u8 length[5];
	u8 data_reserved24[99];
	#define SQ_BIND_RESERVED24_MASK			    0xffffff00UL
	#define SQ_BIND_RESERVED24_SFT				    8
	#define SQ_BIND_DATA_MASK				    0xffffffffUL
	#define SQ_BIND_DATA_SFT				    0
};

/* RQ/SRQ WQE Structures */
/* RQ/SRQ WQE (40 bytes) */
struct rq_wqe {
	u8 wqe_type;
	#define RQ_WQE_WQE_TYPE_RCV				   0x80UL
	u8 flags;
	u8 wqe_size;
	u8 reserved8;
	__le32 reserved32;
	__le32 wr_id[2];
	#define RQ_WQE_WR_ID_MASK				    0xfffffUL
	#define RQ_WQE_WR_ID_SFT				    0
	#define RQ_WQE_RESERVED44_MASK				    0xfff00000UL
	#define RQ_WQE_RESERVED44_SFT				    20
	__le32 reserved128[4];
	__le32 data[24];
};

/* CQ CQE Structures */
/* Base CQE (32 bytes) */
struct cq_base {
	__le64 reserved64_1;
	__le64 reserved64_2;
	__le64 reserved64_3;
	u8 cqe_type_toggle;
	#define CQ_BASE_TOGGLE					    0x1UL
	#define CQ_BASE_CQE_TYPE_MASK				    0x1eUL
	#define CQ_BASE_CQE_TYPE_SFT				    1
	#define CQ_BASE_CQE_TYPE_REQ				   (0x0UL << 1)
	#define CQ_BASE_CQE_TYPE_RES_RC			   (0x1UL << 1)
	#define CQ_BASE_CQE_TYPE_RES_UD			   (0x2UL << 1)
	#define CQ_BASE_CQE_TYPE_RES_RAWETH_QP1		   (0x3UL << 1)
	#define CQ_BASE_CQE_TYPE_TERMINAL			   (0xeUL << 1)
	#define CQ_BASE_CQE_TYPE_CUT_OFF			   (0xfUL << 1)
	#define CQ_BASE_RESERVED3_MASK				    0xe0UL
	#define CQ_BASE_RESERVED3_SFT				    5
	u8 status;
	__le16 reserved16;
	__le32 reserved32;
};

/* Requester CQ CQE (32 bytes) */
struct cq_req {
	__le64 qp_handle;
	__le16 sq_cons_idx;
	__le16 reserved16_1;
	__le32 reserved32_2;
	__le64 reserved64;
	u8 cqe_type_toggle;
	#define CQ_REQ_TOGGLE					    0x1UL
	#define CQ_REQ_CQE_TYPE_MASK				    0x1eUL
	#define CQ_REQ_CQE_TYPE_SFT				    1
	#define CQ_REQ_CQE_TYPE_REQ				   (0x0UL << 1)
	#define CQ_REQ_RESERVED3_MASK				    0xe0UL
	#define CQ_REQ_RESERVED3_SFT				    5
	u8 status;
	#define CQ_REQ_STATUS_OK				   0x0UL
	#define CQ_REQ_STATUS_BAD_RESPONSE_ERR			   0x1UL
	#define CQ_REQ_STATUS_LOCAL_LENGTH_ERR			   0x2UL
	#define CQ_REQ_STATUS_LOCAL_QP_OPERATION_ERR		   0x3UL
	#define CQ_REQ_STATUS_LOCAL_PROTECTION_ERR		   0x4UL
	#define CQ_REQ_STATUS_MEMORY_MGT_OPERATION_ERR		   0x5UL
	#define CQ_REQ_STATUS_REMOTE_INVALID_REQUEST_ERR	   0x6UL
	#define CQ_REQ_STATUS_REMOTE_ACCESS_ERR		   0x7UL
	#define CQ_REQ_STATUS_REMOTE_OPERATION_ERR		   0x8UL
	#define CQ_REQ_STATUS_RNR_NAK_RETRY_CNT_ERR		   0x9UL
	#define CQ_REQ_STATUS_TRANSPORT_RETRY_CNT_ERR		   0xaUL
	#define CQ_REQ_STATUS_WORK_REQUEST_FLUSHED_ERR		   0xbUL
	__le16 reserved16_2;
	__le32 reserved32_1;
};

/* Responder RC CQE (32 bytes) */
struct cq_res_rc {
	__le32 length;
	__le32 imm_data_or_inv_r_key;
	__le64 qp_handle;
	__le64 mr_handle;
	u8 cqe_type_toggle;
	#define CQ_RES_RC_TOGGLE				    0x1UL
	#define CQ_RES_RC_CQE_TYPE_MASK			    0x1eUL
	#define CQ_RES_RC_CQE_TYPE_SFT				    1
	#define CQ_RES_RC_CQE_TYPE_RES_RC			   (0x1UL << 1)
	#define CQ_RES_RC_RESERVED3_MASK			    0xe0UL
	#define CQ_RES_RC_RESERVED3_SFT			    5
	u8 status;
	#define CQ_RES_RC_STATUS_OK				   0x0UL
	#define CQ_RES_RC_STATUS_LOCAL_ACCESS_ERROR		   0x1UL
	#define CQ_RES_RC_STATUS_LOCAL_LENGTH_ERR		   0x2UL
	#define CQ_RES_RC_STATUS_LOCAL_PROTECTION_ERR		   0x3UL
	#define CQ_RES_RC_STATUS_LOCAL_QP_OPERATION_ERR	   0x4UL
	#define CQ_RES_RC_STATUS_MEMORY_MGT_OPERATION_ERR	   0x5UL
	#define CQ_RES_RC_STATUS_REMOTE_INVALID_REQUEST_ERR       0x6UL
	#define CQ_RES_RC_STATUS_WORK_REQUEST_FLUSHED_ERR	   0x7UL
	#define CQ_RES_RC_STATUS_HW_FLUSH_ERR			   0x8UL
	__le16 flags;
	#define CQ_RES_RC_FLAGS_SRQ				    0x1UL
	#define CQ_RES_RC_FLAGS_SRQ_RQ				   (0x0UL << 0)
	#define CQ_RES_RC_FLAGS_SRQ_SRQ			   (0x1UL << 0)
	#define CQ_RES_RC_FLAGS_SRQ_LAST    CQ_RES_RC_FLAGS_SRQ_SRQ
	#define CQ_RES_RC_FLAGS_IMM				    0x2UL
	#define CQ_RES_RC_FLAGS_INV				    0x4UL
	#define CQ_RES_RC_FLAGS_RDMA				    0x8UL
	#define CQ_RES_RC_FLAGS_RDMA_SEND			   (0x0UL << 3)
	#define CQ_RES_RC_FLAGS_RDMA_RDMA_WRITE		   (0x1UL << 3)
	#define CQ_RES_RC_FLAGS_RDMA_LAST    CQ_RES_RC_FLAGS_RDMA_RDMA_WRITE
	__le32 srq_or_rq_wr_id;
	#define CQ_RES_RC_SRQ_OR_RQ_WR_ID_MASK			    0xfffffUL
	#define CQ_RES_RC_SRQ_OR_RQ_WR_ID_SFT			    0
	#define CQ_RES_RC_RESERVED12_MASK			    0xfff00000UL
	#define CQ_RES_RC_RESERVED12_SFT			    20
};

/* Responder UD CQE (32 bytes) */
struct cq_res_ud {
	__le32 length;
	#define CQ_RES_UD_LENGTH_MASK				    0x3fffUL
	#define CQ_RES_UD_LENGTH_SFT				    0
	#define CQ_RES_UD_RESERVED18_MASK			    0xffffc000UL
	#define CQ_RES_UD_RESERVED18_SFT			    14
	__le32 imm_data;
	__le64 qp_handle;
	__le16 src_mac[3];
	__le16 src_qp_low;
	u8 cqe_type_toggle;
	#define CQ_RES_UD_TOGGLE				    0x1UL
	#define CQ_RES_UD_CQE_TYPE_MASK			    0x1eUL
	#define CQ_RES_UD_CQE_TYPE_SFT				    1
	#define CQ_RES_UD_CQE_TYPE_RES_UD			   (0x2UL << 1)
	#define CQ_RES_UD_RESERVED3_MASK			    0xe0UL
	#define CQ_RES_UD_RESERVED3_SFT			    5
	u8 status;
	#define CQ_RES_UD_STATUS_OK				   0x0UL
	#define CQ_RES_UD_STATUS_LOCAL_ACCESS_ERROR		   0x1UL
	#define CQ_RES_UD_STATUS_HW_LOCAL_LENGTH_ERR		   0x2UL
	#define CQ_RES_UD_STATUS_LOCAL_PROTECTION_ERR		   0x3UL
	#define CQ_RES_UD_STATUS_LOCAL_QP_OPERATION_ERR	   0x4UL
	#define CQ_RES_UD_STATUS_MEMORY_MGT_OPERATION_ERR	   0x5UL
	#define CQ_RES_UD_STATUS_WORK_REQUEST_FLUSHED_ERR	   0x7UL
	#define CQ_RES_UD_STATUS_HW_FLUSH_ERR			   0x8UL
	__le16 flags;
	#define CQ_RES_UD_FLAGS_SRQ				    0x1UL
	#define CQ_RES_UD_FLAGS_SRQ_RQ				   (0x0UL << 0)
	#define CQ_RES_UD_FLAGS_SRQ_SRQ			   (0x1UL << 0)
	#define CQ_RES_UD_FLAGS_SRQ_LAST    CQ_RES_UD_FLAGS_SRQ_SRQ
	#define CQ_RES_UD_FLAGS_IMM				    0x2UL
	#define CQ_RES_UD_FLAGS_ROCE_IP_VER_MASK		    0xcUL
	#define CQ_RES_UD_FLAGS_ROCE_IP_VER_SFT		    2
	#define CQ_RES_UD_FLAGS_ROCE_IP_VER_V1			   (0x0UL << 2)
	#define CQ_RES_UD_FLAGS_ROCE_IP_VER_V2IPV4		   (0x2UL << 2)
	#define CQ_RES_UD_FLAGS_ROCE_IP_VER_V2IPV6		   (0x3UL << 2)
	#define CQ_RES_UD_FLAGS_ROCE_IP_VER_LAST		\
					CQ_RES_UD_FLAGS_ROCE_IP_VER_V2IPV6
	__le32 src_qp_high_srq_or_rq_wr_id;
	#define CQ_RES_UD_SRQ_OR_RQ_WR_ID_MASK			    0xfffffUL
	#define CQ_RES_UD_SRQ_OR_RQ_WR_ID_SFT			    0
	#define CQ_RES_UD_RESERVED4_MASK			    0xf00000UL
	#define CQ_RES_UD_RESERVED4_SFT			    20
	#define CQ_RES_UD_SRC_QP_HIGH_MASK			    0xff000000UL
	#define CQ_RES_UD_SRC_QP_HIGH_SFT			    24
};

/* Responder RawEth and QP1 CQE (32 bytes) */
struct cq_res_raweth_qp1 {
	__le16 length;
	#define CQ_RES_RAWETH_QP1_LENGTH_MASK			    0x3fffUL
	#define CQ_RES_RAWETH_QP1_LENGTH_SFT			    0
	#define CQ_RES_RAWETH_QP1_RESERVED2_MASK		    0xc000UL
	#define CQ_RES_RAWETH_QP1_RESERVED2_SFT		    14
	__le16 raweth_qp1_flags;
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_ERROR	    0x1UL
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_RESERVED5_1_MASK 0x3eUL
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_RESERVED5_1_SFT 1
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_ITYPE_MASK      0x3c0UL
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_ITYPE_SFT       6
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_ITYPE_NOT_KNOWN (0x0UL << 6)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_ITYPE_IP       (0x1UL << 6)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_ITYPE_TCP      (0x2UL << 6)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_ITYPE_UDP      (0x3UL << 6)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_ITYPE_FCOE     (0x4UL << 6)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_ITYPE_ROCE     (0x5UL << 6)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_ITYPE_ICMP     (0x7UL << 6)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_ITYPE_PTP_WO_TIMESTAMP \
								 (0x8UL << 6)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_ITYPE_PTP_W_TIMESTAMP \
								 (0x9UL << 6)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_ITYPE_LAST	\
		CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_ITYPE_PTP_W_TIMESTAMP
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_MASK	    0x3ffUL
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_SFT		    0
	#define CQ_RES_RAWETH_QP1_RESERVED6_MASK		    0xfc00UL
	#define CQ_RES_RAWETH_QP1_RESERVED6_SFT		    10
	__le16 raweth_qp1_errors;
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_RESERVED4_MASK 0xfUL
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_RESERVED4_SFT  0
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_IP_CS_ERROR    0x10UL
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_L4_CS_ERROR    0x20UL
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_T_IP_CS_ERROR  0x40UL
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_T_L4_CS_ERROR  0x80UL
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_CRC_ERROR      0x100UL
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_T_PKT_ERROR_MASK 0xe00UL
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_T_PKT_ERROR_SFT 9
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_T_PKT_ERROR_NO_ERROR \
								(0x0UL << 9)
	#define \
	   CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_T_PKT_ERROR_T_L3_BAD_VERSION \
								(0x1UL << 9)
	#define \
	   CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_T_PKT_ERROR_T_L3_BAD_HDR_LEN \
								(0x2UL << 9)
	#define \
	   CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_T_PKT_ERROR_TUNNEL_TOTAL_ERROR \
								(0x3UL << 9)
	#define \
	   CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_T_PKT_ERROR_T_IP_TOTAL_ERROR \
								(0x4UL << 9)
	#define \
	   CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_T_PKT_ERROR_T_UDP_TOTAL_ERROR \
								(0x5UL << 9)
	#define \
	   CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_T_PKT_ERROR_T_L3_BAD_TTL \
								(0x6UL << 9)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_T_PKT_ERROR_LAST \
		CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_T_PKT_ERROR_T_L3_BAD_TTL
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_PKT_ERROR_MASK 0xf000UL
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_PKT_ERROR_SFT  12
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_PKT_ERROR_NO_ERROR \
								(0x0UL << 12)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_PKT_ERROR_L3_BAD_VERSION \
								(0x1UL << 12)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_PKT_ERROR_L3_BAD_HDR_LEN \
								 (0x2UL << 12)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_PKT_ERROR_L3_BAD_TTL \
								 (0x3UL << 12)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_PKT_ERROR_IP_TOTAL_ERROR \
								 (0x4UL << 12)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_PKT_ERROR_UDP_TOTAL_ERROR \
								 (0x5UL << 12)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_PKT_ERROR_L4_BAD_HDR_LEN \
								 (0x6UL << 12)
	#define \
	 CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_PKT_ERROR_L4_BAD_HDR_LEN_TOO_SMALL\
								 (0x7UL << 12)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_PKT_ERROR_L4_BAD_OPT_LEN \
								 (0x8UL << 12)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_PKT_ERROR_LAST \
		CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_PKT_ERROR_L4_BAD_OPT_LEN
	__le16 raweth_qp1_cfa_code;
	__le64 qp_handle;
	__le32 raweth_qp1_flags2;
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS2_IP_CS_CALC     0x1UL
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS2_L4_CS_CALC     0x2UL
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS2_T_IP_CS_CALC   0x4UL
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS2_T_L4_CS_CALC   0x8UL
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS2_META_FORMAT_MASK 0xf0UL
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS2_META_FORMAT_SFT 4
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS2_META_FORMAT_NONE \
								(0x0UL << 4)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS2_META_FORMAT_VLAN \
								(0x1UL << 4)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS2_META_FORMAT_LAST\
			CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS2_META_FORMAT_VLAN
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS2_IP_TYPE	    0x100UL
	__le32 raweth_qp1_metadata;
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_METADATA_VID_MASK     0xfffUL
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_METADATA_VID_SFT      0
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_METADATA_DE	    0x1000UL
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_METADATA_PRI_MASK     0xe000UL
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_METADATA_PRI_SFT      13
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_METADATA_TPID_MASK    0xffff0000UL
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_METADATA_TPID_SFT     16
	u8 cqe_type_toggle;
	#define CQ_RES_RAWETH_QP1_TOGGLE			    0x1UL
	#define CQ_RES_RAWETH_QP1_CQE_TYPE_MASK		    0x1eUL
	#define CQ_RES_RAWETH_QP1_CQE_TYPE_SFT			    1
	#define CQ_RES_RAWETH_QP1_CQE_TYPE_RES_RAWETH_QP1	   (0x3UL << 1)
	#define CQ_RES_RAWETH_QP1_RESERVED3_MASK		    0xe0UL
	#define CQ_RES_RAWETH_QP1_RESERVED3_SFT		    5
	u8 status;
	#define CQ_RES_RAWETH_QP1_STATUS_OK			   0x0UL
	#define CQ_RES_RAWETH_QP1_STATUS_LOCAL_ACCESS_ERROR       0x1UL
	#define CQ_RES_RAWETH_QP1_STATUS_HW_LOCAL_LENGTH_ERR      0x2UL
	#define CQ_RES_RAWETH_QP1_STATUS_LOCAL_PROTECTION_ERR     0x3UL
	#define CQ_RES_RAWETH_QP1_STATUS_LOCAL_QP_OPERATION_ERR   0x4UL
	#define CQ_RES_RAWETH_QP1_STATUS_MEMORY_MGT_OPERATION_ERR 0x5UL
	#define CQ_RES_RAWETH_QP1_STATUS_WORK_REQUEST_FLUSHED_ERR 0x7UL
	#define CQ_RES_RAWETH_QP1_STATUS_HW_FLUSH_ERR		   0x8UL
	__le16 flags;
	#define CQ_RES_RAWETH_QP1_FLAGS_SRQ			    0x1UL
	#define CQ_RES_RAWETH_QP1_FLAGS_SRQ_RQ			   0x0UL
	#define CQ_RES_RAWETH_QP1_FLAGS_SRQ_SRQ		   0x1UL
	#define CQ_RES_RAWETH_QP1_FLAGS_SRQ_LAST \
					CQ_RES_RAWETH_QP1_FLAGS_SRQ_SRQ
	__le32 raweth_qp1_payload_offset_srq_or_rq_wr_id;
	#define CQ_RES_RAWETH_QP1_SRQ_OR_RQ_WR_ID_MASK		    0xfffffUL
	#define CQ_RES_RAWETH_QP1_SRQ_OR_RQ_WR_ID_SFT		    0
	#define CQ_RES_RAWETH_QP1_RESERVED4_MASK		    0xf00000UL
	#define CQ_RES_RAWETH_QP1_RESERVED4_SFT		    20
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_PAYLOAD_OFFSET_MASK   0xff000000UL
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_PAYLOAD_OFFSET_SFT    24
};

/* Terminal CQE (32 bytes) */
struct cq_terminal {
	__le64 qp_handle;
	__le16 sq_cons_idx;
	__le16 rq_cons_idx;
	__le32 reserved32_1;
	__le64 reserved64_3;
	u8 cqe_type_toggle;
	#define CQ_TERMINAL_TOGGLE				    0x1UL
	#define CQ_TERMINAL_CQE_TYPE_MASK			    0x1eUL
	#define CQ_TERMINAL_CQE_TYPE_SFT			    1
	#define CQ_TERMINAL_CQE_TYPE_TERMINAL			   (0xeUL << 1)
	#define CQ_TERMINAL_RESERVED3_MASK			    0xe0UL
	#define CQ_TERMINAL_RESERVED3_SFT			    5
	u8 status;
	#define CQ_TERMINAL_STATUS_OK				   0x0UL
	__le16 reserved16;
	__le32 reserved32_2;
};

/* Cutoff CQE (32 bytes) */
struct cq_cutoff {
	__le64 reserved64_1;
	__le64 reserved64_2;
	__le64 reserved64_3;
	u8 cqe_type_toggle;
	#define CQ_CUTOFF_TOGGLE				    0x1UL
	#define CQ_CUTOFF_CQE_TYPE_MASK			    0x1eUL
	#define CQ_CUTOFF_CQE_TYPE_SFT				    1
	#define CQ_CUTOFF_CQE_TYPE_CUT_OFF			   (0xfUL << 1)
	#define CQ_CUTOFF_RESERVED3_MASK			    0xe0UL
	#define CQ_CUTOFF_RESERVED3_SFT			    5
	u8 status;
	#define CQ_CUTOFF_STATUS_OK				   0x0UL
	__le16 reserved16;
	__le32 reserved32;
};

/* Notification Queue (NQ) Structures */
/* Base NQ Record (16 bytes) */
struct nq_base {
	__le16 info10_type;
	#define NQ_BASE_TYPE_MASK				    0x3fUL
	#define NQ_BASE_TYPE_SFT				    0
	#define NQ_BASE_TYPE_CQ_NOTIFICATION			   0x30UL
	#define NQ_BASE_TYPE_SRQ_EVENT				   0x32UL
	#define NQ_BASE_TYPE_DBQ_EVENT				   0x34UL
	#define NQ_BASE_TYPE_QP_EVENT				   0x38UL
	#define NQ_BASE_TYPE_FUNC_EVENT			   0x3aUL
	#define NQ_BASE_INFO10_MASK				    0xffc0UL
	#define NQ_BASE_INFO10_SFT				    6
	__le16 info16;
	__le32 info32;
	__le32 info63_v[2];
	#define NQ_BASE_V					    0x1UL
	#define NQ_BASE_INFO63_MASK				    0xfffffffeUL
	#define NQ_BASE_INFO63_SFT				    1
};

/* Completion Queue Notification (16 bytes) */
struct nq_cn {
	__le16 type;
	#define NQ_CN_TYPE_MASK				    0x3fUL
	#define NQ_CN_TYPE_SFT					    0
	#define NQ_CN_TYPE_CQ_NOTIFICATION			   0x30UL
	#define NQ_CN_RESERVED9_MASK				    0xffc0UL
	#define NQ_CN_RESERVED9_SFT				    6
	__le16 reserved16;
	__le32 cq_handle_low;
	__le32 v;
	#define NQ_CN_V					    0x1UL
	#define NQ_CN_RESERVED31_MASK				    0xfffffffeUL
	#define NQ_CN_RESERVED31_SFT				    1
	__le32 cq_handle_high;
};

/* SRQ Event Notification (16 bytes) */
struct nq_srq_event {
	u8 type;
	#define NQ_SRQ_EVENT_TYPE_MASK				    0x3fUL
	#define NQ_SRQ_EVENT_TYPE_SFT				    0
	#define NQ_SRQ_EVENT_TYPE_SRQ_EVENT			   0x32UL
	#define NQ_SRQ_EVENT_RESERVED1_MASK			    0xc0UL
	#define NQ_SRQ_EVENT_RESERVED1_SFT			    6
	u8 event;
	#define NQ_SRQ_EVENT_EVENT_SRQ_THRESHOLD_EVENT		   0x1UL
	__le16 reserved16;
	__le32 srq_handle_low;
	__le32 v;
	#define NQ_SRQ_EVENT_V					    0x1UL
	#define NQ_SRQ_EVENT_RESERVED31_MASK			    0xfffffffeUL
	#define NQ_SRQ_EVENT_RESERVED31_SFT			    1
	__le32 srq_handle_high;
};

/* DBQ Async Event Notification (16 bytes) */
struct nq_dbq_event {
	u8 type;
	#define NQ_DBQ_EVENT_TYPE_MASK				    0x3fUL
	#define NQ_DBQ_EVENT_TYPE_SFT				    0
	#define NQ_DBQ_EVENT_TYPE_DBQ_EVENT			   0x34UL
	#define NQ_DBQ_EVENT_RESERVED1_MASK			    0xc0UL
	#define NQ_DBQ_EVENT_RESERVED1_SFT			    6
	u8 event;
	#define NQ_DBQ_EVENT_EVENT_DBQ_THRESHOLD_EVENT		   0x1UL
	__le16 db_pfid;
	#define NQ_DBQ_EVENT_DB_PFID_MASK			    0xfUL
	#define NQ_DBQ_EVENT_DB_PFID_SFT			    0
	#define NQ_DBQ_EVENT_RESERVED12_MASK			    0xfff0UL
	#define NQ_DBQ_EVENT_RESERVED12_SFT			    4
	__le32 db_dpi;
	#define NQ_DBQ_EVENT_DB_DPI_MASK			    0xfffffUL
	#define NQ_DBQ_EVENT_DB_DPI_SFT			    0
	#define NQ_DBQ_EVENT_RESERVED12_2_MASK			    0xfff00000UL
	#define NQ_DBQ_EVENT_RESERVED12_2_SFT			    20
	__le32 v;
	#define NQ_DBQ_EVENT_V					    0x1UL
	#define NQ_DBQ_EVENT_RESERVED32_MASK			    0xfffffffeUL
	#define NQ_DBQ_EVENT_RESERVED32_SFT			    1
	__le32 db_type_db_xid;
	#define NQ_DBQ_EVENT_DB_XID_MASK			    0xfffffUL
	#define NQ_DBQ_EVENT_DB_XID_SFT			    0
	#define NQ_DBQ_EVENT_RESERVED8_MASK			    0xff00000UL
	#define NQ_DBQ_EVENT_RESERVED8_SFT			    20
	#define NQ_DBQ_EVENT_DB_TYPE_MASK			    0xf0000000UL
	#define NQ_DBQ_EVENT_DB_TYPE_SFT			    28
};

/* Read Request/Response Queue Structures */
/* Input Read Request Queue (IRRQ) Message (32 bytes) */
struct xrrq_irrq {
	__le16 credits_type;
	#define XRRQ_IRRQ_TYPE					    0x1UL
	#define XRRQ_IRRQ_TYPE_READ_REQ			   0x0UL
	#define XRRQ_IRRQ_TYPE_ATOMIC_REQ			   0x1UL
	#define XRRQ_IRRQ_RESERVED10_MASK			    0x7feUL
	#define XRRQ_IRRQ_RESERVED10_SFT			    1
	#define XRRQ_IRRQ_CREDITS_MASK				    0xf800UL
	#define XRRQ_IRRQ_CREDITS_SFT				    11
	__le16 reserved16;
	__le32 reserved32;
	__le32 psn;
	#define XRRQ_IRRQ_PSN_MASK				    0xffffffUL
	#define XRRQ_IRRQ_PSN_SFT				    0
	#define XRRQ_IRRQ_RESERVED8_1_MASK			    0xff000000UL
	#define XRRQ_IRRQ_RESERVED8_1_SFT			    24
	__le32 msn;
	#define XRRQ_IRRQ_MSN_MASK				    0xffffffUL
	#define XRRQ_IRRQ_MSN_SFT				    0
	#define XRRQ_IRRQ_RESERVED8_2_MASK			    0xff000000UL
	#define XRRQ_IRRQ_RESERVED8_2_SFT			    24
	__le64 va_or_atomic_result;
	__le32 rdma_r_key;
	__le32 length;
};

/* Output Read Request Queue (ORRQ) Message (32 bytes) */
struct xrrq_orrq {
	__le16 num_sges_type;
	#define XRRQ_ORRQ_TYPE					    0x1UL
	#define XRRQ_ORRQ_TYPE_READ_REQ			   0x0UL
	#define XRRQ_ORRQ_TYPE_ATOMIC_REQ			   0x1UL
	#define XRRQ_ORRQ_RESERVED10_MASK			    0x7feUL
	#define XRRQ_ORRQ_RESERVED10_SFT			    1
	#define XRRQ_ORRQ_NUM_SGES_MASK			    0xf800UL
	#define XRRQ_ORRQ_NUM_SGES_SFT				    11
	__le16 reserved16;
	__le32 length;
	__le32 psn;
	#define XRRQ_ORRQ_PSN_MASK				    0xffffffUL
	#define XRRQ_ORRQ_PSN_SFT				    0
	#define XRRQ_ORRQ_RESERVED8_1_MASK			    0xff000000UL
	#define XRRQ_ORRQ_RESERVED8_1_SFT			    24
	__le32 end_psn;
	#define XRRQ_ORRQ_END_PSN_MASK				    0xffffffUL
	#define XRRQ_ORRQ_END_PSN_SFT				    0
	#define XRRQ_ORRQ_RESERVED8_2_MASK			    0xff000000UL
	#define XRRQ_ORRQ_RESERVED8_2_SFT			    24
	__le64 first_sge_phy_or_sing_sge_va;
	__le32 single_sge_l_key;
	__le32 single_sge_size;
};

/* Page Buffer List Memory Structures (PBL) */
/* Page Table Entry (PTE) (8 bytes) */
struct ptu_pte {
	__le32 page_next_to_last_last_valid[2];
	#define PTU_PTE_VALID					    0x1UL
	#define PTU_PTE_LAST					    0x2UL
	#define PTU_PTE_NEXT_TO_LAST				    0x4UL
	#define PTU_PTE_PAGE_MASK				    0xfffff000UL
	#define PTU_PTE_PAGE_SFT				    12
};

/* Page Directory Entry (PDE) (8 bytes) */
struct ptu_pde {
	__le32 page_valid[2];
	#define PTU_PDE_VALID					    0x1UL
	#define PTU_PDE_PAGE_MASK				    0xfffff000UL
	#define PTU_PDE_PAGE_SFT				    12
};

/* RoCE Fastpath Host Structures */
/* Command Queue (CMDQ) Interface */
/* Init CMDQ (16 bytes) */
struct cmdq_init {
	__le64 cmdq_pbl;
	__le16 cmdq_size_cmdq_lvl;
	#define CMDQ_INIT_CMDQ_LVL_MASK			    0x3UL
	#define CMDQ_INIT_CMDQ_LVL_SFT				    0
	#define CMDQ_INIT_CMDQ_SIZE_MASK			    0xfffcUL
	#define CMDQ_INIT_CMDQ_SIZE_SFT			    2
	__le16 creq_ring_id;
	__le32 prod_idx;
};

/* Update CMDQ producer index (16 bytes) */
struct cmdq_update {
	__le64 reserved64;
	__le32 reserved32;
	__le32 prod_idx;
};

/* CMDQ common header structure (16 bytes) */
struct cmdq_base {
	u8 opcode;
	#define CMDQ_BASE_OPCODE_CREATE_QP			   0x1UL
	#define CMDQ_BASE_OPCODE_DESTROY_QP			   0x2UL
	#define CMDQ_BASE_OPCODE_MODIFY_QP			   0x3UL
	#define CMDQ_BASE_OPCODE_QUERY_QP			   0x4UL
	#define CMDQ_BASE_OPCODE_CREATE_SRQ			   0x5UL
	#define CMDQ_BASE_OPCODE_DESTROY_SRQ			   0x6UL
	#define CMDQ_BASE_OPCODE_QUERY_SRQ			   0x8UL
	#define CMDQ_BASE_OPCODE_CREATE_CQ			   0x9UL
	#define CMDQ_BASE_OPCODE_DESTROY_CQ			   0xaUL
	#define CMDQ_BASE_OPCODE_RESIZE_CQ			   0xcUL
	#define CMDQ_BASE_OPCODE_ALLOCATE_MRW			   0xdUL
	#define CMDQ_BASE_OPCODE_DEALLOCATE_KEY		   0xeUL
	#define CMDQ_BASE_OPCODE_REGISTER_MR			   0xfUL
	#define CMDQ_BASE_OPCODE_DEREGISTER_MR			   0x10UL
	#define CMDQ_BASE_OPCODE_ADD_GID			   0x11UL
	#define CMDQ_BASE_OPCODE_DELETE_GID			   0x12UL
	#define CMDQ_BASE_OPCODE_MODIFY_GID			   0x17UL
	#define CMDQ_BASE_OPCODE_QUERY_GID			   0x18UL
	#define CMDQ_BASE_OPCODE_CREATE_QP1			   0x13UL
	#define CMDQ_BASE_OPCODE_DESTROY_QP1			   0x14UL
	#define CMDQ_BASE_OPCODE_CREATE_AH			   0x15UL
	#define CMDQ_BASE_OPCODE_DESTROY_AH			   0x16UL
	#define CMDQ_BASE_OPCODE_INITIALIZE_FW			   0x80UL
	#define CMDQ_BASE_OPCODE_DEINITIALIZE_FW		   0x81UL
	#define CMDQ_BASE_OPCODE_STOP_FUNC			   0x82UL
	#define CMDQ_BASE_OPCODE_QUERY_FUNC			   0x83UL
	#define CMDQ_BASE_OPCODE_SET_FUNC_RESOURCES		   0x84UL
	#define CMDQ_BASE_OPCODE_READ_CONTEXT			   0x85UL
	#define CMDQ_BASE_OPCODE_VF_BACKCHANNEL_REQUEST	   0x86UL
	#define CMDQ_BASE_OPCODE_READ_VF_MEMORY		   0x87UL
	#define CMDQ_BASE_OPCODE_COMPLETE_VF_REQUEST		   0x88UL
	#define CMDQ_BASE_OPCODE_EXTEND_CONTEXT_ARRRAY		   0x89UL
	#define CMDQ_BASE_OPCODE_MAP_TC_TO_COS			   0x8aUL
	#define CMDQ_BASE_OPCODE_QUERY_VERSION			   0x8bUL
	#define CMDQ_BASE_OPCODE_MODIFY_CC			   0x8cUL
	#define CMDQ_BASE_OPCODE_QUERY_CC			   0x8dUL
	#define CMDQ_BASE_OPCODE_QUERY_ROCE_STATS	   0x8eUL
	u8 cmd_size;
	__le16 flags;
	__le16 cookie;
	u8 resp_size;
	u8 reserved8;
	__le64 resp_addr;
};

/* Create QP command (96 bytes) */
struct cmdq_create_qp {
	u8 opcode;
	#define CMDQ_CREATE_QP_OPCODE_CREATE_QP		   0x1UL
	u8 cmd_size;
	__le16 flags;
	__le16 cookie;
	u8 resp_size;
	u8 reserved8;
	__le64 resp_addr;
	__le64 qp_handle;
	__le32 qp_flags;
	#define CMDQ_CREATE_QP_QP_FLAGS_SRQ_USED		   0x1UL
	#define CMDQ_CREATE_QP_QP_FLAGS_FORCE_COMPLETION	   0x2UL
	#define CMDQ_CREATE_QP_QP_FLAGS_RESERVED_LKEY_ENABLE      0x4UL
	#define CMDQ_CREATE_QP_QP_FLAGS_FR_PMR_ENABLED		   0x8UL
	u8 type;
	#define CMDQ_CREATE_QP_TYPE_RC				   0x2UL
	#define CMDQ_CREATE_QP_TYPE_UD				   0x4UL
	#define CMDQ_CREATE_QP_TYPE_RAW_ETHERTYPE		   0x6UL
	u8 sq_pg_size_sq_lvl;
	#define CMDQ_CREATE_QP_SQ_LVL_MASK			    0xfUL
	#define CMDQ_CREATE_QP_SQ_LVL_SFT			    0
	#define CMDQ_CREATE_QP_SQ_LVL_LVL_0			   0x0UL
	#define CMDQ_CREATE_QP_SQ_LVL_LVL_1			   0x1UL
	#define CMDQ_CREATE_QP_SQ_LVL_LVL_2			   0x2UL
	#define CMDQ_CREATE_QP_SQ_PG_SIZE_MASK			    0xf0UL
	#define CMDQ_CREATE_QP_SQ_PG_SIZE_SFT			    4
	#define CMDQ_CREATE_QP_SQ_PG_SIZE_PG_4K		   (0x0UL << 4)
	#define CMDQ_CREATE_QP_SQ_PG_SIZE_PG_8K		   (0x1UL << 4)
	#define CMDQ_CREATE_QP_SQ_PG_SIZE_PG_64K		   (0x2UL << 4)
	#define CMDQ_CREATE_QP_SQ_PG_SIZE_PG_2M		   (0x3UL << 4)
	#define CMDQ_CREATE_QP_SQ_PG_SIZE_PG_8M		   (0x4UL << 4)
	#define CMDQ_CREATE_QP_SQ_PG_SIZE_PG_1G		   (0x5UL << 4)
	u8 rq_pg_size_rq_lvl;
	#define CMDQ_CREATE_QP_RQ_LVL_MASK			    0xfUL
	#define CMDQ_CREATE_QP_RQ_LVL_SFT			    0
	#define CMDQ_CREATE_QP_RQ_LVL_LVL_0			   0x0UL
	#define CMDQ_CREATE_QP_RQ_LVL_LVL_1			   0x1UL
	#define CMDQ_CREATE_QP_RQ_LVL_LVL_2			   0x2UL
	#define CMDQ_CREATE_QP_RQ_PG_SIZE_MASK			    0xf0UL
	#define CMDQ_CREATE_QP_RQ_PG_SIZE_SFT			    4
	#define CMDQ_CREATE_QP_RQ_PG_SIZE_PG_4K		   (0x0UL << 4)
	#define CMDQ_CREATE_QP_RQ_PG_SIZE_PG_8K		   (0x1UL << 4)
	#define CMDQ_CREATE_QP_RQ_PG_SIZE_PG_64K		   (0x2UL << 4)
	#define CMDQ_CREATE_QP_RQ_PG_SIZE_PG_2M		   (0x3UL << 4)
	#define CMDQ_CREATE_QP_RQ_PG_SIZE_PG_8M		   (0x4UL << 4)
	#define CMDQ_CREATE_QP_RQ_PG_SIZE_PG_1G		   (0x5UL << 4)
	u8 unused_0;
	__le32 dpi;
	__le32 sq_size;
	__le32 rq_size;
	__le16 sq_fwo_sq_sge;
	#define CMDQ_CREATE_QP_SQ_SGE_MASK			    0xfUL
	#define CMDQ_CREATE_QP_SQ_SGE_SFT			    0
	#define CMDQ_CREATE_QP_SQ_FWO_MASK			    0xfff0UL
	#define CMDQ_CREATE_QP_SQ_FWO_SFT			    4
	__le16 rq_fwo_rq_sge;
	#define CMDQ_CREATE_QP_RQ_SGE_MASK			    0xfUL
	#define CMDQ_CREATE_QP_RQ_SGE_SFT			    0
	#define CMDQ_CREATE_QP_RQ_FWO_MASK			    0xfff0UL
	#define CMDQ_CREATE_QP_RQ_FWO_SFT			    4
	__le32 scq_cid;
	__le32 rcq_cid;
	__le32 srq_cid;
	__le32 pd_id;
	__le64 sq_pbl;
	__le64 rq_pbl;
	__le64 irrq_addr;
	__le64 orrq_addr;
};

/* Destroy QP command (24 bytes) */
struct cmdq_destroy_qp {
	u8 opcode;
	#define CMDQ_DESTROY_QP_OPCODE_DESTROY_QP		   0x2UL
	u8 cmd_size;
	__le16 flags;
	__le16 cookie;
	u8 resp_size;
	u8 reserved8;
	__le64 resp_addr;
	__le32 qp_cid;
	__le32 unused_0;
};

/* Modify QP command (112 bytes) */
struct cmdq_modify_qp {
	u8 opcode;
	#define CMDQ_MODIFY_QP_OPCODE_MODIFY_QP		   0x3UL
	u8 cmd_size;
	__le16 flags;
	__le16 cookie;
	u8 resp_size;
	u8 reserved8;
	__le64 resp_addr;
	__le32 modify_mask;
	#define CMDQ_MODIFY_QP_MODIFY_MASK_STATE		    0x1UL
	#define CMDQ_MODIFY_QP_MODIFY_MASK_EN_SQD_ASYNC_NOTIFY     0x2UL
	#define CMDQ_MODIFY_QP_MODIFY_MASK_ACCESS		    0x4UL
	#define CMDQ_MODIFY_QP_MODIFY_MASK_PKEY		    0x8UL
	#define CMDQ_MODIFY_QP_MODIFY_MASK_QKEY		    0x10UL
	#define CMDQ_MODIFY_QP_MODIFY_MASK_DGID		    0x20UL
	#define CMDQ_MODIFY_QP_MODIFY_MASK_FLOW_LABEL		    0x40UL
	#define CMDQ_MODIFY_QP_MODIFY_MASK_SGID_INDEX		    0x80UL
	#define CMDQ_MODIFY_QP_MODIFY_MASK_HOP_LIMIT		    0x100UL
	#define CMDQ_MODIFY_QP_MODIFY_MASK_TRAFFIC_CLASS	    0x200UL
	#define CMDQ_MODIFY_QP_MODIFY_MASK_DEST_MAC		    0x400UL
	#define CMDQ_MODIFY_QP_MODIFY_MASK_PATH_MTU		    0x1000UL
	#define CMDQ_MODIFY_QP_MODIFY_MASK_TIMEOUT		    0x2000UL
	#define CMDQ_MODIFY_QP_MODIFY_MASK_RETRY_CNT		    0x4000UL
	#define CMDQ_MODIFY_QP_MODIFY_MASK_RNR_RETRY		    0x8000UL
	#define CMDQ_MODIFY_QP_MODIFY_MASK_RQ_PSN		    0x10000UL
	#define CMDQ_MODIFY_QP_MODIFY_MASK_MAX_RD_ATOMIC	    0x20000UL
	#define CMDQ_MODIFY_QP_MODIFY_MASK_MIN_RNR_TIMER	    0x40000UL
	#define CMDQ_MODIFY_QP_MODIFY_MASK_SQ_PSN		    0x80000UL
	#define CMDQ_MODIFY_QP_MODIFY_MASK_MAX_DEST_RD_ATOMIC      0x100000UL
	#define CMDQ_MODIFY_QP_MODIFY_MASK_SQ_SIZE		    0x200000UL
	#define CMDQ_MODIFY_QP_MODIFY_MASK_RQ_SIZE		    0x400000UL
	#define CMDQ_MODIFY_QP_MODIFY_MASK_SQ_SGE		    0x800000UL
	#define CMDQ_MODIFY_QP_MODIFY_MASK_RQ_SGE		    0x1000000UL
	#define CMDQ_MODIFY_QP_MODIFY_MASK_MAX_INLINE_DATA	    0x2000000UL
	#define CMDQ_MODIFY_QP_MODIFY_MASK_DEST_QP_ID		    0x4000000UL
	#define CMDQ_MODIFY_QP_MODIFY_MASK_SRC_MAC		    0x8000000UL
	#define CMDQ_MODIFY_QP_MODIFY_MASK_VLAN_ID		    0x10000000UL
	#define CMDQ_MODIFY_QP_MODIFY_MASK_ENABLE_CC		    0x20000000UL
	#define CMDQ_MODIFY_QP_MODIFY_MASK_TOS_ECN		    0x40000000UL
	#define CMDQ_MODIFY_QP_MODIFY_MASK_TOS_DSCP		    0x80000000UL
	__le32 qp_cid;
	u8 network_type_en_sqd_async_notify_new_state;
	#define CMDQ_MODIFY_QP_NEW_STATE_MASK			    0xfUL
	#define CMDQ_MODIFY_QP_NEW_STATE_SFT			    0
	#define CMDQ_MODIFY_QP_NEW_STATE_RESET			   0x0UL
	#define CMDQ_MODIFY_QP_NEW_STATE_INIT			   0x1UL
	#define CMDQ_MODIFY_QP_NEW_STATE_RTR			   0x2UL
	#define CMDQ_MODIFY_QP_NEW_STATE_RTS			   0x3UL
	#define CMDQ_MODIFY_QP_NEW_STATE_SQD			   0x4UL
	#define CMDQ_MODIFY_QP_NEW_STATE_SQE			   0x5UL
	#define CMDQ_MODIFY_QP_NEW_STATE_ERR			   0x6UL
	#define CMDQ_MODIFY_QP_EN_SQD_ASYNC_NOTIFY		    0x10UL
	#define CMDQ_MODIFY_QP_NETWORK_TYPE_MASK		    0xc0UL
	#define CMDQ_MODIFY_QP_NETWORK_TYPE_SFT		    6
	#define CMDQ_MODIFY_QP_NETWORK_TYPE_ROCEV1		   (0x0UL << 6)
	#define CMDQ_MODIFY_QP_NETWORK_TYPE_ROCEV2_IPV4	   (0x2UL << 6)
	#define CMDQ_MODIFY_QP_NETWORK_TYPE_ROCEV2_IPV6	   (0x3UL << 6)
	u8 access;
	#define CMDQ_MODIFY_QP_ACCESS_LOCAL_WRITE		    0x1UL
	#define CMDQ_MODIFY_QP_ACCESS_REMOTE_WRITE		    0x2UL
	#define CMDQ_MODIFY_QP_ACCESS_REMOTE_READ		    0x4UL
	#define CMDQ_MODIFY_QP_ACCESS_REMOTE_ATOMIC		    0x8UL
	__le16 pkey;
	__le32 qkey;
	__le32 dgid[4];
	__le32 flow_label;
	__le16 sgid_index;
	u8 hop_limit;
	u8 traffic_class;
	__le16 dest_mac[3];
	u8 tos_dscp_tos_ecn;
	#define CMDQ_MODIFY_QP_TOS_ECN_MASK			    0x3UL
	#define CMDQ_MODIFY_QP_TOS_ECN_SFT			    0
	#define CMDQ_MODIFY_QP_TOS_DSCP_MASK			    0xfcUL
	#define CMDQ_MODIFY_QP_TOS_DSCP_SFT			    2
	u8 path_mtu;
	#define CMDQ_MODIFY_QP_PATH_MTU_MASK			    0xf0UL
	#define CMDQ_MODIFY_QP_PATH_MTU_SFT			    4
	#define CMDQ_MODIFY_QP_PATH_MTU_MTU_256		   (0x0UL << 4)
	#define CMDQ_MODIFY_QP_PATH_MTU_MTU_512		   (0x1UL << 4)
	#define CMDQ_MODIFY_QP_PATH_MTU_MTU_1024		   (0x2UL << 4)
	#define CMDQ_MODIFY_QP_PATH_MTU_MTU_2048		   (0x3UL << 4)
	#define CMDQ_MODIFY_QP_PATH_MTU_MTU_4096		   (0x4UL << 4)
	#define CMDQ_MODIFY_QP_PATH_MTU_MTU_8192		   (0x5UL << 4)
	u8 timeout;
	u8 retry_cnt;
	u8 rnr_retry;
	u8 min_rnr_timer;
	__le32 rq_psn;
	__le32 sq_psn;
	u8 max_rd_atomic;
	u8 max_dest_rd_atomic;
	__le16 enable_cc;
	#define CMDQ_MODIFY_QP_ENABLE_CC			    0x1UL
	__le32 sq_size;
	__le32 rq_size;
	__le16 sq_sge;
	__le16 rq_sge;
	__le32 max_inline_data;
	__le32 dest_qp_id;
	__le32 unused_3;
	__le16 src_mac[3];
	__le16 vlan_pcp_vlan_dei_vlan_id;
	#define CMDQ_MODIFY_QP_VLAN_ID_MASK			    0xfffUL
	#define CMDQ_MODIFY_QP_VLAN_ID_SFT			    0
	#define CMDQ_MODIFY_QP_VLAN_DEI			    0x1000UL
	#define CMDQ_MODIFY_QP_VLAN_PCP_MASK			    0xe000UL
	#define CMDQ_MODIFY_QP_VLAN_PCP_SFT			    13
};

/* Query QP command (24 bytes) */
struct cmdq_query_qp {
	u8 opcode;
	#define CMDQ_QUERY_QP_OPCODE_QUERY_QP			   0x4UL
	u8 cmd_size;
	__le16 flags;
	__le16 cookie;
	u8 resp_size;
	u8 reserved8;
	__le64 resp_addr;
	__le32 qp_cid;
	__le32 unused_0;
};

/* Create SRQ command (48 bytes) */
struct cmdq_create_srq {
	u8 opcode;
	#define CMDQ_CREATE_SRQ_OPCODE_CREATE_SRQ		   0x5UL
	u8 cmd_size;
	__le16 flags;
	__le16 cookie;
	u8 resp_size;
	u8 reserved8;
	__le64 resp_addr;
	__le64 srq_handle;
	__le16 pg_size_lvl;
	#define CMDQ_CREATE_SRQ_LVL_MASK			    0x3UL
	#define CMDQ_CREATE_SRQ_LVL_SFT			    0
	#define CMDQ_CREATE_SRQ_LVL_LVL_0			   0x0UL
	#define CMDQ_CREATE_SRQ_LVL_LVL_1			   0x1UL
	#define CMDQ_CREATE_SRQ_LVL_LVL_2			   0x2UL
	#define CMDQ_CREATE_SRQ_PG_SIZE_MASK			    0x1cUL
	#define CMDQ_CREATE_SRQ_PG_SIZE_SFT			    2
	#define CMDQ_CREATE_SRQ_PG_SIZE_PG_4K			   (0x0UL << 2)
	#define CMDQ_CREATE_SRQ_PG_SIZE_PG_8K			   (0x1UL << 2)
	#define CMDQ_CREATE_SRQ_PG_SIZE_PG_64K			   (0x2UL << 2)
	#define CMDQ_CREATE_SRQ_PG_SIZE_PG_2M			   (0x3UL << 2)
	#define CMDQ_CREATE_SRQ_PG_SIZE_PG_8M			   (0x4UL << 2)
	#define CMDQ_CREATE_SRQ_PG_SIZE_PG_1G			   (0x5UL << 2)
	__le16 eventq_id;
	#define CMDQ_CREATE_SRQ_EVENTQ_ID_MASK			    0xfffUL
	#define CMDQ_CREATE_SRQ_EVENTQ_ID_SFT			    0
	__le16 srq_size;
	__le16 srq_fwo;
	__le32 dpi;
	__le32 pd_id;
	__le64 pbl;
};

/* Destroy SRQ command (24 bytes) */
struct cmdq_destroy_srq {
	u8 opcode;
	#define CMDQ_DESTROY_SRQ_OPCODE_DESTROY_SRQ		   0x6UL
	u8 cmd_size;
	__le16 flags;
	__le16 cookie;
	u8 resp_size;
	u8 reserved8;
	__le64 resp_addr;
	__le32 srq_cid;
	__le32 unused_0;
};

/* Query SRQ command (24 bytes) */
struct cmdq_query_srq {
	u8 opcode;
	#define CMDQ_QUERY_SRQ_OPCODE_QUERY_SRQ		   0x8UL
	u8 cmd_size;
	__le16 flags;
	__le16 cookie;
	u8 resp_size;
	u8 reserved8;
	__le64 resp_addr;
	__le32 srq_cid;
	__le32 unused_0;
};

/* Create CQ command (48 bytes) */
struct cmdq_create_cq {
	u8 opcode;
	#define CMDQ_CREATE_CQ_OPCODE_CREATE_CQ		   0x9UL
	u8 cmd_size;
	__le16 flags;
	__le16 cookie;
	u8 resp_size;
	u8 reserved8;
	__le64 resp_addr;
	__le64 cq_handle;
	__le32 pg_size_lvl;
	#define CMDQ_CREATE_CQ_LVL_MASK			    0x3UL
	#define CMDQ_CREATE_CQ_LVL_SFT				    0
	#define CMDQ_CREATE_CQ_LVL_LVL_0			   0x0UL
	#define CMDQ_CREATE_CQ_LVL_LVL_1			   0x1UL
	#define CMDQ_CREATE_CQ_LVL_LVL_2			   0x2UL
	#define CMDQ_CREATE_CQ_PG_SIZE_MASK			    0x1cUL
	#define CMDQ_CREATE_CQ_PG_SIZE_SFT			    2
	#define CMDQ_CREATE_CQ_PG_SIZE_PG_4K			   (0x0UL << 2)
	#define CMDQ_CREATE_CQ_PG_SIZE_PG_8K			   (0x1UL << 2)
	#define CMDQ_CREATE_CQ_PG_SIZE_PG_64K			   (0x2UL << 2)
	#define CMDQ_CREATE_CQ_PG_SIZE_PG_2M			   (0x3UL << 2)
	#define CMDQ_CREATE_CQ_PG_SIZE_PG_8M			   (0x4UL << 2)
	#define CMDQ_CREATE_CQ_PG_SIZE_PG_1G			   (0x5UL << 2)
	__le32 cq_fco_cnq_id;
	#define CMDQ_CREATE_CQ_CNQ_ID_MASK			    0xfffUL
	#define CMDQ_CREATE_CQ_CNQ_ID_SFT			    0
	#define CMDQ_CREATE_CQ_CQ_FCO_MASK			    0xfffff000UL
	#define CMDQ_CREATE_CQ_CQ_FCO_SFT			    12
	__le32 dpi;
	__le32 cq_size;
	__le64 pbl;
};

/* Destroy CQ command (24 bytes) */
struct cmdq_destroy_cq {
	u8 opcode;
	#define CMDQ_DESTROY_CQ_OPCODE_DESTROY_CQ		   0xaUL
	u8 cmd_size;
	__le16 flags;
	__le16 cookie;
	u8 resp_size;
	u8 reserved8;
	__le64 resp_addr;
	__le32 cq_cid;
	__le32 unused_0;
};

/* Resize CQ command (40 bytes) */
struct cmdq_resize_cq {
	u8 opcode;
	#define CMDQ_RESIZE_CQ_OPCODE_RESIZE_CQ		   0xcUL
	u8 cmd_size;
	__le16 flags;
	__le16 cookie;
	u8 resp_size;
	u8 reserved8;
	__le64 resp_addr;
	__le32 cq_cid;
	__le32 new_cq_size_pg_size_lvl;
	#define CMDQ_RESIZE_CQ_LVL_MASK			    0x3UL
	#define CMDQ_RESIZE_CQ_LVL_SFT				    0
	#define CMDQ_RESIZE_CQ_LVL_LVL_0			   0x0UL
	#define CMDQ_RESIZE_CQ_LVL_LVL_1			   0x1UL
	#define CMDQ_RESIZE_CQ_LVL_LVL_2			   0x2UL
	#define CMDQ_RESIZE_CQ_PG_SIZE_MASK			    0x1cUL
	#define CMDQ_RESIZE_CQ_PG_SIZE_SFT			    2
	#define CMDQ_RESIZE_CQ_PG_SIZE_PG_4K			   (0x0UL << 2)
	#define CMDQ_RESIZE_CQ_PG_SIZE_PG_8K			   (0x1UL << 2)
	#define CMDQ_RESIZE_CQ_PG_SIZE_PG_64K			   (0x2UL << 2)
	#define CMDQ_RESIZE_CQ_PG_SIZE_PG_2M			   (0x3UL << 2)
	#define CMDQ_RESIZE_CQ_PG_SIZE_PG_8M			   (0x4UL << 2)
	#define CMDQ_RESIZE_CQ_PG_SIZE_PG_1G			   (0x5UL << 2)
	#define CMDQ_RESIZE_CQ_NEW_CQ_SIZE_MASK		    0x1fffe0UL
	#define CMDQ_RESIZE_CQ_NEW_CQ_SIZE_SFT			    5
	__le64 new_pbl;
	__le32 new_cq_fco;
	__le32 unused_2;
};

/* Allocate MRW command (32 bytes) */
struct cmdq_allocate_mrw {
	u8 opcode;
	#define CMDQ_ALLOCATE_MRW_OPCODE_ALLOCATE_MRW		   0xdUL
	u8 cmd_size;
	__le16 flags;
	__le16 cookie;
	u8 resp_size;
	u8 reserved8;
	__le64 resp_addr;
	__le64 mrw_handle;
	u8 mrw_flags;
	#define CMDQ_ALLOCATE_MRW_MRW_FLAGS_MASK		    0xfUL
	#define CMDQ_ALLOCATE_MRW_MRW_FLAGS_SFT		    0
	#define CMDQ_ALLOCATE_MRW_MRW_FLAGS_MR			   0x0UL
	#define CMDQ_ALLOCATE_MRW_MRW_FLAGS_PMR		   0x1UL
	#define CMDQ_ALLOCATE_MRW_MRW_FLAGS_MW_TYPE1		   0x2UL
	#define CMDQ_ALLOCATE_MRW_MRW_FLAGS_MW_TYPE2A		   0x3UL
	#define CMDQ_ALLOCATE_MRW_MRW_FLAGS_MW_TYPE2B		   0x4UL
	u8 access;
	#define CMDQ_ALLOCATE_MRW_ACCESS_RESERVED_MASK		    0x1fUL
	#define CMDQ_ALLOCATE_MRW_ACCESS_RESERVED_SFT		    0
	#define CMDQ_ALLOCATE_MRW_ACCESS_CONSUMER_OWNED_KEY	    0x20UL
	__le16 unused_1;
	__le32 pd_id;
};

/* De-allocate key command (24 bytes) */
struct cmdq_deallocate_key {
	u8 opcode;
	#define CMDQ_DEALLOCATE_KEY_OPCODE_DEALLOCATE_KEY	   0xeUL
	u8 cmd_size;
	__le16 flags;
	__le16 cookie;
	u8 resp_size;
	u8 reserved8;
	__le64 resp_addr;
	u8 mrw_flags;
	#define CMDQ_DEALLOCATE_KEY_MRW_FLAGS_MASK		    0xfUL
	#define CMDQ_DEALLOCATE_KEY_MRW_FLAGS_SFT		    0
	#define CMDQ_DEALLOCATE_KEY_MRW_FLAGS_MR		   0x0UL
	#define CMDQ_DEALLOCATE_KEY_MRW_FLAGS_PMR		   0x1UL
	#define CMDQ_DEALLOCATE_KEY_MRW_FLAGS_MW_TYPE1		   0x2UL
	#define CMDQ_DEALLOCATE_KEY_MRW_FLAGS_MW_TYPE2A	   0x3UL
	#define CMDQ_DEALLOCATE_KEY_MRW_FLAGS_MW_TYPE2B	   0x4UL
	u8 unused_1[3];
	__le32 key;
};

/* Register MR command (48 bytes) */
struct cmdq_register_mr {
	u8 opcode;
	#define CMDQ_REGISTER_MR_OPCODE_REGISTER_MR		   0xfUL
	u8 cmd_size;
	__le16 flags;
	__le16 cookie;
	u8 resp_size;
	u8 reserved8;
	__le64 resp_addr;
	u8 log2_pg_size_lvl;
	#define CMDQ_REGISTER_MR_LVL_MASK			    0x3UL
	#define CMDQ_REGISTER_MR_LVL_SFT			    0
	#define CMDQ_REGISTER_MR_LVL_LVL_0			   0x0UL
	#define CMDQ_REGISTER_MR_LVL_LVL_1			   0x1UL
	#define CMDQ_REGISTER_MR_LVL_LVL_2			   0x2UL
	#define CMDQ_REGISTER_MR_LVL_LAST             CMDQ_REGISTER_MR_LVL_LVL_2
	#define CMDQ_REGISTER_MR_LOG2_PG_SIZE_MASK		    0x7cUL
	#define CMDQ_REGISTER_MR_LOG2_PG_SIZE_SFT		    2
	#define CMDQ_REGISTER_MR_LOG2_PG_SIZE_PG_4K    (0xcUL << 2)
	#define CMDQ_REGISTER_MR_LOG2_PG_SIZE_PG_8K    (0xdUL << 2)
	#define CMDQ_REGISTER_MR_LOG2_PG_SIZE_PG_64K   (0x10UL << 2)
	#define CMDQ_REGISTER_MR_LOG2_PG_SIZE_PG_256K  (0x12UL << 2)
	#define CMDQ_REGISTER_MR_LOG2_PG_SIZE_PG_1M    (0x14UL << 2)
	#define CMDQ_REGISTER_MR_LOG2_PG_SIZE_PG_2M    (0x15UL << 2)
	#define CMDQ_REGISTER_MR_LOG2_PG_SIZE_PG_4M    (0x16UL << 2)
	#define CMDQ_REGISTER_MR_LOG2_PG_SIZE_PG_1G    (0x1eUL << 2)
	#define CMDQ_REGISTER_MR_LOG2_PG_SIZE_LAST	\
					CMDQ_REGISTER_MR_LOG2_PG_SIZE_PG_1G
	#define CMDQ_REGISTER_MR_UNUSED1             0x80UL
	u8 access;
	#define CMDQ_REGISTER_MR_ACCESS_LOCAL_WRITE		    0x1UL
	#define CMDQ_REGISTER_MR_ACCESS_REMOTE_READ		    0x2UL
	#define CMDQ_REGISTER_MR_ACCESS_REMOTE_WRITE		    0x4UL
	#define CMDQ_REGISTER_MR_ACCESS_REMOTE_ATOMIC		    0x8UL
	#define CMDQ_REGISTER_MR_ACCESS_MW_BIND		    0x10UL
	#define CMDQ_REGISTER_MR_ACCESS_ZERO_BASED		    0x20UL
	__le16	log2_pbl_pg_size;
	#define CMDQ_REGISTER_MR_LOG2_PBL_PG_SIZE_MASK   0x1fUL
	#define CMDQ_REGISTER_MR_LOG2_PBL_PG_SIZE_SFT    0
	#define CMDQ_REGISTER_MR_LOG2_PBL_PG_SIZE_PG_4K    0xcUL
	#define CMDQ_REGISTER_MR_LOG2_PBL_PG_SIZE_PG_8K    0xdUL
	#define CMDQ_REGISTER_MR_LOG2_PBL_PG_SIZE_PG_64K   0x10UL
	#define CMDQ_REGISTER_MR_LOG2_PBL_PG_SIZE_PG_256K  0x12UL
	#define CMDQ_REGISTER_MR_LOG2_PBL_PG_SIZE_PG_1M    0x14UL
	#define CMDQ_REGISTER_MR_LOG2_PBL_PG_SIZE_PG_2M    0x15UL
	#define CMDQ_REGISTER_MR_LOG2_PBL_PG_SIZE_PG_4M    0x16UL
	#define CMDQ_REGISTER_MR_LOG2_PBL_PG_SIZE_PG_1G    0x1eUL
	#define CMDQ_REGISTER_MR_LOG2_PBL_PG_SIZE_LAST    \
				CMDQ_REGISTER_MR_LOG2_PBL_PG_SIZE_PG_1G
	#define CMDQ_REGISTER_MR_UNUSED11_MASK           0xffe0UL
	#define CMDQ_REGISTER_MR_UNUSED11_SFT            5
	__le32 key;
	__le64 pbl;
	__le64 va;
	__le64 mr_size;
};

/* Deregister MR command (24 bytes) */
struct cmdq_deregister_mr {
	u8 opcode;
	#define CMDQ_DEREGISTER_MR_OPCODE_DEREGISTER_MR	   0x10UL
	u8 cmd_size;
	__le16 flags;
	__le16 cookie;
	u8 resp_size;
	u8 reserved8;
	__le64 resp_addr;
	__le32 lkey;
	__le32 unused_0;
};

/* Add GID command (48 bytes) */
struct cmdq_add_gid {
	u8 opcode;
	#define CMDQ_ADD_GID_OPCODE_ADD_GID			   0x11UL
	u8 cmd_size;
	__le16 flags;
	__le16 cookie;
	u8 resp_size;
	u8 reserved8;
	__le64 resp_addr;
	__be32 gid[4];
	__be16 src_mac[3];
	__le16 vlan;
	#define CMDQ_ADD_GID_VLAN_VLAN_ID_MASK			    0xfffUL
	#define CMDQ_ADD_GID_VLAN_VLAN_ID_SFT			    0
	#define CMDQ_ADD_GID_VLAN_TPID_MASK			    0x7000UL
	#define CMDQ_ADD_GID_VLAN_TPID_SFT			    12
	#define CMDQ_ADD_GID_VLAN_TPID_TPID_88A8		   (0x0UL << 12)
	#define CMDQ_ADD_GID_VLAN_TPID_TPID_8100		   (0x1UL << 12)
	#define CMDQ_ADD_GID_VLAN_TPID_TPID_9100		   (0x2UL << 12)
	#define CMDQ_ADD_GID_VLAN_TPID_TPID_9200		   (0x3UL << 12)
	#define CMDQ_ADD_GID_VLAN_TPID_TPID_9300		   (0x4UL << 12)
	#define CMDQ_ADD_GID_VLAN_TPID_TPID_CFG1		   (0x5UL << 12)
	#define CMDQ_ADD_GID_VLAN_TPID_TPID_CFG2		   (0x6UL << 12)
	#define CMDQ_ADD_GID_VLAN_TPID_TPID_CFG3		   (0x7UL << 12)
	#define CMDQ_ADD_GID_VLAN_TPID_LAST    CMDQ_ADD_GID_VLAN_TPID_TPID_CFG3
	#define CMDQ_ADD_GID_VLAN_VLAN_EN			    0x8000UL
	__le16 ipid;
	__le16 stats_ctx;
	#define CMDQ_ADD_GID_STATS_CTX_STATS_CTX_ID_MASK	    0x7fffUL
	#define CMDQ_ADD_GID_STATS_CTX_STATS_CTX_ID_SFT	    0
	#define CMDQ_ADD_GID_STATS_CTX_STATS_CTX_VALID		    0x8000UL
	__le32 unused_0;
};

/* Delete GID command (24 bytes) */
struct cmdq_delete_gid {
	u8 opcode;
	#define CMDQ_DELETE_GID_OPCODE_DELETE_GID		   0x12UL
	u8 cmd_size;
	__le16 flags;
	__le16 cookie;
	u8 resp_size;
	u8 reserved8;
	__le64 resp_addr;
	__le16 gid_index;
	__le16 unused_0;
	__le32 unused_1;
};

/* Modify GID command (48 bytes) */
struct cmdq_modify_gid {
	u8 opcode;
	#define CMDQ_MODIFY_GID_OPCODE_MODIFY_GID		   0x17UL
	u8 cmd_size;
	__le16 flags;
	__le16 cookie;
	u8 resp_size;
	u8 reserved8;
	__le64 resp_addr;
	__be32 gid[4];
	__be16 src_mac[3];
	__le16 vlan;
	#define CMDQ_MODIFY_GID_VLAN_VLAN_ID_MASK		    0xfffUL
	#define CMDQ_MODIFY_GID_VLAN_VLAN_ID_SFT		    0
	#define CMDQ_MODIFY_GID_VLAN_TPID_MASK			    0x7000UL
	#define CMDQ_MODIFY_GID_VLAN_TPID_SFT			    12
	#define CMDQ_MODIFY_GID_VLAN_TPID_TPID_88A8		   (0x0UL << 12)
	#define CMDQ_MODIFY_GID_VLAN_TPID_TPID_8100		   (0x1UL << 12)
	#define CMDQ_MODIFY_GID_VLAN_TPID_TPID_9100		   (0x2UL << 12)
	#define CMDQ_MODIFY_GID_VLAN_TPID_TPID_9200		   (0x3UL << 12)
	#define CMDQ_MODIFY_GID_VLAN_TPID_TPID_9300		   (0x4UL << 12)
	#define CMDQ_MODIFY_GID_VLAN_TPID_TPID_CFG1		   (0x5UL << 12)
	#define CMDQ_MODIFY_GID_VLAN_TPID_TPID_CFG2		   (0x6UL << 12)
	#define CMDQ_MODIFY_GID_VLAN_TPID_TPID_CFG3		   (0x7UL << 12)
	#define CMDQ_MODIFY_GID_VLAN_TPID_LAST		\
					CMDQ_MODIFY_GID_VLAN_TPID_TPID_CFG3
	#define CMDQ_MODIFY_GID_VLAN_VLAN_EN			    0x8000UL
	__le16 ipid;
	__le16 gid_index;
	__le16 stats_ctx;
	#define CMDQ_MODIFY_GID_STATS_CTX_STATS_CTX_ID_MASK	    0x7fffUL
	#define CMDQ_MODIFY_GID_STATS_CTX_STATS_CTX_ID_SFT	    0
	#define CMDQ_MODIFY_GID_STATS_CTX_STATS_CTX_VALID	    0x8000UL
	__le16 unused_0;
};

/* Query GID command (24 bytes) */
struct cmdq_query_gid {
	u8 opcode;
	#define CMDQ_QUERY_GID_OPCODE_QUERY_GID		   0x18UL
	u8 cmd_size;
	__le16 flags;
	__le16 cookie;
	u8 resp_size;
	u8 reserved8;
	__le64 resp_addr;
	__le16 gid_index;
	__le16 unused_0;
	__le32 unused_1;
};

/* Create QP1 command (80 bytes) */
struct cmdq_create_qp1 {
	u8 opcode;
	#define CMDQ_CREATE_QP1_OPCODE_CREATE_QP1		   0x13UL
	u8 cmd_size;
	__le16 flags;
	__le16 cookie;
	u8 resp_size;
	u8 reserved8;
	__le64 resp_addr;
	__le64 qp_handle;
	__le32 qp_flags;
	#define CMDQ_CREATE_QP1_QP_FLAGS_SRQ_USED		   0x1UL
	#define CMDQ_CREATE_QP1_QP_FLAGS_FORCE_COMPLETION	   0x2UL
	#define CMDQ_CREATE_QP1_QP_FLAGS_RESERVED_LKEY_ENABLE     0x4UL
	u8 type;
	#define CMDQ_CREATE_QP1_TYPE_GSI			   0x1UL
	u8 sq_pg_size_sq_lvl;
	#define CMDQ_CREATE_QP1_SQ_LVL_MASK			    0xfUL
	#define CMDQ_CREATE_QP1_SQ_LVL_SFT			    0
	#define CMDQ_CREATE_QP1_SQ_LVL_LVL_0			   0x0UL
	#define CMDQ_CREATE_QP1_SQ_LVL_LVL_1			   0x1UL
	#define CMDQ_CREATE_QP1_SQ_LVL_LVL_2			   0x2UL
	#define CMDQ_CREATE_QP1_SQ_PG_SIZE_MASK		    0xf0UL
	#define CMDQ_CREATE_QP1_SQ_PG_SIZE_SFT			    4
	#define CMDQ_CREATE_QP1_SQ_PG_SIZE_PG_4K		   (0x0UL << 4)
	#define CMDQ_CREATE_QP1_SQ_PG_SIZE_PG_8K		   (0x1UL << 4)
	#define CMDQ_CREATE_QP1_SQ_PG_SIZE_PG_64K		   (0x2UL << 4)
	#define CMDQ_CREATE_QP1_SQ_PG_SIZE_PG_2M		   (0x3UL << 4)
	#define CMDQ_CREATE_QP1_SQ_PG_SIZE_PG_8M		   (0x4UL << 4)
	#define CMDQ_CREATE_QP1_SQ_PG_SIZE_PG_1G		   (0x5UL << 4)
	u8 rq_pg_size_rq_lvl;
	#define CMDQ_CREATE_QP1_RQ_LVL_MASK			    0xfUL
	#define CMDQ_CREATE_QP1_RQ_LVL_SFT			    0
	#define CMDQ_CREATE_QP1_RQ_LVL_LVL_0			   0x0UL
	#define CMDQ_CREATE_QP1_RQ_LVL_LVL_1			   0x1UL
	#define CMDQ_CREATE_QP1_RQ_LVL_LVL_2			   0x2UL
	#define CMDQ_CREATE_QP1_RQ_PG_SIZE_MASK		    0xf0UL
	#define CMDQ_CREATE_QP1_RQ_PG_SIZE_SFT			    4
	#define CMDQ_CREATE_QP1_RQ_PG_SIZE_PG_4K		   (0x0UL << 4)
	#define CMDQ_CREATE_QP1_RQ_PG_SIZE_PG_8K		   (0x1UL << 4)
	#define CMDQ_CREATE_QP1_RQ_PG_SIZE_PG_64K		   (0x2UL << 4)
	#define CMDQ_CREATE_QP1_RQ_PG_SIZE_PG_2M		   (0x3UL << 4)
	#define CMDQ_CREATE_QP1_RQ_PG_SIZE_PG_8M		   (0x4UL << 4)
	#define CMDQ_CREATE_QP1_RQ_PG_SIZE_PG_1G		   (0x5UL << 4)
	u8 unused_0;
	__le32 dpi;
	__le32 sq_size;
	__le32 rq_size;
	__le16 sq_fwo_sq_sge;
	#define CMDQ_CREATE_QP1_SQ_SGE_MASK			    0xfUL
	#define CMDQ_CREATE_QP1_SQ_SGE_SFT			    0
	#define CMDQ_CREATE_QP1_SQ_FWO_MASK			    0xfff0UL
	#define CMDQ_CREATE_QP1_SQ_FWO_SFT			    4
	__le16 rq_fwo_rq_sge;
	#define CMDQ_CREATE_QP1_RQ_SGE_MASK			    0xfUL
	#define CMDQ_CREATE_QP1_RQ_SGE_SFT			    0
	#define CMDQ_CREATE_QP1_RQ_FWO_MASK			    0xfff0UL
	#define CMDQ_CREATE_QP1_RQ_FWO_SFT			    4
	__le32 scq_cid;
	__le32 rcq_cid;
	__le32 srq_cid;
	__le32 pd_id;
	__le64 sq_pbl;
	__le64 rq_pbl;
};

/* Destroy QP1 command (24 bytes) */
struct cmdq_destroy_qp1 {
	u8 opcode;
	#define CMDQ_DESTROY_QP1_OPCODE_DESTROY_QP1		   0x14UL
	u8 cmd_size;
	__le16 flags;
	__le16 cookie;
	u8 resp_size;
	u8 reserved8;
	__le64 resp_addr;
	__le32 qp1_cid;
	__le32 unused_0;
};

/* Create AH command (64 bytes) */
struct cmdq_create_ah {
	u8 opcode;
	#define CMDQ_CREATE_AH_OPCODE_CREATE_AH		   0x15UL
	u8 cmd_size;
	__le16 flags;
	__le16 cookie;
	u8 resp_size;
	u8 reserved8;
	__le64 resp_addr;
	__le64 ah_handle;
	__le32 dgid[4];
	u8 type;
	#define CMDQ_CREATE_AH_TYPE_V1				   0x0UL
	#define CMDQ_CREATE_AH_TYPE_V2IPV4			   0x2UL
	#define CMDQ_CREATE_AH_TYPE_V2IPV6			   0x3UL
	u8 hop_limit;
	__le16 sgid_index;
	__le32 dest_vlan_id_flow_label;
	#define CMDQ_CREATE_AH_FLOW_LABEL_MASK			    0xfffffUL
	#define CMDQ_CREATE_AH_FLOW_LABEL_SFT			    0
	#define CMDQ_CREATE_AH_DEST_VLAN_ID_MASK		    0xfff00000UL
	#define CMDQ_CREATE_AH_DEST_VLAN_ID_SFT		    20
	__le32 pd_id;
	__le32 unused_0;
	__le16 dest_mac[3];
	u8 traffic_class;
	u8 unused_1;
};

/* Destroy AH command (24 bytes) */
struct cmdq_destroy_ah {
	u8 opcode;
	#define CMDQ_DESTROY_AH_OPCODE_DESTROY_AH		   0x16UL
	u8 cmd_size;
	__le16 flags;
	__le16 cookie;
	u8 resp_size;
	u8 reserved8;
	__le64 resp_addr;
	__le32 ah_cid;
	__le32 unused_0;
};

/* Initialize Firmware command (112 bytes) */
struct cmdq_initialize_fw {
	u8 opcode;
	#define CMDQ_INITIALIZE_FW_OPCODE_INITIALIZE_FW	   0x80UL
	u8 cmd_size;
	__le16 flags;
	__le16 cookie;
	u8 resp_size;
	u8 reserved8;
	__le64 resp_addr;
	u8 qpc_pg_size_qpc_lvl;
	#define CMDQ_INITIALIZE_FW_QPC_LVL_MASK		    0xfUL
	#define CMDQ_INITIALIZE_FW_QPC_LVL_SFT			    0
	#define CMDQ_INITIALIZE_FW_QPC_LVL_LVL_0		   0x0UL
	#define CMDQ_INITIALIZE_FW_QPC_LVL_LVL_1		   0x1UL
	#define CMDQ_INITIALIZE_FW_QPC_LVL_LVL_2		   0x2UL
	#define CMDQ_INITIALIZE_FW_QPC_PG_SIZE_MASK		    0xf0UL
	#define CMDQ_INITIALIZE_FW_QPC_PG_SIZE_SFT		    4
	#define CMDQ_INITIALIZE_FW_QPC_PG_SIZE_PG_4K		   (0x0UL << 4)
	#define CMDQ_INITIALIZE_FW_QPC_PG_SIZE_PG_8K		   (0x1UL << 4)
	#define CMDQ_INITIALIZE_FW_QPC_PG_SIZE_PG_64K		   (0x2UL << 4)
	#define CMDQ_INITIALIZE_FW_QPC_PG_SIZE_PG_2M		   (0x3UL << 4)
	#define CMDQ_INITIALIZE_FW_QPC_PG_SIZE_PG_8M		   (0x4UL << 4)
	#define CMDQ_INITIALIZE_FW_QPC_PG_SIZE_PG_1G		   (0x5UL << 4)
	u8 mrw_pg_size_mrw_lvl;
	#define CMDQ_INITIALIZE_FW_MRW_LVL_MASK		    0xfUL
	#define CMDQ_INITIALIZE_FW_MRW_LVL_SFT			    0
	#define CMDQ_INITIALIZE_FW_MRW_LVL_LVL_0		   0x0UL
	#define CMDQ_INITIALIZE_FW_MRW_LVL_LVL_1		   0x1UL
	#define CMDQ_INITIALIZE_FW_MRW_LVL_LVL_2		   0x2UL
	#define CMDQ_INITIALIZE_FW_MRW_PG_SIZE_MASK		    0xf0UL
	#define CMDQ_INITIALIZE_FW_MRW_PG_SIZE_SFT		    4
	#define CMDQ_INITIALIZE_FW_MRW_PG_SIZE_PG_4K		   (0x0UL << 4)
	#define CMDQ_INITIALIZE_FW_MRW_PG_SIZE_PG_8K		   (0x1UL << 4)
	#define CMDQ_INITIALIZE_FW_MRW_PG_SIZE_PG_64K		   (0x2UL << 4)
	#define CMDQ_INITIALIZE_FW_MRW_PG_SIZE_PG_2M		   (0x3UL << 4)
	#define CMDQ_INITIALIZE_FW_MRW_PG_SIZE_PG_8M		   (0x4UL << 4)
	#define CMDQ_INITIALIZE_FW_MRW_PG_SIZE_PG_1G		   (0x5UL << 4)
	u8 srq_pg_size_srq_lvl;
	#define CMDQ_INITIALIZE_FW_SRQ_LVL_MASK		    0xfUL
	#define CMDQ_INITIALIZE_FW_SRQ_LVL_SFT			    0
	#define CMDQ_INITIALIZE_FW_SRQ_LVL_LVL_0		   0x0UL
	#define CMDQ_INITIALIZE_FW_SRQ_LVL_LVL_1		   0x1UL
	#define CMDQ_INITIALIZE_FW_SRQ_LVL_LVL_2		   0x2UL
	#define CMDQ_INITIALIZE_FW_SRQ_PG_SIZE_MASK		    0xf0UL
	#define CMDQ_INITIALIZE_FW_SRQ_PG_SIZE_SFT		    4
	#define CMDQ_INITIALIZE_FW_SRQ_PG_SIZE_PG_4K		   (0x0UL << 4)
	#define CMDQ_INITIALIZE_FW_SRQ_PG_SIZE_PG_8K		   (0x1UL << 4)
	#define CMDQ_INITIALIZE_FW_SRQ_PG_SIZE_PG_64K		   (0x2UL << 4)
	#define CMDQ_INITIALIZE_FW_SRQ_PG_SIZE_PG_2M		   (0x3UL << 4)
	#define CMDQ_INITIALIZE_FW_SRQ_PG_SIZE_PG_8M		   (0x4UL << 4)
	#define CMDQ_INITIALIZE_FW_SRQ_PG_SIZE_PG_1G		   (0x5UL << 4)
	u8 cq_pg_size_cq_lvl;
	#define CMDQ_INITIALIZE_FW_CQ_LVL_MASK			    0xfUL
	#define CMDQ_INITIALIZE_FW_CQ_LVL_SFT			    0
	#define CMDQ_INITIALIZE_FW_CQ_LVL_LVL_0		   0x0UL
	#define CMDQ_INITIALIZE_FW_CQ_LVL_LVL_1		   0x1UL
	#define CMDQ_INITIALIZE_FW_CQ_LVL_LVL_2		   0x2UL
	#define CMDQ_INITIALIZE_FW_CQ_PG_SIZE_MASK		    0xf0UL
	#define CMDQ_INITIALIZE_FW_CQ_PG_SIZE_SFT		    4
	#define CMDQ_INITIALIZE_FW_CQ_PG_SIZE_PG_4K		   (0x0UL << 4)
	#define CMDQ_INITIALIZE_FW_CQ_PG_SIZE_PG_8K		   (0x1UL << 4)
	#define CMDQ_INITIALIZE_FW_CQ_PG_SIZE_PG_64K		   (0x2UL << 4)
	#define CMDQ_INITIALIZE_FW_CQ_PG_SIZE_PG_2M		   (0x3UL << 4)
	#define CMDQ_INITIALIZE_FW_CQ_PG_SIZE_PG_8M		   (0x4UL << 4)
	#define CMDQ_INITIALIZE_FW_CQ_PG_SIZE_PG_1G		   (0x5UL << 4)
	u8 tqm_pg_size_tqm_lvl;
	#define CMDQ_INITIALIZE_FW_TQM_LVL_MASK		    0xfUL
	#define CMDQ_INITIALIZE_FW_TQM_LVL_SFT			    0
	#define CMDQ_INITIALIZE_FW_TQM_LVL_LVL_0		   0x0UL
	#define CMDQ_INITIALIZE_FW_TQM_LVL_LVL_1		   0x1UL
	#define CMDQ_INITIALIZE_FW_TQM_LVL_LVL_2		   0x2UL
	#define CMDQ_INITIALIZE_FW_TQM_PG_SIZE_MASK		    0xf0UL
	#define CMDQ_INITIALIZE_FW_TQM_PG_SIZE_SFT		    4
	#define CMDQ_INITIALIZE_FW_TQM_PG_SIZE_PG_4K		   (0x0UL << 4)
	#define CMDQ_INITIALIZE_FW_TQM_PG_SIZE_PG_8K		   (0x1UL << 4)
	#define CMDQ_INITIALIZE_FW_TQM_PG_SIZE_PG_64K		   (0x2UL << 4)
	#define CMDQ_INITIALIZE_FW_TQM_PG_SIZE_PG_2M		   (0x3UL << 4)
	#define CMDQ_INITIALIZE_FW_TQM_PG_SIZE_PG_8M		   (0x4UL << 4)
	#define CMDQ_INITIALIZE_FW_TQM_PG_SIZE_PG_1G		   (0x5UL << 4)
	u8 tim_pg_size_tim_lvl;
	#define CMDQ_INITIALIZE_FW_TIM_LVL_MASK		    0xfUL
	#define CMDQ_INITIALIZE_FW_TIM_LVL_SFT			    0
	#define CMDQ_INITIALIZE_FW_TIM_LVL_LVL_0		   0x0UL
	#define CMDQ_INITIALIZE_FW_TIM_LVL_LVL_1		   0x1UL
	#define CMDQ_INITIALIZE_FW_TIM_LVL_LVL_2		   0x2UL
	#define CMDQ_INITIALIZE_FW_TIM_PG_SIZE_MASK		    0xf0UL
	#define CMDQ_INITIALIZE_FW_TIM_PG_SIZE_SFT		    4
	#define CMDQ_INITIALIZE_FW_TIM_PG_SIZE_PG_4K		   (0x0UL << 4)
	#define CMDQ_INITIALIZE_FW_TIM_PG_SIZE_PG_8K		   (0x1UL << 4)
	#define CMDQ_INITIALIZE_FW_TIM_PG_SIZE_PG_64K		   (0x2UL << 4)
	#define CMDQ_INITIALIZE_FW_TIM_PG_SIZE_PG_2M		   (0x3UL << 4)
	#define CMDQ_INITIALIZE_FW_TIM_PG_SIZE_PG_8M		   (0x4UL << 4)
	#define CMDQ_INITIALIZE_FW_TIM_PG_SIZE_PG_1G		   (0x5UL << 4)
	__le16 reserved16;
	__le64 qpc_page_dir;
	__le64 mrw_page_dir;
	__le64 srq_page_dir;
	__le64 cq_page_dir;
	__le64 tqm_page_dir;
	__le64 tim_page_dir;
	__le32 number_of_qp;
	__le32 number_of_mrw;
	__le32 number_of_srq;
	__le32 number_of_cq;
	__le32 max_qp_per_vf;
	__le32 max_mrw_per_vf;
	__le32 max_srq_per_vf;
	__le32 max_cq_per_vf;
	__le32 max_gid_per_vf;
	__le32 stat_ctx_id;
};

/* De-initialize Firmware command (16 bytes) */
struct cmdq_deinitialize_fw {
	u8 opcode;
	#define CMDQ_DEINITIALIZE_FW_OPCODE_DEINITIALIZE_FW       0x81UL
	u8 cmd_size;
	__le16 flags;
	__le16 cookie;
	u8 resp_size;
	u8 reserved8;
	__le64 resp_addr;
};

/* Stop function command (16 bytes) */
struct cmdq_stop_func {
	u8 opcode;
	#define CMDQ_STOP_FUNC_OPCODE_STOP_FUNC		   0x82UL
	u8 cmd_size;
	__le16 flags;
	__le16 cookie;
	u8 resp_size;
	u8 reserved8;
	__le64 resp_addr;
};

/* Query function command (16 bytes) */
struct cmdq_query_func {
	u8 opcode;
	#define CMDQ_QUERY_FUNC_OPCODE_QUERY_FUNC		   0x83UL
	u8 cmd_size;
	__le16 flags;
	__le16 cookie;
	u8 resp_size;
	u8 reserved8;
	__le64 resp_addr;
};

/* Set function resources command (16 bytes) */
struct cmdq_set_func_resources {
	u8 opcode;
	#define CMDQ_SET_FUNC_RESOURCES_OPCODE_SET_FUNC_RESOURCES 0x84UL
	u8 cmd_size;
	__le16 flags;
	__le16 cookie;
	u8 resp_size;
	u8 reserved8;
	__le64 resp_addr;
	__le32 number_of_qp;
	__le32 number_of_mrw;
	__le32 number_of_srq;
	__le32 number_of_cq;
	__le32 max_qp_per_vf;
	__le32 max_mrw_per_vf;
	__le32 max_srq_per_vf;
	__le32 max_cq_per_vf;
	__le32 max_gid_per_vf;
	__le32 stat_ctx_id;
};

/* Read hardware resource context command (24 bytes) */
struct cmdq_read_context {
	u8 opcode;
	#define CMDQ_READ_CONTEXT_OPCODE_READ_CONTEXT		   0x85UL
	u8 cmd_size;
	__le16 flags;
	__le16 cookie;
	u8 resp_size;
	u8 reserved8;
	__le64 resp_addr;
	__le32 type_xid;
	#define CMDQ_READ_CONTEXT_XID_MASK			    0xffffffUL
	#define CMDQ_READ_CONTEXT_XID_SFT			    0
	#define CMDQ_READ_CONTEXT_TYPE_MASK			    0xff000000UL
	#define CMDQ_READ_CONTEXT_TYPE_SFT			    24
	#define CMDQ_READ_CONTEXT_TYPE_QPC			   (0x0UL << 24)
	#define CMDQ_READ_CONTEXT_TYPE_CQ			   (0x1UL << 24)
	#define CMDQ_READ_CONTEXT_TYPE_MRW			   (0x2UL << 24)
	#define CMDQ_READ_CONTEXT_TYPE_SRQ			   (0x3UL << 24)
	__le32 unused_0;
};

/* Map TC to COS. Can only be issued from a PF (24 bytes) */
struct cmdq_map_tc_to_cos {
	u8 opcode;
	#define CMDQ_MAP_TC_TO_COS_OPCODE_MAP_TC_TO_COS	   0x8aUL
	u8 cmd_size;
	__le16 flags;
	__le16 cookie;
	u8 resp_size;
	u8 reserved8;
	__le64 resp_addr;
	__le16 cos0;
	#define CMDQ_MAP_TC_TO_COS_COS0_NO_CHANGE		   0xffffUL
	__le16 cos1;
	#define CMDQ_MAP_TC_TO_COS_COS1_DISABLE		   0x8000UL
	#define CMDQ_MAP_TC_TO_COS_COS1_NO_CHANGE		   0xffffUL
	__le32 unused_0;
};

/* Query version command (16 bytes) */
struct cmdq_query_version {
	u8 opcode;
	#define CMDQ_QUERY_VERSION_OPCODE_QUERY_VERSION	   0x8bUL
	u8 cmd_size;
	__le16 flags;
	__le16 cookie;
	u8 resp_size;
	u8 reserved8;
	__le64 resp_addr;
};

/* Command-Response Event Queue (CREQ) Structures */
/* Base CREQ Record (16 bytes) */
struct creq_base {
	u8 type;
	#define CREQ_BASE_TYPE_MASK				    0x3fUL
	#define CREQ_BASE_TYPE_SFT				    0
	#define CREQ_BASE_TYPE_QP_EVENT			   0x38UL
	#define CREQ_BASE_TYPE_FUNC_EVENT			   0x3aUL
	#define CREQ_BASE_RESERVED2_MASK			    0xc0UL
	#define CREQ_BASE_RESERVED2_SFT			    6
	u8 reserved56[7];
	u8 v;
	#define CREQ_BASE_V					    0x1UL
	#define CREQ_BASE_RESERVED7_MASK			    0xfeUL
	#define CREQ_BASE_RESERVED7_SFT			    1
	u8 event;
	__le16 reserved48[3];
};

/* RoCE Function Async Event Notification (16 bytes) */
struct creq_func_event {
	u8 type;
	#define CREQ_FUNC_EVENT_TYPE_MASK			    0x3fUL
	#define CREQ_FUNC_EVENT_TYPE_SFT			    0
	#define CREQ_FUNC_EVENT_TYPE_FUNC_EVENT		   0x3aUL
	#define CREQ_FUNC_EVENT_RESERVED2_MASK			    0xc0UL
	#define CREQ_FUNC_EVENT_RESERVED2_SFT			    6
	u8 reserved56[7];
	u8 v;
	#define CREQ_FUNC_EVENT_V				    0x1UL
	#define CREQ_FUNC_EVENT_RESERVED7_MASK			    0xfeUL
	#define CREQ_FUNC_EVENT_RESERVED7_SFT			    1
	u8 event;
	#define CREQ_FUNC_EVENT_EVENT_TX_WQE_ERROR		   0x1UL
	#define CREQ_FUNC_EVENT_EVENT_TX_DATA_ERROR		   0x2UL
	#define CREQ_FUNC_EVENT_EVENT_RX_WQE_ERROR		   0x3UL
	#define CREQ_FUNC_EVENT_EVENT_RX_DATA_ERROR		   0x4UL
	#define CREQ_FUNC_EVENT_EVENT_CQ_ERROR			   0x5UL
	#define CREQ_FUNC_EVENT_EVENT_TQM_ERROR		   0x6UL
	#define CREQ_FUNC_EVENT_EVENT_CFCQ_ERROR		   0x7UL
	#define CREQ_FUNC_EVENT_EVENT_CFCS_ERROR		   0x8UL
	#define CREQ_FUNC_EVENT_EVENT_CFCC_ERROR		   0x9UL
	#define CREQ_FUNC_EVENT_EVENT_CFCM_ERROR		   0xaUL
	#define CREQ_FUNC_EVENT_EVENT_TIM_ERROR		   0xbUL
	#define CREQ_FUNC_EVENT_EVENT_VF_COMM_REQUEST		   0x80UL
	#define CREQ_FUNC_EVENT_EVENT_RESOURCE_EXHAUSTED	   0x81UL
	__le16 reserved48[3];
};

/* RoCE Slowpath Command Completion (16 bytes) */
struct creq_qp_event {
	u8 type;
	#define CREQ_QP_EVENT_TYPE_MASK			    0x3fUL
	#define CREQ_QP_EVENT_TYPE_SFT				    0
	#define CREQ_QP_EVENT_TYPE_QP_EVENT			   0x38UL
	#define CREQ_QP_EVENT_RESERVED2_MASK			    0xc0UL
	#define CREQ_QP_EVENT_RESERVED2_SFT			    6
	u8 status;
	__le16 cookie;
	__le32 reserved32;
	u8 v;
	#define CREQ_QP_EVENT_V				    0x1UL
	#define CREQ_QP_EVENT_RESERVED7_MASK			    0xfeUL
	#define CREQ_QP_EVENT_RESERVED7_SFT			    1
	u8 event;
	#define CREQ_QP_EVENT_EVENT_CREATE_QP			   0x1UL
	#define CREQ_QP_EVENT_EVENT_DESTROY_QP			   0x2UL
	#define CREQ_QP_EVENT_EVENT_MODIFY_QP			   0x3UL
	#define CREQ_QP_EVENT_EVENT_QUERY_QP			   0x4UL
	#define CREQ_QP_EVENT_EVENT_CREATE_SRQ			   0x5UL
	#define CREQ_QP_EVENT_EVENT_DESTROY_SRQ		   0x6UL
	#define CREQ_QP_EVENT_EVENT_QUERY_SRQ			   0x8UL
	#define CREQ_QP_EVENT_EVENT_CREATE_CQ			   0x9UL
	#define CREQ_QP_EVENT_EVENT_DESTROY_CQ			   0xaUL
	#define CREQ_QP_EVENT_EVENT_RESIZE_CQ			   0xcUL
	#define CREQ_QP_EVENT_EVENT_ALLOCATE_MRW		   0xdUL
	#define CREQ_QP_EVENT_EVENT_DEALLOCATE_KEY		   0xeUL
	#define CREQ_QP_EVENT_EVENT_REGISTER_MR		   0xfUL
	#define CREQ_QP_EVENT_EVENT_DEREGISTER_MR		   0x10UL
	#define CREQ_QP_EVENT_EVENT_ADD_GID			   0x11UL
	#define CREQ_QP_EVENT_EVENT_DELETE_GID			   0x12UL
	#define CREQ_QP_EVENT_EVENT_MODIFY_GID			   0x17UL
	#define CREQ_QP_EVENT_EVENT_QUERY_GID			   0x18UL
	#define CREQ_QP_EVENT_EVENT_CREATE_QP1			   0x13UL
	#define CREQ_QP_EVENT_EVENT_DESTROY_QP1		   0x14UL
	#define CREQ_QP_EVENT_EVENT_CREATE_AH			   0x15UL
	#define CREQ_QP_EVENT_EVENT_DESTROY_AH			   0x16UL
	#define CREQ_QP_EVENT_EVENT_INITIALIZE_FW		   0x80UL
	#define CREQ_QP_EVENT_EVENT_DEINITIALIZE_FW		   0x81UL
	#define CREQ_QP_EVENT_EVENT_STOP_FUNC			   0x82UL
	#define CREQ_QP_EVENT_EVENT_QUERY_FUNC			   0x83UL
	#define CREQ_QP_EVENT_EVENT_SET_FUNC_RESOURCES		   0x84UL
	#define CREQ_QP_EVENT_EVENT_MAP_TC_TO_COS		   0x8aUL
	#define CREQ_QP_EVENT_EVENT_QUERY_VERSION		   0x8bUL
	#define CREQ_QP_EVENT_EVENT_MODIFY_CC			   0x8cUL
	#define CREQ_QP_EVENT_EVENT_QUERY_CC			   0x8dUL
	#define CREQ_QP_EVENT_EVENT_QP_ERROR_NOTIFICATION	   0xc0UL
	__le16 reserved48[3];
};

/* Create QP command response (16 bytes) */
struct creq_create_qp_resp {
	u8 type;
	#define CREQ_CREATE_QP_RESP_TYPE_MASK			    0x3fUL
	#define CREQ_CREATE_QP_RESP_TYPE_SFT			    0
	#define CREQ_CREATE_QP_RESP_TYPE_QP_EVENT		   0x38UL
	#define CREQ_CREATE_QP_RESP_RESERVED2_MASK		    0xc0UL
	#define CREQ_CREATE_QP_RESP_RESERVED2_SFT		    6
	u8 status;
	__le16 cookie;
	__le32 xid;
	u8 v;
	#define CREQ_CREATE_QP_RESP_V				    0x1UL
	#define CREQ_CREATE_QP_RESP_RESERVED7_MASK		    0xfeUL
	#define CREQ_CREATE_QP_RESP_RESERVED7_SFT		    1
	u8 event;
	#define CREQ_CREATE_QP_RESP_EVENT_CREATE_QP		   0x1UL
	__le16 reserved48[3];
};

/* Destroy QP command response (16 bytes) */
struct creq_destroy_qp_resp {
	u8 type;
	#define CREQ_DESTROY_QP_RESP_TYPE_MASK			    0x3fUL
	#define CREQ_DESTROY_QP_RESP_TYPE_SFT			    0
	#define CREQ_DESTROY_QP_RESP_TYPE_QP_EVENT		   0x38UL
	#define CREQ_DESTROY_QP_RESP_RESERVED2_MASK		    0xc0UL
	#define CREQ_DESTROY_QP_RESP_RESERVED2_SFT		    6
	u8 status;
	__le16 cookie;
	__le32 xid;
	u8 v;
	#define CREQ_DESTROY_QP_RESP_V				    0x1UL
	#define CREQ_DESTROY_QP_RESP_RESERVED7_MASK		    0xfeUL
	#define CREQ_DESTROY_QP_RESP_RESERVED7_SFT		    1
	u8 event;
	#define CREQ_DESTROY_QP_RESP_EVENT_DESTROY_QP		   0x2UL
	__le16 reserved48[3];
};

/* Modify QP command response (16 bytes) */
struct creq_modify_qp_resp {
	u8 type;
	#define CREQ_MODIFY_QP_RESP_TYPE_MASK			    0x3fUL
	#define CREQ_MODIFY_QP_RESP_TYPE_SFT			    0
	#define CREQ_MODIFY_QP_RESP_TYPE_QP_EVENT		   0x38UL
	#define CREQ_MODIFY_QP_RESP_RESERVED2_MASK		    0xc0UL
	#define CREQ_MODIFY_QP_RESP_RESERVED2_SFT		    6
	u8 status;
	__le16 cookie;
	__le32 xid;
	u8 v;
	#define CREQ_MODIFY_QP_RESP_V				    0x1UL
	#define CREQ_MODIFY_QP_RESP_RESERVED7_MASK		    0xfeUL
	#define CREQ_MODIFY_QP_RESP_RESERVED7_SFT		    1
	u8 event;
	#define CREQ_MODIFY_QP_RESP_EVENT_MODIFY_QP		   0x3UL
	__le16 reserved48[3];
};

/* cmdq_query_roce_stats (size:128b/16B) */
struct cmdq_query_roce_stats {
	u8	opcode;
	#define CMDQ_QUERY_ROCE_STATS_OPCODE_QUERY_ROCE_STATS 0x8eUL
	#define CMDQ_QUERY_ROCE_STATS_OPCODE_LAST	\
				CMDQ_QUERY_ROCE_STATS_OPCODE_QUERY_ROCE_STATS
	u8	cmd_size;
	__le16	flags;
	__le16	cookie;
	u8	resp_size;
	u8	reserved8;
	__le64	resp_addr;
};

/* Query QP command response (16 bytes) */
struct creq_query_qp_resp {
	u8 type;
	#define CREQ_QUERY_QP_RESP_TYPE_MASK			    0x3fUL
	#define CREQ_QUERY_QP_RESP_TYPE_SFT			    0
	#define CREQ_QUERY_QP_RESP_TYPE_QP_EVENT		   0x38UL
	#define CREQ_QUERY_QP_RESP_RESERVED2_MASK		    0xc0UL
	#define CREQ_QUERY_QP_RESP_RESERVED2_SFT		    6
	u8 status;
	__le16 cookie;
	__le32 size;
	u8 v;
	#define CREQ_QUERY_QP_RESP_V				    0x1UL
	#define CREQ_QUERY_QP_RESP_RESERVED7_MASK		    0xfeUL
	#define CREQ_QUERY_QP_RESP_RESERVED7_SFT		    1
	u8 event;
	#define CREQ_QUERY_QP_RESP_EVENT_QUERY_QP		   0x4UL
	__le16 reserved48[3];
};

/* Query QP command response side buffer structure (104 bytes) */
struct creq_query_qp_resp_sb {
	u8 opcode;
	#define CREQ_QUERY_QP_RESP_SB_OPCODE_QUERY_QP		   0x4UL
	u8 status;
	__le16 cookie;
	__le16 flags;
	u8 resp_size;
	u8 reserved8;
	__le32 xid;
	u8 en_sqd_async_notify_state;
	#define CREQ_QUERY_QP_RESP_SB_STATE_MASK		    0xfUL
	#define CREQ_QUERY_QP_RESP_SB_STATE_SFT		    0
	#define CREQ_QUERY_QP_RESP_SB_STATE_RESET		   0x0UL
	#define CREQ_QUERY_QP_RESP_SB_STATE_INIT		   0x1UL
	#define CREQ_QUERY_QP_RESP_SB_STATE_RTR		   0x2UL
	#define CREQ_QUERY_QP_RESP_SB_STATE_RTS		   0x3UL
	#define CREQ_QUERY_QP_RESP_SB_STATE_SQD		   0x4UL
	#define CREQ_QUERY_QP_RESP_SB_STATE_SQE		   0x5UL
	#define CREQ_QUERY_QP_RESP_SB_STATE_ERR		   0x6UL
	#define CREQ_QUERY_QP_RESP_SB_EN_SQD_ASYNC_NOTIFY	    0x10UL
	u8 access;
	#define CREQ_QUERY_QP_RESP_SB_ACCESS_LOCAL_WRITE	    0x1UL
	#define CREQ_QUERY_QP_RESP_SB_ACCESS_REMOTE_WRITE	    0x2UL
	#define CREQ_QUERY_QP_RESP_SB_ACCESS_REMOTE_READ	    0x4UL
	#define CREQ_QUERY_QP_RESP_SB_ACCESS_REMOTE_ATOMIC	    0x8UL
	__le16 pkey;
	__le32 qkey;
	__le32 reserved32;
	__le32 dgid[4];
	__le32 flow_label;
	__le16 sgid_index;
	u8 hop_limit;
	u8 traffic_class;
	__le16 dest_mac[3];
	__le16 path_mtu_dest_vlan_id;
	#define CREQ_QUERY_QP_RESP_SB_DEST_VLAN_ID_MASK	    0xfffUL
	#define CREQ_QUERY_QP_RESP_SB_DEST_VLAN_ID_SFT		    0
	#define CREQ_QUERY_QP_RESP_SB_PATH_MTU_MASK		    0xf000UL
	#define CREQ_QUERY_QP_RESP_SB_PATH_MTU_SFT		    12
	#define CREQ_QUERY_QP_RESP_SB_PATH_MTU_MTU_256		   (0x0UL << 12)
	#define CREQ_QUERY_QP_RESP_SB_PATH_MTU_MTU_512		   (0x1UL << 12)
	#define CREQ_QUERY_QP_RESP_SB_PATH_MTU_MTU_1024	   (0x2UL << 12)
	#define CREQ_QUERY_QP_RESP_SB_PATH_MTU_MTU_2048	   (0x3UL << 12)
	#define CREQ_QUERY_QP_RESP_SB_PATH_MTU_MTU_4096	   (0x4UL << 12)
	#define CREQ_QUERY_QP_RESP_SB_PATH_MTU_MTU_8192	   (0x5UL << 12)
	u8 timeout;
	u8 retry_cnt;
	u8 rnr_retry;
	u8 min_rnr_timer;
	__le32 rq_psn;
	__le32 sq_psn;
	u8 max_rd_atomic;
	u8 max_dest_rd_atomic;
	u8 tos_dscp_tos_ecn;
	#define CREQ_QUERY_QP_RESP_SB_TOS_ECN_MASK		    0x3UL
	#define CREQ_QUERY_QP_RESP_SB_TOS_ECN_SFT		    0
	#define CREQ_QUERY_QP_RESP_SB_TOS_DSCP_MASK		    0xfcUL
	#define CREQ_QUERY_QP_RESP_SB_TOS_DSCP_SFT		    2
	u8 enable_cc;
	#define CREQ_QUERY_QP_RESP_SB_ENABLE_CC		    0x1UL
	#define CREQ_QUERY_QP_RESP_SB_RESERVED7_MASK		    0xfeUL
	#define CREQ_QUERY_QP_RESP_SB_RESERVED7_SFT		    1
	__le32 sq_size;
	__le32 rq_size;
	__le16 sq_sge;
	__le16 rq_sge;
	__le32 max_inline_data;
	__le32 dest_qp_id;
	__le32 unused_1;
	__le16 src_mac[3];
	__le16 vlan_pcp_vlan_dei_vlan_id;
	#define CREQ_QUERY_QP_RESP_SB_VLAN_ID_MASK		    0xfffUL
	#define CREQ_QUERY_QP_RESP_SB_VLAN_ID_SFT		    0
	#define CREQ_QUERY_QP_RESP_SB_VLAN_DEI			    0x1000UL
	#define CREQ_QUERY_QP_RESP_SB_VLAN_PCP_MASK		    0xe000UL
	#define CREQ_QUERY_QP_RESP_SB_VLAN_PCP_SFT		    13
};

/* Create SRQ command response (16 bytes) */
struct creq_create_srq_resp {
	u8 type;
	#define CREQ_CREATE_SRQ_RESP_TYPE_MASK			    0x3fUL
	#define CREQ_CREATE_SRQ_RESP_TYPE_SFT			    0
	#define CREQ_CREATE_SRQ_RESP_TYPE_QP_EVENT		   0x38UL
	#define CREQ_CREATE_SRQ_RESP_RESERVED2_MASK		    0xc0UL
	#define CREQ_CREATE_SRQ_RESP_RESERVED2_SFT		    6
	u8 status;
	__le16 cookie;
	__le32 xid;
	u8 v;
	#define CREQ_CREATE_SRQ_RESP_V				    0x1UL
	#define CREQ_CREATE_SRQ_RESP_RESERVED7_MASK		    0xfeUL
	#define CREQ_CREATE_SRQ_RESP_RESERVED7_SFT		    1
	u8 event;
	#define CREQ_CREATE_SRQ_RESP_EVENT_CREATE_SRQ		   0x5UL
	__le16 reserved48[3];
};

/* Destroy SRQ command response (16 bytes) */
struct creq_destroy_srq_resp {
	u8 type;
	#define CREQ_DESTROY_SRQ_RESP_TYPE_MASK		    0x3fUL
	#define CREQ_DESTROY_SRQ_RESP_TYPE_SFT			    0
	#define CREQ_DESTROY_SRQ_RESP_TYPE_QP_EVENT		   0x38UL
	#define CREQ_DESTROY_SRQ_RESP_RESERVED2_MASK		    0xc0UL
	#define CREQ_DESTROY_SRQ_RESP_RESERVED2_SFT		    6
	u8 status;
	__le16 cookie;
	__le32 xid;
	u8 v;
	#define CREQ_DESTROY_SRQ_RESP_V			    0x1UL
	#define CREQ_DESTROY_SRQ_RESP_RESERVED7_MASK		    0xfeUL
	#define CREQ_DESTROY_SRQ_RESP_RESERVED7_SFT		    1
	u8 event;
	#define CREQ_DESTROY_SRQ_RESP_EVENT_DESTROY_SRQ	   0x6UL
	__le16 enable_for_arm[3];
	#define CREQ_DESTROY_SRQ_RESP_ENABLE_FOR_ARM_MASK	    0x30000UL
	#define CREQ_DESTROY_SRQ_RESP_ENABLE_FOR_ARM_SFT	    16
	#define CREQ_DESTROY_SRQ_RESP_RESERVED46_MASK		    0xfffc0000UL
	#define CREQ_DESTROY_SRQ_RESP_RESERVED46_SFT		    18
};

/* Query SRQ command response (16 bytes) */
struct creq_query_srq_resp {
	u8 type;
	#define CREQ_QUERY_SRQ_RESP_TYPE_MASK			    0x3fUL
	#define CREQ_QUERY_SRQ_RESP_TYPE_SFT			    0
	#define CREQ_QUERY_SRQ_RESP_TYPE_QP_EVENT		   0x38UL
	#define CREQ_QUERY_SRQ_RESP_RESERVED2_MASK		    0xc0UL
	#define CREQ_QUERY_SRQ_RESP_RESERVED2_SFT		    6
	u8 status;
	__le16 cookie;
	__le32 size;
	u8 v;
	#define CREQ_QUERY_SRQ_RESP_V				    0x1UL
	#define CREQ_QUERY_SRQ_RESP_RESERVED7_MASK		    0xfeUL
	#define CREQ_QUERY_SRQ_RESP_RESERVED7_SFT		    1
	u8 event;
	#define CREQ_QUERY_SRQ_RESP_EVENT_QUERY_SRQ		   0x8UL
	__le16 reserved48[3];
};

/* Query SRQ command response side buffer structure (24 bytes) */
struct creq_query_srq_resp_sb {
	u8 opcode;
	#define CREQ_QUERY_SRQ_RESP_SB_OPCODE_QUERY_SRQ	   0x8UL
	u8 status;
	__le16 cookie;
	__le16 flags;
	u8 resp_size;
	u8 reserved8;
	__le32 xid;
	__le16 srq_limit;
	__le16 reserved16;
	__le32 data[4];
};

/* Create CQ command Response (16 bytes) */
struct creq_create_cq_resp {
	u8 type;
	#define CREQ_CREATE_CQ_RESP_TYPE_MASK			    0x3fUL
	#define CREQ_CREATE_CQ_RESP_TYPE_SFT			    0
	#define CREQ_CREATE_CQ_RESP_TYPE_QP_EVENT		   0x38UL
	#define CREQ_CREATE_CQ_RESP_RESERVED2_MASK		    0xc0UL
	#define CREQ_CREATE_CQ_RESP_RESERVED2_SFT		    6
	u8 status;
	__le16 cookie;
	__le32 xid;
	u8 v;
	#define CREQ_CREATE_CQ_RESP_V				    0x1UL
	#define CREQ_CREATE_CQ_RESP_RESERVED7_MASK		    0xfeUL
	#define CREQ_CREATE_CQ_RESP_RESERVED7_SFT		    1
	u8 event;
	#define CREQ_CREATE_CQ_RESP_EVENT_CREATE_CQ		   0x9UL
	__le16 reserved48[3];
};

/* Destroy CQ command response (16 bytes) */
struct creq_destroy_cq_resp {
	u8 type;
	#define CREQ_DESTROY_CQ_RESP_TYPE_MASK			    0x3fUL
	#define CREQ_DESTROY_CQ_RESP_TYPE_SFT			    0
	#define CREQ_DESTROY_CQ_RESP_TYPE_QP_EVENT		   0x38UL
	#define CREQ_DESTROY_CQ_RESP_RESERVED2_MASK		    0xc0UL
	#define CREQ_DESTROY_CQ_RESP_RESERVED2_SFT		    6
	u8 status;
	__le16 cookie;
	__le32 xid;
	u8 v;
	#define CREQ_DESTROY_CQ_RESP_V				    0x1UL
	#define CREQ_DESTROY_CQ_RESP_RESERVED7_MASK		    0xfeUL
	#define CREQ_DESTROY_CQ_RESP_RESERVED7_SFT		    1
	u8 event;
	#define CREQ_DESTROY_CQ_RESP_EVENT_DESTROY_CQ		   0xaUL
	__le16 cq_arm_lvl;
	#define CREQ_DESTROY_CQ_RESP_CQ_ARM_LVL_MASK		    0x3UL
	#define CREQ_DESTROY_CQ_RESP_CQ_ARM_LVL_SFT		    0
	#define CREQ_DESTROY_CQ_RESP_RESERVED14_MASK		    0xfffcUL
	#define CREQ_DESTROY_CQ_RESP_RESERVED14_SFT		    2
	__le16 total_cnq_events;
	__le16 reserved16;
};

/* Resize CQ command response (16 bytes) */
struct creq_resize_cq_resp {
	u8 type;
	#define CREQ_RESIZE_CQ_RESP_TYPE_MASK			    0x3fUL
	#define CREQ_RESIZE_CQ_RESP_TYPE_SFT			    0
	#define CREQ_RESIZE_CQ_RESP_TYPE_QP_EVENT		   0x38UL
	#define CREQ_RESIZE_CQ_RESP_RESERVED2_MASK		    0xc0UL
	#define CREQ_RESIZE_CQ_RESP_RESERVED2_SFT		    6
	u8 status;
	__le16 cookie;
	__le32 xid;
	u8 v;
	#define CREQ_RESIZE_CQ_RESP_V				    0x1UL
	#define CREQ_RESIZE_CQ_RESP_RESERVED7_MASK		    0xfeUL
	#define CREQ_RESIZE_CQ_RESP_RESERVED7_SFT		    1
	u8 event;
	#define CREQ_RESIZE_CQ_RESP_EVENT_RESIZE_CQ		   0xcUL
	__le16 reserved48[3];
};

/* Allocate MRW command response (16 bytes) */
struct creq_allocate_mrw_resp {
	u8 type;
	#define CREQ_ALLOCATE_MRW_RESP_TYPE_MASK		    0x3fUL
	#define CREQ_ALLOCATE_MRW_RESP_TYPE_SFT		    0
	#define CREQ_ALLOCATE_MRW_RESP_TYPE_QP_EVENT		   0x38UL
	#define CREQ_ALLOCATE_MRW_RESP_RESERVED2_MASK		    0xc0UL
	#define CREQ_ALLOCATE_MRW_RESP_RESERVED2_SFT		    6
	u8 status;
	__le16 cookie;
	__le32 xid;
	u8 v;
	#define CREQ_ALLOCATE_MRW_RESP_V			    0x1UL
	#define CREQ_ALLOCATE_MRW_RESP_RESERVED7_MASK		    0xfeUL
	#define CREQ_ALLOCATE_MRW_RESP_RESERVED7_SFT		    1
	u8 event;
	#define CREQ_ALLOCATE_MRW_RESP_EVENT_ALLOCATE_MRW	   0xdUL
	__le16 reserved48[3];
};

/* De-allocate key command response (16 bytes) */
struct creq_deallocate_key_resp {
	u8 type;
	#define CREQ_DEALLOCATE_KEY_RESP_TYPE_MASK		    0x3fUL
	#define CREQ_DEALLOCATE_KEY_RESP_TYPE_SFT		    0
	#define CREQ_DEALLOCATE_KEY_RESP_TYPE_QP_EVENT		   0x38UL
	#define CREQ_DEALLOCATE_KEY_RESP_RESERVED2_MASK	    0xc0UL
	#define CREQ_DEALLOCATE_KEY_RESP_RESERVED2_SFT		    6
	u8 status;
	__le16 cookie;
	__le32 xid;
	u8 v;
	#define CREQ_DEALLOCATE_KEY_RESP_V			    0x1UL
	#define CREQ_DEALLOCATE_KEY_RESP_RESERVED7_MASK	    0xfeUL
	#define CREQ_DEALLOCATE_KEY_RESP_RESERVED7_SFT		    1
	u8 event;
	#define CREQ_DEALLOCATE_KEY_RESP_EVENT_DEALLOCATE_KEY     0xeUL
	__le16 reserved16;
	__le32 bound_window_info;
};

/* Register MR command response (16 bytes) */
struct creq_register_mr_resp {
	u8 type;
	#define CREQ_REGISTER_MR_RESP_TYPE_MASK		    0x3fUL
	#define CREQ_REGISTER_MR_RESP_TYPE_SFT			    0
	#define CREQ_REGISTER_MR_RESP_TYPE_QP_EVENT		   0x38UL
	#define CREQ_REGISTER_MR_RESP_RESERVED2_MASK		    0xc0UL
	#define CREQ_REGISTER_MR_RESP_RESERVED2_SFT		    6
	u8 status;
	__le16 cookie;
	__le32 xid;
	u8 v;
	#define CREQ_REGISTER_MR_RESP_V			    0x1UL
	#define CREQ_REGISTER_MR_RESP_RESERVED7_MASK		    0xfeUL
	#define CREQ_REGISTER_MR_RESP_RESERVED7_SFT		    1
	u8 event;
	#define CREQ_REGISTER_MR_RESP_EVENT_REGISTER_MR	   0xfUL
	__le16 reserved48[3];
};

/* Deregister MR command response (16 bytes) */
struct creq_deregister_mr_resp {
	u8 type;
	#define CREQ_DEREGISTER_MR_RESP_TYPE_MASK		    0x3fUL
	#define CREQ_DEREGISTER_MR_RESP_TYPE_SFT		    0
	#define CREQ_DEREGISTER_MR_RESP_TYPE_QP_EVENT		   0x38UL
	#define CREQ_DEREGISTER_MR_RESP_RESERVED2_MASK		    0xc0UL
	#define CREQ_DEREGISTER_MR_RESP_RESERVED2_SFT		    6
	u8 status;
	__le16 cookie;
	__le32 xid;
	u8 v;
	#define CREQ_DEREGISTER_MR_RESP_V			    0x1UL
	#define CREQ_DEREGISTER_MR_RESP_RESERVED7_MASK		    0xfeUL
	#define CREQ_DEREGISTER_MR_RESP_RESERVED7_SFT		    1
	u8 event;
	#define CREQ_DEREGISTER_MR_RESP_EVENT_DEREGISTER_MR       0x10UL
	__le16 reserved16;
	__le32 bound_windows;
};

/* Add GID command response (16 bytes) */
struct creq_add_gid_resp {
	u8 type;
	#define CREQ_ADD_GID_RESP_TYPE_MASK			    0x3fUL
	#define CREQ_ADD_GID_RESP_TYPE_SFT			    0
	#define CREQ_ADD_GID_RESP_TYPE_QP_EVENT		   0x38UL
	#define CREQ_ADD_GID_RESP_RESERVED2_MASK		    0xc0UL
	#define CREQ_ADD_GID_RESP_RESERVED2_SFT		    6
	u8 status;
	__le16 cookie;
	__le32 xid;
	u8 v;
	#define CREQ_ADD_GID_RESP_V				    0x1UL
	#define CREQ_ADD_GID_RESP_RESERVED7_MASK		    0xfeUL
	#define CREQ_ADD_GID_RESP_RESERVED7_SFT		    1
	u8 event;
	#define CREQ_ADD_GID_RESP_EVENT_ADD_GID		   0x11UL
	__le16 reserved48[3];
};

/* Delete GID command response (16 bytes) */
struct creq_delete_gid_resp {
	u8 type;
	#define CREQ_DELETE_GID_RESP_TYPE_MASK			    0x3fUL
	#define CREQ_DELETE_GID_RESP_TYPE_SFT			    0
	#define CREQ_DELETE_GID_RESP_TYPE_QP_EVENT		   0x38UL
	#define CREQ_DELETE_GID_RESP_RESERVED2_MASK		    0xc0UL
	#define CREQ_DELETE_GID_RESP_RESERVED2_SFT		    6
	u8 status;
	__le16 cookie;
	__le32 xid;
	u8 v;
	#define CREQ_DELETE_GID_RESP_V				    0x1UL
	#define CREQ_DELETE_GID_RESP_RESERVED7_MASK		    0xfeUL
	#define CREQ_DELETE_GID_RESP_RESERVED7_SFT		    1
	u8 event;
	#define CREQ_DELETE_GID_RESP_EVENT_DELETE_GID		   0x12UL
	__le16 reserved48[3];
};

/* Modify GID command response (16 bytes) */
struct creq_modify_gid_resp {
	u8 type;
	#define CREQ_MODIFY_GID_RESP_TYPE_MASK			    0x3fUL
	#define CREQ_MODIFY_GID_RESP_TYPE_SFT			    0
	#define CREQ_MODIFY_GID_RESP_TYPE_QP_EVENT		   0x38UL
	#define CREQ_MODIFY_GID_RESP_RESERVED2_MASK		    0xc0UL
	#define CREQ_MODIFY_GID_RESP_RESERVED2_SFT		    6
	u8 status;
	__le16 cookie;
	__le32 xid;
	u8 v;
	#define CREQ_MODIFY_GID_RESP_V				    0x1UL
	#define CREQ_MODIFY_GID_RESP_RESERVED7_MASK		    0xfeUL
	#define CREQ_MODIFY_GID_RESP_RESERVED7_SFT		    1
	u8 event;
	#define CREQ_MODIFY_GID_RESP_EVENT_ADD_GID		   0x11UL
	__le16 reserved48[3];
};

/* Query GID command response (16 bytes) */
struct creq_query_gid_resp {
	u8 type;
	#define CREQ_QUERY_GID_RESP_TYPE_MASK			    0x3fUL
	#define CREQ_QUERY_GID_RESP_TYPE_SFT			    0
	#define CREQ_QUERY_GID_RESP_TYPE_QP_EVENT		   0x38UL
	#define CREQ_QUERY_GID_RESP_RESERVED2_MASK		    0xc0UL
	#define CREQ_QUERY_GID_RESP_RESERVED2_SFT		    6
	u8 status;
	__le16 cookie;
	__le32 size;
	u8 v;
	#define CREQ_QUERY_GID_RESP_V				    0x1UL
	#define CREQ_QUERY_GID_RESP_RESERVED7_MASK		    0xfeUL
	#define CREQ_QUERY_GID_RESP_RESERVED7_SFT		    1
	u8 event;
	#define CREQ_QUERY_GID_RESP_EVENT_QUERY_GID		   0x18UL
	__le16 reserved48[3];
};

/* Query GID command response side buffer structure (40 bytes) */
struct creq_query_gid_resp_sb {
	u8 opcode;
	#define CREQ_QUERY_GID_RESP_SB_OPCODE_QUERY_GID	   0x18UL
	u8 status;
	__le16 cookie;
	__le16 flags;
	u8 resp_size;
	u8 reserved8;
	__le32 gid[4];
	__le16 src_mac[3];
	__le16 vlan;
	#define CREQ_QUERY_GID_RESP_SB_VLAN_VLAN_ID_MASK	    0xfffUL
	#define CREQ_QUERY_GID_RESP_SB_VLAN_VLAN_ID_SFT	    0
	#define CREQ_QUERY_GID_RESP_SB_VLAN_TPID_MASK		    0x7000UL
	#define CREQ_QUERY_GID_RESP_SB_VLAN_TPID_SFT		    12
	#define CREQ_QUERY_GID_RESP_SB_VLAN_TPID_TPID_88A8	   (0x0UL << 12)
	#define CREQ_QUERY_GID_RESP_SB_VLAN_TPID_TPID_8100	   (0x1UL << 12)
	#define CREQ_QUERY_GID_RESP_SB_VLAN_TPID_TPID_9100	   (0x2UL << 12)
	#define CREQ_QUERY_GID_RESP_SB_VLAN_TPID_TPID_9200	   (0x3UL << 12)
	#define CREQ_QUERY_GID_RESP_SB_VLAN_TPID_TPID_9300	   (0x4UL << 12)
	#define CREQ_QUERY_GID_RESP_SB_VLAN_TPID_TPID_CFG1	   (0x5UL << 12)
	#define CREQ_QUERY_GID_RESP_SB_VLAN_TPID_TPID_CFG2	   (0x6UL << 12)
	#define CREQ_QUERY_GID_RESP_SB_VLAN_TPID_TPID_CFG3	   (0x7UL << 12)
	#define CREQ_QUERY_GID_RESP_SB_VLAN_TPID_LAST	\
				CREQ_QUERY_GID_RESP_SB_VLAN_TPID_TPID_CFG3
	#define CREQ_QUERY_GID_RESP_SB_VLAN_VLAN_EN		    0x8000UL
	__le16 ipid;
	__le16 gid_index;
	__le32 unused_0;
};

/* Create QP1 command response (16 bytes) */
struct creq_create_qp1_resp {
	u8 type;
	#define CREQ_CREATE_QP1_RESP_TYPE_MASK			    0x3fUL
	#define CREQ_CREATE_QP1_RESP_TYPE_SFT			    0
	#define CREQ_CREATE_QP1_RESP_TYPE_QP_EVENT		   0x38UL
	#define CREQ_CREATE_QP1_RESP_RESERVED2_MASK		    0xc0UL
	#define CREQ_CREATE_QP1_RESP_RESERVED2_SFT		    6
	u8 status;
	__le16 cookie;
	__le32 xid;
	u8 v;
	#define CREQ_CREATE_QP1_RESP_V				    0x1UL
	#define CREQ_CREATE_QP1_RESP_RESERVED7_MASK		    0xfeUL
	#define CREQ_CREATE_QP1_RESP_RESERVED7_SFT		    1
	u8 event;
	#define CREQ_CREATE_QP1_RESP_EVENT_CREATE_QP1		   0x13UL
	__le16 reserved48[3];
};

/* Destroy QP1 command response (16 bytes) */
struct creq_destroy_qp1_resp {
	u8 type;
	#define CREQ_DESTROY_QP1_RESP_TYPE_MASK		    0x3fUL
	#define CREQ_DESTROY_QP1_RESP_TYPE_SFT			    0
	#define CREQ_DESTROY_QP1_RESP_TYPE_QP_EVENT		   0x38UL
	#define CREQ_DESTROY_QP1_RESP_RESERVED2_MASK		    0xc0UL
	#define CREQ_DESTROY_QP1_RESP_RESERVED2_SFT		    6
	u8 status;
	__le16 cookie;
	__le32 xid;
	u8 v;
	#define CREQ_DESTROY_QP1_RESP_V			    0x1UL
	#define CREQ_DESTROY_QP1_RESP_RESERVED7_MASK		    0xfeUL
	#define CREQ_DESTROY_QP1_RESP_RESERVED7_SFT		    1
	u8 event;
	#define CREQ_DESTROY_QP1_RESP_EVENT_DESTROY_QP1	   0x14UL
	__le16 reserved48[3];
};

/* Create AH command response (16 bytes) */
struct creq_create_ah_resp {
	u8 type;
	#define CREQ_CREATE_AH_RESP_TYPE_MASK			    0x3fUL
	#define CREQ_CREATE_AH_RESP_TYPE_SFT			    0
	#define CREQ_CREATE_AH_RESP_TYPE_QP_EVENT		   0x38UL
	#define CREQ_CREATE_AH_RESP_RESERVED2_MASK		    0xc0UL
	#define CREQ_CREATE_AH_RESP_RESERVED2_SFT		    6
	u8 status;
	__le16 cookie;
	__le32 xid;
	u8 v;
	#define CREQ_CREATE_AH_RESP_V				    0x1UL
	#define CREQ_CREATE_AH_RESP_RESERVED7_MASK		    0xfeUL
	#define CREQ_CREATE_AH_RESP_RESERVED7_SFT		    1
	u8 event;
	#define CREQ_CREATE_AH_RESP_EVENT_CREATE_AH		   0x15UL
	__le16 reserved48[3];
};

/* Destroy AH command response (16 bytes) */
struct creq_destroy_ah_resp {
	u8 type;
	#define CREQ_DESTROY_AH_RESP_TYPE_MASK			    0x3fUL
	#define CREQ_DESTROY_AH_RESP_TYPE_SFT			    0
	#define CREQ_DESTROY_AH_RESP_TYPE_QP_EVENT		   0x38UL
	#define CREQ_DESTROY_AH_RESP_RESERVED2_MASK		    0xc0UL
	#define CREQ_DESTROY_AH_RESP_RESERVED2_SFT		    6
	u8 status;
	__le16 cookie;
	__le32 xid;
	u8 v;
	#define CREQ_DESTROY_AH_RESP_V				    0x1UL
	#define CREQ_DESTROY_AH_RESP_RESERVED7_MASK		    0xfeUL
	#define CREQ_DESTROY_AH_RESP_RESERVED7_SFT		    1
	u8 event;
	#define CREQ_DESTROY_AH_RESP_EVENT_DESTROY_AH		   0x16UL
	__le16 reserved48[3];
};

/* Initialize Firmware command response (16 bytes) */
struct creq_initialize_fw_resp {
	u8 type;
	#define CREQ_INITIALIZE_FW_RESP_TYPE_MASK		    0x3fUL
	#define CREQ_INITIALIZE_FW_RESP_TYPE_SFT		    0
	#define CREQ_INITIALIZE_FW_RESP_TYPE_QP_EVENT		   0x38UL
	#define CREQ_INITIALIZE_FW_RESP_RESERVED2_MASK		    0xc0UL
	#define CREQ_INITIALIZE_FW_RESP_RESERVED2_SFT		    6
	u8 status;
	__le16 cookie;
	__le32 reserved32;
	u8 v;
	#define CREQ_INITIALIZE_FW_RESP_V			    0x1UL
	#define CREQ_INITIALIZE_FW_RESP_RESERVED7_MASK		    0xfeUL
	#define CREQ_INITIALIZE_FW_RESP_RESERVED7_SFT		    1
	u8 event;
	#define CREQ_INITIALIZE_FW_RESP_EVENT_INITIALIZE_FW       0x80UL
	__le16 reserved48[3];
};

/* De-initialize Firmware command response (16 bytes) */
struct creq_deinitialize_fw_resp {
	u8 type;
	#define CREQ_DEINITIALIZE_FW_RESP_TYPE_MASK		    0x3fUL
	#define CREQ_DEINITIALIZE_FW_RESP_TYPE_SFT		    0
	#define CREQ_DEINITIALIZE_FW_RESP_TYPE_QP_EVENT	   0x38UL
	#define CREQ_DEINITIALIZE_FW_RESP_RESERVED2_MASK	    0xc0UL
	#define CREQ_DEINITIALIZE_FW_RESP_RESERVED2_SFT	    6
	u8 status;
	__le16 cookie;
	__le32 reserved32;
	u8 v;
	#define CREQ_DEINITIALIZE_FW_RESP_V			    0x1UL
	#define CREQ_DEINITIALIZE_FW_RESP_RESERVED7_MASK	    0xfeUL
	#define CREQ_DEINITIALIZE_FW_RESP_RESERVED7_SFT	    1
	u8 event;
	#define CREQ_DEINITIALIZE_FW_RESP_EVENT_DEINITIALIZE_FW   0x81UL
	__le16 reserved48[3];
};

/* Stop function command response (16 bytes) */
struct creq_stop_func_resp {
	u8 type;
	#define CREQ_STOP_FUNC_RESP_TYPE_MASK			    0x3fUL
	#define CREQ_STOP_FUNC_RESP_TYPE_SFT			    0
	#define CREQ_STOP_FUNC_RESP_TYPE_QP_EVENT		   0x38UL
	#define CREQ_STOP_FUNC_RESP_RESERVED2_MASK		    0xc0UL
	#define CREQ_STOP_FUNC_RESP_RESERVED2_SFT		    6
	u8 status;
	__le16 cookie;
	__le32 reserved32;
	u8 v;
	#define CREQ_STOP_FUNC_RESP_V				    0x1UL
	#define CREQ_STOP_FUNC_RESP_RESERVED7_MASK		    0xfeUL
	#define CREQ_STOP_FUNC_RESP_RESERVED7_SFT		    1
	u8 event;
	#define CREQ_STOP_FUNC_RESP_EVENT_STOP_FUNC		   0x82UL
	__le16 reserved48[3];
};

/* Query function command response (16 bytes) */
struct creq_query_func_resp {
	u8 type;
	#define CREQ_QUERY_FUNC_RESP_TYPE_MASK			    0x3fUL
	#define CREQ_QUERY_FUNC_RESP_TYPE_SFT			    0
	#define CREQ_QUERY_FUNC_RESP_TYPE_QP_EVENT		   0x38UL
	#define CREQ_QUERY_FUNC_RESP_RESERVED2_MASK		    0xc0UL
	#define CREQ_QUERY_FUNC_RESP_RESERVED2_SFT		    6
	u8 status;
	__le16 cookie;
	__le32 size;
	u8 v;
	#define CREQ_QUERY_FUNC_RESP_V				    0x1UL
	#define CREQ_QUERY_FUNC_RESP_RESERVED7_MASK		    0xfeUL
	#define CREQ_QUERY_FUNC_RESP_RESERVED7_SFT		    1
	u8 event;
	#define CREQ_QUERY_FUNC_RESP_EVENT_QUERY_FUNC		   0x83UL
	__le16 reserved48[3];
};

/* Query function command response side buffer structure (88 bytes) */
struct creq_query_func_resp_sb {
	u8 opcode;
	#define CREQ_QUERY_FUNC_RESP_SB_OPCODE_QUERY_FUNC	   0x83UL
	u8 status;
	__le16 cookie;
	__le16 flags;
	u8 resp_size;
	u8 reserved8;
	__le64 max_mr_size;
	__le32 max_qp;
	__le16 max_qp_wr;
	__le16 dev_cap_flags;
	#define CREQ_QUERY_FUNC_RESP_SB_DEV_CAP_FLAGS_RESIZE_QP   0x1UL
	__le32 max_cq;
	__le32 max_cqe;
	__le32 max_pd;
	u8 max_sge;
	u8 max_srq_sge;
	u8 max_qp_rd_atom;
	u8 max_qp_init_rd_atom;
	__le32 max_mr;
	__le32 max_mw;
	__le32 max_raw_eth_qp;
	__le32 max_ah;
	__le32 max_fmr;
	__le32 max_srq_wr;
	__le32 max_pkeys;
	__le32 max_inline_data;
	u8 max_map_per_fmr;
	u8 l2_db_space_size;
	__le16 max_srq;
	__le32 max_gid;
	__le32 tqm_alloc_reqs[12];
};

/* Set resources command response (16 bytes) */
struct creq_set_func_resources_resp {
	u8 type;
	#define CREQ_SET_FUNC_RESOURCES_RESP_TYPE_MASK		    0x3fUL
	#define CREQ_SET_FUNC_RESOURCES_RESP_TYPE_SFT		    0
	#define CREQ_SET_FUNC_RESOURCES_RESP_TYPE_QP_EVENT	   0x38UL
	#define CREQ_SET_FUNC_RESOURCES_RESP_RESERVED2_MASK	    0xc0UL
	#define CREQ_SET_FUNC_RESOURCES_RESP_RESERVED2_SFT	    6
	u8 status;
	__le16 cookie;
	__le32 reserved32;
	u8 v;
	#define CREQ_SET_FUNC_RESOURCES_RESP_V			    0x1UL
	#define CREQ_SET_FUNC_RESOURCES_RESP_RESERVED7_MASK	    0xfeUL
	#define CREQ_SET_FUNC_RESOURCES_RESP_RESERVED7_SFT	    1
	u8 event;
	#define CREQ_SET_FUNC_RESOURCES_RESP_EVENT_SET_FUNC_RESOURCES 0x84UL
	__le16 reserved48[3];
};

/* Map TC to COS response (16 bytes) */
struct creq_map_tc_to_cos_resp {
	u8 type;
	#define CREQ_MAP_TC_TO_COS_RESP_TYPE_MASK		    0x3fUL
	#define CREQ_MAP_TC_TO_COS_RESP_TYPE_SFT		    0
	#define CREQ_MAP_TC_TO_COS_RESP_TYPE_QP_EVENT		   0x38UL
	#define CREQ_MAP_TC_TO_COS_RESP_RESERVED2_MASK		    0xc0UL
	#define CREQ_MAP_TC_TO_COS_RESP_RESERVED2_SFT		    6
	u8 status;
	__le16 cookie;
	__le32 reserved32;
	u8 v;
	#define CREQ_MAP_TC_TO_COS_RESP_V			    0x1UL
	#define CREQ_MAP_TC_TO_COS_RESP_RESERVED7_MASK		    0xfeUL
	#define CREQ_MAP_TC_TO_COS_RESP_RESERVED7_SFT		    1
	u8 event;
	#define CREQ_MAP_TC_TO_COS_RESP_EVENT_MAP_TC_TO_COS       0x8aUL
	__le16 reserved48[3];
};

/* Query version response (16 bytes) */
struct creq_query_version_resp {
	u8 type;
	#define CREQ_QUERY_VERSION_RESP_TYPE_MASK		    0x3fUL
	#define CREQ_QUERY_VERSION_RESP_TYPE_SFT		    0
	#define CREQ_QUERY_VERSION_RESP_TYPE_QP_EVENT		   0x38UL
	#define CREQ_QUERY_VERSION_RESP_RESERVED2_MASK		    0xc0UL
	#define CREQ_QUERY_VERSION_RESP_RESERVED2_SFT		    6
	u8 status;
	__le16 cookie;
	u8 fw_maj;
	u8 fw_minor;
	u8 fw_bld;
	u8 fw_rsvd;
	u8 v;
	#define CREQ_QUERY_VERSION_RESP_V			    0x1UL
	#define CREQ_QUERY_VERSION_RESP_RESERVED7_MASK		    0xfeUL
	#define CREQ_QUERY_VERSION_RESP_RESERVED7_SFT		    1
	u8 event;
	#define CREQ_QUERY_VERSION_RESP_EVENT_QUERY_VERSION       0x8bUL
	__le16 reserved16;
	u8 intf_maj;
	u8 intf_minor;
	u8 intf_bld;
	u8 intf_rsvd;
};

/* Modify congestion control command response (16 bytes) */
struct creq_modify_cc_resp {
	u8 type;
	#define CREQ_MODIFY_CC_RESP_TYPE_MASK			    0x3fUL
	#define CREQ_MODIFY_CC_RESP_TYPE_SFT			    0
	#define CREQ_MODIFY_CC_RESP_TYPE_QP_EVENT		   0x38UL
	#define CREQ_MODIFY_CC_RESP_RESERVED2_MASK		    0xc0UL
	#define CREQ_MODIFY_CC_RESP_RESERVED2_SFT		    6
	u8 status;
	__le16 cookie;
	__le32 reserved32;
	u8 v;
	#define CREQ_MODIFY_CC_RESP_V				    0x1UL
	#define CREQ_MODIFY_CC_RESP_RESERVED7_MASK		    0xfeUL
	#define CREQ_MODIFY_CC_RESP_RESERVED7_SFT		    1
	u8 event;
	#define CREQ_MODIFY_CC_RESP_EVENT_MODIFY_CC		   0x8cUL
	__le16 reserved48[3];
};

/* Query congestion control command response (16 bytes) */
struct creq_query_cc_resp {
	u8 type;
	#define CREQ_QUERY_CC_RESP_TYPE_MASK			    0x3fUL
	#define CREQ_QUERY_CC_RESP_TYPE_SFT			    0
	#define CREQ_QUERY_CC_RESP_TYPE_QP_EVENT		   0x38UL
	#define CREQ_QUERY_CC_RESP_RESERVED2_MASK		    0xc0UL
	#define CREQ_QUERY_CC_RESP_RESERVED2_SFT		    6
	u8 status;
	__le16 cookie;
	__le32 size;
	u8 v;
	#define CREQ_QUERY_CC_RESP_V				    0x1UL
	#define CREQ_QUERY_CC_RESP_RESERVED7_MASK		    0xfeUL
	#define CREQ_QUERY_CC_RESP_RESERVED7_SFT		    1
	u8 event;
	#define CREQ_QUERY_CC_RESP_EVENT_QUERY_CC		   0x8dUL
	__le16 reserved48[3];
};

/* Query congestion control command response side buffer structure (32 bytes) */
struct creq_query_cc_resp_sb {
	u8 opcode;
	#define CREQ_QUERY_CC_RESP_SB_OPCODE_QUERY_CC		   0x8dUL
	u8 status;
	__le16 cookie;
	__le16 flags;
	u8 resp_size;
	u8 reserved8;
	u8 enable_cc;
	#define CREQ_QUERY_CC_RESP_SB_ENABLE_CC		    0x1UL
	u8 g;
	#define CREQ_QUERY_CC_RESP_SB_G_MASK			    0x7UL
	#define CREQ_QUERY_CC_RESP_SB_G_SFT			    0
	u8 num_phases_per_state;
	__le16 init_cr;
	u8 unused_2;
	__le16 unused_3;
	u8 unused_4;
	__le16 init_tr;
	u8 tos_dscp_tos_ecn;
	#define CREQ_QUERY_CC_RESP_SB_TOS_ECN_MASK		    0x3UL
	#define CREQ_QUERY_CC_RESP_SB_TOS_ECN_SFT		    0
	#define CREQ_QUERY_CC_RESP_SB_TOS_DSCP_MASK		    0xfcUL
	#define CREQ_QUERY_CC_RESP_SB_TOS_DSCP_SFT		    2
	__le64 reserved64;
	__le64 reserved64_1;
};

/* creq_query_roce_stats_resp (size:128b/16B) */
struct creq_query_roce_stats_resp {
	u8	type;
	#define CREQ_QUERY_ROCE_STATS_RESP_TYPE_MASK    0x3fUL
	#define CREQ_QUERY_ROCE_STATS_RESP_TYPE_SFT     0
	#define CREQ_QUERY_ROCE_STATS_RESP_TYPE_QP_EVENT  0x38UL
	#define CREQ_QUERY_ROCE_STATS_RESP_TYPE_LAST	\
				CREQ_QUERY_ROCE_STATS_RESP_TYPE_QP_EVENT
	u8	status;
	__le16	cookie;
	__le32	size;
	u8	v;
	#define CREQ_QUERY_ROCE_STATS_RESP_V     0x1UL
	u8	event;
	#define CREQ_QUERY_ROCE_STATS_RESP_EVENT_QUERY_ROCE_STATS 0x8eUL
	#define CREQ_QUERY_ROCE_STATS_RESP_EVENT_LAST	\
			CREQ_QUERY_ROCE_STATS_RESP_EVENT_QUERY_ROCE_STATS
	u8	reserved48[6];
};

/* creq_query_roce_stats_resp_sb (size:2624b/328B) */
struct creq_query_roce_stats_resp_sb {
	u8	opcode;
	#define CREQ_QUERY_ROCE_STATS_RESP_SB_OPCODE_QUERY_ROCE_STATS 0x8eUL
	#define CREQ_QUERY_ROCE_STATS_RESP_SB_OPCODE_LAST \
			CREQ_QUERY_ROCE_STATS_RESP_SB_OPCODE_QUERY_ROCE_STATS
	u8	status;
	__le16	cookie;
	__le16	flags;
	u8	resp_size;
	u8	rsvd;
	__le32	num_counters;
	__le32	rsvd1;
	__le64	to_retransmits;
	__le64	seq_err_naks_rcvd;
	__le64	max_retry_exceeded;
	__le64	rnr_naks_rcvd;
	__le64	missing_resp;
	__le64	unrecoverable_err;
	__le64	bad_resp_err;
	__le64	local_qp_op_err;
	__le64	local_protection_err;
	__le64	mem_mgmt_op_err;
	__le64	remote_invalid_req_err;
	__le64	remote_access_err;
	__le64	remote_op_err;
	__le64	dup_req;
	__le64	res_exceed_max;
	__le64	res_length_mismatch;
	__le64	res_exceeds_wqe;
	__le64	res_opcode_err;
	__le64	res_rx_invalid_rkey;
	__le64	res_rx_domain_err;
	__le64	res_rx_no_perm;
	__le64	res_rx_range_err;
	__le64	res_tx_invalid_rkey;
	__le64	res_tx_domain_err;
	__le64	res_tx_no_perm;
	__le64	res_tx_range_err;
	__le64	res_irrq_oflow;
	__le64	res_unsup_opcode;
	__le64	res_unaligned_atomic;
	__le64	res_rem_inv_err;
	__le64	res_mem_error;
	__le64	res_srq_err;
	__le64	res_cmp_err;
	__le64	res_invalid_dup_rkey;
	__le64	res_wqe_format_err;
	__le64	res_cq_load_err;
	__le64	res_srq_load_err;
	__le64	res_tx_pci_err;
	__le64	res_rx_pci_err;
};

/* QP error notification event (16 bytes) */
struct creq_qp_error_notification {
	u8 type;
	#define CREQ_QP_ERROR_NOTIFICATION_TYPE_MASK		    0x3fUL
	#define CREQ_QP_ERROR_NOTIFICATION_TYPE_SFT		    0
	#define CREQ_QP_ERROR_NOTIFICATION_TYPE_QP_EVENT	   0x38UL
	#define CREQ_QP_ERROR_NOTIFICATION_RESERVED2_MASK	    0xc0UL
	#define CREQ_QP_ERROR_NOTIFICATION_RESERVED2_SFT	    6
	u8 status;
	u8 req_slow_path_state;
	u8 req_err_state_reason;
	__le32 xid;
	u8 v;
	#define CREQ_QP_ERROR_NOTIFICATION_V			    0x1UL
	#define CREQ_QP_ERROR_NOTIFICATION_RESERVED7_MASK	    0xfeUL
	#define CREQ_QP_ERROR_NOTIFICATION_RESERVED7_SFT	    1
	u8 event;
	#define CREQ_QP_ERROR_NOTIFICATION_EVENT_QP_ERROR_NOTIFICATION 0xc0UL
	u8 res_slow_path_state;
	u8 res_err_state_reason;
	__le16 sq_cons_idx;
	__le16 rq_cons_idx;
};

/* RoCE Slowpath HSI Specification 1.6.0 */
#define ROCE_SP_HSI_VERSION_MAJOR	1
#define ROCE_SP_HSI_VERSION_MINOR	6
#define ROCE_SP_HSI_VERSION_UPDATE	0

#define ROCE_SP_HSI_VERSION_STR	"1.6.0"
/*
 * Following is the signature for ROCE_SP_HSI message field that indicates not
 * applicable (All F's). Need to cast it the size of the field if needed.
 */
#define ROCE_SP_HSI_NA_SIGNATURE	((__le32)(-1))
#endif /* __BNXT_RE_HSI_H__ */
