/**
 * Copyright (c) 2021 OceanBase
 * OceanBase Database Proxy(ODP) is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *          http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */

#ifndef OCEANBASE_SQL_SESSION_OB_SYS_VAR_CLASS_TYPE_
#define OCEANBASE_SQL_SESSION_OB_SYS_VAR_CLASS_TYPE_

namespace oceanbase
{
namespace sql
{
enum ObSysVarClassType
{
  SYS_VAR_INVALID = -1,
  SYS_VAR_AUTO_INCREMENT_INCREMENT = 0,
  SYS_VAR_AUTO_INCREMENT_OFFSET = 1,
  SYS_VAR_AUTOCOMMIT = 2,
  SYS_VAR_CHARACTER_SET_CLIENT = 3,
  SYS_VAR_CHARACTER_SET_CONNECTION = 4,
  SYS_VAR_CHARACTER_SET_DATABASE = 5,
  SYS_VAR_CHARACTER_SET_RESULTS = 6,
  SYS_VAR_CHARACTER_SET_SERVER = 7,
  SYS_VAR_CHARACTER_SET_SYSTEM = 8,
  SYS_VAR_COLLATION_CONNECTION = 9,
  SYS_VAR_COLLATION_DATABASE = 10,
  SYS_VAR_COLLATION_SERVER = 11,
  SYS_VAR_INTERACTIVE_TIMEOUT = 12,
  SYS_VAR_LAST_INSERT_ID = 13,
  SYS_VAR_MAX_ALLOWED_PACKET = 14,
  SYS_VAR_SQL_MODE = 15,
  SYS_VAR_TIME_ZONE = 16,
  SYS_VAR_TX_ISOLATION = 17,
  SYS_VAR_VERSION_COMMENT = 18,
  SYS_VAR_WAIT_TIMEOUT = 19,
  SYS_VAR_BINLOG_ROW_IMAGE = 20,
  SYS_VAR_CHARACTER_SET_FILESYSTEM = 21,
  SYS_VAR_CONNECT_TIMEOUT = 22,
  SYS_VAR_DATADIR = 23,
  SYS_VAR_DEBUG_SYNC = 24,
  SYS_VAR_DIV_PRECISION_INCREMENT = 25,
  SYS_VAR_EXPLICIT_DEFAULTS_FOR_TIMESTAMP = 26,
  SYS_VAR_GROUP_CONCAT_MAX_LEN = 27,
  SYS_VAR_IDENTITY = 28,
  SYS_VAR_LOWER_CASE_TABLE_NAMES = 29,
  SYS_VAR_NET_READ_TIMEOUT = 30,
  SYS_VAR_NET_WRITE_TIMEOUT = 31,
  SYS_VAR_READ_ONLY = 32,
  SYS_VAR_SQL_AUTO_IS_NULL = 33,
  SYS_VAR_SQL_SELECT_LIMIT = 34,
  SYS_VAR_TIMESTAMP = 35,
  SYS_VAR_TX_READ_ONLY = 36,
  SYS_VAR_VERSION = 37,
  SYS_VAR_SQL_WARNINGS = 38,
  SYS_VAR_MAX_USER_CONNECTIONS = 39,
  SYS_VAR_INIT_CONNECT = 40,
  SYS_VAR_LICENSE = 41,
  SYS_VAR_NET_BUFFER_LENGTH = 42,
  SYS_VAR_SYSTEM_TIME_ZONE = 43,
  SYS_VAR_QUERY_CACHE_SIZE = 44,
  SYS_VAR_QUERY_CACHE_TYPE = 45,
  SYS_VAR_OB_DEFAULT_REPLICA_NUM = 10000,
  SYS_VAR_OB_INTERM_RESULT_MEM_LIMIT = 10001,
  SYS_VAR_OB_PROXY_PARTITION_HIT = 10002,
  SYS_VAR_OB_LOG_LEVEL = 10003,
  SYS_VAR_OB_MAX_PARALLEL_DEGREE = 10004,
  SYS_VAR_OB_QUERY_TIMEOUT = 10005,
  SYS_VAR_OB_READ_CONSISTENCY = 10006,
  SYS_VAR_OB_ENABLE_TRANSFORMATION = 10007,
  SYS_VAR_OB_TRX_TIMEOUT = 10008,
  SYS_VAR_OB_ENABLE_PLAN_CACHE = 10009,
  SYS_VAR_OB_ENABLE_INDEX_DIRECT_SELECT = 10010,
  SYS_VAR_OB_PROXY_SET_TRX_EXECUTED = 10011,
  SYS_VAR_OB_ENABLE_AGGREGATION_PUSHDOWN = 10012,
  SYS_VAR_OB_LAST_SCHEMA_VERSION = 10013,
  SYS_VAR_OB_GLOBAL_DEBUG_SYNC = 10014,
  SYS_VAR_OB_PROXY_GLOBAL_VARIABLES_VERSION = 10015,
  SYS_VAR_OB_ENABLE_TRACE_LOG = 10016,
  SYS_VAR_OB_ENABLE_HASH_GROUP_BY = 10017,
  SYS_VAR_OB_ENABLE_BLK_NESTEDLOOP_JOIN = 10018,
  SYS_VAR_OB_BNL_JOIN_CACHE_SIZE = 10019,
  SYS_VAR_OB_PROXY_USER_PRIVILEGE = 10020,
  SYS_VAR_OB_ORG_CLUSTER_ID = 10021,
  SYS_VAR_OB_PLAN_CACHE_PERCENTAGE = 10022,
  SYS_VAR_OB_PLAN_CACHE_EVICT_HIGH_PERCENTAGE = 10023,
  SYS_VAR_OB_PLAN_CACHE_EVICT_LOW_PERCENTAGE = 10024,
};

}
}
#endif //OCEANBASE_SQL_SESSION_OB_SYS_VAR_CLASS_TYPE_