/**
 * Copyright (c) 2021 OceanBase
 * OceanBase Database Proxy(ODP) is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *          http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */

#ifndef OCEANBASE_SRC_LIB_CHARSET_OB_UCTYPE_H_
#define OCEANBASE_SRC_LIB_CHARSET_OB_UCTYPE_H_
/*
  Unicode ctype data
  Generated from UnicodeData-5.0.0d9.txt
*/
static unsigned char unicode_ctype_page00[256] = {
  0x20,  0x20,  0x20,  0x20,  0x20,  0x20,  0x20,  0x20,
  0x20,  0x20,  0x20,  0x20,  0x20,  0x20,  0x20,  0x20,
  0x20,  0x20,  0x20,  0x20,  0x20,  0x20,  0x20,  0x20,
  0x20,  0x20,  0x20,  0x20,  0x20,  0x20,  0x20,  0x20,
  0x08,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,
  0x04,  0x04,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x81,  0x81,  0x81,  0x81,  0x81,  0x81,  0x81,
  0x81,  0x81,  0x81,  0x81,  0x81,  0x81,  0x81,  0x81,
  0x81,  0x81,  0x81,  0x81,  0x81,  0x81,  0x81,  0x81,
  0x81,  0x81,  0x81,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x82,  0x82,  0x82,  0x82,  0x82,  0x82,  0x82,
  0x82,  0x82,  0x82,  0x82,  0x82,  0x82,  0x82,  0x82,
  0x82,  0x82,  0x82,  0x82,  0x82,  0x82,  0x82,  0x82,
  0x82,  0x82,  0x82,  0x10,  0x10,  0x10,  0x10,  0x20,
  0x20,  0x20,  0x20,  0x20,  0x20,  0x20,  0x20,  0x20,
  0x20,  0x20,  0x20,  0x20,  0x20,  0x20,  0x20,  0x20,
  0x20,  0x20,  0x20,  0x20,  0x20,  0x20,  0x20,  0x20,
  0x20,  0x20,  0x20,  0x20,  0x20,  0x20,  0x20,  0x20,
  0x08,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x02,  0x10,  0x10,  0x20,  0x10,  0x10,
  0x10,  0x10,  0x14,  0x14,  0x10,  0x02,  0x10,  0x10,
  0x10,  0x14,  0x02,  0x10,  0x14,  0x14,  0x14,  0x10,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x10,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x10,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02
};

static unsigned char unicode_ctype_page01[256] = {
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,
  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,
  0x02,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x02,
  0x02,  0x01,  0x01,  0x02,  0x01,  0x02,  0x01,  0x01,
  0x02,  0x01,  0x01,  0x01,  0x02,  0x02,  0x01,  0x01,
  0x01,  0x01,  0x02,  0x01,  0x01,  0x02,  0x01,  0x01,
  0x01,  0x02,  0x02,  0x02,  0x01,  0x01,  0x02,  0x01,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x01,
  0x02,  0x01,  0x02,  0x02,  0x01,  0x02,  0x01,  0x01,
  0x02,  0x01,  0x01,  0x01,  0x02,  0x01,  0x02,  0x01,
  0x01,  0x02,  0x02,  0x02,  0x01,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x01,  0x01,  0x02,  0x01,
  0x01,  0x02,  0x01,  0x01,  0x02,  0x01,  0x02,  0x01,
  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,
  0x02,  0x01,  0x02,  0x01,  0x02,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x02,  0x01,  0x01,  0x02,  0x01,  0x02,  0x01,  0x01,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02
};

static unsigned char unicode_ctype_page02[256] = {
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x01,  0x01,  0x02,  0x01,  0x01,  0x02,
  0x02,  0x01,  0x02,  0x01,  0x01,  0x01,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x10,  0x10,  0x10,  0x10,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x02,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10
};

static unsigned char unicode_ctype_page03[256] = {
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x00,  0x00,  0x00,  0x00,  0x10,  0x10,  0x00,  0x00,
  0x00,  0x00,  0x02,  0x02,  0x02,  0x02,  0x10,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x10,  0x10,  0x01,  0x10,
  0x01,  0x01,  0x01,  0x00,  0x01,  0x00,  0x01,  0x01,
  0x02,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x01,  0x01,  0x00,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x01,  0x01,  0x01,  0x01,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,
  0x02,  0x02,  0x01,  0x01,  0x01,  0x02,  0x02,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x01,  0x02,  0x10,  0x01,
  0x02,  0x01,  0x01,  0x02,  0x02,  0x01,  0x01,  0x01
};

static unsigned char unicode_ctype_page04[256] = {
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x10,  0x12,  0x12,  0x12,  0x12,  0x00,
  0x12,  0x12,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,
  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02
};

static unsigned char unicode_ctype_page05[256] = {
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x00,
  0x00,  0x02,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x00,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x00,  0x10,  0x10,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x10,  0x12,
  0x10,  0x12,  0x12,  0x10,  0x12,  0x12,  0x10,  0x12,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x10,  0x10,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_page06[256] = {
  0x20,  0x20,  0x20,  0x20,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x10,  0x00,  0x00,  0x10,  0x10,
  0x00,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x00,
  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,
  0x04,  0x04,  0x10,  0x10,  0x10,  0x10,  0x02,  0x02,
  0x12,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x10,  0x02,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x20,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x02,  0x02,  0x12,
  0x12,  0x10,  0x12,  0x12,  0x12,  0x12,  0x02,  0x02,
  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,
  0x04,  0x04,  0x02,  0x02,  0x02,  0x10,  0x10,  0x02
};

static unsigned char unicode_ctype_page07[256] = {
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x00,  0x20,
  0x02,  0x12,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x00,  0x00,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x02,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,
  0x04,  0x04,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x02,  0x02,  0x10,  0x10,
  0x10,  0x10,  0x02,  0x00,  0x00,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_page09[256] = {
  0x00,  0x12,  0x12,  0x12,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x00,  0x00,  0x12,  0x02,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x00,  0x00,
  0x02,  0x12,  0x12,  0x12,  0x12,  0x00,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x12,  0x12,  0x10,  0x10,  0x04,  0x04,
  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,
  0x10,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x00,  0x12,  0x12,  0x12,  0x00,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,  0x00,  0x02,
  0x02,  0x00,  0x00,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x00,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x00,  0x02,  0x00,  0x00,  0x00,  0x02,  0x02,
  0x02,  0x02,  0x00,  0x00,  0x12,  0x02,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x00,  0x00,  0x12,
  0x12,  0x00,  0x00,  0x12,  0x12,  0x12,  0x02,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x12,
  0x00,  0x00,  0x00,  0x00,  0x02,  0x02,  0x00,  0x02,
  0x02,  0x02,  0x12,  0x12,  0x00,  0x00,  0x04,  0x04,
  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,
  0x02,  0x02,  0x10,  0x10,  0x14,  0x14,  0x14,  0x14,
  0x14,  0x14,  0x10,  0x00,  0x00,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_page0A[256] = {
  0x00,  0x12,  0x12,  0x12,  0x00,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x00,  0x00,  0x00,  0x00,  0x02,
  0x02,  0x00,  0x00,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x00,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x00,  0x02,  0x02,  0x00,  0x02,  0x02,  0x00,
  0x02,  0x02,  0x00,  0x00,  0x12,  0x00,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x00,  0x00,  0x00,  0x00,  0x12,
  0x12,  0x00,  0x00,  0x12,  0x12,  0x12,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x02,  0x02,  0x02,  0x02,  0x00,  0x02,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x04,  0x04,
  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,
  0x12,  0x12,  0x02,  0x02,  0x02,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x12,  0x12,  0x12,  0x00,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,  0x02,
  0x02,  0x02,  0x00,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x00,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x00,  0x02,  0x02,  0x00,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x00,  0x00,  0x12,  0x02,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x00,  0x12,
  0x12,  0x12,  0x00,  0x12,  0x12,  0x12,  0x00,  0x00,
  0x02,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x02,  0x02,  0x12,  0x12,  0x00,  0x00,  0x04,  0x04,
  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,
  0x00,  0x10,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_page0B[256] = {
  0x00,  0x12,  0x12,  0x12,  0x00,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,  0x00,  0x02,
  0x02,  0x00,  0x00,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x00,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x00,  0x02,  0x02,  0x00,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x00,  0x00,  0x12,  0x02,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x00,  0x00,  0x00,  0x12,
  0x12,  0x00,  0x00,  0x12,  0x12,  0x12,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x12,  0x12,
  0x00,  0x00,  0x00,  0x00,  0x02,  0x02,  0x00,  0x02,
  0x02,  0x02,  0x00,  0x00,  0x00,  0x00,  0x04,  0x04,
  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,
  0x10,  0x02,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x12,  0x02,  0x00,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x00,  0x00,  0x00,  0x02,  0x02,
  0x02,  0x00,  0x02,  0x02,  0x02,  0x02,  0x00,  0x00,
  0x00,  0x02,  0x02,  0x00,  0x02,  0x00,  0x02,  0x02,
  0x00,  0x00,  0x00,  0x02,  0x02,  0x00,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x00,  0x00,  0x00,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x00,  0x00,  0x00,  0x00,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x00,  0x00,  0x00,  0x12,  0x12,
  0x12,  0x00,  0x12,  0x12,  0x12,  0x12,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x12,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x04,  0x04,
  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,
  0x14,  0x14,  0x14,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x00,  0x00,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_page0C[256] = {
  0x00,  0x12,  0x12,  0x12,  0x00,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,  0x02,  0x02,
  0x02,  0x00,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x00,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x00,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x00,  0x00,  0x00,  0x00,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x00,  0x12,  0x12,
  0x12,  0x00,  0x12,  0x12,  0x12,  0x12,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x12,  0x12,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x02,  0x02,  0x00,  0x00,  0x00,  0x00,  0x04,  0x04,
  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x12,  0x12,  0x00,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,  0x02,  0x02,
  0x02,  0x00,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x00,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x00,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x00,  0x00,  0x12,  0x02,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x00,  0x12,  0x12,
  0x12,  0x00,  0x12,  0x12,  0x12,  0x12,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x12,  0x12,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x02,  0x00,
  0x02,  0x02,  0x12,  0x12,  0x00,  0x00,  0x04,  0x04,
  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,
  0x00,  0x10,  0x10,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_page0D[256] = {
  0x00,  0x00,  0x12,  0x12,  0x00,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,  0x02,  0x02,
  0x02,  0x00,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x00,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x00,  0x00,  0x00,  0x00,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x00,  0x00,  0x12,  0x12,
  0x12,  0x00,  0x12,  0x12,  0x12,  0x12,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x12,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x02,  0x02,  0x00,  0x00,  0x00,  0x00,  0x04,  0x04,
  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x12,  0x12,  0x00,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,
  0x00,  0x00,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x00,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x00,  0x02,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,
  0x00,  0x00,  0x12,  0x00,  0x00,  0x00,  0x00,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x00,  0x12,  0x00,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x12,  0x12,  0x10,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_page0E[256] = {
  0x00,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x12,  0x02,  0x02,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x00,  0x00,  0x00,  0x00,  0x10,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x10,
  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,
  0x04,  0x04,  0x10,  0x10,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x02,  0x02,  0x00,  0x02,  0x00,  0x00,  0x02,
  0x02,  0x00,  0x02,  0x00,  0x00,  0x02,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x02,  0x02,  0x02,  0x02,
  0x00,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x00,  0x02,  0x02,  0x02,  0x00,  0x02,  0x00,  0x02,
  0x00,  0x00,  0x02,  0x02,  0x00,  0x02,  0x02,  0x02,
  0x02,  0x12,  0x02,  0x02,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x00,  0x12,  0x12,  0x02,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,  0x02,  0x00,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x00,  0x00,
  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,
  0x04,  0x04,  0x00,  0x00,  0x02,  0x02,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_page0F[256] = {
  0x02,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x12,  0x12,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,
  0x04,  0x04,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,
  0x14,  0x14,  0x14,  0x14,  0x10,  0x12,  0x10,  0x12,
  0x10,  0x12,  0x10,  0x10,  0x10,  0x10,  0x12,  0x12,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x00,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x10,  0x12,  0x12,
  0x02,  0x02,  0x02,  0x02,  0x00,  0x00,  0x00,  0x00,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x00,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x00,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x12,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x00,  0x00,  0x10,
  0x10,  0x10,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_page10[256] = {
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x00,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x00,  0x02,  0x02,  0x00,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x00,  0x00,  0x00,  0x12,  0x12,
  0x12,  0x12,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,
  0x04,  0x04,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x12,  0x12,
  0x12,  0x12,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x10,  0x02,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_page11[256] = {
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x00,  0x00,  0x00,  0x00,  0x00,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_page12[256] = {
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x00,  0x02,  0x02,  0x02,  0x02,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,
  0x02,  0x00,  0x02,  0x02,  0x02,  0x02,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x00,  0x02,  0x02,  0x02,  0x02,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x00,  0x02,  0x02,  0x02,  0x02,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,
  0x02,  0x00,  0x02,  0x02,  0x02,  0x02,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02
};

static unsigned char unicode_ctype_page13[256] = {
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x00,  0x02,  0x02,  0x02,  0x02,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x00,  0x00,  0x00,  0x00,  0x12,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,
  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,
  0x14,  0x14,  0x14,  0x14,  0x14,  0x00,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_page14[256] = {
  0x00,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02
};

static unsigned char unicode_ctype_page16[256] = {
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x10,  0x10,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x08,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x10,  0x10,  0x00,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x10,  0x10,  0x10,  0x07,  0x07,
  0x07,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_page17[256] = {
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,  0x02,  0x02,
  0x02,  0x02,  0x12,  0x12,  0x12,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x12,  0x12,  0x12,  0x10,  0x10,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x12,  0x12,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,  0x02,  0x02,
  0x02,  0x00,  0x12,  0x12,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x20,  0x20,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x10,  0x10,  0x10,  0x02,
  0x10,  0x10,  0x10,  0x10,  0x02,  0x12,  0x00,  0x00,
  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,
  0x04,  0x04,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,
  0x14,  0x14,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_page18[256] = {
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x12,  0x12,  0x12,  0x08,  0x00,
  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,
  0x04,  0x04,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x12,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_page19[256] = {
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,  0x00,  0x00,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x00,  0x00,  0x00,  0x00,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x00,  0x00,  0x00,  0x00,
  0x10,  0x00,  0x00,  0x00,  0x10,  0x10,  0x04,  0x04,
  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x12,  0x12,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,
  0x04,  0x04,  0x00,  0x00,  0x00,  0x00,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10
};

static unsigned char unicode_ctype_page1A[256] = {
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x00,  0x00,  0x10,  0x10,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_page1B[256] = {
  0x12,  0x12,  0x12,  0x12,  0x12,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x00,  0x00,  0x00,  0x00,
  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,
  0x04,  0x04,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_page1D[256] = {
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x12,  0x12
};

static unsigned char unicode_ctype_page1E[256] = {
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x00,  0x00,  0x00,  0x00,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_page1F[256] = {
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,  0x00,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,  0x00,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x00,  0x01,  0x00,  0x01,  0x00,  0x01,  0x00,  0x01,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,  0x02,  0x02,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x10,  0x02,  0x10,
  0x10,  0x10,  0x02,  0x02,  0x02,  0x00,  0x02,  0x02,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x10,  0x10,  0x10,
  0x02,  0x02,  0x02,  0x02,  0x00,  0x00,  0x02,  0x02,
  0x01,  0x01,  0x01,  0x01,  0x00,  0x10,  0x10,  0x10,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x10,  0x10,  0x10,
  0x00,  0x00,  0x02,  0x02,  0x02,  0x00,  0x02,  0x02,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x10,  0x10,  0x00
};

static unsigned char unicode_ctype_page20[256] = {
  0x08,  0x08,  0x08,  0x08,  0x08,  0x08,  0x08,  0x08,
  0x08,  0x08,  0x08,  0x20,  0x20,  0x20,  0x20,  0x20,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x08,  0x08,  0x20,  0x20,  0x20,  0x20,  0x20,  0x08,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x08,
  0x20,  0x20,  0x20,  0x20,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x20,  0x20,  0x20,  0x20,  0x20,  0x20,
  0x14,  0x02,  0x00,  0x00,  0x14,  0x14,  0x14,  0x14,
  0x14,  0x14,  0x10,  0x10,  0x10,  0x10,  0x10,  0x02,
  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,
  0x14,  0x14,  0x10,  0x10,  0x10,  0x10,  0x10,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_page21[256] = {
  0x10,  0x10,  0x01,  0x10,  0x10,  0x10,  0x10,  0x01,
  0x10,  0x10,  0x02,  0x01,  0x01,  0x01,  0x02,  0x02,
  0x01,  0x01,  0x01,  0x02,  0x10,  0x01,  0x10,  0x10,
  0x10,  0x01,  0x01,  0x01,  0x01,  0x01,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x01,  0x10,  0x01,  0x10,
  0x01,  0x10,  0x01,  0x01,  0x01,  0x01,  0x10,  0x02,
  0x01,  0x01,  0x01,  0x01,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x10,  0x10,  0x02,  0x02,  0x01,  0x01,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x01,  0x02,  0x02,
  0x02,  0x02,  0x10,  0x10,  0x10,  0x10,  0x02,  0x00,
  0x00,  0x00,  0x00,  0x14,  0x14,  0x14,  0x14,  0x14,
  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,
  0x07,  0x07,  0x07,  0x07,  0x07,  0x07,  0x07,  0x07,
  0x07,  0x07,  0x07,  0x07,  0x07,  0x07,  0x07,  0x07,
  0x07,  0x07,  0x07,  0x07,  0x07,  0x07,  0x07,  0x07,
  0x07,  0x07,  0x07,  0x07,  0x07,  0x07,  0x07,  0x07,
  0x07,  0x07,  0x07,  0x01,  0x02,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10
};

static unsigned char unicode_ctype_page23[256] = {
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_page24[256] = {
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,
  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,
  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,
  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,
  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,
  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,
  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,
  0x14,  0x14,  0x14,  0x14,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,
  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,
  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14
};

static unsigned char unicode_ctype_page26[256] = {
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x00,  0x00,  0x00,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_page27[256] = {
  0x00,  0x10,  0x10,  0x10,  0x10,  0x00,  0x10,  0x10,
  0x10,  0x10,  0x00,  0x00,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x00,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x00,  0x10,  0x00,  0x10,
  0x10,  0x10,  0x10,  0x00,  0x00,  0x00,  0x10,  0x00,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x00,
  0x00,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x14,  0x14,
  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,
  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,
  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,
  0x14,  0x14,  0x14,  0x14,  0x10,  0x00,  0x00,  0x00,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x00,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x00,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x00,  0x00,  0x00,  0x00,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10
};

static unsigned char unicode_ctype_page2B[256] = {
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x10,  0x10,  0x10,  0x10,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_page2C[256] = {
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,
  0x01,  0x02,  0x01,  0x01,  0x01,  0x02,  0x02,  0x01,
  0x02,  0x01,  0x02,  0x01,  0x02,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x02,  0x01,  0x02,  0x02,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,  0x01,  0x02,
  0x01,  0x02,  0x01,  0x02,  0x02,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x10,  0x10,  0x10,  0x10,  0x14,  0x10,  0x10
};

static unsigned char unicode_ctype_page2D[256] = {
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x02,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_page2E[256] = {
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x00,  0x00,  0x00,  0x00,  0x10,  0x10,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x00,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_page2F[256] = {
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x00,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_page30[256] = {
  0x08,  0x10,  0x10,  0x10,  0x10,  0x02,  0x02,  0x07,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x07,  0x07,  0x07,  0x07,  0x07,  0x07,  0x07,
  0x07,  0x07,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x10,  0x02,  0x02,  0x02,  0x02,  0x02,  0x10,  0x10,
  0x07,  0x07,  0x07,  0x02,  0x02,  0x10,  0x10,  0x10,
  0x00,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,
  0x00,  0x12,  0x12,  0x10,  0x10,  0x02,  0x02,  0x02,
  0x10,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x10,  0x02,  0x02,  0x02,  0x02
};

static unsigned char unicode_ctype_page31[256] = {
  0x00,  0x00,  0x00,  0x00,  0x00,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,  0x00,  0x00,
  0x00,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,
  0x10,  0x10,  0x14,  0x14,  0x14,  0x14,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02
};

static unsigned char unicode_ctype_page32[256] = {
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x00,
  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,
  0x14,  0x14,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x10,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,
  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,
  0x14,  0x14,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,
  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,  0x14,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x00
};

static unsigned char unicode_ctype_page4D[256] = {
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10
};

static unsigned char unicode_ctype_page9F[256] = {
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x02,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_pageA4[256] = {
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,  0x00,  0x00,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_pageA7[256] = {
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x02,
  0x02,  0x02,  0x02,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x10,  0x10,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_pageA8[256] = {
  0x02,  0x02,  0x12,  0x02,  0x02,  0x02,  0x12,  0x02,
  0x02,  0x02,  0x02,  0x12,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x10,  0x10,  0x10,  0x10,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x10,  0x10,  0x10,  0x10,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_pageD7[256] = {
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,  0x03,
  0x03,  0x03,  0x03,  0x03,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_pageD8[256] = {
  0x20,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_pageDB[256] = {
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x20,
  0x20,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x20
};

static unsigned char unicode_ctype_pageDC[256] = {
  0x20,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_pageDF[256] = {
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x20
};

static unsigned char unicode_ctype_pageE0[256] = {
  0x20,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_pageF8[256] = {
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x20
};

static unsigned char unicode_ctype_pageFA[256] = {
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00
};

static unsigned char unicode_ctype_pageFB[256] = {
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x02,  0x12,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x10,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,  0x02,  0x00,
  0x02,  0x02,  0x00,  0x02,  0x02,  0x00,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02
};

static unsigned char unicode_ctype_pageFD[256] = {
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x10,  0x10,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x00,  0x00,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x10,  0x10,  0x00,  0x00
};

static unsigned char unicode_ctype_pageFE[256] = {
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,  0x12,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x12,  0x12,  0x12,  0x12,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x00,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x00,
  0x10,  0x10,  0x10,  0x10,  0x00,  0x00,  0x00,  0x00,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,  0x00,  0x20
};

static unsigned char unicode_ctype_pageFF[256] = {
  0x00,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,
  0x04,  0x04,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,
  0x01,  0x01,  0x01,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x10,  0x10,  0x10,  0x10,  0x10,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,  0x00,
  0x00,  0x00,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x00,  0x00,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x00,  0x00,  0x02,  0x02,  0x02,  0x02,  0x02,  0x02,
  0x00,  0x00,  0x02,  0x02,  0x02,  0x00,  0x00,  0x00,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x00,
  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x10,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x20,  0x20,  0x20,  0x10,  0x10,  0x00,  0x00
};

ObUniCtype ob_uni_ctype[256]={
  {0,unicode_ctype_page00},
  {0,unicode_ctype_page01},
  {0,unicode_ctype_page02},
  {0,unicode_ctype_page03},
  {0,unicode_ctype_page04},
  {0,unicode_ctype_page05},
  {0,unicode_ctype_page06},
  {0,unicode_ctype_page07},
  {0,NULL},
  {0,unicode_ctype_page09},
  {0,unicode_ctype_page0A},
  {0,unicode_ctype_page0B},
  {0,unicode_ctype_page0C},
  {0,unicode_ctype_page0D},
  {0,unicode_ctype_page0E},
  {0,unicode_ctype_page0F},
  {0,unicode_ctype_page10},
  {0,unicode_ctype_page11},
  {0,unicode_ctype_page12},
  {0,unicode_ctype_page13},
  {0,unicode_ctype_page14},
  {2,NULL},
  {0,unicode_ctype_page16},
  {0,unicode_ctype_page17},
  {0,unicode_ctype_page18},
  {0,unicode_ctype_page19},
  {0,unicode_ctype_page1A},
  {0,unicode_ctype_page1B},
  {0,NULL},
  {0,unicode_ctype_page1D},
  {0,unicode_ctype_page1E},
  {0,unicode_ctype_page1F},
  {0,unicode_ctype_page20},
  {0,unicode_ctype_page21},
  {16,NULL},
  {0,unicode_ctype_page23},
  {0,unicode_ctype_page24},
  {16,NULL},
  {0,unicode_ctype_page26},
  {0,unicode_ctype_page27},
  {16,NULL},
  {16,NULL},
  {16,NULL},
  {0,unicode_ctype_page2B},
  {0,unicode_ctype_page2C},
  {0,unicode_ctype_page2D},
  {0,unicode_ctype_page2E},
  {0,unicode_ctype_page2F},
  {0,unicode_ctype_page30},
  {0,unicode_ctype_page31},
  {0,unicode_ctype_page32},
  {16,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {0,unicode_ctype_page4D},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {0,unicode_ctype_page9F},
  {2,NULL},
  {2,NULL},
  {2,NULL},
  {2,NULL},
  {0,unicode_ctype_pageA4},
  {0,NULL},
  {0,NULL},
  {0,unicode_ctype_pageA7},
  {0,unicode_ctype_pageA8},
  {0,NULL},
  {0,NULL},
  {0,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {3,NULL},
  {0,unicode_ctype_pageD7},
  {0,unicode_ctype_pageD8},
  {0,NULL},
  {0,NULL},
  {0,unicode_ctype_pageDB},
  {0,unicode_ctype_pageDC},
  {0,NULL},
  {0,NULL},
  {0,unicode_ctype_pageDF},
  {0,unicode_ctype_pageE0},
  {0,NULL},
  {0,NULL},
  {0,NULL},
  {0,NULL},
  {0,NULL},
  {0,NULL},
  {0,NULL},
  {0,NULL},
  {0,NULL},
  {0,NULL},
  {0,NULL},
  {0,NULL},
  {0,NULL},
  {0,NULL},
  {0,NULL},
  {0,NULL},
  {0,NULL},
  {0,NULL},
  {0,NULL},
  {0,NULL},
  {0,NULL},
  {0,NULL},
  {0,NULL},
  {0,unicode_ctype_pageF8},
  {2,NULL},
  {0,unicode_ctype_pageFA},
  {0,unicode_ctype_pageFB},
  {2,NULL},
  {0,unicode_ctype_pageFD},
  {0,unicode_ctype_pageFE},
  {0,unicode_ctype_pageFF}
};
#endif /* OCEANBASE_SRC_LIB_CHARSET_OB_UCTYPE_H_ */
