/**
 * Copyright (c) 2021 OceanBase
 * OceanBase Database Proxy(ODP) is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *          http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */

#ifndef _OMPK_ROW_H_
#define _OMPK_ROW_H_

#include "rpc/obmysql/ob_mysql_packet.h"
#include "rpc/obmysql/ob_mysql_row.h"

namespace oceanbase
{
namespace obmysql
{

class OMPKRow : public ObMySQLPacket
{
public:
  explicit OMPKRow(const ObMySQLRow &row);

  int decode();
  int serialize(char *buffer, int64_t len, int64_t &pos) const;

  inline const char *get_cdata() const {
    return cdata_;
  }

  inline uint32_t get_clen() const {
    return hdr_.len_;
  }

private:
  DISALLOW_COPY_AND_ASSIGN(OMPKRow);
  const ObMySQLRow &row_;
};

} // end of namespace obmysql
} // end of namespace oceanbase

#endif /* _OMPK_ROW_H_ */
