/**
 * Copyright (c) 2021 OceanBase
 * OceanBase Database Proxy(ODP) is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *          http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */

#ifndef OCEANBASE_LIB_OB_NAME_DEF_H_
#define OCEANBASE_LIB_OB_NAME_DEF_H_

// define common names to be used in logs (e.g. to_string, databuff_xxx and ObPhyOperator::to_string)
#define N_NULL "null"
#define N_TRUE "true"
#define N_FALSE "false"
#define N_MS "ms"
#define N_CS "cs"
#define N_UPS "ups"
#define N_RS "rs"
#define N_TID "table_id"
#define N_REF_TID "ref_table_id"
#define N_DATA_TID "data_table_id"
#define N_CID "column_id"
#define N_OLD_PROJECTOR "old_projector"
#define N_CID_SCAN "column_id_for_scan"
#define N_CID_UPDATE "column_id_for_update"
#define N_COLUMN_CONV_FUNCTION "column_conv"
#define N_PRIMARY_CID "primary_key_ids"
#define N_REFERED_CID "refered_ids"
#define N_DUP_CID "dup_column_id"
#define N_CELL_INDEX "cell_index"
#define N_HAS_INDEX "has_index"
#define N_COLUMN_INDEX "column_index"
#define N_COLUMN "column"
#define N_INSERT_COLUMN "insert_column"
#define N_UPDATE_COLUMN "update_column"
#define N_UPDATE_EXPR "update_expr"
#define N_PROJECT "project"
#define N_ASCENDING "ascending"
#define N_ASC "ASC"
#define N_DESC "DESC"
#define N_ORDER_BY "order_by"
#define N_TOPK "topk"
#define N_RANGE "range"
#define N_INDEX_RANGE "index_range"
#define N_LIMIT "limit"
#define N_OFFSET "offset"
#define N_LIMIT_OFFSET "limit_offset"
#define N_READ_METHOD "read_method"
#define N_SCAN "scan"
#define N_GET "get"
#define N_HAS_SCAN "has_scan"
#define N_HAS_GET "has_get"
#define N_IS_GET "is_get"
#define N_IS_STANDARD "is_standard"
#define N_ALIAS_TID "alias_table_id"
#define N_ROW_DESC "row_desc"
#define N_DESCRIPTOR "descriptor"
#define N_LOCK_FLAG "lock_flag"
#define N_WRITE "write"
#define N_NONE "none"
#define N_HOTSPOT "hotspot"
#define N_SUBQUERY_ID "subquery_id"
#define N_DML_TYPE "dml_type"
#define N_IS_UPS_ROW "is_ups_row"
#define N_DEFAULT_ROW "default_row"
#define N_DATA_SIZE "data_size"
#define N_BLOCK_NUM "block_num"
#define N_ROW "row"
#define N_ROW_COUNT "row_count"
#define N_EXPR "expression"
#define N_EXPLAIN_STMT "explain_stmt"
#define N_PARTITION_EXPR "partition_express"
#define N_IDX "idx"
#define N_CHILDREN_OPS "child_operators"
#define N_PHY_OP_ID "phy_operator_id"
#define N_CHILDREN_NUM "child_operators_num"
#define N_OP_NUM "operators_num"
#define N_SUBQUERY_NUM "subquery_num"
#define N_MAIN_QUERY "main_query"
#define N_SUBQUERIES "sub_queries"
#define N_TRANS_ID "tran_id"
#define N_START_TRANS "begin_trans"
#define N_START_TIME "start_time"
#define N_END_TIME "end_time"
#define N_EXPR_ID "expr_id"
#define N_IS_ALIAS "is_alias"
#define N_ALIAS_NAME "alias_name"
#define N_EXPR_NAME "expr_name"
#define N_STR_PART_NUM "part_num"
#define N_STR_PART_FUNC_TYPE "part_func_type"
#define N_STR_PART_EXPR_LEN "part_func_expr_len"
#define N_STR_PART_BIN_EXPR_LEN "part_func_bin_expr_len"
#define N_STR_PART_EXPR_TOTAL_LEN "part_fun_expr_total_len"
#define N_STR_PART_EXPR "part_func_expr"
#define N_STR_PART_BIN_EXPR "part_func_bin_expr"
#define N_OBJ_TYPE "obj_type"
#define N_RESULT_TYPE "result_type"
#define N_INPUT_TYPE "input_type"
#define N_CMP_TYPE "cmp_type"
#define N_JOINED_TID "joined_table_id"
#define N_JOIN_TYPE "join_type"
#define N_NUM "num"
#define N_IS_JOIN "is_join"
#define N_JOIN_EQ_COND "equal_join_conds"
#define N_JOIN_OTHER_COND "other_join_conds"
#define N_SUBSTMT "sub_stmt"
#define N_STMT_NAME "stmt_name"
#define N_PREPARE_SQL "prepare_sql"
#define N_DISTINCT "distinct"
#define N_FOR_UPDATE "for_update"
#define N_WAIT "wait"
#define N_MAX_WAIT_EVENT "max_wait_event"
#define N_SELECT "select"
#define N_INSERT_UPDATE "insert_up"
#define N_FROM "from"
#define N_JOINED_TABLE "joined_table"
#define N_GROUP_BY_IDX "group_by_idx"
#define N_GROUP_BY "group_by"
#define N_AGG_PARAM_LIST "agg_param_list"
#define N_AGGR_COLUMN "aggr_col"
#define N_HAVING "having"
#define N_AGGR_FUNC "aggr_func"
#define N_IS_SERVING_TENANT "is_serving_tenant"
#define N_SET_OP "set_op"
#define N_LEFT_QUERY "left_query"
#define N_RIGHT_QUERY "right_query"
#define N_ITEM_TYPE "item_type"
#define N_STMT_TYPE "stmt_type"
#define N_QID "query_id"
#define N_PLAN_ID "plan_id"
#define N_SQL_ID "sql_id"
#define N_CG_ID "column_group_id"
#define N_ROWKEY_ID "rowkey_id"
#define N_JOIN_TID "join_table_id"
#define N_JOIN_CID "join_column_id"
#define N_COLUMN_TYPE "column_type"
#define N_LENGTH "length"
#define N_ZEROFILL "zf"
#define N_VALUES "values"
#define N_PRECISION "precision"
#define N_SCALE "scale"
#define N_NULLABLE "nullable"
#define N_AUTO_FILL_TIMESTAMP "auto_filled_timestamp"
#define N_EXISTS "exists"
#define N_NOT_EXISTS "not exists"
#define N_NUMBER_PRECISION "number_precision"
#define N_NUMBER_SCALE "number_scale"
#define N_PARAM "param"
#define N_PARAM_NUM "param_num"
#define N_RESCAN_PARAM "rescan_param"
#define N_ONETIME_FILTER "onetime_filter"
#define N_FETCH_CUR_TIME "fetch_cur_time"
#define N_SYS_VAR "sys_var"
#define N_SYS_VAR_SCOPE "sys_var_scope"
#define N_USER_VAR "user_var"
#define N_OP "op"
#define N_FUNC "func"
#define N_CONST "const"
#define N_POST_EXPR "post_expr"
#define N_TIMEOUT "timeout"
#define N_CACHE_BLOOM_FILTER "cache_bloom"
#define N_CACHE_FROZEN_DATA "cache_frozen_data"
#define N_READ_CONSISTENCY "read_consistency"
#define N_UPS_SCAN_TYPE "ups_scan_type"
#define N_IS_CONSITENCY "consistency_read"
#define N_ONLY_STATIC_DATA "only_static"
#define N_ONLY_FROZEN_VERSION "only_frozen_version_data"
#define N_VERSION_RANGE "version_range"
#define N_FROZEN_VERSION "frozen_version"
#define N_VERSION "version"
#define N_CONNECTION_ID "connection_id"
#define N_SCAN_PARAM "scan_param"
#define N_SCAN_FLAG "scan_flag"
#define N_GET_PARAM "get_param"
#define N_ROWKEY_LIST "rowkey_list"
#define N_READ_MASTER "read_master"
#define N_RESULT_CACHED "result_cached"
#define N_NOT_EXIST_COL_RET_NOP "not_exsit_col_ret_as_nop"
#define N_RAW_EXPR "raw_expr"
#define N_ROWKEY_CELL_NUM "rowkey_cell_num"
#define N_CELL "cell"
#define N_RESERVED_CELL_COUNT "reserved_cell_count"
#define N_SHARDING "shardings"
#define N_MAP_PLAN "map_plan"
#define N_REDUCE_PLAN "reduce_plan"
#define N_PLAN "plan"
#define N_INDEX "index"
#define N_INDEX_SHORT_NAME "index_short_name"
#define N_SORT_COLUMN "sort_columns"
#define N_INDEX_COVER_PREFIX "cover_prefix"
#define N_INDEX_TABLE "index_table"
#define N_INDEX_TABLE_SIZE "index_table_size"
#define N_INDEX_COL_SIZE "index_column_size"
#define N_INDEX_ROW_SIZE "index_row_size"
#define N_INDEX_TID "index_table_id"
#define N_INDEX_ID "index_id"
#define N_ORDERBY_ELI "orderby_eliminate"
#define N_GROUPSORT_ELI "group_sort_eliminate"
#define N_IS_PRIMARY_INDEX "is_primary_index"
#define N_ALL_COVERED "all_covered"
#define N_ALTER_TABLE_SCHEMA "alter_table_schema"
#define N_MASTER_IP "master_ip"
#define N_PORT "port"
#define N_IS_FORCE "is_force"
#define N_VARIABLE_NAME "var_name"
#define N_VARIABLE_VALUE "var_value"
#define N_VARIABLE "var"
#define N_VERBOSE "verbose"
#define N_SHOW_STMT_CTX "show_stmt_ctx"
#define N_TABLE "table"
#define N_TABLE_ID "table_id"
#define N_SHOW_TABLE_ID "show_table_id"
#define N_BASE_TABLE_ID "base_table_id"
#define N_TABLE_IDS "table_ids"
#define N_IF_EXISTS "if_exists"
#define N_TABLE_NAME "table_name"
#define N_DATABASE_NAME "database_name"
#define N_QB_NAME "qb_name"
#define N_NEXTVAL "nextval"
#define N_RESERVED_CELL_COUNT "reserved_cell_count"
#define N_COLUMN_COUNT "column_count"
#define N_COLUMN_ID "column_id"
#define N_COLUMN_IDS "column_ids"
#define N_ALTER_TYPE "alter_type"
#define N_ROLLBACK "rollback"
#define N_WHEN_NUMBER "when_number"
#define N_IS_KILL_QUERY "is_kill_query"
#define N_SESSION_ID "session_id"
#define N_ROW_INTERVAL "row_interval"
#define N_IS_DELETE "is_delete"
#define N_ROWSTORE "rowstore"
#define N_KEY "key"
#define N_KEY_RANGES "key_ranges"
#define N_VALUE "value"
#define N_CONTENT "content"
#define N_ROOT "root"
#define N_HUSK_SCAN "husk_scan"
#define N_JOIN_TYPE "join_type"
#define N_SNAPSHOT_TS "snapshot_ts"
#define N_EXPIRE_CONDITION "expire_condition"
#define N_STR_LEN "str_len"
#define N_SQL_EXPR_LEN "sql_expr_len"
#define N_TOTAL_LEN "total_len"
#define N_START_TRANS_FLAG "start_trans_flag"
#define N_SPECIFY_INDEX "specify_index"
#define N_SESSION_TIMEOUT_TS "session_timeout"
#define N_SESSION_IDLE_TIMEOUT_TS "session_idle_timeout"
#define N_QUERY_RANGE "query_range"
#define N_RANGE_GRAPH "range_graph"
#define N_KEY_PART_VAL "key_part_value"
#define N_ITEM_KEY_PART "item_key_part"
#define N_AND_KEY_PART "and_key_part"
#define N_OR_KEY_PART "or_key_part"
#define N_START_VAL "start_value"
#define N_END_VAL "end_value"
#define N_INCLUDE_START "include_start"
#define N_INCLUDE_END "include_end"
#define N_PATTERN_VAL "pattern"
#define N_ESCAPE_VAL "escape"
#define N_ALWAYS_TRUE "always_true"
#define N_ALWAYS_FALSE "always_false"
#define N_RPC_ROW_ITER "rpc_row_iter"
#define N_ABS_EXPIRED_TIME "abs_expired_time"
#define N_VIEW_DEFINITION "view_definition"
#define N_CHECK_OPTION "check_option"
#define N_IS_UPDATABLE "is_updatable"
#define N_VIEW_SCHEMA "view_schema"
#define N_FILTER_EXPRS "filter_exprs"
#define N_CALC_EXPRS "calc_exprs"
#define N_INDEX_FILTER_EXPRS "index_filter_exprs"
#define N_OPERATOR_MONITOR_INFO "op_info"
#define N_PLAN_MONITOR_INFO "plan_info"
//common comparison operator
#define N_LESS_THAN "<"
#define N_GREATER_THAN ">"
#define N_EQUAL "="
#define N_NS_EQUAL "<=>"
#define N_LESS_EQUAL "<="
#define N_GREATER_EQUAL ">="
#define N_NOT_EQUAL "!="
#define N_IS "is"
#define N_IS_NOT "is_not"
#define N_BTW "between"
#define N_NOT_BTW "not_between"
//subquery comparison operator
#define N_SQ_LESS_THAN "subquery_less_than"
#define N_SQ_GREATER_THAN "subquery_greater_than"
#define N_SQ_EQUAL "subquery_equal"
#define N_SQ_NS_EQUAL "subquery_null_safe_equal"
#define N_SQ_LESS_EQUAL "subquery_less_equal"
#define N_SQ_GREATER_EQUAL "subquery_greater_equal"
#define N_SQ_NOT_EQUAL "subquery_not_equal"

#define N_COLUMN_REF "column_ref"
#define N_NEG "neg"
#define N_ABS "abs"
#define N_ADD "+"
#define N_MINUS "-"
#define N_MUL "*"
#define N_DIV "/"
#define N_MOD "%"
#define N_AND "&&"
#define N_OR "||"
#define N_NOT "!"
#define N_POW "pow"
#define N_XOR "^"
#define N_ROWEQ "row_eq"
#define N_ROWLE "row_le"
#define N_ROWLT "row_lt"
#define N_ROWGE "row_ge"
#define N_ROWGT "row_gt"
#define N_ROWNEQ "row_neq"
#define N_IN "in"
#define N_NOT_IN "not_in"
#define N_INT_DIV "div"
#define N_REGEXP "regexp"
#define N_NOT_REGEXP "not_regexp"
#define N_LIKE "like"
#define N_NOT_LIKE "not_like"
#define N_SUBSTR "substr"
#define N_STRCMP "strcmp"
#define N_INSERT "insert"
#define N_SUBSTRING_INDEX "substring_index"
#define N_MD5 "md5"
#define N_HEX "hex"
#define N_UNHEX "unhex"
#define N_IP2INT "ip2int"
#define N_INT2IP "int2ip"
#define N_UPPER "upper"
#define N_SIGN "sign"
#define N_LOWER "lower"
#define N_REPEAT "repeat"
#define N_REPLACE "replace"
#define N_CONCAT "concat"
#define N_CONCAT_WS "concat_ws"
#define N_INSTR "instr"
#define N_CONV "conv"
#define N_SYS_VIEW_BIGINT_PARAM "sys_view_bigint_param"
#define N_SYS_PRIVILEGE_CHECK "sys_privilege_check"
#define N_LOCATE "locate"
#define N_POSITION "position"
#define N_BIN "bin"
#define N_QUOTE "quote"
#define N_TRIM "trim"
#define N_INNER_TRIM "inner_trim"
#define N_PART_HASH "partition_hash"
#define N_PART_KEY_V1 "partition_key"
#define N_PART_KEY_V2 "partition_key_v2"
#define N_ADDR_TO_PARTITION_ID "addr_to_partition_id"
#define N_CAST "cast"
#define N_TO_TYPE "to_type"
#define N_CHAR "char"
#define N_CONVERT "convert"
#define N_GREATEST "greatest"
#define N_LEAST "least"
#define N_COALESCE "coalesce"
#define N_NVL "nvl"
#define N_EXPR_TYPE "expr_type"
#define N_DIM "dimension"
#define N_CASE "case"
#define N_DECODE "decode"
#define N_ARG_CASE "arg_case"
#define N_SCAN_PLAN "scan_plan"
#define N_GET_PLAN "get_plan"
#define N_TABLE_TYPE "table_type"
#define N_REF_ID "ref_id"
#define N_REF_QUERY "ref_query"
#define N_LEFT_TABLE "left_table"
#define N_RIGHT_TABLE "right_table"
#define N_COLUMN_NAME "column_name"
#define N_WHEN "when"
#define N_WHERE "where"
#define N_MONTH "month"
#define N_DATE "date"
#define N_DATE_ADD "date_add"
#define N_DATE_SUB "date_sub"
#define N_DATE_DIFF "datediff"
#define N_TIME_STAMP_DIFF "timestampdiff"
#define N_TIME_DIFF "timediff"
#define N_PERIOD_DIFF "period_diff"
#define N_SYS_SLEEP "sleep"
#define N_UNIX_TIMESTAMP "unix_timestamp"
#define N_FROM_UNIX_TIME "from_unixtime"
#define N_EXTRACT "extract"
#define N_DATE_FORMAT "date_format"
#define N_STR_TO_DATE "str_to_date"
#define N_TO_DAYS "to_days"
#define N_FROM_DAYS "from_days"
#define N_DATABASE "database"
#define N_ROW_COUNT "row_count"
#define N_FOUND_ROWS "found_rows"
#define N_LAST_INSERT_ID "last_insert_id"
#define N_LAST_INSERT_ID_TO_CLIENT "last_insert_id_to_client"
#define N_LAST_INSERT_ID_SESSION "last_insert_id_session"
#define N_CUR_TIMESTAMP "current_timestamp"
#define N_TIMESTAMP_NVL "timestamp_nvl"
#define N_CUR_TIME "curtime"
#define N_CUR_DATE "cur_date"
#define N_UTC_TIMESTAMP "utc_timestamp"
#define N_UPS_CUR_TIME "ups_cur_time"
#define N_REAL_UPS_TIME "real_ups_time"
#define N_MERGING_FROZEN_TIME "merging_frozen_time"
#define N_POS "pos"
#define N_SCHEMA_VERSION "schema_version"
#define N_PROGRESSIVE_MERGE_NUM "progressive_merge_num"
#define N_TABLE_SCHEMA_VERSION "table_schema_version"
#define N_QUESTION_MARK "?"
#define N_FIRST "first"
#define N_SECOND "second"
#define N_ZONE "zone"
#define N_EXPR_INFO "expr_info"
#define N_REL_ID "rel_id"
#define N_BASE_COLUMN_ID "base_column_id"
#define N_ALIAS_COLUMN_ID "alias_column_id"
#define N_REF_HANDLE "ref_handle"
#define N_COMMENT "comment"
#define N_ID "id"
#define N_SCOPE "scope"
#define N_TYPE "type"
#define N_INT_VALUE "int_val"
#define N_STR_VALUE "str_val"
#define N_STR_VALUE_LEN "str_len"
#define N_CHILDREN "children"
#define N_SEPARATOR_PARAM_EXPR "separator_param_expr"
#define N_TIME_TO_USEC "time_to_usec"
#define N_USEC_TO_TIME "usec_to_time"
#define N_CONSISTENCY_LEVEL "consistency_level"
#define N_REPLICA_NUM "replica_num"
#define N_TABLET_MAX_SIZE "tablet_max_size"
#define N_TABLET_BLOCK_SIZE "tablet_block_size"
#define N_INDEX_STATUS "index_status"
#define N_ALTER_TABLE_OPTION "alter_table_option"
#define N_ALTER_COLUMN_SCHEMA "alter_column_schema"
#define N_CHARSET_TYPE "charset_type"
#define N_COLLATION_TYPE "collation_type"
#define N_USE_BLOOM_FILTER "use_bloom_filter"
#define N_COMPRESS_METHOD "compress_method"
#define N_JOIN_INFO "join_info"
#define N_ID_SET "id_set"
#define N_EQUAL_SET "equal_set"
#define N_LEFT_ID "left_id"
#define N_RIGHT_ID "right_id"
#define N_LEFT_NAME "left_name"
#define N_RIGHT_NAME "right_name"
#define N_OUTER_ID "outer_id"
#define N_INNER_ID "inner_id"
#define N_OUTER "outer"
#define N_INNER "inner"
#define N_SESSION_KEY "session_key"
#define N_SESSION_IDX "session_idx"
#define N_SESSION_REUSE_COUNT "session_reuse_count"
#define N_FIRST_ROWKEY "first_rowkey"
#define N_KEEP_TRANS "keep_trans"
#define N_NEED_REFRESH_SNAPSHOT "need_refresh_snapshot"
#define N_TRANS_REQ "trans_req"
#define N_TRANS_DESC "trans_desc"
#define N_IS_UPDATE_ROWKEY "is_update_rowkey"
#define N_FLOW_PERCENT "flow_percent"
#define N_START_LSN "start_lsn"
#define N_BUFFER "buf"
#define N_LSN "lsn"
#define N_TS "ts"
#define N_PROPOSE_ID "propose_id"
#define N_CHECKSUM "checksum"
#define N_PARTITION_IDX "partition_idx"
#define N_PARTITION_CNT "partition_cnt"
#define N_OCT "oct"
#define N_RPAD "rpad"
#define N_ASSIGN "assign"
#define N_GET_USER_VAR "get_user_var"
#define N_GET_SYS_VAR "get_sys_var"
//use capital as 'default now()' flag
#define N_CURRENT_TIMESTAMP "CURRENT_TIMESTAMP"
#define N_UPDATE_CURRENT_TIMESTAMP "ON UPDATE CURRENT_TIMESTAMP"
#define N_UPS_ADDR "ups_addr"
#define N_ADD_ADDR_LIST "add_addr_list"
#define N_DELETE_ADDR_LIST "delete_addr_list"
#define N_UPS_COUNT_LIMIT "ups_count_limit"
#define N_HUSK_TABLET_BASE "husk_tablet_base"
#define N_DECIMAL_SCALE "decimal_scale"
#define N_READ_ONLY "read_only"
#define N_BLOCK_SIZE "block_size"
#define N_AFFECTED_ROWS "affected_rows"
#define N_ERR_CODE "err_code"
#define N_ERR_MSG "err_msg"
#define N_MEM_LIMIT "mem_limit"
#define N_ROW "row"
#define N_ROW_STORE "row_store"
#define N_PAYLOAD "payload"
#define N_CELLS "cells"
#define N_OB_EXECUTION_ID "ob_execution_id"
#define N_OB_JOB_ID "ob_job_id"
#define N_OB_TASK_ID "ob_task_id"
#define N_OB_SLICE_ID "ob_slice_id"
#define N_EXECUTION_ID "execution_id"
#define N_JOB_ID "job_id"
#define N_TASK_ID "task_id"
#define N_OP_ID "op_id"
#define N_SLICE_ID "slice_id"
#define N_JOB_COUNT "job_count"
#define N_TASK_COUNT "task_count"
#define N_SLICE_COUNT "slice_count"
#define N_JOB "job"
#define N_TASK_INFO "task_info"
#define N_SERVER "server"
#define N_TASK_LOC "task_loc"
#define N_RANGE_LOC "range_loc"
#define N_TASK_STATE "task_state"
#define N_THEN "then"
#define N_PAD "pad"
#define N_COLUMN_CONV "column_conv"
#define N_DEFAULT "default"
#define N_ORA_DECODE "ora_decode"
#define N_ORA_TRUNC "ora_trunc"
#define N_RANGE_COLUMNS "range_columns"
#define N_START_KEY "startkey"
#define N_END_KEY "endkey"
#define N_BORDER "border"
#define N_FLAG "flag"
#define N_MAX_LENGTH "max_length"
#define N_CALC_TYPE "calc_type"
#define N_CALC_META "calc_meta"
#define N_AST "AST"
#define N_UPDATED_CID "updated_column_id"
#define N_REAL_PARAM_NUM "real_param_num"
#define N_PROJECTOR "projector"
#define N_CMD_TYPE "cmd_type"
#define N_JOIN_ORDER "join_order"
#define N_QUERY_HINT "hint"
#define N_QUERY_CTX "query_context"
#define N_UPPER_BASE_COLUMNS "upper_base_columns"
#define N_UPPER_ALIAS_COLUMNS "upper_alias_columns"
#define N_GROUP_COLUMN_REF_LEVELS "group_column_ref_levels"
#define N_NON_GROUP_COLUMN_REF_LEVELS "non_group_column_ref_levels"
#define N_CHILD_STMT "child_stmt"
#define N_PURE_TABLE_ID "pure_table_id"
#define N_TENANT_ID "tenant_id"
#define N_ON_DUPLICATE "on_duplicate"
#define N_CREATE_TABLE_ARG "create_table_arg"
#define N_DEFAULT_VALUE "default_value"
#define N_TENANT "tenant"
#define N_EFFECTIVE_TENANT "effective_tenant"
#define N_EFFECTIVE_TENANT_ID "effective_tenant_id"
#define N_CURRENT_USER "current_user"
#define N_USER "user"
#define N_HOST_IP "host_ip"
#define N_RPC_PORT "rpc_port"
#define N_MYSQL_PORT "mysql_port"
#define N_CHARSET "charset"
#define N_COLLATION "collation"
#define N_COERCIBILITY "coercibility"
#define N_SET_COLLATION "set_collation"
#define N_META "meta"
#define N_OBJ "obj"
#define N_ACCURACY "accuracy"
#define N_CHAR_LENGTH "char_length"
#define N_BIT_AND "&"
#define N_BIT_OR "|"
#define N_BIT_XOR "^"
#define N_BIT_NEG "~"
#define N_BIT_LEFT_SHIFT "<<"
#define N_BIT_RIGHT_SHIFT ">>"
#define N_IFNULL "ifnull"
#define N_ALIAS_REF "alias_ref"
#define N_INDEX_ARG "index_arg"
#define N_FIELD "field"
#define N_ELT "elt"
#define N_NULLIF "nullif"
#define N_IS_TOTAL_QUANTITY_LOG "is_total_quantity_log"
#define N_ISNULL "isnull"
#define N_SQL_MODE "sql_mode"
#define N_IS_IGNORE "is_ignore"
#define N_LEADING_HINT "LEADING"
#define N_USE_MERGE_HINT "USE_MERGE"
#define N_USE_HASH_HINT "USE_HASH"
#define N_USE_NL_HINT "USE_NL"
#define N_USE_BNL_HINT "USE_BNL"
#define N_PRIMARY "primary"
#define N_PART_ID "part_id"
#endif //OCEANBASE_LIB_OB_NAME_DEF_H_
