/**
 * Copyright (c) 2021 OceanBase
 * OceanBase Database Proxy(ODP) is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *          http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */

PCODE_DEF(OB_TEST_PCODE, 0x001)
PCODE_DEF(OB_TEST2_PCODE, 0x002)
PCODE_DEF(OB_TEST3_PCODE, 0x003)
PCODE_DEF(OB_TEST4_PCODE, 0x004)
PCODE_DEF(OB_TEST5_PCODE, 0x005)
PCODE_DEF(OB_TEST6_PCODE, 0x006)
PCODE_DEF(OB_TEST7_PCODE, 0x007)
PCODE_DEF(OB_TEST8_PCODE, 0x008)
PCODE_DEF(OB_TEST9_PCODE, 0x009)

// INVALID REQUEST PCODE, no such rpc
PCODE_DEF(OB_ERROR_PACKET, 0x010)

// core, manager
PCODE_DEF(OB_BOOTSTRAP, 0x101)
PCODE_DEF(OB_RENEW_LEASE, 0x102)
PCODE_DEF(OB_IS_EMPTY_SERVER, 0x103)
PCODE_DEF(OB_SET_ROLE, 0x104)
PCODE_DEF(OB_GET_ROLE, 0x105)
PCODE_DEF(OB_SET_CONFIG, 0x106)
PCODE_DEF(OB_GET_CONFIG, 0x107)
PCODE_DEF(OB_EXECUTE_BOOTSTRAP, 0x108)
PCODE_DEF(OB_REFRESH_CONFIG, 0x109)
PCODE_DEF(OB_ROOT_MAJOR_FREEZE, 0x10A)
PCODE_DEF(OB_ADD_SERVER, 0x10B)
PCODE_DEF(OB_DELETE_SERVER, 0x10C)
PCODE_DEF(OB_CANCEL_DELETE_SERVER, 0x10D)
PCODE_DEF(OB_ADD_ZONE, 0x10E)
PCODE_DEF(OB_DELETE_ZONE, 0x10F)
PCODE_DEF(OB_START_ZONE, 0x110)
PCODE_DEF(OB_STOP_ZONE, 0x111)
PCODE_DEF(OB_ADD_TENANT_TMP, 0x112)

PCODE_DEF(OB_TENANT_MGR, 0x113)
PCODE_DEF(OB_MERGE_FINISH, 0x114)
PCODE_DEF(OB_MERGE_ERROR, 0x115)
PCODE_DEF(OB_START_SERVER, 0x116)
PCODE_DEF(OB_STOP_SERVER, 0x117)
PCODE_DEF(OB_BROADCAST_DS_ACTION, 0x118)
PCODE_DEF(OB_GET_FROZEN_VERSION, 0x119)
PCODE_DEF(OB_GET_FROZEN_STATUS, 0x11A)
PCODE_DEF(OB_FETCH_ALIVE_SERVER, 0x11B)

// DDL relating pcode
PCODE_DEF(OB_FETCH_SCHEMA, 0x201)
PCODE_DEF(OB_SWITCH_SCHEMA, 0x202)
PCODE_DEF(OB_CREATE_TABLE, 0x203)
PCODE_DEF(OB_DROP_TABLE, 0x204)
PCODE_DEF(OB_ALTER_TABLE, 0x205)
PCODE_DEF(OB_CREATE_TENANT, 0x206)
PCODE_DEF(OB_DROP_TENANT, 0x207)
PCODE_DEF(OB_CREATE_DATABASE, 0x208)
PCODE_DEF(OB_DROP_DATABASE, 0x209)
PCODE_DEF(OB_CREATE_PARTITION, 0x20A)
PCODE_DEF(OB_SWITCH_LEADER, 0x20B)
PCODE_DEF(OB_CREATE_TABLEGROUP, 0x20C)
PCODE_DEF(OB_DROP_TABLEGROUP, 0x20D)
PCODE_DEF(OB_CREATE_INDEX, 0x20E)
PCODE_DEF(OB_DROP_INDEX, 0x20F)
PCODE_DEF(OB_MODIFY_TENANT, 0x210)
PCODE_DEF(OB_LOCK_TENANT, 0x211)
PCODE_DEF(OB_CREATE_RESOURCE_UNIT, 0x212)
PCODE_DEF(OB_DROP_RESOURCE_UNIT, 0x213)
PCODE_DEF(OB_CREATE_RESOURCE_POOL, 0x214)
PCODE_DEF(OB_ALTER_RESOURCE_POOL, 0x215)
PCODE_DEF(OB_DROP_RESOURCE_POOL, 0x216)
PCODE_DEF(OB_CREATE_VIEW, 0x217)
PCODE_DEF(OB_ALTER_VIEW, 0x218)
PCODE_DEF(OB_DROP_VIEW, 0x219)
PCODE_DEF(OB_ALTER_TABLEGROUP, 0x21A)
PCODE_DEF(OB_UPDATE_INDEX_TABLE_STATUS, 0x21B)
PCODE_DEF(OB_RENAME_TABLE, 0x21C)
PCODE_DEF(OB_TRUNCATE_TABLE, 0x21D)
PCODE_DEF(OB_ALTER_DATABASE, 0x21E)
PCODE_DEF(OB_CREATE_TABLE_LIKE, 0x21F)
PCODE_DEF(OB_GET_LEADER_CANDIDATES, 0x220)
PCODE_DEF(OB_REQUEST_HEARTBEAT, 0x221)
PCODE_DEF(OB_BROADCAST_SYS_SCHEMA, 0x222)
PCODE_DEF(OB_ALTER_RESOURCE_UNIT, 0x223)
PCODE_DEF(OB_CREATE_PARTITION_BATCH, 0x224)
PCODE_DEF(OB_GET_PARTITION_COUNT, 0x226)
PCODE_DEF(OB_SWITCH_LEADER_LIST, 0x227)

// Privilege relating pcode
PCODE_DEF(OB_CREATE_USER, 0x250)
PCODE_DEF(OB_DROP_USER, 0x251)
PCODE_DEF(OB_RENAME_USER, 0x252)
PCODE_DEF(OB_SET_PASSWD, 0x253)
PCODE_DEF(OB_GRANT, 0x254)
PCODE_DEF(OB_REVOKE_USER, 0x255)
PCODE_DEF(OB_LOCK_USER, 0x256)
PCODE_DEF(OB_REVOKE_DB, 0x257)
PCODE_DEF(OB_REVOKE_TABLE, 0x258)


// system admin commnad
PCODE_DEF(OB_ADMIN_SWITCH_REPLICA_ROLE, 0x280)
PCODE_DEF(OB_ADMIN_DROP_REPLICA, 0x281)
PCODE_DEF(OB_ADMIN_MIGRATE_REPLICA, 0x282)
PCODE_DEF(OB_ADMIN_REPORT_REPLICA, 0x283)
PCODE_DEF(OB_ADMIN_RECYCLE_REPLICA, 0x284)
PCODE_DEF(OB_ADMIN_MERGE, 0x285)
PCODE_DEF(OB_ADMIN_CLEAR_ROOTTABLE, 0x286)
PCODE_DEF(OB_ADMIN_REFRESH_SCHEMA, 0x287)
PCODE_DEF(OB_ADMIN_SET_CONFIG, 0x288)
PCODE_DEF(OB_ADMIN_CLEAR_LOCATION_CACHE, 0x289)
PCODE_DEF(OB_ADMIN_RELOAD_UNIT, 0x28A)
PCODE_DEF(OB_ADMIN_RELOAD_SERVER, 0x28B)
PCODE_DEF(OB_ADMIN_RELOAD_ZONE, 0x28C)
PCODE_DEF(OB_ADMIN_CLEAR_MERGE_ERROR, 0x28D)
PCODE_DEF(OB_ADMIN_MIGRATE_UNIT, 0x28E)

PCODE_DEF(OB_ADMIN_UPGRADE_VIRTUAL_SCHEMA, 0x28F)
PCODE_DEF(OB_RUN_JOB, 0x290)
PCODE_DEF(OB_ADMIN_SWITCH_RS_ROLE, 0x291)

PCODE_DEF(OB_CREATE_OUTLINE, 0x350)
PCODE_DEF(OB_DROP_OUTLINE, 0x351)
// ob server
// TODO:delete these two
PCODE_DEF(OB_MIGRATE, 0x401)
PCODE_DEF(OB_MIGRATE_OVER, 0x402)

PCODE_DEF(OB_REPORT_ROOT_PARTITION, 0x404)
PCODE_DEF(OB_FETCH_ROOT_PARTITION, 0x405)
PCODE_DEF(OB_GET_ROOT_PARTITION, 0x406)
PCODE_DEF(OB_REMOVE_ROOT_PARTITION, 0x407)
PCODE_DEF(OB_GET_PARTITION_STAT, 0x408)
PCODE_DEF(OB_GET_MEMBER_LIST, 0x409)
PCODE_DEF(OB_QUERY_MAJOR_FREEZE_STATUS, 0x40A)
PCODE_DEF(OB_PREPARE_MAJOR_FREEZE, 0x40B)
PCODE_DEF(OB_COMMIT_MAJOR_FREEZE, 0x40C)
PCODE_DEF(OB_ABORT_MAJOR_FREEZE, 0x40D)
PCODE_DEF(OB_FETCH_LOCATION, 0x40E)
PCODE_DEF(OB_CLONE_PARTITION, 0x40F)
PCODE_DEF(OB_REFRESH_SYNC_VALUE, 0x410)
PCODE_DEF(OB_REPORT_REPLICA, 0x411)
PCODE_DEF(OB_RECYCLE_REPLICA, 0x412)
PCODE_DEF(OB_CLEAR_LOCATION_CACHE, 0x413)
PCODE_DEF(OB_DROP_REPLICA, 0x414)
PCODE_DEF(OB_CLEAR_AUTOINC_CACHE, 0x415)
PCODE_DEF(OB_SYNC_AUTO_INCREMENT, 0x416)
PCODE_DEF(OB_SET_DS_ACTION, 0x417)
PCODE_DEF(OB_CHECK_PARTITION_TABLE, 0x418)
PCODE_DEF(OB_REBUILD_ROOT_PARTITION, 0x419)
PCODE_DEF(OB_SYNC_PARTITION_TABLE, 0x420)
PCODE_DEF(OB_SYNC_PT_FINISH, 0x421)
PCODE_DEF(OB_INCREMENTAL_COPY_DATA, 0x422)

//partition online/offline
PCODE_DEF(OB_ADD_TEMPORARY_REPLICA, 0x425)
PCODE_DEF(OB_ADD_REPLICA, 0x426)
PCODE_DEF(OB_REMOVE_REPLICA, 0x427)
PCODE_DEF(OB_MIGRATE_REPLICA, 0x428)

PCODE_DEF(OB_ADD_REPLICA_RES, 0x429)
PCODE_DEF(OB_MIGRATE_REPLICA_RES, 0x430)
PCODE_DEF(OB_ADD_TEMPORARY_REPLICA_RES, 0x431)
PCODE_DEF(OB_REMOVE_MEMBER, 0x432)
PCODE_DEF(OB_REBUILD_REPLICA, 0x433)


// sql, including executor

// sql
PCODE_DEF(OB_PHY_PLAN_EXECUTE, 0x501)
PCODE_DEF(OB_TASK_EXECUTE, 0x502)
PCODE_DEF(OB_TASK_SUBMIT, 0x503)
PCODE_DEF(OB_TASK_COMPLETE, 0x504)
PCODE_DEF(OB_TASK_NOTIFY_FETCH, 0x505)
PCODE_DEF(OB_TASK_FETCH_RESULT, 0x506)
PCODE_DEF(OB_TASK_KILL, 0x507)
PCODE_DEF(OB_CLOSE_RESULT, 0x508)

// election
PCODE_DEF(OB_ELECTION, 0x601)
PCODE_DEF(OB_ELECTION_RESPONSE, 0x602)

// transaction
PCODE_DEF(OB_TRANS, 0x701)
PCODE_DEF(OB_DUMP_MEMTABLE, 0x702)
PCODE_DEF(OB_TRANS_CHECK, 0x703)
PCODE_DEF(OB_TRANS_RESP, 0x706)
// transaction check for change leader by rpc
PCODE_DEF(OB_CHANGE_LEADER, 0x708)
// sys admin
PCODE_DEF(OB_FORCE_SET_AS_SINGLE_REPLICA, 0x720)

// clog
PCODE_DEF(OB_CLOG, 0x801)

PCODE_DEF(OB_LOG_GET_MC_TS, 0x805)
PCODE_DEF(OB_LOG_GET_MAX_CONFIRMED_LOG_ID, 0x806)

/* New Interface. To Replace Dying Rpc. */
PCODE_DEF(OB_LOG_REQ_START_LOG_ID_BY_TS, 0x850)
PCODE_DEF(OB_LOG_REQ_START_POS_BY_LOG_ID, 0x851)
PCODE_DEF(OB_LOG_FETCH_LOG_EXTERNAL, 0x852)
PCODE_DEF(OB_LOG_REQUEST_HEARTBEAT_INFO, 0x853)
PCODE_DEF(OB_LOG_REQ_START_LOG_ID_BY_TS_WITH_BREAKPOINT, 0x854)
PCODE_DEF(OB_LOG_REQ_START_POS_BY_LOG_ID_WITH_BREAKPOINT, 0x855)
PCODE_DEF(OB_LOG_OPEN_STREAM, 0x856)
PCODE_DEF(OB_LOG_STREAM_FETCH_LOG, 0x857)


//partition service
PCODE_DEF(OB_PTS_FETCH_INFO, 0x901)
PCODE_DEF(OB_PTS_MEMBER_CHANGE, 0x902)
PCODE_DEF(OB_GET_LEADER_MEMBER_LIST, 0x903)
PCODE_DEF(OB_MINOR_FREEZE, 0x904)
PCODE_DEF(OB_PTS_ADD_REPLICA, 0x905)
PCODE_DEF(OB_PTS_REMOVE_REPLICA, 0x906)
PCODE_DEF(OB_GET_MEMBER_LIST_AND_LEADER, 0x907)

