/**
 * Copyright (c) 2021 OceanBase
 * OceanBase Database Proxy(ODP) is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *          http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */

#include "ob_errno.h"
#include "ob_define.h"
using namespace oceanbase::common;

static const char* STR_ERROR[OB_MAX_ERROR_CODE];
static const char* SQLSTATE[OB_MAX_ERROR_CODE];
static const char* STR_USER_ERROR[OB_MAX_ERROR_CODE];
static int MYSQL_ERRNO[OB_MAX_ERROR_CODE];

static struct ObStrErrorInit
{
  ObStrErrorInit()
  {
    memset(STR_ERROR, 0, sizeof(STR_ERROR));
    memset(SQLSTATE, 0, sizeof(SQLSTATE));
    memset(MYSQL_ERRNO, 0, sizeof(MYSQL_ERRNO));
    memset(STR_USER_ERROR, 0, sizeof(STR_USER_ERROR));

    MYSQL_ERRNO[-OB_ERROR] = -1;
    SQLSTATE[-OB_ERROR] = "HY000";
    STR_ERROR[-OB_ERROR] = "Common error";
    STR_USER_ERROR[-OB_ERROR] = "Common error";
    MYSQL_ERRNO[-OB_OBJ_TYPE_ERROR] = -1;
    SQLSTATE[-OB_OBJ_TYPE_ERROR] = "HY004";
    STR_ERROR[-OB_OBJ_TYPE_ERROR] = "Object type error";
    STR_USER_ERROR[-OB_OBJ_TYPE_ERROR] = "Object type error";
    MYSQL_ERRNO[-OB_INVALID_ARGUMENT] = ER_WRONG_ARGUMENTS;
    SQLSTATE[-OB_INVALID_ARGUMENT] = "HY000";
    STR_ERROR[-OB_INVALID_ARGUMENT] = "Invalid argument";
    STR_USER_ERROR[-OB_INVALID_ARGUMENT] = "Incorrect arguments to %s";
    MYSQL_ERRNO[-OB_ARRAY_OUT_OF_RANGE] = -1;
    SQLSTATE[-OB_ARRAY_OUT_OF_RANGE] = "42000";
    STR_ERROR[-OB_ARRAY_OUT_OF_RANGE] = "Array index out of range";
    STR_USER_ERROR[-OB_ARRAY_OUT_OF_RANGE] = "Array index out of range";
    MYSQL_ERRNO[-OB_SERVER_LISTEN_ERROR] = -1;
    SQLSTATE[-OB_SERVER_LISTEN_ERROR] = "08S01";
    STR_ERROR[-OB_SERVER_LISTEN_ERROR] = "Failed to listen to the port";
    STR_USER_ERROR[-OB_SERVER_LISTEN_ERROR] = "Failed to listen to the port";
    MYSQL_ERRNO[-OB_INIT_TWICE] = -1;
    SQLSTATE[-OB_INIT_TWICE] = "HY000";
    STR_ERROR[-OB_INIT_TWICE] = "The object is initialized twice";
    STR_USER_ERROR[-OB_INIT_TWICE] = "The object is initialized twice";
    MYSQL_ERRNO[-OB_NOT_INIT] = -1;
    SQLSTATE[-OB_NOT_INIT] = "HY000";
    STR_ERROR[-OB_NOT_INIT] = "The object is not initialized";
    STR_USER_ERROR[-OB_NOT_INIT] = "The object is not initialized";
    MYSQL_ERRNO[-OB_NOT_SUPPORTED] = ER_NOT_SUPPORTED_YET;
    SQLSTATE[-OB_NOT_SUPPORTED] = "0A000";
    STR_ERROR[-OB_NOT_SUPPORTED] = "Not supported feature or function";
    STR_USER_ERROR[-OB_NOT_SUPPORTED] = "%s not supported";
    MYSQL_ERRNO[-OB_ITER_END] = -1;
    SQLSTATE[-OB_ITER_END] = "HY000";
    STR_ERROR[-OB_ITER_END] = "End of iteration";
    STR_USER_ERROR[-OB_ITER_END] = "End of iteration";
    MYSQL_ERRNO[-OB_IO_ERROR] = -1;
    SQLSTATE[-OB_IO_ERROR] = "58030";
    STR_ERROR[-OB_IO_ERROR] = "IO error";
    STR_USER_ERROR[-OB_IO_ERROR] = "IO error";
    MYSQL_ERRNO[-OB_ERROR_FUNC_VERSION] = -1;
    SQLSTATE[-OB_ERROR_FUNC_VERSION] = "HY000";
    STR_ERROR[-OB_ERROR_FUNC_VERSION] = "Wrong RPC command version";
    STR_USER_ERROR[-OB_ERROR_FUNC_VERSION] = "Wrong RPC command version";
    MYSQL_ERRNO[-OB_PACKET_NOT_SENT] = -1;
    SQLSTATE[-OB_PACKET_NOT_SENT] = "HY000";
    STR_ERROR[-OB_PACKET_NOT_SENT] = "Can not send packet";
    STR_USER_ERROR[-OB_PACKET_NOT_SENT] = "Can not send packet";
    MYSQL_ERRNO[-OB_TIMEOUT] = -1;
    SQLSTATE[-OB_TIMEOUT] = "HY000";
    STR_ERROR[-OB_TIMEOUT] = "Timeout";
    STR_USER_ERROR[-OB_TIMEOUT] = "Timeout";
    MYSQL_ERRNO[-OB_ALLOCATE_MEMORY_FAILED] = -1;
    SQLSTATE[-OB_ALLOCATE_MEMORY_FAILED] = "HY001";
    STR_ERROR[-OB_ALLOCATE_MEMORY_FAILED] = "No memory or reach tenant memory limit";
    STR_USER_ERROR[-OB_ALLOCATE_MEMORY_FAILED] = "No memory or reach tenant memory limit";
    MYSQL_ERRNO[-OB_INNER_STAT_ERROR] = -1;
    SQLSTATE[-OB_INNER_STAT_ERROR] = "HY000";
    STR_ERROR[-OB_INNER_STAT_ERROR] = "Inner state error";
    STR_USER_ERROR[-OB_INNER_STAT_ERROR] = "Inner state error";
    MYSQL_ERRNO[-OB_ERR_SYS] = -1;
    SQLSTATE[-OB_ERR_SYS] = "HY000";
    STR_ERROR[-OB_ERR_SYS] = "System error";
    STR_USER_ERROR[-OB_ERR_SYS] = "System error";
    MYSQL_ERRNO[-OB_ERR_UNEXPECTED] = -1;
    SQLSTATE[-OB_ERR_UNEXPECTED] = "HY000";
    STR_ERROR[-OB_ERR_UNEXPECTED] = "Ooooooooooooops";
    STR_USER_ERROR[-OB_ERR_UNEXPECTED] = "%s";
    MYSQL_ERRNO[-OB_ENTRY_EXIST] = -1;
    SQLSTATE[-OB_ENTRY_EXIST] = "HY000";
    STR_ERROR[-OB_ENTRY_EXIST] = "Entry already exist";
    STR_USER_ERROR[-OB_ENTRY_EXIST] = "Entry already exist";
    MYSQL_ERRNO[-OB_ENTRY_NOT_EXIST] = -1;
    SQLSTATE[-OB_ENTRY_NOT_EXIST] = "HY000";
    STR_ERROR[-OB_ENTRY_NOT_EXIST] = "Entry not exist";
    STR_USER_ERROR[-OB_ENTRY_NOT_EXIST] = "Entry not exist";
    MYSQL_ERRNO[-OB_SIZE_OVERFLOW] = -1;
    SQLSTATE[-OB_SIZE_OVERFLOW] = "HY000";
    STR_ERROR[-OB_SIZE_OVERFLOW] = "Size overflow";
    STR_USER_ERROR[-OB_SIZE_OVERFLOW] = "Size overflow";
    MYSQL_ERRNO[-OB_REF_NUM_NOT_ZERO] = -1;
    SQLSTATE[-OB_REF_NUM_NOT_ZERO] = "HY000";
    STR_ERROR[-OB_REF_NUM_NOT_ZERO] = "Reference count is not zero";
    STR_USER_ERROR[-OB_REF_NUM_NOT_ZERO] = "Reference count is not zero";
    MYSQL_ERRNO[-OB_CONFLICT_VALUE] = -1;
    SQLSTATE[-OB_CONFLICT_VALUE] = "HY000";
    STR_ERROR[-OB_CONFLICT_VALUE] = "Conflict value";
    STR_USER_ERROR[-OB_CONFLICT_VALUE] = "Conflict value";
    MYSQL_ERRNO[-OB_ITEM_NOT_SETTED] = -1;
    SQLSTATE[-OB_ITEM_NOT_SETTED] = "HY000";
    STR_ERROR[-OB_ITEM_NOT_SETTED] = "Item not set";
    STR_USER_ERROR[-OB_ITEM_NOT_SETTED] = "Item not set";
    MYSQL_ERRNO[-OB_EAGAIN] = -1;
    SQLSTATE[-OB_EAGAIN] = "HY000";
    STR_ERROR[-OB_EAGAIN] = "Try again";
    STR_USER_ERROR[-OB_EAGAIN] = "Try again";
    MYSQL_ERRNO[-OB_BUF_NOT_ENOUGH] = -1;
    SQLSTATE[-OB_BUF_NOT_ENOUGH] = "HY000";
    STR_ERROR[-OB_BUF_NOT_ENOUGH] = "Buffer not enough";
    STR_USER_ERROR[-OB_BUF_NOT_ENOUGH] = "Buffer not enough";
    MYSQL_ERRNO[-OB_PARTIAL_FAILED] = -1;
    SQLSTATE[-OB_PARTIAL_FAILED] = "HY000";
    STR_ERROR[-OB_PARTIAL_FAILED] = "Partial failed";
    STR_USER_ERROR[-OB_PARTIAL_FAILED] = "Partial failed";
    MYSQL_ERRNO[-OB_READ_NOTHING] = -1;
    SQLSTATE[-OB_READ_NOTHING] = "02000";
    STR_ERROR[-OB_READ_NOTHING] = "Nothing to read";
    STR_USER_ERROR[-OB_READ_NOTHING] = "Nothing to read";
    MYSQL_ERRNO[-OB_FILE_NOT_EXIST] = ER_FILE_NOT_FOUND;
    SQLSTATE[-OB_FILE_NOT_EXIST] = "HY000";
    STR_ERROR[-OB_FILE_NOT_EXIST] = "File not exist";
    STR_USER_ERROR[-OB_FILE_NOT_EXIST] = "File not exist";
    MYSQL_ERRNO[-OB_DISCONTINUOUS_LOG] = -1;
    SQLSTATE[-OB_DISCONTINUOUS_LOG] = "HY000";
    STR_ERROR[-OB_DISCONTINUOUS_LOG] = "Log entry not continuous";
    STR_USER_ERROR[-OB_DISCONTINUOUS_LOG] = "Log entry not continuous";
    MYSQL_ERRNO[-OB_SCHEMA_ERROR] = -1;
    SQLSTATE[-OB_SCHEMA_ERROR] = "HY000";
    STR_ERROR[-OB_SCHEMA_ERROR] = "Schema error";
    STR_USER_ERROR[-OB_SCHEMA_ERROR] = "Schema error";
    MYSQL_ERRNO[-OB_TENANT_OUT_OF_MEM] = -1;
    SQLSTATE[-OB_TENANT_OUT_OF_MEM] = "HY000";
    STR_ERROR[-OB_TENANT_OUT_OF_MEM] = "Over tenant memory limits";
    STR_USER_ERROR[-OB_TENANT_OUT_OF_MEM] = "Over tenant memory limits";
    MYSQL_ERRNO[-OB_UNKNOWN_OBJ] = -1;
    SQLSTATE[-OB_UNKNOWN_OBJ] = "HY004";
    STR_ERROR[-OB_UNKNOWN_OBJ] = "Unknown object";
    STR_USER_ERROR[-OB_UNKNOWN_OBJ] = "Unknown object";
    MYSQL_ERRNO[-OB_NO_MONITOR_DATA] = -1;
    SQLSTATE[-OB_NO_MONITOR_DATA] = "02000";
    STR_ERROR[-OB_NO_MONITOR_DATA] = "No monitor data";
    STR_USER_ERROR[-OB_NO_MONITOR_DATA] = "No monitor data";
    MYSQL_ERRNO[-OB_SERIALIZE_ERROR] = -1;
    SQLSTATE[-OB_SERIALIZE_ERROR] = "HY000";
    STR_ERROR[-OB_SERIALIZE_ERROR] = "Serialize error";
    STR_USER_ERROR[-OB_SERIALIZE_ERROR] = "Serialize error";
    MYSQL_ERRNO[-OB_DESERIALIZE_ERROR] = -1;
    SQLSTATE[-OB_DESERIALIZE_ERROR] = "HY000";
    STR_ERROR[-OB_DESERIALIZE_ERROR] = "Deserialize error";
    STR_USER_ERROR[-OB_DESERIALIZE_ERROR] = "Deserialize error";
    MYSQL_ERRNO[-OB_AIO_TIMEOUT] = -1;
    SQLSTATE[-OB_AIO_TIMEOUT] = "HY000";
    STR_ERROR[-OB_AIO_TIMEOUT] = "Asynchronous IO error";
    STR_USER_ERROR[-OB_AIO_TIMEOUT] = "Asynchronous IO error";
    MYSQL_ERRNO[-OB_NEED_RETRY] = -1;
    SQLSTATE[-OB_NEED_RETRY] = "HY000";
    STR_ERROR[-OB_NEED_RETRY] = "Need retry";
    STR_USER_ERROR[-OB_NEED_RETRY] = "Need retry";
    MYSQL_ERRNO[-OB_TOO_MANY_SSTABLE] = -1;
    SQLSTATE[-OB_TOO_MANY_SSTABLE] = "HY000";
    STR_ERROR[-OB_TOO_MANY_SSTABLE] = "Too many sstable";
    STR_USER_ERROR[-OB_TOO_MANY_SSTABLE] = "Too many sstable";
    MYSQL_ERRNO[-OB_NOT_MASTER] = -1;
    SQLSTATE[-OB_NOT_MASTER] = "HY000";
    STR_ERROR[-OB_NOT_MASTER] = "The observer or zone is not the master";
    STR_USER_ERROR[-OB_NOT_MASTER] = "The observer or zone is not the master";
    MYSQL_ERRNO[-OB_DECRYPT_FAILED] = -1;
    SQLSTATE[-OB_DECRYPT_FAILED] = "HY000";
    STR_ERROR[-OB_DECRYPT_FAILED] = "Decrypt error";
    STR_USER_ERROR[-OB_DECRYPT_FAILED] = "Decrypt error";
    MYSQL_ERRNO[-OB_USER_NOT_EXIST] = ER_PASSWORD_NO_MATCH;
    SQLSTATE[-OB_USER_NOT_EXIST] = "42000";
    STR_ERROR[-OB_USER_NOT_EXIST] = "Can not find any matching row in the user table";
    STR_USER_ERROR[-OB_USER_NOT_EXIST] = "Can not find any matching row in the user table";
    MYSQL_ERRNO[-OB_PASSWORD_WRONG] = ER_ACCESS_DENIED_ERROR;
    SQLSTATE[-OB_PASSWORD_WRONG] = "42000";
    STR_ERROR[-OB_PASSWORD_WRONG] = "Access denied for user";
    STR_USER_ERROR[-OB_PASSWORD_WRONG] = "Access denied for user '%.*s'@'%.*s' (using password: %s)";
    MYSQL_ERRNO[-OB_SKEY_VERSION_WRONG] = -1;
    SQLSTATE[-OB_SKEY_VERSION_WRONG] = "HY000";
    STR_ERROR[-OB_SKEY_VERSION_WRONG] = "Wrong skey version";
    STR_USER_ERROR[-OB_SKEY_VERSION_WRONG] = "Wrong skey version";
    MYSQL_ERRNO[-OB_NOT_REGISTERED] = -1;
    SQLSTATE[-OB_NOT_REGISTERED] = "HY000";
    STR_ERROR[-OB_NOT_REGISTERED] = "Not registered";
    STR_USER_ERROR[-OB_NOT_REGISTERED] = "Not registered";
    MYSQL_ERRNO[-OB_WAITQUEUE_TIMEOUT] = 4012;
    SQLSTATE[-OB_WAITQUEUE_TIMEOUT] = "HY000";
    STR_ERROR[-OB_WAITQUEUE_TIMEOUT] = "Task timeout and not executed";
    STR_USER_ERROR[-OB_WAITQUEUE_TIMEOUT] = "Task timeout and not executed";
    MYSQL_ERRNO[-OB_NOT_THE_OBJECT] = -1;
    SQLSTATE[-OB_NOT_THE_OBJECT] = "HY000";
    STR_ERROR[-OB_NOT_THE_OBJECT] = "Not the object";
    STR_USER_ERROR[-OB_NOT_THE_OBJECT] = "Not the object";
    MYSQL_ERRNO[-OB_ALREADY_REGISTERED] = -1;
    SQLSTATE[-OB_ALREADY_REGISTERED] = "HY000";
    STR_ERROR[-OB_ALREADY_REGISTERED] = "Already registered";
    STR_USER_ERROR[-OB_ALREADY_REGISTERED] = "Already registered";
    MYSQL_ERRNO[-OB_LAST_LOG_RUINNED] = -1;
    SQLSTATE[-OB_LAST_LOG_RUINNED] = "HY000";
    STR_ERROR[-OB_LAST_LOG_RUINNED] = "Corrupted log entry";
    STR_USER_ERROR[-OB_LAST_LOG_RUINNED] = "Corrupted log entry";
    MYSQL_ERRNO[-OB_NO_CS_SELECTED] = -1;
    SQLSTATE[-OB_NO_CS_SELECTED] = "HY000";
    STR_ERROR[-OB_NO_CS_SELECTED] = "No ChunkServer selected";
    STR_USER_ERROR[-OB_NO_CS_SELECTED] = "No ChunkServer selected";
    MYSQL_ERRNO[-OB_NO_TABLETS_CREATED] = -1;
    SQLSTATE[-OB_NO_TABLETS_CREATED] = "HY000";
    STR_ERROR[-OB_NO_TABLETS_CREATED] = "No tablets created";
    STR_USER_ERROR[-OB_NO_TABLETS_CREATED] = "No tablets created";
    MYSQL_ERRNO[-OB_INVALID_ERROR] = -1;
    SQLSTATE[-OB_INVALID_ERROR] = "HY000";
    STR_ERROR[-OB_INVALID_ERROR] = "Invalid entry";
    STR_USER_ERROR[-OB_INVALID_ERROR] = "Invalid entry";
    MYSQL_ERRNO[-OB_DECIMAL_OVERFLOW_WARN] = -1;
    SQLSTATE[-OB_DECIMAL_OVERFLOW_WARN] = "HY000";
    STR_ERROR[-OB_DECIMAL_OVERFLOW_WARN] = "Decimal overflow warning";
    STR_USER_ERROR[-OB_DECIMAL_OVERFLOW_WARN] = "Decimal overflow warning";
    MYSQL_ERRNO[-OB_DECIMAL_UNLEGAL_ERROR] = -1;
    SQLSTATE[-OB_DECIMAL_UNLEGAL_ERROR] = "HY000";
    STR_ERROR[-OB_DECIMAL_UNLEGAL_ERROR] = "Decimal overflow error";
    STR_USER_ERROR[-OB_DECIMAL_UNLEGAL_ERROR] = "Decimal overflow error";
    MYSQL_ERRNO[-OB_OBJ_DIVIDE_ERROR] = -1;
    SQLSTATE[-OB_OBJ_DIVIDE_ERROR] = "HY000";
    STR_ERROR[-OB_OBJ_DIVIDE_ERROR] = "Divide error";
    STR_USER_ERROR[-OB_OBJ_DIVIDE_ERROR] = "Divide error";
    MYSQL_ERRNO[-OB_NOT_A_DECIMAL] = -1;
    SQLSTATE[-OB_NOT_A_DECIMAL] = "HY000";
    STR_ERROR[-OB_NOT_A_DECIMAL] = "Not a decimal";
    STR_USER_ERROR[-OB_NOT_A_DECIMAL] = "Not a decimal";
    MYSQL_ERRNO[-OB_DECIMAL_PRECISION_NOT_EQUAL] = -1;
    SQLSTATE[-OB_DECIMAL_PRECISION_NOT_EQUAL] = "HY104";
    STR_ERROR[-OB_DECIMAL_PRECISION_NOT_EQUAL] = "Decimal precision error";
    STR_USER_ERROR[-OB_DECIMAL_PRECISION_NOT_EQUAL] = "Decimal precision error";
    MYSQL_ERRNO[-OB_EMPTY_RANGE] = -1;
    SQLSTATE[-OB_EMPTY_RANGE] = "HY000";
    STR_ERROR[-OB_EMPTY_RANGE] = "Empty range";
    STR_USER_ERROR[-OB_EMPTY_RANGE] = "Empty range";
    MYSQL_ERRNO[-OB_SESSION_KILLED] = -1;
    SQLSTATE[-OB_SESSION_KILLED] = "HY000";
    STR_ERROR[-OB_SESSION_KILLED] = "Session killed";
    STR_USER_ERROR[-OB_SESSION_KILLED] = "Session killed";
    MYSQL_ERRNO[-OB_LOG_NOT_SYNC] = -1;
    SQLSTATE[-OB_LOG_NOT_SYNC] = "HY000";
    STR_ERROR[-OB_LOG_NOT_SYNC] = "Log not sync";
    STR_USER_ERROR[-OB_LOG_NOT_SYNC] = "Log not sync";
    MYSQL_ERRNO[-OB_DIR_NOT_EXIST] = ER_CANT_READ_DIR;
    SQLSTATE[-OB_DIR_NOT_EXIST] = "HY000";
    STR_ERROR[-OB_DIR_NOT_EXIST] = "Directory not exist";
    STR_USER_ERROR[-OB_DIR_NOT_EXIST] = "Directory not exist";
    MYSQL_ERRNO[-OB_SESSION_NOT_FOUND] = 4012;
    SQLSTATE[-OB_SESSION_NOT_FOUND] = "HY000";
    STR_ERROR[-OB_SESSION_NOT_FOUND] = "RPC session not found";
    STR_USER_ERROR[-OB_SESSION_NOT_FOUND] = "RPC session not found";
    MYSQL_ERRNO[-OB_INVALID_LOG] = -1;
    SQLSTATE[-OB_INVALID_LOG] = "HY000";
    STR_ERROR[-OB_INVALID_LOG] = "Invalid log";
    STR_USER_ERROR[-OB_INVALID_LOG] = "Invalid log";
    MYSQL_ERRNO[-OB_INVALID_DATA] = -1;
    SQLSTATE[-OB_INVALID_DATA] = "HY000";
    STR_ERROR[-OB_INVALID_DATA] = "Invalid data";
    STR_USER_ERROR[-OB_INVALID_DATA] = "Invalid data";
    MYSQL_ERRNO[-OB_ALREADY_DONE] = -1;
    SQLSTATE[-OB_ALREADY_DONE] = "HY000";
    STR_ERROR[-OB_ALREADY_DONE] = "Already done";
    STR_USER_ERROR[-OB_ALREADY_DONE] = "Already done";
    MYSQL_ERRNO[-OB_CANCELED] = -1;
    SQLSTATE[-OB_CANCELED] = "HY000";
    STR_ERROR[-OB_CANCELED] = "Operation canceled";
    STR_USER_ERROR[-OB_CANCELED] = "Operation canceled";
    MYSQL_ERRNO[-OB_LOG_SRC_CHANGED] = -1;
    SQLSTATE[-OB_LOG_SRC_CHANGED] = "HY000";
    STR_ERROR[-OB_LOG_SRC_CHANGED] = "Log source changed";
    STR_USER_ERROR[-OB_LOG_SRC_CHANGED] = "Log source changed";
    MYSQL_ERRNO[-OB_LOG_NOT_ALIGN] = -1;
    SQLSTATE[-OB_LOG_NOT_ALIGN] = "HY000";
    STR_ERROR[-OB_LOG_NOT_ALIGN] = "Log not aligned";
    STR_USER_ERROR[-OB_LOG_NOT_ALIGN] = "Log not aligned";
    MYSQL_ERRNO[-OB_LOG_MISSING] = -1;
    SQLSTATE[-OB_LOG_MISSING] = "HY000";
    STR_ERROR[-OB_LOG_MISSING] = "Log entry missed";
    STR_USER_ERROR[-OB_LOG_MISSING] = "Log entry missed";
    MYSQL_ERRNO[-OB_NEED_WAIT] = -1;
    SQLSTATE[-OB_NEED_WAIT] = "HY000";
    STR_ERROR[-OB_NEED_WAIT] = "Need wait";
    STR_USER_ERROR[-OB_NEED_WAIT] = "Need wait";
    MYSQL_ERRNO[-OB_NOT_IMPLEMENT] = -1;
    SQLSTATE[-OB_NOT_IMPLEMENT] = "0A000";
    STR_ERROR[-OB_NOT_IMPLEMENT] = "Not implemented feature";
    STR_USER_ERROR[-OB_NOT_IMPLEMENT] = "Not implemented feature";
    MYSQL_ERRNO[-OB_DIVISION_BY_ZERO] = ER_DIVISION_BY_ZERO;
    SQLSTATE[-OB_DIVISION_BY_ZERO] = "42000";
    STR_ERROR[-OB_DIVISION_BY_ZERO] = "Divided by zero";
    STR_USER_ERROR[-OB_DIVISION_BY_ZERO] = "Divided by zero";
    MYSQL_ERRNO[-OB_EXCEED_MEM_LIMIT] = -1;
    SQLSTATE[-OB_EXCEED_MEM_LIMIT] = "HY013";
    STR_ERROR[-OB_EXCEED_MEM_LIMIT] = "exceed memory limit";
    STR_USER_ERROR[-OB_EXCEED_MEM_LIMIT] = "exceed memory limit";
    MYSQL_ERRNO[-OB_RESULT_UNKNOWN] = -1;
    SQLSTATE[-OB_RESULT_UNKNOWN] = "HY000";
    STR_ERROR[-OB_RESULT_UNKNOWN] = "Unknown result";
    STR_USER_ERROR[-OB_RESULT_UNKNOWN] = "Unknown result";
    MYSQL_ERRNO[-OB_NO_RESULT] = -1;
    SQLSTATE[-OB_NO_RESULT] = "02000";
    STR_ERROR[-OB_NO_RESULT] = "No result";
    STR_USER_ERROR[-OB_NO_RESULT] = "No result";
    MYSQL_ERRNO[-OB_QUEUE_OVERFLOW] = -1;
    SQLSTATE[-OB_QUEUE_OVERFLOW] = "HY000";
    STR_ERROR[-OB_QUEUE_OVERFLOW] = "Queue overflow";
    STR_USER_ERROR[-OB_QUEUE_OVERFLOW] = "Queue overflow";
    MYSQL_ERRNO[-OB_TERM_LAGGED] = -1;
    SQLSTATE[-OB_TERM_LAGGED] = "HY000";
    STR_ERROR[-OB_TERM_LAGGED] = "Term lagged";
    STR_USER_ERROR[-OB_TERM_LAGGED] = "Term lagged";
    MYSQL_ERRNO[-OB_TERM_NOT_MATCH] = -1;
    SQLSTATE[-OB_TERM_NOT_MATCH] = "HY000";
    STR_ERROR[-OB_TERM_NOT_MATCH] = "Term not match";
    STR_USER_ERROR[-OB_TERM_NOT_MATCH] = "Term not match";
    MYSQL_ERRNO[-OB_START_LOG_CURSOR_INVALID] = -1;
    SQLSTATE[-OB_START_LOG_CURSOR_INVALID] = "HY000";
    STR_ERROR[-OB_START_LOG_CURSOR_INVALID] = "Invalid log cursor";
    STR_USER_ERROR[-OB_START_LOG_CURSOR_INVALID] = "Invalid log cursor";
    MYSQL_ERRNO[-OB_LOCK_NOT_MATCH] = -1;
    SQLSTATE[-OB_LOCK_NOT_MATCH] = "HY000";
    STR_ERROR[-OB_LOCK_NOT_MATCH] = "Lock not match";
    STR_USER_ERROR[-OB_LOCK_NOT_MATCH] = "Lock not match";
    MYSQL_ERRNO[-OB_DEAD_LOCK] = ER_LOCK_DEADLOCK;
    SQLSTATE[-OB_DEAD_LOCK] = "HY000";
    STR_ERROR[-OB_DEAD_LOCK] = "Deadlock";
    STR_USER_ERROR[-OB_DEAD_LOCK] = "Deadlock";
    MYSQL_ERRNO[-OB_PARTIAL_LOG] = -1;
    SQLSTATE[-OB_PARTIAL_LOG] = "HY000";
    STR_ERROR[-OB_PARTIAL_LOG] = "Incomplete log entry";
    STR_USER_ERROR[-OB_PARTIAL_LOG] = "Incomplete log entry";
    MYSQL_ERRNO[-OB_CHECKSUM_ERROR] = -1;
    SQLSTATE[-OB_CHECKSUM_ERROR] = "42000";
    STR_ERROR[-OB_CHECKSUM_ERROR] = "Data checksum error";
    STR_USER_ERROR[-OB_CHECKSUM_ERROR] = "Data checksum error";
    MYSQL_ERRNO[-OB_INIT_FAIL] = -1;
    SQLSTATE[-OB_INIT_FAIL] = "HY000";
    STR_ERROR[-OB_INIT_FAIL] = "Initialize error";
    STR_USER_ERROR[-OB_INIT_FAIL] = "Initialize error";
    MYSQL_ERRNO[-OB_NOT_ENOUGH_STORE] = -1;
    SQLSTATE[-OB_NOT_ENOUGH_STORE] = "HY000";
    STR_ERROR[-OB_NOT_ENOUGH_STORE] = "not enough commitlog store";
    STR_USER_ERROR[-OB_NOT_ENOUGH_STORE] = "not enough commitlog store";
    MYSQL_ERRNO[-OB_BLOCK_SWITCHED] = -1;
    SQLSTATE[-OB_BLOCK_SWITCHED] = "HY000";
    STR_ERROR[-OB_BLOCK_SWITCHED] = "block switched when fill commitlog";
    STR_USER_ERROR[-OB_BLOCK_SWITCHED] = "block switched when fill commitlog";
    MYSQL_ERRNO[-OB_STATE_NOT_MATCH] = -1;
    SQLSTATE[-OB_STATE_NOT_MATCH] = "HY000";
    STR_ERROR[-OB_STATE_NOT_MATCH] = "Server state or role not the same as expected";
    STR_USER_ERROR[-OB_STATE_NOT_MATCH] = "Server state or role not the same as expected";
    MYSQL_ERRNO[-OB_READ_ZERO_LOG] = -1;
    SQLSTATE[-OB_READ_ZERO_LOG] = "HY000";
    STR_ERROR[-OB_READ_ZERO_LOG] = "Read zero log";
    STR_USER_ERROR[-OB_READ_ZERO_LOG] = "Read zero log";
    MYSQL_ERRNO[-OB_BLOCK_NEED_FREEZE] = -1;
    SQLSTATE[-OB_BLOCK_NEED_FREEZE] = "HY000";
    STR_ERROR[-OB_BLOCK_NEED_FREEZE] = "block need freeze";
    STR_USER_ERROR[-OB_BLOCK_NEED_FREEZE] = "block need freeze";
    MYSQL_ERRNO[-OB_BLOCK_FROZEN] = -1;
    SQLSTATE[-OB_BLOCK_FROZEN] = "HY000";
    STR_ERROR[-OB_BLOCK_FROZEN] = "block frozen";
    STR_USER_ERROR[-OB_BLOCK_FROZEN] = "block frozen";
    MYSQL_ERRNO[-OB_IN_FATAL_STATE] = -1;
    SQLSTATE[-OB_IN_FATAL_STATE] = "HY000";
    STR_ERROR[-OB_IN_FATAL_STATE] = "In FATAL state";
    STR_USER_ERROR[-OB_IN_FATAL_STATE] = "In FATAL state";
    MYSQL_ERRNO[-OB_IN_STOP_STATE] = -1;
    SQLSTATE[-OB_IN_STOP_STATE] = "08S01";
    STR_ERROR[-OB_IN_STOP_STATE] = "In STOP state";
    STR_USER_ERROR[-OB_IN_STOP_STATE] = "In STOP state";
    MYSQL_ERRNO[-OB_UPS_MASTER_EXISTS] = -1;
    SQLSTATE[-OB_UPS_MASTER_EXISTS] = "HY000";
    STR_ERROR[-OB_UPS_MASTER_EXISTS] = "Master UpdateServer already exists";
    STR_USER_ERROR[-OB_UPS_MASTER_EXISTS] = "Master UpdateServer already exists";
    MYSQL_ERRNO[-OB_LOG_NOT_CLEAR] = -1;
    SQLSTATE[-OB_LOG_NOT_CLEAR] = "42000";
    STR_ERROR[-OB_LOG_NOT_CLEAR] = "Log not clear";
    STR_USER_ERROR[-OB_LOG_NOT_CLEAR] = "Log not clear";
    MYSQL_ERRNO[-OB_FILE_ALREADY_EXIST] = ER_FILE_EXISTS_ERROR;
    SQLSTATE[-OB_FILE_ALREADY_EXIST] = "58000";
    STR_ERROR[-OB_FILE_ALREADY_EXIST] = "File already exist";
    STR_USER_ERROR[-OB_FILE_ALREADY_EXIST] = "File already exist";
    MYSQL_ERRNO[-OB_UNKNOWN_PACKET] = ER_UNKNOWN_COM_ERROR;
    SQLSTATE[-OB_UNKNOWN_PACKET] = "HY001";
    STR_ERROR[-OB_UNKNOWN_PACKET] = "Unknown packet";
    STR_USER_ERROR[-OB_UNKNOWN_PACKET] = "Unknown packet";
    MYSQL_ERRNO[-OB_RPC_PACKET_TOO_LONG] = -1;
    SQLSTATE[-OB_RPC_PACKET_TOO_LONG] = "08000";
    STR_ERROR[-OB_RPC_PACKET_TOO_LONG] = "RPC packet to send too long";
    STR_USER_ERROR[-OB_RPC_PACKET_TOO_LONG] = "RPC packet to send too long";
    MYSQL_ERRNO[-OB_LOG_TOO_LARGE] = -1;
    SQLSTATE[-OB_LOG_TOO_LARGE] = "HY000";
    STR_ERROR[-OB_LOG_TOO_LARGE] = "Log too large";
    STR_USER_ERROR[-OB_LOG_TOO_LARGE] = "Log too large";
    MYSQL_ERRNO[-OB_RPC_SEND_ERROR] = -1;
    SQLSTATE[-OB_RPC_SEND_ERROR] = "08000";
    STR_ERROR[-OB_RPC_SEND_ERROR] = "RPC send error";
    STR_USER_ERROR[-OB_RPC_SEND_ERROR] = "RPC send error";
    MYSQL_ERRNO[-OB_RPC_POST_ERROR] = -1;
    SQLSTATE[-OB_RPC_POST_ERROR] = "08000";
    STR_ERROR[-OB_RPC_POST_ERROR] = "RPC post error";
    STR_USER_ERROR[-OB_RPC_POST_ERROR] = "RPC post error";
    MYSQL_ERRNO[-OB_LIBEASY_ERROR] = -1;
    SQLSTATE[-OB_LIBEASY_ERROR] = "08000";
    STR_ERROR[-OB_LIBEASY_ERROR] = "Libeasy error";
    STR_USER_ERROR[-OB_LIBEASY_ERROR] = "Libeasy error";
    MYSQL_ERRNO[-OB_CONNECT_ERROR] = -1;
    SQLSTATE[-OB_CONNECT_ERROR] = "HY000";
    STR_ERROR[-OB_CONNECT_ERROR] = "Connect error";
    STR_USER_ERROR[-OB_CONNECT_ERROR] = "Connect error";
    MYSQL_ERRNO[-OB_NOT_FREE] = -1;
    SQLSTATE[-OB_NOT_FREE] = "HY000";
    STR_ERROR[-OB_NOT_FREE] = "Not free";
    STR_USER_ERROR[-OB_NOT_FREE] = "Not free";
    MYSQL_ERRNO[-OB_INIT_SQL_CONTEXT_ERROR] = -1;
    SQLSTATE[-OB_INIT_SQL_CONTEXT_ERROR] = "HY000";
    STR_ERROR[-OB_INIT_SQL_CONTEXT_ERROR] = "Init SQL context error";
    STR_USER_ERROR[-OB_INIT_SQL_CONTEXT_ERROR] = "Init SQL context error";
    MYSQL_ERRNO[-OB_SKIP_INVALID_ROW] = -1;
    SQLSTATE[-OB_SKIP_INVALID_ROW] = "42000";
    STR_ERROR[-OB_SKIP_INVALID_ROW] = "Skip invalid row";
    STR_USER_ERROR[-OB_SKIP_INVALID_ROW] = "Skip invalid row";
    MYSQL_ERRNO[-OB_RPC_PACKET_INVALID] = -1;
    SQLSTATE[-OB_RPC_PACKET_INVALID] = "HY000";
    STR_ERROR[-OB_RPC_PACKET_INVALID] = "RPC packet is invalid";
    STR_USER_ERROR[-OB_RPC_PACKET_INVALID] = "RPC packet is invalid";
    MYSQL_ERRNO[-OB_NO_TABLET] = -1;
    SQLSTATE[-OB_NO_TABLET] = "HY000";
    STR_ERROR[-OB_NO_TABLET] = "No tablets";
    STR_USER_ERROR[-OB_NO_TABLET] = "No tablets";
    MYSQL_ERRNO[-OB_SNAPSHOT_DISCARDED] = -1;
    SQLSTATE[-OB_SNAPSHOT_DISCARDED] = "HY000";
    STR_ERROR[-OB_SNAPSHOT_DISCARDED] = "Request to read too old versioned data";
    STR_USER_ERROR[-OB_SNAPSHOT_DISCARDED] = "Request to read too old versioned data";
    MYSQL_ERRNO[-OB_DATA_NOT_UPTODATE] = -1;
    SQLSTATE[-OB_DATA_NOT_UPTODATE] = "HY000";
    STR_ERROR[-OB_DATA_NOT_UPTODATE] = "State is stale";
    STR_USER_ERROR[-OB_DATA_NOT_UPTODATE] = "State is stale";
    MYSQL_ERRNO[-OB_ROW_MODIFIED] = -1;
    SQLSTATE[-OB_ROW_MODIFIED] = "HY000";
    STR_ERROR[-OB_ROW_MODIFIED] = "Row modified";
    STR_USER_ERROR[-OB_ROW_MODIFIED] = "Row modified";
    MYSQL_ERRNO[-OB_VERSION_NOT_MATCH] = -1;
    SQLSTATE[-OB_VERSION_NOT_MATCH] = "42000";
    STR_ERROR[-OB_VERSION_NOT_MATCH] = "Version not match";
    STR_USER_ERROR[-OB_VERSION_NOT_MATCH] = "Version not match";
    MYSQL_ERRNO[-OB_BAD_ADDRESS] = -1;
    SQLSTATE[-OB_BAD_ADDRESS] = "42000";
    STR_ERROR[-OB_BAD_ADDRESS] = "Bad address";
    STR_USER_ERROR[-OB_BAD_ADDRESS] = "Bad address";
    MYSQL_ERRNO[-OB_ENQUEUE_FAILED] = -1;
    SQLSTATE[-OB_ENQUEUE_FAILED] = "HY000";
    STR_ERROR[-OB_ENQUEUE_FAILED] = "Enqueue error";
    STR_USER_ERROR[-OB_ENQUEUE_FAILED] = "Enqueue error";
    MYSQL_ERRNO[-OB_INVALID_CONFIG] = -1;
    SQLSTATE[-OB_INVALID_CONFIG] = "HY000";
    STR_ERROR[-OB_INVALID_CONFIG] = "Invalid config";
    STR_USER_ERROR[-OB_INVALID_CONFIG] = "Invalid config";
    MYSQL_ERRNO[-OB_STMT_EXPIRED] = -1;
    SQLSTATE[-OB_STMT_EXPIRED] = "HY000";
    STR_ERROR[-OB_STMT_EXPIRED] = "Expired statement";
    STR_USER_ERROR[-OB_STMT_EXPIRED] = "Expired statement";
    MYSQL_ERRNO[-OB_ERR_MIN_VALUE] = -1;
    SQLSTATE[-OB_ERR_MIN_VALUE] = "42000";
    STR_ERROR[-OB_ERR_MIN_VALUE] = "Min value";
    STR_USER_ERROR[-OB_ERR_MIN_VALUE] = "Min value";
    MYSQL_ERRNO[-OB_ERR_MAX_VALUE] = -1;
    SQLSTATE[-OB_ERR_MAX_VALUE] = "42000";
    STR_ERROR[-OB_ERR_MAX_VALUE] = "Max value";
    STR_USER_ERROR[-OB_ERR_MAX_VALUE] = "Max value";
    MYSQL_ERRNO[-OB_ERR_NULL_VALUE] = -1;
    SQLSTATE[-OB_ERR_NULL_VALUE] = "42000";
    STR_ERROR[-OB_ERR_NULL_VALUE] = "Null value";
    STR_USER_ERROR[-OB_ERR_NULL_VALUE] = "%s";
    MYSQL_ERRNO[-OB_RESOURCE_OUT] = ER_OUT_OF_RESOURCES;
    SQLSTATE[-OB_RESOURCE_OUT] = "53000";
    STR_ERROR[-OB_RESOURCE_OUT] = "Out of resource";
    STR_USER_ERROR[-OB_RESOURCE_OUT] = "Out of resource";
    MYSQL_ERRNO[-OB_ERR_SQL_CLIENT] = -1;
    SQLSTATE[-OB_ERR_SQL_CLIENT] = "HY000";
    STR_ERROR[-OB_ERR_SQL_CLIENT] = "Internal SQL client error";
    STR_USER_ERROR[-OB_ERR_SQL_CLIENT] = "Internal SQL client error";
    MYSQL_ERRNO[-OB_META_TABLE_WITHOUT_USE_TABLE] = -1;
    SQLSTATE[-OB_META_TABLE_WITHOUT_USE_TABLE] = "HY000";
    STR_ERROR[-OB_META_TABLE_WITHOUT_USE_TABLE] = "Meta table without use table";
    STR_USER_ERROR[-OB_META_TABLE_WITHOUT_USE_TABLE] = "Meta table without use table";
    MYSQL_ERRNO[-OB_DISCARD_PACKET] = -1;
    SQLSTATE[-OB_DISCARD_PACKET] = "HY000";
    STR_ERROR[-OB_DISCARD_PACKET] = "Discard packet";
    STR_USER_ERROR[-OB_DISCARD_PACKET] = "Discard packet";
    MYSQL_ERRNO[-OB_OPERATE_OVERFLOW] = ER_DATA_OUT_OF_RANGE;
    SQLSTATE[-OB_OPERATE_OVERFLOW] = "22003";
    STR_ERROR[-OB_OPERATE_OVERFLOW] = "value is out of range";
    STR_USER_ERROR[-OB_OPERATE_OVERFLOW] = "%s value is out of range in '%s'";
    MYSQL_ERRNO[-OB_INVALID_DATE_FORMAT] = ER_TRUNCATED_WRONG_VALUE;
    SQLSTATE[-OB_INVALID_DATE_FORMAT] = "22007";
    STR_ERROR[-OB_INVALID_DATE_FORMAT] = "Incorrect value";
    STR_USER_ERROR[-OB_INVALID_DATE_FORMAT] = "%s=%d must between %d and %d";
    MYSQL_ERRNO[-OB_POOL_REGISTERED_FAILED] = -1;
    SQLSTATE[-OB_POOL_REGISTERED_FAILED] = "HY000";
    STR_ERROR[-OB_POOL_REGISTERED_FAILED] = "register pool failed";
    STR_USER_ERROR[-OB_POOL_REGISTERED_FAILED] = "register pool failed";
    MYSQL_ERRNO[-OB_POOL_UNREGISTERED_FAILED] = -1;
    SQLSTATE[-OB_POOL_UNREGISTERED_FAILED] = "HY000";
    STR_ERROR[-OB_POOL_UNREGISTERED_FAILED] = "unregister pool failed";
    STR_USER_ERROR[-OB_POOL_UNREGISTERED_FAILED] = "unregister pool failed";
    MYSQL_ERRNO[-OB_INVALID_ARGUMENT_NUM] = -1;
    SQLSTATE[-OB_INVALID_ARGUMENT_NUM] = "42000";
    STR_ERROR[-OB_INVALID_ARGUMENT_NUM] = "Invalid argument num";
    STR_USER_ERROR[-OB_INVALID_ARGUMENT_NUM] = "Invalid argument num";
    MYSQL_ERRNO[-OB_LEASE_NOT_ENOUGH] = -1;
    SQLSTATE[-OB_LEASE_NOT_ENOUGH] = "HY000";
    STR_ERROR[-OB_LEASE_NOT_ENOUGH] = "reserved lease not enough";
    STR_USER_ERROR[-OB_LEASE_NOT_ENOUGH] = "reserved lease not enough";
    MYSQL_ERRNO[-OB_LEASE_NOT_MATCH] = -1;
    SQLSTATE[-OB_LEASE_NOT_MATCH] = "HY000";
    STR_ERROR[-OB_LEASE_NOT_MATCH] = "ups lease not match with rs";
    STR_USER_ERROR[-OB_LEASE_NOT_MATCH] = "ups lease not match with rs";
    MYSQL_ERRNO[-OB_UPS_SWITCH_NOT_HAPPEN] = -1;
    SQLSTATE[-OB_UPS_SWITCH_NOT_HAPPEN] = "HY000";
    STR_ERROR[-OB_UPS_SWITCH_NOT_HAPPEN] = "ups switch not happen";
    STR_USER_ERROR[-OB_UPS_SWITCH_NOT_HAPPEN] = "ups switch not happen";
    MYSQL_ERRNO[-OB_EMPTY_RESULT] = -1;
    SQLSTATE[-OB_EMPTY_RESULT] = "HY000";
    STR_ERROR[-OB_EMPTY_RESULT] = "Empty result";
    STR_USER_ERROR[-OB_EMPTY_RESULT] = "Empty result";
    MYSQL_ERRNO[-OB_CACHE_NOT_HIT] = -1;
    SQLSTATE[-OB_CACHE_NOT_HIT] = "HY000";
    STR_ERROR[-OB_CACHE_NOT_HIT] = "Cache not hit";
    STR_USER_ERROR[-OB_CACHE_NOT_HIT] = "Cache not hit";
    MYSQL_ERRNO[-OB_NESTED_LOOP_NOT_SUPPORT] = -1;
    SQLSTATE[-OB_NESTED_LOOP_NOT_SUPPORT] = "HY000";
    STR_ERROR[-OB_NESTED_LOOP_NOT_SUPPORT] = "Nested loop not support";
    STR_USER_ERROR[-OB_NESTED_LOOP_NOT_SUPPORT] = "Nested loop not support";
    MYSQL_ERRNO[-OB_LOG_INVALID_MOD_ID] = -1;
    SQLSTATE[-OB_LOG_INVALID_MOD_ID] = "HY000";
    STR_ERROR[-OB_LOG_INVALID_MOD_ID] = "Invalid log module id";
    STR_USER_ERROR[-OB_LOG_INVALID_MOD_ID] = "Invalid log module id";
    MYSQL_ERRNO[-OB_LOG_MODULE_UNKNOWN] = -1;
    SQLSTATE[-OB_LOG_MODULE_UNKNOWN] = "HY000";
    STR_ERROR[-OB_LOG_MODULE_UNKNOWN] = "Unknown module name";
    STR_USER_ERROR[-OB_LOG_MODULE_UNKNOWN] = "Unknown module name. Invalid Setting:'%.*s'. Syntax:parMod.subMod:level, parMod.subMod:level";
    MYSQL_ERRNO[-OB_LOG_LEVEL_INVALID] = -1;
    SQLSTATE[-OB_LOG_LEVEL_INVALID] = "HY000";
    STR_ERROR[-OB_LOG_LEVEL_INVALID] = "Invalid level";
    STR_USER_ERROR[-OB_LOG_LEVEL_INVALID] = "Invalid level. Invalid setting:'%.*s'. Syntax:parMod.subMod:level, parMod.subMod:level";
    MYSQL_ERRNO[-OB_LOG_PARSER_SYNTAX_ERR] = -1;
    SQLSTATE[-OB_LOG_PARSER_SYNTAX_ERR] = "HY000";
    STR_ERROR[-OB_LOG_PARSER_SYNTAX_ERR] = "Syntax to set log_level error";
    STR_USER_ERROR[-OB_LOG_PARSER_SYNTAX_ERR] = "Syntax to set log_level error. Invalid setting:'%.*s'. Syntax:parMod.subMod:level, parMod.subMod:level";
    MYSQL_ERRNO[-OB_INDEX_OUT_OF_RANGE] = -1;
    SQLSTATE[-OB_INDEX_OUT_OF_RANGE] = "HY000";
    STR_ERROR[-OB_INDEX_OUT_OF_RANGE] = "Index out of range";
    STR_USER_ERROR[-OB_INDEX_OUT_OF_RANGE] = "Index out of range";
    MYSQL_ERRNO[-OB_INT_UNDERFLOW] = -1;
    SQLSTATE[-OB_INT_UNDERFLOW] = "HY000";
    STR_ERROR[-OB_INT_UNDERFLOW] = "Int underflow";
    STR_USER_ERROR[-OB_INT_UNDERFLOW] = "Int underflow";
    MYSQL_ERRNO[-OB_UNKNOWN_CONNECTION] = ER_NO_SUCH_THREAD;
    SQLSTATE[-OB_UNKNOWN_CONNECTION] = "HY000";
    STR_ERROR[-OB_UNKNOWN_CONNECTION] = "Unknown thread id";
    STR_USER_ERROR[-OB_UNKNOWN_CONNECTION] = "Unknown thread id: %lu";
    MYSQL_ERRNO[-OB_ERROR_OUT_OF_RANGE] = -1;
    SQLSTATE[-OB_ERROR_OUT_OF_RANGE] = "42000";
    STR_ERROR[-OB_ERROR_OUT_OF_RANGE] = "Out of range";
    STR_USER_ERROR[-OB_ERROR_OUT_OF_RANGE] = "Out of range";
    MYSQL_ERRNO[-OB_CACHE_SHRINK_FAILED] = -1;
    SQLSTATE[-OB_CACHE_SHRINK_FAILED] = "HY001";
    STR_ERROR[-OB_CACHE_SHRINK_FAILED] = "shrink cache failed, no available cache";
    STR_USER_ERROR[-OB_CACHE_SHRINK_FAILED] = "shrink cache failed, no available cache";
    MYSQL_ERRNO[-OB_OLD_SCHEMA_VERSION] = -1;
    SQLSTATE[-OB_OLD_SCHEMA_VERSION] = "42000";
    STR_ERROR[-OB_OLD_SCHEMA_VERSION] = "Schema version too old";
    STR_USER_ERROR[-OB_OLD_SCHEMA_VERSION] = "Schema version too old";
    MYSQL_ERRNO[-OB_RELEASE_SCHEMA_ERROR] = -1;
    SQLSTATE[-OB_RELEASE_SCHEMA_ERROR] = "HY000";
    STR_ERROR[-OB_RELEASE_SCHEMA_ERROR] = "Release schema error";
    STR_USER_ERROR[-OB_RELEASE_SCHEMA_ERROR] = "Release schema error";
    MYSQL_ERRNO[-OB_OP_NOT_ALLOW] = -1;
    SQLSTATE[-OB_OP_NOT_ALLOW] = "HY000";
    STR_ERROR[-OB_OP_NOT_ALLOW] = "Operation not allowed now";
    STR_USER_ERROR[-OB_OP_NOT_ALLOW] = "%s not allowed";
    MYSQL_ERRNO[-OB_NO_EMPTY_ENTRY] = -1;
    SQLSTATE[-OB_NO_EMPTY_ENTRY] = "HY000";
    STR_ERROR[-OB_NO_EMPTY_ENTRY] = "No empty entry";
    STR_USER_ERROR[-OB_NO_EMPTY_ENTRY] = "No empty entry";
    MYSQL_ERRNO[-OB_ERR_ALREADY_EXISTS] = -1;
    SQLSTATE[-OB_ERR_ALREADY_EXISTS] = "42S01";
    STR_ERROR[-OB_ERR_ALREADY_EXISTS] = "Already exist";
    STR_USER_ERROR[-OB_ERR_ALREADY_EXISTS] = "Already exist";
    MYSQL_ERRNO[-OB_SEARCH_NOT_FOUND] = -1;
    SQLSTATE[-OB_SEARCH_NOT_FOUND] = "HY000";
    STR_ERROR[-OB_SEARCH_NOT_FOUND] = "Value not found";
    STR_USER_ERROR[-OB_SEARCH_NOT_FOUND] = "Value not found";
    MYSQL_ERRNO[-OB_BEYOND_THE_RANGE] = -1;
    SQLSTATE[-OB_BEYOND_THE_RANGE] = "HY000";
    STR_ERROR[-OB_BEYOND_THE_RANGE] = "Key out of range";
    STR_USER_ERROR[-OB_BEYOND_THE_RANGE] = "Key out of range";
    MYSQL_ERRNO[-OB_CS_OUTOF_DISK_SPACE] = -1;
    SQLSTATE[-OB_CS_OUTOF_DISK_SPACE] = "53100";
    STR_ERROR[-OB_CS_OUTOF_DISK_SPACE] = "ChunkServer out of disk space";
    STR_USER_ERROR[-OB_CS_OUTOF_DISK_SPACE] = "ChunkServer out of disk space";
    MYSQL_ERRNO[-OB_COLUMN_GROUP_NOT_FOUND] = -1;
    SQLSTATE[-OB_COLUMN_GROUP_NOT_FOUND] = "HY000";
    STR_ERROR[-OB_COLUMN_GROUP_NOT_FOUND] = "Column group not found";
    STR_USER_ERROR[-OB_COLUMN_GROUP_NOT_FOUND] = "Column group not found";
    MYSQL_ERRNO[-OB_CS_COMPRESS_LIB_ERROR] = -1;
    SQLSTATE[-OB_CS_COMPRESS_LIB_ERROR] = "HY000";
    STR_ERROR[-OB_CS_COMPRESS_LIB_ERROR] = "ChunkServer failed to get compress library";
    STR_USER_ERROR[-OB_CS_COMPRESS_LIB_ERROR] = "ChunkServer failed to get compress library";
    MYSQL_ERRNO[-OB_ITEM_NOT_MATCH] = -1;
    SQLSTATE[-OB_ITEM_NOT_MATCH] = "HY000";
    STR_ERROR[-OB_ITEM_NOT_MATCH] = "Item not match";
    STR_USER_ERROR[-OB_ITEM_NOT_MATCH] = "Item not match";
    MYSQL_ERRNO[-OB_INVALID_DATE_FORMAT_END] = ER_TRUNCATED_WRONG_VALUE;
    SQLSTATE[-OB_INVALID_DATE_FORMAT_END] = "22007";
    STR_ERROR[-OB_INVALID_DATE_FORMAT_END] = "Incorrect value";
    STR_USER_ERROR[-OB_INVALID_DATE_FORMAT_END] = "Incorrect value";
    MYSQL_ERRNO[-OB_HASH_EXIST] = -1;
    SQLSTATE[-OB_HASH_EXIST] = "HY000";
    STR_ERROR[-OB_HASH_EXIST] = "hash map/set entry exist";
    STR_USER_ERROR[-OB_HASH_EXIST] = "hash map/set entry exist";
    MYSQL_ERRNO[-OB_HASH_NOT_EXIST] = -1;
    SQLSTATE[-OB_HASH_NOT_EXIST] = "HY000";
    STR_ERROR[-OB_HASH_NOT_EXIST] = "hash map/set entry not exist";
    STR_USER_ERROR[-OB_HASH_NOT_EXIST] = "hash map/set entry not exist";
    MYSQL_ERRNO[-OB_HASH_GET_TIMEOUT] = -1;
    SQLSTATE[-OB_HASH_GET_TIMEOUT] = "HY000";
    STR_ERROR[-OB_HASH_GET_TIMEOUT] = "hash map/set get timeout";
    STR_USER_ERROR[-OB_HASH_GET_TIMEOUT] = "hash map/set get timeout";
    MYSQL_ERRNO[-OB_HASH_PLACEMENT_RETRY] = -1;
    SQLSTATE[-OB_HASH_PLACEMENT_RETRY] = "HY000";
    STR_ERROR[-OB_HASH_PLACEMENT_RETRY] = "hash map/set retry";
    STR_USER_ERROR[-OB_HASH_PLACEMENT_RETRY] = "hash map/set retry";
    MYSQL_ERRNO[-OB_HASH_FULL] = -1;
    SQLSTATE[-OB_HASH_FULL] = "HY000";
    STR_ERROR[-OB_HASH_FULL] = "hash map/set full";
    STR_USER_ERROR[-OB_HASH_FULL] = "hash map/set full";
    MYSQL_ERRNO[-OB_PACKET_PROCESSED] = -1;
    SQLSTATE[-OB_PACKET_PROCESSED] = "HY000";
    STR_ERROR[-OB_PACKET_PROCESSED] = "packet processed";
    STR_USER_ERROR[-OB_PACKET_PROCESSED] = "packet processed";
    MYSQL_ERRNO[-OB_WAIT_NEXT_TIMEOUT] = -1;
    SQLSTATE[-OB_WAIT_NEXT_TIMEOUT] = "HY000";
    STR_ERROR[-OB_WAIT_NEXT_TIMEOUT] = "wait next packet timeout";
    STR_USER_ERROR[-OB_WAIT_NEXT_TIMEOUT] = "wait next packet timeout";
    MYSQL_ERRNO[-OB_LEADER_NOT_EXIST] = -1;
    SQLSTATE[-OB_LEADER_NOT_EXIST] = "HY000";
    STR_ERROR[-OB_LEADER_NOT_EXIST] = "partition has not leader";
    STR_USER_ERROR[-OB_LEADER_NOT_EXIST] = "partition has not leader";
    MYSQL_ERRNO[-OB_PREPARE_MAJOR_FREEZE_FAILED] = -1;
    SQLSTATE[-OB_PREPARE_MAJOR_FREEZE_FAILED] = "HY000";
    STR_ERROR[-OB_PREPARE_MAJOR_FREEZE_FAILED] = "prepare major freeze failed";
    STR_USER_ERROR[-OB_PREPARE_MAJOR_FREEZE_FAILED] = "prepare major freeze failed";
    MYSQL_ERRNO[-OB_COMMIT_MAJOR_FREEZE_FAILED] = -1;
    SQLSTATE[-OB_COMMIT_MAJOR_FREEZE_FAILED] = "HY000";
    STR_ERROR[-OB_COMMIT_MAJOR_FREEZE_FAILED] = "commit major freeze failed";
    STR_USER_ERROR[-OB_COMMIT_MAJOR_FREEZE_FAILED] = "commit major freeze failed";
    MYSQL_ERRNO[-OB_ABORT_MAJOR_FREEZE_FAILED] = -1;
    SQLSTATE[-OB_ABORT_MAJOR_FREEZE_FAILED] = "HY000";
    STR_ERROR[-OB_ABORT_MAJOR_FREEZE_FAILED] = "abort major freeze failed";
    STR_USER_ERROR[-OB_ABORT_MAJOR_FREEZE_FAILED] = "abort major freeze failed";
    MYSQL_ERRNO[-OB_MAJOR_FREEZE_NOT_FINISHED] = -1;
    SQLSTATE[-OB_MAJOR_FREEZE_NOT_FINISHED] = "HY000";
    STR_ERROR[-OB_MAJOR_FREEZE_NOT_FINISHED] = "last major freeze not finish";
    STR_USER_ERROR[-OB_MAJOR_FREEZE_NOT_FINISHED] = "last major freeze not finish";
    MYSQL_ERRNO[-OB_PARTITION_NOT_LEADER] = -1;
    SQLSTATE[-OB_PARTITION_NOT_LEADER] = "HY000";
    STR_ERROR[-OB_PARTITION_NOT_LEADER] = "partition is not leader partition";
    STR_USER_ERROR[-OB_PARTITION_NOT_LEADER] = "partition is not leader partition";
    MYSQL_ERRNO[-OB_WAIT_MAJOR_FREEZE_RESPONSE_TIMEOUT] = -1;
    SQLSTATE[-OB_WAIT_MAJOR_FREEZE_RESPONSE_TIMEOUT] = "HY000";
    STR_ERROR[-OB_WAIT_MAJOR_FREEZE_RESPONSE_TIMEOUT] = "wait major freeze response timeout";
    STR_USER_ERROR[-OB_WAIT_MAJOR_FREEZE_RESPONSE_TIMEOUT] = "wait major freeze response timeout";
    MYSQL_ERRNO[-OB_CURL_ERROR] = -1;
    SQLSTATE[-OB_CURL_ERROR] = "HY000";
    STR_ERROR[-OB_CURL_ERROR] = "curl error";
    STR_USER_ERROR[-OB_CURL_ERROR] = "curl error";
    MYSQL_ERRNO[-OB_MAJOR_FREEZE_NOT_ALLOW] = -1;
    SQLSTATE[-OB_MAJOR_FREEZE_NOT_ALLOW] = "HY000";
    STR_ERROR[-OB_MAJOR_FREEZE_NOT_ALLOW] = "Major freeze not allowed now";
    STR_USER_ERROR[-OB_MAJOR_FREEZE_NOT_ALLOW] = "%s";
    MYSQL_ERRNO[-OB_PREPARE_FREEZE_FAILED] = -1;
    SQLSTATE[-OB_PREPARE_FREEZE_FAILED] = "HY000";
    STR_ERROR[-OB_PREPARE_FREEZE_FAILED] = "prepare freeze failed";
    STR_USER_ERROR[-OB_PREPARE_FREEZE_FAILED] = "prepare freeze failed";
    MYSQL_ERRNO[-OB_INVALID_DATE_VALUE] = ER_TRUNCATED_WRONG_VALUE;
    SQLSTATE[-OB_INVALID_DATE_VALUE] = "22007";
    STR_ERROR[-OB_INVALID_DATE_VALUE] = "Incorrect value";
    STR_USER_ERROR[-OB_INVALID_DATE_VALUE] = "Incorrect datetime value: '%s' for column '%s' at row %d";
    MYSQL_ERRNO[-OB_INACTIVE_SQL_CLIENT] = -1;
    SQLSTATE[-OB_INACTIVE_SQL_CLIENT] = "HY000";
    STR_ERROR[-OB_INACTIVE_SQL_CLIENT] = "Inactive sql client, only read allowed";
    STR_USER_ERROR[-OB_INACTIVE_SQL_CLIENT] = "Inactive sql client, only read allowed";
    MYSQL_ERRNO[-OB_INACTIVE_RPC_PROXY] = -1;
    SQLSTATE[-OB_INACTIVE_RPC_PROXY] = "HY000";
    STR_ERROR[-OB_INACTIVE_RPC_PROXY] = "Inactive rpc proxy, can not send RPC request";
    STR_USER_ERROR[-OB_INACTIVE_RPC_PROXY] = "Inactive rpc proxy, can not send RPC request";
    MYSQL_ERRNO[-OB_INTERVAL_WITH_MONTH] = -1;
    SQLSTATE[-OB_INTERVAL_WITH_MONTH] = "42000";
    STR_ERROR[-OB_INTERVAL_WITH_MONTH] = "Interval with year or month can not be converted to microseconds";
    STR_USER_ERROR[-OB_INTERVAL_WITH_MONTH] = "Interval with year or month can not be converted to microseconds";
    MYSQL_ERRNO[-OB_TOO_MANY_DATETIME_PARTS] = -1;
    SQLSTATE[-OB_TOO_MANY_DATETIME_PARTS] = "42000";
    STR_ERROR[-OB_TOO_MANY_DATETIME_PARTS] = "Interval has too many datetime parts";
    STR_USER_ERROR[-OB_TOO_MANY_DATETIME_PARTS] = "Interval has too many datetime parts";
    MYSQL_ERRNO[-OB_DATA_OUT_OF_RANGE] = ER_WARN_DATA_OUT_OF_RANGE;
    SQLSTATE[-OB_DATA_OUT_OF_RANGE] = "22003";
    STR_ERROR[-OB_DATA_OUT_OF_RANGE] = "Out of range value for column";
    STR_USER_ERROR[-OB_DATA_OUT_OF_RANGE] = "Out of range value for column '%.*s' at row %lld";
    MYSQL_ERRNO[-OB_PARTITION_NOT_EXIST] = -1;
    SQLSTATE[-OB_PARTITION_NOT_EXIST] = "HY000";
    STR_ERROR[-OB_PARTITION_NOT_EXIST] = "Partition entry not exists";
    STR_USER_ERROR[-OB_PARTITION_NOT_EXIST] = "Partition entry not exists";
    MYSQL_ERRNO[-OB_ERR_TRUNCATED_WRONG_VALUE_FOR_FIELD] = ER_TRUNCATED_WRONG_VALUE_FOR_FIELD;
    SQLSTATE[-OB_ERR_TRUNCATED_WRONG_VALUE_FOR_FIELD] = "HY000";
    STR_ERROR[-OB_ERR_TRUNCATED_WRONG_VALUE_FOR_FIELD] = "Incorrect integer value";
    STR_USER_ERROR[-OB_ERR_TRUNCATED_WRONG_VALUE_FOR_FIELD] = "Incorrect integer value: '%.*s'";
    MYSQL_ERRNO[-OB_ERR_NO_DEFAULT_FOR_FIELD] = ER_NO_DEFAULT_FOR_FIELD;
    SQLSTATE[-OB_ERR_NO_DEFAULT_FOR_FIELD] = "HY000";
    STR_ERROR[-OB_ERR_NO_DEFAULT_FOR_FIELD] = "Field doesn't have a default value";
    STR_USER_ERROR[-OB_ERR_NO_DEFAULT_FOR_FIELD] = "Field \'%s\' doesn't have a default value";
    MYSQL_ERRNO[-OB_ERR_FIELD_SPECIFIED_TWICE] = ER_FIELD_SPECIFIED_TWICE;
    SQLSTATE[-OB_ERR_FIELD_SPECIFIED_TWICE] = "42000";
    STR_ERROR[-OB_ERR_FIELD_SPECIFIED_TWICE] = "Column specified twice";
    STR_USER_ERROR[-OB_ERR_FIELD_SPECIFIED_TWICE] = "Column \'%s\' specified twice";
    MYSQL_ERRNO[-OB_ERR_TOO_LONG_TABLE_COMMENT] = ER_TOO_LONG_TABLE_COMMENT;
    SQLSTATE[-OB_ERR_TOO_LONG_TABLE_COMMENT] = "HY000";
    STR_ERROR[-OB_ERR_TOO_LONG_TABLE_COMMENT] = "Comment for table is too long";
    STR_USER_ERROR[-OB_ERR_TOO_LONG_TABLE_COMMENT] = "Comment for table is too long (max = %ld)";
    MYSQL_ERRNO[-OB_ERR_TOO_LONG_FIELD_COMMENT] = ER_TOO_LONG_FIELD_COMMENT;
    SQLSTATE[-OB_ERR_TOO_LONG_FIELD_COMMENT] = "HY000";
    STR_ERROR[-OB_ERR_TOO_LONG_FIELD_COMMENT] = "Comment for field is too long";
    STR_USER_ERROR[-OB_ERR_TOO_LONG_FIELD_COMMENT] = "Comment for field is too long (max = %ld)";
    MYSQL_ERRNO[-OB_ERR_TOO_LONG_INDEX_COMMENT] = ER_TOO_LONG_INDEX_COMMENT;
    SQLSTATE[-OB_ERR_TOO_LONG_INDEX_COMMENT] = "HY000";
    STR_ERROR[-OB_ERR_TOO_LONG_INDEX_COMMENT] = "Comment for index is too long";
    STR_USER_ERROR[-OB_ERR_TOO_LONG_INDEX_COMMENT] = "Comment for index is too long (max = %ld)";
    MYSQL_ERRNO[-OB_NOT_FOLLOWER] = -1;
    SQLSTATE[-OB_NOT_FOLLOWER] = "HY000";
    STR_ERROR[-OB_NOT_FOLLOWER] = "The observer or zone is not a follower";
    STR_USER_ERROR[-OB_NOT_FOLLOWER] = "The observer or zone is not a follower";
    MYSQL_ERRNO[-OB_ERR_OUT_OF_LOWER_BOUND] = -1;
    SQLSTATE[-OB_ERR_OUT_OF_LOWER_BOUND] = "HY000";
    STR_ERROR[-OB_ERR_OUT_OF_LOWER_BOUND] = "smaller than container lower bound";
    STR_USER_ERROR[-OB_ERR_OUT_OF_LOWER_BOUND] = "smaller than container lower bound";
    MYSQL_ERRNO[-OB_ERR_OUT_OF_UPPER_BOUND] = -1;
    SQLSTATE[-OB_ERR_OUT_OF_UPPER_BOUND] = "HY000";
    STR_ERROR[-OB_ERR_OUT_OF_UPPER_BOUND] = "bigger than container upper bound";
    STR_USER_ERROR[-OB_ERR_OUT_OF_UPPER_BOUND] = "bigger than container upper bound";
    MYSQL_ERRNO[-OB_BAD_NULL_ERROR] = ER_BAD_NULL_ERROR;
    SQLSTATE[-OB_BAD_NULL_ERROR] = "23000";
    STR_ERROR[-OB_BAD_NULL_ERROR] = "Column cannot be null";
    STR_USER_ERROR[-OB_BAD_NULL_ERROR] = "Column '%.*s' cannot be null";
    MYSQL_ERRNO[-OB_OBCONFIG_RETURN_ERROR] = -1;
    SQLSTATE[-OB_OBCONFIG_RETURN_ERROR] = "HY000";
    STR_ERROR[-OB_OBCONFIG_RETURN_ERROR] = "ObConfig return error code";
    STR_USER_ERROR[-OB_OBCONFIG_RETURN_ERROR] = "ObConfig return error code";
    MYSQL_ERRNO[-OB_OBCONFIG_APPNAME_MISMATCH] = -1;
    SQLSTATE[-OB_OBCONFIG_APPNAME_MISMATCH] = "HY000";
    STR_ERROR[-OB_OBCONFIG_APPNAME_MISMATCH] = "Appname mismatch with obconfig result";
    STR_USER_ERROR[-OB_OBCONFIG_APPNAME_MISMATCH] = "Appname mismatch with obconfig result";
    MYSQL_ERRNO[-OB_ERR_VIEW_SELECT_DERIVED] = ER_VIEW_SELECT_DERIVED;
    SQLSTATE[-OB_ERR_VIEW_SELECT_DERIVED] = "HY000";
    STR_ERROR[-OB_ERR_VIEW_SELECT_DERIVED] = "View's SELECT contains a subquery in the FROM clause";
    STR_USER_ERROR[-OB_ERR_VIEW_SELECT_DERIVED] = "View's SELECT contains a subquery in the FROM clause";
    MYSQL_ERRNO[-OB_CANT_MJ_PATH] = -1;
    SQLSTATE[-OB_CANT_MJ_PATH] = "HY000";
    STR_ERROR[-OB_CANT_MJ_PATH] = "Can not use merge-join to join the tables without join conditions";
    STR_USER_ERROR[-OB_CANT_MJ_PATH] = "Can not use merge-join to join the tables without join conditions";
    MYSQL_ERRNO[-OB_ERR_NO_JOIN_ORDER_GENERATED] = -1;
    SQLSTATE[-OB_ERR_NO_JOIN_ORDER_GENERATED] = "HY000";
    STR_ERROR[-OB_ERR_NO_JOIN_ORDER_GENERATED] = "No join order generated";
    STR_USER_ERROR[-OB_ERR_NO_JOIN_ORDER_GENERATED] = "No join order generated";
    MYSQL_ERRNO[-OB_ERR_NO_PATH_GENERATED] = -1;
    SQLSTATE[-OB_ERR_NO_PATH_GENERATED] = "HY000";
    STR_ERROR[-OB_ERR_NO_PATH_GENERATED] = "No join path generated";
    STR_USER_ERROR[-OB_ERR_NO_PATH_GENERATED] = "No join path generated";
    MYSQL_ERRNO[-OB_ERR_WAIT_REMOTE_SCHEMA_REFRESH] = -1;
    SQLSTATE[-OB_ERR_WAIT_REMOTE_SCHEMA_REFRESH] = "HY000";
    STR_ERROR[-OB_ERR_WAIT_REMOTE_SCHEMA_REFRESH] = "Schema error";
    STR_USER_ERROR[-OB_ERR_WAIT_REMOTE_SCHEMA_REFRESH] = "Schema error";
    MYSQL_ERRNO[-OB_FILE_NOT_OPENED] = -1;
    SQLSTATE[-OB_FILE_NOT_OPENED] = "HY000";
    STR_ERROR[-OB_FILE_NOT_OPENED] = "file not opened";
    STR_USER_ERROR[-OB_FILE_NOT_OPENED] = "file not opened";
    MYSQL_ERRNO[-OB_TIMER_TASK_HAS_SCHEDULED] = -1;
    SQLSTATE[-OB_TIMER_TASK_HAS_SCHEDULED] = "HY000";
    STR_ERROR[-OB_TIMER_TASK_HAS_SCHEDULED] = "Timer task has been scheduled";
    STR_USER_ERROR[-OB_TIMER_TASK_HAS_SCHEDULED] = "Timer task has been scheduled";
    MYSQL_ERRNO[-OB_TIMER_TASK_HAS_NOT_SCHEDULED] = -1;
    SQLSTATE[-OB_TIMER_TASK_HAS_NOT_SCHEDULED] = "HY000";
    STR_ERROR[-OB_TIMER_TASK_HAS_NOT_SCHEDULED] = "Timer task has not been scheduled";
    STR_USER_ERROR[-OB_TIMER_TASK_HAS_NOT_SCHEDULED] = "Timer task has not been scheduled";
    MYSQL_ERRNO[-OB_PARSE_DEBUG_SYNC_ERROR] = -1;
    SQLSTATE[-OB_PARSE_DEBUG_SYNC_ERROR] = "HY000";
    STR_ERROR[-OB_PARSE_DEBUG_SYNC_ERROR] = "parse debug sync string error";
    STR_USER_ERROR[-OB_PARSE_DEBUG_SYNC_ERROR] = "parse debug sync string error";
    MYSQL_ERRNO[-OB_UNKNOWN_DEBUG_SYNC_POINT] = -1;
    SQLSTATE[-OB_UNKNOWN_DEBUG_SYNC_POINT] = "HY000";
    STR_ERROR[-OB_UNKNOWN_DEBUG_SYNC_POINT] = "unknown debug sync point";
    STR_USER_ERROR[-OB_UNKNOWN_DEBUG_SYNC_POINT] = "unknown debug sync point";
    MYSQL_ERRNO[-OB_ERR_INTERRUPTED] = -1;
    SQLSTATE[-OB_ERR_INTERRUPTED] = "HY000";
    STR_ERROR[-OB_ERR_INTERRUPTED] = "task is interrupted while running";
    STR_USER_ERROR[-OB_ERR_INTERRUPTED] = "task is interrupted while running";
    MYSQL_ERRNO[-OB_ERR_DATA_TRUNCATED] = WARN_DATA_TRUNCATED;
    SQLSTATE[-OB_ERR_DATA_TRUNCATED] = "01000";
    STR_ERROR[-OB_ERR_DATA_TRUNCATED] = "Data truncated for argument";
    STR_USER_ERROR[-OB_ERR_DATA_TRUNCATED] = "Data truncated for argument";
    MYSQL_ERRNO[-OB_NOT_RUNNING] = -1;
    SQLSTATE[-OB_NOT_RUNNING] = "HY000";
    STR_ERROR[-OB_NOT_RUNNING] = "module is not running";
    STR_USER_ERROR[-OB_NOT_RUNNING] = "module is not running";
    MYSQL_ERRNO[-OB_INVALID_PARTITION] = -1;
    SQLSTATE[-OB_INVALID_PARTITION] = "HY000";
    STR_ERROR[-OB_INVALID_PARTITION] = "partition not valid";
    STR_USER_ERROR[-OB_INVALID_PARTITION] = "partition not valid";
    MYSQL_ERRNO[-OB_ERR_TIMEOUT_TRUNCATED] = WARN_DATA_TRUNCATED;
    SQLSTATE[-OB_ERR_TIMEOUT_TRUNCATED] = "01000";
    STR_ERROR[-OB_ERR_TIMEOUT_TRUNCATED] = "Timeout value truncated to 102 years";
    STR_USER_ERROR[-OB_ERR_TIMEOUT_TRUNCATED] = "Timeout value truncated to 102 years";
    MYSQL_ERRNO[-OB_ERR_TOO_LONG_TENANT_COMMENT] = -1;
    SQLSTATE[-OB_ERR_TOO_LONG_TENANT_COMMENT] = "HY000";
    STR_ERROR[-OB_ERR_TOO_LONG_TENANT_COMMENT] = "Comment for tenant is too long";
    STR_USER_ERROR[-OB_ERR_TOO_LONG_TENANT_COMMENT] = "Comment for tenant is too long (max = %ld)";
    MYSQL_ERRNO[-OB_ERR_NET_PACKET_TOO_LARGE] = ER_NET_PACKET_TOO_LARGE;
    SQLSTATE[-OB_ERR_NET_PACKET_TOO_LARGE] = "08S01";
    STR_ERROR[-OB_ERR_NET_PACKET_TOO_LARGE] = "Got a packet bigger than \'max_allowed_packet\' bytes";
    STR_USER_ERROR[-OB_ERR_NET_PACKET_TOO_LARGE] = "Got a packet bigger than \'max_allowed_packet\' bytes";
    MYSQL_ERRNO[-OB_TRACE_DESC_NOT_EXIST] = -1;
    SQLSTATE[-OB_TRACE_DESC_NOT_EXIST] = "HY000";
    STR_ERROR[-OB_TRACE_DESC_NOT_EXIST] = "trace log title or key not exist describle";
    STR_USER_ERROR[-OB_TRACE_DESC_NOT_EXIST] = "trace log title or key not exist describle";
    MYSQL_ERRNO[-OB_ERR_NO_DEFAULT] = ER_NO_DEFAULT;
    SQLSTATE[-OB_ERR_NO_DEFAULT] = "42000";
    STR_ERROR[-OB_ERR_NO_DEFAULT] = "Variable doesn't have a default value";
    STR_USER_ERROR[-OB_ERR_NO_DEFAULT] = "Variable '%.*s' doesn't have a default value";
    MYSQL_ERRNO[-OB_ERR_COMPRESS_DECOMPRESS_DATA] = -1;
    SQLSTATE[-OB_ERR_COMPRESS_DECOMPRESS_DATA] = "HY000";
    STR_ERROR[-OB_ERR_COMPRESS_DECOMPRESS_DATA] = "compress data or decompress data failed";
    STR_USER_ERROR[-OB_ERR_COMPRESS_DECOMPRESS_DATA] = "compress data or decompress data failed";
    MYSQL_ERRNO[-OB_ERR_INCORRECT_STRING_VALUE] = ER_TRUNCATED_WRONG_VALUE_FOR_FIELD;
    SQLSTATE[-OB_ERR_INCORRECT_STRING_VALUE] = "HY000";
    STR_ERROR[-OB_ERR_INCORRECT_STRING_VALUE] = "Incorrect string value";
    STR_USER_ERROR[-OB_ERR_INCORRECT_STRING_VALUE] = "Incorrect string value for column '%.*s' at row %lld";
    MYSQL_ERRNO[-OB_ERR_DISTRIBUTED_NOT_SUPPORTED] = ER_NOT_SUPPORTED_YET;
    SQLSTATE[-OB_ERR_DISTRIBUTED_NOT_SUPPORTED] = "0A000";
    STR_ERROR[-OB_ERR_DISTRIBUTED_NOT_SUPPORTED] = "Distributed Not supported feature or function";
    STR_USER_ERROR[-OB_ERR_DISTRIBUTED_NOT_SUPPORTED] = "%s not supported";
    MYSQL_ERRNO[-OB_IS_CHANGING_LEADER] = -1;
    SQLSTATE[-OB_IS_CHANGING_LEADER] = "HY000";
    STR_ERROR[-OB_IS_CHANGING_LEADER] = "the partition is changing leader";
    STR_USER_ERROR[-OB_IS_CHANGING_LEADER] = "the partition is changing leader";
    MYSQL_ERRNO[-OB_DATETIME_FUNCTION_OVERFLOW] = ER_DATETIME_FUNCTION_OVERFLOW;
    SQLSTATE[-OB_DATETIME_FUNCTION_OVERFLOW] = "22008";
    STR_ERROR[-OB_DATETIME_FUNCTION_OVERFLOW] = "Datetime overflow";
    STR_USER_ERROR[-OB_DATETIME_FUNCTION_OVERFLOW] = "Datetime overflow";
    MYSQL_ERRNO[-OB_ERR_DOUBLE_TRUNCATED] = ER_TRUNCATED_WRONG_VALUE;
    SQLSTATE[-OB_ERR_DOUBLE_TRUNCATED] = "01000";
    STR_ERROR[-OB_ERR_DOUBLE_TRUNCATED] = "Truncated incorrect DOUBLE value";
    STR_USER_ERROR[-OB_ERR_DOUBLE_TRUNCATED] = "Truncated incorrect DOUBLE value: '%.*s'";
    MYSQL_ERRNO[-OB_MINOR_FREEZE_NOT_ALLOW] = -1;
    SQLSTATE[-OB_MINOR_FREEZE_NOT_ALLOW] = "HY000";
    STR_ERROR[-OB_MINOR_FREEZE_NOT_ALLOW] = "Minor freeze not allowed now";
    STR_USER_ERROR[-OB_MINOR_FREEZE_NOT_ALLOW] = "%s";
    MYSQL_ERRNO[-OB_LOG_OUTOF_DISK_SPACE] = -1;
    SQLSTATE[-OB_LOG_OUTOF_DISK_SPACE] = "HY000";
    STR_ERROR[-OB_LOG_OUTOF_DISK_SPACE] = "Log out of disk space";
    STR_USER_ERROR[-OB_LOG_OUTOF_DISK_SPACE] = "Log out of disk space";
    MYSQL_ERRNO[-OB_IMPORT_NOT_IN_SERVER] = -1;
    SQLSTATE[-OB_IMPORT_NOT_IN_SERVER] = "HY000";
    STR_ERROR[-OB_IMPORT_NOT_IN_SERVER] = "Import not in service";
    STR_USER_ERROR[-OB_IMPORT_NOT_IN_SERVER] = "Import not in service";
    MYSQL_ERRNO[-OB_CONVERT_ERROR] = -1;
    SQLSTATE[-OB_CONVERT_ERROR] = "42000";
    STR_ERROR[-OB_CONVERT_ERROR] = "Convert error";
    STR_USER_ERROR[-OB_CONVERT_ERROR] = "Convert error";
    MYSQL_ERRNO[-OB_BYPASS_TIMEOUT] = -1;
    SQLSTATE[-OB_BYPASS_TIMEOUT] = "HY000";
    STR_ERROR[-OB_BYPASS_TIMEOUT] = "Bypass timeout";
    STR_USER_ERROR[-OB_BYPASS_TIMEOUT] = "Bypass timeout";
    MYSQL_ERRNO[-OB_RS_STATE_NOT_ALLOW] = -1;
    SQLSTATE[-OB_RS_STATE_NOT_ALLOW] = "HY000";
    STR_ERROR[-OB_RS_STATE_NOT_ALLOW] = "RootServer state error";
    STR_USER_ERROR[-OB_RS_STATE_NOT_ALLOW] = "RootServer state error";
    MYSQL_ERRNO[-OB_NO_REPLICA_VALID] = -1;
    SQLSTATE[-OB_NO_REPLICA_VALID] = "HY000";
    STR_ERROR[-OB_NO_REPLICA_VALID] = "No replica is valid";
    STR_USER_ERROR[-OB_NO_REPLICA_VALID] = "No replica is valid";
    MYSQL_ERRNO[-OB_NO_NEED_UPDATE] = -1;
    SQLSTATE[-OB_NO_NEED_UPDATE] = "HY000";
    STR_ERROR[-OB_NO_NEED_UPDATE] = "No need to update";
    STR_USER_ERROR[-OB_NO_NEED_UPDATE] = "No need to update";
    MYSQL_ERRNO[-OB_CACHE_TIMEOUT] = -1;
    SQLSTATE[-OB_CACHE_TIMEOUT] = "HY000";
    STR_ERROR[-OB_CACHE_TIMEOUT] = "Cache timeout";
    STR_USER_ERROR[-OB_CACHE_TIMEOUT] = "Cache timeout";
    MYSQL_ERRNO[-OB_ITER_STOP] = -1;
    SQLSTATE[-OB_ITER_STOP] = "HY000";
    STR_ERROR[-OB_ITER_STOP] = "Iteration was stopped";
    STR_USER_ERROR[-OB_ITER_STOP] = "Iteration was stopped";
    MYSQL_ERRNO[-OB_ZONE_ALREADY_MASTER] = -1;
    SQLSTATE[-OB_ZONE_ALREADY_MASTER] = "HY000";
    STR_ERROR[-OB_ZONE_ALREADY_MASTER] = "The zone is the master already";
    STR_USER_ERROR[-OB_ZONE_ALREADY_MASTER] = "The zone is the master already";
    MYSQL_ERRNO[-OB_IP_PORT_IS_NOT_SLAVE_ZONE] = -1;
    SQLSTATE[-OB_IP_PORT_IS_NOT_SLAVE_ZONE] = "HY000";
    STR_ERROR[-OB_IP_PORT_IS_NOT_SLAVE_ZONE] = "Not slave zone";
    STR_USER_ERROR[-OB_IP_PORT_IS_NOT_SLAVE_ZONE] = "Not slave zone";
    MYSQL_ERRNO[-OB_ZONE_IS_NOT_SLAVE] = -1;
    SQLSTATE[-OB_ZONE_IS_NOT_SLAVE] = "HY000";
    STR_ERROR[-OB_ZONE_IS_NOT_SLAVE] = "Not slave zone";
    STR_USER_ERROR[-OB_ZONE_IS_NOT_SLAVE] = "Not slave zone";
    MYSQL_ERRNO[-OB_ZONE_IS_NOT_MASTER] = -1;
    SQLSTATE[-OB_ZONE_IS_NOT_MASTER] = "HY000";
    STR_ERROR[-OB_ZONE_IS_NOT_MASTER] = "Not master zone";
    STR_USER_ERROR[-OB_ZONE_IS_NOT_MASTER] = "Not master zone";
    MYSQL_ERRNO[-OB_CONFIG_NOT_SYNC] = -1;
    SQLSTATE[-OB_CONFIG_NOT_SYNC] = "F0000";
    STR_ERROR[-OB_CONFIG_NOT_SYNC] = "Configuration not sync";
    STR_USER_ERROR[-OB_CONFIG_NOT_SYNC] = "Configuration not sync";
    MYSQL_ERRNO[-OB_IP_PORT_IS_NOT_ZONE] = -1;
    SQLSTATE[-OB_IP_PORT_IS_NOT_ZONE] = "42000";
    STR_ERROR[-OB_IP_PORT_IS_NOT_ZONE] = "Not a zone address";
    STR_USER_ERROR[-OB_IP_PORT_IS_NOT_ZONE] = "Not a zone address";
    MYSQL_ERRNO[-OB_MASTER_ZONE_NOT_EXIST] = -1;
    SQLSTATE[-OB_MASTER_ZONE_NOT_EXIST] = "HY000";
    STR_ERROR[-OB_MASTER_ZONE_NOT_EXIST] = "Master zone not exist";
    STR_USER_ERROR[-OB_MASTER_ZONE_NOT_EXIST] = "Master zone not exist";
    MYSQL_ERRNO[-OB_ZONE_INFO_NOT_EXIST] = -1;
    SQLSTATE[-OB_ZONE_INFO_NOT_EXIST] = "HY000";
    STR_ERROR[-OB_ZONE_INFO_NOT_EXIST] = "Zone info not exist";
    STR_USER_ERROR[-OB_ZONE_INFO_NOT_EXIST] = "Zone info \'%s\' not exist";
    MYSQL_ERRNO[-OB_GET_ZONE_MASTER_UPS_FAILED] = -1;
    SQLSTATE[-OB_GET_ZONE_MASTER_UPS_FAILED] = "HY000";
    STR_ERROR[-OB_GET_ZONE_MASTER_UPS_FAILED] = "Failed to get master UpdateServer";
    STR_USER_ERROR[-OB_GET_ZONE_MASTER_UPS_FAILED] = "Failed to get master UpdateServer";
    MYSQL_ERRNO[-OB_MULTIPLE_MASTER_ZONES_EXIST] = -1;
    SQLSTATE[-OB_MULTIPLE_MASTER_ZONES_EXIST] = "HY000";
    STR_ERROR[-OB_MULTIPLE_MASTER_ZONES_EXIST] = "Multiple master zones";
    STR_USER_ERROR[-OB_MULTIPLE_MASTER_ZONES_EXIST] = "Multiple master zones";
    MYSQL_ERRNO[-OB_INDEXING_ZONE_INVALID] = -1;
    SQLSTATE[-OB_INDEXING_ZONE_INVALID] = "HY000";
    STR_ERROR[-OB_INDEXING_ZONE_INVALID] = "indexing zone is not exist anymore or not active";
    STR_USER_ERROR[-OB_INDEXING_ZONE_INVALID] = "indexing zone is not exist anymore or not active";
    MYSQL_ERRNO[-OB_ROOT_TABLE_RANGE_NOT_EXIST] = -1;
    SQLSTATE[-OB_ROOT_TABLE_RANGE_NOT_EXIST] = "HY000";
    STR_ERROR[-OB_ROOT_TABLE_RANGE_NOT_EXIST] = "Tablet range not exist";
    STR_USER_ERROR[-OB_ROOT_TABLE_RANGE_NOT_EXIST] = "Tablet range not exist";
    MYSQL_ERRNO[-OB_ROOT_MIGRATE_CONCURRENCY_FULL] = -1;
    SQLSTATE[-OB_ROOT_MIGRATE_CONCURRENCY_FULL] = "HY000";
    STR_ERROR[-OB_ROOT_MIGRATE_CONCURRENCY_FULL] = "Migrate concurrency full";
    STR_USER_ERROR[-OB_ROOT_MIGRATE_CONCURRENCY_FULL] = "Migrate concurrency full";
    MYSQL_ERRNO[-OB_ROOT_MIGRATE_INFO_NOT_FOUND] = -1;
    SQLSTATE[-OB_ROOT_MIGRATE_INFO_NOT_FOUND] = "HY000";
    STR_ERROR[-OB_ROOT_MIGRATE_INFO_NOT_FOUND] = "Migrate info not found";
    STR_USER_ERROR[-OB_ROOT_MIGRATE_INFO_NOT_FOUND] = "Migrate info not found";
    MYSQL_ERRNO[-OB_NOT_DATA_LOAD_TABLE] = -1;
    SQLSTATE[-OB_NOT_DATA_LOAD_TABLE] = "HY000";
    STR_ERROR[-OB_NOT_DATA_LOAD_TABLE] = "No data to load";
    STR_USER_ERROR[-OB_NOT_DATA_LOAD_TABLE] = "No data to load";
    MYSQL_ERRNO[-OB_DATA_LOAD_TABLE_DUPLICATED] = -1;
    SQLSTATE[-OB_DATA_LOAD_TABLE_DUPLICATED] = "HY000";
    STR_ERROR[-OB_DATA_LOAD_TABLE_DUPLICATED] = "Duplicated table data to load";
    STR_USER_ERROR[-OB_DATA_LOAD_TABLE_DUPLICATED] = "Duplicated table data to load";
    MYSQL_ERRNO[-OB_ROOT_TABLE_ID_EXIST] = -1;
    SQLSTATE[-OB_ROOT_TABLE_ID_EXIST] = "HY000";
    STR_ERROR[-OB_ROOT_TABLE_ID_EXIST] = "Table ID exist";
    STR_USER_ERROR[-OB_ROOT_TABLE_ID_EXIST] = "Table ID exist";
    MYSQL_ERRNO[-OB_INDEX_TIMEOUT] = -1;
    SQLSTATE[-OB_INDEX_TIMEOUT] = "HY000";
    STR_ERROR[-OB_INDEX_TIMEOUT] = "Building index timeout";
    STR_USER_ERROR[-OB_INDEX_TIMEOUT] = "Building index timeout";
    MYSQL_ERRNO[-OB_ROOT_NOT_INTEGRATED] = -1;
    SQLSTATE[-OB_ROOT_NOT_INTEGRATED] = "42000";
    STR_ERROR[-OB_ROOT_NOT_INTEGRATED] = "Root not integrated";
    STR_USER_ERROR[-OB_ROOT_NOT_INTEGRATED] = "Root not integrated";
    MYSQL_ERRNO[-OB_INDEX_INELIGIBLE] = -1;
    SQLSTATE[-OB_INDEX_INELIGIBLE] = "HY000";
    STR_ERROR[-OB_INDEX_INELIGIBLE] = "index data not unique";
    STR_USER_ERROR[-OB_INDEX_INELIGIBLE] = "index data not unique";
    MYSQL_ERRNO[-OB_REBALANCE_EXEC_TIMEOUT] = -1;
    SQLSTATE[-OB_REBALANCE_EXEC_TIMEOUT] = "HY000";
    STR_ERROR[-OB_REBALANCE_EXEC_TIMEOUT] = "execute replication or migration task timeout";
    STR_USER_ERROR[-OB_REBALANCE_EXEC_TIMEOUT] = "execute replication or migration task timeout";
    MYSQL_ERRNO[-OB_MERGE_NOT_STARTED] = -1;
    SQLSTATE[-OB_MERGE_NOT_STARTED] = "HY000";
    STR_ERROR[-OB_MERGE_NOT_STARTED] = "global merge not started";
    STR_USER_ERROR[-OB_MERGE_NOT_STARTED] = "global merge not started";
    MYSQL_ERRNO[-OB_MERGE_ALREADY_STARTED] = -1;
    SQLSTATE[-OB_MERGE_ALREADY_STARTED] = "HY000";
    STR_ERROR[-OB_MERGE_ALREADY_STARTED] = "merge already started";
    STR_USER_ERROR[-OB_MERGE_ALREADY_STARTED] = "merge already started";
    MYSQL_ERRNO[-OB_ROOTSERVICE_EXIST] = -1;
    SQLSTATE[-OB_ROOTSERVICE_EXIST] = "HY000";
    STR_ERROR[-OB_ROOTSERVICE_EXIST] = "rootservice already exist";
    STR_USER_ERROR[-OB_ROOTSERVICE_EXIST] = "rootservice already exist";
    MYSQL_ERRNO[-OB_RS_SHUTDOWN] = -1;
    SQLSTATE[-OB_RS_SHUTDOWN] = "HY000";
    STR_ERROR[-OB_RS_SHUTDOWN] = "rootservice is shutdown";
    STR_USER_ERROR[-OB_RS_SHUTDOWN] = "rootservice is shutdown";
    MYSQL_ERRNO[-OB_SERVER_MIGRATE_IN_DENIED] = -1;
    SQLSTATE[-OB_SERVER_MIGRATE_IN_DENIED] = "HY000";
    STR_ERROR[-OB_SERVER_MIGRATE_IN_DENIED] = "server migrate in denied";
    STR_USER_ERROR[-OB_SERVER_MIGRATE_IN_DENIED] = "server migrate in denied";
    MYSQL_ERRNO[-OB_REBALANCE_TASK_CANT_EXEC] = -1;
    SQLSTATE[-OB_REBALANCE_TASK_CANT_EXEC] = "HY000";
    STR_ERROR[-OB_REBALANCE_TASK_CANT_EXEC] = "rebalance task can not executing now";
    STR_USER_ERROR[-OB_REBALANCE_TASK_CANT_EXEC] = "rebalance task can not executing now";
    MYSQL_ERRNO[-OB_PARTITION_CNT_REACH_ROOTSERVER_LIMIT] = -1;
    SQLSTATE[-OB_PARTITION_CNT_REACH_ROOTSERVER_LIMIT] = "HY000";
    STR_ERROR[-OB_PARTITION_CNT_REACH_ROOTSERVER_LIMIT] = "rootserver can not hold more partition";
    STR_USER_ERROR[-OB_PARTITION_CNT_REACH_ROOTSERVER_LIMIT] = "rootserver can not hold more partition";
    MYSQL_ERRNO[-OB_DATA_SOURCE_NOT_EXIST] = -1;
    SQLSTATE[-OB_DATA_SOURCE_NOT_EXIST] = "HY000";
    STR_ERROR[-OB_DATA_SOURCE_NOT_EXIST] = "Data source not exist";
    STR_USER_ERROR[-OB_DATA_SOURCE_NOT_EXIST] = "Data source not exist";
    MYSQL_ERRNO[-OB_DATA_SOURCE_TABLE_NOT_EXIST] = -1;
    SQLSTATE[-OB_DATA_SOURCE_TABLE_NOT_EXIST] = "HY000";
    STR_ERROR[-OB_DATA_SOURCE_TABLE_NOT_EXIST] = "Data source table not exist";
    STR_USER_ERROR[-OB_DATA_SOURCE_TABLE_NOT_EXIST] = "Data source table not exist";
    MYSQL_ERRNO[-OB_DATA_SOURCE_RANGE_NOT_EXIST] = -1;
    SQLSTATE[-OB_DATA_SOURCE_RANGE_NOT_EXIST] = "HY000";
    STR_ERROR[-OB_DATA_SOURCE_RANGE_NOT_EXIST] = "Data source range not exist";
    STR_USER_ERROR[-OB_DATA_SOURCE_RANGE_NOT_EXIST] = "Data source range not exist";
    MYSQL_ERRNO[-OB_DATA_SOURCE_DATA_NOT_EXIST] = -1;
    SQLSTATE[-OB_DATA_SOURCE_DATA_NOT_EXIST] = "HY000";
    STR_ERROR[-OB_DATA_SOURCE_DATA_NOT_EXIST] = "Data source data not exist";
    STR_USER_ERROR[-OB_DATA_SOURCE_DATA_NOT_EXIST] = "Data source data not exist";
    MYSQL_ERRNO[-OB_DATA_SOURCE_SYS_ERROR] = -1;
    SQLSTATE[-OB_DATA_SOURCE_SYS_ERROR] = "HY000";
    STR_ERROR[-OB_DATA_SOURCE_SYS_ERROR] = "Data source sys error";
    STR_USER_ERROR[-OB_DATA_SOURCE_SYS_ERROR] = "Data source sys error";
    MYSQL_ERRNO[-OB_DATA_SOURCE_TIMEOUT] = -1;
    SQLSTATE[-OB_DATA_SOURCE_TIMEOUT] = "HY000";
    STR_ERROR[-OB_DATA_SOURCE_TIMEOUT] = "Data source timeout";
    STR_USER_ERROR[-OB_DATA_SOURCE_TIMEOUT] = "Data source timeout";
    MYSQL_ERRNO[-OB_DATA_SOURCE_CONCURRENCY_FULL] = -1;
    SQLSTATE[-OB_DATA_SOURCE_CONCURRENCY_FULL] = "53000";
    STR_ERROR[-OB_DATA_SOURCE_CONCURRENCY_FULL] = "Data source concurrency full";
    STR_USER_ERROR[-OB_DATA_SOURCE_CONCURRENCY_FULL] = "Data source concurrency full";
    MYSQL_ERRNO[-OB_DATA_SOURCE_WRONG_URI_FORMAT] = -1;
    SQLSTATE[-OB_DATA_SOURCE_WRONG_URI_FORMAT] = "42000";
    STR_ERROR[-OB_DATA_SOURCE_WRONG_URI_FORMAT] = "Data source wrong URI format";
    STR_USER_ERROR[-OB_DATA_SOURCE_WRONG_URI_FORMAT] = "Data source wrong URI format";
    MYSQL_ERRNO[-OB_SSTABLE_VERSION_UNEQUAL] = -1;
    SQLSTATE[-OB_SSTABLE_VERSION_UNEQUAL] = "42000";
    STR_ERROR[-OB_SSTABLE_VERSION_UNEQUAL] = "SSTable version not equal";
    STR_USER_ERROR[-OB_SSTABLE_VERSION_UNEQUAL] = "SSTable version not equal";
    MYSQL_ERRNO[-OB_UPS_RENEW_LEASE_NOT_ALLOWED] = -1;
    SQLSTATE[-OB_UPS_RENEW_LEASE_NOT_ALLOWED] = "HY000";
    STR_ERROR[-OB_UPS_RENEW_LEASE_NOT_ALLOWED] = "ups should not renew its lease";
    STR_USER_ERROR[-OB_UPS_RENEW_LEASE_NOT_ALLOWED] = "ups should not renew its lease";
    MYSQL_ERRNO[-OB_UPS_COUNT_OVER_LIMIT] = -1;
    SQLSTATE[-OB_UPS_COUNT_OVER_LIMIT] = "HY000";
    STR_ERROR[-OB_UPS_COUNT_OVER_LIMIT] = "ups count over limit";
    STR_USER_ERROR[-OB_UPS_COUNT_OVER_LIMIT] = "ups count over limit";
    MYSQL_ERRNO[-OB_NO_UPS_MAJORITY] = -1;
    SQLSTATE[-OB_NO_UPS_MAJORITY] = "HY000";
    STR_ERROR[-OB_NO_UPS_MAJORITY] = "ups not form a majority";
    STR_USER_ERROR[-OB_NO_UPS_MAJORITY] = "ups not form a majority";
    MYSQL_ERRNO[-OB_INDEX_COUNT_REACH_THE_LIMIT] = -1;
    SQLSTATE[-OB_INDEX_COUNT_REACH_THE_LIMIT] = "HY000";
    STR_ERROR[-OB_INDEX_COUNT_REACH_THE_LIMIT] = "created index tables count has reach the limit:128";
    STR_USER_ERROR[-OB_INDEX_COUNT_REACH_THE_LIMIT] = "created index tables count has reach the limit:128";
    MYSQL_ERRNO[-OB_TASK_EXPIRED] = -1;
    SQLSTATE[-OB_TASK_EXPIRED] = "HY000";
    STR_ERROR[-OB_TASK_EXPIRED] = "task expired";
    STR_USER_ERROR[-OB_TASK_EXPIRED] = "task expired";
    MYSQL_ERRNO[-OB_TABLEGROUP_NOT_EMPTY] = -1;
    SQLSTATE[-OB_TABLEGROUP_NOT_EMPTY] = "HY000";
    STR_ERROR[-OB_TABLEGROUP_NOT_EMPTY] = "tablegroup is not empty";
    STR_USER_ERROR[-OB_TABLEGROUP_NOT_EMPTY] = "tablegroup is not empty";
    MYSQL_ERRNO[-OB_INVALID_SERVER_STATUS] = -1;
    SQLSTATE[-OB_INVALID_SERVER_STATUS] = "HY000";
    STR_ERROR[-OB_INVALID_SERVER_STATUS] = "server status is not valid";
    STR_USER_ERROR[-OB_INVALID_SERVER_STATUS] = "server status is not valid";
    MYSQL_ERRNO[-OB_WAIT_ELEC_LEADER_TIMEOUT] = -1;
    SQLSTATE[-OB_WAIT_ELEC_LEADER_TIMEOUT] = "HY000";
    STR_ERROR[-OB_WAIT_ELEC_LEADER_TIMEOUT] = "wait elect partition leader timeout";
    STR_USER_ERROR[-OB_WAIT_ELEC_LEADER_TIMEOUT] = "wait elect partition leader timeout";
    MYSQL_ERRNO[-OB_WAIT_ALL_RS_ONLINE_TIMEOUT] = -1;
    SQLSTATE[-OB_WAIT_ALL_RS_ONLINE_TIMEOUT] = "HY000";
    STR_ERROR[-OB_WAIT_ALL_RS_ONLINE_TIMEOUT] = "wait all rs online timeout";
    STR_USER_ERROR[-OB_WAIT_ALL_RS_ONLINE_TIMEOUT] = "wait all rs online timeout";
    MYSQL_ERRNO[-OB_ALL_REPLICAS_ON_MERGE_ZONE] = -1;
    SQLSTATE[-OB_ALL_REPLICAS_ON_MERGE_ZONE] = "HY000";
    STR_ERROR[-OB_ALL_REPLICAS_ON_MERGE_ZONE] = "all replicas of partition group are on zones to merge";
    STR_USER_ERROR[-OB_ALL_REPLICAS_ON_MERGE_ZONE] = "all replicas of partition group are on zones to merge";
    MYSQL_ERRNO[-OB_MACHINE_RESOURCE_NOT_ENOUGH] = -1;
    SQLSTATE[-OB_MACHINE_RESOURCE_NOT_ENOUGH] = "HY000";
    STR_ERROR[-OB_MACHINE_RESOURCE_NOT_ENOUGH] = "machine resource is not enough to hold a new unit";
    STR_USER_ERROR[-OB_MACHINE_RESOURCE_NOT_ENOUGH] = "machine resource is not enough to hold a new unit";
    MYSQL_ERRNO[-OB_NOT_SERVER_CAN_HOLD_SOFTLY] = -1;
    SQLSTATE[-OB_NOT_SERVER_CAN_HOLD_SOFTLY] = "HY000";
    STR_ERROR[-OB_NOT_SERVER_CAN_HOLD_SOFTLY] = "not server can hole the unit and not over soft limit";
    STR_USER_ERROR[-OB_NOT_SERVER_CAN_HOLD_SOFTLY] = "not server can hole the unit and not over soft limit";
    MYSQL_ERRNO[-OB_RESOURCE_POOL_ALREADY_GRANTED] = -1;
    SQLSTATE[-OB_RESOURCE_POOL_ALREADY_GRANTED] = "HY000";
    STR_ERROR[-OB_RESOURCE_POOL_ALREADY_GRANTED] = "resource pool has already been granted to a tenant";
    STR_USER_ERROR[-OB_RESOURCE_POOL_ALREADY_GRANTED] = "resource pool \'%s\' has already been granted to a tenant";
    MYSQL_ERRNO[-OB_SERVER_ALREADY_DELETED] = -1;
    SQLSTATE[-OB_SERVER_ALREADY_DELETED] = "HY000";
    STR_ERROR[-OB_SERVER_ALREADY_DELETED] = "server has already been deleted";
    STR_USER_ERROR[-OB_SERVER_ALREADY_DELETED] = "server has already been deleted";
    MYSQL_ERRNO[-OB_SERVER_NOT_DELETING] = -1;
    SQLSTATE[-OB_SERVER_NOT_DELETING] = "HY000";
    STR_ERROR[-OB_SERVER_NOT_DELETING] = "server is not in deleting status";
    STR_USER_ERROR[-OB_SERVER_NOT_DELETING] = "server is not in deleting status";
    MYSQL_ERRNO[-OB_SERVER_NOT_IN_WHITE_LIST] = -1;
    SQLSTATE[-OB_SERVER_NOT_IN_WHITE_LIST] = "HY000";
    STR_ERROR[-OB_SERVER_NOT_IN_WHITE_LIST] = "server not in server white list";
    STR_USER_ERROR[-OB_SERVER_NOT_IN_WHITE_LIST] = "server not in server white list";
    MYSQL_ERRNO[-OB_SERVER_ZONE_NOT_MATCH] = -1;
    SQLSTATE[-OB_SERVER_ZONE_NOT_MATCH] = "HY000";
    STR_ERROR[-OB_SERVER_ZONE_NOT_MATCH] = "server zone not match";
    STR_USER_ERROR[-OB_SERVER_ZONE_NOT_MATCH] = "server zone not match";
    MYSQL_ERRNO[-OB_OVER_ZONE_NUM_LIMIT] = -1;
    SQLSTATE[-OB_OVER_ZONE_NUM_LIMIT] = "HY000";
    STR_ERROR[-OB_OVER_ZONE_NUM_LIMIT] = "zone num has reach max zone num";
    STR_USER_ERROR[-OB_OVER_ZONE_NUM_LIMIT] = "zone num has reach max zone num";
    MYSQL_ERRNO[-OB_ZONE_STATUS_NOT_MATCH] = -1;
    SQLSTATE[-OB_ZONE_STATUS_NOT_MATCH] = "HY000";
    STR_ERROR[-OB_ZONE_STATUS_NOT_MATCH] = "zone status not match";
    STR_USER_ERROR[-OB_ZONE_STATUS_NOT_MATCH] = "zone status not match";
    MYSQL_ERRNO[-OB_RESOURCE_UNIT_IS_REFERENCED] = -1;
    SQLSTATE[-OB_RESOURCE_UNIT_IS_REFERENCED] = "HY000";
    STR_ERROR[-OB_RESOURCE_UNIT_IS_REFERENCED] = "resource unit is referenced by resource pool";
    STR_USER_ERROR[-OB_RESOURCE_UNIT_IS_REFERENCED] = "resource unit \'%s\' is referenced by some resource pool";
    MYSQL_ERRNO[-OB_DIFFERENT_PRIMARY_ZONE] = -1;
    SQLSTATE[-OB_DIFFERENT_PRIMARY_ZONE] = "HY000";
    STR_ERROR[-OB_DIFFERENT_PRIMARY_ZONE] = "table schema primary zone different with other table in sampe tablegroup";
    STR_USER_ERROR[-OB_DIFFERENT_PRIMARY_ZONE] = "table schema primary zone different with other table in sampe tablegroup";
    MYSQL_ERRNO[-OB_SERVER_NOT_ACTIVE] = -1;
    SQLSTATE[-OB_SERVER_NOT_ACTIVE] = "HY000";
    STR_ERROR[-OB_SERVER_NOT_ACTIVE] = "server is not active";
    STR_USER_ERROR[-OB_SERVER_NOT_ACTIVE] = "server is not active";
    MYSQL_ERRNO[-OB_RS_NOT_MASTER] = -1;
    SQLSTATE[-OB_RS_NOT_MASTER] = "HY000";
    STR_ERROR[-OB_RS_NOT_MASTER] = "The RootServer is not the master";
    STR_USER_ERROR[-OB_RS_NOT_MASTER] = "The RootServer is not the master";
    MYSQL_ERRNO[-OB_CANDIDATE_LIST_ERROR] = -1;
    SQLSTATE[-OB_CANDIDATE_LIST_ERROR] = "HY000";
    STR_ERROR[-OB_CANDIDATE_LIST_ERROR] = "The candidate list is invalid";
    STR_USER_ERROR[-OB_CANDIDATE_LIST_ERROR] = "The candidate list is invalid";
    MYSQL_ERRNO[-OB_PARTITION_ZONE_DUPLICATED] = -1;
    SQLSTATE[-OB_PARTITION_ZONE_DUPLICATED] = "HY000";
    STR_ERROR[-OB_PARTITION_ZONE_DUPLICATED] = "The chosen partition servers belong to same zone.";
    STR_USER_ERROR[-OB_PARTITION_ZONE_DUPLICATED] = "The chosen partition servers belong to same zone.";
    MYSQL_ERRNO[-OB_ZONE_DUPLICATED] = -1;
    SQLSTATE[-OB_ZONE_DUPLICATED] = "HY000";
    STR_ERROR[-OB_ZONE_DUPLICATED] = "Duplicated zone in zone list";
    STR_USER_ERROR[-OB_ZONE_DUPLICATED] = "Duplicated zone \'%s\' in zone list %s";
    MYSQL_ERRNO[-OB_NOT_ALL_ZONE_ACTIVE] = -1;
    SQLSTATE[-OB_NOT_ALL_ZONE_ACTIVE] = "HY000";
    STR_ERROR[-OB_NOT_ALL_ZONE_ACTIVE] = "Not all zone in zone list are active";
    STR_USER_ERROR[-OB_NOT_ALL_ZONE_ACTIVE] = "Not all zone in zone list are active";
    MYSQL_ERRNO[-OB_PRIMARY_ZONE_NOT_IN_ZONE_LIST] = -1;
    SQLSTATE[-OB_PRIMARY_ZONE_NOT_IN_ZONE_LIST] = "HY000";
    STR_ERROR[-OB_PRIMARY_ZONE_NOT_IN_ZONE_LIST] = "primary zone not in zone list";
    STR_USER_ERROR[-OB_PRIMARY_ZONE_NOT_IN_ZONE_LIST] = "primary zone \'%s\' not in zone list %s";
    MYSQL_ERRNO[-OB_REPLICA_NUM_NOT_MATCH] = -1;
    SQLSTATE[-OB_REPLICA_NUM_NOT_MATCH] = "HY000";
    STR_ERROR[-OB_REPLICA_NUM_NOT_MATCH] = "replica num not same with zone count";
    STR_USER_ERROR[-OB_REPLICA_NUM_NOT_MATCH] = "replica num not same with zone count";
    MYSQL_ERRNO[-OB_ZONE_LIST_POOL_LIST_NOT_MATCH] = -1;
    SQLSTATE[-OB_ZONE_LIST_POOL_LIST_NOT_MATCH] = "HY000";
    STR_ERROR[-OB_ZONE_LIST_POOL_LIST_NOT_MATCH] = "zone list not a subset of  resource pool list";
    STR_USER_ERROR[-OB_ZONE_LIST_POOL_LIST_NOT_MATCH] = "zone list %s not a subset of resource pool zone list %s";
    MYSQL_ERRNO[-OB_INVALID_TENANT_NAME] = -1;
    SQLSTATE[-OB_INVALID_TENANT_NAME] = "HY000";
    STR_ERROR[-OB_INVALID_TENANT_NAME] = "tenant name is too long";
    STR_USER_ERROR[-OB_INVALID_TENANT_NAME] = "tenant name \'%s\' over max_tenant_name_length %ld";
    MYSQL_ERRNO[-OB_EMPTY_RESOURCE_POOL_LIST] = -1;
    SQLSTATE[-OB_EMPTY_RESOURCE_POOL_LIST] = "HY000";
    STR_ERROR[-OB_EMPTY_RESOURCE_POOL_LIST] = "resource pool list is empty";
    STR_USER_ERROR[-OB_EMPTY_RESOURCE_POOL_LIST] = "resource pool list is empty";
    MYSQL_ERRNO[-OB_RESOURCE_UNIT_NOT_EXIST] = -1;
    SQLSTATE[-OB_RESOURCE_UNIT_NOT_EXIST] = "HY000";
    STR_ERROR[-OB_RESOURCE_UNIT_NOT_EXIST] = "resource unit not exist";
    STR_USER_ERROR[-OB_RESOURCE_UNIT_NOT_EXIST] = "resource unit \'%s\' not exist";
    MYSQL_ERRNO[-OB_RESOURCE_UNIT_EXIST] = -1;
    SQLSTATE[-OB_RESOURCE_UNIT_EXIST] = "HY000";
    STR_ERROR[-OB_RESOURCE_UNIT_EXIST] = "resource unit already exist";
    STR_USER_ERROR[-OB_RESOURCE_UNIT_EXIST] = "resource unit \'%s\' already exist";
    MYSQL_ERRNO[-OB_RESOURCE_POOL_NOT_EXIST] = -1;
    SQLSTATE[-OB_RESOURCE_POOL_NOT_EXIST] = "HY000";
    STR_ERROR[-OB_RESOURCE_POOL_NOT_EXIST] = "resource pool not exist";
    STR_USER_ERROR[-OB_RESOURCE_POOL_NOT_EXIST] = "resource pool \'%s\' not exist";
    MYSQL_ERRNO[-OB_RESOURCE_POOL_EXIST] = -1;
    SQLSTATE[-OB_RESOURCE_POOL_EXIST] = "HY000";
    STR_ERROR[-OB_RESOURCE_POOL_EXIST] = "resource pool already exist";
    STR_USER_ERROR[-OB_RESOURCE_POOL_EXIST] = "resource pool \'%s\' exist";
    MYSQL_ERRNO[-OB_WAIT_LEADER_SWITCH_TIMEOUT] = -1;
    SQLSTATE[-OB_WAIT_LEADER_SWITCH_TIMEOUT] = "HY000";
    STR_ERROR[-OB_WAIT_LEADER_SWITCH_TIMEOUT] = "wait leader switch timeout";
    STR_USER_ERROR[-OB_WAIT_LEADER_SWITCH_TIMEOUT] = "wait leader switch timeout";
    MYSQL_ERRNO[-OB_LOCATION_NOT_EXIST] = -1;
    SQLSTATE[-OB_LOCATION_NOT_EXIST] = "HY000";
    STR_ERROR[-OB_LOCATION_NOT_EXIST] = "location not exist";
    STR_USER_ERROR[-OB_LOCATION_NOT_EXIST] = "location not exist";
    MYSQL_ERRNO[-OB_LOCATION_LEADER_NOT_EXIST] = -1;
    SQLSTATE[-OB_LOCATION_LEADER_NOT_EXIST] = "HY000";
    STR_ERROR[-OB_LOCATION_LEADER_NOT_EXIST] = "location leader not exist";
    STR_USER_ERROR[-OB_LOCATION_LEADER_NOT_EXIST] = "location leader not exist";
    MYSQL_ERRNO[-OB_ZONE_NOT_ACTIVE] = -1;
    SQLSTATE[-OB_ZONE_NOT_ACTIVE] = "HY000";
    STR_ERROR[-OB_ZONE_NOT_ACTIVE] = "zone not active";
    STR_USER_ERROR[-OB_ZONE_NOT_ACTIVE] = "zone not active";
    MYSQL_ERRNO[-OB_UNIT_NUM_OVER_SERVER_COUNT] = -1;
    SQLSTATE[-OB_UNIT_NUM_OVER_SERVER_COUNT] = "HY000";
    STR_ERROR[-OB_UNIT_NUM_OVER_SERVER_COUNT] = "resource pool unit num is bigger than zone server count";
    STR_USER_ERROR[-OB_UNIT_NUM_OVER_SERVER_COUNT] = "resource pool unit num is bigger than zone server count";
    MYSQL_ERRNO[-OB_POOL_SERVER_INTERSECT] = -1;
    SQLSTATE[-OB_POOL_SERVER_INTERSECT] = "HY000";
    STR_ERROR[-OB_POOL_SERVER_INTERSECT] = "resource pool list unit server intersect";
    STR_USER_ERROR[-OB_POOL_SERVER_INTERSECT] = "resource pool list %s unit servers intersect";
    MYSQL_ERRNO[-OB_NOT_SINGLE_RESOURCE_POOL] = -1;
    SQLSTATE[-OB_NOT_SINGLE_RESOURCE_POOL] = "HY000";
    STR_ERROR[-OB_NOT_SINGLE_RESOURCE_POOL] = "create tenant only support single resource pool now";
    STR_USER_ERROR[-OB_NOT_SINGLE_RESOURCE_POOL] = "create tenant only support single resource pool now, but pool list is %s";
    MYSQL_ERRNO[-OB_INVALID_RESOURCE_UNIT] = -1;
    SQLSTATE[-OB_INVALID_RESOURCE_UNIT] = "HY000";
    STR_ERROR[-OB_INVALID_RESOURCE_UNIT] = "invalid resource unit";
    STR_USER_ERROR[-OB_INVALID_RESOURCE_UNIT] = "invalid resource unit, %s\'s min value is %s";
    MYSQL_ERRNO[-OB_STOP_SERVER_IN_MULTIPLE_ZONES] = -1;
    SQLSTATE[-OB_STOP_SERVER_IN_MULTIPLE_ZONES] = "HY000";
    STR_ERROR[-OB_STOP_SERVER_IN_MULTIPLE_ZONES] = "Can not stop server in multiple zones";
    STR_USER_ERROR[-OB_STOP_SERVER_IN_MULTIPLE_ZONES] = "Can not stop server in multiple zones, there are already servers stopped in zone:%s";
    MYSQL_ERRNO[-OB_SESSION_ENTRY_EXIST] = -1;
    SQLSTATE[-OB_SESSION_ENTRY_EXIST] = "HY000";
    STR_ERROR[-OB_SESSION_ENTRY_EXIST] = "Session already exist";
    STR_USER_ERROR[-OB_SESSION_ENTRY_EXIST] = "Session already exist";
    MYSQL_ERRNO[-OB_GOT_SIGNAL_ABORTING] = ER_GOT_SIGNAL;
    SQLSTATE[-OB_GOT_SIGNAL_ABORTING] = "01000";
    STR_ERROR[-OB_GOT_SIGNAL_ABORTING] = "Got signal. Aborting!";
    STR_USER_ERROR[-OB_GOT_SIGNAL_ABORTING] = "%s: Got signal %d. Aborting!";
    MYSQL_ERRNO[-OB_SERVER_NOT_ALIVE] = -1;
    SQLSTATE[-OB_SERVER_NOT_ALIVE] = "HY000";
    STR_ERROR[-OB_SERVER_NOT_ALIVE] = "server is not alive";
    STR_USER_ERROR[-OB_SERVER_NOT_ALIVE] = "server is not alive";
    MYSQL_ERRNO[-OB_GET_LOCATION_TIME_OUT] = 4012;
    SQLSTATE[-OB_GET_LOCATION_TIME_OUT] = "HY000";
    STR_ERROR[-OB_GET_LOCATION_TIME_OUT] = "Get Location Cache Fail";
    STR_USER_ERROR[-OB_GET_LOCATION_TIME_OUT] = "Get Location Cache Fail";
    MYSQL_ERRNO[-OB_UNIT_IS_MIGRATING] = -1;
    SQLSTATE[-OB_UNIT_IS_MIGRATING] = "HY000";
    STR_ERROR[-OB_UNIT_IS_MIGRATING] = "Unit is migrating, can not migrate again";
    STR_USER_ERROR[-OB_UNIT_IS_MIGRATING] = "Unit is migrating, can not migrate again";
    MYSQL_ERRNO[-OB_CLUSTER_NO_MATCH] = -1;
    SQLSTATE[-OB_CLUSTER_NO_MATCH] = "HY000";
    STR_ERROR[-OB_CLUSTER_NO_MATCH] = "cluster name is not match";
    STR_USER_ERROR[-OB_CLUSTER_NO_MATCH] = "cluster name is not match to \'%s\'";
    MYSQL_ERRNO[-OB_CHECK_ZONE_MERGE_ORDER] = -1;
    SQLSTATE[-OB_CHECK_ZONE_MERGE_ORDER] = "HY000";
    STR_ERROR[-OB_CHECK_ZONE_MERGE_ORDER] = "Please check new zone in zone_merge_order. You can show parameters like 'zone_merge_order'";
    STR_USER_ERROR[-OB_CHECK_ZONE_MERGE_ORDER] = "Please check new zone in zone_merge_order. You can show parameters like 'zone_merge_order'";
    MYSQL_ERRNO[-OB_INVALID_MACRO_BLOCK_TYPE] = -1;
    SQLSTATE[-OB_INVALID_MACRO_BLOCK_TYPE] = "HY000";
    STR_ERROR[-OB_INVALID_MACRO_BLOCK_TYPE] = "the macro block type does not exist";
    STR_USER_ERROR[-OB_INVALID_MACRO_BLOCK_TYPE] = "the macro block type does not exist";
    MYSQL_ERRNO[-OB_CLUSTER_NOT_EXIST] = -1;
    SQLSTATE[-OB_CLUSTER_NOT_EXIST] = "HY000";
    STR_ERROR[-OB_CLUSTER_NOT_EXIST] = "cluster not exist";
    STR_USER_ERROR[-OB_CLUSTER_NOT_EXIST] = "cluster \'%s\' not exist";
    MYSQL_ERRNO[-OB_ERR_PARSER_INIT] = ER_PARSE_ERROR;
    SQLSTATE[-OB_ERR_PARSER_INIT] = "0B000";
    STR_ERROR[-OB_ERR_PARSER_INIT] = "Failed to init SQL parser";
    STR_USER_ERROR[-OB_ERR_PARSER_INIT] = "Failed to init SQL parser";
    MYSQL_ERRNO[-OB_ERR_PARSE_SQL] = ER_PARSE_ERROR;
    SQLSTATE[-OB_ERR_PARSE_SQL] = "42000";
    STR_ERROR[-OB_ERR_PARSE_SQL] = "Parse error";
    STR_USER_ERROR[-OB_ERR_PARSE_SQL] = "%s near \'%.*s\' at line %d";
    MYSQL_ERRNO[-OB_ERR_RESOLVE_SQL] = -1;
    SQLSTATE[-OB_ERR_RESOLVE_SQL] = "HY000";
    STR_ERROR[-OB_ERR_RESOLVE_SQL] = "Resolve error";
    STR_USER_ERROR[-OB_ERR_RESOLVE_SQL] = "Resolve error";
    MYSQL_ERRNO[-OB_ERR_GEN_PLAN] = -1;
    SQLSTATE[-OB_ERR_GEN_PLAN] = "HY000";
    STR_ERROR[-OB_ERR_GEN_PLAN] = "Generate plan error";
    STR_USER_ERROR[-OB_ERR_GEN_PLAN] = "Generate plan error";
    MYSQL_ERRNO[-OB_ERR_PARSER_SYNTAX] = ER_SYNTAX_ERROR;
    SQLSTATE[-OB_ERR_PARSER_SYNTAX] = "42000";
    STR_ERROR[-OB_ERR_PARSER_SYNTAX] = "You have an error in your SQL syntax; check the manual that corresponds to your MySQL server version for the right syntax to use";
    STR_USER_ERROR[-OB_ERR_PARSER_SYNTAX] = "You have an error in your SQL syntax; check the manual that corresponds to your MySQL server version for the right syntax to use";
    MYSQL_ERRNO[-OB_ERR_COLUMN_SIZE] = ER_WRONG_NUMBER_OF_COLUMNS_IN_SELECT;
    SQLSTATE[-OB_ERR_COLUMN_SIZE] = "21000";
    STR_ERROR[-OB_ERR_COLUMN_SIZE] = "The used SELECT statements have a different number of columns";
    STR_USER_ERROR[-OB_ERR_COLUMN_SIZE] = "The used SELECT statements have a different number of columns";
    MYSQL_ERRNO[-OB_ERR_COLUMN_DUPLICATE] = ER_DUP_FIELDNAME;
    SQLSTATE[-OB_ERR_COLUMN_DUPLICATE] = "42S21";
    STR_ERROR[-OB_ERR_COLUMN_DUPLICATE] = "Duplicate column name";
    STR_USER_ERROR[-OB_ERR_COLUMN_DUPLICATE] = "Duplicate column name '%.*s'";
    MYSQL_ERRNO[-OB_ERR_OPERATOR_UNKNOWN] = -1;
    SQLSTATE[-OB_ERR_OPERATOR_UNKNOWN] = "21000";
    STR_ERROR[-OB_ERR_OPERATOR_UNKNOWN] = "Unknown operator";
    STR_USER_ERROR[-OB_ERR_OPERATOR_UNKNOWN] = "Unknown operator";
    MYSQL_ERRNO[-OB_ERR_STAR_DUPLICATE] = -1;
    SQLSTATE[-OB_ERR_STAR_DUPLICATE] = "42000";
    STR_ERROR[-OB_ERR_STAR_DUPLICATE] = "Duplicated star";
    STR_USER_ERROR[-OB_ERR_STAR_DUPLICATE] = "Duplicated star";
    MYSQL_ERRNO[-OB_ERR_ILLEGAL_ID] = -1;
    SQLSTATE[-OB_ERR_ILLEGAL_ID] = "HY000";
    STR_ERROR[-OB_ERR_ILLEGAL_ID] = "Illegal ID";
    STR_USER_ERROR[-OB_ERR_ILLEGAL_ID] = "%s";
    MYSQL_ERRNO[-OB_ERR_ILLEGAL_VALUE] = -1;
    SQLSTATE[-OB_ERR_ILLEGAL_VALUE] = "HY000";
    STR_ERROR[-OB_ERR_ILLEGAL_VALUE] = "Illegal value";
    STR_USER_ERROR[-OB_ERR_ILLEGAL_VALUE] = "Illegal value";
    MYSQL_ERRNO[-OB_ERR_COLUMN_AMBIGUOUS] = ER_AMBIGUOUS_FIELD_TERM;
    SQLSTATE[-OB_ERR_COLUMN_AMBIGUOUS] = "42000";
    STR_ERROR[-OB_ERR_COLUMN_AMBIGUOUS] = "Ambiguous column";
    STR_USER_ERROR[-OB_ERR_COLUMN_AMBIGUOUS] = "Ambiguous column";
    MYSQL_ERRNO[-OB_ERR_LOGICAL_PLAN_FAILD] = -1;
    SQLSTATE[-OB_ERR_LOGICAL_PLAN_FAILD] = "HY000";
    STR_ERROR[-OB_ERR_LOGICAL_PLAN_FAILD] = "Generate logical plan error";
    STR_USER_ERROR[-OB_ERR_LOGICAL_PLAN_FAILD] = "Generate logical plan error";
    MYSQL_ERRNO[-OB_ERR_SCHEMA_UNSET] = -1;
    SQLSTATE[-OB_ERR_SCHEMA_UNSET] = "HY000";
    STR_ERROR[-OB_ERR_SCHEMA_UNSET] = "Schema not set";
    STR_USER_ERROR[-OB_ERR_SCHEMA_UNSET] = "Schema not set";
    MYSQL_ERRNO[-OB_ERR_ILLEGAL_NAME] = -1;
    SQLSTATE[-OB_ERR_ILLEGAL_NAME] = "42000";
    STR_ERROR[-OB_ERR_ILLEGAL_NAME] = "Illegal name";
    STR_USER_ERROR[-OB_ERR_ILLEGAL_NAME] = "Illegal name";
    MYSQL_ERRNO[-OB_TABLE_NOT_EXIST] = ER_NO_SUCH_TABLE;
    SQLSTATE[-OB_TABLE_NOT_EXIST] = "42S02";
    STR_ERROR[-OB_TABLE_NOT_EXIST] = "Table doesn\'t exist";
    STR_USER_ERROR[-OB_TABLE_NOT_EXIST] = "Table \'%s.%s\' doesn\'t exist";
    MYSQL_ERRNO[-OB_ERR_TABLE_EXIST] = ER_TABLE_EXISTS_ERROR;
    SQLSTATE[-OB_ERR_TABLE_EXIST] = "42S01";
    STR_ERROR[-OB_ERR_TABLE_EXIST] = "Table already exists";
    STR_USER_ERROR[-OB_ERR_TABLE_EXIST] = "Table '%.*s' already exists";
    MYSQL_ERRNO[-OB_ERR_EXPR_UNKNOWN] = -1;
    SQLSTATE[-OB_ERR_EXPR_UNKNOWN] = "42000";
    STR_ERROR[-OB_ERR_EXPR_UNKNOWN] = "Unknown expression";
    STR_USER_ERROR[-OB_ERR_EXPR_UNKNOWN] = "Unknown expression";
    MYSQL_ERRNO[-OB_ERR_ILLEGAL_TYPE] = -1;
    SQLSTATE[-OB_ERR_ILLEGAL_TYPE] = "S1004";
    STR_ERROR[-OB_ERR_ILLEGAL_TYPE] = "Illegal type";
    STR_USER_ERROR[-OB_ERR_ILLEGAL_TYPE] = "unsupport MySQL type %d. Maybe you should use java.sql.Timestamp instead of java.util.Date.";
    MYSQL_ERRNO[-OB_ERR_PRIMARY_KEY_DUPLICATE] = ER_DUP_ENTRY;
    SQLSTATE[-OB_ERR_PRIMARY_KEY_DUPLICATE] = "23000";
    STR_ERROR[-OB_ERR_PRIMARY_KEY_DUPLICATE] = "Duplicated primary key";
    STR_USER_ERROR[-OB_ERR_PRIMARY_KEY_DUPLICATE] = "Duplicate entry \'%s\' for key \'%.*s\'";
    MYSQL_ERRNO[-OB_ERR_KEY_NAME_DUPLICATE] = ER_DUP_KEYNAME;
    SQLSTATE[-OB_ERR_KEY_NAME_DUPLICATE] = "42000";
    STR_ERROR[-OB_ERR_KEY_NAME_DUPLICATE] = "Duplicated key name";
    STR_USER_ERROR[-OB_ERR_KEY_NAME_DUPLICATE] = "Duplicate key name \'%.*s\'";
    MYSQL_ERRNO[-OB_ERR_CREATETIME_DUPLICATE] = -1;
    SQLSTATE[-OB_ERR_CREATETIME_DUPLICATE] = "42000";
    STR_ERROR[-OB_ERR_CREATETIME_DUPLICATE] = "Duplicated createtime";
    STR_USER_ERROR[-OB_ERR_CREATETIME_DUPLICATE] = "Duplicated createtime";
    MYSQL_ERRNO[-OB_ERR_MODIFYTIME_DUPLICATE] = -1;
    SQLSTATE[-OB_ERR_MODIFYTIME_DUPLICATE] = "42000";
    STR_ERROR[-OB_ERR_MODIFYTIME_DUPLICATE] = "Duplicated modifytime";
    STR_USER_ERROR[-OB_ERR_MODIFYTIME_DUPLICATE] = "Duplicated modifytime";
    MYSQL_ERRNO[-OB_ERR_ILLEGAL_INDEX] = ER_NO_SUCH_INDEX;
    SQLSTATE[-OB_ERR_ILLEGAL_INDEX] = "42S12";
    STR_ERROR[-OB_ERR_ILLEGAL_INDEX] = "Illegal index";
    STR_USER_ERROR[-OB_ERR_ILLEGAL_INDEX] = "Illegal index";
    MYSQL_ERRNO[-OB_ERR_INVALID_SCHEMA] = -1;
    SQLSTATE[-OB_ERR_INVALID_SCHEMA] = "HY000";
    STR_ERROR[-OB_ERR_INVALID_SCHEMA] = "Invalid schema";
    STR_USER_ERROR[-OB_ERR_INVALID_SCHEMA] = "Invalid schema";
    MYSQL_ERRNO[-OB_ERR_INSERT_NULL_ROWKEY] = ER_PRIMARY_CANT_HAVE_NULL;
    SQLSTATE[-OB_ERR_INSERT_NULL_ROWKEY] = "42000";
    STR_ERROR[-OB_ERR_INSERT_NULL_ROWKEY] = "Insert null rowkey";
    STR_USER_ERROR[-OB_ERR_INSERT_NULL_ROWKEY] = "Insert null rowkey";
    MYSQL_ERRNO[-OB_ERR_COLUMN_NOT_FOUND] = -1;
    SQLSTATE[-OB_ERR_COLUMN_NOT_FOUND] = "HY000";
    STR_ERROR[-OB_ERR_COLUMN_NOT_FOUND] = "Column not found";
    STR_USER_ERROR[-OB_ERR_COLUMN_NOT_FOUND] = "Column not found";
    MYSQL_ERRNO[-OB_ERR_DELETE_NULL_ROWKEY] = -1;
    SQLSTATE[-OB_ERR_DELETE_NULL_ROWKEY] = "23000";
    STR_ERROR[-OB_ERR_DELETE_NULL_ROWKEY] = "Delete null rowkey";
    STR_USER_ERROR[-OB_ERR_DELETE_NULL_ROWKEY] = "Delete null rowkey";
    MYSQL_ERRNO[-OB_ERR_USER_EMPTY] = -1;
    SQLSTATE[-OB_ERR_USER_EMPTY] = "01007";
    STR_ERROR[-OB_ERR_USER_EMPTY] = "No user";
    STR_USER_ERROR[-OB_ERR_USER_EMPTY] = "No user";
    MYSQL_ERRNO[-OB_ERR_USER_NOT_EXIST] = ER_NO_SUCH_USER;
    SQLSTATE[-OB_ERR_USER_NOT_EXIST] = "01007";
    STR_ERROR[-OB_ERR_USER_NOT_EXIST] = "User not exist";
    STR_USER_ERROR[-OB_ERR_USER_NOT_EXIST] = "User not exist";
    MYSQL_ERRNO[-OB_ERR_NO_PRIVILEGE] = ER_SPECIFIC_ACCESS_DENIED_ERROR;
    SQLSTATE[-OB_ERR_NO_PRIVILEGE] = "42501";
    STR_ERROR[-OB_ERR_NO_PRIVILEGE] = "Access denied";
    STR_USER_ERROR[-OB_ERR_NO_PRIVILEGE] = "Access denied; you need (at least one of) the %s privilege(s) for this operation";
    MYSQL_ERRNO[-OB_ERR_NO_AVAILABLE_PRIVILEGE_ENTRY] = -1;
    SQLSTATE[-OB_ERR_NO_AVAILABLE_PRIVILEGE_ENTRY] = "HY000";
    STR_ERROR[-OB_ERR_NO_AVAILABLE_PRIVILEGE_ENTRY] = "No privilege entry";
    STR_USER_ERROR[-OB_ERR_NO_AVAILABLE_PRIVILEGE_ENTRY] = "No privilege entry";
    MYSQL_ERRNO[-OB_ERR_WRONG_PASSWORD] = ER_PASSWORD_NO_MATCH;
    SQLSTATE[-OB_ERR_WRONG_PASSWORD] = "42000";
    STR_ERROR[-OB_ERR_WRONG_PASSWORD] = "Incorrect password";
    STR_USER_ERROR[-OB_ERR_WRONG_PASSWORD] = "Incorrect password";
    MYSQL_ERRNO[-OB_ERR_USER_IS_LOCKED] = -1;
    SQLSTATE[-OB_ERR_USER_IS_LOCKED] = "01007";
    STR_ERROR[-OB_ERR_USER_IS_LOCKED] = "User locked";
    STR_USER_ERROR[-OB_ERR_USER_IS_LOCKED] = "User locked";
    MYSQL_ERRNO[-OB_ERR_UPDATE_ROWKEY_COLUMN] = -1;
    SQLSTATE[-OB_ERR_UPDATE_ROWKEY_COLUMN] = "42000";
    STR_ERROR[-OB_ERR_UPDATE_ROWKEY_COLUMN] = "Can not update rowkey column";
    STR_USER_ERROR[-OB_ERR_UPDATE_ROWKEY_COLUMN] = "Can not update rowkey column";
    MYSQL_ERRNO[-OB_ERR_UPDATE_JOIN_COLUMN] = -1;
    SQLSTATE[-OB_ERR_UPDATE_JOIN_COLUMN] = "42000";
    STR_ERROR[-OB_ERR_UPDATE_JOIN_COLUMN] = "Can not update join column";
    STR_USER_ERROR[-OB_ERR_UPDATE_JOIN_COLUMN] = "Can not update join column";
    MYSQL_ERRNO[-OB_ERR_INVALID_COLUMN_NUM] = ER_OPERAND_COLUMNS;
    SQLSTATE[-OB_ERR_INVALID_COLUMN_NUM] = "21000";
    STR_ERROR[-OB_ERR_INVALID_COLUMN_NUM] = "Invalid column number";
    STR_USER_ERROR[-OB_ERR_INVALID_COLUMN_NUM] = "Operand should contain %d column(s)";
    MYSQL_ERRNO[-OB_ERR_PREPARE_STMT_NOT_FOUND] = ER_UNKNOWN_STMT_HANDLER;
    SQLSTATE[-OB_ERR_PREPARE_STMT_NOT_FOUND] = "HY007";
    STR_ERROR[-OB_ERR_PREPARE_STMT_NOT_FOUND] = "Unknown prepared statement handle";
    STR_USER_ERROR[-OB_ERR_PREPARE_STMT_NOT_FOUND] = "statement not prepared, stmt_id=%u";
    MYSQL_ERRNO[-OB_ERR_SYS_VARIABLE_UNKNOWN] = ER_UNKNOWN_SYSTEM_VARIABLE;
    SQLSTATE[-OB_ERR_SYS_VARIABLE_UNKNOWN] = "HY000";
    STR_ERROR[-OB_ERR_SYS_VARIABLE_UNKNOWN] = "Unknown system variable";
    STR_USER_ERROR[-OB_ERR_SYS_VARIABLE_UNKNOWN] = "Unknown system variable '%.*s'";
    MYSQL_ERRNO[-OB_ERR_OLDER_PRIVILEGE_VERSION] = -1;
    SQLSTATE[-OB_ERR_OLDER_PRIVILEGE_VERSION] = "HY000";
    STR_ERROR[-OB_ERR_OLDER_PRIVILEGE_VERSION] = "Older privilege version";
    STR_USER_ERROR[-OB_ERR_OLDER_PRIVILEGE_VERSION] = "Older privilege version";
    MYSQL_ERRNO[-OB_ERR_LACK_OF_ROWKEY_COL] = ER_REQUIRES_PRIMARY_KEY;
    SQLSTATE[-OB_ERR_LACK_OF_ROWKEY_COL] = "42000";
    STR_ERROR[-OB_ERR_LACK_OF_ROWKEY_COL] = "No rowkey column specified";
    STR_USER_ERROR[-OB_ERR_LACK_OF_ROWKEY_COL] = "Primary key column(s) not specified in the WHERE clause";
    MYSQL_ERRNO[-OB_ERR_USER_EXIST] = -1;
    SQLSTATE[-OB_ERR_USER_EXIST] = "42710";
    STR_ERROR[-OB_ERR_USER_EXIST] = "User exists";
    STR_USER_ERROR[-OB_ERR_USER_EXIST] = "User exists";
    MYSQL_ERRNO[-OB_ERR_PASSWORD_EMPTY] = -1;
    SQLSTATE[-OB_ERR_PASSWORD_EMPTY] = "HY000";
    STR_ERROR[-OB_ERR_PASSWORD_EMPTY] = "Empty password";
    STR_USER_ERROR[-OB_ERR_PASSWORD_EMPTY] = "Empty password";
    MYSQL_ERRNO[-OB_ERR_GRANT_PRIVILEGES_TO_CREATE_TABLE] = -1;
    SQLSTATE[-OB_ERR_GRANT_PRIVILEGES_TO_CREATE_TABLE] = "42000";
    STR_ERROR[-OB_ERR_GRANT_PRIVILEGES_TO_CREATE_TABLE] = "Failed to grant privelege";
    STR_USER_ERROR[-OB_ERR_GRANT_PRIVILEGES_TO_CREATE_TABLE] = "Failed to grant privelege";
    MYSQL_ERRNO[-OB_ERR_WRONG_DYNAMIC_PARAM] = -1;
    SQLSTATE[-OB_ERR_WRONG_DYNAMIC_PARAM] = "HY093";
    STR_ERROR[-OB_ERR_WRONG_DYNAMIC_PARAM] = "Wrong dynamic parameters";
    STR_USER_ERROR[-OB_ERR_WRONG_DYNAMIC_PARAM] = "Incorrect arguments number to EXECUTE, need %ld arguments but give %ld";
    MYSQL_ERRNO[-OB_ERR_PARAM_SIZE] = ER_WRONG_PARAMCOUNT_TO_NATIVE_FCT;
    SQLSTATE[-OB_ERR_PARAM_SIZE] = "42000";
    STR_ERROR[-OB_ERR_PARAM_SIZE] = "Incorrect parameter count";
    STR_USER_ERROR[-OB_ERR_PARAM_SIZE] = "Incorrect parameter count in the call to native function '%.*s'";
    MYSQL_ERRNO[-OB_ERR_FUNCTION_UNKNOWN] = ER_SP_DOES_NOT_EXIST;
    SQLSTATE[-OB_ERR_FUNCTION_UNKNOWN] = "42000";
    STR_ERROR[-OB_ERR_FUNCTION_UNKNOWN] = "FUNCTION does not exist";
    STR_USER_ERROR[-OB_ERR_FUNCTION_UNKNOWN] = "%s %s does not exist";
    MYSQL_ERRNO[-OB_ERR_CREAT_MODIFY_TIME_COLUMN] = -1;
    SQLSTATE[-OB_ERR_CREAT_MODIFY_TIME_COLUMN] = "23000";
    STR_ERROR[-OB_ERR_CREAT_MODIFY_TIME_COLUMN] = "CreateTime or ModifyTime column cannot be modified";
    STR_USER_ERROR[-OB_ERR_CREAT_MODIFY_TIME_COLUMN] = "CreateTime or ModifyTime column cannot be modified";
    MYSQL_ERRNO[-OB_ERR_MODIFY_PRIMARY_KEY] = -1;
    SQLSTATE[-OB_ERR_MODIFY_PRIMARY_KEY] = "23000";
    STR_ERROR[-OB_ERR_MODIFY_PRIMARY_KEY] = "Primary key cannot be modified";
    STR_USER_ERROR[-OB_ERR_MODIFY_PRIMARY_KEY] = "Primary key cannot be modified";
    MYSQL_ERRNO[-OB_ERR_PARAM_DUPLICATE] = -1;
    SQLSTATE[-OB_ERR_PARAM_DUPLICATE] = "42000";
    STR_ERROR[-OB_ERR_PARAM_DUPLICATE] = "Duplicated parameters";
    STR_USER_ERROR[-OB_ERR_PARAM_DUPLICATE] = "Duplicated parameters";
    MYSQL_ERRNO[-OB_ERR_TOO_MANY_SESSIONS] = ER_TOO_MANY_USER_CONNECTIONS;
    SQLSTATE[-OB_ERR_TOO_MANY_SESSIONS] = "42000";
    STR_ERROR[-OB_ERR_TOO_MANY_SESSIONS] = "Too many sessions";
    STR_USER_ERROR[-OB_ERR_TOO_MANY_SESSIONS] = "Too many sessions";
    MYSQL_ERRNO[-OB_ERR_TOO_MANY_PS] = -1;
    SQLSTATE[-OB_ERR_TOO_MANY_PS] = "54023";
    STR_ERROR[-OB_ERR_TOO_MANY_PS] = "Too many prepared statements";
    STR_USER_ERROR[-OB_ERR_TOO_MANY_PS] = "Too many prepared statements";
    MYSQL_ERRNO[-OB_ERR_HINT_UNKNOWN] = -1;
    SQLSTATE[-OB_ERR_HINT_UNKNOWN] = "42000";
    STR_ERROR[-OB_ERR_HINT_UNKNOWN] = "Unknown hint";
    STR_USER_ERROR[-OB_ERR_HINT_UNKNOWN] = "Unknown hint";
    MYSQL_ERRNO[-OB_ERR_WHEN_UNSATISFIED] = -1;
    SQLSTATE[-OB_ERR_WHEN_UNSATISFIED] = "23000";
    STR_ERROR[-OB_ERR_WHEN_UNSATISFIED] = "When condition not satisfied";
    STR_USER_ERROR[-OB_ERR_WHEN_UNSATISFIED] = "When condition not satisfied";
    MYSQL_ERRNO[-OB_ERR_QUERY_INTERRUPTED] = ER_QUERY_INTERRUPTED;
    SQLSTATE[-OB_ERR_QUERY_INTERRUPTED] = "70100";
    STR_ERROR[-OB_ERR_QUERY_INTERRUPTED] = "Query execution was interrupted";
    STR_USER_ERROR[-OB_ERR_QUERY_INTERRUPTED] = "Query execution was interrupted";
    MYSQL_ERRNO[-OB_ERR_SESSION_INTERRUPTED] = -1;
    SQLSTATE[-OB_ERR_SESSION_INTERRUPTED] = "HY000";
    STR_ERROR[-OB_ERR_SESSION_INTERRUPTED] = "Session interrupted";
    STR_USER_ERROR[-OB_ERR_SESSION_INTERRUPTED] = "Session interrupted";
    MYSQL_ERRNO[-OB_ERR_UNKNOWN_SESSION_ID] = -1;
    SQLSTATE[-OB_ERR_UNKNOWN_SESSION_ID] = "HY000";
    STR_ERROR[-OB_ERR_UNKNOWN_SESSION_ID] = "Unknown session ID";
    STR_USER_ERROR[-OB_ERR_UNKNOWN_SESSION_ID] = "Unknown session ID";
    MYSQL_ERRNO[-OB_ERR_PROTOCOL_NOT_RECOGNIZE] = -1;
    SQLSTATE[-OB_ERR_PROTOCOL_NOT_RECOGNIZE] = "HY000";
    STR_ERROR[-OB_ERR_PROTOCOL_NOT_RECOGNIZE] = "Incorrect protocol";
    STR_USER_ERROR[-OB_ERR_PROTOCOL_NOT_RECOGNIZE] = "Incorrect protocol";
    MYSQL_ERRNO[-OB_ERR_WRITE_AUTH_ERROR] = -1;
    SQLSTATE[-OB_ERR_WRITE_AUTH_ERROR] = "HY000";
    STR_ERROR[-OB_ERR_WRITE_AUTH_ERROR] = "Write auth packet error";
    STR_USER_ERROR[-OB_ERR_WRITE_AUTH_ERROR] = "Write auth packet error";
    MYSQL_ERRNO[-OB_ERR_PARSE_JOIN_INFO] = -1;
    SQLSTATE[-OB_ERR_PARSE_JOIN_INFO] = "42000";
    STR_ERROR[-OB_ERR_PARSE_JOIN_INFO] = "Wrong join info";
    STR_USER_ERROR[-OB_ERR_PARSE_JOIN_INFO] = "Wrong join info";
    MYSQL_ERRNO[-OB_ERR_ALTER_INDEX_COLUMN] = -1;
    SQLSTATE[-OB_ERR_ALTER_INDEX_COLUMN] = "42000";
    STR_ERROR[-OB_ERR_ALTER_INDEX_COLUMN] = "Cannot alter index column";
    STR_USER_ERROR[-OB_ERR_ALTER_INDEX_COLUMN] = "Cannot alter index column";
    MYSQL_ERRNO[-OB_ERR_MODIFY_INDEX_TABLE] = -1;
    SQLSTATE[-OB_ERR_MODIFY_INDEX_TABLE] = "42000";
    STR_ERROR[-OB_ERR_MODIFY_INDEX_TABLE] = "Cannot modify index table";
    STR_USER_ERROR[-OB_ERR_MODIFY_INDEX_TABLE] = "Cannot modify index table";
    MYSQL_ERRNO[-OB_ERR_INDEX_UNAVAILABLE] = ER_NO_SUCH_INDEX;
    SQLSTATE[-OB_ERR_INDEX_UNAVAILABLE] = "42000";
    STR_ERROR[-OB_ERR_INDEX_UNAVAILABLE] = "Index unavailable";
    STR_USER_ERROR[-OB_ERR_INDEX_UNAVAILABLE] = "Index unavailable";
    MYSQL_ERRNO[-OB_ERR_NOP_VALUE] = -1;
    SQLSTATE[-OB_ERR_NOP_VALUE] = "23000";
    STR_ERROR[-OB_ERR_NOP_VALUE] = "NOP cannot be used here";
    STR_USER_ERROR[-OB_ERR_NOP_VALUE] = "NOP cannot be used here";
    MYSQL_ERRNO[-OB_ERR_PS_TOO_MANY_PARAM] = ER_PS_MANY_PARAM;
    SQLSTATE[-OB_ERR_PS_TOO_MANY_PARAM] = "54000";
    STR_ERROR[-OB_ERR_PS_TOO_MANY_PARAM] = "Prepared statement contains too many placeholders";
    STR_USER_ERROR[-OB_ERR_PS_TOO_MANY_PARAM] = "Prepared statement contains too many placeholders";
    MYSQL_ERRNO[-OB_ERR_READ_ONLY] = -1;
    SQLSTATE[-OB_ERR_READ_ONLY] = "25000";
    STR_ERROR[-OB_ERR_READ_ONLY] = "The server is read only now";
    STR_USER_ERROR[-OB_ERR_READ_ONLY] = "The server is read only now";
    MYSQL_ERRNO[-OB_ERR_INVALID_TYPE_FOR_OP] = -1;
    SQLSTATE[-OB_ERR_INVALID_TYPE_FOR_OP] = "22000";
    STR_ERROR[-OB_ERR_INVALID_TYPE_FOR_OP] = "Invalid data type for the operation";
    STR_USER_ERROR[-OB_ERR_INVALID_TYPE_FOR_OP] = "invalid obj type for type promotion, left_type=%d right_type=%d";
    MYSQL_ERRNO[-OB_ERR_CAST_VARCHAR_TO_BOOL] = -1;
    SQLSTATE[-OB_ERR_CAST_VARCHAR_TO_BOOL] = "22000";
    STR_ERROR[-OB_ERR_CAST_VARCHAR_TO_BOOL] = "Can not cast varchar value to bool type";
    STR_USER_ERROR[-OB_ERR_CAST_VARCHAR_TO_BOOL] = "Can not cast varchar value to bool type";
    MYSQL_ERRNO[-OB_ERR_CAST_VARCHAR_TO_NUMBER] = -1;
    SQLSTATE[-OB_ERR_CAST_VARCHAR_TO_NUMBER] = "22000";
    STR_ERROR[-OB_ERR_CAST_VARCHAR_TO_NUMBER] = "Not a number Can not cast varchar value to number type";
    STR_USER_ERROR[-OB_ERR_CAST_VARCHAR_TO_NUMBER] = "Not a number Can not cast varchar value to number type";
    MYSQL_ERRNO[-OB_ERR_CAST_VARCHAR_TO_TIME] = -1;
    SQLSTATE[-OB_ERR_CAST_VARCHAR_TO_TIME] = "22000";
    STR_ERROR[-OB_ERR_CAST_VARCHAR_TO_TIME] = "Not timestamp Can not cast varchar value to timestamp type";
    STR_USER_ERROR[-OB_ERR_CAST_VARCHAR_TO_TIME] = "Not timestamp Can not cast varchar value to timestamp type";
    MYSQL_ERRNO[-OB_ERR_CAST_NUMBER_OVERFLOW] = -1;
    SQLSTATE[-OB_ERR_CAST_NUMBER_OVERFLOW] = "22000";
    STR_ERROR[-OB_ERR_CAST_NUMBER_OVERFLOW] = "Result value was out of range when cast to number";
    STR_USER_ERROR[-OB_ERR_CAST_NUMBER_OVERFLOW] = "Result value was out of range when cast to number";
    MYSQL_ERRNO[-OB_INTEGER_PRECISION_OVERFLOW] = -1;
    SQLSTATE[-OB_INTEGER_PRECISION_OVERFLOW] = "22000";
    STR_ERROR[-OB_INTEGER_PRECISION_OVERFLOW] = "Result value was out of range when cast varchar to number";
    STR_USER_ERROR[-OB_INTEGER_PRECISION_OVERFLOW] = "value larger than specified precision(%ld,%ld) allowed for this column";
    MYSQL_ERRNO[-OB_DECIMAL_PRECISION_OVERFLOW] = -1;
    SQLSTATE[-OB_DECIMAL_PRECISION_OVERFLOW] = "22000";
    STR_ERROR[-OB_DECIMAL_PRECISION_OVERFLOW] = "Result value was out of range when cast varchar to number";
    STR_USER_ERROR[-OB_DECIMAL_PRECISION_OVERFLOW] = "value(%s) larger than specified precision(%ld,%ld) allowed for this column";
    MYSQL_ERRNO[-OB_SCHEMA_NUMBER_PRECISION_OVERFLOW] = -1;
    SQLSTATE[-OB_SCHEMA_NUMBER_PRECISION_OVERFLOW] = "22000";
    STR_ERROR[-OB_SCHEMA_NUMBER_PRECISION_OVERFLOW] = "Precision was out of range";
    STR_USER_ERROR[-OB_SCHEMA_NUMBER_PRECISION_OVERFLOW] = "Precision was out of range";
    MYSQL_ERRNO[-OB_SCHEMA_NUMBER_SCALE_OVERFLOW] = -1;
    SQLSTATE[-OB_SCHEMA_NUMBER_SCALE_OVERFLOW] = "22000";
    STR_ERROR[-OB_SCHEMA_NUMBER_SCALE_OVERFLOW] = "Scale value was out of range";
    STR_USER_ERROR[-OB_SCHEMA_NUMBER_SCALE_OVERFLOW] = "Scale value was out of range";
    MYSQL_ERRNO[-OB_ERR_INDEX_UNKNOWN] = -1;
    SQLSTATE[-OB_ERR_INDEX_UNKNOWN] = "42000";
    STR_ERROR[-OB_ERR_INDEX_UNKNOWN] = "Unknown index";
    STR_USER_ERROR[-OB_ERR_INDEX_UNKNOWN] = "Unknown index";
    MYSQL_ERRNO[-OB_NUMERIC_OVERFLOW] = -1;
    SQLSTATE[-OB_NUMERIC_OVERFLOW] = "22000";
    STR_ERROR[-OB_NUMERIC_OVERFLOW] = "numeric overflow";
    STR_USER_ERROR[-OB_NUMERIC_OVERFLOW] = "numeric overflow";
    MYSQL_ERRNO[-OB_ERR_TOO_MANY_JOIN_TABLES] = -1;
    SQLSTATE[-OB_ERR_TOO_MANY_JOIN_TABLES] = "HY000";
    STR_ERROR[-OB_ERR_TOO_MANY_JOIN_TABLES] = "too many joined tables";
    STR_USER_ERROR[-OB_ERR_TOO_MANY_JOIN_TABLES] = "too many joined tables";
    MYSQL_ERRNO[-OB_ERR_VARCHAR_TOO_LONG] = -1;
    SQLSTATE[-OB_ERR_VARCHAR_TOO_LONG] = "22001";
    STR_ERROR[-OB_ERR_VARCHAR_TOO_LONG] = "Varchar value is too long for the column";
    STR_USER_ERROR[-OB_ERR_VARCHAR_TOO_LONG] = "Data too long(%d>%ld) for column '%s'";
    MYSQL_ERRNO[-OB_ERR_SYS_CONFIG_UNKNOWN] = -1;
    SQLSTATE[-OB_ERR_SYS_CONFIG_UNKNOWN] = "42000";
    STR_ERROR[-OB_ERR_SYS_CONFIG_UNKNOWN] = "System config unknown";
    STR_USER_ERROR[-OB_ERR_SYS_CONFIG_UNKNOWN] = "System config unknown";
    MYSQL_ERRNO[-OB_ERR_LOCAL_VARIABLE] = ER_LOCAL_VARIABLE;
    SQLSTATE[-OB_ERR_LOCAL_VARIABLE] = "HY000";
    STR_ERROR[-OB_ERR_LOCAL_VARIABLE] = "Local variable";
    STR_USER_ERROR[-OB_ERR_LOCAL_VARIABLE] = "Variable \'%.*s\' is a SESSION variable and can't be used with SET GLOBAL";
    MYSQL_ERRNO[-OB_ERR_GLOBAL_VARIABLE] = ER_GLOBAL_VARIABLE;
    SQLSTATE[-OB_ERR_GLOBAL_VARIABLE] = "HY000";
    STR_ERROR[-OB_ERR_GLOBAL_VARIABLE] = "Global variable";
    STR_USER_ERROR[-OB_ERR_GLOBAL_VARIABLE] = "Variable \'%.*s\' is a GLOBAL variable and should be set with SET GLOBAL";
    MYSQL_ERRNO[-OB_ERR_VARIABLE_IS_READONLY] = ER_VARIABLE_IS_READONLY;
    SQLSTATE[-OB_ERR_VARIABLE_IS_READONLY] = "HY000";
    STR_ERROR[-OB_ERR_VARIABLE_IS_READONLY] = "variable is read only";
    STR_USER_ERROR[-OB_ERR_VARIABLE_IS_READONLY] = "%.*s variable '%.*s' is read-only. Use SET %.*s to assign the value";
    MYSQL_ERRNO[-OB_ERR_INCORRECT_GLOBAL_LOCAL_VAR] = ER_INCORRECT_GLOBAL_LOCAL_VAR;
    SQLSTATE[-OB_ERR_INCORRECT_GLOBAL_LOCAL_VAR] = "HY000";
    STR_ERROR[-OB_ERR_INCORRECT_GLOBAL_LOCAL_VAR] = "incorrect global or local variable";
    STR_USER_ERROR[-OB_ERR_INCORRECT_GLOBAL_LOCAL_VAR] = "Variable '%.*s' is a %.*s variable";
    MYSQL_ERRNO[-OB_ERR_EXPIRE_INFO_TOO_LONG] = -1;
    SQLSTATE[-OB_ERR_EXPIRE_INFO_TOO_LONG] = "42000";
    STR_ERROR[-OB_ERR_EXPIRE_INFO_TOO_LONG] = "Expire expression too long";
    STR_USER_ERROR[-OB_ERR_EXPIRE_INFO_TOO_LONG] = "length(%d) of expire_info is larger than the max allowed(%ld)";
    MYSQL_ERRNO[-OB_ERR_EXPIRE_COND_TOO_LONG] = -1;
    SQLSTATE[-OB_ERR_EXPIRE_COND_TOO_LONG] = "42000";
    STR_ERROR[-OB_ERR_EXPIRE_COND_TOO_LONG] = "Expire condition too long";
    STR_USER_ERROR[-OB_ERR_EXPIRE_COND_TOO_LONG] = "total length(%ld) of expire_info and its expression is larger than the max allowed(%ld)";
    MYSQL_ERRNO[-OB_INVALID_ARGUMENT_FOR_EXTRACT] = -1;
    SQLSTATE[-OB_INVALID_ARGUMENT_FOR_EXTRACT] = "42000";
    STR_ERROR[-OB_INVALID_ARGUMENT_FOR_EXTRACT] = "Invalid argument for extract()";
    STR_USER_ERROR[-OB_INVALID_ARGUMENT_FOR_EXTRACT] = "EXTRACT() expected timestamp or a string as date argument";
    MYSQL_ERRNO[-OB_INVALID_ARGUMENT_FOR_IS] = -1;
    SQLSTATE[-OB_INVALID_ARGUMENT_FOR_IS] = "42000";
    STR_ERROR[-OB_INVALID_ARGUMENT_FOR_IS] = "Invalid argument for IS operator";
    STR_USER_ERROR[-OB_INVALID_ARGUMENT_FOR_IS] = "Invalid operand type for IS operator, lval=%s";
    MYSQL_ERRNO[-OB_INVALID_ARGUMENT_FOR_LENGTH] = -1;
    SQLSTATE[-OB_INVALID_ARGUMENT_FOR_LENGTH] = "42000";
    STR_ERROR[-OB_INVALID_ARGUMENT_FOR_LENGTH] = "Invalid argument for length()";
    STR_USER_ERROR[-OB_INVALID_ARGUMENT_FOR_LENGTH] = "function LENGTH() expected a varchar argument";
    MYSQL_ERRNO[-OB_INVALID_ARGUMENT_FOR_SUBSTR] = -1;
    SQLSTATE[-OB_INVALID_ARGUMENT_FOR_SUBSTR] = "42000";
    STR_ERROR[-OB_INVALID_ARGUMENT_FOR_SUBSTR] = "Invalid argument for substr()";
    STR_USER_ERROR[-OB_INVALID_ARGUMENT_FOR_SUBSTR] = "invalid input format. ret=%d text=%s start=%s length=%s";
    MYSQL_ERRNO[-OB_INVALID_ARGUMENT_FOR_TIME_TO_USEC] = -1;
    SQLSTATE[-OB_INVALID_ARGUMENT_FOR_TIME_TO_USEC] = "42000";
    STR_ERROR[-OB_INVALID_ARGUMENT_FOR_TIME_TO_USEC] = "Invalid argument for time_to_usec()";
    STR_USER_ERROR[-OB_INVALID_ARGUMENT_FOR_TIME_TO_USEC] = "TIME_TO_USEC() expected timestamp or a string as date argument";
    MYSQL_ERRNO[-OB_INVALID_ARGUMENT_FOR_USEC_TO_TIME] = -1;
    SQLSTATE[-OB_INVALID_ARGUMENT_FOR_USEC_TO_TIME] = "42000";
    STR_ERROR[-OB_INVALID_ARGUMENT_FOR_USEC_TO_TIME] = "Invalid argument for usec_to_time()";
    STR_USER_ERROR[-OB_INVALID_ARGUMENT_FOR_USEC_TO_TIME] = "USEC_TO_TIME expected a interger number as usec argument";
    MYSQL_ERRNO[-OB_ERR_USER_VARIABLE_UNKNOWN] = -1;
    SQLSTATE[-OB_ERR_USER_VARIABLE_UNKNOWN] = "42P01";
    STR_ERROR[-OB_ERR_USER_VARIABLE_UNKNOWN] = "Unknown user variable";
    STR_USER_ERROR[-OB_ERR_USER_VARIABLE_UNKNOWN] = "Variable %.*s does not exists";
    MYSQL_ERRNO[-OB_ILLEGAL_USAGE_OF_MERGING_FROZEN_TIME] = -1;
    SQLSTATE[-OB_ILLEGAL_USAGE_OF_MERGING_FROZEN_TIME] = "42000";
    STR_ERROR[-OB_ILLEGAL_USAGE_OF_MERGING_FROZEN_TIME] = "Illegal usage of merging_frozen_time()";
    STR_USER_ERROR[-OB_ILLEGAL_USAGE_OF_MERGING_FROZEN_TIME] = "MERGING_FROZEN_TIME() system function only be used in daily merging.";
    MYSQL_ERRNO[-OB_INVALID_NUMERIC] = -1;
    SQLSTATE[-OB_INVALID_NUMERIC] = "42000";
    STR_ERROR[-OB_INVALID_NUMERIC] = "Invalid numeric";
    STR_USER_ERROR[-OB_INVALID_NUMERIC] = "Invalid numeric char '%c'";
    MYSQL_ERRNO[-OB_ERR_REGEXP_ERROR] = ER_REGEXP_ERROR;
    SQLSTATE[-OB_ERR_REGEXP_ERROR] = "42000";
    STR_ERROR[-OB_ERR_REGEXP_ERROR] = "Got error 'empty (sub)expression' from regexp";
    STR_USER_ERROR[-OB_ERR_REGEXP_ERROR] = "Got error 'empty (sub)expression' from regexp";
    MYSQL_ERRNO[-OB_SQL_LOG_OP_SETCHILD_OVERFLOW] = -1;
    SQLSTATE[-OB_SQL_LOG_OP_SETCHILD_OVERFLOW] = "HY000";
    STR_ERROR[-OB_SQL_LOG_OP_SETCHILD_OVERFLOW] = "Logical operator child index overflow";
    STR_USER_ERROR[-OB_SQL_LOG_OP_SETCHILD_OVERFLOW] = "Logical operator child index overflow";
    MYSQL_ERRNO[-OB_SQL_EXPLAIN_FAILED] = -1;
    SQLSTATE[-OB_SQL_EXPLAIN_FAILED] = "HY000";
    STR_ERROR[-OB_SQL_EXPLAIN_FAILED] = "fail to explain plan";
    STR_USER_ERROR[-OB_SQL_EXPLAIN_FAILED] = "fail to explain plan";
    MYSQL_ERRNO[-OB_SQL_OPT_COPY_OP_FAILED] = -1;
    SQLSTATE[-OB_SQL_OPT_COPY_OP_FAILED] = "HY000";
    STR_ERROR[-OB_SQL_OPT_COPY_OP_FAILED] = "fail to copy logical operator";
    STR_USER_ERROR[-OB_SQL_OPT_COPY_OP_FAILED] = "fail to copy logical operator";
    MYSQL_ERRNO[-OB_SQL_OPT_GEN_PLAN_FALIED] = -1;
    SQLSTATE[-OB_SQL_OPT_GEN_PLAN_FALIED] = "HY000";
    STR_ERROR[-OB_SQL_OPT_GEN_PLAN_FALIED] = "fail to generate plan";
    STR_USER_ERROR[-OB_SQL_OPT_GEN_PLAN_FALIED] = "fail to generate plan";
    MYSQL_ERRNO[-OB_SQL_OPT_CREATE_RAWEXPR_FAILED] = -1;
    SQLSTATE[-OB_SQL_OPT_CREATE_RAWEXPR_FAILED] = "HY000";
    STR_ERROR[-OB_SQL_OPT_CREATE_RAWEXPR_FAILED] = "fail to create raw expr";
    STR_USER_ERROR[-OB_SQL_OPT_CREATE_RAWEXPR_FAILED] = "fail to create raw expr";
    MYSQL_ERRNO[-OB_SQL_OPT_JOIN_ORDER_FAILED] = -1;
    SQLSTATE[-OB_SQL_OPT_JOIN_ORDER_FAILED] = "HY000";
    STR_ERROR[-OB_SQL_OPT_JOIN_ORDER_FAILED] = "fail to generate join order";
    STR_USER_ERROR[-OB_SQL_OPT_JOIN_ORDER_FAILED] = "fail to generate join order";
    MYSQL_ERRNO[-OB_SQL_OPT_ERROR] = -1;
    SQLSTATE[-OB_SQL_OPT_ERROR] = "HY000";
    STR_ERROR[-OB_SQL_OPT_ERROR] = "optimizer general error";
    STR_USER_ERROR[-OB_SQL_OPT_ERROR] = "optimizer general error";
    MYSQL_ERRNO[-OB_SQL_RESOLVER_NO_MEMORY] = -1;
    SQLSTATE[-OB_SQL_RESOLVER_NO_MEMORY] = "HY000";
    STR_ERROR[-OB_SQL_RESOLVER_NO_MEMORY] = "sql resolver no memory";
    STR_USER_ERROR[-OB_SQL_RESOLVER_NO_MEMORY] = "sql resolver no memory";
    MYSQL_ERRNO[-OB_SQL_DML_ONLY] = -1;
    SQLSTATE[-OB_SQL_DML_ONLY] = "HY000";
    STR_ERROR[-OB_SQL_DML_ONLY] = "plan cache support dml only";
    STR_USER_ERROR[-OB_SQL_DML_ONLY] = "plan cache support dml only";
    MYSQL_ERRNO[-OB_ERR_NO_GRANT] = -1;
    SQLSTATE[-OB_ERR_NO_GRANT] = "42000";
    STR_ERROR[-OB_ERR_NO_GRANT] = "No such grant defined";
    STR_USER_ERROR[-OB_ERR_NO_GRANT] = "No such grant defined";
    MYSQL_ERRNO[-OB_ERR_NO_DB_SELECTED] = ER_NO_DB_ERROR;
    SQLSTATE[-OB_ERR_NO_DB_SELECTED] = "3D000";
    STR_ERROR[-OB_ERR_NO_DB_SELECTED] = "No database selected";
    STR_USER_ERROR[-OB_ERR_NO_DB_SELECTED] = "No database selected";
    MYSQL_ERRNO[-OB_SQL_PC_OVERFLOW] = -1;
    SQLSTATE[-OB_SQL_PC_OVERFLOW] = "HY000";
    STR_ERROR[-OB_SQL_PC_OVERFLOW] = "plan cache is overflow";
    STR_USER_ERROR[-OB_SQL_PC_OVERFLOW] = "plan cache is overflow";
    MYSQL_ERRNO[-OB_SQL_PC_PLAN_DUPLICATE] = -1;
    SQLSTATE[-OB_SQL_PC_PLAN_DUPLICATE] = "HY000";
    STR_ERROR[-OB_SQL_PC_PLAN_DUPLICATE] = "plan exists in plan cache already";
    STR_USER_ERROR[-OB_SQL_PC_PLAN_DUPLICATE] = "plan exists in plan cache already";
    MYSQL_ERRNO[-OB_SQL_PC_PLAN_EXPIRE] = -1;
    SQLSTATE[-OB_SQL_PC_PLAN_EXPIRE] = "HY000";
    STR_ERROR[-OB_SQL_PC_PLAN_EXPIRE] = "plan is expired";
    STR_USER_ERROR[-OB_SQL_PC_PLAN_EXPIRE] = "plan is expired";
    MYSQL_ERRNO[-OB_SQL_PC_NOT_EXIST] = -1;
    SQLSTATE[-OB_SQL_PC_NOT_EXIST] = "HY000";
    STR_ERROR[-OB_SQL_PC_NOT_EXIST] = "no plan exist";
    STR_USER_ERROR[-OB_SQL_PC_NOT_EXIST] = "no plan exist";
    MYSQL_ERRNO[-OB_SQL_PARAMS_LIMIT] = -1;
    SQLSTATE[-OB_SQL_PARAMS_LIMIT] = "HY000";
    STR_ERROR[-OB_SQL_PARAMS_LIMIT] = "too many params, plan cache not support";
    STR_USER_ERROR[-OB_SQL_PARAMS_LIMIT] = "too many params, plan cache not support";
    MYSQL_ERRNO[-OB_SQL_PC_PLAN_SIZE_LIMIT] = -1;
    SQLSTATE[-OB_SQL_PC_PLAN_SIZE_LIMIT] = "HY000";
    STR_ERROR[-OB_SQL_PC_PLAN_SIZE_LIMIT] = "plan is too big to add to plan cache";
    STR_USER_ERROR[-OB_SQL_PC_PLAN_SIZE_LIMIT] = "plan is too big to add to plan cache";
    MYSQL_ERRNO[-OB_ERR_UNKNOWN_CHARSET] = ER_UNKNOWN_CHARACTER_SET;
    SQLSTATE[-OB_ERR_UNKNOWN_CHARSET] = "42000";
    STR_ERROR[-OB_ERR_UNKNOWN_CHARSET] = "Unknown character set";
    STR_USER_ERROR[-OB_ERR_UNKNOWN_CHARSET] = "Unknown character set: '%.*s'";
    MYSQL_ERRNO[-OB_ERR_UNKNOWN_COLLATION] = ER_UNKNOWN_COLLATION;
    SQLSTATE[-OB_ERR_UNKNOWN_COLLATION] = "HY000";
    STR_ERROR[-OB_ERR_UNKNOWN_COLLATION] = "Unknown collation";
    STR_USER_ERROR[-OB_ERR_UNKNOWN_COLLATION] = "Unknown collation: '%.*s'";
    MYSQL_ERRNO[-OB_ERR_COLLATION_MISMATCH] = ER_COLLATION_CHARSET_MISMATCH;
    SQLSTATE[-OB_ERR_COLLATION_MISMATCH] = "42000";
    STR_ERROR[-OB_ERR_COLLATION_MISMATCH] = "The collation is not valid for the character set";
    STR_USER_ERROR[-OB_ERR_COLLATION_MISMATCH] = "COLLATION '%.*s' is not valid for CHARACTER SET '%.*s'";
    MYSQL_ERRNO[-OB_ERR_WRONG_VALUE_FOR_VAR] = ER_WRONG_VALUE_FOR_VAR;
    SQLSTATE[-OB_ERR_WRONG_VALUE_FOR_VAR] = "42000";
    STR_ERROR[-OB_ERR_WRONG_VALUE_FOR_VAR] = "Variable can't be set to the value";
    STR_USER_ERROR[-OB_ERR_WRONG_VALUE_FOR_VAR] = "Variable \'%.*s\' can't be set to the value of \'%.*s\'";
    MYSQL_ERRNO[-OB_UNKNOWN_PARTITION] = ER_UNKNOWN_PARTITION;
    SQLSTATE[-OB_UNKNOWN_PARTITION] = "HY000";
    STR_ERROR[-OB_UNKNOWN_PARTITION] = "Unknown partition";
    STR_USER_ERROR[-OB_UNKNOWN_PARTITION] = "Unkown partition '%.*s' in table '%.*s'";
    MYSQL_ERRNO[-OB_PARTITION_NOT_MATCH] = ER_ROW_DOES_NOT_MATCH_GIVEN_PARTITION_SET;
    SQLSTATE[-OB_PARTITION_NOT_MATCH] = "HY000";
    STR_ERROR[-OB_PARTITION_NOT_MATCH] = "Found a row not matching the given partition set";
    STR_USER_ERROR[-OB_PARTITION_NOT_MATCH] = "Found a row not matching the given partition set";
    MYSQL_ERRNO[-OB_ER_PASSWD_LENGTH] = -1;
    SQLSTATE[-OB_ER_PASSWD_LENGTH] = "HY000";
    STR_ERROR[-OB_ER_PASSWD_LENGTH] = " Password hash should be a 40-digit hexadecimal number";
    STR_USER_ERROR[-OB_ER_PASSWD_LENGTH] = " Password hash should be a 40-digit hexadecimal number";
    MYSQL_ERRNO[-OB_ERR_INSERT_INNER_JOIN_COLUMN] = -1;
    SQLSTATE[-OB_ERR_INSERT_INNER_JOIN_COLUMN] = "07000";
    STR_ERROR[-OB_ERR_INSERT_INNER_JOIN_COLUMN] = "Insert inner join column error";
    STR_USER_ERROR[-OB_ERR_INSERT_INNER_JOIN_COLUMN] = "Insert inner join column error";
    MYSQL_ERRNO[-OB_TENANT_NOT_IN_SERVER] = -1;
    SQLSTATE[-OB_TENANT_NOT_IN_SERVER] = "HY000";
    STR_ERROR[-OB_TENANT_NOT_IN_SERVER] = "Tenant not in this server";
    STR_USER_ERROR[-OB_TENANT_NOT_IN_SERVER] = "Tenant not in this server";
    MYSQL_ERRNO[-OB_TABLEGROUP_NOT_EXIST] = -1;
    SQLSTATE[-OB_TABLEGROUP_NOT_EXIST] = "42P01";
    STR_ERROR[-OB_TABLEGROUP_NOT_EXIST] = "tablegroup not exist";
    STR_USER_ERROR[-OB_TABLEGROUP_NOT_EXIST] = "tablegroup not exist";
    MYSQL_ERRNO[-OB_SUBQUERY_TOO_MANY_ROW] = ER_SUBQUERY_NO_1_ROW;
    SQLSTATE[-OB_SUBQUERY_TOO_MANY_ROW] = "21000";
    STR_ERROR[-OB_SUBQUERY_TOO_MANY_ROW] = "Subquery returns more than 1 row";
    STR_USER_ERROR[-OB_SUBQUERY_TOO_MANY_ROW] = "Subquery returns more than 1 row";
    MYSQL_ERRNO[-OB_ERR_BAD_DATABASE] = ER_BAD_DB_ERROR;
    SQLSTATE[-OB_ERR_BAD_DATABASE] = "42000";
    STR_ERROR[-OB_ERR_BAD_DATABASE] = "Unknown database";
    STR_USER_ERROR[-OB_ERR_BAD_DATABASE] = "Unknown database '%.*s'";
    MYSQL_ERRNO[-OB_CANNOT_USER] = ER_CANNOT_USER;
    SQLSTATE[-OB_CANNOT_USER] = "HY000";
    STR_ERROR[-OB_CANNOT_USER] = "User operation failed";
    STR_USER_ERROR[-OB_CANNOT_USER] = "Operation %.*s failed for %.*s";
    MYSQL_ERRNO[-OB_TENANT_EXIST] = -1;
    SQLSTATE[-OB_TENANT_EXIST] = "HY000";
    STR_ERROR[-OB_TENANT_EXIST] = "tenant already exist";
    STR_USER_ERROR[-OB_TENANT_EXIST] = "tenant \'%s\' already exist";
    MYSQL_ERRNO[-OB_TENANT_NOT_EXIST] = -1;
    SQLSTATE[-OB_TENANT_NOT_EXIST] = "HY000";
    STR_ERROR[-OB_TENANT_NOT_EXIST] = "Unknown tenant";
    STR_USER_ERROR[-OB_TENANT_NOT_EXIST] = "Unknown tenant '%.*s'";
    MYSQL_ERRNO[-OB_DATABASE_EXIST] = ER_DB_CREATE_EXISTS;
    SQLSTATE[-OB_DATABASE_EXIST] = "HY000";
    STR_ERROR[-OB_DATABASE_EXIST] = "Can't create database;database exists";
    STR_USER_ERROR[-OB_DATABASE_EXIST] = "Can't create database '%.*s'; database exists";
    MYSQL_ERRNO[-OB_TABLEGROUP_EXIST] = -1;
    SQLSTATE[-OB_TABLEGROUP_EXIST] = "HY000";
    STR_ERROR[-OB_TABLEGROUP_EXIST] = "tablegroup already exist";
    STR_USER_ERROR[-OB_TABLEGROUP_EXIST] = "tablegroup already exist";
    MYSQL_ERRNO[-OB_ERR_INVALID_TENANT_NAME] = -1;
    SQLSTATE[-OB_ERR_INVALID_TENANT_NAME] = "HY000";
    STR_ERROR[-OB_ERR_INVALID_TENANT_NAME] = "invalid tenant name specified in connection string";
    STR_USER_ERROR[-OB_ERR_INVALID_TENANT_NAME] = "invalid tenant name specified in connection string";
    MYSQL_ERRNO[-OB_EMPTY_TENANT] = -1;
    SQLSTATE[-OB_EMPTY_TENANT] = "HY000";
    STR_ERROR[-OB_EMPTY_TENANT] = "tenant is empty";
    STR_USER_ERROR[-OB_EMPTY_TENANT] = "tenant is empty";
    MYSQL_ERRNO[-OB_WRONG_DB_NAME] = ER_WRONG_DB_NAME;
    SQLSTATE[-OB_WRONG_DB_NAME] = "42000";
    STR_ERROR[-OB_WRONG_DB_NAME] = "Incorrect database name";
    STR_USER_ERROR[-OB_WRONG_DB_NAME] = "Incorrect database name '%.*s'";
    MYSQL_ERRNO[-OB_WRONG_TABLE_NAME] = ER_WRONG_TABLE_NAME;
    SQLSTATE[-OB_WRONG_TABLE_NAME] = "42000";
    STR_ERROR[-OB_WRONG_TABLE_NAME] = "Incorrect table name";
    STR_USER_ERROR[-OB_WRONG_TABLE_NAME] = "Incorrect table name '%.*s'";
    MYSQL_ERRNO[-OB_WRONG_COLUMN_NAME] = ER_WRONG_COLUMN_NAME;
    SQLSTATE[-OB_WRONG_COLUMN_NAME] = "42000";
    STR_ERROR[-OB_WRONG_COLUMN_NAME] = "Incorrect column name";
    STR_USER_ERROR[-OB_WRONG_COLUMN_NAME] = "Incorrect column name '%.*s'";
    MYSQL_ERRNO[-OB_ERR_COLUMN_SPEC] = ER_WRONG_FIELD_SPEC;
    SQLSTATE[-OB_ERR_COLUMN_SPEC] = "42000";
    STR_ERROR[-OB_ERR_COLUMN_SPEC] = "Incorrect column specifier";
    STR_USER_ERROR[-OB_ERR_COLUMN_SPEC] = "Incorrect column specifier for column '%.*s'";
    MYSQL_ERRNO[-OB_ERR_DB_DROP_EXISTS] = ER_DB_DROP_EXISTS;
    SQLSTATE[-OB_ERR_DB_DROP_EXISTS] = "HY000";
    STR_ERROR[-OB_ERR_DB_DROP_EXISTS] = "Can't drop database;database doesn't exist";
    STR_USER_ERROR[-OB_ERR_DB_DROP_EXISTS] = "Can't drop database '%.*s'; database doesn't exist";
    MYSQL_ERRNO[-OB_ERR_DATA_TOO_LONG] = ER_DATA_TOO_LONG;
    SQLSTATE[-OB_ERR_DATA_TOO_LONG] = "22001";
    STR_ERROR[-OB_ERR_DATA_TOO_LONG] = "Data too long for column";
    STR_USER_ERROR[-OB_ERR_DATA_TOO_LONG] = "Data too long for column '%.*s' at row %lld";
    MYSQL_ERRNO[-OB_ERR_WRONG_VALUE_COUNT_ON_ROW] = ER_WRONG_VALUE_COUNT_ON_ROW;
    SQLSTATE[-OB_ERR_WRONG_VALUE_COUNT_ON_ROW] = "21S01";
    STR_ERROR[-OB_ERR_WRONG_VALUE_COUNT_ON_ROW] = "column count does not match value count";
    STR_USER_ERROR[-OB_ERR_WRONG_VALUE_COUNT_ON_ROW] = "column count does not match value count at row '%d'";
    MYSQL_ERRNO[-OB_ERR_CREATE_USER_WITH_GRANT] = ER_CANT_CREATE_USER_WITH_GRANT;
    SQLSTATE[-OB_ERR_CREATE_USER_WITH_GRANT] = "42000";
    STR_ERROR[-OB_ERR_CREATE_USER_WITH_GRANT] = "You are not allowed to create a user with GRANT";
    STR_USER_ERROR[-OB_ERR_CREATE_USER_WITH_GRANT] = "You are not allowed to create a user with GRANT";
    MYSQL_ERRNO[-OB_ERR_NO_DB_PRIVILEGE] = ER_DBACCESS_DENIED_ERROR;
    SQLSTATE[-OB_ERR_NO_DB_PRIVILEGE] = "42000";
    STR_ERROR[-OB_ERR_NO_DB_PRIVILEGE] = "Access denied for user to database";
    STR_USER_ERROR[-OB_ERR_NO_DB_PRIVILEGE] = "Access denied for user '%.*s'@'%.*s' to database '%.*s'";
    MYSQL_ERRNO[-OB_ERR_NO_TABLE_PRIVILEGE] = ER_TABLEACCESS_DENIED_ERROR;
    SQLSTATE[-OB_ERR_NO_TABLE_PRIVILEGE] = "42000";
    STR_ERROR[-OB_ERR_NO_TABLE_PRIVILEGE] = "Command denied to user for table";
    STR_USER_ERROR[-OB_ERR_NO_TABLE_PRIVILEGE] = "%.*s command denied to user '%.*s'@'%.*s' for table '%.*s'";
    MYSQL_ERRNO[-OB_INVALID_ON_UPDATE] = ER_INVALID_ON_UPDATE;
    SQLSTATE[-OB_INVALID_ON_UPDATE] = "HY000";
    STR_ERROR[-OB_INVALID_ON_UPDATE] = "Invalid ON UPDATE clause";
    STR_USER_ERROR[-OB_INVALID_ON_UPDATE] = "Invalid ON UPDATE clause for \'%s\' column";
    MYSQL_ERRNO[-OB_INVALID_DEFAULT] = ER_INVALID_DEFAULT;
    SQLSTATE[-OB_INVALID_DEFAULT] = "42000";
    STR_ERROR[-OB_INVALID_DEFAULT] = "Invalid default value";
    STR_USER_ERROR[-OB_INVALID_DEFAULT] = "Invalid default value for \'%.*s\'";
    MYSQL_ERRNO[-OB_ERR_UPDATE_TABLE_USED] = ER_UPDATE_TABLE_USED;
    SQLSTATE[-OB_ERR_UPDATE_TABLE_USED] = "HY000";
    STR_ERROR[-OB_ERR_UPDATE_TABLE_USED] = "Update table used";
    STR_USER_ERROR[-OB_ERR_UPDATE_TABLE_USED] = "You can\'t specify target table \'%s\' for update in FROM clause";
    MYSQL_ERRNO[-OB_ERR_COULUMN_VALUE_NOT_MATCH] = ER_WRONG_VALUE_COUNT_ON_ROW;
    SQLSTATE[-OB_ERR_COULUMN_VALUE_NOT_MATCH] = "21S01";
    STR_ERROR[-OB_ERR_COULUMN_VALUE_NOT_MATCH] = "Column count doesn\'t match value count";
    STR_USER_ERROR[-OB_ERR_COULUMN_VALUE_NOT_MATCH] = "Column count doesn\'t match value count at row %ld";
    MYSQL_ERRNO[-OB_ERR_INVALID_GROUP_FUNC_USE] = ER_INVALID_GROUP_FUNC_USE;
    SQLSTATE[-OB_ERR_INVALID_GROUP_FUNC_USE] = "HY000";
    STR_ERROR[-OB_ERR_INVALID_GROUP_FUNC_USE] = "Invalid use of group function";
    STR_USER_ERROR[-OB_ERR_INVALID_GROUP_FUNC_USE] = "Invalid use of group function";
    MYSQL_ERRNO[-OB_CANT_AGGREGATE_2COLLATIONS] = ER_CANT_AGGREGATE_2COLLATIONS;
    SQLSTATE[-OB_CANT_AGGREGATE_2COLLATIONS] = "HY000";
    STR_ERROR[-OB_CANT_AGGREGATE_2COLLATIONS] = "Illegal mix of collations";
    STR_USER_ERROR[-OB_CANT_AGGREGATE_2COLLATIONS] = "Illegal mix of collations";
    MYSQL_ERRNO[-OB_ERR_FIELD_TYPE_NOT_ALLOWED_AS_PARTITION_FIELD] = ER_FIELD_TYPE_NOT_ALLOWED_AS_PARTITION_FIELD;
    SQLSTATE[-OB_ERR_FIELD_TYPE_NOT_ALLOWED_AS_PARTITION_FIELD] = "HY000";
    STR_ERROR[-OB_ERR_FIELD_TYPE_NOT_ALLOWED_AS_PARTITION_FIELD] = "Field is of a not allowed type for this type of partitioning";
    STR_USER_ERROR[-OB_ERR_FIELD_TYPE_NOT_ALLOWED_AS_PARTITION_FIELD] = "Field \'%.*s\' is of a not allowed type for this type of partitioning";
    MYSQL_ERRNO[-OB_ERR_TOO_LONG_IDENT] = ER_TOO_LONG_IDENT;
    SQLSTATE[-OB_ERR_TOO_LONG_IDENT] = "42000";
    STR_ERROR[-OB_ERR_TOO_LONG_IDENT] = "Identifier name is too long";
    STR_USER_ERROR[-OB_ERR_TOO_LONG_IDENT] = "Identifier name \'%.*s\' is too long";
    MYSQL_ERRNO[-OB_ERR_WRONG_TYPE_FOR_VAR] = ER_WRONG_TYPE_FOR_VAR;
    SQLSTATE[-OB_ERR_WRONG_TYPE_FOR_VAR] = "42000";
    STR_ERROR[-OB_ERR_WRONG_TYPE_FOR_VAR] = "Incorrect argument type to variable";
    STR_USER_ERROR[-OB_ERR_WRONG_TYPE_FOR_VAR] = "Incorrect argument type to variable '%.*s'";
    MYSQL_ERRNO[-OB_WRONG_USER_NAME_LENGTH] = ER_WRONG_STRING_LENGTH;
    SQLSTATE[-OB_WRONG_USER_NAME_LENGTH] = "HY000";
    STR_ERROR[-OB_WRONG_USER_NAME_LENGTH] = "String is too long for user_name (should be no longer than 16)";
    STR_USER_ERROR[-OB_WRONG_USER_NAME_LENGTH] = "String '%.*s' is too long for user name (should be no longer than 16)";
    MYSQL_ERRNO[-OB_ERR_PRIV_USAGE] = ER_WRONG_USAGE;
    SQLSTATE[-OB_ERR_PRIV_USAGE] = "HY000";
    STR_ERROR[-OB_ERR_PRIV_USAGE] = "Incorrect usage of DB GRANT and GLOBAL PRIVILEGES";
    STR_USER_ERROR[-OB_ERR_PRIV_USAGE] = "Incorrect usage of DB GRANT and GLOBAL PRIVILEGES";
    MYSQL_ERRNO[-OB_ILLEGAL_GRANT_FOR_TABLE] = ER_ILLEGAL_GRANT_FOR_TABLE;
    SQLSTATE[-OB_ILLEGAL_GRANT_FOR_TABLE] = "42000";
    STR_ERROR[-OB_ILLEGAL_GRANT_FOR_TABLE] = "Illegal GRANT/REVOKE command; please consult the manual to see which privileges can be used";
    STR_USER_ERROR[-OB_ILLEGAL_GRANT_FOR_TABLE] = "Illegal GRANT/REVOKE command; please consult the manual to see which privileges can be used";
    MYSQL_ERRNO[-OB_ERR_REACH_AUTOINC_MAX] = ER_AUTOINC_READ_FAILED;
    SQLSTATE[-OB_ERR_REACH_AUTOINC_MAX] = "HY000";
    STR_ERROR[-OB_ERR_REACH_AUTOINC_MAX] = "Failed to read auto-increment value from storage engine";
    STR_USER_ERROR[-OB_ERR_REACH_AUTOINC_MAX] = "Failed to read auto-increment value from storage engine";
    MYSQL_ERRNO[-OB_ERR_NO_TABLES_USED] = ER_NO_TABLES_USED;
    SQLSTATE[-OB_ERR_NO_TABLES_USED] = "HY000";
    STR_ERROR[-OB_ERR_NO_TABLES_USED] = "No tables used";
    STR_USER_ERROR[-OB_ERR_NO_TABLES_USED] = "No tables used";
    MYSQL_ERRNO[-OB_CANT_REMOVE_ALL_FIELDS] = ER_CANT_REMOVE_ALL_FIELDS;
    SQLSTATE[-OB_CANT_REMOVE_ALL_FIELDS] = "42000";
    STR_ERROR[-OB_CANT_REMOVE_ALL_FIELDS] = "You can't delete all columns with ALTER TABLE; use DROP TABLE instead";
    STR_USER_ERROR[-OB_CANT_REMOVE_ALL_FIELDS] = "You can't delete all columns with ALTER TABLE; use DROP TABLE instead";
    MYSQL_ERRNO[-OB_TOO_MANY_PARTITIONS_ERROR] = ER_TOO_MANY_PARTITIONS_ERROR;
    SQLSTATE[-OB_TOO_MANY_PARTITIONS_ERROR] = "HY000";
    STR_ERROR[-OB_TOO_MANY_PARTITIONS_ERROR] = "Too many partitions (including subpartitions) were defined";
    STR_USER_ERROR[-OB_TOO_MANY_PARTITIONS_ERROR] = "Too many partitions (including subpartitions) were defined";
    MYSQL_ERRNO[-OB_NO_PARTS_ERROR] = ER_NO_PARTS_ERROR;
    SQLSTATE[-OB_NO_PARTS_ERROR] = "HY000";
    STR_ERROR[-OB_NO_PARTS_ERROR] = "Number of partitions = 0 is not an allowed value";
    STR_USER_ERROR[-OB_NO_PARTS_ERROR] = "Number of partitions = 0 is not an allowed value";
    MYSQL_ERRNO[-OB_WRONG_SUB_KEY] = ER_WRONG_SUB_KEY;
    SQLSTATE[-OB_WRONG_SUB_KEY] = "HY000";
    STR_ERROR[-OB_WRONG_SUB_KEY] = "Incorrect prefix key; the used key part isn't a string, the used length is longer than the key part, or the storage engine doesn't support unique prefix keys";
    STR_USER_ERROR[-OB_WRONG_SUB_KEY] = "Incorrect prefix key; the used key part isn't a string, the used length is longer than the key part, or the storage engine doesn't support unique prefix keys";
    MYSQL_ERRNO[-OB_KEY_PART_0] = ER_KEY_PART_0;
    SQLSTATE[-OB_KEY_PART_0] = "HY000";
    STR_ERROR[-OB_KEY_PART_0] = "Key part length cannot be 0";
    STR_USER_ERROR[-OB_KEY_PART_0] = "Key part \'%.*s\' length cannot be 0";
    MYSQL_ERRNO[-OB_ERR_UNKNOWN_TIME_ZONE] = ER_UNKNOWN_TIME_ZONE;
    SQLSTATE[-OB_ERR_UNKNOWN_TIME_ZONE] = "HY000";
    STR_ERROR[-OB_ERR_UNKNOWN_TIME_ZONE] = "Unknown or incorrect time zone";
    STR_USER_ERROR[-OB_ERR_UNKNOWN_TIME_ZONE] = "Unknown or incorrect time zone: \'%.*s\'";
    MYSQL_ERRNO[-OB_ERR_WRONG_AUTO_KEY] = ER_WRONG_AUTO_KEY;
    SQLSTATE[-OB_ERR_WRONG_AUTO_KEY] = "42000";
    STR_ERROR[-OB_ERR_WRONG_AUTO_KEY] = "Incorrect table definition; there can be only one auto column";
    STR_USER_ERROR[-OB_ERR_WRONG_AUTO_KEY] = "Incorrect table definition; there can be only one auto column";
    MYSQL_ERRNO[-OB_ERR_TOO_MANY_KEYS] = ER_TOO_MANY_KEYS;
    SQLSTATE[-OB_ERR_TOO_MANY_KEYS] = "42000";
    STR_ERROR[-OB_ERR_TOO_MANY_KEYS] = "Too many keys specified";
    STR_USER_ERROR[-OB_ERR_TOO_MANY_KEYS] = "Too many keys specified; max %d keys allowed";
    MYSQL_ERRNO[-OB_ERR_TOO_MANY_ROWKEY_COLUMNS] = ER_TOO_MANY_KEY_PARTS;
    SQLSTATE[-OB_ERR_TOO_MANY_ROWKEY_COLUMNS] = "42000";
    STR_ERROR[-OB_ERR_TOO_MANY_ROWKEY_COLUMNS] = "Too many key parts specified";
    STR_USER_ERROR[-OB_ERR_TOO_MANY_ROWKEY_COLUMNS] = "Too many key parts specified; max %d parts allowed";
    MYSQL_ERRNO[-OB_ERR_TOO_LONG_KEY_LENGTH] = ER_TOO_LONG_KEY;
    SQLSTATE[-OB_ERR_TOO_LONG_KEY_LENGTH] = "42000";
    STR_ERROR[-OB_ERR_TOO_LONG_KEY_LENGTH] = "Specified key was too long";
    STR_USER_ERROR[-OB_ERR_TOO_LONG_KEY_LENGTH] = "Specified key was too long; max key length is %d bytes";
    MYSQL_ERRNO[-OB_ERR_TOO_MANY_COLUMNS] = ER_TOO_MANY_FIELDS;
    SQLSTATE[-OB_ERR_TOO_MANY_COLUMNS] = "42000";
    STR_ERROR[-OB_ERR_TOO_MANY_COLUMNS] = "Too many columns";
    STR_USER_ERROR[-OB_ERR_TOO_MANY_COLUMNS] = "Too many columns";
    MYSQL_ERRNO[-OB_ERR_TOO_LONG_COLUMN_LENGTH] = ER_TOO_BIG_FIELDLENGTH;
    SQLSTATE[-OB_ERR_TOO_LONG_COLUMN_LENGTH] = "42000";
    STR_ERROR[-OB_ERR_TOO_LONG_COLUMN_LENGTH] = "Column length too big";
    STR_USER_ERROR[-OB_ERR_TOO_LONG_COLUMN_LENGTH] = "Column length too big for column '%s' (max = %d)";
    MYSQL_ERRNO[-OB_ERR_TOO_BIG_ROWSIZE] = ER_TOO_BIG_ROWSIZE;
    SQLSTATE[-OB_ERR_TOO_BIG_ROWSIZE] = "42000";
    STR_ERROR[-OB_ERR_TOO_BIG_ROWSIZE] = "Row size too large";
    STR_USER_ERROR[-OB_ERR_TOO_BIG_ROWSIZE] = "Row size too large";
    MYSQL_ERRNO[-OB_ERR_UNKNOWN_TABLE] = ER_UNKNOWN_TABLE;
    SQLSTATE[-OB_ERR_UNKNOWN_TABLE] = "42S02";
    STR_ERROR[-OB_ERR_UNKNOWN_TABLE] = "Unknown table";
    STR_USER_ERROR[-OB_ERR_UNKNOWN_TABLE] = "Unknown table '%.*s' in %.*s";
    MYSQL_ERRNO[-OB_ERR_BAD_TABLE] = ER_BAD_TABLE_ERROR;
    SQLSTATE[-OB_ERR_BAD_TABLE] = "42S02";
    STR_ERROR[-OB_ERR_BAD_TABLE] = "Unknown table";
    STR_USER_ERROR[-OB_ERR_BAD_TABLE] = "Unknown table '%.*s'";
    MYSQL_ERRNO[-OB_ERR_TOO_BIG_SCALE] = ER_TOO_BIG_SCALE;
    SQLSTATE[-OB_ERR_TOO_BIG_SCALE] = "42000";
    STR_ERROR[-OB_ERR_TOO_BIG_SCALE] = "Too big scale %d specified for column '%s'. Maximum is %ld.";
    STR_USER_ERROR[-OB_ERR_TOO_BIG_SCALE] = "Too big scale %d specified for column '%s'. Maximum is %ld.";
    MYSQL_ERRNO[-OB_ERR_TOO_BIG_PRECISION] = ER_TOO_BIG_PRECISION;
    SQLSTATE[-OB_ERR_TOO_BIG_PRECISION] = "42000";
    STR_ERROR[-OB_ERR_TOO_BIG_PRECISION] = "Too big precision %d specified for column '%s'. Maximum is %ld.";
    STR_USER_ERROR[-OB_ERR_TOO_BIG_PRECISION] = "Too big precision %d specified for column '%s'. Maximum is %ld.";
    MYSQL_ERRNO[-OB_ERR_M_BIGGER_THAN_D] = ER_M_BIGGER_THAN_D;
    SQLSTATE[-OB_ERR_M_BIGGER_THAN_D] = "42000";
    STR_ERROR[-OB_ERR_M_BIGGER_THAN_D] = "For float(M,D), double(M,D) or decimal(M,D), M must be >= D (column '%s').";
    STR_USER_ERROR[-OB_ERR_M_BIGGER_THAN_D] = "For float(M,D), double(M,D) or decimal(M,D), M must be >= D (column '%s').";
    MYSQL_ERRNO[-OB_ERR_TOO_BIG_DISPLAYWIDTH] = ER_TOO_BIG_DISPLAYWIDTH;
    SQLSTATE[-OB_ERR_TOO_BIG_DISPLAYWIDTH] = "42000";
    STR_ERROR[-OB_ERR_TOO_BIG_DISPLAYWIDTH] = "Display width out of range for column '%s' (max = %ld)";
    STR_USER_ERROR[-OB_ERR_TOO_BIG_DISPLAYWIDTH] = "Display width out of range for column '%s' (max = %ld)";
    MYSQL_ERRNO[-OB_WRONG_GROUP_FIELD] = ER_WRONG_GROUP_FIELD;
    SQLSTATE[-OB_WRONG_GROUP_FIELD] = "42000";
    STR_ERROR[-OB_WRONG_GROUP_FIELD] = "Can't group on '%.*s'";
    STR_USER_ERROR[-OB_WRONG_GROUP_FIELD] = "Can't group on '%.*s'";
    MYSQL_ERRNO[-OB_NON_UNIQ_ERROR] = ER_NON_UNIQ_ERROR;
    SQLSTATE[-OB_NON_UNIQ_ERROR] = "23000";
    STR_ERROR[-OB_NON_UNIQ_ERROR] = "Column is ambiguous";
    STR_USER_ERROR[-OB_NON_UNIQ_ERROR] = "Column '%.*s' in %.*s is ambiguous";
    MYSQL_ERRNO[-OB_ERR_NONUNIQ_TABLE] = ER_NONUNIQ_TABLE;
    SQLSTATE[-OB_ERR_NONUNIQ_TABLE] = "42000";
    STR_ERROR[-OB_ERR_NONUNIQ_TABLE] = "Not unique table/alias";
    STR_USER_ERROR[-OB_ERR_NONUNIQ_TABLE] = "Not unique table/alias: \'%.*s\'";
    MYSQL_ERRNO[-OB_ERR_CANT_DROP_FIELD_OR_KEY] = ER_CANT_DROP_FIELD_OR_KEY;
    SQLSTATE[-OB_ERR_CANT_DROP_FIELD_OR_KEY] = "42000";
    STR_ERROR[-OB_ERR_CANT_DROP_FIELD_OR_KEY] = "Can't DROP Column; check that column/key exists";
    STR_USER_ERROR[-OB_ERR_CANT_DROP_FIELD_OR_KEY] = "Can't DROP '%.*s'; check that column/key exists";
    MYSQL_ERRNO[-OB_ERR_MULTIPLE_PRI_KEY] = ER_MULTIPLE_PRI_KEY;
    SQLSTATE[-OB_ERR_MULTIPLE_PRI_KEY] = "42000";
    STR_ERROR[-OB_ERR_MULTIPLE_PRI_KEY] = "Multiple primary key defined";
    STR_USER_ERROR[-OB_ERR_MULTIPLE_PRI_KEY] = "Multiple primary key defined";
    MYSQL_ERRNO[-OB_ERR_KEY_COLUMN_DOES_NOT_EXITS] = ER_KEY_COLUMN_DOES_NOT_EXITS;
    SQLSTATE[-OB_ERR_KEY_COLUMN_DOES_NOT_EXITS] = "42000";
    STR_ERROR[-OB_ERR_KEY_COLUMN_DOES_NOT_EXITS] = "Key column doesn't exist in table";
    STR_USER_ERROR[-OB_ERR_KEY_COLUMN_DOES_NOT_EXITS] = "Key column '%.*s' doesn't exist in table";
    MYSQL_ERRNO[-OB_ERR_AUTO_PARTITION_KEY] = -1;
    SQLSTATE[-OB_ERR_AUTO_PARTITION_KEY] = "42000";
    STR_ERROR[-OB_ERR_AUTO_PARTITION_KEY] = "auto-increment column should not be part of partition key";
    STR_USER_ERROR[-OB_ERR_AUTO_PARTITION_KEY] = "auto-increment column '%.*s' should not be part of partition key";
    MYSQL_ERRNO[-OB_ERR_CANT_USE_OPTION_HERE] = ER_CANT_USE_OPTION_HERE;
    SQLSTATE[-OB_ERR_CANT_USE_OPTION_HERE] = "42000";
    STR_ERROR[-OB_ERR_CANT_USE_OPTION_HERE] = "Incorrect usage/placement";
    STR_USER_ERROR[-OB_ERR_CANT_USE_OPTION_HERE] = "Incorrect usage/placement of '%s'";
    MYSQL_ERRNO[-OB_ERR_WRONG_OBJECT] = ER_WRONG_OBJECT;
    SQLSTATE[-OB_ERR_WRONG_OBJECT] = "HY000";
    STR_ERROR[-OB_ERR_WRONG_OBJECT] = "Wrong object";
    STR_USER_ERROR[-OB_ERR_WRONG_OBJECT] = "\'%s.%s\' is not %s";
    MYSQL_ERRNO[-OB_ERR_ON_RENAME] = ER_ERROR_ON_RENAME;
    SQLSTATE[-OB_ERR_ON_RENAME] = "HY000";
    STR_ERROR[-OB_ERR_ON_RENAME] = "Error on rename table";
    STR_USER_ERROR[-OB_ERR_ON_RENAME] = "Error on rename of \'%s.%s\' to \'%s.%s\'";
    MYSQL_ERRNO[-OB_ERR_WRONG_KEY_COLUMN] = ER_WRONG_KEY_COLUMN;
    SQLSTATE[-OB_ERR_WRONG_KEY_COLUMN] = "42000";
    STR_ERROR[-OB_ERR_WRONG_KEY_COLUMN] = "The used storage engine can't index column";
    STR_USER_ERROR[-OB_ERR_WRONG_KEY_COLUMN] = "The used storage engine can't index column '%.*s'";
    MYSQL_ERRNO[-OB_ERR_BAD_FIELD_ERROR] = ER_BAD_FIELD_ERROR;
    SQLSTATE[-OB_ERR_BAD_FIELD_ERROR] = "42S22";
    STR_ERROR[-OB_ERR_BAD_FIELD_ERROR] = "Unknown column";
    STR_USER_ERROR[-OB_ERR_BAD_FIELD_ERROR] = "Unknown column '%.*s' in '%.*s'";
    MYSQL_ERRNO[-OB_ERR_WRONG_FIELD_WITH_GROUP] = ER_WRONG_FIELD_WITH_GROUP;
    SQLSTATE[-OB_ERR_WRONG_FIELD_WITH_GROUP] = "42000";
    STR_ERROR[-OB_ERR_WRONG_FIELD_WITH_GROUP] = "column is not in GROUP BY";
    STR_USER_ERROR[-OB_ERR_WRONG_FIELD_WITH_GROUP] = "\'%.*s\' is not in GROUP BY";
    MYSQL_ERRNO[-OB_ERR_CANT_CHANGE_TX_CHARACTERISTICS] = ER_CANT_CHANGE_TX_CHARACTERISTICS;
    SQLSTATE[-OB_ERR_CANT_CHANGE_TX_CHARACTERISTICS] = "25001";
    STR_ERROR[-OB_ERR_CANT_CHANGE_TX_CHARACTERISTICS] = "Transaction characteristics can't be changed while a transaction is in progress";
    STR_USER_ERROR[-OB_ERR_CANT_CHANGE_TX_CHARACTERISTICS] = "Transaction characteristics can't be changed while a transaction is in progress";
    MYSQL_ERRNO[-OB_ERR_CANT_EXECUTE_IN_READ_ONLY_TRANSACTION] = ER_CANT_EXECUTE_IN_READ_ONLY_TRANSACTION;
    SQLSTATE[-OB_ERR_CANT_EXECUTE_IN_READ_ONLY_TRANSACTION] = "25006";
    STR_ERROR[-OB_ERR_CANT_EXECUTE_IN_READ_ONLY_TRANSACTION] = "Cannot execute statement in a READ ONLY transaction.";
    STR_USER_ERROR[-OB_ERR_CANT_EXECUTE_IN_READ_ONLY_TRANSACTION] = "Cannot execute statement in a READ ONLY transaction.";
    MYSQL_ERRNO[-OB_ERR_MIX_OF_GROUP_FUNC_AND_FIELDS] = ER_MIX_OF_GROUP_FUNC_AND_FIELDS;
    SQLSTATE[-OB_ERR_MIX_OF_GROUP_FUNC_AND_FIELDS] = "42000";
    STR_ERROR[-OB_ERR_MIX_OF_GROUP_FUNC_AND_FIELDS] = "Mixing of GROUP columns (MIN(),MAX(),COUNT(),...) with no GROUP columns is illegal if there is no GROUP BY clause";
    STR_USER_ERROR[-OB_ERR_MIX_OF_GROUP_FUNC_AND_FIELDS] = "Mixing of GROUP columns (MIN(),MAX(),COUNT(),...) with no GROUP columns is illegal if there is no GROUP BY clause";
    MYSQL_ERRNO[-OB_ERR_TRUNCATED_WRONG_VALUE] = ER_TRUNCATED_WRONG_VALUE;
    SQLSTATE[-OB_ERR_TRUNCATED_WRONG_VALUE] = "22007";
    STR_ERROR[-OB_ERR_TRUNCATED_WRONG_VALUE] = "Incorrect value";
    STR_USER_ERROR[-OB_ERR_TRUNCATED_WRONG_VALUE] = "Truncated incorrect %.*s value: '%.*s'";
    MYSQL_ERRNO[-OB_ERR_WRONG_IDENT_NAME] = -1;
    SQLSTATE[-OB_ERR_WRONG_IDENT_NAME] = "42000";
    STR_ERROR[-OB_ERR_WRONG_IDENT_NAME] = "wrong ident name";
    STR_USER_ERROR[-OB_ERR_WRONG_IDENT_NAME] = "wrong ident name";
    MYSQL_ERRNO[-OB_WRONG_NAME_FOR_INDEX] = ER_WRONG_NAME_FOR_INDEX;
    SQLSTATE[-OB_WRONG_NAME_FOR_INDEX] = "42000";
    STR_ERROR[-OB_WRONG_NAME_FOR_INDEX] = "Incorrect index name";
    STR_USER_ERROR[-OB_WRONG_NAME_FOR_INDEX] = "Incorrect index name '%.*s'";
    MYSQL_ERRNO[-OB_ILLEGAL_REFERENCE] = ER_ILLEGAL_REFERENCE;
    SQLSTATE[-OB_ILLEGAL_REFERENCE] = "42S22";
    STR_ERROR[-OB_ILLEGAL_REFERENCE] = "Reference not supported (reference to group function)";
    STR_USER_ERROR[-OB_ILLEGAL_REFERENCE] = "Reference '%.*s' not supported (reference to group function)";
    MYSQL_ERRNO[-OB_REACH_MEMORY_LIMIT] = -1;
    SQLSTATE[-OB_REACH_MEMORY_LIMIT] = "42000";
    STR_ERROR[-OB_REACH_MEMORY_LIMIT] = "plan cache memory used reach the high water mark.";
    STR_USER_ERROR[-OB_REACH_MEMORY_LIMIT] = "plan cache memory used reach the high water mark.";
    MYSQL_ERRNO[-OB_ERR_PASSWORD_FORMAT] = ER_PASSWORD_FORMAT;
    SQLSTATE[-OB_ERR_PASSWORD_FORMAT] = "42000";
    STR_ERROR[-OB_ERR_PASSWORD_FORMAT] = "The password hash doesn't have the expected format. Check if the correct password algorithm is being used with the PASSWORD() function.";
    STR_USER_ERROR[-OB_ERR_PASSWORD_FORMAT] = "The password hash doesn't have the expected format. Check if the correct password algorithm is being used with the PASSWORD() function.";
    MYSQL_ERRNO[-OB_ERR_NON_UPDATABLE_TABLE] = ER_NON_UPDATABLE_TABLE;
    SQLSTATE[-OB_ERR_NON_UPDATABLE_TABLE] = "HY000";
    STR_ERROR[-OB_ERR_NON_UPDATABLE_TABLE] = "The target table tt of the UPDATE is not updatable";
    STR_USER_ERROR[-OB_ERR_NON_UPDATABLE_TABLE] = "The target table tt of the UPDATE is not updatable";
    MYSQL_ERRNO[-OB_ERR_WARN_DATA_OUT_OF_RANGE] = ER_WARN_DATA_OUT_OF_RANGE;
    SQLSTATE[-OB_ERR_WARN_DATA_OUT_OF_RANGE] = "22003";
    STR_ERROR[-OB_ERR_WARN_DATA_OUT_OF_RANGE] = "Out of range value for column";
    STR_USER_ERROR[-OB_ERR_WARN_DATA_OUT_OF_RANGE] = "Out of range value for column '%.*s' at row %ld";
    MYSQL_ERRNO[-OB_ERR_WRONG_EXPR_IN_PARTITION_FUNC_ERROR] = ER_WRONG_EXPR_IN_PARTITION_FUNC_ERROR;
    SQLSTATE[-OB_ERR_WRONG_EXPR_IN_PARTITION_FUNC_ERROR] = "HY000";
    STR_ERROR[-OB_ERR_WRONG_EXPR_IN_PARTITION_FUNC_ERROR] = "Constant or random or timezone-dependent expressions in (sub)partitioning function are not allowed";
    STR_USER_ERROR[-OB_ERR_WRONG_EXPR_IN_PARTITION_FUNC_ERROR] = "Constant or random or timezone-dependent expressions in (sub)partitioning function are not allowed";
    MYSQL_ERRNO[-OB_ERR_VIEW_INVALID] = ER_VIEW_INVALID;
    SQLSTATE[-OB_ERR_VIEW_INVALID] = "42S22";
    STR_ERROR[-OB_ERR_VIEW_INVALID] = "view invalid";
    STR_USER_ERROR[-OB_ERR_VIEW_INVALID] = "View \'%.*s.%.*s\' references invalid table(s) or column(s) or function(s) or definer/invoker of view lack rights to use them";
    MYSQL_ERRNO[-OB_ERR_OPTION_PREVENTS_STATEMENT] = ER_OPTION_PREVENTS_STATEMENT;
    SQLSTATE[-OB_ERR_OPTION_PREVENTS_STATEMENT] = "HY000";
    STR_ERROR[-OB_ERR_OPTION_PREVENTS_STATEMENT] = "The MySQL server is running with the --read-only option so it cannot execute this statement";
    STR_USER_ERROR[-OB_ERR_OPTION_PREVENTS_STATEMENT] = "The MySQL server is running with the --read-only option so it cannot execute this statement";
    MYSQL_ERRNO[-OB_ERR_DB_READ_ONLY] = -1;
    SQLSTATE[-OB_ERR_DB_READ_ONLY] = "HY000";
    STR_ERROR[-OB_ERR_DB_READ_ONLY] = "The database is read only so it cannot execute this statement";
    STR_USER_ERROR[-OB_ERR_DB_READ_ONLY] = "The database is read only so it cannot execute this statement";
    MYSQL_ERRNO[-OB_ERR_TABLE_READ_ONLY] = -1;
    SQLSTATE[-OB_ERR_TABLE_READ_ONLY] = "HY000";
    STR_ERROR[-OB_ERR_TABLE_READ_ONLY] = "The table is read only so it cannot execute this statement";
    STR_USER_ERROR[-OB_ERR_TABLE_READ_ONLY] = "The table is read only so it cannot execute this statement";
    MYSQL_ERRNO[-OB_ERR_LOCK_OR_ACTIVE_TRANSACTION] = ER_LOCK_OR_ACTIVE_TRANSACTION;
    SQLSTATE[-OB_ERR_LOCK_OR_ACTIVE_TRANSACTION] = "HY000";
    STR_ERROR[-OB_ERR_LOCK_OR_ACTIVE_TRANSACTION] = "Can't execute the given command because you have active locked tables or an active transaction";
    STR_USER_ERROR[-OB_ERR_LOCK_OR_ACTIVE_TRANSACTION] = "Can't execute the given command because you have active locked tables or an active transaction";
    MYSQL_ERRNO[-OB_ERR_SAME_NAME_PARTITION_FIELD] = ER_SAME_NAME_PARTITION_FIELD;
    SQLSTATE[-OB_ERR_SAME_NAME_PARTITION_FIELD] = "HY000";
    STR_ERROR[-OB_ERR_SAME_NAME_PARTITION_FIELD] = "Duplicate partition field name";
    STR_USER_ERROR[-OB_ERR_SAME_NAME_PARTITION_FIELD] = "Duplicate partition field name '%.*s'";
    MYSQL_ERRNO[-OB_ERR_TABLENAME_NOT_ALLOWED_HERE] = ER_TABLENAME_NOT_ALLOWED_HERE;
    SQLSTATE[-OB_ERR_TABLENAME_NOT_ALLOWED_HERE] = "42000";
    STR_ERROR[-OB_ERR_TABLENAME_NOT_ALLOWED_HERE] = "Table from one of the SELECTs cannot be used in global ORDER clause";
    STR_USER_ERROR[-OB_ERR_TABLENAME_NOT_ALLOWED_HERE] = "Table \'%.*s\' from one of the SELECTs cannot be used in global ORDER clause";
    MYSQL_ERRNO[-OB_ERR_VIEW_RECURSIVE] = ER_VIEW_RECURSIVE;
    SQLSTATE[-OB_ERR_VIEW_RECURSIVE] = "42S22";
    STR_ERROR[-OB_ERR_VIEW_RECURSIVE] = "view contains recursion";
    STR_USER_ERROR[-OB_ERR_VIEW_RECURSIVE] = "\'%.*s'.'%.*s\' contains view recursion";
    MYSQL_ERRNO[-OB_ERR_QUALIFIER] = -1;
    SQLSTATE[-OB_ERR_QUALIFIER] = "HY000";
    STR_ERROR[-OB_ERR_QUALIFIER] = "Column part of USING clause cannot have qualifier";
    STR_USER_ERROR[-OB_ERR_QUALIFIER] = "Column part of USING clause cannot have qualifier";
    MYSQL_ERRNO[-OB_ERR_WRONG_VALUE] = ER_WRONG_VALUE;
    SQLSTATE[-OB_ERR_WRONG_VALUE] = "HY000";
    STR_ERROR[-OB_ERR_WRONG_VALUE] = "Incorrect %s value: '%s'";
    STR_USER_ERROR[-OB_ERR_WRONG_VALUE] = "Incorrect %s value: '%s'";
    MYSQL_ERRNO[-OB_ERR_VIEW_WRONG_LIST] = ER_VIEW_WRONG_LIST;
    SQLSTATE[-OB_ERR_VIEW_WRONG_LIST] = "HY000";
    STR_ERROR[-OB_ERR_VIEW_WRONG_LIST] = "View's SELECT and view's field list have different column counts";
    STR_USER_ERROR[-OB_ERR_VIEW_WRONG_LIST] = "View's SELECT and view's field list have different column counts";
    MYSQL_ERRNO[-OB_SYS_VARS_MAYBE_DIFF_VERSION] = -1;
    SQLSTATE[-OB_SYS_VARS_MAYBE_DIFF_VERSION] = "HY000";
    STR_ERROR[-OB_SYS_VARS_MAYBE_DIFF_VERSION] = "system variables' version maybe different";
    STR_USER_ERROR[-OB_SYS_VARS_MAYBE_DIFF_VERSION] = "system variables' version maybe different";
    MYSQL_ERRNO[-OB_ERR_AUTO_INCREMENT_CONFLICT] = ER_AUTO_INCREMENT_CONFLICT;
    SQLSTATE[-OB_ERR_AUTO_INCREMENT_CONFLICT] = "HY000";
    STR_ERROR[-OB_ERR_AUTO_INCREMENT_CONFLICT] = "Auto-increment value in UPDATE conflicts with internally generated values";
    STR_USER_ERROR[-OB_ERR_AUTO_INCREMENT_CONFLICT] = "Auto-increment value in UPDATE conflicts with internally generated values";
    MYSQL_ERRNO[-OB_ERR_TASK_SKIPPED] = -1;
    SQLSTATE[-OB_ERR_TASK_SKIPPED] = "HY000";
    STR_ERROR[-OB_ERR_TASK_SKIPPED] = "some tasks are skipped";
    STR_USER_ERROR[-OB_ERR_TASK_SKIPPED] = "some tasks are skipped, skipped server addr is '%s', the orginal error code is %d";
    MYSQL_ERRNO[-OB_ERR_NAME_BECOMES_EMPTY] = ER_NAME_BECOMES_EMPTY;
    SQLSTATE[-OB_ERR_NAME_BECOMES_EMPTY] = "HY000";
    STR_ERROR[-OB_ERR_NAME_BECOMES_EMPTY] = "Name has become ''";
    STR_USER_ERROR[-OB_ERR_NAME_BECOMES_EMPTY] = "Name \'%.*s\' has become ''";
    MYSQL_ERRNO[-OB_ERR_REMOVED_SPACES] = ER_REMOVED_SPACES;
    SQLSTATE[-OB_ERR_REMOVED_SPACES] = "HY000";
    STR_ERROR[-OB_ERR_REMOVED_SPACES] = "Leading spaces are removed from name ";
    STR_USER_ERROR[-OB_ERR_REMOVED_SPACES] = "Leading spaces are removed from name \'%.*s\'";
    MYSQL_ERRNO[-OB_WARN_ADD_AUTOINCREMENT_COLUMN] = -1;
    SQLSTATE[-OB_WARN_ADD_AUTOINCREMENT_COLUMN] = "HY000";
    STR_ERROR[-OB_WARN_ADD_AUTOINCREMENT_COLUMN] = "Alter table add auto_increment column is dangerous";
    STR_USER_ERROR[-OB_WARN_ADD_AUTOINCREMENT_COLUMN] = "Alter table add auto_increment column is dangerous, table_name=\'%.*s\', column_name=\'%s\'";
    MYSQL_ERRNO[-OB_WARN_CHAMGE_NULL_ATTRIBUTE] = -1;
    SQLSTATE[-OB_WARN_CHAMGE_NULL_ATTRIBUTE] = "HY000";
    STR_ERROR[-OB_WARN_CHAMGE_NULL_ATTRIBUTE] = "Alter table change nullable column to not nullable is dangerous";
    STR_USER_ERROR[-OB_WARN_CHAMGE_NULL_ATTRIBUTE] = "Alter table change nullable column to not nullable is dangerous, table_name=\'%.*s\', column_name=\'%.*s\'";
    MYSQL_ERRNO[-OB_ERR_INVALID_CHARACTER_STRING] = ER_INVALID_CHARACTER_STRING;
    SQLSTATE[-OB_ERR_INVALID_CHARACTER_STRING] = "HY000";
    STR_ERROR[-OB_ERR_INVALID_CHARACTER_STRING] = "Invalid character string";
    STR_USER_ERROR[-OB_ERR_INVALID_CHARACTER_STRING] = "Invalid %.*s character string: \'%.*s\'";
    MYSQL_ERRNO[-OB_ERR_KILL_DENIED] = ER_KILL_DENIED_ERROR;
    SQLSTATE[-OB_ERR_KILL_DENIED] = "HY000";
    STR_ERROR[-OB_ERR_KILL_DENIED] = "You are not owner of thread";
    STR_USER_ERROR[-OB_ERR_KILL_DENIED] = "You are not owner of thread %lu";
    MYSQL_ERRNO[-OB_ERR_COLUMN_DEFINITION_AMBIGUOUS] = -1;
    SQLSTATE[-OB_ERR_COLUMN_DEFINITION_AMBIGUOUS] = "HY000";
    STR_ERROR[-OB_ERR_COLUMN_DEFINITION_AMBIGUOUS] = "Column definition is ambiguous. Column has both NULL and NOT NULL attributes";
    STR_USER_ERROR[-OB_ERR_COLUMN_DEFINITION_AMBIGUOUS] = "Column definition is ambiguous. Column has both NULL and NOT NULL attributes";
    MYSQL_ERRNO[-OB_ERR_EMPTY_QUERY] = ER_EMPTY_QUERY;
    SQLSTATE[-OB_ERR_EMPTY_QUERY] = "42000";
    STR_ERROR[-OB_ERR_EMPTY_QUERY] = "Query was empty";
    STR_USER_ERROR[-OB_ERR_EMPTY_QUERY] = "Query was empty";
    MYSQL_ERRNO[-OB_ERR_CUT_VALUE_GROUP_CONCAT] = ER_CUT_VALUE_GROUP_CONCAT;
    SQLSTATE[-OB_ERR_CUT_VALUE_GROUP_CONCAT] = "42000";
    STR_ERROR[-OB_ERR_CUT_VALUE_GROUP_CONCAT] = "Row was cut by GROUP_CONCAT()";
    STR_USER_ERROR[-OB_ERR_CUT_VALUE_GROUP_CONCAT] = "Row %ld was cut by GROUP_CONCAT()";
    MYSQL_ERRNO[-OB_ERR_FILED_NOT_FOUND_PART] = ER_FIELD_NOT_FOUND_PART_ERROR;
    SQLSTATE[-OB_ERR_FILED_NOT_FOUND_PART] = "HY000";
    STR_ERROR[-OB_ERR_FILED_NOT_FOUND_PART] = "Field in list of fields for partition function not found in table";
    STR_USER_ERROR[-OB_ERR_FILED_NOT_FOUND_PART] = "Field in list of fields for partition function not found in table";
    MYSQL_ERRNO[-OB_ERR_PRIMARY_CANT_HAVE_NULL] = ER_PRIMARY_CANT_HAVE_NULL;
    SQLSTATE[-OB_ERR_PRIMARY_CANT_HAVE_NULL] = "42000";
    STR_ERROR[-OB_ERR_PRIMARY_CANT_HAVE_NULL] = "All parts of a PRIMARY KEY must be NOT NULL; if you need NULL in a key, use UNIQUE instead";
    STR_USER_ERROR[-OB_ERR_PRIMARY_CANT_HAVE_NULL] = "All parts of a PRIMARY KEY must be NOT NULL; if you need NULL in a key, use UNIQUE instead";
    MYSQL_ERRNO[-OB_ERR_PARTITION_FUNC_NOT_ALLOWED_ERROR] = ER_PARTITION_FUNC_NOT_ALLOWED_ERROR;
    SQLSTATE[-OB_ERR_PARTITION_FUNC_NOT_ALLOWED_ERROR] = "HY000";
    STR_ERROR[-OB_ERR_PARTITION_FUNC_NOT_ALLOWED_ERROR] = "The PARTITION function returns the wrong type";
    STR_USER_ERROR[-OB_ERR_PARTITION_FUNC_NOT_ALLOWED_ERROR] = "The PARTITION function returns the wrong type";
    MYSQL_ERRNO[-OB_ERR_INVALID_BLOCK_SIZE] = -1;
    SQLSTATE[-OB_ERR_INVALID_BLOCK_SIZE] = "HY000";
    STR_ERROR[-OB_ERR_INVALID_BLOCK_SIZE] = "Invalid block size, block size should between 16384 and 1048576";
    STR_USER_ERROR[-OB_ERR_INVALID_BLOCK_SIZE] = "Invalid block size, block size should between 16384 and 1048576";
    MYSQL_ERRNO[-OB_ERR_UNKNOWN_STORAGE_ENGINE] = ER_UNKNOWN_STORAGE_ENGINE;
    SQLSTATE[-OB_ERR_UNKNOWN_STORAGE_ENGINE] = "42000";
    STR_ERROR[-OB_ERR_UNKNOWN_STORAGE_ENGINE] = "Unknown storage engine";
    STR_USER_ERROR[-OB_ERR_UNKNOWN_STORAGE_ENGINE] = "Unknown storage engine \'%.*s\'";
    MYSQL_ERRNO[-OB_ERR_TENANT_IS_LOCKED] = -1;
    SQLSTATE[-OB_ERR_TENANT_IS_LOCKED] = "HY000";
    STR_ERROR[-OB_ERR_TENANT_IS_LOCKED] = "Tenant is locked";
    STR_USER_ERROR[-OB_ERR_TENANT_IS_LOCKED] = "Tenant \'%.*s\' is locked";
    MYSQL_ERRNO[-OB_EER_UNIQUE_KEY_NEED_ALL_FIELDS_IN_PF] = ER_UNIQUE_KEY_NEED_ALL_FIELDS_IN_PF;
    SQLSTATE[-OB_EER_UNIQUE_KEY_NEED_ALL_FIELDS_IN_PF] = "HY000";
    STR_ERROR[-OB_EER_UNIQUE_KEY_NEED_ALL_FIELDS_IN_PF] = "A UNIQUE INDEX/PRIMARY KEY must include all columns in the table's partitioning function";
    STR_USER_ERROR[-OB_EER_UNIQUE_KEY_NEED_ALL_FIELDS_IN_PF] = "A %s must include all columns in the table's partitioning function";
    MYSQL_ERRNO[-OB_ERR_AGGREGATE_ORDER_FOR_UNION] = ER_AGGREGATE_ORDER_FOR_UNION;
    SQLSTATE[-OB_ERR_AGGREGATE_ORDER_FOR_UNION] = "HY000";
    STR_ERROR[-OB_ERR_AGGREGATE_ORDER_FOR_UNION] = "aggregate order for union";
    STR_USER_ERROR[-OB_ERR_AGGREGATE_ORDER_FOR_UNION] = "Expression #%d of ORDER BY contains aggregate function and applies to a UNION";
    MYSQL_ERRNO[-OB_ERR_OUTLINE_EXIST] = -1;
    SQLSTATE[-OB_ERR_OUTLINE_EXIST] = "HY000";
    STR_ERROR[-OB_ERR_OUTLINE_EXIST] = "Outline exists";
    STR_USER_ERROR[-OB_ERR_OUTLINE_EXIST] = "Outline '%.*s' already exists";
    MYSQL_ERRNO[-OB_OUTLINE_NOT_EXIST] = -1;
    SQLSTATE[-OB_OUTLINE_NOT_EXIST] = "HY000";
    STR_ERROR[-OB_OUTLINE_NOT_EXIST] = "Outline not exists";
    STR_USER_ERROR[-OB_OUTLINE_NOT_EXIST] = "Outline \'%.*s.%.*s\' doesn\'t exist";
    MYSQL_ERRNO[-OB_WARN_OPTION_BELOW_LIMIT] = WARN_OPTION_BELOW_LIMIT;
    SQLSTATE[-OB_WARN_OPTION_BELOW_LIMIT] = "HY000";
    STR_ERROR[-OB_WARN_OPTION_BELOW_LIMIT] = "The value should be no less than the limit";
    STR_USER_ERROR[-OB_WARN_OPTION_BELOW_LIMIT] = "The value of \'%s\' should be no less than the value of \'%s\'";
    MYSQL_ERRNO[-OB_INVALID_OUTLINE] = -1;
    SQLSTATE[-OB_INVALID_OUTLINE] = "HY000";
    STR_ERROR[-OB_INVALID_OUTLINE] = "invalid outline";
    STR_USER_ERROR[-OB_INVALID_OUTLINE] = "invalid outline ,error info:%s";
    MYSQL_ERRNO[-OB_REACH_MAX_CONCURRENT_NUM] = -1;
    SQLSTATE[-OB_REACH_MAX_CONCURRENT_NUM] = "HY000";
    STR_ERROR[-OB_REACH_MAX_CONCURRENT_NUM] = "SQL reach max concurrent num";
    STR_USER_ERROR[-OB_REACH_MAX_CONCURRENT_NUM] = "SQL reach max concurrent num %ld";
    MYSQL_ERRNO[-OB_ERR_OPERATION_ON_RECYCLE_OBJECT] = -1;
    SQLSTATE[-OB_ERR_OPERATION_ON_RECYCLE_OBJECT] = "HY000";
    STR_ERROR[-OB_ERR_OPERATION_ON_RECYCLE_OBJECT] = "can not perform DDL/DML over objects in Recycle Bin";
    STR_USER_ERROR[-OB_ERR_OPERATION_ON_RECYCLE_OBJECT] = "can not perform DDL/DML over objects in Recycle Bin";
    MYSQL_ERRNO[-OB_ERR_OBJECT_NOT_IN_RECYCLEBIN] = -1;
    SQLSTATE[-OB_ERR_OBJECT_NOT_IN_RECYCLEBIN] = "HY000";
    STR_ERROR[-OB_ERR_OBJECT_NOT_IN_RECYCLEBIN] = "object not in RECYCLE BIN";
    STR_USER_ERROR[-OB_ERR_OBJECT_NOT_IN_RECYCLEBIN] = "object not in RECYCLE BIN";
    MYSQL_ERRNO[-OB_ERR_CON_COUNT_ERROR] = ER_CON_COUNT_ERROR;
    SQLSTATE[-OB_ERR_CON_COUNT_ERROR] = "08004";
    STR_ERROR[-OB_ERR_CON_COUNT_ERROR] = "Too many connections";
    STR_USER_ERROR[-OB_ERR_CON_COUNT_ERROR] = "Too many connections";
    MYSQL_ERRNO[-OB_ERR_OUTLINE_CONTENT_EXIST] = -1;
    SQLSTATE[-OB_ERR_OUTLINE_CONTENT_EXIST] = "HY000";
    STR_ERROR[-OB_ERR_OUTLINE_CONTENT_EXIST] = "Outline content already exists when added";
    STR_USER_ERROR[-OB_ERR_OUTLINE_CONTENT_EXIST] = "Outline content '%.*s' of outline '%.*s' already exists when added";
    MYSQL_ERRNO[-OB_ERR_OUTLINE_MAX_CONCURRENT_EXIST] = -1;
    SQLSTATE[-OB_ERR_OUTLINE_MAX_CONCURRENT_EXIST] = "HY000";
    STR_ERROR[-OB_ERR_OUTLINE_MAX_CONCURRENT_EXIST] = "Max concurrent already exists when added";
    STR_USER_ERROR[-OB_ERR_OUTLINE_MAX_CONCURRENT_EXIST] = "Max concurrent in outline '%.*s' already exists when added";
    MYSQL_ERRNO[-OB_ERR_VALUES_IS_NOT_INT_TYPE_ERROR] = ER_VALUES_IS_NOT_INT_TYPE_ERROR;
    SQLSTATE[-OB_ERR_VALUES_IS_NOT_INT_TYPE_ERROR] = "HY000";
    STR_ERROR[-OB_ERR_VALUES_IS_NOT_INT_TYPE_ERROR] = "VALUES value for partition must have type INT";
    STR_USER_ERROR[-OB_ERR_VALUES_IS_NOT_INT_TYPE_ERROR] = "VALUES value for partition \'%.*s\' must have type INT";
    MYSQL_ERRNO[-OB_ERR_WRONG_TYPE_COLUMN_VALUE_ERROR] = ER_WRONG_TYPE_COLUMN_VALUE_ERROR;
    SQLSTATE[-OB_ERR_WRONG_TYPE_COLUMN_VALUE_ERROR] = "HY000";
    STR_ERROR[-OB_ERR_WRONG_TYPE_COLUMN_VALUE_ERROR] = "Partition column values of incorrect type";
    STR_USER_ERROR[-OB_ERR_WRONG_TYPE_COLUMN_VALUE_ERROR] = "Partition column values of incorrect type";
    MYSQL_ERRNO[-OB_ERR_PARTITION_COLUMN_LIST_ERROR] = ER_PARTITION_COLUMN_LIST_ERROR;
    SQLSTATE[-OB_ERR_PARTITION_COLUMN_LIST_ERROR] = "HY000";
    STR_ERROR[-OB_ERR_PARTITION_COLUMN_LIST_ERROR] = "Inconsistency in usage of column lists for partitioning";
    STR_USER_ERROR[-OB_ERR_PARTITION_COLUMN_LIST_ERROR] = "Inconsistency in usage of column lists for partitioning";
    MYSQL_ERRNO[-OB_ERR_TOO_MANY_VALUES_ERROR] = ER_TOO_MANY_VALUES_ERROR;
    SQLSTATE[-OB_ERR_TOO_MANY_VALUES_ERROR] = "HY000";
    STR_ERROR[-OB_ERR_TOO_MANY_VALUES_ERROR] = "Cannot have more than one value for this type of RANGE partitioning";
    STR_USER_ERROR[-OB_ERR_TOO_MANY_VALUES_ERROR] = "Cannot have more than one value for this type of RANGE partitioning";
    MYSQL_ERRNO[-OB_ERR_PARTITION_FUNCTION_IS_NOT_ALLOWED] = ER_PARTITION_FUNCTION_IS_NOT_ALLOWED;
    SQLSTATE[-OB_ERR_PARTITION_FUNCTION_IS_NOT_ALLOWED] = "HY000";
    STR_ERROR[-OB_ERR_PARTITION_FUNCTION_IS_NOT_ALLOWED] = "This partition function is not allowed";
    STR_USER_ERROR[-OB_ERR_PARTITION_FUNCTION_IS_NOT_ALLOWED] = "This partition function is not allowed";
    MYSQL_ERRNO[-OB_ERR_PARTITION_INTERVAL_ERROR] = -1;
    SQLSTATE[-OB_ERR_PARTITION_INTERVAL_ERROR] = "HY000";
    STR_ERROR[-OB_ERR_PARTITION_INTERVAL_ERROR] = "Partition interval must have type INT";
    STR_USER_ERROR[-OB_ERR_PARTITION_INTERVAL_ERROR] = "Partition interval must have type INT";
    MYSQL_ERRNO[-OB_ERR_SAME_NAME_PARTITION] = ER_SAME_NAME_PARTITION;
    SQLSTATE[-OB_ERR_SAME_NAME_PARTITION] = "HY000";
    STR_ERROR[-OB_ERR_SAME_NAME_PARTITION] = "Duplicate partition name";
    STR_USER_ERROR[-OB_ERR_SAME_NAME_PARTITION] = "Duplicate partition name \'%.*s\'";
    MYSQL_ERRNO[-OB_ERR_RANGE_NOT_INCREASING_ERROR] = ER_RANGE_NOT_INCREASING_ERROR;
    SQLSTATE[-OB_ERR_RANGE_NOT_INCREASING_ERROR] = "HY000";
    STR_ERROR[-OB_ERR_RANGE_NOT_INCREASING_ERROR] = "VALUES LESS THAN value must be strictly increasing for each partition";
    STR_USER_ERROR[-OB_ERR_RANGE_NOT_INCREASING_ERROR] = "VALUES LESS THAN value must be strictly increasing for each partition";
    MYSQL_ERRNO[-OB_ERR_PARSE_PARTITION_RANGE] = ER_PARSE_ERROR;
    SQLSTATE[-OB_ERR_PARSE_PARTITION_RANGE] = "42000";
    STR_ERROR[-OB_ERR_PARSE_PARTITION_RANGE] = "Wrong number of partitions defined, mismatch with previous setting";
    STR_USER_ERROR[-OB_ERR_PARSE_PARTITION_RANGE] = "Wrong number of partitions defined, mismatch with previous setting";
    MYSQL_ERRNO[-OB_ERR_UNIQUE_KEY_NEED_ALL_FIELDS_IN_PF] = ER_UNIQUE_KEY_NEED_ALL_FIELDS_IN_PF;
    SQLSTATE[-OB_ERR_UNIQUE_KEY_NEED_ALL_FIELDS_IN_PF] = "HY000";
    STR_ERROR[-OB_ERR_UNIQUE_KEY_NEED_ALL_FIELDS_IN_PF] = "A PRIMARY KEY must include all columns in the table\'s partitioning function";
    STR_USER_ERROR[-OB_ERR_UNIQUE_KEY_NEED_ALL_FIELDS_IN_PF] = "A PRIMARY KEY must include all columns in the table\'s partitioning function";
    MYSQL_ERRNO[-OB_NO_PARTITION_FOR_GIVEN_VALUE] = ER_NO_PARTITION_FOR_GIVEN_VALUE;
    SQLSTATE[-OB_NO_PARTITION_FOR_GIVEN_VALUE] = "HY000";
    STR_ERROR[-OB_NO_PARTITION_FOR_GIVEN_VALUE] = "Table has no partition for value";
    STR_USER_ERROR[-OB_NO_PARTITION_FOR_GIVEN_VALUE] = "Table has no partition for value";
    MYSQL_ERRNO[-OB_EER_NULL_IN_VALUES_LESS_THAN] = ER_NULL_IN_VALUES_LESS_THAN;
    SQLSTATE[-OB_EER_NULL_IN_VALUES_LESS_THAN] = "HY000";
    STR_ERROR[-OB_EER_NULL_IN_VALUES_LESS_THAN] = "Not allowed to use NULL value in VALUES LESS THAN";
    STR_USER_ERROR[-OB_EER_NULL_IN_VALUES_LESS_THAN] = "Not allowed to use NULL value in VALUES LESS THAN";
    MYSQL_ERRNO[-OB_ERR_PARTITION_CONST_DOMAIN_ERROR] = ER_PARTITION_CONST_DOMAIN_ERROR;
    SQLSTATE[-OB_ERR_PARTITION_CONST_DOMAIN_ERROR] = "HY000";
    STR_ERROR[-OB_ERR_PARTITION_CONST_DOMAIN_ERROR] = "Partition constant is out of partition function domain";
    STR_USER_ERROR[-OB_ERR_PARTITION_CONST_DOMAIN_ERROR] = "Partition constant is out of partition function domain";
    MYSQL_ERRNO[-OB_ERR_TOO_MANY_PARTITION_FUNC_FIELDS] = ER_TOO_MANY_PARTITION_FUNC_FIELDS_ERROR;
    SQLSTATE[-OB_ERR_TOO_MANY_PARTITION_FUNC_FIELDS] = "HY000";
    STR_ERROR[-OB_ERR_TOO_MANY_PARTITION_FUNC_FIELDS] = "Too many fields in \'list of partition fields\'";
    STR_USER_ERROR[-OB_ERR_TOO_MANY_PARTITION_FUNC_FIELDS] = "Too many fields in \'list of partition fields\'";
    MYSQL_ERRNO[-OB_ERR_BAD_FT_COLUMN] = ER_BAD_FT_COLUMN;
    SQLSTATE[-OB_ERR_BAD_FT_COLUMN] = "HY000";
    STR_ERROR[-OB_ERR_BAD_FT_COLUMN] = "Column cannot be part of FULLTEXT index";
    STR_USER_ERROR[-OB_ERR_BAD_FT_COLUMN] = "Column '%.*s' cannot be part of FULLTEXT index";
    MYSQL_ERRNO[-OB_ERR_KEY_DOES_NOT_EXISTS] = ER_KEY_DOES_NOT_EXISTS;
    SQLSTATE[-OB_ERR_KEY_DOES_NOT_EXISTS] = "42000";
    STR_ERROR[-OB_ERR_KEY_DOES_NOT_EXISTS] = "key does not exist in table";
    STR_USER_ERROR[-OB_ERR_KEY_DOES_NOT_EXISTS] = "Key '%.*s' doesn't exist in table '%.*s'";
    MYSQL_ERRNO[-OB_NON_DEFAULT_VALUE_FOR_GENERATED_COLUMN] = ER_NON_DEFAULT_VALUE_FOR_GENERATED_COLUMN;
    SQLSTATE[-OB_NON_DEFAULT_VALUE_FOR_GENERATED_COLUMN] = "HY000";
    STR_ERROR[-OB_NON_DEFAULT_VALUE_FOR_GENERATED_COLUMN] = "non-default value for generated column is not allowed";
    STR_USER_ERROR[-OB_NON_DEFAULT_VALUE_FOR_GENERATED_COLUMN] = "The value specified for generated column '%.*s' in table '%.*s' is not allowed";
    MYSQL_ERRNO[-OB_ERR_BAD_CTXCAT_COLUMN] = -1;
    SQLSTATE[-OB_ERR_BAD_CTXCAT_COLUMN] = "HY000";
    STR_ERROR[-OB_ERR_BAD_CTXCAT_COLUMN] = "The CTXCAT column must be contiguous in the index column list";
    STR_USER_ERROR[-OB_ERR_BAD_CTXCAT_COLUMN] = "The CTXCAT column must be contiguous in the index column list";
    MYSQL_ERRNO[-OB_ERR_UNSUPPORTED_ACTION_ON_GENERATED_COLUMN] = ER_UNSUPPORTED_ACTION_ON_GENERATED_COLUMN;
    SQLSTATE[-OB_ERR_UNSUPPORTED_ACTION_ON_GENERATED_COLUMN] = "HY000";
    STR_ERROR[-OB_ERR_UNSUPPORTED_ACTION_ON_GENERATED_COLUMN] = "not supported for generated columns";
    STR_USER_ERROR[-OB_ERR_UNSUPPORTED_ACTION_ON_GENERATED_COLUMN] = "'%s' is not supported for generated columns.";
    MYSQL_ERRNO[-OB_ERR_DEPENDENT_BY_GENERATED_COLUMN] = ER_DEPENDENT_BY_GENERATED_COLUMN;
    SQLSTATE[-OB_ERR_DEPENDENT_BY_GENERATED_COLUMN] = "HY000";
    STR_ERROR[-OB_ERR_DEPENDENT_BY_GENERATED_COLUMN] = "Column has a generated column dependency";
    STR_USER_ERROR[-OB_ERR_DEPENDENT_BY_GENERATED_COLUMN] = "Column '%.*s' has a generated column dependency";
    MYSQL_ERRNO[-OB_ERR_TOO_MANY_ROWS] = ER_TOO_MANY_ROWS;
    SQLSTATE[-OB_ERR_TOO_MANY_ROWS] = "42000";
    STR_ERROR[-OB_ERR_TOO_MANY_ROWS] = "Result consisted of more than one row";
    STR_USER_ERROR[-OB_ERR_TOO_MANY_ROWS] = "Result consisted of more than one row";
    MYSQL_ERRNO[-OB_WRONG_FIELD_TERMINATORS] = ER_WRONG_FIELD_TERMINATORS;
    SQLSTATE[-OB_WRONG_FIELD_TERMINATORS] = "42000";
    STR_ERROR[-OB_WRONG_FIELD_TERMINATORS] = "Field separator argument is not what is expected; check the manual";
    STR_USER_ERROR[-OB_WRONG_FIELD_TERMINATORS] = "Field separator argument is not what is expected; check the manual";
    MYSQL_ERRNO[-OB_ERR_UNEXPECTED_TZ_TRANSITION] = -1;
    SQLSTATE[-OB_ERR_UNEXPECTED_TZ_TRANSITION] = "HY000";
    STR_ERROR[-OB_ERR_UNEXPECTED_TZ_TRANSITION] = "unexpected time zone info transition";
    STR_USER_ERROR[-OB_ERR_UNEXPECTED_TZ_TRANSITION] = "unexpected time zone info transition";
    MYSQL_ERRNO[-OB_ERR_INVALID_TIMEZONE_REGION_ID] = -1;
    SQLSTATE[-OB_ERR_INVALID_TIMEZONE_REGION_ID] = "HY000";
    STR_ERROR[-OB_ERR_INVALID_TIMEZONE_REGION_ID] = "timezone region ID is invalid";
    STR_USER_ERROR[-OB_ERR_INVALID_TIMEZONE_REGION_ID] = "timezone region ID is invalid";
    MYSQL_ERRNO[-OB_ERR_INVALID_HEX_NUMBER] = -1;
    SQLSTATE[-OB_ERR_INVALID_HEX_NUMBER] = "HY000";
    STR_ERROR[-OB_ERR_INVALID_HEX_NUMBER] = "invalid hex number";
    STR_USER_ERROR[-OB_ERR_INVALID_HEX_NUMBER] = "invalid hex number";
    MYSQL_ERRNO[-OB_ERR_YEAR_CONFLICTS_WITH_JULIAN_DATE] = -1;
    SQLSTATE[-OB_ERR_YEAR_CONFLICTS_WITH_JULIAN_DATE] = "HY000";
    STR_ERROR[-OB_ERR_YEAR_CONFLICTS_WITH_JULIAN_DATE] = "year conflicts with Julian date";
    STR_USER_ERROR[-OB_ERR_YEAR_CONFLICTS_WITH_JULIAN_DATE] = "year conflicts with Julian date";
    MYSQL_ERRNO[-OB_ERR_DAY_OF_YEAR_CONFLICTS_WITH_JULIAN_DATE] = -1;
    SQLSTATE[-OB_ERR_DAY_OF_YEAR_CONFLICTS_WITH_JULIAN_DATE] = "HY000";
    STR_ERROR[-OB_ERR_DAY_OF_YEAR_CONFLICTS_WITH_JULIAN_DATE] = "day of year conflicts with Julian date";
    STR_USER_ERROR[-OB_ERR_DAY_OF_YEAR_CONFLICTS_WITH_JULIAN_DATE] = "day of year conflicts with Julian date";
    MYSQL_ERRNO[-OB_ERR_MONTH_CONFLICTS_WITH_JULIAN_DATE] = -1;
    SQLSTATE[-OB_ERR_MONTH_CONFLICTS_WITH_JULIAN_DATE] = "HY000";
    STR_ERROR[-OB_ERR_MONTH_CONFLICTS_WITH_JULIAN_DATE] = "month conflicts with Julian date";
    STR_USER_ERROR[-OB_ERR_MONTH_CONFLICTS_WITH_JULIAN_DATE] = "month conflicts with Julian date";
    MYSQL_ERRNO[-OB_ERR_DAY_OF_MONTH_CONFLICTS_WITH_JULIAN_DATE] = -1;
    SQLSTATE[-OB_ERR_DAY_OF_MONTH_CONFLICTS_WITH_JULIAN_DATE] = "HY000";
    STR_ERROR[-OB_ERR_DAY_OF_MONTH_CONFLICTS_WITH_JULIAN_DATE] = "day of month conflicts with Julian date";
    STR_USER_ERROR[-OB_ERR_DAY_OF_MONTH_CONFLICTS_WITH_JULIAN_DATE] = "day of month conflicts with Julian date";
    MYSQL_ERRNO[-OB_ERR_DAY_OF_WEEK_CONFLICTS_WITH_JULIAN_DATE] = -1;
    SQLSTATE[-OB_ERR_DAY_OF_WEEK_CONFLICTS_WITH_JULIAN_DATE] = "HY000";
    STR_ERROR[-OB_ERR_DAY_OF_WEEK_CONFLICTS_WITH_JULIAN_DATE] = "day of week conflicts with Julian date";
    STR_USER_ERROR[-OB_ERR_DAY_OF_WEEK_CONFLICTS_WITH_JULIAN_DATE] = "day of week conflicts with Julian date";
    MYSQL_ERRNO[-OB_ERR_HOUR_CONFLICTS_WITH_SECONDS_IN_DAY] = -1;
    SQLSTATE[-OB_ERR_HOUR_CONFLICTS_WITH_SECONDS_IN_DAY] = "HY000";
    STR_ERROR[-OB_ERR_HOUR_CONFLICTS_WITH_SECONDS_IN_DAY] = "hour conflicts with seconds in day";
    STR_USER_ERROR[-OB_ERR_HOUR_CONFLICTS_WITH_SECONDS_IN_DAY] = "hour conflicts with seconds in day";
    MYSQL_ERRNO[-OB_ERR_MINUTES_OF_HOUR_CONFLICTS_WITH_SECONDS_IN_DAY] = -1;
    SQLSTATE[-OB_ERR_MINUTES_OF_HOUR_CONFLICTS_WITH_SECONDS_IN_DAY] = "HY000";
    STR_ERROR[-OB_ERR_MINUTES_OF_HOUR_CONFLICTS_WITH_SECONDS_IN_DAY] = "minutes of hour conflicts with seconds in day";
    STR_USER_ERROR[-OB_ERR_MINUTES_OF_HOUR_CONFLICTS_WITH_SECONDS_IN_DAY] = "minutes of hour conflicts with seconds in day";
    MYSQL_ERRNO[-OB_ERR_SECONDS_OF_MINUTE_CONFLICTS_WITH_SECONDS_IN_DAY] = -1;
    SQLSTATE[-OB_ERR_SECONDS_OF_MINUTE_CONFLICTS_WITH_SECONDS_IN_DAY] = "HY000";
    STR_ERROR[-OB_ERR_SECONDS_OF_MINUTE_CONFLICTS_WITH_SECONDS_IN_DAY] = "seconds of minute conflicts with seconds in day";
    STR_USER_ERROR[-OB_ERR_SECONDS_OF_MINUTE_CONFLICTS_WITH_SECONDS_IN_DAY] = "seconds of minute conflicts with seconds in day";
    MYSQL_ERRNO[-OB_ERR_DATE_NOT_VALID_FOR_MONTH_SPECIFIED] = -1;
    SQLSTATE[-OB_ERR_DATE_NOT_VALID_FOR_MONTH_SPECIFIED] = "HY000";
    STR_ERROR[-OB_ERR_DATE_NOT_VALID_FOR_MONTH_SPECIFIED] = "date not valid for month specified";
    STR_USER_ERROR[-OB_ERR_DATE_NOT_VALID_FOR_MONTH_SPECIFIED] = "date not valid for month specified";
    MYSQL_ERRNO[-OB_ERR_INPUT_VALUE_NOT_LONG_ENOUGH] = -1;
    SQLSTATE[-OB_ERR_INPUT_VALUE_NOT_LONG_ENOUGH] = "HY000";
    STR_ERROR[-OB_ERR_INPUT_VALUE_NOT_LONG_ENOUGH] = "input value not long enough for date format";
    STR_USER_ERROR[-OB_ERR_INPUT_VALUE_NOT_LONG_ENOUGH] = "input value not long enough for date format";
    MYSQL_ERRNO[-OB_ERR_INVALID_YEAR_VALUE] = -1;
    SQLSTATE[-OB_ERR_INVALID_YEAR_VALUE] = "HY000";
    STR_ERROR[-OB_ERR_INVALID_YEAR_VALUE] = "(full) year must be between -4713 and +9999, and not be 0";
    STR_USER_ERROR[-OB_ERR_INVALID_YEAR_VALUE] = "(full) year must be between -4713 and +9999, and not be 0";
    MYSQL_ERRNO[-OB_ERR_INVALID_MONTH] = -1;
    SQLSTATE[-OB_ERR_INVALID_MONTH] = "HY000";
    STR_ERROR[-OB_ERR_INVALID_MONTH] = "not a valid month";
    STR_USER_ERROR[-OB_ERR_INVALID_MONTH] = "not a valid month";
    MYSQL_ERRNO[-OB_ERR_INVALID_DAY_OF_THE_WEEK] = -1;
    SQLSTATE[-OB_ERR_INVALID_DAY_OF_THE_WEEK] = "HY000";
    STR_ERROR[-OB_ERR_INVALID_DAY_OF_THE_WEEK] = "not a valid day of the week";
    STR_USER_ERROR[-OB_ERR_INVALID_DAY_OF_THE_WEEK] = "not a valid day of the week";
    MYSQL_ERRNO[-OB_ERR_INVALID_DAY_OF_YEAR_VALUE] = -1;
    SQLSTATE[-OB_ERR_INVALID_DAY_OF_YEAR_VALUE] = "HY000";
    STR_ERROR[-OB_ERR_INVALID_DAY_OF_YEAR_VALUE] = "day of year must be between 1 and 365 (366 for leap year)";
    STR_USER_ERROR[-OB_ERR_INVALID_DAY_OF_YEAR_VALUE] = "day of year must be between 1 and 365 (366 for leap year)";
    MYSQL_ERRNO[-OB_ERR_INVALID_HOUR12_VALUE] = -1;
    SQLSTATE[-OB_ERR_INVALID_HOUR12_VALUE] = "HY000";
    STR_ERROR[-OB_ERR_INVALID_HOUR12_VALUE] = "hour must be between 1 and 12";
    STR_USER_ERROR[-OB_ERR_INVALID_HOUR12_VALUE] = "hour must be between 1 and 12";
    MYSQL_ERRNO[-OB_ERR_INVALID_HOUR24_VALUE] = -1;
    SQLSTATE[-OB_ERR_INVALID_HOUR24_VALUE] = "HY000";
    STR_ERROR[-OB_ERR_INVALID_HOUR24_VALUE] = "hour must be between 0 and 23";
    STR_USER_ERROR[-OB_ERR_INVALID_HOUR24_VALUE] = "hour must be between 0 and 23";
    MYSQL_ERRNO[-OB_ERR_INVALID_MINUTES_VALUE] = -1;
    SQLSTATE[-OB_ERR_INVALID_MINUTES_VALUE] = "HY000";
    STR_ERROR[-OB_ERR_INVALID_MINUTES_VALUE] = "minutes must be between 0 and 59";
    STR_USER_ERROR[-OB_ERR_INVALID_MINUTES_VALUE] = "minutes must be between 0 and 59";
    MYSQL_ERRNO[-OB_ERR_INVALID_SECONDS_VALUE] = -1;
    SQLSTATE[-OB_ERR_INVALID_SECONDS_VALUE] = "HY000";
    STR_ERROR[-OB_ERR_INVALID_SECONDS_VALUE] = "seconds must be between 0 and 59";
    STR_USER_ERROR[-OB_ERR_INVALID_SECONDS_VALUE] = "seconds must be between 0 and 59";
    MYSQL_ERRNO[-OB_ERR_INVALID_SECONDS_IN_DAY_VALUE] = -1;
    SQLSTATE[-OB_ERR_INVALID_SECONDS_IN_DAY_VALUE] = "HY000";
    STR_ERROR[-OB_ERR_INVALID_SECONDS_IN_DAY_VALUE] = "seconds in day must be between 0 and 86399";
    STR_USER_ERROR[-OB_ERR_INVALID_SECONDS_IN_DAY_VALUE] = "seconds in day must be between 0 and 86399";
    MYSQL_ERRNO[-OB_ERR_INVALID_JULIAN_DATE_VALUE] = -1;
    SQLSTATE[-OB_ERR_INVALID_JULIAN_DATE_VALUE] = "HY000";
    STR_ERROR[-OB_ERR_INVALID_JULIAN_DATE_VALUE] = "julian date must be between 1 and 5373484";
    STR_USER_ERROR[-OB_ERR_INVALID_JULIAN_DATE_VALUE] = "julian date must be between 1 and 5373484";
    MYSQL_ERRNO[-OB_ERR_AM_OR_PM_REQUIRED] = -1;
    SQLSTATE[-OB_ERR_AM_OR_PM_REQUIRED] = "HY000";
    STR_ERROR[-OB_ERR_AM_OR_PM_REQUIRED] = "AM/A.M. or PM/P.M. required";
    STR_USER_ERROR[-OB_ERR_AM_OR_PM_REQUIRED] = "AM/A.M. or PM/P.M. required";
    MYSQL_ERRNO[-OB_ERR_BC_OR_AD_REQUIRED] = -1;
    SQLSTATE[-OB_ERR_BC_OR_AD_REQUIRED] = "HY000";
    STR_ERROR[-OB_ERR_BC_OR_AD_REQUIRED] = "BC/B.C. or AD/A.D. required";
    STR_USER_ERROR[-OB_ERR_BC_OR_AD_REQUIRED] = "BC/B.C. or AD/A.D. required";
    MYSQL_ERRNO[-OB_ERR_FORMAT_CODE_APPEARS_TWICE] = -1;
    SQLSTATE[-OB_ERR_FORMAT_CODE_APPEARS_TWICE] = "HY000";
    STR_ERROR[-OB_ERR_FORMAT_CODE_APPEARS_TWICE] = "format code appears twice";
    STR_USER_ERROR[-OB_ERR_FORMAT_CODE_APPEARS_TWICE] = "format code appears twice";
    MYSQL_ERRNO[-OB_ERR_DAY_OF_WEEK_SPECIFIED_MORE_THAN_ONCE] = -1;
    SQLSTATE[-OB_ERR_DAY_OF_WEEK_SPECIFIED_MORE_THAN_ONCE] = "HY000";
    STR_ERROR[-OB_ERR_DAY_OF_WEEK_SPECIFIED_MORE_THAN_ONCE] = "day of week may only be specified once";
    STR_USER_ERROR[-OB_ERR_DAY_OF_WEEK_SPECIFIED_MORE_THAN_ONCE] = "day of week may only be specified once";
    MYSQL_ERRNO[-OB_ERR_SIGNED_YEAR_PRECLUDES_USE_OF_BC_AD] = -1;
    SQLSTATE[-OB_ERR_SIGNED_YEAR_PRECLUDES_USE_OF_BC_AD] = "HY000";
    STR_ERROR[-OB_ERR_SIGNED_YEAR_PRECLUDES_USE_OF_BC_AD] = "signed year precludes use of BC/AD";
    STR_USER_ERROR[-OB_ERR_SIGNED_YEAR_PRECLUDES_USE_OF_BC_AD] = "signed year precludes use of BC/AD";
    MYSQL_ERRNO[-OB_ERR_JULIAN_DATE_PRECLUDES_USE_OF_DAY_OF_YEAR] = -1;
    SQLSTATE[-OB_ERR_JULIAN_DATE_PRECLUDES_USE_OF_DAY_OF_YEAR] = "HY000";
    STR_ERROR[-OB_ERR_JULIAN_DATE_PRECLUDES_USE_OF_DAY_OF_YEAR] = "Julian date precludes use of day of year";
    STR_USER_ERROR[-OB_ERR_JULIAN_DATE_PRECLUDES_USE_OF_DAY_OF_YEAR] = "Julian date precludes use of day of year";
    MYSQL_ERRNO[-OB_ERR_YEAR_MAY_ONLY_BE_SPECIFIED_ONCE] = -1;
    SQLSTATE[-OB_ERR_YEAR_MAY_ONLY_BE_SPECIFIED_ONCE] = "HY000";
    STR_ERROR[-OB_ERR_YEAR_MAY_ONLY_BE_SPECIFIED_ONCE] = "year may only be specified once";
    STR_USER_ERROR[-OB_ERR_YEAR_MAY_ONLY_BE_SPECIFIED_ONCE] = "year may only be specified once";
    MYSQL_ERRNO[-OB_ERR_HOUR_MAY_ONLY_BE_SPECIFIED_ONCE] = -1;
    SQLSTATE[-OB_ERR_HOUR_MAY_ONLY_BE_SPECIFIED_ONCE] = "HY000";
    STR_ERROR[-OB_ERR_HOUR_MAY_ONLY_BE_SPECIFIED_ONCE] = "hour may only be specified once";
    STR_USER_ERROR[-OB_ERR_HOUR_MAY_ONLY_BE_SPECIFIED_ONCE] = "hour may only be specified once";
    MYSQL_ERRNO[-OB_ERR_AM_PM_CONFLICTS_WITH_USE_OF_AM_DOT_PM_DOT] = -1;
    SQLSTATE[-OB_ERR_AM_PM_CONFLICTS_WITH_USE_OF_AM_DOT_PM_DOT] = "HY000";
    STR_ERROR[-OB_ERR_AM_PM_CONFLICTS_WITH_USE_OF_AM_DOT_PM_DOT] = "AM/PM conflicts with use of A.M./P.M.";
    STR_USER_ERROR[-OB_ERR_AM_PM_CONFLICTS_WITH_USE_OF_AM_DOT_PM_DOT] = "AM/PM conflicts with use of A.M./P.M.";
    MYSQL_ERRNO[-OB_ERR_BC_AD_CONFLICT_WITH_USE_OF_BC_DOT_AD_DOT] = -1;
    SQLSTATE[-OB_ERR_BC_AD_CONFLICT_WITH_USE_OF_BC_DOT_AD_DOT] = "HY000";
    STR_ERROR[-OB_ERR_BC_AD_CONFLICT_WITH_USE_OF_BC_DOT_AD_DOT] = "BC/AD conflicts with use of B.C./A.D.";
    STR_USER_ERROR[-OB_ERR_BC_AD_CONFLICT_WITH_USE_OF_BC_DOT_AD_DOT] = "BC/AD conflicts with use of B.C./A.D.";
    MYSQL_ERRNO[-OB_ERR_MONTH_MAY_ONLY_BE_SPECIFIED_ONCE] = -1;
    SQLSTATE[-OB_ERR_MONTH_MAY_ONLY_BE_SPECIFIED_ONCE] = "HY000";
    STR_ERROR[-OB_ERR_MONTH_MAY_ONLY_BE_SPECIFIED_ONCE] = "month may only be specified once";
    STR_USER_ERROR[-OB_ERR_MONTH_MAY_ONLY_BE_SPECIFIED_ONCE] = "month may only be specified once";
    MYSQL_ERRNO[-OB_ERR_DAY_OF_WEEK_MAY_ONLY_BE_SPECIFIED_ONCE] = -1;
    SQLSTATE[-OB_ERR_DAY_OF_WEEK_MAY_ONLY_BE_SPECIFIED_ONCE] = "HY000";
    STR_ERROR[-OB_ERR_DAY_OF_WEEK_MAY_ONLY_BE_SPECIFIED_ONCE] = "day of week may only be specified once";
    STR_USER_ERROR[-OB_ERR_DAY_OF_WEEK_MAY_ONLY_BE_SPECIFIED_ONCE] = "day of week may only be specified once";
    MYSQL_ERRNO[-OB_ERR_FORMAT_CODE_CANNOT_APPEAR] = -1;
    SQLSTATE[-OB_ERR_FORMAT_CODE_CANNOT_APPEAR] = "HY000";
    STR_ERROR[-OB_ERR_FORMAT_CODE_CANNOT_APPEAR] = "format code cannot appear in date input format";
    STR_USER_ERROR[-OB_ERR_FORMAT_CODE_CANNOT_APPEAR] = "format code cannot appear in date input format";
    MYSQL_ERRNO[-OB_ERR_NON_NUMERIC_CHARACTER_VALUE] = -1;
    SQLSTATE[-OB_ERR_NON_NUMERIC_CHARACTER_VALUE] = "HY000";
    STR_ERROR[-OB_ERR_NON_NUMERIC_CHARACTER_VALUE] = "a non-numeric character was found where a numeric was expected";
    STR_USER_ERROR[-OB_ERR_NON_NUMERIC_CHARACTER_VALUE] = "a non-numeric character was found where a numeric was expected";
    MYSQL_ERRNO[-OB_INVALID_MERIDIAN_INDICATOR_USE] = -1;
    SQLSTATE[-OB_INVALID_MERIDIAN_INDICATOR_USE] = "HY000";
    STR_ERROR[-OB_INVALID_MERIDIAN_INDICATOR_USE] = "'HH24' precludes use of meridian indicator";
    STR_USER_ERROR[-OB_INVALID_MERIDIAN_INDICATOR_USE] = "'HH24' precludes use of meridian indicator";
    MYSQL_ERRNO[-OB_ERR_DAY_OF_MONTH_RANGE] = -1;
    SQLSTATE[-OB_ERR_DAY_OF_MONTH_RANGE] = "HY000";
    STR_ERROR[-OB_ERR_DAY_OF_MONTH_RANGE] = "day of month must be between 1 and last day of month";
    STR_USER_ERROR[-OB_ERR_DAY_OF_MONTH_RANGE] = "day of month must be between 1 and last day of month";
    MYSQL_ERRNO[-OB_ERR_THE_LEADING_PRECISION_OF_THE_INTERVAL_IS_TOO_SMALL] = -1;
    SQLSTATE[-OB_ERR_THE_LEADING_PRECISION_OF_THE_INTERVAL_IS_TOO_SMALL] = "HY000";
    STR_ERROR[-OB_ERR_THE_LEADING_PRECISION_OF_THE_INTERVAL_IS_TOO_SMALL] = "the leading precision of the interval is too small";
    STR_USER_ERROR[-OB_ERR_THE_LEADING_PRECISION_OF_THE_INTERVAL_IS_TOO_SMALL] = "the leading precision of the interval is too small";
    MYSQL_ERRNO[-OB_ERR_INVALID_TIME_ZONE_HOUR] = -1;
    SQLSTATE[-OB_ERR_INVALID_TIME_ZONE_HOUR] = "HY000";
    STR_ERROR[-OB_ERR_INVALID_TIME_ZONE_HOUR] = "time zone hour must be between -12 and 14";
    STR_USER_ERROR[-OB_ERR_INVALID_TIME_ZONE_HOUR] = "time zone hour must be between -12 and 14";
    MYSQL_ERRNO[-OB_ERR_INVALID_TIME_ZONE_MINUTE] = -1;
    SQLSTATE[-OB_ERR_INVALID_TIME_ZONE_MINUTE] = "HY000";
    STR_ERROR[-OB_ERR_INVALID_TIME_ZONE_MINUTE] = "time zone minute must be between -59 and 59";
    STR_USER_ERROR[-OB_ERR_INVALID_TIME_ZONE_MINUTE] = "time zone minute must be between -59 and 59";
    MYSQL_ERRNO[-OB_ERR_NOT_A_VALID_TIME_ZONE] = -1;
    SQLSTATE[-OB_ERR_NOT_A_VALID_TIME_ZONE] = "HY000";
    STR_ERROR[-OB_ERR_NOT_A_VALID_TIME_ZONE] = "not a valid time zone";
    STR_USER_ERROR[-OB_ERR_NOT_A_VALID_TIME_ZONE] = "not a valid time zone";
    MYSQL_ERRNO[-OB_ERR_DATE_FORMAT_IS_TOO_LONG_FOR_INTERNAL_BUFFER] = -1;
    SQLSTATE[-OB_ERR_DATE_FORMAT_IS_TOO_LONG_FOR_INTERNAL_BUFFER] = "HY000";
    STR_ERROR[-OB_ERR_DATE_FORMAT_IS_TOO_LONG_FOR_INTERNAL_BUFFER] = "date format is too long for internal buffer";
    STR_USER_ERROR[-OB_ERR_DATE_FORMAT_IS_TOO_LONG_FOR_INTERNAL_BUFFER] = "date format is too long for internal buffer";
    MYSQL_ERRNO[-OB_INVALID_ROWID] = -1;
    SQLSTATE[-OB_INVALID_ROWID] = "HY000";
    STR_ERROR[-OB_INVALID_ROWID] = "invalid ROWID";
    STR_USER_ERROR[-OB_INVALID_ROWID] = "invalid ROWID";
    MYSQL_ERRNO[-OB_ERR_DATETIME_INTERVAL_INTERNAL_ERROR] = -1;
    SQLSTATE[-OB_ERR_DATETIME_INTERVAL_INTERNAL_ERROR] = "HY000";
    STR_ERROR[-OB_ERR_DATETIME_INTERVAL_INTERNAL_ERROR] = "Datetime/Interval internal error";
    STR_USER_ERROR[-OB_ERR_DATETIME_INTERVAL_INTERNAL_ERROR] = "Datetime/Interval internal error";
    MYSQL_ERRNO[-OB_ERR_FETCH_OUT_SEQUENCE] = 1002;
    SQLSTATE[-OB_ERR_FETCH_OUT_SEQUENCE] = "HY000";
    STR_ERROR[-OB_ERR_FETCH_OUT_SEQUENCE] = "ORA-01002: fetch out of sequence";
    STR_USER_ERROR[-OB_ERR_FETCH_OUT_SEQUENCE] = "ORA-01002: fetch out of sequence";
    MYSQL_ERRNO[-OB_TRANSACTION_SET_VIOLATION] = -1;
    SQLSTATE[-OB_TRANSACTION_SET_VIOLATION] = "25000";
    STR_ERROR[-OB_TRANSACTION_SET_VIOLATION] = "Transaction set changed during the execution";
    STR_USER_ERROR[-OB_TRANSACTION_SET_VIOLATION] = "Transaction set changed during the execution";
    MYSQL_ERRNO[-OB_TRANS_ROLLBACKED] = -1;
    SQLSTATE[-OB_TRANS_ROLLBACKED] = "40000";
    STR_ERROR[-OB_TRANS_ROLLBACKED] = "Transaction rollbacked";
    STR_USER_ERROR[-OB_TRANS_ROLLBACKED] = "transaction is rolled back";
    MYSQL_ERRNO[-OB_ERR_EXCLUSIVE_LOCK_CONFLICT] = ER_LOCK_WAIT_TIMEOUT;
    SQLSTATE[-OB_ERR_EXCLUSIVE_LOCK_CONFLICT] = "HY000";
    STR_ERROR[-OB_ERR_EXCLUSIVE_LOCK_CONFLICT] = "Lock wait timeout exceeded; try restarting transaction";
    STR_USER_ERROR[-OB_ERR_EXCLUSIVE_LOCK_CONFLICT] = "Lock wait timeout exceeded; try restarting transaction";
    MYSQL_ERRNO[-OB_ERR_SHARED_LOCK_CONFLICT] = -1;
    SQLSTATE[-OB_ERR_SHARED_LOCK_CONFLICT] = "HY000";
    STR_ERROR[-OB_ERR_SHARED_LOCK_CONFLICT] = "Shared lock conflict";
    STR_USER_ERROR[-OB_ERR_SHARED_LOCK_CONFLICT] = "Shared lock conflict";
    MYSQL_ERRNO[-OB_TRY_LOCK_ROW_CONFLICT] = -1;
    SQLSTATE[-OB_TRY_LOCK_ROW_CONFLICT] = "HY000";
    STR_ERROR[-OB_TRY_LOCK_ROW_CONFLICT] = "Try lock row conflict";
    STR_USER_ERROR[-OB_TRY_LOCK_ROW_CONFLICT] = "Try lock row conflict";
    MYSQL_ERRNO[-OB_CLOCK_OUT_OF_ORDER] = -1;
    SQLSTATE[-OB_CLOCK_OUT_OF_ORDER] = "25000";
    STR_ERROR[-OB_CLOCK_OUT_OF_ORDER] = "Clock out of order";
    STR_USER_ERROR[-OB_CLOCK_OUT_OF_ORDER] = "Clock out of order";
    MYSQL_ERRNO[-OB_MASK_SET_NO_NODE] = -1;
    SQLSTATE[-OB_MASK_SET_NO_NODE] = "25000";
    STR_ERROR[-OB_MASK_SET_NO_NODE] = "Mask set has no node";
    STR_USER_ERROR[-OB_MASK_SET_NO_NODE] = "Mask set has no node";
    MYSQL_ERRNO[-OB_TRANS_HAS_DECIDED] = -1;
    SQLSTATE[-OB_TRANS_HAS_DECIDED] = "HY000";
    STR_ERROR[-OB_TRANS_HAS_DECIDED] = "Transaction has been decided";
    STR_USER_ERROR[-OB_TRANS_HAS_DECIDED] = "Transaction has been decided";
    MYSQL_ERRNO[-OB_TRANS_INVALID_STATE] = -1;
    SQLSTATE[-OB_TRANS_INVALID_STATE] = "HY000";
    STR_ERROR[-OB_TRANS_INVALID_STATE] = "Transaction state invalid";
    STR_USER_ERROR[-OB_TRANS_INVALID_STATE] = "Transaction state invalid";
    MYSQL_ERRNO[-OB_TRANS_STATE_NOT_CHANGE] = -1;
    SQLSTATE[-OB_TRANS_STATE_NOT_CHANGE] = "HY000";
    STR_ERROR[-OB_TRANS_STATE_NOT_CHANGE] = "Transaction state not changed";
    STR_USER_ERROR[-OB_TRANS_STATE_NOT_CHANGE] = "Transaction state not changed";
    MYSQL_ERRNO[-OB_TRANS_PROTOCOL_ERROR] = -1;
    SQLSTATE[-OB_TRANS_PROTOCOL_ERROR] = "HY000";
    STR_ERROR[-OB_TRANS_PROTOCOL_ERROR] = "Transaction protocol error";
    STR_USER_ERROR[-OB_TRANS_PROTOCOL_ERROR] = "Transaction protocol error";
    MYSQL_ERRNO[-OB_TRANS_INVALID_MESSAGE] = -1;
    SQLSTATE[-OB_TRANS_INVALID_MESSAGE] = "HY000";
    STR_ERROR[-OB_TRANS_INVALID_MESSAGE] = "Transaction message invalid";
    STR_USER_ERROR[-OB_TRANS_INVALID_MESSAGE] = "Transaction message invalid";
    MYSQL_ERRNO[-OB_TRANS_INVALID_MESSAGE_TYPE] = -1;
    SQLSTATE[-OB_TRANS_INVALID_MESSAGE_TYPE] = "HY000";
    STR_ERROR[-OB_TRANS_INVALID_MESSAGE_TYPE] = "Transaction message type invalid";
    STR_USER_ERROR[-OB_TRANS_INVALID_MESSAGE_TYPE] = "Transaction message type invalid";
    MYSQL_ERRNO[-OB_TRANS_TIMEOUT] = 4012;
    SQLSTATE[-OB_TRANS_TIMEOUT] = "25000";
    STR_ERROR[-OB_TRANS_TIMEOUT] = "Transaction is timeout";
    STR_USER_ERROR[-OB_TRANS_TIMEOUT] = "Transaction is timeout";
    MYSQL_ERRNO[-OB_TRANS_KILLED] = 6002;
    SQLSTATE[-OB_TRANS_KILLED] = "25000";
    STR_ERROR[-OB_TRANS_KILLED] = "Transaction is killed";
    STR_USER_ERROR[-OB_TRANS_KILLED] = "Transaction is killed";
    MYSQL_ERRNO[-OB_TRANS_STMT_TIMEOUT] = 4012;
    SQLSTATE[-OB_TRANS_STMT_TIMEOUT] = "25000";
    STR_ERROR[-OB_TRANS_STMT_TIMEOUT] = "Statement is timeout";
    STR_USER_ERROR[-OB_TRANS_STMT_TIMEOUT] = "Statement is timeout";
    MYSQL_ERRNO[-OB_TRANS_CTX_NOT_EXIST] = 6002;
    SQLSTATE[-OB_TRANS_CTX_NOT_EXIST] = "HY000";
    STR_ERROR[-OB_TRANS_CTX_NOT_EXIST] = "Transaction context does not exist";
    STR_USER_ERROR[-OB_TRANS_CTX_NOT_EXIST] = "Transaction context does not exist";
    MYSQL_ERRNO[-OB_PARTITION_IS_FROZEN] = 6002;
    SQLSTATE[-OB_PARTITION_IS_FROZEN] = "25000";
    STR_ERROR[-OB_PARTITION_IS_FROZEN] = "Partition is frozen";
    STR_USER_ERROR[-OB_PARTITION_IS_FROZEN] = "Partition is frozen";
    MYSQL_ERRNO[-OB_PARTITION_IS_NOT_FROZEN] = -1;
    SQLSTATE[-OB_PARTITION_IS_NOT_FROZEN] = "HY000";
    STR_ERROR[-OB_PARTITION_IS_NOT_FROZEN] = "Partition is not frozen";
    STR_USER_ERROR[-OB_PARTITION_IS_NOT_FROZEN] = "Partition is not frozen";
    MYSQL_ERRNO[-OB_TRANS_INVALID_LOG_TYPE] = -1;
    SQLSTATE[-OB_TRANS_INVALID_LOG_TYPE] = "HY000";
    STR_ERROR[-OB_TRANS_INVALID_LOG_TYPE] = "Transaction invalid log type";
    STR_USER_ERROR[-OB_TRANS_INVALID_LOG_TYPE] = "Transaction invalid log type";
    MYSQL_ERRNO[-OB_TRANS_SQL_SEQUENCE_ILLEGAL] = -1;
    SQLSTATE[-OB_TRANS_SQL_SEQUENCE_ILLEGAL] = "HY000";
    STR_ERROR[-OB_TRANS_SQL_SEQUENCE_ILLEGAL] = "SQL sequence illegal";
    STR_USER_ERROR[-OB_TRANS_SQL_SEQUENCE_ILLEGAL] = "SQL sequence illegal";
    MYSQL_ERRNO[-OB_TRANS_CANNOT_BE_KILLED] = -1;
    SQLSTATE[-OB_TRANS_CANNOT_BE_KILLED] = "HY000";
    STR_ERROR[-OB_TRANS_CANNOT_BE_KILLED] = "Transaction context cannot be killed";
    STR_USER_ERROR[-OB_TRANS_CANNOT_BE_KILLED] = "Transaction context cannot be killed";
    MYSQL_ERRNO[-OB_TRANS_STATE_UNKNOWN] = -1;
    SQLSTATE[-OB_TRANS_STATE_UNKNOWN] = "HY000";
    STR_ERROR[-OB_TRANS_STATE_UNKNOWN] = "Transaction state unknown";
    STR_USER_ERROR[-OB_TRANS_STATE_UNKNOWN] = "Transaction state unknown";
    MYSQL_ERRNO[-OB_TRANS_IS_EXITING] = 6002;
    SQLSTATE[-OB_TRANS_IS_EXITING] = "25000";
    STR_ERROR[-OB_TRANS_IS_EXITING] = "Transaction exiting";
    STR_USER_ERROR[-OB_TRANS_IS_EXITING] = "Transaction exiting";
    MYSQL_ERRNO[-OB_TRANS_NEED_ROLLBACK] = 6002;
    SQLSTATE[-OB_TRANS_NEED_ROLLBACK] = "25000";
    STR_ERROR[-OB_TRANS_NEED_ROLLBACK] = "transaction need rollback";
    STR_USER_ERROR[-OB_TRANS_NEED_ROLLBACK] = "transaction need rollback";
    MYSQL_ERRNO[-OB_TRANS_UNKNOWN] = 4012;
    SQLSTATE[-OB_TRANS_UNKNOWN] = "25000";
    STR_ERROR[-OB_TRANS_UNKNOWN] = "Transaction result is unknown";
    STR_USER_ERROR[-OB_TRANS_UNKNOWN] = "Transaction result is unknown";
    MYSQL_ERRNO[-OB_ERR_READ_ONLY_TRANSACTION] = ER_CANT_EXECUTE_IN_READ_ONLY_TRANSACTION;
    SQLSTATE[-OB_ERR_READ_ONLY_TRANSACTION] = "25006";
    STR_ERROR[-OB_ERR_READ_ONLY_TRANSACTION] = "Cannot execute statement in a READ ONLY transaction";
    STR_USER_ERROR[-OB_ERR_READ_ONLY_TRANSACTION] = "Cannot execute statement in a READ ONLY transaction";
    MYSQL_ERRNO[-OB_PARTITION_IS_NOT_STOPPED] = -1;
    SQLSTATE[-OB_PARTITION_IS_NOT_STOPPED] = "HY000";
    STR_ERROR[-OB_PARTITION_IS_NOT_STOPPED] = "Partition is not stopped";
    STR_USER_ERROR[-OB_PARTITION_IS_NOT_STOPPED] = "Partition is not stopped";
    MYSQL_ERRNO[-OB_PARTITION_IS_STOPPED] = -1;
    SQLSTATE[-OB_PARTITION_IS_STOPPED] = "HY000";
    STR_ERROR[-OB_PARTITION_IS_STOPPED] = "Partition has been stopped";
    STR_USER_ERROR[-OB_PARTITION_IS_STOPPED] = "Partition has been stopped";
    MYSQL_ERRNO[-OB_PARTITION_IS_BLOCKED] = -1;
    SQLSTATE[-OB_PARTITION_IS_BLOCKED] = "HY000";
    STR_ERROR[-OB_PARTITION_IS_BLOCKED] = "Partition has been blocked";
    STR_USER_ERROR[-OB_PARTITION_IS_BLOCKED] = "Partition has been blocked";
    MYSQL_ERRNO[-OB_TRANS_RPC_TIMEOUT] = 4012;
    SQLSTATE[-OB_TRANS_RPC_TIMEOUT] = "25000";
    STR_ERROR[-OB_TRANS_RPC_TIMEOUT] = "transaction rpc timeout";
    STR_USER_ERROR[-OB_TRANS_RPC_TIMEOUT] = "transaction rpc timeout";

    // in transaction internal routing, if sql not supported to be executed on participant sent to participant
    // server return OB_TRANS_FREE_ROUTE_NOT_SUPPORTED
    // proxy downgrade transaction internal routing and send the rest of sql to coordinator
    MYSQL_ERRNO[-OB_TRANS_FREE_ROUTE_NOT_SUPPORTED] = -1;
    SQLSTATE[-OB_TRANS_FREE_ROUTE_NOT_SUPPORTED] = "HY000";
    STR_ERROR[-OB_TRANS_FREE_ROUTE_NOT_SUPPORTED] = "Query is not supported to be executed on txn participant node";
    STR_USER_ERROR[-OB_TRANS_FREE_ROUTE_NOT_SUPPORTED] = "Query is not supported to be executed on txn participant node";
    MYSQL_ERRNO[-OB_LOG_ID_NOT_FOUND] = -1;
    SQLSTATE[-OB_LOG_ID_NOT_FOUND] = "HY000";
    STR_ERROR[-OB_LOG_ID_NOT_FOUND] = "log id not found";
    STR_USER_ERROR[-OB_LOG_ID_NOT_FOUND] = "log id not found";
    MYSQL_ERRNO[-OB_LSR_THREAD_STOPPED] = -1;
    SQLSTATE[-OB_LSR_THREAD_STOPPED] = "HY000";
    STR_ERROR[-OB_LSR_THREAD_STOPPED] = "log scan runnable thread stop";
    STR_USER_ERROR[-OB_LSR_THREAD_STOPPED] = "log scan runnable thread stop";
    MYSQL_ERRNO[-OB_NO_LOG] = -1;
    SQLSTATE[-OB_NO_LOG] = "HY000";
    STR_ERROR[-OB_NO_LOG] = "no log ever scanned";
    STR_USER_ERROR[-OB_NO_LOG] = "no log ever scanned";
    MYSQL_ERRNO[-OB_LOG_ID_RANGE_ERROR] = -1;
    SQLSTATE[-OB_LOG_ID_RANGE_ERROR] = "HY000";
    STR_ERROR[-OB_LOG_ID_RANGE_ERROR] = "log id range error";
    STR_USER_ERROR[-OB_LOG_ID_RANGE_ERROR] = "log id range error";
    MYSQL_ERRNO[-OB_LOG_ITER_ENOUGH] = -1;
    SQLSTATE[-OB_LOG_ITER_ENOUGH] = "HY000";
    STR_ERROR[-OB_LOG_ITER_ENOUGH] = "iter scans enough files";
    STR_USER_ERROR[-OB_LOG_ITER_ENOUGH] = "iter scans enough files";
    MYSQL_ERRNO[-OB_CLOG_INVALID_ACK] = -1;
    SQLSTATE[-OB_CLOG_INVALID_ACK] = "HY000";
    STR_ERROR[-OB_CLOG_INVALID_ACK] = "invalid ack msg";
    STR_USER_ERROR[-OB_CLOG_INVALID_ACK] = "invalid ack msg";
    MYSQL_ERRNO[-OB_CLOG_CACHE_INVALID] = -1;
    SQLSTATE[-OB_CLOG_CACHE_INVALID] = "HY000";
    STR_ERROR[-OB_CLOG_CACHE_INVALID] = "clog cache invalid";
    STR_USER_ERROR[-OB_CLOG_CACHE_INVALID] = "clog cache invalid";
    MYSQL_ERRNO[-OB_EXT_HANDLE_UNFINISH] = -1;
    SQLSTATE[-OB_EXT_HANDLE_UNFINISH] = "HY000";
    STR_ERROR[-OB_EXT_HANDLE_UNFINISH] = "external executor handle do not finish";
    STR_USER_ERROR[-OB_EXT_HANDLE_UNFINISH] = "external executor handle do not finish";
    MYSQL_ERRNO[-OB_CURSOR_NOT_EXIST] = -1;
    SQLSTATE[-OB_CURSOR_NOT_EXIST] = "HY000";
    STR_ERROR[-OB_CURSOR_NOT_EXIST] = "cursor not exist";
    STR_USER_ERROR[-OB_CURSOR_NOT_EXIST] = "cursor not exist";
    MYSQL_ERRNO[-OB_STREAM_NOT_EXIST] = -1;
    SQLSTATE[-OB_STREAM_NOT_EXIST] = "HY000";
    STR_ERROR[-OB_STREAM_NOT_EXIST] = "stream not exist";
    STR_USER_ERROR[-OB_STREAM_NOT_EXIST] = "stream not exist";
    MYSQL_ERRNO[-OB_STREAM_BUSY] = -1;
    SQLSTATE[-OB_STREAM_BUSY] = "HY000";
    STR_ERROR[-OB_STREAM_BUSY] = "stream busy";
    STR_USER_ERROR[-OB_STREAM_BUSY] = "stream busy";
    MYSQL_ERRNO[-OB_FILE_RECYCLED] = -1;
    SQLSTATE[-OB_FILE_RECYCLED] = "HY000";
    STR_ERROR[-OB_FILE_RECYCLED] = "file recycled";
    STR_USER_ERROR[-OB_FILE_RECYCLED] = "file recycled";
    MYSQL_ERRNO[-OB_REPLAY_EAGAIN_TOO_MUCH_TIME] = -1;
    SQLSTATE[-OB_REPLAY_EAGAIN_TOO_MUCH_TIME] = "HY000";
    STR_ERROR[-OB_REPLAY_EAGAIN_TOO_MUCH_TIME] = "replay eagain cost too much time";
    STR_USER_ERROR[-OB_REPLAY_EAGAIN_TOO_MUCH_TIME] = "replay eagain cost too much time";
    MYSQL_ERRNO[-OB_MEMBER_CHANGE_FAILED] = -1;
    SQLSTATE[-OB_MEMBER_CHANGE_FAILED] = "HY000";
    STR_ERROR[-OB_MEMBER_CHANGE_FAILED] = "member change log sync failed";
    STR_USER_ERROR[-OB_MEMBER_CHANGE_FAILED] = "member change log sync failed";
    MYSQL_ERRNO[-OB_ELECTION_WARN_LOGBUF_FULL] = -1;
    SQLSTATE[-OB_ELECTION_WARN_LOGBUF_FULL] = "HY000";
    STR_ERROR[-OB_ELECTION_WARN_LOGBUF_FULL] = "The log buffer is full";
    STR_USER_ERROR[-OB_ELECTION_WARN_LOGBUF_FULL] = "The log buffer is full";
    MYSQL_ERRNO[-OB_ELECTION_WARN_LOGBUF_EMPTY] = -1;
    SQLSTATE[-OB_ELECTION_WARN_LOGBUF_EMPTY] = "HY000";
    STR_ERROR[-OB_ELECTION_WARN_LOGBUF_EMPTY] = "The log buffer is empty";
    STR_USER_ERROR[-OB_ELECTION_WARN_LOGBUF_EMPTY] = "The log buffer is empty";
    MYSQL_ERRNO[-OB_ELECTION_WARN_NOT_RUNNING] = -1;
    SQLSTATE[-OB_ELECTION_WARN_NOT_RUNNING] = "HY000";
    STR_ERROR[-OB_ELECTION_WARN_NOT_RUNNING] = "The object is not running";
    STR_USER_ERROR[-OB_ELECTION_WARN_NOT_RUNNING] = "The object is not running";
    MYSQL_ERRNO[-OB_ELECTION_WARN_IS_RUNNING] = -1;
    SQLSTATE[-OB_ELECTION_WARN_IS_RUNNING] = "HY000";
    STR_ERROR[-OB_ELECTION_WARN_IS_RUNNING] = "The object is running";
    STR_USER_ERROR[-OB_ELECTION_WARN_IS_RUNNING] = "The object is running";
    MYSQL_ERRNO[-OB_ELECTION_WARN_NOT_REACH_MAJORITY] = -1;
    SQLSTATE[-OB_ELECTION_WARN_NOT_REACH_MAJORITY] = "HY000";
    STR_ERROR[-OB_ELECTION_WARN_NOT_REACH_MAJORITY] = "Election does not reach majority";
    STR_USER_ERROR[-OB_ELECTION_WARN_NOT_REACH_MAJORITY] = "Election does not reach majority";
    MYSQL_ERRNO[-OB_ELECTION_WARN_INVALID_SERVER] = -1;
    SQLSTATE[-OB_ELECTION_WARN_INVALID_SERVER] = "HY000";
    STR_ERROR[-OB_ELECTION_WARN_INVALID_SERVER] = "The server is not valid";
    STR_USER_ERROR[-OB_ELECTION_WARN_INVALID_SERVER] = "The server is not valid";
    MYSQL_ERRNO[-OB_ELECTION_WARN_INVALID_LEADER] = -1;
    SQLSTATE[-OB_ELECTION_WARN_INVALID_LEADER] = "HY000";
    STR_ERROR[-OB_ELECTION_WARN_INVALID_LEADER] = "The leader is not valid";
    STR_USER_ERROR[-OB_ELECTION_WARN_INVALID_LEADER] = "The leader is not valid";
    MYSQL_ERRNO[-OB_ELECTION_WARN_LEADER_LEASE_EXPIRED] = -1;
    SQLSTATE[-OB_ELECTION_WARN_LEADER_LEASE_EXPIRED] = "HY000";
    STR_ERROR[-OB_ELECTION_WARN_LEADER_LEASE_EXPIRED] = "The leader lease is expired";
    STR_USER_ERROR[-OB_ELECTION_WARN_LEADER_LEASE_EXPIRED] = "The leader lease is expired";
    MYSQL_ERRNO[-OB_ELECTION_WARN_INVALID_MESSAGE] = -1;
    SQLSTATE[-OB_ELECTION_WARN_INVALID_MESSAGE] = "HY000";
    STR_ERROR[-OB_ELECTION_WARN_INVALID_MESSAGE] = "The message is not valid";
    STR_USER_ERROR[-OB_ELECTION_WARN_INVALID_MESSAGE] = "The message is not valid";
    MYSQL_ERRNO[-OB_ELECTION_WARN_MESSAGE_NOT_INTIME] = -1;
    SQLSTATE[-OB_ELECTION_WARN_MESSAGE_NOT_INTIME] = "HY000";
    STR_ERROR[-OB_ELECTION_WARN_MESSAGE_NOT_INTIME] = "The message is not intime";
    STR_USER_ERROR[-OB_ELECTION_WARN_MESSAGE_NOT_INTIME] = "The message is not intime";
    MYSQL_ERRNO[-OB_ELECTION_WARN_NOT_CANDIDATE] = -1;
    SQLSTATE[-OB_ELECTION_WARN_NOT_CANDIDATE] = "HY000";
    STR_ERROR[-OB_ELECTION_WARN_NOT_CANDIDATE] = "The server is not candidate";
    STR_USER_ERROR[-OB_ELECTION_WARN_NOT_CANDIDATE] = "The server is not candidate";
    MYSQL_ERRNO[-OB_ELECTION_WARN_NOT_CANDIDATE_OR_VOTER] = -1;
    SQLSTATE[-OB_ELECTION_WARN_NOT_CANDIDATE_OR_VOTER] = "HY000";
    STR_ERROR[-OB_ELECTION_WARN_NOT_CANDIDATE_OR_VOTER] = "The server is not candidate or voter";
    STR_USER_ERROR[-OB_ELECTION_WARN_NOT_CANDIDATE_OR_VOTER] = "The server is not candidate or voter";
    MYSQL_ERRNO[-OB_ELECTION_WARN_PROTOCOL_ERROR] = -1;
    SQLSTATE[-OB_ELECTION_WARN_PROTOCOL_ERROR] = "HY000";
    STR_ERROR[-OB_ELECTION_WARN_PROTOCOL_ERROR] = "Election protocol error";
    STR_USER_ERROR[-OB_ELECTION_WARN_PROTOCOL_ERROR] = "Election protocol error";
    MYSQL_ERRNO[-OB_ELECTION_WARN_RUNTIME_OUT_OF_RANGE] = -1;
    SQLSTATE[-OB_ELECTION_WARN_RUNTIME_OUT_OF_RANGE] = "HY000";
    STR_ERROR[-OB_ELECTION_WARN_RUNTIME_OUT_OF_RANGE] = "The task run time out of range";
    STR_USER_ERROR[-OB_ELECTION_WARN_RUNTIME_OUT_OF_RANGE] = "The task run time out of range";
    MYSQL_ERRNO[-OB_ELECTION_WARN_LAST_OPERATION_NOT_DONE] = -1;
    SQLSTATE[-OB_ELECTION_WARN_LAST_OPERATION_NOT_DONE] = "HY000";
    STR_ERROR[-OB_ELECTION_WARN_LAST_OPERATION_NOT_DONE] = "Last operation has not done";
    STR_USER_ERROR[-OB_ELECTION_WARN_LAST_OPERATION_NOT_DONE] = "Last operation has not done";
    MYSQL_ERRNO[-OB_ELECTION_WARN_CURRENT_SERVER_NOT_LEADER] = -1;
    SQLSTATE[-OB_ELECTION_WARN_CURRENT_SERVER_NOT_LEADER] = "HY000";
    STR_ERROR[-OB_ELECTION_WARN_CURRENT_SERVER_NOT_LEADER] = "Current server is not leader";
    STR_USER_ERROR[-OB_ELECTION_WARN_CURRENT_SERVER_NOT_LEADER] = "Current server is not leader";
    MYSQL_ERRNO[-OB_ELECTION_WARN_NO_PREPARE_MESSAGE] = -1;
    SQLSTATE[-OB_ELECTION_WARN_NO_PREPARE_MESSAGE] = "HY000";
    STR_ERROR[-OB_ELECTION_WARN_NO_PREPARE_MESSAGE] = "There is not prepare message";
    STR_USER_ERROR[-OB_ELECTION_WARN_NO_PREPARE_MESSAGE] = "There is not prepare message";
    MYSQL_ERRNO[-OB_ELECTION_ERROR_MULTI_PREPARE_MESSAGE] = -1;
    SQLSTATE[-OB_ELECTION_ERROR_MULTI_PREPARE_MESSAGE] = "HY000";
    STR_ERROR[-OB_ELECTION_ERROR_MULTI_PREPARE_MESSAGE] = "There is more than one prepare message";
    STR_USER_ERROR[-OB_ELECTION_ERROR_MULTI_PREPARE_MESSAGE] = "There is more than one prepare message";
    MYSQL_ERRNO[-OB_ELECTION_NOT_EXIST] = -1;
    SQLSTATE[-OB_ELECTION_NOT_EXIST] = "HY000";
    STR_ERROR[-OB_ELECTION_NOT_EXIST] = "Election does not exist";
    STR_USER_ERROR[-OB_ELECTION_NOT_EXIST] = "Election does not exist";
    MYSQL_ERRNO[-OB_ELECTION_MGR_IS_RUNNING] = -1;
    SQLSTATE[-OB_ELECTION_MGR_IS_RUNNING] = "HY000";
    STR_ERROR[-OB_ELECTION_MGR_IS_RUNNING] = "Election manager is running";
    STR_USER_ERROR[-OB_ELECTION_MGR_IS_RUNNING] = "Election manager is running";
    MYSQL_ERRNO[-OB_ELECTION_WARN_NO_MAJORITY_PREPARE_MESSAGE] = -1;
    SQLSTATE[-OB_ELECTION_WARN_NO_MAJORITY_PREPARE_MESSAGE] = "HY000";
    STR_ERROR[-OB_ELECTION_WARN_NO_MAJORITY_PREPARE_MESSAGE] = "Election msg pool not have majority prepare message";
    STR_USER_ERROR[-OB_ELECTION_WARN_NO_MAJORITY_PREPARE_MESSAGE] = "Election msg pool not have majority prepare message";
    MYSQL_ERRNO[-OB_ELECTION_ASYNC_LOG_WARN_INIT] = -1;
    SQLSTATE[-OB_ELECTION_ASYNC_LOG_WARN_INIT] = "HY000";
    STR_ERROR[-OB_ELECTION_ASYNC_LOG_WARN_INIT] = "Election async log init error";
    STR_USER_ERROR[-OB_ELECTION_ASYNC_LOG_WARN_INIT] = "Election async log init error";
    MYSQL_ERRNO[-OB_ELECTION_WAIT_LEADER_MESSAGE] = -1;
    SQLSTATE[-OB_ELECTION_WAIT_LEADER_MESSAGE] = "HY000";
    STR_ERROR[-OB_ELECTION_WAIT_LEADER_MESSAGE] = "Election waiting leader message";
    STR_USER_ERROR[-OB_ELECTION_WAIT_LEADER_MESSAGE] = "Election waiting leader message";
    MYSQL_ERRNO[-OB_SERVER_IS_INIT] = -1;
    SQLSTATE[-OB_SERVER_IS_INIT] = "08004";
    STR_ERROR[-OB_SERVER_IS_INIT] = "Server is initializing";
    STR_USER_ERROR[-OB_SERVER_IS_INIT] = "Server is initializing";
    MYSQL_ERRNO[-OB_SERVER_IS_STOPPING] = -1;
    SQLSTATE[-OB_SERVER_IS_STOPPING] = "08004";
    STR_ERROR[-OB_SERVER_IS_STOPPING] = "Server is stopping";
    STR_USER_ERROR[-OB_SERVER_IS_STOPPING] = "Server is stopping";
    MYSQL_ERRNO[-OB_PACKET_CHECKSUM_ERROR] = -1;
    SQLSTATE[-OB_PACKET_CHECKSUM_ERROR] = "08004";
    STR_ERROR[-OB_PACKET_CHECKSUM_ERROR] = "Packet checksum error";
    STR_USER_ERROR[-OB_PACKET_CHECKSUM_ERROR] = "Packet checksum error";
    MYSQL_ERRNO[-OB_SSL_ERROR] = -1;
    SQLSTATE[-OB_SSL_ERROR] = "HY000";
    STR_ERROR[-OB_SSL_ERROR] = "SSL error";
    STR_USER_ERROR[-OB_SSL_ERROR] = "SSL error";
    MYSQL_ERRNO[-OB_UNSUPPORTED_PS] = ER_UNSUPPORTED_PS;
    SQLSTATE[-OB_UNSUPPORTED_PS] = "HY000";
    STR_ERROR[-OB_UNSUPPORTED_PS] = "This command is not supported in the prepared statement protocol yet";
    STR_USER_ERROR[-OB_UNSUPPORTED_PS] = "This command is not supported in the prepared statement protocol yet";
    MYSQL_ERRNO[-OB_ERR_LIMIT] = -1;
    SQLSTATE[-OB_ERR_LIMIT] = "HY000";
    STR_ERROR[-OB_ERR_LIMIT] = "The request is limited";
    STR_USER_ERROR[-OB_ERR_LIMIT] = "The request is limited by '%.*s'";
    MYSQL_ERRNO[-OB_SEQUENCE_ERROR] = 7100;
    SQLSTATE[-OB_SEQUENCE_ERROR] = "HY000";
    STR_ERROR[-OB_SEQUENCE_ERROR] = "Sequence error";
    STR_USER_ERROR[-OB_SEQUENCE_ERROR] = "Sequence error";
    MYSQL_ERRNO[-OB_EXPR_CALC_ERROR] = 7001;
    SQLSTATE[-OB_EXPR_CALC_ERROR] = "HY000";
    STR_ERROR[-OB_EXPR_CALC_ERROR] = "Table rule execute error";
    STR_USER_ERROR[-OB_EXPR_CALC_ERROR] = "Table rule execute error";
    MYSQL_ERRNO[-OB_EXPR_COLUMN_NOT_EXIST] = -1;
    SQLSTATE[-OB_EXPR_COLUMN_NOT_EXIST] = "HY000";
    STR_ERROR[-OB_EXPR_COLUMN_NOT_EXIST] = "column not exist";
    STR_USER_ERROR[-OB_EXPR_COLUMN_NOT_EXIST] = "column not exist";
    MYSQL_ERRNO[-OB_ERR_NO_ZONE_SHARD_TPO] = -1;
    SQLSTATE[-OB_ERR_NO_ZONE_SHARD_TPO] = "HY000";
    STR_ERROR[-OB_ERR_NO_ZONE_SHARD_TPO] = "local zone shards topology does not exist for strict mode";
    STR_USER_ERROR[-OB_ERR_NO_ZONE_SHARD_TPO] = "local zone shards topology does not exist for strict mode";
    MYSQL_ERRNO[-OB_ERR_NO_DEFAULT_SHARD_TPO] = -1;
    SQLSTATE[-OB_ERR_NO_DEFAULT_SHARD_TPO] = "HY000";
    STR_ERROR[-OB_ERR_NO_DEFAULT_SHARD_TPO] = "default shards topology does not exist";
    STR_USER_ERROR[-OB_ERR_NO_DEFAULT_SHARD_TPO] = "default shards topology does not exist";
    MYSQL_ERRNO[-OB_ERR_NO_TABLE_RULE] = 7002;
    SQLSTATE[-OB_ERR_NO_TABLE_RULE] = "HY000";
    STR_ERROR[-OB_ERR_NO_TABLE_RULE] = "Unable to find table rule";
    STR_USER_ERROR[-OB_ERR_NO_TABLE_RULE] = "Unable to find table rule";
    MYSQL_ERRNO[-OB_ERR_DISTRIBUTED_TRANSACTION_NOT_SUPPORTED] = 7031;
    SQLSTATE[-OB_ERR_DISTRIBUTED_TRANSACTION_NOT_SUPPORTED] = "HY000";
    STR_ERROR[-OB_ERR_DISTRIBUTED_TRANSACTION_NOT_SUPPORTED] = "Cannot execute update SQLs cross databases in transaction";
    STR_USER_ERROR[-OB_ERR_DISTRIBUTED_TRANSACTION_NOT_SUPPORTED] = "Cannot execute update SQLs cross databases in transaction";
    MYSQL_ERRNO[-OB_ERROR_UNSUPPORT_EXPR_TYPE] = -1;
    SQLSTATE[-OB_ERROR_UNSUPPORT_EXPR_TYPE] = "HY000";
    STR_ERROR[-OB_ERROR_UNSUPPORT_EXPR_TYPE] = "Expr not supported yet";
    STR_USER_ERROR[-OB_ERROR_UNSUPPORT_EXPR_TYPE] = "Expr not supported yet";
    MYSQL_ERRNO[-OB_ERR_FORMAT_FOR_TESTLOAD_TABLE_MAP] = -1;
    SQLSTATE[-OB_ERR_FORMAT_FOR_TESTLOAD_TABLE_MAP] = "HY000";
    STR_ERROR[-OB_ERR_FORMAT_FOR_TESTLOAD_TABLE_MAP] = "DatabaseVariables\'s format of testloadTableMap error";
    STR_USER_ERROR[-OB_ERR_FORMAT_FOR_TESTLOAD_TABLE_MAP] = "DatabaseVariables\'s format (\'%s\') of testloadTableMap error";
    MYSQL_ERRNO[-OB_ERR_MORE_TABLES_WITH_TABLE_HINT] = -1;
    SQLSTATE[-OB_ERR_MORE_TABLES_WITH_TABLE_HINT] = "HY000";
    STR_ERROR[-OB_ERR_MORE_TABLES_WITH_TABLE_HINT] = "Table count isn\'t 1 with \'table_name\' hint";
    STR_USER_ERROR[-OB_ERR_MORE_TABLES_WITH_TABLE_HINT] = "Table count isn\'t 1 with \'table_name\' hint %ld";
    MYSQL_ERRNO[-OB_ERR_GET_PHYSIC_INDEX_BY_RULE] = -1;
    SQLSTATE[-OB_ERR_GET_PHYSIC_INDEX_BY_RULE] = "HY000";
    STR_ERROR[-OB_ERR_GET_PHYSIC_INDEX_BY_RULE] = "Cannot get route info by user\'s rules and partition values";
    STR_USER_ERROR[-OB_ERR_GET_PHYSIC_INDEX_BY_RULE] = "Cannot get route info by user\'s rules and partition values";
    MYSQL_ERRNO[-OB_ERR_TESTLOAD_ALIPAY_COMPATIBLE] = -1;
    SQLSTATE[-OB_ERR_TESTLOAD_ALIPAY_COMPATIBLE] = "HY000";
    STR_ERROR[-OB_ERR_TESTLOAD_ALIPAY_COMPATIBLE] = "The table_name needed in TESTLOAD_ALIPAY_COMPATIBLE(\'testload = 8\') mode";
    STR_USER_ERROR[-OB_ERR_TESTLOAD_ALIPAY_COMPATIBLE] = "The table_name needed in TESTLOAD_ALIPAY_COMPATIBLE(\'testload = 8\') mode";
    MYSQL_ERRNO[-OB_ERR_NULL_DB_VAL_TESTLOAD_TABLE_MAP] = -1;
    SQLSTATE[-OB_ERR_NULL_DB_VAL_TESTLOAD_TABLE_MAP] = "HY000";
    STR_ERROR[-OB_ERR_NULL_DB_VAL_TESTLOAD_TABLE_MAP] = "Null database variable for testload table map to execute testload query";
    STR_USER_ERROR[-OB_ERR_NULL_DB_VAL_TESTLOAD_TABLE_MAP] = "Null database variable for testload table map to execute testload query";
    MYSQL_ERRNO[-OB_ERR_BATCH_INSERT_FOUND] = -1;
    SQLSTATE[-OB_ERR_BATCH_INSERT_FOUND] = "HY000";
    STR_ERROR[-OB_ERR_BATCH_INSERT_FOUND] = "Batch insert is not supported";
    STR_USER_ERROR[-OB_ERR_BATCH_INSERT_FOUND] = "Batch insert is not supported";
    MYSQL_ERRNO[-OB_ERR_UNSUPPORT_DIFF_TOPOLOGY] = 7202;
    SQLSTATE[-OB_ERR_UNSUPPORT_DIFF_TOPOLOGY] = "HY000";
    STR_ERROR[-OB_ERR_UNSUPPORT_DIFF_TOPOLOGY] = "Not support different topology table join";
    STR_USER_ERROR[-OB_ERR_UNSUPPORT_DIFF_TOPOLOGY] = "Not support different topology table join";
    MYSQL_ERRNO[-OB_SESSION_POOL_CMD_ERROR] = -1;
    SQLSTATE[-OB_SESSION_POOL_CMD_ERROR] = "HY000";
    STR_ERROR[-OB_SESSION_POOL_CMD_ERROR] = "Session pool error";
    STR_USER_ERROR[-OB_SESSION_POOL_CMD_ERROR] = "Session pool error";
    MYSQL_ERRNO[-OB_SESSION_POOL_FULL_ERROR] = OB_SESSION_POOL_FULL_ERROR; //8102;
    SQLSTATE[-OB_SESSION_POOL_FULL_ERROR] = "HY000";
    STR_ERROR[-OB_SESSION_POOL_FULL_ERROR] = "Session pool is full";
    STR_USER_ERROR[-OB_SESSION_POOL_FULL_ERROR] = "Session is full";
    MYSQL_ERRNO[-OB_ERR_SHARD_DDL_UNEXPECTED] = ER_SYNTAX_ERROR; //8204;
    SQLSTATE[-OB_ERR_SHARD_DDL_UNEXPECTED] = "HY000";
    STR_ERROR[-OB_ERR_SHARD_DDL_UNEXPECTED] = "Execute DDL job error";
    STR_USER_ERROR[-OB_ERR_SHARD_DDL_UNEXPECTED] = "Execute DDL job error";
    MYSQL_ERRNO[-OB_ERR_CAN_NOT_PASS_WHITELIST] = -1;
    SQLSTATE[-OB_ERR_CAN_NOT_PASS_WHITELIST] = "HY000";
    STR_ERROR[-OB_ERR_CAN_NOT_PASS_WHITELIST] = "Can not pass whitelist";
    STR_USER_ERROR[-OB_ERR_CAN_NOT_PASS_WHITELIST] = "Can not pass whitelist";
  }
} local_init;

namespace oceanbase
{
namespace common
{
  const char* ob_strerror(int err)
  {
    const char* ret = "Unknown error";
    if (OB_LIKELY(0 >= err && err > -OB_MAX_ERROR_CODE)) {
      ret = STR_ERROR[-err];
      if (OB_UNLIKELY(NULL == ret || '\0' == ret[0]))
      {
        ret = "Unknown Error";
      }
    }
    return ret;
  }
  const char* ob_str_user_error(int err)
  {
    const char* ret = NULL;
    if (OB_LIKELY(0 >= err && err > -OB_MAX_ERROR_CODE)) {
      ret = STR_USER_ERROR[-err];
      if (OB_UNLIKELY(NULL == ret || '\0' == ret[0])) {
        ret = NULL;
      }
    }
    return ret;
  }
  const char* ob_sqlstate(int err)
  {
    const char* ret = "HY000";
    if (OB_LIKELY(0 >= err && err > -OB_MAX_ERROR_CODE)) {
      ret = SQLSTATE[-err];
      if (OB_UNLIKELY(NULL == ret || '\0' == ret[0])) {
        ret = "HY000";
      }
    }
    return ret;
  }
  int ob_mysql_errno(int err)
  {
    int ret = -1;
    if (OB_LIKELY(0 >= err && err > -OB_MAX_ERROR_CODE)) {
      ret = MYSQL_ERRNO[-err];
    }
  return ret;
  }
} // end namespace common
} // end namespace oceanbase
