/**
 * Copyright (c) 2021 OceanBase
 * OceanBase Database Proxy(ODP) is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *          http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */

#ifdef MOD_ITEM_DEF
MOD_ITEM_DEF(OB_MOD_DO_NOT_USE_ME)

MOD_ITEM_DEF(OB_MOD_ALLOCATOR_START)
MOD_ITEM_DEF(OB_ALLOC_CHUNK)
MOD_ITEM_DEF(OB_ALLOC_BLOCK)
MOD_ITEM_DEF(OB_ALLOC_OBJECT)
MOD_ITEM_DEF(OB_MOD_ALLOCATOR_END)

MOD_ITEM_DEF(OB_MEMORY_STAT)

//debug
MOD_ITEM_DEF(OB_COMMON_ARRAY_OB_STMT)
MOD_ITEM_DEF(OB_COMMON_ARRAY_OB_SELECT_STMT)
MOD_ITEM_DEF(OB_COMMON_ARRAY_OB_LOG_TABLE_SCAN)
MOD_ITEM_DEF(OB_COMMON_ARRAY_OB_LOG_PLAN)
MOD_ITEM_DEF(OB_COMMON_ARRAY_OB_CANDIDATE_PLAN)
MOD_ITEM_DEF(OB_COMMON_ARRAY_OB_ALL_CANDIDATE_PLAN)
MOD_ITEM_DEF(OB_COMMON_ARRAY_OB_JOIN_ORDER)
MOD_ITEM_DEF(OB_COMMON_ARRAY_OB_LOGICAL_OPER)
MOD_ITEM_DEF(OB_COMMON_ARRAY_OB_LOGICAL_JOIN_OPER)
MOD_ITEM_DEF(OB_SE_ARRAY_OB_SHOW_CREATE_DATABASE_KEY_RANGES)
MOD_ITEM_DEF(OB_PAGE_ARENA_QUERY_RANGE)
MOD_ITEM_DEF(OB_CON_FIFO_ALLOC)
MOD_ITEM_DEF(OB_FIFO_ALLOC)
//end debug
///definemoduleshere
//commonmodules
MOD_ITEM_DEF(OB_OBJ_FREELISTS)
MOD_ITEM_DEF(OB_COMMON_NETWORK)
MOD_ITEM_DEF(OB_THREAD_BUFFER)
MOD_ITEM_DEF(OB_VARCACHE)
MOD_ITEM_DEF(OB_KVSTORE_CACHE)
MOD_ITEM_DEF(OB_DIAGNOSE_INFO)
MOD_ITEM_DEF(OB_SESSION_STAT)
MOD_ITEM_DEF(OB_WAIT_QUEUE)
MOD_ITEM_DEF(OB_TENANT_INFO)
MOD_ITEM_DEF(OB_TSI_FACTORY)
MOD_ITEM_DEF(OB_THREAD_OBJPOOL)
MOD_ITEM_DEF(OB_ROW_COMPACTION)
MOD_ITEM_DEF(OB_COMMON_COMPACTOR)
MOD_ITEM_DEF(OB_SQL_RPC_SCAN)
MOD_ITEM_DEF(OB_SQL_RPC_GET)
MOD_ITEM_DEF(OB_COMMON_ARRAY)
MOD_ITEM_DEF(OB_MYSQL_REQUEST_RECORD)
MOD_ITEM_DEF(OB_SE_ARRAY)
MOD_ITEM_DEF(OB_SE_ARRAY_ENGINE)
MOD_ITEM_DEF(OB_2D_ARRAY)
MOD_ITEM_DEF(OB_LIGHTY_QUEUE)
MOD_ITEM_DEF(OB_SEQ_QUEUE)
MOD_ITEM_DEF(OB_SEQ_CONTAINER)
MOD_ITEM_DEF(OB_RECENT_CACHE)
MOD_ITEM_DEF(OB_FILE_DIRECTOR_UTIL)
MOD_ITEM_DEF(OB_FETCH_RUNABLE)
MOD_ITEM_DEF(OB_GET_PARAM)
MOD_ITEM_DEF(OB_SCAN_PARAM)
MOD_ITEM_DEF(OB_MUTATOR)
MOD_ITEM_DEF(OB_SCANNER)
MOD_ITEM_DEF(OB_NEW_SCANNER)
MOD_ITEM_DEF(OB_MS_EVENT_SCANNER)
MOD_ITEM_DEF(OB_MS_BF_SCAN_SCANNER)
MOD_ITEM_DEF(OB_MS_BF_GET_SCANNER)
MOD_ITEM_DEF(OB_BUFFER)
MOD_ITEM_DEF(OB_THREAD_STORE)
MOD_ITEM_DEF(OB_LOG_WRITER)
MOD_ITEM_DEF(OB_LOG_READER)
MOD_ITEM_DEF(OB_REGEX)
MOD_ITEM_DEF(OB_SLAB)
MOD_ITEM_DEF(OB_SLAVE_MGR)
MOD_ITEM_DEF(OB_THREAD_MEM_POOL)
MOD_ITEM_DEF(OB_HASH_BUCKET)
MOD_ITEM_DEF(OB_HASH_NODE)
MOD_ITEM_DEF(OB_PAGE_ARENA)
MOD_ITEM_DEF(OB_NB_ACCESSOR)
MOD_ITEM_DEF(OB_STRING_BUF)
MOD_ITEM_DEF(OB_SCHEMA)
MOD_ITEM_DEF(OB_SCHEMA_SYS_SCHEMA)
MOD_ITEM_DEF(OB_SCHEMA_TENANT_SYS_SCHEMA)
MOD_ITEM_DEF(OB_SCHEMA_ROW_KEY)
MOD_ITEM_DEF(OB_SCHEMA_PRIV_TENANT_INFO)
MOD_ITEM_DEF(OB_SCHEMA_PRIV_NAME_MAP)
MOD_ITEM_DEF(OB_SCHEMA_PRIV_USER_INFO)
MOD_ITEM_DEF(OB_SCHEMA_PRIV_DB_PRIVS)
MOD_ITEM_DEF(OB_SCHEMA_PRIV_TABLE_PRIVS)
MOD_ITEM_DEF(OB_SCHEMA_PRIV_TABLE_PRIV_MAP)
MOD_ITEM_DEF(OB_SCHEMA_PRIV_LOCAL_ALLOCATOR)
MOD_ITEM_DEF(OB_SCHEMA_OPERATOR_SET_WITH_ALLOC)
MOD_ITEM_DEF(OB_SCHEMA_TABLE_INFOS)
MOD_ITEM_DEF(OB_SCHEMA_INDEX_TABLE_INFOS)
MOD_ITEM_DEF(OB_SCHEMA_DATABASE_INFOS)
MOD_ITEM_DEF(OB_SCHEMA_TABLEGROUP_INFOS)
MOD_ITEM_DEF(OB_SCHEMA_MAP)
MOD_ITEM_DEF(OB_SCHEMA_MAP_GUARD)
MOD_ITEM_DEF(OB_SCHEMA_SORTED_VECTOR)
MOD_ITEM_DEF(OB_SCHEMA_TENANT_NAME_MAP)
MOD_ITEM_DEF(OB_SCHEMA_USER_NAME_MAP)
MOD_ITEM_DEF(OB_SCHEMA_TABLE_ID_MAP)
MOD_ITEM_DEF(OB_SCHEMA_TABLE_NAME_MAP)
MOD_ITEM_DEF(OB_SCHEMA_TABLEGROUP_NAME_MAP)
MOD_ITEM_DEF(OB_SCHEMA_DATABASE_NAME_MAP)
MOD_ITEM_DEF(OB_SCHEMA_CACHE_SYS_CACHE_VALUE)
MOD_ITEM_DEF(OB_SCHEMA_TENANT_NAME_CASE_MODE_MAP)
MOD_ITEM_DEF(OB_SCHEMA_TENANT_NAME_SCHEMA_MAP)
MOD_ITEM_DEF(OB_SCHEMA_NAME)
MOD_ITEM_DEF(OB_SCHEMA_PRIV)
MOD_ITEM_DEF(OB_SCHEMA_ID_VERSIONS)
MOD_ITEM_DEF(OB_SCHEMA_CACHE_SYS_CACHE_MAP)
MOD_ITEM_DEF(OB_SCHEMA_GETTER_GUARD)
MOD_ITEM_DEF(OB_SCHEMA_UPDATE_INFO)
MOD_ITEM_DEF(OB_SCHEMA_MANAGER_LOCAL_ALLOCATOR)
MOD_ITEM_DEF(OB_SCHEMA_OB_SCHEMA_ARENA)
MOD_ITEM_DEF(OB_SCHEMA_SERVICE)
MOD_ITEM_DEF(OB_SCHEMA_MAX_USED_TABLE_ID_MAP)
MOD_ITEM_DEF(OB_SCHEMA_OUTLINE_INFO_VECTOR)
MOD_ITEM_DEF(OB_SCHEMA_OUTLINE_ID_MAP)
MOD_ITEM_DEF(OB_SCHEMA_OUTLINE_NAME_MAP)
MOD_ITEM_DEF(OB_SCHEMA_OUTLINE_SQL_MAP)
MOD_ITEM_DEF(OB_SCHEMA_OUTLINE_LOCAL_ALLOCATOR)
MOD_ITEM_DEF(OB_ROW_ITER_ADAPTOR)
MOD_ITEM_DEF(OB_WAITABLE_POOL)
MOD_ITEM_DEF(OB_ASYNC_FILE_APPENDER)
MOD_ITEM_DEF(OB_PLAN_EXECUTE)
MOD_ITEM_DEF(OB_MODULE_PAGE_ALLOCATOR)
MOD_ITEM_DEF(OB_PACKET_LIGHTY_QUEUE)
MOD_ITEM_DEF(LIBEASY)
MOD_ITEM_DEF(OB_RESULT_SET)
MOD_ITEM_DEF(OB_FIRST_TABLET_META)
MOD_ITEM_DEF(OB_FILE_CLIENT)
MOD_ITEM_DEF(OB_OLD_GROUPBY)
MOD_ITEM_DEF(OB_MEM_BUFFER)
MOD_ITEM_DEF(OB_USER_INFO_KEY)
MOD_ITEM_DEF(OB_PERM_INFO)
MOD_ITEM_DEF(OB_SKEY_INFO_KEY)
MOD_ITEM_DEF(OB_FIXED_QUEUE)
MOD_ITEM_DEF(OB_PACKET_QUEUE)
MOD_ITEM_DEF(OB_POOL)
MOD_ITEM_DEF(OB_BLOOM_FILTER)
MOD_ITEM_DEF(COMPACT_ROW)
MOD_ITEM_DEF(SPOP_QUEUE)
MOD_ITEM_DEF(BUCKET_LOCK)
MOD_ITEM_DEF(ID_MAP)
MOD_ITEM_DEF(LIB_OBSQL)
MOD_ITEM_DEF(BLOCK_ALLOC)
MOD_ITEM_DEF(VECTOR)
MOD_ITEM_DEF(TEST)
MOD_ITEM_DEF(QUERY_RESULT_READER)
MOD_ITEM_DEF(MYSQL_CLIENT_CACHE)
MOD_ITEM_DEF(SQL_CLIENT_READ_RESULT)
MOD_ITEM_DEF(TICKET_QUEUE)
MOD_ITEM_DEF(ACK_QUEUE)
MOD_ITEM_DEF(BALANCE_FILTER)
MOD_ITEM_DEF(TSI_BLOCK_ALLOC)
MOD_ITEM_DEF(JSON_PARSER)
MOD_ITEM_DEF(OB_CELL_CHECKER)
MOD_ITEM_DEF(OB_HASH_BUCKET_CONF_CONTAINER)
MOD_ITEM_DEF(OB_HASH_BUCKET_SQL_COLUMN_MAP)
MOD_ITEM_DEF(OB_HASH_BUCKET_TASK_MAP)
MOD_ITEM_DEF(OB_HASH_BUCKET_LRU_CACHE)
MOD_ITEM_DEF(OB_HASH_BUCKET_THREAD_LOCAL_INFO)
MOD_ITEM_DEF(OB_HASH_BUCKET_NEXT_WAIT_MAP)
MOD_ITEM_DEF(OB_HASH_BUCKET_PRIVILEGE)
MOD_ITEM_DEF(OB_HASH_BUCKET_SHRINK_CONTAINER)
MOD_ITEM_DEF(OB_HASH_BUCKET_MESSAGE_POOL)
MOD_ITEM_DEF(OB_HASH_NODE_CONF_CONTAINER)
MOD_ITEM_DEF(OB_HASH_NODE_SQL_COLUMN_MAP)
MOD_ITEM_DEF(OB_HASH_NODE_TASK_MAP)
MOD_ITEM_DEF(OB_HASH_NODE_LRU_CACHE)
MOD_ITEM_DEF(OB_HASH_NODE_THREAD_LOCAL_INFO)
MOD_ITEM_DEF(OB_HASH_NODE_NEXT_WAIT_MAP)
MOD_ITEM_DEF(OB_HASH_NODE_PRIVILEGE)
MOD_ITEM_DEF(OB_HASH_NODE_SHRINK_CONTAINER)
MOD_ITEM_DEF(OB_HASH_NODE_MESSAGE_POOL)
MOD_ITEM_DEF(OB_RPC_ROOT_TABLE)
MOD_ITEM_DEF(OB_SQL_STRING)
MOD_ITEM_DEF(OB_INNER_SQL_CONN_POOL)
MOD_ITEM_DEF(OB_JSON_PARSER)
MOD_ITEM_DEF(OB_LINEAR_HASH_MAP)
MOD_ITEM_DEF(OB_CONCURRENCY_OBJ_POOL)
MOD_ITEM_DEF(OB_AUTOINCREMENT)
MOD_ITEM_DEF(OB_CORE_TABLE_PROXY)
MOD_ITEM_DEF(OB_BIT_MAP)
MOD_ITEM_DEF(OB_BIT_SET)
MOD_ITEM_DEF(OB_HASH_BUCKET_GLOBAL_STATUS_MAP)
MOD_ITEM_DEF(OB_HASH_BUCKET_SESSION_STATUS_MAP)
MOD_ITEM_DEF(OB_COMMON_SYS_VAR_FAC)
MOD_ITEM_DEF(OB_COMMON_SYS_VAR_DEFAULT_VALUE)
MOD_ITEM_DEF(OB_ASYNC_EXTERNAL_SORTER)
MOD_ITEM_DEF(OB_CORE_LOCAL_STORAGE)
MOD_ITEM_DEF(OB_SMALL_OBJ_POOL)
MOD_ITEM_DEF(OB_EXT_MS_QUEUE)
MOD_ITEM_DEF(OB_EXT_MS_QUEUE_QITEM)
MOD_ITEM_DEF(OB_PARTITION_TABLE_TASK)
MOD_ITEM_DEF(OB_TEMP_VARIABLES)
MOD_ITEM_DEF(OB_EXTERNAL_SORTER)
MOD_ITEM_DEF(OB_OBJ_STORE)
MOD_ITEM_DEF(OB_COMPRESSOR)

//obproxy
MOD_ITEM_DEF(OB_PROXY_SESSION)
MOD_ITEM_DEF(OB_PROXY_DEFAULT_SYS_VARIABLE)
MOD_ITEM_DEF(OB_PROXY_SQL_PARSE)
MOD_ITEM_DEF(OB_PROXY_STAT)
MOD_ITEM_DEF(OB_PROXY_COMMON_DQ)
MOD_ITEM_DEF(OB_PROXY_UTILS)
MOD_ITEM_DEF(OB_PROXY_RESULTSET_FETCHER)
MOD_ITEM_DEF(OB_PROXY_FILE)
MOD_ITEM_DEF(OB_PROXY_TABLE_ENTRY_MAP)
MOD_ITEM_DEF(OB_PROXY_SQL_TABLE_ENTRY_MAP)
MOD_ITEM_DEF(OB_PROXY_PARTITION_ENTRY_MAP)
MOD_ITEM_DEF(OB_PROXY_ROUTINE_ENTRY_MAP)
MOD_ITEM_DEF(OB_PROXY_CONGESTION_ENTRY_MAP)
MOD_ITEM_DEF(OB_PROXY_PRINTF)
MOD_ITEM_DEF(OB_PROXY_WARN_LOG_BUF)
MOD_ITEM_DEF(OB_PROXY_LDC_ARRAY)
MOD_ITEM_DEF(OB_PROXY_PARAM_TYPE_ARRAY)
MOD_ITEM_DEF(OB_PROXY_PARAM_OBJ_ARRAY)
MOD_ITEM_DEF(OB_PROXY_SHARDING_OPTIMIZER)
MOD_ITEM_DEF(OB_PROXY_SHARDING_EXPR)
MOD_ITEM_DEF(OB_PROXY_SHARDING_PARSE)
MOD_ITEM_DEF(OB_PROXY_SHARDING_CONFIG)
MOD_ITEM_DEF(OB_PROXY_SHARDING_DDL)
MOD_ITEM_DEF(OB_PROXY_QOS)
MOD_ITEM_DEF(OB_PROXY_SSL_RELATED)
MOD_ITEM_DEF(OB_PROXY_CONFIG_TABLE)
MOD_ITEM_DEF(OB_PROMETHEUS_RELATED)
MOD_ITEM_DEF(OB_PROXY_SESS_SYNC)

//mergeservermodules
MOD_ITEM_DEF(OB_MS_CELL_ARRAY)
MOD_ITEM_DEF(OB_MS_LOCATION_CACHE)
MOD_ITEM_DEF(OB_MS_BTREE)
MOD_ITEM_DEF(OB_MS_RPC)
MOD_ITEM_DEF(OB_MS_JOIN_CACHE)
MOD_ITEM_DEF(OB_MS_REQUEST_EVENT)
MOD_ITEM_DEF(OB_MS_RPC_EVENT)
MOD_ITEM_DEF(OB_MS_GET_EVENT)
MOD_ITEM_DEF(OB_MS_SERVICE_FUNC)
MOD_ITEM_DEF(OB_MS_FROZEN_DATA_CACHE)
MOD_ITEM_DEF(OB_FROZEN_DATA_KEY_BUF)
MOD_ITEM_DEF(OB_MS_COMMON)
MOD_ITEM_DEF(OB_MS_SUB_SCAN_REQUEST)
MOD_ITEM_DEF(OB_MS_UPDATE_BLOOM_FILTER)
MOD_ITEM_DEF(OB_MS_SQL_SCAN_REQ_POOL)
MOD_ITEM_DEF(OB_MS_SQL_GET_REQ_POOL)
MOD_ITEM_DEF(OB_HASH_BUCKET_MS_COUNTER)
MOD_ITEM_DEF(OB_MS_TABLE_PREFIX_STAT)
MOD_ITEM_DEF(OB_SHARDING_RESULT)
MOD_ITEM_DEF(OB_MS_ROOT_TABLE_TEMP)
MOD_ITEM_DEF(OB_MS_FETCH_LOCATION)
//hashmap

//updateservermodules
MOD_ITEM_DEF(OB_UPS_ENGINE)
MOD_ITEM_DEF(OB_UPS_MEMTABLE)
MOD_ITEM_DEF(OB_UPS_LOG)
MOD_ITEM_DEF(OB_UPS_SCHEMA)
MOD_ITEM_DEF(OB_UPS_RESOURCE_POOL_NODE)
MOD_ITEM_DEF(OB_UPS_RESOURCE_POOL_ARRAY)
MOD_ITEM_DEF(OB_UPS_PARAM_DATA)
MOD_ITEM_DEF(OB_UPS_SESSION_CTX)
MOD_ITEM_DEF(OB_UPS_LOG_REPLAY_WORKER)
MOD_ITEM_DEF(OB_UPS_TRANS_EXECUTOR_TASK)
MOD_ITEM_DEF(OB_UPS_RESULT)
MOD_ITEM_DEF(OB_UPS_PHYPLAN_ALLOCATOR)
MOD_ITEM_DEF(OB_UPS_QUERY)
MOD_ITEM_DEF(OB_UPS_DATA_BLOCK)
MOD_ITEM_DEF(OB_UPS_SSTABLE_MGR)
MOD_ITEM_DEF(OB_UPS_COMMON)
MOD_ITEM_DEF(OB_HASH_BUCKET_HASH_ENGINE_MAP)
MOD_ITEM_DEF(OB_HASH_BUCKET_HASH_ENGINE_INDEX_MAP)
MOD_ITEM_DEF(OB_HASH_BUCKET_QUERY_ENGINE)
MOD_ITEM_DEF(OB_HASH_BUCKET_SCHEMA_NAME_MAP)
MOD_ITEM_DEF(OB_HASH_BUCKET_SCHEMA_ID_MAP)
MOD_ITEM_DEF(OB_HASH_BUCKET_SSTABLE_INFO_MAP)
MOD_ITEM_DEF(OB_HASH_BUCKET_STORE_DEV_MAP)
MOD_ITEM_DEF(OB_CAST_TSI_BUFF)
MOD_ITEM_DEF(OB_HASH_ALIAS_TABLE_MAP)

//oceanbase server modules
MOD_ITEM_DEF(OCEANBASE_SERVER)
MOD_ITEM_DEF(OMT)
MOD_ITEM_DEF(OB_HASH_BUCKET_PT_CHECKER_MAP)
MOD_ITEM_DEF(OB_HASH_BUCKET_TABLE_STATISTICS)
MOD_ITEM_DEF(OB_WORKER_EXECUTION)

//chunkservermodules
MOD_ITEM_DEF(OB_CS_SSTABLE_READER)
MOD_ITEM_DEF(OB_CS_TABLET_IMAGE)
MOD_ITEM_DEF(OB_CS_DELETE_TABLET)
MOD_ITEM_DEF(OB_CS_COMMIT_LOG)
MOD_ITEM_DEF(OB_CS_IMPORT_SSTABLE)
MOD_ITEM_DEF(OB_CS_SERVICE_FUNC)
MOD_ITEM_DEF(OB_CS_BUILD_INDEX)
MOD_ITEM_DEF(OB_CS_MERGER)
MOD_ITEM_DEF(OB_CS_COMMON)
MOD_ITEM_DEF(OB_CS_FILE_RECYCLE)
MOD_ITEM_DEF(OB_CS_BLOOM_FILTER)
MOD_ITEM_DEF(OB_CS_ROOT_TABLE_TEMP)
MOD_ITEM_DEF(OB_CS_MACRO_BLOCK_STATISTICS_BUCKET)
MOD_ITEM_DEF(OB_CS_MACRO_BLOCK_STATISTICS_ITEM)
MOD_ITEM_DEF(OB_CS_DISK_BALANCE)
MOD_ITEM_DEF(OB_CS_ROW_READER)

//sstablemodules
MOD_ITEM_DEF(OB_SSTABLE_AIO)
MOD_ITEM_DEF(OB_SSTABLE_AIO_BUFFER_ARRAY)
MOD_ITEM_DEF(OB_SSTABLE_GET_SCAN)
MOD_ITEM_DEF(OB_SSTABLE_WRITER)
MOD_ITEM_DEF(OB_SSTABLE_READER)
MOD_ITEM_DEF(OB_SSTABLE_GET_PARAM)
MOD_ITEM_DEF(OB_SSTABLE_INDEX)
MOD_ITEM_DEF(OB_SSTABLE_SCHEMA)
MOD_ITEM_DEF(OB_SSTABLE_BLOCK_FILE)
MOD_ITEM_DEF(OB_SSTABLE_BLOCK_INDEX)
MOD_ITEM_DEF(OB_MACRO_BLOCK_META)
MOD_ITEM_DEF(OB_HASH_BUCKET_COLUMN_SCHEMA_MAP)

//obmysqlmodules
MOD_ITEM_DEF(OB_MYSQL_PACKET)
MOD_ITEM_DEF(OB_DELETE_SESSION_TASK)

//rootservermodules
MOD_ITEM_DEF(OB_RS_ROOT_TABLE)
MOD_ITEM_DEF(OB_RS_ROOT_TABLE_TEMP)
MOD_ITEM_DEF(OB_RS_SYS_LOCATION_CACHE)
MOD_ITEM_DEF(OB_LOCATION_CACHE_QUEUE)
MOD_ITEM_DEF(OB_RS_ROOT_TABLE_CACHE)
MOD_ITEM_DEF(OB_RS_META_TABLE_CACHE)
MOD_ITEM_DEF(OB_RS_TABLET_ITER)
MOD_ITEM_DEF(OB_RS_TABLET_MANAGER)
MOD_ITEM_DEF(OB_RS_SERVER_MANAGER)
MOD_ITEM_DEF(OB_RS_SCHEMA_MANAGER)
MOD_ITEM_DEF(OB_SCHEMA_DEDUP_QUEUE)
MOD_ITEM_DEF(OB_RS_LOG_WORKER)
MOD_ITEM_DEF(OB_RS_CHECK_ALL_SERVER)
MOD_ITEM_DEF(OB_RS_TIMER_TASK_MANAGER)
MOD_ITEM_DEF(OB_HASH_BUCKET_BALANCER)
MOD_ITEM_DEF(OB_HASH_BUCKET_USER_RT_PROXY_MOCK)
MOD_ITEM_DEF(OB_HASH_BUCKET_FIRST_RT_PROXY_MOCK)
MOD_ITEM_DEF(OB_HASH_BUCKET_ALL_ROOT_TABLETS)
MOD_ITEM_DEF(OB_RS_TABLET_LIST)
MOD_ITEM_DEF(OB_RS_TABLET_INFO)
MOD_ITEM_DEF(OB_REBALANCE_TASK_MGR)
MOD_ITEM_DEF(OB_ROOT_TABLE_BUF)
MOD_ITEM_DEF(OB_RS_PARTITION_TABLE_TEMP)
MOD_ITEM_DEF(OB_ZONE_TABLE_UPDATER)
MOD_ITEM_DEF(OB_HASH_BUCKET_SERVER_CNT_MAP)
MOD_ITEM_DEF(OB_HASH_BUCKET_SCHEMA_ZONE_MAP)
MOD_ITEM_DEF(OB_HASH_BUCKET_POOL_UNIT_MAP)
MOD_ITEM_DEF(OB_HASH_BUCKET_CONFIG_POOLS_MAP)
MOD_ITEM_DEF(OB_HASH_BUCKET_SERVER_REF_COUNT_MAP)
MOD_ITEM_DEF(OB_HASH_BUCKET_ID_UNIT_MAP)
MOD_ITEM_DEF(OB_HASH_BUCKET_ID_CONFIG_MAP)
MOD_ITEM_DEF(OB_HASH_BUCKET_NAME_CONFIG_MAP)
MOD_ITEM_DEF(OB_HASH_BUCKET_CONFIG_REF_COUNT_MAP)
MOD_ITEM_DEF(OB_HASH_BUCKET_ID_POOL_MAP)
MOD_ITEM_DEF(OB_HASH_BUCKET_NAME_POOL_MAP)
MOD_ITEM_DEF(OB_HASH_BUCKET_SERVER_UNITLOAD_MAP)
MOD_ITEM_DEF(OB_HASH_BUCKET_TENANT_POOLS_MAP)
MOD_ITEM_DEF(OB_HASH_BUCKET_SERVER_MIGRATE_UNIT_MAP)
MOD_ITEM_DEF(OB_RS_UNIT_MANAGER)
MOD_ITEM_DEF(OB_HASH_BUCKET_RENAME_TABLE_MAP)
MOD_ITEM_DEF(OB_RS_DEFAULT_VALUE_CASTER)
MOD_ITEM_DEF(OB_RS_ASYNC_RPC_PROXY)
MOD_ITEM_DEF(OB_RS_EVENT_QUEUE)
MOD_ITEM_DEF(OB_RS_EVENT_TASK)
MOD_ITEM_DEF(OB_RS_LEADER_COORDINATOR)

//sqlmodules
//compile include parse, resolve, optimize, code generate
MOD_ITEM_DEF(OB_SQL_COMPILE)
MOD_ITEM_DEF(OB_SQL_PARSER)
MOD_ITEM_DEF(OB_SQL_SESSION_POOL)
MOD_ITEM_DEF(OB_SQL_SESSION)
MOD_ITEM_DEF(OB_SQL_ROW_STORE)
MOD_ITEM_DEF(OB_SQL_RES_TYPE)
//MOD_ITEM_DEF(OB_SQL_OPTIMIZER)
MOD_ITEM_DEF(OB_SQL_EXECUTOR)
MOD_ITEM_DEF(OB_SQL_EXECUTOR_INTERM_RESULT_SCANNER)
MOD_ITEM_DEF(OB_SQL_EXECUTOR_INTERM_RESULT_MAP)
MOD_ITEM_DEF(OB_SQL_EXECUTOR_SCHEDULER)
MOD_ITEM_DEF(OB_SQL_EXECUTOR_TASK_EVENT)
MOD_ITEM_DEF(OB_SQL_SCAN_PARAM)
MOD_ITEM_DEF(OB_SQL_GET_PARAM)
MOD_ITEM_DEF(OB_SQL_DEFAULT_VALUE_CONTEXT)
MOD_ITEM_DEF(OB_SQL_REQUEST)
MOD_ITEM_DEF(OB_SQL_TRANSFORMER_PS)
MOD_ITEM_DEF(OB_SQL_PS_TRANS)
MOD_ITEM_DEF(OB_SQL_ARRAY)
MOD_ITEM_DEF(OB_SQL_EXPR)
MOD_ITEM_DEF(OB_SQL_EXPR_ITEM)
MOD_ITEM_DEF(OB_SQL_EXPR_BUF)
MOD_ITEM_DEF(OB_SQL_EXPR_CALC)
MOD_ITEM_DEF(OB_SQL_EXPR_OP)
MOD_ITEM_DEF(OB_SQL_EXPR_REPLACE)
MOD_ITEM_DEF(OB_SQL_AGGR_FUNC)
MOD_ITEM_DEF(OB_SQL_AGGR_FUNC_ROW)
MOD_ITEM_DEF(OB_SQL_AGGR_FUNC_ARR)
MOD_ITEM_DEF(OB_SQL_AGGR_FUN_GROUP_CONCAT)
MOD_ITEM_DEF(OB_SQL_INSERT)
MOD_ITEM_DEF(OB_SQL_MERGE_JOIN)
MOD_ITEM_DEF(OB_SQL_RESULT_SET)
MOD_ITEM_DEF(OB_SQL_TABLET_CACHE_JOIN)
MOD_ITEM_DEF(OB_SQL_UPDATE)
MOD_ITEM_DEF(OB_SQL_READ_STRATEGY)
MOD_ITEM_DEF(OB_SQL_PRIVILEGE)
MOD_ITEM_DEF(OB_SQL_RPC_SCAN2)
MOD_ITEM_DEF(OB_SQL_READ_STATEGY)
MOD_ITEM_DEF(OB_SQL_TABLE_SCAN_CTX)
MOD_ITEM_DEF(OB_SQL_SCALAR_AGGR)
MOD_ITEM_DEF(OB_SQL_MERGE_GROUPBY)
MOD_ITEM_DEF(OB_SQL_MERGE_UNION)
MOD_ITEM_DEF(OB_SQL_PHY_PLAN)
MOD_ITEM_DEF(OB_SQL_PHY_PLAN_REMOTE)
MOD_ITEM_DEF(OB_SQL_PHY_PLAN_JOIN_PARAM)
MOD_ITEM_DEF(OB_SQL_RESULT_SET_DYN)
MOD_ITEM_DEF(OB_SQL_SESSION_HASHMAP)
MOD_ITEM_DEF(OB_SQL_SESSION_SBLOCK)
MOD_ITEM_DEF(OB_SQL_SESSION_VAR_MAP)
MOD_ITEM_DEF(OB_SQL_QUERY_CACHE)
MOD_ITEM_DEF(OB_SQL_QUERY_RANGE)
MOD_ITEM_DEF(OB_SQL_RPC_REQUEST)
MOD_ITEM_DEF(OB_SQL_PS_STORE_PHYSICALPLAN)
MOD_ITEM_DEF(OB_SQL_PS_STORE_OPERATORS)
MOD_ITEM_DEF(OB_SQL_PS_STORE_ITEM)
MOD_ITEM_DEF(OB_SQL_PHY_PLAN_STRING)
MOD_ITEM_DEF(OB_SQL_KEY_PART)
MOD_ITEM_DEF(OB_SQL_NLJ_CACHE)
MOD_ITEM_DEF(OB_QUERY_RANGE)
MOD_ITEM_DEF(OB_QUERY_RANGE_CTX)
MOD_ITEM_DEF(OB_PS_INFO)
MOD_ITEM_DEF(OB_VARIABLE_SET)
MOD_ITEM_DEF(OB_SQL_EXEC_CONTEXT)
MOD_ITEM_DEF(OB_SQL_CG)
MOD_ITEM_DEF(OB_SQL_PREPARED_SQL)
MOD_ITEM_DEF(OB_SQL_TABLE_LOCATION)
MOD_ITEM_DEF(OB_SQL_SORT_ROW)
MOD_ITEM_DEF(OB_SQL_PLAN_MONITOR)

MOD_ITEM_DEF(OB_HASH_BUCKET_SYS_CONF)
MOD_ITEM_DEF(OB_HASH_BUCKET_SYS_CONF_MAP)
MOD_ITEM_DEF(OB_HASH_BUCKET_ALTER_TABLE_MAP)
MOD_ITEM_DEF(OB_HASH_BUCKET_GROUP_ROWS)
MOD_ITEM_DEF(OB_HASH_BUCKET_PLAN_CACHE)
MOD_ITEM_DEF(OB_HASH_BUCKET_SQL_PARAMETERIZATION)
MOD_ITEM_DEF(OB_HASH_BUCKET_PLAN_STAT)
MOD_ITEM_DEF(OB_HASH_BUCKET_NLJ_CACHE)
MOD_ITEM_DEF(OB_HASH_NODE_SYS_CONF)
MOD_ITEM_DEF(OB_HASH_NODE_SYS_CONF_MAP)
MOD_ITEM_DEF(OB_HASH_NODE_ALTER_TABLE_MAP)
MOD_ITEM_DEF(OB_HASH_NODE_GROUP_ROWS)
MOD_ITEM_DEF(OB_HASH_NODE_PLAN_CACHE)
MOD_ITEM_DEF(OB_HASH_NODE_PLAN_STAT)
MOD_ITEM_DEF(OB_HASH_NODE_SQL_PARAMETERIZATION)
MOD_ITEM_DEF(OB_HASH_NODE_NLJ_CACHE)
MOD_ITEM_DEF(OB_SQL_PARAMETERIZATION)
MOD_ITEM_DEF(OB_SQL_PLAN_CACHE)
MOD_ITEM_DEF(OB_SQL_PLAN_CACHE_VALUE)
MOD_ITEM_DEF(OB_SQL_PLAN_SET)
//mpimodules
MOD_ITEM_DEF(OB_MPI_INTERM_RESULT)
MOD_ITEM_DEF(OB_MPI)
MOD_ITEM_DEF(OB_HASH_BUCKET_MPI_SUBPLAN_MAP)
MOD_ITEM_DEF(OB_HASH_BUCKET_IR_MAP)
MOD_ITEM_DEF(OB_HASH_BUCKET_MPI_TASK_MAP)
MOD_ITEM_DEF(OB_HASH_BUCKET_MPI_JOB_MAP)

//liboblog
MOD_ITEM_DEF(OB_LOG_BINLOG_RECORD)
MOD_ITEM_DEF(OB_LOG_BINLOG_RECORD_POOL)
MOD_ITEM_DEF(OB_LOG_FETCHER)
MOD_ITEM_DEF(OB_LOG_PART_INFO)
MOD_ITEM_DEF(OB_LOG_PART_COMMIT_INFO)
MOD_ITEM_DEF(OB_LOG_PART_TRANS_TASK_SMALL)
MOD_ITEM_DEF(OB_LOG_PART_TRANS_TASK_LARGE)
MOD_ITEM_DEF(OB_LOG_DATABASE_META_MAP)
MOD_ITEM_DEF(OB_LOG_TABLE_META_MAP)
MOD_ITEM_DEF(OB_LOG_META_INFO)
MOD_ITEM_DEF(OB_LOG_FORMATTER)
MOD_ITEM_DEF(OB_LOG_SERVER_PROVIDER)
MOD_ITEM_DEF(OB_LOG_DEP_MAP)
MOD_ITEM_DEF(OB_LOG_TRANS_CTX)
MOD_ITEM_DEF(OB_LOG_TENANT_DB_NAME)
MOD_ITEM_DEF(OB_LOG_ASYNC_HEARTBEAT_REQ)
MOD_ITEM_DEF(OB_LOG_TEMP_MEMORY)
MOD_ITEM_DEF(OB_LOG_SERVER_FINDER)
MOD_ITEM_DEF(OB_LOG_SERVER_ASSIGNER)
MOD_ITEM_DEF(OB_LOG_OBJ_RETAINER_REF_CNTER_POOL)
MOD_ITEM_DEF(OB_LOG_PARTITION_STREAM_MAP)
MOD_ITEM_DEF(OB_LOG_PARTITION_STREAM_TASK_MAP)
MOD_ITEM_DEF(OB_LOG_START_LOG_ID_REQ_MAP)
MOD_ITEM_DEF(OB_LOG_START_LOG_ID_LOCATOR_REQ_MAP)
MOD_ITEM_DEF(OB_LOG_PARTITION_STREAM_PARAM_MAP)
MOD_ITEM_DEF(OB_LOG_PARTITION_RECORDS_MAP)
MOD_ITEM_DEF(OB_LOG_MT_QUEUE_MAP)

// storagetest
MOD_ITEM_DEF(OB_ST_WORKER)
MOD_ITEM_DEF(OB_ST_GEN_OPERATOR)
MOD_ITEM_DEF(OB_ST_TEMP)
MOD_ITEM_DEF(OB_ST_NOP_POS)
MOD_ITEM_DEF(OB_ST_FREEZE_LOG_TASK)

// proxy
MOD_ITEM_DEF(OB_HASH_BUCKET_PROXY_MAP)
MOD_ITEM_DEF(OB_HASH_BUCKET_YUNTI_META_MAP)
MOD_ITEM_DEF(OB_LARGE_IO_BUFFER)
MOD_ITEM_DEF(OB_ASYNC_LOG_BUFFER)

// election
MOD_ITEM_DEF(OB_ELECTION)
MOD_ITEM_DEF(OB_ELECTION_MGR)
MOD_ITEM_DEF(OB_ELECTION_TIMER)
MOD_ITEM_DEF(OB_ELECTION_TIMER_TASK)
MOD_ITEM_DEF(OB_ELECTION_HASH_BUCKET)
MOD_ITEM_DEF(OB_ELECTION_ASYNC_LOG)
MOD_ITEM_DEF(OB_ELECTION_VIRTAUL_TABLE_ELECTION_INFO)
MOD_ITEM_DEF(OB_ELECTION_VIRTAUL_TABLE_MEM_STAT)
MOD_ITEM_DEF(OB_ELECTION_EVENT_QUEUE)

// memtable
MOD_ITEM_DEF(OB_CHECKSUM_CHECKER)
MOD_ITEM_DEF(OB_MEMTABLE_BTREE_MAP)
MOD_ITEM_DEF(OB_MEMTABLE_HASH_MAP)
MOD_ITEM_DEF(OB_MEMTABLE_COMPACT_WRITER_BUFFER)
MOD_ITEM_DEF(OB_MEMTABLE_OBJECT)
MOD_ITEM_DEF(OB_MEMTABLE_QUERY)
MOD_ITEM_DEF(OB_MEMTABLE_CTX_OBJECT)
MOD_ITEM_DEF(OB_MEMTABLE_CTX_DYNAMIC)

// storage
MOD_ITEM_DEF(OB_PARTITION_MGR)
MOD_ITEM_DEF(OB_PARTITION)
MOD_ITEM_DEF(OB_PARTITION_STORAGE)
MOD_ITEM_DEF(OB_PARTITION_SERVICE)
MOD_ITEM_DEF(OB_PARTITION_TEST)
MOD_ITEM_DEF(OB_SSSTORE)
MOD_ITEM_DEF(OB_BASESTORAGE)
MOD_ITEM_DEF(OB_MEM_SCAN_ITER)
MOD_ITEM_DEF(OB_MEMSTORE)
MOD_ITEM_DEF(OB_TRANS_SERVICE)
MOD_ITEM_DEF(OB_CLOG_MGR)
MOD_ITEM_DEF(OB_TABLE_SCAN_ITER)
MOD_ITEM_DEF(OB_INDEX_MERGE)
MOD_ITEM_DEF(OB_PARTITION_MIGRATOR)
MOD_ITEM_DEF(OB_ROW_PURGER)
MOD_ITEM_DEF(OB_FREEZE)
MOD_ITEM_DEF(OB_COLUMN_DEFAULT_VALUE)
MOD_ITEM_DEF(OB_CALLBACK_TASK)
MOD_ITEM_DEF(OB_CHECK2REMOVE)
MOD_ITEM_DEF(OB_VALUE_ROW_ITER)
MOD_ITEM_DEF(OB_COL_MAP)
MOD_ITEM_DEF(OB_WORK_ROW)
MOD_ITEM_DEF(OB_PARTITION_ROW_MERGE)
MOD_ITEM_DEF(OB_PARTITION_SCAN_MERGE)
MOD_ITEM_DEF(OB_PARTITION_GET_MERGE)
MOD_ITEM_DEF(OB_PARTITION_SCHEDULER)
MOD_ITEM_DEF(OB_PADDING_COLUMN)

//replay engine
MOD_ITEM_DEF(OB_LOG_REPLAY_ENGINE)

//clog
MOD_ITEM_DEF(OB_LOG_DIRECT_READER_ID)
MOD_ITEM_DEF(OB_INDEX_ITERATOR_ID)
MOD_ITEM_DEF(OB_LOG_ITERATOR_ID)
MOD_ITEM_DEF(OB_LOG_WRITER_ID)
MOD_ITEM_DEF(OB_CLOG_MGR_ID)
MOD_ITEM_DEF(OB_CLOG_SW)
MOD_ITEM_DEF(OB_CLOG_RE)
MOD_ITEM_DEF(OB_CLOG_GE)
MOD_ITEM_DEF(OB_CLOG_SR_MAP)
MOD_ITEM_DEF(OB_CLOG_EXTERNAL_RPC)
MOD_ITEM_DEF(OB_CLOG_FETCH_LE)
MOD_ITEM_DEF(OB_CLOG_INFO_BLK_HNDLR)
MOD_ITEM_DEF(OB_LOG_INDEX_MOD)
MOD_ITEM_DEF(OB_LOG_TASK)
MOD_ITEM_DEF(OB_LOG_BLACK_LIST)

// cursor cache
MOD_ITEM_DEF(OB_CSR_FILE_ID_CACHE_FILE_LIST)
MOD_ITEM_DEF(OB_CSR_FILE_ID_CACHE_FILE_ITEM)
MOD_ITEM_DEF(OB_CSR_FILE_ID_CACHE_PKEY_MAP)
MOD_ITEM_DEF(OB_CSR_PER_FILE_NODE_WRAPPER)
MOD_ITEM_DEF(OB_CSR_PER_FILE_NODE_MAP)
MOD_ITEM_DEF(OB_CSR_PER_FILE_BUF_AND_MAP)

// clog external rpc for liboblog
MOD_ITEM_DEF(OB_CLOG_EXT_RPC)
MOD_ITEM_DEF(OB_EXT_STREAM_MAP)
MOD_ITEM_DEF(OB_EXT_STREAM_ALLOCATOR)

//clog test nio
MOD_ITEM_DEF(NIO_MOD_ID)
MOD_ITEM_DEF(NIO_MOD_ID2)

//clog log_tool
MOD_ITEM_DEF(OB_LOG_TOOL)

MOD_ITEM_DEF(OB_RPC)
MOD_ITEM_DEF(OB_RPC_STAT)
MOD_ITEM_DEF(OB_RPC_PROCESSOR)
MOD_ITEM_DEF(OB_RPC_BUFFER)
MOD_ITEM_DEF(OB_RPC_PTABLE)
MOD_ITEM_DEF(OB_MYSQL_PROCESSOR)
MOD_ITEM_DEF(OB_MYSQL_BUFFER)
MOD_ITEM_DEF(OB_MYSQL_PTABLE)


// transaction
MOD_ITEM_DEF(OB_END_TRANS_CALLBACK)
MOD_ITEM_DEF(OB_HASH_BUCKET_TRANS_CTX)
MOD_ITEM_DEF(OB_HASH_BUCKET_PARTITION_TRANS_CTX)
MOD_ITEM_DEF(OB_HASH_BUCKET_TRANS_VERSION)
MOD_ITEM_DEF(OB_TRANS_CHECK)
MOD_ITEM_DEF(OB_TRANS_PUBLISH_VERSION_TOKEN)
MOD_ITEM_DEF(OB_HASH_BUCKET_TRANS_STATUS)
MOD_ITEM_DEF(OB_TRANS_VIRTUAL_TABLE_PARTITION)
MOD_ITEM_DEF(OB_TRANS_VIRTUAL_TABLE_TRANS_STAT)
MOD_ITEM_DEF(OB_TRANS_VIRTUAL_TABLE_PARTITION_STAT)
MOD_ITEM_DEF(OB_TRANS_VIRTUAL_TABLE_MEMORY_STAT)
MOD_ITEM_DEF(OB_TRANS_REDO_LOG_ID_ARRAY)
MOD_ITEM_DEF(OB_TRANS_PARTITION_LOG_INFO_ARRAY)
MOD_ITEM_DEF(OB_TRANS_PARTITION_ARRAY)
MOD_ITEM_DEF(OB_TRANS_CLOG_BUF)
MOD_ITEM_DEF(OB_TRANS_MUTATOR_BUF)
MOD_ITEM_DEF(OB_PARTITION_TRANS_CTX_MGR)
MOD_ITEM_DEF(OB_TRANS_SUBMIT_LOG_TASK)
MOD_ITEM_DEF(OB_TRANS_LOCATION_CACHE)
MOD_ITEM_DEF(OB_TRANS_FREEZE_TASK)

// rootservice
MOD_ITEM_DEF(OB_HASH_BUCKET_LEADER_STATUS_MAP)
MOD_ITEM_DEF(OB_HASH_BUCKET_PARTITION_DIST_MAP)
MOD_ITEM_DEF(OB_MAJOR_FREEZE_PARTITION_LIST)
MOD_ITEM_DEF(OB_HASH_BUCKET_FREEZE_STATUS_DIST_MAP)
MOD_ITEM_DEF(OB_CREATE_PARTITION_FAILED_LIST)
MOD_ITEM_DEF(OB_SERVER_ARPCARGS_MAP)

// storage_test
MOD_ITEM_DEF(OB_TABLE_DATA_HOLDER)
MOD_ITEM_DEF(OB_DATA_HOLDER)
MOD_ITEM_DEF(OB_DATA_HOLDER_DATA)
MOD_ITEM_DEF(OB_DATA_HOLDER_INCREMENT_DATA)
MOD_ITEM_DEF(OB_DATA_MANAGER)
MOD_ITEM_DEF(OB_DATA_TRANSLATOR)
MOD_ITEM_DEF(OB_BASE_TASK_THREAD_MGR)
MOD_ITEM_DEF(OB_INDEX_CHECK)
MOD_ITEM_DEF(OB_MEM_STAT_SET)
MOD_ITEM_DEF(OB_RING_BUFFER)
MOD_ITEM_DEF(OB_CONCURRENT_HASH_MAP)

MOD_ITEM_DEF(OB_TRACE_LOG)
MOD_ITEM_DEF(OB_MOD_END)
#endif

#ifndef __OB_COMMON_OB_MOD_DEFINE2_H__
#define __OB_COMMON_OB_MOD_DEFINE2_H__
#include "lib/ob_define.h"
#include "lib/thread_local/ob_tsi_utils.h"
#include "lib/string/ob_string.h"
namespace oceanbase
{
namespace common
{

struct ObModIds
{
  enum ObModIdEnum
  {
#define MOD_ITEM_DEF(name) name,
#include "lib/allocator/ob_mod_define.h"
#undef MOD_ITEM_DEF
  };
};

struct ObModItem
{
  ObModItem(): hold_(0), used_(0), count_(0), alloc_count_(0), free_count_(0) {}

  inline void update(int64_t hold, int64_t used)
  {
    if (hold > 0) {
      count_ += 1;
      alloc_count_++;
    } else if (hold < 0) {
      count_ -= 1;
      free_count_++;
    }
    used_ += used;
    hold_ += hold;
  }
  int64_t format_string(char *buf, int64_t len, const char *name) const;

  ObModItem &operator +=(const ObModItem &item)
  {
    hold_ += item.hold_;
    used_ += item.used_;
    count_ += item.count_;
    alloc_count_ += item.alloc_count_;
    free_count_ += item.free_count_;
    return *this;
  }

  void reset()
  {
    hold_ = 0;
    used_ = 0;
    count_ = 0;
    alloc_count_ = 0;
    free_count_ = 0;
  }

  int64_t hold_;
  int64_t used_;
  int64_t count_;
  int64_t alloc_count_;
  int64_t free_count_;
};

inline bool is_valid_mod_id(int64_t mod_id)
{
  return mod_id >= 0 && mod_id < ObModIds::OB_MOD_END;
}

inline bool is_allocator_mod(int64_t mod_id)
{
  return mod_id > ObModIds::OB_MOD_ALLOCATOR_START && mod_id < ObModIds::OB_MOD_ALLOCATOR_END;
}

class ObLocalModSet
{
  enum { MOD_COUNT_LIMIT = ObModIds::OB_MOD_END };
public:
  ObLocalModSet()
      : mods_()
  {}
  void reset()
  {
    MEMSET(&mods_, 0, sizeof (mods_));
  }
  int64_t get_mod_hold(int64_t mod_id) const
  {
    return mods_[(mod_id >= 0 && mod_id < MOD_COUNT_LIMIT) ? mod_id : 0].hold_;
  }
  int64_t get_mod_used(int64_t mod_id) const
  {
    return mods_[(mod_id >= 0 && mod_id < MOD_COUNT_LIMIT) ? mod_id : 0].used_;
  }
  int64_t get_mod_count(int64_t mod_id) const
  {
    return mods_[(mod_id >= 0 && mod_id < MOD_COUNT_LIMIT) ? mod_id : 0].count_;
  }
  int64_t get_mod_alloc_count(int64_t mod_id) const
  {
    return mods_[(mod_id >= 0 && mod_id < MOD_COUNT_LIMIT) ? mod_id : 0].alloc_count_;
  }
  int64_t get_mod_free_count(int64_t mod_id) const
  {
    return mods_[(mod_id >= 0 && mod_id < MOD_COUNT_LIMIT) ? mod_id : 0].free_count_;
  }
  inline ObModItem get_mod(int64_t mod_id) const
  {
    return mods_[(mod_id >= 0 && mod_id < MOD_COUNT_LIMIT) ? mod_id : 0];
  }
  inline void mod_update(int64_t mod_id, int64_t hold, int64_t used)
  {
    mods_[(mod_id >= 0 && mod_id < MOD_COUNT_LIMIT) ? mod_id : 0].update(hold, used);
  }
private:
  ObModItem mods_[MOD_COUNT_LIMIT];
};

class ObModSet
{
public:
  enum { MOD_COUNT_LIMIT = ObModIds::OB_MOD_END };
  ObModSet()
  : limit_(INT64_MAX),
    reserved_urgent_memory_(0),
    reserve_(0),
    sys_allocated_(0),
    user_allocated_(0),
    mod_names_(),
    local_mod_set_(),
    mod_sets_()
  {
    // In case of allocating a new local mod set wounld case
    // 'BlockMgr' dead lock, we create a local mod set in advance.
    mod_sets_[0] = &local_mod_set_;
#define MOD_ITEM_DEF(id) set_mod_name(ObModIds::id, #id);
#include "lib/allocator/ob_mod_define.h"
#undef MOD_ITEM_DEF
  }
  virtual ~ObModSet() {}
  void set_limit(int64_t limit) { limit_ = limit; }
  void set_reserved_urgent_memory(int64_t reserved_urgent_memory) { reserved_urgent_memory_ = reserved_urgent_memory; }
  void set_reserve(const int64_t reserve) { reserve_ = reserve;}
  inline void sub_sys_allocated(int64_t delta)
  {
    __sync_add_and_fetch(&sys_allocated_, -delta);
  }
  int64_t get_available()const { return limit_ - sys_allocated_ - reserved_urgent_memory_ > 0 ? limit_ - sys_allocated_ - reserved_urgent_memory_ : 0; }
  int64_t get_limit() const { return limit_; }
  int64_t get_reserved_urgent_memory() const { return reserved_urgent_memory_; }
  int64_t get_reserve() const { return reserve_; }
  int64_t get_hold() const { return sys_allocated_; }
  int64_t get_used() const { return user_allocated_; }
  int get_mod_id(const common::ObString &mod_name) const;
  void set_mod_name(int64_t mod_id, const char *name)
  {
    if (mod_id >= 0 && mod_id < MOD_COUNT_LIMIT) {
      mod_names_[mod_id] = name;
    }
  }
  const char *get_mod_name(int64_t mod_id) const
  {
    const char * t = "NONE";
    if (mod_id >= 0 && mod_id < MOD_COUNT_LIMIT)
    {
      t = mod_names_[mod_id];
    }
    return t;
  }

  int64_t get_mod_hold(int64_t mod_id) const
  {
    int64_t hold = 0;
    for (int64_t i = 0; i < std::min(get_max_itid(), OB_MAX_THREAD_NUM); i++) {
      if (NULL != mod_sets_[i]) {
        hold += mod_sets_[i]->get_mod_hold(mod_id);
      }
    }
    return hold;
  }
  int64_t get_mod_used(int64_t mod_id) const
  {
    int64_t used = 0;
    for (int64_t i = 0; i < std::min(get_max_itid(), OB_MAX_THREAD_NUM); i++) {
      if (NULL != mod_sets_[i]) {
        used += mod_sets_[i]->get_mod_used(mod_id);
      }
    }
    return used;
  }
  int64_t get_mod_count(int64_t mod_id) const
  {
    int64_t count = 0;
    for (int64_t i = 0; i < std::min(get_max_itid(), OB_MAX_THREAD_NUM); i++) {
      if (NULL != mod_sets_[i]) {
        count += mod_sets_[i]->get_mod_count(mod_id);
      }
    }
    return count;
  }
  inline void mod_update(int64_t mod_id, int64_t hold, int64_t used)
  {
    ObLocalModSet *p = get_local();
    if (NULL != p) {
      p->mod_update(mod_id, hold, used);
    }
  }

  void print_mod_memory_usage(bool print_glibc = false) const;
  int print_mod_memory_usage(char *buf, int64_t len, int64_t &pos) const;
private:
  ObLocalModSet *get_local();

  ObModItem get_mod(int64_t mod_id) const
  {
    ObModItem item;
    for (int64_t i = 0; i < std::min(get_max_itid(), OB_MAX_THREAD_NUM); i++) {
      if (NULL != mod_sets_[i]) {
        item += mod_sets_[i]->get_mod(mod_id);
      }
    }
    return item;
  }

private:
  int64_t limit_;
  int64_t reserved_urgent_memory_;
  int64_t reserve_;
  int64_t sys_allocated_ CACHE_ALIGNED;
  int64_t user_allocated_ CACHE_ALIGNED;
  const char* mod_names_[MOD_COUNT_LIMIT];
  ObLocalModSet local_mod_set_;
  ObLocalModSet *mod_sets_[OB_MAX_THREAD_NUM];
};

}; // end namespace common
namespace debug
{
#define PC_LOG(...) _OB_LOG(INFO, __VA_ARGS__)
#include "ob_pcounter.h"
#define PC_ADD(mod, x) debug::get_pcounter_set().add(debug::PCOUNTER_ ## mod, x)
#define PC_REPORT() debug::get_pcounter_monitor().report()
#define PC_GET(mod) debug::get_pcounter_set().get(debug::PCOUNTER_ ## mod)
};
}; // end namespace oceanbase

#endif /* __OB_COMMON_OB_MOD_DEFINE2_H__ */
