/**
 * Copyright (c) 2021 OceanBase
 * OceanBase Database Proxy(ODP) is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *          http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */

#define USING_LOG_PREFIX  LIB_TIME

#include "lib/timezone/ob_timezone_info.h"
#include "lib/timezone/ob_time_convert.h"
#include "lib/oblog/ob_log.h"
#include "lib/ob_proxy_worker.h"

namespace oceanbase
{
namespace common
{

ObTimeZoneName ObTimeZoneInfo::TIME_ZONE_NAMES[] =
{
  {"", 0, 0, 0},    // // used to occupy this place.
  {"Africa/Abidjan", 1, 2, 1},
  {"Africa/Accra", 3, 18, 2},
  {"Africa/Addis_Ababa", 19, 20, 3},
  {"Africa/Algiers", 21, 54, 4},
  {"Africa/Asmara", 55, 56, 5},
  {"Africa/Asmera", 57, 58, 6},
  {"Africa/Bamako", 59, 62, 7},
  {"Africa/Bangui", 63, 64, 8},
  {"Africa/Banjul", 65, 68, 9},
  {"Africa/Bissau", 69, 71, 10},
  {"Africa/Blantyre", 72, 73, 11},
  {"Africa/Brazzaville", 74, 75, 12},
  {"Africa/Bujumbura", 76, 76, 13},
  {"Africa/Cairo", 77, 198, 14},
  {"Africa/Casablanca", 199, 226, 15},
  {"Africa/Ceuta", 227, 352, 16},
  {"Africa/Conakry", 353, 356, 17},
  {"Africa/Dakar", 357, 359, 18},
  {"Africa/Dar_es_Salaam", 360, 363, 19},
  {"Africa/Djibouti", 364, 365, 20},
  {"Africa/Douala", 366, 367, 21},
  {"Africa/El_Aaiun", 368, 370, 22},
  {"Africa/Freetown", 371, 401, 23},
  {"Africa/Gaborone", 402, 403, 24},
  {"Africa/Harare", 404, 405, 25},
  {"Africa/Johannesburg", 406, 411, 26},
  {"Africa/Juba", 412, 446, 27},
  {"Africa/Kampala", 447, 451, 28},
  {"Africa/Khartoum", 452, 486, 29},
  {"Africa/Kigali", 487, 488, 30},
  {"Africa/Kinshasa", 489, 489, 31},
  {"Africa/Lagos", 490, 491, 32},
  {"Africa/Libreville", 492, 493, 33},
  {"Africa/Lome", 494, 494, 34},
  {"Africa/Luanda", 495, 496, 35},
  {"Africa/Lubumbashi", 497, 497, 36},
  {"Africa/Lusaka", 498, 499, 37},
  {"Africa/Malabo", 500, 502, 38},
  {"Africa/Maputo", 503, 504, 39},
  {"Africa/Maseru", 505, 508, 40},
  {"Africa/Mbabane", 509, 510, 41},
  {"Africa/Mogadishu", 511, 512, 42},
  {"Africa/Monrovia", 513, 515, 43},
  {"Africa/Nairobi", 516, 520, 44},
  {"Africa/Ndjamena", 521, 524, 45},
  {"Africa/Niamey", 525, 528, 46},
  {"Africa/Nouakchott", 529, 532, 47},
  {"Africa/Ouagadougou", 533, 534, 48},
  {"Africa/Porto-Novo", 535, 537, 49},
  {"Africa/Sao_Tome", 538, 539, 50},
  {"Africa/Timbuktu", 540, 543, 51},
  {"Africa/Tripoli", 544, 573, 52},
  {"Africa/Tunis", 574, 607, 53},
  {"Africa/Windhoek", 608, 700, 54},
  {"America/Adak", 701, 843, 55},
  {"America/Anchorage", 844, 986, 56},
  {"America/Anguilla", 987, 988, 57},
  {"America/Antigua", 989, 991, 58},
  {"America/Araguaina", 992, 1041, 59},
  {"America/Argentina/Buenos_Aires", 1042, 1102, 60},
  {"America/Argentina/Catamarca", 1103, 1163, 61},
  {"America/Argentina/ComodRivadavia", 1164, 1224, 62},
  {"America/Argentina/Cordoba", 1225, 1285, 63},
  {"America/Argentina/Jujuy", 1286, 1344, 64},
  {"America/Argentina/La_Rioja", 1345, 1406, 65},
  {"America/Argentina/Mendoza", 1407, 1467, 66},
  {"America/Argentina/Rio_Gallegos", 1468, 1528, 67},
  {"America/Argentina/Salta", 1529, 1587, 68},
  {"America/Argentina/San_Juan", 1588, 1649, 69},
  {"America/Argentina/San_Luis", 1650, 1711, 70},
  {"America/Argentina/Tucuman", 1712, 1774, 71},
  {"America/Argentina/Ushuaia", 1775, 1835, 72},
  {"America/Aruba", 1836, 1838, 73},
  {"America/Asuncion", 1839, 1967, 74},
  {"America/Atikokan", 1968, 1973, 75},
  {"America/Atka", 1974, 2116, 76},
  {"America/Bahia", 2117, 2229, 77},
  {"America/Bahia_Banderas", 2230, 2323, 78},
  {"America/Barbados", 2324, 2334, 79},
  {"America/Belem", 2335, 2364, 80},
  {"America/Belize", 2365, 2420, 81},
  {"America/Blanc-Sablon", 2421, 2425, 82},
  {"America/Boa_Vista", 2426, 2459, 83},
  {"America/Bogota", 2460, 2463, 84},
  {"America/Boise", 2464, 2613, 85},
  {"America/Buenos_Aires", 2614, 2674, 86},
  {"America/Cambridge_Bay", 2675, 2798, 87},
  {"America/Campo_Grande", 2799, 2927, 88},
  {"America/Cancun", 2928, 3015, 89},
  {"America/Caracas", 3016, 3019, 90},
  {"America/Catamarca", 3020, 3080, 91},
  {"America/Cayenne", 3081, 3083, 92},
  {"America/Cayman", 3084, 3085, 93},
  {"America/Chicago", 3086, 3320, 94},
  {"America/Chihuahua", 3321, 3411, 95},
  {"America/Coral_Harbour", 3412, 3417, 96},
  {"America/Cordoba", 3418, 3478, 97},
  {"America/Costa_Rica", 3479, 3488, 98},
  {"America/Cuiaba", 3489, 3615, 99},
  {"America/Curacao", 3616, 3618, 100},
  {"America/Danmarkshavn", 3619, 3653, 101},
  {"America/Dawson", 3654, 3779, 102},
  {"America/Dawson_Creek", 3780, 3836, 103},
  {"America/Denver", 3837, 3993, 104},
  {"America/Detroit", 3994, 4133, 105},
  {"America/Dominica", 4134, 4135, 106},
  {"America/Edmonton", 4136, 4290, 107},
  {"America/Eirunepe", 4291, 4323, 108},
  {"America/El_Salvador", 4324, 4329, 109},
  {"America/Ensenada", 4330, 4479, 110},
  {"America/Fort_Wayne", 4520, 4617, 111},
  {"America/Fortaleza", 4480, 4519, 112},
  {"America/Glace_Bay", 4618, 4758, 113},
  {"America/Godthab", 4759, 4876, 114},
  {"America/Goose_Bay", 4877, 5079, 115},
  {"America/Grand_Turk", 5080, 5199, 116},
  {"America/Grenada", 5200, 5201, 117},
  {"America/Guadeloupe", 5202, 5203, 118},
  {"America/Guatemala", 5204, 5213, 119},
  {"America/Guayaquil", 5214, 5215, 120},
  {"America/Guyana", 5216, 5220, 121},
  {"America/Halifax", 5221, 5449, 122},
  {"America/Havana", 5450, 5605, 123},
  {"America/Hermosillo", 5606, 5621, 124},
  {"America/Indiana/Indianapolis", 5622, 5719, 125},
  {"America/Indiana/Knox", 5720, 5872, 126},
  {"America/Indiana/Marengo", 5873, 5974, 127},
  {"America/Indiana/Petersburg", 5975, 6089, 128},
  {"America/Indiana/Tell_City", 6090, 6189, 129},
  {"America/Indiana/Vevay", 6190, 6269, 130},
  {"America/Indiana/Vincennes", 6270, 6369, 131},
  {"America/Indiana/Winamac", 6370, 6475, 132},
  {"America/Indianapolis", 6476, 6573, 133},
  {"America/Inuvik", 6574, 6694, 134},
  {"America/Iqaluit", 6695, 6816, 135},
  {"America/Jamaica", 6817, 6838, 136},
  {"America/Jujuy", 6839, 6897, 137},
  {"America/Juneau", 6898, 7039, 138},
  {"America/Kentucky/Louisville", 7040, 7216, 139},
  {"America/Kentucky/Monticello", 7217, 7363, 140},
  {"America/Knox_IN", 7364, 7516, 141},
  {"America/Kralendijk", 7517, 7519, 142},
  {"America/La_Paz", 7520, 7522, 143},
  {"America/Lima", 7523, 7538, 144},
  {"America/Los_Angeles", 7539, 7723, 145},
  {"America/Louisville", 7724, 7900, 146},
  {"America/Lower_Princes", 7901, 7903, 147},
  {"America/Maceio", 7904, 7945, 148},
  {"America/Managua", 7946, 7961, 149},
  {"America/Manaus", 7962, 7993, 150},
  {"America/Marigot", 7994, 7995, 151},
  {"America/Martinique", 7996, 7999, 152},
  {"America/Matamoros", 8000, 8087, 153},
  {"America/Mazatlan", 8088, 8181, 154},
  {"America/Mendoza", 8182, 8242, 155},
  {"America/Menominee", 8243, 8384, 156},
  {"America/Merida", 8385, 8472, 157},
  {"America/Metlakatla", 8473, 8505, 158},
  {"America/Mexico_City", 8506, 8604, 159},
  {"America/Miquelon", 8605, 8709, 160},
  {"America/Moncton", 8710, 8916, 161},
  {"America/Monterrey", 8917, 9004, 162},
  {"America/Montevideo", 9005, 9136, 163},
  {"America/Montreal", 9137, 9368, 164},
  {"America/Montserrat", 9369, 9370, 165},
  {"America/Nassau", 9371, 9520, 166},
  {"America/New_York", 9521, 9755, 167},
  {"America/Nipigon", 9756, 9889, 168},
  {"America/Nome", 9890, 10032, 169},
  {"America/Noronha", 10033, 10072, 170},
  {"America/North_Dakota/Beulah", 10073, 10221, 171},
  {"America/North_Dakota/Center", 10222, 10370, 172},
  {"America/North_Dakota/New_Salem", 10371, 10519, 173},
  {"America/Ojinaga", 10520, 10610, 174},
  {"America/Panama", 10611, 10612, 175},
  {"America/Pangnirtung", 10613, 10735, 176},
  {"America/Paramaribo", 10736, 10741, 177},
  {"America/Phoenix", 10742, 10751, 178},
  {"America/Port-au-Prince", 10752, 10787, 179},
  {"America/Port_of_Spain", 10849, 10850, 180},
  {"America/Porto_Acre", 10788, 10818, 181},
  {"America/Porto_Velho", 10819, 10848, 182},
  {"America/Puerto_Rico", 10851, 10853, 183},
  {"America/Rainy_River", 10854, 10987, 184},
  {"America/Rankin_Inlet", 10988, 11107, 185},
  {"America/Recife", 11108, 11147, 186},
  {"America/Regina", 11148, 11201, 187},
  {"America/Resolute", 11202, 11321, 188},
  {"America/Rio_Branco", 11322, 11352, 189},
  {"America/Rosario", 11353, 11413, 190},
  {"America/Santa_Isabel", 11445, 11594, 191},
  {"America/Santarem", 11414, 11444, 192},
  {"America/Santiago", 11595, 11752, 193},
  {"America/Santo_Domingo", 11753, 11769, 194},
  {"America/Sao_Paulo", 11770, 11898, 195},
  {"America/Scoresbysund", 11899, 12016, 196},
  {"America/Shiprock", 12017, 12173, 197},
  {"America/Sitka", 12174, 12315, 198},
  {"America/St_Barthelemy", 12316, 12317, 199},
  {"America/St_Johns", 12318, 12555, 200},
  {"America/St_Kitts", 12556, 12557, 201},
  {"America/St_Lucia", 12558, 12559, 202},
  {"America/St_Thomas", 12560, 12561, 203},
  {"America/St_Vincent", 12562, 12563, 204},
  {"America/Swift_Current", 12564, 12587, 205},
  {"America/Tegucigalpa", 12588, 12595, 206},
  {"America/Thule", 12596, 12691, 207},
  {"America/Thunder_Bay", 12692, 12830, 208},
  {"America/Tijuana", 12831, 12980, 209},
  {"America/Toronto", 12981, 13212, 210},
  {"America/Tortola", 13213, 13214, 211},
  {"America/Vancouver", 13215, 13403, 212},
  {"America/Virgin", 13404, 13405, 213},
  {"America/Whitehorse", 13406, 13531, 214},
  {"America/Winnipeg", 13532, 13717, 215},
  {"America/Yakutat", 13718, 13859, 216},
  {"America/Yellowknife", 13860, 13982, 217},
  {"Antarctica/Casey", 13983, 13986, 218},
  {"Antarctica/Davis", 13987, 13991, 219},
  {"Antarctica/DumontDUrville", 13992, 13994, 220},
  {"Antarctica/Macquarie", 13995, 14090, 221},
  {"Antarctica/Mawson", 14091, 14093, 222},
  {"Antarctica/McMurdo", 14094, 14222, 223},
  {"Antarctica/Palmer", 14223, 14348, 224},
  {"Antarctica/Rothera", 14349, 14350, 225},
  {"Antarctica/South_Pole", 14351, 14479, 226},
  {"Antarctica/Syowa", 14480, 14481, 227},
  {"Antarctica/Vostok", 14482, 14483, 228},
  {"Arctic/Longyearbyen", 14484, 14624, 229},
  {"Asia/Aden", 14625, 14626, 230},
  {"Asia/Almaty", 14627, 14677, 231},
  {"Asia/Amman", 14678, 14797, 232},
  {"Asia/Anadyr", 14798, 14862, 233},
  {"Asia/Aqtau", 14863, 14915, 234},
  {"Asia/Aqtobe", 14916, 14967, 235},
  {"Asia/Ashgabat", 14968, 14994, 236},
  {"Asia/Ashkhabad", 14995, 15021, 237},
  {"Asia/Baghdad", 15022, 15075, 238},
  {"Asia/Bahrain", 15076, 15078, 239},
  {"Asia/Baku", 15079, 15191, 240},
  {"Asia/Bangkok", 15192, 15193, 241},
  {"Asia/Beirut", 15194, 15333, 242},
  {"Asia/Bishkek", 15334, 15386, 243},
  {"Asia/Brunei", 15387, 15389, 244},
  {"Asia/Calcutta", 15390, 15394, 245},
  {"Asia/Choibalsan", 15395, 15442, 246},
  {"Asia/Chongqing", 15443, 15457, 247},
  {"Asia/Chungking", 15458, 15472, 248},
  {"Asia/Colombo", 15473, 15480, 249},
  {"Asia/Dacca", 15481, 15488, 250},
  {"Asia/Damascus", 15489, 15640, 251},
  {"Asia/Dhaka", 15641, 15648, 252},
  {"Asia/Dili", 15649, 15654, 253},
  {"Asia/Dubai", 15655, 15656, 254},
  {"Asia/Dushanbe", 15657, 15681, 255},
  {"Asia/Gaza", 15682, 15773, 256},
  {"Asia/Harbin", 15774, 15791, 257},
  {"Asia/Hebron", 15792, 15885, 258},
  {"Asia/Ho_Chi_Minh", 16003, 16007, 259},
  {"Asia/Hong_Kong", 15886, 15955, 260},
  {"Asia/Hovd", 15956, 16002, 261},
  {"Asia/Irkutsk", 16008, 16072, 262},
  {"Asia/Istanbul", 16073, 16244, 263},
  {"Asia/Jakarta", 16245, 16252, 264},
  {"Asia/Jayapura", 16253, 16256, 265},
  {"Asia/Jerusalem", 16257, 16399, 266},
  {"Asia/Kabul", 16400, 16401, 267},
  {"Asia/Kamchatka", 16402, 16466, 268},
  {"Asia/Karachi", 16467, 16478, 269},
  {"Asia/Kashgar", 16479, 16494, 270},
  {"Asia/Kathmandu", 16495, 16497, 271},
  {"Asia/Katmandu", 16498, 16500, 272},
  {"Asia/Kolkata", 16501, 16505, 273},
  {"Asia/Krasnoyarsk", 16506, 16570, 274},
  {"Asia/Kuala_Lumpur", 16571, 16578, 275},
  {"Asia/Kuching", 16579, 16598, 276},
  {"Asia/Kuwait", 16599, 16600, 277},
  {"Asia/Macao", 16601, 16643, 278},
  {"Asia/Macau", 16644, 16686, 279},
  {"Asia/Magadan", 16687, 16751, 280},
  {"Asia/Makassar", 16752, 16756, 281},
  {"Asia/Manila", 16757, 16764, 282},
  {"Asia/Muscat", 16765, 16766, 283},
  {"Asia/Nicosia", 16767, 16894, 284},
  {"Asia/Novokuznetsk", 16895, 16959, 285},
  {"Asia/Novosibirsk", 16960, 17025, 286},
  {"Asia/Omsk", 17026, 17090, 287},
  {"Asia/Oral", 17091, 17142, 288},
  {"Asia/Phnom_Penh", 17143, 17147, 289},
  {"Asia/Pontianak", 17148, 17156, 290},
  {"Asia/Pyongyang", 17157, 17161, 291},
  {"Asia/Qatar", 17162, 17164, 292},
  {"Asia/Qyzylorda", 17165, 17217, 293},
  {"Asia/Rangoon", 17218, 17221, 294},
  {"Asia/Riyadh", 17222, 17223, 295},
  {"Asia/Saigon", 17224, 17228, 296},
  {"Asia/Sakhalin", 17229, 17294, 297},
  {"Asia/Samarkand", 17295, 17321, 298},
  {"Asia/Seoul", 17322, 17333, 299},
  {"Asia/Shanghai", 17334, 17351, 300},
  {"Asia/Singapore", 17352, 17360, 301},
  {"Asia/Taipei", 17361, 17400, 302},
  {"Asia/Tashkent", 17401, 17427, 303},
  {"Asia/Tbilisi", 17428, 17481, 304},
  {"Asia/Tehran", 17482, 17582, 305},
  {"Asia/Tel_Aviv", 17583, 17725, 306},
  {"Asia/Thimbu", 17726, 17728, 307},
  {"Asia/Thimphu", 17729, 17731, 308},
  {"Asia/Tokyo", 17732, 17741, 309},
  {"Asia/Ujung_Pandang", 17742, 17746, 310},
  {"Asia/Ulaanbaatar", 17747, 17793, 311},
  {"Asia/Ulan_Bator", 17794, 17840, 312},
  {"Asia/Urumqi", 17841, 17855, 313},
  {"Asia/Vientiane", 17856, 17860, 314},
  {"Asia/Vladivostok", 17861, 17925, 315},
  {"Asia/Yakutsk", 17926, 17990, 316},
  {"Asia/Yekaterinburg", 17991, 18055, 317},
  {"Asia/Yerevan", 18056, 18172, 318},
  {"Atlantic/Azores", 18173, 18393, 319},
  {"Atlantic/Bermuda", 18394, 18523, 320},
  {"Atlantic/Canary", 18524, 18642, 321},
  {"Atlantic/Cape_Verde", 18643, 18647, 322},
  {"Atlantic/Faeroe", 18648, 18763, 323},
  {"Atlantic/Faroe", 18764, 18879, 324},
  {"Atlantic/Jan_Mayen", 18880, 19020, 325},
  {"Atlantic/Madeira", 19021, 19241, 326},
  {"Atlantic/Reykjavik", 19242, 19306, 327},
  {"Atlantic/South_Georgia", 19307, 19307, 328},
  {"Atlantic/St_Helena", 19430, 19431, 329},
  {"Atlantic/Stanley", 19308, 19429, 330},
  {"Australia/ACT", 19432, 19572, 331},
  {"Australia/Adelaide", 19573, 19713, 332},
  {"Australia/Brisbane", 19714, 19729, 333},
  {"Australia/Broken_Hill", 19730, 19871, 334},
  {"Australia/Canberra", 19872, 20012, 335},
  {"Australia/Currie", 20013, 20153, 336},
  {"Australia/Darwin", 20154, 20161, 337},
  {"Australia/Eucla", 20162, 20179, 338},
  {"Australia/Hobart", 20180, 20328, 339},
  {"Australia/LHI", 20329, 20443, 340},
  {"Australia/Lindeman", 20444, 20464, 341},
  {"Australia/Lord_Howe", 20465, 20579, 342},
  {"Australia/Melbourne", 20580, 20720, 343},
  {"Australia/NSW", 20729, 20869, 344},
  {"Australia/North", 20721, 20728, 345},
  {"Australia/Perth", 20870, 20887, 346},
  {"Australia/Queensland", 20888, 20903, 347},
  {"Australia/South", 20904, 21044, 348},
  {"Australia/Sydney", 21045, 21185, 349},
  {"Australia/Tasmania", 21186, 21334, 350},
  {"Australia/Victoria", 21335, 21475, 351},
  {"Australia/West", 21476, 21493, 352},
  {"Australia/Yancowinna", 21494, 21635, 353},
  {"Brazil/Acre", 21636, 21666, 354},
  {"Brazil/DeNoronha", 21667, 21706, 355},
  {"Brazil/East", 21707, 21835, 356},
  {"Brazil/West", 21836, 21867, 357},
  {"CET", 23331, 23466, 358},
  {"CST6CDT", 23769, 23917, 359},
  {"Canada/Atlantic", 21868, 22096, 360},
  {"Canada/Central", 22097, 22282, 361},
  {"Canada/East-Saskatchewan", 22283, 22336, 362},
  {"Canada/Eastern", 22337, 22568, 363},
  {"Canada/Mountain", 22569, 22723, 364},
  {"Canada/Newfoundland", 22724, 22961, 365},
  {"Canada/Pacific", 22962, 23150, 366},
  {"Canada/Saskatchewan", 23151, 23204, 367},
  {"Canada/Yukon", 23205, 23330, 368},
  {"Chile/Continental", 23467, 23624, 369},
  {"Chile/EasterIsland", 23625, 23768, 370},
  {"Cuba", 23918, 24073, 371},
  {"EET", 24074, 24195, 372},
  {"EST", 24548, 24548, 373},
  {"EST5EDT", 24549, 24697, 374},
  {"Egypt", 24196, 24317, 375},
  {"Eire", 24318, 24547, 376},
  {"Etc/GMT", 24698, 24698, 377},
  {"Etc/GMT+0", 24699, 24699, 378},
  {"Etc/GMT+1", 24700, 24700, 379},
  {"Etc/GMT+10", 24701, 24701, 380},
  {"Etc/GMT+11", 24702, 24702, 381},
  {"Etc/GMT+12", 24703, 24703, 382},
  {"Etc/GMT+2", 24704, 24704, 383},
  {"Etc/GMT+3", 24705, 24705, 384},
  {"Etc/GMT+4", 24706, 24706, 385},
  {"Etc/GMT+5", 24707, 24707, 386},
  {"Etc/GMT+6", 24708, 24708, 387},
  {"Etc/GMT+7", 24709, 24709, 388},
  {"Etc/GMT+8", 24710, 24710, 389},
  {"Etc/GMT+9", 24711, 24711, 390},
  {"Etc/GMT-0", 24712, 24712, 391},
  {"Etc/GMT-1", 24713, 24713, 392},
  {"Etc/GMT-10", 24714, 24714, 393},
  {"Etc/GMT-11", 24715, 24715, 394},
  {"Etc/GMT-12", 24716, 24716, 395},
  {"Etc/GMT-13", 24717, 24717, 396},
  {"Etc/GMT-14", 24718, 24718, 397},
  {"Etc/GMT-2", 24719, 24719, 398},
  {"Etc/GMT-3", 24720, 24720, 399},
  {"Etc/GMT-4", 24721, 24721, 400},
  {"Etc/GMT-5", 24722, 24722, 401},
  {"Etc/GMT-6", 24723, 24723, 402},
  {"Etc/GMT-7", 24724, 24724, 403},
  {"Etc/GMT-8", 24725, 24725, 404},
  {"Etc/GMT-9", 24726, 24726, 405},
  {"Etc/GMT0", 24727, 24727, 406},
  {"Etc/Greenwich", 24728, 24728, 407},
  {"Etc/UCT", 24729, 24729, 408},
  {"Etc/UTC", 24731, 24731, 409},
  {"Etc/Universal", 24730, 24730, 410},
  {"Etc/Zulu", 24732, 24732, 411},
  {"Europe/Amsterdam", 24733, 24912, 412},
  {"Europe/Andorra", 24913, 25020, 413},
  {"Europe/Athens", 25021, 25158, 414},
  {"Europe/Belfast", 25159, 25400, 415},
  {"Europe/Belgrade", 25401, 25520, 416},
  {"Europe/Berlin", 25521, 25664, 417},
  {"Europe/Bratislava", 25665, 25805, 418},
  {"Europe/Brussels", 25806, 25991, 419},
  {"Europe/Bucharest", 25992, 26129, 420},
  {"Europe/Budapest", 26130, 26283, 421},
  {"Europe/Chisinau", 26284, 26424, 422},
  {"Europe/Copenhagen", 26425, 26557, 423},
  {"Europe/Dublin", 26558, 26787, 424},
  {"Europe/Gibraltar", 26788, 26984, 425},
  {"Europe/Guernsey", 26985, 27226, 426},
  {"Europe/Helsinki", 27227, 27344, 427},
  {"Europe/Isle_of_Man", 27345, 27586, 428},
  {"Europe/Istanbul", 27587, 27758, 429},
  {"Europe/Jersey", 27759, 28000, 430},
  {"Europe/Kaliningrad", 28001, 28077, 431},
  {"Europe/Kiev", 28078, 28197, 432},
  {"Europe/Lisbon", 28198, 28419, 433},
  {"Europe/Ljubljana", 28420, 28539, 434},
  {"Europe/London", 28540, 28781, 435},
  {"Europe/Luxembourg", 28782, 28966, 436},
  {"Europe/Madrid", 28967, 29129, 437},
  {"Europe/Malta", 29130, 29297, 438},
  {"Europe/Mariehamn", 29298, 29415, 439},
  {"Europe/Minsk", 29416, 29484, 440},
  {"Europe/Monaco", 29485, 29669, 441},
  {"Europe/Moscow", 29670, 29746, 442},
  {"Europe/Nicosia", 29747, 29874, 443},
  {"Europe/Oslo", 29875, 30015, 444},
  {"Europe/Paris", 30016, 30199, 445},
  {"Europe/Podgorica", 30200, 30319, 446},
  {"Europe/Prague", 30320, 30460, 447},
  {"Europe/Riga", 30461, 30587, 448},
  {"Europe/Rome", 30588, 30757, 449},
  {"Europe/Samara", 30758, 30824, 450},
  {"Europe/San_Marino", 30825, 30994, 451},
  {"Europe/Sarajevo", 30995, 31114, 452},
  {"Europe/Simferopol", 31115, 31238, 453},
  {"Europe/Skopje", 31239, 31358, 454},
  {"Europe/Sofia", 31359, 31484, 455},
  {"Europe/Stockholm", 31485, 31602, 456},
  {"Europe/Tallinn", 31603, 31726, 457},
  {"Europe/Tirane", 31727, 31860, 458},
  {"Europe/Tiraspol", 31861, 32001, 459},
  {"Europe/Uzhgorod", 32002, 32122, 460},
  {"Europe/Vaduz", 32123, 32237, 461},
  {"Europe/Vatican", 32238, 32407, 462},
  {"Europe/Vienna", 32408, 32547, 463},
  {"Europe/Vilnius", 32548, 32669, 464},
  {"Europe/Volgograd", 32670, 32734, 465},
  {"Europe/Warsaw", 32735, 32902, 466},
  {"Europe/Zagreb", 32903, 33022, 467},
  {"Europe/Zaporozhye", 33023, 33144, 468},
  {"Europe/Zurich", 33145, 33262, 469},
  {"GB", 33263, 33504, 470},
  {"GB-Eire", 33505, 33746, 471},
  {"GMT", 33747, 33747, 472},
  {"GMT+0", 33748, 33748, 473},
  {"GMT-0", 33749, 33749, 474},
  {"GMT0", 33750, 33750, 475},
  {"Greenwich", 33751, 33751, 476},
  {"HST", 33822, 33822, 477},
  {"Hongkong", 33752, 33821, 478},
  {"Iceland", 33823, 33887, 479},
  {"Indian/Antananarivo", 33888, 33891, 480},
  {"Indian/Chagos", 33892, 33894, 481},
  {"Indian/Christmas", 33895, 33895, 482},
  {"Indian/Cocos", 33896, 33896, 483},
  {"Indian/Comoro", 33897, 33898, 484},
  {"Indian/Kerguelen", 33899, 33900, 485},
  {"Indian/Mahe", 33901, 33902, 486},
  {"Indian/Maldives", 33903, 33904, 487},
  {"Indian/Mauritius", 33905, 33910, 488},
  {"Indian/Mayotte", 33911, 33912, 489},
  {"Indian/Reunion", 33913, 33914, 490},
  {"Iran", 33915, 34015, 491},
  {"Israel", 34016, 34158, 492},
  {"Jamaica", 34159, 34180, 493},
  {"Japan", 34181, 34190, 494},
  {"Kwajalein", 34191, 34193, 495},
  {"Libya", 34194, 34223, 496},
  {"MET", 34224, 34359, 497},
  {"MST", 34703, 34703, 498},
  {"MST7MDT", 34704, 34852, 499},
  {"Mexico/BajaNorte", 34360, 34509, 500},
  {"Mexico/BajaSur", 34510, 34603, 501},
  {"Mexico/General", 34604, 34702, 502},
  {"NZ", 35010, 35164, 503},
  {"NZ-CHAT", 35165, 35293, 504},
  {"Navajo", 34853, 35009, 505},
  {"PRC", 36270, 36287, 506},
  {"PST8PDT", 36288, 36436, 507},
  {"Pacific/Apia", 35294, 35301, 508},
  {"Pacific/Auckland", 35302, 35456, 509},
  {"Pacific/Chatham", 35457, 35585, 510},
  {"Pacific/Chuuk", 35586, 35586, 511},
  {"Pacific/Easter", 35587, 35730, 512},
  {"Pacific/Efate", 35731, 35752, 513},
  {"Pacific/Enderbury", 35753, 35755, 514},
  {"Pacific/Fakaofo", 35756, 35756, 515},
  {"Pacific/Fiji", 35757, 35768, 516},
  {"Pacific/Funafuti", 35769, 35769, 517},
  {"Pacific/Galapagos", 35770, 35772, 518},
  {"Pacific/Gambier", 35773, 35774, 519},
  {"Pacific/Guadalcanal", 35775, 35776, 520},
  {"Pacific/Guam", 35777, 35778, 521},
  {"Pacific/Honolulu", 35779, 35783, 522},
  {"Pacific/Johnston", 35784, 35784, 523},
  {"Pacific/Kiritimati", 35785, 35787, 524},
  {"Pacific/Kosrae", 35788, 35789, 525},
  {"Pacific/Kwajalein", 35790, 35792, 526},
  {"Pacific/Majuro", 35793, 35794, 527},
  {"Pacific/Marquesas", 35795, 35796, 528},
  {"Pacific/Midway", 35797, 35800, 529},
  {"Pacific/Nauru", 35801, 35805, 530},
  {"Pacific/Niue", 35806, 35808, 531},
  {"Pacific/Norfolk", 35809, 35810, 532},
  {"Pacific/Noumea", 35811, 35818, 533},
  {"Pacific/Pago_Pago", 35819, 35823, 534},
  {"Pacific/Palau", 35824, 35824, 535},
  {"Pacific/Pitcairn", 35825, 35826, 536},
  {"Pacific/Pohnpei", 35827, 35827, 537},
  {"Pacific/Ponape", 35828, 35828, 538},
  {"Pacific/Port_Moresby", 35829, 35829, 539},
  {"Pacific/Rarotonga", 35830, 35856, 540},
  {"Pacific/Saipan", 35857, 35859, 541},
  {"Pacific/Samoa", 35860, 35864, 542},
  {"Pacific/Tahiti", 35865, 35866, 543},
  {"Pacific/Tarawa", 35867, 35867, 544},
  {"Pacific/Tongatapu", 35868, 35875, 545},
  {"Pacific/Truk", 35876, 35876, 546},
  {"Pacific/Wake", 35877, 35877, 547},
  {"Pacific/Wallis", 35878, 35878, 548},
  {"Pacific/Yap", 35879, 35879, 549},
  {"Poland", 35880, 36047, 550},
  {"Portugal", 36048, 36269, 551},
  {"ROC", 36437, 36476, 552},
  {"ROK", 36477, 36488, 553},
  {"Singapore", 36489, 36497, 554},
  {"Turkey", 36498, 36669, 555},
  {"UCT", 36670, 36670, 556},
  {"US/Alaska", 36672, 36814, 557},
  {"US/Aleutian", 36815, 36957, 558},
  {"US/Arizona", 36958, 36967, 559},
  {"US/Central", 36968, 37202, 560},
  {"US/East-Indiana", 37203, 37300, 561},
  {"US/Eastern", 37301, 37535, 562},
  {"US/Hawaii", 37536, 37540, 563},
  {"US/Indiana-Starke", 37541, 37693, 564},
  {"US/Michigan", 37694, 37833, 565},
  {"US/Mountain", 37834, 37990, 566},
  {"US/Pacific", 37991, 38175, 567},
  {"US/Samoa", 38176, 38180, 568},
  {"UTC", 38181, 38181, 569},
  {"Universal", 36671, 36671, 570},
  {"W-SU", 38182, 38258, 571},
  {"WET", 38259, 38380, 572},
  {"Zulu", 38381, 38381, 573},
};

ObTimeZoneTrans ObTimeZoneInfo::TIME_ZONE_TRANS[] =
{
  {INT64_MIN, 0, 0},    // used to occupy this place.
  {INT64_MIN, -968, 1},
  {-1830383032, 0, 1},
  {INT64_MIN, -52, 2},
  {-1640995148, 0, 2},
  {-1051920000, 1200, 2},
  {-1041466800, 0, 2},
  {-1020384000, 1200, 2},
  {-1009930800, 0, 2},
  {-988848000, 1200, 2},
  {-978394800, 0, 2},
  {-957312000, 1200, 2},
  {-946858800, 0, 2},
  {-925689600, 1200, 2},
  {-915236400, 0, 2},
  {-894153600, 1200, 2},
  {-883700400, 0, 2},
  {-862617600, 1200, 2},
  {-852164400, 0, 2},
  {INT64_MIN, 9320, 3},
  {-1062210920, 10800, 3},
  {INT64_MIN, 561, 4},
  {-1855958961, 0, 4},
  {-1689814800, 3600, 4},
  {-1680397200, 0, 4},
  {-1665363600, 3600, 4},
  {-1648342800, 0, 4},
  {-1635123600, 3600, 4},
  {-1616893200, 0, 4},
  {-1604278800, 3600, 4},
  {-1585443600, 0, 4},
  {-1574038800, 3600, 4},
  {-1552266000, 0, 4},
  {-1539997200, 3600, 4},
  {-1531443600, 0, 4},
  {-956365200, 3600, 4},
  {-950486400, 0, 4},
  {-942012000, 3600, 4},
  {-812502000, 7200, 4},
  {-796262400, 3600, 4},
  {-781052400, 7200, 4},
  {-766630800, 3600, 4},
  {-733280400, 0, 4},
  {-439430400, 3600, 4},
  {-212029200, 0, 4},
  {41468400, 3600, 4},
  {54774000, 0, 4},
  {231724800, 3600, 4},
  {246236400, 3600, 4},
  {259545600, 7200, 4},
  {275274000, 3600, 4},
  {309740400, 0, 4},
  {325468800, 3600, 4},
  {341802000, 0, 4},
  {357523200, 3600, 4},
  {INT64_MIN, 9320, 5},
  {-1062210920, 10800, 5},
  {INT64_MIN, 9320, 6},
  {-1062210920, 10800, 6},
  {INT64_MIN, -1920, 7},
  {-1830382080, 0, 7},
  {-1131235200, -3600, 7},
  {-300841200, 0, 7},
  {INT64_MIN, 4460, 8},
  {-1830388460, 3600, 8},
  {INT64_MIN, -3996, 9},
  {-1830380004, -3996, 9},
  {-1104533604, -3600, 9},
  {-189385200, 0, 9},
  {INT64_MIN, -3740, 10},
  {-1849388260, -3600, 10},
  {157770000, 0, 10},
  {INT64_MIN, 8400, 11},
  {-2109291600, 7200, 11},
  {INT64_MIN, 3668, 12},
  {-1830387668, 3600, 12},
  {INT64_MIN, 7200, 13},
  {-929844000, 10800, 14},
  {-923108400, 7200, 14},
  {-906170400, 10800, 14},
  {-892868400, 7200, 14},
  {-875844000, 10800, 14},
  {-857790000, 7200, 14},
  {-844308000, 10800, 14},
  {-825822000, 7200, 14},
  {-812685600, 10800, 14},
  {-794199600, 7200, 14},
  {-779853600, 10800, 14},
  {-762663600, 7200, 14},
  {-399088800, 10800, 14},
  {-386650800, 7200, 14},
  {-368330400, 10800, 14},
  {-355114800, 7200, 14},
  {-336790800, 10800, 14},
  {-323654400, 7200, 14},
  {-305168400, 10800, 14},
  {-292032000, 7200, 14},
  {-273632400, 10800, 14},
  {-260496000, 7200, 14},
  {-242096400, 10800, 14},
  {-228960000, 7200, 14},
  {-210560400, 10800, 14},
  {-197424000, 7200, 14},
  {-178938000, 10800, 14},
  {-165801600, 7200, 14},
  {-147402000, 10800, 14},
  {-134265600, 7200, 14},
  {-115866000, 10800, 14},
  {-102643200, 7200, 14},
  {-84330000, 10800, 14},
  {-71107200, 7200, 14},
  {-52707600, 10800, 14},
  {-39484800, 7200, 14},
  {-21171600, 10800, 14},
  {-7948800, 7200, 14},
  {10364400, 10800, 14},
  {23587200, 7200, 14},
  {41900400, 10800, 14},
  {55123200, 7200, 14},
  {73522800, 10800, 14},
  {86745600, 7200, 14},
  {105058800, 10800, 14},
  {118281600, 7200, 14},
  {136594800, 10800, 14},
  {149817600, 7200, 14},
  {168130800, 10800, 14},
  {181353600, 7200, 14},
  {199753200, 10800, 14},
  {212976000, 7200, 14},
  {231289200, 10800, 14},
  {244512000, 7200, 14},
  {262825200, 10800, 14},
  {276048000, 7200, 14},
  {294361200, 10800, 14},
  {307584000, 7200, 14},
  {325983600, 10800, 14},
  {339206400, 7200, 14},
  {357519600, 10800, 14},
  {370742400, 7200, 14},
  {396399600, 10800, 14},
  {402278400, 7200, 14},
  {426812400, 10800, 14},
  {433814400, 7200, 14},
  {452214000, 10800, 14},
  {465436800, 7200, 14},
  {483750000, 10800, 14},
  {496972800, 7200, 14},
  {515286000, 10800, 14},
  {528508800, 7200, 14},
  {546822000, 10800, 14},
  {560044800, 7200, 14},
  {578444400, 10800, 14},
  {591667200, 7200, 14},
  {610412400, 10800, 14},
  {623203200, 7200, 14},
  {641516400, 10800, 14},
  {654739200, 7200, 14},
  {673052400, 10800, 14},
  {686275200, 7200, 14},
  {704674800, 10800, 14},
  {717897600, 7200, 14},
  {736210800, 10800, 14},
  {749433600, 7200, 14},
  {767746800, 10800, 14},
  {780969600, 7200, 14},
  {799020000, 10800, 14},
  {812322000, 7200, 14},
  {830469600, 10800, 14},
  {843771600, 7200, 14},
  {861919200, 10800, 14},
  {875221200, 7200, 14},
  {893368800, 10800, 14},
  {906670800, 7200, 14},
  {925423200, 10800, 14},
  {938725200, 7200, 14},
  {956872800, 10800, 14},
  {970174800, 7200, 14},
  {988322400, 10800, 14},
  {1001624400, 7200, 14},
  {1019772000, 10800, 14},
  {1033074000, 7200, 14},
  {1051221600, 10800, 14},
  {1064523600, 7200, 14},
  {1083276000, 10800, 14},
  {1096578000, 7200, 14},
  {1114725600, 10800, 14},
  {1128027600, 7200, 14},
  {1146175200, 10800, 14},
  {1158872400, 7200, 14},
  {1177624800, 10800, 14},
  {1189112400, 7200, 14},
  {1209074400, 10800, 14},
  {1219957200, 7200, 14},
  {1240524000, 10800, 14},
  {1250802000, 7200, 14},
  {1272578400, 10800, 14},
  {1281474000, 7200, 14},
  {1284069600, 10800, 14},
  {1285880400, 7200, 14},
  {INT64_MIN, -1820, 15},
  {-1773012580, 0, 15},
  {-956361600, 3600, 15},
  {-950490000, 0, 15},
  {-942019200, 3600, 15},
  {-761187600, 0, 15},
  {-617241600, 3600, 15},
  {-605149200, 0, 15},
  {-81432000, 3600, 15},
  {-71110800, 0, 15},
  {141264000, 3600, 15},
  {147222000, 0, 15},
  {199756800, 3600, 15},
  {207702000, 0, 15},
  {231292800, 3600, 15},
  {244249200, 0, 15},
  {265507200, 3600, 15},
  {271033200, 0, 15},
  {448243200, 3600, 15},
  {504918000, 0, 15},
  {1212278400, 3600, 15},
  {1220223600, 0, 15},
  {1243814400, 3600, 15},
  {1250809200, 0, 15},
  {1272758400, 3600, 15},
  {1281222000, 0, 15},
  {1301788800, 3600, 15},
  {1312066800, 0, 15},
  {-1630112400, 3600, 16},
  {-1616810400, 0, 16},
  {-1442451600, 3600, 16},
  {-1427677200, 0, 16},
  {-1379293200, 3600, 16},
  {-1364778000, 0, 16},
  {-1348448400, 3600, 16},
  {-1333328400, 0, 16},
  {-1316394000, 3600, 16},
  {-1301274000, 0, 16},
  {-1293840000, 0, 16},
  {-81432000, 3600, 16},
  {-71110800, 0, 16},
  {141264000, 3600, 16},
  {147222000, 0, 16},
  {199756800, 3600, 16},
  {207702000, 0, 16},
  {231292800, 3600, 16},
  {244249200, 0, 16},
  {265507200, 3600, 16},
  {271033200, 0, 16},
  {448243200, 3600, 16},
  {512528400, 7200, 16},
  {528253200, 3600, 16},
  {543978000, 7200, 16},
  {559702800, 3600, 16},
  {575427600, 7200, 16},
  {591152400, 3600, 16},
  {606877200, 7200, 16},
  {622602000, 3600, 16},
  {638326800, 7200, 16},
  {654656400, 3600, 16},
  {670381200, 7200, 16},
  {686106000, 3600, 16},
  {701830800, 7200, 16},
  {717555600, 3600, 16},
  {733280400, 7200, 16},
  {749005200, 3600, 16},
  {764730000, 7200, 16},
  {780454800, 3600, 16},
  {796179600, 7200, 16},
  {811904400, 3600, 16},
  {828234000, 7200, 16},
  {846378000, 3600, 16},
  {859683600, 7200, 16},
  {877827600, 3600, 16},
  {891133200, 7200, 16},
  {909277200, 3600, 16},
  {922582800, 7200, 16},
  {941331600, 3600, 16},
  {954032400, 7200, 16},
  {972781200, 3600, 16},
  {985482000, 7200, 16},
  {1004230800, 3600, 16},
  {1017536400, 7200, 16},
  {1035680400, 3600, 16},
  {1048986000, 7200, 16},
  {1067130000, 3600, 16},
  {1080435600, 7200, 16},
  {1099184400, 3600, 16},
  {1111885200, 7200, 16},
  {1130634000, 3600, 16},
  {1143334800, 7200, 16},
  {1162083600, 3600, 16},
  {1174784400, 7200, 16},
  {1193533200, 3600, 16},
  {1206838800, 7200, 16},
  {1224982800, 3600, 16},
  {1238288400, 7200, 16},
  {1256432400, 3600, 16},
  {1269738000, 7200, 16},
  {1288486800, 3600, 16},
  {1301187600, 7200, 16},
  {1319936400, 3600, 16},
  {1332637200, 7200, 16},
  {1351386000, 3600, 16},
  {1364691600, 7200, 16},
  {1382835600, 3600, 16},
  {1396141200, 7200, 16},
  {1414285200, 3600, 16},
  {1427590800, 7200, 16},
  {1445734800, 3600, 16},
  {1459040400, 7200, 16},
  {1477789200, 3600, 16},
  {1490490000, 7200, 16},
  {1509238800, 3600, 16},
  {1521939600, 7200, 16},
  {1540688400, 3600, 16},
  {1553994000, 7200, 16},
  {1572138000, 3600, 16},
  {1585443600, 7200, 16},
  {1603587600, 3600, 16},
  {1616893200, 7200, 16},
  {1635642000, 3600, 16},
  {1648342800, 7200, 16},
  {1667091600, 3600, 16},
  {1679792400, 7200, 16},
  {1698541200, 3600, 16},
  {1711846800, 7200, 16},
  {1729990800, 3600, 16},
  {1743296400, 7200, 16},
  {1761440400, 3600, 16},
  {1774746000, 7200, 16},
  {1792890000, 3600, 16},
  {1806195600, 7200, 16},
  {1824944400, 3600, 16},
  {1837645200, 7200, 16},
  {1856394000, 3600, 16},
  {1869094800, 7200, 16},
  {1887843600, 3600, 16},
  {1901149200, 7200, 16},
  {1919293200, 3600, 16},
  {1932598800, 7200, 16},
  {1950742800, 3600, 16},
  {1964048400, 7200, 16},
  {1982797200, 3600, 16},
  {1995498000, 7200, 16},
  {2014246800, 3600, 16},
  {2026947600, 7200, 16},
  {2045696400, 3600, 16},
  {2058397200, 7200, 16},
  {2077146000, 3600, 16},
  {2090451600, 7200, 16},
  {2108595600, 3600, 16},
  {2121901200, 7200, 16},
  {2140045200, 3600, 16},
  {INT64_MIN, -3292, 17},
  {-1830380708, 0, 17},
  {-1131235200, -3600, 17},
  {-315615600, 0, 17},
  {INT64_MIN, -4184, 18},
  {-1830379816, -3600, 18},
  {-902098800, 0, 18},
  {INT64_MIN, 9428, 19},
  {-1230777428, 10800, 19},
  {-694321200, 9900, 19},
  {-284006700, 10800, 19},
  {INT64_MIN, 10356, 20},
  {-1846291956, 10800, 20},
  {INT64_MIN, 2328, 21},
  {-1830386328, 3600, 21},
  {INT64_MIN, -3168, 22},
  {-1136070432, -3600, 22},
  {198291600, 0, 22},
  {INT64_MIN, -3180, 23},
  {-1785712020, -3600, 23},
  {-1091487600, -1200, 23},
  {-1080949200, -3600, 23},
  {-1059865200, -1200, 23},
  {-1049326800, -3600, 23},
  {-1028329200, -1200, 23},
  {-1017790800, -3600, 23},
  {-996793200, -1200, 23},
  {-986254800, -3600, 23},
  {-965257200, -1200, 23},
  {-954718800, -3600, 23},
  {-933634800, -1200, 23},
  {-923096400, -3600, 23},
  {-902098800, -1200, 23},
  {-891560400, -3600, 23},
  {-870562800, -1200, 23},
  {-860024400, -3600, 23},
  {-410223600, 0, 23},
  {-397180800, 3600, 23},
  {-389235600, 0, 23},
  {-365644800, 3600, 23},
  {-357699600, 0, 23},
  {-334108800, 3600, 23},
  {-326163600, 0, 23},
  {-302486400, 3600, 23},
  {-294541200, 0, 23},
  {-270950400, 3600, 23},
  {-263005200, 0, 23},
  {-239414400, 3600, 23},
  {-231469200, 0, 23},
  {-829526400, 10800, 24},
  {-813805200, 7200, 24},
  {INT64_MIN, 7452, 25},
  {-2109290652, 7200, 25},
  {INT64_MIN, 5400, 26},
  {-2109288600, 7200, 26},
  {-860976000, 10800, 26},
  {-845254800, 7200, 26},
  {-829526400, 10800, 26},
  {-813805200, 7200, 26},
  {INT64_MIN, 7584, 27},
  {-1230775584, 7200, 27},
  {10360800, 10800, 27},
  {24786000, 7200, 27},
  {41810400, 10800, 27},
  {56322000, 7200, 27},
  {73432800, 10800, 27},
  {87944400, 7200, 27},
  {104882400, 10800, 27},
  {119480400, 7200, 27},
  {136332000, 10800, 27},
  {151016400, 7200, 27},
  {167781600, 10800, 27},
  {182552400, 7200, 27},
  {199231200, 10800, 27},
  {214174800, 7200, 27},
  {230680800, 10800, 27},
  {245710800, 7200, 27},
  {262735200, 10800, 27},
  {277246800, 7200, 27},
  {294184800, 10800, 27},
  {308782800, 7200, 27},
  {325634400, 10800, 27},
  {340405200, 7200, 27},
  {357084000, 10800, 27},
  {371941200, 7200, 27},
  {388533600, 10800, 27},
  {403477200, 7200, 27},
  {419983200, 10800, 27},
  {435013200, 7200, 27},
  {452037600, 10800, 27},
  {466635600, 7200, 27},
  {483487200, 10800, 27},
  {498171600, 7200, 27},
  {947930400, 10800, 27},
  {INT64_MIN, 7780, 28},
  {-1309745380, 10800, 28},
  {-1262314800, 9000, 28},
  {-694319400, 9900, 28},
  {-410237100, 10800, 28},
  {INT64_MIN, 7808, 29},
  {-1230775808, 7200, 29},
  {10360800, 10800, 29},
  {24786000, 7200, 29},
  {41810400, 10800, 29},
  {56322000, 7200, 29},
  {73432800, 10800, 29},
  {87944400, 7200, 29},
  {104882400, 10800, 29},
  {119480400, 7200, 29},
  {136332000, 10800, 29},
  {151016400, 7200, 29},
  {167781600, 10800, 29},
  {182552400, 7200, 29},
  {199231200, 10800, 29},
  {214174800, 7200, 29},
  {230680800, 10800, 29},
  {245710800, 7200, 29},
  {262735200, 10800, 29},
  {277246800, 7200, 29},
  {294184800, 10800, 29},
  {308782800, 7200, 29},
  {325634400, 10800, 29},
  {340405200, 7200, 29},
  {357084000, 10800, 29},
  {371941200, 7200, 29},
  {388533600, 10800, 29},
  {403477200, 7200, 29},
  {419983200, 10800, 29},
  {435013200, 7200, 29},
  {452037600, 10800, 29},
  {466635600, 7200, 29},
  {483487200, 10800, 29},
  {498171600, 7200, 29},
  {947930400, 10800, 29},
  {INT64_MIN, 7216, 30},
  {-1091498416, 7200, 30},
  {INT64_MIN, 3600, 31},
  {INT64_MIN, 816, 32},
  {-1588464816, 3600, 32},
  {INT64_MIN, 2268, 33},
  {-1830386268, 3600, 33},
  {INT64_MIN, 0, 34},
  {INT64_MIN, 3124, 35},
  {-1849395124, 3600, 35},
  {INT64_MIN, 7200, 36},
  {INT64_MIN, 6788, 37},
  {-2109289988, 7200, 37},
  {INT64_MIN, 2108, 38},
  {-1830386108, 0, 38},
  {-190857600, 3600, 38},
  {INT64_MIN, 7820, 39},
  {-2109291020, 7200, 39},
  {INT64_MIN, 6600, 40},
  {-2109289800, 7200, 40},
  {-829526400, 10800, 40},
  {-813805200, 7200, 40},
  {INT64_MIN, 7464, 41},
  {-2109290664, 7200, 41},
  {-1230778800, 9000, 42},
  {-410236200, 10800, 42},
  {INT64_MIN, -2588, 43},
  {-1604359012, -2670, 43},
  {73529070, 0, 43},
  {INT64_MIN, 8836, 44},
  {-1309746436, 10800, 44},
  {-1262314800, 9000, 44},
  {-946780200, 9900, 44},
  {-315629100, 10800, 44},
  {INT64_MIN, 3612, 45},
  {-1830387612, 3600, 45},
  {308703600, 7200, 45},
  {321314400, 3600, 45},
  {INT64_MIN, 508, 46},
  {-1830384508, -3600, 46},
  {-1131231600, 0, 46},
  {-315619200, 3600, 46},
  {INT64_MIN, -3828, 47},
  {-1830380172, 0, 47},
  {-1131235200, -3600, 47},
  {-286930800, 0, 47},
  {INT64_MIN, -364, 48},
  {-1830383636, 0, 48},
  {INT64_MIN, 628, 49},
  {-1830384628, 0, 49},
  {-1131235200, 3600, 49},
  {INT64_MIN, -2192, 50},
  {-1830381808, 0, 50},
  {INT64_MIN, -1920, 51},
  {-1830382080, 0, 51},
  {-1131235200, -3600, 51},
  {-300841200, 0, 51},
  {INT64_MIN, 3164, 52},
  {-1577926364, 3600, 52},
  {-574902000, 7200, 52},
  {-568087200, 3600, 52},
  {-512175600, 7200, 52},
  {-504928800, 3600, 52},
  {-449888400, 7200, 52},
  {-441856800, 3600, 52},
  {-347158800, 7200, 52},
  {378684000, 3600, 52},
  {386463600, 7200, 52},
  {402271200, 3600, 52},
  {417999600, 7200, 52},
  {433807200, 3600, 52},
  {449622000, 7200, 52},
  {465429600, 3600, 52},
  {481590000, 7200, 52},
  {496965600, 3600, 52},
  {512953200, 7200, 52},
  {528674400, 3600, 52},
  {544230000, 7200, 52},
  {560037600, 3600, 52},
  {575852400, 7200, 52},
  {591660000, 3600, 52},
  {607388400, 7200, 52},
  {623196000, 3600, 52},
  {641775600, 7200, 52},
  {844034400, 3600, 52},
  {860108400, 7200, 52},
  {875916000, 7200, 52},
  {INT64_MIN, 561, 53},
  {-1855958961, 3600, 53},
  {-969242400, 7200, 53},
  {-950493600, 3600, 53},
  {-941940000, 7200, 53},
  {-891136800, 3600, 53},
  {-877827600, 7200, 53},
  {-857257200, 3600, 53},
  {-844556400, 7200, 53},
  {-842918400, 3600, 53},
  {-842223600, 7200, 53},
  {-828230400, 3600, 53},
  {-812502000, 7200, 53},
  {-796269600, 3600, 53},
  {-781052400, 7200, 53},
  {-766634400, 3600, 53},
  {231202800, 7200, 53},
  {243903600, 3600, 53},
  {262825200, 7200, 53},
  {276044400, 3600, 53},
  {581122800, 7200, 53},
  {591145200, 3600, 53},
  {606870000, 7200, 53},
  {622594800, 3600, 53},
  {641516400, 7200, 53},
  {654649200, 3600, 53},
  {1114902000, 7200, 53},
  {1128038400, 3600, 53},
  {1143334800, 7200, 53},
  {1162083600, 3600, 53},
  {1174784400, 7200, 53},
  {1193533200, 3600, 53},
  {1206838800, 7200, 53},
  {1224982800, 3600, 53},
  {INT64_MIN, 5400, 54},
  {-2109288600, 7200, 54},
  {-860976000, 10800, 54},
  {-845254800, 7200, 54},
  {637970400, 7200, 54},
  {765324000, 3600, 54},
  {778640400, 7200, 54},
  {796780800, 3600, 54},
  {810090000, 7200, 54},
  {828835200, 3600, 54},
  {841539600, 7200, 54},
  {860284800, 3600, 54},
  {873594000, 7200, 54},
  {891734400, 3600, 54},
  {905043600, 7200, 54},
  {923184000, 3600, 54},
  {936493200, 7200, 54},
  {954633600, 3600, 54},
  {967942800, 7200, 54},
  {986083200, 3600, 54},
  {999392400, 7200, 54},
  {1018137600, 3600, 54},
  {1030842000, 7200, 54},
  {1049587200, 3600, 54},
  {1062896400, 7200, 54},
  {1081036800, 3600, 54},
  {1094346000, 7200, 54},
  {1112486400, 3600, 54},
  {1125795600, 7200, 54},
  {1143936000, 3600, 54},
  {1157245200, 7200, 54},
  {1175385600, 3600, 54},
  {1188694800, 7200, 54},
  {1207440000, 3600, 54},
  {1220749200, 7200, 54},
  {1238889600, 3600, 54},
  {1252198800, 7200, 54},
  {1270339200, 3600, 54},
  {1283648400, 7200, 54},
  {1301788800, 3600, 54},
  {1315098000, 7200, 54},
  {1333238400, 3600, 54},
  {1346547600, 7200, 54},
  {1365292800, 3600, 54},
  {1377997200, 7200, 54},
  {1396742400, 3600, 54},
  {1410051600, 7200, 54},
  {1428192000, 3600, 54},
  {1441501200, 7200, 54},
  {1459641600, 3600, 54},
  {1472950800, 7200, 54},
  {1491091200, 3600, 54},
  {1504400400, 7200, 54},
  {1522540800, 3600, 54},
  {1535850000, 7200, 54},
  {1554595200, 3600, 54},
  {1567299600, 7200, 54},
  {1586044800, 3600, 54},
  {1599354000, 7200, 54},
  {1617494400, 3600, 54},
  {1630803600, 7200, 54},
  {1648944000, 3600, 54},
  {1662253200, 7200, 54},
  {1680393600, 3600, 54},
  {1693702800, 7200, 54},
  {1712448000, 3600, 54},
  {1725152400, 7200, 54},
  {1743897600, 3600, 54},
  {1757206800, 7200, 54},
  {1775347200, 3600, 54},
  {1788656400, 7200, 54},
  {1806796800, 3600, 54},
  {1820106000, 7200, 54},
  {1838246400, 3600, 54},
  {1851555600, 7200, 54},
  {1869696000, 3600, 54},
  {1883005200, 7200, 54},
  {1901750400, 3600, 54},
  {1914454800, 7200, 54},
  {1933200000, 3600, 54},
  {1946509200, 7200, 54},
  {1964649600, 3600, 54},
  {1977958800, 7200, 54},
  {1996099200, 3600, 54},
  {2009408400, 7200, 54},
  {2027548800, 3600, 54},
  {2040858000, 7200, 54},
  {2058998400, 3600, 54},
  {2072307600, 7200, 54},
  {2091052800, 3600, 54},
  {2104362000, 7200, 54},
  {2122502400, 3600, 54},
  {2135811600, 7200, 54},
  {-880196400, -36000, 55},
  {-769395600, -36000, 55},
  {-765374400, -39600, 55},
  {-86878800, -39600, 55},
  {-21466800, -36000, 55},
  {-5745600, -39600, 55},
  {9982800, -36000, 55},
  {25704000, -39600, 55},
  {41432400, -36000, 55},
  {57758400, -39600, 55},
  {73486800, -36000, 55},
  {89208000, -39600, 55},
  {104936400, -36000, 55},
  {120657600, -39600, 55},
  {126709200, -36000, 55},
  {152107200, -39600, 55},
  {162392400, -36000, 55},
  {183556800, -39600, 55},
  {199285200, -36000, 55},
  {215611200, -39600, 55},
  {230734800, -36000, 55},
  {247060800, -39600, 55},
  {262789200, -36000, 55},
  {278510400, -39600, 55},
  {294238800, -36000, 55},
  {309960000, -39600, 55},
  {325688400, -36000, 55},
  {341409600, -39600, 55},
  {357138000, -36000, 55},
  {372859200, -39600, 55},
  {388587600, -36000, 55},
  {404913600, -39600, 55},
  {420037200, -36000, 55},
  {436363200, -36000, 55},
  {439034400, -36000, 55},
  {452088000, -32400, 55},
  {467809200, -36000, 55},
  {483537600, -32400, 55},
  {499258800, -36000, 55},
  {514987200, -32400, 55},
  {530708400, -36000, 55},
  {544622400, -32400, 55},
  {562158000, -36000, 55},
  {576072000, -32400, 55},
  {594212400, -36000, 55},
  {607521600, -32400, 55},
  {625662000, -36000, 55},
  {638971200, -32400, 55},
  {657111600, -36000, 55},
  {671025600, -32400, 55},
  {688561200, -36000, 55},
  {702475200, -32400, 55},
  {720010800, -36000, 55},
  {733924800, -32400, 55},
  {752065200, -36000, 55},
  {765374400, -32400, 55},
  {783514800, -36000, 55},
  {796824000, -32400, 55},
  {814964400, -36000, 55},
  {828878400, -32400, 55},
  {846414000, -36000, 55},
  {860328000, -32400, 55},
  {877863600, -36000, 55},
  {891777600, -32400, 55},
  {909313200, -36000, 55},
  {923227200, -32400, 55},
  {941367600, -36000, 55},
  {954676800, -32400, 55},
  {972817200, -36000, 55},
  {986126400, -32400, 55},
  {1004266800, -36000, 55},
  {1018180800, -32400, 55},
  {1035716400, -36000, 55},
  {1049630400, -32400, 55},
  {1067166000, -36000, 55},
  {1081080000, -32400, 55},
  {1099220400, -36000, 55},
  {1112529600, -32400, 55},
  {1130670000, -36000, 55},
  {1143979200, -32400, 55},
  {1162119600, -36000, 55},
  {1173614400, -32400, 55},
  {1194174000, -36000, 55},
  {1205064000, -32400, 55},
  {1225623600, -36000, 55},
  {1236513600, -32400, 55},
  {1257073200, -36000, 55},
  {1268568000, -32400, 55},
  {1289127600, -36000, 55},
  {1300017600, -32400, 55},
  {1320577200, -36000, 55},
  {1331467200, -32400, 55},
  {1352026800, -36000, 55},
  {1362916800, -32400, 55},
  {1383476400, -36000, 55},
  {1394366400, -32400, 55},
  {1414926000, -36000, 55},
  {1425816000, -32400, 55},
  {1446375600, -36000, 55},
  {1457870400, -32400, 55},
  {1478430000, -36000, 55},
  {1489320000, -32400, 55},
  {1509879600, -36000, 55},
  {1520769600, -32400, 55},
  {1541329200, -36000, 55},
  {1552219200, -32400, 55},
  {1572778800, -36000, 55},
  {1583668800, -32400, 55},
  {1604228400, -36000, 55},
  {1615723200, -32400, 55},
  {1636282800, -36000, 55},
  {1647172800, -32400, 55},
  {1667732400, -36000, 55},
  {1678622400, -32400, 55},
  {1699182000, -36000, 55},
  {1710072000, -32400, 55},
  {1730631600, -36000, 55},
  {1741521600, -32400, 55},
  {1762081200, -36000, 55},
  {1772971200, -32400, 55},
  {1793530800, -36000, 55},
  {1805025600, -32400, 55},
  {1825585200, -36000, 55},
  {1836475200, -32400, 55},
  {1857034800, -36000, 55},
  {1867924800, -32400, 55},
  {1888484400, -36000, 55},
  {1899374400, -32400, 55},
  {1919934000, -36000, 55},
  {1930824000, -32400, 55},
  {1951383600, -36000, 55},
  {1962878400, -32400, 55},
  {1983438000, -36000, 55},
  {1994328000, -32400, 55},
  {2014887600, -36000, 55},
  {2025777600, -32400, 55},
  {2046337200, -36000, 55},
  {2057227200, -32400, 55},
  {2077786800, -36000, 55},
  {2088676800, -32400, 55},
  {2109236400, -36000, 55},
  {2120126400, -32400, 55},
  {2140686000, -36000, 55},
  {-880200000, -32400, 56},
  {-769395600, -32400, 56},
  {-765378000, -36000, 56},
  {-86882400, -36000, 56},
  {-21470400, -32400, 56},
  {-5749200, -36000, 56},
  {9979200, -32400, 56},
  {25700400, -36000, 56},
  {41428800, -32400, 56},
  {57754800, -36000, 56},
  {73483200, -32400, 56},
  {89204400, -36000, 56},
  {104932800, -32400, 56},
  {120654000, -36000, 56},
  {126705600, -32400, 56},
  {152103600, -36000, 56},
  {162388800, -32400, 56},
  {183553200, -36000, 56},
  {199281600, -32400, 56},
  {215607600, -36000, 56},
  {230731200, -32400, 56},
  {247057200, -36000, 56},
  {262785600, -32400, 56},
  {278506800, -36000, 56},
  {294235200, -32400, 56},
  {309956400, -36000, 56},
  {325684800, -32400, 56},
  {341406000, -36000, 56},
  {357134400, -32400, 56},
  {372855600, -36000, 56},
  {388584000, -32400, 56},
  {404910000, -36000, 56},
  {420033600, -32400, 56},
  {436359600, -32400, 56},
  {439030800, -32400, 56},
  {452084400, -28800, 56},
  {467805600, -32400, 56},
  {483534000, -28800, 56},
  {499255200, -32400, 56},
  {514983600, -28800, 56},
  {530704800, -32400, 56},
  {544618800, -28800, 56},
  {562154400, -32400, 56},
  {576068400, -28800, 56},
  {594208800, -32400, 56},
  {607518000, -28800, 56},
  {625658400, -32400, 56},
  {638967600, -28800, 56},
  {657108000, -32400, 56},
  {671022000, -28800, 56},
  {688557600, -32400, 56},
  {702471600, -28800, 56},
  {720007200, -32400, 56},
  {733921200, -28800, 56},
  {752061600, -32400, 56},
  {765370800, -28800, 56},
  {783511200, -32400, 56},
  {796820400, -28800, 56},
  {814960800, -32400, 56},
  {828874800, -28800, 56},
  {846410400, -32400, 56},
  {860324400, -28800, 56},
  {877860000, -32400, 56},
  {891774000, -28800, 56},
  {909309600, -32400, 56},
  {923223600, -28800, 56},
  {941364000, -32400, 56},
  {954673200, -28800, 56},
  {972813600, -32400, 56},
  {986122800, -28800, 56},
  {1004263200, -32400, 56},
  {1018177200, -28800, 56},
  {1035712800, -32400, 56},
  {1049626800, -28800, 56},
  {1067162400, -32400, 56},
  {1081076400, -28800, 56},
  {1099216800, -32400, 56},
  {1112526000, -28800, 56},
  {1130666400, -32400, 56},
  {1143975600, -28800, 56},
  {1162116000, -32400, 56},
  {1173610800, -28800, 56},
  {1194170400, -32400, 56},
  {1205060400, -28800, 56},
  {1225620000, -32400, 56},
  {1236510000, -28800, 56},
  {1257069600, -32400, 56},
  {1268564400, -28800, 56},
  {1289124000, -32400, 56},
  {1300014000, -28800, 56},
  {1320573600, -32400, 56},
  {1331463600, -28800, 56},
  {1352023200, -32400, 56},
  {1362913200, -28800, 56},
  {1383472800, -32400, 56},
  {1394362800, -28800, 56},
  {1414922400, -32400, 56},
  {1425812400, -28800, 56},
  {1446372000, -32400, 56},
  {1457866800, -28800, 56},
  {1478426400, -32400, 56},
  {1489316400, -28800, 56},
  {1509876000, -32400, 56},
  {1520766000, -28800, 56},
  {1541325600, -32400, 56},
  {1552215600, -28800, 56},
  {1572775200, -32400, 56},
  {1583665200, -28800, 56},
  {1604224800, -32400, 56},
  {1615719600, -28800, 56},
  {1636279200, -32400, 56},
  {1647169200, -28800, 56},
  {1667728800, -32400, 56},
  {1678618800, -28800, 56},
  {1699178400, -32400, 56},
  {1710068400, -28800, 56},
  {1730628000, -32400, 56},
  {1741518000, -28800, 56},
  {1762077600, -32400, 56},
  {1772967600, -28800, 56},
  {1793527200, -32400, 56},
  {1805022000, -28800, 56},
  {1825581600, -32400, 56},
  {1836471600, -28800, 56},
  {1857031200, -32400, 56},
  {1867921200, -28800, 56},
  {1888480800, -32400, 56},
  {1899370800, -28800, 56},
  {1919930400, -32400, 56},
  {1930820400, -28800, 56},
  {1951380000, -32400, 56},
  {1962874800, -28800, 56},
  {1983434400, -32400, 56},
  {1994324400, -28800, 56},
  {2014884000, -32400, 56},
  {2025774000, -28800, 56},
  {2046333600, -32400, 56},
  {2057223600, -28800, 56},
  {2077783200, -32400, 56},
  {2088673200, -28800, 56},
  {2109232800, -32400, 56},
  {2120122800, -28800, 56},
  {2140682400, -32400, 56},
  {INT64_MIN, -15136, 57},
  {-1825098464, -14400, 57},
  {INT64_MIN, -14832, 58},
  {-1825098768, -18000, 58},
  {-599598000, -14400, 58},
  {INT64_MIN, -11568, 59},
  {-1767214032, -10800, 59},
  {-1206957600, -7200, 59},
  {-1191362400, -10800, 59},
  {-1175374800, -7200, 59},
  {-1159826400, -10800, 59},
  {-633819600, -7200, 59},
  {-622069200, -10800, 59},
  {-602283600, -7200, 59},
  {-591832800, -10800, 59},
  {-570747600, -7200, 59},
  {-560210400, -10800, 59},
  {-539125200, -7200, 59},
  {-531352800, -10800, 59},
  {-191365200, -7200, 59},
  {-184197600, -10800, 59},
  {-155163600, -7200, 59},
  {-150069600, -10800, 59},
  {-128898000, -7200, 59},
  {-121125600, -10800, 59},
  {-99954000, -7200, 59},
  {-89589600, -10800, 59},
  {-68418000, -7200, 59},
  {-57967200, -10800, 59},
  {499748400, -7200, 59},
  {511236000, -10800, 59},
  {530593200, -7200, 59},
  {540266400, -10800, 59},
  {562129200, -7200, 59},
  {571197600, -10800, 59},
  {592974000, -7200, 59},
  {602042400, -10800, 59},
  {624423600, -7200, 59},
  {634701600, -10800, 59},
  {813726000, -7200, 59},
  {824004000, -10800, 59},
  {844570800, -7200, 59},
  {856058400, -10800, 59},
  {876106800, -7200, 59},
  {888717600, -10800, 59},
  {908074800, -7200, 59},
  {919562400, -10800, 59},
  {938919600, -7200, 59},
  {951616800, -10800, 59},
  {970974000, -7200, 59},
  {982461600, -10800, 59},
  {1003028400, -7200, 59},
  {1013911200, -10800, 59},
  {1036292400, -7200, 59},
  {1045360800, -10800, 59},
  {INT64_MIN, -15408, 60},
  {-1567453392, -14400, 60},
  {-1233432000, -10800, 60},
  {-1222981200, -14400, 60},
  {-1205956800, -10800, 60},
  {-1194037200, -14400, 60},
  {-1172865600, -10800, 60},
  {-1162501200, -14400, 60},
  {-1141329600, -10800, 60},
  {-1130965200, -14400, 60},
  {-1109793600, -10800, 60},
  {-1099429200, -14400, 60},
  {-1078257600, -10800, 60},
  {-1067806800, -14400, 60},
  {-1046635200, -10800, 60},
  {-1036270800, -14400, 60},
  {-1015099200, -10800, 60},
  {-1004734800, -14400, 60},
  {-983563200, -10800, 60},
  {-973198800, -14400, 60},
  {-952027200, -10800, 60},
  {-941576400, -14400, 60},
  {-931032000, -10800, 60},
  {-900882000, -14400, 60},
  {-890337600, -10800, 60},
  {-833749200, -14400, 60},
  {-827265600, -10800, 60},
  {-752274000, -14400, 60},
  {-733780800, -10800, 60},
  {-197326800, -14400, 60},
  {-190843200, -10800, 60},
  {-184194000, -14400, 60},
  {-164491200, -10800, 60},
  {-152658000, -14400, 60},
  {-132955200, -10800, 60},
  {-121122000, -14400, 60},
  {-101419200, -10800, 60},
  {-86821200, -14400, 60},
  {-71092800, -10800, 60},
  {-54766800, -14400, 60},
  {-39038400, -10800, 60},
  {-23317200, -14400, 60},
  {-7588800, -10800, 60},
  {128142000, -7200, 60},
  {136605600, -10800, 60},
  {596948400, -7200, 60},
  {605066400, -10800, 60},
  {624423600, -7200, 60},
  {636516000, -10800, 60},
  {656478000, -7200, 60},
  {667965600, -10800, 60},
  {687927600, -7200, 60},
  {699415200, -10800, 60},
  {719377200, -7200, 60},
  {731469600, -10800, 60},
  {938919600, -10800, 60},
  {952052400, -10800, 60},
  {1198983600, -7200, 60},
  {1205632800, -10800, 60},
  {1224385200, -7200, 60},
  {1237082400, -10800, 60},
  {INT64_MIN, -15408, 61},
  {-1567453392, -14400, 61},
  {-1233432000, -10800, 61},
  {-1222981200, -14400, 61},
  {-1205956800, -10800, 61},
  {-1194037200, -14400, 61},
  {-1172865600, -10800, 61},
  {-1162501200, -14400, 61},
  {-1141329600, -10800, 61},
  {-1130965200, -14400, 61},
  {-1109793600, -10800, 61},
  {-1099429200, -14400, 61},
  {-1078257600, -10800, 61},
  {-1067806800, -14400, 61},
  {-1046635200, -10800, 61},
  {-1036270800, -14400, 61},
  {-1015099200, -10800, 61},
  {-1004734800, -14400, 61},
  {-983563200, -10800, 61},
  {-973198800, -14400, 61},
  {-952027200, -10800, 61},
  {-941576400, -14400, 61},
  {-931032000, -10800, 61},
  {-900882000, -14400, 61},
  {-890337600, -10800, 61},
  {-833749200, -14400, 61},
  {-827265600, -10800, 61},
  {-752274000, -14400, 61},
  {-733780800, -10800, 61},
  {-197326800, -14400, 61},
  {-190843200, -10800, 61},
  {-184194000, -14400, 61},
  {-164491200, -10800, 61},
  {-152658000, -14400, 61},
  {-132955200, -10800, 61},
  {-121122000, -14400, 61},
  {-101419200, -10800, 61},
  {-86821200, -14400, 61},
  {-71092800, -10800, 61},
  {-54766800, -14400, 61},
  {-39038400, -10800, 61},
  {-23317200, -14400, 61},
  {-7588800, -10800, 61},
  {128142000, -7200, 61},
  {136605600, -10800, 61},
  {596948400, -7200, 61},
  {605066400, -10800, 61},
  {624423600, -7200, 61},
  {636516000, -10800, 61},
  {656478000, -7200, 61},
  {667965600, -14400, 61},
  {687931200, -7200, 61},
  {699415200, -10800, 61},
  {719377200, -7200, 61},
  {731469600, -10800, 61},
  {938919600, -10800, 61},
  {952052400, -10800, 61},
  {1086058800, -14400, 61},
  {1087704000, -10800, 61},
  {1198983600, -7200, 61},
  {1205632800, -10800, 61},
  {INT64_MIN, -15408, 62},
  {-1567453392, -14400, 62},
  {-1233432000, -10800, 62},
  {-1222981200, -14400, 62},
  {-1205956800, -10800, 62},
  {-1194037200, -14400, 62},
  {-1172865600, -10800, 62},
  {-1162501200, -14400, 62},
  {-1141329600, -10800, 62},
  {-1130965200, -14400, 62},
  {-1109793600, -10800, 62},
  {-1099429200, -14400, 62},
  {-1078257600, -10800, 62},
  {-1067806800, -14400, 62},
  {-1046635200, -10800, 62},
  {-1036270800, -14400, 62},
  {-1015099200, -10800, 62},
  {-1004734800, -14400, 62},
  {-983563200, -10800, 62},
  {-973198800, -14400, 62},
  {-952027200, -10800, 62},
  {-941576400, -14400, 62},
  {-931032000, -10800, 62},
  {-900882000, -14400, 62},
  {-890337600, -10800, 62},
  {-833749200, -14400, 62},
  {-827265600, -10800, 62},
  {-752274000, -14400, 62},
  {-733780800, -10800, 62},
  {-197326800, -14400, 62},
  {-190843200, -10800, 62},
  {-184194000, -14400, 62},
  {-164491200, -10800, 62},
  {-152658000, -14400, 62},
  {-132955200, -10800, 62},
  {-121122000, -14400, 62},
  {-101419200, -10800, 62},
  {-86821200, -14400, 62},
  {-71092800, -10800, 62},
  {-54766800, -14400, 62},
  {-39038400, -10800, 62},
  {-23317200, -14400, 62},
  {-7588800, -10800, 62},
  {128142000, -7200, 62},
  {136605600, -10800, 62},
  {596948400, -7200, 62},
  {605066400, -10800, 62},
  {624423600, -7200, 62},
  {636516000, -10800, 62},
  {656478000, -7200, 62},
  {667965600, -14400, 62},
  {687931200, -7200, 62},
  {699415200, -10800, 62},
  {719377200, -7200, 62},
  {731469600, -10800, 62},
  {938919600, -10800, 62},
  {952052400, -10800, 62},
  {1086058800, -14400, 62},
  {1087704000, -10800, 62},
  {1198983600, -7200, 62},
  {1205632800, -10800, 62},
  {INT64_MIN, -15408, 63},
  {-1567453392, -14400, 63},
  {-1233432000, -10800, 63},
  {-1222981200, -14400, 63},
  {-1205956800, -10800, 63},
  {-1194037200, -14400, 63},
  {-1172865600, -10800, 63},
  {-1162501200, -14400, 63},
  {-1141329600, -10800, 63},
  {-1130965200, -14400, 63},
  {-1109793600, -10800, 63},
  {-1099429200, -14400, 63},
  {-1078257600, -10800, 63},
  {-1067806800, -14400, 63},
  {-1046635200, -10800, 63},
  {-1036270800, -14400, 63},
  {-1015099200, -10800, 63},
  {-1004734800, -14400, 63},
  {-983563200, -10800, 63},
  {-973198800, -14400, 63},
  {-952027200, -10800, 63},
  {-941576400, -14400, 63},
  {-931032000, -10800, 63},
  {-900882000, -14400, 63},
  {-890337600, -10800, 63},
  {-833749200, -14400, 63},
  {-827265600, -10800, 63},
  {-752274000, -14400, 63},
  {-733780800, -10800, 63},
  {-197326800, -14400, 63},
  {-190843200, -10800, 63},
  {-184194000, -14400, 63},
  {-164491200, -10800, 63},
  {-152658000, -14400, 63},
  {-132955200, -10800, 63},
  {-121122000, -14400, 63},
  {-101419200, -10800, 63},
  {-86821200, -14400, 63},
  {-71092800, -10800, 63},
  {-54766800, -14400, 63},
  {-39038400, -10800, 63},
  {-23317200, -14400, 63},
  {-7588800, -10800, 63},
  {128142000, -7200, 63},
  {136605600, -10800, 63},
  {596948400, -7200, 63},
  {605066400, -10800, 63},
  {624423600, -7200, 63},
  {636516000, -10800, 63},
  {656478000, -7200, 63},
  {667965600, -14400, 63},
  {687931200, -7200, 63},
  {699415200, -10800, 63},
  {719377200, -7200, 63},
  {731469600, -10800, 63},
  {938919600, -10800, 63},
  {952052400, -10800, 63},
  {1198983600, -7200, 63},
  {1205632800, -10800, 63},
  {1224385200, -7200, 63},
  {1237082400, -10800, 63},
  {INT64_MIN, -15408, 64},
  {-1567453392, -14400, 64},
  {-1233432000, -10800, 64},
  {-1222981200, -14400, 64},
  {-1205956800, -10800, 64},
  {-1194037200, -14400, 64},
  {-1172865600, -10800, 64},
  {-1162501200, -14400, 64},
  {-1141329600, -10800, 64},
  {-1130965200, -14400, 64},
  {-1109793600, -10800, 64},
  {-1099429200, -14400, 64},
  {-1078257600, -10800, 64},
  {-1067806800, -14400, 64},
  {-1046635200, -10800, 64},
  {-1036270800, -14400, 64},
  {-1015099200, -10800, 64},
  {-1004734800, -14400, 64},
  {-983563200, -10800, 64},
  {-973198800, -14400, 64},
  {-952027200, -10800, 64},
  {-941576400, -14400, 64},
  {-931032000, -10800, 64},
  {-900882000, -14400, 64},
  {-890337600, -10800, 64},
  {-833749200, -14400, 64},
  {-827265600, -10800, 64},
  {-752274000, -14400, 64},
  {-733780800, -10800, 64},
  {-197326800, -14400, 64},
  {-190843200, -10800, 64},
  {-184194000, -14400, 64},
  {-164491200, -10800, 64},
  {-152658000, -14400, 64},
  {-132955200, -10800, 64},
  {-121122000, -14400, 64},
  {-101419200, -10800, 64},
  {-86821200, -14400, 64},
  {-71092800, -10800, 64},
  {-54766800, -14400, 64},
  {-39038400, -10800, 64},
  {-23317200, -14400, 64},
  {-7588800, -10800, 64},
  {128142000, -7200, 64},
  {136605600, -10800, 64},
  {596948400, -7200, 64},
  {605066400, -10800, 64},
  {624423600, -7200, 64},
  {636516000, -14400, 64},
  {657086400, -10800, 64},
  {669178800, -14400, 64},
  {686721600, -7200, 64},
  {699415200, -10800, 64},
  {719377200, -7200, 64},
  {731469600, -10800, 64},
  {938919600, -10800, 64},
  {952052400, -10800, 64},
  {1198983600, -7200, 64},
  {1205632800, -10800, 64},
  {INT64_MIN, -15408, 65},
  {-1567453392, -14400, 65},
  {-1233432000, -10800, 65},
  {-1222981200, -14400, 65},
  {-1205956800, -10800, 65},
  {-1194037200, -14400, 65},
  {-1172865600, -10800, 65},
  {-1162501200, -14400, 65},
  {-1141329600, -10800, 65},
  {-1130965200, -14400, 65},
  {-1109793600, -10800, 65},
  {-1099429200, -14400, 65},
  {-1078257600, -10800, 65},
  {-1067806800, -14400, 65},
  {-1046635200, -10800, 65},
  {-1036270800, -14400, 65},
  {-1015099200, -10800, 65},
  {-1004734800, -14400, 65},
  {-983563200, -10800, 65},
  {-973198800, -14400, 65},
  {-952027200, -10800, 65},
  {-941576400, -14400, 65},
  {-931032000, -10800, 65},
  {-900882000, -14400, 65},
  {-890337600, -10800, 65},
  {-833749200, -14400, 65},
  {-827265600, -10800, 65},
  {-752274000, -14400, 65},
  {-733780800, -10800, 65},
  {-197326800, -14400, 65},
  {-190843200, -10800, 65},
  {-184194000, -14400, 65},
  {-164491200, -10800, 65},
  {-152658000, -14400, 65},
  {-132955200, -10800, 65},
  {-121122000, -14400, 65},
  {-101419200, -10800, 65},
  {-86821200, -14400, 65},
  {-71092800, -10800, 65},
  {-54766800, -14400, 65},
  {-39038400, -10800, 65},
  {-23317200, -14400, 65},
  {-7588800, -10800, 65},
  {128142000, -7200, 65},
  {136605600, -10800, 65},
  {596948400, -7200, 65},
  {605066400, -10800, 65},
  {624423600, -7200, 65},
  {636516000, -10800, 65},
  {656478000, -7200, 65},
  {667792800, -14400, 65},
  {673588800, -10800, 65},
  {687927600, -7200, 65},
  {699415200, -10800, 65},
  {719377200, -7200, 65},
  {731469600, -10800, 65},
  {938919600, -10800, 65},
  {952052400, -10800, 65},
  {1086058800, -14400, 65},
  {1087704000, -10800, 65},
  {1198983600, -7200, 65},
  {1205632800, -10800, 65},
  {INT64_MIN, -15408, 66},
  {-1567453392, -14400, 66},
  {-1233432000, -10800, 66},
  {-1222981200, -14400, 66},
  {-1205956800, -10800, 66},
  {-1194037200, -14400, 66},
  {-1172865600, -10800, 66},
  {-1162501200, -14400, 66},
  {-1141329600, -10800, 66},
  {-1130965200, -14400, 66},
  {-1109793600, -10800, 66},
  {-1099429200, -14400, 66},
  {-1078257600, -10800, 66},
  {-1067806800, -14400, 66},
  {-1046635200, -10800, 66},
  {-1036270800, -14400, 66},
  {-1015099200, -10800, 66},
  {-1004734800, -14400, 66},
  {-983563200, -10800, 66},
  {-973198800, -14400, 66},
  {-952027200, -10800, 66},
  {-941576400, -14400, 66},
  {-931032000, -10800, 66},
  {-900882000, -14400, 66},
  {-890337600, -10800, 66},
  {-833749200, -14400, 66},
  {-827265600, -10800, 66},
  {-752274000, -14400, 66},
  {-733780800, -10800, 66},
  {-197326800, -14400, 66},
  {-190843200, -10800, 66},
  {-184194000, -14400, 66},
  {-164491200, -10800, 66},
  {-152658000, -14400, 66},
  {-132955200, -10800, 66},
  {-121122000, -14400, 66},
  {-101419200, -10800, 66},
  {-86821200, -14400, 66},
  {-71092800, -10800, 66},
  {-54766800, -14400, 66},
  {-39038400, -10800, 66},
  {-23317200, -14400, 66},
  {-7588800, -10800, 66},
  {128142000, -7200, 66},
  {136605600, -10800, 66},
  {596948400, -7200, 66},
  {605066400, -10800, 66},
  {624423600, -7200, 66},
  {636516000, -14400, 66},
  {655963200, -10800, 66},
  {667796400, -14400, 66},
  {687499200, -10800, 66},
  {699418800, -14400, 66},
  {719380800, -7200, 66},
  {731469600, -10800, 66},
  {938919600, -10800, 66},
  {952052400, -10800, 66},
  {1085281200, -14400, 66},
  {1096171200, -10800, 66},
  {1198983600, -7200, 66},
  {1205632800, -10800, 66},
  {INT64_MIN, -15408, 67},
  {-1567453392, -14400, 67},
  {-1233432000, -10800, 67},
  {-1222981200, -14400, 67},
  {-1205956800, -10800, 67},
  {-1194037200, -14400, 67},
  {-1172865600, -10800, 67},
  {-1162501200, -14400, 67},
  {-1141329600, -10800, 67},
  {-1130965200, -14400, 67},
  {-1109793600, -10800, 67},
  {-1099429200, -14400, 67},
  {-1078257600, -10800, 67},
  {-1067806800, -14400, 67},
  {-1046635200, -10800, 67},
  {-1036270800, -14400, 67},
  {-1015099200, -10800, 67},
  {-1004734800, -14400, 67},
  {-983563200, -10800, 67},
  {-973198800, -14400, 67},
  {-952027200, -10800, 67},
  {-941576400, -14400, 67},
  {-931032000, -10800, 67},
  {-900882000, -14400, 67},
  {-890337600, -10800, 67},
  {-833749200, -14400, 67},
  {-827265600, -10800, 67},
  {-752274000, -14400, 67},
  {-733780800, -10800, 67},
  {-197326800, -14400, 67},
  {-190843200, -10800, 67},
  {-184194000, -14400, 67},
  {-164491200, -10800, 67},
  {-152658000, -14400, 67},
  {-132955200, -10800, 67},
  {-121122000, -14400, 67},
  {-101419200, -10800, 67},
  {-86821200, -14400, 67},
  {-71092800, -10800, 67},
  {-54766800, -14400, 67},
  {-39038400, -10800, 67},
  {-23317200, -14400, 67},
  {-7588800, -10800, 67},
  {128142000, -7200, 67},
  {136605600, -10800, 67},
  {596948400, -7200, 67},
  {605066400, -10800, 67},
  {624423600, -7200, 67},
  {636516000, -10800, 67},
  {656478000, -7200, 67},
  {667965600, -10800, 67},
  {687927600, -7200, 67},
  {699415200, -10800, 67},
  {719377200, -7200, 67},
  {731469600, -10800, 67},
  {938919600, -10800, 67},
  {952052400, -10800, 67},
  {1086058800, -14400, 67},
  {1087704000, -10800, 67},
  {1198983600, -7200, 67},
  {1205632800, -10800, 67},
  {INT64_MIN, -15408, 68},
  {-1567453392, -14400, 68},
  {-1233432000, -10800, 68},
  {-1222981200, -14400, 68},
  {-1205956800, -10800, 68},
  {-1194037200, -14400, 68},
  {-1172865600, -10800, 68},
  {-1162501200, -14400, 68},
  {-1141329600, -10800, 68},
  {-1130965200, -14400, 68},
  {-1109793600, -10800, 68},
  {-1099429200, -14400, 68},
  {-1078257600, -10800, 68},
  {-1067806800, -14400, 68},
  {-1046635200, -10800, 68},
  {-1036270800, -14400, 68},
  {-1015099200, -10800, 68},
  {-1004734800, -14400, 68},
  {-983563200, -10800, 68},
  {-973198800, -14400, 68},
  {-952027200, -10800, 68},
  {-941576400, -14400, 68},
  {-931032000, -10800, 68},
  {-900882000, -14400, 68},
  {-890337600, -10800, 68},
  {-833749200, -14400, 68},
  {-827265600, -10800, 68},
  {-752274000, -14400, 68},
  {-733780800, -10800, 68},
  {-197326800, -14400, 68},
  {-190843200, -10800, 68},
  {-184194000, -14400, 68},
  {-164491200, -10800, 68},
  {-152658000, -14400, 68},
  {-132955200, -10800, 68},
  {-121122000, -14400, 68},
  {-101419200, -10800, 68},
  {-86821200, -14400, 68},
  {-71092800, -10800, 68},
  {-54766800, -14400, 68},
  {-39038400, -10800, 68},
  {-23317200, -14400, 68},
  {-7588800, -10800, 68},
  {128142000, -7200, 68},
  {136605600, -10800, 68},
  {596948400, -7200, 68},
  {605066400, -10800, 68},
  {624423600, -7200, 68},
  {636516000, -10800, 68},
  {656478000, -7200, 68},
  {667965600, -14400, 68},
  {687931200, -7200, 68},
  {699415200, -10800, 68},
  {719377200, -7200, 68},
  {731469600, -10800, 68},
  {938919600, -10800, 68},
  {952052400, -10800, 68},
  {1198983600, -7200, 68},
  {1205632800, -10800, 68},
  {INT64_MIN, -15408, 69},
  {-1567453392, -14400, 69},
  {-1233432000, -10800, 69},
  {-1222981200, -14400, 69},
  {-1205956800, -10800, 69},
  {-1194037200, -14400, 69},
  {-1172865600, -10800, 69},
  {-1162501200, -14400, 69},
  {-1141329600, -10800, 69},
  {-1130965200, -14400, 69},
  {-1109793600, -10800, 69},
  {-1099429200, -14400, 69},
  {-1078257600, -10800, 69},
  {-1067806800, -14400, 69},
  {-1046635200, -10800, 69},
  {-1036270800, -14400, 69},
  {-1015099200, -10800, 69},
  {-1004734800, -14400, 69},
  {-983563200, -10800, 69},
  {-973198800, -14400, 69},
  {-952027200, -10800, 69},
  {-941576400, -14400, 69},
  {-931032000, -10800, 69},
  {-900882000, -14400, 69},
  {-890337600, -10800, 69},
  {-833749200, -14400, 69},
  {-827265600, -10800, 69},
  {-752274000, -14400, 69},
  {-733780800, -10800, 69},
  {-197326800, -14400, 69},
  {-190843200, -10800, 69},
  {-184194000, -14400, 69},
  {-164491200, -10800, 69},
  {-152658000, -14400, 69},
  {-132955200, -10800, 69},
  {-121122000, -14400, 69},
  {-101419200, -10800, 69},
  {-86821200, -14400, 69},
  {-71092800, -10800, 69},
  {-54766800, -14400, 69},
  {-39038400, -10800, 69},
  {-23317200, -14400, 69},
  {-7588800, -10800, 69},
  {128142000, -7200, 69},
  {136605600, -10800, 69},
  {596948400, -7200, 69},
  {605066400, -10800, 69},
  {624423600, -7200, 69},
  {636516000, -10800, 69},
  {656478000, -7200, 69},
  {667792800, -14400, 69},
  {673588800, -10800, 69},
  {687927600, -7200, 69},
  {699415200, -10800, 69},
  {719377200, -7200, 69},
  {731469600, -10800, 69},
  {938919600, -10800, 69},
  {952052400, -10800, 69},
  {1085972400, -14400, 69},
  {1090728000, -10800, 69},
  {1198983600, -7200, 69},
  {1205632800, -10800, 69},
  {INT64_MIN, -15408, 70},
  {-1567453392, -14400, 70},
  {-1233432000, -10800, 70},
  {-1222981200, -14400, 70},
  {-1205956800, -10800, 70},
  {-1194037200, -14400, 70},
  {-1172865600, -10800, 70},
  {-1162501200, -14400, 70},
  {-1141329600, -10800, 70},
  {-1130965200, -14400, 70},
  {-1109793600, -10800, 70},
  {-1099429200, -14400, 70},
  {-1078257600, -10800, 70},
  {-1067806800, -14400, 70},
  {-1046635200, -10800, 70},
  {-1036270800, -14400, 70},
  {-1015099200, -10800, 70},
  {-1004734800, -14400, 70},
  {-983563200, -10800, 70},
  {-973198800, -14400, 70},
  {-952027200, -10800, 70},
  {-941576400, -14400, 70},
  {-931032000, -10800, 70},
  {-900882000, -14400, 70},
  {-890337600, -10800, 70},
  {-833749200, -14400, 70},
  {-827265600, -10800, 70},
  {-752274000, -14400, 70},
  {-733780800, -10800, 70},
  {-197326800, -14400, 70},
  {-190843200, -10800, 70},
  {-184194000, -14400, 70},
  {-164491200, -10800, 70},
  {-152658000, -14400, 70},
  {-132955200, -10800, 70},
  {-121122000, -14400, 70},
  {-101419200, -10800, 70},
  {-86821200, -14400, 70},
  {-71092800, -10800, 70},
  {-54766800, -14400, 70},
  {-39038400, -10800, 70},
  {-23317200, -14400, 70},
  {-7588800, -10800, 70},
  {128142000, -7200, 70},
  {136605600, -10800, 70},
  {596948400, -7200, 70},
  {605066400, -10800, 70},
  {624423600, -7200, 70},
  {637380000, -14400, 70},
  {655963200, -10800, 70},
  {667796400, -14400, 70},
  {675748800, -10800, 70},
  {938919600, -10800, 70},
  {952052400, -10800, 70},
  {1085972400, -14400, 70},
  {1090728000, -10800, 70},
  {1198983600, -7200, 70},
  {1200880800, -10800, 70},
  {1205031600, -14400, 70},
  {1223784000, -10800, 70},
  {1236481200, -14400, 70},
  {1255233600, -10800, 70},
  {INT64_MIN, -15408, 71},
  {-1567453392, -14400, 71},
  {-1233432000, -10800, 71},
  {-1222981200, -14400, 71},
  {-1205956800, -10800, 71},
  {-1194037200, -14400, 71},
  {-1172865600, -10800, 71},
  {-1162501200, -14400, 71},
  {-1141329600, -10800, 71},
  {-1130965200, -14400, 71},
  {-1109793600, -10800, 71},
  {-1099429200, -14400, 71},
  {-1078257600, -10800, 71},
  {-1067806800, -14400, 71},
  {-1046635200, -10800, 71},
  {-1036270800, -14400, 71},
  {-1015099200, -10800, 71},
  {-1004734800, -14400, 71},
  {-983563200, -10800, 71},
  {-973198800, -14400, 71},
  {-952027200, -10800, 71},
  {-941576400, -14400, 71},
  {-931032000, -10800, 71},
  {-900882000, -14400, 71},
  {-890337600, -10800, 71},
  {-833749200, -14400, 71},
  {-827265600, -10800, 71},
  {-752274000, -14400, 71},
  {-733780800, -10800, 71},
  {-197326800, -14400, 71},
  {-190843200, -10800, 71},
  {-184194000, -14400, 71},
  {-164491200, -10800, 71},
  {-152658000, -14400, 71},
  {-132955200, -10800, 71},
  {-121122000, -14400, 71},
  {-101419200, -10800, 71},
  {-86821200, -14400, 71},
  {-71092800, -10800, 71},
  {-54766800, -14400, 71},
  {-39038400, -10800, 71},
  {-23317200, -14400, 71},
  {-7588800, -10800, 71},
  {128142000, -7200, 71},
  {136605600, -10800, 71},
  {596948400, -7200, 71},
  {605066400, -10800, 71},
  {624423600, -7200, 71},
  {636516000, -10800, 71},
  {656478000, -7200, 71},
  {667965600, -14400, 71},
  {687931200, -7200, 71},
  {699415200, -10800, 71},
  {719377200, -7200, 71},
  {731469600, -10800, 71},
  {938919600, -10800, 71},
  {952052400, -10800, 71},
  {1086058800, -14400, 71},
  {1087099200, -10800, 71},
  {1198983600, -7200, 71},
  {1205632800, -10800, 71},
  {1224385200, -7200, 71},
  {1237082400, -10800, 71},
  {INT64_MIN, -15408, 72},
  {-1567453392, -14400, 72},
  {-1233432000, -10800, 72},
  {-1222981200, -14400, 72},
  {-1205956800, -10800, 72},
  {-1194037200, -14400, 72},
  {-1172865600, -10800, 72},
  {-1162501200, -14400, 72},
  {-1141329600, -10800, 72},
  {-1130965200, -14400, 72},
  {-1109793600, -10800, 72},
  {-1099429200, -14400, 72},
  {-1078257600, -10800, 72},
  {-1067806800, -14400, 72},
  {-1046635200, -10800, 72},
  {-1036270800, -14400, 72},
  {-1015099200, -10800, 72},
  {-1004734800, -14400, 72},
  {-983563200, -10800, 72},
  {-973198800, -14400, 72},
  {-952027200, -10800, 72},
  {-941576400, -14400, 72},
  {-931032000, -10800, 72},
  {-900882000, -14400, 72},
  {-890337600, -10800, 72},
  {-833749200, -14400, 72},
  {-827265600, -10800, 72},
  {-752274000, -14400, 72},
  {-733780800, -10800, 72},
  {-197326800, -14400, 72},
  {-190843200, -10800, 72},
  {-184194000, -14400, 72},
  {-164491200, -10800, 72},
  {-152658000, -14400, 72},
  {-132955200, -10800, 72},
  {-121122000, -14400, 72},
  {-101419200, -10800, 72},
  {-86821200, -14400, 72},
  {-71092800, -10800, 72},
  {-54766800, -14400, 72},
  {-39038400, -10800, 72},
  {-23317200, -14400, 72},
  {-7588800, -10800, 72},
  {128142000, -7200, 72},
  {136605600, -10800, 72},
  {596948400, -7200, 72},
  {605066400, -10800, 72},
  {624423600, -7200, 72},
  {636516000, -10800, 72},
  {656478000, -7200, 72},
  {667965600, -10800, 72},
  {687927600, -7200, 72},
  {699415200, -10800, 72},
  {719377200, -7200, 72},
  {731469600, -10800, 72},
  {938919600, -10800, 72},
  {952052400, -10800, 72},
  {1085886000, -14400, 72},
  {1087704000, -10800, 72},
  {1198983600, -7200, 72},
  {1205632800, -10800, 72},
  {INT64_MIN, -16824, 73},
  {-1826738376, -16200, 73},
  {-157750200, -14400, 73},
  {INT64_MIN, -13840, 74},
  {-1206389360, -14400, 74},
  {86760000, -10800, 74},
  {134017200, -14400, 74},
  {181368000, -10800, 74},
  {194497200, -14400, 74},
  {212990400, -10800, 74},
  {226033200, -14400, 74},
  {244526400, -10800, 74},
  {257569200, -14400, 74},
  {276062400, -10800, 74},
  {291783600, -14400, 74},
  {307598400, -10800, 74},
  {323406000, -14400, 74},
  {339220800, -10800, 74},
  {354942000, -14400, 74},
  {370756800, -10800, 74},
  {386478000, -14400, 74},
  {402292800, -10800, 74},
  {418014000, -14400, 74},
  {433828800, -10800, 74},
  {449636400, -14400, 74},
  {465451200, -10800, 74},
  {481172400, -14400, 74},
  {496987200, -10800, 74},
  {512708400, -14400, 74},
  {528523200, -10800, 74},
  {544244400, -14400, 74},
  {560059200, -10800, 74},
  {575866800, -14400, 74},
  {591681600, -10800, 74},
  {607402800, -14400, 74},
  {625032000, -10800, 74},
  {638938800, -14400, 74},
  {654753600, -10800, 74},
  {670474800, -14400, 74},
  {686721600, -10800, 74},
  {699418800, -14400, 74},
  {718257600, -10800, 74},
  {733546800, -14400, 74},
  {749448000, -10800, 74},
  {762318000, -14400, 74},
  {780984000, -10800, 74},
  {793767600, -14400, 74},
  {812520000, -10800, 74},
  {825649200, -14400, 74},
  {844574400, -10800, 74},
  {856666800, -14400, 74},
  {876024000, -10800, 74},
  {888721200, -14400, 74},
  {907473600, -10800, 74},
  {920775600, -14400, 74},
  {938923200, -10800, 74},
  {952225200, -14400, 74},
  {970372800, -10800, 74},
  {983674800, -14400, 74},
  {1002427200, -10800, 74},
  {1018148400, -14400, 74},
  {1030852800, -10800, 74},
  {1049598000, -14400, 74},
  {1062907200, -10800, 74},
  {1081047600, -14400, 74},
  {1097985600, -10800, 74},
  {1110682800, -14400, 74},
  {1129435200, -10800, 74},
  {1142132400, -14400, 74},
  {1160884800, -10800, 74},
  {1173582000, -14400, 74},
  {1192939200, -10800, 74},
  {1205031600, -14400, 74},
  {1224388800, -10800, 74},
  {1236481200, -14400, 74},
  {1255838400, -10800, 74},
  {1270954800, -14400, 74},
  {1286078400, -10800, 74},
  {1302404400, -14400, 74},
  {1317528000, -10800, 74},
  {1333854000, -14400, 74},
  {1349582400, -10800, 74},
  {1365908400, -14400, 74},
  {1381032000, -10800, 74},
  {1397358000, -14400, 74},
  {1412481600, -10800, 74},
  {1428807600, -14400, 74},
  {1443931200, -10800, 74},
  {1460257200, -14400, 74},
  {1475380800, -10800, 74},
  {1491706800, -14400, 74},
  {1506830400, -10800, 74},
  {1523156400, -14400, 74},
  {1538884800, -10800, 74},
  {1555210800, -14400, 74},
  {1570334400, -10800, 74},
  {1586660400, -14400, 74},
  {1601784000, -10800, 74},
  {1618110000, -14400, 74},
  {1633233600, -10800, 74},
  {1649559600, -14400, 74},
  {1664683200, -10800, 74},
  {1681009200, -14400, 74},
  {1696132800, -10800, 74},
  {1713063600, -14400, 74},
  {1728187200, -10800, 74},
  {1744513200, -14400, 74},
  {1759636800, -10800, 74},
  {1775962800, -14400, 74},
  {1791086400, -10800, 74},
  {1807412400, -14400, 74},
  {1822536000, -10800, 74},
  {1838862000, -14400, 74},
  {1853985600, -10800, 74},
  {1870311600, -14400, 74},
  {1886040000, -10800, 74},
  {1902366000, -14400, 74},
  {1917489600, -10800, 74},
  {1933815600, -14400, 74},
  {1948939200, -10800, 74},
  {1965265200, -14400, 74},
  {1980388800, -10800, 74},
  {1996714800, -14400, 74},
  {2011838400, -10800, 74},
  {2028164400, -14400, 74},
  {2043288000, -10800, 74},
  {2059614000, -14400, 74},
  {2075342400, -10800, 74},
  {2091668400, -14400, 74},
  {2106792000, -10800, 74},
  {2123118000, -14400, 74},
  {2138241600, -10800, 74},
  {-1632067200, -18000, 75},
  {-1614790800, -21600, 75},
  {-923248800, -18000, 75},
  {-880214400, -18000, 75},
  {-769395600, -18000, 75},
  {-765392400, -18000, 75},
  {-880196400, -36000, 76},
  {-769395600, -36000, 76},
  {-765374400, -39600, 76},
  {-86878800, -39600, 76},
  {-21466800, -36000, 76},
  {-5745600, -39600, 76},
  {9982800, -36000, 76},
  {25704000, -39600, 76},
  {41432400, -36000, 76},
  {57758400, -39600, 76},
  {73486800, -36000, 76},
  {89208000, -39600, 76},
  {104936400, -36000, 76},
  {120657600, -39600, 76},
  {126709200, -36000, 76},
  {152107200, -39600, 76},
  {162392400, -36000, 76},
  {183556800, -39600, 76},
  {199285200, -36000, 76},
  {215611200, -39600, 76},
  {230734800, -36000, 76},
  {247060800, -39600, 76},
  {262789200, -36000, 76},
  {278510400, -39600, 76},
  {294238800, -36000, 76},
  {309960000, -39600, 76},
  {325688400, -36000, 76},
  {341409600, -39600, 76},
  {357138000, -36000, 76},
  {372859200, -39600, 76},
  {388587600, -36000, 76},
  {404913600, -39600, 76},
  {420037200, -36000, 76},
  {436363200, -36000, 76},
  {439034400, -36000, 76},
  {452088000, -32400, 76},
  {467809200, -36000, 76},
  {483537600, -32400, 76},
  {499258800, -36000, 76},
  {514987200, -32400, 76},
  {530708400, -36000, 76},
  {544622400, -32400, 76},
  {562158000, -36000, 76},
  {576072000, -32400, 76},
  {594212400, -36000, 76},
  {607521600, -32400, 76},
  {625662000, -36000, 76},
  {638971200, -32400, 76},
  {657111600, -36000, 76},
  {671025600, -32400, 76},
  {688561200, -36000, 76},
  {702475200, -32400, 76},
  {720010800, -36000, 76},
  {733924800, -32400, 76},
  {752065200, -36000, 76},
  {765374400, -32400, 76},
  {783514800, -36000, 76},
  {796824000, -32400, 76},
  {814964400, -36000, 76},
  {828878400, -32400, 76},
  {846414000, -36000, 76},
  {860328000, -32400, 76},
  {877863600, -36000, 76},
  {891777600, -32400, 76},
  {909313200, -36000, 76},
  {923227200, -32400, 76},
  {941367600, -36000, 76},
  {954676800, -32400, 76},
  {972817200, -36000, 76},
  {986126400, -32400, 76},
  {1004266800, -36000, 76},
  {1018180800, -32400, 76},
  {1035716400, -36000, 76},
  {1049630400, -32400, 76},
  {1067166000, -36000, 76},
  {1081080000, -32400, 76},
  {1099220400, -36000, 76},
  {1112529600, -32400, 76},
  {1130670000, -36000, 76},
  {1143979200, -32400, 76},
  {1162119600, -36000, 76},
  {1173614400, -32400, 76},
  {1194174000, -36000, 76},
  {1205064000, -32400, 76},
  {1225623600, -36000, 76},
  {1236513600, -32400, 76},
  {1257073200, -36000, 76},
  {1268568000, -32400, 76},
  {1289127600, -36000, 76},
  {1300017600, -32400, 76},
  {1320577200, -36000, 76},
  {1331467200, -32400, 76},
  {1352026800, -36000, 76},
  {1362916800, -32400, 76},
  {1383476400, -36000, 76},
  {1394366400, -32400, 76},
  {1414926000, -36000, 76},
  {1425816000, -32400, 76},
  {1446375600, -36000, 76},
  {1457870400, -32400, 76},
  {1478430000, -36000, 76},
  {1489320000, -32400, 76},
  {1509879600, -36000, 76},
  {1520769600, -32400, 76},
  {1541329200, -36000, 76},
  {1552219200, -32400, 76},
  {1572778800, -36000, 76},
  {1583668800, -32400, 76},
  {1604228400, -36000, 76},
  {1615723200, -32400, 76},
  {1636282800, -36000, 76},
  {1647172800, -32400, 76},
  {1667732400, -36000, 76},
  {1678622400, -32400, 76},
  {1699182000, -36000, 76},
  {1710072000, -32400, 76},
  {1730631600, -36000, 76},
  {1741521600, -32400, 76},
  {1762081200, -36000, 76},
  {1772971200, -32400, 76},
  {1793530800, -36000, 76},
  {1805025600, -32400, 76},
  {1825585200, -36000, 76},
  {1836475200, -32400, 76},
  {1857034800, -36000, 76},
  {1867924800, -32400, 76},
  {1888484400, -36000, 76},
  {1899374400, -32400, 76},
  {1919934000, -36000, 76},
  {1930824000, -32400, 76},
  {1951383600, -36000, 76},
  {1962878400, -32400, 76},
  {1983438000, -36000, 76},
  {1994328000, -32400, 76},
  {2014887600, -36000, 76},
  {2025777600, -32400, 76},
  {2046337200, -36000, 76},
  {2057227200, -32400, 76},
  {2077786800, -36000, 76},
  {2088676800, -32400, 76},
  {2109236400, -36000, 76},
  {2120126400, -32400, 76},
  {2140686000, -36000, 76},
  {INT64_MIN, -9244, 77},
  {-1767216356, -10800, 77},
  {-1206957600, -7200, 77},
  {-1191362400, -10800, 77},
  {-1175374800, -7200, 77},
  {-1159826400, -10800, 77},
  {-633819600, -7200, 77},
  {-622069200, -10800, 77},
  {-602283600, -7200, 77},
  {-591832800, -10800, 77},
  {-570747600, -7200, 77},
  {-560210400, -10800, 77},
  {-539125200, -7200, 77},
  {-531352800, -10800, 77},
  {-191365200, -7200, 77},
  {-184197600, -10800, 77},
  {-155163600, -7200, 77},
  {-150069600, -10800, 77},
  {-128898000, -7200, 77},
  {-121125600, -10800, 77},
  {-99954000, -7200, 77},
  {-89589600, -10800, 77},
  {-68418000, -7200, 77},
  {-57967200, -10800, 77},
  {499748400, -7200, 77},
  {511236000, -10800, 77},
  {530593200, -7200, 77},
  {540266400, -10800, 77},
  {562129200, -7200, 77},
  {571197600, -10800, 77},
  {592974000, -7200, 77},
  {602042400, -10800, 77},
  {624423600, -7200, 77},
  {634701600, -10800, 77},
  {656478000, -7200, 77},
  {666756000, -10800, 77},
  {687927600, -7200, 77},
  {697600800, -10800, 77},
  {719982000, -7200, 77},
  {728445600, -10800, 77},
  {750826800, -7200, 77},
  {761709600, -10800, 77},
  {782276400, -7200, 77},
  {793159200, -10800, 77},
  {813726000, -7200, 77},
  {824004000, -10800, 77},
  {844570800, -7200, 77},
  {856058400, -10800, 77},
  {876106800, -7200, 77},
  {888717600, -10800, 77},
  {908074800, -7200, 77},
  {919562400, -10800, 77},
  {938919600, -7200, 77},
  {951616800, -10800, 77},
  {970974000, -7200, 77},
  {982461600, -10800, 77},
  {1003028400, -7200, 77},
  {1013911200, -10800, 77},
  {1036292400, -7200, 77},
  {1045360800, -10800, 77},
  {1318734000, -7200, 77},
  {1330221600, -10800, 77},
  {1350788400, -7200, 77},
  {1361066400, -10800, 77},
  {1382238000, -7200, 77},
  {1392516000, -10800, 77},
  {1413687600, -7200, 77},
  {1424570400, -10800, 77},
  {1445137200, -7200, 77},
  {1456020000, -10800, 77},
  {1476586800, -7200, 77},
  {1487469600, -10800, 77},
  {1508036400, -7200, 77},
  {1518919200, -10800, 77},
  {1540090800, -7200, 77},
  {1550368800, -10800, 77},
  {1571540400, -7200, 77},
  {1581818400, -10800, 77},
  {1602990000, -7200, 77},
  {1613872800, -10800, 77},
  {1634439600, -7200, 77},
  {1645322400, -10800, 77},
  {1665889200, -7200, 77},
  {1677376800, -10800, 77},
  {1697338800, -7200, 77},
  {1708221600, -10800, 77},
  {1729393200, -7200, 77},
  {1739671200, -10800, 77},
  {1760842800, -7200, 77},
  {1771725600, -10800, 77},
  {1792292400, -7200, 77},
  {1803175200, -10800, 77},
  {1823742000, -7200, 77},
  {1834624800, -10800, 77},
  {1855191600, -7200, 77},
  {1866074400, -10800, 77},
  {1887246000, -7200, 77},
  {1897524000, -10800, 77},
  {1918695600, -7200, 77},
  {1928973600, -10800, 77},
  {1950145200, -7200, 77},
  {1960423200, -10800, 77},
  {1981594800, -7200, 77},
  {1992477600, -10800, 77},
  {2013044400, -7200, 77},
  {2024532000, -10800, 77},
  {2044494000, -7200, 77},
  {2055376800, -10800, 77},
  {2076548400, -7200, 77},
  {2086826400, -10800, 77},
  {2107998000, -7200, 77},
  {2118880800, -10800, 77},
  {2139447600, -7200, 77},
  {INT64_MIN, -25260, 78},
  {-1514739600, -25200, 78},
  {-1343066400, -21600, 78},
  {-1234807200, -25200, 78},
  {-1220292000, -21600, 78},
  {-1207159200, -25200, 78},
  {-1191344400, -21600, 78},
  {-873828000, -25200, 78},
  {-661539600, -28800, 78},
  {28800, -25200, 78},
  {828867600, -21600, 78},
  {846403200, -25200, 78},
  {860317200, -21600, 78},
  {877852800, -25200, 78},
  {891766800, -21600, 78},
  {909302400, -25200, 78},
  {923216400, -21600, 78},
  {941356800, -25200, 78},
  {954666000, -21600, 78},
  {972806400, -25200, 78},
  {989139600, -21600, 78},
  {1001836800, -25200, 78},
  {1018170000, -21600, 78},
  {1035705600, -25200, 78},
  {1049619600, -21600, 78},
  {1067155200, -25200, 78},
  {1081069200, -21600, 78},
  {1099209600, -25200, 78},
  {1112518800, -21600, 78},
  {1130659200, -25200, 78},
  {1143968400, -21600, 78},
  {1162108800, -25200, 78},
  {1175418000, -21600, 78},
  {1193558400, -25200, 78},
  {1207472400, -21600, 78},
  {1225008000, -25200, 78},
  {1238922000, -21600, 78},
  {1256457600, -25200, 78},
  {1270371600, -18000, 78},
  {1288508400, -21600, 78},
  {1301817600, -18000, 78},
  {1319958000, -21600, 78},
  {1333267200, -18000, 78},
  {1351407600, -21600, 78},
  {1365321600, -18000, 78},
  {1382857200, -21600, 78},
  {1396771200, -18000, 78},
  {1414306800, -21600, 78},
  {1428220800, -18000, 78},
  {1445756400, -21600, 78},
  {1459670400, -18000, 78},
  {1477810800, -21600, 78},
  {1491120000, -18000, 78},
  {1509260400, -21600, 78},
  {1522569600, -18000, 78},
  {1540710000, -21600, 78},
  {1554624000, -18000, 78},
  {1572159600, -21600, 78},
  {1586073600, -18000, 78},
  {1603609200, -21600, 78},
  {1617523200, -18000, 78},
  {1635663600, -21600, 78},
  {1648972800, -18000, 78},
  {1667113200, -21600, 78},
  {1680422400, -18000, 78},
  {1698562800, -21600, 78},
  {1712476800, -18000, 78},
  {1730012400, -21600, 78},
  {1743926400, -18000, 78},
  {1761462000, -21600, 78},
  {1775376000, -18000, 78},
  {1792911600, -21600, 78},
  {1806825600, -18000, 78},
  {1824966000, -21600, 78},
  {1838275200, -18000, 78},
  {1856415600, -21600, 78},
  {1869724800, -18000, 78},
  {1887865200, -21600, 78},
  {1901779200, -18000, 78},
  {1919314800, -21600, 78},
  {1933228800, -18000, 78},
  {1950764400, -21600, 78},
  {1964678400, -18000, 78},
  {1982818800, -21600, 78},
  {1996128000, -18000, 78},
  {2014268400, -21600, 78},
  {2027577600, -18000, 78},
  {2045718000, -21600, 78},
  {2059027200, -18000, 78},
  {2077167600, -21600, 78},
  {2091081600, -18000, 78},
  {2108617200, -21600, 78},
  {2122531200, -18000, 78},
  {2140066800, -21600, 78},
  {INT64_MIN, -14308, 79},
  {-1451678492, -14308, 79},
  {-1199217692, -14400, 79},
  {234943200, -10800, 79},
  {244616400, -14400, 79},
  {261554400, -10800, 79},
  {276066000, -14400, 79},
  {293004000, -10800, 79},
  {307515600, -14400, 79},
  {325058400, -10800, 79},
  {338706000, -14400, 79},
  {INT64_MIN, -11636, 80},
  {-1767213964, -10800, 80},
  {-1206957600, -7200, 80},
  {-1191362400, -10800, 80},
  {-1175374800, -7200, 80},
  {-1159826400, -10800, 80},
  {-633819600, -7200, 80},
  {-622069200, -10800, 80},
  {-602283600, -7200, 80},
  {-591832800, -10800, 80},
  {-570747600, -7200, 80},
  {-560210400, -10800, 80},
  {-539125200, -7200, 80},
  {-531352800, -10800, 80},
  {-191365200, -7200, 80},
  {-184197600, -10800, 80},
  {-155163600, -7200, 80},
  {-150069600, -10800, 80},
  {-128898000, -7200, 80},
  {-121125600, -10800, 80},
  {-99954000, -7200, 80},
  {-89589600, -10800, 80},
  {-68418000, -7200, 80},
  {-57967200, -10800, 80},
  {499748400, -7200, 80},
  {511236000, -10800, 80},
  {530593200, -7200, 80},
  {540266400, -10800, 80},
  {562129200, -7200, 80},
  {571197600, -10800, 80},
  {INT64_MIN, -21168, 81},
  {-1822500432, -21600, 81},
  {-1616954400, -19800, 81},
  {-1606069800, -21600, 81},
  {-1585504800, -19800, 81},
  {-1574015400, -21600, 81},
  {-1554055200, -19800, 81},
  {-1542565800, -21600, 81},
  {-1522605600, -19800, 81},
  {-1511116200, -21600, 81},
  {-1490551200, -19800, 81},
  {-1479666600, -21600, 81},
  {-1459101600, -19800, 81},
  {-1448217000, -21600, 81},
  {-1427652000, -19800, 81},
  {-1416162600, -21600, 81},
  {-1396202400, -19800, 81},
  {-1384713000, -21600, 81},
  {-1364752800, -19800, 81},
  {-1353263400, -21600, 81},
  {-1333303200, -19800, 81},
  {-1321813800, -21600, 81},
  {-1301248800, -19800, 81},
  {-1290364200, -21600, 81},
  {-1269799200, -19800, 81},
  {-1258914600, -21600, 81},
  {-1238349600, -19800, 81},
  {-1226860200, -21600, 81},
  {-1206900000, -19800, 81},
  {-1195410600, -21600, 81},
  {-1175450400, -19800, 81},
  {-1163961000, -21600, 81},
  {-1143396000, -19800, 81},
  {-1132511400, -21600, 81},
  {-1111946400, -19800, 81},
  {-1101061800, -21600, 81},
  {-1080496800, -19800, 81},
  {-1069612200, -21600, 81},
  {-1049047200, -19800, 81},
  {-1037557800, -21600, 81},
  {-1017597600, -19800, 81},
  {-1006108200, -21600, 81},
  {-986148000, -19800, 81},
  {-974658600, -21600, 81},
  {-954093600, -19800, 81},
  {-943209000, -21600, 81},
  {-922644000, -19800, 81},
  {-911759400, -21600, 81},
  {-891194400, -19800, 81},
  {-879705000, -21600, 81},
  {-859744800, -19800, 81},
  {-848255400, -21600, 81},
  {123919200, -18000, 81},
  {129618000, -21600, 81},
  {409039200, -18000, 81},
  {413874000, -21600, 81},
  {-1632074400, -10800, 82},
  {-1614798000, -14400, 82},
  {-880221600, -10800, 82},
  {-769395600, -10800, 82},
  {-765399600, -14400, 82},
  {INT64_MIN, -14560, 83},
  {-1767211040, -14400, 83},
  {-1206954000, -10800, 83},
  {-1191358800, -14400, 83},
  {-1175371200, -10800, 83},
  {-1159822800, -14400, 83},
  {-633816000, -10800, 83},
  {-622065600, -14400, 83},
  {-602280000, -10800, 83},
  {-591829200, -14400, 83},
  {-570744000, -10800, 83},
  {-560206800, -14400, 83},
  {-539121600, -10800, 83},
  {-531349200, -14400, 83},
  {-191361600, -10800, 83},
  {-184194000, -14400, 83},
  {-155160000, -10800, 83},
  {-150066000, -14400, 83},
  {-128894400, -10800, 83},
  {-121122000, -14400, 83},
  {-99950400, -10800, 83},
  {-89586000, -14400, 83},
  {-68414400, -10800, 83},
  {-57963600, -14400, 83},
  {499752000, -10800, 83},
  {511239600, -14400, 83},
  {530596800, -10800, 83},
  {540270000, -14400, 83},
  {562132800, -10800, 83},
  {571201200, -14400, 83},
  {938923200, -10800, 83},
  {951620400, -14400, 83},
  {970977600, -10800, 83},
  {971578800, -14400, 83},
  {INT64_MIN, -17780, 84},
  {-1739041420, -18000, 84},
  {704869200, -14400, 84},
  {733896000, -18000, 84},
  {-1633269600, -25200, 85},
  {-1615129200, -28800, 85},
  {-1601820000, -25200, 85},
  {-1583679600, -28800, 85},
  {-1471788000, -25200, 85},
  {-880210800, -21600, 85},
  {-769395600, -21600, 85},
  {-765388800, -25200, 85},
  {-84380400, -21600, 85},
  {-68659200, -25200, 85},
  {-52930800, -21600, 85},
  {-37209600, -25200, 85},
  {-21481200, -21600, 85},
  {-5760000, -25200, 85},
  {9968400, -21600, 85},
  {25689600, -25200, 85},
  {41418000, -21600, 85},
  {57744000, -25200, 85},
  {73472400, -21600, 85},
  {89193600, -25200, 85},
  {104922000, -21600, 85},
  {120643200, -25200, 85},
  {129114000, -21600, 85},
  {152092800, -25200, 85},
  {162378000, -21600, 85},
  {183542400, -25200, 85},
  {199270800, -21600, 85},
  {215596800, -25200, 85},
  {230720400, -21600, 85},
  {247046400, -25200, 85},
  {262774800, -21600, 85},
  {278496000, -25200, 85},
  {294224400, -21600, 85},
  {309945600, -25200, 85},
  {325674000, -21600, 85},
  {341395200, -25200, 85},
  {357123600, -21600, 85},
  {372844800, -25200, 85},
  {388573200, -21600, 85},
  {404899200, -25200, 85},
  {420022800, -21600, 85},
  {436348800, -25200, 85},
  {452077200, -21600, 85},
  {467798400, -25200, 85},
  {483526800, -21600, 85},
  {499248000, -25200, 85},
  {514976400, -21600, 85},
  {530697600, -25200, 85},
  {544611600, -21600, 85},
  {562147200, -25200, 85},
  {576061200, -21600, 85},
  {594201600, -25200, 85},
  {607510800, -21600, 85},
  {625651200, -25200, 85},
  {638960400, -21600, 85},
  {657100800, -25200, 85},
  {671014800, -21600, 85},
  {688550400, -25200, 85},
  {702464400, -21600, 85},
  {720000000, -25200, 85},
  {733914000, -21600, 85},
  {752054400, -25200, 85},
  {765363600, -21600, 85},
  {783504000, -25200, 85},
  {796813200, -21600, 85},
  {814953600, -25200, 85},
  {828867600, -21600, 85},
  {846403200, -25200, 85},
  {860317200, -21600, 85},
  {877852800, -25200, 85},
  {891766800, -21600, 85},
  {909302400, -25200, 85},
  {923216400, -21600, 85},
  {941356800, -25200, 85},
  {954666000, -21600, 85},
  {972806400, -25200, 85},
  {986115600, -21600, 85},
  {1004256000, -25200, 85},
  {1018170000, -21600, 85},
  {1035705600, -25200, 85},
  {1049619600, -21600, 85},
  {1067155200, -25200, 85},
  {1081069200, -21600, 85},
  {1099209600, -25200, 85},
  {1112518800, -21600, 85},
  {1130659200, -25200, 85},
  {1143968400, -21600, 85},
  {1162108800, -25200, 85},
  {1173603600, -21600, 85},
  {1194163200, -25200, 85},
  {1205053200, -21600, 85},
  {1225612800, -25200, 85},
  {1236502800, -21600, 85},
  {1257062400, -25200, 85},
  {1268557200, -21600, 85},
  {1289116800, -25200, 85},
  {1300006800, -21600, 85},
  {1320566400, -25200, 85},
  {1331456400, -21600, 85},
  {1352016000, -25200, 85},
  {1362906000, -21600, 85},
  {1383465600, -25200, 85},
  {1394355600, -21600, 85},
  {1414915200, -25200, 85},
  {1425805200, -21600, 85},
  {1446364800, -25200, 85},
  {1457859600, -21600, 85},
  {1478419200, -25200, 85},
  {1489309200, -21600, 85},
  {1509868800, -25200, 85},
  {1520758800, -21600, 85},
  {1541318400, -25200, 85},
  {1552208400, -21600, 85},
  {1572768000, -25200, 85},
  {1583658000, -21600, 85},
  {1604217600, -25200, 85},
  {1615712400, -21600, 85},
  {1636272000, -25200, 85},
  {1647162000, -21600, 85},
  {1667721600, -25200, 85},
  {1678611600, -21600, 85},
  {1699171200, -25200, 85},
  {1710061200, -21600, 85},
  {1730620800, -25200, 85},
  {1741510800, -21600, 85},
  {1762070400, -25200, 85},
  {1772960400, -21600, 85},
  {1793520000, -25200, 85},
  {1805014800, -21600, 85},
  {1825574400, -25200, 85},
  {1836464400, -21600, 85},
  {1857024000, -25200, 85},
  {1867914000, -21600, 85},
  {1888473600, -25200, 85},
  {1899363600, -21600, 85},
  {1919923200, -25200, 85},
  {1930813200, -21600, 85},
  {1951372800, -25200, 85},
  {1962867600, -21600, 85},
  {1983427200, -25200, 85},
  {1994317200, -21600, 85},
  {2014876800, -25200, 85},
  {2025766800, -21600, 85},
  {2046326400, -25200, 85},
  {2057216400, -21600, 85},
  {2077776000, -25200, 85},
  {2088666000, -21600, 85},
  {2109225600, -25200, 85},
  {2120115600, -21600, 85},
  {2140675200, -25200, 85},
  {INT64_MIN, -15408, 86},
  {-1567453392, -14400, 86},
  {-1233432000, -10800, 86},
  {-1222981200, -14400, 86},
  {-1205956800, -10800, 86},
  {-1194037200, -14400, 86},
  {-1172865600, -10800, 86},
  {-1162501200, -14400, 86},
  {-1141329600, -10800, 86},
  {-1130965200, -14400, 86},
  {-1109793600, -10800, 86},
  {-1099429200, -14400, 86},
  {-1078257600, -10800, 86},
  {-1067806800, -14400, 86},
  {-1046635200, -10800, 86},
  {-1036270800, -14400, 86},
  {-1015099200, -10800, 86},
  {-1004734800, -14400, 86},
  {-983563200, -10800, 86},
  {-973198800, -14400, 86},
  {-952027200, -10800, 86},
  {-941576400, -14400, 86},
  {-931032000, -10800, 86},
  {-900882000, -14400, 86},
  {-890337600, -10800, 86},
  {-833749200, -14400, 86},
  {-827265600, -10800, 86},
  {-752274000, -14400, 86},
  {-733780800, -10800, 86},
  {-197326800, -14400, 86},
  {-190843200, -10800, 86},
  {-184194000, -14400, 86},
  {-164491200, -10800, 86},
  {-152658000, -14400, 86},
  {-132955200, -10800, 86},
  {-121122000, -14400, 86},
  {-101419200, -10800, 86},
  {-86821200, -14400, 86},
  {-71092800, -10800, 86},
  {-54766800, -14400, 86},
  {-39038400, -10800, 86},
  {-23317200, -14400, 86},
  {-7588800, -10800, 86},
  {128142000, -7200, 86},
  {136605600, -10800, 86},
  {596948400, -7200, 86},
  {605066400, -10800, 86},
  {624423600, -7200, 86},
  {636516000, -10800, 86},
  {656478000, -7200, 86},
  {667965600, -10800, 86},
  {687927600, -7200, 86},
  {699415200, -10800, 86},
  {719377200, -7200, 86},
  {731469600, -10800, 86},
  {938919600, -10800, 86},
  {952052400, -10800, 86},
  {1198983600, -7200, 86},
  {1205632800, -10800, 86},
  {1224385200, -7200, 86},
  {1237082400, -10800, 86},
  {INT64_MIN, 0, 87},
  {-1577923200, -25200, 87},
  {-880210800, -21600, 87},
  {-769395600, -21600, 87},
  {-765388800, -25200, 87},
  {-147891600, -18000, 87},
  {-131562000, -25200, 87},
  {325674000, -21600, 87},
  {341395200, -25200, 87},
  {357123600, -21600, 87},
  {372844800, -25200, 87},
  {388573200, -21600, 87},
  {404899200, -25200, 87},
  {420022800, -21600, 87},
  {436348800, -25200, 87},
  {452077200, -21600, 87},
  {467798400, -25200, 87},
  {483526800, -21600, 87},
  {499248000, -25200, 87},
  {514976400, -21600, 87},
  {530697600, -25200, 87},
  {544611600, -21600, 87},
  {562147200, -25200, 87},
  {576061200, -21600, 87},
  {594201600, -25200, 87},
  {607510800, -21600, 87},
  {625651200, -25200, 87},
  {638960400, -21600, 87},
  {657100800, -25200, 87},
  {671014800, -21600, 87},
  {688550400, -25200, 87},
  {702464400, -21600, 87},
  {720000000, -25200, 87},
  {733914000, -21600, 87},
  {752054400, -25200, 87},
  {765363600, -21600, 87},
  {783504000, -25200, 87},
  {796813200, -21600, 87},
  {814953600, -25200, 87},
  {828867600, -21600, 87},
  {846403200, -25200, 87},
  {860317200, -21600, 87},
  {877852800, -25200, 87},
  {891766800, -21600, 87},
  {909302400, -25200, 87},
  {923216400, -21600, 87},
  {941356800, -21600, 87},
  {954662400, -18000, 87},
  {972802800, -18000, 87},
  {973400400, -21600, 87},
  {986115600, -21600, 87},
  {1004256000, -25200, 87},
  {1018170000, -21600, 87},
  {1035705600, -25200, 87},
  {1049619600, -21600, 87},
  {1067155200, -25200, 87},
  {1081069200, -21600, 87},
  {1099209600, -25200, 87},
  {1112518800, -21600, 87},
  {1130659200, -25200, 87},
  {1143968400, -21600, 87},
  {1162108800, -25200, 87},
  {1173603600, -21600, 87},
  {1194163200, -25200, 87},
  {1205053200, -21600, 87},
  {1225612800, -25200, 87},
  {1236502800, -21600, 87},
  {1257062400, -25200, 87},
  {1268557200, -21600, 87},
  {1289116800, -25200, 87},
  {1300006800, -21600, 87},
  {1320566400, -25200, 87},
  {1331456400, -21600, 87},
  {1352016000, -25200, 87},
  {1362906000, -21600, 87},
  {1383465600, -25200, 87},
  {1394355600, -21600, 87},
  {1414915200, -25200, 87},
  {1425805200, -21600, 87},
  {1446364800, -25200, 87},
  {1457859600, -21600, 87},
  {1478419200, -25200, 87},
  {1489309200, -21600, 87},
  {1509868800, -25200, 87},
  {1520758800, -21600, 87},
  {1541318400, -25200, 87},
  {1552208400, -21600, 87},
  {1572768000, -25200, 87},
  {1583658000, -21600, 87},
  {1604217600, -25200, 87},
  {1615712400, -21600, 87},
  {1636272000, -25200, 87},
  {1647162000, -21600, 87},
  {1667721600, -25200, 87},
  {1678611600, -21600, 87},
  {1699171200, -25200, 87},
  {1710061200, -21600, 87},
  {1730620800, -25200, 87},
  {1741510800, -21600, 87},
  {1762070400, -25200, 87},
  {1772960400, -21600, 87},
  {1793520000, -25200, 87},
  {1805014800, -21600, 87},
  {1825574400, -25200, 87},
  {1836464400, -21600, 87},
  {1857024000, -25200, 87},
  {1867914000, -21600, 87},
  {1888473600, -25200, 87},
  {1899363600, -21600, 87},
  {1919923200, -25200, 87},
  {1930813200, -21600, 87},
  {1951372800, -25200, 87},
  {1962867600, -21600, 87},
  {1983427200, -25200, 87},
  {1994317200, -21600, 87},
  {2014876800, -25200, 87},
  {2025766800, -21600, 87},
  {2046326400, -25200, 87},
  {2057216400, -21600, 87},
  {2077776000, -25200, 87},
  {2088666000, -21600, 87},
  {2109225600, -25200, 87},
  {2120115600, -21600, 87},
  {2140675200, -25200, 87},
  {INT64_MIN, -13108, 88},
  {-1767212492, -14400, 88},
  {-1206954000, -10800, 88},
  {-1191358800, -14400, 88},
  {-1175371200, -10800, 88},
  {-1159822800, -14400, 88},
  {-633816000, -10800, 88},
  {-622065600, -14400, 88},
  {-602280000, -10800, 88},
  {-591829200, -14400, 88},
  {-570744000, -10800, 88},
  {-560206800, -14400, 88},
  {-539121600, -10800, 88},
  {-531349200, -14400, 88},
  {-191361600, -10800, 88},
  {-184194000, -14400, 88},
  {-155160000, -10800, 88},
  {-150066000, -14400, 88},
  {-128894400, -10800, 88},
  {-121122000, -14400, 88},
  {-99950400, -10800, 88},
  {-89586000, -14400, 88},
  {-68414400, -10800, 88},
  {-57963600, -14400, 88},
  {499752000, -10800, 88},
  {511239600, -14400, 88},
  {530596800, -10800, 88},
  {540270000, -14400, 88},
  {562132800, -10800, 88},
  {571201200, -14400, 88},
  {592977600, -10800, 88},
  {602046000, -14400, 88},
  {624427200, -10800, 88},
  {634705200, -14400, 88},
  {656481600, -10800, 88},
  {666759600, -14400, 88},
  {687931200, -10800, 88},
  {697604400, -14400, 88},
  {719985600, -10800, 88},
  {728449200, -14400, 88},
  {750830400, -10800, 88},
  {761713200, -14400, 88},
  {782280000, -10800, 88},
  {793162800, -14400, 88},
  {813729600, -10800, 88},
  {824007600, -14400, 88},
  {844574400, -10800, 88},
  {856062000, -14400, 88},
  {876110400, -10800, 88},
  {888721200, -14400, 88},
  {908078400, -10800, 88},
  {919566000, -14400, 88},
  {938923200, -10800, 88},
  {951620400, -14400, 88},
  {970977600, -10800, 88},
  {982465200, -14400, 88},
  {1003032000, -10800, 88},
  {1013914800, -14400, 88},
  {1036296000, -10800, 88},
  {1045364400, -14400, 88},
  {1066536000, -10800, 88},
  {1076814000, -14400, 88},
  {1099368000, -10800, 88},
  {1108868400, -14400, 88},
  {1129435200, -10800, 88},
  {1140318000, -14400, 88},
  {1162699200, -10800, 88},
  {1172372400, -14400, 88},
  {1192334400, -10800, 88},
  {1203217200, -14400, 88},
  {1224388800, -10800, 88},
  {1234666800, -14400, 88},
  {1255838400, -10800, 88},
  {1266721200, -14400, 88},
  {1287288000, -10800, 88},
  {1298170800, -14400, 88},
  {1318737600, -10800, 88},
  {1330225200, -14400, 88},
  {1350792000, -10800, 88},
  {1361070000, -14400, 88},
  {1382241600, -10800, 88},
  {1392519600, -14400, 88},
  {1413691200, -10800, 88},
  {1424574000, -14400, 88},
  {1445140800, -10800, 88},
  {1456023600, -14400, 88},
  {1476590400, -10800, 88},
  {1487473200, -14400, 88},
  {1508040000, -10800, 88},
  {1518922800, -14400, 88},
  {1540094400, -10800, 88},
  {1550372400, -14400, 88},
  {1571544000, -10800, 88},
  {1581822000, -14400, 88},
  {1602993600, -10800, 88},
  {1613876400, -14400, 88},
  {1634443200, -10800, 88},
  {1645326000, -14400, 88},
  {1665892800, -10800, 88},
  {1677380400, -14400, 88},
  {1697342400, -10800, 88},
  {1708225200, -14400, 88},
  {1729396800, -10800, 88},
  {1739674800, -14400, 88},
  {1760846400, -10800, 88},
  {1771729200, -14400, 88},
  {1792296000, -10800, 88},
  {1803178800, -14400, 88},
  {1823745600, -10800, 88},
  {1834628400, -14400, 88},
  {1855195200, -10800, 88},
  {1866078000, -14400, 88},
  {1887249600, -10800, 88},
  {1897527600, -14400, 88},
  {1918699200, -10800, 88},
  {1928977200, -14400, 88},
  {1950148800, -10800, 88},
  {1960426800, -14400, 88},
  {1981598400, -10800, 88},
  {1992481200, -14400, 88},
  {2013048000, -10800, 88},
  {2024535600, -14400, 88},
  {2044497600, -10800, 88},
  {2055380400, -14400, 88},
  {2076552000, -10800, 88},
  {2086830000, -14400, 88},
  {2108001600, -10800, 88},
  {2118884400, -14400, 88},
  {2139451200, -10800, 88},
  {INT64_MIN, -20824, 89},
  {-1514743200, -21600, 89},
  {377935200, -18000, 89},
  {828860400, -14400, 89},
  {846396000, -18000, 89},
  {860310000, -14400, 89},
  {877845600, -18000, 89},
  {891759600, -14400, 89},
  {902037600, -18000, 89},
  {909298800, -21600, 89},
  {923212800, -18000, 89},
  {941353200, -21600, 89},
  {954662400, -18000, 89},
  {972802800, -21600, 89},
  {989136000, -18000, 89},
  {1001833200, -21600, 89},
  {1018166400, -18000, 89},
  {1035702000, -21600, 89},
  {1049616000, -18000, 89},
  {1067151600, -21600, 89},
  {1081065600, -18000, 89},
  {1099206000, -21600, 89},
  {1112515200, -18000, 89},
  {1130655600, -21600, 89},
  {1143964800, -18000, 89},
  {1162105200, -21600, 89},
  {1175414400, -18000, 89},
  {1193554800, -21600, 89},
  {1207468800, -18000, 89},
  {1225004400, -21600, 89},
  {1238918400, -18000, 89},
  {1256454000, -21600, 89},
  {1270368000, -18000, 89},
  {1288508400, -21600, 89},
  {1301817600, -18000, 89},
  {1319958000, -21600, 89},
  {1333267200, -18000, 89},
  {1351407600, -21600, 89},
  {1365321600, -18000, 89},
  {1382857200, -21600, 89},
  {1396771200, -18000, 89},
  {1414306800, -21600, 89},
  {1428220800, -18000, 89},
  {1445756400, -21600, 89},
  {1459670400, -18000, 89},
  {1477810800, -21600, 89},
  {1491120000, -18000, 89},
  {1509260400, -21600, 89},
  {1522569600, -18000, 89},
  {1540710000, -21600, 89},
  {1554624000, -18000, 89},
  {1572159600, -21600, 89},
  {1586073600, -18000, 89},
  {1603609200, -21600, 89},
  {1617523200, -18000, 89},
  {1635663600, -21600, 89},
  {1648972800, -18000, 89},
  {1667113200, -21600, 89},
  {1680422400, -18000, 89},
  {1698562800, -21600, 89},
  {1712476800, -18000, 89},
  {1730012400, -21600, 89},
  {1743926400, -18000, 89},
  {1761462000, -21600, 89},
  {1775376000, -18000, 89},
  {1792911600, -21600, 89},
  {1806825600, -18000, 89},
  {1824966000, -21600, 89},
  {1838275200, -18000, 89},
  {1856415600, -21600, 89},
  {1869724800, -18000, 89},
  {1887865200, -21600, 89},
  {1901779200, -18000, 89},
  {1919314800, -21600, 89},
  {1933228800, -18000, 89},
  {1950764400, -21600, 89},
  {1964678400, -18000, 89},
  {1982818800, -21600, 89},
  {1996128000, -18000, 89},
  {2014268400, -21600, 89},
  {2027577600, -18000, 89},
  {2045718000, -21600, 89},
  {2059027200, -18000, 89},
  {2077167600, -21600, 89},
  {2091081600, -18000, 89},
  {2108617200, -21600, 89},
  {2122531200, -18000, 89},
  {2140066800, -21600, 89},
  {INT64_MIN, -16060, 90},
  {-1826739140, -16200, 90},
  {-157750200, -14400, 90},
  {1197183600, -16200, 90},
  {INT64_MIN, -15408, 91},
  {-1567453392, -14400, 91},
  {-1233432000, -10800, 91},
  {-1222981200, -14400, 91},
  {-1205956800, -10800, 91},
  {-1194037200, -14400, 91},
  {-1172865600, -10800, 91},
  {-1162501200, -14400, 91},
  {-1141329600, -10800, 91},
  {-1130965200, -14400, 91},
  {-1109793600, -10800, 91},
  {-1099429200, -14400, 91},
  {-1078257600, -10800, 91},
  {-1067806800, -14400, 91},
  {-1046635200, -10800, 91},
  {-1036270800, -14400, 91},
  {-1015099200, -10800, 91},
  {-1004734800, -14400, 91},
  {-983563200, -10800, 91},
  {-973198800, -14400, 91},
  {-952027200, -10800, 91},
  {-941576400, -14400, 91},
  {-931032000, -10800, 91},
  {-900882000, -14400, 91},
  {-890337600, -10800, 91},
  {-833749200, -14400, 91},
  {-827265600, -10800, 91},
  {-752274000, -14400, 91},
  {-733780800, -10800, 91},
  {-197326800, -14400, 91},
  {-190843200, -10800, 91},
  {-184194000, -14400, 91},
  {-164491200, -10800, 91},
  {-152658000, -14400, 91},
  {-132955200, -10800, 91},
  {-121122000, -14400, 91},
  {-101419200, -10800, 91},
  {-86821200, -14400, 91},
  {-71092800, -10800, 91},
  {-54766800, -14400, 91},
  {-39038400, -10800, 91},
  {-23317200, -14400, 91},
  {-7588800, -10800, 91},
  {128142000, -7200, 91},
  {136605600, -10800, 91},
  {596948400, -7200, 91},
  {605066400, -10800, 91},
  {624423600, -7200, 91},
  {636516000, -10800, 91},
  {656478000, -7200, 91},
  {667965600, -14400, 91},
  {687931200, -7200, 91},
  {699415200, -10800, 91},
  {719377200, -7200, 91},
  {731469600, -10800, 91},
  {938919600, -10800, 91},
  {952052400, -10800, 91},
  {1086058800, -14400, 91},
  {1087704000, -10800, 91},
  {1198983600, -7200, 91},
  {1205632800, -10800, 91},
  {INT64_MIN, -12560, 92},
  {-1846269040, -14400, 92},
  {-71092800, -10800, 92},
  {INT64_MIN, -18432, 93},
  {-1827687168, -18000, 93},
  {-1633276800, -18000, 94},
  {-1615136400, -21600, 94},
  {-1601827200, -18000, 94},
  {-1583686800, -21600, 94},
  {-1563724800, -18000, 94},
  {-1551632400, -21600, 94},
  {-1538928000, -18000, 94},
  {-1520182800, -21600, 94},
  {-1504454400, -18000, 94},
  {-1491757200, -21600, 94},
  {-1473004800, -18000, 94},
  {-1459702800, -21600, 94},
  {-1441555200, -18000, 94},
  {-1428253200, -21600, 94},
  {-1410105600, -18000, 94},
  {-1396803600, -21600, 94},
  {-1378656000, -18000, 94},
  {-1365354000, -21600, 94},
  {-1347206400, -18000, 94},
  {-1333904400, -21600, 94},
  {-1315152000, -18000, 94},
  {-1301850000, -21600, 94},
  {-1283702400, -18000, 94},
  {-1270400400, -21600, 94},
  {-1252252800, -18000, 94},
  {-1238950800, -21600, 94},
  {-1220803200, -18000, 94},
  {-1207501200, -21600, 94},
  {-1189353600, -18000, 94},
  {-1176051600, -21600, 94},
  {-1157299200, -18000, 94},
  {-1144602000, -21600, 94},
  {-1125849600, -18000, 94},
  {-1112547600, -21600, 94},
  {-1094400000, -18000, 94},
  {-1081098000, -21600, 94},
  {-1067788800, -18000, 94},
  {-1045414800, -21600, 94},
  {-1031500800, -18000, 94},
  {-1018198800, -21600, 94},
  {-1000051200, -18000, 94},
  {-986749200, -21600, 94},
  {-967996800, -18000, 94},
  {-955299600, -21600, 94},
  {-936547200, -18000, 94},
  {-923245200, -21600, 94},
  {-905097600, -18000, 94},
  {-891795600, -21600, 94},
  {-880214400, -18000, 94},
  {-769395600, -18000, 94},
  {-765392400, -21600, 94},
  {-747244800, -18000, 94},
  {-733942800, -21600, 94},
  {-715795200, -18000, 94},
  {-702493200, -21600, 94},
  {-684345600, -18000, 94},
  {-671043600, -21600, 94},
  {-652896000, -18000, 94},
  {-639594000, -21600, 94},
  {-620841600, -18000, 94},
  {-608144400, -21600, 94},
  {-589392000, -18000, 94},
  {-576090000, -21600, 94},
  {-557942400, -18000, 94},
  {-544640400, -21600, 94},
  {-526492800, -18000, 94},
  {-513190800, -21600, 94},
  {-495043200, -18000, 94},
  {-481741200, -21600, 94},
  {-463593600, -18000, 94},
  {-447267600, -21600, 94},
  {-431539200, -18000, 94},
  {-415818000, -21600, 94},
  {-400089600, -18000, 94},
  {-384368400, -21600, 94},
  {-368640000, -18000, 94},
  {-352918800, -21600, 94},
  {-337190400, -18000, 94},
  {-321469200, -21600, 94},
  {-305740800, -18000, 94},
  {-289414800, -21600, 94},
  {-273686400, -18000, 94},
  {-257965200, -21600, 94},
  {-242236800, -18000, 94},
  {-226515600, -21600, 94},
  {-210787200, -18000, 94},
  {-195066000, -21600, 94},
  {-179337600, -18000, 94},
  {-163616400, -21600, 94},
  {-147888000, -18000, 94},
  {-131562000, -21600, 94},
  {-116438400, -18000, 94},
  {-100112400, -21600, 94},
  {-84384000, -18000, 94},
  {-68662800, -21600, 94},
  {-52934400, -18000, 94},
  {-37213200, -21600, 94},
  {-21484800, -18000, 94},
  {-5763600, -21600, 94},
  {9964800, -18000, 94},
  {25686000, -21600, 94},
  {41414400, -18000, 94},
  {57740400, -21600, 94},
  {73468800, -18000, 94},
  {89190000, -21600, 94},
  {104918400, -18000, 94},
  {120639600, -21600, 94},
  {126691200, -18000, 94},
  {152089200, -21600, 94},
  {162374400, -18000, 94},
  {183538800, -21600, 94},
  {199267200, -18000, 94},
  {215593200, -21600, 94},
  {230716800, -18000, 94},
  {247042800, -21600, 94},
  {262771200, -18000, 94},
  {278492400, -21600, 94},
  {294220800, -18000, 94},
  {309942000, -21600, 94},
  {325670400, -18000, 94},
  {341391600, -21600, 94},
  {357120000, -18000, 94},
  {372841200, -21600, 94},
  {388569600, -18000, 94},
  {404895600, -21600, 94},
  {420019200, -18000, 94},
  {436345200, -21600, 94},
  {452073600, -18000, 94},
  {467794800, -21600, 94},
  {483523200, -18000, 94},
  {499244400, -21600, 94},
  {514972800, -18000, 94},
  {530694000, -21600, 94},
  {544608000, -18000, 94},
  {562143600, -21600, 94},
  {576057600, -18000, 94},
  {594198000, -21600, 94},
  {607507200, -18000, 94},
  {625647600, -21600, 94},
  {638956800, -18000, 94},
  {657097200, -21600, 94},
  {671011200, -18000, 94},
  {688546800, -21600, 94},
  {702460800, -18000, 94},
  {719996400, -21600, 94},
  {733910400, -18000, 94},
  {752050800, -21600, 94},
  {765360000, -18000, 94},
  {783500400, -21600, 94},
  {796809600, -18000, 94},
  {814950000, -21600, 94},
  {828864000, -18000, 94},
  {846399600, -21600, 94},
  {860313600, -18000, 94},
  {877849200, -21600, 94},
  {891763200, -18000, 94},
  {909298800, -21600, 94},
  {923212800, -18000, 94},
  {941353200, -21600, 94},
  {954662400, -18000, 94},
  {972802800, -21600, 94},
  {986112000, -18000, 94},
  {1004252400, -21600, 94},
  {1018166400, -18000, 94},
  {1035702000, -21600, 94},
  {1049616000, -18000, 94},
  {1067151600, -21600, 94},
  {1081065600, -18000, 94},
  {1099206000, -21600, 94},
  {1112515200, -18000, 94},
  {1130655600, -21600, 94},
  {1143964800, -18000, 94},
  {1162105200, -21600, 94},
  {1173600000, -18000, 94},
  {1194159600, -21600, 94},
  {1205049600, -18000, 94},
  {1225609200, -21600, 94},
  {1236499200, -18000, 94},
  {1257058800, -21600, 94},
  {1268553600, -18000, 94},
  {1289113200, -21600, 94},
  {1300003200, -18000, 94},
  {1320562800, -21600, 94},
  {1331452800, -18000, 94},
  {1352012400, -21600, 94},
  {1362902400, -18000, 94},
  {1383462000, -21600, 94},
  {1394352000, -18000, 94},
  {1414911600, -21600, 94},
  {1425801600, -18000, 94},
  {1446361200, -21600, 94},
  {1457856000, -18000, 94},
  {1478415600, -21600, 94},
  {1489305600, -18000, 94},
  {1509865200, -21600, 94},
  {1520755200, -18000, 94},
  {1541314800, -21600, 94},
  {1552204800, -18000, 94},
  {1572764400, -21600, 94},
  {1583654400, -18000, 94},
  {1604214000, -21600, 94},
  {1615708800, -18000, 94},
  {1636268400, -21600, 94},
  {1647158400, -18000, 94},
  {1667718000, -21600, 94},
  {1678608000, -18000, 94},
  {1699167600, -21600, 94},
  {1710057600, -18000, 94},
  {1730617200, -21600, 94},
  {1741507200, -18000, 94},
  {1762066800, -21600, 94},
  {1772956800, -18000, 94},
  {1793516400, -21600, 94},
  {1805011200, -18000, 94},
  {1825570800, -21600, 94},
  {1836460800, -18000, 94},
  {1857020400, -21600, 94},
  {1867910400, -18000, 94},
  {1888470000, -21600, 94},
  {1899360000, -18000, 94},
  {1919919600, -21600, 94},
  {1930809600, -18000, 94},
  {1951369200, -21600, 94},
  {1962864000, -18000, 94},
  {1983423600, -21600, 94},
  {1994313600, -18000, 94},
  {2014873200, -21600, 94},
  {2025763200, -18000, 94},
  {2046322800, -21600, 94},
  {2057212800, -18000, 94},
  {2077772400, -21600, 94},
  {2088662400, -18000, 94},
  {2109222000, -21600, 94},
  {2120112000, -18000, 94},
  {2140671600, -21600, 94},
  {INT64_MIN, -25460, 95},
  {-1514739600, -25200, 95},
  {-1343066400, -21600, 95},
  {-1234807200, -25200, 95},
  {-1220292000, -21600, 95},
  {-1207159200, -25200, 95},
  {-1191344400, -21600, 95},
  {828864000, -18000, 95},
  {846399600, -21600, 95},
  {860313600, -18000, 95},
  {877849200, -21600, 95},
  {891766800, -21600, 95},
  {909302400, -25200, 95},
  {923216400, -21600, 95},
  {941356800, -25200, 95},
  {954666000, -21600, 95},
  {972806400, -25200, 95},
  {989139600, -21600, 95},
  {1001836800, -25200, 95},
  {1018170000, -21600, 95},
  {1035705600, -25200, 95},
  {1049619600, -21600, 95},
  {1067155200, -25200, 95},
  {1081069200, -21600, 95},
  {1099209600, -25200, 95},
  {1112518800, -21600, 95},
  {1130659200, -25200, 95},
  {1143968400, -21600, 95},
  {1162108800, -25200, 95},
  {1175418000, -21600, 95},
  {1193558400, -25200, 95},
  {1207472400, -21600, 95},
  {1225008000, -25200, 95},
  {1238922000, -21600, 95},
  {1256457600, -25200, 95},
  {1270371600, -21600, 95},
  {1288512000, -25200, 95},
  {1301821200, -21600, 95},
  {1319961600, -25200, 95},
  {1333270800, -21600, 95},
  {1351411200, -25200, 95},
  {1365325200, -21600, 95},
  {1382860800, -25200, 95},
  {1396774800, -21600, 95},
  {1414310400, -25200, 95},
  {1428224400, -21600, 95},
  {1445760000, -25200, 95},
  {1459674000, -21600, 95},
  {1477814400, -25200, 95},
  {1491123600, -21600, 95},
  {1509264000, -25200, 95},
  {1522573200, -21600, 95},
  {1540713600, -25200, 95},
  {1554627600, -21600, 95},
  {1572163200, -25200, 95},
  {1586077200, -21600, 95},
  {1603612800, -25200, 95},
  {1617526800, -21600, 95},
  {1635667200, -25200, 95},
  {1648976400, -21600, 95},
  {1667116800, -25200, 95},
  {1680426000, -21600, 95},
  {1698566400, -25200, 95},
  {1712480400, -21600, 95},
  {1730016000, -25200, 95},
  {1743930000, -21600, 95},
  {1761465600, -25200, 95},
  {1775379600, -21600, 95},
  {1792915200, -25200, 95},
  {1806829200, -21600, 95},
  {1824969600, -25200, 95},
  {1838278800, -21600, 95},
  {1856419200, -25200, 95},
  {1869728400, -21600, 95},
  {1887868800, -25200, 95},
  {1901782800, -21600, 95},
  {1919318400, -25200, 95},
  {1933232400, -21600, 95},
  {1950768000, -25200, 95},
  {1964682000, -21600, 95},
  {1982822400, -25200, 95},
  {1996131600, -21600, 95},
  {2014272000, -25200, 95},
  {2027581200, -21600, 95},
  {2045721600, -25200, 95},
  {2059030800, -21600, 95},
  {2077171200, -25200, 95},
  {2091085200, -21600, 95},
  {2108620800, -25200, 95},
  {2122534800, -21600, 95},
  {2140070400, -25200, 95},
  {-1632067200, -18000, 96},
  {-1614790800, -21600, 96},
  {-923248800, -18000, 96},
  {-880214400, -18000, 96},
  {-769395600, -18000, 96},
  {-765392400, -18000, 96},
  {INT64_MIN, -15408, 97},
  {-1567453392, -14400, 97},
  {-1233432000, -10800, 97},
  {-1222981200, -14400, 97},
  {-1205956800, -10800, 97},
  {-1194037200, -14400, 97},
  {-1172865600, -10800, 97},
  {-1162501200, -14400, 97},
  {-1141329600, -10800, 97},
  {-1130965200, -14400, 97},
  {-1109793600, -10800, 97},
  {-1099429200, -14400, 97},
  {-1078257600, -10800, 97},
  {-1067806800, -14400, 97},
  {-1046635200, -10800, 97},
  {-1036270800, -14400, 97},
  {-1015099200, -10800, 97},
  {-1004734800, -14400, 97},
  {-983563200, -10800, 97},
  {-973198800, -14400, 97},
  {-952027200, -10800, 97},
  {-941576400, -14400, 97},
  {-931032000, -10800, 97},
  {-900882000, -14400, 97},
  {-890337600, -10800, 97},
  {-833749200, -14400, 97},
  {-827265600, -10800, 97},
  {-752274000, -14400, 97},
  {-733780800, -10800, 97},
  {-197326800, -14400, 97},
  {-190843200, -10800, 97},
  {-184194000, -14400, 97},
  {-164491200, -10800, 97},
  {-152658000, -14400, 97},
  {-132955200, -10800, 97},
  {-121122000, -14400, 97},
  {-101419200, -10800, 97},
  {-86821200, -14400, 97},
  {-71092800, -10800, 97},
  {-54766800, -14400, 97},
  {-39038400, -10800, 97},
  {-23317200, -14400, 97},
  {-7588800, -10800, 97},
  {128142000, -7200, 97},
  {136605600, -10800, 97},
  {596948400, -7200, 97},
  {605066400, -10800, 97},
  {624423600, -7200, 97},
  {636516000, -10800, 97},
  {656478000, -7200, 97},
  {667965600, -14400, 97},
  {687931200, -7200, 97},
  {699415200, -10800, 97},
  {719377200, -7200, 97},
  {731469600, -10800, 97},
  {938919600, -10800, 97},
  {952052400, -10800, 97},
  {1198983600, -7200, 97},
  {1205632800, -10800, 97},
  {1224385200, -7200, 97},
  {1237082400, -10800, 97},
  {INT64_MIN, -20180, 98},
  {-1545071020, -21600, 98},
  {288770400, -18000, 98},
  {297234000, -21600, 98},
  {320220000, -18000, 98},
  {328683600, -21600, 98},
  {664264800, -18000, 98},
  {678344400, -21600, 98},
  {695714400, -18000, 98},
  {700635600, -21600, 98},
  {INT64_MIN, -13460, 99},
  {-1767212140, -14400, 99},
  {-1206954000, -10800, 99},
  {-1191358800, -14400, 99},
  {-1175371200, -10800, 99},
  {-1159822800, -14400, 99},
  {-633816000, -10800, 99},
  {-622065600, -14400, 99},
  {-602280000, -10800, 99},
  {-591829200, -14400, 99},
  {-570744000, -10800, 99},
  {-560206800, -14400, 99},
  {-539121600, -10800, 99},
  {-531349200, -14400, 99},
  {-191361600, -10800, 99},
  {-184194000, -14400, 99},
  {-155160000, -10800, 99},
  {-150066000, -14400, 99},
  {-128894400, -10800, 99},
  {-121122000, -14400, 99},
  {-99950400, -10800, 99},
  {-89586000, -14400, 99},
  {-68414400, -10800, 99},
  {-57963600, -14400, 99},
  {499752000, -10800, 99},
  {511239600, -14400, 99},
  {530596800, -10800, 99},
  {540270000, -14400, 99},
  {562132800, -10800, 99},
  {571201200, -14400, 99},
  {592977600, -10800, 99},
  {602046000, -14400, 99},
  {624427200, -10800, 99},
  {634705200, -14400, 99},
  {656481600, -10800, 99},
  {666759600, -14400, 99},
  {687931200, -10800, 99},
  {697604400, -14400, 99},
  {719985600, -10800, 99},
  {728449200, -14400, 99},
  {750830400, -10800, 99},
  {761713200, -14400, 99},
  {782280000, -10800, 99},
  {793162800, -14400, 99},
  {813729600, -10800, 99},
  {824007600, -14400, 99},
  {844574400, -10800, 99},
  {856062000, -14400, 99},
  {876110400, -10800, 99},
  {888721200, -14400, 99},
  {908078400, -10800, 99},
  {919566000, -14400, 99},
  {938923200, -10800, 99},
  {951620400, -14400, 99},
  {970977600, -10800, 99},
  {982465200, -14400, 99},
  {1003032000, -10800, 99},
  {1013914800, -14400, 99},
  {1036296000, -10800, 99},
  {1045364400, -14400, 99},
  {1099368000, -10800, 99},
  {1108868400, -14400, 99},
  {1129435200, -10800, 99},
  {1140318000, -14400, 99},
  {1162699200, -10800, 99},
  {1172372400, -14400, 99},
  {1192334400, -10800, 99},
  {1203217200, -14400, 99},
  {1224388800, -10800, 99},
  {1234666800, -14400, 99},
  {1255838400, -10800, 99},
  {1266721200, -14400, 99},
  {1287288000, -10800, 99},
  {1298170800, -14400, 99},
  {1318737600, -10800, 99},
  {1330225200, -14400, 99},
  {1350792000, -10800, 99},
  {1361070000, -14400, 99},
  {1382241600, -10800, 99},
  {1392519600, -14400, 99},
  {1413691200, -10800, 99},
  {1424574000, -14400, 99},
  {1445140800, -10800, 99},
  {1456023600, -14400, 99},
  {1476590400, -10800, 99},
  {1487473200, -14400, 99},
  {1508040000, -10800, 99},
  {1518922800, -14400, 99},
  {1540094400, -10800, 99},
  {1550372400, -14400, 99},
  {1571544000, -10800, 99},
  {1581822000, -14400, 99},
  {1602993600, -10800, 99},
  {1613876400, -14400, 99},
  {1634443200, -10800, 99},
  {1645326000, -14400, 99},
  {1665892800, -10800, 99},
  {1677380400, -14400, 99},
  {1697342400, -10800, 99},
  {1708225200, -14400, 99},
  {1729396800, -10800, 99},
  {1739674800, -14400, 99},
  {1760846400, -10800, 99},
  {1771729200, -14400, 99},
  {1792296000, -10800, 99},
  {1803178800, -14400, 99},
  {1823745600, -10800, 99},
  {1834628400, -14400, 99},
  {1855195200, -10800, 99},
  {1866078000, -14400, 99},
  {1887249600, -10800, 99},
  {1897527600, -14400, 99},
  {1918699200, -10800, 99},
  {1928977200, -14400, 99},
  {1950148800, -10800, 99},
  {1960426800, -14400, 99},
  {1981598400, -10800, 99},
  {1992481200, -14400, 99},
  {2013048000, -10800, 99},
  {2024535600, -14400, 99},
  {2044497600, -10800, 99},
  {2055380400, -14400, 99},
  {2076552000, -10800, 99},
  {2086830000, -14400, 99},
  {2108001600, -10800, 99},
  {2118884400, -14400, 99},
  {2139451200, -10800, 99},
  {INT64_MIN, -16544, 100},
  {-1826738656, -16200, 100},
  {-157750200, -14400, 100},
  {INT64_MIN, -4480, 101},
  {-1686091520, -10800, 101},
  {323845200, -7200, 101},
  {338950800, -10800, 101},
  {354675600, -7200, 101},
  {370400400, -10800, 101},
  {386125200, -7200, 101},
  {401850000, -10800, 101},
  {417574800, -7200, 101},
  {433299600, -10800, 101},
  {449024400, -7200, 101},
  {465354000, -10800, 101},
  {481078800, -7200, 101},
  {496803600, -10800, 101},
  {512528400, -7200, 101},
  {528253200, -10800, 101},
  {543978000, -7200, 101},
  {559702800, -10800, 101},
  {575427600, -7200, 101},
  {591152400, -10800, 101},
  {606877200, -7200, 101},
  {622602000, -10800, 101},
  {638326800, -7200, 101},
  {654656400, -10800, 101},
  {670381200, -7200, 101},
  {686106000, -10800, 101},
  {701830800, -7200, 101},
  {717555600, -10800, 101},
  {733280400, -7200, 101},
  {749005200, -10800, 101},
  {764730000, -7200, 101},
  {780454800, -10800, 101},
  {796179600, -7200, 101},
  {811904400, -10800, 101},
  {820465200, 0, 101},
  {-1632056400, -28800, 102},
  {-1615125600, -32400, 102},
  {-1596978000, -28800, 102},
  {-1583164800, -32400, 102},
  {-880203600, -28800, 102},
  {-769395600, -28800, 102},
  {-765381600, -32400, 102},
  {-147884400, -25200, 102},
  {-131554800, -32400, 102},
  {120646800, -28800, 102},
  {325677600, -25200, 102},
  {341398800, -28800, 102},
  {357127200, -25200, 102},
  {372848400, -28800, 102},
  {388576800, -25200, 102},
  {404902800, -28800, 102},
  {420026400, -25200, 102},
  {436352400, -28800, 102},
  {452080800, -25200, 102},
  {467802000, -28800, 102},
  {483530400, -25200, 102},
  {499251600, -28800, 102},
  {514980000, -25200, 102},
  {530701200, -28800, 102},
  {544615200, -25200, 102},
  {562150800, -28800, 102},
  {576064800, -25200, 102},
  {594205200, -28800, 102},
  {607514400, -25200, 102},
  {625654800, -28800, 102},
  {638964000, -25200, 102},
  {657104400, -28800, 102},
  {671018400, -25200, 102},
  {688554000, -28800, 102},
  {702468000, -25200, 102},
  {720003600, -28800, 102},
  {733917600, -25200, 102},
  {752058000, -28800, 102},
  {765367200, -25200, 102},
  {783507600, -28800, 102},
  {796816800, -25200, 102},
  {814957200, -28800, 102},
  {828871200, -25200, 102},
  {846406800, -28800, 102},
  {860320800, -25200, 102},
  {877856400, -28800, 102},
  {891770400, -25200, 102},
  {909306000, -28800, 102},
  {923220000, -25200, 102},
  {941360400, -28800, 102},
  {954669600, -25200, 102},
  {972810000, -28800, 102},
  {986119200, -25200, 102},
  {1004259600, -28800, 102},
  {1018173600, -25200, 102},
  {1035709200, -28800, 102},
  {1049623200, -25200, 102},
  {1067158800, -28800, 102},
  {1081072800, -25200, 102},
  {1099213200, -28800, 102},
  {1112522400, -25200, 102},
  {1130662800, -28800, 102},
  {1143972000, -25200, 102},
  {1162112400, -28800, 102},
  {1173607200, -25200, 102},
  {1194166800, -28800, 102},
  {1205056800, -25200, 102},
  {1225616400, -28800, 102},
  {1236506400, -25200, 102},
  {1257066000, -28800, 102},
  {1268560800, -25200, 102},
  {1289120400, -28800, 102},
  {1300010400, -25200, 102},
  {1320570000, -28800, 102},
  {1331460000, -25200, 102},
  {1352019600, -28800, 102},
  {1362909600, -25200, 102},
  {1383469200, -28800, 102},
  {1394359200, -25200, 102},
  {1414918800, -28800, 102},
  {1425808800, -25200, 102},
  {1446368400, -28800, 102},
  {1457863200, -25200, 102},
  {1478422800, -28800, 102},
  {1489312800, -25200, 102},
  {1509872400, -28800, 102},
  {1520762400, -25200, 102},
  {1541322000, -28800, 102},
  {1552212000, -25200, 102},
  {1572771600, -28800, 102},
  {1583661600, -25200, 102},
  {1604221200, -28800, 102},
  {1615716000, -25200, 102},
  {1636275600, -28800, 102},
  {1647165600, -25200, 102},
  {1667725200, -28800, 102},
  {1678615200, -25200, 102},
  {1699174800, -28800, 102},
  {1710064800, -25200, 102},
  {1730624400, -28800, 102},
  {1741514400, -25200, 102},
  {1762074000, -28800, 102},
  {1772964000, -25200, 102},
  {1793523600, -28800, 102},
  {1805018400, -25200, 102},
  {1825578000, -28800, 102},
  {1836468000, -25200, 102},
  {1857027600, -28800, 102},
  {1867917600, -25200, 102},
  {1888477200, -28800, 102},
  {1899367200, -25200, 102},
  {1919926800, -28800, 102},
  {1930816800, -25200, 102},
  {1951376400, -28800, 102},
  {1962871200, -25200, 102},
  {1983430800, -28800, 102},
  {1994320800, -25200, 102},
  {2014880400, -28800, 102},
  {2025770400, -25200, 102},
  {2046330000, -28800, 102},
  {2057220000, -25200, 102},
  {2077779600, -28800, 102},
  {2088669600, -25200, 102},
  {2109229200, -28800, 102},
  {2120119200, -25200, 102},
  {2140678800, -28800, 102},
  {-1632060000, -25200, 103},
  {-1614783600, -28800, 103},
  {-880207200, -25200, 103},
  {-769395600, -25200, 103},
  {-765385200, -28800, 103},
  {-715788000, -25200, 103},
  {-702486000, -28800, 103},
  {-684338400, -25200, 103},
  {-671036400, -28800, 103},
  {-652888800, -25200, 103},
  {-639586800, -28800, 103},
  {-620834400, -25200, 103},
  {-608137200, -28800, 103},
  {-589384800, -25200, 103},
  {-576082800, -28800, 103},
  {-557935200, -25200, 103},
  {-544633200, -28800, 103},
  {-526485600, -25200, 103},
  {-513183600, -28800, 103},
  {-495036000, -25200, 103},
  {-481734000, -28800, 103},
  {-463586400, -25200, 103},
  {-450284400, -28800, 103},
  {-431532000, -25200, 103},
  {-418230000, -28800, 103},
  {-400082400, -25200, 103},
  {-386780400, -28800, 103},
  {-368632800, -25200, 103},
  {-355330800, -28800, 103},
  {-337183200, -25200, 103},
  {-323881200, -28800, 103},
  {-305733600, -25200, 103},
  {-292431600, -28800, 103},
  {-273679200, -25200, 103},
  {-260982000, -28800, 103},
  {-242229600, -25200, 103},
  {-226508400, -28800, 103},
  {-210780000, -25200, 103},
  {-195058800, -28800, 103},
  {-179330400, -25200, 103},
  {-163609200, -28800, 103},
  {-147880800, -25200, 103},
  {-131554800, -28800, 103},
  {-116431200, -25200, 103},
  {-100105200, -28800, 103},
  {-84376800, -25200, 103},
  {-68655600, -28800, 103},
  {-52927200, -25200, 103},
  {-37206000, -28800, 103},
  {-21477600, -25200, 103},
  {-5756400, -28800, 103},
  {9972000, -25200, 103},
  {25693200, -28800, 103},
  {41421600, -25200, 103},
  {57747600, -28800, 103},
  {73476000, -25200, 103},
  {84013200, -25200, 103},
  {-1633273200, -21600, 104},
  {-1615132800, -25200, 104},
  {-1601823600, -21600, 104},
  {-1583683200, -25200, 104},
  {-1570374000, -21600, 104},
  {-1551628800, -25200, 104},
  {-1538924400, -21600, 104},
  {-1534089600, -25200, 104},
  {-880210800, -21600, 104},
  {-769395600, -21600, 104},
  {-765388800, -25200, 104},
  {-147884400, -21600, 104},
  {-131558400, -25200, 104},
  {-116434800, -21600, 104},
  {-100108800, -25200, 104},
  {-84380400, -21600, 104},
  {-68659200, -25200, 104},
  {-52930800, -21600, 104},
  {-37209600, -25200, 104},
  {-21481200, -21600, 104},
  {-5760000, -25200, 104},
  {9968400, -21600, 104},
  {25689600, -25200, 104},
  {41418000, -21600, 104},
  {57744000, -25200, 104},
  {73472400, -21600, 104},
  {89193600, -25200, 104},
  {104922000, -21600, 104},
  {120643200, -25200, 104},
  {126694800, -21600, 104},
  {152092800, -25200, 104},
  {162378000, -21600, 104},
  {183542400, -25200, 104},
  {199270800, -21600, 104},
  {215596800, -25200, 104},
  {230720400, -21600, 104},
  {247046400, -25200, 104},
  {262774800, -21600, 104},
  {278496000, -25200, 104},
  {294224400, -21600, 104},
  {309945600, -25200, 104},
  {325674000, -21600, 104},
  {341395200, -25200, 104},
  {357123600, -21600, 104},
  {372844800, -25200, 104},
  {388573200, -21600, 104},
  {404899200, -25200, 104},
  {420022800, -21600, 104},
  {436348800, -25200, 104},
  {452077200, -21600, 104},
  {467798400, -25200, 104},
  {483526800, -21600, 104},
  {499248000, -25200, 104},
  {514976400, -21600, 104},
  {530697600, -25200, 104},
  {544611600, -21600, 104},
  {562147200, -25200, 104},
  {576061200, -21600, 104},
  {594201600, -25200, 104},
  {607510800, -21600, 104},
  {625651200, -25200, 104},
  {638960400, -21600, 104},
  {657100800, -25200, 104},
  {671014800, -21600, 104},
  {688550400, -25200, 104},
  {702464400, -21600, 104},
  {720000000, -25200, 104},
  {733914000, -21600, 104},
  {752054400, -25200, 104},
  {765363600, -21600, 104},
  {783504000, -25200, 104},
  {796813200, -21600, 104},
  {814953600, -25200, 104},
  {828867600, -21600, 104},
  {846403200, -25200, 104},
  {860317200, -21600, 104},
  {877852800, -25200, 104},
  {891766800, -21600, 104},
  {909302400, -25200, 104},
  {923216400, -21600, 104},
  {941356800, -25200, 104},
  {954666000, -21600, 104},
  {972806400, -25200, 104},
  {986115600, -21600, 104},
  {1004256000, -25200, 104},
  {1018170000, -21600, 104},
  {1035705600, -25200, 104},
  {1049619600, -21600, 104},
  {1067155200, -25200, 104},
  {1081069200, -21600, 104},
  {1099209600, -25200, 104},
  {1112518800, -21600, 104},
  {1130659200, -25200, 104},
  {1143968400, -21600, 104},
  {1162108800, -25200, 104},
  {1173603600, -21600, 104},
  {1194163200, -25200, 104},
  {1205053200, -21600, 104},
  {1225612800, -25200, 104},
  {1236502800, -21600, 104},
  {1257062400, -25200, 104},
  {1268557200, -21600, 104},
  {1289116800, -25200, 104},
  {1300006800, -21600, 104},
  {1320566400, -25200, 104},
  {1331456400, -21600, 104},
  {1352016000, -25200, 104},
  {1362906000, -21600, 104},
  {1383465600, -25200, 104},
  {1394355600, -21600, 104},
  {1414915200, -25200, 104},
  {1425805200, -21600, 104},
  {1446364800, -25200, 104},
  {1457859600, -21600, 104},
  {1478419200, -25200, 104},
  {1489309200, -21600, 104},
  {1509868800, -25200, 104},
  {1520758800, -21600, 104},
  {1541318400, -25200, 104},
  {1552208400, -21600, 104},
  {1572768000, -25200, 104},
  {1583658000, -21600, 104},
  {1604217600, -25200, 104},
  {1615712400, -21600, 104},
  {1636272000, -25200, 104},
  {1647162000, -21600, 104},
  {1667721600, -25200, 104},
  {1678611600, -21600, 104},
  {1699171200, -25200, 104},
  {1710061200, -21600, 104},
  {1730620800, -25200, 104},
  {1741510800, -21600, 104},
  {1762070400, -25200, 104},
  {1772960400, -21600, 104},
  {1793520000, -25200, 104},
  {1805014800, -21600, 104},
  {1825574400, -25200, 104},
  {1836464400, -21600, 104},
  {1857024000, -25200, 104},
  {1867914000, -21600, 104},
  {1888473600, -25200, 104},
  {1899363600, -21600, 104},
  {1919923200, -25200, 104},
  {1930813200, -21600, 104},
  {1951372800, -25200, 104},
  {1962867600, -21600, 104},
  {1983427200, -25200, 104},
  {1994317200, -21600, 104},
  {2014876800, -25200, 104},
  {2025766800, -21600, 104},
  {2046326400, -25200, 104},
  {2057216400, -21600, 104},
  {2077776000, -25200, 104},
  {2088666000, -21600, 104},
  {2109225600, -25200, 104},
  {2120115600, -21600, 104},
  {2140675200, -25200, 104},
  {INT64_MIN, -19931, 105},
  {-2051202469, -21600, 105},
  {-1724083200, -18000, 105},
  {-880218000, -14400, 105},
  {-769395600, -14400, 105},
  {-765396000, -18000, 105},
  {-684349200, -14400, 105},
  {-671047200, -18000, 105},
  {-80499600, -14400, 105},
  {-68666400, -18000, 105},
  {104914800, -14400, 105},
  {120636000, -18000, 105},
  {126687600, -14400, 105},
  {152085600, -18000, 105},
  {167814000, -14400, 105},
  {183535200, -18000, 105},
  {199263600, -14400, 105},
  {215589600, -18000, 105},
  {230713200, -14400, 105},
  {247039200, -18000, 105},
  {262767600, -14400, 105},
  {278488800, -18000, 105},
  {294217200, -14400, 105},
  {309938400, -18000, 105},
  {325666800, -14400, 105},
  {341388000, -18000, 105},
  {357116400, -14400, 105},
  {372837600, -18000, 105},
  {388566000, -14400, 105},
  {404892000, -18000, 105},
  {420015600, -14400, 105},
  {436341600, -18000, 105},
  {452070000, -14400, 105},
  {467791200, -18000, 105},
  {483519600, -14400, 105},
  {499240800, -18000, 105},
  {514969200, -14400, 105},
  {530690400, -18000, 105},
  {544604400, -14400, 105},
  {562140000, -18000, 105},
  {576054000, -14400, 105},
  {594194400, -18000, 105},
  {607503600, -14400, 105},
  {625644000, -18000, 105},
  {638953200, -14400, 105},
  {657093600, -18000, 105},
  {671007600, -14400, 105},
  {688543200, -18000, 105},
  {702457200, -14400, 105},
  {719992800, -18000, 105},
  {733906800, -14400, 105},
  {752047200, -18000, 105},
  {765356400, -14400, 105},
  {783496800, -18000, 105},
  {796806000, -14400, 105},
  {814946400, -18000, 105},
  {828860400, -14400, 105},
  {846396000, -18000, 105},
  {860310000, -14400, 105},
  {877845600, -18000, 105},
  {891759600, -14400, 105},
  {909295200, -18000, 105},
  {923209200, -14400, 105},
  {941349600, -18000, 105},
  {954658800, -14400, 105},
  {972799200, -18000, 105},
  {986108400, -14400, 105},
  {1004248800, -18000, 105},
  {1018162800, -14400, 105},
  {1035698400, -18000, 105},
  {1049612400, -14400, 105},
  {1067148000, -18000, 105},
  {1081062000, -14400, 105},
  {1099202400, -18000, 105},
  {1112511600, -14400, 105},
  {1130652000, -18000, 105},
  {1143961200, -14400, 105},
  {1162101600, -18000, 105},
  {1173596400, -14400, 105},
  {1194156000, -18000, 105},
  {1205046000, -14400, 105},
  {1225605600, -18000, 105},
  {1236495600, -14400, 105},
  {1257055200, -18000, 105},
  {1268550000, -14400, 105},
  {1289109600, -18000, 105},
  {1299999600, -14400, 105},
  {1320559200, -18000, 105},
  {1331449200, -14400, 105},
  {1352008800, -18000, 105},
  {1362898800, -14400, 105},
  {1383458400, -18000, 105},
  {1394348400, -14400, 105},
  {1414908000, -18000, 105},
  {1425798000, -14400, 105},
  {1446357600, -18000, 105},
  {1457852400, -14400, 105},
  {1478412000, -18000, 105},
  {1489302000, -14400, 105},
  {1509861600, -18000, 105},
  {1520751600, -14400, 105},
  {1541311200, -18000, 105},
  {1552201200, -14400, 105},
  {1572760800, -18000, 105},
  {1583650800, -14400, 105},
  {1604210400, -18000, 105},
  {1615705200, -14400, 105},
  {1636264800, -18000, 105},
  {1647154800, -14400, 105},
  {1667714400, -18000, 105},
  {1678604400, -14400, 105},
  {1699164000, -18000, 105},
  {1710054000, -14400, 105},
  {1730613600, -18000, 105},
  {1741503600, -14400, 105},
  {1762063200, -18000, 105},
  {1772953200, -14400, 105},
  {1793512800, -18000, 105},
  {1805007600, -14400, 105},
  {1825567200, -18000, 105},
  {1836457200, -14400, 105},
  {1857016800, -18000, 105},
  {1867906800, -14400, 105},
  {1888466400, -18000, 105},
  {1899356400, -14400, 105},
  {1919916000, -18000, 105},
  {1930806000, -14400, 105},
  {1951365600, -18000, 105},
  {1962860400, -14400, 105},
  {1983420000, -18000, 105},
  {1994310000, -14400, 105},
  {2014869600, -18000, 105},
  {2025759600, -14400, 105},
  {2046319200, -18000, 105},
  {2057209200, -14400, 105},
  {2077768800, -18000, 105},
  {2088658800, -14400, 105},
  {2109218400, -18000, 105},
  {2120108400, -14400, 105},
  {2140668000, -18000, 105},
  {INT64_MIN, -14736, 106},
  {-1846266804, -14400, 106},
  {INT64_MIN, -27232, 107},
  {-1998663968, -25200, 107},
  {-1632063600, -21600, 107},
  {-1614787200, -25200, 107},
  {-1600614000, -21600, 107},
  {-1596816000, -25200, 107},
  {-1567954800, -21600, 107},
  {-1551628800, -25200, 107},
  {-1536505200, -21600, 107},
  {-1523203200, -25200, 107},
  {-1504450800, -21600, 107},
  {-1491753600, -25200, 107},
  {-1473001200, -21600, 107},
  {-1459699200, -25200, 107},
  {-880210800, -21600, 107},
  {-769395600, -21600, 107},
  {-765388800, -25200, 107},
  {-715791600, -21600, 107},
  {-702489600, -25200, 107},
  {-84380400, -21600, 107},
  {-68659200, -25200, 107},
  {-21481200, -21600, 107},
  {-5760000, -25200, 107},
  {73472400, -21600, 107},
  {89193600, -25200, 107},
  {104922000, -21600, 107},
  {120643200, -25200, 107},
  {136371600, -21600, 107},
  {152092800, -25200, 107},
  {167821200, -21600, 107},
  {183542400, -25200, 107},
  {199270800, -21600, 107},
  {215596800, -25200, 107},
  {230720400, -21600, 107},
  {247046400, -25200, 107},
  {262774800, -21600, 107},
  {278496000, -25200, 107},
  {294224400, -21600, 107},
  {309945600, -25200, 107},
  {325674000, -21600, 107},
  {341395200, -25200, 107},
  {357123600, -21600, 107},
  {372844800, -25200, 107},
  {388573200, -21600, 107},
  {404899200, -25200, 107},
  {420022800, -21600, 107},
  {436348800, -25200, 107},
  {452077200, -21600, 107},
  {467798400, -25200, 107},
  {483526800, -21600, 107},
  {499248000, -25200, 107},
  {514976400, -21600, 107},
  {530697600, -25200, 107},
  {544611600, -21600, 107},
  {562147200, -25200, 107},
  {576061200, -21600, 107},
  {594201600, -25200, 107},
  {607510800, -21600, 107},
  {625651200, -25200, 107},
  {638960400, -21600, 107},
  {657100800, -25200, 107},
  {671014800, -21600, 107},
  {688550400, -25200, 107},
  {702464400, -21600, 107},
  {720000000, -25200, 107},
  {733914000, -21600, 107},
  {752054400, -25200, 107},
  {765363600, -21600, 107},
  {783504000, -25200, 107},
  {796813200, -21600, 107},
  {814953600, -25200, 107},
  {828867600, -21600, 107},
  {846403200, -25200, 107},
  {860317200, -21600, 107},
  {877852800, -25200, 107},
  {891766800, -21600, 107},
  {909302400, -25200, 107},
  {923216400, -21600, 107},
  {941356800, -25200, 107},
  {954666000, -21600, 107},
  {972806400, -25200, 107},
  {986115600, -21600, 107},
  {1004256000, -25200, 107},
  {1018170000, -21600, 107},
  {1035705600, -25200, 107},
  {1049619600, -21600, 107},
  {1067155200, -25200, 107},
  {1081069200, -21600, 107},
  {1099209600, -25200, 107},
  {1112518800, -21600, 107},
  {1130659200, -25200, 107},
  {1143968400, -21600, 107},
  {1162108800, -25200, 107},
  {1173603600, -21600, 107},
  {1194163200, -25200, 107},
  {1205053200, -21600, 107},
  {1225612800, -25200, 107},
  {1236502800, -21600, 107},
  {1257062400, -25200, 107},
  {1268557200, -21600, 107},
  {1289116800, -25200, 107},
  {1300006800, -21600, 107},
  {1320566400, -25200, 107},
  {1331456400, -21600, 107},
  {1352016000, -25200, 107},
  {1362906000, -21600, 107},
  {1383465600, -25200, 107},
  {1394355600, -21600, 107},
  {1414915200, -25200, 107},
  {1425805200, -21600, 107},
  {1446364800, -25200, 107},
  {1457859600, -21600, 107},
  {1478419200, -25200, 107},
  {1489309200, -21600, 107},
  {1509868800, -25200, 107},
  {1520758800, -21600, 107},
  {1541318400, -25200, 107},
  {1552208400, -21600, 107},
  {1572768000, -25200, 107},
  {1583658000, -21600, 107},
  {1604217600, -25200, 107},
  {1615712400, -21600, 107},
  {1636272000, -25200, 107},
  {1647162000, -21600, 107},
  {1667721600, -25200, 107},
  {1678611600, -21600, 107},
  {1699171200, -25200, 107},
  {1710061200, -21600, 107},
  {1730620800, -25200, 107},
  {1741510800, -21600, 107},
  {1762070400, -25200, 107},
  {1772960400, -21600, 107},
  {1793520000, -25200, 107},
  {1805014800, -21600, 107},
  {1825574400, -25200, 107},
  {1836464400, -21600, 107},
  {1857024000, -25200, 107},
  {1867914000, -21600, 107},
  {1888473600, -25200, 107},
  {1899363600, -21600, 107},
  {1919923200, -25200, 107},
  {1930813200, -21600, 107},
  {1951372800, -25200, 107},
  {1962867600, -21600, 107},
  {1983427200, -25200, 107},
  {1994317200, -21600, 107},
  {2014876800, -25200, 107},
  {2025766800, -21600, 107},
  {2046326400, -25200, 107},
  {2057216400, -21600, 107},
  {2077776000, -25200, 107},
  {2088666000, -21600, 107},
  {2109225600, -25200, 107},
  {2120115600, -21600, 107},
  {2140675200, -25200, 107},
  {INT64_MIN, -16768, 108},
  {-1767208832, -18000, 108},
  {-1206950400, -14400, 108},
  {-1191355200, -18000, 108},
  {-1175367600, -14400, 108},
  {-1159819200, -18000, 108},
  {-633812400, -14400, 108},
  {-622062000, -18000, 108},
  {-602276400, -14400, 108},
  {-591825600, -18000, 108},
  {-570740400, -14400, 108},
  {-560203200, -18000, 108},
  {-539118000, -14400, 108},
  {-531345600, -18000, 108},
  {-191358000, -14400, 108},
  {-184190400, -18000, 108},
  {-155156400, -14400, 108},
  {-150062400, -18000, 108},
  {-128890800, -14400, 108},
  {-121118400, -18000, 108},
  {-99946800, -14400, 108},
  {-89582400, -18000, 108},
  {-68410800, -14400, 108},
  {-57960000, -18000, 108},
  {499755600, -14400, 108},
  {511243200, -18000, 108},
  {530600400, -14400, 108},
  {540273600, -18000, 108},
  {562136400, -14400, 108},
  {571204800, -18000, 108},
  {750834000, -14400, 108},
  {761716800, -18000, 108},
  {1214283600, -14400, 108},
  {INT64_MIN, -21408, 109},
  {-1546279392, -21600, 109},
  {547020000, -18000, 109},
  {559717200, -21600, 109},
  {578469600, -18000, 109},
  {591166800, -21600, 109},
  {INT64_MIN, -28084, 110},
  {-1514736000, -25200, 110},
  {-1451667600, -28800, 110},
  {-1343062800, -25200, 110},
  {-1234803600, -28800, 110},
  {-1222963200, -25200, 110},
  {-1207242000, -28800, 110},
  {-873820800, -25200, 110},
  {-769395600, -25200, 110},
  {-761677200, -28800, 110},
  {-686073600, -25200, 110},
  {-661539600, -28800, 110},
  {-495036000, -25200, 110},
  {-481734000, -28800, 110},
  {-463586400, -25200, 110},
  {-450284400, -28800, 110},
  {-431532000, -25200, 110},
  {-418230000, -28800, 110},
  {-400082400, -25200, 110},
  {-386780400, -28800, 110},
  {-368632800, -25200, 110},
  {-355330800, -28800, 110},
  {-337183200, -25200, 110},
  {-323881200, -28800, 110},
  {-305733600, -25200, 110},
  {-292431600, -28800, 110},
  {199274400, -25200, 110},
  {215600400, -28800, 110},
  {230724000, -25200, 110},
  {247050000, -28800, 110},
  {262778400, -25200, 110},
  {278499600, -28800, 110},
  {294228000, -25200, 110},
  {309949200, -28800, 110},
  {325677600, -25200, 110},
  {341398800, -28800, 110},
  {357127200, -25200, 110},
  {372848400, -28800, 110},
  {388576800, -25200, 110},
  {404902800, -28800, 110},
  {420026400, -25200, 110},
  {436352400, -28800, 110},
  {452080800, -25200, 110},
  {467802000, -28800, 110},
  {483530400, -25200, 110},
  {499251600, -28800, 110},
  {514980000, -25200, 110},
  {530701200, -28800, 110},
  {544615200, -25200, 110},
  {562150800, -28800, 110},
  {576064800, -25200, 110},
  {594205200, -28800, 110},
  {607514400, -25200, 110},
  {625654800, -28800, 110},
  {638964000, -25200, 110},
  {657104400, -28800, 110},
  {671018400, -25200, 110},
  {688554000, -28800, 110},
  {702468000, -25200, 110},
  {720003600, -28800, 110},
  {733917600, -25200, 110},
  {752058000, -28800, 110},
  {765367200, -25200, 110},
  {783507600, -28800, 110},
  {796816800, -25200, 110},
  {814957200, -28800, 110},
  {828871200, -25200, 110},
  {846406800, -28800, 110},
  {860320800, -25200, 110},
  {877856400, -28800, 110},
  {891770400, -25200, 110},
  {909306000, -28800, 110},
  {923220000, -25200, 110},
  {941360400, -28800, 110},
  {954669600, -25200, 110},
  {972810000, -28800, 110},
  {986119200, -25200, 110},
  {1004259600, -28800, 110},
  {1018173600, -25200, 110},
  {1035709200, -28800, 110},
  {1049623200, -25200, 110},
  {1067158800, -28800, 110},
  {1081072800, -25200, 110},
  {1099213200, -28800, 110},
  {1112522400, -25200, 110},
  {1130662800, -28800, 110},
  {1143972000, -25200, 110},
  {1162112400, -28800, 110},
  {1175421600, -25200, 110},
  {1193562000, -28800, 110},
  {1207476000, -25200, 110},
  {1225011600, -28800, 110},
  {1238925600, -25200, 110},
  {1256461200, -28800, 110},
  {1268560800, -25200, 110},
  {1289120400, -28800, 110},
  {1300010400, -25200, 110},
  {1320570000, -28800, 110},
  {1331460000, -25200, 110},
  {1352019600, -28800, 110},
  {1362909600, -25200, 110},
  {1383469200, -28800, 110},
  {1394359200, -25200, 110},
  {1414918800, -28800, 110},
  {1425808800, -25200, 110},
  {1446368400, -28800, 110},
  {1457863200, -25200, 110},
  {1478422800, -28800, 110},
  {1489312800, -25200, 110},
  {1509872400, -28800, 110},
  {1520762400, -25200, 110},
  {1541322000, -28800, 110},
  {1552212000, -25200, 110},
  {1572771600, -28800, 110},
  {1583661600, -25200, 110},
  {1604221200, -28800, 110},
  {1615716000, -25200, 110},
  {1636275600, -28800, 110},
  {1647165600, -25200, 110},
  {1667725200, -28800, 110},
  {1678615200, -25200, 110},
  {1699174800, -28800, 110},
  {1710064800, -25200, 110},
  {1730624400, -28800, 110},
  {1741514400, -25200, 110},
  {1762074000, -28800, 110},
  {1772964000, -25200, 110},
  {1793523600, -28800, 110},
  {1805018400, -25200, 110},
  {1825578000, -28800, 110},
  {1836468000, -25200, 110},
  {1857027600, -28800, 110},
  {1867917600, -25200, 110},
  {1888477200, -28800, 110},
  {1899367200, -25200, 110},
  {1919926800, -28800, 110},
  {1930816800, -25200, 110},
  {1951376400, -28800, 110},
  {1962871200, -25200, 110},
  {1983430800, -28800, 110},
  {1994320800, -25200, 110},
  {2014880400, -28800, 110},
  {2025770400, -25200, 110},
  {2046330000, -28800, 110},
  {2057220000, -25200, 110},
  {2077779600, -28800, 110},
  {2088669600, -25200, 110},
  {2109229200, -28800, 110},
  {2120119200, -25200, 110},
  {2140678800, -28800, 110},
  {-1633276800, -18000, 111},
  {-1615136400, -21600, 111},
  {-1601827200, -18000, 111},
  {-1583686800, -21600, 111},
  {-900259200, -18000, 111},
  {-891795600, -21600, 111},
  {-880214400, -18000, 111},
  {-769395600, -18000, 111},
  {-765392400, -21600, 111},
  {-747244800, -18000, 111},
  {-733942800, -21600, 111},
  {-715795200, -18000, 111},
  {-702493200, -21600, 111},
  {-684345600, -18000, 111},
  {-671043600, -21600, 111},
  {-652896000, -18000, 111},
  {-639594000, -21600, 111},
  {-620841600, -18000, 111},
  {-608144400, -21600, 111},
  {-589392000, -18000, 111},
  {-576090000, -21600, 111},
  {-557942400, -18000, 111},
  {-544640400, -21600, 111},
  {-526492800, -18000, 111},
  {-513190800, -21600, 111},
  {-495043200, -18000, 111},
  {-481741200, -21600, 111},
  {-463593600, -18000, 111},
  {-386787600, -21600, 111},
  {-368640000, -18000, 111},
  {-21488400, -14400, 111},
  {-5767200, -18000, 111},
  {9961200, -14400, 111},
  {25682400, -18000, 111},
  {1143961200, -14400, 111},
  {1162101600, -18000, 111},
  {1173596400, -14400, 111},
  {1194156000, -18000, 111},
  {1205046000, -14400, 111},
  {1225605600, -18000, 111},
  {1236495600, -14400, 111},
  {1257055200, -18000, 111},
  {1268550000, -14400, 111},
  {1289109600, -18000, 111},
  {1299999600, -14400, 111},
  {1320559200, -18000, 111},
  {1331449200, -14400, 111},
  {1352008800, -18000, 111},
  {1362898800, -14400, 111},
  {1383458400, -18000, 111},
  {1394348400, -14400, 111},
  {1414908000, -18000, 111},
  {1425798000, -14400, 111},
  {1446357600, -18000, 111},
  {1457852400, -14400, 111},
  {1478412000, -18000, 111},
  {1489302000, -14400, 111},
  {1509861600, -18000, 111},
  {1520751600, -14400, 111},
  {1541311200, -18000, 111},
  {1552201200, -14400, 111},
  {1572760800, -18000, 111},
  {1583650800, -14400, 111},
  {1604210400, -18000, 111},
  {1615705200, -14400, 111},
  {1636264800, -18000, 111},
  {1647154800, -14400, 111},
  {1667714400, -18000, 111},
  {1678604400, -14400, 111},
  {1699164000, -18000, 111},
  {1710054000, -14400, 111},
  {1730613600, -18000, 111},
  {1741503600, -14400, 111},
  {1762063200, -18000, 111},
  {1772953200, -14400, 111},
  {1793512800, -18000, 111},
  {1805007600, -14400, 111},
  {1825567200, -18000, 111},
  {1836457200, -14400, 111},
  {1857016800, -18000, 111},
  {1867906800, -14400, 111},
  {1888466400, -18000, 111},
  {1899356400, -14400, 111},
  {1919916000, -18000, 111},
  {1930806000, -14400, 111},
  {1951365600, -18000, 111},
  {1962860400, -14400, 111},
  {1983420000, -18000, 111},
  {1994310000, -14400, 111},
  {2014869600, -18000, 111},
  {2025759600, -14400, 111},
  {2046319200, -18000, 111},
  {2057209200, -14400, 111},
  {2077768800, -18000, 111},
  {2088658800, -14400, 111},
  {2109218400, -18000, 111},
  {2120108400, -14400, 111},
  {2140668000, -18000, 111},
  {INT64_MIN, -9240, 112},
  {-1767216360, -10800, 112},
  {-1206957600, -7200, 112},
  {-1191362400, -10800, 112},
  {-1175374800, -7200, 112},
  {-1159826400, -10800, 112},
  {-633819600, -7200, 112},
  {-622069200, -10800, 112},
  {-602283600, -7200, 112},
  {-591832800, -10800, 112},
  {-570747600, -7200, 112},
  {-560210400, -10800, 112},
  {-539125200, -7200, 112},
  {-531352800, -10800, 112},
  {-191365200, -7200, 112},
  {-184197600, -10800, 112},
  {-155163600, -7200, 112},
  {-150069600, -10800, 112},
  {-128898000, -7200, 112},
  {-121125600, -10800, 112},
  {-99954000, -7200, 112},
  {-89589600, -10800, 112},
  {-68418000, -7200, 112},
  {-57967200, -10800, 112},
  {499748400, -7200, 112},
  {511236000, -10800, 112},
  {530593200, -7200, 112},
  {540266400, -10800, 112},
  {562129200, -7200, 112},
  {571197600, -10800, 112},
  {592974000, -7200, 112},
  {602042400, -10800, 112},
  {624423600, -7200, 112},
  {634701600, -10800, 112},
  {938919600, -7200, 112},
  {951616800, -10800, 112},
  {970974000, -7200, 112},
  {972180000, -10800, 112},
  {1003028400, -7200, 112},
  {1013911200, -10800, 112},
  {INT64_MIN, -14388, 113},
  {-2131646412, -14400, 113},
  {-1632074400, -10800, 113},
  {-1614798000, -14400, 113},
  {-880221600, -10800, 113},
  {-769395600, -10800, 113},
  {-765399600, -14400, 113},
  {-526500000, -10800, 113},
  {-513198000, -14400, 113},
  {73461600, -10800, 113},
  {89182800, -14400, 113},
  {104911200, -10800, 113},
  {120632400, -14400, 113},
  {136360800, -10800, 113},
  {152082000, -14400, 113},
  {167810400, -10800, 113},
  {183531600, -14400, 113},
  {199260000, -10800, 113},
  {215586000, -14400, 113},
  {230709600, -10800, 113},
  {247035600, -14400, 113},
  {262764000, -10800, 113},
  {278485200, -14400, 113},
  {294213600, -10800, 113},
  {309934800, -14400, 113},
  {325663200, -10800, 113},
  {341384400, -14400, 113},
  {357112800, -10800, 113},
  {372834000, -14400, 113},
  {388562400, -10800, 113},
  {404888400, -14400, 113},
  {420012000, -10800, 113},
  {436338000, -14400, 113},
  {452066400, -10800, 113},
  {467787600, -14400, 113},
  {483516000, -10800, 113},
  {499237200, -14400, 113},
  {514965600, -10800, 113},
  {530686800, -14400, 113},
  {544600800, -10800, 113},
  {562136400, -14400, 113},
  {576050400, -10800, 113},
  {594190800, -14400, 113},
  {607500000, -10800, 113},
  {625640400, -14400, 113},
  {638949600, -10800, 113},
  {657090000, -14400, 113},
  {671004000, -10800, 113},
  {688539600, -14400, 113},
  {702453600, -10800, 113},
  {719989200, -14400, 113},
  {733903200, -10800, 113},
  {752043600, -14400, 113},
  {765352800, -10800, 113},
  {783493200, -14400, 113},
  {796802400, -10800, 113},
  {814942800, -14400, 113},
  {828856800, -10800, 113},
  {846392400, -14400, 113},
  {860306400, -10800, 113},
  {877842000, -14400, 113},
  {891756000, -10800, 113},
  {909291600, -14400, 113},
  {923205600, -10800, 113},
  {941346000, -14400, 113},
  {954655200, -10800, 113},
  {972795600, -14400, 113},
  {986104800, -10800, 113},
  {1004245200, -14400, 113},
  {1018159200, -10800, 113},
  {1035694800, -14400, 113},
  {1049608800, -10800, 113},
  {1067144400, -14400, 113},
  {1081058400, -10800, 113},
  {1099198800, -14400, 113},
  {1112508000, -10800, 113},
  {1130648400, -14400, 113},
  {1143957600, -10800, 113},
  {1162098000, -14400, 113},
  {1173592800, -10800, 113},
  {1194152400, -14400, 113},
  {1205042400, -10800, 113},
  {1225602000, -14400, 113},
  {1236492000, -10800, 113},
  {1257051600, -14400, 113},
  {1268546400, -10800, 113},
  {1289106000, -14400, 113},
  {1299996000, -10800, 113},
  {1320555600, -14400, 113},
  {1331445600, -10800, 113},
  {1352005200, -14400, 113},
  {1362895200, -10800, 113},
  {1383454800, -14400, 113},
  {1394344800, -10800, 113},
  {1414904400, -14400, 113},
  {1425794400, -10800, 113},
  {1446354000, -14400, 113},
  {1457848800, -10800, 113},
  {1478408400, -14400, 113},
  {1489298400, -10800, 113},
  {1509858000, -14400, 113},
  {1520748000, -10800, 113},
  {1541307600, -14400, 113},
  {1552197600, -10800, 113},
  {1572757200, -14400, 113},
  {1583647200, -10800, 113},
  {1604206800, -14400, 113},
  {1615701600, -10800, 113},
  {1636261200, -14400, 113},
  {1647151200, -10800, 113},
  {1667710800, -14400, 113},
  {1678600800, -10800, 113},
  {1699160400, -14400, 113},
  {1710050400, -10800, 113},
  {1730610000, -14400, 113},
  {1741500000, -10800, 113},
  {1762059600, -14400, 113},
  {1772949600, -10800, 113},
  {1793509200, -14400, 113},
  {1805004000, -10800, 113},
  {1825563600, -14400, 113},
  {1836453600, -10800, 113},
  {1857013200, -14400, 113},
  {1867903200, -10800, 113},
  {1888462800, -14400, 113},
  {1899352800, -10800, 113},
  {1919912400, -14400, 113},
  {1930802400, -10800, 113},
  {1951362000, -14400, 113},
  {1962856800, -10800, 113},
  {1983416400, -14400, 113},
  {1994306400, -10800, 113},
  {2014866000, -14400, 113},
  {2025756000, -10800, 113},
  {2046315600, -14400, 113},
  {2057205600, -10800, 113},
  {2077765200, -14400, 113},
  {2088655200, -10800, 113},
  {2109214800, -14400, 113},
  {2120104800, -10800, 113},
  {2140664400, -14400, 113},
  {INT64_MIN, -12416, 114},
  {-1686083584, -10800, 114},
  {323845200, -7200, 114},
  {338950800, -10800, 114},
  {354675600, -7200, 114},
  {370400400, -10800, 114},
  {386125200, -7200, 114},
  {401850000, -10800, 114},
  {417574800, -7200, 114},
  {433299600, -10800, 114},
  {449024400, -7200, 114},
  {465354000, -10800, 114},
  {481078800, -7200, 114},
  {496803600, -10800, 114},
  {512528400, -7200, 114},
  {528253200, -10800, 114},
  {543978000, -7200, 114},
  {559702800, -10800, 114},
  {575427600, -7200, 114},
  {591152400, -10800, 114},
  {606877200, -7200, 114},
  {622602000, -10800, 114},
  {638326800, -7200, 114},
  {654656400, -10800, 114},
  {670381200, -7200, 114},
  {686106000, -10800, 114},
  {701830800, -7200, 114},
  {717555600, -10800, 114},
  {733280400, -7200, 114},
  {749005200, -10800, 114},
  {764730000, -7200, 114},
  {780454800, -10800, 114},
  {796179600, -7200, 114},
  {811904400, -10800, 114},
  {828234000, -7200, 114},
  {846378000, -10800, 114},
  {859683600, -7200, 114},
  {877827600, -10800, 114},
  {891133200, -7200, 114},
  {909277200, -10800, 114},
  {922582800, -7200, 114},
  {941331600, -10800, 114},
  {954032400, -7200, 114},
  {972781200, -10800, 114},
  {985482000, -7200, 114},
  {1004230800, -10800, 114},
  {1017536400, -7200, 114},
  {1035680400, -10800, 114},
  {1048986000, -7200, 114},
  {1067130000, -10800, 114},
  {1080435600, -7200, 114},
  {1099184400, -10800, 114},
  {1111885200, -7200, 114},
  {1130634000, -10800, 114},
  {1143334800, -7200, 114},
  {1162083600, -10800, 114},
  {1174784400, -7200, 114},
  {1193533200, -10800, 114},
  {1206838800, -7200, 114},
  {1224982800, -10800, 114},
  {1238288400, -7200, 114},
  {1256432400, -10800, 114},
  {1269738000, -7200, 114},
  {1288486800, -10800, 114},
  {1301187600, -7200, 114},
  {1319936400, -10800, 114},
  {1332637200, -7200, 114},
  {1351386000, -10800, 114},
  {1364691600, -7200, 114},
  {1382835600, -10800, 114},
  {1396141200, -7200, 114},
  {1414285200, -10800, 114},
  {1427590800, -7200, 114},
  {1445734800, -10800, 114},
  {1459040400, -7200, 114},
  {1477789200, -10800, 114},
  {1490490000, -7200, 114},
  {1509238800, -10800, 114},
  {1521939600, -7200, 114},
  {1540688400, -10800, 114},
  {1553994000, -7200, 114},
  {1572138000, -10800, 114},
  {1585443600, -7200, 114},
  {1603587600, -10800, 114},
  {1616893200, -7200, 114},
  {1635642000, -10800, 114},
  {1648342800, -7200, 114},
  {1667091600, -10800, 114},
  {1679792400, -7200, 114},
  {1698541200, -10800, 114},
  {1711846800, -7200, 114},
  {1729990800, -10800, 114},
  {1743296400, -7200, 114},
  {1761440400, -10800, 114},
  {1774746000, -7200, 114},
  {1792890000, -10800, 114},
  {1806195600, -7200, 114},
  {1824944400, -10800, 114},
  {1837645200, -7200, 114},
  {1856394000, -10800, 114},
  {1869094800, -7200, 114},
  {1887843600, -10800, 114},
  {1901149200, -7200, 114},
  {1919293200, -10800, 114},
  {1932598800, -7200, 114},
  {1950742800, -10800, 114},
  {1964048400, -7200, 114},
  {1982797200, -10800, 114},
  {1995498000, -7200, 114},
  {2014246800, -10800, 114},
  {2026947600, -7200, 114},
  {2045696400, -10800, 114},
  {2058397200, -7200, 114},
  {2077146000, -10800, 114},
  {2090451600, -7200, 114},
  {2108595600, -10800, 114},
  {2121901200, -7200, 114},
  {2140045200, -10800, 114},
  {-1632076148, -9052, 115},
  {-1614799748, -12652, 115},
  {-1096921748, -12600, 115},
  {-1061670600, -9000, 115},
  {-1048973400, -12600, 115},
  {-1030221000, -9000, 115},
  {-1017523800, -12600, 115},
  {-998771400, -9000, 115},
  {-986074200, -12600, 115},
  {-966717000, -9000, 115},
  {-954624600, -12600, 115},
  {-935267400, -9000, 115},
  {-922570200, -12600, 115},
  {-903817800, -9000, 115},
  {-891120600, -12600, 115},
  {-872368200, -9000, 115},
  {-769395600, -9000, 115},
  {-765401400, -12600, 115},
  {-746044200, -9000, 115},
  {-733347000, -12600, 115},
  {-714594600, -9000, 115},
  {-701897400, -12600, 115},
  {-683145000, -9000, 115},
  {-670447800, -12600, 115},
  {-651695400, -9000, 115},
  {-638998200, -12600, 115},
  {-619641000, -9000, 115},
  {-606943800, -12600, 115},
  {-589401000, -9000, 115},
  {-576099000, -12600, 115},
  {-557951400, -9000, 115},
  {-544649400, -12600, 115},
  {-526501800, -9000, 115},
  {-513199800, -12600, 115},
  {-495052200, -9000, 115},
  {-481750200, -12600, 115},
  {-463602600, -9000, 115},
  {-450300600, -12600, 115},
  {-431548200, -9000, 115},
  {-418246200, -12600, 115},
  {-400098600, -9000, 115},
  {-386796600, -12600, 115},
  {-368649000, -9000, 115},
  {-355347000, -12600, 115},
  {-337199400, -9000, 115},
  {-323897400, -12600, 115},
  {-305749800, -9000, 115},
  {-289423800, -12600, 115},
  {-273695400, -9000, 115},
  {-257974200, -12600, 115},
  {-242245800, -9000, 115},
  {-226524600, -12600, 115},
  {-210796200, -9000, 115},
  {-195075000, -12600, 115},
  {-179346600, -9000, 115},
  {-163625400, -12600, 115},
  {-147897000, -9000, 115},
  {-131571000, -12600, 115},
  {-119903400, -14400, 115},
  {-116445600, -10800, 115},
  {-100119600, -14400, 115},
  {-84391200, -10800, 115},
  {-68670000, -14400, 115},
  {-52941600, -10800, 115},
  {-37220400, -14400, 115},
  {-21492000, -10800, 115},
  {-5770800, -14400, 115},
  {9957600, -10800, 115},
  {25678800, -14400, 115},
  {41407200, -10800, 115},
  {57733200, -14400, 115},
  {73461600, -10800, 115},
  {89182800, -14400, 115},
  {104911200, -10800, 115},
  {120632400, -14400, 115},
  {136360800, -10800, 115},
  {152082000, -14400, 115},
  {167810400, -10800, 115},
  {183531600, -14400, 115},
  {199260000, -10800, 115},
  {215586000, -14400, 115},
  {230709600, -10800, 115},
  {247035600, -14400, 115},
  {262764000, -10800, 115},
  {278485200, -14400, 115},
  {294213600, -10800, 115},
  {309934800, -14400, 115},
  {325663200, -10800, 115},
  {341384400, -14400, 115},
  {357112800, -10800, 115},
  {372834000, -14400, 115},
  {388562400, -10800, 115},
  {404888400, -14400, 115},
  {420012000, -10800, 115},
  {436338000, -14400, 115},
  {452066400, -10800, 115},
  {467787600, -14400, 115},
  {483516000, -10800, 115},
  {499237200, -14400, 115},
  {514965600, -10800, 115},
  {530686800, -14400, 115},
  {544593660, -10800, 115},
  {562129260, -14400, 115},
  {576043260, -7200, 115},
  {594180060, -14400, 115},
  {607492860, -10800, 115},
  {625633260, -14400, 115},
  {638942460, -10800, 115},
  {657082860, -14400, 115},
  {670996860, -10800, 115},
  {688532460, -14400, 115},
  {702446460, -10800, 115},
  {719982060, -14400, 115},
  {733896060, -10800, 115},
  {752036460, -14400, 115},
  {765345660, -10800, 115},
  {783486060, -14400, 115},
  {796795260, -10800, 115},
  {814935660, -14400, 115},
  {828849660, -10800, 115},
  {846385260, -14400, 115},
  {860299260, -10800, 115},
  {877834860, -14400, 115},
  {891748860, -10800, 115},
  {909284460, -14400, 115},
  {923198460, -10800, 115},
  {941338860, -14400, 115},
  {954648060, -10800, 115},
  {972788460, -14400, 115},
  {986097660, -10800, 115},
  {1004238060, -14400, 115},
  {1018152060, -10800, 115},
  {1035687660, -14400, 115},
  {1049601660, -10800, 115},
  {1067137260, -14400, 115},
  {1081051260, -10800, 115},
  {1099191660, -14400, 115},
  {1112500860, -10800, 115},
  {1130641260, -14400, 115},
  {1143950460, -10800, 115},
  {1162090860, -14400, 115},
  {1173585660, -10800, 115},
  {1194145260, -14400, 115},
  {1205035260, -10800, 115},
  {1225594860, -14400, 115},
  {1236484860, -10800, 115},
  {1257044460, -14400, 115},
  {1268539260, -10800, 115},
  {1289098860, -14400, 115},
  {1299988860, -10800, 115},
  {1320555600, -14400, 115},
  {1331445600, -10800, 115},
  {1352005200, -14400, 115},
  {1362895200, -10800, 115},
  {1383454800, -14400, 115},
  {1394344800, -10800, 115},
  {1414904400, -14400, 115},
  {1425794400, -10800, 115},
  {1446354000, -14400, 115},
  {1457848800, -10800, 115},
  {1478408400, -14400, 115},
  {1489298400, -10800, 115},
  {1509858000, -14400, 115},
  {1520748000, -10800, 115},
  {1541307600, -14400, 115},
  {1552197600, -10800, 115},
  {1572757200, -14400, 115},
  {1583647200, -10800, 115},
  {1604206800, -14400, 115},
  {1615701600, -10800, 115},
  {1636261200, -14400, 115},
  {1647151200, -10800, 115},
  {1667710800, -14400, 115},
  {1678600800, -10800, 115},
  {1699160400, -14400, 115},
  {1710050400, -10800, 115},
  {1730610000, -14400, 115},
  {1741500000, -10800, 115},
  {1762059600, -14400, 115},
  {1772949600, -10800, 115},
  {1793509200, -14400, 115},
  {1805004000, -10800, 115},
  {1825563600, -14400, 115},
  {1836453600, -10800, 115},
  {1857013200, -14400, 115},
  {1867903200, -10800, 115},
  {1888462800, -14400, 115},
  {1899352800, -10800, 115},
  {1919912400, -14400, 115},
  {1930802400, -10800, 115},
  {1951362000, -14400, 115},
  {1962856800, -10800, 115},
  {1983416400, -14400, 115},
  {1994306400, -10800, 115},
  {2014866000, -14400, 115},
  {2025756000, -10800, 115},
  {2046315600, -14400, 115},
  {2057205600, -10800, 115},
  {2077765200, -14400, 115},
  {2088655200, -10800, 115},
  {2109214800, -14400, 115},
  {2120104800, -10800, 115},
  {2140664400, -14400, 115},
  {INT64_MIN, -18432, 116},
  {-1827687168, -18000, 116},
  {294217200, -14400, 116},
  {309938400, -18000, 116},
  {325666800, -14400, 116},
  {341388000, -18000, 116},
  {357116400, -14400, 116},
  {372837600, -18000, 116},
  {388566000, -14400, 116},
  {404892000, -18000, 116},
  {420015600, -14400, 116},
  {436341600, -18000, 116},
  {452070000, -14400, 116},
  {467791200, -18000, 116},
  {483519600, -14400, 116},
  {499240800, -18000, 116},
  {514969200, -14400, 116},
  {530690400, -18000, 116},
  {544604400, -14400, 116},
  {562140000, -18000, 116},
  {576054000, -14400, 116},
  {594194400, -18000, 116},
  {607503600, -14400, 116},
  {625644000, -18000, 116},
  {638953200, -14400, 116},
  {657093600, -18000, 116},
  {671007600, -14400, 116},
  {688543200, -18000, 116},
  {702457200, -14400, 116},
  {719992800, -18000, 116},
  {733906800, -14400, 116},
  {752047200, -18000, 116},
  {765356400, -14400, 116},
  {783496800, -18000, 116},
  {796806000, -14400, 116},
  {814946400, -18000, 116},
  {828860400, -14400, 116},
  {846396000, -18000, 116},
  {860310000, -14400, 116},
  {877845600, -18000, 116},
  {891759600, -14400, 116},
  {909295200, -18000, 116},
  {923209200, -14400, 116},
  {941349600, -18000, 116},
  {954658800, -14400, 116},
  {972799200, -18000, 116},
  {986108400, -14400, 116},
  {1004248800, -18000, 116},
  {1018162800, -14400, 116},
  {1035698400, -18000, 116},
  {1049612400, -14400, 116},
  {1067148000, -18000, 116},
  {1081062000, -14400, 116},
  {1099202400, -18000, 116},
  {1112511600, -14400, 116},
  {1130652000, -18000, 116},
  {1143961200, -14400, 116},
  {1162101600, -18000, 116},
  {1173596400, -14400, 116},
  {1194156000, -18000, 116},
  {1205046000, -14400, 116},
  {1225605600, -18000, 116},
  {1236495600, -14400, 116},
  {1257055200, -18000, 116},
  {1268550000, -14400, 116},
  {1289109600, -18000, 116},
  {1299999600, -14400, 116},
  {1320559200, -18000, 116},
  {1331449200, -14400, 116},
  {1352008800, -18000, 116},
  {1362898800, -14400, 116},
  {1383458400, -18000, 116},
  {1394348400, -14400, 116},
  {1414908000, -18000, 116},
  {1425798000, -14400, 116},
  {1446357600, -18000, 116},
  {1457852400, -14400, 116},
  {1478412000, -18000, 116},
  {1489302000, -14400, 116},
  {1509861600, -18000, 116},
  {1520751600, -14400, 116},
  {1541311200, -18000, 116},
  {1552201200, -14400, 116},
  {1572760800, -18000, 116},
  {1583650800, -14400, 116},
  {1604210400, -18000, 116},
  {1615705200, -14400, 116},
  {1636264800, -18000, 116},
  {1647154800, -14400, 116},
  {1667714400, -18000, 116},
  {1678604400, -14400, 116},
  {1699164000, -18000, 116},
  {1710054000, -14400, 116},
  {1730613600, -18000, 116},
  {1741503600, -14400, 116},
  {1762063200, -18000, 116},
  {1772953200, -14400, 116},
  {1793512800, -18000, 116},
  {1805007600, -14400, 116},
  {1825567200, -18000, 116},
  {1836457200, -14400, 116},
  {1857016800, -18000, 116},
  {1867906800, -14400, 116},
  {1888466400, -18000, 116},
  {1899356400, -14400, 116},
  {1919916000, -18000, 116},
  {1930806000, -14400, 116},
  {1951365600, -18000, 116},
  {1962860400, -14400, 116},
  {1983420000, -18000, 116},
  {1994310000, -14400, 116},
  {2014869600, -18000, 116},
  {2025759600, -14400, 116},
  {2046319200, -18000, 116},
  {2057209200, -14400, 116},
  {2077768800, -18000, 116},
  {2088658800, -14400, 116},
  {2109218400, -18000, 116},
  {2120108400, -14400, 116},
  {2140668000, -18000, 116},
  {INT64_MIN, -14820, 117},
  {-1846266780, -14400, 117},
  {INT64_MIN, -14768, 118},
  {-1848254032, -14400, 118},
  {INT64_MIN, -21724, 119},
  {-1617040676, -21600, 119},
  {123055200, -18000, 119},
  {130914000, -21600, 119},
  {422344800, -18000, 119},
  {433054800, -21600, 119},
  {669708000, -18000, 119},
  {684219600, -21600, 119},
  {1146376800, -18000, 119},
  {1159678800, -21600, 119},
  {INT64_MIN, -18840, 120},
  {-1230749160, -18000, 120},
  {INT64_MIN, -13960, 121},
  {-1730578040, -13500, 121},
  {-113688900, -13500, 121},
  {176010300, -10800, 121},
  {662698800, -14400, 121},
  {INT64_MIN, -15264, 122},
  {-2131645536, -14400, 122},
  {-1696276800, -10800, 122},
  {-1680469200, -14400, 122},
  {-1632074400, -10800, 122},
  {-1614798000, -14400, 122},
  {-1566763200, -10800, 122},
  {-1557090000, -14400, 122},
  {-1535486400, -10800, 122},
  {-1524949200, -14400, 122},
  {-1504468800, -10800, 122},
  {-1493413200, -14400, 122},
  {-1472414400, -10800, 122},
  {-1461963600, -14400, 122},
  {-1440964800, -10800, 122},
  {-1429390800, -14400, 122},
  {-1409515200, -10800, 122},
  {-1396731600, -14400, 122},
  {-1376856000, -10800, 122},
  {-1366491600, -14400, 122},
  {-1346616000, -10800, 122},
  {-1333832400, -14400, 122},
  {-1313956800, -10800, 122},
  {-1303678800, -14400, 122},
  {-1282507200, -10800, 122},
  {-1272661200, -14400, 122},
  {-1251057600, -10800, 122},
  {-1240088400, -14400, 122},
  {-1219608000, -10800, 122},
  {-1207429200, -14400, 122},
  {-1188763200, -10800, 122},
  {-1175979600, -14400, 122},
  {-1157313600, -10800, 122},
  {-1143925200, -14400, 122},
  {-1124049600, -10800, 122},
  {-1113771600, -14400, 122},
  {-1091390400, -10800, 122},
  {-1081026000, -14400, 122},
  {-1059854400, -10800, 122},
  {-1050786000, -14400, 122},
  {-1030910400, -10800, 122},
  {-1018126800, -14400, 122},
  {-999460800, -10800, 122},
  {-986677200, -14400, 122},
  {-965592000, -10800, 122},
  {-955227600, -14400, 122},
  {-935956800, -10800, 122},
  {-923173200, -14400, 122},
  {-904507200, -10800, 122},
  {-891723600, -14400, 122},
  {-880221600, -10800, 122},
  {-769395600, -10800, 122},
  {-765399600, -14400, 122},
  {-747252000, -10800, 122},
  {-733950000, -14400, 122},
  {-715802400, -10800, 122},
  {-702500400, -14400, 122},
  {-684352800, -10800, 122},
  {-671050800, -14400, 122},
  {-652903200, -10800, 122},
  {-639601200, -14400, 122},
  {-589399200, -10800, 122},
  {-576097200, -14400, 122},
  {-557949600, -10800, 122},
  {-544647600, -14400, 122},
  {-526500000, -10800, 122},
  {-513198000, -14400, 122},
  {-495050400, -10800, 122},
  {-481748400, -14400, 122},
  {-431546400, -10800, 122},
  {-418244400, -14400, 122},
  {-400096800, -10800, 122},
  {-386794800, -14400, 122},
  {-368647200, -10800, 122},
  {-355345200, -14400, 122},
  {-337197600, -10800, 122},
  {-323895600, -14400, 122},
  {-242244000, -10800, 122},
  {-226522800, -14400, 122},
  {-210794400, -10800, 122},
  {-195073200, -14400, 122},
  {-179344800, -10800, 122},
  {-163623600, -14400, 122},
  {-147895200, -10800, 122},
  {-131569200, -14400, 122},
  {-116445600, -10800, 122},
  {-100119600, -14400, 122},
  {-84391200, -10800, 122},
  {-68670000, -14400, 122},
  {-52941600, -10800, 122},
  {-37220400, -14400, 122},
  {-21492000, -10800, 122},
  {-5770800, -14400, 122},
  {9957600, -10800, 122},
  {25678800, -14400, 122},
  {41407200, -10800, 122},
  {57733200, -14400, 122},
  {73461600, -10800, 122},
  {89182800, -14400, 122},
  {104911200, -10800, 122},
  {120632400, -14400, 122},
  {136360800, -10800, 122},
  {152082000, -14400, 122},
  {167810400, -10800, 122},
  {183531600, -14400, 122},
  {199260000, -10800, 122},
  {215586000, -14400, 122},
  {230709600, -10800, 122},
  {247035600, -14400, 122},
  {262764000, -10800, 122},
  {278485200, -14400, 122},
  {294213600, -10800, 122},
  {309934800, -14400, 122},
  {325663200, -10800, 122},
  {341384400, -14400, 122},
  {357112800, -10800, 122},
  {372834000, -14400, 122},
  {388562400, -10800, 122},
  {404888400, -14400, 122},
  {420012000, -10800, 122},
  {436338000, -14400, 122},
  {452066400, -10800, 122},
  {467787600, -14400, 122},
  {483516000, -10800, 122},
  {499237200, -14400, 122},
  {514965600, -10800, 122},
  {530686800, -14400, 122},
  {544600800, -10800, 122},
  {562136400, -14400, 122},
  {576050400, -10800, 122},
  {594190800, -14400, 122},
  {607500000, -10800, 122},
  {625640400, -14400, 122},
  {638949600, -10800, 122},
  {657090000, -14400, 122},
  {671004000, -10800, 122},
  {688539600, -14400, 122},
  {702453600, -10800, 122},
  {719989200, -14400, 122},
  {733903200, -10800, 122},
  {752043600, -14400, 122},
  {765352800, -10800, 122},
  {783493200, -14400, 122},
  {796802400, -10800, 122},
  {814942800, -14400, 122},
  {828856800, -10800, 122},
  {846392400, -14400, 122},
  {860306400, -10800, 122},
  {877842000, -14400, 122},
  {891756000, -10800, 122},
  {909291600, -14400, 122},
  {923205600, -10800, 122},
  {941346000, -14400, 122},
  {954655200, -10800, 122},
  {972795600, -14400, 122},
  {986104800, -10800, 122},
  {1004245200, -14400, 122},
  {1018159200, -10800, 122},
  {1035694800, -14400, 122},
  {1049608800, -10800, 122},
  {1067144400, -14400, 122},
  {1081058400, -10800, 122},
  {1099198800, -14400, 122},
  {1112508000, -10800, 122},
  {1130648400, -14400, 122},
  {1143957600, -10800, 122},
  {1162098000, -14400, 122},
  {1173592800, -10800, 122},
  {1194152400, -14400, 122},
  {1205042400, -10800, 122},
  {1225602000, -14400, 122},
  {1236492000, -10800, 122},
  {1257051600, -14400, 122},
  {1268546400, -10800, 122},
  {1289106000, -14400, 122},
  {1299996000, -10800, 122},
  {1320555600, -14400, 122},
  {1331445600, -10800, 122},
  {1352005200, -14400, 122},
  {1362895200, -10800, 122},
  {1383454800, -14400, 122},
  {1394344800, -10800, 122},
  {1414904400, -14400, 122},
  {1425794400, -10800, 122},
  {1446354000, -14400, 122},
  {1457848800, -10800, 122},
  {1478408400, -14400, 122},
  {1489298400, -10800, 122},
  {1509858000, -14400, 122},
  {1520748000, -10800, 122},
  {1541307600, -14400, 122},
  {1552197600, -10800, 122},
  {1572757200, -14400, 122},
  {1583647200, -10800, 122},
  {1604206800, -14400, 122},
  {1615701600, -10800, 122},
  {1636261200, -14400, 122},
  {1647151200, -10800, 122},
  {1667710800, -14400, 122},
  {1678600800, -10800, 122},
  {1699160400, -14400, 122},
  {1710050400, -10800, 122},
  {1730610000, -14400, 122},
  {1741500000, -10800, 122},
  {1762059600, -14400, 122},
  {1772949600, -10800, 122},
  {1793509200, -14400, 122},
  {1805004000, -10800, 122},
  {1825563600, -14400, 122},
  {1836453600, -10800, 122},
  {1857013200, -14400, 122},
  {1867903200, -10800, 122},
  {1888462800, -14400, 122},
  {1899352800, -10800, 122},
  {1919912400, -14400, 122},
  {1930802400, -10800, 122},
  {1951362000, -14400, 122},
  {1962856800, -10800, 122},
  {1983416400, -14400, 122},
  {1994306400, -10800, 122},
  {2014866000, -14400, 122},
  {2025756000, -10800, 122},
  {2046315600, -14400, 122},
  {2057205600, -10800, 122},
  {2077765200, -14400, 122},
  {2088655200, -10800, 122},
  {2109214800, -14400, 122},
  {2120104800, -10800, 122},
  {2140664400, -14400, 122},
  {INT64_MIN, -19776, 123},
  {-1402813824, -18000, 123},
  {-1311534000, -14400, 123},
  {-1300996800, -18000, 123},
  {-933534000, -14400, 123},
  {-925675200, -18000, 123},
  {-902084400, -14400, 123},
  {-893620800, -18000, 123},
  {-870030000, -14400, 123},
  {-862171200, -18000, 123},
  {-775681200, -14400, 123},
  {-767822400, -18000, 123},
  {-744231600, -14400, 123},
  {-736372800, -18000, 123},
  {-144702000, -14400, 123},
  {-134251200, -18000, 123},
  {-113425200, -14400, 123},
  {-102542400, -18000, 123},
  {-86295600, -14400, 123},
  {-72907200, -18000, 123},
  {-54154800, -14400, 123},
  {-41457600, -18000, 123},
  {-21495600, -14400, 123},
  {-5774400, -18000, 123},
  {9954000, -14400, 123},
  {25675200, -18000, 123},
  {41403600, -14400, 123},
  {57729600, -18000, 123},
  {73458000, -14400, 123},
  {87364800, -18000, 123},
  {104907600, -14400, 123},
  {118900800, -18000, 123},
  {136357200, -14400, 123},
  {150436800, -18000, 123},
  {167806800, -14400, 123},
  {183528000, -18000, 123},
  {199256400, -14400, 123},
  {215582400, -18000, 123},
  {230706000, -14400, 123},
  {247032000, -18000, 123},
  {263365200, -14400, 123},
  {276667200, -18000, 123},
  {290581200, -14400, 123},
  {308721600, -18000, 123},
  {322030800, -14400, 123},
  {340171200, -18000, 123},
  {358318800, -14400, 123},
  {371620800, -18000, 123},
  {389768400, -14400, 123},
  {403070400, -18000, 123},
  {421218000, -14400, 123},
  {434520000, -18000, 123},
  {452667600, -14400, 123},
  {466574400, -18000, 123},
  {484117200, -14400, 123},
  {498024000, -18000, 123},
  {511333200, -14400, 123},
  {529473600, -18000, 123},
  {542782800, -14400, 123},
  {560923200, -18000, 123},
  {574837200, -14400, 123},
  {592372800, -18000, 123},
  {606286800, -14400, 123},
  {623822400, -18000, 123},
  {638946000, -14400, 123},
  {655876800, -18000, 123},
  {671000400, -14400, 123},
  {687330000, -18000, 123},
  {702450000, -14400, 123},
  {718779600, -18000, 123},
  {733899600, -14400, 123},
  {750229200, -18000, 123},
  {765349200, -14400, 123},
  {781678800, -18000, 123},
  {796798800, -14400, 123},
  {813128400, -18000, 123},
  {828853200, -14400, 123},
  {844578000, -18000, 123},
  {860302800, -14400, 123},
  {876632400, -18000, 123},
  {891147600, -14400, 123},
  {909291600, -18000, 123},
  {922597200, -14400, 123},
  {941346000, -18000, 123},
  {954651600, -14400, 123},
  {972795600, -18000, 123},
  {986101200, -14400, 123},
  {1004245200, -18000, 123},
  {1018155600, -14400, 123},
  {1035694800, -18000, 123},
  {1049605200, -14400, 123},
  {1067144400, -18000, 123},
  {1081054800, -14400, 123},
  {1162098000, -18000, 123},
  {1173589200, -14400, 123},
  {1193547600, -18000, 123},
  {1205643600, -14400, 123},
  {1224997200, -18000, 123},
  {1236488400, -14400, 123},
  {1256446800, -18000, 123},
  {1268542800, -14400, 123},
  {1288501200, -18000, 123},
  {1300597200, -14400, 123},
  {1319950800, -18000, 123},
  {1331442000, -14400, 123},
  {1351400400, -18000, 123},
  {1362891600, -14400, 123},
  {1382850000, -18000, 123},
  {1394341200, -14400, 123},
  {1414299600, -18000, 123},
  {1425790800, -14400, 123},
  {1445749200, -18000, 123},
  {1457845200, -14400, 123},
  {1477803600, -18000, 123},
  {1489294800, -14400, 123},
  {1509253200, -18000, 123},
  {1520744400, -14400, 123},
  {1540702800, -18000, 123},
  {1552194000, -14400, 123},
  {1572152400, -18000, 123},
  {1583643600, -14400, 123},
  {1603602000, -18000, 123},
  {1615698000, -14400, 123},
  {1635656400, -18000, 123},
  {1647147600, -14400, 123},
  {1667106000, -18000, 123},
  {1678597200, -14400, 123},
  {1698555600, -18000, 123},
  {1710046800, -14400, 123},
  {1730005200, -18000, 123},
  {1741496400, -14400, 123},
  {1761454800, -18000, 123},
  {1772946000, -14400, 123},
  {1792904400, -18000, 123},
  {1805000400, -14400, 123},
  {1824958800, -18000, 123},
  {1836450000, -14400, 123},
  {1856408400, -18000, 123},
  {1867899600, -14400, 123},
  {1887858000, -18000, 123},
  {1899349200, -14400, 123},
  {1919307600, -18000, 123},
  {1930798800, -14400, 123},
  {1950757200, -18000, 123},
  {1962853200, -14400, 123},
  {1982811600, -18000, 123},
  {1994302800, -14400, 123},
  {2014261200, -18000, 123},
  {2025752400, -14400, 123},
  {2045710800, -18000, 123},
  {2057202000, -14400, 123},
  {2077160400, -18000, 123},
  {2088651600, -14400, 123},
  {2108610000, -18000, 123},
  {2120101200, -14400, 123},
  {2140059600, -18000, 123},
  {INT64_MIN, -26632, 124},
  {-1514739600, -25200, 124},
  {-1343066400, -21600, 124},
  {-1234807200, -25200, 124},
  {-1220292000, -21600, 124},
  {-1207159200, -25200, 124},
  {-1191344400, -21600, 124},
  {-873828000, -25200, 124},
  {-661539600, -28800, 124},
  {28800, -25200, 124},
  {828867600, -21600, 124},
  {846403200, -25200, 124},
  {860317200, -21600, 124},
  {877852800, -25200, 124},
  {891766800, -21600, 124},
  {909302400, -25200, 124},
  {-1633276800, -18000, 125},
  {-1615136400, -21600, 125},
  {-1601827200, -18000, 125},
  {-1583686800, -21600, 125},
  {-900259200, -18000, 125},
  {-891795600, -21600, 125},
  {-880214400, -18000, 125},
  {-769395600, -18000, 125},
  {-765392400, -21600, 125},
  {-747244800, -18000, 125},
  {-733942800, -21600, 125},
  {-715795200, -18000, 125},
  {-702493200, -21600, 125},
  {-684345600, -18000, 125},
  {-671043600, -21600, 125},
  {-652896000, -18000, 125},
  {-639594000, -21600, 125},
  {-620841600, -18000, 125},
  {-608144400, -21600, 125},
  {-589392000, -18000, 125},
  {-576090000, -21600, 125},
  {-557942400, -18000, 125},
  {-544640400, -21600, 125},
  {-526492800, -18000, 125},
  {-513190800, -21600, 125},
  {-495043200, -18000, 125},
  {-481741200, -21600, 125},
  {-463593600, -18000, 125},
  {-386787600, -21600, 125},
  {-368640000, -18000, 125},
  {-21488400, -14400, 125},
  {-5767200, -18000, 125},
  {9961200, -14400, 125},
  {25682400, -18000, 125},
  {1143961200, -14400, 125},
  {1162101600, -18000, 125},
  {1173596400, -14400, 125},
  {1194156000, -18000, 125},
  {1205046000, -14400, 125},
  {1225605600, -18000, 125},
  {1236495600, -14400, 125},
  {1257055200, -18000, 125},
  {1268550000, -14400, 125},
  {1289109600, -18000, 125},
  {1299999600, -14400, 125},
  {1320559200, -18000, 125},
  {1331449200, -14400, 125},
  {1352008800, -18000, 125},
  {1362898800, -14400, 125},
  {1383458400, -18000, 125},
  {1394348400, -14400, 125},
  {1414908000, -18000, 125},
  {1425798000, -14400, 125},
  {1446357600, -18000, 125},
  {1457852400, -14400, 125},
  {1478412000, -18000, 125},
  {1489302000, -14400, 125},
  {1509861600, -18000, 125},
  {1520751600, -14400, 125},
  {1541311200, -18000, 125},
  {1552201200, -14400, 125},
  {1572760800, -18000, 125},
  {1583650800, -14400, 125},
  {1604210400, -18000, 125},
  {1615705200, -14400, 125},
  {1636264800, -18000, 125},
  {1647154800, -14400, 125},
  {1667714400, -18000, 125},
  {1678604400, -14400, 125},
  {1699164000, -18000, 125},
  {1710054000, -14400, 125},
  {1730613600, -18000, 125},
  {1741503600, -14400, 125},
  {1762063200, -18000, 125},
  {1772953200, -14400, 125},
  {1793512800, -18000, 125},
  {1805007600, -14400, 125},
  {1825567200, -18000, 125},
  {1836457200, -14400, 125},
  {1857016800, -18000, 125},
  {1867906800, -14400, 125},
  {1888466400, -18000, 125},
  {1899356400, -14400, 125},
  {1919916000, -18000, 125},
  {1930806000, -14400, 125},
  {1951365600, -18000, 125},
  {1962860400, -14400, 125},
  {1983420000, -18000, 125},
  {1994310000, -14400, 125},
  {2014869600, -18000, 125},
  {2025759600, -14400, 125},
  {2046319200, -18000, 125},
  {2057209200, -14400, 125},
  {2077768800, -18000, 125},
  {2088658800, -14400, 125},
  {2109218400, -18000, 125},
  {2120108400, -14400, 125},
  {2140668000, -18000, 125},
  {-1633276800, -18000, 126},
  {-1615136400, -21600, 126},
  {-1601827200, -18000, 126},
  {-1583686800, -21600, 126},
  {-880214400, -18000, 126},
  {-769395600, -18000, 126},
  {-765392400, -21600, 126},
  {-715795200, -18000, 126},
  {-702493200, -21600, 126},
  {-684345600, -18000, 126},
  {-671043600, -21600, 126},
  {-652896000, -18000, 126},
  {-639594000, -21600, 126},
  {-620841600, -18000, 126},
  {-608144400, -21600, 126},
  {-589392000, -18000, 126},
  {-576090000, -21600, 126},
  {-557942400, -18000, 126},
  {-544640400, -21600, 126},
  {-526492800, -18000, 126},
  {-513190800, -21600, 126},
  {-495043200, -18000, 126},
  {-481741200, -21600, 126},
  {-463593600, -18000, 126},
  {-447267600, -21600, 126},
  {-431539200, -18000, 126},
  {-415818000, -21600, 126},
  {-400089600, -18000, 126},
  {-386787600, -21600, 126},
  {-368640000, -18000, 126},
  {-355338000, -21600, 126},
  {-337190400, -18000, 126},
  {-321469200, -21600, 126},
  {-305740800, -18000, 126},
  {-289414800, -21600, 126},
  {-273686400, -18000, 126},
  {-257965200, -21600, 126},
  {-242236800, -18000, 126},
  {-195066000, -21600, 126},
  {-84384000, -18000, 126},
  {-68662800, -21600, 126},
  {-52934400, -18000, 126},
  {-37213200, -21600, 126},
  {-21484800, -18000, 126},
  {-5763600, -21600, 126},
  {9964800, -18000, 126},
  {25686000, -21600, 126},
  {41414400, -18000, 126},
  {57740400, -21600, 126},
  {73468800, -18000, 126},
  {89190000, -21600, 126},
  {104918400, -18000, 126},
  {120639600, -21600, 126},
  {126691200, -18000, 126},
  {152089200, -21600, 126},
  {162374400, -18000, 126},
  {183538800, -21600, 126},
  {199267200, -18000, 126},
  {215593200, -21600, 126},
  {230716800, -18000, 126},
  {247042800, -21600, 126},
  {262771200, -18000, 126},
  {278492400, -21600, 126},
  {294220800, -18000, 126},
  {309942000, -21600, 126},
  {325670400, -18000, 126},
  {341391600, -21600, 126},
  {357120000, -18000, 126},
  {372841200, -21600, 126},
  {388569600, -18000, 126},
  {404895600, -21600, 126},
  {420019200, -18000, 126},
  {436345200, -21600, 126},
  {452073600, -18000, 126},
  {467794800, -21600, 126},
  {483523200, -18000, 126},
  {499244400, -21600, 126},
  {514972800, -18000, 126},
  {530694000, -21600, 126},
  {544608000, -18000, 126},
  {562143600, -21600, 126},
  {576057600, -18000, 126},
  {594198000, -21600, 126},
  {607507200, -18000, 126},
  {625647600, -21600, 126},
  {638956800, -18000, 126},
  {657097200, -21600, 126},
  {671011200, -18000, 126},
  {688546800, -18000, 126},
  {1143961200, -18000, 126},
  {1162105200, -21600, 126},
  {1173600000, -18000, 126},
  {1194159600, -21600, 126},
  {1205049600, -18000, 126},
  {1225609200, -21600, 126},
  {1236499200, -18000, 126},
  {1257058800, -21600, 126},
  {1268553600, -18000, 126},
  {1289113200, -21600, 126},
  {1300003200, -18000, 126},
  {1320562800, -21600, 126},
  {1331452800, -18000, 126},
  {1352012400, -21600, 126},
  {1362902400, -18000, 126},
  {1383462000, -21600, 126},
  {1394352000, -18000, 126},
  {1414911600, -21600, 126},
  {1425801600, -18000, 126},
  {1446361200, -21600, 126},
  {1457856000, -18000, 126},
  {1478415600, -21600, 126},
  {1489305600, -18000, 126},
  {1509865200, -21600, 126},
  {1520755200, -18000, 126},
  {1541314800, -21600, 126},
  {1552204800, -18000, 126},
  {1572764400, -21600, 126},
  {1583654400, -18000, 126},
  {1604214000, -21600, 126},
  {1615708800, -18000, 126},
  {1636268400, -21600, 126},
  {1647158400, -18000, 126},
  {1667718000, -21600, 126},
  {1678608000, -18000, 126},
  {1699167600, -21600, 126},
  {1710057600, -18000, 126},
  {1730617200, -21600, 126},
  {1741507200, -18000, 126},
  {1762066800, -21600, 126},
  {1772956800, -18000, 126},
  {1793516400, -21600, 126},
  {1805011200, -18000, 126},
  {1825570800, -21600, 126},
  {1836460800, -18000, 126},
  {1857020400, -21600, 126},
  {1867910400, -18000, 126},
  {1888470000, -21600, 126},
  {1899360000, -18000, 126},
  {1919919600, -21600, 126},
  {1930809600, -18000, 126},
  {1951369200, -21600, 126},
  {1962864000, -18000, 126},
  {1983423600, -21600, 126},
  {1994313600, -18000, 126},
  {2014873200, -21600, 126},
  {2025763200, -18000, 126},
  {2046322800, -21600, 126},
  {2057212800, -18000, 126},
  {2077772400, -21600, 126},
  {2088662400, -18000, 126},
  {2109222000, -21600, 126},
  {2120112000, -18000, 126},
  {2140671600, -21600, 126},
  {-1633276800, -18000, 127},
  {-1615136400, -21600, 127},
  {-1601827200, -18000, 127},
  {-1583686800, -21600, 127},
  {-880214400, -18000, 127},
  {-769395600, -18000, 127},
  {-765392400, -21600, 127},
  {-589392000, -18000, 127},
  {-576090000, -21600, 127},
  {-495043200, -18000, 127},
  {-481741200, -21600, 127},
  {-463593600, -18000, 127},
  {-450291600, -21600, 127},
  {-431539200, -18000, 127},
  {-418237200, -21600, 127},
  {-400089600, -18000, 127},
  {-386787600, -21600, 127},
  {-368640000, -18000, 127},
  {-355338000, -21600, 127},
  {-337190400, -18000, 127},
  {-323888400, -21600, 127},
  {-305740800, -18000, 127},
  {-292438800, -21600, 127},
  {-273686400, -18000, 127},
  {-21488400, -14400, 127},
  {-5767200, -18000, 127},
  {9961200, -14400, 127},
  {25682400, -18000, 127},
  {41410800, -14400, 127},
  {57736800, -18000, 127},
  {73465200, -14400, 127},
  {89186400, -18000, 127},
  {104914800, -14400, 127},
  {120636000, -18000, 127},
  {126687600, -18000, 127},
  {152089200, -18000, 127},
  {162370800, -14400, 127},
  {183535200, -18000, 127},
  {1143961200, -14400, 127},
  {1162101600, -18000, 127},
  {1173596400, -14400, 127},
  {1194156000, -18000, 127},
  {1205046000, -14400, 127},
  {1225605600, -18000, 127},
  {1236495600, -14400, 127},
  {1257055200, -18000, 127},
  {1268550000, -14400, 127},
  {1289109600, -18000, 127},
  {1299999600, -14400, 127},
  {1320559200, -18000, 127},
  {1331449200, -14400, 127},
  {1352008800, -18000, 127},
  {1362898800, -14400, 127},
  {1383458400, -18000, 127},
  {1394348400, -14400, 127},
  {1414908000, -18000, 127},
  {1425798000, -14400, 127},
  {1446357600, -18000, 127},
  {1457852400, -14400, 127},
  {1478412000, -18000, 127},
  {1489302000, -14400, 127},
  {1509861600, -18000, 127},
  {1520751600, -14400, 127},
  {1541311200, -18000, 127},
  {1552201200, -14400, 127},
  {1572760800, -18000, 127},
  {1583650800, -14400, 127},
  {1604210400, -18000, 127},
  {1615705200, -14400, 127},
  {1636264800, -18000, 127},
  {1647154800, -14400, 127},
  {1667714400, -18000, 127},
  {1678604400, -14400, 127},
  {1699164000, -18000, 127},
  {1710054000, -14400, 127},
  {1730613600, -18000, 127},
  {1741503600, -14400, 127},
  {1762063200, -18000, 127},
  {1772953200, -14400, 127},
  {1793512800, -18000, 127},
  {1805007600, -14400, 127},
  {1825567200, -18000, 127},
  {1836457200, -14400, 127},
  {1857016800, -18000, 127},
  {1867906800, -14400, 127},
  {1888466400, -18000, 127},
  {1899356400, -14400, 127},
  {1919916000, -18000, 127},
  {1930806000, -14400, 127},
  {1951365600, -18000, 127},
  {1962860400, -14400, 127},
  {1983420000, -18000, 127},
  {1994310000, -14400, 127},
  {2014869600, -18000, 127},
  {2025759600, -14400, 127},
  {2046319200, -18000, 127},
  {2057209200, -14400, 127},
  {2077768800, -18000, 127},
  {2088658800, -14400, 127},
  {2109218400, -18000, 127},
  {2120108400, -14400, 127},
  {2140668000, -18000, 127},
  {-1633276800, -18000, 128},
  {-1615136400, -21600, 128},
  {-1601827200, -18000, 128},
  {-1583686800, -21600, 128},
  {-880214400, -18000, 128},
  {-769395600, -18000, 128},
  {-765392400, -21600, 128},
  {-462996000, -18000, 128},
  {-450291600, -21600, 128},
  {-431539200, -18000, 128},
  {-418237200, -21600, 128},
  {-400089600, -18000, 128},
  {-386787600, -21600, 128},
  {-368640000, -18000, 128},
  {-355338000, -21600, 128},
  {-337190400, -18000, 128},
  {-323888400, -21600, 128},
  {-305740800, -18000, 128},
  {-292438800, -21600, 128},
  {-273686400, -18000, 128},
  {-257965200, -21600, 128},
  {-242236800, -18000, 128},
  {-226515600, -21600, 128},
  {-210787200, -18000, 128},
  {-195066000, -21600, 128},
  {-179337600, -18000, 128},
  {-163616400, -21600, 128},
  {-147888000, -18000, 128},
  {-100112400, -21600, 128},
  {-84384000, -18000, 128},
  {-68662800, -21600, 128},
  {-52934400, -18000, 128},
  {-37213200, -21600, 128},
  {-21484800, -18000, 128},
  {-5763600, -21600, 128},
  {9964800, -18000, 128},
  {25686000, -21600, 128},
  {41414400, -18000, 128},
  {57740400, -21600, 128},
  {73468800, -18000, 128},
  {89190000, -21600, 128},
  {104918400, -18000, 128},
  {120639600, -21600, 128},
  {126691200, -18000, 128},
  {152089200, -21600, 128},
  {162374400, -18000, 128},
  {183538800, -21600, 128},
  {199267200, -18000, 128},
  {215593200, -21600, 128},
  {230716800, -18000, 128},
  {247042800, -18000, 128},
  {1143961200, -18000, 128},
  {1162105200, -21600, 128},
  {1173600000, -18000, 128},
  {1194159600, -18000, 128},
  {1205046000, -14400, 128},
  {1225605600, -18000, 128},
  {1236495600, -14400, 128},
  {1257055200, -18000, 128},
  {1268550000, -14400, 128},
  {1289109600, -18000, 128},
  {1299999600, -14400, 128},
  {1320559200, -18000, 128},
  {1331449200, -14400, 128},
  {1352008800, -18000, 128},
  {1362898800, -14400, 128},
  {1383458400, -18000, 128},
  {1394348400, -14400, 128},
  {1414908000, -18000, 128},
  {1425798000, -14400, 128},
  {1446357600, -18000, 128},
  {1457852400, -14400, 128},
  {1478412000, -18000, 128},
  {1489302000, -14400, 128},
  {1509861600, -18000, 128},
  {1520751600, -14400, 128},
  {1541311200, -18000, 128},
  {1552201200, -14400, 128},
  {1572760800, -18000, 128},
  {1583650800, -14400, 128},
  {1604210400, -18000, 128},
  {1615705200, -14400, 128},
  {1636264800, -18000, 128},
  {1647154800, -14400, 128},
  {1667714400, -18000, 128},
  {1678604400, -14400, 128},
  {1699164000, -18000, 128},
  {1710054000, -14400, 128},
  {1730613600, -18000, 128},
  {1741503600, -14400, 128},
  {1762063200, -18000, 128},
  {1772953200, -14400, 128},
  {1793512800, -18000, 128},
  {1805007600, -14400, 128},
  {1825567200, -18000, 128},
  {1836457200, -14400, 128},
  {1857016800, -18000, 128},
  {1867906800, -14400, 128},
  {1888466400, -18000, 128},
  {1899356400, -14400, 128},
  {1919916000, -18000, 128},
  {1930806000, -14400, 128},
  {1951365600, -18000, 128},
  {1962860400, -14400, 128},
  {1983420000, -18000, 128},
  {1994310000, -14400, 128},
  {2014869600, -18000, 128},
  {2025759600, -14400, 128},
  {2046319200, -18000, 128},
  {2057209200, -14400, 128},
  {2077768800, -18000, 128},
  {2088658800, -14400, 128},
  {2109218400, -18000, 128},
  {2120108400, -14400, 128},
  {2140668000, -18000, 128},
  {-1633276800, -18000, 129},
  {-1615136400, -21600, 129},
  {-1601827200, -18000, 129},
  {-1583686800, -21600, 129},
  {-880214400, -18000, 129},
  {-769395600, -18000, 129},
  {-765392400, -21600, 129},
  {-747244800, -18000, 129},
  {-733942800, -21600, 129},
  {-526492800, -18000, 129},
  {-513190800, -21600, 129},
  {-495043200, -18000, 129},
  {-481741200, -21600, 129},
  {-462996000, -18000, 129},
  {-450291600, -21600, 129},
  {-431539200, -18000, 129},
  {-418237200, -21600, 129},
  {-400089600, -18000, 129},
  {-386787600, -21600, 129},
  {-368640000, -18000, 129},
  {-355338000, -21600, 129},
  {-337190400, -18000, 129},
  {-323888400, -21600, 129},
  {-305740800, -18000, 129},
  {-289414800, -21600, 129},
  {-273686400, -18000, 129},
  {-260989200, -21600, 129},
  {-242236800, -18000, 129},
  {-226515600, -21600, 129},
  {-210787200, -18000, 129},
  {-195066000, -21600, 129},
  {-179337600, -18000, 129},
  {-21488400, -14400, 129},
  {-5767200, -18000, 129},
  {9961200, -14400, 129},
  {25682400, -18000, 129},
  {1143961200, -18000, 129},
  {1162105200, -21600, 129},
  {1173600000, -18000, 129},
  {1194159600, -21600, 129},
  {1205049600, -18000, 129},
  {1225609200, -21600, 129},
  {1236499200, -18000, 129},
  {1257058800, -21600, 129},
  {1268553600, -18000, 129},
  {1289113200, -21600, 129},
  {1300003200, -18000, 129},
  {1320562800, -21600, 129},
  {1331452800, -18000, 129},
  {1352012400, -21600, 129},
  {1362902400, -18000, 129},
  {1383462000, -21600, 129},
  {1394352000, -18000, 129},
  {1414911600, -21600, 129},
  {1425801600, -18000, 129},
  {1446361200, -21600, 129},
  {1457856000, -18000, 129},
  {1478415600, -21600, 129},
  {1489305600, -18000, 129},
  {1509865200, -21600, 129},
  {1520755200, -18000, 129},
  {1541314800, -21600, 129},
  {1552204800, -18000, 129},
  {1572764400, -21600, 129},
  {1583654400, -18000, 129},
  {1604214000, -21600, 129},
  {1615708800, -18000, 129},
  {1636268400, -21600, 129},
  {1647158400, -18000, 129},
  {1667718000, -21600, 129},
  {1678608000, -18000, 129},
  {1699167600, -21600, 129},
  {1710057600, -18000, 129},
  {1730617200, -21600, 129},
  {1741507200, -18000, 129},
  {1762066800, -21600, 129},
  {1772956800, -18000, 129},
  {1793516400, -21600, 129},
  {1805011200, -18000, 129},
  {1825570800, -21600, 129},
  {1836460800, -18000, 129},
  {1857020400, -21600, 129},
  {1867910400, -18000, 129},
  {1888470000, -21600, 129},
  {1899360000, -18000, 129},
  {1919919600, -21600, 129},
  {1930809600, -18000, 129},
  {1951369200, -21600, 129},
  {1962864000, -18000, 129},
  {1983423600, -21600, 129},
  {1994313600, -18000, 129},
  {2014873200, -21600, 129},
  {2025763200, -18000, 129},
  {2046322800, -21600, 129},
  {2057212800, -18000, 129},
  {2077772400, -21600, 129},
  {2088662400, -18000, 129},
  {2109222000, -21600, 129},
  {2120112000, -18000, 129},
  {2140671600, -21600, 129},
  {-1633276800, -18000, 130},
  {-1615136400, -21600, 130},
  {-1601827200, -18000, 130},
  {-1583686800, -21600, 130},
  {-880214400, -18000, 130},
  {-769395600, -18000, 130},
  {-765392400, -21600, 130},
  {-495043200, -18000, 130},
  {-21488400, -14400, 130},
  {-5767200, -18000, 130},
  {9961200, -14400, 130},
  {25682400, -18000, 130},
  {41410800, -14400, 130},
  {57736800, -18000, 130},
  {73465200, -14400, 130},
  {89186400, -18000, 130},
  {1143961200, -14400, 130},
  {1162101600, -18000, 130},
  {1173596400, -14400, 130},
  {1194156000, -18000, 130},
  {1205046000, -14400, 130},
  {1225605600, -18000, 130},
  {1236495600, -14400, 130},
  {1257055200, -18000, 130},
  {1268550000, -14400, 130},
  {1289109600, -18000, 130},
  {1299999600, -14400, 130},
  {1320559200, -18000, 130},
  {1331449200, -14400, 130},
  {1352008800, -18000, 130},
  {1362898800, -14400, 130},
  {1383458400, -18000, 130},
  {1394348400, -14400, 130},
  {1414908000, -18000, 130},
  {1425798000, -14400, 130},
  {1446357600, -18000, 130},
  {1457852400, -14400, 130},
  {1478412000, -18000, 130},
  {1489302000, -14400, 130},
  {1509861600, -18000, 130},
  {1520751600, -14400, 130},
  {1541311200, -18000, 130},
  {1552201200, -14400, 130},
  {1572760800, -18000, 130},
  {1583650800, -14400, 130},
  {1604210400, -18000, 130},
  {1615705200, -14400, 130},
  {1636264800, -18000, 130},
  {1647154800, -14400, 130},
  {1667714400, -18000, 130},
  {1678604400, -14400, 130},
  {1699164000, -18000, 130},
  {1710054000, -14400, 130},
  {1730613600, -18000, 130},
  {1741503600, -14400, 130},
  {1762063200, -18000, 130},
  {1772953200, -14400, 130},
  {1793512800, -18000, 130},
  {1805007600, -14400, 130},
  {1825567200, -18000, 130},
  {1836457200, -14400, 130},
  {1857016800, -18000, 130},
  {1867906800, -14400, 130},
  {1888466400, -18000, 130},
  {1899356400, -14400, 130},
  {1919916000, -18000, 130},
  {1930806000, -14400, 130},
  {1951365600, -18000, 130},
  {1962860400, -14400, 130},
  {1983420000, -18000, 130},
  {1994310000, -14400, 130},
  {2014869600, -18000, 130},
  {2025759600, -14400, 130},
  {2046319200, -18000, 130},
  {2057209200, -14400, 130},
  {2077768800, -18000, 130},
  {2088658800, -14400, 130},
  {2109218400, -18000, 130},
  {2120108400, -14400, 130},
  {2140668000, -18000, 130},
  {-1633276800, -18000, 131},
  {-1615136400, -21600, 131},
  {-1601827200, -18000, 131},
  {-1583686800, -21600, 131},
  {-880214400, -18000, 131},
  {-769395600, -18000, 131},
  {-765392400, -21600, 131},
  {-747244800, -18000, 131},
  {-733942800, -21600, 131},
  {-526492800, -18000, 131},
  {-513190800, -21600, 131},
  {-495043200, -18000, 131},
  {-481741200, -21600, 131},
  {-462996000, -18000, 131},
  {-450291600, -21600, 131},
  {-431539200, -18000, 131},
  {-418237200, -21600, 131},
  {-400089600, -18000, 131},
  {-386787600, -21600, 131},
  {-368640000, -18000, 131},
  {-355338000, -21600, 131},
  {-337190400, -18000, 131},
  {-323888400, -21600, 131},
  {-305740800, -18000, 131},
  {-289414800, -21600, 131},
  {-273686400, -18000, 131},
  {-260989200, -21600, 131},
  {-242236800, -18000, 131},
  {-226515600, -21600, 131},
  {-210787200, -18000, 131},
  {-195066000, -21600, 131},
  {-179337600, -18000, 131},
  {-21488400, -14400, 131},
  {-5767200, -18000, 131},
  {9961200, -14400, 131},
  {25682400, -18000, 131},
  {1143961200, -18000, 131},
  {1162105200, -21600, 131},
  {1173600000, -18000, 131},
  {1194159600, -18000, 131},
  {1205046000, -14400, 131},
  {1225605600, -18000, 131},
  {1236495600, -14400, 131},
  {1257055200, -18000, 131},
  {1268550000, -14400, 131},
  {1289109600, -18000, 131},
  {1299999600, -14400, 131},
  {1320559200, -18000, 131},
  {1331449200, -14400, 131},
  {1352008800, -18000, 131},
  {1362898800, -14400, 131},
  {1383458400, -18000, 131},
  {1394348400, -14400, 131},
  {1414908000, -18000, 131},
  {1425798000, -14400, 131},
  {1446357600, -18000, 131},
  {1457852400, -14400, 131},
  {1478412000, -18000, 131},
  {1489302000, -14400, 131},
  {1509861600, -18000, 131},
  {1520751600, -14400, 131},
  {1541311200, -18000, 131},
  {1552201200, -14400, 131},
  {1572760800, -18000, 131},
  {1583650800, -14400, 131},
  {1604210400, -18000, 131},
  {1615705200, -14400, 131},
  {1636264800, -18000, 131},
  {1647154800, -14400, 131},
  {1667714400, -18000, 131},
  {1678604400, -14400, 131},
  {1699164000, -18000, 131},
  {1710054000, -14400, 131},
  {1730613600, -18000, 131},
  {1741503600, -14400, 131},
  {1762063200, -18000, 131},
  {1772953200, -14400, 131},
  {1793512800, -18000, 131},
  {1805007600, -14400, 131},
  {1825567200, -18000, 131},
  {1836457200, -14400, 131},
  {1857016800, -18000, 131},
  {1867906800, -14400, 131},
  {1888466400, -18000, 131},
  {1899356400, -14400, 131},
  {1919916000, -18000, 131},
  {1930806000, -14400, 131},
  {1951365600, -18000, 131},
  {1962860400, -14400, 131},
  {1983420000, -18000, 131},
  {1994310000, -14400, 131},
  {2014869600, -18000, 131},
  {2025759600, -14400, 131},
  {2046319200, -18000, 131},
  {2057209200, -14400, 131},
  {2077768800, -18000, 131},
  {2088658800, -14400, 131},
  {2109218400, -18000, 131},
  {2120108400, -14400, 131},
  {2140668000, -18000, 131},
  {-1633276800, -18000, 132},
  {-1615136400, -21600, 132},
  {-1601827200, -18000, 132},
  {-1583686800, -21600, 132},
  {-880214400, -18000, 132},
  {-769395600, -18000, 132},
  {-765392400, -21600, 132},
  {-747244800, -18000, 132},
  {-733942800, -21600, 132},
  {-715795200, -18000, 132},
  {-702493200, -21600, 132},
  {-684345600, -18000, 132},
  {-671043600, -21600, 132},
  {-652896000, -18000, 132},
  {-639594000, -21600, 132},
  {-620841600, -18000, 132},
  {-608144400, -21600, 132},
  {-589392000, -18000, 132},
  {-576090000, -21600, 132},
  {-557942400, -18000, 132},
  {-544640400, -21600, 132},
  {-526492800, -18000, 132},
  {-513190800, -21600, 132},
  {-495043200, -18000, 132},
  {-481741200, -21600, 132},
  {-463593600, -18000, 132},
  {-447267600, -21600, 132},
  {-431539200, -18000, 132},
  {-415818000, -21600, 132},
  {-400089600, -18000, 132},
  {-386787600, -21600, 132},
  {-368640000, -18000, 132},
  {-355338000, -21600, 132},
  {-337190400, -18000, 132},
  {-323888400, -21600, 132},
  {-305740800, -18000, 132},
  {-292438800, -21600, 132},
  {-273686400, -18000, 132},
  {-21488400, -14400, 132},
  {-5767200, -18000, 132},
  {9961200, -14400, 132},
  {25682400, -18000, 132},
  {1143961200, -18000, 132},
  {1162105200, -21600, 132},
  {1173600000, -14400, 132},
  {1194156000, -18000, 132},
  {1205046000, -14400, 132},
  {1225605600, -18000, 132},
  {1236495600, -14400, 132},
  {1257055200, -18000, 132},
  {1268550000, -14400, 132},
  {1289109600, -18000, 132},
  {1299999600, -14400, 132},
  {1320559200, -18000, 132},
  {1331449200, -14400, 132},
  {1352008800, -18000, 132},
  {1362898800, -14400, 132},
  {1383458400, -18000, 132},
  {1394348400, -14400, 132},
  {1414908000, -18000, 132},
  {1425798000, -14400, 132},
  {1446357600, -18000, 132},
  {1457852400, -14400, 132},
  {1478412000, -18000, 132},
  {1489302000, -14400, 132},
  {1509861600, -18000, 132},
  {1520751600, -14400, 132},
  {1541311200, -18000, 132},
  {1552201200, -14400, 132},
  {1572760800, -18000, 132},
  {1583650800, -14400, 132},
  {1604210400, -18000, 132},
  {1615705200, -14400, 132},
  {1636264800, -18000, 132},
  {1647154800, -14400, 132},
  {1667714400, -18000, 132},
  {1678604400, -14400, 132},
  {1699164000, -18000, 132},
  {1710054000, -14400, 132},
  {1730613600, -18000, 132},
  {1741503600, -14400, 132},
  {1762063200, -18000, 132},
  {1772953200, -14400, 132},
  {1793512800, -18000, 132},
  {1805007600, -14400, 132},
  {1825567200, -18000, 132},
  {1836457200, -14400, 132},
  {1857016800, -18000, 132},
  {1867906800, -14400, 132},
  {1888466400, -18000, 132},
  {1899356400, -14400, 132},
  {1919916000, -18000, 132},
  {1930806000, -14400, 132},
  {1951365600, -18000, 132},
  {1962860400, -14400, 132},
  {1983420000, -18000, 132},
  {1994310000, -14400, 132},
  {2014869600, -18000, 132},
  {2025759600, -14400, 132},
  {2046319200, -18000, 132},
  {2057209200, -14400, 132},
  {2077768800, -18000, 132},
  {2088658800, -14400, 132},
  {2109218400, -18000, 132},
  {2120108400, -14400, 132},
  {2140668000, -18000, 132},
  {-1633276800, -18000, 133},
  {-1615136400, -21600, 133},
  {-1601827200, -18000, 133},
  {-1583686800, -21600, 133},
  {-900259200, -18000, 133},
  {-891795600, -21600, 133},
  {-880214400, -18000, 133},
  {-769395600, -18000, 133},
  {-765392400, -21600, 133},
  {-747244800, -18000, 133},
  {-733942800, -21600, 133},
  {-715795200, -18000, 133},
  {-702493200, -21600, 133},
  {-684345600, -18000, 133},
  {-671043600, -21600, 133},
  {-652896000, -18000, 133},
  {-639594000, -21600, 133},
  {-620841600, -18000, 133},
  {-608144400, -21600, 133},
  {-589392000, -18000, 133},
  {-576090000, -21600, 133},
  {-557942400, -18000, 133},
  {-544640400, -21600, 133},
  {-526492800, -18000, 133},
  {-513190800, -21600, 133},
  {-495043200, -18000, 133},
  {-481741200, -21600, 133},
  {-463593600, -18000, 133},
  {-386787600, -21600, 133},
  {-368640000, -18000, 133},
  {-21488400, -14400, 133},
  {-5767200, -18000, 133},
  {9961200, -14400, 133},
  {25682400, -18000, 133},
  {1143961200, -14400, 133},
  {1162101600, -18000, 133},
  {1173596400, -14400, 133},
  {1194156000, -18000, 133},
  {1205046000, -14400, 133},
  {1225605600, -18000, 133},
  {1236495600, -14400, 133},
  {1257055200, -18000, 133},
  {1268550000, -14400, 133},
  {1289109600, -18000, 133},
  {1299999600, -14400, 133},
  {1320559200, -18000, 133},
  {1331449200, -14400, 133},
  {1352008800, -18000, 133},
  {1362898800, -14400, 133},
  {1383458400, -18000, 133},
  {1394348400, -14400, 133},
  {1414908000, -18000, 133},
  {1425798000, -14400, 133},
  {1446357600, -18000, 133},
  {1457852400, -14400, 133},
  {1478412000, -18000, 133},
  {1489302000, -14400, 133},
  {1509861600, -18000, 133},
  {1520751600, -14400, 133},
  {1541311200, -18000, 133},
  {1552201200, -14400, 133},
  {1572760800, -18000, 133},
  {1583650800, -14400, 133},
  {1604210400, -18000, 133},
  {1615705200, -14400, 133},
  {1636264800, -18000, 133},
  {1647154800, -14400, 133},
  {1667714400, -18000, 133},
  {1678604400, -14400, 133},
  {1699164000, -18000, 133},
  {1710054000, -14400, 133},
  {1730613600, -18000, 133},
  {1741503600, -14400, 133},
  {1762063200, -18000, 133},
  {1772953200, -14400, 133},
  {1793512800, -18000, 133},
  {1805007600, -14400, 133},
  {1825567200, -18000, 133},
  {1836457200, -14400, 133},
  {1857016800, -18000, 133},
  {1867906800, -14400, 133},
  {1888466400, -18000, 133},
  {1899356400, -14400, 133},
  {1919916000, -18000, 133},
  {1930806000, -14400, 133},
  {1951365600, -18000, 133},
  {1962860400, -14400, 133},
  {1983420000, -18000, 133},
  {1994310000, -14400, 133},
  {2014869600, -18000, 133},
  {2025759600, -14400, 133},
  {2046319200, -18000, 133},
  {2057209200, -14400, 133},
  {2077768800, -18000, 133},
  {2088658800, -14400, 133},
  {2109218400, -18000, 133},
  {2120108400, -14400, 133},
  {2140668000, -18000, 133},
  {INT64_MIN, 0, 134},
  {-536457600, -28800, 134},
  {-147888000, -21600, 134},
  {-131558400, -28800, 134},
  {294228000, -25200, 134},
  {325674000, -21600, 134},
  {341395200, -25200, 134},
  {357123600, -21600, 134},
  {372844800, -25200, 134},
  {388573200, -21600, 134},
  {404899200, -25200, 134},
  {420022800, -21600, 134},
  {436348800, -25200, 134},
  {452077200, -21600, 134},
  {467798400, -25200, 134},
  {483526800, -21600, 134},
  {499248000, -25200, 134},
  {514976400, -21600, 134},
  {530697600, -25200, 134},
  {544611600, -21600, 134},
  {562147200, -25200, 134},
  {576061200, -21600, 134},
  {594201600, -25200, 134},
  {607510800, -21600, 134},
  {625651200, -25200, 134},
  {638960400, -21600, 134},
  {657100800, -25200, 134},
  {671014800, -21600, 134},
  {688550400, -25200, 134},
  {702464400, -21600, 134},
  {720000000, -25200, 134},
  {733914000, -21600, 134},
  {752054400, -25200, 134},
  {765363600, -21600, 134},
  {783504000, -25200, 134},
  {796813200, -21600, 134},
  {814953600, -25200, 134},
  {828867600, -21600, 134},
  {846403200, -25200, 134},
  {860317200, -21600, 134},
  {877852800, -25200, 134},
  {891766800, -21600, 134},
  {909302400, -25200, 134},
  {923216400, -21600, 134},
  {941356800, -25200, 134},
  {954666000, -21600, 134},
  {972806400, -25200, 134},
  {986115600, -21600, 134},
  {1004256000, -25200, 134},
  {1018170000, -21600, 134},
  {1035705600, -25200, 134},
  {1049619600, -21600, 134},
  {1067155200, -25200, 134},
  {1081069200, -21600, 134},
  {1099209600, -25200, 134},
  {1112518800, -21600, 134},
  {1130659200, -25200, 134},
  {1143968400, -21600, 134},
  {1162108800, -25200, 134},
  {1173603600, -21600, 134},
  {1194163200, -25200, 134},
  {1205053200, -21600, 134},
  {1225612800, -25200, 134},
  {1236502800, -21600, 134},
  {1257062400, -25200, 134},
  {1268557200, -21600, 134},
  {1289116800, -25200, 134},
  {1300006800, -21600, 134},
  {1320566400, -25200, 134},
  {1331456400, -21600, 134},
  {1352016000, -25200, 134},
  {1362906000, -21600, 134},
  {1383465600, -25200, 134},
  {1394355600, -21600, 134},
  {1414915200, -25200, 134},
  {1425805200, -21600, 134},
  {1446364800, -25200, 134},
  {1457859600, -21600, 134},
  {1478419200, -25200, 134},
  {1489309200, -21600, 134},
  {1509868800, -25200, 134},
  {1520758800, -21600, 134},
  {1541318400, -25200, 134},
  {1552208400, -21600, 134},
  {1572768000, -25200, 134},
  {1583658000, -21600, 134},
  {1604217600, -25200, 134},
  {1615712400, -21600, 134},
  {1636272000, -25200, 134},
  {1647162000, -21600, 134},
  {1667721600, -25200, 134},
  {1678611600, -21600, 134},
  {1699171200, -25200, 134},
  {1710061200, -21600, 134},
  {1730620800, -25200, 134},
  {1741510800, -21600, 134},
  {1762070400, -25200, 134},
  {1772960400, -21600, 134},
  {1793520000, -25200, 134},
  {1805014800, -21600, 134},
  {1825574400, -25200, 134},
  {1836464400, -21600, 134},
  {1857024000, -25200, 134},
  {1867914000, -21600, 134},
  {1888473600, -25200, 134},
  {1899363600, -21600, 134},
  {1919923200, -25200, 134},
  {1930813200, -21600, 134},
  {1951372800, -25200, 134},
  {1962867600, -21600, 134},
  {1983427200, -25200, 134},
  {1994317200, -21600, 134},
  {2014876800, -25200, 134},
  {2025766800, -21600, 134},
  {2046326400, -25200, 134},
  {2057216400, -21600, 134},
  {2077776000, -25200, 134},
  {2088666000, -21600, 134},
  {2109225600, -25200, 134},
  {2120115600, -21600, 134},
  {2140675200, -25200, 134},
  {INT64_MIN, 0, 135},
  {-865296000, -14400, 135},
  {-769395600, -14400, 135},
  {-765396000, -18000, 135},
  {-147898800, -10800, 135},
  {-131569200, -18000, 135},
  {325666800, -14400, 135},
  {341388000, -18000, 135},
  {357116400, -14400, 135},
  {372837600, -18000, 135},
  {388566000, -14400, 135},
  {404892000, -18000, 135},
  {420015600, -14400, 135},
  {436341600, -18000, 135},
  {452070000, -14400, 135},
  {467791200, -18000, 135},
  {483519600, -14400, 135},
  {499240800, -18000, 135},
  {514969200, -14400, 135},
  {530690400, -18000, 135},
  {544604400, -14400, 135},
  {562140000, -18000, 135},
  {576054000, -14400, 135},
  {594194400, -18000, 135},
  {607503600, -14400, 135},
  {625644000, -18000, 135},
  {638953200, -14400, 135},
  {657093600, -18000, 135},
  {671007600, -14400, 135},
  {688543200, -18000, 135},
  {702457200, -14400, 135},
  {719992800, -18000, 135},
  {733906800, -14400, 135},
  {752047200, -18000, 135},
  {765356400, -14400, 135},
  {783496800, -18000, 135},
  {796806000, -14400, 135},
  {814946400, -18000, 135},
  {828860400, -14400, 135},
  {846396000, -18000, 135},
  {860310000, -14400, 135},
  {877845600, -18000, 135},
  {891759600, -14400, 135},
  {909295200, -18000, 135},
  {923209200, -14400, 135},
  {941349600, -21600, 135},
  {954662400, -18000, 135},
  {972802800, -18000, 135},
  {986108400, -14400, 135},
  {1004248800, -18000, 135},
  {1018162800, -14400, 135},
  {1035698400, -18000, 135},
  {1049612400, -14400, 135},
  {1067148000, -18000, 135},
  {1081062000, -14400, 135},
  {1099202400, -18000, 135},
  {1112511600, -14400, 135},
  {1130652000, -18000, 135},
  {1143961200, -14400, 135},
  {1162101600, -18000, 135},
  {1173596400, -14400, 135},
  {1194156000, -18000, 135},
  {1205046000, -14400, 135},
  {1225605600, -18000, 135},
  {1236495600, -14400, 135},
  {1257055200, -18000, 135},
  {1268550000, -14400, 135},
  {1289109600, -18000, 135},
  {1299999600, -14400, 135},
  {1320559200, -18000, 135},
  {1331449200, -14400, 135},
  {1352008800, -18000, 135},
  {1362898800, -14400, 135},
  {1383458400, -18000, 135},
  {1394348400, -14400, 135},
  {1414908000, -18000, 135},
  {1425798000, -14400, 135},
  {1446357600, -18000, 135},
  {1457852400, -14400, 135},
  {1478412000, -18000, 135},
  {1489302000, -14400, 135},
  {1509861600, -18000, 135},
  {1520751600, -14400, 135},
  {1541311200, -18000, 135},
  {1552201200, -14400, 135},
  {1572760800, -18000, 135},
  {1583650800, -14400, 135},
  {1604210400, -18000, 135},
  {1615705200, -14400, 135},
  {1636264800, -18000, 135},
  {1647154800, -14400, 135},
  {1667714400, -18000, 135},
  {1678604400, -14400, 135},
  {1699164000, -18000, 135},
  {1710054000, -14400, 135},
  {1730613600, -18000, 135},
  {1741503600, -14400, 135},
  {1762063200, -18000, 135},
  {1772953200, -14400, 135},
  {1793512800, -18000, 135},
  {1805007600, -14400, 135},
  {1825567200, -18000, 135},
  {1836457200, -14400, 135},
  {1857016800, -18000, 135},
  {1867906800, -14400, 135},
  {1888466400, -18000, 135},
  {1899356400, -14400, 135},
  {1919916000, -18000, 135},
  {1930806000, -14400, 135},
  {1951365600, -18000, 135},
  {1962860400, -14400, 135},
  {1983420000, -18000, 135},
  {1994310000, -14400, 135},
  {2014869600, -18000, 135},
  {2025759600, -14400, 135},
  {2046319200, -18000, 135},
  {2057209200, -14400, 135},
  {2077768800, -18000, 135},
  {2088658800, -14400, 135},
  {2109218400, -18000, 135},
  {2120108400, -14400, 135},
  {2140668000, -18000, 135},
  {INT64_MIN, -18432, 136},
  {-1827687168, -18000, 136},
  {136364400, -14400, 136},
  {152085600, -18000, 136},
  {162370800, -14400, 136},
  {183535200, -18000, 136},
  {199263600, -14400, 136},
  {215589600, -18000, 136},
  {230713200, -14400, 136},
  {247039200, -18000, 136},
  {262767600, -14400, 136},
  {278488800, -18000, 136},
  {294217200, -14400, 136},
  {309938400, -18000, 136},
  {325666800, -14400, 136},
  {341388000, -18000, 136},
  {357116400, -14400, 136},
  {372837600, -18000, 136},
  {388566000, -14400, 136},
  {404892000, -18000, 136},
  {420015600, -14400, 136},
  {436341600, -18000, 136},
  {INT64_MIN, -15408, 137},
  {-1567453392, -14400, 137},
  {-1233432000, -10800, 137},
  {-1222981200, -14400, 137},
  {-1205956800, -10800, 137},
  {-1194037200, -14400, 137},
  {-1172865600, -10800, 137},
  {-1162501200, -14400, 137},
  {-1141329600, -10800, 137},
  {-1130965200, -14400, 137},
  {-1109793600, -10800, 137},
  {-1099429200, -14400, 137},
  {-1078257600, -10800, 137},
  {-1067806800, -14400, 137},
  {-1046635200, -10800, 137},
  {-1036270800, -14400, 137},
  {-1015099200, -10800, 137},
  {-1004734800, -14400, 137},
  {-983563200, -10800, 137},
  {-973198800, -14400, 137},
  {-952027200, -10800, 137},
  {-941576400, -14400, 137},
  {-931032000, -10800, 137},
  {-900882000, -14400, 137},
  {-890337600, -10800, 137},
  {-833749200, -14400, 137},
  {-827265600, -10800, 137},
  {-752274000, -14400, 137},
  {-733780800, -10800, 137},
  {-197326800, -14400, 137},
  {-190843200, -10800, 137},
  {-184194000, -14400, 137},
  {-164491200, -10800, 137},
  {-152658000, -14400, 137},
  {-132955200, -10800, 137},
  {-121122000, -14400, 137},
  {-101419200, -10800, 137},
  {-86821200, -14400, 137},
  {-71092800, -10800, 137},
  {-54766800, -14400, 137},
  {-39038400, -10800, 137},
  {-23317200, -14400, 137},
  {-7588800, -10800, 137},
  {128142000, -7200, 137},
  {136605600, -10800, 137},
  {596948400, -7200, 137},
  {605066400, -10800, 137},
  {624423600, -7200, 137},
  {636516000, -14400, 137},
  {657086400, -10800, 137},
  {669178800, -14400, 137},
  {686721600, -7200, 137},
  {699415200, -10800, 137},
  {719377200, -7200, 137},
  {731469600, -10800, 137},
  {938919600, -10800, 137},
  {952052400, -10800, 137},
  {1198983600, -7200, 137},
  {1205632800, -10800, 137},
  {-880207200, -25200, 138},
  {-769395600, -25200, 138},
  {-765385200, -28800, 138},
  {-21477600, -25200, 138},
  {-5756400, -28800, 138},
  {9972000, -25200, 138},
  {25693200, -28800, 138},
  {41421600, -25200, 138},
  {57747600, -28800, 138},
  {73476000, -25200, 138},
  {89197200, -28800, 138},
  {104925600, -25200, 138},
  {120646800, -28800, 138},
  {126698400, -25200, 138},
  {152096400, -28800, 138},
  {162381600, -25200, 138},
  {183546000, -28800, 138},
  {199274400, -25200, 138},
  {215600400, -28800, 138},
  {230724000, -25200, 138},
  {247050000, -28800, 138},
  {262778400, -25200, 138},
  {278499600, -28800, 138},
  {294228000, -25200, 138},
  {309949200, -28800, 138},
  {325677600, -28800, 138},
  {341402400, -28800, 138},
  {357127200, -25200, 138},
  {372848400, -28800, 138},
  {388576800, -25200, 138},
  {404902800, -28800, 138},
  {420026400, -25200, 138},
  {436352400, -32400, 138},
  {439030800, -32400, 138},
  {452084400, -28800, 138},
  {467805600, -32400, 138},
  {483534000, -28800, 138},
  {499255200, -32400, 138},
  {514983600, -28800, 138},
  {530704800, -32400, 138},
  {544618800, -28800, 138},
  {562154400, -32400, 138},
  {576068400, -28800, 138},
  {594208800, -32400, 138},
  {607518000, -28800, 138},
  {625658400, -32400, 138},
  {638967600, -28800, 138},
  {657108000, -32400, 138},
  {671022000, -28800, 138},
  {688557600, -32400, 138},
  {702471600, -28800, 138},
  {720007200, -32400, 138},
  {733921200, -28800, 138},
  {752061600, -32400, 138},
  {765370800, -28800, 138},
  {783511200, -32400, 138},
  {796820400, -28800, 138},
  {814960800, -32400, 138},
  {828874800, -28800, 138},
  {846410400, -32400, 138},
  {860324400, -28800, 138},
  {877860000, -32400, 138},
  {891774000, -28800, 138},
  {909309600, -32400, 138},
  {923223600, -28800, 138},
  {941364000, -32400, 138},
  {954673200, -28800, 138},
  {972813600, -32400, 138},
  {986122800, -28800, 138},
  {1004263200, -32400, 138},
  {1018177200, -28800, 138},
  {1035712800, -32400, 138},
  {1049626800, -28800, 138},
  {1067162400, -32400, 138},
  {1081076400, -28800, 138},
  {1099216800, -32400, 138},
  {1112526000, -28800, 138},
  {1130666400, -32400, 138},
  {1143975600, -28800, 138},
  {1162116000, -32400, 138},
  {1173610800, -28800, 138},
  {1194170400, -32400, 138},
  {1205060400, -28800, 138},
  {1225620000, -32400, 138},
  {1236510000, -28800, 138},
  {1257069600, -32400, 138},
  {1268564400, -28800, 138},
  {1289124000, -32400, 138},
  {1300014000, -28800, 138},
  {1320573600, -32400, 138},
  {1331463600, -28800, 138},
  {1352023200, -32400, 138},
  {1362913200, -28800, 138},
  {1383472800, -32400, 138},
  {1394362800, -28800, 138},
  {1414922400, -32400, 138},
  {1425812400, -28800, 138},
  {1446372000, -32400, 138},
  {1457866800, -28800, 138},
  {1478426400, -32400, 138},
  {1489316400, -28800, 138},
  {1509876000, -32400, 138},
  {1520766000, -28800, 138},
  {1541325600, -32400, 138},
  {1552215600, -28800, 138},
  {1572775200, -32400, 138},
  {1583665200, -28800, 138},
  {1604224800, -32400, 138},
  {1615719600, -28800, 138},
  {1636279200, -32400, 138},
  {1647169200, -28800, 138},
  {1667728800, -32400, 138},
  {1678618800, -28800, 138},
  {1699178400, -32400, 138},
  {1710068400, -28800, 138},
  {1730628000, -32400, 138},
  {1741518000, -28800, 138},
  {1762077600, -32400, 138},
  {1772967600, -28800, 138},
  {1793527200, -32400, 138},
  {1805022000, -28800, 138},
  {1825581600, -32400, 138},
  {1836471600, -28800, 138},
  {1857031200, -32400, 138},
  {1867921200, -28800, 138},
  {1888480800, -32400, 138},
  {1899370800, -28800, 138},
  {1919930400, -32400, 138},
  {1930820400, -28800, 138},
  {1951380000, -32400, 138},
  {1962874800, -28800, 138},
  {1983434400, -32400, 138},
  {1994324400, -28800, 138},
  {2014884000, -32400, 138},
  {2025774000, -28800, 138},
  {2046333600, -32400, 138},
  {2057223600, -28800, 138},
  {2077783200, -32400, 138},
  {2088673200, -28800, 138},
  {2109232800, -32400, 138},
  {2120122800, -28800, 138},
  {2140682400, -32400, 138},
  {-1633276800, -18000, 139},
  {-1615136400, -21600, 139},
  {-1601827200, -18000, 139},
  {-1583686800, -21600, 139},
  {-1535904000, -18000, 139},
  {-1525280400, -21600, 139},
  {-905097600, -18000, 139},
  {-891795600, -21600, 139},
  {-880214400, -18000, 139},
  {-769395600, -18000, 139},
  {-765392400, -21600, 139},
  {-757360800, -18000, 139},
  {-744224400, -21600, 139},
  {-715795200, -18000, 139},
  {-608144400, -21600, 139},
  {-589392000, -18000, 139},
  {-576090000, -21600, 139},
  {-557942400, -18000, 139},
  {-544640400, -21600, 139},
  {-526492800, -18000, 139},
  {-513190800, -21600, 139},
  {-495043200, -18000, 139},
  {-481741200, -21600, 139},
  {-463593600, -18000, 139},
  {-450291600, -21600, 139},
  {-431539200, -18000, 139},
  {-415818000, -21600, 139},
  {-400089600, -18000, 139},
  {-384368400, -21600, 139},
  {-368640000, -18000, 139},
  {-352918800, -21600, 139},
  {-337190400, -18000, 139},
  {-321469200, -21600, 139},
  {-305740800, -18000, 139},
  {-289414800, -21600, 139},
  {-273686400, -18000, 139},
  {-266432400, -18000, 139},
  {-52938000, -14400, 139},
  {-37216800, -18000, 139},
  {-21488400, -14400, 139},
  {-5767200, -18000, 139},
  {9961200, -14400, 139},
  {25682400, -18000, 139},
  {41410800, -14400, 139},
  {57736800, -18000, 139},
  {73465200, -14400, 139},
  {89186400, -18000, 139},
  {104914800, -14400, 139},
  {120636000, -18000, 139},
  {126687600, -18000, 139},
  {152089200, -18000, 139},
  {162370800, -14400, 139},
  {183535200, -18000, 139},
  {199263600, -14400, 139},
  {215589600, -18000, 139},
  {230713200, -14400, 139},
  {247039200, -18000, 139},
  {262767600, -14400, 139},
  {278488800, -18000, 139},
  {294217200, -14400, 139},
  {309938400, -18000, 139},
  {325666800, -14400, 139},
  {341388000, -18000, 139},
  {357116400, -14400, 139},
  {372837600, -18000, 139},
  {388566000, -14400, 139},
  {404892000, -18000, 139},
  {420015600, -14400, 139},
  {436341600, -18000, 139},
  {452070000, -14400, 139},
  {467791200, -18000, 139},
  {483519600, -14400, 139},
  {499240800, -18000, 139},
  {514969200, -14400, 139},
  {530690400, -18000, 139},
  {544604400, -14400, 139},
  {562140000, -18000, 139},
  {576054000, -14400, 139},
  {594194400, -18000, 139},
  {607503600, -14400, 139},
  {625644000, -18000, 139},
  {638953200, -14400, 139},
  {657093600, -18000, 139},
  {671007600, -14400, 139},
  {688543200, -18000, 139},
  {702457200, -14400, 139},
  {719992800, -18000, 139},
  {733906800, -14400, 139},
  {752047200, -18000, 139},
  {765356400, -14400, 139},
  {783496800, -18000, 139},
  {796806000, -14400, 139},
  {814946400, -18000, 139},
  {828860400, -14400, 139},
  {846396000, -18000, 139},
  {860310000, -14400, 139},
  {877845600, -18000, 139},
  {891759600, -14400, 139},
  {909295200, -18000, 139},
  {923209200, -14400, 139},
  {941349600, -18000, 139},
  {954658800, -14400, 139},
  {972799200, -18000, 139},
  {986108400, -14400, 139},
  {1004248800, -18000, 139},
  {1018162800, -14400, 139},
  {1035698400, -18000, 139},
  {1049612400, -14400, 139},
  {1067148000, -18000, 139},
  {1081062000, -14400, 139},
  {1099202400, -18000, 139},
  {1112511600, -14400, 139},
  {1130652000, -18000, 139},
  {1143961200, -14400, 139},
  {1162101600, -18000, 139},
  {1173596400, -14400, 139},
  {1194156000, -18000, 139},
  {1205046000, -14400, 139},
  {1225605600, -18000, 139},
  {1236495600, -14400, 139},
  {1257055200, -18000, 139},
  {1268550000, -14400, 139},
  {1289109600, -18000, 139},
  {1299999600, -14400, 139},
  {1320559200, -18000, 139},
  {1331449200, -14400, 139},
  {1352008800, -18000, 139},
  {1362898800, -14400, 139},
  {1383458400, -18000, 139},
  {1394348400, -14400, 139},
  {1414908000, -18000, 139},
  {1425798000, -14400, 139},
  {1446357600, -18000, 139},
  {1457852400, -14400, 139},
  {1478412000, -18000, 139},
  {1489302000, -14400, 139},
  {1509861600, -18000, 139},
  {1520751600, -14400, 139},
  {1541311200, -18000, 139},
  {1552201200, -14400, 139},
  {1572760800, -18000, 139},
  {1583650800, -14400, 139},
  {1604210400, -18000, 139},
  {1615705200, -14400, 139},
  {1636264800, -18000, 139},
  {1647154800, -14400, 139},
  {1667714400, -18000, 139},
  {1678604400, -14400, 139},
  {1699164000, -18000, 139},
  {1710054000, -14400, 139},
  {1730613600, -18000, 139},
  {1741503600, -14400, 139},
  {1762063200, -18000, 139},
  {1772953200, -14400, 139},
  {1793512800, -18000, 139},
  {1805007600, -14400, 139},
  {1825567200, -18000, 139},
  {1836457200, -14400, 139},
  {1857016800, -18000, 139},
  {1867906800, -14400, 139},
  {1888466400, -18000, 139},
  {1899356400, -14400, 139},
  {1919916000, -18000, 139},
  {1930806000, -14400, 139},
  {1951365600, -18000, 139},
  {1962860400, -14400, 139},
  {1983420000, -18000, 139},
  {1994310000, -14400, 139},
  {2014869600, -18000, 139},
  {2025759600, -14400, 139},
  {2046319200, -18000, 139},
  {2057209200, -14400, 139},
  {2077768800, -18000, 139},
  {2088658800, -14400, 139},
  {2109218400, -18000, 139},
  {2120108400, -14400, 139},
  {2140668000, -18000, 139},
  {-1633276800, -18000, 140},
  {-1615136400, -21600, 140},
  {-1601827200, -18000, 140},
  {-1583686800, -21600, 140},
  {-880214400, -18000, 140},
  {-769395600, -18000, 140},
  {-765392400, -21600, 140},
  {-52934400, -18000, 140},
  {-37213200, -21600, 140},
  {-21484800, -18000, 140},
  {-5763600, -21600, 140},
  {9964800, -18000, 140},
  {25686000, -21600, 140},
  {41414400, -18000, 140},
  {57740400, -21600, 140},
  {73468800, -18000, 140},
  {89190000, -21600, 140},
  {104918400, -18000, 140},
  {120639600, -21600, 140},
  {126691200, -18000, 140},
  {152089200, -21600, 140},
  {162374400, -18000, 140},
  {183538800, -21600, 140},
  {199267200, -18000, 140},
  {215593200, -21600, 140},
  {230716800, -18000, 140},
  {247042800, -21600, 140},
  {262771200, -18000, 140},
  {278492400, -21600, 140},
  {294220800, -18000, 140},
  {309942000, -21600, 140},
  {325670400, -18000, 140},
  {341391600, -21600, 140},
  {357120000, -18000, 140},
  {372841200, -21600, 140},
  {388569600, -18000, 140},
  {404895600, -21600, 140},
  {420019200, -18000, 140},
  {436345200, -21600, 140},
  {452073600, -18000, 140},
  {467794800, -21600, 140},
  {483523200, -18000, 140},
  {499244400, -21600, 140},
  {514972800, -18000, 140},
  {530694000, -21600, 140},
  {544608000, -18000, 140},
  {562143600, -21600, 140},
  {576057600, -18000, 140},
  {594198000, -21600, 140},
  {607507200, -18000, 140},
  {625647600, -21600, 140},
  {638956800, -18000, 140},
  {657097200, -21600, 140},
  {671011200, -18000, 140},
  {688546800, -21600, 140},
  {702460800, -18000, 140},
  {719996400, -21600, 140},
  {733910400, -18000, 140},
  {752050800, -21600, 140},
  {765360000, -18000, 140},
  {783500400, -21600, 140},
  {796809600, -18000, 140},
  {814950000, -21600, 140},
  {828864000, -18000, 140},
  {846399600, -21600, 140},
  {860313600, -18000, 140},
  {877849200, -21600, 140},
  {891763200, -18000, 140},
  {909298800, -21600, 140},
  {923212800, -18000, 140},
  {941353200, -21600, 140},
  {954662400, -18000, 140},
  {972802800, -18000, 140},
  {986108400, -14400, 140},
  {1004248800, -18000, 140},
  {1018162800, -14400, 140},
  {1035698400, -18000, 140},
  {1049612400, -14400, 140},
  {1067148000, -18000, 140},
  {1081062000, -14400, 140},
  {1099202400, -18000, 140},
  {1112511600, -14400, 140},
  {1130652000, -18000, 140},
  {1143961200, -14400, 140},
  {1162101600, -18000, 140},
  {1173596400, -14400, 140},
  {1194156000, -18000, 140},
  {1205046000, -14400, 140},
  {1225605600, -18000, 140},
  {1236495600, -14400, 140},
  {1257055200, -18000, 140},
  {1268550000, -14400, 140},
  {1289109600, -18000, 140},
  {1299999600, -14400, 140},
  {1320559200, -18000, 140},
  {1331449200, -14400, 140},
  {1352008800, -18000, 140},
  {1362898800, -14400, 140},
  {1383458400, -18000, 140},
  {1394348400, -14400, 140},
  {1414908000, -18000, 140},
  {1425798000, -14400, 140},
  {1446357600, -18000, 140},
  {1457852400, -14400, 140},
  {1478412000, -18000, 140},
  {1489302000, -14400, 140},
  {1509861600, -18000, 140},
  {1520751600, -14400, 140},
  {1541311200, -18000, 140},
  {1552201200, -14400, 140},
  {1572760800, -18000, 140},
  {1583650800, -14400, 140},
  {1604210400, -18000, 140},
  {1615705200, -14400, 140},
  {1636264800, -18000, 140},
  {1647154800, -14400, 140},
  {1667714400, -18000, 140},
  {1678604400, -14400, 140},
  {1699164000, -18000, 140},
  {1710054000, -14400, 140},
  {1730613600, -18000, 140},
  {1741503600, -14400, 140},
  {1762063200, -18000, 140},
  {1772953200, -14400, 140},
  {1793512800, -18000, 140},
  {1805007600, -14400, 140},
  {1825567200, -18000, 140},
  {1836457200, -14400, 140},
  {1857016800, -18000, 140},
  {1867906800, -14400, 140},
  {1888466400, -18000, 140},
  {1899356400, -14400, 140},
  {1919916000, -18000, 140},
  {1930806000, -14400, 140},
  {1951365600, -18000, 140},
  {1962860400, -14400, 140},
  {1983420000, -18000, 140},
  {1994310000, -14400, 140},
  {2014869600, -18000, 140},
  {2025759600, -14400, 140},
  {2046319200, -18000, 140},
  {2057209200, -14400, 140},
  {2077768800, -18000, 140},
  {2088658800, -14400, 140},
  {2109218400, -18000, 140},
  {2120108400, -14400, 140},
  {2140668000, -18000, 140},
  {-1633276800, -18000, 141},
  {-1615136400, -21600, 141},
  {-1601827200, -18000, 141},
  {-1583686800, -21600, 141},
  {-880214400, -18000, 141},
  {-769395600, -18000, 141},
  {-765392400, -21600, 141},
  {-715795200, -18000, 141},
  {-702493200, -21600, 141},
  {-684345600, -18000, 141},
  {-671043600, -21600, 141},
  {-652896000, -18000, 141},
  {-639594000, -21600, 141},
  {-620841600, -18000, 141},
  {-608144400, -21600, 141},
  {-589392000, -18000, 141},
  {-576090000, -21600, 141},
  {-557942400, -18000, 141},
  {-544640400, -21600, 141},
  {-526492800, -18000, 141},
  {-513190800, -21600, 141},
  {-495043200, -18000, 141},
  {-481741200, -21600, 141},
  {-463593600, -18000, 141},
  {-447267600, -21600, 141},
  {-431539200, -18000, 141},
  {-415818000, -21600, 141},
  {-400089600, -18000, 141},
  {-386787600, -21600, 141},
  {-368640000, -18000, 141},
  {-355338000, -21600, 141},
  {-337190400, -18000, 141},
  {-321469200, -21600, 141},
  {-305740800, -18000, 141},
  {-289414800, -21600, 141},
  {-273686400, -18000, 141},
  {-257965200, -21600, 141},
  {-242236800, -18000, 141},
  {-195066000, -21600, 141},
  {-84384000, -18000, 141},
  {-68662800, -21600, 141},
  {-52934400, -18000, 141},
  {-37213200, -21600, 141},
  {-21484800, -18000, 141},
  {-5763600, -21600, 141},
  {9964800, -18000, 141},
  {25686000, -21600, 141},
  {41414400, -18000, 141},
  {57740400, -21600, 141},
  {73468800, -18000, 141},
  {89190000, -21600, 141},
  {104918400, -18000, 141},
  {120639600, -21600, 141},
  {126691200, -18000, 141},
  {152089200, -21600, 141},
  {162374400, -18000, 141},
  {183538800, -21600, 141},
  {199267200, -18000, 141},
  {215593200, -21600, 141},
  {230716800, -18000, 141},
  {247042800, -21600, 141},
  {262771200, -18000, 141},
  {278492400, -21600, 141},
  {294220800, -18000, 141},
  {309942000, -21600, 141},
  {325670400, -18000, 141},
  {341391600, -21600, 141},
  {357120000, -18000, 141},
  {372841200, -21600, 141},
  {388569600, -18000, 141},
  {404895600, -21600, 141},
  {420019200, -18000, 141},
  {436345200, -21600, 141},
  {452073600, -18000, 141},
  {467794800, -21600, 141},
  {483523200, -18000, 141},
  {499244400, -21600, 141},
  {514972800, -18000, 141},
  {530694000, -21600, 141},
  {544608000, -18000, 141},
  {562143600, -21600, 141},
  {576057600, -18000, 141},
  {594198000, -21600, 141},
  {607507200, -18000, 141},
  {625647600, -21600, 141},
  {638956800, -18000, 141},
  {657097200, -21600, 141},
  {671011200, -18000, 141},
  {688546800, -18000, 141},
  {1143961200, -18000, 141},
  {1162105200, -21600, 141},
  {1173600000, -18000, 141},
  {1194159600, -21600, 141},
  {1205049600, -18000, 141},
  {1225609200, -21600, 141},
  {1236499200, -18000, 141},
  {1257058800, -21600, 141},
  {1268553600, -18000, 141},
  {1289113200, -21600, 141},
  {1300003200, -18000, 141},
  {1320562800, -21600, 141},
  {1331452800, -18000, 141},
  {1352012400, -21600, 141},
  {1362902400, -18000, 141},
  {1383462000, -21600, 141},
  {1394352000, -18000, 141},
  {1414911600, -21600, 141},
  {1425801600, -18000, 141},
  {1446361200, -21600, 141},
  {1457856000, -18000, 141},
  {1478415600, -21600, 141},
  {1489305600, -18000, 141},
  {1509865200, -21600, 141},
  {1520755200, -18000, 141},
  {1541314800, -21600, 141},
  {1552204800, -18000, 141},
  {1572764400, -21600, 141},
  {1583654400, -18000, 141},
  {1604214000, -21600, 141},
  {1615708800, -18000, 141},
  {1636268400, -21600, 141},
  {1647158400, -18000, 141},
  {1667718000, -21600, 141},
  {1678608000, -18000, 141},
  {1699167600, -21600, 141},
  {1710057600, -18000, 141},
  {1730617200, -21600, 141},
  {1741507200, -18000, 141},
  {1762066800, -21600, 141},
  {1772956800, -18000, 141},
  {1793516400, -21600, 141},
  {1805011200, -18000, 141},
  {1825570800, -21600, 141},
  {1836460800, -18000, 141},
  {1857020400, -21600, 141},
  {1867910400, -18000, 141},
  {1888470000, -21600, 141},
  {1899360000, -18000, 141},
  {1919919600, -21600, 141},
  {1930809600, -18000, 141},
  {1951369200, -21600, 141},
  {1962864000, -18000, 141},
  {1983423600, -21600, 141},
  {1994313600, -18000, 141},
  {2014873200, -21600, 141},
  {2025763200, -18000, 141},
  {2046322800, -21600, 141},
  {2057212800, -18000, 141},
  {2077772400, -21600, 141},
  {2088662400, -18000, 141},
  {2109222000, -21600, 141},
  {2120112000, -18000, 141},
  {2140671600, -21600, 141},
  {INT64_MIN, -16544, 142},
  {-1826738656, -16200, 142},
  {-157750200, -14400, 142},
  {INT64_MIN, -16356, 143},
  {-1205954844, -12756, 143},
  {-1192307244, -14400, 143},
  {INT64_MIN, -18516, 144},
  {-1938538284, -18000, 144},
  {-1009825200, -14400, 144},
  {-1002052800, -18000, 144},
  {-986756400, -14400, 144},
  {-971035200, -18000, 144},
  {-955306800, -14400, 144},
  {-939585600, -18000, 144},
  {504939600, -14400, 144},
  {512712000, -18000, 144},
  {536475600, -14400, 144},
  {544248000, -18000, 144},
  {631170000, -14400, 144},
  {638942400, -18000, 144},
  {757400400, -14400, 144},
  {765172800, -18000, 144},
  {-1633269600, -25200, 145},
  {-1615129200, -28800, 145},
  {-1601820000, -25200, 145},
  {-1583679600, -28800, 145},
  {-880207200, -25200, 145},
  {-769395600, -25200, 145},
  {-765385200, -28800, 145},
  {-687967200, -25200, 145},
  {-662655600, -28800, 145},
  {-620834400, -25200, 145},
  {-608137200, -28800, 145},
  {-589384800, -25200, 145},
  {-576082800, -28800, 145},
  {-557935200, -25200, 145},
  {-544633200, -28800, 145},
  {-526485600, -25200, 145},
  {-513183600, -28800, 145},
  {-495036000, -25200, 145},
  {-481734000, -28800, 145},
  {-463586400, -25200, 145},
  {-450284400, -28800, 145},
  {-431532000, -25200, 145},
  {-418230000, -28800, 145},
  {-400082400, -25200, 145},
  {-386780400, -28800, 145},
  {-368632800, -25200, 145},
  {-355330800, -28800, 145},
  {-337183200, -25200, 145},
  {-323881200, -28800, 145},
  {-305733600, -25200, 145},
  {-292431600, -28800, 145},
  {-273679200, -25200, 145},
  {-260982000, -28800, 145},
  {-242229600, -25200, 145},
  {-226508400, -28800, 145},
  {-210780000, -25200, 145},
  {-195058800, -28800, 145},
  {-179330400, -25200, 145},
  {-163609200, -28800, 145},
  {-147880800, -25200, 145},
  {-131554800, -28800, 145},
  {-116431200, -25200, 145},
  {-100105200, -28800, 145},
  {-84376800, -25200, 145},
  {-68655600, -28800, 145},
  {-52927200, -25200, 145},
  {-37206000, -28800, 145},
  {-21477600, -25200, 145},
  {-5756400, -28800, 145},
  {9972000, -25200, 145},
  {25693200, -28800, 145},
  {41421600, -25200, 145},
  {57747600, -28800, 145},
  {73476000, -25200, 145},
  {89197200, -28800, 145},
  {104925600, -25200, 145},
  {120646800, -28800, 145},
  {126698400, -25200, 145},
  {152096400, -28800, 145},
  {162381600, -25200, 145},
  {183546000, -28800, 145},
  {199274400, -25200, 145},
  {215600400, -28800, 145},
  {230724000, -25200, 145},
  {247050000, -28800, 145},
  {262778400, -25200, 145},
  {278499600, -28800, 145},
  {294228000, -25200, 145},
  {309949200, -28800, 145},
  {325677600, -25200, 145},
  {341398800, -28800, 145},
  {357127200, -25200, 145},
  {372848400, -28800, 145},
  {388576800, -25200, 145},
  {404902800, -28800, 145},
  {420026400, -25200, 145},
  {436352400, -28800, 145},
  {452080800, -25200, 145},
  {467802000, -28800, 145},
  {483530400, -25200, 145},
  {499251600, -28800, 145},
  {514980000, -25200, 145},
  {530701200, -28800, 145},
  {544615200, -25200, 145},
  {562150800, -28800, 145},
  {576064800, -25200, 145},
  {594205200, -28800, 145},
  {607514400, -25200, 145},
  {625654800, -28800, 145},
  {638964000, -25200, 145},
  {657104400, -28800, 145},
  {671018400, -25200, 145},
  {688554000, -28800, 145},
  {702468000, -25200, 145},
  {720003600, -28800, 145},
  {733917600, -25200, 145},
  {752058000, -28800, 145},
  {765367200, -25200, 145},
  {783507600, -28800, 145},
  {796816800, -25200, 145},
  {814957200, -28800, 145},
  {828871200, -25200, 145},
  {846406800, -28800, 145},
  {860320800, -25200, 145},
  {877856400, -28800, 145},
  {891770400, -25200, 145},
  {909306000, -28800, 145},
  {923220000, -25200, 145},
  {941360400, -28800, 145},
  {954669600, -25200, 145},
  {972810000, -28800, 145},
  {986119200, -25200, 145},
  {1004259600, -28800, 145},
  {1018173600, -25200, 145},
  {1035709200, -28800, 145},
  {1049623200, -25200, 145},
  {1067158800, -28800, 145},
  {1081072800, -25200, 145},
  {1099213200, -28800, 145},
  {1112522400, -25200, 145},
  {1130662800, -28800, 145},
  {1143972000, -25200, 145},
  {1162112400, -28800, 145},
  {1173607200, -25200, 145},
  {1194166800, -28800, 145},
  {1205056800, -25200, 145},
  {1225616400, -28800, 145},
  {1236506400, -25200, 145},
  {1257066000, -28800, 145},
  {1268560800, -25200, 145},
  {1289120400, -28800, 145},
  {1300010400, -25200, 145},
  {1320570000, -28800, 145},
  {1331460000, -25200, 145},
  {1352019600, -28800, 145},
  {1362909600, -25200, 145},
  {1383469200, -28800, 145},
  {1394359200, -25200, 145},
  {1414918800, -28800, 145},
  {1425808800, -25200, 145},
  {1446368400, -28800, 145},
  {1457863200, -25200, 145},
  {1478422800, -28800, 145},
  {1489312800, -25200, 145},
  {1509872400, -28800, 145},
  {1520762400, -25200, 145},
  {1541322000, -28800, 145},
  {1552212000, -25200, 145},
  {1572771600, -28800, 145},
  {1583661600, -25200, 145},
  {1604221200, -28800, 145},
  {1615716000, -25200, 145},
  {1636275600, -28800, 145},
  {1647165600, -25200, 145},
  {1667725200, -28800, 145},
  {1678615200, -25200, 145},
  {1699174800, -28800, 145},
  {1710064800, -25200, 145},
  {1730624400, -28800, 145},
  {1741514400, -25200, 145},
  {1762074000, -28800, 145},
  {1772964000, -25200, 145},
  {1793523600, -28800, 145},
  {1805018400, -25200, 145},
  {1825578000, -28800, 145},
  {1836468000, -25200, 145},
  {1857027600, -28800, 145},
  {1867917600, -25200, 145},
  {1888477200, -28800, 145},
  {1899367200, -25200, 145},
  {1919926800, -28800, 145},
  {1930816800, -25200, 145},
  {1951376400, -28800, 145},
  {1962871200, -25200, 145},
  {1983430800, -28800, 145},
  {1994320800, -25200, 145},
  {2014880400, -28800, 145},
  {2025770400, -25200, 145},
  {2046330000, -28800, 145},
  {2057220000, -25200, 145},
  {2077779600, -28800, 145},
  {2088669600, -25200, 145},
  {2109229200, -28800, 145},
  {2120119200, -25200, 145},
  {2140678800, -28800, 145},
  {-1633276800, -18000, 146},
  {-1615136400, -21600, 146},
  {-1601827200, -18000, 146},
  {-1583686800, -21600, 146},
  {-1535904000, -18000, 146},
  {-1525280400, -21600, 146},
  {-905097600, -18000, 146},
  {-891795600, -21600, 146},
  {-880214400, -18000, 146},
  {-769395600, -18000, 146},
  {-765392400, -21600, 146},
  {-757360800, -18000, 146},
  {-744224400, -21600, 146},
  {-715795200, -18000, 146},
  {-608144400, -21600, 146},
  {-589392000, -18000, 146},
  {-576090000, -21600, 146},
  {-557942400, -18000, 146},
  {-544640400, -21600, 146},
  {-526492800, -18000, 146},
  {-513190800, -21600, 146},
  {-495043200, -18000, 146},
  {-481741200, -21600, 146},
  {-463593600, -18000, 146},
  {-450291600, -21600, 146},
  {-431539200, -18000, 146},
  {-415818000, -21600, 146},
  {-400089600, -18000, 146},
  {-384368400, -21600, 146},
  {-368640000, -18000, 146},
  {-352918800, -21600, 146},
  {-337190400, -18000, 146},
  {-321469200, -21600, 146},
  {-305740800, -18000, 146},
  {-289414800, -21600, 146},
  {-273686400, -18000, 146},
  {-266432400, -18000, 146},
  {-52938000, -14400, 146},
  {-37216800, -18000, 146},
  {-21488400, -14400, 146},
  {-5767200, -18000, 146},
  {9961200, -14400, 146},
  {25682400, -18000, 146},
  {41410800, -14400, 146},
  {57736800, -18000, 146},
  {73465200, -14400, 146},
  {89186400, -18000, 146},
  {104914800, -14400, 146},
  {120636000, -18000, 146},
  {126687600, -18000, 146},
  {152089200, -18000, 146},
  {162370800, -14400, 146},
  {183535200, -18000, 146},
  {199263600, -14400, 146},
  {215589600, -18000, 146},
  {230713200, -14400, 146},
  {247039200, -18000, 146},
  {262767600, -14400, 146},
  {278488800, -18000, 146},
  {294217200, -14400, 146},
  {309938400, -18000, 146},
  {325666800, -14400, 146},
  {341388000, -18000, 146},
  {357116400, -14400, 146},
  {372837600, -18000, 146},
  {388566000, -14400, 146},
  {404892000, -18000, 146},
  {420015600, -14400, 146},
  {436341600, -18000, 146},
  {452070000, -14400, 146},
  {467791200, -18000, 146},
  {483519600, -14400, 146},
  {499240800, -18000, 146},
  {514969200, -14400, 146},
  {530690400, -18000, 146},
  {544604400, -14400, 146},
  {562140000, -18000, 146},
  {576054000, -14400, 146},
  {594194400, -18000, 146},
  {607503600, -14400, 146},
  {625644000, -18000, 146},
  {638953200, -14400, 146},
  {657093600, -18000, 146},
  {671007600, -14400, 146},
  {688543200, -18000, 146},
  {702457200, -14400, 146},
  {719992800, -18000, 146},
  {733906800, -14400, 146},
  {752047200, -18000, 146},
  {765356400, -14400, 146},
  {783496800, -18000, 146},
  {796806000, -14400, 146},
  {814946400, -18000, 146},
  {828860400, -14400, 146},
  {846396000, -18000, 146},
  {860310000, -14400, 146},
  {877845600, -18000, 146},
  {891759600, -14400, 146},
  {909295200, -18000, 146},
  {923209200, -14400, 146},
  {941349600, -18000, 146},
  {954658800, -14400, 146},
  {972799200, -18000, 146},
  {986108400, -14400, 146},
  {1004248800, -18000, 146},
  {1018162800, -14400, 146},
  {1035698400, -18000, 146},
  {1049612400, -14400, 146},
  {1067148000, -18000, 146},
  {1081062000, -14400, 146},
  {1099202400, -18000, 146},
  {1112511600, -14400, 146},
  {1130652000, -18000, 146},
  {1143961200, -14400, 146},
  {1162101600, -18000, 146},
  {1173596400, -14400, 146},
  {1194156000, -18000, 146},
  {1205046000, -14400, 146},
  {1225605600, -18000, 146},
  {1236495600, -14400, 146},
  {1257055200, -18000, 146},
  {1268550000, -14400, 146},
  {1289109600, -18000, 146},
  {1299999600, -14400, 146},
  {1320559200, -18000, 146},
  {1331449200, -14400, 146},
  {1352008800, -18000, 146},
  {1362898800, -14400, 146},
  {1383458400, -18000, 146},
  {1394348400, -14400, 146},
  {1414908000, -18000, 146},
  {1425798000, -14400, 146},
  {1446357600, -18000, 146},
  {1457852400, -14400, 146},
  {1478412000, -18000, 146},
  {1489302000, -14400, 146},
  {1509861600, -18000, 146},
  {1520751600, -14400, 146},
  {1541311200, -18000, 146},
  {1552201200, -14400, 146},
  {1572760800, -18000, 146},
  {1583650800, -14400, 146},
  {1604210400, -18000, 146},
  {1615705200, -14400, 146},
  {1636264800, -18000, 146},
  {1647154800, -14400, 146},
  {1667714400, -18000, 146},
  {1678604400, -14400, 146},
  {1699164000, -18000, 146},
  {1710054000, -14400, 146},
  {1730613600, -18000, 146},
  {1741503600, -14400, 146},
  {1762063200, -18000, 146},
  {1772953200, -14400, 146},
  {1793512800, -18000, 146},
  {1805007600, -14400, 146},
  {1825567200, -18000, 146},
  {1836457200, -14400, 146},
  {1857016800, -18000, 146},
  {1867906800, -14400, 146},
  {1888466400, -18000, 146},
  {1899356400, -14400, 146},
  {1919916000, -18000, 146},
  {1930806000, -14400, 146},
  {1951365600, -18000, 146},
  {1962860400, -14400, 146},
  {1983420000, -18000, 146},
  {1994310000, -14400, 146},
  {2014869600, -18000, 146},
  {2025759600, -14400, 146},
  {2046319200, -18000, 146},
  {2057209200, -14400, 146},
  {2077768800, -18000, 146},
  {2088658800, -14400, 146},
  {2109218400, -18000, 146},
  {2120108400, -14400, 146},
  {2140668000, -18000, 146},
  {INT64_MIN, -16544, 147},
  {-1826738656, -16200, 147},
  {-157750200, -14400, 147},
  {INT64_MIN, -8572, 148},
  {-1767217028, -10800, 148},
  {-1206957600, -7200, 148},
  {-1191362400, -10800, 148},
  {-1175374800, -7200, 148},
  {-1159826400, -10800, 148},
  {-633819600, -7200, 148},
  {-622069200, -10800, 148},
  {-602283600, -7200, 148},
  {-591832800, -10800, 148},
  {-570747600, -7200, 148},
  {-560210400, -10800, 148},
  {-539125200, -7200, 148},
  {-531352800, -10800, 148},
  {-191365200, -7200, 148},
  {-184197600, -10800, 148},
  {-155163600, -7200, 148},
  {-150069600, -10800, 148},
  {-128898000, -7200, 148},
  {-121125600, -10800, 148},
  {-99954000, -7200, 148},
  {-89589600, -10800, 148},
  {-68418000, -7200, 148},
  {-57967200, -10800, 148},
  {499748400, -7200, 148},
  {511236000, -10800, 148},
  {530593200, -7200, 148},
  {540266400, -10800, 148},
  {562129200, -7200, 148},
  {571197600, -10800, 148},
  {592974000, -7200, 148},
  {602042400, -10800, 148},
  {624423600, -7200, 148},
  {634701600, -10800, 148},
  {813726000, -7200, 148},
  {824004000, -10800, 148},
  {938919600, -7200, 148},
  {951616800, -10800, 148},
  {970974000, -7200, 148},
  {972180000, -10800, 148},
  {1003028400, -7200, 148},
  {1013911200, -10800, 148},
  {INT64_MIN, -20712, 149},
  {-1121105688, -21600, 149},
  {105084000, -18000, 149},
  {161758800, -21600, 149},
  {290584800, -18000, 149},
  {299134800, -21600, 149},
  {322034400, -18000, 149},
  {330584400, -21600, 149},
  {694260000, -18000, 149},
  {717310800, -21600, 149},
  {725868000, -18000, 149},
  {852094800, -21600, 149},
  {1113112800, -18000, 149},
  {1128229200, -21600, 149},
  {1146384000, -18000, 149},
  {1159682400, -21600, 149},
  {INT64_MIN, -14404, 150},
  {-1767211196, -14400, 150},
  {-1206954000, -10800, 150},
  {-1191358800, -14400, 150},
  {-1175371200, -10800, 150},
  {-1159822800, -14400, 150},
  {-633816000, -10800, 150},
  {-622065600, -14400, 150},
  {-602280000, -10800, 150},
  {-591829200, -14400, 150},
  {-570744000, -10800, 150},
  {-560206800, -14400, 150},
  {-539121600, -10800, 150},
  {-531349200, -14400, 150},
  {-191361600, -10800, 150},
  {-184194000, -14400, 150},
  {-155160000, -10800, 150},
  {-150066000, -14400, 150},
  {-128894400, -10800, 150},
  {-121122000, -14400, 150},
  {-99950400, -10800, 150},
  {-89586000, -14400, 150},
  {-68414400, -10800, 150},
  {-57963600, -14400, 150},
  {499752000, -10800, 150},
  {511239600, -14400, 150},
  {530596800, -10800, 150},
  {540270000, -14400, 150},
  {562132800, -10800, 150},
  {571201200, -14400, 150},
  {750830400, -10800, 150},
  {761713200, -14400, 150},
  {INT64_MIN, -14768, 151},
  {-1848254032, -14400, 151},
  {INT64_MIN, -14660, 152},
  {-1851537340, -14400, 152},
  {323841600, -10800, 152},
  {338958000, -14400, 152},
  {INT64_MIN, -24000, 153},
  {-1514743200, -21600, 153},
  {576057600, -18000, 153},
  {594198000, -21600, 153},
  {828864000, -18000, 153},
  {846399600, -21600, 153},
  {860313600, -18000, 153},
  {877849200, -21600, 153},
  {891763200, -18000, 153},
  {909298800, -21600, 153},
  {923212800, -18000, 153},
  {941353200, -21600, 153},
  {954662400, -18000, 153},
  {972802800, -21600, 153},
  {989136000, -18000, 153},
  {1001833200, -21600, 153},
  {1018166400, -18000, 153},
  {1035702000, -21600, 153},
  {1049616000, -18000, 153},
  {1067151600, -21600, 153},
  {1081065600, -18000, 153},
  {1099206000, -21600, 153},
  {1112515200, -18000, 153},
  {1130655600, -21600, 153},
  {1143964800, -18000, 153},
  {1162105200, -21600, 153},
  {1175414400, -18000, 153},
  {1193554800, -21600, 153},
  {1207468800, -18000, 153},
  {1225004400, -21600, 153},
  {1238918400, -18000, 153},
  {1256454000, -21600, 153},
  {1268553600, -18000, 153},
  {1289113200, -21600, 153},
  {1300003200, -18000, 153},
  {1320562800, -21600, 153},
  {1331452800, -18000, 153},
  {1352012400, -21600, 153},
  {1362902400, -18000, 153},
  {1383462000, -21600, 153},
  {1394352000, -18000, 153},
  {1414911600, -21600, 153},
  {1425801600, -18000, 153},
  {1446361200, -21600, 153},
  {1457856000, -18000, 153},
  {1478415600, -21600, 153},
  {1489305600, -18000, 153},
  {1509865200, -21600, 153},
  {1520755200, -18000, 153},
  {1541314800, -21600, 153},
  {1552204800, -18000, 153},
  {1572764400, -21600, 153},
  {1583654400, -18000, 153},
  {1604214000, -21600, 153},
  {1615708800, -18000, 153},
  {1636268400, -21600, 153},
  {1647158400, -18000, 153},
  {1667718000, -21600, 153},
  {1678608000, -18000, 153},
  {1699167600, -21600, 153},
  {1710057600, -18000, 153},
  {1730617200, -21600, 153},
  {1741507200, -18000, 153},
  {1762066800, -21600, 153},
  {1772956800, -18000, 153},
  {1793516400, -21600, 153},
  {1805011200, -18000, 153},
  {1825570800, -21600, 153},
  {1836460800, -18000, 153},
  {1857020400, -21600, 153},
  {1867910400, -18000, 153},
  {1888470000, -21600, 153},
  {1899360000, -18000, 153},
  {1919919600, -21600, 153},
  {1930809600, -18000, 153},
  {1951369200, -21600, 153},
  {1962864000, -18000, 153},
  {1983423600, -21600, 153},
  {1994313600, -18000, 153},
  {2014873200, -21600, 153},
  {2025763200, -18000, 153},
  {2046322800, -21600, 153},
  {2057212800, -18000, 153},
  {2077772400, -21600, 153},
  {2088662400, -18000, 153},
  {2109222000, -21600, 153},
  {2120112000, -18000, 153},
  {2140671600, -21600, 153},
  {INT64_MIN, -25540, 154},
  {-1514739600, -25200, 154},
  {-1343066400, -21600, 154},
  {-1234807200, -25200, 154},
  {-1220292000, -21600, 154},
  {-1207159200, -25200, 154},
  {-1191344400, -21600, 154},
  {-873828000, -25200, 154},
  {-661539600, -28800, 154},
  {28800, -25200, 154},
  {828867600, -21600, 154},
  {846403200, -25200, 154},
  {860317200, -21600, 154},
  {877852800, -25200, 154},
  {891766800, -21600, 154},
  {909302400, -25200, 154},
  {923216400, -21600, 154},
  {941356800, -25200, 154},
  {954666000, -21600, 154},
  {972806400, -25200, 154},
  {989139600, -21600, 154},
  {1001836800, -25200, 154},
  {1018170000, -21600, 154},
  {1035705600, -25200, 154},
  {1049619600, -21600, 154},
  {1067155200, -25200, 154},
  {1081069200, -21600, 154},
  {1099209600, -25200, 154},
  {1112518800, -21600, 154},
  {1130659200, -25200, 154},
  {1143968400, -21600, 154},
  {1162108800, -25200, 154},
  {1175418000, -21600, 154},
  {1193558400, -25200, 154},
  {1207472400, -21600, 154},
  {1225008000, -25200, 154},
  {1238922000, -21600, 154},
  {1256457600, -25200, 154},
  {1270371600, -21600, 154},
  {1288512000, -25200, 154},
  {1301821200, -21600, 154},
  {1319961600, -25200, 154},
  {1333270800, -21600, 154},
  {1351411200, -25200, 154},
  {1365325200, -21600, 154},
  {1382860800, -25200, 154},
  {1396774800, -21600, 154},
  {1414310400, -25200, 154},
  {1428224400, -21600, 154},
  {1445760000, -25200, 154},
  {1459674000, -21600, 154},
  {1477814400, -25200, 154},
  {1491123600, -21600, 154},
  {1509264000, -25200, 154},
  {1522573200, -21600, 154},
  {1540713600, -25200, 154},
  {1554627600, -21600, 154},
  {1572163200, -25200, 154},
  {1586077200, -21600, 154},
  {1603612800, -25200, 154},
  {1617526800, -21600, 154},
  {1635667200, -25200, 154},
  {1648976400, -21600, 154},
  {1667116800, -25200, 154},
  {1680426000, -21600, 154},
  {1698566400, -25200, 154},
  {1712480400, -21600, 154},
  {1730016000, -25200, 154},
  {1743930000, -21600, 154},
  {1761465600, -25200, 154},
  {1775379600, -21600, 154},
  {1792915200, -25200, 154},
  {1806829200, -21600, 154},
  {1824969600, -25200, 154},
  {1838278800, -21600, 154},
  {1856419200, -25200, 154},
  {1869728400, -21600, 154},
  {1887868800, -25200, 154},
  {1901782800, -21600, 154},
  {1919318400, -25200, 154},
  {1933232400, -21600, 154},
  {1950768000, -25200, 154},
  {1964682000, -21600, 154},
  {1982822400, -25200, 154},
  {1996131600, -21600, 154},
  {2014272000, -25200, 154},
  {2027581200, -21600, 154},
  {2045721600, -25200, 154},
  {2059030800, -21600, 154},
  {2077171200, -25200, 154},
  {2091085200, -21600, 154},
  {2108620800, -25200, 154},
  {2122534800, -21600, 154},
  {2140070400, -25200, 154},
  {INT64_MIN, -15408, 155},
  {-1567453392, -14400, 155},
  {-1233432000, -10800, 155},
  {-1222981200, -14400, 155},
  {-1205956800, -10800, 155},
  {-1194037200, -14400, 155},
  {-1172865600, -10800, 155},
  {-1162501200, -14400, 155},
  {-1141329600, -10800, 155},
  {-1130965200, -14400, 155},
  {-1109793600, -10800, 155},
  {-1099429200, -14400, 155},
  {-1078257600, -10800, 155},
  {-1067806800, -14400, 155},
  {-1046635200, -10800, 155},
  {-1036270800, -14400, 155},
  {-1015099200, -10800, 155},
  {-1004734800, -14400, 155},
  {-983563200, -10800, 155},
  {-973198800, -14400, 155},
  {-952027200, -10800, 155},
  {-941576400, -14400, 155},
  {-931032000, -10800, 155},
  {-900882000, -14400, 155},
  {-890337600, -10800, 155},
  {-833749200, -14400, 155},
  {-827265600, -10800, 155},
  {-752274000, -14400, 155},
  {-733780800, -10800, 155},
  {-197326800, -14400, 155},
  {-190843200, -10800, 155},
  {-184194000, -14400, 155},
  {-164491200, -10800, 155},
  {-152658000, -14400, 155},
  {-132955200, -10800, 155},
  {-121122000, -14400, 155},
  {-101419200, -10800, 155},
  {-86821200, -14400, 155},
  {-71092800, -10800, 155},
  {-54766800, -14400, 155},
  {-39038400, -10800, 155},
  {-23317200, -14400, 155},
  {-7588800, -10800, 155},
  {128142000, -7200, 155},
  {136605600, -10800, 155},
  {596948400, -7200, 155},
  {605066400, -10800, 155},
  {624423600, -7200, 155},
  {636516000, -14400, 155},
  {655963200, -10800, 155},
  {667796400, -14400, 155},
  {687499200, -10800, 155},
  {699418800, -14400, 155},
  {719380800, -7200, 155},
  {731469600, -10800, 155},
  {938919600, -10800, 155},
  {952052400, -10800, 155},
  {1085281200, -14400, 155},
  {1096171200, -10800, 155},
  {1198983600, -7200, 155},
  {1205632800, -10800, 155},
  {-1633276800, -18000, 156},
  {-1615136400, -21600, 156},
  {-1601827200, -18000, 156},
  {-1583686800, -21600, 156},
  {-880214400, -18000, 156},
  {-769395600, -18000, 156},
  {-765392400, -21600, 156},
  {-747244800, -18000, 156},
  {-733942800, -21600, 156},
  {-116438400, -18000, 156},
  {-100112400, -21600, 156},
  {-21484800, -18000, 156},
  {104914800, -18000, 156},
  {120639600, -21600, 156},
  {126691200, -18000, 156},
  {152089200, -21600, 156},
  {162374400, -18000, 156},
  {183538800, -21600, 156},
  {199267200, -18000, 156},
  {215593200, -21600, 156},
  {230716800, -18000, 156},
  {247042800, -21600, 156},
  {262771200, -18000, 156},
  {278492400, -21600, 156},
  {294220800, -18000, 156},
  {309942000, -21600, 156},
  {325670400, -18000, 156},
  {341391600, -21600, 156},
  {357120000, -18000, 156},
  {372841200, -21600, 156},
  {388569600, -18000, 156},
  {404895600, -21600, 156},
  {420019200, -18000, 156},
  {436345200, -21600, 156},
  {452073600, -18000, 156},
  {467794800, -21600, 156},
  {483523200, -18000, 156},
  {499244400, -21600, 156},
  {514972800, -18000, 156},
  {530694000, -21600, 156},
  {544608000, -18000, 156},
  {562143600, -21600, 156},
  {576057600, -18000, 156},
  {594198000, -21600, 156},
  {607507200, -18000, 156},
  {625647600, -21600, 156},
  {638956800, -18000, 156},
  {657097200, -21600, 156},
  {671011200, -18000, 156},
  {688546800, -21600, 156},
  {702460800, -18000, 156},
  {719996400, -21600, 156},
  {733910400, -18000, 156},
  {752050800, -21600, 156},
  {765360000, -18000, 156},
  {783500400, -21600, 156},
  {796809600, -18000, 156},
  {814950000, -21600, 156},
  {828864000, -18000, 156},
  {846399600, -21600, 156},
  {860313600, -18000, 156},
  {877849200, -21600, 156},
  {891763200, -18000, 156},
  {909298800, -21600, 156},
  {923212800, -18000, 156},
  {941353200, -21600, 156},
  {954662400, -18000, 156},
  {972802800, -21600, 156},
  {986112000, -18000, 156},
  {1004252400, -21600, 156},
  {1018166400, -18000, 156},
  {1035702000, -21600, 156},
  {1049616000, -18000, 156},
  {1067151600, -21600, 156},
  {1081065600, -18000, 156},
  {1099206000, -21600, 156},
  {1112515200, -18000, 156},
  {1130655600, -21600, 156},
  {1143964800, -18000, 156},
  {1162105200, -21600, 156},
  {1173600000, -18000, 156},
  {1194159600, -21600, 156},
  {1205049600, -18000, 156},
  {1225609200, -21600, 156},
  {1236499200, -18000, 156},
  {1257058800, -21600, 156},
  {1268553600, -18000, 156},
  {1289113200, -21600, 156},
  {1300003200, -18000, 156},
  {1320562800, -21600, 156},
  {1331452800, -18000, 156},
  {1352012400, -21600, 156},
  {1362902400, -18000, 156},
  {1383462000, -21600, 156},
  {1394352000, -18000, 156},
  {1414911600, -21600, 156},
  {1425801600, -18000, 156},
  {1446361200, -21600, 156},
  {1457856000, -18000, 156},
  {1478415600, -21600, 156},
  {1489305600, -18000, 156},
  {1509865200, -21600, 156},
  {1520755200, -18000, 156},
  {1541314800, -21600, 156},
  {1552204800, -18000, 156},
  {1572764400, -21600, 156},
  {1583654400, -18000, 156},
  {1604214000, -21600, 156},
  {1615708800, -18000, 156},
  {1636268400, -21600, 156},
  {1647158400, -18000, 156},
  {1667718000, -21600, 156},
  {1678608000, -18000, 156},
  {1699167600, -21600, 156},
  {1710057600, -18000, 156},
  {1730617200, -21600, 156},
  {1741507200, -18000, 156},
  {1762066800, -21600, 156},
  {1772956800, -18000, 156},
  {1793516400, -21600, 156},
  {1805011200, -18000, 156},
  {1825570800, -21600, 156},
  {1836460800, -18000, 156},
  {1857020400, -21600, 156},
  {1867910400, -18000, 156},
  {1888470000, -21600, 156},
  {1899360000, -18000, 156},
  {1919919600, -21600, 156},
  {1930809600, -18000, 156},
  {1951369200, -21600, 156},
  {1962864000, -18000, 156},
  {1983423600, -21600, 156},
  {1994313600, -18000, 156},
  {2014873200, -21600, 156},
  {2025763200, -18000, 156},
  {2046322800, -21600, 156},
  {2057212800, -18000, 156},
  {2077772400, -21600, 156},
  {2088662400, -18000, 156},
  {2109222000, -21600, 156},
  {2120112000, -18000, 156},
  {2140671600, -21600, 156},
  {INT64_MIN, -21508, 157},
  {-1514743200, -21600, 157},
  {377935200, -18000, 157},
  {407653200, -21600, 157},
  {828864000, -18000, 157},
  {846399600, -21600, 157},
  {860313600, -18000, 157},
  {877849200, -21600, 157},
  {891763200, -18000, 157},
  {909298800, -21600, 157},
  {923212800, -18000, 157},
  {941353200, -21600, 157},
  {954662400, -18000, 157},
  {972802800, -21600, 157},
  {989136000, -18000, 157},
  {1001833200, -21600, 157},
  {1018166400, -18000, 157},
  {1035702000, -21600, 157},
  {1049616000, -18000, 157},
  {1067151600, -21600, 157},
  {1081065600, -18000, 157},
  {1099206000, -21600, 157},
  {1112515200, -18000, 157},
  {1130655600, -21600, 157},
  {1143964800, -18000, 157},
  {1162105200, -21600, 157},
  {1175414400, -18000, 157},
  {1193554800, -21600, 157},
  {1207468800, -18000, 157},
  {1225004400, -21600, 157},
  {1238918400, -18000, 157},
  {1256454000, -21600, 157},
  {1270368000, -18000, 157},
  {1288508400, -21600, 157},
  {1301817600, -18000, 157},
  {1319958000, -21600, 157},
  {1333267200, -18000, 157},
  {1351407600, -21600, 157},
  {1365321600, -18000, 157},
  {1382857200, -21600, 157},
  {1396771200, -18000, 157},
  {1414306800, -21600, 157},
  {1428220800, -18000, 157},
  {1445756400, -21600, 157},
  {1459670400, -18000, 157},
  {1477810800, -21600, 157},
  {1491120000, -18000, 157},
  {1509260400, -21600, 157},
  {1522569600, -18000, 157},
  {1540710000, -21600, 157},
  {1554624000, -18000, 157},
  {1572159600, -21600, 157},
  {1586073600, -18000, 157},
  {1603609200, -21600, 157},
  {1617523200, -18000, 157},
  {1635663600, -21600, 157},
  {1648972800, -18000, 157},
  {1667113200, -21600, 157},
  {1680422400, -18000, 157},
  {1698562800, -21600, 157},
  {1712476800, -18000, 157},
  {1730012400, -21600, 157},
  {1743926400, -18000, 157},
  {1761462000, -21600, 157},
  {1775376000, -18000, 157},
  {1792911600, -21600, 157},
  {1806825600, -18000, 157},
  {1824966000, -21600, 157},
  {1838275200, -18000, 157},
  {1856415600, -21600, 157},
  {1869724800, -18000, 157},
  {1887865200, -21600, 157},
  {1901779200, -18000, 157},
  {1919314800, -21600, 157},
  {1933228800, -18000, 157},
  {1950764400, -21600, 157},
  {1964678400, -18000, 157},
  {1982818800, -21600, 157},
  {1996128000, -18000, 157},
  {2014268400, -21600, 157},
  {2027577600, -18000, 157},
  {2045718000, -21600, 157},
  {2059027200, -18000, 157},
  {2077167600, -21600, 157},
  {2091081600, -18000, 157},
  {2108617200, -21600, 157},
  {2122531200, -18000, 157},
  {2140066800, -21600, 157},
  {-880207200, -25200, 158},
  {-769395600, -25200, 158},
  {-765385200, -28800, 158},
  {-21477600, -25200, 158},
  {-5756400, -28800, 158},
  {9972000, -25200, 158},
  {25693200, -28800, 158},
  {41421600, -25200, 158},
  {57747600, -28800, 158},
  {73476000, -25200, 158},
  {89197200, -28800, 158},
  {104925600, -25200, 158},
  {120646800, -28800, 158},
  {126698400, -25200, 158},
  {152096400, -28800, 158},
  {162381600, -25200, 158},
  {183546000, -28800, 158},
  {199274400, -25200, 158},
  {215600400, -28800, 158},
  {230724000, -25200, 158},
  {247050000, -28800, 158},
  {262778400, -25200, 158},
  {278499600, -28800, 158},
  {294228000, -25200, 158},
  {309949200, -28800, 158},
  {325677600, -25200, 158},
  {341398800, -28800, 158},
  {357127200, -25200, 158},
  {372848400, -28800, 158},
  {388576800, -25200, 158},
  {404902800, -28800, 158},
  {420026400, -25200, 158},
  {436352400, -28800, 158},
  {INT64_MIN, -23796, 159},
  {-1514739600, -25200, 159},
  {-1343066400, -21600, 159},
  {-1234807200, -25200, 159},
  {-1220292000, -21600, 159},
  {-1207159200, -25200, 159},
  {-1191344400, -21600, 159},
  {-975261600, -18000, 159},
  {-963169200, -21600, 159},
  {-917114400, -18000, 159},
  {-907354800, -21600, 159},
  {-821901600, -18000, 159},
  {-810068400, -21600, 159},
  {-627501600, -18000, 159},
  {-612990000, -21600, 159},
  {828864000, -18000, 159},
  {846399600, -21600, 159},
  {860313600, -18000, 159},
  {877849200, -21600, 159},
  {891763200, -18000, 159},
  {909298800, -21600, 159},
  {923212800, -18000, 159},
  {941353200, -21600, 159},
  {954662400, -18000, 159},
  {972802800, -21600, 159},
  {989136000, -18000, 159},
  {1001833200, -21600, 159},
  {1018166400, -18000, 159},
  {1035702000, -21600, 159},
  {1049616000, -18000, 159},
  {1067151600, -21600, 159},
  {1081065600, -18000, 159},
  {1099206000, -21600, 159},
  {1112515200, -18000, 159},
  {1130655600, -21600, 159},
  {1143964800, -18000, 159},
  {1162105200, -21600, 159},
  {1175414400, -18000, 159},
  {1193554800, -21600, 159},
  {1207468800, -18000, 159},
  {1225004400, -21600, 159},
  {1238918400, -18000, 159},
  {1256454000, -21600, 159},
  {1270368000, -18000, 159},
  {1288508400, -21600, 159},
  {1301817600, -18000, 159},
  {1319958000, -21600, 159},
  {1333267200, -18000, 159},
  {1351407600, -21600, 159},
  {1365321600, -18000, 159},
  {1382857200, -21600, 159},
  {1396771200, -18000, 159},
  {1414306800, -21600, 159},
  {1428220800, -18000, 159},
  {1445756400, -21600, 159},
  {1459670400, -18000, 159},
  {1477810800, -21600, 159},
  {1491120000, -18000, 159},
  {1509260400, -21600, 159},
  {1522569600, -18000, 159},
  {1540710000, -21600, 159},
  {1554624000, -18000, 159},
  {1572159600, -21600, 159},
  {1586073600, -18000, 159},
  {1603609200, -21600, 159},
  {1617523200, -18000, 159},
  {1635663600, -21600, 159},
  {1648972800, -18000, 159},
  {1667113200, -21600, 159},
  {1680422400, -18000, 159},
  {1698562800, -21600, 159},
  {1712476800, -18000, 159},
  {1730012400, -21600, 159},
  {1743926400, -18000, 159},
  {1761462000, -21600, 159},
  {1775376000, -18000, 159},
  {1792911600, -21600, 159},
  {1806825600, -18000, 159},
  {1824966000, -21600, 159},
  {1838275200, -18000, 159},
  {1856415600, -21600, 159},
  {1869724800, -18000, 159},
  {1887865200, -21600, 159},
  {1901779200, -18000, 159},
  {1919314800, -21600, 159},
  {1933228800, -18000, 159},
  {1950764400, -21600, 159},
  {1964678400, -18000, 159},
  {1982818800, -21600, 159},
  {1996128000, -18000, 159},
  {2014268400, -21600, 159},
  {2027577600, -18000, 159},
  {2045718000, -21600, 159},
  {2059027200, -18000, 159},
  {2077167600, -21600, 159},
  {2091081600, -18000, 159},
  {2108617200, -21600, 159},
  {2122531200, -18000, 159},
  {2140066800, -21600, 159},
  {INT64_MIN, -13480, 160},
  {-1850328920, -14400, 160},
  {326001600, -10800, 160},
  {544597200, -7200, 160},
  {562132800, -10800, 160},
  {576046800, -7200, 160},
  {594187200, -10800, 160},
  {607496400, -7200, 160},
  {625636800, -10800, 160},
  {638946000, -7200, 160},
  {657086400, -10800, 160},
  {671000400, -7200, 160},
  {688536000, -10800, 160},
  {702450000, -7200, 160},
  {719985600, -10800, 160},
  {733899600, -7200, 160},
  {752040000, -10800, 160},
  {765349200, -7200, 160},
  {783489600, -10800, 160},
  {796798800, -7200, 160},
  {814939200, -10800, 160},
  {828853200, -7200, 160},
  {846388800, -10800, 160},
  {860302800, -7200, 160},
  {877838400, -10800, 160},
  {891752400, -7200, 160},
  {909288000, -10800, 160},
  {923202000, -7200, 160},
  {941342400, -10800, 160},
  {954651600, -7200, 160},
  {972792000, -10800, 160},
  {986101200, -7200, 160},
  {1004241600, -10800, 160},
  {1018155600, -7200, 160},
  {1035691200, -10800, 160},
  {1049605200, -7200, 160},
  {1067140800, -10800, 160},
  {1081054800, -7200, 160},
  {1099195200, -10800, 160},
  {1112504400, -7200, 160},
  {1130644800, -10800, 160},
  {1143954000, -7200, 160},
  {1162094400, -10800, 160},
  {1173589200, -7200, 160},
  {1194148800, -10800, 160},
  {1205038800, -7200, 160},
  {1225598400, -10800, 160},
  {1236488400, -7200, 160},
  {1257048000, -10800, 160},
  {1268542800, -7200, 160},
  {1289102400, -10800, 160},
  {1299992400, -7200, 160},
  {1320552000, -10800, 160},
  {1331442000, -7200, 160},
  {1352001600, -10800, 160},
  {1362891600, -7200, 160},
  {1383451200, -10800, 160},
  {1394341200, -7200, 160},
  {1414900800, -10800, 160},
  {1425790800, -7200, 160},
  {1446350400, -10800, 160},
  {1457845200, -7200, 160},
  {1478404800, -10800, 160},
  {1489294800, -7200, 160},
  {1509854400, -10800, 160},
  {1520744400, -7200, 160},
  {1541304000, -10800, 160},
  {1552194000, -7200, 160},
  {1572753600, -10800, 160},
  {1583643600, -7200, 160},
  {1604203200, -10800, 160},
  {1615698000, -7200, 160},
  {1636257600, -10800, 160},
  {1647147600, -7200, 160},
  {1667707200, -10800, 160},
  {1678597200, -7200, 160},
  {1699156800, -10800, 160},
  {1710046800, -7200, 160},
  {1730606400, -10800, 160},
  {1741496400, -7200, 160},
  {1762056000, -10800, 160},
  {1772946000, -7200, 160},
  {1793505600, -10800, 160},
  {1805000400, -7200, 160},
  {1825560000, -10800, 160},
  {1836450000, -7200, 160},
  {1857009600, -10800, 160},
  {1867899600, -7200, 160},
  {1888459200, -10800, 160},
  {1899349200, -7200, 160},
  {1919908800, -10800, 160},
  {1930798800, -7200, 160},
  {1951358400, -10800, 160},
  {1962853200, -7200, 160},
  {1983412800, -10800, 160},
  {1994302800, -7200, 160},
  {2014862400, -10800, 160},
  {2025752400, -7200, 160},
  {2046312000, -10800, 160},
  {2057202000, -7200, 160},
  {2077761600, -10800, 160},
  {2088651600, -7200, 160},
  {2109211200, -10800, 160},
  {2120101200, -7200, 160},
  {2140660800, -10800, 160},
  {INT64_MIN, -18000, 161},
  {-2131642800, -14400, 161},
  {-1632074400, -10800, 161},
  {-1614798000, -14400, 161},
  {-1153681200, -10800, 161},
  {-1145822400, -14400, 161},
  {-1122231600, -10800, 161},
  {-1114372800, -14400, 161},
  {-1090782000, -10800, 161},
  {-1082923200, -14400, 161},
  {-1059332400, -10800, 161},
  {-1051473600, -14400, 161},
  {-1027882800, -10800, 161},
  {-1020024000, -14400, 161},
  {-996433200, -10800, 161},
  {-988574400, -14400, 161},
  {-965674800, -10800, 161},
  {-955396800, -14400, 161},
  {-934743600, -10800, 161},
  {-923947200, -14400, 161},
  {-904503600, -10800, 161},
  {-891892800, -14400, 161},
  {-880221600, -10800, 161},
  {-769395600, -10800, 161},
  {-765399600, -14400, 161},
  {-747252000, -10800, 161},
  {-733950000, -14400, 161},
  {-715802400, -10800, 161},
  {-702500400, -14400, 161},
  {-684352800, -10800, 161},
  {-671050800, -14400, 161},
  {-652903200, -10800, 161},
  {-639601200, -14400, 161},
  {-620848800, -10800, 161},
  {-608151600, -14400, 161},
  {-589399200, -10800, 161},
  {-576097200, -14400, 161},
  {-557949600, -10800, 161},
  {-544647600, -14400, 161},
  {-526500000, -10800, 161},
  {-513198000, -14400, 161},
  {-495050400, -10800, 161},
  {-481748400, -14400, 161},
  {-463600800, -10800, 161},
  {-450298800, -14400, 161},
  {-431546400, -10800, 161},
  {-418244400, -14400, 161},
  {-400096800, -10800, 161},
  {-384375600, -14400, 161},
  {-368647200, -10800, 161},
  {-352926000, -14400, 161},
  {-337197600, -10800, 161},
  {-321476400, -14400, 161},
  {-305748000, -10800, 161},
  {-289422000, -14400, 161},
  {-273693600, -10800, 161},
  {-257972400, -14400, 161},
  {-242244000, -10800, 161},
  {-226522800, -14400, 161},
  {-210794400, -10800, 161},
  {-195073200, -14400, 161},
  {-179344800, -10800, 161},
  {-163623600, -14400, 161},
  {-147895200, -10800, 161},
  {-131569200, -14400, 161},
  {-116445600, -10800, 161},
  {-100119600, -14400, 161},
  {-84391200, -10800, 161},
  {-68670000, -14400, 161},
  {-52941600, -10800, 161},
  {-37220400, -14400, 161},
  {-21492000, -10800, 161},
  {-5770800, -14400, 161},
  {9957600, -10800, 161},
  {25678800, -14400, 161},
  {41407200, -10800, 161},
  {57733200, -14400, 161},
  {73461600, -10800, 161},
  {89182800, -14400, 161},
  {136360800, -10800, 161},
  {152082000, -14400, 161},
  {167810400, -10800, 161},
  {183531600, -14400, 161},
  {199260000, -10800, 161},
  {215586000, -14400, 161},
  {230709600, -10800, 161},
  {247035600, -14400, 161},
  {262764000, -10800, 161},
  {278485200, -14400, 161},
  {294213600, -10800, 161},
  {309934800, -14400, 161},
  {325663200, -10800, 161},
  {341384400, -14400, 161},
  {357112800, -10800, 161},
  {372834000, -14400, 161},
  {388562400, -10800, 161},
  {404888400, -14400, 161},
  {420012000, -10800, 161},
  {436338000, -14400, 161},
  {452066400, -10800, 161},
  {467787600, -14400, 161},
  {483516000, -10800, 161},
  {499237200, -14400, 161},
  {514965600, -10800, 161},
  {530686800, -14400, 161},
  {544600800, -10800, 161},
  {562136400, -14400, 161},
  {576050400, -10800, 161},
  {594190800, -14400, 161},
  {607500000, -10800, 161},
  {625640400, -14400, 161},
  {638949600, -10800, 161},
  {657090000, -14400, 161},
  {671004000, -10800, 161},
  {688539600, -14400, 161},
  {702453600, -10800, 161},
  {719989200, -14400, 161},
  {733896060, -10800, 161},
  {752036460, -14400, 161},
  {765345660, -10800, 161},
  {783486060, -14400, 161},
  {796795260, -10800, 161},
  {814935660, -14400, 161},
  {828849660, -10800, 161},
  {846385260, -14400, 161},
  {860299260, -10800, 161},
  {877834860, -14400, 161},
  {891748860, -10800, 161},
  {909284460, -14400, 161},
  {923198460, -10800, 161},
  {941338860, -14400, 161},
  {954648060, -10800, 161},
  {972788460, -14400, 161},
  {986097660, -10800, 161},
  {1004238060, -14400, 161},
  {1018152060, -10800, 161},
  {1035687660, -14400, 161},
  {1049601660, -10800, 161},
  {1067137260, -14400, 161},
  {1081051260, -10800, 161},
  {1099191660, -14400, 161},
  {1112500860, -10800, 161},
  {1130641260, -14400, 161},
  {1143950460, -10800, 161},
  {1162090860, -14400, 161},
  {1173592800, -10800, 161},
  {1194152400, -14400, 161},
  {1205042400, -10800, 161},
  {1225602000, -14400, 161},
  {1236492000, -10800, 161},
  {1257051600, -14400, 161},
  {1268546400, -10800, 161},
  {1289106000, -14400, 161},
  {1299996000, -10800, 161},
  {1320555600, -14400, 161},
  {1331445600, -10800, 161},
  {1352005200, -14400, 161},
  {1362895200, -10800, 161},
  {1383454800, -14400, 161},
  {1394344800, -10800, 161},
  {1414904400, -14400, 161},
  {1425794400, -10800, 161},
  {1446354000, -14400, 161},
  {1457848800, -10800, 161},
  {1478408400, -14400, 161},
  {1489298400, -10800, 161},
  {1509858000, -14400, 161},
  {1520748000, -10800, 161},
  {1541307600, -14400, 161},
  {1552197600, -10800, 161},
  {1572757200, -14400, 161},
  {1583647200, -10800, 161},
  {1604206800, -14400, 161},
  {1615701600, -10800, 161},
  {1636261200, -14400, 161},
  {1647151200, -10800, 161},
  {1667710800, -14400, 161},
  {1678600800, -10800, 161},
  {1699160400, -14400, 161},
  {1710050400, -10800, 161},
  {1730610000, -14400, 161},
  {1741500000, -10800, 161},
  {1762059600, -14400, 161},
  {1772949600, -10800, 161},
  {1793509200, -14400, 161},
  {1805004000, -10800, 161},
  {1825563600, -14400, 161},
  {1836453600, -10800, 161},
  {1857013200, -14400, 161},
  {1867903200, -10800, 161},
  {1888462800, -14400, 161},
  {1899352800, -10800, 161},
  {1919912400, -14400, 161},
  {1930802400, -10800, 161},
  {1951362000, -14400, 161},
  {1962856800, -10800, 161},
  {1983416400, -14400, 161},
  {1994306400, -10800, 161},
  {2014866000, -14400, 161},
  {2025756000, -10800, 161},
  {2046315600, -14400, 161},
  {2057205600, -10800, 161},
  {2077765200, -14400, 161},
  {2088655200, -10800, 161},
  {2109214800, -14400, 161},
  {2120104800, -10800, 161},
  {2140664400, -14400, 161},
  {INT64_MIN, -24076, 162},
  {-1514743200, -21600, 162},
  {576057600, -18000, 162},
  {594198000, -21600, 162},
  {828864000, -18000, 162},
  {846399600, -21600, 162},
  {860313600, -18000, 162},
  {877849200, -21600, 162},
  {891763200, -18000, 162},
  {909298800, -21600, 162},
  {923212800, -18000, 162},
  {941353200, -21600, 162},
  {954662400, -18000, 162},
  {972802800, -21600, 162},
  {989136000, -18000, 162},
  {1001833200, -21600, 162},
  {1018166400, -18000, 162},
  {1035702000, -21600, 162},
  {1049616000, -18000, 162},
  {1067151600, -21600, 162},
  {1081065600, -18000, 162},
  {1099206000, -21600, 162},
  {1112515200, -18000, 162},
  {1130655600, -21600, 162},
  {1143964800, -18000, 162},
  {1162105200, -21600, 162},
  {1175414400, -18000, 162},
  {1193554800, -21600, 162},
  {1207468800, -18000, 162},
  {1225004400, -21600, 162},
  {1238918400, -18000, 162},
  {1256454000, -21600, 162},
  {1270368000, -18000, 162},
  {1288508400, -21600, 162},
  {1301817600, -18000, 162},
  {1319958000, -21600, 162},
  {1333267200, -18000, 162},
  {1351407600, -21600, 162},
  {1365321600, -18000, 162},
  {1382857200, -21600, 162},
  {1396771200, -18000, 162},
  {1414306800, -21600, 162},
  {1428220800, -18000, 162},
  {1445756400, -21600, 162},
  {1459670400, -18000, 162},
  {1477810800, -21600, 162},
  {1491120000, -18000, 162},
  {1509260400, -21600, 162},
  {1522569600, -18000, 162},
  {1540710000, -21600, 162},
  {1554624000, -18000, 162},
  {1572159600, -21600, 162},
  {1586073600, -18000, 162},
  {1603609200, -21600, 162},
  {1617523200, -18000, 162},
  {1635663600, -21600, 162},
  {1648972800, -18000, 162},
  {1667113200, -21600, 162},
  {1680422400, -18000, 162},
  {1698562800, -21600, 162},
  {1712476800, -18000, 162},
  {1730012400, -21600, 162},
  {1743926400, -18000, 162},
  {1761462000, -21600, 162},
  {1775376000, -18000, 162},
  {1792911600, -21600, 162},
  {1806825600, -18000, 162},
  {1824966000, -21600, 162},
  {1838275200, -18000, 162},
  {1856415600, -21600, 162},
  {1869724800, -18000, 162},
  {1887865200, -21600, 162},
  {1901779200, -18000, 162},
  {1919314800, -21600, 162},
  {1933228800, -18000, 162},
  {1950764400, -21600, 162},
  {1964678400, -18000, 162},
  {1982818800, -21600, 162},
  {1996128000, -18000, 162},
  {2014268400, -21600, 162},
  {2027577600, -18000, 162},
  {2045718000, -21600, 162},
  {2059027200, -18000, 162},
  {2077167600, -21600, 162},
  {2091081600, -18000, 162},
  {2108617200, -21600, 162},
  {2122531200, -18000, 162},
  {2140066800, -21600, 162},
  {INT64_MIN, -13484, 163},
  {-1567455316, -12600, 163},
  {-1459542600, -10800, 163},
  {-1443819600, -12600, 163},
  {-1428006600, -10800, 163},
  {-1412283600, -12600, 163},
  {-1396470600, -10800, 163},
  {-1380747600, -12600, 163},
  {-1141590600, -10800, 163},
  {-1128286800, -12600, 163},
  {-1110141000, -10800, 163},
  {-1096837200, -12600, 163},
  {-1078691400, -10800, 163},
  {-1065387600, -12600, 163},
  {-1046637000, -10800, 163},
  {-1033938000, -12600, 163},
  {-1015187400, -10800, 163},
  {-1002488400, -12600, 163},
  {-983737800, -10800, 163},
  {-971038800, -12600, 163},
  {-952288200, -10800, 163},
  {-938984400, -12600, 163},
  {-920838600, -10800, 163},
  {-907534800, -12600, 163},
  {-896819400, -10800, 163},
  {-883602000, -12600, 163},
  {-853619400, -7200, 163},
  {-845848800, -10800, 163},
  {-334789200, -7200, 163},
  {-319672800, -10800, 163},
  {-314226000, -7200, 163},
  {-309996000, -10800, 163},
  {-149720400, -7200, 163},
  {-134604000, -10800, 163},
  {-118270800, -7200, 163},
  {-100044000, -10800, 163},
  {-86821200, -7200, 163},
  {-68508000, -10800, 163},
  {-50446800, -9000, 163},
  {-34119000, -10800, 163},
  {-18910800, -9000, 163},
  {-2583000, -10800, 163},
  {12625200, -9000, 163},
  {28953000, -10800, 163},
  {72932400, -7200, 163},
  {82692000, -10800, 163},
  {132116400, -9000, 163},
  {156911400, -7200, 163},
  {212983200, -10800, 163},
  {250052400, -7200, 163},
  {260244000, -10800, 163},
  {307594800, -7200, 163},
  {325994400, -10800, 163},
  {566449200, -7200, 163},
  {574308000, -10800, 163},
  {597812400, -7200, 163},
  {605671200, -10800, 163},
  {625633200, -7200, 163},
  {636516000, -10800, 163},
  {656478000, -7200, 163},
  {667965600, -10800, 163},
  {688532400, -7200, 163},
  {699415200, -10800, 163},
  {719377200, -7200, 163},
  {730864800, -10800, 163},
  {1095562800, -7200, 163},
  {1111896000, -10800, 163},
  {1128834000, -7200, 163},
  {1142136000, -10800, 163},
  {1159678800, -7200, 163},
  {1173585600, -10800, 163},
  {1191733200, -7200, 163},
  {1205035200, -10800, 163},
  {1223182800, -7200, 163},
  {1236484800, -10800, 163},
  {1254632400, -7200, 163},
  {1268539200, -10800, 163},
  {1286082000, -7200, 163},
  {1299988800, -10800, 163},
  {1317531600, -7200, 163},
  {1331438400, -10800, 163},
  {1349586000, -7200, 163},
  {1362888000, -10800, 163},
  {1381035600, -7200, 163},
  {1394337600, -10800, 163},
  {1412485200, -7200, 163},
  {1425787200, -10800, 163},
  {1443934800, -7200, 163},
  {1457841600, -10800, 163},
  {1475384400, -7200, 163},
  {1489291200, -10800, 163},
  {1506834000, -7200, 163},
  {1520740800, -10800, 163},
  {1538888400, -7200, 163},
  {1552190400, -10800, 163},
  {1570338000, -7200, 163},
  {1583640000, -10800, 163},
  {1601787600, -7200, 163},
  {1615694400, -10800, 163},
  {1633237200, -7200, 163},
  {1647144000, -10800, 163},
  {1664686800, -7200, 163},
  {1678593600, -10800, 163},
  {1696136400, -7200, 163},
  {1710043200, -10800, 163},
  {1728190800, -7200, 163},
  {1741492800, -10800, 163},
  {1759640400, -7200, 163},
  {1772942400, -10800, 163},
  {1791090000, -7200, 163},
  {1804996800, -10800, 163},
  {1822539600, -7200, 163},
  {1836446400, -10800, 163},
  {1853989200, -7200, 163},
  {1867896000, -10800, 163},
  {1886043600, -7200, 163},
  {1899345600, -10800, 163},
  {1917493200, -7200, 163},
  {1930795200, -10800, 163},
  {1948942800, -7200, 163},
  {1962849600, -10800, 163},
  {1980392400, -7200, 163},
  {1994299200, -10800, 163},
  {2011842000, -7200, 163},
  {2025748800, -10800, 163},
  {2043291600, -7200, 163},
  {2057198400, -10800, 163},
  {2075346000, -7200, 163},
  {2088648000, -10800, 163},
  {2106795600, -7200, 163},
  {2120097600, -10800, 163},
  {2138245200, -7200, 163},
  {-1665334800, -14400, 164},
  {-1662753600, -18000, 164},
  {-1632070800, -14400, 164},
  {-1614794400, -18000, 164},
  {-1601742600, -14400, 164},
  {-1583775000, -18000, 164},
  {-1567355400, -14400, 164},
  {-1554053400, -18000, 164},
  {-1535907600, -14400, 164},
  {-1522603800, -18000, 164},
  {-1504458000, -14400, 164},
  {-1491154200, -18000, 164},
  {-1439830800, -14400, 164},
  {-1428255000, -18000, 164},
  {-1409504400, -14400, 164},
  {-1396805400, -18000, 164},
  {-1378054800, -14400, 164},
  {-1365355800, -18000, 164},
  {-1346612400, -14400, 164},
  {-1333915200, -18000, 164},
  {-1315162800, -14400, 164},
  {-1301860800, -18000, 164},
  {-1283713200, -14400, 164},
  {-1270411200, -18000, 164},
  {-1252263600, -14400, 164},
  {-1238961600, -18000, 164},
  {-1220814000, -14400, 164},
  {-1207512000, -18000, 164},
  {-1188759600, -14400, 164},
  {-1176062400, -18000, 164},
  {-1157310000, -14400, 164},
  {-1144008000, -18000, 164},
  {-1125860400, -14400, 164},
  {-1112558400, -18000, 164},
  {-1094410800, -14400, 164},
  {-1081108800, -18000, 164},
  {-1062961200, -14400, 164},
  {-1049659200, -18000, 164},
  {-1031511600, -14400, 164},
  {-1018209600, -18000, 164},
  {-1000062000, -14400, 164},
  {-986760000, -18000, 164},
  {-968007600, -14400, 164},
  {-955310400, -18000, 164},
  {-936558000, -14400, 164},
  {-880218000, -14400, 164},
  {-769395600, -14400, 164},
  {-765396000, -18000, 164},
  {-747248400, -14400, 164},
  {-733946400, -18000, 164},
  {-715798800, -14400, 164},
  {-702496800, -18000, 164},
  {-684349200, -14400, 164},
  {-671047200, -18000, 164},
  {-652899600, -14400, 164},
  {-636573600, -18000, 164},
  {-620845200, -14400, 164},
  {-605124000, -18000, 164},
  {-589395600, -14400, 164},
  {-576093600, -18000, 164},
  {-557946000, -14400, 164},
  {-544644000, -18000, 164},
  {-526496400, -14400, 164},
  {-513194400, -18000, 164},
  {-495046800, -14400, 164},
  {-481744800, -18000, 164},
  {-463597200, -14400, 164},
  {-450295200, -18000, 164},
  {-431542800, -14400, 164},
  {-418240800, -18000, 164},
  {-400093200, -14400, 164},
  {-384372000, -18000, 164},
  {-368643600, -14400, 164},
  {-352922400, -18000, 164},
  {-337194000, -14400, 164},
  {-321472800, -18000, 164},
  {-305744400, -14400, 164},
  {-289418400, -18000, 164},
  {-273690000, -14400, 164},
  {-257968800, -18000, 164},
  {-242240400, -14400, 164},
  {-226519200, -18000, 164},
  {-210790800, -14400, 164},
  {-195069600, -18000, 164},
  {-179341200, -14400, 164},
  {-163620000, -18000, 164},
  {-147891600, -14400, 164},
  {-131565600, -18000, 164},
  {-116442000, -14400, 164},
  {-100116000, -18000, 164},
  {-84387600, -14400, 164},
  {-68666400, -18000, 164},
  {-52938000, -14400, 164},
  {-37216800, -18000, 164},
  {-21488400, -14400, 164},
  {-5767200, -18000, 164},
  {9961200, -14400, 164},
  {25682400, -18000, 164},
  {41410800, -14400, 164},
  {57736800, -18000, 164},
  {73465200, -14400, 164},
  {89186400, -18000, 164},
  {104914800, -14400, 164},
  {120636000, -18000, 164},
  {136364400, -14400, 164},
  {152085600, -18000, 164},
  {167814000, -14400, 164},
  {183535200, -18000, 164},
  {199263600, -14400, 164},
  {215589600, -18000, 164},
  {230713200, -14400, 164},
  {247039200, -18000, 164},
  {262767600, -14400, 164},
  {278488800, -18000, 164},
  {294217200, -14400, 164},
  {309938400, -18000, 164},
  {325666800, -14400, 164},
  {341388000, -18000, 164},
  {357116400, -14400, 164},
  {372837600, -18000, 164},
  {388566000, -14400, 164},
  {404892000, -18000, 164},
  {420015600, -14400, 164},
  {436341600, -18000, 164},
  {452070000, -14400, 164},
  {467791200, -18000, 164},
  {483519600, -14400, 164},
  {499240800, -18000, 164},
  {514969200, -14400, 164},
  {530690400, -18000, 164},
  {544604400, -14400, 164},
  {562140000, -18000, 164},
  {576054000, -14400, 164},
  {594194400, -18000, 164},
  {607503600, -14400, 164},
  {625644000, -18000, 164},
  {638953200, -14400, 164},
  {657093600, -18000, 164},
  {671007600, -14400, 164},
  {688543200, -18000, 164},
  {702457200, -14400, 164},
  {719992800, -18000, 164},
  {733906800, -14400, 164},
  {752047200, -18000, 164},
  {765356400, -14400, 164},
  {783496800, -18000, 164},
  {796806000, -14400, 164},
  {814946400, -18000, 164},
  {828860400, -14400, 164},
  {846396000, -18000, 164},
  {860310000, -14400, 164},
  {877845600, -18000, 164},
  {891759600, -14400, 164},
  {909295200, -18000, 164},
  {923209200, -14400, 164},
  {941349600, -18000, 164},
  {954658800, -14400, 164},
  {972799200, -18000, 164},
  {986108400, -14400, 164},
  {1004248800, -18000, 164},
  {1018162800, -14400, 164},
  {1035698400, -18000, 164},
  {1049612400, -14400, 164},
  {1067148000, -18000, 164},
  {1081062000, -14400, 164},
  {1099202400, -18000, 164},
  {1112511600, -14400, 164},
  {1130652000, -18000, 164},
  {1143961200, -14400, 164},
  {1162101600, -18000, 164},
  {1173596400, -14400, 164},
  {1194156000, -18000, 164},
  {1205046000, -14400, 164},
  {1225605600, -18000, 164},
  {1236495600, -14400, 164},
  {1257055200, -18000, 164},
  {1268550000, -14400, 164},
  {1289109600, -18000, 164},
  {1299999600, -14400, 164},
  {1320559200, -18000, 164},
  {1331449200, -14400, 164},
  {1352008800, -18000, 164},
  {1362898800, -14400, 164},
  {1383458400, -18000, 164},
  {1394348400, -14400, 164},
  {1414908000, -18000, 164},
  {1425798000, -14400, 164},
  {1446357600, -18000, 164},
  {1457852400, -14400, 164},
  {1478412000, -18000, 164},
  {1489302000, -14400, 164},
  {1509861600, -18000, 164},
  {1520751600, -14400, 164},
  {1541311200, -18000, 164},
  {1552201200, -14400, 164},
  {1572760800, -18000, 164},
  {1583650800, -14400, 164},
  {1604210400, -18000, 164},
  {1615705200, -14400, 164},
  {1636264800, -18000, 164},
  {1647154800, -14400, 164},
  {1667714400, -18000, 164},
  {1678604400, -14400, 164},
  {1699164000, -18000, 164},
  {1710054000, -14400, 164},
  {1730613600, -18000, 164},
  {1741503600, -14400, 164},
  {1762063200, -18000, 164},
  {1772953200, -14400, 164},
  {1793512800, -18000, 164},
  {1805007600, -14400, 164},
  {1825567200, -18000, 164},
  {1836457200, -14400, 164},
  {1857016800, -18000, 164},
  {1867906800, -14400, 164},
  {1888466400, -18000, 164},
  {1899356400, -14400, 164},
  {1919916000, -18000, 164},
  {1930806000, -14400, 164},
  {1951365600, -18000, 164},
  {1962860400, -14400, 164},
  {1983420000, -18000, 164},
  {1994310000, -14400, 164},
  {2014869600, -18000, 164},
  {2025759600, -14400, 164},
  {2046319200, -18000, 164},
  {2057209200, -14400, 164},
  {2077768800, -18000, 164},
  {2088658800, -14400, 164},
  {2109218400, -18000, 164},
  {2120108400, -14400, 164},
  {2140668000, -18000, 164},
  {INT64_MIN, -14932, 165},
  {-1846266608, -14400, 165},
  {INT64_MIN, -18564, 166},
  {-1825095036, -18000, 166},
  {-179341200, -14400, 166},
  {-163620000, -18000, 166},
  {-147891600, -14400, 166},
  {-131565600, -18000, 166},
  {-116442000, -14400, 166},
  {-100116000, -18000, 166},
  {-84387600, -14400, 166},
  {-68666400, -18000, 166},
  {-52938000, -14400, 166},
  {-37216800, -18000, 166},
  {-21488400, -14400, 166},
  {-5767200, -18000, 166},
  {9961200, -14400, 166},
  {25682400, -18000, 166},
  {41410800, -14400, 166},
  {57736800, -18000, 166},
  {73465200, -14400, 166},
  {89186400, -18000, 166},
  {104914800, -14400, 166},
  {120636000, -18000, 166},
  {136364400, -14400, 166},
  {152085600, -18000, 166},
  {167814000, -14400, 166},
  {183535200, -18000, 166},
  {199263600, -14400, 166},
  {215589600, -18000, 166},
  {230713200, -14400, 166},
  {247039200, -18000, 166},
  {262767600, -14400, 166},
  {278488800, -18000, 166},
  {294217200, -14400, 166},
  {309938400, -18000, 166},
  {325666800, -14400, 166},
  {341388000, -18000, 166},
  {357116400, -14400, 166},
  {372837600, -18000, 166},
  {388566000, -14400, 166},
  {404892000, -18000, 166},
  {420015600, -14400, 166},
  {436341600, -18000, 166},
  {452070000, -14400, 166},
  {467791200, -18000, 166},
  {483519600, -14400, 166},
  {499240800, -18000, 166},
  {514969200, -14400, 166},
  {530690400, -18000, 166},
  {544604400, -14400, 166},
  {562140000, -18000, 166},
  {576054000, -14400, 166},
  {594194400, -18000, 166},
  {607503600, -14400, 166},
  {625644000, -18000, 166},
  {638953200, -14400, 166},
  {657093600, -18000, 166},
  {671007600, -14400, 166},
  {688543200, -18000, 166},
  {702457200, -14400, 166},
  {719992800, -18000, 166},
  {733906800, -14400, 166},
  {752047200, -18000, 166},
  {765356400, -14400, 166},
  {783496800, -18000, 166},
  {796806000, -14400, 166},
  {814946400, -18000, 166},
  {828860400, -14400, 166},
  {846396000, -18000, 166},
  {860310000, -14400, 166},
  {877845600, -18000, 166},
  {891759600, -14400, 166},
  {909295200, -18000, 166},
  {923209200, -14400, 166},
  {941349600, -18000, 166},
  {954658800, -14400, 166},
  {972799200, -18000, 166},
  {986108400, -14400, 166},
  {1004248800, -18000, 166},
  {1018162800, -14400, 166},
  {1035698400, -18000, 166},
  {1049612400, -14400, 166},
  {1067148000, -18000, 166},
  {1081062000, -14400, 166},
  {1099202400, -18000, 166},
  {1112511600, -14400, 166},
  {1130652000, -18000, 166},
  {1143961200, -14400, 166},
  {1162101600, -18000, 166},
  {1173596400, -14400, 166},
  {1194156000, -18000, 166},
  {1205046000, -14400, 166},
  {1225605600, -18000, 166},
  {1236495600, -14400, 166},
  {1257055200, -18000, 166},
  {1268550000, -14400, 166},
  {1289109600, -18000, 166},
  {1299999600, -14400, 166},
  {1320559200, -18000, 166},
  {1331449200, -14400, 166},
  {1352008800, -18000, 166},
  {1362898800, -14400, 166},
  {1383458400, -18000, 166},
  {1394348400, -14400, 166},
  {1414908000, -18000, 166},
  {1425798000, -14400, 166},
  {1446357600, -18000, 166},
  {1457852400, -14400, 166},
  {1478412000, -18000, 166},
  {1489302000, -14400, 166},
  {1509861600, -18000, 166},
  {1520751600, -14400, 166},
  {1541311200, -18000, 166},
  {1552201200, -14400, 166},
  {1572760800, -18000, 166},
  {1583650800, -14400, 166},
  {1604210400, -18000, 166},
  {1615705200, -14400, 166},
  {1636264800, -18000, 166},
  {1647154800, -14400, 166},
  {1667714400, -18000, 166},
  {1678604400, -14400, 166},
  {1699164000, -18000, 166},
  {1710054000, -14400, 166},
  {1730613600, -18000, 166},
  {1741503600, -14400, 166},
  {1762063200, -18000, 166},
  {1772953200, -14400, 166},
  {1793512800, -18000, 166},
  {1805007600, -14400, 166},
  {1825567200, -18000, 166},
  {1836457200, -14400, 166},
  {1857016800, -18000, 166},
  {1867906800, -14400, 166},
  {1888466400, -18000, 166},
  {1899356400, -14400, 166},
  {1919916000, -18000, 166},
  {1930806000, -14400, 166},
  {1951365600, -18000, 166},
  {1962860400, -14400, 166},
  {1983420000, -18000, 166},
  {1994310000, -14400, 166},
  {2014869600, -18000, 166},
  {2025759600, -14400, 166},
  {2046319200, -18000, 166},
  {2057209200, -14400, 166},
  {2077768800, -18000, 166},
  {2088658800, -14400, 166},
  {2109218400, -18000, 166},
  {2120108400, -14400, 166},
  {2140668000, -18000, 166},
  {-1633280400, -14400, 167},
  {-1615140000, -18000, 167},
  {-1601830800, -14400, 167},
  {-1583690400, -18000, 167},
  {-1570381200, -14400, 167},
  {-1551636000, -18000, 167},
  {-1536512400, -14400, 167},
  {-1523210400, -18000, 167},
  {-1504458000, -14400, 167},
  {-1491760800, -18000, 167},
  {-1473008400, -14400, 167},
  {-1459706400, -18000, 167},
  {-1441558800, -14400, 167},
  {-1428256800, -18000, 167},
  {-1410109200, -14400, 167},
  {-1396807200, -18000, 167},
  {-1378659600, -14400, 167},
  {-1365357600, -18000, 167},
  {-1347210000, -14400, 167},
  {-1333908000, -18000, 167},
  {-1315155600, -14400, 167},
  {-1301853600, -18000, 167},
  {-1283706000, -14400, 167},
  {-1270404000, -18000, 167},
  {-1252256400, -14400, 167},
  {-1238954400, -18000, 167},
  {-1220806800, -14400, 167},
  {-1207504800, -18000, 167},
  {-1189357200, -14400, 167},
  {-1176055200, -18000, 167},
  {-1157302800, -14400, 167},
  {-1144605600, -18000, 167},
  {-1125853200, -14400, 167},
  {-1112551200, -18000, 167},
  {-1094403600, -14400, 167},
  {-1081101600, -18000, 167},
  {-1062954000, -14400, 167},
  {-1049652000, -18000, 167},
  {-1031504400, -14400, 167},
  {-1018202400, -18000, 167},
  {-1000054800, -14400, 167},
  {-986752800, -18000, 167},
  {-968000400, -14400, 167},
  {-955303200, -18000, 167},
  {-936550800, -14400, 167},
  {-923248800, -18000, 167},
  {-905101200, -14400, 167},
  {-891799200, -18000, 167},
  {-880218000, -14400, 167},
  {-769395600, -14400, 167},
  {-765396000, -18000, 167},
  {-747248400, -14400, 167},
  {-733946400, -18000, 167},
  {-715798800, -14400, 167},
  {-702496800, -18000, 167},
  {-684349200, -14400, 167},
  {-671047200, -18000, 167},
  {-652899600, -14400, 167},
  {-639597600, -18000, 167},
  {-620845200, -14400, 167},
  {-608148000, -18000, 167},
  {-589395600, -14400, 167},
  {-576093600, -18000, 167},
  {-557946000, -14400, 167},
  {-544644000, -18000, 167},
  {-526496400, -14400, 167},
  {-513194400, -18000, 167},
  {-495046800, -14400, 167},
  {-481744800, -18000, 167},
  {-463597200, -14400, 167},
  {-447271200, -18000, 167},
  {-431542800, -14400, 167},
  {-415821600, -18000, 167},
  {-400093200, -14400, 167},
  {-384372000, -18000, 167},
  {-368643600, -14400, 167},
  {-352922400, -18000, 167},
  {-337194000, -14400, 167},
  {-321472800, -18000, 167},
  {-305744400, -14400, 167},
  {-289418400, -18000, 167},
  {-273690000, -14400, 167},
  {-257968800, -18000, 167},
  {-242240400, -14400, 167},
  {-226519200, -18000, 167},
  {-210790800, -14400, 167},
  {-195069600, -18000, 167},
  {-179341200, -14400, 167},
  {-163620000, -18000, 167},
  {-147891600, -14400, 167},
  {-131565600, -18000, 167},
  {-116442000, -14400, 167},
  {-100116000, -18000, 167},
  {-84387600, -14400, 167},
  {-68666400, -18000, 167},
  {-52938000, -14400, 167},
  {-37216800, -18000, 167},
  {-21488400, -14400, 167},
  {-5767200, -18000, 167},
  {9961200, -14400, 167},
  {25682400, -18000, 167},
  {41410800, -14400, 167},
  {57736800, -18000, 167},
  {73465200, -14400, 167},
  {89186400, -18000, 167},
  {104914800, -14400, 167},
  {120636000, -18000, 167},
  {126687600, -14400, 167},
  {152085600, -18000, 167},
  {162370800, -14400, 167},
  {183535200, -18000, 167},
  {199263600, -14400, 167},
  {215589600, -18000, 167},
  {230713200, -14400, 167},
  {247039200, -18000, 167},
  {262767600, -14400, 167},
  {278488800, -18000, 167},
  {294217200, -14400, 167},
  {309938400, -18000, 167},
  {325666800, -14400, 167},
  {341388000, -18000, 167},
  {357116400, -14400, 167},
  {372837600, -18000, 167},
  {388566000, -14400, 167},
  {404892000, -18000, 167},
  {420015600, -14400, 167},
  {436341600, -18000, 167},
  {452070000, -14400, 167},
  {467791200, -18000, 167},
  {483519600, -14400, 167},
  {499240800, -18000, 167},
  {514969200, -14400, 167},
  {530690400, -18000, 167},
  {544604400, -14400, 167},
  {562140000, -18000, 167},
  {576054000, -14400, 167},
  {594194400, -18000, 167},
  {607503600, -14400, 167},
  {625644000, -18000, 167},
  {638953200, -14400, 167},
  {657093600, -18000, 167},
  {671007600, -14400, 167},
  {688543200, -18000, 167},
  {702457200, -14400, 167},
  {719992800, -18000, 167},
  {733906800, -14400, 167},
  {752047200, -18000, 167},
  {765356400, -14400, 167},
  {783496800, -18000, 167},
  {796806000, -14400, 167},
  {814946400, -18000, 167},
  {828860400, -14400, 167},
  {846396000, -18000, 167},
  {860310000, -14400, 167},
  {877845600, -18000, 167},
  {891759600, -14400, 167},
  {909295200, -18000, 167},
  {923209200, -14400, 167},
  {941349600, -18000, 167},
  {954658800, -14400, 167},
  {972799200, -18000, 167},
  {986108400, -14400, 167},
  {1004248800, -18000, 167},
  {1018162800, -14400, 167},
  {1035698400, -18000, 167},
  {1049612400, -14400, 167},
  {1067148000, -18000, 167},
  {1081062000, -14400, 167},
  {1099202400, -18000, 167},
  {1112511600, -14400, 167},
  {1130652000, -18000, 167},
  {1143961200, -14400, 167},
  {1162101600, -18000, 167},
  {1173596400, -14400, 167},
  {1194156000, -18000, 167},
  {1205046000, -14400, 167},
  {1225605600, -18000, 167},
  {1236495600, -14400, 167},
  {1257055200, -18000, 167},
  {1268550000, -14400, 167},
  {1289109600, -18000, 167},
  {1299999600, -14400, 167},
  {1320559200, -18000, 167},
  {1331449200, -14400, 167},
  {1352008800, -18000, 167},
  {1362898800, -14400, 167},
  {1383458400, -18000, 167},
  {1394348400, -14400, 167},
  {1414908000, -18000, 167},
  {1425798000, -14400, 167},
  {1446357600, -18000, 167},
  {1457852400, -14400, 167},
  {1478412000, -18000, 167},
  {1489302000, -14400, 167},
  {1509861600, -18000, 167},
  {1520751600, -14400, 167},
  {1541311200, -18000, 167},
  {1552201200, -14400, 167},
  {1572760800, -18000, 167},
  {1583650800, -14400, 167},
  {1604210400, -18000, 167},
  {1615705200, -14400, 167},
  {1636264800, -18000, 167},
  {1647154800, -14400, 167},
  {1667714400, -18000, 167},
  {1678604400, -14400, 167},
  {1699164000, -18000, 167},
  {1710054000, -14400, 167},
  {1730613600, -18000, 167},
  {1741503600, -14400, 167},
  {1762063200, -18000, 167},
  {1772953200, -14400, 167},
  {1793512800, -18000, 167},
  {1805007600, -14400, 167},
  {1825567200, -18000, 167},
  {1836457200, -14400, 167},
  {1857016800, -18000, 167},
  {1867906800, -14400, 167},
  {1888466400, -18000, 167},
  {1899356400, -14400, 167},
  {1919916000, -18000, 167},
  {1930806000, -14400, 167},
  {1951365600, -18000, 167},
  {1962860400, -14400, 167},
  {1983420000, -18000, 167},
  {1994310000, -14400, 167},
  {2014869600, -18000, 167},
  {2025759600, -14400, 167},
  {2046319200, -18000, 167},
  {2057209200, -14400, 167},
  {2077768800, -18000, 167},
  {2088658800, -14400, 167},
  {2109218400, -18000, 167},
  {2120108400, -14400, 167},
  {2140668000, -18000, 167},
  {-1632070800, -14400, 168},
  {-1614794400, -18000, 168},
  {-923252400, -14400, 168},
  {-880218000, -14400, 168},
  {-769395600, -14400, 168},
  {-765396000, -18000, 168},
  {136364400, -14400, 168},
  {152085600, -18000, 168},
  {167814000, -14400, 168},
  {183535200, -18000, 168},
  {199263600, -14400, 168},
  {215589600, -18000, 168},
  {230713200, -14400, 168},
  {247039200, -18000, 168},
  {262767600, -14400, 168},
  {278488800, -18000, 168},
  {294217200, -14400, 168},
  {309938400, -18000, 168},
  {325666800, -14400, 168},
  {341388000, -18000, 168},
  {357116400, -14400, 168},
  {372837600, -18000, 168},
  {388566000, -14400, 168},
  {404892000, -18000, 168},
  {420015600, -14400, 168},
  {436341600, -18000, 168},
  {452070000, -14400, 168},
  {467791200, -18000, 168},
  {483519600, -14400, 168},
  {499240800, -18000, 168},
  {514969200, -14400, 168},
  {530690400, -18000, 168},
  {544604400, -14400, 168},
  {562140000, -18000, 168},
  {576054000, -14400, 168},
  {594194400, -18000, 168},
  {607503600, -14400, 168},
  {625644000, -18000, 168},
  {638953200, -14400, 168},
  {657093600, -18000, 168},
  {671007600, -14400, 168},
  {688543200, -18000, 168},
  {702457200, -14400, 168},
  {719992800, -18000, 168},
  {733906800, -14400, 168},
  {752047200, -18000, 168},
  {765356400, -14400, 168},
  {783496800, -18000, 168},
  {796806000, -14400, 168},
  {814946400, -18000, 168},
  {828860400, -14400, 168},
  {846396000, -18000, 168},
  {860310000, -14400, 168},
  {877845600, -18000, 168},
  {891759600, -14400, 168},
  {909295200, -18000, 168},
  {923209200, -14400, 168},
  {941349600, -18000, 168},
  {954658800, -14400, 168},
  {972799200, -18000, 168},
  {986108400, -14400, 168},
  {1004248800, -18000, 168},
  {1018162800, -14400, 168},
  {1035698400, -18000, 168},
  {1049612400, -14400, 168},
  {1067148000, -18000, 168},
  {1081062000, -14400, 168},
  {1099202400, -18000, 168},
  {1112511600, -14400, 168},
  {1130652000, -18000, 168},
  {1143961200, -14400, 168},
  {1162101600, -18000, 168},
  {1173596400, -14400, 168},
  {1194156000, -18000, 168},
  {1205046000, -14400, 168},
  {1225605600, -18000, 168},
  {1236495600, -14400, 168},
  {1257055200, -18000, 168},
  {1268550000, -14400, 168},
  {1289109600, -18000, 168},
  {1299999600, -14400, 168},
  {1320559200, -18000, 168},
  {1331449200, -14400, 168},
  {1352008800, -18000, 168},
  {1362898800, -14400, 168},
  {1383458400, -18000, 168},
  {1394348400, -14400, 168},
  {1414908000, -18000, 168},
  {1425798000, -14400, 168},
  {1446357600, -18000, 168},
  {1457852400, -14400, 168},
  {1478412000, -18000, 168},
  {1489302000, -14400, 168},
  {1509861600, -18000, 168},
  {1520751600, -14400, 168},
  {1541311200, -18000, 168},
  {1552201200, -14400, 168},
  {1572760800, -18000, 168},
  {1583650800, -14400, 168},
  {1604210400, -18000, 168},
  {1615705200, -14400, 168},
  {1636264800, -18000, 168},
  {1647154800, -14400, 168},
  {1667714400, -18000, 168},
  {1678604400, -14400, 168},
  {1699164000, -18000, 168},
  {1710054000, -14400, 168},
  {1730613600, -18000, 168},
  {1741503600, -14400, 168},
  {1762063200, -18000, 168},
  {1772953200, -14400, 168},
  {1793512800, -18000, 168},
  {1805007600, -14400, 168},
  {1825567200, -18000, 168},
  {1836457200, -14400, 168},
  {1857016800, -18000, 168},
  {1867906800, -14400, 168},
  {1888466400, -18000, 168},
  {1899356400, -14400, 168},
  {1919916000, -18000, 168},
  {1930806000, -14400, 168},
  {1951365600, -18000, 168},
  {1962860400, -14400, 168},
  {1983420000, -18000, 168},
  {1994310000, -14400, 168},
  {2014869600, -18000, 168},
  {2025759600, -14400, 168},
  {2046319200, -18000, 168},
  {2057209200, -14400, 168},
  {2077768800, -18000, 168},
  {2088658800, -14400, 168},
  {2109218400, -18000, 168},
  {2120108400, -14400, 168},
  {2140668000, -18000, 168},
  {-880196400, -36000, 169},
  {-769395600, -36000, 169},
  {-765374400, -39600, 169},
  {-86878800, -39600, 169},
  {-21466800, -36000, 169},
  {-5745600, -39600, 169},
  {9982800, -36000, 169},
  {25704000, -39600, 169},
  {41432400, -36000, 169},
  {57758400, -39600, 169},
  {73486800, -36000, 169},
  {89208000, -39600, 169},
  {104936400, -36000, 169},
  {120657600, -39600, 169},
  {126709200, -36000, 169},
  {152107200, -39600, 169},
  {162392400, -36000, 169},
  {183556800, -39600, 169},
  {199285200, -36000, 169},
  {215611200, -39600, 169},
  {230734800, -36000, 169},
  {247060800, -39600, 169},
  {262789200, -36000, 169},
  {278510400, -39600, 169},
  {294238800, -36000, 169},
  {309960000, -39600, 169},
  {325688400, -36000, 169},
  {341409600, -39600, 169},
  {357138000, -36000, 169},
  {372859200, -39600, 169},
  {388587600, -36000, 169},
  {404913600, -39600, 169},
  {420037200, -36000, 169},
  {436363200, -32400, 169},
  {439030800, -32400, 169},
  {452084400, -28800, 169},
  {467805600, -32400, 169},
  {483534000, -28800, 169},
  {499255200, -32400, 169},
  {514983600, -28800, 169},
  {530704800, -32400, 169},
  {544618800, -28800, 169},
  {562154400, -32400, 169},
  {576068400, -28800, 169},
  {594208800, -32400, 169},
  {607518000, -28800, 169},
  {625658400, -32400, 169},
  {638967600, -28800, 169},
  {657108000, -32400, 169},
  {671022000, -28800, 169},
  {688557600, -32400, 169},
  {702471600, -28800, 169},
  {720007200, -32400, 169},
  {733921200, -28800, 169},
  {752061600, -32400, 169},
  {765370800, -28800, 169},
  {783511200, -32400, 169},
  {796820400, -28800, 169},
  {814960800, -32400, 169},
  {828874800, -28800, 169},
  {846410400, -32400, 169},
  {860324400, -28800, 169},
  {877860000, -32400, 169},
  {891774000, -28800, 169},
  {909309600, -32400, 169},
  {923223600, -28800, 169},
  {941364000, -32400, 169},
  {954673200, -28800, 169},
  {972813600, -32400, 169},
  {986122800, -28800, 169},
  {1004263200, -32400, 169},
  {1018177200, -28800, 169},
  {1035712800, -32400, 169},
  {1049626800, -28800, 169},
  {1067162400, -32400, 169},
  {1081076400, -28800, 169},
  {1099216800, -32400, 169},
  {1112526000, -28800, 169},
  {1130666400, -32400, 169},
  {1143975600, -28800, 169},
  {1162116000, -32400, 169},
  {1173610800, -28800, 169},
  {1194170400, -32400, 169},
  {1205060400, -28800, 169},
  {1225620000, -32400, 169},
  {1236510000, -28800, 169},
  {1257069600, -32400, 169},
  {1268564400, -28800, 169},
  {1289124000, -32400, 169},
  {1300014000, -28800, 169},
  {1320573600, -32400, 169},
  {1331463600, -28800, 169},
  {1352023200, -32400, 169},
  {1362913200, -28800, 169},
  {1383472800, -32400, 169},
  {1394362800, -28800, 169},
  {1414922400, -32400, 169},
  {1425812400, -28800, 169},
  {1446372000, -32400, 169},
  {1457866800, -28800, 169},
  {1478426400, -32400, 169},
  {1489316400, -28800, 169},
  {1509876000, -32400, 169},
  {1520766000, -28800, 169},
  {1541325600, -32400, 169},
  {1552215600, -28800, 169},
  {1572775200, -32400, 169},
  {1583665200, -28800, 169},
  {1604224800, -32400, 169},
  {1615719600, -28800, 169},
  {1636279200, -32400, 169},
  {1647169200, -28800, 169},
  {1667728800, -32400, 169},
  {1678618800, -28800, 169},
  {1699178400, -32400, 169},
  {1710068400, -28800, 169},
  {1730628000, -32400, 169},
  {1741518000, -28800, 169},
  {1762077600, -32400, 169},
  {1772967600, -28800, 169},
  {1793527200, -32400, 169},
  {1805022000, -28800, 169},
  {1825581600, -32400, 169},
  {1836471600, -28800, 169},
  {1857031200, -32400, 169},
  {1867921200, -28800, 169},
  {1888480800, -32400, 169},
  {1899370800, -28800, 169},
  {1919930400, -32400, 169},
  {1930820400, -28800, 169},
  {1951380000, -32400, 169},
  {1962874800, -28800, 169},
  {1983434400, -32400, 169},
  {1994324400, -28800, 169},
  {2014884000, -32400, 169},
  {2025774000, -28800, 169},
  {2046333600, -32400, 169},
  {2057223600, -28800, 169},
  {2077783200, -32400, 169},
  {2088673200, -28800, 169},
  {2109232800, -32400, 169},
  {2120122800, -28800, 169},
  {2140682400, -32400, 169},
  {INT64_MIN, -7780, 170},
  {-1767217820, -7200, 170},
  {-1206961200, -3600, 170},
  {-1191366000, -7200, 170},
  {-1175378400, -3600, 170},
  {-1159830000, -7200, 170},
  {-633823200, -3600, 170},
  {-622072800, -7200, 170},
  {-602287200, -3600, 170},
  {-591836400, -7200, 170},
  {-570751200, -3600, 170},
  {-560214000, -7200, 170},
  {-539128800, -3600, 170},
  {-531356400, -7200, 170},
  {-191368800, -3600, 170},
  {-184201200, -7200, 170},
  {-155167200, -3600, 170},
  {-150073200, -7200, 170},
  {-128901600, -3600, 170},
  {-121129200, -7200, 170},
  {-99957600, -3600, 170},
  {-89593200, -7200, 170},
  {-68421600, -3600, 170},
  {-57970800, -7200, 170},
  {499744800, -3600, 170},
  {511232400, -7200, 170},
  {530589600, -3600, 170},
  {540262800, -7200, 170},
  {562125600, -3600, 170},
  {571194000, -7200, 170},
  {592970400, -3600, 170},
  {602038800, -7200, 170},
  {624420000, -3600, 170},
  {634698000, -7200, 170},
  {938916000, -3600, 170},
  {951613200, -7200, 170},
  {970970400, -3600, 170},
  {971571600, -7200, 170},
  {1003024800, -3600, 170},
  {1013907600, -7200, 170},
  {-1633273200, -21600, 171},
  {-1615132800, -25200, 171},
  {-1601823600, -21600, 171},
  {-1583683200, -25200, 171},
  {-880210800, -21600, 171},
  {-769395600, -21600, 171},
  {-765388800, -25200, 171},
  {-84380400, -21600, 171},
  {-68659200, -25200, 171},
  {-52930800, -21600, 171},
  {-37209600, -25200, 171},
  {-21481200, -21600, 171},
  {-5760000, -25200, 171},
  {9968400, -21600, 171},
  {25689600, -25200, 171},
  {41418000, -21600, 171},
  {57744000, -25200, 171},
  {73472400, -21600, 171},
  {89193600, -25200, 171},
  {104922000, -21600, 171},
  {120643200, -25200, 171},
  {126694800, -21600, 171},
  {152092800, -25200, 171},
  {162378000, -21600, 171},
  {183542400, -25200, 171},
  {199270800, -21600, 171},
  {215596800, -25200, 171},
  {230720400, -21600, 171},
  {247046400, -25200, 171},
  {262774800, -21600, 171},
  {278496000, -25200, 171},
  {294224400, -21600, 171},
  {309945600, -25200, 171},
  {325674000, -21600, 171},
  {341395200, -25200, 171},
  {357123600, -21600, 171},
  {372844800, -25200, 171},
  {388573200, -21600, 171},
  {404899200, -25200, 171},
  {420022800, -21600, 171},
  {436348800, -25200, 171},
  {452077200, -21600, 171},
  {467798400, -25200, 171},
  {483526800, -21600, 171},
  {499248000, -25200, 171},
  {514976400, -21600, 171},
  {530697600, -25200, 171},
  {544611600, -21600, 171},
  {562147200, -25200, 171},
  {576061200, -21600, 171},
  {594201600, -25200, 171},
  {607510800, -21600, 171},
  {625651200, -25200, 171},
  {638960400, -21600, 171},
  {657100800, -25200, 171},
  {671014800, -21600, 171},
  {688550400, -25200, 171},
  {702464400, -21600, 171},
  {720000000, -25200, 171},
  {733914000, -21600, 171},
  {752054400, -25200, 171},
  {765363600, -21600, 171},
  {783504000, -25200, 171},
  {796813200, -21600, 171},
  {814953600, -25200, 171},
  {828867600, -21600, 171},
  {846403200, -25200, 171},
  {860317200, -21600, 171},
  {877852800, -25200, 171},
  {891766800, -21600, 171},
  {909302400, -25200, 171},
  {923216400, -21600, 171},
  {941356800, -25200, 171},
  {954666000, -21600, 171},
  {972806400, -25200, 171},
  {986115600, -21600, 171},
  {1004256000, -25200, 171},
  {1018170000, -21600, 171},
  {1035705600, -25200, 171},
  {1049619600, -21600, 171},
  {1067155200, -25200, 171},
  {1081069200, -21600, 171},
  {1099209600, -25200, 171},
  {1112518800, -21600, 171},
  {1130659200, -25200, 171},
  {1143968400, -21600, 171},
  {1162108800, -25200, 171},
  {1173603600, -21600, 171},
  {1194163200, -25200, 171},
  {1205053200, -21600, 171},
  {1225612800, -25200, 171},
  {1236502800, -21600, 171},
  {1257062400, -25200, 171},
  {1268557200, -21600, 171},
  {1289116800, -21600, 171},
  {1300003200, -18000, 171},
  {1320562800, -21600, 171},
  {1331452800, -18000, 171},
  {1352012400, -21600, 171},
  {1362902400, -18000, 171},
  {1383462000, -21600, 171},
  {1394352000, -18000, 171},
  {1414911600, -21600, 171},
  {1425801600, -18000, 171},
  {1446361200, -21600, 171},
  {1457856000, -18000, 171},
  {1478415600, -21600, 171},
  {1489305600, -18000, 171},
  {1509865200, -21600, 171},
  {1520755200, -18000, 171},
  {1541314800, -21600, 171},
  {1552204800, -18000, 171},
  {1572764400, -21600, 171},
  {1583654400, -18000, 171},
  {1604214000, -21600, 171},
  {1615708800, -18000, 171},
  {1636268400, -21600, 171},
  {1647158400, -18000, 171},
  {1667718000, -21600, 171},
  {1678608000, -18000, 171},
  {1699167600, -21600, 171},
  {1710057600, -18000, 171},
  {1730617200, -21600, 171},
  {1741507200, -18000, 171},
  {1762066800, -21600, 171},
  {1772956800, -18000, 171},
  {1793516400, -21600, 171},
  {1805011200, -18000, 171},
  {1825570800, -21600, 171},
  {1836460800, -18000, 171},
  {1857020400, -21600, 171},
  {1867910400, -18000, 171},
  {1888470000, -21600, 171},
  {1899360000, -18000, 171},
  {1919919600, -21600, 171},
  {1930809600, -18000, 171},
  {1951369200, -21600, 171},
  {1962864000, -18000, 171},
  {1983423600, -21600, 171},
  {1994313600, -18000, 171},
  {2014873200, -21600, 171},
  {2025763200, -18000, 171},
  {2046322800, -21600, 171},
  {2057212800, -18000, 171},
  {2077772400, -21600, 171},
  {2088662400, -18000, 171},
  {2109222000, -21600, 171},
  {2120112000, -18000, 171},
  {2140671600, -21600, 171},
  {-1633273200, -21600, 172},
  {-1615132800, -25200, 172},
  {-1601823600, -21600, 172},
  {-1583683200, -25200, 172},
  {-880210800, -21600, 172},
  {-769395600, -21600, 172},
  {-765388800, -25200, 172},
  {-84380400, -21600, 172},
  {-68659200, -25200, 172},
  {-52930800, -21600, 172},
  {-37209600, -25200, 172},
  {-21481200, -21600, 172},
  {-5760000, -25200, 172},
  {9968400, -21600, 172},
  {25689600, -25200, 172},
  {41418000, -21600, 172},
  {57744000, -25200, 172},
  {73472400, -21600, 172},
  {89193600, -25200, 172},
  {104922000, -21600, 172},
  {120643200, -25200, 172},
  {126694800, -21600, 172},
  {152092800, -25200, 172},
  {162378000, -21600, 172},
  {183542400, -25200, 172},
  {199270800, -21600, 172},
  {215596800, -25200, 172},
  {230720400, -21600, 172},
  {247046400, -25200, 172},
  {262774800, -21600, 172},
  {278496000, -25200, 172},
  {294224400, -21600, 172},
  {309945600, -25200, 172},
  {325674000, -21600, 172},
  {341395200, -25200, 172},
  {357123600, -21600, 172},
  {372844800, -25200, 172},
  {388573200, -21600, 172},
  {404899200, -25200, 172},
  {420022800, -21600, 172},
  {436348800, -25200, 172},
  {452077200, -21600, 172},
  {467798400, -25200, 172},
  {483526800, -21600, 172},
  {499248000, -25200, 172},
  {514976400, -21600, 172},
  {530697600, -25200, 172},
  {544611600, -21600, 172},
  {562147200, -25200, 172},
  {576061200, -21600, 172},
  {594201600, -25200, 172},
  {607510800, -21600, 172},
  {625651200, -25200, 172},
  {638960400, -21600, 172},
  {657100800, -25200, 172},
  {671014800, -21600, 172},
  {688550400, -25200, 172},
  {702464400, -21600, 172},
  {720000000, -21600, 172},
  {733910400, -18000, 172},
  {752050800, -21600, 172},
  {765360000, -18000, 172},
  {783500400, -21600, 172},
  {796809600, -18000, 172},
  {814950000, -21600, 172},
  {828864000, -18000, 172},
  {846399600, -21600, 172},
  {860313600, -18000, 172},
  {877849200, -21600, 172},
  {891763200, -18000, 172},
  {909298800, -21600, 172},
  {923212800, -18000, 172},
  {941353200, -21600, 172},
  {954662400, -18000, 172},
  {972802800, -21600, 172},
  {986112000, -18000, 172},
  {1004252400, -21600, 172},
  {1018166400, -18000, 172},
  {1035702000, -21600, 172},
  {1049616000, -18000, 172},
  {1067151600, -21600, 172},
  {1081065600, -18000, 172},
  {1099206000, -21600, 172},
  {1112515200, -18000, 172},
  {1130655600, -21600, 172},
  {1143964800, -18000, 172},
  {1162105200, -21600, 172},
  {1173600000, -18000, 172},
  {1194159600, -21600, 172},
  {1205049600, -18000, 172},
  {1225609200, -21600, 172},
  {1236499200, -18000, 172},
  {1257058800, -21600, 172},
  {1268553600, -18000, 172},
  {1289113200, -21600, 172},
  {1300003200, -18000, 172},
  {1320562800, -21600, 172},
  {1331452800, -18000, 172},
  {1352012400, -21600, 172},
  {1362902400, -18000, 172},
  {1383462000, -21600, 172},
  {1394352000, -18000, 172},
  {1414911600, -21600, 172},
  {1425801600, -18000, 172},
  {1446361200, -21600, 172},
  {1457856000, -18000, 172},
  {1478415600, -21600, 172},
  {1489305600, -18000, 172},
  {1509865200, -21600, 172},
  {1520755200, -18000, 172},
  {1541314800, -21600, 172},
  {1552204800, -18000, 172},
  {1572764400, -21600, 172},
  {1583654400, -18000, 172},
  {1604214000, -21600, 172},
  {1615708800, -18000, 172},
  {1636268400, -21600, 172},
  {1647158400, -18000, 172},
  {1667718000, -21600, 172},
  {1678608000, -18000, 172},
  {1699167600, -21600, 172},
  {1710057600, -18000, 172},
  {1730617200, -21600, 172},
  {1741507200, -18000, 172},
  {1762066800, -21600, 172},
  {1772956800, -18000, 172},
  {1793516400, -21600, 172},
  {1805011200, -18000, 172},
  {1825570800, -21600, 172},
  {1836460800, -18000, 172},
  {1857020400, -21600, 172},
  {1867910400, -18000, 172},
  {1888470000, -21600, 172},
  {1899360000, -18000, 172},
  {1919919600, -21600, 172},
  {1930809600, -18000, 172},
  {1951369200, -21600, 172},
  {1962864000, -18000, 172},
  {1983423600, -21600, 172},
  {1994313600, -18000, 172},
  {2014873200, -21600, 172},
  {2025763200, -18000, 172},
  {2046322800, -21600, 172},
  {2057212800, -18000, 172},
  {2077772400, -21600, 172},
  {2088662400, -18000, 172},
  {2109222000, -21600, 172},
  {2120112000, -18000, 172},
  {2140671600, -21600, 172},
  {-1633273200, -21600, 173},
  {-1615132800, -25200, 173},
  {-1601823600, -21600, 173},
  {-1583683200, -25200, 173},
  {-880210800, -21600, 173},
  {-769395600, -21600, 173},
  {-765388800, -25200, 173},
  {-84380400, -21600, 173},
  {-68659200, -25200, 173},
  {-52930800, -21600, 173},
  {-37209600, -25200, 173},
  {-21481200, -21600, 173},
  {-5760000, -25200, 173},
  {9968400, -21600, 173},
  {25689600, -25200, 173},
  {41418000, -21600, 173},
  {57744000, -25200, 173},
  {73472400, -21600, 173},
  {89193600, -25200, 173},
  {104922000, -21600, 173},
  {120643200, -25200, 173},
  {126694800, -21600, 173},
  {152092800, -25200, 173},
  {162378000, -21600, 173},
  {183542400, -25200, 173},
  {199270800, -21600, 173},
  {215596800, -25200, 173},
  {230720400, -21600, 173},
  {247046400, -25200, 173},
  {262774800, -21600, 173},
  {278496000, -25200, 173},
  {294224400, -21600, 173},
  {309945600, -25200, 173},
  {325674000, -21600, 173},
  {341395200, -25200, 173},
  {357123600, -21600, 173},
  {372844800, -25200, 173},
  {388573200, -21600, 173},
  {404899200, -25200, 173},
  {420022800, -21600, 173},
  {436348800, -25200, 173},
  {452077200, -21600, 173},
  {467798400, -25200, 173},
  {483526800, -21600, 173},
  {499248000, -25200, 173},
  {514976400, -21600, 173},
  {530697600, -25200, 173},
  {544611600, -21600, 173},
  {562147200, -25200, 173},
  {576061200, -21600, 173},
  {594201600, -25200, 173},
  {607510800, -21600, 173},
  {625651200, -25200, 173},
  {638960400, -21600, 173},
  {657100800, -25200, 173},
  {671014800, -21600, 173},
  {688550400, -25200, 173},
  {702464400, -21600, 173},
  {720000000, -25200, 173},
  {733914000, -21600, 173},
  {752054400, -25200, 173},
  {765363600, -21600, 173},
  {783504000, -25200, 173},
  {796813200, -21600, 173},
  {814953600, -25200, 173},
  {828867600, -21600, 173},
  {846403200, -25200, 173},
  {860317200, -21600, 173},
  {877852800, -25200, 173},
  {891766800, -21600, 173},
  {909302400, -25200, 173},
  {923216400, -21600, 173},
  {941356800, -25200, 173},
  {954666000, -21600, 173},
  {972806400, -25200, 173},
  {986115600, -21600, 173},
  {1004256000, -25200, 173},
  {1018170000, -21600, 173},
  {1035705600, -25200, 173},
  {1049619600, -21600, 173},
  {1067155200, -21600, 173},
  {1081065600, -18000, 173},
  {1099206000, -21600, 173},
  {1112515200, -18000, 173},
  {1130655600, -21600, 173},
  {1143964800, -18000, 173},
  {1162105200, -21600, 173},
  {1173600000, -18000, 173},
  {1194159600, -21600, 173},
  {1205049600, -18000, 173},
  {1225609200, -21600, 173},
  {1236499200, -18000, 173},
  {1257058800, -21600, 173},
  {1268553600, -18000, 173},
  {1289113200, -21600, 173},
  {1300003200, -18000, 173},
  {1320562800, -21600, 173},
  {1331452800, -18000, 173},
  {1352012400, -21600, 173},
  {1362902400, -18000, 173},
  {1383462000, -21600, 173},
  {1394352000, -18000, 173},
  {1414911600, -21600, 173},
  {1425801600, -18000, 173},
  {1446361200, -21600, 173},
  {1457856000, -18000, 173},
  {1478415600, -21600, 173},
  {1489305600, -18000, 173},
  {1509865200, -21600, 173},
  {1520755200, -18000, 173},
  {1541314800, -21600, 173},
  {1552204800, -18000, 173},
  {1572764400, -21600, 173},
  {1583654400, -18000, 173},
  {1604214000, -21600, 173},
  {1615708800, -18000, 173},
  {1636268400, -21600, 173},
  {1647158400, -18000, 173},
  {1667718000, -21600, 173},
  {1678608000, -18000, 173},
  {1699167600, -21600, 173},
  {1710057600, -18000, 173},
  {1730617200, -21600, 173},
  {1741507200, -18000, 173},
  {1762066800, -21600, 173},
  {1772956800, -18000, 173},
  {1793516400, -21600, 173},
  {1805011200, -18000, 173},
  {1825570800, -21600, 173},
  {1836460800, -18000, 173},
  {1857020400, -21600, 173},
  {1867910400, -18000, 173},
  {1888470000, -21600, 173},
  {1899360000, -18000, 173},
  {1919919600, -21600, 173},
  {1930809600, -18000, 173},
  {1951369200, -21600, 173},
  {1962864000, -18000, 173},
  {1983423600, -21600, 173},
  {1994313600, -18000, 173},
  {2014873200, -21600, 173},
  {2025763200, -18000, 173},
  {2046322800, -21600, 173},
  {2057212800, -18000, 173},
  {2077772400, -21600, 173},
  {2088662400, -18000, 173},
  {2109222000, -21600, 173},
  {2120112000, -18000, 173},
  {2140671600, -21600, 173},
  {INT64_MIN, -25060, 174},
  {-1514739600, -25200, 174},
  {-1343066400, -21600, 174},
  {-1234807200, -25200, 174},
  {-1220292000, -21600, 174},
  {-1207159200, -25200, 174},
  {-1191344400, -21600, 174},
  {828864000, -18000, 174},
  {846399600, -21600, 174},
  {860313600, -18000, 174},
  {877849200, -21600, 174},
  {891766800, -21600, 174},
  {909302400, -25200, 174},
  {923216400, -21600, 174},
  {941356800, -25200, 174},
  {954666000, -21600, 174},
  {972806400, -25200, 174},
  {989139600, -21600, 174},
  {1001836800, -25200, 174},
  {1018170000, -21600, 174},
  {1035705600, -25200, 174},
  {1049619600, -21600, 174},
  {1067155200, -25200, 174},
  {1081069200, -21600, 174},
  {1099209600, -25200, 174},
  {1112518800, -21600, 174},
  {1130659200, -25200, 174},
  {1143968400, -21600, 174},
  {1162108800, -25200, 174},
  {1175418000, -21600, 174},
  {1193558400, -25200, 174},
  {1207472400, -21600, 174},
  {1225008000, -25200, 174},
  {1238922000, -21600, 174},
  {1256457600, -25200, 174},
  {1268557200, -21600, 174},
  {1289116800, -25200, 174},
  {1300006800, -21600, 174},
  {1320566400, -25200, 174},
  {1331456400, -21600, 174},
  {1352016000, -25200, 174},
  {1362906000, -21600, 174},
  {1383465600, -25200, 174},
  {1394355600, -21600, 174},
  {1414915200, -25200, 174},
  {1425805200, -21600, 174},
  {1446364800, -25200, 174},
  {1457859600, -21600, 174},
  {1478419200, -25200, 174},
  {1489309200, -21600, 174},
  {1509868800, -25200, 174},
  {1520758800, -21600, 174},
  {1541318400, -25200, 174},
  {1552208400, -21600, 174},
  {1572768000, -25200, 174},
  {1583658000, -21600, 174},
  {1604217600, -25200, 174},
  {1615712400, -21600, 174},
  {1636272000, -25200, 174},
  {1647162000, -21600, 174},
  {1667721600, -25200, 174},
  {1678611600, -21600, 174},
  {1699171200, -25200, 174},
  {1710061200, -21600, 174},
  {1730620800, -25200, 174},
  {1741510800, -21600, 174},
  {1762070400, -25200, 174},
  {1772960400, -21600, 174},
  {1793520000, -25200, 174},
  {1805014800, -21600, 174},
  {1825574400, -25200, 174},
  {1836464400, -21600, 174},
  {1857024000, -25200, 174},
  {1867914000, -21600, 174},
  {1888473600, -25200, 174},
  {1899363600, -21600, 174},
  {1919923200, -25200, 174},
  {1930813200, -21600, 174},
  {1951372800, -25200, 174},
  {1962867600, -21600, 174},
  {1983427200, -25200, 174},
  {1994317200, -21600, 174},
  {2014876800, -25200, 174},
  {2025766800, -21600, 174},
  {2046326400, -25200, 174},
  {2057216400, -21600, 174},
  {2077776000, -25200, 174},
  {2088666000, -21600, 174},
  {2109225600, -25200, 174},
  {2120115600, -21600, 174},
  {2140675200, -25200, 174},
  {INT64_MIN, -19176, 175},
  {-1946918424, -18000, 175},
  {INT64_MIN, 0, 176},
  {-1546300800, -14400, 176},
  {-880221600, -10800, 176},
  {-769395600, -10800, 176},
  {-765399600, -14400, 176},
  {-147902400, -7200, 176},
  {-131572800, -14400, 176},
  {325663200, -10800, 176},
  {341384400, -14400, 176},
  {357112800, -10800, 176},
  {372834000, -14400, 176},
  {388562400, -10800, 176},
  {404888400, -14400, 176},
  {420012000, -10800, 176},
  {436338000, -14400, 176},
  {452066400, -10800, 176},
  {467787600, -14400, 176},
  {483516000, -10800, 176},
  {499237200, -14400, 176},
  {514965600, -10800, 176},
  {530686800, -14400, 176},
  {544600800, -10800, 176},
  {562136400, -14400, 176},
  {576050400, -10800, 176},
  {594190800, -14400, 176},
  {607500000, -10800, 176},
  {625640400, -14400, 176},
  {638949600, -10800, 176},
  {657090000, -14400, 176},
  {671004000, -10800, 176},
  {688539600, -14400, 176},
  {702453600, -10800, 176},
  {719989200, -14400, 176},
  {733903200, -10800, 176},
  {752043600, -14400, 176},
  {765352800, -10800, 176},
  {783493200, -14400, 176},
  {796802400, -14400, 176},
  {814946400, -18000, 176},
  {828860400, -14400, 176},
  {846396000, -18000, 176},
  {860310000, -14400, 176},
  {877845600, -18000, 176},
  {891759600, -14400, 176},
  {909295200, -18000, 176},
  {923209200, -14400, 176},
  {941349600, -21600, 176},
  {954662400, -18000, 176},
  {972802800, -18000, 176},
  {986108400, -14400, 176},
  {1004248800, -18000, 176},
  {1018162800, -14400, 176},
  {1035698400, -18000, 176},
  {1049612400, -14400, 176},
  {1067148000, -18000, 176},
  {1081062000, -14400, 176},
  {1099202400, -18000, 176},
  {1112511600, -14400, 176},
  {1130652000, -18000, 176},
  {1143961200, -14400, 176},
  {1162101600, -18000, 176},
  {1173596400, -14400, 176},
  {1194156000, -18000, 176},
  {1205046000, -14400, 176},
  {1225605600, -18000, 176},
  {1236495600, -14400, 176},
  {1257055200, -18000, 176},
  {1268550000, -14400, 176},
  {1289109600, -18000, 176},
  {1299999600, -14400, 176},
  {1320559200, -18000, 176},
  {1331449200, -14400, 176},
  {1352008800, -18000, 176},
  {1362898800, -14400, 176},
  {1383458400, -18000, 176},
  {1394348400, -14400, 176},
  {1414908000, -18000, 176},
  {1425798000, -14400, 176},
  {1446357600, -18000, 176},
  {1457852400, -14400, 176},
  {1478412000, -18000, 176},
  {1489302000, -14400, 176},
  {1509861600, -18000, 176},
  {1520751600, -14400, 176},
  {1541311200, -18000, 176},
  {1552201200, -14400, 176},
  {1572760800, -18000, 176},
  {1583650800, -14400, 176},
  {1604210400, -18000, 176},
  {1615705200, -14400, 176},
  {1636264800, -18000, 176},
  {1647154800, -14400, 176},
  {1667714400, -18000, 176},
  {1678604400, -14400, 176},
  {1699164000, -18000, 176},
  {1710054000, -14400, 176},
  {1730613600, -18000, 176},
  {1741503600, -14400, 176},
  {1762063200, -18000, 176},
  {1772953200, -14400, 176},
  {1793512800, -18000, 176},
  {1805007600, -14400, 176},
  {1825567200, -18000, 176},
  {1836457200, -14400, 176},
  {1857016800, -18000, 176},
  {1867906800, -14400, 176},
  {1888466400, -18000, 176},
  {1899356400, -14400, 176},
  {1919916000, -18000, 176},
  {1930806000, -14400, 176},
  {1951365600, -18000, 176},
  {1962860400, -14400, 176},
  {1983420000, -18000, 176},
  {1994310000, -14400, 176},
  {2014869600, -18000, 176},
  {2025759600, -14400, 176},
  {2046319200, -18000, 176},
  {2057209200, -14400, 176},
  {2077768800, -18000, 176},
  {2088658800, -14400, 176},
  {2109218400, -18000, 176},
  {2120108400, -14400, 176},
  {2140668000, -18000, 176},
  {INT64_MIN, -13240, 177},
  {-1861906760, -13252, 177},
  {-1104524348, -13236, 177},
  {-765317964, -12600, 177},
  {185686200, -12600, 177},
  {465449400, -10800, 177},
  {-1633273200, -21600, 178},
  {-1615132800, -25200, 178},
  {-1601823600, -21600, 178},
  {-1583683200, -25200, 178},
  {-880210800, -21600, 178},
  {-820519140, -25200, 178},
  {-812653140, -21600, 178},
  {-796845540, -25200, 178},
  {-84380400, -21600, 178},
  {-68659200, -25200, 178},
  {INT64_MIN, -17340, 179},
  {-1670483460, -18000, 179},
  {421218000, -14400, 179},
  {436334400, -18000, 179},
  {452062800, -14400, 179},
  {467784000, -18000, 179},
  {483512400, -14400, 179},
  {499233600, -18000, 179},
  {514962000, -14400, 179},
  {530683200, -18000, 179},
  {546411600, -14400, 179},
  {562132800, -18000, 179},
  {576050400, -14400, 179},
  {594194400, -18000, 179},
  {607500000, -14400, 179},
  {625644000, -18000, 179},
  {638949600, -14400, 179},
  {657093600, -18000, 179},
  {671004000, -14400, 179},
  {688543200, -18000, 179},
  {702453600, -14400, 179},
  {719992800, -18000, 179},
  {733903200, -14400, 179},
  {752047200, -18000, 179},
  {765352800, -14400, 179},
  {783496800, -18000, 179},
  {796802400, -14400, 179},
  {814946400, -18000, 179},
  {828856800, -14400, 179},
  {846396000, -18000, 179},
  {860306400, -14400, 179},
  {877845600, -18000, 179},
  {1112504400, -14400, 179},
  {1130644800, -18000, 179},
  {1143954000, -14400, 179},
  {1162094400, -18000, 179},
  {INT64_MIN, -14764, 180},
  {-1825098836, -14400, 180},
  {INT64_MIN, -16272, 181},
  {-1767209328, -18000, 181},
  {-1206950400, -14400, 181},
  {-1191355200, -18000, 181},
  {-1175367600, -14400, 181},
  {-1159819200, -18000, 181},
  {-633812400, -14400, 181},
  {-622062000, -18000, 181},
  {-602276400, -14400, 181},
  {-591825600, -18000, 181},
  {-570740400, -14400, 181},
  {-560203200, -18000, 181},
  {-539118000, -14400, 181},
  {-531345600, -18000, 181},
  {-191358000, -14400, 181},
  {-184190400, -18000, 181},
  {-155156400, -14400, 181},
  {-150062400, -18000, 181},
  {-128890800, -14400, 181},
  {-121118400, -18000, 181},
  {-99946800, -14400, 181},
  {-89582400, -18000, 181},
  {-68410800, -14400, 181},
  {-57960000, -18000, 181},
  {499755600, -14400, 181},
  {511243200, -18000, 181},
  {530600400, -14400, 181},
  {540273600, -18000, 181},
  {562136400, -14400, 181},
  {571204800, -18000, 181},
  {1214283600, -14400, 181},
  {INT64_MIN, -15336, 182},
  {-1767210264, -14400, 182},
  {-1206954000, -10800, 182},
  {-1191358800, -14400, 182},
  {-1175371200, -10800, 182},
  {-1159822800, -14400, 182},
  {-633816000, -10800, 182},
  {-622065600, -14400, 182},
  {-602280000, -10800, 182},
  {-591829200, -14400, 182},
  {-570744000, -10800, 182},
  {-560206800, -14400, 182},
  {-539121600, -10800, 182},
  {-531349200, -14400, 182},
  {-191361600, -10800, 182},
  {-184194000, -14400, 182},
  {-155160000, -10800, 182},
  {-150066000, -14400, 182},
  {-128894400, -10800, 182},
  {-121122000, -14400, 182},
  {-99950400, -10800, 182},
  {-89586000, -14400, 182},
  {-68414400, -10800, 182},
  {-57963600, -14400, 182},
  {499752000, -10800, 182},
  {511239600, -14400, 182},
  {530596800, -10800, 182},
  {540270000, -14400, 182},
  {562132800, -10800, 182},
  {571201200, -14400, 182},
  {-873057600, -10800, 183},
  {-769395600, -10800, 183},
  {-765399600, -14400, 183},
  {-1632067200, -18000, 184},
  {-1614790800, -21600, 184},
  {-923248800, -18000, 184},
  {-880214400, -18000, 184},
  {-769395600, -18000, 184},
  {-765392400, -21600, 184},
  {136368000, -18000, 184},
  {152089200, -21600, 184},
  {167817600, -18000, 184},
  {183538800, -21600, 184},
  {199267200, -18000, 184},
  {215593200, -21600, 184},
  {230716800, -18000, 184},
  {247042800, -21600, 184},
  {262771200, -18000, 184},
  {278492400, -21600, 184},
  {294220800, -18000, 184},
  {309942000, -21600, 184},
  {325670400, -18000, 184},
  {341391600, -21600, 184},
  {357120000, -18000, 184},
  {372841200, -21600, 184},
  {388569600, -18000, 184},
  {404895600, -21600, 184},
  {420019200, -18000, 184},
  {436345200, -21600, 184},
  {452073600, -18000, 184},
  {467794800, -21600, 184},
  {483523200, -18000, 184},
  {499244400, -21600, 184},
  {514972800, -18000, 184},
  {530694000, -21600, 184},
  {544608000, -18000, 184},
  {562143600, -21600, 184},
  {576057600, -18000, 184},
  {594198000, -21600, 184},
  {607507200, -18000, 184},
  {625647600, -21600, 184},
  {638956800, -18000, 184},
  {657097200, -21600, 184},
  {671011200, -18000, 184},
  {688546800, -21600, 184},
  {702460800, -18000, 184},
  {719996400, -21600, 184},
  {733910400, -18000, 184},
  {752050800, -21600, 184},
  {765360000, -18000, 184},
  {783500400, -21600, 184},
  {796809600, -18000, 184},
  {814950000, -21600, 184},
  {828864000, -18000, 184},
  {846399600, -21600, 184},
  {860313600, -18000, 184},
  {877849200, -21600, 184},
  {891763200, -18000, 184},
  {909298800, -21600, 184},
  {923212800, -18000, 184},
  {941353200, -21600, 184},
  {954662400, -18000, 184},
  {972802800, -21600, 184},
  {986112000, -18000, 184},
  {1004252400, -21600, 184},
  {1018166400, -18000, 184},
  {1035702000, -21600, 184},
  {1049616000, -18000, 184},
  {1067151600, -21600, 184},
  {1081065600, -18000, 184},
  {1099206000, -21600, 184},
  {1112515200, -18000, 184},
  {1130655600, -21600, 184},
  {1143964800, -18000, 184},
  {1162105200, -21600, 184},
  {1173600000, -18000, 184},
  {1194159600, -21600, 184},
  {1205049600, -18000, 184},
  {1225609200, -21600, 184},
  {1236499200, -18000, 184},
  {1257058800, -21600, 184},
  {1268553600, -18000, 184},
  {1289113200, -21600, 184},
  {1300003200, -18000, 184},
  {1320562800, -21600, 184},
  {1331452800, -18000, 184},
  {1352012400, -21600, 184},
  {1362902400, -18000, 184},
  {1383462000, -21600, 184},
  {1394352000, -18000, 184},
  {1414911600, -21600, 184},
  {1425801600, -18000, 184},
  {1446361200, -21600, 184},
  {1457856000, -18000, 184},
  {1478415600, -21600, 184},
  {1489305600, -18000, 184},
  {1509865200, -21600, 184},
  {1520755200, -18000, 184},
  {1541314800, -21600, 184},
  {1552204800, -18000, 184},
  {1572764400, -21600, 184},
  {1583654400, -18000, 184},
  {1604214000, -21600, 184},
  {1615708800, -18000, 184},
  {1636268400, -21600, 184},
  {1647158400, -18000, 184},
  {1667718000, -21600, 184},
  {1678608000, -18000, 184},
  {1699167600, -21600, 184},
  {1710057600, -18000, 184},
  {1730617200, -21600, 184},
  {1741507200, -18000, 184},
  {1762066800, -21600, 184},
  {1772956800, -18000, 184},
  {1793516400, -21600, 184},
  {1805011200, -18000, 184},
  {1825570800, -21600, 184},
  {1836460800, -18000, 184},
  {1857020400, -21600, 184},
  {1867910400, -18000, 184},
  {1888470000, -21600, 184},
  {1899360000, -18000, 184},
  {1919919600, -21600, 184},
  {1930809600, -18000, 184},
  {1951369200, -21600, 184},
  {1962864000, -18000, 184},
  {1983423600, -21600, 184},
  {1994313600, -18000, 184},
  {2014873200, -21600, 184},
  {2025763200, -18000, 184},
  {2046322800, -21600, 184},
  {2057212800, -18000, 184},
  {2077772400, -21600, 184},
  {2088662400, -18000, 184},
  {2109222000, -21600, 184},
  {2120112000, -18000, 184},
  {2140671600, -21600, 184},
  {INT64_MIN, 0, 185},
  {-410227200, -21600, 185},
  {-147895200, -14400, 185},
  {-131565600, -21600, 185},
  {325670400, -18000, 185},
  {341391600, -21600, 185},
  {357120000, -18000, 185},
  {372841200, -21600, 185},
  {388569600, -18000, 185},
  {404895600, -21600, 185},
  {420019200, -18000, 185},
  {436345200, -21600, 185},
  {452073600, -18000, 185},
  {467794800, -21600, 185},
  {483523200, -18000, 185},
  {499244400, -21600, 185},
  {514972800, -18000, 185},
  {530694000, -21600, 185},
  {544608000, -18000, 185},
  {562143600, -21600, 185},
  {576057600, -18000, 185},
  {594198000, -21600, 185},
  {607507200, -18000, 185},
  {625647600, -21600, 185},
  {638956800, -18000, 185},
  {657097200, -21600, 185},
  {671011200, -18000, 185},
  {688546800, -21600, 185},
  {702460800, -18000, 185},
  {719996400, -21600, 185},
  {733910400, -18000, 185},
  {752050800, -21600, 185},
  {765360000, -18000, 185},
  {783500400, -21600, 185},
  {796809600, -18000, 185},
  {814950000, -21600, 185},
  {828864000, -18000, 185},
  {846399600, -21600, 185},
  {860313600, -18000, 185},
  {877849200, -21600, 185},
  {891763200, -18000, 185},
  {909298800, -21600, 185},
  {923212800, -18000, 185},
  {941353200, -21600, 185},
  {954662400, -18000, 185},
  {972802800, -18000, 185},
  {986112000, -18000, 185},
  {1004252400, -21600, 185},
  {1018166400, -18000, 185},
  {1035702000, -21600, 185},
  {1049616000, -18000, 185},
  {1067151600, -21600, 185},
  {1081065600, -18000, 185},
  {1099206000, -21600, 185},
  {1112515200, -18000, 185},
  {1130655600, -21600, 185},
  {1143964800, -18000, 185},
  {1162105200, -21600, 185},
  {1173600000, -18000, 185},
  {1194159600, -21600, 185},
  {1205049600, -18000, 185},
  {1225609200, -21600, 185},
  {1236499200, -18000, 185},
  {1257058800, -21600, 185},
  {1268553600, -18000, 185},
  {1289113200, -21600, 185},
  {1300003200, -18000, 185},
  {1320562800, -21600, 185},
  {1331452800, -18000, 185},
  {1352012400, -21600, 185},
  {1362902400, -18000, 185},
  {1383462000, -21600, 185},
  {1394352000, -18000, 185},
  {1414911600, -21600, 185},
  {1425801600, -18000, 185},
  {1446361200, -21600, 185},
  {1457856000, -18000, 185},
  {1478415600, -21600, 185},
  {1489305600, -18000, 185},
  {1509865200, -21600, 185},
  {1520755200, -18000, 185},
  {1541314800, -21600, 185},
  {1552204800, -18000, 185},
  {1572764400, -21600, 185},
  {1583654400, -18000, 185},
  {1604214000, -21600, 185},
  {1615708800, -18000, 185},
  {1636268400, -21600, 185},
  {1647158400, -18000, 185},
  {1667718000, -21600, 185},
  {1678608000, -18000, 185},
  {1699167600, -21600, 185},
  {1710057600, -18000, 185},
  {1730617200, -21600, 185},
  {1741507200, -18000, 185},
  {1762066800, -21600, 185},
  {1772956800, -18000, 185},
  {1793516400, -21600, 185},
  {1805011200, -18000, 185},
  {1825570800, -21600, 185},
  {1836460800, -18000, 185},
  {1857020400, -21600, 185},
  {1867910400, -18000, 185},
  {1888470000, -21600, 185},
  {1899360000, -18000, 185},
  {1919919600, -21600, 185},
  {1930809600, -18000, 185},
  {1951369200, -21600, 185},
  {1962864000, -18000, 185},
  {1983423600, -21600, 185},
  {1994313600, -18000, 185},
  {2014873200, -21600, 185},
  {2025763200, -18000, 185},
  {2046322800, -21600, 185},
  {2057212800, -18000, 185},
  {2077772400, -21600, 185},
  {2088662400, -18000, 185},
  {2109222000, -21600, 185},
  {2120112000, -18000, 185},
  {2140671600, -21600, 185},
  {INT64_MIN, -8376, 186},
  {-1767217224, -10800, 186},
  {-1206957600, -7200, 186},
  {-1191362400, -10800, 186},
  {-1175374800, -7200, 186},
  {-1159826400, -10800, 186},
  {-633819600, -7200, 186},
  {-622069200, -10800, 186},
  {-602283600, -7200, 186},
  {-591832800, -10800, 186},
  {-570747600, -7200, 186},
  {-560210400, -10800, 186},
  {-539125200, -7200, 186},
  {-531352800, -10800, 186},
  {-191365200, -7200, 186},
  {-184197600, -10800, 186},
  {-155163600, -7200, 186},
  {-150069600, -10800, 186},
  {-128898000, -7200, 186},
  {-121125600, -10800, 186},
  {-99954000, -7200, 186},
  {-89589600, -10800, 186},
  {-68418000, -7200, 186},
  {-57967200, -10800, 186},
  {499748400, -7200, 186},
  {511236000, -10800, 186},
  {530593200, -7200, 186},
  {540266400, -10800, 186},
  {562129200, -7200, 186},
  {571197600, -10800, 186},
  {592974000, -7200, 186},
  {602042400, -10800, 186},
  {624423600, -7200, 186},
  {634701600, -10800, 186},
  {938919600, -7200, 186},
  {951616800, -10800, 186},
  {970974000, -7200, 186},
  {971575200, -10800, 186},
  {1003028400, -7200, 186},
  {1013911200, -10800, 186},
  {INT64_MIN, -25116, 187},
  {-2030202084, -25200, 187},
  {-1632063600, -21600, 187},
  {-1614787200, -25200, 187},
  {-1251651600, -21600, 187},
  {-1238349600, -25200, 187},
  {-1220202000, -21600, 187},
  {-1206900000, -25200, 187},
  {-1188752400, -21600, 187},
  {-1175450400, -25200, 187},
  {-1156698000, -21600, 187},
  {-1144000800, -25200, 187},
  {-1125248400, -21600, 187},
  {-1111946400, -25200, 187},
  {-1032714000, -21600, 187},
  {-1016992800, -25200, 187},
  {-1001264400, -21600, 187},
  {-986148000, -25200, 187},
  {-969814800, -21600, 187},
  {-954093600, -25200, 187},
  {-937760400, -21600, 187},
  {-922039200, -25200, 187},
  {-906310800, -21600, 187},
  {-890589600, -25200, 187},
  {-880210800, -21600, 187},
  {-769395600, -21600, 187},
  {-765388800, -25200, 187},
  {-748450800, -21600, 187},
  {-732729600, -25200, 187},
  {-715791600, -21600, 187},
  {-702489600, -25200, 187},
  {-684342000, -21600, 187},
  {-671040000, -25200, 187},
  {-652892400, -21600, 187},
  {-639590400, -25200, 187},
  {-620838000, -21600, 187},
  {-608140800, -25200, 187},
  {-589388400, -21600, 187},
  {-576086400, -25200, 187},
  {-557938800, -21600, 187},
  {-544636800, -25200, 187},
  {-526489200, -21600, 187},
  {-513187200, -25200, 187},
  {-495039600, -21600, 187},
  {-481737600, -25200, 187},
  {-463590000, -21600, 187},
  {-450288000, -25200, 187},
  {-431535600, -21600, 187},
  {-418233600, -25200, 187},
  {-400086000, -21600, 187},
  {-386784000, -25200, 187},
  {-337186800, -21600, 187},
  {-321465600, -25200, 187},
  {-305737200, -21600, 187},
  {INT64_MIN, 0, 188},
  {-704937600, -21600, 188},
  {-147895200, -14400, 188},
  {-131565600, -21600, 188},
  {325670400, -18000, 188},
  {341391600, -21600, 188},
  {357120000, -18000, 188},
  {372841200, -21600, 188},
  {388569600, -18000, 188},
  {404895600, -21600, 188},
  {420019200, -18000, 188},
  {436345200, -21600, 188},
  {452073600, -18000, 188},
  {467794800, -21600, 188},
  {483523200, -18000, 188},
  {499244400, -21600, 188},
  {514972800, -18000, 188},
  {530694000, -21600, 188},
  {544608000, -18000, 188},
  {562143600, -21600, 188},
  {576057600, -18000, 188},
  {594198000, -21600, 188},
  {607507200, -18000, 188},
  {625647600, -21600, 188},
  {638956800, -18000, 188},
  {657097200, -21600, 188},
  {671011200, -18000, 188},
  {688546800, -21600, 188},
  {702460800, -18000, 188},
  {719996400, -21600, 188},
  {733910400, -18000, 188},
  {752050800, -21600, 188},
  {765360000, -18000, 188},
  {783500400, -21600, 188},
  {796809600, -18000, 188},
  {814950000, -21600, 188},
  {828864000, -18000, 188},
  {846399600, -21600, 188},
  {860313600, -18000, 188},
  {877849200, -21600, 188},
  {891763200, -18000, 188},
  {909298800, -21600, 188},
  {923212800, -18000, 188},
  {941353200, -21600, 188},
  {954662400, -18000, 188},
  {972802800, -18000, 188},
  {986112000, -18000, 188},
  {1004252400, -21600, 188},
  {1018166400, -18000, 188},
  {1035702000, -21600, 188},
  {1049616000, -18000, 188},
  {1067151600, -21600, 188},
  {1081065600, -18000, 188},
  {1099206000, -21600, 188},
  {1112515200, -18000, 188},
  {1130655600, -21600, 188},
  {1143964800, -18000, 188},
  {1162105200, -18000, 188},
  {1173600000, -18000, 188},
  {1194159600, -21600, 188},
  {1205049600, -18000, 188},
  {1225609200, -21600, 188},
  {1236499200, -18000, 188},
  {1257058800, -21600, 188},
  {1268553600, -18000, 188},
  {1289113200, -21600, 188},
  {1300003200, -18000, 188},
  {1320562800, -21600, 188},
  {1331452800, -18000, 188},
  {1352012400, -21600, 188},
  {1362902400, -18000, 188},
  {1383462000, -21600, 188},
  {1394352000, -18000, 188},
  {1414911600, -21600, 188},
  {1425801600, -18000, 188},
  {1446361200, -21600, 188},
  {1457856000, -18000, 188},
  {1478415600, -21600, 188},
  {1489305600, -18000, 188},
  {1509865200, -21600, 188},
  {1520755200, -18000, 188},
  {1541314800, -21600, 188},
  {1552204800, -18000, 188},
  {1572764400, -21600, 188},
  {1583654400, -18000, 188},
  {1604214000, -21600, 188},
  {1615708800, -18000, 188},
  {1636268400, -21600, 188},
  {1647158400, -18000, 188},
  {1667718000, -21600, 188},
  {1678608000, -18000, 188},
  {1699167600, -21600, 188},
  {1710057600, -18000, 188},
  {1730617200, -21600, 188},
  {1741507200, -18000, 188},
  {1762066800, -21600, 188},
  {1772956800, -18000, 188},
  {1793516400, -21600, 188},
  {1805011200, -18000, 188},
  {1825570800, -21600, 188},
  {1836460800, -18000, 188},
  {1857020400, -21600, 188},
  {1867910400, -18000, 188},
  {1888470000, -21600, 188},
  {1899360000, -18000, 188},
  {1919919600, -21600, 188},
  {1930809600, -18000, 188},
  {1951369200, -21600, 188},
  {1962864000, -18000, 188},
  {1983423600, -21600, 188},
  {1994313600, -18000, 188},
  {2014873200, -21600, 188},
  {2025763200, -18000, 188},
  {2046322800, -21600, 188},
  {2057212800, -18000, 188},
  {2077772400, -21600, 188},
  {2088662400, -18000, 188},
  {2109222000, -21600, 188},
  {2120112000, -18000, 188},
  {2140671600, -21600, 188},
  {INT64_MIN, -16272, 189},
  {-1767209328, -18000, 189},
  {-1206950400, -14400, 189},
  {-1191355200, -18000, 189},
  {-1175367600, -14400, 189},
  {-1159819200, -18000, 189},
  {-633812400, -14400, 189},
  {-622062000, -18000, 189},
  {-602276400, -14400, 189},
  {-591825600, -18000, 189},
  {-570740400, -14400, 189},
  {-560203200, -18000, 189},
  {-539118000, -14400, 189},
  {-531345600, -18000, 189},
  {-191358000, -14400, 189},
  {-184190400, -18000, 189},
  {-155156400, -14400, 189},
  {-150062400, -18000, 189},
  {-128890800, -14400, 189},
  {-121118400, -18000, 189},
  {-99946800, -14400, 189},
  {-89582400, -18000, 189},
  {-68410800, -14400, 189},
  {-57960000, -18000, 189},
  {499755600, -14400, 189},
  {511243200, -18000, 189},
  {530600400, -14400, 189},
  {540273600, -18000, 189},
  {562136400, -14400, 189},
  {571204800, -18000, 189},
  {1214283600, -14400, 189},
  {INT64_MIN, -15408, 190},
  {-1567453392, -14400, 190},
  {-1233432000, -10800, 190},
  {-1222981200, -14400, 190},
  {-1205956800, -10800, 190},
  {-1194037200, -14400, 190},
  {-1172865600, -10800, 190},
  {-1162501200, -14400, 190},
  {-1141329600, -10800, 190},
  {-1130965200, -14400, 190},
  {-1109793600, -10800, 190},
  {-1099429200, -14400, 190},
  {-1078257600, -10800, 190},
  {-1067806800, -14400, 190},
  {-1046635200, -10800, 190},
  {-1036270800, -14400, 190},
  {-1015099200, -10800, 190},
  {-1004734800, -14400, 190},
  {-983563200, -10800, 190},
  {-973198800, -14400, 190},
  {-952027200, -10800, 190},
  {-941576400, -14400, 190},
  {-931032000, -10800, 190},
  {-900882000, -14400, 190},
  {-890337600, -10800, 190},
  {-833749200, -14400, 190},
  {-827265600, -10800, 190},
  {-752274000, -14400, 190},
  {-733780800, -10800, 190},
  {-197326800, -14400, 190},
  {-190843200, -10800, 190},
  {-184194000, -14400, 190},
  {-164491200, -10800, 190},
  {-152658000, -14400, 190},
  {-132955200, -10800, 190},
  {-121122000, -14400, 190},
  {-101419200, -10800, 190},
  {-86821200, -14400, 190},
  {-71092800, -10800, 190},
  {-54766800, -14400, 190},
  {-39038400, -10800, 190},
  {-23317200, -14400, 190},
  {-7588800, -10800, 190},
  {128142000, -7200, 190},
  {136605600, -10800, 190},
  {596948400, -7200, 190},
  {605066400, -10800, 190},
  {624423600, -7200, 190},
  {636516000, -10800, 190},
  {656478000, -7200, 190},
  {667965600, -14400, 190},
  {687931200, -7200, 190},
  {699415200, -10800, 190},
  {719377200, -7200, 190},
  {731469600, -10800, 190},
  {938919600, -10800, 190},
  {952052400, -10800, 190},
  {1198983600, -7200, 190},
  {1205632800, -10800, 190},
  {1224385200, -7200, 190},
  {1237082400, -10800, 190},
  {INT64_MIN, -27568, 191},
  {-1514736000, -25200, 191},
  {-1451667600, -28800, 191},
  {-1343062800, -25200, 191},
  {-1234803600, -28800, 191},
  {-1222963200, -25200, 191},
  {-1207242000, -28800, 191},
  {-873820800, -25200, 191},
  {-769395600, -25200, 191},
  {-761677200, -28800, 191},
  {-686073600, -25200, 191},
  {-661539600, -28800, 191},
  {-495036000, -25200, 191},
  {-481734000, -28800, 191},
  {-463586400, -25200, 191},
  {-450284400, -28800, 191},
  {-431532000, -25200, 191},
  {-418230000, -28800, 191},
  {-400082400, -25200, 191},
  {-386780400, -28800, 191},
  {-368632800, -25200, 191},
  {-355330800, -28800, 191},
  {-337183200, -25200, 191},
  {-323881200, -28800, 191},
  {-305733600, -25200, 191},
  {-292431600, -28800, 191},
  {199274400, -25200, 191},
  {215600400, -28800, 191},
  {230724000, -25200, 191},
  {247050000, -28800, 191},
  {262778400, -25200, 191},
  {278499600, -28800, 191},
  {294228000, -25200, 191},
  {309949200, -28800, 191},
  {325677600, -25200, 191},
  {341398800, -28800, 191},
  {357127200, -25200, 191},
  {372848400, -28800, 191},
  {388576800, -25200, 191},
  {404902800, -28800, 191},
  {420026400, -25200, 191},
  {436352400, -28800, 191},
  {452080800, -25200, 191},
  {467802000, -28800, 191},
  {483530400, -25200, 191},
  {499251600, -28800, 191},
  {514980000, -25200, 191},
  {530701200, -28800, 191},
  {544615200, -25200, 191},
  {562150800, -28800, 191},
  {576064800, -25200, 191},
  {594205200, -28800, 191},
  {607514400, -25200, 191},
  {625654800, -28800, 191},
  {638964000, -25200, 191},
  {657104400, -28800, 191},
  {671018400, -25200, 191},
  {688554000, -28800, 191},
  {702468000, -25200, 191},
  {720003600, -28800, 191},
  {733917600, -25200, 191},
  {752058000, -28800, 191},
  {765367200, -25200, 191},
  {783507600, -28800, 191},
  {796816800, -25200, 191},
  {814957200, -28800, 191},
  {828871200, -25200, 191},
  {846406800, -28800, 191},
  {860320800, -25200, 191},
  {877856400, -28800, 191},
  {891770400, -25200, 191},
  {909306000, -28800, 191},
  {923220000, -25200, 191},
  {941360400, -28800, 191},
  {954669600, -25200, 191},
  {972810000, -28800, 191},
  {986119200, -25200, 191},
  {1004259600, -28800, 191},
  {1018173600, -25200, 191},
  {1035709200, -28800, 191},
  {1049623200, -25200, 191},
  {1067158800, -28800, 191},
  {1081072800, -25200, 191},
  {1099213200, -28800, 191},
  {1112522400, -25200, 191},
  {1130662800, -28800, 191},
  {1143972000, -25200, 191},
  {1162112400, -28800, 191},
  {1175421600, -25200, 191},
  {1193562000, -28800, 191},
  {1207476000, -25200, 191},
  {1225011600, -28800, 191},
  {1238925600, -25200, 191},
  {1256461200, -28800, 191},
  {1270375200, -25200, 191},
  {1288515600, -28800, 191},
  {1301824800, -25200, 191},
  {1319965200, -28800, 191},
  {1333274400, -25200, 191},
  {1351414800, -28800, 191},
  {1365328800, -25200, 191},
  {1382864400, -28800, 191},
  {1396778400, -25200, 191},
  {1414314000, -28800, 191},
  {1428228000, -25200, 191},
  {1445763600, -28800, 191},
  {1459677600, -25200, 191},
  {1477818000, -28800, 191},
  {1491127200, -25200, 191},
  {1509267600, -28800, 191},
  {1522576800, -25200, 191},
  {1540717200, -28800, 191},
  {1554631200, -25200, 191},
  {1572166800, -28800, 191},
  {1586080800, -25200, 191},
  {1603616400, -28800, 191},
  {1617530400, -25200, 191},
  {1635670800, -28800, 191},
  {1648980000, -25200, 191},
  {1667120400, -28800, 191},
  {1680429600, -25200, 191},
  {1698570000, -28800, 191},
  {1712484000, -25200, 191},
  {1730019600, -28800, 191},
  {1743933600, -25200, 191},
  {1761469200, -28800, 191},
  {1775383200, -25200, 191},
  {1792918800, -28800, 191},
  {1806832800, -25200, 191},
  {1824973200, -28800, 191},
  {1838282400, -25200, 191},
  {1856422800, -28800, 191},
  {1869732000, -25200, 191},
  {1887872400, -28800, 191},
  {1901786400, -25200, 191},
  {1919322000, -28800, 191},
  {1933236000, -25200, 191},
  {1950771600, -28800, 191},
  {1964685600, -25200, 191},
  {1982826000, -28800, 191},
  {1996135200, -25200, 191},
  {2014275600, -28800, 191},
  {2027584800, -25200, 191},
  {2045725200, -28800, 191},
  {2059034400, -25200, 191},
  {2077174800, -28800, 191},
  {2091088800, -25200, 191},
  {2108624400, -28800, 191},
  {2122538400, -25200, 191},
  {2140074000, -28800, 191},
  {INT64_MIN, -13128, 192},
  {-1767212472, -14400, 192},
  {-1206954000, -10800, 192},
  {-1191358800, -14400, 192},
  {-1175371200, -10800, 192},
  {-1159822800, -14400, 192},
  {-633816000, -10800, 192},
  {-622065600, -14400, 192},
  {-602280000, -10800, 192},
  {-591829200, -14400, 192},
  {-570744000, -10800, 192},
  {-560206800, -14400, 192},
  {-539121600, -10800, 192},
  {-531349200, -14400, 192},
  {-191361600, -10800, 192},
  {-184194000, -14400, 192},
  {-155160000, -10800, 192},
  {-150066000, -14400, 192},
  {-128894400, -10800, 192},
  {-121122000, -14400, 192},
  {-99950400, -10800, 192},
  {-89586000, -14400, 192},
  {-68414400, -10800, 192},
  {-57963600, -14400, 192},
  {499752000, -10800, 192},
  {511239600, -14400, 192},
  {530596800, -10800, 192},
  {540270000, -14400, 192},
  {562132800, -10800, 192},
  {571201200, -14400, 192},
  {1214280000, -10800, 192},
  {-1893439034, -18000, 193},
  {-1688410800, -16966, 193},
  {-1619983034, -14400, 193},
  {-1593806400, -16966, 193},
  {-1335986234, -14400, 193},
  {-1317585600, -18000, 193},
  {-1304362800, -14400, 193},
  {-1286049600, -18000, 193},
  {-1272826800, -14400, 193},
  {-1254513600, -18000, 193},
  {-1241290800, -14400, 193},
  {-1222977600, -18000, 193},
  {-1209754800, -14400, 193},
  {-1191355200, -18000, 193},
  {-1178132400, -14400, 193},
  {-870552000, -18000, 193},
  {-865278000, -14400, 193},
  {-736376400, -18000, 193},
  {-713646000, -14400, 193},
  {-36619200, -10800, 193},
  {-23922000, -14400, 193},
  {-3355200, -10800, 193},
  {7527600, -14400, 193},
  {24465600, -10800, 193},
  {37767600, -14400, 193},
  {55915200, -10800, 193},
  {69217200, -14400, 193},
  {87969600, -10800, 193},
  {100666800, -14400, 193},
  {118209600, -10800, 193},
  {132116400, -14400, 193},
  {150868800, -10800, 193},
  {163566000, -14400, 193},
  {182318400, -10800, 193},
  {195620400, -14400, 193},
  {213768000, -10800, 193},
  {227070000, -14400, 193},
  {245217600, -10800, 193},
  {258519600, -14400, 193},
  {277272000, -10800, 193},
  {289969200, -14400, 193},
  {308721600, -10800, 193},
  {321418800, -14400, 193},
  {340171200, -10800, 193},
  {353473200, -14400, 193},
  {371620800, -10800, 193},
  {384922800, -14400, 193},
  {403070400, -10800, 193},
  {416372400, -14400, 193},
  {434520000, -10800, 193},
  {447822000, -14400, 193},
  {466574400, -10800, 193},
  {479271600, -14400, 193},
  {498024000, -10800, 193},
  {510721200, -14400, 193},
  {529473600, -10800, 193},
  {545194800, -14400, 193},
  {560923200, -10800, 193},
  {574225200, -14400, 193},
  {591768000, -10800, 193},
  {605674800, -14400, 193},
  {624427200, -10800, 193},
  {637729200, -14400, 193},
  {653457600, -10800, 193},
  {668574000, -14400, 193},
  {687326400, -10800, 193},
  {700628400, -14400, 193},
  {718776000, -10800, 193},
  {732078000, -14400, 193},
  {750225600, -10800, 193},
  {763527600, -14400, 193},
  {781675200, -10800, 193},
  {794977200, -14400, 193},
  {813729600, -10800, 193},
  {826426800, -14400, 193},
  {845179200, -10800, 193},
  {859690800, -14400, 193},
  {876628800, -10800, 193},
  {889930800, -14400, 193},
  {906868800, -10800, 193},
  {923194800, -14400, 193},
  {939528000, -10800, 193},
  {952830000, -14400, 193},
  {971582400, -10800, 193},
  {984279600, -14400, 193},
  {1003032000, -10800, 193},
  {1015729200, -14400, 193},
  {1034481600, -10800, 193},
  {1047178800, -14400, 193},
  {1065931200, -10800, 193},
  {1079233200, -14400, 193},
  {1097380800, -10800, 193},
  {1110682800, -14400, 193},
  {1128830400, -10800, 193},
  {1142132400, -14400, 193},
  {1160884800, -10800, 193},
  {1173582000, -14400, 193},
  {1192334400, -10800, 193},
  {1206846000, -14400, 193},
  {1223784000, -10800, 193},
  {1237086000, -14400, 193},
  {1255233600, -10800, 193},
  {1270350000, -14400, 193},
  {1286683200, -10800, 193},
  {1304823600, -14400, 193},
  {1313899200, -10800, 193},
  {1331434800, -14400, 193},
  {1350187200, -10800, 193},
  {1362884400, -14400, 193},
  {1381636800, -10800, 193},
  {1394334000, -14400, 193},
  {1413086400, -10800, 193},
  {1426388400, -14400, 193},
  {1444536000, -10800, 193},
  {1457838000, -14400, 193},
  {1475985600, -10800, 193},
  {1489287600, -14400, 193},
  {1508040000, -10800, 193},
  {1520737200, -14400, 193},
  {1539489600, -10800, 193},
  {1552186800, -14400, 193},
  {1570939200, -10800, 193},
  {1584241200, -14400, 193},
  {1602388800, -10800, 193},
  {1615690800, -14400, 193},
  {1633838400, -10800, 193},
  {1647140400, -14400, 193},
  {1665288000, -10800, 193},
  {1678590000, -14400, 193},
  {1697342400, -10800, 193},
  {1710039600, -14400, 193},
  {1728792000, -10800, 193},
  {1741489200, -14400, 193},
  {1760241600, -10800, 193},
  {1773543600, -14400, 193},
  {1791691200, -10800, 193},
  {1804993200, -14400, 193},
  {1823140800, -10800, 193},
  {1836442800, -14400, 193},
  {1855195200, -10800, 193},
  {1867892400, -14400, 193},
  {1886644800, -10800, 193},
  {1899342000, -14400, 193},
  {1918094400, -10800, 193},
  {1930791600, -14400, 193},
  {1949544000, -10800, 193},
  {1962846000, -14400, 193},
  {1980993600, -10800, 193},
  {1994295600, -14400, 193},
  {2012443200, -10800, 193},
  {2025745200, -14400, 193},
  {2044497600, -10800, 193},
  {2057194800, -14400, 193},
  {2075947200, -10800, 193},
  {2088644400, -14400, 193},
  {2107396800, -10800, 193},
  {2120698800, -14400, 193},
  {2138846400, -10800, 193},
  {INT64_MIN, -16800, 194},
  {-1159773600, -18000, 194},
  {-100119600, -14400, 194},
  {-89668800, -18000, 194},
  {-5770800, -16200, 194},
  {4422600, -18000, 194},
  {25678800, -16200, 194},
  {33193800, -18000, 194},
  {57733200, -16200, 194},
  {64816200, -18000, 194},
  {89182800, -16200, 194},
  {96438600, -18000, 194},
  {120632400, -16200, 194},
  {127974600, -18000, 194},
  {152082000, -14400, 194},
  {972799200, -18000, 194},
  {975823200, -14400, 194},
  {INT64_MIN, -11188, 195},
  {-1767214412, -10800, 195},
  {-1206957600, -7200, 195},
  {-1191362400, -10800, 195},
  {-1175374800, -7200, 195},
  {-1159826400, -10800, 195},
  {-633819600, -7200, 195},
  {-622069200, -10800, 195},
  {-602283600, -7200, 195},
  {-591832800, -10800, 195},
  {-570747600, -7200, 195},
  {-560210400, -10800, 195},
  {-539125200, -7200, 195},
  {-531352800, -10800, 195},
  {-195426000, -7200, 195},
  {-184197600, -10800, 195},
  {-155163600, -7200, 195},
  {-150069600, -10800, 195},
  {-128898000, -7200, 195},
  {-121125600, -10800, 195},
  {-99954000, -7200, 195},
  {-89589600, -10800, 195},
  {-68418000, -7200, 195},
  {-57967200, -10800, 195},
  {499748400, -7200, 195},
  {511236000, -10800, 195},
  {530593200, -7200, 195},
  {540266400, -10800, 195},
  {562129200, -7200, 195},
  {571197600, -10800, 195},
  {592974000, -7200, 195},
  {602042400, -10800, 195},
  {624423600, -7200, 195},
  {634701600, -10800, 195},
  {656478000, -7200, 195},
  {666756000, -10800, 195},
  {687927600, -7200, 195},
  {697600800, -10800, 195},
  {719982000, -7200, 195},
  {728445600, -10800, 195},
  {750826800, -7200, 195},
  {761709600, -10800, 195},
  {782276400, -7200, 195},
  {793159200, -10800, 195},
  {813726000, -7200, 195},
  {824004000, -10800, 195},
  {844570800, -7200, 195},
  {856058400, -10800, 195},
  {876106800, -7200, 195},
  {888717600, -10800, 195},
  {908074800, -7200, 195},
  {919562400, -10800, 195},
  {938919600, -7200, 195},
  {951616800, -10800, 195},
  {970974000, -7200, 195},
  {982461600, -10800, 195},
  {1003028400, -7200, 195},
  {1013911200, -10800, 195},
  {1036292400, -7200, 195},
  {1045360800, -10800, 195},
  {1066532400, -7200, 195},
  {1076810400, -10800, 195},
  {1099364400, -7200, 195},
  {1108864800, -10800, 195},
  {1129431600, -7200, 195},
  {1140314400, -10800, 195},
  {1162695600, -7200, 195},
  {1172368800, -10800, 195},
  {1192330800, -7200, 195},
  {1203213600, -10800, 195},
  {1224385200, -7200, 195},
  {1234663200, -10800, 195},
  {1255834800, -7200, 195},
  {1266717600, -10800, 195},
  {1287284400, -7200, 195},
  {1298167200, -10800, 195},
  {1318734000, -7200, 195},
  {1330221600, -10800, 195},
  {1350788400, -7200, 195},
  {1361066400, -10800, 195},
  {1382238000, -7200, 195},
  {1392516000, -10800, 195},
  {1413687600, -7200, 195},
  {1424570400, -10800, 195},
  {1445137200, -7200, 195},
  {1456020000, -10800, 195},
  {1476586800, -7200, 195},
  {1487469600, -10800, 195},
  {1508036400, -7200, 195},
  {1518919200, -10800, 195},
  {1540090800, -7200, 195},
  {1550368800, -10800, 195},
  {1571540400, -7200, 195},
  {1581818400, -10800, 195},
  {1602990000, -7200, 195},
  {1613872800, -10800, 195},
  {1634439600, -7200, 195},
  {1645322400, -10800, 195},
  {1665889200, -7200, 195},
  {1677376800, -10800, 195},
  {1697338800, -7200, 195},
  {1708221600, -10800, 195},
  {1729393200, -7200, 195},
  {1739671200, -10800, 195},
  {1760842800, -7200, 195},
  {1771725600, -10800, 195},
  {1792292400, -7200, 195},
  {1803175200, -10800, 195},
  {1823742000, -7200, 195},
  {1834624800, -10800, 195},
  {1855191600, -7200, 195},
  {1866074400, -10800, 195},
  {1887246000, -7200, 195},
  {1897524000, -10800, 195},
  {1918695600, -7200, 195},
  {1928973600, -10800, 195},
  {1950145200, -7200, 195},
  {1960423200, -10800, 195},
  {1981594800, -7200, 195},
  {1992477600, -10800, 195},
  {2013044400, -7200, 195},
  {2024532000, -10800, 195},
  {2044494000, -7200, 195},
  {2055376800, -10800, 195},
  {2076548400, -7200, 195},
  {2086826400, -10800, 195},
  {2107998000, -7200, 195},
  {2118880800, -10800, 195},
  {2139447600, -7200, 195},
  {INT64_MIN, -5272, 196},
  {-1686090728, -7200, 196},
  {323841600, -3600, 196},
  {338961600, -7200, 196},
  {354679200, 0, 196},
  {370400400, -3600, 196},
  {386125200, 0, 196},
  {401850000, -3600, 196},
  {417574800, 0, 196},
  {433299600, -3600, 196},
  {449024400, 0, 196},
  {465354000, -3600, 196},
  {481078800, 0, 196},
  {496803600, -3600, 196},
  {512528400, 0, 196},
  {528253200, -3600, 196},
  {543978000, 0, 196},
  {559702800, -3600, 196},
  {575427600, 0, 196},
  {591152400, -3600, 196},
  {606877200, 0, 196},
  {622602000, -3600, 196},
  {638326800, 0, 196},
  {654656400, -3600, 196},
  {670381200, 0, 196},
  {686106000, -3600, 196},
  {701830800, 0, 196},
  {717555600, -3600, 196},
  {733280400, 0, 196},
  {749005200, -3600, 196},
  {764730000, 0, 196},
  {780454800, -3600, 196},
  {796179600, 0, 196},
  {811904400, -3600, 196},
  {828234000, 0, 196},
  {846378000, -3600, 196},
  {859683600, 0, 196},
  {877827600, -3600, 196},
  {891133200, 0, 196},
  {909277200, -3600, 196},
  {922582800, 0, 196},
  {941331600, -3600, 196},
  {954032400, 0, 196},
  {972781200, -3600, 196},
  {985482000, 0, 196},
  {1004230800, -3600, 196},
  {1017536400, 0, 196},
  {1035680400, -3600, 196},
  {1048986000, 0, 196},
  {1067130000, -3600, 196},
  {1080435600, 0, 196},
  {1099184400, -3600, 196},
  {1111885200, 0, 196},
  {1130634000, -3600, 196},
  {1143334800, 0, 196},
  {1162083600, -3600, 196},
  {1174784400, 0, 196},
  {1193533200, -3600, 196},
  {1206838800, 0, 196},
  {1224982800, -3600, 196},
  {1238288400, 0, 196},
  {1256432400, -3600, 196},
  {1269738000, 0, 196},
  {1288486800, -3600, 196},
  {1301187600, 0, 196},
  {1319936400, -3600, 196},
  {1332637200, 0, 196},
  {1351386000, -3600, 196},
  {1364691600, 0, 196},
  {1382835600, -3600, 196},
  {1396141200, 0, 196},
  {1414285200, -3600, 196},
  {1427590800, 0, 196},
  {1445734800, -3600, 196},
  {1459040400, 0, 196},
  {1477789200, -3600, 196},
  {1490490000, 0, 196},
  {1509238800, -3600, 196},
  {1521939600, 0, 196},
  {1540688400, -3600, 196},
  {1553994000, 0, 196},
  {1572138000, -3600, 196},
  {1585443600, 0, 196},
  {1603587600, -3600, 196},
  {1616893200, 0, 196},
  {1635642000, -3600, 196},
  {1648342800, 0, 196},
  {1667091600, -3600, 196},
  {1679792400, 0, 196},
  {1698541200, -3600, 196},
  {1711846800, 0, 196},
  {1729990800, -3600, 196},
  {1743296400, 0, 196},
  {1761440400, -3600, 196},
  {1774746000, 0, 196},
  {1792890000, -3600, 196},
  {1806195600, 0, 196},
  {1824944400, -3600, 196},
  {1837645200, 0, 196},
  {1856394000, -3600, 196},
  {1869094800, 0, 196},
  {1887843600, -3600, 196},
  {1901149200, 0, 196},
  {1919293200, -3600, 196},
  {1932598800, 0, 196},
  {1950742800, -3600, 196},
  {1964048400, 0, 196},
  {1982797200, -3600, 196},
  {1995498000, 0, 196},
  {2014246800, -3600, 196},
  {2026947600, 0, 196},
  {2045696400, -3600, 196},
  {2058397200, 0, 196},
  {2077146000, -3600, 196},
  {2090451600, 0, 196},
  {2108595600, -3600, 196},
  {2121901200, 0, 196},
  {2140045200, -3600, 196},
  {-1633273200, -21600, 197},
  {-1615132800, -25200, 197},
  {-1601823600, -21600, 197},
  {-1583683200, -25200, 197},
  {-1570374000, -21600, 197},
  {-1551628800, -25200, 197},
  {-1538924400, -21600, 197},
  {-1534089600, -25200, 197},
  {-880210800, -21600, 197},
  {-769395600, -21600, 197},
  {-765388800, -25200, 197},
  {-147884400, -21600, 197},
  {-131558400, -25200, 197},
  {-116434800, -21600, 197},
  {-100108800, -25200, 197},
  {-84380400, -21600, 197},
  {-68659200, -25200, 197},
  {-52930800, -21600, 197},
  {-37209600, -25200, 197},
  {-21481200, -21600, 197},
  {-5760000, -25200, 197},
  {9968400, -21600, 197},
  {25689600, -25200, 197},
  {41418000, -21600, 197},
  {57744000, -25200, 197},
  {73472400, -21600, 197},
  {89193600, -25200, 197},
  {104922000, -21600, 197},
  {120643200, -25200, 197},
  {126694800, -21600, 197},
  {152092800, -25200, 197},
  {162378000, -21600, 197},
  {183542400, -25200, 197},
  {199270800, -21600, 197},
  {215596800, -25200, 197},
  {230720400, -21600, 197},
  {247046400, -25200, 197},
  {262774800, -21600, 197},
  {278496000, -25200, 197},
  {294224400, -21600, 197},
  {309945600, -25200, 197},
  {325674000, -21600, 197},
  {341395200, -25200, 197},
  {357123600, -21600, 197},
  {372844800, -25200, 197},
  {388573200, -21600, 197},
  {404899200, -25200, 197},
  {420022800, -21600, 197},
  {436348800, -25200, 197},
  {452077200, -21600, 197},
  {467798400, -25200, 197},
  {483526800, -21600, 197},
  {499248000, -25200, 197},
  {514976400, -21600, 197},
  {530697600, -25200, 197},
  {544611600, -21600, 197},
  {562147200, -25200, 197},
  {576061200, -21600, 197},
  {594201600, -25200, 197},
  {607510800, -21600, 197},
  {625651200, -25200, 197},
  {638960400, -21600, 197},
  {657100800, -25200, 197},
  {671014800, -21600, 197},
  {688550400, -25200, 197},
  {702464400, -21600, 197},
  {720000000, -25200, 197},
  {733914000, -21600, 197},
  {752054400, -25200, 197},
  {765363600, -21600, 197},
  {783504000, -25200, 197},
  {796813200, -21600, 197},
  {814953600, -25200, 197},
  {828867600, -21600, 197},
  {846403200, -25200, 197},
  {860317200, -21600, 197},
  {877852800, -25200, 197},
  {891766800, -21600, 197},
  {909302400, -25200, 197},
  {923216400, -21600, 197},
  {941356800, -25200, 197},
  {954666000, -21600, 197},
  {972806400, -25200, 197},
  {986115600, -21600, 197},
  {1004256000, -25200, 197},
  {1018170000, -21600, 197},
  {1035705600, -25200, 197},
  {1049619600, -21600, 197},
  {1067155200, -25200, 197},
  {1081069200, -21600, 197},
  {1099209600, -25200, 197},
  {1112518800, -21600, 197},
  {1130659200, -25200, 197},
  {1143968400, -21600, 197},
  {1162108800, -25200, 197},
  {1173603600, -21600, 197},
  {1194163200, -25200, 197},
  {1205053200, -21600, 197},
  {1225612800, -25200, 197},
  {1236502800, -21600, 197},
  {1257062400, -25200, 197},
  {1268557200, -21600, 197},
  {1289116800, -25200, 197},
  {1300006800, -21600, 197},
  {1320566400, -25200, 197},
  {1331456400, -21600, 197},
  {1352016000, -25200, 197},
  {1362906000, -21600, 197},
  {1383465600, -25200, 197},
  {1394355600, -21600, 197},
  {1414915200, -25200, 197},
  {1425805200, -21600, 197},
  {1446364800, -25200, 197},
  {1457859600, -21600, 197},
  {1478419200, -25200, 197},
  {1489309200, -21600, 197},
  {1509868800, -25200, 197},
  {1520758800, -21600, 197},
  {1541318400, -25200, 197},
  {1552208400, -21600, 197},
  {1572768000, -25200, 197},
  {1583658000, -21600, 197},
  {1604217600, -25200, 197},
  {1615712400, -21600, 197},
  {1636272000, -25200, 197},
  {1647162000, -21600, 197},
  {1667721600, -25200, 197},
  {1678611600, -21600, 197},
  {1699171200, -25200, 197},
  {1710061200, -21600, 197},
  {1730620800, -25200, 197},
  {1741510800, -21600, 197},
  {1762070400, -25200, 197},
  {1772960400, -21600, 197},
  {1793520000, -25200, 197},
  {1805014800, -21600, 197},
  {1825574400, -25200, 197},
  {1836464400, -21600, 197},
  {1857024000, -25200, 197},
  {1867914000, -21600, 197},
  {1888473600, -25200, 197},
  {1899363600, -21600, 197},
  {1919923200, -25200, 197},
  {1930813200, -21600, 197},
  {1951372800, -25200, 197},
  {1962867600, -21600, 197},
  {1983427200, -25200, 197},
  {1994317200, -21600, 197},
  {2014876800, -25200, 197},
  {2025766800, -21600, 197},
  {2046326400, -25200, 197},
  {2057216400, -21600, 197},
  {2077776000, -25200, 197},
  {2088666000, -21600, 197},
  {2109225600, -25200, 197},
  {2120115600, -21600, 197},
  {2140675200, -25200, 197},
  {-880207200, -25200, 198},
  {-769395600, -25200, 198},
  {-765385200, -28800, 198},
  {-21477600, -25200, 198},
  {-5756400, -28800, 198},
  {9972000, -25200, 198},
  {25693200, -28800, 198},
  {41421600, -25200, 198},
  {57747600, -28800, 198},
  {73476000, -25200, 198},
  {89197200, -28800, 198},
  {104925600, -25200, 198},
  {120646800, -28800, 198},
  {126698400, -25200, 198},
  {152096400, -28800, 198},
  {162381600, -25200, 198},
  {183546000, -28800, 198},
  {199274400, -25200, 198},
  {215600400, -28800, 198},
  {230724000, -25200, 198},
  {247050000, -28800, 198},
  {262778400, -25200, 198},
  {278499600, -28800, 198},
  {294228000, -25200, 198},
  {309949200, -28800, 198},
  {325677600, -25200, 198},
  {341398800, -28800, 198},
  {357127200, -25200, 198},
  {372848400, -28800, 198},
  {388576800, -25200, 198},
  {404902800, -28800, 198},
  {420026400, -25200, 198},
  {436352400, -32400, 198},
  {439030800, -32400, 198},
  {452084400, -28800, 198},
  {467805600, -32400, 198},
  {483534000, -28800, 198},
  {499255200, -32400, 198},
  {514983600, -28800, 198},
  {530704800, -32400, 198},
  {544618800, -28800, 198},
  {562154400, -32400, 198},
  {576068400, -28800, 198},
  {594208800, -32400, 198},
  {607518000, -28800, 198},
  {625658400, -32400, 198},
  {638967600, -28800, 198},
  {657108000, -32400, 198},
  {671022000, -28800, 198},
  {688557600, -32400, 198},
  {702471600, -28800, 198},
  {720007200, -32400, 198},
  {733921200, -28800, 198},
  {752061600, -32400, 198},
  {765370800, -28800, 198},
  {783511200, -32400, 198},
  {796820400, -28800, 198},
  {814960800, -32400, 198},
  {828874800, -28800, 198},
  {846410400, -32400, 198},
  {860324400, -28800, 198},
  {877860000, -32400, 198},
  {891774000, -28800, 198},
  {909309600, -32400, 198},
  {923223600, -28800, 198},
  {941364000, -32400, 198},
  {954673200, -28800, 198},
  {972813600, -32400, 198},
  {986122800, -28800, 198},
  {1004263200, -32400, 198},
  {1018177200, -28800, 198},
  {1035712800, -32400, 198},
  {1049626800, -28800, 198},
  {1067162400, -32400, 198},
  {1081076400, -28800, 198},
  {1099216800, -32400, 198},
  {1112526000, -28800, 198},
  {1130666400, -32400, 198},
  {1143975600, -28800, 198},
  {1162116000, -32400, 198},
  {1173610800, -28800, 198},
  {1194170400, -32400, 198},
  {1205060400, -28800, 198},
  {1225620000, -32400, 198},
  {1236510000, -28800, 198},
  {1257069600, -32400, 198},
  {1268564400, -28800, 198},
  {1289124000, -32400, 198},
  {1300014000, -28800, 198},
  {1320573600, -32400, 198},
  {1331463600, -28800, 198},
  {1352023200, -32400, 198},
  {1362913200, -28800, 198},
  {1383472800, -32400, 198},
  {1394362800, -28800, 198},
  {1414922400, -32400, 198},
  {1425812400, -28800, 198},
  {1446372000, -32400, 198},
  {1457866800, -28800, 198},
  {1478426400, -32400, 198},
  {1489316400, -28800, 198},
  {1509876000, -32400, 198},
  {1520766000, -28800, 198},
  {1541325600, -32400, 198},
  {1552215600, -28800, 198},
  {1572775200, -32400, 198},
  {1583665200, -28800, 198},
  {1604224800, -32400, 198},
  {1615719600, -28800, 198},
  {1636279200, -32400, 198},
  {1647169200, -28800, 198},
  {1667728800, -32400, 198},
  {1678618800, -28800, 198},
  {1699178400, -32400, 198},
  {1710068400, -28800, 198},
  {1730628000, -32400, 198},
  {1741518000, -28800, 198},
  {1762077600, -32400, 198},
  {1772967600, -28800, 198},
  {1793527200, -32400, 198},
  {1805022000, -28800, 198},
  {1825581600, -32400, 198},
  {1836471600, -28800, 198},
  {1857031200, -32400, 198},
  {1867921200, -28800, 198},
  {1888480800, -32400, 198},
  {1899370800, -28800, 198},
  {1919930400, -32400, 198},
  {1930820400, -28800, 198},
  {1951380000, -32400, 198},
  {1962874800, -28800, 198},
  {1983434400, -32400, 198},
  {1994324400, -28800, 198},
  {2014884000, -32400, 198},
  {2025774000, -28800, 198},
  {2046333600, -32400, 198},
  {2057223600, -28800, 198},
  {2077783200, -32400, 198},
  {2088673200, -28800, 198},
  {2109232800, -32400, 198},
  {2120122800, -28800, 198},
  {2140682400, -32400, 198},
  {INT64_MIN, -14768, 199},
  {-1848254032, -14400, 199},
  {-1664130548, -9052, 200},
  {-1650137348, -12652, 200},
  {-1632076148, -9052, 200},
  {-1614799748, -12652, 200},
  {-1598650148, -9052, 200},
  {-1590100148, -12652, 200},
  {-1567286948, -9052, 200},
  {-1551565748, -12652, 200},
  {-1535837348, -9052, 200},
  {-1520116148, -12652, 200},
  {-1503782948, -9052, 200},
  {-1488666548, -12652, 200},
  {-1472333348, -9052, 200},
  {-1457216948, -12652, 200},
  {-1440883748, -9052, 200},
  {-1425767348, -12652, 200},
  {-1409434148, -9052, 200},
  {-1394317748, -12652, 200},
  {-1377984548, -9052, 200},
  {-1362263348, -12652, 200},
  {-1346534948, -9052, 200},
  {-1330813748, -12652, 200},
  {-1314480548, -9052, 200},
  {-1299364148, -12652, 200},
  {-1283030948, -9052, 200},
  {-1267914548, -12652, 200},
  {-1251581348, -9052, 200},
  {-1236464948, -12652, 200},
  {-1220131748, -9052, 200},
  {-1205015348, -12652, 200},
  {-1188682148, -9052, 200},
  {-1172960948, -12652, 200},
  {-1156627748, -9052, 200},
  {-1141511348, -12652, 200},
  {-1125178148, -9052, 200},
  {-1110061748, -12652, 200},
  {-1096921748, -12600, 200},
  {-1093728600, -9000, 200},
  {-1078612200, -12600, 200},
  {-1061670600, -9000, 200},
  {-1048973400, -12600, 200},
  {-1030221000, -9000, 200},
  {-1017523800, -12600, 200},
  {-998771400, -9000, 200},
  {-986074200, -12600, 200},
  {-966717000, -9000, 200},
  {-954624600, -12600, 200},
  {-935267400, -9000, 200},
  {-922570200, -12600, 200},
  {-903817800, -9000, 200},
  {-891120600, -12600, 200},
  {-872368200, -9000, 200},
  {-769395600, -9000, 200},
  {-765401400, -12600, 200},
  {-746044200, -9000, 200},
  {-733347000, -12600, 200},
  {-714594600, -9000, 200},
  {-701897400, -12600, 200},
  {-683145000, -9000, 200},
  {-670447800, -12600, 200},
  {-651695400, -9000, 200},
  {-638998200, -12600, 200},
  {-619641000, -9000, 200},
  {-606943800, -12600, 200},
  {-589401000, -9000, 200},
  {-576099000, -12600, 200},
  {-557951400, -9000, 200},
  {-544649400, -12600, 200},
  {-526501800, -9000, 200},
  {-513199800, -12600, 200},
  {-495052200, -9000, 200},
  {-481750200, -12600, 200},
  {-463602600, -9000, 200},
  {-450300600, -12600, 200},
  {-431548200, -9000, 200},
  {-418246200, -12600, 200},
  {-400098600, -9000, 200},
  {-386796600, -12600, 200},
  {-368649000, -9000, 200},
  {-355347000, -12600, 200},
  {-337199400, -9000, 200},
  {-323897400, -12600, 200},
  {-305749800, -9000, 200},
  {-289423800, -12600, 200},
  {-273695400, -9000, 200},
  {-257974200, -12600, 200},
  {-242245800, -9000, 200},
  {-226524600, -12600, 200},
  {-210796200, -9000, 200},
  {-195075000, -12600, 200},
  {-179346600, -9000, 200},
  {-163625400, -12600, 200},
  {-147897000, -9000, 200},
  {-131571000, -12600, 200},
  {-116447400, -9000, 200},
  {-100121400, -12600, 200},
  {-84393000, -9000, 200},
  {-68671800, -12600, 200},
  {-52943400, -9000, 200},
  {-37222200, -12600, 200},
  {-21493800, -9000, 200},
  {-5772600, -12600, 200},
  {9955800, -9000, 200},
  {25677000, -12600, 200},
  {41405400, -9000, 200},
  {57731400, -12600, 200},
  {73459800, -9000, 200},
  {89181000, -12600, 200},
  {104909400, -9000, 200},
  {120630600, -12600, 200},
  {136359000, -9000, 200},
  {152080200, -12600, 200},
  {167808600, -9000, 200},
  {183529800, -12600, 200},
  {199258200, -9000, 200},
  {215584200, -12600, 200},
  {230707800, -9000, 200},
  {247033800, -12600, 200},
  {262762200, -9000, 200},
  {278483400, -12600, 200},
  {294211800, -9000, 200},
  {309933000, -12600, 200},
  {325661400, -9000, 200},
  {341382600, -12600, 200},
  {357111000, -9000, 200},
  {372832200, -12600, 200},
  {388560600, -9000, 200},
  {404886600, -12600, 200},
  {420010200, -9000, 200},
  {436336200, -12600, 200},
  {452064600, -9000, 200},
  {467785800, -12600, 200},
  {483514200, -9000, 200},
  {499235400, -12600, 200},
  {514963800, -9000, 200},
  {530685000, -12600, 200},
  {544591860, -9000, 200},
  {562127460, -12600, 200},
  {576041460, -5400, 200},
  {594178260, -12600, 200},
  {607491060, -9000, 200},
  {625631460, -12600, 200},
  {638940660, -9000, 200},
  {657081060, -12600, 200},
  {670995060, -9000, 200},
  {688530660, -12600, 200},
  {702444660, -9000, 200},
  {719980260, -12600, 200},
  {733894260, -9000, 200},
  {752034660, -12600, 200},
  {765343860, -9000, 200},
  {783484260, -12600, 200},
  {796793460, -9000, 200},
  {814933860, -12600, 200},
  {828847860, -9000, 200},
  {846383460, -12600, 200},
  {860297460, -9000, 200},
  {877833060, -12600, 200},
  {891747060, -9000, 200},
  {909282660, -12600, 200},
  {923196660, -9000, 200},
  {941337060, -12600, 200},
  {954646260, -9000, 200},
  {972786660, -12600, 200},
  {986095860, -9000, 200},
  {1004236260, -12600, 200},
  {1018150260, -9000, 200},
  {1035685860, -12600, 200},
  {1049599860, -9000, 200},
  {1067135460, -12600, 200},
  {1081049460, -9000, 200},
  {1099189860, -12600, 200},
  {1112499060, -9000, 200},
  {1130639460, -12600, 200},
  {1143948660, -9000, 200},
  {1162089060, -12600, 200},
  {1173583860, -9000, 200},
  {1194143460, -12600, 200},
  {1205033460, -9000, 200},
  {1225593060, -12600, 200},
  {1236483060, -9000, 200},
  {1257042660, -12600, 200},
  {1268537460, -9000, 200},
  {1289097060, -12600, 200},
  {1299987060, -9000, 200},
  {1320553800, -12600, 200},
  {1331443800, -9000, 200},
  {1352003400, -12600, 200},
  {1362893400, -9000, 200},
  {1383453000, -12600, 200},
  {1394343000, -9000, 200},
  {1414902600, -12600, 200},
  {1425792600, -9000, 200},
  {1446352200, -12600, 200},
  {1457847000, -9000, 200},
  {1478406600, -12600, 200},
  {1489296600, -9000, 200},
  {1509856200, -12600, 200},
  {1520746200, -9000, 200},
  {1541305800, -12600, 200},
  {1552195800, -9000, 200},
  {1572755400, -12600, 200},
  {1583645400, -9000, 200},
  {1604205000, -12600, 200},
  {1615699800, -9000, 200},
  {1636259400, -12600, 200},
  {1647149400, -9000, 200},
  {1667709000, -12600, 200},
  {1678599000, -9000, 200},
  {1699158600, -12600, 200},
  {1710048600, -9000, 200},
  {1730608200, -12600, 200},
  {1741498200, -9000, 200},
  {1762057800, -12600, 200},
  {1772947800, -9000, 200},
  {1793507400, -12600, 200},
  {1805002200, -9000, 200},
  {1825561800, -12600, 200},
  {1836451800, -9000, 200},
  {1857011400, -12600, 200},
  {1867901400, -9000, 200},
  {1888461000, -12600, 200},
  {1899351000, -9000, 200},
  {1919910600, -12600, 200},
  {1930800600, -9000, 200},
  {1951360200, -12600, 200},
  {1962855000, -9000, 200},
  {1983414600, -12600, 200},
  {1994304600, -9000, 200},
  {2014864200, -12600, 200},
  {2025754200, -9000, 200},
  {2046313800, -12600, 200},
  {2057203800, -9000, 200},
  {2077763400, -12600, 200},
  {2088653400, -9000, 200},
  {2109213000, -12600, 200},
  {2120103000, -9000, 200},
  {2140662600, -12600, 200},
  {INT64_MIN, -15052, 201},
  {-1825098548, -14400, 201},
  {INT64_MIN, -14640, 202},
  {-1830369360, -14400, 202},
  {INT64_MIN, -15584, 203},
  {-1846266016, -14400, 203},
  {INT64_MIN, -14696, 204},
  {-1830369304, -14400, 204},
  {INT64_MIN, -25880, 205},
  {-2030201320, -25200, 205},
  {-1632063600, -21600, 205},
  {-1614787200, -25200, 205},
  {-880210800, -21600, 205},
  {-769395600, -21600, 205},
  {-765388800, -25200, 205},
  {-747241200, -21600, 205},
  {-732729600, -25200, 205},
  {-715791600, -21600, 205},
  {-702489600, -25200, 205},
  {-684342000, -21600, 205},
  {-671040000, -25200, 205},
  {-652892400, -21600, 205},
  {-639590400, -25200, 205},
  {-400086000, -21600, 205},
  {-384364800, -25200, 205},
  {-337186800, -21600, 205},
  {-321465600, -25200, 205},
  {-305737200, -21600, 205},
  {-292435200, -25200, 205},
  {-273682800, -21600, 205},
  {-260985600, -25200, 205},
  {73472400, -21600, 205},
  {INT64_MIN, -20932, 206},
  {-1538503868, -21600, 206},
  {547020000, -18000, 206},
  {559717200, -21600, 206},
  {578469600, -18000, 206},
  {591166800, -21600, 206},
  {1146981600, -18000, 206},
  {1154926800, -21600, 206},
  {INT64_MIN, -16508, 207},
  {-1686079492, -14400, 207},
  {670399200, -10800, 207},
  {686120400, -14400, 207},
  {701848800, -10800, 207},
  {717570000, -14400, 207},
  {733903200, -10800, 207},
  {752043600, -14400, 207},
  {765352800, -10800, 207},
  {783493200, -14400, 207},
  {796802400, -10800, 207},
  {814942800, -14400, 207},
  {828856800, -10800, 207},
  {846392400, -14400, 207},
  {860306400, -10800, 207},
  {877842000, -14400, 207},
  {891756000, -10800, 207},
  {909291600, -14400, 207},
  {923205600, -10800, 207},
  {941346000, -14400, 207},
  {954655200, -10800, 207},
  {972795600, -14400, 207},
  {986104800, -10800, 207},
  {1004245200, -14400, 207},
  {1018159200, -10800, 207},
  {1035694800, -14400, 207},
  {1049608800, -10800, 207},
  {1067144400, -14400, 207},
  {1081058400, -10800, 207},
  {1099198800, -14400, 207},
  {1112508000, -10800, 207},
  {1130648400, -14400, 207},
  {1143957600, -10800, 207},
  {1162098000, -14400, 207},
  {1173592800, -10800, 207},
  {1194152400, -14400, 207},
  {1205042400, -10800, 207},
  {1225602000, -14400, 207},
  {1236492000, -10800, 207},
  {1257051600, -14400, 207},
  {1268546400, -10800, 207},
  {1289106000, -14400, 207},
  {1299996000, -10800, 207},
  {1320555600, -14400, 207},
  {1331445600, -10800, 207},
  {1352005200, -14400, 207},
  {1362895200, -10800, 207},
  {1383454800, -14400, 207},
  {1394344800, -10800, 207},
  {1414904400, -14400, 207},
  {1425794400, -10800, 207},
  {1446354000, -14400, 207},
  {1457848800, -10800, 207},
  {1478408400, -14400, 207},
  {1489298400, -10800, 207},
  {1509858000, -14400, 207},
  {1520748000, -10800, 207},
  {1541307600, -14400, 207},
  {1552197600, -10800, 207},
  {1572757200, -14400, 207},
  {1583647200, -10800, 207},
  {1604206800, -14400, 207},
  {1615701600, -10800, 207},
  {1636261200, -14400, 207},
  {1647151200, -10800, 207},
  {1667710800, -14400, 207},
  {1678600800, -10800, 207},
  {1699160400, -14400, 207},
  {1710050400, -10800, 207},
  {1730610000, -14400, 207},
  {1741500000, -10800, 207},
  {1762059600, -14400, 207},
  {1772949600, -10800, 207},
  {1793509200, -14400, 207},
  {1805004000, -10800, 207},
  {1825563600, -14400, 207},
  {1836453600, -10800, 207},
  {1857013200, -14400, 207},
  {1867903200, -10800, 207},
  {1888462800, -14400, 207},
  {1899352800, -10800, 207},
  {1919912400, -14400, 207},
  {1930802400, -10800, 207},
  {1951362000, -14400, 207},
  {1962856800, -10800, 207},
  {1983416400, -14400, 207},
  {1994306400, -10800, 207},
  {2014866000, -14400, 207},
  {2025756000, -10800, 207},
  {2046315600, -14400, 207},
  {2057205600, -10800, 207},
  {2077765200, -14400, 207},
  {2088655200, -10800, 207},
  {2109214800, -14400, 207},
  {2120104800, -10800, 207},
  {2140664400, -14400, 207},
  {INT64_MIN, -21600, 208},
  {-1893434400, -18000, 208},
  {-880218000, -14400, 208},
  {-769395600, -14400, 208},
  {-765396000, -18000, 208},
  {9961200, -14400, 208},
  {25682400, -18000, 208},
  {41410800, -14400, 208},
  {57736800, -18000, 208},
  {73465200, -14400, 208},
  {89186400, -18000, 208},
  {136364400, -14400, 208},
  {152085600, -18000, 208},
  {167814000, -14400, 208},
  {183535200, -18000, 208},
  {199263600, -14400, 208},
  {215589600, -18000, 208},
  {230713200, -14400, 208},
  {247039200, -18000, 208},
  {262767600, -14400, 208},
  {278488800, -18000, 208},
  {294217200, -14400, 208},
  {309938400, -18000, 208},
  {325666800, -14400, 208},
  {341388000, -18000, 208},
  {357116400, -14400, 208},
  {372837600, -18000, 208},
  {388566000, -14400, 208},
  {404892000, -18000, 208},
  {420015600, -14400, 208},
  {436341600, -18000, 208},
  {452070000, -14400, 208},
  {467791200, -18000, 208},
  {483519600, -14400, 208},
  {499240800, -18000, 208},
  {514969200, -14400, 208},
  {530690400, -18000, 208},
  {544604400, -14400, 208},
  {562140000, -18000, 208},
  {576054000, -14400, 208},
  {594194400, -18000, 208},
  {607503600, -14400, 208},
  {625644000, -18000, 208},
  {638953200, -14400, 208},
  {657093600, -18000, 208},
  {671007600, -14400, 208},
  {688543200, -18000, 208},
  {702457200, -14400, 208},
  {719992800, -18000, 208},
  {733906800, -14400, 208},
  {752047200, -18000, 208},
  {765356400, -14400, 208},
  {783496800, -18000, 208},
  {796806000, -14400, 208},
  {814946400, -18000, 208},
  {828860400, -14400, 208},
  {846396000, -18000, 208},
  {860310000, -14400, 208},
  {877845600, -18000, 208},
  {891759600, -14400, 208},
  {909295200, -18000, 208},
  {923209200, -14400, 208},
  {941349600, -18000, 208},
  {954658800, -14400, 208},
  {972799200, -18000, 208},
  {986108400, -14400, 208},
  {1004248800, -18000, 208},
  {1018162800, -14400, 208},
  {1035698400, -18000, 208},
  {1049612400, -14400, 208},
  {1067148000, -18000, 208},
  {1081062000, -14400, 208},
  {1099202400, -18000, 208},
  {1112511600, -14400, 208},
  {1130652000, -18000, 208},
  {1143961200, -14400, 208},
  {1162101600, -18000, 208},
  {1173596400, -14400, 208},
  {1194156000, -18000, 208},
  {1205046000, -14400, 208},
  {1225605600, -18000, 208},
  {1236495600, -14400, 208},
  {1257055200, -18000, 208},
  {1268550000, -14400, 208},
  {1289109600, -18000, 208},
  {1299999600, -14400, 208},
  {1320559200, -18000, 208},
  {1331449200, -14400, 208},
  {1352008800, -18000, 208},
  {1362898800, -14400, 208},
  {1383458400, -18000, 208},
  {1394348400, -14400, 208},
  {1414908000, -18000, 208},
  {1425798000, -14400, 208},
  {1446357600, -18000, 208},
  {1457852400, -14400, 208},
  {1478412000, -18000, 208},
  {1489302000, -14400, 208},
  {1509861600, -18000, 208},
  {1520751600, -14400, 208},
  {1541311200, -18000, 208},
  {1552201200, -14400, 208},
  {1572760800, -18000, 208},
  {1583650800, -14400, 208},
  {1604210400, -18000, 208},
  {1615705200, -14400, 208},
  {1636264800, -18000, 208},
  {1647154800, -14400, 208},
  {1667714400, -18000, 208},
  {1678604400, -14400, 208},
  {1699164000, -18000, 208},
  {1710054000, -14400, 208},
  {1730613600, -18000, 208},
  {1741503600, -14400, 208},
  {1762063200, -18000, 208},
  {1772953200, -14400, 208},
  {1793512800, -18000, 208},
  {1805007600, -14400, 208},
  {1825567200, -18000, 208},
  {1836457200, -14400, 208},
  {1857016800, -18000, 208},
  {1867906800, -14400, 208},
  {1888466400, -18000, 208},
  {1899356400, -14400, 208},
  {1919916000, -18000, 208},
  {1930806000, -14400, 208},
  {1951365600, -18000, 208},
  {1962860400, -14400, 208},
  {1983420000, -18000, 208},
  {1994310000, -14400, 208},
  {2014869600, -18000, 208},
  {2025759600, -14400, 208},
  {2046319200, -18000, 208},
  {2057209200, -14400, 208},
  {2077768800, -18000, 208},
  {2088658800, -14400, 208},
  {2109218400, -18000, 208},
  {2120108400, -14400, 208},
  {2140668000, -18000, 208},
  {INT64_MIN, -28084, 209},
  {-1514736000, -25200, 209},
  {-1451667600, -28800, 209},
  {-1343062800, -25200, 209},
  {-1234803600, -28800, 209},
  {-1222963200, -25200, 209},
  {-1207242000, -28800, 209},
  {-873820800, -25200, 209},
  {-769395600, -25200, 209},
  {-761677200, -28800, 209},
  {-686073600, -25200, 209},
  {-661539600, -28800, 209},
  {-495036000, -25200, 209},
  {-481734000, -28800, 209},
  {-463586400, -25200, 209},
  {-450284400, -28800, 209},
  {-431532000, -25200, 209},
  {-418230000, -28800, 209},
  {-400082400, -25200, 209},
  {-386780400, -28800, 209},
  {-368632800, -25200, 209},
  {-355330800, -28800, 209},
  {-337183200, -25200, 209},
  {-323881200, -28800, 209},
  {-305733600, -25200, 209},
  {-292431600, -28800, 209},
  {199274400, -25200, 209},
  {215600400, -28800, 209},
  {230724000, -25200, 209},
  {247050000, -28800, 209},
  {262778400, -25200, 209},
  {278499600, -28800, 209},
  {294228000, -25200, 209},
  {309949200, -28800, 209},
  {325677600, -25200, 209},
  {341398800, -28800, 209},
  {357127200, -25200, 209},
  {372848400, -28800, 209},
  {388576800, -25200, 209},
  {404902800, -28800, 209},
  {420026400, -25200, 209},
  {436352400, -28800, 209},
  {452080800, -25200, 209},
  {467802000, -28800, 209},
  {483530400, -25200, 209},
  {499251600, -28800, 209},
  {514980000, -25200, 209},
  {530701200, -28800, 209},
  {544615200, -25200, 209},
  {562150800, -28800, 209},
  {576064800, -25200, 209},
  {594205200, -28800, 209},
  {607514400, -25200, 209},
  {625654800, -28800, 209},
  {638964000, -25200, 209},
  {657104400, -28800, 209},
  {671018400, -25200, 209},
  {688554000, -28800, 209},
  {702468000, -25200, 209},
  {720003600, -28800, 209},
  {733917600, -25200, 209},
  {752058000, -28800, 209},
  {765367200, -25200, 209},
  {783507600, -28800, 209},
  {796816800, -25200, 209},
  {814957200, -28800, 209},
  {828871200, -25200, 209},
  {846406800, -28800, 209},
  {860320800, -25200, 209},
  {877856400, -28800, 209},
  {891770400, -25200, 209},
  {909306000, -28800, 209},
  {923220000, -25200, 209},
  {941360400, -28800, 209},
  {954669600, -25200, 209},
  {972810000, -28800, 209},
  {986119200, -25200, 209},
  {1004259600, -28800, 209},
  {1018173600, -25200, 209},
  {1035709200, -28800, 209},
  {1049623200, -25200, 209},
  {1067158800, -28800, 209},
  {1081072800, -25200, 209},
  {1099213200, -28800, 209},
  {1112522400, -25200, 209},
  {1130662800, -28800, 209},
  {1143972000, -25200, 209},
  {1162112400, -28800, 209},
  {1175421600, -25200, 209},
  {1193562000, -28800, 209},
  {1207476000, -25200, 209},
  {1225011600, -28800, 209},
  {1238925600, -25200, 209},
  {1256461200, -28800, 209},
  {1268560800, -25200, 209},
  {1289120400, -28800, 209},
  {1300010400, -25200, 209},
  {1320570000, -28800, 209},
  {1331460000, -25200, 209},
  {1352019600, -28800, 209},
  {1362909600, -25200, 209},
  {1383469200, -28800, 209},
  {1394359200, -25200, 209},
  {1414918800, -28800, 209},
  {1425808800, -25200, 209},
  {1446368400, -28800, 209},
  {1457863200, -25200, 209},
  {1478422800, -28800, 209},
  {1489312800, -25200, 209},
  {1509872400, -28800, 209},
  {1520762400, -25200, 209},
  {1541322000, -28800, 209},
  {1552212000, -25200, 209},
  {1572771600, -28800, 209},
  {1583661600, -25200, 209},
  {1604221200, -28800, 209},
  {1615716000, -25200, 209},
  {1636275600, -28800, 209},
  {1647165600, -25200, 209},
  {1667725200, -28800, 209},
  {1678615200, -25200, 209},
  {1699174800, -28800, 209},
  {1710064800, -25200, 209},
  {1730624400, -28800, 209},
  {1741514400, -25200, 209},
  {1762074000, -28800, 209},
  {1772964000, -25200, 209},
  {1793523600, -28800, 209},
  {1805018400, -25200, 209},
  {1825578000, -28800, 209},
  {1836468000, -25200, 209},
  {1857027600, -28800, 209},
  {1867917600, -25200, 209},
  {1888477200, -28800, 209},
  {1899367200, -25200, 209},
  {1919926800, -28800, 209},
  {1930816800, -25200, 209},
  {1951376400, -28800, 209},
  {1962871200, -25200, 209},
  {1983430800, -28800, 209},
  {1994320800, -25200, 209},
  {2014880400, -28800, 209},
  {2025770400, -25200, 209},
  {2046330000, -28800, 209},
  {2057220000, -25200, 209},
  {2077779600, -28800, 209},
  {2088669600, -25200, 209},
  {2109229200, -28800, 209},
  {2120119200, -25200, 209},
  {2140678800, -28800, 209},
  {-1632070800, -14400, 210},
  {-1614794400, -18000, 210},
  {-1601753400, -14400, 210},
  {-1583697600, -18000, 210},
  {-1567357200, -14400, 210},
  {-1554667200, -18000, 210},
  {-1534698000, -14400, 210},
  {-1524074400, -18000, 210},
  {-1503248400, -14400, 210},
  {-1492365600, -18000, 210},
  {-1471798800, -14400, 210},
  {-1460916000, -18000, 210},
  {-1440954000, -14400, 210},
  {-1428861600, -18000, 210},
  {-1409504400, -14400, 210},
  {-1397412000, -18000, 210},
  {-1378054800, -14400, 210},
  {-1365962400, -18000, 210},
  {-1346605200, -14400, 210},
  {-1333908000, -18000, 210},
  {-1315155600, -14400, 210},
  {-1301853600, -18000, 210},
  {-1283706000, -14400, 210},
  {-1270404000, -18000, 210},
  {-1252256400, -14400, 210},
  {-1238954400, -18000, 210},
  {-1220806800, -14400, 210},
  {-1207504800, -18000, 210},
  {-1188752400, -14400, 210},
  {-1176055200, -18000, 210},
  {-1157302800, -14400, 210},
  {-1144000800, -18000, 210},
  {-1125853200, -14400, 210},
  {-1112551200, -18000, 210},
  {-1094403600, -14400, 210},
  {-1081101600, -18000, 210},
  {-1062954000, -14400, 210},
  {-1049652000, -18000, 210},
  {-1031504400, -14400, 210},
  {-1018202400, -18000, 210},
  {-1000054800, -14400, 210},
  {-986752800, -18000, 210},
  {-968000400, -14400, 210},
  {-955303200, -18000, 210},
  {-936550800, -14400, 210},
  {-880218000, -14400, 210},
  {-769395600, -14400, 210},
  {-765396000, -18000, 210},
  {-747248400, -14400, 210},
  {-733946400, -18000, 210},
  {-715806000, -14400, 210},
  {-702504000, -18000, 210},
  {-684356400, -14400, 210},
  {-671054400, -18000, 210},
  {-652906800, -14400, 210},
  {-634161600, -18000, 210},
  {-620845200, -14400, 210},
  {-602704800, -18000, 210},
  {-589395600, -14400, 210},
  {-576093600, -18000, 210},
  {-557946000, -14400, 210},
  {-544644000, -18000, 210},
  {-526496400, -14400, 210},
  {-513194400, -18000, 210},
  {-495046800, -14400, 210},
  {-481744800, -18000, 210},
  {-463597200, -14400, 210},
  {-450295200, -18000, 210},
  {-431542800, -14400, 210},
  {-418240800, -18000, 210},
  {-400093200, -14400, 210},
  {-384372000, -18000, 210},
  {-368643600, -14400, 210},
  {-352922400, -18000, 210},
  {-337194000, -14400, 210},
  {-321472800, -18000, 210},
  {-305744400, -14400, 210},
  {-289418400, -18000, 210},
  {-273690000, -14400, 210},
  {-257968800, -18000, 210},
  {-242240400, -14400, 210},
  {-226519200, -18000, 210},
  {-210790800, -14400, 210},
  {-195069600, -18000, 210},
  {-179341200, -14400, 210},
  {-163620000, -18000, 210},
  {-147891600, -14400, 210},
  {-131565600, -18000, 210},
  {-116442000, -14400, 210},
  {-100116000, -18000, 210},
  {-84387600, -14400, 210},
  {-68666400, -18000, 210},
  {-52938000, -14400, 210},
  {-37216800, -18000, 210},
  {-21488400, -14400, 210},
  {-5767200, -18000, 210},
  {9961200, -14400, 210},
  {25682400, -18000, 210},
  {41410800, -14400, 210},
  {57736800, -18000, 210},
  {73465200, -14400, 210},
  {89186400, -18000, 210},
  {104914800, -14400, 210},
  {120636000, -18000, 210},
  {136364400, -14400, 210},
  {152085600, -18000, 210},
  {167814000, -14400, 210},
  {183535200, -18000, 210},
  {199263600, -14400, 210},
  {215589600, -18000, 210},
  {230713200, -14400, 210},
  {247039200, -18000, 210},
  {262767600, -14400, 210},
  {278488800, -18000, 210},
  {294217200, -14400, 210},
  {309938400, -18000, 210},
  {325666800, -14400, 210},
  {341388000, -18000, 210},
  {357116400, -14400, 210},
  {372837600, -18000, 210},
  {388566000, -14400, 210},
  {404892000, -18000, 210},
  {420015600, -14400, 210},
  {436341600, -18000, 210},
  {452070000, -14400, 210},
  {467791200, -18000, 210},
  {483519600, -14400, 210},
  {499240800, -18000, 210},
  {514969200, -14400, 210},
  {530690400, -18000, 210},
  {544604400, -14400, 210},
  {562140000, -18000, 210},
  {576054000, -14400, 210},
  {594194400, -18000, 210},
  {607503600, -14400, 210},
  {625644000, -18000, 210},
  {638953200, -14400, 210},
  {657093600, -18000, 210},
  {671007600, -14400, 210},
  {688543200, -18000, 210},
  {702457200, -14400, 210},
  {719992800, -18000, 210},
  {733906800, -14400, 210},
  {752047200, -18000, 210},
  {765356400, -14400, 210},
  {783496800, -18000, 210},
  {796806000, -14400, 210},
  {814946400, -18000, 210},
  {828860400, -14400, 210},
  {846396000, -18000, 210},
  {860310000, -14400, 210},
  {877845600, -18000, 210},
  {891759600, -14400, 210},
  {909295200, -18000, 210},
  {923209200, -14400, 210},
  {941349600, -18000, 210},
  {954658800, -14400, 210},
  {972799200, -18000, 210},
  {986108400, -14400, 210},
  {1004248800, -18000, 210},
  {1018162800, -14400, 210},
  {1035698400, -18000, 210},
  {1049612400, -14400, 210},
  {1067148000, -18000, 210},
  {1081062000, -14400, 210},
  {1099202400, -18000, 210},
  {1112511600, -14400, 210},
  {1130652000, -18000, 210},
  {1143961200, -14400, 210},
  {1162101600, -18000, 210},
  {1173596400, -14400, 210},
  {1194156000, -18000, 210},
  {1205046000, -14400, 210},
  {1225605600, -18000, 210},
  {1236495600, -14400, 210},
  {1257055200, -18000, 210},
  {1268550000, -14400, 210},
  {1289109600, -18000, 210},
  {1299999600, -14400, 210},
  {1320559200, -18000, 210},
  {1331449200, -14400, 210},
  {1352008800, -18000, 210},
  {1362898800, -14400, 210},
  {1383458400, -18000, 210},
  {1394348400, -14400, 210},
  {1414908000, -18000, 210},
  {1425798000, -14400, 210},
  {1446357600, -18000, 210},
  {1457852400, -14400, 210},
  {1478412000, -18000, 210},
  {1489302000, -14400, 210},
  {1509861600, -18000, 210},
  {1520751600, -14400, 210},
  {1541311200, -18000, 210},
  {1552201200, -14400, 210},
  {1572760800, -18000, 210},
  {1583650800, -14400, 210},
  {1604210400, -18000, 210},
  {1615705200, -14400, 210},
  {1636264800, -18000, 210},
  {1647154800, -14400, 210},
  {1667714400, -18000, 210},
  {1678604400, -14400, 210},
  {1699164000, -18000, 210},
  {1710054000, -14400, 210},
  {1730613600, -18000, 210},
  {1741503600, -14400, 210},
  {1762063200, -18000, 210},
  {1772953200, -14400, 210},
  {1793512800, -18000, 210},
  {1805007600, -14400, 210},
  {1825567200, -18000, 210},
  {1836457200, -14400, 210},
  {1857016800, -18000, 210},
  {1867906800, -14400, 210},
  {1888466400, -18000, 210},
  {1899356400, -14400, 210},
  {1919916000, -18000, 210},
  {1930806000, -14400, 210},
  {1951365600, -18000, 210},
  {1962860400, -14400, 210},
  {1983420000, -18000, 210},
  {1994310000, -14400, 210},
  {2014869600, -18000, 210},
  {2025759600, -14400, 210},
  {2046319200, -18000, 210},
  {2057209200, -14400, 210},
  {2077768800, -18000, 210},
  {2088658800, -14400, 210},
  {2109218400, -18000, 210},
  {2120108400, -14400, 210},
  {2140668000, -18000, 210},
  {INT64_MIN, -15508, 211},
  {-1846266092, -14400, 211},
  {-1632060000, -25200, 212},
  {-1614783600, -28800, 212},
  {-880207200, -25200, 212},
  {-769395600, -25200, 212},
  {-765385200, -28800, 212},
  {-747237600, -25200, 212},
  {-732726000, -28800, 212},
  {-715788000, -25200, 212},
  {-702486000, -28800, 212},
  {-684338400, -25200, 212},
  {-671036400, -28800, 212},
  {-652888800, -25200, 212},
  {-639586800, -28800, 212},
  {-620834400, -25200, 212},
  {-608137200, -28800, 212},
  {-589384800, -25200, 212},
  {-576082800, -28800, 212},
  {-557935200, -25200, 212},
  {-544633200, -28800, 212},
  {-526485600, -25200, 212},
  {-513183600, -28800, 212},
  {-495036000, -25200, 212},
  {-481734000, -28800, 212},
  {-463586400, -25200, 212},
  {-450284400, -28800, 212},
  {-431532000, -25200, 212},
  {-418230000, -28800, 212},
  {-400082400, -25200, 212},
  {-386780400, -28800, 212},
  {-368632800, -25200, 212},
  {-355330800, -28800, 212},
  {-337183200, -25200, 212},
  {-323881200, -28800, 212},
  {-305733600, -25200, 212},
  {-292431600, -28800, 212},
  {-273679200, -25200, 212},
  {-260982000, -28800, 212},
  {-242229600, -25200, 212},
  {-226508400, -28800, 212},
  {-210780000, -25200, 212},
  {-195058800, -28800, 212},
  {-179330400, -25200, 212},
  {-163609200, -28800, 212},
  {-147880800, -25200, 212},
  {-131554800, -28800, 212},
  {-116431200, -25200, 212},
  {-100105200, -28800, 212},
  {-84376800, -25200, 212},
  {-68655600, -28800, 212},
  {-52927200, -25200, 212},
  {-37206000, -28800, 212},
  {-21477600, -25200, 212},
  {-5756400, -28800, 212},
  {9972000, -25200, 212},
  {25693200, -28800, 212},
  {41421600, -25200, 212},
  {57747600, -28800, 212},
  {73476000, -25200, 212},
  {89197200, -28800, 212},
  {104925600, -25200, 212},
  {120646800, -28800, 212},
  {136375200, -25200, 212},
  {152096400, -28800, 212},
  {167824800, -25200, 212},
  {183546000, -28800, 212},
  {199274400, -25200, 212},
  {215600400, -28800, 212},
  {230724000, -25200, 212},
  {247050000, -28800, 212},
  {262778400, -25200, 212},
  {278499600, -28800, 212},
  {294228000, -25200, 212},
  {309949200, -28800, 212},
  {325677600, -25200, 212},
  {341398800, -28800, 212},
  {357127200, -25200, 212},
  {372848400, -28800, 212},
  {388576800, -25200, 212},
  {404902800, -28800, 212},
  {420026400, -25200, 212},
  {436352400, -28800, 212},
  {452080800, -25200, 212},
  {467802000, -28800, 212},
  {483530400, -25200, 212},
  {499251600, -28800, 212},
  {514980000, -25200, 212},
  {530701200, -28800, 212},
  {544615200, -25200, 212},
  {562150800, -28800, 212},
  {576064800, -25200, 212},
  {594205200, -28800, 212},
  {607514400, -25200, 212},
  {625654800, -28800, 212},
  {638964000, -25200, 212},
  {657104400, -28800, 212},
  {671018400, -25200, 212},
  {688554000, -28800, 212},
  {702468000, -25200, 212},
  {720003600, -28800, 212},
  {733917600, -25200, 212},
  {752058000, -28800, 212},
  {765367200, -25200, 212},
  {783507600, -28800, 212},
  {796816800, -25200, 212},
  {814957200, -28800, 212},
  {828871200, -25200, 212},
  {846406800, -28800, 212},
  {860320800, -25200, 212},
  {877856400, -28800, 212},
  {891770400, -25200, 212},
  {909306000, -28800, 212},
  {923220000, -25200, 212},
  {941360400, -28800, 212},
  {954669600, -25200, 212},
  {972810000, -28800, 212},
  {986119200, -25200, 212},
  {1004259600, -28800, 212},
  {1018173600, -25200, 212},
  {1035709200, -28800, 212},
  {1049623200, -25200, 212},
  {1067158800, -28800, 212},
  {1081072800, -25200, 212},
  {1099213200, -28800, 212},
  {1112522400, -25200, 212},
  {1130662800, -28800, 212},
  {1143972000, -25200, 212},
  {1162112400, -28800, 212},
  {1173607200, -25200, 212},
  {1194166800, -28800, 212},
  {1205056800, -25200, 212},
  {1225616400, -28800, 212},
  {1236506400, -25200, 212},
  {1257066000, -28800, 212},
  {1268560800, -25200, 212},
  {1289120400, -28800, 212},
  {1300010400, -25200, 212},
  {1320570000, -28800, 212},
  {1331460000, -25200, 212},
  {1352019600, -28800, 212},
  {1362909600, -25200, 212},
  {1383469200, -28800, 212},
  {1394359200, -25200, 212},
  {1414918800, -28800, 212},
  {1425808800, -25200, 212},
  {1446368400, -28800, 212},
  {1457863200, -25200, 212},
  {1478422800, -28800, 212},
  {1489312800, -25200, 212},
  {1509872400, -28800, 212},
  {1520762400, -25200, 212},
  {1541322000, -28800, 212},
  {1552212000, -25200, 212},
  {1572771600, -28800, 212},
  {1583661600, -25200, 212},
  {1604221200, -28800, 212},
  {1615716000, -25200, 212},
  {1636275600, -28800, 212},
  {1647165600, -25200, 212},
  {1667725200, -28800, 212},
  {1678615200, -25200, 212},
  {1699174800, -28800, 212},
  {1710064800, -25200, 212},
  {1730624400, -28800, 212},
  {1741514400, -25200, 212},
  {1762074000, -28800, 212},
  {1772964000, -25200, 212},
  {1793523600, -28800, 212},
  {1805018400, -25200, 212},
  {1825578000, -28800, 212},
  {1836468000, -25200, 212},
  {1857027600, -28800, 212},
  {1867917600, -25200, 212},
  {1888477200, -28800, 212},
  {1899367200, -25200, 212},
  {1919926800, -28800, 212},
  {1930816800, -25200, 212},
  {1951376400, -28800, 212},
  {1962871200, -25200, 212},
  {1983430800, -28800, 212},
  {1994320800, -25200, 212},
  {2014880400, -28800, 212},
  {2025770400, -25200, 212},
  {2046330000, -28800, 212},
  {2057220000, -25200, 212},
  {2077779600, -28800, 212},
  {2088669600, -25200, 212},
  {2109229200, -28800, 212},
  {2120119200, -25200, 212},
  {2140678800, -28800, 212},
  {INT64_MIN, -15584, 213},
  {-1846266016, -14400, 213},
  {-1632056400, -28800, 214},
  {-1615125600, -32400, 214},
  {-1596978000, -28800, 214},
  {-1583164800, -32400, 214},
  {-880203600, -28800, 214},
  {-769395600, -28800, 214},
  {-765381600, -32400, 214},
  {-147884400, -25200, 214},
  {-131554800, -32400, 214},
  {-110552400, -28800, 214},
  {325677600, -25200, 214},
  {341398800, -28800, 214},
  {357127200, -25200, 214},
  {372848400, -28800, 214},
  {388576800, -25200, 214},
  {404902800, -28800, 214},
  {420026400, -25200, 214},
  {436352400, -28800, 214},
  {452080800, -25200, 214},
  {467802000, -28800, 214},
  {483530400, -25200, 214},
  {499251600, -28800, 214},
  {514980000, -25200, 214},
  {530701200, -28800, 214},
  {544615200, -25200, 214},
  {562150800, -28800, 214},
  {576064800, -25200, 214},
  {594205200, -28800, 214},
  {607514400, -25200, 214},
  {625654800, -28800, 214},
  {638964000, -25200, 214},
  {657104400, -28800, 214},
  {671018400, -25200, 214},
  {688554000, -28800, 214},
  {702468000, -25200, 214},
  {720003600, -28800, 214},
  {733917600, -25200, 214},
  {752058000, -28800, 214},
  {765367200, -25200, 214},
  {783507600, -28800, 214},
  {796816800, -25200, 214},
  {814957200, -28800, 214},
  {828871200, -25200, 214},
  {846406800, -28800, 214},
  {860320800, -25200, 214},
  {877856400, -28800, 214},
  {891770400, -25200, 214},
  {909306000, -28800, 214},
  {923220000, -25200, 214},
  {941360400, -28800, 214},
  {954669600, -25200, 214},
  {972810000, -28800, 214},
  {986119200, -25200, 214},
  {1004259600, -28800, 214},
  {1018173600, -25200, 214},
  {1035709200, -28800, 214},
  {1049623200, -25200, 214},
  {1067158800, -28800, 214},
  {1081072800, -25200, 214},
  {1099213200, -28800, 214},
  {1112522400, -25200, 214},
  {1130662800, -28800, 214},
  {1143972000, -25200, 214},
  {1162112400, -28800, 214},
  {1173607200, -25200, 214},
  {1194166800, -28800, 214},
  {1205056800, -25200, 214},
  {1225616400, -28800, 214},
  {1236506400, -25200, 214},
  {1257066000, -28800, 214},
  {1268560800, -25200, 214},
  {1289120400, -28800, 214},
  {1300010400, -25200, 214},
  {1320570000, -28800, 214},
  {1331460000, -25200, 214},
  {1352019600, -28800, 214},
  {1362909600, -25200, 214},
  {1383469200, -28800, 214},
  {1394359200, -25200, 214},
  {1414918800, -28800, 214},
  {1425808800, -25200, 214},
  {1446368400, -28800, 214},
  {1457863200, -25200, 214},
  {1478422800, -28800, 214},
  {1489312800, -25200, 214},
  {1509872400, -28800, 214},
  {1520762400, -25200, 214},
  {1541322000, -28800, 214},
  {1552212000, -25200, 214},
  {1572771600, -28800, 214},
  {1583661600, -25200, 214},
  {1604221200, -28800, 214},
  {1615716000, -25200, 214},
  {1636275600, -28800, 214},
  {1647165600, -25200, 214},
  {1667725200, -28800, 214},
  {1678615200, -25200, 214},
  {1699174800, -28800, 214},
  {1710064800, -25200, 214},
  {1730624400, -28800, 214},
  {1741514400, -25200, 214},
  {1762074000, -28800, 214},
  {1772964000, -25200, 214},
  {1793523600, -28800, 214},
  {1805018400, -25200, 214},
  {1825578000, -28800, 214},
  {1836468000, -25200, 214},
  {1857027600, -28800, 214},
  {1867917600, -25200, 214},
  {1888477200, -28800, 214},
  {1899367200, -25200, 214},
  {1919926800, -28800, 214},
  {1930816800, -25200, 214},
  {1951376400, -28800, 214},
  {1962871200, -25200, 214},
  {1983430800, -28800, 214},
  {1994320800, -25200, 214},
  {2014880400, -28800, 214},
  {2025770400, -25200, 214},
  {2046330000, -28800, 214},
  {2057220000, -25200, 214},
  {2077779600, -28800, 214},
  {2088669600, -25200, 214},
  {2109229200, -28800, 214},
  {2120119200, -25200, 214},
  {2140678800, -28800, 214},
  {-1694368800, -18000, 215},
  {-1681671600, -21600, 215},
  {-1632067200, -18000, 215},
  {-1614790800, -21600, 215},
  {-1029686400, -18000, 215},
  {-1018198800, -21600, 215},
  {-880214400, -18000, 215},
  {-769395600, -18000, 215},
  {-765392400, -21600, 215},
  {-746035200, -18000, 215},
  {-732733200, -21600, 215},
  {-715795200, -18000, 215},
  {-702493200, -21600, 215},
  {-684345600, -18000, 215},
  {-671043600, -21600, 215},
  {-652896000, -18000, 215},
  {-639594000, -21600, 215},
  {-620755200, -18000, 215},
  {-607626000, -21600, 215},
  {-589392000, -18000, 215},
  {-576090000, -21600, 215},
  {-557942400, -18000, 215},
  {-544640400, -21600, 215},
  {-526492800, -18000, 215},
  {-513190800, -21600, 215},
  {-495043200, -18000, 215},
  {-481741200, -21600, 215},
  {-463593600, -18000, 215},
  {-450291600, -21600, 215},
  {-431539200, -18000, 215},
  {-418237200, -21600, 215},
  {-400089600, -18000, 215},
  {-386787600, -21600, 215},
  {-368640000, -18000, 215},
  {-355338000, -21600, 215},
  {-337190400, -18000, 215},
  {-321469200, -21600, 215},
  {-305740800, -18000, 215},
  {-292438800, -21600, 215},
  {-210787200, -18000, 215},
  {-198090000, -21600, 215},
  {-116438400, -18000, 215},
  {-100108800, -21600, 215},
  {-84384000, -18000, 215},
  {-68659200, -21600, 215},
  {-52934400, -18000, 215},
  {-37209600, -21600, 215},
  {-21484800, -18000, 215},
  {-5760000, -21600, 215},
  {9964800, -18000, 215},
  {25689600, -21600, 215},
  {41414400, -18000, 215},
  {57744000, -21600, 215},
  {73468800, -18000, 215},
  {89193600, -21600, 215},
  {104918400, -18000, 215},
  {120643200, -21600, 215},
  {136368000, -18000, 215},
  {152092800, -21600, 215},
  {167817600, -18000, 215},
  {183542400, -21600, 215},
  {199267200, -18000, 215},
  {215596800, -21600, 215},
  {230716800, -18000, 215},
  {247046400, -21600, 215},
  {262771200, -18000, 215},
  {278496000, -21600, 215},
  {294220800, -18000, 215},
  {309945600, -21600, 215},
  {325670400, -18000, 215},
  {341395200, -21600, 215},
  {357120000, -18000, 215},
  {372844800, -21600, 215},
  {388569600, -18000, 215},
  {404899200, -21600, 215},
  {420019200, -18000, 215},
  {436348800, -21600, 215},
  {452073600, -18000, 215},
  {467798400, -21600, 215},
  {483523200, -18000, 215},
  {499248000, -21600, 215},
  {514972800, -18000, 215},
  {530697600, -21600, 215},
  {544608000, -18000, 215},
  {562147200, -21600, 215},
  {576057600, -18000, 215},
  {594201600, -21600, 215},
  {607507200, -18000, 215},
  {625651200, -21600, 215},
  {638956800, -18000, 215},
  {657100800, -21600, 215},
  {671011200, -18000, 215},
  {688550400, -21600, 215},
  {702460800, -18000, 215},
  {720000000, -21600, 215},
  {733910400, -18000, 215},
  {752054400, -21600, 215},
  {765360000, -18000, 215},
  {783504000, -21600, 215},
  {796809600, -18000, 215},
  {814953600, -21600, 215},
  {828864000, -18000, 215},
  {846403200, -21600, 215},
  {860313600, -18000, 215},
  {877852800, -21600, 215},
  {891763200, -18000, 215},
  {909302400, -21600, 215},
  {923212800, -18000, 215},
  {941356800, -21600, 215},
  {954662400, -18000, 215},
  {972806400, -21600, 215},
  {986112000, -18000, 215},
  {1004256000, -21600, 215},
  {1018166400, -18000, 215},
  {1035705600, -21600, 215},
  {1049616000, -18000, 215},
  {1067155200, -21600, 215},
  {1081065600, -18000, 215},
  {1099209600, -21600, 215},
  {1112515200, -18000, 215},
  {1130659200, -21600, 215},
  {1136095200, -21600, 215},
  {1143964800, -18000, 215},
  {1162105200, -21600, 215},
  {1173600000, -18000, 215},
  {1194159600, -21600, 215},
  {1205049600, -18000, 215},
  {1225609200, -21600, 215},
  {1236499200, -18000, 215},
  {1257058800, -21600, 215},
  {1268553600, -18000, 215},
  {1289113200, -21600, 215},
  {1300003200, -18000, 215},
  {1320562800, -21600, 215},
  {1331452800, -18000, 215},
  {1352012400, -21600, 215},
  {1362902400, -18000, 215},
  {1383462000, -21600, 215},
  {1394352000, -18000, 215},
  {1414911600, -21600, 215},
  {1425801600, -18000, 215},
  {1446361200, -21600, 215},
  {1457856000, -18000, 215},
  {1478415600, -21600, 215},
  {1489305600, -18000, 215},
  {1509865200, -21600, 215},
  {1520755200, -18000, 215},
  {1541314800, -21600, 215},
  {1552204800, -18000, 215},
  {1572764400, -21600, 215},
  {1583654400, -18000, 215},
  {1604214000, -21600, 215},
  {1615708800, -18000, 215},
  {1636268400, -21600, 215},
  {1647158400, -18000, 215},
  {1667718000, -21600, 215},
  {1678608000, -18000, 215},
  {1699167600, -21600, 215},
  {1710057600, -18000, 215},
  {1730617200, -21600, 215},
  {1741507200, -18000, 215},
  {1762066800, -21600, 215},
  {1772956800, -18000, 215},
  {1793516400, -21600, 215},
  {1805011200, -18000, 215},
  {1825570800, -21600, 215},
  {1836460800, -18000, 215},
  {1857020400, -21600, 215},
  {1867910400, -18000, 215},
  {1888470000, -21600, 215},
  {1899360000, -18000, 215},
  {1919919600, -21600, 215},
  {1930809600, -18000, 215},
  {1951369200, -21600, 215},
  {1962864000, -18000, 215},
  {1983423600, -21600, 215},
  {1994313600, -18000, 215},
  {2014873200, -21600, 215},
  {2025763200, -18000, 215},
  {2046322800, -21600, 215},
  {2057212800, -18000, 215},
  {2077772400, -21600, 215},
  {2088662400, -18000, 215},
  {2109222000, -21600, 215},
  {2120112000, -18000, 215},
  {2140671600, -21600, 215},
  {-880203600, -28800, 216},
  {-769395600, -28800, 216},
  {-765381600, -32400, 216},
  {-21474000, -28800, 216},
  {-5752800, -32400, 216},
  {9975600, -28800, 216},
  {25696800, -32400, 216},
  {41425200, -28800, 216},
  {57751200, -32400, 216},
  {73479600, -28800, 216},
  {89200800, -32400, 216},
  {104929200, -28800, 216},
  {120650400, -32400, 216},
  {126702000, -28800, 216},
  {152100000, -32400, 216},
  {162385200, -28800, 216},
  {183549600, -32400, 216},
  {199278000, -28800, 216},
  {215604000, -32400, 216},
  {230727600, -28800, 216},
  {247053600, -32400, 216},
  {262782000, -28800, 216},
  {278503200, -32400, 216},
  {294231600, -28800, 216},
  {309952800, -32400, 216},
  {325681200, -28800, 216},
  {341402400, -32400, 216},
  {357130800, -28800, 216},
  {372852000, -32400, 216},
  {388580400, -28800, 216},
  {404906400, -32400, 216},
  {420030000, -28800, 216},
  {436356000, -32400, 216},
  {439030800, -32400, 216},
  {452084400, -28800, 216},
  {467805600, -32400, 216},
  {483534000, -28800, 216},
  {499255200, -32400, 216},
  {514983600, -28800, 216},
  {530704800, -32400, 216},
  {544618800, -28800, 216},
  {562154400, -32400, 216},
  {576068400, -28800, 216},
  {594208800, -32400, 216},
  {607518000, -28800, 216},
  {625658400, -32400, 216},
  {638967600, -28800, 216},
  {657108000, -32400, 216},
  {671022000, -28800, 216},
  {688557600, -32400, 216},
  {702471600, -28800, 216},
  {720007200, -32400, 216},
  {733921200, -28800, 216},
  {752061600, -32400, 216},
  {765370800, -28800, 216},
  {783511200, -32400, 216},
  {796820400, -28800, 216},
  {814960800, -32400, 216},
  {828874800, -28800, 216},
  {846410400, -32400, 216},
  {860324400, -28800, 216},
  {877860000, -32400, 216},
  {891774000, -28800, 216},
  {909309600, -32400, 216},
  {923223600, -28800, 216},
  {941364000, -32400, 216},
  {954673200, -28800, 216},
  {972813600, -32400, 216},
  {986122800, -28800, 216},
  {1004263200, -32400, 216},
  {1018177200, -28800, 216},
  {1035712800, -32400, 216},
  {1049626800, -28800, 216},
  {1067162400, -32400, 216},
  {1081076400, -28800, 216},
  {1099216800, -32400, 216},
  {1112526000, -28800, 216},
  {1130666400, -32400, 216},
  {1143975600, -28800, 216},
  {1162116000, -32400, 216},
  {1173610800, -28800, 216},
  {1194170400, -32400, 216},
  {1205060400, -28800, 216},
  {1225620000, -32400, 216},
  {1236510000, -28800, 216},
  {1257069600, -32400, 216},
  {1268564400, -28800, 216},
  {1289124000, -32400, 216},
  {1300014000, -28800, 216},
  {1320573600, -32400, 216},
  {1331463600, -28800, 216},
  {1352023200, -32400, 216},
  {1362913200, -28800, 216},
  {1383472800, -32400, 216},
  {1394362800, -28800, 216},
  {1414922400, -32400, 216},
  {1425812400, -28800, 216},
  {1446372000, -32400, 216},
  {1457866800, -28800, 216},
  {1478426400, -32400, 216},
  {1489316400, -28800, 216},
  {1509876000, -32400, 216},
  {1520766000, -28800, 216},
  {1541325600, -32400, 216},
  {1552215600, -28800, 216},
  {1572775200, -32400, 216},
  {1583665200, -28800, 216},
  {1604224800, -32400, 216},
  {1615719600, -28800, 216},
  {1636279200, -32400, 216},
  {1647169200, -28800, 216},
  {1667728800, -32400, 216},
  {1678618800, -28800, 216},
  {1699178400, -32400, 216},
  {1710068400, -28800, 216},
  {1730628000, -32400, 216},
  {1741518000, -28800, 216},
  {1762077600, -32400, 216},
  {1772967600, -28800, 216},
  {1793527200, -32400, 216},
  {1805022000, -28800, 216},
  {1825581600, -32400, 216},
  {1836471600, -28800, 216},
  {1857031200, -32400, 216},
  {1867921200, -28800, 216},
  {1888480800, -32400, 216},
  {1899370800, -28800, 216},
  {1919930400, -32400, 216},
  {1930820400, -28800, 216},
  {1951380000, -32400, 216},
  {1962874800, -28800, 216},
  {1983434400, -32400, 216},
  {1994324400, -28800, 216},
  {2014884000, -32400, 216},
  {2025774000, -28800, 216},
  {2046333600, -32400, 216},
  {2057223600, -28800, 216},
  {2077783200, -32400, 216},
  {2088673200, -28800, 216},
  {2109232800, -32400, 216},
  {2120122800, -28800, 216},
  {2140682400, -32400, 216},
  {INT64_MIN, 0, 217},
  {-1104537600, -25200, 217},
  {-880210800, -21600, 217},
  {-769395600, -21600, 217},
  {-765388800, -25200, 217},
  {-147891600, -18000, 217},
  {-131562000, -25200, 217},
  {325674000, -21600, 217},
  {341395200, -25200, 217},
  {357123600, -21600, 217},
  {372844800, -25200, 217},
  {388573200, -21600, 217},
  {404899200, -25200, 217},
  {420022800, -21600, 217},
  {436348800, -25200, 217},
  {452077200, -21600, 217},
  {467798400, -25200, 217},
  {483526800, -21600, 217},
  {499248000, -25200, 217},
  {514976400, -21600, 217},
  {530697600, -25200, 217},
  {544611600, -21600, 217},
  {562147200, -25200, 217},
  {576061200, -21600, 217},
  {594201600, -25200, 217},
  {607510800, -21600, 217},
  {625651200, -25200, 217},
  {638960400, -21600, 217},
  {657100800, -25200, 217},
  {671014800, -21600, 217},
  {688550400, -25200, 217},
  {702464400, -21600, 217},
  {720000000, -25200, 217},
  {733914000, -21600, 217},
  {752054400, -25200, 217},
  {765363600, -21600, 217},
  {783504000, -25200, 217},
  {796813200, -21600, 217},
  {814953600, -25200, 217},
  {828867600, -21600, 217},
  {846403200, -25200, 217},
  {860317200, -21600, 217},
  {877852800, -25200, 217},
  {891766800, -21600, 217},
  {909302400, -25200, 217},
  {923216400, -21600, 217},
  {941356800, -25200, 217},
  {954666000, -21600, 217},
  {972806400, -25200, 217},
  {986115600, -21600, 217},
  {1004256000, -25200, 217},
  {1018170000, -21600, 217},
  {1035705600, -25200, 217},
  {1049619600, -21600, 217},
  {1067155200, -25200, 217},
  {1081069200, -21600, 217},
  {1099209600, -25200, 217},
  {1112518800, -21600, 217},
  {1130659200, -25200, 217},
  {1143968400, -21600, 217},
  {1162108800, -25200, 217},
  {1173603600, -21600, 217},
  {1194163200, -25200, 217},
  {1205053200, -21600, 217},
  {1225612800, -25200, 217},
  {1236502800, -21600, 217},
  {1257062400, -25200, 217},
  {1268557200, -21600, 217},
  {1289116800, -25200, 217},
  {1300006800, -21600, 217},
  {1320566400, -25200, 217},
  {1331456400, -21600, 217},
  {1352016000, -25200, 217},
  {1362906000, -21600, 217},
  {1383465600, -25200, 217},
  {1394355600, -21600, 217},
  {1414915200, -25200, 217},
  {1425805200, -21600, 217},
  {1446364800, -25200, 217},
  {1457859600, -21600, 217},
  {1478419200, -25200, 217},
  {1489309200, -21600, 217},
  {1509868800, -25200, 217},
  {1520758800, -21600, 217},
  {1541318400, -25200, 217},
  {1552208400, -21600, 217},
  {1572768000, -25200, 217},
  {1583658000, -21600, 217},
  {1604217600, -25200, 217},
  {1615712400, -21600, 217},
  {1636272000, -25200, 217},
  {1647162000, -21600, 217},
  {1667721600, -25200, 217},
  {1678611600, -21600, 217},
  {1699171200, -25200, 217},
  {1710061200, -21600, 217},
  {1730620800, -25200, 217},
  {1741510800, -21600, 217},
  {1762070400, -25200, 217},
  {1772960400, -21600, 217},
  {1793520000, -25200, 217},
  {1805014800, -21600, 217},
  {1825574400, -25200, 217},
  {1836464400, -21600, 217},
  {1857024000, -25200, 217},
  {1867914000, -21600, 217},
  {1888473600, -25200, 217},
  {1899363600, -21600, 217},
  {1919923200, -25200, 217},
  {1930813200, -21600, 217},
  {1951372800, -25200, 217},
  {1962867600, -21600, 217},
  {1983427200, -25200, 217},
  {1994317200, -21600, 217},
  {2014876800, -25200, 217},
  {2025766800, -21600, 217},
  {2046326400, -25200, 217},
  {2057216400, -21600, 217},
  {2077776000, -25200, 217},
  {2088666000, -21600, 217},
  {2109225600, -25200, 217},
  {2120115600, -21600, 217},
  {2140675200, -25200, 217},
  {INT64_MIN, 0, 218},
  {-31536000, 28800, 218},
  {1255802400, 39600, 218},
  {1267714800, 28800, 218},
  {-409190400, 25200, 219},
  {-163062000, 0, 219},
  {-28857600, 25200, 219},
  {1255806000, 18000, 219},
  {1268251200, 25200, 219},
  {-725846400, 36000, 220},
  {-566992800, 0, 220},
  {-415497600, 36000, 220},
  {INT64_MIN, 0, 221},
  {-1861920000, 36000, 221},
  {-1680508800, 39600, 221},
  {-1665392400, 36000, 221},
  {-883641600, 39600, 221},
  {-876128400, 36000, 221},
  {-860400000, 39600, 221},
  {-844678800, 36000, 221},
  {-828345600, 39600, 221},
  {-813229200, 36000, 221},
  {-71136000, 39600, 221},
  {-55411200, 36000, 221},
  {-37267200, 39600, 221},
  {-25776000, 36000, 221},
  {-5817600, 39600, 221},
  {5673600, 36000, 221},
  {25632000, 39600, 221},
  {37728000, 36000, 221},
  {57686400, 39600, 221},
  {67968000, 36000, 221},
  {89136000, 39600, 221},
  {100022400, 36000, 221},
  {120585600, 39600, 221},
  {131472000, 36000, 221},
  {152035200, 39600, 221},
  {162921600, 36000, 221},
  {183484800, 39600, 221},
  {194976000, 36000, 221},
  {215539200, 39600, 221},
  {226425600, 36000, 221},
  {246988800, 39600, 221},
  {257875200, 36000, 221},
  {278438400, 39600, 221},
  {289324800, 36000, 221},
  {309888000, 39600, 221},
  {320774400, 36000, 221},
  {341337600, 39600, 221},
  {352224000, 36000, 221},
  {372787200, 39600, 221},
  {386092800, 36000, 221},
  {404841600, 39600, 221},
  {417542400, 36000, 221},
  {436291200, 39600, 221},
  {447177600, 36000, 221},
  {467740800, 39600, 221},
  {478627200, 36000, 221},
  {499190400, 39600, 221},
  {510076800, 36000, 221},
  {530035200, 39600, 221},
  {542736000, 36000, 221},
  {562089600, 39600, 221},
  {574790400, 36000, 221},
  {594144000, 39600, 221},
  {606240000, 36000, 221},
  {625593600, 39600, 221},
  {637689600, 36000, 221},
  {657043200, 39600, 221},
  {670348800, 36000, 221},
  {686678400, 39600, 221},
  {701798400, 36000, 221},
  {718128000, 39600, 221},
  {733248000, 36000, 221},
  {749577600, 39600, 221},
  {764697600, 36000, 221},
  {781027200, 39600, 221},
  {796147200, 36000, 221},
  {812476800, 39600, 221},
  {828201600, 36000, 221},
  {844531200, 39600, 221},
  {859651200, 36000, 221},
  {875980800, 39600, 221},
  {891100800, 36000, 221},
  {907430400, 39600, 221},
  {922550400, 36000, 221},
  {938880000, 39600, 221},
  {954000000, 36000, 221},
  {967305600, 39600, 221},
  {985449600, 36000, 221},
  {1002384000, 39600, 221},
  {1017504000, 36000, 221},
  {1033833600, 39600, 221},
  {1048953600, 36000, 221},
  {1065283200, 39600, 221},
  {1080403200, 36000, 221},
  {1096732800, 39600, 221},
  {1111852800, 36000, 221},
  {1128182400, 39600, 221},
  {1143907200, 36000, 221},
  {1159632000, 39600, 221},
  {1174752000, 36000, 221},
  {1191686400, 39600, 221},
  {1207411200, 36000, 221},
  {1223136000, 39600, 221},
  {1238860800, 36000, 221},
  {1254585600, 39600, 221},
  {1270310400, 39600, 221},
  {INT64_MIN, 0, 222},
  {-501206400, 21600, 222},
  {1255809600, 18000, 222},
  {INT64_MIN, 0, 223},
  {-441849600, 43200, 223},
  {152632800, 46800, 223},
  {162309600, 43200, 223},
  {183477600, 46800, 223},
  {194968800, 43200, 223},
  {215532000, 46800, 223},
  {226418400, 43200, 223},
  {246981600, 46800, 223},
  {257868000, 43200, 223},
  {278431200, 46800, 223},
  {289317600, 43200, 223},
  {309880800, 46800, 223},
  {320767200, 43200, 223},
  {341330400, 46800, 223},
  {352216800, 43200, 223},
  {372780000, 46800, 223},
  {384271200, 43200, 223},
  {404834400, 46800, 223},
  {415720800, 43200, 223},
  {436284000, 46800, 223},
  {447170400, 43200, 223},
  {467733600, 46800, 223},
  {478620000, 43200, 223},
  {499183200, 46800, 223},
  {510069600, 43200, 223},
  {530632800, 46800, 223},
  {541519200, 43200, 223},
  {562082400, 46800, 223},
  {573573600, 43200, 223},
  {594136800, 46800, 223},
  {605023200, 43200, 223},
  {623772000, 46800, 223},
  {637682400, 43200, 223},
  {655221600, 46800, 223},
  {669132000, 43200, 223},
  {686671200, 46800, 223},
  {700581600, 43200, 223},
  {718120800, 46800, 223},
  {732636000, 43200, 223},
  {749570400, 46800, 223},
  {764085600, 43200, 223},
  {781020000, 46800, 223},
  {795535200, 43200, 223},
  {812469600, 46800, 223},
  {826984800, 43200, 223},
  {844524000, 46800, 223},
  {858434400, 43200, 223},
  {875973600, 46800, 223},
  {889884000, 43200, 223},
  {907423200, 46800, 223},
  {921938400, 43200, 223},
  {938872800, 46800, 223},
  {953388000, 43200, 223},
  {970322400, 46800, 223},
  {984837600, 43200, 223},
  {1002376800, 46800, 223},
  {1016287200, 43200, 223},
  {1033826400, 46800, 223},
  {1047736800, 43200, 223},
  {1065276000, 46800, 223},
  {1079791200, 43200, 223},
  {1096725600, 46800, 223},
  {1111240800, 43200, 223},
  {1128175200, 46800, 223},
  {1142690400, 43200, 223},
  {1159624800, 46800, 223},
  {1174140000, 43200, 223},
  {1191074400, 46800, 223},
  {1207404000, 43200, 223},
  {1222524000, 46800, 223},
  {1238853600, 43200, 223},
  {1253973600, 46800, 223},
  {1270303200, 43200, 223},
  {1285423200, 46800, 223},
  {1301752800, 43200, 223},
  {1316872800, 46800, 223},
  {1333202400, 43200, 223},
  {1348927200, 46800, 223},
  {1365256800, 43200, 223},
  {1380376800, 46800, 223},
  {1396706400, 43200, 223},
  {1411826400, 46800, 223},
  {1428156000, 43200, 223},
  {1443276000, 46800, 223},
  {1459605600, 43200, 223},
  {1474725600, 46800, 223},
  {1491055200, 43200, 223},
  {1506175200, 46800, 223},
  {1522504800, 43200, 223},
  {1538229600, 46800, 223},
  {1554559200, 43200, 223},
  {1569679200, 46800, 223},
  {1586008800, 43200, 223},
  {1601128800, 46800, 223},
  {1617458400, 43200, 223},
  {1632578400, 46800, 223},
  {1648908000, 43200, 223},
  {1664028000, 46800, 223},
  {1680357600, 43200, 223},
  {1695477600, 46800, 223},
  {1712412000, 43200, 223},
  {1727532000, 46800, 223},
  {1743861600, 43200, 223},
  {1758981600, 46800, 223},
  {1775311200, 43200, 223},
  {1790431200, 46800, 223},
  {1806760800, 43200, 223},
  {1821880800, 46800, 223},
  {1838210400, 43200, 223},
  {1853330400, 46800, 223},
  {1869660000, 43200, 223},
  {1885384800, 46800, 223},
  {1901714400, 43200, 223},
  {1916834400, 46800, 223},
  {1933164000, 43200, 223},
  {1948284000, 46800, 223},
  {1964613600, 43200, 223},
  {1979733600, 46800, 223},
  {1996063200, 43200, 223},
  {2011183200, 46800, 223},
  {2027512800, 43200, 223},
  {2042632800, 46800, 223},
  {2058962400, 43200, 223},
  {2074687200, 46800, 223},
  {2091016800, 43200, 223},
  {2106136800, 46800, 223},
  {2122466400, 43200, 223},
  {2137586400, 46800, 223},
  {INT64_MIN, 0, 224},
  {-157766400, -10800, 224},
  {-152658000, -14400, 224},
  {-132955200, -10800, 224},
  {-121122000, -14400, 224},
  {-101419200, -10800, 224},
  {-86821200, -14400, 224},
  {-71092800, -10800, 224},
  {-54766800, -14400, 224},
  {-39038400, -10800, 224},
  {-23317200, -14400, 224},
  {-7588800, -10800, 224},
  {128142000, -7200, 224},
  {136605600, -10800, 224},
  {389070000, -14400, 224},
  {403070400, -10800, 224},
  {416372400, -14400, 224},
  {434520000, -10800, 224},
  {447822000, -14400, 224},
  {466574400, -10800, 224},
  {479271600, -14400, 224},
  {498024000, -10800, 224},
  {510721200, -14400, 224},
  {529473600, -10800, 224},
  {545194800, -14400, 224},
  {560923200, -10800, 224},
  {574225200, -14400, 224},
  {591768000, -10800, 224},
  {605674800, -14400, 224},
  {624427200, -10800, 224},
  {637729200, -14400, 224},
  {653457600, -10800, 224},
  {668574000, -14400, 224},
  {687326400, -10800, 224},
  {700628400, -14400, 224},
  {718776000, -10800, 224},
  {732078000, -14400, 224},
  {750225600, -10800, 224},
  {763527600, -14400, 224},
  {781675200, -10800, 224},
  {794977200, -14400, 224},
  {813729600, -10800, 224},
  {826426800, -14400, 224},
  {845179200, -10800, 224},
  {859690800, -14400, 224},
  {876628800, -10800, 224},
  {889930800, -14400, 224},
  {906868800, -10800, 224},
  {923194800, -14400, 224},
  {939528000, -10800, 224},
  {952830000, -14400, 224},
  {971582400, -10800, 224},
  {984279600, -14400, 224},
  {1003032000, -10800, 224},
  {1015729200, -14400, 224},
  {1034481600, -10800, 224},
  {1047178800, -14400, 224},
  {1065931200, -10800, 224},
  {1079233200, -14400, 224},
  {1097380800, -10800, 224},
  {1110682800, -14400, 224},
  {1128830400, -10800, 224},
  {1142132400, -14400, 224},
  {1160884800, -10800, 224},
  {1173582000, -14400, 224},
  {1192334400, -10800, 224},
  {1205031600, -14400, 224},
  {1223784000, -10800, 224},
  {1237086000, -14400, 224},
  {1255233600, -10800, 224},
  {1268535600, -14400, 224},
  {1286683200, -10800, 224},
  {1299985200, -14400, 224},
  {1318132800, -10800, 224},
  {1331434800, -14400, 224},
  {1350187200, -10800, 224},
  {1362884400, -14400, 224},
  {1381636800, -10800, 224},
  {1394334000, -14400, 224},
  {1413086400, -10800, 224},
  {1426388400, -14400, 224},
  {1444536000, -10800, 224},
  {1457838000, -14400, 224},
  {1475985600, -10800, 224},
  {1489287600, -14400, 224},
  {1508040000, -10800, 224},
  {1520737200, -14400, 224},
  {1539489600, -10800, 224},
  {1552186800, -14400, 224},
  {1570939200, -10800, 224},
  {1584241200, -14400, 224},
  {1602388800, -10800, 224},
  {1615690800, -14400, 224},
  {1633838400, -10800, 224},
  {1647140400, -14400, 224},
  {1665288000, -10800, 224},
  {1678590000, -14400, 224},
  {1697342400, -10800, 224},
  {1710039600, -14400, 224},
  {1728792000, -10800, 224},
  {1741489200, -14400, 224},
  {1760241600, -10800, 224},
  {1773543600, -14400, 224},
  {1791691200, -10800, 224},
  {1804993200, -14400, 224},
  {1823140800, -10800, 224},
  {1836442800, -14400, 224},
  {1855195200, -10800, 224},
  {1867892400, -14400, 224},
  {1886644800, -10800, 224},
  {1899342000, -14400, 224},
  {1918094400, -10800, 224},
  {1930791600, -14400, 224},
  {1949544000, -10800, 224},
  {1962846000, -14400, 224},
  {1980993600, -10800, 224},
  {1994295600, -14400, 224},
  {2012443200, -10800, 224},
  {2025745200, -14400, 224},
  {2044497600, -10800, 224},
  {2057194800, -14400, 224},
  {2075947200, -10800, 224},
  {2088644400, -14400, 224},
  {2107396800, -10800, 224},
  {2120698800, -14400, 224},
  {2138846400, -10800, 224},
  {INT64_MIN, 0, 225},
  {218246400, -10800, 225},
  {INT64_MIN, 0, 226},
  {-441849600, 43200, 226},
  {152632800, 46800, 226},
  {162309600, 43200, 226},
  {183477600, 46800, 226},
  {194968800, 43200, 226},
  {215532000, 46800, 226},
  {226418400, 43200, 226},
  {246981600, 46800, 226},
  {257868000, 43200, 226},
  {278431200, 46800, 226},
  {289317600, 43200, 226},
  {309880800, 46800, 226},
  {320767200, 43200, 226},
  {341330400, 46800, 226},
  {352216800, 43200, 226},
  {372780000, 46800, 226},
  {384271200, 43200, 226},
  {404834400, 46800, 226},
  {415720800, 43200, 226},
  {436284000, 46800, 226},
  {447170400, 43200, 226},
  {467733600, 46800, 226},
  {478620000, 43200, 226},
  {499183200, 46800, 226},
  {510069600, 43200, 226},
  {530632800, 46800, 226},
  {541519200, 43200, 226},
  {562082400, 46800, 226},
  {573573600, 43200, 226},
  {594136800, 46800, 226},
  {605023200, 43200, 226},
  {623772000, 46800, 226},
  {637682400, 43200, 226},
  {655221600, 46800, 226},
  {669132000, 43200, 226},
  {686671200, 46800, 226},
  {700581600, 43200, 226},
  {718120800, 46800, 226},
  {732636000, 43200, 226},
  {749570400, 46800, 226},
  {764085600, 43200, 226},
  {781020000, 46800, 226},
  {795535200, 43200, 226},
  {812469600, 46800, 226},
  {826984800, 43200, 226},
  {844524000, 46800, 226},
  {858434400, 43200, 226},
  {875973600, 46800, 226},
  {889884000, 43200, 226},
  {907423200, 46800, 226},
  {921938400, 43200, 226},
  {938872800, 46800, 226},
  {953388000, 43200, 226},
  {970322400, 46800, 226},
  {984837600, 43200, 226},
  {1002376800, 46800, 226},
  {1016287200, 43200, 226},
  {1033826400, 46800, 226},
  {1047736800, 43200, 226},
  {1065276000, 46800, 226},
  {1079791200, 43200, 226},
  {1096725600, 46800, 226},
  {1111240800, 43200, 226},
  {1128175200, 46800, 226},
  {1142690400, 43200, 226},
  {1159624800, 46800, 226},
  {1174140000, 43200, 226},
  {1191074400, 46800, 226},
  {1207404000, 43200, 226},
  {1222524000, 46800, 226},
  {1238853600, 43200, 226},
  {1253973600, 46800, 226},
  {1270303200, 43200, 226},
  {1285423200, 46800, 226},
  {1301752800, 43200, 226},
  {1316872800, 46800, 226},
  {1333202400, 43200, 226},
  {1348927200, 46800, 226},
  {1365256800, 43200, 226},
  {1380376800, 46800, 226},
  {1396706400, 43200, 226},
  {1411826400, 46800, 226},
  {1428156000, 43200, 226},
  {1443276000, 46800, 226},
  {1459605600, 43200, 226},
  {1474725600, 46800, 226},
  {1491055200, 43200, 226},
  {1506175200, 46800, 226},
  {1522504800, 43200, 226},
  {1538229600, 46800, 226},
  {1554559200, 43200, 226},
  {1569679200, 46800, 226},
  {1586008800, 43200, 226},
  {1601128800, 46800, 226},
  {1617458400, 43200, 226},
  {1632578400, 46800, 226},
  {1648908000, 43200, 226},
  {1664028000, 46800, 226},
  {1680357600, 43200, 226},
  {1695477600, 46800, 226},
  {1712412000, 43200, 226},
  {1727532000, 46800, 226},
  {1743861600, 43200, 226},
  {1758981600, 46800, 226},
  {1775311200, 43200, 226},
  {1790431200, 46800, 226},
  {1806760800, 43200, 226},
  {1821880800, 46800, 226},
  {1838210400, 43200, 226},
  {1853330400, 46800, 226},
  {1869660000, 43200, 226},
  {1885384800, 46800, 226},
  {1901714400, 43200, 226},
  {1916834400, 46800, 226},
  {1933164000, 43200, 226},
  {1948284000, 46800, 226},
  {1964613600, 43200, 226},
  {1979733600, 46800, 226},
  {1996063200, 43200, 226},
  {2011183200, 46800, 226},
  {2027512800, 43200, 226},
  {2042632800, 46800, 226},
  {2058962400, 43200, 226},
  {2074687200, 46800, 226},
  {2091016800, 43200, 226},
  {2106136800, 46800, 226},
  {2122466400, 43200, 226},
  {2137586400, 46800, 226},
  {INT64_MIN, 0, 227},
  {-407808000, 10800, 227},
  {INT64_MIN, 0, 228},
  {-380073600, 21600, 228},
  {-1691884800, 7200, 229},
  {-1680573600, 3600, 229},
  {-927511200, 7200, 229},
  {-857257200, 3600, 229},
  {-844556400, 7200, 229},
  {-828226800, 3600, 229},
  {-812502000, 7200, 229},
  {-796777200, 3600, 229},
  {-781052400, 7200, 229},
  {-765327600, 3600, 229},
  {-340844400, 7200, 229},
  {-324514800, 3600, 229},
  {-308790000, 7200, 229},
  {-293065200, 3600, 229},
  {-277340400, 7200, 229},
  {-261615600, 3600, 229},
  {-245890800, 7200, 229},
  {-230166000, 3600, 229},
  {-214441200, 7200, 229},
  {-198716400, 3600, 229},
  {-182991600, 7200, 229},
  {-166662000, 3600, 229},
  {-147913200, 7200, 229},
  {-135212400, 3600, 229},
  {315529200, 3600, 229},
  {323830800, 7200, 229},
  {338950800, 3600, 229},
  {354675600, 7200, 229},
  {370400400, 3600, 229},
  {386125200, 7200, 229},
  {401850000, 3600, 229},
  {417574800, 7200, 229},
  {433299600, 3600, 229},
  {449024400, 7200, 229},
  {465354000, 3600, 229},
  {481078800, 7200, 229},
  {496803600, 3600, 229},
  {512528400, 7200, 229},
  {528253200, 3600, 229},
  {543978000, 7200, 229},
  {559702800, 3600, 229},
  {575427600, 7200, 229},
  {591152400, 3600, 229},
  {606877200, 7200, 229},
  {622602000, 3600, 229},
  {638326800, 7200, 229},
  {654656400, 3600, 229},
  {670381200, 7200, 229},
  {686106000, 3600, 229},
  {701830800, 7200, 229},
  {717555600, 3600, 229},
  {733280400, 7200, 229},
  {749005200, 3600, 229},
  {764730000, 7200, 229},
  {780454800, 3600, 229},
  {796179600, 7200, 229},
  {811904400, 3600, 229},
  {828234000, 7200, 229},
  {846378000, 3600, 229},
  {859683600, 7200, 229},
  {877827600, 3600, 229},
  {891133200, 7200, 229},
  {909277200, 3600, 229},
  {922582800, 7200, 229},
  {941331600, 3600, 229},
  {954032400, 7200, 229},
  {972781200, 3600, 229},
  {985482000, 7200, 229},
  {1004230800, 3600, 229},
  {1017536400, 7200, 229},
  {1035680400, 3600, 229},
  {1048986000, 7200, 229},
  {1067130000, 3600, 229},
  {1080435600, 7200, 229},
  {1099184400, 3600, 229},
  {1111885200, 7200, 229},
  {1130634000, 3600, 229},
  {1143334800, 7200, 229},
  {1162083600, 3600, 229},
  {1174784400, 7200, 229},
  {1193533200, 3600, 229},
  {1206838800, 7200, 229},
  {1224982800, 3600, 229},
  {1238288400, 7200, 229},
  {1256432400, 3600, 229},
  {1269738000, 7200, 229},
  {1288486800, 3600, 229},
  {1301187600, 7200, 229},
  {1319936400, 3600, 229},
  {1332637200, 7200, 229},
  {1351386000, 3600, 229},
  {1364691600, 7200, 229},
  {1382835600, 3600, 229},
  {1396141200, 7200, 229},
  {1414285200, 3600, 229},
  {1427590800, 7200, 229},
  {1445734800, 3600, 229},
  {1459040400, 7200, 229},
  {1477789200, 3600, 229},
  {1490490000, 7200, 229},
  {1509238800, 3600, 229},
  {1521939600, 7200, 229},
  {1540688400, 3600, 229},
  {1553994000, 7200, 229},
  {1572138000, 3600, 229},
  {1585443600, 7200, 229},
  {1603587600, 3600, 229},
  {1616893200, 7200, 229},
  {1635642000, 3600, 229},
  {1648342800, 7200, 229},
  {1667091600, 3600, 229},
  {1679792400, 7200, 229},
  {1698541200, 3600, 229},
  {1711846800, 7200, 229},
  {1729990800, 3600, 229},
  {1743296400, 7200, 229},
  {1761440400, 3600, 229},
  {1774746000, 7200, 229},
  {1792890000, 3600, 229},
  {1806195600, 7200, 229},
  {1824944400, 3600, 229},
  {1837645200, 7200, 229},
  {1856394000, 3600, 229},
  {1869094800, 7200, 229},
  {1887843600, 3600, 229},
  {1901149200, 7200, 229},
  {1919293200, 3600, 229},
  {1932598800, 7200, 229},
  {1950742800, 3600, 229},
  {1964048400, 7200, 229},
  {1982797200, 3600, 229},
  {1995498000, 7200, 229},
  {2014246800, 3600, 229},
  {2026947600, 7200, 229},
  {2045696400, 3600, 229},
  {2058397200, 7200, 229},
  {2077146000, 3600, 229},
  {2090451600, 7200, 229},
  {2108595600, 3600, 229},
  {2121901200, 7200, 229},
  {2140045200, 3600, 229},
  {INT64_MIN, 10848, 230},
  {-631162848, 10800, 230},
  {INT64_MIN, 18468, 231},
  {-1441170468, 18000, 231},
  {-1247547600, 21600, 231},
  {354909600, 25200, 231},
  {370717200, 21600, 231},
  {386445600, 25200, 231},
  {402253200, 21600, 231},
  {417981600, 25200, 231},
  {433789200, 21600, 231},
  {449604000, 25200, 231},
  {465336000, 21600, 231},
  {481060800, 25200, 231},
  {496785600, 21600, 231},
  {512510400, 25200, 231},
  {528235200, 21600, 231},
  {543960000, 25200, 231},
  {559684800, 21600, 231},
  {575409600, 25200, 231},
  {591134400, 21600, 231},
  {606859200, 25200, 231},
  {622584000, 21600, 231},
  {638308800, 25200, 231},
  {654638400, 21600, 231},
  {662666400, 21600, 231},
  {701802000, 25200, 231},
  {717523200, 21600, 231},
  {733262400, 25200, 231},
  {748987200, 21600, 231},
  {764712000, 25200, 231},
  {780436800, 21600, 231},
  {796161600, 25200, 231},
  {811886400, 21600, 231},
  {828216000, 25200, 231},
  {846360000, 21600, 231},
  {859665600, 25200, 231},
  {877809600, 21600, 231},
  {891115200, 25200, 231},
  {909259200, 21600, 231},
  {922564800, 25200, 231},
  {941313600, 21600, 231},
  {954014400, 25200, 231},
  {972763200, 21600, 231},
  {985464000, 25200, 231},
  {1004212800, 21600, 231},
  {1017518400, 25200, 231},
  {1035662400, 21600, 231},
  {1048968000, 25200, 231},
  {1067112000, 21600, 231},
  {1080417600, 25200, 231},
  {1099166400, 21600, 231},
  {1110823200, 21600, 231},
  {INT64_MIN, 8624, 232},
  {-1230776624, 7200, 232},
  {108165600, 10800, 232},
  {118270800, 7200, 232},
  {136591200, 10800, 232},
  {149806800, 7200, 232},
  {168127200, 10800, 232},
  {181342800, 7200, 232},
  {199749600, 10800, 232},
  {215643600, 7200, 232},
  {231285600, 10800, 232},
  {244501200, 7200, 232},
  {262735200, 10800, 232},
  {275950800, 7200, 232},
  {481154400, 10800, 232},
  {496962000, 7200, 232},
  {512949600, 10800, 232},
  {528670800, 7200, 232},
  {544399200, 10800, 232},
  {560120400, 7200, 232},
  {575848800, 10800, 232},
  {592174800, 7200, 232},
  {610581600, 10800, 232},
  {623624400, 7200, 232},
  {641167200, 10800, 232},
  {655074000, 7200, 232},
  {671839200, 10800, 232},
  {685918800, 7200, 232},
  {702856800, 10800, 232},
  {717973200, 7200, 232},
  {733701600, 10800, 232},
  {749422800, 7200, 232},
  {765151200, 10800, 232},
  {779662800, 7200, 232},
  {797205600, 10800, 232},
  {811116000, 7200, 232},
  {828655200, 10800, 232},
  {843170400, 7200, 232},
  {860104800, 10800, 232},
  {874620000, 7200, 232},
  {891554400, 10800, 232},
  {906069600, 7200, 232},
  {930780000, 10800, 232},
  {938124000, 7200, 232},
  {954367200, 10800, 232},
  {970178400, 7200, 232},
  {985816800, 10800, 232},
  {1001628000, 7200, 232},
  {1017352800, 10800, 232},
  {1033077600, 7200, 232},
  {1048802400, 10800, 232},
  {1066946400, 7200, 232},
  {1080252000, 10800, 232},
  {1097791200, 7200, 232},
  {1112306400, 10800, 232},
  {1128031200, 7200, 232},
  {1143756000, 10800, 232},
  {1161900000, 7200, 232},
  {1175205600, 10800, 232},
  {1193349600, 7200, 232},
  {1206655200, 10800, 232},
  {1225404000, 7200, 232},
  {1238104800, 10800, 232},
  {1256853600, 7200, 232},
  {1269554400, 10800, 232},
  {1288303200, 7200, 232},
  {1301608800, 10800, 232},
  {1319752800, 7200, 232},
  {1333058400, 10800, 232},
  {1351202400, 7200, 232},
  {1364508000, 10800, 232},
  {1382652000, 7200, 232},
  {1395957600, 10800, 232},
  {1414706400, 7200, 232},
  {1427407200, 10800, 232},
  {1446156000, 7200, 232},
  {1459461600, 10800, 232},
  {1477605600, 7200, 232},
  {1490911200, 10800, 232},
  {1509055200, 7200, 232},
  {1522360800, 10800, 232},
  {1540504800, 7200, 232},
  {1553810400, 10800, 232},
  {1571954400, 7200, 232},
  {1585260000, 10800, 232},
  {1604008800, 7200, 232},
  {1616709600, 10800, 232},
  {1635458400, 7200, 232},
  {1648764000, 10800, 232},
  {1666908000, 7200, 232},
  {1680213600, 10800, 232},
  {1698357600, 7200, 232},
  {1711663200, 10800, 232},
  {1729807200, 7200, 232},
  {1743112800, 10800, 232},
  {1761861600, 7200, 232},
  {1774562400, 10800, 232},
  {1793311200, 7200, 232},
  {1806012000, 10800, 232},
  {1824760800, 7200, 232},
  {1838066400, 10800, 232},
  {1856210400, 7200, 232},
  {1869516000, 10800, 232},
  {1887660000, 7200, 232},
  {1900965600, 10800, 232},
  {1919109600, 7200, 232},
  {1932415200, 10800, 232},
  {1951164000, 7200, 232},
  {1963864800, 10800, 232},
  {1982613600, 7200, 232},
  {1995919200, 10800, 232},
  {2014063200, 7200, 232},
  {2027368800, 10800, 232},
  {2045512800, 7200, 232},
  {2058818400, 10800, 232},
  {2076962400, 7200, 232},
  {2090268000, 10800, 232},
  {2109016800, 7200, 232},
  {2121717600, 10800, 232},
  {2140466400, 7200, 232},
  {INT64_MIN, 42596, 233},
  {-1441194596, 43200, 233},
  {-1247572800, 46800, 233},
  {354884400, 50400, 233},
  {370692000, 46800, 233},
  {386420400, 46800, 233},
  {402231600, 43200, 233},
  {417960000, 46800, 233},
  {433767600, 43200, 233},
  {449582400, 46800, 233},
  {465314400, 43200, 233},
  {481039200, 46800, 233},
  {496764000, 43200, 233},
  {512488800, 46800, 233},
  {528213600, 43200, 233},
  {543938400, 46800, 233},
  {559663200, 43200, 233},
  {575388000, 46800, 233},
  {591112800, 43200, 233},
  {606837600, 46800, 233},
  {622562400, 43200, 233},
  {638287200, 46800, 233},
  {654616800, 43200, 233},
  {670341600, 43200, 233},
  {686070000, 39600, 233},
  {695746800, 43200, 233},
  {701780400, 46800, 233},
  {717501600, 43200, 233},
  {733240800, 46800, 233},
  {748965600, 43200, 233},
  {764690400, 46800, 233},
  {780415200, 43200, 233},
  {796140000, 46800, 233},
  {811864800, 43200, 233},
  {828194400, 46800, 233},
  {846338400, 43200, 233},
  {859644000, 46800, 233},
  {877788000, 43200, 233},
  {891093600, 46800, 233},
  {909237600, 43200, 233},
  {922543200, 46800, 233},
  {941292000, 43200, 233},
  {953992800, 46800, 233},
  {972741600, 43200, 233},
  {985442400, 46800, 233},
  {1004191200, 43200, 233},
  {1017496800, 46800, 233},
  {1035640800, 43200, 233},
  {1048946400, 46800, 233},
  {1067090400, 43200, 233},
  {1080396000, 46800, 233},
  {1099144800, 43200, 233},
  {1111845600, 46800, 233},
  {1130594400, 43200, 233},
  {1143295200, 46800, 233},
  {1162044000, 43200, 233},
  {1174744800, 46800, 233},
  {1193493600, 43200, 233},
  {1206799200, 46800, 233},
  {1224943200, 43200, 233},
  {1238248800, 46800, 233},
  {1256392800, 43200, 233},
  {1269698400, 43200, 233},
  {1288450800, 39600, 233},
  {1301151600, 43200, 233},
  {INT64_MIN, 14400, 234},
  {INT64_MIN, 12064, 234},
  {-1441164064, 14400, 234},
  {-1247544000, 18000, 234},
  {-220942800, 18000, 234},
  {370724400, 21600, 234},
  {386445600, 21600, 234},
  {402256800, 18000, 234},
  {417985200, 21600, 234},
  {433792800, 18000, 234},
  {449607600, 21600, 234},
  {465339600, 18000, 234},
  {481064400, 21600, 234},
  {496789200, 18000, 234},
  {512514000, 21600, 234},
  {528238800, 18000, 234},
  {543963600, 21600, 234},
  {559688400, 18000, 234},
  {575413200, 21600, 234},
  {591138000, 18000, 234},
  {606862800, 21600, 234},
  {622587600, 18000, 234},
  {638312400, 21600, 234},
  {654642000, 18000, 234},
  {662670000, 18000, 234},
  {692823600, 18000, 234},
  {701805600, 21600, 234},
  {717526800, 18000, 234},
  {733266000, 21600, 234},
  {748990800, 18000, 234},
  {764715600, 21600, 234},
  {780440400, 18000, 234},
  {796165200, 18000, 234},
  {811893600, 14400, 234},
  {828223200, 18000, 234},
  {846367200, 14400, 234},
  {859672800, 18000, 234},
  {877816800, 14400, 234},
  {891122400, 18000, 234},
  {909266400, 14400, 234},
  {922572000, 18000, 234},
  {941320800, 14400, 234},
  {954021600, 18000, 234},
  {972770400, 14400, 234},
  {985471200, 18000, 234},
  {1004220000, 14400, 234},
  {1017525600, 18000, 234},
  {1035669600, 14400, 234},
  {1048975200, 18000, 234},
  {1067119200, 14400, 234},
  {1080424800, 18000, 234},
  {1099173600, 14400, 234},
  {1110830400, 18000, 234},
  {INT64_MIN, 13720, 235},
  {-1441165720, 14400, 235},
  {-1247544000, 18000, 235},
  {354913200, 21600, 235},
  {370720800, 21600, 235},
  {386445600, 21600, 235},
  {402256800, 18000, 235},
  {417985200, 21600, 235},
  {433792800, 18000, 235},
  {449607600, 21600, 235},
  {465339600, 18000, 235},
  {481064400, 21600, 235},
  {496789200, 18000, 235},
  {512514000, 21600, 235},
  {528238800, 18000, 235},
  {543963600, 21600, 235},
  {559688400, 18000, 235},
  {575413200, 21600, 235},
  {591138000, 18000, 235},
  {606862800, 21600, 235},
  {622587600, 18000, 235},
  {638312400, 21600, 235},
  {654642000, 18000, 235},
  {662670000, 18000, 235},
  {692823600, 18000, 235},
  {701805600, 21600, 235},
  {717526800, 18000, 235},
  {733266000, 21600, 235},
  {748990800, 18000, 235},
  {764715600, 21600, 235},
  {780440400, 18000, 235},
  {796165200, 21600, 235},
  {811890000, 18000, 235},
  {828219600, 21600, 235},
  {846363600, 18000, 235},
  {859669200, 21600, 235},
  {877813200, 18000, 235},
  {891118800, 21600, 235},
  {909262800, 18000, 235},
  {922568400, 21600, 235},
  {941317200, 18000, 235},
  {954018000, 21600, 235},
  {972766800, 18000, 235},
  {985467600, 21600, 235},
  {1004216400, 18000, 235},
  {1017522000, 21600, 235},
  {1035666000, 18000, 235},
  {1048971600, 21600, 235},
  {1067115600, 18000, 235},
  {1080421200, 21600, 235},
  {1099170000, 18000, 235},
  {1110826800, 18000, 235},
  {INT64_MIN, 14012, 236},
  {-1441166012, 14400, 236},
  {-1247544000, 18000, 236},
  {354913200, 21600, 236},
  {370720800, 18000, 236},
  {386449200, 21600, 236},
  {402256800, 18000, 236},
  {417985200, 21600, 236},
  {433792800, 18000, 236},
  {449607600, 21600, 236},
  {465339600, 18000, 236},
  {481064400, 21600, 236},
  {496789200, 18000, 236},
  {512514000, 21600, 236},
  {528238800, 18000, 236},
  {543963600, 21600, 236},
  {559688400, 18000, 236},
  {575413200, 21600, 236},
  {591138000, 18000, 236},
  {606862800, 21600, 236},
  {622587600, 18000, 236},
  {638312400, 21600, 236},
  {654642000, 18000, 236},
  {670366800, 18000, 236},
  {686095200, 14400, 236},
  {688507200, 14400, 236},
  {695772000, 18000, 236},
  {INT64_MIN, 14012, 237},
  {-1441166012, 14400, 237},
  {-1247544000, 18000, 237},
  {354913200, 21600, 237},
  {370720800, 18000, 237},
  {386449200, 21600, 237},
  {402256800, 18000, 237},
  {417985200, 21600, 237},
  {433792800, 18000, 237},
  {449607600, 21600, 237},
  {465339600, 18000, 237},
  {481064400, 21600, 237},
  {496789200, 18000, 237},
  {512514000, 21600, 237},
  {528238800, 18000, 237},
  {543963600, 21600, 237},
  {559688400, 18000, 237},
  {575413200, 21600, 237},
  {591138000, 18000, 237},
  {606862800, 21600, 237},
  {622587600, 18000, 237},
  {638312400, 21600, 237},
  {654642000, 18000, 237},
  {670366800, 18000, 237},
  {686095200, 14400, 237},
  {688507200, 14400, 237},
  {695772000, 18000, 237},
  {INT64_MIN, 10656, 238},
  {-1641005856, 10800, 238},
  {389048400, 14400, 238},
  {402264000, 10800, 238},
  {417906000, 14400, 238},
  {433800000, 10800, 238},
  {449614800, 14400, 238},
  {465422400, 10800, 238},
  {481150800, 14400, 238},
  {496792800, 10800, 238},
  {512517600, 14400, 238},
  {528242400, 10800, 238},
  {543967200, 14400, 238},
  {559692000, 10800, 238},
  {575416800, 14400, 238},
  {591141600, 10800, 238},
  {606866400, 14400, 238},
  {622591200, 10800, 238},
  {638316000, 14400, 238},
  {654645600, 10800, 238},
  {670464000, 14400, 238},
  {686275200, 10800, 238},
  {702086400, 14400, 238},
  {717897600, 10800, 238},
  {733622400, 14400, 238},
  {749433600, 10800, 238},
  {765158400, 14400, 238},
  {780969600, 10800, 238},
  {796694400, 14400, 238},
  {812505600, 10800, 238},
  {828316800, 14400, 238},
  {844128000, 10800, 238},
  {859852800, 14400, 238},
  {875664000, 10800, 238},
  {891388800, 14400, 238},
  {907200000, 10800, 238},
  {922924800, 14400, 238},
  {938736000, 10800, 238},
  {954547200, 14400, 238},
  {970358400, 10800, 238},
  {986083200, 14400, 238},
  {1001894400, 10800, 238},
  {1017619200, 14400, 238},
  {1033430400, 10800, 238},
  {1049155200, 14400, 238},
  {1064966400, 10800, 238},
  {1080777600, 14400, 238},
  {1096588800, 10800, 238},
  {1112313600, 14400, 238},
  {1128124800, 10800, 238},
  {1143849600, 14400, 238},
  {1159660800, 10800, 238},
  {1175385600, 14400, 238},
  {1191196800, 10800, 238},
  {INT64_MIN, 12140, 239},
  {-1577935340, 14400, 239},
  {76190400, 10800, 239},
  {INT64_MIN, 11964, 240},
  {-1441163964, 10800, 240},
  {-405140400, 14400, 240},
  {354916800, 18000, 240},
  {370724400, 14400, 240},
  {386452800, 18000, 240},
  {402260400, 14400, 240},
  {417988800, 18000, 240},
  {433796400, 14400, 240},
  {449611200, 18000, 240},
  {465343200, 14400, 240},
  {481068000, 18000, 240},
  {496792800, 14400, 240},
  {512517600, 18000, 240},
  {528242400, 14400, 240},
  {543967200, 18000, 240},
  {559692000, 14400, 240},
  {575416800, 18000, 240},
  {591141600, 14400, 240},
  {606866400, 18000, 240},
  {622591200, 14400, 240},
  {638316000, 18000, 240},
  {654645600, 14400, 240},
  {670370400, 14400, 240},
  {683496000, 14400, 240},
  {686098800, 10800, 240},
  {701812800, 14400, 240},
  {717534000, 14400, 240},
  {828234000, 18000, 240},
  {846378000, 14400, 240},
  {852062400, 14400, 240},
  {859680000, 18000, 240},
  {877824000, 14400, 240},
  {891129600, 18000, 240},
  {909273600, 14400, 240},
  {922579200, 18000, 240},
  {941328000, 14400, 240},
  {954028800, 18000, 240},
  {972777600, 14400, 240},
  {985478400, 18000, 240},
  {1004227200, 14400, 240},
  {1017532800, 18000, 240},
  {1035676800, 14400, 240},
  {1048982400, 18000, 240},
  {1067126400, 14400, 240},
  {1080432000, 18000, 240},
  {1099180800, 14400, 240},
  {1111881600, 18000, 240},
  {1130630400, 14400, 240},
  {1143331200, 18000, 240},
  {1162080000, 14400, 240},
  {1174780800, 18000, 240},
  {1193529600, 14400, 240},
  {1206835200, 18000, 240},
  {1224979200, 14400, 240},
  {1238284800, 18000, 240},
  {1256428800, 14400, 240},
  {1269734400, 18000, 240},
  {1288483200, 14400, 240},
  {1301184000, 18000, 240},
  {1319932800, 14400, 240},
  {1332633600, 18000, 240},
  {1351382400, 14400, 240},
  {1364688000, 18000, 240},
  {1382832000, 14400, 240},
  {1396137600, 18000, 240},
  {1414281600, 14400, 240},
  {1427587200, 18000, 240},
  {1445731200, 14400, 240},
  {1459036800, 18000, 240},
  {1477785600, 14400, 240},
  {1490486400, 18000, 240},
  {1509235200, 14400, 240},
  {1521936000, 18000, 240},
  {1540684800, 14400, 240},
  {1553990400, 18000, 240},
  {1572134400, 14400, 240},
  {1585440000, 18000, 240},
  {1603584000, 14400, 240},
  {1616889600, 18000, 240},
  {1635638400, 14400, 240},
  {1648339200, 18000, 240},
  {1667088000, 14400, 240},
  {1679788800, 18000, 240},
  {1698537600, 14400, 240},
  {1711843200, 18000, 240},
  {1729987200, 14400, 240},
  {1743292800, 18000, 240},
  {1761436800, 14400, 240},
  {1774742400, 18000, 240},
  {1792886400, 14400, 240},
  {1806192000, 18000, 240},
  {1824940800, 14400, 240},
  {1837641600, 18000, 240},
  {1856390400, 14400, 240},
  {1869091200, 18000, 240},
  {1887840000, 14400, 240},
  {1901145600, 18000, 240},
  {1919289600, 14400, 240},
  {1932595200, 18000, 240},
  {1950739200, 14400, 240},
  {1964044800, 18000, 240},
  {1982793600, 14400, 240},
  {1995494400, 18000, 240},
  {2014243200, 14400, 240},
  {2026944000, 18000, 240},
  {2045692800, 14400, 240},
  {2058393600, 18000, 240},
  {2077142400, 14400, 240},
  {2090448000, 18000, 240},
  {2108592000, 14400, 240},
  {2121897600, 18000, 240},
  {2140041600, 14400, 240},
  {INT64_MIN, 24124, 241},
  {-1570084924, 25200, 241},
  {-1570413600, 10800, 242},
  {-1552186800, 7200, 242},
  {-1538359200, 10800, 242},
  {-1522551600, 7200, 242},
  {-1507514400, 10800, 242},
  {-1490583600, 7200, 242},
  {-1473645600, 10800, 242},
  {-1460948400, 7200, 242},
  {-399866400, 10800, 242},
  {-386650800, 7200, 242},
  {-368330400, 10800, 242},
  {-355114800, 7200, 242},
  {-336794400, 10800, 242},
  {-323578800, 7200, 242},
  {-305172000, 10800, 242},
  {-291956400, 7200, 242},
  {-273636000, 10800, 242},
  {-260420400, 7200, 242},
  {78012000, 10800, 242},
  {86734800, 7200, 242},
  {105055200, 10800, 242},
  {118270800, 7200, 242},
  {136591200, 10800, 242},
  {149806800, 7200, 242},
  {168127200, 10800, 242},
  {181342800, 7200, 242},
  {199749600, 10800, 242},
  {212965200, 7200, 242},
  {231285600, 10800, 242},
  {244501200, 7200, 242},
  {262735200, 10800, 242},
  {275950800, 7200, 242},
  {452210400, 10800, 242},
  {466722000, 7200, 242},
  {483746400, 10800, 242},
  {498258000, 7200, 242},
  {515282400, 10800, 242},
  {529794000, 7200, 242},
  {546818400, 10800, 242},
  {561330000, 7200, 242},
  {581119200, 10800, 242},
  {592952400, 7200, 242},
  {610754400, 10800, 242},
  {624488400, 7200, 242},
  {641512800, 10800, 242},
  {656024400, 7200, 242},
  {673048800, 10800, 242},
  {687560400, 7200, 242},
  {704671200, 10800, 242},
  {718146000, 7200, 242},
  {733269600, 10800, 242},
  {748990800, 7200, 242},
  {764719200, 10800, 242},
  {780440400, 7200, 242},
  {796168800, 10800, 242},
  {811890000, 7200, 242},
  {828223200, 10800, 242},
  {843944400, 7200, 242},
  {859672800, 10800, 242},
  {875394000, 7200, 242},
  {891122400, 10800, 242},
  {906843600, 7200, 242},
  {922572000, 10800, 242},
  {941317200, 7200, 242},
  {954021600, 10800, 242},
  {972766800, 7200, 242},
  {985471200, 10800, 242},
  {1004216400, 7200, 242},
  {1017525600, 10800, 242},
  {1035666000, 7200, 242},
  {1048975200, 10800, 242},
  {1067115600, 7200, 242},
  {1080424800, 10800, 242},
  {1099170000, 7200, 242},
  {1111874400, 10800, 242},
  {1130619600, 7200, 242},
  {1143324000, 10800, 242},
  {1162069200, 7200, 242},
  {1174773600, 10800, 242},
  {1193518800, 7200, 242},
  {1206828000, 10800, 242},
  {1224968400, 7200, 242},
  {1238277600, 10800, 242},
  {1256418000, 7200, 242},
  {1269727200, 10800, 242},
  {1288472400, 7200, 242},
  {1301176800, 10800, 242},
  {1319922000, 7200, 242},
  {1332626400, 10800, 242},
  {1351371600, 7200, 242},
  {1364680800, 10800, 242},
  {1382821200, 7200, 242},
  {1396130400, 10800, 242},
  {1414270800, 7200, 242},
  {1427580000, 10800, 242},
  {1445720400, 7200, 242},
  {1459029600, 10800, 242},
  {1477774800, 7200, 242},
  {1490479200, 10800, 242},
  {1509224400, 7200, 242},
  {1521928800, 10800, 242},
  {1540674000, 7200, 242},
  {1553983200, 10800, 242},
  {1572123600, 7200, 242},
  {1585432800, 10800, 242},
  {1603573200, 7200, 242},
  {1616882400, 10800, 242},
  {1635627600, 7200, 242},
  {1648332000, 10800, 242},
  {1667077200, 7200, 242},
  {1679781600, 10800, 242},
  {1698526800, 7200, 242},
  {1711836000, 10800, 242},
  {1729976400, 7200, 242},
  {1743285600, 10800, 242},
  {1761426000, 7200, 242},
  {1774735200, 10800, 242},
  {1792875600, 7200, 242},
  {1806184800, 10800, 242},
  {1824930000, 7200, 242},
  {1837634400, 10800, 242},
  {1856379600, 7200, 242},
  {1869084000, 10800, 242},
  {1887829200, 7200, 242},
  {1901138400, 10800, 242},
  {1919278800, 7200, 242},
  {1932588000, 10800, 242},
  {1950728400, 7200, 242},
  {1964037600, 10800, 242},
  {1982782800, 7200, 242},
  {1995487200, 10800, 242},
  {2014232400, 7200, 242},
  {2026936800, 10800, 242},
  {2045682000, 7200, 242},
  {2058386400, 10800, 242},
  {2077131600, 7200, 242},
  {2090440800, 10800, 242},
  {2108581200, 7200, 242},
  {2121890400, 10800, 242},
  {2140030800, 7200, 242},
  {INT64_MIN, 17904, 243},
  {-1441169904, 18000, 243},
  {-1247547600, 21600, 243},
  {354909600, 25200, 243},
  {370717200, 21600, 243},
  {386445600, 25200, 243},
  {402253200, 21600, 243},
  {417981600, 25200, 243},
  {433789200, 21600, 243},
  {449604000, 25200, 243},
  {465336000, 21600, 243},
  {481060800, 25200, 243},
  {496785600, 21600, 243},
  {512510400, 25200, 243},
  {528235200, 21600, 243},
  {543960000, 25200, 243},
  {559684800, 21600, 243},
  {575409600, 25200, 243},
  {591134400, 21600, 243},
  {606859200, 25200, 243},
  {622584000, 21600, 243},
  {638308800, 25200, 243},
  {654638400, 21600, 243},
  {670363200, 21600, 243},
  {683582400, 18000, 243},
  {703018800, 21600, 243},
  {717530400, 18000, 243},
  {734468400, 21600, 243},
  {748980000, 18000, 243},
  {765918000, 21600, 243},
  {780429600, 18000, 243},
  {797367600, 21600, 243},
  {811879200, 18000, 243},
  {828817200, 21600, 243},
  {843933600, 18000, 243},
  {859671000, 21600, 243},
  {877811400, 18000, 243},
  {891120600, 21600, 243},
  {909261000, 18000, 243},
  {922570200, 21600, 243},
  {941315400, 18000, 243},
  {954019800, 21600, 243},
  {972765000, 18000, 243},
  {985469400, 21600, 243},
  {1004214600, 18000, 243},
  {1017523800, 21600, 243},
  {1035664200, 18000, 243},
  {1048973400, 21600, 243},
  {1067113800, 18000, 243},
  {1080423000, 21600, 243},
  {1099168200, 18000, 243},
  {1111872600, 21600, 243},
  {1123783200, 21600, 243},
  {INT64_MIN, 27580, 244},
  {-1383464380, 27000, 244},
  {-1167636600, 28800, 244},
  {INT64_MIN, 21200, 245},
  {-891582800, 23400, 245},
  {-872058600, 19800, 245},
  {-862637400, 23400, 245},
  {-764145000, 19800, 245},
  {INT64_MIN, 27480, 246},
  {-2032933080, 25200, 246},
  {252435600, 28800, 246},
  {417974400, 36000, 246},
  {433778400, 32400, 246},
  {449593200, 36000, 246},
  {465314400, 32400, 246},
  {481042800, 36000, 246},
  {496764000, 32400, 246},
  {512492400, 36000, 246},
  {528213600, 32400, 246},
  {543942000, 36000, 246},
  {559663200, 32400, 246},
  {575391600, 36000, 246},
  {591112800, 32400, 246},
  {606841200, 36000, 246},
  {622562400, 32400, 246},
  {638290800, 36000, 246},
  {654616800, 32400, 246},
  {670345200, 36000, 246},
  {686066400, 32400, 246},
  {701794800, 36000, 246},
  {717516000, 32400, 246},
  {733244400, 36000, 246},
  {748965600, 32400, 246},
  {764694000, 36000, 246},
  {780415200, 32400, 246},
  {796143600, 36000, 246},
  {811864800, 32400, 246},
  {828198000, 36000, 246},
  {843919200, 32400, 246},
  {859647600, 36000, 246},
  {875368800, 32400, 246},
  {891097200, 36000, 246},
  {906818400, 32400, 246},
  {988390800, 36000, 246},
  {1001692800, 32400, 246},
  {1017421200, 36000, 246},
  {1033142400, 32400, 246},
  {1048870800, 36000, 246},
  {1064592000, 32400, 246},
  {1080320400, 36000, 246},
  {1096041600, 32400, 246},
  {1111770000, 36000, 246},
  {1127491200, 32400, 246},
  {1143219600, 36000, 246},
  {1159545600, 32400, 246},
  {1206889200, 28800, 246},
  {INT64_MIN, 25580, 247},
  {-1325487980, 25200, 247},
  {325962000, 28800, 247},
  {515520000, 32400, 247},
  {527007600, 28800, 247},
  {545155200, 32400, 247},
  {558457200, 28800, 247},
  {576604800, 32400, 247},
  {589906800, 28800, 247},
  {608659200, 32400, 247},
  {621961200, 28800, 247},
  {640108800, 32400, 247},
  {653410800, 28800, 247},
  {671558400, 32400, 247},
  {684860400, 28800, 247},
  {INT64_MIN, 25580, 248},
  {-1325487980, 25200, 248},
  {325962000, 28800, 248},
  {515520000, 32400, 248},
  {527007600, 28800, 248},
  {545155200, 32400, 248},
  {558457200, 28800, 248},
  {576604800, 32400, 248},
  {589906800, 28800, 248},
  {608659200, 32400, 248},
  {621961200, 28800, 248},
  {640108800, 32400, 248},
  {653410800, 28800, 248},
  {671558400, 32400, 248},
  {684860400, 28800, 248},
  {INT64_MIN, 19172, 249},
  {-2019705572, 19800, 249},
  {-883287000, 21600, 249},
  {-862639200, 23400, 249},
  {-764051400, 19800, 249},
  {832962600, 23400, 249},
  {846266400, 21600, 249},
  {1145039400, 19800, 249},
  {INT64_MIN, 21200, 250},
  {-891582800, 23400, 250},
  {-872058600, 19800, 250},
  {-862637400, 23400, 250},
  {-576138600, 21600, 250},
  {38772000, 21600, 250},
  {1245430800, 25200, 250},
  {1262278740, 21600, 250},
  {INT64_MIN, 8712, 251},
  {-1577931912, 7200, 251},
  {-1568592000, 10800, 251},
  {-1554080400, 7200, 251},
  {-1537142400, 10800, 251},
  {-1522630800, 7200, 251},
  {-1505692800, 10800, 251},
  {-1491181200, 7200, 251},
  {-1474243200, 10800, 251},
  {-1459126800, 7200, 251},
  {-242265600, 10800, 251},
  {-228877200, 7200, 251},
  {-210556800, 10800, 251},
  {-197427600, 7200, 251},
  {-178934400, 10800, 251},
  {-165718800, 7200, 251},
  {-147398400, 10800, 251},
  {-134269200, 7200, 251},
  {-116467200, 10800, 251},
  {-102646800, 7200, 251},
  {-84326400, 10800, 251},
  {-71110800, 7200, 251},
  {-52704000, 10800, 251},
  {-39488400, 7200, 251},
  {-21168000, 10800, 251},
  {-7952400, 7200, 251},
  {10368000, 10800, 251},
  {23583600, 7200, 251},
  {41904000, 10800, 251},
  {55119600, 7200, 251},
  {73526400, 10800, 251},
  {86742000, 7200, 251},
  {105062400, 10800, 251},
  {118278000, 7200, 251},
  {136598400, 10800, 251},
  {149814000, 7200, 251},
  {168134400, 10800, 251},
  {181350000, 7200, 251},
  {199756800, 10800, 251},
  {212972400, 7200, 251},
  {231292800, 10800, 251},
  {241916400, 7200, 251},
  {262828800, 10800, 251},
  {273452400, 7200, 251},
  {418694400, 10800, 251},
  {433810800, 7200, 251},
  {450316800, 10800, 251},
  {465433200, 7200, 251},
  {508896000, 10800, 251},
  {529196400, 7200, 251},
  {541555200, 10800, 251},
  {562633200, 7200, 251},
  {574387200, 10800, 251},
  {594255600, 7200, 251},
  {607305600, 10800, 251},
  {623199600, 7200, 251},
  {638928000, 10800, 251},
  {654649200, 7200, 251},
  {670456800, 10800, 251},
  {686264400, 7200, 251},
  {702684000, 10800, 251},
  {717886800, 7200, 251},
  {733096800, 10800, 251},
  {748904400, 7200, 251},
  {765151200, 10800, 251},
  {780958800, 7200, 251},
  {796687200, 10800, 251},
  {812494800, 7200, 251},
  {828309600, 10800, 251},
  {844117200, 7200, 251},
  {859759200, 10800, 251},
  {875653200, 7200, 251},
  {891208800, 10800, 251},
  {907189200, 7200, 251},
  {922917600, 10800, 251},
  {938725200, 7200, 251},
  {954540000, 10800, 251},
  {970347600, 7200, 251},
  {986076000, 10800, 251},
  {1001883600, 7200, 251},
  {1017612000, 10800, 251},
  {1033419600, 7200, 251},
  {1049148000, 10800, 251},
  {1064955600, 7200, 251},
  {1080770400, 10800, 251},
  {1096578000, 7200, 251},
  {1112306400, 10800, 251},
  {1128114000, 7200, 251},
  {1143842400, 10800, 251},
  {1158872400, 7200, 251},
  {1175205600, 10800, 251},
  {1193950800, 7200, 251},
  {1207260000, 10800, 251},
  {1225486800, 7200, 251},
  {1238104800, 10800, 251},
  {1256850000, 7200, 251},
  {1270159200, 10800, 251},
  {1288299600, 7200, 251},
  {1301608800, 10800, 251},
  {1319749200, 7200, 251},
  {1333663200, 10800, 251},
  {1351198800, 7200, 251},
  {1365112800, 10800, 251},
  {1382648400, 7200, 251},
  {1396562400, 10800, 251},
  {1414702800, 7200, 251},
  {1428012000, 10800, 251},
  {1446152400, 7200, 251},
  {1459461600, 10800, 251},
  {1477602000, 7200, 251},
  {1491516000, 10800, 251},
  {1509051600, 7200, 251},
  {1522965600, 10800, 251},
  {1540501200, 7200, 251},
  {1554415200, 10800, 251},
  {1571950800, 7200, 251},
  {1585864800, 10800, 251},
  {1604005200, 7200, 251},
  {1617314400, 10800, 251},
  {1635454800, 7200, 251},
  {1648764000, 10800, 251},
  {1666904400, 7200, 251},
  {1680818400, 10800, 251},
  {1698354000, 7200, 251},
  {1712268000, 10800, 251},
  {1729803600, 7200, 251},
  {1743717600, 10800, 251},
  {1761858000, 7200, 251},
  {1775167200, 10800, 251},
  {1793307600, 7200, 251},
  {1806616800, 10800, 251},
  {1824757200, 7200, 251},
  {1838671200, 10800, 251},
  {1856206800, 7200, 251},
  {1870120800, 10800, 251},
  {1887656400, 7200, 251},
  {1901570400, 10800, 251},
  {1919106000, 7200, 251},
  {1933020000, 10800, 251},
  {1951160400, 7200, 251},
  {1964469600, 10800, 251},
  {1982610000, 7200, 251},
  {1995919200, 10800, 251},
  {2014059600, 7200, 251},
  {2027973600, 10800, 251},
  {2045509200, 7200, 251},
  {2059423200, 10800, 251},
  {2076958800, 7200, 251},
  {2090872800, 10800, 251},
  {2109013200, 7200, 251},
  {2122322400, 10800, 251},
  {2140462800, 7200, 251},
  {INT64_MIN, 21200, 252},
  {-891582800, 23400, 252},
  {-872058600, 19800, 252},
  {-862637400, 23400, 252},
  {-576138600, 21600, 252},
  {38772000, 21600, 252},
  {1245430800, 25200, 252},
  {1262278740, 21600, 252},
  {INT64_MIN, 30140, 253},
  {-1830414140, 28800, 253},
  {-879152400, 32400, 253},
  {-766054800, 32400, 253},
  {199897200, 28800, 253},
  {969120000, 32400, 253},
  {INT64_MIN, 13272, 254},
  {-1577936472, 14400, 254},
  {INT64_MIN, 16512, 255},
  {-1441168512, 18000, 255},
  {-1247547600, 21600, 255},
  {354909600, 25200, 255},
  {370717200, 21600, 255},
  {386445600, 25200, 255},
  {402253200, 21600, 255},
  {417981600, 25200, 255},
  {433789200, 21600, 255},
  {449604000, 25200, 255},
  {465336000, 21600, 255},
  {481060800, 25200, 255},
  {496785600, 21600, 255},
  {512510400, 25200, 255},
  {528235200, 21600, 255},
  {543960000, 25200, 255},
  {559684800, 21600, 255},
  {575409600, 25200, 255},
  {591134400, 21600, 255},
  {606859200, 25200, 255},
  {622584000, 21600, 255},
  {638308800, 25200, 255},
  {654638400, 21600, 255},
  {670363200, 21600, 255},
  {684363600, 18000, 255},
  {-933645600, 10800, 256},
  {-857358000, 7200, 256},
  {-844300800, 10800, 256},
  {-825822000, 7200, 256},
  {-812685600, 10800, 256},
  {-794199600, 7200, 256},
  {-779853600, 10800, 256},
  {-762656400, 7200, 256},
  {-748310400, 10800, 256},
  {-731127600, 7200, 256},
  {-399088800, 10800, 256},
  {-386650800, 7200, 256},
  {-368330400, 10800, 256},
  {-355114800, 7200, 256},
  {-336790800, 10800, 256},
  {-323654400, 7200, 256},
  {-305168400, 10800, 256},
  {-292032000, 7200, 256},
  {-273632400, 10800, 256},
  {-260496000, 7200, 256},
  {-242096400, 10800, 256},
  {-228960000, 7200, 256},
  {-210560400, 10800, 256},
  {-197424000, 7200, 256},
  {-178938000, 10800, 256},
  {-165801600, 7200, 256},
  {-147402000, 10800, 256},
  {-134265600, 7200, 256},
  {-115866000, 10800, 256},
  {-102643200, 7200, 256},
  {-84330000, 10800, 256},
  {-81313200, 7200, 256},
  {142380000, 10800, 256},
  {150843600, 7200, 256},
  {167176800, 10800, 256},
  {178664400, 7200, 256},
  {482277600, 10800, 256},
  {495579600, 7200, 256},
  {516751200, 10800, 256},
  {526424400, 7200, 256},
  {545436000, 10800, 256},
  {558478800, 7200, 256},
  {576540000, 10800, 256},
  {589237200, 7200, 256},
  {609890400, 10800, 256},
  {620773200, 7200, 256},
  {638316000, 10800, 256},
  {651618000, 7200, 256},
  {669765600, 10800, 256},
  {683672400, 7200, 256},
  {701820000, 10800, 256},
  {715726800, 7200, 256},
  {733701600, 10800, 256},
  {747176400, 7200, 256},
  {765151200, 10800, 256},
  {778021200, 7200, 256},
  {796600800, 10800, 256},
  {810075600, 7200, 256},
  {820447200, 7200, 256},
  {828655200, 10800, 256},
  {843170400, 7200, 256},
  {860104800, 10800, 256},
  {874620000, 7200, 256},
  {891554400, 10800, 256},
  {906069600, 7200, 256},
  {915141600, 7200, 256},
  {924213600, 10800, 256},
  {939934800, 7200, 256},
  {956268000, 10800, 256},
  {971989200, 7200, 256},
  {987717600, 10800, 256},
  {1003438800, 7200, 256},
  {1019167200, 10800, 256},
  {1034888400, 7200, 256},
  {1050616800, 10800, 256},
  {1066338000, 7200, 256},
  {1082066400, 10800, 256},
  {1096581600, 7200, 256},
  {1113516000, 10800, 256},
  {1128380400, 7200, 256},
  {1143842400, 10800, 256},
  {1158872400, 7200, 256},
  {1175378400, 10800, 256},
  {1189638000, 7200, 256},
  {1207000800, 10800, 256},
  {1219957200, 7200, 256},
  {1238104800, 10800, 256},
  {1252018800, 7200, 256},
  {1269640860, 10800, 256},
  {1281474000, 7200, 256},
  {1301738460, 10800, 256},
  {1312146000, 7200, 256},
  {INT64_MIN, 30404, 257},
  {-1325492804, 30600, 257},
  {-1194078600, 28800, 257},
  {-946800000, 32400, 257},
  {-115894800, 30600, 257},
  {325956600, 28800, 257},
  {515520000, 32400, 257},
  {527007600, 28800, 257},
  {545155200, 32400, 257},
  {558457200, 28800, 257},
  {576604800, 32400, 257},
  {589906800, 28800, 257},
  {608659200, 32400, 257},
  {621961200, 28800, 257},
  {640108800, 32400, 257},
  {653410800, 28800, 257},
  {671558400, 32400, 257},
  {684860400, 28800, 257},
  {-933645600, 10800, 258},
  {-857358000, 7200, 258},
  {-844300800, 10800, 258},
  {-825822000, 7200, 258},
  {-812685600, 10800, 258},
  {-794199600, 7200, 258},
  {-779853600, 10800, 258},
  {-762656400, 7200, 258},
  {-748310400, 10800, 258},
  {-731127600, 7200, 258},
  {-399088800, 10800, 258},
  {-386650800, 7200, 258},
  {-368330400, 10800, 258},
  {-355114800, 7200, 258},
  {-336790800, 10800, 258},
  {-323654400, 7200, 258},
  {-305168400, 10800, 258},
  {-292032000, 7200, 258},
  {-273632400, 10800, 258},
  {-260496000, 7200, 258},
  {-242096400, 10800, 258},
  {-228960000, 7200, 258},
  {-210560400, 10800, 258},
  {-197424000, 7200, 258},
  {-178938000, 10800, 258},
  {-165801600, 7200, 258},
  {-147402000, 10800, 258},
  {-134265600, 7200, 258},
  {-115866000, 10800, 258},
  {-102643200, 7200, 258},
  {-84330000, 10800, 258},
  {-81313200, 7200, 258},
  {142380000, 10800, 258},
  {150843600, 7200, 258},
  {167176800, 10800, 258},
  {178664400, 7200, 258},
  {482277600, 10800, 258},
  {495579600, 7200, 258},
  {516751200, 10800, 258},
  {526424400, 7200, 258},
  {545436000, 10800, 258},
  {558478800, 7200, 258},
  {576540000, 10800, 258},
  {589237200, 7200, 258},
  {609890400, 10800, 258},
  {620773200, 7200, 258},
  {638316000, 10800, 258},
  {651618000, 7200, 258},
  {669765600, 10800, 258},
  {683672400, 7200, 258},
  {701820000, 10800, 258},
  {715726800, 7200, 258},
  {733701600, 10800, 258},
  {747176400, 7200, 258},
  {765151200, 10800, 258},
  {778021200, 7200, 258},
  {796600800, 10800, 258},
  {810075600, 7200, 258},
  {820447200, 7200, 258},
  {828655200, 10800, 258},
  {843170400, 7200, 258},
  {860104800, 10800, 258},
  {874620000, 7200, 258},
  {891554400, 10800, 258},
  {906069600, 7200, 258},
  {915141600, 7200, 258},
  {924213600, 10800, 258},
  {939934800, 7200, 258},
  {956268000, 10800, 258},
  {971989200, 7200, 258},
  {987717600, 10800, 258},
  {1003438800, 7200, 258},
  {1019167200, 10800, 258},
  {1034888400, 7200, 258},
  {1050616800, 10800, 258},
  {1066338000, 7200, 258},
  {1082066400, 10800, 258},
  {1096581600, 7200, 258},
  {1113516000, 10800, 258},
  {1128380400, 7200, 258},
  {1143842400, 10800, 258},
  {1158872400, 7200, 258},
  {1175378400, 10800, 258},
  {1189638000, 7200, 258},
  {1207000800, 10800, 258},
  {1220216400, 7200, 258},
  {1238104800, 10800, 258},
  {1252018800, 7200, 258},
  {1269640860, 10800, 258},
  {1281474000, 7200, 258},
  {1301652060, 10800, 258},
  {1312146000, 7200, 258},
  {1314655200, 10800, 258},
  {1317340800, 7200, 258},
  {INT64_MIN, 25600, 259},
  {-2005974400, 25580, 259},
  {-1855983920, 25200, 259},
  {-1819954800, 28800, 259},
  {-1220428800, 25200, 259},
  {-2056692996, 28800, 260},
  {-907389000, 32400, 260},
  {-891667800, 28800, 260},
  {-884246400, 32400, 260},
  {-766746000, 28800, 260},
  {-747981000, 32400, 260},
  {-728544600, 28800, 260},
  {-717049800, 32400, 260},
  {-694503000, 28800, 260},
  {-683785800, 32400, 260},
  {-668064600, 28800, 260},
  {-654755400, 32400, 260},
  {-636615000, 28800, 260},
  {-623305800, 32400, 260},
  {-605165400, 28800, 260},
  {-591856200, 32400, 260},
  {-573715800, 28800, 260},
  {-559801800, 32400, 260},
  {-542352600, 28800, 260},
  {-528352200, 32400, 260},
  {-510211800, 28800, 260},
  {-498112200, 32400, 260},
  {-478762200, 28800, 260},
  {-466662600, 32400, 260},
  {-446707800, 28800, 260},
  {-435213000, 32400, 260},
  {-415258200, 28800, 260},
  {-403158600, 32400, 260},
  {-383808600, 28800, 260},
  {-371709000, 32400, 260},
  {-352359000, 28800, 260},
  {-340259400, 32400, 260},
  {-320909400, 28800, 260},
  {-308809800, 32400, 260},
  {-288855000, 28800, 260},
  {-277360200, 32400, 260},
  {-257405400, 28800, 260},
  {-245910600, 32400, 260},
  {-225955800, 28800, 260},
  {-213856200, 32400, 260},
  {-194506200, 28800, 260},
  {-182406600, 32400, 260},
  {-163056600, 28800, 260},
  {-148537800, 32400, 260},
  {-132816600, 28800, 260},
  {-117088200, 32400, 260},
  {-101367000, 28800, 260},
  {-85638600, 32400, 260},
  {-69312600, 28800, 260},
  {-53584200, 32400, 260},
  {-37863000, 28800, 260},
  {-22134600, 32400, 260},
  {-6413400, 28800, 260},
  {9315000, 32400, 260},
  {25036200, 28800, 260},
  {40764600, 32400, 260},
  {56485800, 28800, 260},
  {72214200, 32400, 260},
  {88540200, 28800, 260},
  {104268600, 32400, 260},
  {119989800, 28800, 260},
  {126041400, 32400, 260},
  {151439400, 28800, 260},
  {167167800, 32400, 260},
  {182889000, 28800, 260},
  {198617400, 32400, 260},
  {214338600, 28800, 260},
  {295385400, 32400, 260},
  {309292200, 28800, 260},
  {INT64_MIN, 27396, 260},
  {INT64_MIN, 21996, 261},
  {-2032927596, 21600, 261},
  {252439200, 25200, 261},
  {417978000, 28800, 261},
  {433785600, 25200, 261},
  {449600400, 28800, 261},
  {465321600, 25200, 261},
  {481050000, 28800, 261},
  {496771200, 25200, 261},
  {512499600, 28800, 261},
  {528220800, 25200, 261},
  {543949200, 28800, 261},
  {559670400, 25200, 261},
  {575398800, 28800, 261},
  {591120000, 25200, 261},
  {606848400, 28800, 261},
  {622569600, 25200, 261},
  {638298000, 28800, 261},
  {654624000, 25200, 261},
  {670352400, 28800, 261},
  {686073600, 25200, 261},
  {701802000, 28800, 261},
  {717523200, 25200, 261},
  {733251600, 28800, 261},
  {748972800, 25200, 261},
  {764701200, 28800, 261},
  {780422400, 25200, 261},
  {796150800, 28800, 261},
  {811872000, 25200, 261},
  {828205200, 28800, 261},
  {843926400, 25200, 261},
  {859654800, 28800, 261},
  {875376000, 25200, 261},
  {891104400, 28800, 261},
  {906825600, 25200, 261},
  {988398000, 28800, 261},
  {1001700000, 25200, 261},
  {1017428400, 28800, 261},
  {1033149600, 25200, 261},
  {1048878000, 28800, 261},
  {1064599200, 25200, 261},
  {1080327600, 28800, 261},
  {1096048800, 25200, 261},
  {1111777200, 28800, 261},
  {1127498400, 25200, 261},
  {1143226800, 28800, 261},
  {1159552800, 25200, 261},
  {INT64_MIN, 25040, 262},
  {-1575874640, 25200, 262},
  {-1247554800, 28800, 262},
  {354902400, 32400, 262},
  {370710000, 28800, 262},
  {386438400, 32400, 262},
  {402246000, 28800, 262},
  {417974400, 32400, 262},
  {433782000, 28800, 262},
  {449596800, 32400, 262},
  {465328800, 28800, 262},
  {481053600, 32400, 262},
  {496778400, 28800, 262},
  {512503200, 32400, 262},
  {528228000, 28800, 262},
  {543952800, 32400, 262},
  {559677600, 28800, 262},
  {575402400, 32400, 262},
  {591127200, 28800, 262},
  {606852000, 32400, 262},
  {622576800, 28800, 262},
  {638301600, 32400, 262},
  {654631200, 28800, 262},
  {670356000, 28800, 262},
  {686084400, 25200, 262},
  {695761200, 28800, 262},
  {701794800, 32400, 262},
  {717516000, 28800, 262},
  {733255200, 32400, 262},
  {748980000, 28800, 262},
  {764704800, 32400, 262},
  {780429600, 28800, 262},
  {796154400, 32400, 262},
  {811879200, 28800, 262},
  {828208800, 32400, 262},
  {846352800, 28800, 262},
  {859658400, 32400, 262},
  {877802400, 28800, 262},
  {891108000, 32400, 262},
  {909252000, 28800, 262},
  {922557600, 32400, 262},
  {941306400, 28800, 262},
  {954007200, 32400, 262},
  {972756000, 28800, 262},
  {985456800, 32400, 262},
  {1004205600, 28800, 262},
  {1017511200, 32400, 262},
  {1035655200, 28800, 262},
  {1048960800, 32400, 262},
  {1067104800, 28800, 262},
  {1080410400, 32400, 262},
  {1099159200, 28800, 262},
  {1111860000, 32400, 262},
  {1130608800, 28800, 262},
  {1143309600, 32400, 262},
  {1162058400, 28800, 262},
  {1174759200, 32400, 262},
  {1193508000, 28800, 262},
  {1206813600, 32400, 262},
  {1224957600, 28800, 262},
  {1238263200, 32400, 262},
  {1256407200, 28800, 262},
  {1269712800, 32400, 262},
  {1288461600, 28800, 262},
  {1301162400, 32400, 262},
  {INT64_MIN, 7016, 263},
  {-1869875816, 7200, 263},
  {-1693706400, 10800, 263},
  {-1680490800, 7200, 263},
  {-1570413600, 10800, 263},
  {-1552186800, 7200, 263},
  {-1538359200, 10800, 263},
  {-1522551600, 7200, 263},
  {-1507514400, 10800, 263},
  {-1490583600, 7200, 263},
  {-1440208800, 10800, 263},
  {-1428030000, 7200, 263},
  {-1409709600, 10800, 263},
  {-1396494000, 7200, 263},
  {-931140000, 10800, 263},
  {-922762800, 7200, 263},
  {-917834400, 10800, 263},
  {-892436400, 7200, 263},
  {-875844000, 10800, 263},
  {-857358000, 7200, 263},
  {-781063200, 10800, 263},
  {-764737200, 7200, 263},
  {-744343200, 10800, 263},
  {-733806000, 7200, 263},
  {-716436000, 10800, 263},
  {-701924400, 7200, 263},
  {-684986400, 10800, 263},
  {-670474800, 7200, 263},
  {-654141600, 10800, 263},
  {-639025200, 7200, 263},
  {-621828000, 10800, 263},
  {-606970800, 7200, 263},
  {-590032800, 10800, 263},
  {-575434800, 7200, 263},
  {-235620000, 10800, 263},
  {-228279600, 7200, 263},
  {-177732000, 10800, 263},
  {-165726000, 7200, 263},
  {10533600, 10800, 263},
  {23835600, 7200, 263},
  {41983200, 10800, 263},
  {55285200, 7200, 263},
  {74037600, 10800, 263},
  {87339600, 7200, 263},
  {107910000, 10800, 263},
  {121219200, 7200, 263},
  {133920000, 10800, 263},
  {152676000, 7200, 263},
  {165362400, 10800, 263},
  {183502800, 7200, 263},
  {202428000, 10800, 263},
  {215557200, 7200, 263},
  {228866400, 10800, 263},
  {245797200, 7200, 263},
  {260316000, 10800, 263},
  {277246800, 14400, 263},
  {308779200, 10800, 263},
  {323827200, 14400, 263},
  {340228800, 10800, 263},
  {354672000, 14400, 263},
  {371678400, 10800, 263},
  {386121600, 14400, 263},
  {403128000, 10800, 263},
  {428446800, 14400, 263},
  {433886400, 10800, 263},
  {482792400, 10800, 263},
  {496702800, 7200, 263},
  {512524800, 10800, 263},
  {528249600, 7200, 263},
  {543974400, 10800, 263},
  {559699200, 7200, 263},
  {575424000, 10800, 263},
  {591148800, 7200, 263},
  {606873600, 10800, 263},
  {622598400, 7200, 263},
  {638323200, 10800, 263},
  {654652800, 7200, 263},
  {670374000, 10800, 263},
  {686098800, 7200, 263},
  {701823600, 10800, 263},
  {717548400, 7200, 263},
  {733273200, 10800, 263},
  {748998000, 7200, 263},
  {764722800, 10800, 263},
  {780447600, 7200, 263},
  {796172400, 10800, 263},
  {811897200, 7200, 263},
  {828226800, 10800, 263},
  {846370800, 7200, 263},
  {859676400, 10800, 263},
  {877820400, 7200, 263},
  {891126000, 10800, 263},
  {909270000, 7200, 263},
  {922575600, 10800, 263},
  {941324400, 7200, 263},
  {954025200, 10800, 263},
  {972774000, 7200, 263},
  {985474800, 10800, 263},
  {1004223600, 7200, 263},
  {1017529200, 10800, 263},
  {1035673200, 7200, 263},
  {1048978800, 10800, 263},
  {1067122800, 7200, 263},
  {1080428400, 10800, 263},
  {1099177200, 7200, 263},
  {1111878000, 10800, 263},
  {1130626800, 7200, 263},
  {1143327600, 10800, 263},
  {1162076400, 7200, 263},
  {1167602400, 7200, 263},
  {1174784400, 10800, 263},
  {1193533200, 7200, 263},
  {1206838800, 10800, 263},
  {1224982800, 7200, 263},
  {1238288400, 10800, 263},
  {1256432400, 7200, 263},
  {1269738000, 10800, 263},
  {1288486800, 7200, 263},
  {1301274000, 10800, 263},
  {1319936400, 7200, 263},
  {1332637200, 10800, 263},
  {1351386000, 7200, 263},
  {1364691600, 10800, 263},
  {1382835600, 7200, 263},
  {1396141200, 10800, 263},
  {1414285200, 7200, 263},
  {1427590800, 10800, 263},
  {1445734800, 7200, 263},
  {1459040400, 10800, 263},
  {1477789200, 7200, 263},
  {1490490000, 10800, 263},
  {1509238800, 7200, 263},
  {1521939600, 10800, 263},
  {1540688400, 7200, 263},
  {1553994000, 10800, 263},
  {1572138000, 7200, 263},
  {1585443600, 10800, 263},
  {1603587600, 7200, 263},
  {1616893200, 10800, 263},
  {1635642000, 7200, 263},
  {1648342800, 10800, 263},
  {1667091600, 7200, 263},
  {1679792400, 10800, 263},
  {1698541200, 7200, 263},
  {1711846800, 10800, 263},
  {1729990800, 7200, 263},
  {1743296400, 10800, 263},
  {1761440400, 7200, 263},
  {1774746000, 10800, 263},
  {1792890000, 7200, 263},
  {1806195600, 10800, 263},
  {1824944400, 7200, 263},
  {1837645200, 10800, 263},
  {1856394000, 7200, 263},
  {1869094800, 10800, 263},
  {1887843600, 7200, 263},
  {1901149200, 10800, 263},
  {1919293200, 7200, 263},
  {1932598800, 10800, 263},
  {1950742800, 7200, 263},
  {1964048400, 10800, 263},
  {1982797200, 7200, 263},
  {1995498000, 10800, 263},
  {2014246800, 7200, 263},
  {2026947600, 10800, 263},
  {2045696400, 7200, 263},
  {2058397200, 10800, 263},
  {2077146000, 7200, 263},
  {2090451600, 10800, 263},
  {2108595600, 7200, 263},
  {2121901200, 10800, 263},
  {2140045200, 7200, 263},
  {INT64_MIN, 25632, 264},
  {-1451719200, 26400, 264},
  {-1172906400, 27000, 264},
  {-876641400, 32400, 264},
  {-766054800, 27000, 264},
  {-683883000, 28800, 264},
  {-620812800, 27000, 264},
  {-189415800, 25200, 264},
  {INT64_MIN, 33768, 265},
  {-1172913768, 32400, 265},
  {-799491600, 34200, 265},
  {-189423000, 32400, 265},
  {INT64_MIN, 8440, 266},
  {-1641003640, 7200, 266},
  {-933645600, 10800, 266},
  {-857358000, 7200, 266},
  {-844300800, 10800, 266},
  {-825822000, 7200, 266},
  {-812685600, 10800, 266},
  {-794199600, 7200, 266},
  {-779853600, 10800, 266},
  {-762656400, 7200, 266},
  {-748310400, 10800, 266},
  {-731127600, 7200, 266},
  {-681962400, 14400, 266},
  {-673243200, 10800, 266},
  {-667962000, 7200, 266},
  {-652327200, 10800, 266},
  {-636426000, 7200, 266},
  {-622087200, 10800, 266},
  {-608947200, 7200, 266},
  {-591847200, 10800, 266},
  {-572486400, 7200, 266},
  {-558576000, 10800, 266},
  {-542851200, 7200, 266},
  {-527731200, 10800, 266},
  {-514425600, 7200, 266},
  {-490845600, 10800, 266},
  {-482986800, 7200, 266},
  {-459475200, 10800, 266},
  {-451537200, 7200, 266},
  {-428551200, 10800, 266},
  {-418262400, 7200, 266},
  {-400032000, 10800, 266},
  {-387428400, 7200, 266},
  {142380000, 10800, 266},
  {150843600, 7200, 266},
  {167176800, 10800, 266},
  {178664400, 7200, 266},
  {482277600, 10800, 266},
  {495579600, 7200, 266},
  {516751200, 10800, 266},
  {526424400, 7200, 266},
  {545436000, 10800, 266},
  {558478800, 7200, 266},
  {576540000, 10800, 266},
  {589237200, 7200, 266},
  {609890400, 10800, 266},
  {620773200, 7200, 266},
  {638316000, 10800, 266},
  {651618000, 7200, 266},
  {669765600, 10800, 266},
  {683672400, 7200, 266},
  {701820000, 10800, 266},
  {715726800, 7200, 266},
  {733701600, 10800, 266},
  {747176400, 7200, 266},
  {765151200, 10800, 266},
  {778021200, 7200, 266},
  {796600800, 10800, 266},
  {810075600, 7200, 266},
  {826840800, 10800, 266},
  {842821200, 7200, 266},
  {858895200, 10800, 266},
  {874184400, 7200, 266},
  {890344800, 10800, 266},
  {905029200, 7200, 266},
  {923011200, 10800, 266},
  {936313200, 7200, 266},
  {955670400, 10800, 266},
  {970783200, 7200, 266},
  {986770800, 10800, 266},
  {1001282400, 7200, 266},
  {1017356400, 10800, 266},
  {1033941600, 7200, 266},
  {1048806000, 10800, 266},
  {1065132000, 7200, 266},
  {1081292400, 10800, 266},
  {1095804000, 7200, 266},
  {1112313600, 10800, 266},
  {1128812400, 7200, 266},
  {1143763200, 10800, 266},
  {1159657200, 7200, 266},
  {1175212800, 10800, 266},
  {1189897200, 7200, 266},
  {1206662400, 10800, 266},
  {1223161200, 7200, 266},
  {1238112000, 10800, 266},
  {1254006000, 7200, 266},
  {1269561600, 10800, 266},
  {1284246000, 7200, 266},
  {1301616000, 10800, 266},
  {1317510000, 7200, 266},
  {1333065600, 10800, 266},
  {1348354800, 7200, 266},
  {1364515200, 10800, 266},
  {1378594800, 7200, 266},
  {1395964800, 10800, 266},
  {1411858800, 7200, 266},
  {1427414400, 10800, 266},
  {1442703600, 7200, 266},
  {1459468800, 10800, 266},
  {1475967600, 7200, 266},
  {1490918400, 10800, 266},
  {1506207600, 7200, 266},
  {1522368000, 10800, 266},
  {1537052400, 7200, 266},
  {1553817600, 10800, 266},
  {1570316400, 7200, 266},
  {1585267200, 10800, 266},
  {1601161200, 7200, 266},
  {1616716800, 10800, 266},
  {1631401200, 7200, 266},
  {1648771200, 10800, 266},
  {1664665200, 7200, 266},
  {1680220800, 10800, 266},
  {1695510000, 7200, 266},
  {1711670400, 10800, 266},
  {1728169200, 7200, 266},
  {1743120000, 10800, 266},
  {1759014000, 7200, 266},
  {1774569600, 10800, 266},
  {1789858800, 7200, 266},
  {1806019200, 10800, 266},
  {1823122800, 7200, 266},
  {1838073600, 10800, 266},
  {1853362800, 7200, 266},
  {1869523200, 10800, 266},
  {1884207600, 7200, 266},
  {1900972800, 10800, 266},
  {1917471600, 7200, 266},
  {1932422400, 10800, 266},
  {1947711600, 7200, 266},
  {1963872000, 10800, 266},
  {1978556400, 7200, 266},
  {1995926400, 10800, 266},
  {2011820400, 7200, 266},
  {2027376000, 10800, 266},
  {2042060400, 7200, 266},
  {2058825600, 10800, 266},
  {2075324400, 7200, 266},
  {2090275200, 10800, 266},
  {2106169200, 7200, 266},
  {2121724800, 10800, 266},
  {2136409200, 7200, 266},
  {INT64_MIN, 14400, 267},
  {-788932800, 16200, 267},
  {INT64_MIN, 38076, 268},
  {-1487759676, 39600, 268},
  {-1247569200, 43200, 268},
  {354888000, 46800, 268},
  {370695600, 43200, 268},
  {386424000, 46800, 268},
  {402231600, 43200, 268},
  {417960000, 46800, 268},
  {433767600, 43200, 268},
  {449582400, 46800, 268},
  {465314400, 43200, 268},
  {481039200, 46800, 268},
  {496764000, 43200, 268},
  {512488800, 46800, 268},
  {528213600, 43200, 268},
  {543938400, 46800, 268},
  {559663200, 43200, 268},
  {575388000, 46800, 268},
  {591112800, 43200, 268},
  {606837600, 46800, 268},
  {622562400, 43200, 268},
  {638287200, 46800, 268},
  {654616800, 43200, 268},
  {670341600, 43200, 268},
  {686070000, 39600, 268},
  {695746800, 43200, 268},
  {701780400, 46800, 268},
  {717501600, 43200, 268},
  {733240800, 46800, 268},
  {748965600, 43200, 268},
  {764690400, 46800, 268},
  {780415200, 43200, 268},
  {796140000, 46800, 268},
  {811864800, 43200, 268},
  {828194400, 46800, 268},
  {846338400, 43200, 268},
  {859644000, 46800, 268},
  {877788000, 43200, 268},
  {891093600, 46800, 268},
  {909237600, 43200, 268},
  {922543200, 46800, 268},
  {941292000, 43200, 268},
  {953992800, 46800, 268},
  {972741600, 43200, 268},
  {985442400, 46800, 268},
  {1004191200, 43200, 268},
  {1017496800, 46800, 268},
  {1035640800, 43200, 268},
  {1048946400, 46800, 268},
  {1067090400, 43200, 268},
  {1080396000, 46800, 268},
  {1099144800, 43200, 268},
  {1111845600, 46800, 268},
  {1130594400, 43200, 268},
  {1143295200, 46800, 268},
  {1162044000, 43200, 268},
  {1174744800, 46800, 268},
  {1193493600, 43200, 268},
  {1206799200, 46800, 268},
  {1224943200, 43200, 268},
  {1238248800, 46800, 268},
  {1256392800, 43200, 268},
  {1269698400, 43200, 268},
  {1288450800, 39600, 268},
  {1301151600, 43200, 268},
  {INT64_MIN, 16092, 269},
  {-1988166492, 19800, 269},
  {-862637400, 23400, 269},
  {-764145000, 19800, 269},
  {-576135000, 18000, 269},
  {38775600, 18000, 269},
  {1018119660, 21600, 269},
  {1033840860, 18000, 269},
  {1212260400, 21600, 269},
  {1225476000, 18000, 269},
  {1239735600, 21600, 269},
  {1257012000, 18000, 269},
  {INT64_MIN, 18236, 270},
  {-1325480636, 19800, 270},
  {-946791000, 18000, 270},
  {325969200, 28800, 270},
  {515520000, 32400, 270},
  {527007600, 28800, 270},
  {545155200, 32400, 270},
  {558457200, 28800, 270},
  {576604800, 32400, 270},
  {589906800, 28800, 270},
  {608659200, 32400, 270},
  {621961200, 28800, 270},
  {640108800, 32400, 270},
  {653410800, 28800, 270},
  {671558400, 32400, 270},
  {684860400, 28800, 270},
  {INT64_MIN, 20476, 271},
  {-1577943676, 19800, 271},
  {504901800, 20700, 271},
  {INT64_MIN, 20476, 272},
  {-1577943676, 19800, 272},
  {504901800, 20700, 272},
  {INT64_MIN, 21200, 273},
  {-891582800, 23400, 273},
  {-872058600, 19800, 273},
  {-862637400, 23400, 273},
  {-764145000, 19800, 273},
  {INT64_MIN, 22280, 274},
  {-1577513480, 21600, 274},
  {-1247551200, 25200, 274},
  {354906000, 28800, 274},
  {370713600, 25200, 274},
  {386442000, 28800, 274},
  {402249600, 25200, 274},
  {417978000, 28800, 274},
  {433785600, 25200, 274},
  {449600400, 28800, 274},
  {465332400, 25200, 274},
  {481057200, 28800, 274},
  {496782000, 25200, 274},
  {512506800, 28800, 274},
  {528231600, 25200, 274},
  {543956400, 28800, 274},
  {559681200, 25200, 274},
  {575406000, 28800, 274},
  {591130800, 25200, 274},
  {606855600, 28800, 274},
  {622580400, 25200, 274},
  {638305200, 28800, 274},
  {654634800, 25200, 274},
  {670359600, 25200, 274},
  {686088000, 21600, 274},
  {695764800, 25200, 274},
  {701798400, 28800, 274},
  {717519600, 25200, 274},
  {733258800, 28800, 274},
  {748983600, 25200, 274},
  {764708400, 28800, 274},
  {780433200, 25200, 274},
  {796158000, 28800, 274},
  {811882800, 25200, 274},
  {828212400, 28800, 274},
  {846356400, 25200, 274},
  {859662000, 28800, 274},
  {877806000, 25200, 274},
  {891111600, 28800, 274},
  {909255600, 25200, 274},
  {922561200, 28800, 274},
  {941310000, 25200, 274},
  {954010800, 28800, 274},
  {972759600, 25200, 274},
  {985460400, 28800, 274},
  {1004209200, 25200, 274},
  {1017514800, 28800, 274},
  {1035658800, 25200, 274},
  {1048964400, 28800, 274},
  {1067108400, 25200, 274},
  {1080414000, 28800, 274},
  {1099162800, 25200, 274},
  {1111863600, 28800, 274},
  {1130612400, 25200, 274},
  {1143313200, 28800, 274},
  {1162062000, 25200, 274},
  {1174762800, 28800, 274},
  {1193511600, 25200, 274},
  {1206817200, 28800, 274},
  {1224961200, 25200, 274},
  {1238266800, 28800, 274},
  {1256410800, 25200, 274},
  {1269716400, 28800, 274},
  {1288465200, 25200, 274},
  {1301166000, 28800, 274},
  {INT64_MIN, 24925, 275},
  {-2038200925, 25200, 275},
  {-1167634800, 26400, 275},
  {-1073028000, 26400, 275},
  {-894180000, 27000, 275},
  {-879665400, 32400, 275},
  {-767005200, 27000, 275},
  {378664200, 28800, 275},
  {INT64_MIN, 26480, 276},
  {-1383463280, 27000, 276},
  {-1167636600, 28800, 276},
  {-1082448000, 30000, 276},
  {-1074586800, 28800, 276},
  {-1050825600, 30000, 276},
  {-1042964400, 28800, 276},
  {-1019289600, 30000, 276},
  {-1011428400, 28800, 276},
  {-987753600, 30000, 276},
  {-979892400, 28800, 276},
  {-956217600, 30000, 276},
  {-948356400, 28800, 276},
  {-924595200, 30000, 276},
  {-916734000, 28800, 276},
  {-893059200, 30000, 276},
  {-885198000, 28800, 276},
  {-879667200, 32400, 276},
  {-767005200, 28800, 276},
  {378662400, 28800, 276},
  {INT64_MIN, 11516, 277},
  {-631163516, 10800, 277},
  {INT64_MIN, 27260, 278},
  {-1830411260, 28800, 278},
  {-277360200, 32400, 278},
  {-257405400, 28800, 278},
  {-245910600, 32400, 278},
  {-225955800, 28800, 278},
  {-214473600, 32400, 278},
  {-194506200, 28800, 278},
  {-182406600, 32400, 278},
  {-163056600, 28800, 278},
  {-150969600, 32400, 278},
  {-131619600, 28800, 278},
  {-117088200, 32400, 278},
  {-101367000, 28800, 278},
  {-85638600, 32400, 278},
  {-69312600, 28800, 278},
  {-53584200, 32400, 278},
  {-37863000, 28800, 278},
  {-22134600, 32400, 278},
  {-6413400, 28800, 278},
  {9315000, 32400, 278},
  {25036200, 28800, 278},
  {40764600, 32400, 278},
  {56485800, 28800, 278},
  {72201600, 32400, 278},
  {87922800, 28800, 278},
  {103651200, 32400, 278},
  {119977200, 28800, 278},
  {135705600, 32400, 278},
  {151439400, 28800, 278},
  {167167800, 32400, 278},
  {182889000, 28800, 278},
  {198617400, 32400, 278},
  {214338600, 28800, 278},
  {230067000, 32400, 278},
  {245788200, 28800, 278},
  {261504000, 32400, 278},
  {277225200, 28800, 278},
  {292953600, 32400, 278},
  {309279600, 28800, 278},
  {325008000, 32400, 278},
  {340729200, 28800, 278},
  {945619200, 28800, 278},
  {INT64_MIN, 27260, 279},
  {-1830411260, 28800, 279},
  {-277360200, 32400, 279},
  {-257405400, 28800, 279},
  {-245910600, 32400, 279},
  {-225955800, 28800, 279},
  {-214473600, 32400, 279},
  {-194506200, 28800, 279},
  {-182406600, 32400, 279},
  {-163056600, 28800, 279},
  {-150969600, 32400, 279},
  {-131619600, 28800, 279},
  {-117088200, 32400, 279},
  {-101367000, 28800, 279},
  {-85638600, 32400, 279},
  {-69312600, 28800, 279},
  {-53584200, 32400, 279},
  {-37863000, 28800, 279},
  {-22134600, 32400, 279},
  {-6413400, 28800, 279},
  {9315000, 32400, 279},
  {25036200, 28800, 279},
  {40764600, 32400, 279},
  {56485800, 28800, 279},
  {72201600, 32400, 279},
  {87922800, 28800, 279},
  {103651200, 32400, 279},
  {119977200, 28800, 279},
  {135705600, 32400, 279},
  {151439400, 28800, 279},
  {167167800, 32400, 279},
  {182889000, 28800, 279},
  {198617400, 32400, 279},
  {214338600, 28800, 279},
  {230067000, 32400, 279},
  {245788200, 28800, 279},
  {261504000, 32400, 279},
  {277225200, 28800, 279},
  {292953600, 32400, 279},
  {309279600, 28800, 279},
  {325008000, 32400, 279},
  {340729200, 28800, 279},
  {945619200, 28800, 279},
  {INT64_MIN, 36192, 280},
  {-1441188192, 36000, 280},
  {-1247565600, 39600, 280},
  {354891600, 43200, 280},
  {370699200, 39600, 280},
  {386427600, 43200, 280},
  {402235200, 39600, 280},
  {417963600, 43200, 280},
  {433771200, 39600, 280},
  {449586000, 43200, 280},
  {465318000, 39600, 280},
  {481042800, 43200, 280},
  {496767600, 39600, 280},
  {512492400, 43200, 280},
  {528217200, 39600, 280},
  {543942000, 43200, 280},
  {559666800, 39600, 280},
  {575391600, 43200, 280},
  {591116400, 39600, 280},
  {606841200, 43200, 280},
  {622566000, 39600, 280},
  {638290800, 43200, 280},
  {654620400, 39600, 280},
  {670345200, 39600, 280},
  {686073600, 36000, 280},
  {695750400, 39600, 280},
  {701784000, 43200, 280},
  {717505200, 39600, 280},
  {733244400, 43200, 280},
  {748969200, 39600, 280},
  {764694000, 43200, 280},
  {780418800, 39600, 280},
  {796143600, 43200, 280},
  {811868400, 39600, 280},
  {828198000, 43200, 280},
  {846342000, 39600, 280},
  {859647600, 43200, 280},
  {877791600, 39600, 280},
  {891097200, 43200, 280},
  {909241200, 39600, 280},
  {922546800, 43200, 280},
  {941295600, 39600, 280},
  {953996400, 43200, 280},
  {972745200, 39600, 280},
  {985446000, 43200, 280},
  {1004194800, 39600, 280},
  {1017500400, 43200, 280},
  {1035644400, 39600, 280},
  {1048950000, 43200, 280},
  {1067094000, 39600, 280},
  {1080399600, 43200, 280},
  {1099148400, 39600, 280},
  {1111849200, 43200, 280},
  {1130598000, 39600, 280},
  {1143298800, 43200, 280},
  {1162047600, 39600, 280},
  {1174748400, 43200, 280},
  {1193497200, 39600, 280},
  {1206802800, 43200, 280},
  {1224946800, 39600, 280},
  {1238252400, 43200, 280},
  {1256396400, 39600, 280},
  {1269702000, 43200, 280},
  {1288450800, 39600, 280},
  {1301151600, 43200, 280},
  {INT64_MIN, 28656, 281},
  {-1577951856, 28656, 281},
  {-1172908656, 28800, 281},
  {-880272000, 32400, 281},
  {-766054800, 28800, 281},
  {-1046678400, 32400, 282},
  {-1038733200, 28800, 282},
  {-873273600, 32400, 282},
  {-794221200, 28800, 282},
  {-496224000, 32400, 282},
  {-489315600, 28800, 282},
  {259344000, 32400, 282},
  {275151600, 28800, 282},
  {INT64_MIN, 14060, 283},
  {-1577937260, 14400, 283},
  {INT64_MIN, 8008, 284},
  {-1518920008, 7200, 284},
  {166572000, 10800, 284},
  {182293200, 7200, 284},
  {200959200, 10800, 284},
  {213829200, 7200, 284},
  {228866400, 10800, 284},
  {243982800, 7200, 284},
  {260316000, 10800, 284},
  {276123600, 7200, 284},
  {291765600, 10800, 284},
  {307486800, 7200, 284},
  {323820000, 10800, 284},
  {338936400, 7200, 284},
  {354664800, 10800, 284},
  {370386000, 7200, 284},
  {386114400, 10800, 284},
  {401835600, 7200, 284},
  {417564000, 10800, 284},
  {433285200, 7200, 284},
  {449013600, 10800, 284},
  {465339600, 7200, 284},
  {481068000, 10800, 284},
  {496789200, 7200, 284},
  {512517600, 10800, 284},
  {528238800, 7200, 284},
  {543967200, 10800, 284},
  {559688400, 7200, 284},
  {575416800, 10800, 284},
  {591138000, 7200, 284},
  {606866400, 10800, 284},
  {622587600, 7200, 284},
  {638316000, 10800, 284},
  {654642000, 7200, 284},
  {670370400, 10800, 284},
  {686091600, 7200, 284},
  {701820000, 10800, 284},
  {717541200, 7200, 284},
  {733269600, 10800, 284},
  {748990800, 7200, 284},
  {764719200, 10800, 284},
  {780440400, 7200, 284},
  {796168800, 10800, 284},
  {811890000, 7200, 284},
  {828223200, 10800, 284},
  {843944400, 7200, 284},
  {859672800, 10800, 284},
  {875394000, 7200, 284},
  {891122400, 10800, 284},
  {909277200, 7200, 284},
  {922582800, 10800, 284},
  {941331600, 7200, 284},
  {954032400, 10800, 284},
  {972781200, 7200, 284},
  {985482000, 10800, 284},
  {1004230800, 7200, 284},
  {1017536400, 10800, 284},
  {1035680400, 7200, 284},
  {1048986000, 10800, 284},
  {1067130000, 7200, 284},
  {1080435600, 10800, 284},
  {1099184400, 7200, 284},
  {1111885200, 10800, 284},
  {1130634000, 7200, 284},
  {1143334800, 10800, 284},
  {1162083600, 7200, 284},
  {1174784400, 10800, 284},
  {1193533200, 7200, 284},
  {1206838800, 10800, 284},
  {1224982800, 7200, 284},
  {1238288400, 10800, 284},
  {1256432400, 7200, 284},
  {1269738000, 10800, 284},
  {1288486800, 7200, 284},
  {1301187600, 10800, 284},
  {1319936400, 7200, 284},
  {1332637200, 10800, 284},
  {1351386000, 7200, 284},
  {1364691600, 10800, 284},
  {1382835600, 7200, 284},
  {1396141200, 10800, 284},
  {1414285200, 7200, 284},
  {1427590800, 10800, 284},
  {1445734800, 7200, 284},
  {1459040400, 10800, 284},
  {1477789200, 7200, 284},
  {1490490000, 10800, 284},
  {1509238800, 7200, 284},
  {1521939600, 10800, 284},
  {1540688400, 7200, 284},
  {1553994000, 10800, 284},
  {1572138000, 7200, 284},
  {1585443600, 10800, 284},
  {1603587600, 7200, 284},
  {1616893200, 10800, 284},
  {1635642000, 7200, 284},
  {1648342800, 10800, 284},
  {1667091600, 7200, 284},
  {1679792400, 10800, 284},
  {1698541200, 7200, 284},
  {1711846800, 10800, 284},
  {1729990800, 7200, 284},
  {1743296400, 10800, 284},
  {1761440400, 7200, 284},
  {1774746000, 10800, 284},
  {1792890000, 7200, 284},
  {1806195600, 10800, 284},
  {1824944400, 7200, 284},
  {1837645200, 10800, 284},
  {1856394000, 7200, 284},
  {1869094800, 10800, 284},
  {1887843600, 7200, 284},
  {1901149200, 10800, 284},
  {1919293200, 7200, 284},
  {1932598800, 10800, 284},
  {1950742800, 7200, 284},
  {1964048400, 10800, 284},
  {1982797200, 7200, 284},
  {1995498000, 10800, 284},
  {2014246800, 7200, 284},
  {2026947600, 10800, 284},
  {2045696400, 7200, 284},
  {2058397200, 10800, 284},
  {2077146000, 7200, 284},
  {2090451600, 10800, 284},
  {2108595600, 7200, 284},
  {2121901200, 10800, 284},
  {2140045200, 7200, 284},
  {INT64_MIN, 20928, 285},
  {-1577512128, 21600, 285},
  {-1247551200, 25200, 285},
  {354906000, 28800, 285},
  {370713600, 25200, 285},
  {386442000, 28800, 285},
  {402249600, 25200, 285},
  {417978000, 28800, 285},
  {433785600, 25200, 285},
  {449600400, 28800, 285},
  {465332400, 25200, 285},
  {481057200, 28800, 285},
  {496782000, 25200, 285},
  {512506800, 28800, 285},
  {528231600, 25200, 285},
  {543956400, 28800, 285},
  {559681200, 25200, 285},
  {575406000, 28800, 285},
  {591130800, 25200, 285},
  {606855600, 28800, 285},
  {622580400, 25200, 285},
  {638305200, 28800, 285},
  {654634800, 25200, 285},
  {670359600, 25200, 285},
  {686088000, 21600, 285},
  {695764800, 25200, 285},
  {701798400, 28800, 285},
  {717519600, 25200, 285},
  {733258800, 28800, 285},
  {748983600, 25200, 285},
  {764708400, 28800, 285},
  {780433200, 25200, 285},
  {796158000, 28800, 285},
  {811882800, 25200, 285},
  {828212400, 28800, 285},
  {846356400, 25200, 285},
  {859662000, 28800, 285},
  {877806000, 25200, 285},
  {891111600, 28800, 285},
  {909255600, 25200, 285},
  {922561200, 28800, 285},
  {941310000, 25200, 285},
  {954010800, 28800, 285},
  {972759600, 25200, 285},
  {985460400, 28800, 285},
  {1004209200, 25200, 285},
  {1017514800, 28800, 285},
  {1035658800, 25200, 285},
  {1048964400, 28800, 285},
  {1067108400, 25200, 285},
  {1080414000, 28800, 285},
  {1099162800, 25200, 285},
  {1111863600, 28800, 285},
  {1130612400, 25200, 285},
  {1143313200, 28800, 285},
  {1162062000, 25200, 285},
  {1174762800, 28800, 285},
  {1193511600, 25200, 285},
  {1206817200, 28800, 285},
  {1224961200, 25200, 285},
  {1238266800, 28800, 285},
  {1256410800, 25200, 285},
  {1269716400, 25200, 285},
  {1288468800, 21600, 285},
  {1301169600, 25200, 285},
  {INT64_MIN, 19900, 286},
  {-1579476700, 21600, 286},
  {-1247551200, 25200, 286},
  {354906000, 28800, 286},
  {370713600, 25200, 286},
  {386442000, 28800, 286},
  {402249600, 25200, 286},
  {417978000, 28800, 286},
  {433785600, 25200, 286},
  {449600400, 28800, 286},
  {465332400, 25200, 286},
  {481057200, 28800, 286},
  {496782000, 25200, 286},
  {512506800, 28800, 286},
  {528231600, 25200, 286},
  {543956400, 28800, 286},
  {559681200, 25200, 286},
  {575406000, 28800, 286},
  {591130800, 25200, 286},
  {606855600, 28800, 286},
  {622580400, 25200, 286},
  {638305200, 28800, 286},
  {654634800, 25200, 286},
  {670359600, 25200, 286},
  {686088000, 21600, 286},
  {695764800, 25200, 286},
  {701798400, 28800, 286},
  {717519600, 25200, 286},
  {733258800, 28800, 286},
  {738086400, 25200, 286},
  {748987200, 21600, 286},
  {764712000, 25200, 286},
  {780436800, 21600, 286},
  {796161600, 25200, 286},
  {811886400, 21600, 286},
  {828216000, 25200, 286},
  {846360000, 21600, 286},
  {859665600, 25200, 286},
  {877809600, 21600, 286},
  {891115200, 25200, 286},
  {909259200, 21600, 286},
  {922564800, 25200, 286},
  {941313600, 21600, 286},
  {954014400, 25200, 286},
  {972763200, 21600, 286},
  {985464000, 25200, 286},
  {1004212800, 21600, 286},
  {1017518400, 25200, 286},
  {1035662400, 21600, 286},
  {1048968000, 25200, 286},
  {1067112000, 21600, 286},
  {1080417600, 25200, 286},
  {1099166400, 21600, 286},
  {1111867200, 25200, 286},
  {1130616000, 21600, 286},
  {1143316800, 25200, 286},
  {1162065600, 21600, 286},
  {1174766400, 25200, 286},
  {1193515200, 21600, 286},
  {1206820800, 25200, 286},
  {1224964800, 21600, 286},
  {1238270400, 25200, 286},
  {1256414400, 21600, 286},
  {1269720000, 25200, 286},
  {1288468800, 21600, 286},
  {1301169600, 25200, 286},
  {INT64_MIN, 17616, 287},
  {-1582088016, 18000, 287},
  {-1247547600, 21600, 287},
  {354909600, 25200, 287},
  {370717200, 21600, 287},
  {386445600, 25200, 287},
  {402253200, 21600, 287},
  {417981600, 25200, 287},
  {433789200, 21600, 287},
  {449604000, 25200, 287},
  {465336000, 21600, 287},
  {481060800, 25200, 287},
  {496785600, 21600, 287},
  {512510400, 25200, 287},
  {528235200, 21600, 287},
  {543960000, 25200, 287},
  {559684800, 21600, 287},
  {575409600, 25200, 287},
  {591134400, 21600, 287},
  {606859200, 25200, 287},
  {622584000, 21600, 287},
  {638308800, 25200, 287},
  {654638400, 21600, 287},
  {670363200, 21600, 287},
  {686091600, 18000, 287},
  {695768400, 21600, 287},
  {701802000, 25200, 287},
  {717523200, 21600, 287},
  {733262400, 25200, 287},
  {748987200, 21600, 287},
  {764712000, 25200, 287},
  {780436800, 21600, 287},
  {796161600, 25200, 287},
  {811886400, 21600, 287},
  {828216000, 25200, 287},
  {846360000, 21600, 287},
  {859665600, 25200, 287},
  {877809600, 21600, 287},
  {891115200, 25200, 287},
  {909259200, 21600, 287},
  {922564800, 25200, 287},
  {941313600, 21600, 287},
  {954014400, 25200, 287},
  {972763200, 21600, 287},
  {985464000, 25200, 287},
  {1004212800, 21600, 287},
  {1017518400, 25200, 287},
  {1035662400, 21600, 287},
  {1048968000, 25200, 287},
  {1067112000, 21600, 287},
  {1080417600, 25200, 287},
  {1099166400, 21600, 287},
  {1111867200, 25200, 287},
  {1130616000, 21600, 287},
  {1143316800, 25200, 287},
  {1162065600, 21600, 287},
  {1174766400, 25200, 287},
  {1193515200, 21600, 287},
  {1206820800, 25200, 287},
  {1224964800, 21600, 287},
  {1238270400, 25200, 287},
  {1256414400, 21600, 287},
  {1269720000, 25200, 287},
  {1288468800, 21600, 287},
  {1301169600, 25200, 287},
  {INT64_MIN, 12324, 288},
  {-1441164324, 14400, 288},
  {-1247544000, 18000, 288},
  {354913200, 21600, 288},
  {370720800, 21600, 288},
  {386445600, 21600, 288},
  {402256800, 18000, 288},
  {417985200, 21600, 288},
  {433792800, 18000, 288},
  {449607600, 21600, 288},
  {465339600, 18000, 288},
  {481064400, 21600, 288},
  {496789200, 18000, 288},
  {512514000, 21600, 288},
  {528238800, 18000, 288},
  {543963600, 21600, 288},
  {559688400, 18000, 288},
  {575413200, 21600, 288},
  {591138000, 18000, 288},
  {606862800, 18000, 288},
  {622591200, 14400, 288},
  {638316000, 18000, 288},
  {654645600, 14400, 288},
  {662673600, 14400, 288},
  {692827200, 14400, 288},
  {701809200, 18000, 288},
  {717530400, 14400, 288},
  {733269600, 18000, 288},
  {748994400, 14400, 288},
  {764719200, 18000, 288},
  {780444000, 14400, 288},
  {796168800, 18000, 288},
  {811893600, 14400, 288},
  {828223200, 18000, 288},
  {846367200, 14400, 288},
  {859672800, 18000, 288},
  {877816800, 14400, 288},
  {891122400, 18000, 288},
  {909266400, 14400, 288},
  {922572000, 18000, 288},
  {941320800, 14400, 288},
  {954021600, 18000, 288},
  {972770400, 14400, 288},
  {985471200, 18000, 288},
  {1004220000, 14400, 288},
  {1017525600, 18000, 288},
  {1035669600, 14400, 288},
  {1048975200, 18000, 288},
  {1067119200, 14400, 288},
  {1080424800, 18000, 288},
  {1099173600, 14400, 288},
  {1110830400, 18000, 288},
  {INT64_MIN, 25180, 289},
  {-2005973980, 25580, 289},
  {-1855983920, 25200, 289},
  {-1819954800, 28800, 289},
  {-1220428800, 25200, 289},
  {INT64_MIN, 26240, 290},
  {-1946186240, 26240, 290},
  {-1172906240, 27000, 290},
  {-881220600, 32400, 290},
  {-766054800, 27000, 290},
  {-683883000, 28800, 290},
  {-620812800, 27000, 290},
  {-189415800, 28800, 290},
  {567964800, 25200, 290},
  {-2053931400, 32400, 291},
  {-1325494800, 30600, 291},
  {-1199262600, 32400, 291},
  {-498128400, 28800, 291},
  {-264931200, 32400, 291},
  {INT64_MIN, 12368, 292},
  {-1577935568, 14400, 292},
  {76190400, 10800, 292},
  {INT64_MIN, 15712, 293},
  {-1441167712, 14400, 293},
  {-1247544000, 18000, 293},
  {354913200, 21600, 293},
  {370720800, 21600, 293},
  {386445600, 21600, 293},
  {402256800, 18000, 293},
  {417985200, 21600, 293},
  {433792800, 18000, 293},
  {449607600, 21600, 293},
  {465339600, 18000, 293},
  {481064400, 21600, 293},
  {496789200, 18000, 293},
  {512514000, 21600, 293},
  {528238800, 18000, 293},
  {543963600, 21600, 293},
  {559688400, 18000, 293},
  {575413200, 21600, 293},
  {591138000, 18000, 293},
  {606862800, 21600, 293},
  {622587600, 18000, 293},
  {638312400, 21600, 293},
  {654642000, 18000, 293},
  {662670000, 18000, 293},
  {692823600, 18000, 293},
  {695768400, 21600, 293},
  {701802000, 25200, 293},
  {717523200, 21600, 293},
  {733262400, 25200, 293},
  {748987200, 21600, 293},
  {764712000, 25200, 293},
  {780436800, 21600, 293},
  {796161600, 25200, 293},
  {811886400, 21600, 293},
  {828216000, 25200, 293},
  {846360000, 21600, 293},
  {859665600, 25200, 293},
  {877809600, 21600, 293},
  {891115200, 25200, 293},
  {909259200, 21600, 293},
  {922564800, 25200, 293},
  {941313600, 21600, 293},
  {954014400, 25200, 293},
  {972763200, 21600, 293},
  {985464000, 25200, 293},
  {1004212800, 21600, 293},
  {1017518400, 25200, 293},
  {1035662400, 21600, 293},
  {1048968000, 25200, 293},
  {1067112000, 21600, 293},
  {1080417600, 25200, 293},
  {1099166400, 21600, 293},
  {1110823200, 21600, 293},
  {INT64_MIN, 23076, 294},
  {-1577946276, 23400, 294},
  {-873268200, 32400, 294},
  {-778410000, 23400, 294},
  {INT64_MIN, 11212, 295},
  {-631163212, 10800, 295},
  {INT64_MIN, 25600, 296},
  {-2005974400, 25580, 296},
  {-1855983920, 25200, 296},
  {-1819954800, 28800, 296},
  {-1220428800, 25200, 296},
  {INT64_MIN, 34248, 297},
  {-2031039048, 32400, 297},
  {-1009875600, 32400, 297},
  {-768560400, 39600, 297},
  {354891600, 43200, 297},
  {370699200, 39600, 297},
  {386427600, 43200, 297},
  {402235200, 39600, 297},
  {417963600, 43200, 297},
  {433771200, 39600, 297},
  {449586000, 43200, 297},
  {465318000, 39600, 297},
  {481042800, 43200, 297},
  {496767600, 39600, 297},
  {512492400, 43200, 297},
  {528217200, 39600, 297},
  {543942000, 43200, 297},
  {559666800, 39600, 297},
  {575391600, 43200, 297},
  {591116400, 39600, 297},
  {606841200, 43200, 297},
  {622566000, 39600, 297},
  {638290800, 43200, 297},
  {654620400, 39600, 297},
  {670345200, 39600, 297},
  {686073600, 36000, 297},
  {695750400, 39600, 297},
  {701784000, 43200, 297},
  {717505200, 39600, 297},
  {733244400, 43200, 297},
  {748969200, 39600, 297},
  {764694000, 43200, 297},
  {780418800, 39600, 297},
  {796143600, 43200, 297},
  {811868400, 39600, 297},
  {828198000, 43200, 297},
  {846342000, 39600, 297},
  {859647600, 39600, 297},
  {877795200, 36000, 297},
  {891100800, 39600, 297},
  {909244800, 36000, 297},
  {922550400, 39600, 297},
  {941299200, 36000, 297},
  {954000000, 39600, 297},
  {972748800, 36000, 297},
  {985449600, 39600, 297},
  {1004198400, 36000, 297},
  {1017504000, 39600, 297},
  {1035648000, 36000, 297},
  {1048953600, 39600, 297},
  {1067097600, 36000, 297},
  {1080403200, 39600, 297},
  {1099152000, 36000, 297},
  {1111852800, 39600, 297},
  {1130601600, 36000, 297},
  {1143302400, 39600, 297},
  {1162051200, 36000, 297},
  {1174752000, 39600, 297},
  {1193500800, 36000, 297},
  {1206806400, 39600, 297},
  {1224950400, 36000, 297},
  {1238256000, 39600, 297},
  {1256400000, 36000, 297},
  {1269705600, 39600, 297},
  {1288454400, 36000, 297},
  {1301155200, 39600, 297},
  {INT64_MIN, 16032, 298},
  {-1441168032, 14400, 298},
  {-1247544000, 18000, 298},
  {354913200, 21600, 298},
  {370720800, 21600, 298},
  {386445600, 21600, 298},
  {402256800, 18000, 298},
  {417985200, 21600, 298},
  {433792800, 18000, 298},
  {449607600, 21600, 298},
  {465339600, 18000, 298},
  {481064400, 21600, 298},
  {496789200, 18000, 298},
  {512514000, 21600, 298},
  {528238800, 18000, 298},
  {543963600, 21600, 298},
  {559688400, 18000, 298},
  {575413200, 21600, 298},
  {591138000, 18000, 298},
  {606862800, 21600, 298},
  {622587600, 18000, 298},
  {638312400, 21600, 298},
  {654642000, 18000, 298},
  {670366800, 21600, 298},
  {683661600, 21600, 298},
  {686091600, 18000, 298},
  {694206000, 18000, 298},
  {-2053931400, 32400, 299},
  {-1325494800, 30600, 299},
  {-1199262600, 32400, 299},
  {-498128400, 28800, 299},
  {-303984000, 32400, 299},
  {-293533200, 28800, 299},
  {-264931200, 30600, 299},
  {-39515400, 32400, 299},
  {547570800, 36000, 299},
  {560872800, 32400, 299},
  {579020400, 36000, 299},
  {592322400, 32400, 299},
  {INT64_MIN, 29152, 300},
  {-1325491552, 28800, 300},
  {-933494400, 32400, 300},
  {-923130000, 28800, 300},
  {-908784000, 32400, 300},
  {-891594000, 28800, 300},
  {515520000, 32400, 300},
  {527007600, 28800, 300},
  {545155200, 32400, 300},
  {558457200, 28800, 300},
  {576604800, 32400, 300},
  {589906800, 28800, 300},
  {608659200, 32400, 300},
  {621961200, 28800, 300},
  {640108800, 32400, 300},
  {653410800, 28800, 300},
  {671558400, 32400, 300},
  {684860400, 28800, 300},
  {INT64_MIN, 24925, 301},
  {-2038200925, 25200, 301},
  {-1167634800, 26400, 301},
  {-1073028000, 26400, 301},
  {-894180000, 27000, 301},
  {-879665400, 32400, 301},
  {-767005200, 27000, 301},
  {-138785400, 27000, 301},
  {378664200, 28800, 301},
  {-778579200, 32400, 302},
  {-765363600, 28800, 302},
  {-747043200, 32400, 302},
  {-733827600, 28800, 302},
  {-715507200, 32400, 302},
  {-702291600, 28800, 302},
  {-683884800, 32400, 302},
  {-670669200, 28800, 302},
  {-652348800, 32400, 302},
  {-639133200, 28800, 302},
  {-620812800, 32400, 302},
  {-607597200, 28800, 302},
  {-589276800, 32400, 302},
  {-576061200, 28800, 302},
  {-562924800, 32400, 302},
  {-541760400, 28800, 302},
  {-528710400, 32400, 302},
  {-510224400, 28800, 302},
  {-497174400, 32400, 302},
  {-478688400, 28800, 302},
  {-465638400, 32400, 302},
  {-449830800, 28800, 302},
  {-434016000, 32400, 302},
  {-418208400, 28800, 302},
  {-402480000, 32400, 302},
  {-386672400, 28800, 302},
  {-370944000, 32400, 302},
  {-355136400, 28800, 302},
  {-339408000, 32400, 302},
  {-323600400, 28800, 302},
  {-302515200, 32400, 302},
  {-291978000, 28800, 302},
  {-270979200, 32400, 302},
  {-260442000, 28800, 302},
  {133977600, 32400, 302},
  {149785200, 28800, 302},
  {165513600, 32400, 302},
  {181321200, 28800, 302},
  {299520000, 32400, 302},
  {307465200, 28800, 302},
  {INT64_MIN, 16632, 303},
  {-1441168632, 18000, 303},
  {-1247547600, 21600, 303},
  {354909600, 25200, 303},
  {370717200, 21600, 303},
  {386445600, 25200, 303},
  {402253200, 21600, 303},
  {417981600, 25200, 303},
  {433789200, 21600, 303},
  {449604000, 25200, 303},
  {465336000, 21600, 303},
  {481060800, 25200, 303},
  {496785600, 21600, 303},
  {512510400, 25200, 303},
  {528235200, 21600, 303},
  {543960000, 25200, 303},
  {559684800, 21600, 303},
  {575409600, 25200, 303},
  {591134400, 21600, 303},
  {606859200, 25200, 303},
  {622584000, 21600, 303},
  {638308800, 25200, 303},
  {654638400, 21600, 303},
  {670363200, 21600, 303},
  {683661600, 21600, 303},
  {686091600, 18000, 303},
  {694206000, 18000, 303},
  {INT64_MIN, 10756, 304},
  {-1441162756, 10800, 304},
  {-405140400, 14400, 304},
  {354916800, 18000, 304},
  {370724400, 14400, 304},
  {386452800, 18000, 304},
  {402260400, 14400, 304},
  {417988800, 18000, 304},
  {433796400, 14400, 304},
  {449611200, 18000, 304},
  {465343200, 14400, 304},
  {481068000, 18000, 304},
  {496792800, 14400, 304},
  {512517600, 18000, 304},
  {528242400, 14400, 304},
  {543967200, 18000, 304},
  {559692000, 14400, 304},
  {575416800, 18000, 304},
  {591141600, 14400, 304},
  {606866400, 18000, 304},
  {622591200, 14400, 304},
  {638316000, 18000, 304},
  {654645600, 14400, 304},
  {670370400, 14400, 304},
  {671140800, 14400, 304},
  {686098800, 10800, 304},
  {694213200, 10800, 304},
  {701816400, 14400, 304},
  {717537600, 10800, 304},
  {733266000, 14400, 304},
  {748987200, 10800, 304},
  {764715600, 14400, 304},
  {780436800, 14400, 304},
  {796161600, 18000, 304},
  {811882800, 14400, 304},
  {828216000, 18000, 304},
  {859662000, 18000, 304},
  {877806000, 14400, 304},
  {891115200, 18000, 304},
  {909255600, 14400, 304},
  {922564800, 18000, 304},
  {941310000, 14400, 304},
  {954014400, 18000, 304},
  {972759600, 14400, 304},
  {985464000, 18000, 304},
  {1004209200, 14400, 304},
  {1017518400, 18000, 304},
  {1035658800, 14400, 304},
  {1048968000, 18000, 304},
  {1067108400, 14400, 304},
  {1080417600, 18000, 304},
  {1088276400, 14400, 304},
  {1099177200, 10800, 304},
  {1111878000, 14400, 304},
  {INT64_MIN, 12344, 305},
  {-1704165944, 12344, 305},
  {-757394744, 12600, 305},
  {247177800, 14400, 305},
  {259272000, 18000, 305},
  {277758000, 14400, 305},
  {283982400, 12600, 305},
  {290809800, 16200, 305},
  {306531000, 12600, 305},
  {322432200, 16200, 305},
  {338499000, 12600, 305},
  {673216200, 16200, 305},
  {685481400, 12600, 305},
  {701209800, 16200, 305},
  {717103800, 12600, 305},
  {732745800, 16200, 305},
  {748639800, 12600, 305},
  {764281800, 16200, 305},
  {780175800, 12600, 305},
  {795817800, 16200, 305},
  {811711800, 12600, 305},
  {827353800, 16200, 305},
  {843247800, 12600, 305},
  {858976200, 16200, 305},
  {874870200, 12600, 305},
  {890512200, 16200, 305},
  {906406200, 12600, 305},
  {922048200, 16200, 305},
  {937942200, 12600, 305},
  {953584200, 16200, 305},
  {969478200, 12600, 305},
  {985206600, 16200, 305},
  {1001100600, 12600, 305},
  {1016742600, 16200, 305},
  {1032636600, 12600, 305},
  {1048278600, 16200, 305},
  {1064172600, 12600, 305},
  {1079814600, 16200, 305},
  {1095708600, 12600, 305},
  {1111437000, 16200, 305},
  {1127331000, 12600, 305},
  {1206045000, 16200, 305},
  {1221939000, 12600, 305},
  {1237667400, 16200, 305},
  {1253561400, 12600, 305},
  {1269203400, 16200, 305},
  {1285097400, 12600, 305},
  {1300739400, 16200, 305},
  {1316633400, 12600, 305},
  {1332275400, 16200, 305},
  {1348169400, 12600, 305},
  {1363897800, 16200, 305},
  {1379791800, 12600, 305},
  {1395433800, 16200, 305},
  {1411327800, 12600, 305},
  {1426969800, 16200, 305},
  {1442863800, 12600, 305},
  {1458505800, 16200, 305},
  {1474399800, 12600, 305},
  {1490128200, 16200, 305},
  {1506022200, 12600, 305},
  {1521664200, 16200, 305},
  {1537558200, 12600, 305},
  {1553200200, 16200, 305},
  {1569094200, 12600, 305},
  {1584736200, 16200, 305},
  {1600630200, 12600, 305},
  {1616358600, 16200, 305},
  {1632252600, 12600, 305},
  {1647894600, 16200, 305},
  {1663788600, 12600, 305},
  {1679430600, 16200, 305},
  {1695324600, 12600, 305},
  {1710966600, 16200, 305},
  {1726860600, 12600, 305},
  {1742589000, 16200, 305},
  {1758483000, 12600, 305},
  {1774125000, 16200, 305},
  {1790019000, 12600, 305},
  {1805661000, 16200, 305},
  {1821555000, 12600, 305},
  {1837197000, 16200, 305},
  {1853091000, 12600, 305},
  {1868733000, 16200, 305},
  {1884627000, 12600, 305},
  {1900355400, 16200, 305},
  {1916249400, 12600, 305},
  {1931891400, 16200, 305},
  {1947785400, 12600, 305},
  {1963427400, 16200, 305},
  {1979321400, 12600, 305},
  {1994963400, 16200, 305},
  {2010857400, 12600, 305},
  {2026585800, 16200, 305},
  {2042479800, 12600, 305},
  {2058121800, 16200, 305},
  {2074015800, 12600, 305},
  {2089657800, 16200, 305},
  {2105551800, 12600, 305},
  {2121193800, 16200, 305},
  {2137087800, 12600, 305},
  {INT64_MIN, 8440, 306},
  {-1641003640, 7200, 306},
  {-933645600, 10800, 306},
  {-857358000, 7200, 306},
  {-844300800, 10800, 306},
  {-825822000, 7200, 306},
  {-812685600, 10800, 306},
  {-794199600, 7200, 306},
  {-779853600, 10800, 306},
  {-762656400, 7200, 306},
  {-748310400, 10800, 306},
  {-731127600, 7200, 306},
  {-681962400, 14400, 306},
  {-673243200, 10800, 306},
  {-667962000, 7200, 306},
  {-652327200, 10800, 306},
  {-636426000, 7200, 306},
  {-622087200, 10800, 306},
  {-608947200, 7200, 306},
  {-591847200, 10800, 306},
  {-572486400, 7200, 306},
  {-558576000, 10800, 306},
  {-542851200, 7200, 306},
  {-527731200, 10800, 306},
  {-514425600, 7200, 306},
  {-490845600, 10800, 306},
  {-482986800, 7200, 306},
  {-459475200, 10800, 306},
  {-451537200, 7200, 306},
  {-428551200, 10800, 306},
  {-418262400, 7200, 306},
  {-400032000, 10800, 306},
  {-387428400, 7200, 306},
  {142380000, 10800, 306},
  {150843600, 7200, 306},
  {167176800, 10800, 306},
  {178664400, 7200, 306},
  {482277600, 10800, 306},
  {495579600, 7200, 306},
  {516751200, 10800, 306},
  {526424400, 7200, 306},
  {545436000, 10800, 306},
  {558478800, 7200, 306},
  {576540000, 10800, 306},
  {589237200, 7200, 306},
  {609890400, 10800, 306},
  {620773200, 7200, 306},
  {638316000, 10800, 306},
  {651618000, 7200, 306},
  {669765600, 10800, 306},
  {683672400, 7200, 306},
  {701820000, 10800, 306},
  {715726800, 7200, 306},
  {733701600, 10800, 306},
  {747176400, 7200, 306},
  {765151200, 10800, 306},
  {778021200, 7200, 306},
  {796600800, 10800, 306},
  {810075600, 7200, 306},
  {826840800, 10800, 306},
  {842821200, 7200, 306},
  {858895200, 10800, 306},
  {874184400, 7200, 306},
  {890344800, 10800, 306},
  {905029200, 7200, 306},
  {923011200, 10800, 306},
  {936313200, 7200, 306},
  {955670400, 10800, 306},
  {970783200, 7200, 306},
  {986770800, 10800, 306},
  {1001282400, 7200, 306},
  {1017356400, 10800, 306},
  {1033941600, 7200, 306},
  {1048806000, 10800, 306},
  {1065132000, 7200, 306},
  {1081292400, 10800, 306},
  {1095804000, 7200, 306},
  {1112313600, 10800, 306},
  {1128812400, 7200, 306},
  {1143763200, 10800, 306},
  {1159657200, 7200, 306},
  {1175212800, 10800, 306},
  {1189897200, 7200, 306},
  {1206662400, 10800, 306},
  {1223161200, 7200, 306},
  {1238112000, 10800, 306},
  {1254006000, 7200, 306},
  {1269561600, 10800, 306},
  {1284246000, 7200, 306},
  {1301616000, 10800, 306},
  {1317510000, 7200, 306},
  {1333065600, 10800, 306},
  {1348354800, 7200, 306},
  {1364515200, 10800, 306},
  {1378594800, 7200, 306},
  {1395964800, 10800, 306},
  {1411858800, 7200, 306},
  {1427414400, 10800, 306},
  {1442703600, 7200, 306},
  {1459468800, 10800, 306},
  {1475967600, 7200, 306},
  {1490918400, 10800, 306},
  {1506207600, 7200, 306},
  {1522368000, 10800, 306},
  {1537052400, 7200, 306},
  {1553817600, 10800, 306},
  {1570316400, 7200, 306},
  {1585267200, 10800, 306},
  {1601161200, 7200, 306},
  {1616716800, 10800, 306},
  {1631401200, 7200, 306},
  {1648771200, 10800, 306},
  {1664665200, 7200, 306},
  {1680220800, 10800, 306},
  {1695510000, 7200, 306},
  {1711670400, 10800, 306},
  {1728169200, 7200, 306},
  {1743120000, 10800, 306},
  {1759014000, 7200, 306},
  {1774569600, 10800, 306},
  {1789858800, 7200, 306},
  {1806019200, 10800, 306},
  {1823122800, 7200, 306},
  {1838073600, 10800, 306},
  {1853362800, 7200, 306},
  {1869523200, 10800, 306},
  {1884207600, 7200, 306},
  {1900972800, 10800, 306},
  {1917471600, 7200, 306},
  {1932422400, 10800, 306},
  {1947711600, 7200, 306},
  {1963872000, 10800, 306},
  {1978556400, 7200, 306},
  {1995926400, 10800, 306},
  {2011820400, 7200, 306},
  {2027376000, 10800, 306},
  {2042060400, 7200, 306},
  {2058825600, 10800, 306},
  {2075324400, 7200, 306},
  {2090275200, 10800, 306},
  {2106169200, 7200, 306},
  {2121724800, 10800, 306},
  {2136409200, 7200, 306},
  {INT64_MIN, 21516, 307},
  {-706341516, 19800, 307},
  {560025000, 21600, 307},
  {INT64_MIN, 21516, 308},
  {-706341516, 19800, 308},
  {560025000, 21600, 308},
  {INT64_MIN, 32400, 309},
  {-1009875600, 32400, 309},
  {-683794800, 36000, 309},
  {-672393600, 32400, 309},
  {-654764400, 36000, 309},
  {-640944000, 32400, 309},
  {-620290800, 36000, 309},
  {-609494400, 32400, 309},
  {-588841200, 36000, 309},
  {-578044800, 32400, 309},
  {INT64_MIN, 28656, 310},
  {-1577951856, 28656, 310},
  {-1172908656, 28800, 310},
  {-880272000, 32400, 310},
  {-766054800, 28800, 310},
  {INT64_MIN, 25652, 311},
  {-2032931252, 25200, 311},
  {252435600, 28800, 311},
  {417974400, 32400, 311},
  {433782000, 28800, 311},
  {449596800, 32400, 311},
  {465318000, 28800, 311},
  {481046400, 32400, 311},
  {496767600, 28800, 311},
  {512496000, 32400, 311},
  {528217200, 28800, 311},
  {543945600, 32400, 311},
  {559666800, 28800, 311},
  {575395200, 32400, 311},
  {591116400, 28800, 311},
  {606844800, 32400, 311},
  {622566000, 28800, 311},
  {638294400, 32400, 311},
  {654620400, 28800, 311},
  {670348800, 32400, 311},
  {686070000, 28800, 311},
  {701798400, 32400, 311},
  {717519600, 28800, 311},
  {733248000, 32400, 311},
  {748969200, 28800, 311},
  {764697600, 32400, 311},
  {780418800, 28800, 311},
  {796147200, 32400, 311},
  {811868400, 28800, 311},
  {828201600, 32400, 311},
  {843922800, 28800, 311},
  {859651200, 32400, 311},
  {875372400, 28800, 311},
  {891100800, 32400, 311},
  {906822000, 28800, 311},
  {988394400, 32400, 311},
  {1001696400, 28800, 311},
  {1017424800, 32400, 311},
  {1033146000, 28800, 311},
  {1048874400, 32400, 311},
  {1064595600, 28800, 311},
  {1080324000, 32400, 311},
  {1096045200, 28800, 311},
  {1111773600, 32400, 311},
  {1127494800, 28800, 311},
  {1143223200, 32400, 311},
  {1159549200, 28800, 311},
  {INT64_MIN, 25652, 312},
  {-2032931252, 25200, 312},
  {252435600, 28800, 312},
  {417974400, 32400, 312},
  {433782000, 28800, 312},
  {449596800, 32400, 312},
  {465318000, 28800, 312},
  {481046400, 32400, 312},
  {496767600, 28800, 312},
  {512496000, 32400, 312},
  {528217200, 28800, 312},
  {543945600, 32400, 312},
  {559666800, 28800, 312},
  {575395200, 32400, 312},
  {591116400, 28800, 312},
  {606844800, 32400, 312},
  {622566000, 28800, 312},
  {638294400, 32400, 312},
  {654620400, 28800, 312},
  {670348800, 32400, 312},
  {686070000, 28800, 312},
  {701798400, 32400, 312},
  {717519600, 28800, 312},
  {733248000, 32400, 312},
  {748969200, 28800, 312},
  {764697600, 32400, 312},
  {780418800, 28800, 312},
  {796147200, 32400, 312},
  {811868400, 28800, 312},
  {828201600, 32400, 312},
  {843922800, 28800, 312},
  {859651200, 32400, 312},
  {875372400, 28800, 312},
  {891100800, 32400, 312},
  {906822000, 28800, 312},
  {988394400, 32400, 312},
  {1001696400, 28800, 312},
  {1017424800, 32400, 312},
  {1033146000, 28800, 312},
  {1048874400, 32400, 312},
  {1064595600, 28800, 312},
  {1080324000, 32400, 312},
  {1096045200, 28800, 312},
  {1111773600, 32400, 312},
  {1127494800, 28800, 312},
  {1143223200, 32400, 312},
  {1159549200, 28800, 312},
  {INT64_MIN, 21020, 313},
  {-1325483420, 21600, 313},
  {325965600, 28800, 313},
  {515520000, 32400, 313},
  {527007600, 28800, 313},
  {545155200, 32400, 313},
  {558457200, 28800, 313},
  {576604800, 32400, 313},
  {589906800, 28800, 313},
  {608659200, 32400, 313},
  {621961200, 28800, 313},
  {640108800, 32400, 313},
  {653410800, 28800, 313},
  {671558400, 32400, 313},
  {684860400, 28800, 313},
  {INT64_MIN, 24624, 314},
  {-2005973424, 25580, 314},
  {-1855983920, 25200, 314},
  {-1819954800, 28800, 314},
  {-1220428800, 25200, 314},
  {INT64_MIN, 31664, 315},
  {-1487321264, 32400, 315},
  {-1247562000, 36000, 315},
  {354895200, 39600, 315},
  {370702800, 36000, 315},
  {386431200, 39600, 315},
  {402238800, 36000, 315},
  {417967200, 39600, 315},
  {433774800, 36000, 315},
  {449589600, 39600, 315},
  {465321600, 36000, 315},
  {481046400, 39600, 315},
  {496771200, 36000, 315},
  {512496000, 39600, 315},
  {528220800, 36000, 315},
  {543945600, 39600, 315},
  {559670400, 36000, 315},
  {575395200, 39600, 315},
  {591120000, 36000, 315},
  {606844800, 39600, 315},
  {622569600, 36000, 315},
  {638294400, 39600, 315},
  {654624000, 36000, 315},
  {670348800, 36000, 315},
  {686077200, 32400, 315},
  {695754000, 36000, 315},
  {701787600, 39600, 315},
  {717508800, 36000, 315},
  {733248000, 39600, 315},
  {748972800, 36000, 315},
  {764697600, 39600, 315},
  {780422400, 36000, 315},
  {796147200, 39600, 315},
  {811872000, 36000, 315},
  {828201600, 39600, 315},
  {846345600, 36000, 315},
  {859651200, 39600, 315},
  {877795200, 36000, 315},
  {891100800, 39600, 315},
  {909244800, 36000, 315},
  {922550400, 39600, 315},
  {941299200, 36000, 315},
  {954000000, 39600, 315},
  {972748800, 36000, 315},
  {985449600, 39600, 315},
  {1004198400, 36000, 315},
  {1017504000, 39600, 315},
  {1035648000, 36000, 315},
  {1048953600, 39600, 315},
  {1067097600, 36000, 315},
  {1080403200, 39600, 315},
  {1099152000, 36000, 315},
  {1111852800, 39600, 315},
  {1130601600, 36000, 315},
  {1143302400, 39600, 315},
  {1162051200, 36000, 315},
  {1174752000, 39600, 315},
  {1193500800, 36000, 315},
  {1206806400, 39600, 315},
  {1224950400, 36000, 315},
  {1238256000, 39600, 315},
  {1256400000, 36000, 315},
  {1269705600, 39600, 315},
  {1288454400, 36000, 315},
  {1301155200, 39600, 315},
  {INT64_MIN, 31120, 316},
  {-1579423120, 28800, 316},
  {-1247558400, 32400, 316},
  {354898800, 36000, 316},
  {370706400, 32400, 316},
  {386434800, 36000, 316},
  {402242400, 32400, 316},
  {417970800, 36000, 316},
  {433778400, 32400, 316},
  {449593200, 36000, 316},
  {465325200, 32400, 316},
  {481050000, 36000, 316},
  {496774800, 32400, 316},
  {512499600, 36000, 316},
  {528224400, 32400, 316},
  {543949200, 36000, 316},
  {559674000, 32400, 316},
  {575398800, 36000, 316},
  {591123600, 32400, 316},
  {606848400, 36000, 316},
  {622573200, 32400, 316},
  {638298000, 36000, 316},
  {654627600, 32400, 316},
  {670352400, 32400, 316},
  {686080800, 28800, 316},
  {695757600, 32400, 316},
  {701791200, 36000, 316},
  {717512400, 32400, 316},
  {733251600, 36000, 316},
  {748976400, 32400, 316},
  {764701200, 36000, 316},
  {780426000, 32400, 316},
  {796150800, 36000, 316},
  {811875600, 32400, 316},
  {828205200, 36000, 316},
  {846349200, 32400, 316},
  {859654800, 36000, 316},
  {877798800, 32400, 316},
  {891104400, 36000, 316},
  {909248400, 32400, 316},
  {922554000, 36000, 316},
  {941302800, 32400, 316},
  {954003600, 36000, 316},
  {972752400, 32400, 316},
  {985453200, 36000, 316},
  {1004202000, 32400, 316},
  {1017507600, 36000, 316},
  {1035651600, 32400, 316},
  {1048957200, 36000, 316},
  {1067101200, 32400, 316},
  {1080406800, 36000, 316},
  {1099155600, 32400, 316},
  {1111856400, 36000, 316},
  {1130605200, 32400, 316},
  {1143306000, 36000, 316},
  {1162054800, 32400, 316},
  {1174755600, 36000, 316},
  {1193504400, 32400, 316},
  {1206810000, 36000, 316},
  {1224954000, 32400, 316},
  {1238259600, 36000, 316},
  {1256403600, 32400, 316},
  {1269709200, 36000, 316},
  {1288458000, 32400, 316},
  {1301158800, 36000, 316},
  {INT64_MIN, 14544, 317},
  {-1592611344, 14400, 317},
  {-1247544000, 18000, 317},
  {354913200, 21600, 317},
  {370720800, 18000, 317},
  {386449200, 21600, 317},
  {402256800, 18000, 317},
  {417985200, 21600, 317},
  {433792800, 18000, 317},
  {449607600, 21600, 317},
  {465339600, 18000, 317},
  {481064400, 21600, 317},
  {496789200, 18000, 317},
  {512514000, 21600, 317},
  {528238800, 18000, 317},
  {543963600, 21600, 317},
  {559688400, 18000, 317},
  {575413200, 21600, 317},
  {591138000, 18000, 317},
  {606862800, 21600, 317},
  {622587600, 18000, 317},
  {638312400, 21600, 317},
  {654642000, 18000, 317},
  {670366800, 18000, 317},
  {686095200, 14400, 317},
  {695772000, 18000, 317},
  {701805600, 21600, 317},
  {717526800, 18000, 317},
  {733266000, 21600, 317},
  {748990800, 18000, 317},
  {764715600, 21600, 317},
  {780440400, 18000, 317},
  {796165200, 21600, 317},
  {811890000, 18000, 317},
  {828219600, 21600, 317},
  {846363600, 18000, 317},
  {859669200, 21600, 317},
  {877813200, 18000, 317},
  {891118800, 21600, 317},
  {909262800, 18000, 317},
  {922568400, 21600, 317},
  {941317200, 18000, 317},
  {954018000, 21600, 317},
  {972766800, 18000, 317},
  {985467600, 21600, 317},
  {1004216400, 18000, 317},
  {1017522000, 21600, 317},
  {1035666000, 18000, 317},
  {1048971600, 21600, 317},
  {1067115600, 18000, 317},
  {1080421200, 21600, 317},
  {1099170000, 18000, 317},
  {1111870800, 21600, 317},
  {1130619600, 18000, 317},
  {1143320400, 21600, 317},
  {1162069200, 18000, 317},
  {1174770000, 21600, 317},
  {1193518800, 18000, 317},
  {1206824400, 21600, 317},
  {1224968400, 18000, 317},
  {1238274000, 21600, 317},
  {1256418000, 18000, 317},
  {1269723600, 21600, 317},
  {1288472400, 18000, 317},
  {1301173200, 21600, 317},
  {INT64_MIN, 10680, 318},
  {-1441162680, 10800, 318},
  {-405140400, 14400, 318},
  {354916800, 18000, 318},
  {370724400, 14400, 318},
  {386452800, 18000, 318},
  {402260400, 14400, 318},
  {417988800, 18000, 318},
  {433796400, 14400, 318},
  {449611200, 18000, 318},
  {465343200, 14400, 318},
  {481068000, 18000, 318},
  {496792800, 14400, 318},
  {512517600, 18000, 318},
  {528242400, 14400, 318},
  {543967200, 18000, 318},
  {559692000, 14400, 318},
  {575416800, 18000, 318},
  {591141600, 14400, 318},
  {606866400, 18000, 318},
  {622591200, 14400, 318},
  {638316000, 18000, 318},
  {654645600, 14400, 318},
  {670370400, 14400, 318},
  {685569600, 14400, 318},
  {686098800, 10800, 318},
  {701812800, 14400, 318},
  {717534000, 10800, 318},
  {733273200, 14400, 318},
  {748998000, 10800, 318},
  {764722800, 14400, 318},
  {780447600, 10800, 318},
  {796172400, 14400, 318},
  {811897200, 14400, 318},
  {852062400, 14400, 318},
  {859672800, 18000, 318},
  {877816800, 14400, 318},
  {891122400, 18000, 318},
  {909266400, 14400, 318},
  {922572000, 18000, 318},
  {941320800, 14400, 318},
  {954021600, 18000, 318},
  {972770400, 14400, 318},
  {985471200, 18000, 318},
  {1004220000, 14400, 318},
  {1017525600, 18000, 318},
  {1035669600, 14400, 318},
  {1048975200, 18000, 318},
  {1067119200, 14400, 318},
  {1080424800, 18000, 318},
  {1099173600, 14400, 318},
  {1111874400, 18000, 318},
  {1130623200, 14400, 318},
  {1143324000, 18000, 318},
  {1162072800, 14400, 318},
  {1174773600, 18000, 318},
  {1193522400, 14400, 318},
  {1206828000, 18000, 318},
  {1224972000, 14400, 318},
  {1238277600, 18000, 318},
  {1256421600, 14400, 318},
  {1269727200, 18000, 318},
  {1288476000, 14400, 318},
  {1301176800, 18000, 318},
  {1319925600, 14400, 318},
  {1332626400, 18000, 318},
  {1351375200, 14400, 318},
  {1364680800, 18000, 318},
  {1382824800, 14400, 318},
  {1396130400, 18000, 318},
  {1414274400, 14400, 318},
  {1427580000, 18000, 318},
  {1445724000, 14400, 318},
  {1459029600, 18000, 318},
  {1477778400, 14400, 318},
  {1490479200, 18000, 318},
  {1509228000, 14400, 318},
  {1521928800, 18000, 318},
  {1540677600, 14400, 318},
  {1553983200, 18000, 318},
  {1572127200, 14400, 318},
  {1585432800, 18000, 318},
  {1603576800, 14400, 318},
  {1616882400, 18000, 318},
  {1635631200, 14400, 318},
  {1648332000, 18000, 318},
  {1667080800, 14400, 318},
  {1679781600, 18000, 318},
  {1698530400, 14400, 318},
  {1711836000, 18000, 318},
  {1729980000, 14400, 318},
  {1743285600, 18000, 318},
  {1761429600, 14400, 318},
  {1774735200, 18000, 318},
  {1792879200, 14400, 318},
  {1806184800, 18000, 318},
  {1824933600, 14400, 318},
  {1837634400, 18000, 318},
  {1856383200, 14400, 318},
  {1869084000, 18000, 318},
  {1887832800, 14400, 318},
  {1901138400, 18000, 318},
  {1919282400, 14400, 318},
  {1932588000, 18000, 318},
  {1950732000, 14400, 318},
  {1964037600, 18000, 318},
  {1982786400, 14400, 318},
  {1995487200, 18000, 318},
  {2014236000, 14400, 318},
  {2026936800, 18000, 318},
  {2045685600, 14400, 318},
  {2058386400, 18000, 318},
  {2077135200, 14400, 318},
  {2090440800, 18000, 318},
  {2108584800, 14400, 318},
  {2121890400, 18000, 318},
  {2140034400, 14400, 318},
  {INT64_MIN, -6872, 319},
  {-1849557928, -7200, 319},
  {-1689548400, -3600, 319},
  {-1677794400, -7200, 319},
  {-1667430000, -3600, 319},
  {-1647730800, -7200, 319},
  {-1635807600, -3600, 319},
  {-1616194800, -7200, 319},
  {-1604358000, -3600, 319},
  {-1584658800, -7200, 319},
  {-1572735600, -3600, 319},
  {-1553036400, -7200, 319},
  {-1541199600, -3600, 319},
  {-1521500400, -7200, 319},
  {-1442444400, -3600, 319},
  {-1426806000, -7200, 319},
  {-1379286000, -3600, 319},
  {-1364770800, -7200, 319},
  {-1348441200, -3600, 319},
  {-1333321200, -7200, 319},
  {-1316386800, -3600, 319},
  {-1301266800, -7200, 319},
  {-1284332400, -3600, 319},
  {-1269817200, -7200, 319},
  {-1221433200, -3600, 319},
  {-1206918000, -7200, 319},
  {-1191193200, -3600, 319},
  {-1175468400, -7200, 319},
  {-1127689200, -3600, 319},
  {-1111964400, -7200, 319},
  {-1096844400, -3600, 319},
  {-1080514800, -7200, 319},
  {-1063580400, -3600, 319},
  {-1049065200, -7200, 319},
  {-1033340400, -3600, 319},
  {-1017615600, -7200, 319},
  {-1002495600, -3600, 319},
  {-986166000, -7200, 319},
  {-969231600, -3600, 319},
  {-950482800, -7200, 319},
  {-942015600, -3600, 319},
  {-922662000, -7200, 319},
  {-906937200, -3600, 319},
  {-891126000, -7200, 319},
  {-877302000, -3600, 319},
  {-873676800, 0, 319},
  {-864000000, -3600, 319},
  {-857948400, -7200, 319},
  {-845852400, -3600, 319},
  {-842832000, 0, 319},
  {-831340800, -3600, 319},
  {-825894000, -7200, 319},
  {-814402800, -3600, 319},
  {-810777600, 0, 319},
  {-799891200, -3600, 319},
  {-794444400, -7200, 319},
  {-782953200, -3600, 319},
  {-779328000, 0, 319},
  {-768441600, -3600, 319},
  {-762994800, -7200, 319},
  {-749084400, -3600, 319},
  {-733359600, -7200, 319},
  {-717624000, -3600, 319},
  {-701899200, -7200, 319},
  {-686174400, -3600, 319},
  {-670449600, -7200, 319},
  {-654724800, -3600, 319},
  {-639000000, -7200, 319},
  {-591825600, -3600, 319},
  {-575496000, -7200, 319},
  {-559771200, -3600, 319},
  {-544046400, -7200, 319},
  {-528321600, -3600, 319},
  {-512596800, -7200, 319},
  {-496872000, -3600, 319},
  {-481147200, -7200, 319},
  {-465422400, -3600, 319},
  {-449697600, -7200, 319},
  {-433972800, -3600, 319},
  {-417643200, -7200, 319},
  {-401918400, -3600, 319},
  {-386193600, -7200, 319},
  {-370468800, -3600, 319},
  {-354744000, -7200, 319},
  {-339019200, -3600, 319},
  {-323294400, -7200, 319},
  {-307569600, -3600, 319},
  {-291844800, -7200, 319},
  {-276120000, -3600, 319},
  {-260395200, -7200, 319},
  {-244670400, -3600, 319},
  {-228340800, -7200, 319},
  {-212616000, -3600, 319},
  {-196891200, -7200, 319},
  {-181166400, -3600, 319},
  {-165441600, -7200, 319},
  {-149716800, -3600, 319},
  {-133992000, -7200, 319},
  {-118267200, -3600, 319},
  {228272400, 0, 319},
  {243997200, -3600, 319},
  {260326800, 0, 319},
  {276051600, -3600, 319},
  {291776400, 0, 319},
  {307504800, -3600, 319},
  {323226000, 0, 319},
  {338954400, -3600, 319},
  {354679200, 0, 319},
  {370404000, -3600, 319},
  {386128800, 0, 319},
  {401853600, -3600, 319},
  {417582000, 0, 319},
  {433303200, -3600, 319},
  {449028000, 0, 319},
  {465357600, -3600, 319},
  {481082400, 0, 319},
  {496807200, -3600, 319},
  {512532000, 0, 319},
  {528256800, -3600, 319},
  {543981600, 0, 319},
  {559706400, -3600, 319},
  {575431200, 0, 319},
  {591156000, -3600, 319},
  {606880800, 0, 319},
  {622605600, -3600, 319},
  {638330400, 0, 319},
  {654660000, -3600, 319},
  {670384800, 0, 319},
  {686109600, -3600, 319},
  {701834400, 0, 319},
  {717559200, 0, 319},
  {733280400, 0, 319},
  {749005200, -3600, 319},
  {764730000, 0, 319},
  {780454800, -3600, 319},
  {796179600, 0, 319},
  {811904400, -3600, 319},
  {828234000, 0, 319},
  {846378000, -3600, 319},
  {859683600, 0, 319},
  {877827600, -3600, 319},
  {891133200, 0, 319},
  {909277200, -3600, 319},
  {922582800, 0, 319},
  {941331600, -3600, 319},
  {954032400, 0, 319},
  {972781200, -3600, 319},
  {985482000, 0, 319},
  {1004230800, -3600, 319},
  {1017536400, 0, 319},
  {1035680400, -3600, 319},
  {1048986000, 0, 319},
  {1067130000, -3600, 319},
  {1080435600, 0, 319},
  {1099184400, -3600, 319},
  {1111885200, 0, 319},
  {1130634000, -3600, 319},
  {1143334800, 0, 319},
  {1162083600, -3600, 319},
  {1174784400, 0, 319},
  {1193533200, -3600, 319},
  {1206838800, 0, 319},
  {1224982800, -3600, 319},
  {1238288400, 0, 319},
  {1256432400, -3600, 319},
  {1269738000, 0, 319},
  {1288486800, -3600, 319},
  {1301187600, 0, 319},
  {1319936400, -3600, 319},
  {1332637200, 0, 319},
  {1351386000, -3600, 319},
  {1364691600, 0, 319},
  {1382835600, -3600, 319},
  {1396141200, 0, 319},
  {1414285200, -3600, 319},
  {1427590800, 0, 319},
  {1445734800, -3600, 319},
  {1459040400, 0, 319},
  {1477789200, -3600, 319},
  {1490490000, 0, 319},
  {1509238800, -3600, 319},
  {1521939600, 0, 319},
  {1540688400, -3600, 319},
  {1553994000, 0, 319},
  {1572138000, -3600, 319},
  {1585443600, 0, 319},
  {1603587600, -3600, 319},
  {1616893200, 0, 319},
  {1635642000, -3600, 319},
  {1648342800, 0, 319},
  {1667091600, -3600, 319},
  {1679792400, 0, 319},
  {1698541200, -3600, 319},
  {1711846800, 0, 319},
  {1729990800, -3600, 319},
  {1743296400, 0, 319},
  {1761440400, -3600, 319},
  {1774746000, 0, 319},
  {1792890000, -3600, 319},
  {1806195600, 0, 319},
  {1824944400, -3600, 319},
  {1837645200, 0, 319},
  {1856394000, -3600, 319},
  {1869094800, 0, 319},
  {1887843600, -3600, 319},
  {1901149200, 0, 319},
  {1919293200, -3600, 319},
  {1932598800, 0, 319},
  {1950742800, -3600, 319},
  {1964048400, 0, 319},
  {1982797200, -3600, 319},
  {1995498000, 0, 319},
  {2014246800, -3600, 319},
  {2026947600, 0, 319},
  {2045696400, -3600, 319},
  {2058397200, 0, 319},
  {2077146000, -3600, 319},
  {2090451600, 0, 319},
  {2108595600, -3600, 319},
  {2121901200, 0, 319},
  {2140045200, -3600, 319},
  {INT64_MIN, -15544, 320},
  {-1262281256, -14400, 320},
  {136360800, -10800, 320},
  {152082000, -14400, 320},
  {167810400, -10800, 320},
  {183531600, -14400, 320},
  {199260000, -10800, 320},
  {215586000, -14400, 320},
  {230709600, -10800, 320},
  {247035600, -14400, 320},
  {262764000, -10800, 320},
  {278485200, -14400, 320},
  {294213600, -10800, 320},
  {309934800, -14400, 320},
  {325663200, -10800, 320},
  {341384400, -14400, 320},
  {357112800, -10800, 320},
  {372834000, -14400, 320},
  {388562400, -10800, 320},
  {404888400, -14400, 320},
  {420012000, -10800, 320},
  {436338000, -14400, 320},
  {452066400, -10800, 320},
  {467787600, -14400, 320},
  {483516000, -10800, 320},
  {499237200, -14400, 320},
  {514965600, -10800, 320},
  {530686800, -14400, 320},
  {544600800, -10800, 320},
  {562136400, -14400, 320},
  {576050400, -10800, 320},
  {594190800, -14400, 320},
  {607500000, -10800, 320},
  {625640400, -14400, 320},
  {638949600, -10800, 320},
  {657090000, -14400, 320},
  {671004000, -10800, 320},
  {688539600, -14400, 320},
  {702453600, -10800, 320},
  {719989200, -14400, 320},
  {733903200, -10800, 320},
  {752043600, -14400, 320},
  {765352800, -10800, 320},
  {783493200, -14400, 320},
  {796802400, -10800, 320},
  {814942800, -14400, 320},
  {828856800, -10800, 320},
  {846392400, -14400, 320},
  {860306400, -10800, 320},
  {877842000, -14400, 320},
  {891756000, -10800, 320},
  {909291600, -14400, 320},
  {923205600, -10800, 320},
  {941346000, -14400, 320},
  {954655200, -10800, 320},
  {972795600, -14400, 320},
  {986104800, -10800, 320},
  {1004245200, -14400, 320},
  {1018159200, -10800, 320},
  {1035694800, -14400, 320},
  {1049608800, -10800, 320},
  {1067144400, -14400, 320},
  {1081058400, -10800, 320},
  {1099198800, -14400, 320},
  {1112508000, -10800, 320},
  {1130648400, -14400, 320},
  {1143957600, -10800, 320},
  {1162098000, -14400, 320},
  {1173592800, -10800, 320},
  {1194152400, -14400, 320},
  {1205042400, -10800, 320},
  {1225602000, -14400, 320},
  {1236492000, -10800, 320},
  {1257051600, -14400, 320},
  {1268546400, -10800, 320},
  {1289106000, -14400, 320},
  {1299996000, -10800, 320},
  {1320555600, -14400, 320},
  {1331445600, -10800, 320},
  {1352005200, -14400, 320},
  {1362895200, -10800, 320},
  {1383454800, -14400, 320},
  {1394344800, -10800, 320},
  {1414904400, -14400, 320},
  {1425794400, -10800, 320},
  {1446354000, -14400, 320},
  {1457848800, -10800, 320},
  {1478408400, -14400, 320},
  {1489298400, -10800, 320},
  {1509858000, -14400, 320},
  {1520748000, -10800, 320},
  {1541307600, -14400, 320},
  {1552197600, -10800, 320},
  {1572757200, -14400, 320},
  {1583647200, -10800, 320},
  {1604206800, -14400, 320},
  {1615701600, -10800, 320},
  {1636261200, -14400, 320},
  {1647151200, -10800, 320},
  {1667710800, -14400, 320},
  {1678600800, -10800, 320},
  {1699160400, -14400, 320},
  {1710050400, -10800, 320},
  {1730610000, -14400, 320},
  {1741500000, -10800, 320},
  {1762059600, -14400, 320},
  {1772949600, -10800, 320},
  {1793509200, -14400, 320},
  {1805004000, -10800, 320},
  {1825563600, -14400, 320},
  {1836453600, -10800, 320},
  {1857013200, -14400, 320},
  {1867903200, -10800, 320},
  {1888462800, -14400, 320},
  {1899352800, -10800, 320},
  {1919912400, -14400, 320},
  {1930802400, -10800, 320},
  {1951362000, -14400, 320},
  {1962856800, -10800, 320},
  {1983416400, -14400, 320},
  {1994306400, -10800, 320},
  {2014866000, -14400, 320},
  {2025756000, -10800, 320},
  {2046315600, -14400, 320},
  {2057205600, -10800, 320},
  {2077765200, -14400, 320},
  {2088655200, -10800, 320},
  {2109214800, -14400, 320},
  {2120104800, -10800, 320},
  {2140664400, -14400, 320},
  {INT64_MIN, -3696, 321},
  {-1509663504, -3600, 321},
  {-733874400, 0, 321},
  {323827200, 3600, 321},
  {338950800, 0, 321},
  {354675600, 3600, 321},
  {370400400, 0, 321},
  {386125200, 3600, 321},
  {401850000, 0, 321},
  {417574800, 3600, 321},
  {433299600, 0, 321},
  {449024400, 3600, 321},
  {465354000, 0, 321},
  {481078800, 3600, 321},
  {496803600, 0, 321},
  {512528400, 3600, 321},
  {528253200, 0, 321},
  {543978000, 3600, 321},
  {559702800, 0, 321},
  {575427600, 3600, 321},
  {591152400, 0, 321},
  {606877200, 3600, 321},
  {622602000, 0, 321},
  {638326800, 3600, 321},
  {654656400, 0, 321},
  {670381200, 3600, 321},
  {686106000, 0, 321},
  {701830800, 3600, 321},
  {717555600, 0, 321},
  {733280400, 3600, 321},
  {749005200, 0, 321},
  {764730000, 3600, 321},
  {780454800, 0, 321},
  {796179600, 3600, 321},
  {811904400, 0, 321},
  {828234000, 3600, 321},
  {846378000, 0, 321},
  {859683600, 3600, 321},
  {877827600, 0, 321},
  {891133200, 3600, 321},
  {909277200, 0, 321},
  {922582800, 3600, 321},
  {941331600, 0, 321},
  {954032400, 3600, 321},
  {972781200, 0, 321},
  {985482000, 3600, 321},
  {1004230800, 0, 321},
  {1017536400, 3600, 321},
  {1035680400, 0, 321},
  {1048986000, 3600, 321},
  {1067130000, 0, 321},
  {1080435600, 3600, 321},
  {1099184400, 0, 321},
  {1111885200, 3600, 321},
  {1130634000, 0, 321},
  {1143334800, 3600, 321},
  {1162083600, 0, 321},
  {1174784400, 3600, 321},
  {1193533200, 0, 321},
  {1206838800, 3600, 321},
  {1224982800, 0, 321},
  {1238288400, 3600, 321},
  {1256432400, 0, 321},
  {1269738000, 3600, 321},
  {1288486800, 0, 321},
  {1301187600, 3600, 321},
  {1319936400, 0, 321},
  {1332637200, 3600, 321},
  {1351386000, 0, 321},
  {1364691600, 3600, 321},
  {1382835600, 0, 321},
  {1396141200, 3600, 321},
  {1414285200, 0, 321},
  {1427590800, 3600, 321},
  {1445734800, 0, 321},
  {1459040400, 3600, 321},
  {1477789200, 0, 321},
  {1490490000, 3600, 321},
  {1509238800, 0, 321},
  {1521939600, 3600, 321},
  {1540688400, 0, 321},
  {1553994000, 3600, 321},
  {1572138000, 0, 321},
  {1585443600, 3600, 321},
  {1603587600, 0, 321},
  {1616893200, 3600, 321},
  {1635642000, 0, 321},
  {1648342800, 3600, 321},
  {1667091600, 0, 321},
  {1679792400, 3600, 321},
  {1698541200, 0, 321},
  {1711846800, 3600, 321},
  {1729990800, 0, 321},
  {1743296400, 3600, 321},
  {1761440400, 0, 321},
  {1774746000, 3600, 321},
  {1792890000, 0, 321},
  {1806195600, 3600, 321},
  {1824944400, 0, 321},
  {1837645200, 3600, 321},
  {1856394000, 0, 321},
  {1869094800, 3600, 321},
  {1887843600, 0, 321},
  {1901149200, 3600, 321},
  {1919293200, 0, 321},
  {1932598800, 3600, 321},
  {1950742800, 0, 321},
  {1964048400, 3600, 321},
  {1982797200, 0, 321},
  {1995498000, 3600, 321},
  {2014246800, 0, 321},
  {2026947600, 3600, 321},
  {2045696400, 0, 321},
  {2058397200, 3600, 321},
  {2077146000, 0, 321},
  {2090451600, 3600, 321},
  {2108595600, 0, 321},
  {2121901200, 3600, 321},
  {2140045200, 0, 321},
  {INT64_MIN, -5644, 322},
  {-1988144756, -7200, 322},
  {-862610400, -3600, 322},
  {-764118000, -7200, 322},
  {186120000, -3600, 322},
  {INT64_MIN, -1624, 323},
  {-1955748776, 0, 323},
  {354675600, 3600, 323},
  {370400400, 0, 323},
  {386125200, 3600, 323},
  {401850000, 0, 323},
  {417574800, 3600, 323},
  {433299600, 0, 323},
  {449024400, 3600, 323},
  {465354000, 0, 323},
  {481078800, 3600, 323},
  {496803600, 0, 323},
  {512528400, 3600, 323},
  {528253200, 0, 323},
  {543978000, 3600, 323},
  {559702800, 0, 323},
  {575427600, 3600, 323},
  {591152400, 0, 323},
  {606877200, 3600, 323},
  {622602000, 0, 323},
  {638326800, 3600, 323},
  {654656400, 0, 323},
  {670381200, 3600, 323},
  {686106000, 0, 323},
  {701830800, 3600, 323},
  {717555600, 0, 323},
  {733280400, 3600, 323},
  {749005200, 0, 323},
  {764730000, 3600, 323},
  {780454800, 0, 323},
  {796179600, 3600, 323},
  {811904400, 0, 323},
  {828234000, 3600, 323},
  {846378000, 0, 323},
  {859683600, 3600, 323},
  {877827600, 0, 323},
  {891133200, 3600, 323},
  {909277200, 0, 323},
  {922582800, 3600, 323},
  {941331600, 0, 323},
  {954032400, 3600, 323},
  {972781200, 0, 323},
  {985482000, 3600, 323},
  {1004230800, 0, 323},
  {1017536400, 3600, 323},
  {1035680400, 0, 323},
  {1048986000, 3600, 323},
  {1067130000, 0, 323},
  {1080435600, 3600, 323},
  {1099184400, 0, 323},
  {1111885200, 3600, 323},
  {1130634000, 0, 323},
  {1143334800, 3600, 323},
  {1162083600, 0, 323},
  {1174784400, 3600, 323},
  {1193533200, 0, 323},
  {1206838800, 3600, 323},
  {1224982800, 0, 323},
  {1238288400, 3600, 323},
  {1256432400, 0, 323},
  {1269738000, 3600, 323},
  {1288486800, 0, 323},
  {1301187600, 3600, 323},
  {1319936400, 0, 323},
  {1332637200, 3600, 323},
  {1351386000, 0, 323},
  {1364691600, 3600, 323},
  {1382835600, 0, 323},
  {1396141200, 3600, 323},
  {1414285200, 0, 323},
  {1427590800, 3600, 323},
  {1445734800, 0, 323},
  {1459040400, 3600, 323},
  {1477789200, 0, 323},
  {1490490000, 3600, 323},
  {1509238800, 0, 323},
  {1521939600, 3600, 323},
  {1540688400, 0, 323},
  {1553994000, 3600, 323},
  {1572138000, 0, 323},
  {1585443600, 3600, 323},
  {1603587600, 0, 323},
  {1616893200, 3600, 323},
  {1635642000, 0, 323},
  {1648342800, 3600, 323},
  {1667091600, 0, 323},
  {1679792400, 3600, 323},
  {1698541200, 0, 323},
  {1711846800, 3600, 323},
  {1729990800, 0, 323},
  {1743296400, 3600, 323},
  {1761440400, 0, 323},
  {1774746000, 3600, 323},
  {1792890000, 0, 323},
  {1806195600, 3600, 323},
  {1824944400, 0, 323},
  {1837645200, 3600, 323},
  {1856394000, 0, 323},
  {1869094800, 3600, 323},
  {1887843600, 0, 323},
  {1901149200, 3600, 323},
  {1919293200, 0, 323},
  {1932598800, 3600, 323},
  {1950742800, 0, 323},
  {1964048400, 3600, 323},
  {1982797200, 0, 323},
  {1995498000, 3600, 323},
  {2014246800, 0, 323},
  {2026947600, 3600, 323},
  {2045696400, 0, 323},
  {2058397200, 3600, 323},
  {2077146000, 0, 323},
  {2090451600, 3600, 323},
  {2108595600, 0, 323},
  {2121901200, 3600, 323},
  {2140045200, 0, 323},
  {INT64_MIN, -1624, 324},
  {-1955748776, 0, 324},
  {354675600, 3600, 324},
  {370400400, 0, 324},
  {386125200, 3600, 324},
  {401850000, 0, 324},
  {417574800, 3600, 324},
  {433299600, 0, 324},
  {449024400, 3600, 324},
  {465354000, 0, 324},
  {481078800, 3600, 324},
  {496803600, 0, 324},
  {512528400, 3600, 324},
  {528253200, 0, 324},
  {543978000, 3600, 324},
  {559702800, 0, 324},
  {575427600, 3600, 324},
  {591152400, 0, 324},
  {606877200, 3600, 324},
  {622602000, 0, 324},
  {638326800, 3600, 324},
  {654656400, 0, 324},
  {670381200, 3600, 324},
  {686106000, 0, 324},
  {701830800, 3600, 324},
  {717555600, 0, 324},
  {733280400, 3600, 324},
  {749005200, 0, 324},
  {764730000, 3600, 324},
  {780454800, 0, 324},
  {796179600, 3600, 324},
  {811904400, 0, 324},
  {828234000, 3600, 324},
  {846378000, 0, 324},
  {859683600, 3600, 324},
  {877827600, 0, 324},
  {891133200, 3600, 324},
  {909277200, 0, 324},
  {922582800, 3600, 324},
  {941331600, 0, 324},
  {954032400, 3600, 324},
  {972781200, 0, 324},
  {985482000, 3600, 324},
  {1004230800, 0, 324},
  {1017536400, 3600, 324},
  {1035680400, 0, 324},
  {1048986000, 3600, 324},
  {1067130000, 0, 324},
  {1080435600, 3600, 324},
  {1099184400, 0, 324},
  {1111885200, 3600, 324},
  {1130634000, 0, 324},
  {1143334800, 3600, 324},
  {1162083600, 0, 324},
  {1174784400, 3600, 324},
  {1193533200, 0, 324},
  {1206838800, 3600, 324},
  {1224982800, 0, 324},
  {1238288400, 3600, 324},
  {1256432400, 0, 324},
  {1269738000, 3600, 324},
  {1288486800, 0, 324},
  {1301187600, 3600, 324},
  {1319936400, 0, 324},
  {1332637200, 3600, 324},
  {1351386000, 0, 324},
  {1364691600, 3600, 324},
  {1382835600, 0, 324},
  {1396141200, 3600, 324},
  {1414285200, 0, 324},
  {1427590800, 3600, 324},
  {1445734800, 0, 324},
  {1459040400, 3600, 324},
  {1477789200, 0, 324},
  {1490490000, 3600, 324},
  {1509238800, 0, 324},
  {1521939600, 3600, 324},
  {1540688400, 0, 324},
  {1553994000, 3600, 324},
  {1572138000, 0, 324},
  {1585443600, 3600, 324},
  {1603587600, 0, 324},
  {1616893200, 3600, 324},
  {1635642000, 0, 324},
  {1648342800, 3600, 324},
  {1667091600, 0, 324},
  {1679792400, 3600, 324},
  {1698541200, 0, 324},
  {1711846800, 3600, 324},
  {1729990800, 0, 324},
  {1743296400, 3600, 324},
  {1761440400, 0, 324},
  {1774746000, 3600, 324},
  {1792890000, 0, 324},
  {1806195600, 3600, 324},
  {1824944400, 0, 324},
  {1837645200, 3600, 324},
  {1856394000, 0, 324},
  {1869094800, 3600, 324},
  {1887843600, 0, 324},
  {1901149200, 3600, 324},
  {1919293200, 0, 324},
  {1932598800, 3600, 324},
  {1950742800, 0, 324},
  {1964048400, 3600, 324},
  {1982797200, 0, 324},
  {1995498000, 3600, 324},
  {2014246800, 0, 324},
  {2026947600, 3600, 324},
  {2045696400, 0, 324},
  {2058397200, 3600, 324},
  {2077146000, 0, 324},
  {2090451600, 3600, 324},
  {2108595600, 0, 324},
  {2121901200, 3600, 324},
  {2140045200, 0, 324},
  {-1691884800, 7200, 325},
  {-1680573600, 3600, 325},
  {-927511200, 7200, 325},
  {-857257200, 3600, 325},
  {-844556400, 7200, 325},
  {-828226800, 3600, 325},
  {-812502000, 7200, 325},
  {-796777200, 3600, 325},
  {-781052400, 7200, 325},
  {-765327600, 3600, 325},
  {-340844400, 7200, 325},
  {-324514800, 3600, 325},
  {-308790000, 7200, 325},
  {-293065200, 3600, 325},
  {-277340400, 7200, 325},
  {-261615600, 3600, 325},
  {-245890800, 7200, 325},
  {-230166000, 3600, 325},
  {-214441200, 7200, 325},
  {-198716400, 3600, 325},
  {-182991600, 7200, 325},
  {-166662000, 3600, 325},
  {-147913200, 7200, 325},
  {-135212400, 3600, 325},
  {315529200, 3600, 325},
  {323830800, 7200, 325},
  {338950800, 3600, 325},
  {354675600, 7200, 325},
  {370400400, 3600, 325},
  {386125200, 7200, 325},
  {401850000, 3600, 325},
  {417574800, 7200, 325},
  {433299600, 3600, 325},
  {449024400, 7200, 325},
  {465354000, 3600, 325},
  {481078800, 7200, 325},
  {496803600, 3600, 325},
  {512528400, 7200, 325},
  {528253200, 3600, 325},
  {543978000, 7200, 325},
  {559702800, 3600, 325},
  {575427600, 7200, 325},
  {591152400, 3600, 325},
  {606877200, 7200, 325},
  {622602000, 3600, 325},
  {638326800, 7200, 325},
  {654656400, 3600, 325},
  {670381200, 7200, 325},
  {686106000, 3600, 325},
  {701830800, 7200, 325},
  {717555600, 3600, 325},
  {733280400, 7200, 325},
  {749005200, 3600, 325},
  {764730000, 7200, 325},
  {780454800, 3600, 325},
  {796179600, 7200, 325},
  {811904400, 3600, 325},
  {828234000, 7200, 325},
  {846378000, 3600, 325},
  {859683600, 7200, 325},
  {877827600, 3600, 325},
  {891133200, 7200, 325},
  {909277200, 3600, 325},
  {922582800, 7200, 325},
  {941331600, 3600, 325},
  {954032400, 7200, 325},
  {972781200, 3600, 325},
  {985482000, 7200, 325},
  {1004230800, 3600, 325},
  {1017536400, 7200, 325},
  {1035680400, 3600, 325},
  {1048986000, 7200, 325},
  {1067130000, 3600, 325},
  {1080435600, 7200, 325},
  {1099184400, 3600, 325},
  {1111885200, 7200, 325},
  {1130634000, 3600, 325},
  {1143334800, 7200, 325},
  {1162083600, 3600, 325},
  {1174784400, 7200, 325},
  {1193533200, 3600, 325},
  {1206838800, 7200, 325},
  {1224982800, 3600, 325},
  {1238288400, 7200, 325},
  {1256432400, 3600, 325},
  {1269738000, 7200, 325},
  {1288486800, 3600, 325},
  {1301187600, 7200, 325},
  {1319936400, 3600, 325},
  {1332637200, 7200, 325},
  {1351386000, 3600, 325},
  {1364691600, 7200, 325},
  {1382835600, 3600, 325},
  {1396141200, 7200, 325},
  {1414285200, 3600, 325},
  {1427590800, 7200, 325},
  {1445734800, 3600, 325},
  {1459040400, 7200, 325},
  {1477789200, 3600, 325},
  {1490490000, 7200, 325},
  {1509238800, 3600, 325},
  {1521939600, 7200, 325},
  {1540688400, 3600, 325},
  {1553994000, 7200, 325},
  {1572138000, 3600, 325},
  {1585443600, 7200, 325},
  {1603587600, 3600, 325},
  {1616893200, 7200, 325},
  {1635642000, 3600, 325},
  {1648342800, 7200, 325},
  {1667091600, 3600, 325},
  {1679792400, 7200, 325},
  {1698541200, 3600, 325},
  {1711846800, 7200, 325},
  {1729990800, 3600, 325},
  {1743296400, 7200, 325},
  {1761440400, 3600, 325},
  {1774746000, 7200, 325},
  {1792890000, 3600, 325},
  {1806195600, 7200, 325},
  {1824944400, 3600, 325},
  {1837645200, 7200, 325},
  {1856394000, 3600, 325},
  {1869094800, 7200, 325},
  {1887843600, 3600, 325},
  {1901149200, 7200, 325},
  {1919293200, 3600, 325},
  {1932598800, 7200, 325},
  {1950742800, 3600, 325},
  {1964048400, 7200, 325},
  {1982797200, 3600, 325},
  {1995498000, 7200, 325},
  {2014246800, 3600, 325},
  {2026947600, 7200, 325},
  {2045696400, 3600, 325},
  {2058397200, 7200, 325},
  {2077146000, 3600, 325},
  {2090451600, 7200, 325},
  {2108595600, 3600, 325},
  {2121901200, 7200, 325},
  {2140045200, 3600, 325},
  {INT64_MIN, -4056, 326},
  {-1849560744, -3600, 326},
  {-1689552000, 0, 326},
  {-1677798000, -3600, 326},
  {-1667433600, 0, 326},
  {-1647734400, -3600, 326},
  {-1635811200, 0, 326},
  {-1616198400, -3600, 326},
  {-1604361600, 0, 326},
  {-1584662400, -3600, 326},
  {-1572739200, 0, 326},
  {-1553040000, -3600, 326},
  {-1541203200, 0, 326},
  {-1521504000, -3600, 326},
  {-1442448000, 0, 326},
  {-1426809600, -3600, 326},
  {-1379289600, 0, 326},
  {-1364774400, -3600, 326},
  {-1348444800, 0, 326},
  {-1333324800, -3600, 326},
  {-1316390400, 0, 326},
  {-1301270400, -3600, 326},
  {-1284336000, 0, 326},
  {-1269820800, -3600, 326},
  {-1221436800, 0, 326},
  {-1206921600, -3600, 326},
  {-1191196800, 0, 326},
  {-1175472000, -3600, 326},
  {-1127692800, 0, 326},
  {-1111968000, -3600, 326},
  {-1096848000, 0, 326},
  {-1080518400, -3600, 326},
  {-1063584000, 0, 326},
  {-1049068800, -3600, 326},
  {-1033344000, 0, 326},
  {-1017619200, -3600, 326},
  {-1002499200, 0, 326},
  {-986169600, -3600, 326},
  {-969235200, 0, 326},
  {-950486400, -3600, 326},
  {-942019200, 0, 326},
  {-922665600, -3600, 326},
  {-906940800, 0, 326},
  {-891129600, -3600, 326},
  {-877305600, 0, 326},
  {-873680400, 3600, 326},
  {-864003600, 0, 326},
  {-857952000, -3600, 326},
  {-845856000, 0, 326},
  {-842835600, 3600, 326},
  {-831344400, 0, 326},
  {-825897600, -3600, 326},
  {-814406400, 0, 326},
  {-810781200, 3600, 326},
  {-799894800, 0, 326},
  {-794448000, -3600, 326},
  {-782956800, 0, 326},
  {-779331600, 3600, 326},
  {-768445200, 0, 326},
  {-762998400, -3600, 326},
  {-749088000, 0, 326},
  {-733363200, -3600, 326},
  {-717627600, 0, 326},
  {-701902800, -3600, 326},
  {-686178000, 0, 326},
  {-670453200, -3600, 326},
  {-654728400, 0, 326},
  {-639003600, -3600, 326},
  {-591829200, 0, 326},
  {-575499600, -3600, 326},
  {-559774800, 0, 326},
  {-544050000, -3600, 326},
  {-528325200, 0, 326},
  {-512600400, -3600, 326},
  {-496875600, 0, 326},
  {-481150800, -3600, 326},
  {-465426000, 0, 326},
  {-449701200, -3600, 326},
  {-433976400, 0, 326},
  {-417646800, -3600, 326},
  {-401922000, 0, 326},
  {-386197200, -3600, 326},
  {-370472400, 0, 326},
  {-354747600, -3600, 326},
  {-339022800, 0, 326},
  {-323298000, -3600, 326},
  {-307573200, 0, 326},
  {-291848400, -3600, 326},
  {-276123600, 0, 326},
  {-260398800, -3600, 326},
  {-244674000, 0, 326},
  {-228344400, -3600, 326},
  {-212619600, 0, 326},
  {-196894800, -3600, 326},
  {-181170000, 0, 326},
  {-165445200, -3600, 326},
  {-149720400, 0, 326},
  {-133995600, -3600, 326},
  {-118270800, 0, 326},
  {228268800, 3600, 326},
  {243993600, 0, 326},
  {260323200, 3600, 326},
  {276048000, 0, 326},
  {291772800, 3600, 326},
  {307501200, 0, 326},
  {323222400, 3600, 326},
  {338950800, 0, 326},
  {354675600, 3600, 326},
  {370400400, 0, 326},
  {386125200, 3600, 326},
  {401850000, 0, 326},
  {417578400, 3600, 326},
  {433299600, 0, 326},
  {449024400, 3600, 326},
  {465354000, 0, 326},
  {481078800, 3600, 326},
  {496803600, 0, 326},
  {512528400, 3600, 326},
  {528253200, 0, 326},
  {543978000, 3600, 326},
  {559702800, 0, 326},
  {575427600, 3600, 326},
  {591152400, 0, 326},
  {606877200, 3600, 326},
  {622602000, 0, 326},
  {638326800, 3600, 326},
  {654656400, 0, 326},
  {670381200, 3600, 326},
  {686106000, 0, 326},
  {701830800, 3600, 326},
  {717555600, 0, 326},
  {733280400, 3600, 326},
  {749005200, 0, 326},
  {764730000, 3600, 326},
  {780454800, 0, 326},
  {796179600, 3600, 326},
  {811904400, 0, 326},
  {828234000, 3600, 326},
  {846378000, 0, 326},
  {859683600, 3600, 326},
  {877827600, 0, 326},
  {891133200, 3600, 326},
  {909277200, 0, 326},
  {922582800, 3600, 326},
  {941331600, 0, 326},
  {954032400, 3600, 326},
  {972781200, 0, 326},
  {985482000, 3600, 326},
  {1004230800, 0, 326},
  {1017536400, 3600, 326},
  {1035680400, 0, 326},
  {1048986000, 3600, 326},
  {1067130000, 0, 326},
  {1080435600, 3600, 326},
  {1099184400, 0, 326},
  {1111885200, 3600, 326},
  {1130634000, 0, 326},
  {1143334800, 3600, 326},
  {1162083600, 0, 326},
  {1174784400, 3600, 326},
  {1193533200, 0, 326},
  {1206838800, 3600, 326},
  {1224982800, 0, 326},
  {1238288400, 3600, 326},
  {1256432400, 0, 326},
  {1269738000, 3600, 326},
  {1288486800, 0, 326},
  {1301187600, 3600, 326},
  {1319936400, 0, 326},
  {1332637200, 3600, 326},
  {1351386000, 0, 326},
  {1364691600, 3600, 326},
  {1382835600, 0, 326},
  {1396141200, 3600, 326},
  {1414285200, 0, 326},
  {1427590800, 3600, 326},
  {1445734800, 0, 326},
  {1459040400, 3600, 326},
  {1477789200, 0, 326},
  {1490490000, 3600, 326},
  {1509238800, 0, 326},
  {1521939600, 3600, 326},
  {1540688400, 0, 326},
  {1553994000, 3600, 326},
  {1572138000, 0, 326},
  {1585443600, 3600, 326},
  {1603587600, 0, 326},
  {1616893200, 3600, 326},
  {1635642000, 0, 326},
  {1648342800, 3600, 326},
  {1667091600, 0, 326},
  {1679792400, 3600, 326},
  {1698541200, 0, 326},
  {1711846800, 3600, 326},
  {1729990800, 0, 326},
  {1743296400, 3600, 326},
  {1761440400, 0, 326},
  {1774746000, 3600, 326},
  {1792890000, 0, 326},
  {1806195600, 3600, 326},
  {1824944400, 0, 326},
  {1837645200, 3600, 326},
  {1856394000, 0, 326},
  {1869094800, 3600, 326},
  {1887843600, 0, 326},
  {1901149200, 3600, 326},
  {1919293200, 0, 326},
  {1932598800, 3600, 326},
  {1950742800, 0, 326},
  {1964048400, 3600, 326},
  {1982797200, 0, 326},
  {1995498000, 3600, 326},
  {2014246800, 0, 326},
  {2026947600, 3600, 326},
  {2045696400, 0, 326},
  {2058397200, 3600, 326},
  {2077146000, 0, 326},
  {2090451600, 3600, 326},
  {2108595600, 0, 326},
  {2121901200, 3600, 326},
  {2140045200, 0, 326},
  {INT64_MIN, -5268, 327},
  {-1956609132, -3600, 327},
  {-1668211200, 0, 327},
  {-1647212400, -3600, 327},
  {-1636675200, 0, 327},
  {-1613430000, -3600, 327},
  {-968025600, 0, 327},
  {-949615200, -3600, 327},
  {-942008400, 0, 327},
  {-920239200, -3600, 327},
  {-909957600, 0, 327},
  {-888789600, -3600, 327},
  {-877903200, 0, 327},
  {-857944800, -3600, 327},
  {-846453600, 0, 327},
  {-826495200, -3600, 327},
  {-815004000, 0, 327},
  {-795045600, -3600, 327},
  {-783554400, 0, 327},
  {-762991200, -3600, 327},
  {-752104800, 0, 327},
  {-731541600, -3600, 327},
  {-717631200, 0, 327},
  {-700092000, -3600, 327},
  {-686181600, 0, 327},
  {-668642400, -3600, 327},
  {-654732000, 0, 327},
  {-636588000, -3600, 327},
  {-623282400, 0, 327},
  {-605743200, -3600, 327},
  {-591832800, 0, 327},
  {-573688800, -3600, 327},
  {-559778400, 0, 327},
  {-542239200, -3600, 327},
  {-528328800, 0, 327},
  {-510789600, -3600, 327},
  {-496879200, 0, 327},
  {-479340000, -3600, 327},
  {-465429600, 0, 327},
  {-447890400, -3600, 327},
  {-433980000, 0, 327},
  {-415836000, -3600, 327},
  {-401925600, 0, 327},
  {-384386400, -3600, 327},
  {-370476000, 0, 327},
  {-352936800, -3600, 327},
  {-339026400, 0, 327},
  {-321487200, -3600, 327},
  {-307576800, 0, 327},
  {-290037600, -3600, 327},
  {-276127200, 0, 327},
  {-258588000, -3600, 327},
  {-244677600, 0, 327},
  {-226533600, -3600, 327},
  {-212623200, 0, 327},
  {-195084000, -3600, 327},
  {-181173600, 0, 327},
  {-163634400, -3600, 327},
  {-149724000, 0, 327},
  {-132184800, -3600, 327},
  {-118274400, 0, 327},
  {-100735200, -3600, 327},
  {-86824800, 0, 327},
  {-68680800, -3600, 327},
  {-54770400, 0, 327},
  {INT64_MIN, -7200, 328},
  {INT64_MIN, -1368, 329},
  {-599614632, 0, 329},
  {INT64_MIN, -13884, 330},
  {-1824235716, -14400, 330},
  {-1018209600, -10800, 330},
  {-1003093200, -14400, 330},
  {-986760000, -10800, 330},
  {-971643600, -14400, 330},
  {-954705600, -10800, 330},
  {-939589200, -14400, 330},
  {-923256000, -10800, 330},
  {-908139600, -14400, 330},
  {-891806400, -10800, 330},
  {-876690000, -14400, 330},
  {-860356800, -10800, 330},
  {-852066000, -14400, 330},
  {420609600, -10800, 330},
  {433306800, -7200, 330},
  {452052000, -10800, 330},
  {464151600, -7200, 330},
  {483501600, -10800, 330},
  {495601200, -10800, 330},
  {514350000, -14400, 330},
  {527054400, -10800, 330},
  {545799600, -14400, 330},
  {558504000, -10800, 330},
  {577249200, -14400, 330},
  {589953600, -10800, 330},
  {608698800, -14400, 330},
  {621403200, -10800, 330},
  {640753200, -14400, 330},
  {652852800, -10800, 330},
  {672202800, -14400, 330},
  {684907200, -10800, 330},
  {703652400, -14400, 330},
  {716356800, -10800, 330},
  {735102000, -14400, 330},
  {747806400, -10800, 330},
  {766551600, -14400, 330},
  {779256000, -10800, 330},
  {798001200, -14400, 330},
  {810705600, -10800, 330},
  {830055600, -14400, 330},
  {842760000, -10800, 330},
  {861505200, -14400, 330},
  {874209600, -10800, 330},
  {892954800, -14400, 330},
  {905659200, -10800, 330},
  {924404400, -14400, 330},
  {937108800, -10800, 330},
  {955854000, -14400, 330},
  {968558400, -10800, 330},
  {987310800, -14400, 330},
  {999410400, -10800, 330},
  {1019365200, -14400, 330},
  {1030860000, -10800, 330},
  {1050814800, -14400, 330},
  {1062914400, -10800, 330},
  {1082264400, -14400, 330},
  {1094364000, -10800, 330},
  {1113714000, -14400, 330},
  {1125813600, -10800, 330},
  {1145163600, -14400, 330},
  {1157263200, -10800, 330},
  {1176613200, -14400, 330},
  {1188712800, -10800, 330},
  {1208667600, -14400, 330},
  {1220767200, -10800, 330},
  {1240117200, -14400, 330},
  {1252216800, -10800, 330},
  {1271566800, -14400, 330},
  {1283666400, -10800, 330},
  {1334466000, -14400, 330},
  {1346565600, -10800, 330},
  {1366520400, -14400, 330},
  {1378015200, -10800, 330},
  {1397970000, -14400, 330},
  {1410069600, -10800, 330},
  {1429419600, -14400, 330},
  {1441519200, -10800, 330},
  {1460869200, -14400, 330},
  {1472968800, -10800, 330},
  {1492318800, -14400, 330},
  {1504418400, -10800, 330},
  {1523768400, -14400, 330},
  {1535868000, -10800, 330},
  {1555822800, -14400, 330},
  {1567317600, -10800, 330},
  {1587272400, -14400, 330},
  {1599372000, -10800, 330},
  {1618722000, -14400, 330},
  {1630821600, -10800, 330},
  {1650171600, -14400, 330},
  {1662271200, -10800, 330},
  {1681621200, -14400, 330},
  {1693720800, -10800, 330},
  {1713675600, -14400, 330},
  {1725170400, -10800, 330},
  {1745125200, -14400, 330},
  {1757224800, -10800, 330},
  {1776574800, -14400, 330},
  {1788674400, -10800, 330},
  {1808024400, -14400, 330},
  {1820124000, -10800, 330},
  {1839474000, -14400, 330},
  {1851573600, -10800, 330},
  {1870923600, -14400, 330},
  {1883023200, -10800, 330},
  {1902978000, -14400, 330},
  {1914472800, -10800, 330},
  {1934427600, -14400, 330},
  {1946527200, -10800, 330},
  {1965877200, -14400, 330},
  {1977976800, -10800, 330},
  {1997326800, -14400, 330},
  {2009426400, -10800, 330},
  {2028776400, -14400, 330},
  {2040876000, -10800, 330},
  {2060226000, -14400, 330},
  {2072325600, -10800, 330},
  {2092280400, -14400, 330},
  {2104380000, -10800, 330},
  {2123730000, -14400, 330},
  {2135829600, -10800, 330},
  {-1672567140, 39600, 331},
  {-1665392400, 36000, 331},
  {-883641600, 39600, 331},
  {-876128400, 36000, 331},
  {-860400000, 39600, 331},
  {-844678800, 36000, 331},
  {-828345600, 39600, 331},
  {-813229200, 36000, 331},
  {57686400, 39600, 331},
  {67968000, 36000, 331},
  {89136000, 39600, 331},
  {100022400, 36000, 331},
  {120585600, 39600, 331},
  {131472000, 36000, 331},
  {152035200, 39600, 331},
  {162921600, 36000, 331},
  {183484800, 39600, 331},
  {194976000, 36000, 331},
  {215539200, 39600, 331},
  {226425600, 36000, 331},
  {246988800, 39600, 331},
  {257875200, 36000, 331},
  {278438400, 39600, 331},
  {289324800, 36000, 331},
  {309888000, 39600, 331},
  {320774400, 36000, 331},
  {341337600, 39600, 331},
  {352224000, 36000, 331},
  {372787200, 39600, 331},
  {386697600, 36000, 331},
  {404841600, 39600, 331},
  {415728000, 36000, 331},
  {436291200, 39600, 331},
  {447177600, 36000, 331},
  {467740800, 39600, 331},
  {478627200, 36000, 331},
  {499190400, 39600, 331},
  {511286400, 36000, 331},
  {530035200, 39600, 331},
  {542736000, 36000, 331},
  {562089600, 39600, 331},
  {574790400, 36000, 331},
  {594144000, 39600, 331},
  {606240000, 36000, 331},
  {625593600, 39600, 331},
  {636480000, 36000, 331},
  {657043200, 39600, 331},
  {667929600, 36000, 331},
  {688492800, 39600, 331},
  {699379200, 36000, 331},
  {719942400, 39600, 331},
  {731433600, 36000, 331},
  {751996800, 39600, 331},
  {762883200, 36000, 331},
  {783446400, 39600, 331},
  {794332800, 36000, 331},
  {814896000, 39600, 331},
  {828201600, 36000, 331},
  {846345600, 39600, 331},
  {859651200, 36000, 331},
  {877795200, 39600, 331},
  {891100800, 36000, 331},
  {909244800, 39600, 331},
  {922550400, 36000, 331},
  {941299200, 39600, 331},
  {954000000, 36000, 331},
  {967305600, 39600, 331},
  {985449600, 36000, 331},
  {1004198400, 39600, 331},
  {1017504000, 36000, 331},
  {1035648000, 39600, 331},
  {1048953600, 36000, 331},
  {1067097600, 39600, 331},
  {1080403200, 36000, 331},
  {1099152000, 39600, 331},
  {1111852800, 36000, 331},
  {1130601600, 39600, 331},
  {1143907200, 36000, 331},
  {1162051200, 39600, 331},
  {1174752000, 36000, 331},
  {1193500800, 39600, 331},
  {1207411200, 36000, 331},
  {1223136000, 39600, 331},
  {1238860800, 36000, 331},
  {1254585600, 39600, 331},
  {1270310400, 36000, 331},
  {1286035200, 39600, 331},
  {1301760000, 36000, 331},
  {1317484800, 39600, 331},
  {1333209600, 36000, 331},
  {1349539200, 39600, 331},
  {1365264000, 36000, 331},
  {1380988800, 39600, 331},
  {1396713600, 36000, 331},
  {1412438400, 39600, 331},
  {1428163200, 36000, 331},
  {1443888000, 39600, 331},
  {1459612800, 36000, 331},
  {1475337600, 39600, 331},
  {1491062400, 36000, 331},
  {1506787200, 39600, 331},
  {1522512000, 36000, 331},
  {1538841600, 39600, 331},
  {1554566400, 36000, 331},
  {1570291200, 39600, 331},
  {1586016000, 36000, 331},
  {1601740800, 39600, 331},
  {1617465600, 36000, 331},
  {1633190400, 39600, 331},
  {1648915200, 36000, 331},
  {1664640000, 39600, 331},
  {1680364800, 36000, 331},
  {1696089600, 39600, 331},
  {1712419200, 36000, 331},
  {1728144000, 39600, 331},
  {1743868800, 36000, 331},
  {1759593600, 39600, 331},
  {1775318400, 36000, 331},
  {1791043200, 39600, 331},
  {1806768000, 36000, 331},
  {1822492800, 39600, 331},
  {1838217600, 36000, 331},
  {1853942400, 39600, 331},
  {1869667200, 36000, 331},
  {1885996800, 39600, 331},
  {1901721600, 36000, 331},
  {1917446400, 39600, 331},
  {1933171200, 36000, 331},
  {1948896000, 39600, 331},
  {1964620800, 36000, 331},
  {1980345600, 39600, 331},
  {1996070400, 36000, 331},
  {2011795200, 39600, 331},
  {2027520000, 36000, 331},
  {2043244800, 39600, 331},
  {2058969600, 36000, 331},
  {2075299200, 39600, 331},
  {2091024000, 36000, 331},
  {2106748800, 39600, 331},
  {2122473600, 36000, 331},
  {2138198400, 39600, 331},
  {-1672565340, 37800, 332},
  {-1665390600, 34200, 332},
  {-883639800, 37800, 332},
  {-876126600, 34200, 332},
  {-860398200, 37800, 332},
  {-844677000, 34200, 332},
  {-828343800, 37800, 332},
  {-813227400, 34200, 332},
  {57688200, 37800, 332},
  {67969800, 34200, 332},
  {89137800, 37800, 332},
  {100024200, 34200, 332},
  {120587400, 37800, 332},
  {131473800, 34200, 332},
  {152037000, 37800, 332},
  {162923400, 34200, 332},
  {183486600, 37800, 332},
  {194977800, 34200, 332},
  {215541000, 37800, 332},
  {226427400, 34200, 332},
  {246990600, 37800, 332},
  {257877000, 34200, 332},
  {278440200, 37800, 332},
  {289326600, 34200, 332},
  {309889800, 37800, 332},
  {320776200, 34200, 332},
  {341339400, 37800, 332},
  {352225800, 34200, 332},
  {372789000, 37800, 332},
  {384280200, 34200, 332},
  {404843400, 37800, 332},
  {415729800, 34200, 332},
  {436293000, 37800, 332},
  {447179400, 34200, 332},
  {467742600, 37800, 332},
  {478629000, 34200, 332},
  {499192200, 37800, 332},
  {511288200, 34200, 332},
  {530037000, 37800, 332},
  {542737800, 34200, 332},
  {562091400, 37800, 332},
  {574792200, 34200, 332},
  {594145800, 37800, 332},
  {606241800, 34200, 332},
  {625595400, 37800, 332},
  {637691400, 34200, 332},
  {657045000, 37800, 332},
  {667931400, 34200, 332},
  {688494600, 37800, 332},
  {701195400, 34200, 332},
  {719944200, 37800, 332},
  {731435400, 34200, 332},
  {751998600, 37800, 332},
  {764094600, 34200, 332},
  {783448200, 37800, 332},
  {796149000, 34200, 332},
  {814897800, 37800, 332},
  {828203400, 34200, 332},
  {846347400, 37800, 332},
  {859653000, 34200, 332},
  {877797000, 37800, 332},
  {891102600, 34200, 332},
  {909246600, 37800, 332},
  {922552200, 34200, 332},
  {941301000, 37800, 332},
  {954001800, 34200, 332},
  {972750600, 37800, 332},
  {985451400, 34200, 332},
  {1004200200, 37800, 332},
  {1017505800, 34200, 332},
  {1035649800, 37800, 332},
  {1048955400, 34200, 332},
  {1067099400, 37800, 332},
  {1080405000, 34200, 332},
  {1099153800, 37800, 332},
  {1111854600, 34200, 332},
  {1130603400, 37800, 332},
  {1143909000, 34200, 332},
  {1162053000, 37800, 332},
  {1174753800, 34200, 332},
  {1193502600, 37800, 332},
  {1207413000, 34200, 332},
  {1223137800, 37800, 332},
  {1238862600, 34200, 332},
  {1254587400, 37800, 332},
  {1270312200, 34200, 332},
  {1286037000, 37800, 332},
  {1301761800, 34200, 332},
  {1317486600, 37800, 332},
  {1333211400, 34200, 332},
  {1349541000, 37800, 332},
  {1365265800, 34200, 332},
  {1380990600, 37800, 332},
  {1396715400, 34200, 332},
  {1412440200, 37800, 332},
  {1428165000, 34200, 332},
  {1443889800, 37800, 332},
  {1459614600, 34200, 332},
  {1475339400, 37800, 332},
  {1491064200, 34200, 332},
  {1506789000, 37800, 332},
  {1522513800, 34200, 332},
  {1538843400, 37800, 332},
  {1554568200, 34200, 332},
  {1570293000, 37800, 332},
  {1586017800, 34200, 332},
  {1601742600, 37800, 332},
  {1617467400, 34200, 332},
  {1633192200, 37800, 332},
  {1648917000, 34200, 332},
  {1664641800, 37800, 332},
  {1680366600, 34200, 332},
  {1696091400, 37800, 332},
  {1712421000, 34200, 332},
  {1728145800, 37800, 332},
  {1743870600, 34200, 332},
  {1759595400, 37800, 332},
  {1775320200, 34200, 332},
  {1791045000, 37800, 332},
  {1806769800, 34200, 332},
  {1822494600, 37800, 332},
  {1838219400, 34200, 332},
  {1853944200, 37800, 332},
  {1869669000, 34200, 332},
  {1885998600, 37800, 332},
  {1901723400, 34200, 332},
  {1917448200, 37800, 332},
  {1933173000, 34200, 332},
  {1948897800, 37800, 332},
  {1964622600, 34200, 332},
  {1980347400, 37800, 332},
  {1996072200, 34200, 332},
  {2011797000, 37800, 332},
  {2027521800, 34200, 332},
  {2043246600, 37800, 332},
  {2058971400, 34200, 332},
  {2075301000, 37800, 332},
  {2091025800, 34200, 332},
  {2106750600, 37800, 332},
  {2122475400, 34200, 332},
  {2138200200, 37800, 332},
  {-1672567140, 39600, 333},
  {-1665392400, 36000, 333},
  {-883641600, 39600, 333},
  {-876128400, 36000, 333},
  {-860400000, 39600, 333},
  {-844678800, 36000, 333},
  {-828345600, 39600, 333},
  {-813229200, 36000, 333},
  {57686400, 39600, 333},
  {67968000, 36000, 333},
  {625593600, 39600, 333},
  {636480000, 36000, 333},
  {657043200, 39600, 333},
  {667929600, 36000, 333},
  {688492800, 39600, 333},
  {699379200, 36000, 333},
  {-1672565340, 37800, 334},
  {-1665390600, 34200, 334},
  {-883639800, 37800, 334},
  {-876126600, 34200, 334},
  {-860398200, 37800, 334},
  {-844677000, 34200, 334},
  {-828343800, 37800, 334},
  {-813227400, 34200, 334},
  {57688200, 37800, 334},
  {67969800, 34200, 334},
  {89137800, 37800, 334},
  {100024200, 34200, 334},
  {120587400, 37800, 334},
  {131473800, 34200, 334},
  {152037000, 37800, 334},
  {162923400, 34200, 334},
  {183486600, 37800, 334},
  {194977800, 34200, 334},
  {215541000, 37800, 334},
  {226427400, 34200, 334},
  {246990600, 37800, 334},
  {257877000, 34200, 334},
  {278440200, 37800, 334},
  {289326600, 34200, 334},
  {309889800, 37800, 334},
  {320776200, 34200, 334},
  {341339400, 37800, 334},
  {352225800, 34200, 334},
  {372789000, 37800, 334},
  {386699400, 34200, 334},
  {404843400, 37800, 334},
  {415729800, 34200, 334},
  {436293000, 37800, 334},
  {447179400, 34200, 334},
  {467742600, 37800, 334},
  {478629000, 34200, 334},
  {499192200, 37800, 334},
  {511288200, 34200, 334},
  {530037000, 37800, 334},
  {542737800, 34200, 334},
  {562091400, 37800, 334},
  {574792200, 34200, 334},
  {594145800, 37800, 334},
  {606241800, 34200, 334},
  {625595400, 37800, 334},
  {636481800, 34200, 334},
  {657045000, 37800, 334},
  {667931400, 34200, 334},
  {688494600, 37800, 334},
  {699381000, 34200, 334},
  {719944200, 37800, 334},
  {731435400, 34200, 334},
  {751998600, 37800, 334},
  {762885000, 34200, 334},
  {783448200, 37800, 334},
  {794334600, 34200, 334},
  {814897800, 37800, 334},
  {828203400, 34200, 334},
  {846347400, 37800, 334},
  {859653000, 34200, 334},
  {877797000, 37800, 334},
  {891102600, 34200, 334},
  {909246600, 37800, 334},
  {922552200, 34200, 334},
  {941301000, 37800, 334},
  {946647000, 37800, 334},
  {954001800, 34200, 334},
  {972750600, 37800, 334},
  {985451400, 34200, 334},
  {1004200200, 37800, 334},
  {1017505800, 34200, 334},
  {1035649800, 37800, 334},
  {1048955400, 34200, 334},
  {1067099400, 37800, 334},
  {1080405000, 34200, 334},
  {1099153800, 37800, 334},
  {1111854600, 34200, 334},
  {1130603400, 37800, 334},
  {1143909000, 34200, 334},
  {1162053000, 37800, 334},
  {1174753800, 34200, 334},
  {1193502600, 37800, 334},
  {1207413000, 34200, 334},
  {1223137800, 37800, 334},
  {1238862600, 34200, 334},
  {1254587400, 37800, 334},
  {1270312200, 34200, 334},
  {1286037000, 37800, 334},
  {1301761800, 34200, 334},
  {1317486600, 37800, 334},
  {1333211400, 34200, 334},
  {1349541000, 37800, 334},
  {1365265800, 34200, 334},
  {1380990600, 37800, 334},
  {1396715400, 34200, 334},
  {1412440200, 37800, 334},
  {1428165000, 34200, 334},
  {1443889800, 37800, 334},
  {1459614600, 34200, 334},
  {1475339400, 37800, 334},
  {1491064200, 34200, 334},
  {1506789000, 37800, 334},
  {1522513800, 34200, 334},
  {1538843400, 37800, 334},
  {1554568200, 34200, 334},
  {1570293000, 37800, 334},
  {1586017800, 34200, 334},
  {1601742600, 37800, 334},
  {1617467400, 34200, 334},
  {1633192200, 37800, 334},
  {1648917000, 34200, 334},
  {1664641800, 37800, 334},
  {1680366600, 34200, 334},
  {1696091400, 37800, 334},
  {1712421000, 34200, 334},
  {1728145800, 37800, 334},
  {1743870600, 34200, 334},
  {1759595400, 37800, 334},
  {1775320200, 34200, 334},
  {1791045000, 37800, 334},
  {1806769800, 34200, 334},
  {1822494600, 37800, 334},
  {1838219400, 34200, 334},
  {1853944200, 37800, 334},
  {1869669000, 34200, 334},
  {1885998600, 37800, 334},
  {1901723400, 34200, 334},
  {1917448200, 37800, 334},
  {1933173000, 34200, 334},
  {1948897800, 37800, 334},
  {1964622600, 34200, 334},
  {1980347400, 37800, 334},
  {1996072200, 34200, 334},
  {2011797000, 37800, 334},
  {2027521800, 34200, 334},
  {2043246600, 37800, 334},
  {2058971400, 34200, 334},
  {2075301000, 37800, 334},
  {2091025800, 34200, 334},
  {2106750600, 37800, 334},
  {2122475400, 34200, 334},
  {2138200200, 37800, 334},
  {-1672567140, 39600, 335},
  {-1665392400, 36000, 335},
  {-883641600, 39600, 335},
  {-876128400, 36000, 335},
  {-860400000, 39600, 335},
  {-844678800, 36000, 335},
  {-828345600, 39600, 335},
  {-813229200, 36000, 335},
  {57686400, 39600, 335},
  {67968000, 36000, 335},
  {89136000, 39600, 335},
  {100022400, 36000, 335},
  {120585600, 39600, 335},
  {131472000, 36000, 335},
  {152035200, 39600, 335},
  {162921600, 36000, 335},
  {183484800, 39600, 335},
  {194976000, 36000, 335},
  {215539200, 39600, 335},
  {226425600, 36000, 335},
  {246988800, 39600, 335},
  {257875200, 36000, 335},
  {278438400, 39600, 335},
  {289324800, 36000, 335},
  {309888000, 39600, 335},
  {320774400, 36000, 335},
  {341337600, 39600, 335},
  {352224000, 36000, 335},
  {372787200, 39600, 335},
  {386697600, 36000, 335},
  {404841600, 39600, 335},
  {415728000, 36000, 335},
  {436291200, 39600, 335},
  {447177600, 36000, 335},
  {467740800, 39600, 335},
  {478627200, 36000, 335},
  {499190400, 39600, 335},
  {511286400, 36000, 335},
  {530035200, 39600, 335},
  {542736000, 36000, 335},
  {562089600, 39600, 335},
  {574790400, 36000, 335},
  {594144000, 39600, 335},
  {606240000, 36000, 335},
  {625593600, 39600, 335},
  {636480000, 36000, 335},
  {657043200, 39600, 335},
  {667929600, 36000, 335},
  {688492800, 39600, 335},
  {699379200, 36000, 335},
  {719942400, 39600, 335},
  {731433600, 36000, 335},
  {751996800, 39600, 335},
  {762883200, 36000, 335},
  {783446400, 39600, 335},
  {794332800, 36000, 335},
  {814896000, 39600, 335},
  {828201600, 36000, 335},
  {846345600, 39600, 335},
  {859651200, 36000, 335},
  {877795200, 39600, 335},
  {891100800, 36000, 335},
  {909244800, 39600, 335},
  {922550400, 36000, 335},
  {941299200, 39600, 335},
  {954000000, 36000, 335},
  {967305600, 39600, 335},
  {985449600, 36000, 335},
  {1004198400, 39600, 335},
  {1017504000, 36000, 335},
  {1035648000, 39600, 335},
  {1048953600, 36000, 335},
  {1067097600, 39600, 335},
  {1080403200, 36000, 335},
  {1099152000, 39600, 335},
  {1111852800, 36000, 335},
  {1130601600, 39600, 335},
  {1143907200, 36000, 335},
  {1162051200, 39600, 335},
  {1174752000, 36000, 335},
  {1193500800, 39600, 335},
  {1207411200, 36000, 335},
  {1223136000, 39600, 335},
  {1238860800, 36000, 335},
  {1254585600, 39600, 335},
  {1270310400, 36000, 335},
  {1286035200, 39600, 335},
  {1301760000, 36000, 335},
  {1317484800, 39600, 335},
  {1333209600, 36000, 335},
  {1349539200, 39600, 335},
  {1365264000, 36000, 335},
  {1380988800, 39600, 335},
  {1396713600, 36000, 335},
  {1412438400, 39600, 335},
  {1428163200, 36000, 335},
  {1443888000, 39600, 335},
  {1459612800, 36000, 335},
  {1475337600, 39600, 335},
  {1491062400, 36000, 335},
  {1506787200, 39600, 335},
  {1522512000, 36000, 335},
  {1538841600, 39600, 335},
  {1554566400, 36000, 335},
  {1570291200, 39600, 335},
  {1586016000, 36000, 335},
  {1601740800, 39600, 335},
  {1617465600, 36000, 335},
  {1633190400, 39600, 335},
  {1648915200, 36000, 335},
  {1664640000, 39600, 335},
  {1680364800, 36000, 335},
  {1696089600, 39600, 335},
  {1712419200, 36000, 335},
  {1728144000, 39600, 335},
  {1743868800, 36000, 335},
  {1759593600, 39600, 335},
  {1775318400, 36000, 335},
  {1791043200, 39600, 335},
  {1806768000, 36000, 335},
  {1822492800, 39600, 335},
  {1838217600, 36000, 335},
  {1853942400, 39600, 335},
  {1869667200, 36000, 335},
  {1885996800, 39600, 335},
  {1901721600, 36000, 335},
  {1917446400, 39600, 335},
  {1933171200, 36000, 335},
  {1948896000, 39600, 335},
  {1964620800, 36000, 335},
  {1980345600, 39600, 335},
  {1996070400, 36000, 335},
  {2011795200, 39600, 335},
  {2027520000, 36000, 335},
  {2043244800, 39600, 335},
  {2058969600, 36000, 335},
  {2075299200, 39600, 335},
  {2091024000, 36000, 335},
  {2106748800, 39600, 335},
  {2122473600, 36000, 335},
  {2138198400, 39600, 335},
  {-1680508800, 39600, 336},
  {-1665392400, 36000, 336},
  {-883641600, 39600, 336},
  {-876128400, 36000, 336},
  {-860400000, 39600, 336},
  {-844678800, 36000, 336},
  {-828345600, 39600, 336},
  {-813229200, 36000, 336},
  {57686400, 39600, 336},
  {67968000, 36000, 336},
  {89136000, 39600, 336},
  {100022400, 36000, 336},
  {120585600, 39600, 336},
  {131472000, 36000, 336},
  {152035200, 39600, 336},
  {162921600, 36000, 336},
  {183484800, 39600, 336},
  {194976000, 36000, 336},
  {215539200, 39600, 336},
  {226425600, 36000, 336},
  {246988800, 39600, 336},
  {257875200, 36000, 336},
  {278438400, 39600, 336},
  {289324800, 36000, 336},
  {309888000, 39600, 336},
  {320774400, 36000, 336},
  {341337600, 39600, 336},
  {352224000, 36000, 336},
  {372787200, 39600, 336},
  {386092800, 36000, 336},
  {404841600, 39600, 336},
  {417542400, 36000, 336},
  {436291200, 39600, 336},
  {447177600, 36000, 336},
  {467740800, 39600, 336},
  {478627200, 36000, 336},
  {499190400, 39600, 336},
  {510076800, 36000, 336},
  {530035200, 39600, 336},
  {542736000, 36000, 336},
  {562089600, 39600, 336},
  {574790400, 36000, 336},
  {594144000, 39600, 336},
  {606240000, 36000, 336},
  {625593600, 39600, 336},
  {637689600, 36000, 336},
  {657043200, 39600, 336},
  {670348800, 36000, 336},
  {686678400, 39600, 336},
  {701798400, 36000, 336},
  {718128000, 39600, 336},
  {733248000, 36000, 336},
  {749577600, 39600, 336},
  {764697600, 36000, 336},
  {781027200, 39600, 336},
  {796147200, 36000, 336},
  {812476800, 39600, 336},
  {828201600, 36000, 336},
  {844531200, 39600, 336},
  {859651200, 36000, 336},
  {875980800, 39600, 336},
  {891100800, 36000, 336},
  {907430400, 39600, 336},
  {922550400, 36000, 336},
  {938880000, 39600, 336},
  {954000000, 36000, 336},
  {967305600, 39600, 336},
  {985449600, 36000, 336},
  {1002384000, 39600, 336},
  {1017504000, 36000, 336},
  {1033833600, 39600, 336},
  {1048953600, 36000, 336},
  {1065283200, 39600, 336},
  {1080403200, 36000, 336},
  {1096732800, 39600, 336},
  {1111852800, 36000, 336},
  {1128182400, 39600, 336},
  {1143907200, 36000, 336},
  {1159632000, 39600, 336},
  {1174752000, 36000, 336},
  {1191686400, 39600, 336},
  {1207411200, 36000, 336},
  {1223136000, 39600, 336},
  {1238860800, 36000, 336},
  {1254585600, 39600, 336},
  {1270310400, 36000, 336},
  {1286035200, 39600, 336},
  {1301760000, 36000, 336},
  {1317484800, 39600, 336},
  {1333209600, 36000, 336},
  {1349539200, 39600, 336},
  {1365264000, 36000, 336},
  {1380988800, 39600, 336},
  {1396713600, 36000, 336},
  {1412438400, 39600, 336},
  {1428163200, 36000, 336},
  {1443888000, 39600, 336},
  {1459612800, 36000, 336},
  {1475337600, 39600, 336},
  {1491062400, 36000, 336},
  {1506787200, 39600, 336},
  {1522512000, 36000, 336},
  {1538841600, 39600, 336},
  {1554566400, 36000, 336},
  {1570291200, 39600, 336},
  {1586016000, 36000, 336},
  {1601740800, 39600, 336},
  {1617465600, 36000, 336},
  {1633190400, 39600, 336},
  {1648915200, 36000, 336},
  {1664640000, 39600, 336},
  {1680364800, 36000, 336},
  {1696089600, 39600, 336},
  {1712419200, 36000, 336},
  {1728144000, 39600, 336},
  {1743868800, 36000, 336},
  {1759593600, 39600, 336},
  {1775318400, 36000, 336},
  {1791043200, 39600, 336},
  {1806768000, 36000, 336},
  {1822492800, 39600, 336},
  {1838217600, 36000, 336},
  {1853942400, 39600, 336},
  {1869667200, 36000, 336},
  {1885996800, 39600, 336},
  {1901721600, 36000, 336},
  {1917446400, 39600, 336},
  {1933171200, 36000, 336},
  {1948896000, 39600, 336},
  {1964620800, 36000, 336},
  {1980345600, 39600, 336},
  {1996070400, 36000, 336},
  {2011795200, 39600, 336},
  {2027520000, 36000, 336},
  {2043244800, 39600, 336},
  {2058969600, 36000, 336},
  {2075299200, 39600, 336},
  {2091024000, 36000, 336},
  {2106748800, 39600, 336},
  {2122473600, 36000, 336},
  {2138198400, 39600, 336},
  {-1672565340, 37800, 337},
  {-1665390600, 34200, 337},
  {-883639800, 37800, 337},
  {-876126600, 34200, 337},
  {-860398200, 37800, 337},
  {-844677000, 34200, 337},
  {-828343800, 37800, 337},
  {-813227400, 34200, 337},
  {-1672562640, 35100, 338},
  {-1665387900, 31500, 338},
  {-883637100, 35100, 338},
  {-876123900, 31500, 338},
  {-860395500, 35100, 338},
  {-844674300, 31500, 338},
  {152039700, 35100, 338},
  {162926100, 31500, 338},
  {436295700, 35100, 338},
  {447182100, 31500, 338},
  {690311700, 35100, 338},
  {699383700, 31500, 338},
  {1165079700, 35100, 338},
  {1174756500, 31500, 338},
  {1193505300, 35100, 338},
  {1206810900, 31500, 338},
  {1224954900, 35100, 338},
  {1238260500, 31500, 338},
  {-1680508800, 39600, 339},
  {-1665392400, 36000, 339},
  {-883641600, 39600, 339},
  {-876128400, 36000, 339},
  {-860400000, 39600, 339},
  {-844678800, 36000, 339},
  {-828345600, 39600, 339},
  {-813229200, 36000, 339},
  {-71136000, 39600, 339},
  {-55411200, 36000, 339},
  {-37267200, 39600, 339},
  {-25776000, 36000, 339},
  {-5817600, 39600, 339},
  {5673600, 36000, 339},
  {25632000, 39600, 339},
  {37728000, 36000, 339},
  {57686400, 39600, 339},
  {67968000, 36000, 339},
  {89136000, 39600, 339},
  {100022400, 36000, 339},
  {120585600, 39600, 339},
  {131472000, 36000, 339},
  {152035200, 39600, 339},
  {162921600, 36000, 339},
  {183484800, 39600, 339},
  {194976000, 36000, 339},
  {215539200, 39600, 339},
  {226425600, 36000, 339},
  {246988800, 39600, 339},
  {257875200, 36000, 339},
  {278438400, 39600, 339},
  {289324800, 36000, 339},
  {309888000, 39600, 339},
  {320774400, 36000, 339},
  {341337600, 39600, 339},
  {352224000, 36000, 339},
  {372787200, 39600, 339},
  {386092800, 36000, 339},
  {404841600, 39600, 339},
  {417542400, 36000, 339},
  {436291200, 39600, 339},
  {447177600, 36000, 339},
  {467740800, 39600, 339},
  {478627200, 36000, 339},
  {499190400, 39600, 339},
  {510076800, 36000, 339},
  {530035200, 39600, 339},
  {542736000, 36000, 339},
  {562089600, 39600, 339},
  {574790400, 36000, 339},
  {594144000, 39600, 339},
  {606240000, 36000, 339},
  {625593600, 39600, 339},
  {637689600, 36000, 339},
  {657043200, 39600, 339},
  {670348800, 36000, 339},
  {686678400, 39600, 339},
  {701798400, 36000, 339},
  {718128000, 39600, 339},
  {733248000, 36000, 339},
  {749577600, 39600, 339},
  {764697600, 36000, 339},
  {781027200, 39600, 339},
  {796147200, 36000, 339},
  {812476800, 39600, 339},
  {828201600, 36000, 339},
  {844531200, 39600, 339},
  {859651200, 36000, 339},
  {875980800, 39600, 339},
  {891100800, 36000, 339},
  {907430400, 39600, 339},
  {922550400, 36000, 339},
  {938880000, 39600, 339},
  {954000000, 36000, 339},
  {967305600, 39600, 339},
  {985449600, 36000, 339},
  {1002384000, 39600, 339},
  {1017504000, 36000, 339},
  {1033833600, 39600, 339},
  {1048953600, 36000, 339},
  {1065283200, 39600, 339},
  {1080403200, 36000, 339},
  {1096732800, 39600, 339},
  {1111852800, 36000, 339},
  {1128182400, 39600, 339},
  {1143907200, 36000, 339},
  {1159632000, 39600, 339},
  {1174752000, 36000, 339},
  {1191686400, 39600, 339},
  {1207411200, 36000, 339},
  {1223136000, 39600, 339},
  {1238860800, 36000, 339},
  {1254585600, 39600, 339},
  {1270310400, 36000, 339},
  {1286035200, 39600, 339},
  {1301760000, 36000, 339},
  {1317484800, 39600, 339},
  {1333209600, 36000, 339},
  {1349539200, 39600, 339},
  {1365264000, 36000, 339},
  {1380988800, 39600, 339},
  {1396713600, 36000, 339},
  {1412438400, 39600, 339},
  {1428163200, 36000, 339},
  {1443888000, 39600, 339},
  {1459612800, 36000, 339},
  {1475337600, 39600, 339},
  {1491062400, 36000, 339},
  {1506787200, 39600, 339},
  {1522512000, 36000, 339},
  {1538841600, 39600, 339},
  {1554566400, 36000, 339},
  {1570291200, 39600, 339},
  {1586016000, 36000, 339},
  {1601740800, 39600, 339},
  {1617465600, 36000, 339},
  {1633190400, 39600, 339},
  {1648915200, 36000, 339},
  {1664640000, 39600, 339},
  {1680364800, 36000, 339},
  {1696089600, 39600, 339},
  {1712419200, 36000, 339},
  {1728144000, 39600, 339},
  {1743868800, 36000, 339},
  {1759593600, 39600, 339},
  {1775318400, 36000, 339},
  {1791043200, 39600, 339},
  {1806768000, 36000, 339},
  {1822492800, 39600, 339},
  {1838217600, 36000, 339},
  {1853942400, 39600, 339},
  {1869667200, 36000, 339},
  {1885996800, 39600, 339},
  {1901721600, 36000, 339},
  {1917446400, 39600, 339},
  {1933171200, 36000, 339},
  {1948896000, 39600, 339},
  {1964620800, 36000, 339},
  {1980345600, 39600, 339},
  {1996070400, 36000, 339},
  {2011795200, 39600, 339},
  {2027520000, 36000, 339},
  {2043244800, 39600, 339},
  {2058969600, 36000, 339},
  {2075299200, 39600, 339},
  {2091024000, 36000, 339},
  {2106748800, 39600, 339},
  {2122473600, 36000, 339},
  {2138198400, 39600, 339},
  {INT64_MIN, 36000, 340},
  {352216800, 37800, 340},
  {372785400, 41400, 340},
  {384273000, 37800, 340},
  {404839800, 41400, 340},
  {415722600, 37800, 340},
  {436289400, 41400, 340},
  {447172200, 37800, 340},
  {467739000, 41400, 340},
  {478621800, 37800, 340},
  {499188600, 39600, 340},
  {511282800, 37800, 340},
  {530033400, 39600, 340},
  {542732400, 37800, 340},
  {562087800, 39600, 340},
  {574786800, 37800, 340},
  {594142200, 39600, 340},
  {606236400, 37800, 340},
  {625591800, 39600, 340},
  {636476400, 37800, 340},
  {657041400, 39600, 340},
  {667926000, 37800, 340},
  {688491000, 39600, 340},
  {699375600, 37800, 340},
  {719940600, 39600, 340},
  {731430000, 37800, 340},
  {751995000, 39600, 340},
  {762879600, 37800, 340},
  {783444600, 39600, 340},
  {794329200, 37800, 340},
  {814894200, 39600, 340},
  {828198000, 37800, 340},
  {846343800, 39600, 340},
  {859647600, 37800, 340},
  {877793400, 39600, 340},
  {891097200, 37800, 340},
  {909243000, 39600, 340},
  {922546800, 37800, 340},
  {941297400, 39600, 340},
  {953996400, 37800, 340},
  {967303800, 39600, 340},
  {985446000, 37800, 340},
  {1004196600, 39600, 340},
  {1017500400, 37800, 340},
  {1035646200, 39600, 340},
  {1048950000, 37800, 340},
  {1067095800, 39600, 340},
  {1080399600, 37800, 340},
  {1099150200, 39600, 340},
  {1111849200, 37800, 340},
  {1130599800, 39600, 340},
  {1143903600, 37800, 340},
  {1162049400, 39600, 340},
  {1174748400, 37800, 340},
  {1193499000, 39600, 340},
  {1207407600, 37800, 340},
  {1223134200, 39600, 340},
  {1238857200, 37800, 340},
  {1254583800, 39600, 340},
  {1270306800, 37800, 340},
  {1286033400, 39600, 340},
  {1301756400, 37800, 340},
  {1317483000, 39600, 340},
  {1333206000, 37800, 340},
  {1349537400, 39600, 340},
  {1365260400, 37800, 340},
  {1380987000, 39600, 340},
  {1396710000, 37800, 340},
  {1412436600, 39600, 340},
  {1428159600, 37800, 340},
  {1443886200, 39600, 340},
  {1459609200, 37800, 340},
  {1475335800, 39600, 340},
  {1491058800, 37800, 340},
  {1506785400, 39600, 340},
  {1522508400, 37800, 340},
  {1538839800, 39600, 340},
  {1554562800, 37800, 340},
  {1570289400, 39600, 340},
  {1586012400, 37800, 340},
  {1601739000, 39600, 340},
  {1617462000, 37800, 340},
  {1633188600, 39600, 340},
  {1648911600, 37800, 340},
  {1664638200, 39600, 340},
  {1680361200, 37800, 340},
  {1696087800, 39600, 340},
  {1712415600, 37800, 340},
  {1728142200, 39600, 340},
  {1743865200, 37800, 340},
  {1759591800, 39600, 340},
  {1775314800, 37800, 340},
  {1791041400, 39600, 340},
  {1806764400, 37800, 340},
  {1822491000, 39600, 340},
  {1838214000, 37800, 340},
  {1853940600, 39600, 340},
  {1869663600, 37800, 340},
  {1885995000, 39600, 340},
  {1901718000, 37800, 340},
  {1917444600, 39600, 340},
  {1933167600, 37800, 340},
  {1948894200, 39600, 340},
  {1964617200, 37800, 340},
  {1980343800, 39600, 340},
  {1996066800, 37800, 340},
  {2011793400, 39600, 340},
  {2027516400, 37800, 340},
  {2043243000, 39600, 340},
  {2058966000, 37800, 340},
  {2075297400, 39600, 340},
  {2091020400, 37800, 340},
  {2106747000, 39600, 340},
  {2122470000, 37800, 340},
  {2138196600, 39600, 340},
  {-1672567140, 39600, 341},
  {-1665392400, 36000, 341},
  {-883641600, 39600, 341},
  {-876128400, 36000, 341},
  {-860400000, 39600, 341},
  {-844678800, 36000, 341},
  {-828345600, 39600, 341},
  {-813229200, 36000, 341},
  {57686400, 39600, 341},
  {67968000, 36000, 341},
  {625593600, 39600, 341},
  {636480000, 36000, 341},
  {657043200, 39600, 341},
  {667929600, 36000, 341},
  {688492800, 39600, 341},
  {699379200, 36000, 341},
  {709912800, 36000, 341},
  {719942400, 39600, 341},
  {731433600, 36000, 341},
  {751996800, 39600, 341},
  {762883200, 36000, 341},
  {INT64_MIN, 36000, 342},
  {352216800, 37800, 342},
  {372785400, 41400, 342},
  {384273000, 37800, 342},
  {404839800, 41400, 342},
  {415722600, 37800, 342},
  {436289400, 41400, 342},
  {447172200, 37800, 342},
  {467739000, 41400, 342},
  {478621800, 37800, 342},
  {499188600, 39600, 342},
  {511282800, 37800, 342},
  {530033400, 39600, 342},
  {542732400, 37800, 342},
  {562087800, 39600, 342},
  {574786800, 37800, 342},
  {594142200, 39600, 342},
  {606236400, 37800, 342},
  {625591800, 39600, 342},
  {636476400, 37800, 342},
  {657041400, 39600, 342},
  {667926000, 37800, 342},
  {688491000, 39600, 342},
  {699375600, 37800, 342},
  {719940600, 39600, 342},
  {731430000, 37800, 342},
  {751995000, 39600, 342},
  {762879600, 37800, 342},
  {783444600, 39600, 342},
  {794329200, 37800, 342},
  {814894200, 39600, 342},
  {828198000, 37800, 342},
  {846343800, 39600, 342},
  {859647600, 37800, 342},
  {877793400, 39600, 342},
  {891097200, 37800, 342},
  {909243000, 39600, 342},
  {922546800, 37800, 342},
  {941297400, 39600, 342},
  {953996400, 37800, 342},
  {967303800, 39600, 342},
  {985446000, 37800, 342},
  {1004196600, 39600, 342},
  {1017500400, 37800, 342},
  {1035646200, 39600, 342},
  {1048950000, 37800, 342},
  {1067095800, 39600, 342},
  {1080399600, 37800, 342},
  {1099150200, 39600, 342},
  {1111849200, 37800, 342},
  {1130599800, 39600, 342},
  {1143903600, 37800, 342},
  {1162049400, 39600, 342},
  {1174748400, 37800, 342},
  {1193499000, 39600, 342},
  {1207407600, 37800, 342},
  {1223134200, 39600, 342},
  {1238857200, 37800, 342},
  {1254583800, 39600, 342},
  {1270306800, 37800, 342},
  {1286033400, 39600, 342},
  {1301756400, 37800, 342},
  {1317483000, 39600, 342},
  {1333206000, 37800, 342},
  {1349537400, 39600, 342},
  {1365260400, 37800, 342},
  {1380987000, 39600, 342},
  {1396710000, 37800, 342},
  {1412436600, 39600, 342},
  {1428159600, 37800, 342},
  {1443886200, 39600, 342},
  {1459609200, 37800, 342},
  {1475335800, 39600, 342},
  {1491058800, 37800, 342},
  {1506785400, 39600, 342},
  {1522508400, 37800, 342},
  {1538839800, 39600, 342},
  {1554562800, 37800, 342},
  {1570289400, 39600, 342},
  {1586012400, 37800, 342},
  {1601739000, 39600, 342},
  {1617462000, 37800, 342},
  {1633188600, 39600, 342},
  {1648911600, 37800, 342},
  {1664638200, 39600, 342},
  {1680361200, 37800, 342},
  {1696087800, 39600, 342},
  {1712415600, 37800, 342},
  {1728142200, 39600, 342},
  {1743865200, 37800, 342},
  {1759591800, 39600, 342},
  {1775314800, 37800, 342},
  {1791041400, 39600, 342},
  {1806764400, 37800, 342},
  {1822491000, 39600, 342},
  {1838214000, 37800, 342},
  {1853940600, 39600, 342},
  {1869663600, 37800, 342},
  {1885995000, 39600, 342},
  {1901718000, 37800, 342},
  {1917444600, 39600, 342},
  {1933167600, 37800, 342},
  {1948894200, 39600, 342},
  {1964617200, 37800, 342},
  {1980343800, 39600, 342},
  {1996066800, 37800, 342},
  {2011793400, 39600, 342},
  {2027516400, 37800, 342},
  {2043243000, 39600, 342},
  {2058966000, 37800, 342},
  {2075297400, 39600, 342},
  {2091020400, 37800, 342},
  {2106747000, 39600, 342},
  {2122470000, 37800, 342},
  {2138196600, 39600, 342},
  {-1672567140, 39600, 343},
  {-1665392400, 36000, 343},
  {-883641600, 39600, 343},
  {-876128400, 36000, 343},
  {-860400000, 39600, 343},
  {-844678800, 36000, 343},
  {-828345600, 39600, 343},
  {-813229200, 36000, 343},
  {57686400, 39600, 343},
  {67968000, 36000, 343},
  {89136000, 39600, 343},
  {100022400, 36000, 343},
  {120585600, 39600, 343},
  {131472000, 36000, 343},
  {152035200, 39600, 343},
  {162921600, 36000, 343},
  {183484800, 39600, 343},
  {194976000, 36000, 343},
  {215539200, 39600, 343},
  {226425600, 36000, 343},
  {246988800, 39600, 343},
  {257875200, 36000, 343},
  {278438400, 39600, 343},
  {289324800, 36000, 343},
  {309888000, 39600, 343},
  {320774400, 36000, 343},
  {341337600, 39600, 343},
  {352224000, 36000, 343},
  {372787200, 39600, 343},
  {384278400, 36000, 343},
  {404841600, 39600, 343},
  {415728000, 36000, 343},
  {436291200, 39600, 343},
  {447177600, 36000, 343},
  {467740800, 39600, 343},
  {478627200, 36000, 343},
  {499190400, 39600, 343},
  {511286400, 36000, 343},
  {530035200, 39600, 343},
  {542736000, 36000, 343},
  {561484800, 39600, 343},
  {574790400, 36000, 343},
  {594144000, 39600, 343},
  {606240000, 36000, 343},
  {625593600, 39600, 343},
  {637689600, 36000, 343},
  {657043200, 39600, 343},
  {667929600, 36000, 343},
  {688492800, 39600, 343},
  {699379200, 36000, 343},
  {719942400, 39600, 343},
  {731433600, 36000, 343},
  {751996800, 39600, 343},
  {762883200, 36000, 343},
  {783446400, 39600, 343},
  {796147200, 36000, 343},
  {814896000, 39600, 343},
  {828201600, 36000, 343},
  {846345600, 39600, 343},
  {859651200, 36000, 343},
  {877795200, 39600, 343},
  {891100800, 36000, 343},
  {909244800, 39600, 343},
  {922550400, 36000, 343},
  {941299200, 39600, 343},
  {954000000, 36000, 343},
  {967305600, 39600, 343},
  {985449600, 36000, 343},
  {1004198400, 39600, 343},
  {1017504000, 36000, 343},
  {1035648000, 39600, 343},
  {1048953600, 36000, 343},
  {1067097600, 39600, 343},
  {1080403200, 36000, 343},
  {1099152000, 39600, 343},
  {1111852800, 36000, 343},
  {1130601600, 39600, 343},
  {1143907200, 36000, 343},
  {1162051200, 39600, 343},
  {1174752000, 36000, 343},
  {1193500800, 39600, 343},
  {1207411200, 36000, 343},
  {1223136000, 39600, 343},
  {1238860800, 36000, 343},
  {1254585600, 39600, 343},
  {1270310400, 36000, 343},
  {1286035200, 39600, 343},
  {1301760000, 36000, 343},
  {1317484800, 39600, 343},
  {1333209600, 36000, 343},
  {1349539200, 39600, 343},
  {1365264000, 36000, 343},
  {1380988800, 39600, 343},
  {1396713600, 36000, 343},
  {1412438400, 39600, 343},
  {1428163200, 36000, 343},
  {1443888000, 39600, 343},
  {1459612800, 36000, 343},
  {1475337600, 39600, 343},
  {1491062400, 36000, 343},
  {1506787200, 39600, 343},
  {1522512000, 36000, 343},
  {1538841600, 39600, 343},
  {1554566400, 36000, 343},
  {1570291200, 39600, 343},
  {1586016000, 36000, 343},
  {1601740800, 39600, 343},
  {1617465600, 36000, 343},
  {1633190400, 39600, 343},
  {1648915200, 36000, 343},
  {1664640000, 39600, 343},
  {1680364800, 36000, 343},
  {1696089600, 39600, 343},
  {1712419200, 36000, 343},
  {1728144000, 39600, 343},
  {1743868800, 36000, 343},
  {1759593600, 39600, 343},
  {1775318400, 36000, 343},
  {1791043200, 39600, 343},
  {1806768000, 36000, 343},
  {1822492800, 39600, 343},
  {1838217600, 36000, 343},
  {1853942400, 39600, 343},
  {1869667200, 36000, 343},
  {1885996800, 39600, 343},
  {1901721600, 36000, 343},
  {1917446400, 39600, 343},
  {1933171200, 36000, 343},
  {1948896000, 39600, 343},
  {1964620800, 36000, 343},
  {1980345600, 39600, 343},
  {1996070400, 36000, 343},
  {2011795200, 39600, 343},
  {2027520000, 36000, 343},
  {2043244800, 39600, 343},
  {2058969600, 36000, 343},
  {2075299200, 39600, 343},
  {2091024000, 36000, 343},
  {2106748800, 39600, 343},
  {2122473600, 36000, 343},
  {2138198400, 39600, 343},
  {-1672567140, 39600, 344},
  {-1665392400, 36000, 344},
  {-883641600, 39600, 344},
  {-876128400, 36000, 344},
  {-860400000, 39600, 344},
  {-844678800, 36000, 344},
  {-828345600, 39600, 344},
  {-813229200, 36000, 344},
  {57686400, 39600, 344},
  {67968000, 36000, 344},
  {89136000, 39600, 344},
  {100022400, 36000, 344},
  {120585600, 39600, 344},
  {131472000, 36000, 344},
  {152035200, 39600, 344},
  {162921600, 36000, 344},
  {183484800, 39600, 344},
  {194976000, 36000, 344},
  {215539200, 39600, 344},
  {226425600, 36000, 344},
  {246988800, 39600, 344},
  {257875200, 36000, 344},
  {278438400, 39600, 344},
  {289324800, 36000, 344},
  {309888000, 39600, 344},
  {320774400, 36000, 344},
  {341337600, 39600, 344},
  {352224000, 36000, 344},
  {372787200, 39600, 344},
  {386697600, 36000, 344},
  {404841600, 39600, 344},
  {415728000, 36000, 344},
  {436291200, 39600, 344},
  {447177600, 36000, 344},
  {467740800, 39600, 344},
  {478627200, 36000, 344},
  {499190400, 39600, 344},
  {511286400, 36000, 344},
  {530035200, 39600, 344},
  {542736000, 36000, 344},
  {562089600, 39600, 344},
  {574790400, 36000, 344},
  {594144000, 39600, 344},
  {606240000, 36000, 344},
  {625593600, 39600, 344},
  {636480000, 36000, 344},
  {657043200, 39600, 344},
  {667929600, 36000, 344},
  {688492800, 39600, 344},
  {699379200, 36000, 344},
  {719942400, 39600, 344},
  {731433600, 36000, 344},
  {751996800, 39600, 344},
  {762883200, 36000, 344},
  {783446400, 39600, 344},
  {794332800, 36000, 344},
  {814896000, 39600, 344},
  {828201600, 36000, 344},
  {846345600, 39600, 344},
  {859651200, 36000, 344},
  {877795200, 39600, 344},
  {891100800, 36000, 344},
  {909244800, 39600, 344},
  {922550400, 36000, 344},
  {941299200, 39600, 344},
  {954000000, 36000, 344},
  {967305600, 39600, 344},
  {985449600, 36000, 344},
  {1004198400, 39600, 344},
  {1017504000, 36000, 344},
  {1035648000, 39600, 344},
  {1048953600, 36000, 344},
  {1067097600, 39600, 344},
  {1080403200, 36000, 344},
  {1099152000, 39600, 344},
  {1111852800, 36000, 344},
  {1130601600, 39600, 344},
  {1143907200, 36000, 344},
  {1162051200, 39600, 344},
  {1174752000, 36000, 344},
  {1193500800, 39600, 344},
  {1207411200, 36000, 344},
  {1223136000, 39600, 344},
  {1238860800, 36000, 344},
  {1254585600, 39600, 344},
  {1270310400, 36000, 344},
  {1286035200, 39600, 344},
  {1301760000, 36000, 344},
  {1317484800, 39600, 344},
  {1333209600, 36000, 344},
  {1349539200, 39600, 344},
  {1365264000, 36000, 344},
  {1380988800, 39600, 344},
  {1396713600, 36000, 344},
  {1412438400, 39600, 344},
  {1428163200, 36000, 344},
  {1443888000, 39600, 344},
  {1459612800, 36000, 344},
  {1475337600, 39600, 344},
  {1491062400, 36000, 344},
  {1506787200, 39600, 344},
  {1522512000, 36000, 344},
  {1538841600, 39600, 344},
  {1554566400, 36000, 344},
  {1570291200, 39600, 344},
  {1586016000, 36000, 344},
  {1601740800, 39600, 344},
  {1617465600, 36000, 344},
  {1633190400, 39600, 344},
  {1648915200, 36000, 344},
  {1664640000, 39600, 344},
  {1680364800, 36000, 344},
  {1696089600, 39600, 344},
  {1712419200, 36000, 344},
  {1728144000, 39600, 344},
  {1743868800, 36000, 344},
  {1759593600, 39600, 344},
  {1775318400, 36000, 344},
  {1791043200, 39600, 344},
  {1806768000, 36000, 344},
  {1822492800, 39600, 344},
  {1838217600, 36000, 344},
  {1853942400, 39600, 344},
  {1869667200, 36000, 344},
  {1885996800, 39600, 344},
  {1901721600, 36000, 344},
  {1917446400, 39600, 344},
  {1933171200, 36000, 344},
  {1948896000, 39600, 344},
  {1964620800, 36000, 344},
  {1980345600, 39600, 344},
  {1996070400, 36000, 344},
  {2011795200, 39600, 344},
  {2027520000, 36000, 344},
  {2043244800, 39600, 344},
  {2058969600, 36000, 344},
  {2075299200, 39600, 344},
  {2091024000, 36000, 344},
  {2106748800, 39600, 344},
  {2122473600, 36000, 344},
  {2138198400, 39600, 344},
  {-1672565340, 37800, 345},
  {-1665390600, 34200, 345},
  {-883639800, 37800, 345},
  {-876126600, 34200, 345},
  {-860398200, 37800, 345},
  {-844677000, 34200, 345},
  {-828343800, 37800, 345},
  {-813227400, 34200, 345},
  {-1672559940, 32400, 346},
  {-1665385200, 28800, 346},
  {-883634400, 32400, 346},
  {-876121200, 28800, 346},
  {-860392800, 32400, 346},
  {-844671600, 28800, 346},
  {152042400, 32400, 346},
  {162928800, 28800, 346},
  {436298400, 32400, 346},
  {447184800, 28800, 346},
  {690314400, 32400, 346},
  {699386400, 28800, 346},
  {1165082400, 32400, 346},
  {1174759200, 28800, 346},
  {1193508000, 32400, 346},
  {1206813600, 28800, 346},
  {1224957600, 32400, 346},
  {1238263200, 28800, 346},
  {-1672567140, 39600, 347},
  {-1665392400, 36000, 347},
  {-883641600, 39600, 347},
  {-876128400, 36000, 347},
  {-860400000, 39600, 347},
  {-844678800, 36000, 347},
  {-828345600, 39600, 347},
  {-813229200, 36000, 347},
  {57686400, 39600, 347},
  {67968000, 36000, 347},
  {625593600, 39600, 347},
  {636480000, 36000, 347},
  {657043200, 39600, 347},
  {667929600, 36000, 347},
  {688492800, 39600, 347},
  {699379200, 36000, 347},
  {-1672565340, 37800, 348},
  {-1665390600, 34200, 348},
  {-883639800, 37800, 348},
  {-876126600, 34200, 348},
  {-860398200, 37800, 348},
  {-844677000, 34200, 348},
  {-828343800, 37800, 348},
  {-813227400, 34200, 348},
  {57688200, 37800, 348},
  {67969800, 34200, 348},
  {89137800, 37800, 348},
  {100024200, 34200, 348},
  {120587400, 37800, 348},
  {131473800, 34200, 348},
  {152037000, 37800, 348},
  {162923400, 34200, 348},
  {183486600, 37800, 348},
  {194977800, 34200, 348},
  {215541000, 37800, 348},
  {226427400, 34200, 348},
  {246990600, 37800, 348},
  {257877000, 34200, 348},
  {278440200, 37800, 348},
  {289326600, 34200, 348},
  {309889800, 37800, 348},
  {320776200, 34200, 348},
  {341339400, 37800, 348},
  {352225800, 34200, 348},
  {372789000, 37800, 348},
  {384280200, 34200, 348},
  {404843400, 37800, 348},
  {415729800, 34200, 348},
  {436293000, 37800, 348},
  {447179400, 34200, 348},
  {467742600, 37800, 348},
  {478629000, 34200, 348},
  {499192200, 37800, 348},
  {511288200, 34200, 348},
  {530037000, 37800, 348},
  {542737800, 34200, 348},
  {562091400, 37800, 348},
  {574792200, 34200, 348},
  {594145800, 37800, 348},
  {606241800, 34200, 348},
  {625595400, 37800, 348},
  {637691400, 34200, 348},
  {657045000, 37800, 348},
  {667931400, 34200, 348},
  {688494600, 37800, 348},
  {701195400, 34200, 348},
  {719944200, 37800, 348},
  {731435400, 34200, 348},
  {751998600, 37800, 348},
  {764094600, 34200, 348},
  {783448200, 37800, 348},
  {796149000, 34200, 348},
  {814897800, 37800, 348},
  {828203400, 34200, 348},
  {846347400, 37800, 348},
  {859653000, 34200, 348},
  {877797000, 37800, 348},
  {891102600, 34200, 348},
  {909246600, 37800, 348},
  {922552200, 34200, 348},
  {941301000, 37800, 348},
  {954001800, 34200, 348},
  {972750600, 37800, 348},
  {985451400, 34200, 348},
  {1004200200, 37800, 348},
  {1017505800, 34200, 348},
  {1035649800, 37800, 348},
  {1048955400, 34200, 348},
  {1067099400, 37800, 348},
  {1080405000, 34200, 348},
  {1099153800, 37800, 348},
  {1111854600, 34200, 348},
  {1130603400, 37800, 348},
  {1143909000, 34200, 348},
  {1162053000, 37800, 348},
  {1174753800, 34200, 348},
  {1193502600, 37800, 348},
  {1207413000, 34200, 348},
  {1223137800, 37800, 348},
  {1238862600, 34200, 348},
  {1254587400, 37800, 348},
  {1270312200, 34200, 348},
  {1286037000, 37800, 348},
  {1301761800, 34200, 348},
  {1317486600, 37800, 348},
  {1333211400, 34200, 348},
  {1349541000, 37800, 348},
  {1365265800, 34200, 348},
  {1380990600, 37800, 348},
  {1396715400, 34200, 348},
  {1412440200, 37800, 348},
  {1428165000, 34200, 348},
  {1443889800, 37800, 348},
  {1459614600, 34200, 348},
  {1475339400, 37800, 348},
  {1491064200, 34200, 348},
  {1506789000, 37800, 348},
  {1522513800, 34200, 348},
  {1538843400, 37800, 348},
  {1554568200, 34200, 348},
  {1570293000, 37800, 348},
  {1586017800, 34200, 348},
  {1601742600, 37800, 348},
  {1617467400, 34200, 348},
  {1633192200, 37800, 348},
  {1648917000, 34200, 348},
  {1664641800, 37800, 348},
  {1680366600, 34200, 348},
  {1696091400, 37800, 348},
  {1712421000, 34200, 348},
  {1728145800, 37800, 348},
  {1743870600, 34200, 348},
  {1759595400, 37800, 348},
  {1775320200, 34200, 348},
  {1791045000, 37800, 348},
  {1806769800, 34200, 348},
  {1822494600, 37800, 348},
  {1838219400, 34200, 348},
  {1853944200, 37800, 348},
  {1869669000, 34200, 348},
  {1885998600, 37800, 348},
  {1901723400, 34200, 348},
  {1917448200, 37800, 348},
  {1933173000, 34200, 348},
  {1948897800, 37800, 348},
  {1964622600, 34200, 348},
  {1980347400, 37800, 348},
  {1996072200, 34200, 348},
  {2011797000, 37800, 348},
  {2027521800, 34200, 348},
  {2043246600, 37800, 348},
  {2058971400, 34200, 348},
  {2075301000, 37800, 348},
  {2091025800, 34200, 348},
  {2106750600, 37800, 348},
  {2122475400, 34200, 348},
  {2138200200, 37800, 348},
  {-1672567140, 39600, 349},
  {-1665392400, 36000, 349},
  {-883641600, 39600, 349},
  {-876128400, 36000, 349},
  {-860400000, 39600, 349},
  {-844678800, 36000, 349},
  {-828345600, 39600, 349},
  {-813229200, 36000, 349},
  {57686400, 39600, 349},
  {67968000, 36000, 349},
  {89136000, 39600, 349},
  {100022400, 36000, 349},
  {120585600, 39600, 349},
  {131472000, 36000, 349},
  {152035200, 39600, 349},
  {162921600, 36000, 349},
  {183484800, 39600, 349},
  {194976000, 36000, 349},
  {215539200, 39600, 349},
  {226425600, 36000, 349},
  {246988800, 39600, 349},
  {257875200, 36000, 349},
  {278438400, 39600, 349},
  {289324800, 36000, 349},
  {309888000, 39600, 349},
  {320774400, 36000, 349},
  {341337600, 39600, 349},
  {352224000, 36000, 349},
  {372787200, 39600, 349},
  {386697600, 36000, 349},
  {404841600, 39600, 349},
  {415728000, 36000, 349},
  {436291200, 39600, 349},
  {447177600, 36000, 349},
  {467740800, 39600, 349},
  {478627200, 36000, 349},
  {499190400, 39600, 349},
  {511286400, 36000, 349},
  {530035200, 39600, 349},
  {542736000, 36000, 349},
  {562089600, 39600, 349},
  {574790400, 36000, 349},
  {594144000, 39600, 349},
  {606240000, 36000, 349},
  {625593600, 39600, 349},
  {636480000, 36000, 349},
  {657043200, 39600, 349},
  {667929600, 36000, 349},
  {688492800, 39600, 349},
  {699379200, 36000, 349},
  {719942400, 39600, 349},
  {731433600, 36000, 349},
  {751996800, 39600, 349},
  {762883200, 36000, 349},
  {783446400, 39600, 349},
  {794332800, 36000, 349},
  {814896000, 39600, 349},
  {828201600, 36000, 349},
  {846345600, 39600, 349},
  {859651200, 36000, 349},
  {877795200, 39600, 349},
  {891100800, 36000, 349},
  {909244800, 39600, 349},
  {922550400, 36000, 349},
  {941299200, 39600, 349},
  {954000000, 36000, 349},
  {967305600, 39600, 349},
  {985449600, 36000, 349},
  {1004198400, 39600, 349},
  {1017504000, 36000, 349},
  {1035648000, 39600, 349},
  {1048953600, 36000, 349},
  {1067097600, 39600, 349},
  {1080403200, 36000, 349},
  {1099152000, 39600, 349},
  {1111852800, 36000, 349},
  {1130601600, 39600, 349},
  {1143907200, 36000, 349},
  {1162051200, 39600, 349},
  {1174752000, 36000, 349},
  {1193500800, 39600, 349},
  {1207411200, 36000, 349},
  {1223136000, 39600, 349},
  {1238860800, 36000, 349},
  {1254585600, 39600, 349},
  {1270310400, 36000, 349},
  {1286035200, 39600, 349},
  {1301760000, 36000, 349},
  {1317484800, 39600, 349},
  {1333209600, 36000, 349},
  {1349539200, 39600, 349},
  {1365264000, 36000, 349},
  {1380988800, 39600, 349},
  {1396713600, 36000, 349},
  {1412438400, 39600, 349},
  {1428163200, 36000, 349},
  {1443888000, 39600, 349},
  {1459612800, 36000, 349},
  {1475337600, 39600, 349},
  {1491062400, 36000, 349},
  {1506787200, 39600, 349},
  {1522512000, 36000, 349},
  {1538841600, 39600, 349},
  {1554566400, 36000, 349},
  {1570291200, 39600, 349},
  {1586016000, 36000, 349},
  {1601740800, 39600, 349},
  {1617465600, 36000, 349},
  {1633190400, 39600, 349},
  {1648915200, 36000, 349},
  {1664640000, 39600, 349},
  {1680364800, 36000, 349},
  {1696089600, 39600, 349},
  {1712419200, 36000, 349},
  {1728144000, 39600, 349},
  {1743868800, 36000, 349},
  {1759593600, 39600, 349},
  {1775318400, 36000, 349},
  {1791043200, 39600, 349},
  {1806768000, 36000, 349},
  {1822492800, 39600, 349},
  {1838217600, 36000, 349},
  {1853942400, 39600, 349},
  {1869667200, 36000, 349},
  {1885996800, 39600, 349},
  {1901721600, 36000, 349},
  {1917446400, 39600, 349},
  {1933171200, 36000, 349},
  {1948896000, 39600, 349},
  {1964620800, 36000, 349},
  {1980345600, 39600, 349},
  {1996070400, 36000, 349},
  {2011795200, 39600, 349},
  {2027520000, 36000, 349},
  {2043244800, 39600, 349},
  {2058969600, 36000, 349},
  {2075299200, 39600, 349},
  {2091024000, 36000, 349},
  {2106748800, 39600, 349},
  {2122473600, 36000, 349},
  {2138198400, 39600, 349},
  {-1680508800, 39600, 350},
  {-1665392400, 36000, 350},
  {-883641600, 39600, 350},
  {-876128400, 36000, 350},
  {-860400000, 39600, 350},
  {-844678800, 36000, 350},
  {-828345600, 39600, 350},
  {-813229200, 36000, 350},
  {-71136000, 39600, 350},
  {-55411200, 36000, 350},
  {-37267200, 39600, 350},
  {-25776000, 36000, 350},
  {-5817600, 39600, 350},
  {5673600, 36000, 350},
  {25632000, 39600, 350},
  {37728000, 36000, 350},
  {57686400, 39600, 350},
  {67968000, 36000, 350},
  {89136000, 39600, 350},
  {100022400, 36000, 350},
  {120585600, 39600, 350},
  {131472000, 36000, 350},
  {152035200, 39600, 350},
  {162921600, 36000, 350},
  {183484800, 39600, 350},
  {194976000, 36000, 350},
  {215539200, 39600, 350},
  {226425600, 36000, 350},
  {246988800, 39600, 350},
  {257875200, 36000, 350},
  {278438400, 39600, 350},
  {289324800, 36000, 350},
  {309888000, 39600, 350},
  {320774400, 36000, 350},
  {341337600, 39600, 350},
  {352224000, 36000, 350},
  {372787200, 39600, 350},
  {386092800, 36000, 350},
  {404841600, 39600, 350},
  {417542400, 36000, 350},
  {436291200, 39600, 350},
  {447177600, 36000, 350},
  {467740800, 39600, 350},
  {478627200, 36000, 350},
  {499190400, 39600, 350},
  {510076800, 36000, 350},
  {530035200, 39600, 350},
  {542736000, 36000, 350},
  {562089600, 39600, 350},
  {574790400, 36000, 350},
  {594144000, 39600, 350},
  {606240000, 36000, 350},
  {625593600, 39600, 350},
  {637689600, 36000, 350},
  {657043200, 39600, 350},
  {670348800, 36000, 350},
  {686678400, 39600, 350},
  {701798400, 36000, 350},
  {718128000, 39600, 350},
  {733248000, 36000, 350},
  {749577600, 39600, 350},
  {764697600, 36000, 350},
  {781027200, 39600, 350},
  {796147200, 36000, 350},
  {812476800, 39600, 350},
  {828201600, 36000, 350},
  {844531200, 39600, 350},
  {859651200, 36000, 350},
  {875980800, 39600, 350},
  {891100800, 36000, 350},
  {907430400, 39600, 350},
  {922550400, 36000, 350},
  {938880000, 39600, 350},
  {954000000, 36000, 350},
  {967305600, 39600, 350},
  {985449600, 36000, 350},
  {1002384000, 39600, 350},
  {1017504000, 36000, 350},
  {1033833600, 39600, 350},
  {1048953600, 36000, 350},
  {1065283200, 39600, 350},
  {1080403200, 36000, 350},
  {1096732800, 39600, 350},
  {1111852800, 36000, 350},
  {1128182400, 39600, 350},
  {1143907200, 36000, 350},
  {1159632000, 39600, 350},
  {1174752000, 36000, 350},
  {1191686400, 39600, 350},
  {1207411200, 36000, 350},
  {1223136000, 39600, 350},
  {1238860800, 36000, 350},
  {1254585600, 39600, 350},
  {1270310400, 36000, 350},
  {1286035200, 39600, 350},
  {1301760000, 36000, 350},
  {1317484800, 39600, 350},
  {1333209600, 36000, 350},
  {1349539200, 39600, 350},
  {1365264000, 36000, 350},
  {1380988800, 39600, 350},
  {1396713600, 36000, 350},
  {1412438400, 39600, 350},
  {1428163200, 36000, 350},
  {1443888000, 39600, 350},
  {1459612800, 36000, 350},
  {1475337600, 39600, 350},
  {1491062400, 36000, 350},
  {1506787200, 39600, 350},
  {1522512000, 36000, 350},
  {1538841600, 39600, 350},
  {1554566400, 36000, 350},
  {1570291200, 39600, 350},
  {1586016000, 36000, 350},
  {1601740800, 39600, 350},
  {1617465600, 36000, 350},
  {1633190400, 39600, 350},
  {1648915200, 36000, 350},
  {1664640000, 39600, 350},
  {1680364800, 36000, 350},
  {1696089600, 39600, 350},
  {1712419200, 36000, 350},
  {1728144000, 39600, 350},
  {1743868800, 36000, 350},
  {1759593600, 39600, 350},
  {1775318400, 36000, 350},
  {1791043200, 39600, 350},
  {1806768000, 36000, 350},
  {1822492800, 39600, 350},
  {1838217600, 36000, 350},
  {1853942400, 39600, 350},
  {1869667200, 36000, 350},
  {1885996800, 39600, 350},
  {1901721600, 36000, 350},
  {1917446400, 39600, 350},
  {1933171200, 36000, 350},
  {1948896000, 39600, 350},
  {1964620800, 36000, 350},
  {1980345600, 39600, 350},
  {1996070400, 36000, 350},
  {2011795200, 39600, 350},
  {2027520000, 36000, 350},
  {2043244800, 39600, 350},
  {2058969600, 36000, 350},
  {2075299200, 39600, 350},
  {2091024000, 36000, 350},
  {2106748800, 39600, 350},
  {2122473600, 36000, 350},
  {2138198400, 39600, 350},
  {-1672567140, 39600, 351},
  {-1665392400, 36000, 351},
  {-883641600, 39600, 351},
  {-876128400, 36000, 351},
  {-860400000, 39600, 351},
  {-844678800, 36000, 351},
  {-828345600, 39600, 351},
  {-813229200, 36000, 351},
  {57686400, 39600, 351},
  {67968000, 36000, 351},
  {89136000, 39600, 351},
  {100022400, 36000, 351},
  {120585600, 39600, 351},
  {131472000, 36000, 351},
  {152035200, 39600, 351},
  {162921600, 36000, 351},
  {183484800, 39600, 351},
  {194976000, 36000, 351},
  {215539200, 39600, 351},
  {226425600, 36000, 351},
  {246988800, 39600, 351},
  {257875200, 36000, 351},
  {278438400, 39600, 351},
  {289324800, 36000, 351},
  {309888000, 39600, 351},
  {320774400, 36000, 351},
  {341337600, 39600, 351},
  {352224000, 36000, 351},
  {372787200, 39600, 351},
  {384278400, 36000, 351},
  {404841600, 39600, 351},
  {415728000, 36000, 351},
  {436291200, 39600, 351},
  {447177600, 36000, 351},
  {467740800, 39600, 351},
  {478627200, 36000, 351},
  {499190400, 39600, 351},
  {511286400, 36000, 351},
  {530035200, 39600, 351},
  {542736000, 36000, 351},
  {561484800, 39600, 351},
  {574790400, 36000, 351},
  {594144000, 39600, 351},
  {606240000, 36000, 351},
  {625593600, 39600, 351},
  {637689600, 36000, 351},
  {657043200, 39600, 351},
  {667929600, 36000, 351},
  {688492800, 39600, 351},
  {699379200, 36000, 351},
  {719942400, 39600, 351},
  {731433600, 36000, 351},
  {751996800, 39600, 351},
  {762883200, 36000, 351},
  {783446400, 39600, 351},
  {796147200, 36000, 351},
  {814896000, 39600, 351},
  {828201600, 36000, 351},
  {846345600, 39600, 351},
  {859651200, 36000, 351},
  {877795200, 39600, 351},
  {891100800, 36000, 351},
  {909244800, 39600, 351},
  {922550400, 36000, 351},
  {941299200, 39600, 351},
  {954000000, 36000, 351},
  {967305600, 39600, 351},
  {985449600, 36000, 351},
  {1004198400, 39600, 351},
  {1017504000, 36000, 351},
  {1035648000, 39600, 351},
  {1048953600, 36000, 351},
  {1067097600, 39600, 351},
  {1080403200, 36000, 351},
  {1099152000, 39600, 351},
  {1111852800, 36000, 351},
  {1130601600, 39600, 351},
  {1143907200, 36000, 351},
  {1162051200, 39600, 351},
  {1174752000, 36000, 351},
  {1193500800, 39600, 351},
  {1207411200, 36000, 351},
  {1223136000, 39600, 351},
  {1238860800, 36000, 351},
  {1254585600, 39600, 351},
  {1270310400, 36000, 351},
  {1286035200, 39600, 351},
  {1301760000, 36000, 351},
  {1317484800, 39600, 351},
  {1333209600, 36000, 351},
  {1349539200, 39600, 351},
  {1365264000, 36000, 351},
  {1380988800, 39600, 351},
  {1396713600, 36000, 351},
  {1412438400, 39600, 351},
  {1428163200, 36000, 351},
  {1443888000, 39600, 351},
  {1459612800, 36000, 351},
  {1475337600, 39600, 351},
  {1491062400, 36000, 351},
  {1506787200, 39600, 351},
  {1522512000, 36000, 351},
  {1538841600, 39600, 351},
  {1554566400, 36000, 351},
  {1570291200, 39600, 351},
  {1586016000, 36000, 351},
  {1601740800, 39600, 351},
  {1617465600, 36000, 351},
  {1633190400, 39600, 351},
  {1648915200, 36000, 351},
  {1664640000, 39600, 351},
  {1680364800, 36000, 351},
  {1696089600, 39600, 351},
  {1712419200, 36000, 351},
  {1728144000, 39600, 351},
  {1743868800, 36000, 351},
  {1759593600, 39600, 351},
  {1775318400, 36000, 351},
  {1791043200, 39600, 351},
  {1806768000, 36000, 351},
  {1822492800, 39600, 351},
  {1838217600, 36000, 351},
  {1853942400, 39600, 351},
  {1869667200, 36000, 351},
  {1885996800, 39600, 351},
  {1901721600, 36000, 351},
  {1917446400, 39600, 351},
  {1933171200, 36000, 351},
  {1948896000, 39600, 351},
  {1964620800, 36000, 351},
  {1980345600, 39600, 351},
  {1996070400, 36000, 351},
  {2011795200, 39600, 351},
  {2027520000, 36000, 351},
  {2043244800, 39600, 351},
  {2058969600, 36000, 351},
  {2075299200, 39600, 351},
  {2091024000, 36000, 351},
  {2106748800, 39600, 351},
  {2122473600, 36000, 351},
  {2138198400, 39600, 351},
  {-1672559940, 32400, 352},
  {-1665385200, 28800, 352},
  {-883634400, 32400, 352},
  {-876121200, 28800, 352},
  {-860392800, 32400, 352},
  {-844671600, 28800, 352},
  {152042400, 32400, 352},
  {162928800, 28800, 352},
  {436298400, 32400, 352},
  {447184800, 28800, 352},
  {690314400, 32400, 352},
  {699386400, 28800, 352},
  {1165082400, 32400, 352},
  {1174759200, 28800, 352},
  {1193508000, 32400, 352},
  {1206813600, 28800, 352},
  {1224957600, 32400, 352},
  {1238263200, 28800, 352},
  {-1672565340, 37800, 353},
  {-1665390600, 34200, 353},
  {-883639800, 37800, 353},
  {-876126600, 34200, 353},
  {-860398200, 37800, 353},
  {-844677000, 34200, 353},
  {-828343800, 37800, 353},
  {-813227400, 34200, 353},
  {57688200, 37800, 353},
  {67969800, 34200, 353},
  {89137800, 37800, 353},
  {100024200, 34200, 353},
  {120587400, 37800, 353},
  {131473800, 34200, 353},
  {152037000, 37800, 353},
  {162923400, 34200, 353},
  {183486600, 37800, 353},
  {194977800, 34200, 353},
  {215541000, 37800, 353},
  {226427400, 34200, 353},
  {246990600, 37800, 353},
  {257877000, 34200, 353},
  {278440200, 37800, 353},
  {289326600, 34200, 353},
  {309889800, 37800, 353},
  {320776200, 34200, 353},
  {341339400, 37800, 353},
  {352225800, 34200, 353},
  {372789000, 37800, 353},
  {386699400, 34200, 353},
  {404843400, 37800, 353},
  {415729800, 34200, 353},
  {436293000, 37800, 353},
  {447179400, 34200, 353},
  {467742600, 37800, 353},
  {478629000, 34200, 353},
  {499192200, 37800, 353},
  {511288200, 34200, 353},
  {530037000, 37800, 353},
  {542737800, 34200, 353},
  {562091400, 37800, 353},
  {574792200, 34200, 353},
  {594145800, 37800, 353},
  {606241800, 34200, 353},
  {625595400, 37800, 353},
  {636481800, 34200, 353},
  {657045000, 37800, 353},
  {667931400, 34200, 353},
  {688494600, 37800, 353},
  {699381000, 34200, 353},
  {719944200, 37800, 353},
  {731435400, 34200, 353},
  {751998600, 37800, 353},
  {762885000, 34200, 353},
  {783448200, 37800, 353},
  {794334600, 34200, 353},
  {814897800, 37800, 353},
  {828203400, 34200, 353},
  {846347400, 37800, 353},
  {859653000, 34200, 353},
  {877797000, 37800, 353},
  {891102600, 34200, 353},
  {909246600, 37800, 353},
  {922552200, 34200, 353},
  {941301000, 37800, 353},
  {946647000, 37800, 353},
  {954001800, 34200, 353},
  {972750600, 37800, 353},
  {985451400, 34200, 353},
  {1004200200, 37800, 353},
  {1017505800, 34200, 353},
  {1035649800, 37800, 353},
  {1048955400, 34200, 353},
  {1067099400, 37800, 353},
  {1080405000, 34200, 353},
  {1099153800, 37800, 353},
  {1111854600, 34200, 353},
  {1130603400, 37800, 353},
  {1143909000, 34200, 353},
  {1162053000, 37800, 353},
  {1174753800, 34200, 353},
  {1193502600, 37800, 353},
  {1207413000, 34200, 353},
  {1223137800, 37800, 353},
  {1238862600, 34200, 353},
  {1254587400, 37800, 353},
  {1270312200, 34200, 353},
  {1286037000, 37800, 353},
  {1301761800, 34200, 353},
  {1317486600, 37800, 353},
  {1333211400, 34200, 353},
  {1349541000, 37800, 353},
  {1365265800, 34200, 353},
  {1380990600, 37800, 353},
  {1396715400, 34200, 353},
  {1412440200, 37800, 353},
  {1428165000, 34200, 353},
  {1443889800, 37800, 353},
  {1459614600, 34200, 353},
  {1475339400, 37800, 353},
  {1491064200, 34200, 353},
  {1506789000, 37800, 353},
  {1522513800, 34200, 353},
  {1538843400, 37800, 353},
  {1554568200, 34200, 353},
  {1570293000, 37800, 353},
  {1586017800, 34200, 353},
  {1601742600, 37800, 353},
  {1617467400, 34200, 353},
  {1633192200, 37800, 353},
  {1648917000, 34200, 353},
  {1664641800, 37800, 353},
  {1680366600, 34200, 353},
  {1696091400, 37800, 353},
  {1712421000, 34200, 353},
  {1728145800, 37800, 353},
  {1743870600, 34200, 353},
  {1759595400, 37800, 353},
  {1775320200, 34200, 353},
  {1791045000, 37800, 353},
  {1806769800, 34200, 353},
  {1822494600, 37800, 353},
  {1838219400, 34200, 353},
  {1853944200, 37800, 353},
  {1869669000, 34200, 353},
  {1885998600, 37800, 353},
  {1901723400, 34200, 353},
  {1917448200, 37800, 353},
  {1933173000, 34200, 353},
  {1948897800, 37800, 353},
  {1964622600, 34200, 353},
  {1980347400, 37800, 353},
  {1996072200, 34200, 353},
  {2011797000, 37800, 353},
  {2027521800, 34200, 353},
  {2043246600, 37800, 353},
  {2058971400, 34200, 353},
  {2075301000, 37800, 353},
  {2091025800, 34200, 353},
  {2106750600, 37800, 353},
  {2122475400, 34200, 353},
  {2138200200, 37800, 353},
  {INT64_MIN, -16272, 354},
  {-1767209328, -18000, 354},
  {-1206950400, -14400, 354},
  {-1191355200, -18000, 354},
  {-1175367600, -14400, 354},
  {-1159819200, -18000, 354},
  {-633812400, -14400, 354},
  {-622062000, -18000, 354},
  {-602276400, -14400, 354},
  {-591825600, -18000, 354},
  {-570740400, -14400, 354},
  {-560203200, -18000, 354},
  {-539118000, -14400, 354},
  {-531345600, -18000, 354},
  {-191358000, -14400, 354},
  {-184190400, -18000, 354},
  {-155156400, -14400, 354},
  {-150062400, -18000, 354},
  {-128890800, -14400, 354},
  {-121118400, -18000, 354},
  {-99946800, -14400, 354},
  {-89582400, -18000, 354},
  {-68410800, -14400, 354},
  {-57960000, -18000, 354},
  {499755600, -14400, 354},
  {511243200, -18000, 354},
  {530600400, -14400, 354},
  {540273600, -18000, 354},
  {562136400, -14400, 354},
  {571204800, -18000, 354},
  {1214283600, -14400, 354},
  {INT64_MIN, -7780, 355},
  {-1767217820, -7200, 355},
  {-1206961200, -3600, 355},
  {-1191366000, -7200, 355},
  {-1175378400, -3600, 355},
  {-1159830000, -7200, 355},
  {-633823200, -3600, 355},
  {-622072800, -7200, 355},
  {-602287200, -3600, 355},
  {-591836400, -7200, 355},
  {-570751200, -3600, 355},
  {-560214000, -7200, 355},
  {-539128800, -3600, 355},
  {-531356400, -7200, 355},
  {-191368800, -3600, 355},
  {-184201200, -7200, 355},
  {-155167200, -3600, 355},
  {-150073200, -7200, 355},
  {-128901600, -3600, 355},
  {-121129200, -7200, 355},
  {-99957600, -3600, 355},
  {-89593200, -7200, 355},
  {-68421600, -3600, 355},
  {-57970800, -7200, 355},
  {499744800, -3600, 355},
  {511232400, -7200, 355},
  {530589600, -3600, 355},
  {540262800, -7200, 355},
  {562125600, -3600, 355},
  {571194000, -7200, 355},
  {592970400, -3600, 355},
  {602038800, -7200, 355},
  {624420000, -3600, 355},
  {634698000, -7200, 355},
  {938916000, -3600, 355},
  {951613200, -7200, 355},
  {970970400, -3600, 355},
  {971571600, -7200, 355},
  {1003024800, -3600, 355},
  {1013907600, -7200, 355},
  {INT64_MIN, -11188, 356},
  {-1767214412, -10800, 356},
  {-1206957600, -7200, 356},
  {-1191362400, -10800, 356},
  {-1175374800, -7200, 356},
  {-1159826400, -10800, 356},
  {-633819600, -7200, 356},
  {-622069200, -10800, 356},
  {-602283600, -7200, 356},
  {-591832800, -10800, 356},
  {-570747600, -7200, 356},
  {-560210400, -10800, 356},
  {-539125200, -7200, 356},
  {-531352800, -10800, 356},
  {-195426000, -7200, 356},
  {-184197600, -10800, 356},
  {-155163600, -7200, 356},
  {-150069600, -10800, 356},
  {-128898000, -7200, 356},
  {-121125600, -10800, 356},
  {-99954000, -7200, 356},
  {-89589600, -10800, 356},
  {-68418000, -7200, 356},
  {-57967200, -10800, 356},
  {499748400, -7200, 356},
  {511236000, -10800, 356},
  {530593200, -7200, 356},
  {540266400, -10800, 356},
  {562129200, -7200, 356},
  {571197600, -10800, 356},
  {592974000, -7200, 356},
  {602042400, -10800, 356},
  {624423600, -7200, 356},
  {634701600, -10800, 356},
  {656478000, -7200, 356},
  {666756000, -10800, 356},
  {687927600, -7200, 356},
  {697600800, -10800, 356},
  {719982000, -7200, 356},
  {728445600, -10800, 356},
  {750826800, -7200, 356},
  {761709600, -10800, 356},
  {782276400, -7200, 356},
  {793159200, -10800, 356},
  {813726000, -7200, 356},
  {824004000, -10800, 356},
  {844570800, -7200, 356},
  {856058400, -10800, 356},
  {876106800, -7200, 356},
  {888717600, -10800, 356},
  {908074800, -7200, 356},
  {919562400, -10800, 356},
  {938919600, -7200, 356},
  {951616800, -10800, 356},
  {970974000, -7200, 356},
  {982461600, -10800, 356},
  {1003028400, -7200, 356},
  {1013911200, -10800, 356},
  {1036292400, -7200, 356},
  {1045360800, -10800, 356},
  {1066532400, -7200, 356},
  {1076810400, -10800, 356},
  {1099364400, -7200, 356},
  {1108864800, -10800, 356},
  {1129431600, -7200, 356},
  {1140314400, -10800, 356},
  {1162695600, -7200, 356},
  {1172368800, -10800, 356},
  {1192330800, -7200, 356},
  {1203213600, -10800, 356},
  {1224385200, -7200, 356},
  {1234663200, -10800, 356},
  {1255834800, -7200, 356},
  {1266717600, -10800, 356},
  {1287284400, -7200, 356},
  {1298167200, -10800, 356},
  {1318734000, -7200, 356},
  {1330221600, -10800, 356},
  {1350788400, -7200, 356},
  {1361066400, -10800, 356},
  {1382238000, -7200, 356},
  {1392516000, -10800, 356},
  {1413687600, -7200, 356},
  {1424570400, -10800, 356},
  {1445137200, -7200, 356},
  {1456020000, -10800, 356},
  {1476586800, -7200, 356},
  {1487469600, -10800, 356},
  {1508036400, -7200, 356},
  {1518919200, -10800, 356},
  {1540090800, -7200, 356},
  {1550368800, -10800, 356},
  {1571540400, -7200, 356},
  {1581818400, -10800, 356},
  {1602990000, -7200, 356},
  {1613872800, -10800, 356},
  {1634439600, -7200, 356},
  {1645322400, -10800, 356},
  {1665889200, -7200, 356},
  {1677376800, -10800, 356},
  {1697338800, -7200, 356},
  {1708221600, -10800, 356},
  {1729393200, -7200, 356},
  {1739671200, -10800, 356},
  {1760842800, -7200, 356},
  {1771725600, -10800, 356},
  {1792292400, -7200, 356},
  {1803175200, -10800, 356},
  {1823742000, -7200, 356},
  {1834624800, -10800, 356},
  {1855191600, -7200, 356},
  {1866074400, -10800, 356},
  {1887246000, -7200, 356},
  {1897524000, -10800, 356},
  {1918695600, -7200, 356},
  {1928973600, -10800, 356},
  {1950145200, -7200, 356},
  {1960423200, -10800, 356},
  {1981594800, -7200, 356},
  {1992477600, -10800, 356},
  {2013044400, -7200, 356},
  {2024532000, -10800, 356},
  {2044494000, -7200, 356},
  {2055376800, -10800, 356},
  {2076548400, -7200, 356},
  {2086826400, -10800, 356},
  {2107998000, -7200, 356},
  {2118880800, -10800, 356},
  {2139447600, -7200, 356},
  {INT64_MIN, -14404, 357},
  {-1767211196, -14400, 357},
  {-1206954000, -10800, 357},
  {-1191358800, -14400, 357},
  {-1175371200, -10800, 357},
  {-1159822800, -14400, 357},
  {-633816000, -10800, 357},
  {-622065600, -14400, 357},
  {-602280000, -10800, 357},
  {-591829200, -14400, 357},
  {-570744000, -10800, 357},
  {-560206800, -14400, 357},
  {-539121600, -10800, 357},
  {-531349200, -14400, 357},
  {-191361600, -10800, 357},
  {-184194000, -14400, 357},
  {-155160000, -10800, 357},
  {-150066000, -14400, 357},
  {-128894400, -10800, 357},
  {-121122000, -14400, 357},
  {-99950400, -10800, 357},
  {-89586000, -14400, 357},
  {-68414400, -10800, 357},
  {-57963600, -14400, 357},
  {499752000, -10800, 357},
  {511239600, -14400, 357},
  {530596800, -10800, 357},
  {540270000, -14400, 357},
  {562132800, -10800, 357},
  {571201200, -14400, 357},
  {750830400, -10800, 357},
  {761713200, -14400, 357},
  {-1693706400, 7200, 358},
  {-1680483600, 3600, 358},
  {-1663455600, 7200, 358},
  {-1650150000, 3600, 358},
  {-1632006000, 7200, 358},
  {-1618700400, 3600, 358},
  {-938905200, 7200, 358},
  {-857257200, 3600, 358},
  {-844556400, 7200, 358},
  {-828226800, 3600, 358},
  {-812502000, 7200, 358},
  {-796777200, 3600, 358},
  {-781052400, 7200, 358},
  {-766623600, 3600, 358},
  {228877200, 7200, 358},
  {243997200, 3600, 358},
  {260326800, 7200, 358},
  {276051600, 3600, 358},
  {291776400, 7200, 358},
  {307501200, 3600, 358},
  {323830800, 7200, 358},
  {338950800, 3600, 358},
  {354675600, 7200, 358},
  {370400400, 3600, 358},
  {386125200, 7200, 358},
  {401850000, 3600, 358},
  {417574800, 7200, 358},
  {433299600, 3600, 358},
  {449024400, 7200, 358},
  {465354000, 3600, 358},
  {481078800, 7200, 358},
  {496803600, 3600, 358},
  {512528400, 7200, 358},
  {528253200, 3600, 358},
  {543978000, 7200, 358},
  {559702800, 3600, 358},
  {575427600, 7200, 358},
  {591152400, 3600, 358},
  {606877200, 7200, 358},
  {622602000, 3600, 358},
  {638326800, 7200, 358},
  {654656400, 3600, 358},
  {670381200, 7200, 358},
  {686106000, 3600, 358},
  {701830800, 7200, 358},
  {717555600, 3600, 358},
  {733280400, 7200, 358},
  {749005200, 3600, 358},
  {764730000, 7200, 358},
  {780454800, 3600, 358},
  {796179600, 7200, 358},
  {811904400, 3600, 358},
  {828234000, 7200, 358},
  {846378000, 3600, 358},
  {859683600, 7200, 358},
  {877827600, 3600, 358},
  {891133200, 7200, 358},
  {909277200, 3600, 358},
  {922582800, 7200, 358},
  {941331600, 3600, 358},
  {954032400, 7200, 358},
  {972781200, 3600, 358},
  {985482000, 7200, 358},
  {1004230800, 3600, 358},
  {1017536400, 7200, 358},
  {1035680400, 3600, 358},
  {1048986000, 7200, 358},
  {1067130000, 3600, 358},
  {1080435600, 7200, 358},
  {1099184400, 3600, 358},
  {1111885200, 7200, 358},
  {1130634000, 3600, 358},
  {1143334800, 7200, 358},
  {1162083600, 3600, 358},
  {1174784400, 7200, 358},
  {1193533200, 3600, 358},
  {1206838800, 7200, 358},
  {1224982800, 3600, 358},
  {1238288400, 7200, 358},
  {1256432400, 3600, 358},
  {1269738000, 7200, 358},
  {1288486800, 3600, 358},
  {1301187600, 7200, 358},
  {1319936400, 3600, 358},
  {1332637200, 7200, 358},
  {1351386000, 3600, 358},
  {1364691600, 7200, 358},
  {1382835600, 3600, 358},
  {1396141200, 7200, 358},
  {1414285200, 3600, 358},
  {1427590800, 7200, 358},
  {1445734800, 3600, 358},
  {1459040400, 7200, 358},
  {1477789200, 3600, 358},
  {1490490000, 7200, 358},
  {1509238800, 3600, 358},
  {1521939600, 7200, 358},
  {1540688400, 3600, 358},
  {1553994000, 7200, 358},
  {1572138000, 3600, 358},
  {1585443600, 7200, 358},
  {1603587600, 3600, 358},
  {1616893200, 7200, 358},
  {1635642000, 3600, 358},
  {1648342800, 7200, 358},
  {1667091600, 3600, 358},
  {1679792400, 7200, 358},
  {1698541200, 3600, 358},
  {1711846800, 7200, 358},
  {1729990800, 3600, 358},
  {1743296400, 7200, 358},
  {1761440400, 3600, 358},
  {1774746000, 7200, 358},
  {1792890000, 3600, 358},
  {1806195600, 7200, 358},
  {1824944400, 3600, 358},
  {1837645200, 7200, 358},
  {1856394000, 3600, 358},
  {1869094800, 7200, 358},
  {1887843600, 3600, 358},
  {1901149200, 7200, 358},
  {1919293200, 3600, 358},
  {1932598800, 7200, 358},
  {1950742800, 3600, 358},
  {1964048400, 7200, 358},
  {1982797200, 3600, 358},
  {1995498000, 7200, 358},
  {2014246800, 3600, 358},
  {2026947600, 7200, 358},
  {2045696400, 3600, 358},
  {2058397200, 7200, 358},
  {2077146000, 3600, 358},
  {2090451600, 7200, 358},
  {2108595600, 3600, 358},
  {2121901200, 7200, 358},
  {2140045200, 3600, 358},
  {-1633276800, -18000, 359},
  {-1615136400, -21600, 359},
  {-1601827200, -18000, 359},
  {-1583686800, -21600, 359},
  {-880214400, -18000, 359},
  {-769395600, -18000, 359},
  {-765392400, -21600, 359},
  {-84384000, -18000, 359},
  {-68662800, -21600, 359},
  {-52934400, -18000, 359},
  {-37213200, -21600, 359},
  {-21484800, -18000, 359},
  {-5763600, -21600, 359},
  {9964800, -18000, 359},
  {25686000, -21600, 359},
  {41414400, -18000, 359},
  {57740400, -21600, 359},
  {73468800, -18000, 359},
  {89190000, -21600, 359},
  {104918400, -18000, 359},
  {120639600, -21600, 359},
  {126691200, -18000, 359},
  {152089200, -21600, 359},
  {162374400, -18000, 359},
  {183538800, -21600, 359},
  {199267200, -18000, 359},
  {215593200, -21600, 359},
  {230716800, -18000, 359},
  {247042800, -21600, 359},
  {262771200, -18000, 359},
  {278492400, -21600, 359},
  {294220800, -18000, 359},
  {309942000, -21600, 359},
  {325670400, -18000, 359},
  {341391600, -21600, 359},
  {357120000, -18000, 359},
  {372841200, -21600, 359},
  {388569600, -18000, 359},
  {404895600, -21600, 359},
  {420019200, -18000, 359},
  {436345200, -21600, 359},
  {452073600, -18000, 359},
  {467794800, -21600, 359},
  {483523200, -18000, 359},
  {499244400, -21600, 359},
  {514972800, -18000, 359},
  {530694000, -21600, 359},
  {544608000, -18000, 359},
  {562143600, -21600, 359},
  {576057600, -18000, 359},
  {594198000, -21600, 359},
  {607507200, -18000, 359},
  {625647600, -21600, 359},
  {638956800, -18000, 359},
  {657097200, -21600, 359},
  {671011200, -18000, 359},
  {688546800, -21600, 359},
  {702460800, -18000, 359},
  {719996400, -21600, 359},
  {733910400, -18000, 359},
  {752050800, -21600, 359},
  {765360000, -18000, 359},
  {783500400, -21600, 359},
  {796809600, -18000, 359},
  {814950000, -21600, 359},
  {828864000, -18000, 359},
  {846399600, -21600, 359},
  {860313600, -18000, 359},
  {877849200, -21600, 359},
  {891763200, -18000, 359},
  {909298800, -21600, 359},
  {923212800, -18000, 359},
  {941353200, -21600, 359},
  {954662400, -18000, 359},
  {972802800, -21600, 359},
  {986112000, -18000, 359},
  {1004252400, -21600, 359},
  {1018166400, -18000, 359},
  {1035702000, -21600, 359},
  {1049616000, -18000, 359},
  {1067151600, -21600, 359},
  {1081065600, -18000, 359},
  {1099206000, -21600, 359},
  {1112515200, -18000, 359},
  {1130655600, -21600, 359},
  {1143964800, -18000, 359},
  {1162105200, -21600, 359},
  {1173600000, -18000, 359},
  {1194159600, -21600, 359},
  {1205049600, -18000, 359},
  {1225609200, -21600, 359},
  {1236499200, -18000, 359},
  {1257058800, -21600, 359},
  {1268553600, -18000, 359},
  {1289113200, -21600, 359},
  {1300003200, -18000, 359},
  {1320562800, -21600, 359},
  {1331452800, -18000, 359},
  {1352012400, -21600, 359},
  {1362902400, -18000, 359},
  {1383462000, -21600, 359},
  {1394352000, -18000, 359},
  {1414911600, -21600, 359},
  {1425801600, -18000, 359},
  {1446361200, -21600, 359},
  {1457856000, -18000, 359},
  {1478415600, -21600, 359},
  {1489305600, -18000, 359},
  {1509865200, -21600, 359},
  {1520755200, -18000, 359},
  {1541314800, -21600, 359},
  {1552204800, -18000, 359},
  {1572764400, -21600, 359},
  {1583654400, -18000, 359},
  {1604214000, -21600, 359},
  {1615708800, -18000, 359},
  {1636268400, -21600, 359},
  {1647158400, -18000, 359},
  {1667718000, -21600, 359},
  {1678608000, -18000, 359},
  {1699167600, -21600, 359},
  {1710057600, -18000, 359},
  {1730617200, -21600, 359},
  {1741507200, -18000, 359},
  {1762066800, -21600, 359},
  {1772956800, -18000, 359},
  {1793516400, -21600, 359},
  {1805011200, -18000, 359},
  {1825570800, -21600, 359},
  {1836460800, -18000, 359},
  {1857020400, -21600, 359},
  {1867910400, -18000, 359},
  {1888470000, -21600, 359},
  {1899360000, -18000, 359},
  {1919919600, -21600, 359},
  {1930809600, -18000, 359},
  {1951369200, -21600, 359},
  {1962864000, -18000, 359},
  {1983423600, -21600, 359},
  {1994313600, -18000, 359},
  {2014873200, -21600, 359},
  {2025763200, -18000, 359},
  {2046322800, -21600, 359},
  {2057212800, -18000, 359},
  {2077772400, -21600, 359},
  {2088662400, -18000, 359},
  {2109222000, -21600, 359},
  {2120112000, -18000, 359},
  {2140671600, -21600, 359},
  {INT64_MIN, -15264, 360},
  {-2131645536, -14400, 360},
  {-1696276800, -10800, 360},
  {-1680469200, -14400, 360},
  {-1632074400, -10800, 360},
  {-1614798000, -14400, 360},
  {-1566763200, -10800, 360},
  {-1557090000, -14400, 360},
  {-1535486400, -10800, 360},
  {-1524949200, -14400, 360},
  {-1504468800, -10800, 360},
  {-1493413200, -14400, 360},
  {-1472414400, -10800, 360},
  {-1461963600, -14400, 360},
  {-1440964800, -10800, 360},
  {-1429390800, -14400, 360},
  {-1409515200, -10800, 360},
  {-1396731600, -14400, 360},
  {-1376856000, -10800, 360},
  {-1366491600, -14400, 360},
  {-1346616000, -10800, 360},
  {-1333832400, -14400, 360},
  {-1313956800, -10800, 360},
  {-1303678800, -14400, 360},
  {-1282507200, -10800, 360},
  {-1272661200, -14400, 360},
  {-1251057600, -10800, 360},
  {-1240088400, -14400, 360},
  {-1219608000, -10800, 360},
  {-1207429200, -14400, 360},
  {-1188763200, -10800, 360},
  {-1175979600, -14400, 360},
  {-1157313600, -10800, 360},
  {-1143925200, -14400, 360},
  {-1124049600, -10800, 360},
  {-1113771600, -14400, 360},
  {-1091390400, -10800, 360},
  {-1081026000, -14400, 360},
  {-1059854400, -10800, 360},
  {-1050786000, -14400, 360},
  {-1030910400, -10800, 360},
  {-1018126800, -14400, 360},
  {-999460800, -10800, 360},
  {-986677200, -14400, 360},
  {-965592000, -10800, 360},
  {-955227600, -14400, 360},
  {-935956800, -10800, 360},
  {-923173200, -14400, 360},
  {-904507200, -10800, 360},
  {-891723600, -14400, 360},
  {-880221600, -10800, 360},
  {-769395600, -10800, 360},
  {-765399600, -14400, 360},
  {-747252000, -10800, 360},
  {-733950000, -14400, 360},
  {-715802400, -10800, 360},
  {-702500400, -14400, 360},
  {-684352800, -10800, 360},
  {-671050800, -14400, 360},
  {-652903200, -10800, 360},
  {-639601200, -14400, 360},
  {-589399200, -10800, 360},
  {-576097200, -14400, 360},
  {-557949600, -10800, 360},
  {-544647600, -14400, 360},
  {-526500000, -10800, 360},
  {-513198000, -14400, 360},
  {-495050400, -10800, 360},
  {-481748400, -14400, 360},
  {-431546400, -10800, 360},
  {-418244400, -14400, 360},
  {-400096800, -10800, 360},
  {-386794800, -14400, 360},
  {-368647200, -10800, 360},
  {-355345200, -14400, 360},
  {-337197600, -10800, 360},
  {-323895600, -14400, 360},
  {-242244000, -10800, 360},
  {-226522800, -14400, 360},
  {-210794400, -10800, 360},
  {-195073200, -14400, 360},
  {-179344800, -10800, 360},
  {-163623600, -14400, 360},
  {-147895200, -10800, 360},
  {-131569200, -14400, 360},
  {-116445600, -10800, 360},
  {-100119600, -14400, 360},
  {-84391200, -10800, 360},
  {-68670000, -14400, 360},
  {-52941600, -10800, 360},
  {-37220400, -14400, 360},
  {-21492000, -10800, 360},
  {-5770800, -14400, 360},
  {9957600, -10800, 360},
  {25678800, -14400, 360},
  {41407200, -10800, 360},
  {57733200, -14400, 360},
  {73461600, -10800, 360},
  {89182800, -14400, 360},
  {104911200, -10800, 360},
  {120632400, -14400, 360},
  {136360800, -10800, 360},
  {152082000, -14400, 360},
  {167810400, -10800, 360},
  {183531600, -14400, 360},
  {199260000, -10800, 360},
  {215586000, -14400, 360},
  {230709600, -10800, 360},
  {247035600, -14400, 360},
  {262764000, -10800, 360},
  {278485200, -14400, 360},
  {294213600, -10800, 360},
  {309934800, -14400, 360},
  {325663200, -10800, 360},
  {341384400, -14400, 360},
  {357112800, -10800, 360},
  {372834000, -14400, 360},
  {388562400, -10800, 360},
  {404888400, -14400, 360},
  {420012000, -10800, 360},
  {436338000, -14400, 360},
  {452066400, -10800, 360},
  {467787600, -14400, 360},
  {483516000, -10800, 360},
  {499237200, -14400, 360},
  {514965600, -10800, 360},
  {530686800, -14400, 360},
  {544600800, -10800, 360},
  {562136400, -14400, 360},
  {576050400, -10800, 360},
  {594190800, -14400, 360},
  {607500000, -10800, 360},
  {625640400, -14400, 360},
  {638949600, -10800, 360},
  {657090000, -14400, 360},
  {671004000, -10800, 360},
  {688539600, -14400, 360},
  {702453600, -10800, 360},
  {719989200, -14400, 360},
  {733903200, -10800, 360},
  {752043600, -14400, 360},
  {765352800, -10800, 360},
  {783493200, -14400, 360},
  {796802400, -10800, 360},
  {814942800, -14400, 360},
  {828856800, -10800, 360},
  {846392400, -14400, 360},
  {860306400, -10800, 360},
  {877842000, -14400, 360},
  {891756000, -10800, 360},
  {909291600, -14400, 360},
  {923205600, -10800, 360},
  {941346000, -14400, 360},
  {954655200, -10800, 360},
  {972795600, -14400, 360},
  {986104800, -10800, 360},
  {1004245200, -14400, 360},
  {1018159200, -10800, 360},
  {1035694800, -14400, 360},
  {1049608800, -10800, 360},
  {1067144400, -14400, 360},
  {1081058400, -10800, 360},
  {1099198800, -14400, 360},
  {1112508000, -10800, 360},
  {1130648400, -14400, 360},
  {1143957600, -10800, 360},
  {1162098000, -14400, 360},
  {1173592800, -10800, 360},
  {1194152400, -14400, 360},
  {1205042400, -10800, 360},
  {1225602000, -14400, 360},
  {1236492000, -10800, 360},
  {1257051600, -14400, 360},
  {1268546400, -10800, 360},
  {1289106000, -14400, 360},
  {1299996000, -10800, 360},
  {1320555600, -14400, 360},
  {1331445600, -10800, 360},
  {1352005200, -14400, 360},
  {1362895200, -10800, 360},
  {1383454800, -14400, 360},
  {1394344800, -10800, 360},
  {1414904400, -14400, 360},
  {1425794400, -10800, 360},
  {1446354000, -14400, 360},
  {1457848800, -10800, 360},
  {1478408400, -14400, 360},
  {1489298400, -10800, 360},
  {1509858000, -14400, 360},
  {1520748000, -10800, 360},
  {1541307600, -14400, 360},
  {1552197600, -10800, 360},
  {1572757200, -14400, 360},
  {1583647200, -10800, 360},
  {1604206800, -14400, 360},
  {1615701600, -10800, 360},
  {1636261200, -14400, 360},
  {1647151200, -10800, 360},
  {1667710800, -14400, 360},
  {1678600800, -10800, 360},
  {1699160400, -14400, 360},
  {1710050400, -10800, 360},
  {1730610000, -14400, 360},
  {1741500000, -10800, 360},
  {1762059600, -14400, 360},
  {1772949600, -10800, 360},
  {1793509200, -14400, 360},
  {1805004000, -10800, 360},
  {1825563600, -14400, 360},
  {1836453600, -10800, 360},
  {1857013200, -14400, 360},
  {1867903200, -10800, 360},
  {1888462800, -14400, 360},
  {1899352800, -10800, 360},
  {1919912400, -14400, 360},
  {1930802400, -10800, 360},
  {1951362000, -14400, 360},
  {1962856800, -10800, 360},
  {1983416400, -14400, 360},
  {1994306400, -10800, 360},
  {2014866000, -14400, 360},
  {2025756000, -10800, 360},
  {2046315600, -14400, 360},
  {2057205600, -10800, 360},
  {2077765200, -14400, 360},
  {2088655200, -10800, 360},
  {2109214800, -14400, 360},
  {2120104800, -10800, 360},
  {2140664400, -14400, 360},
  {-1694368800, -18000, 361},
  {-1681671600, -21600, 361},
  {-1632067200, -18000, 361},
  {-1614790800, -21600, 361},
  {-1029686400, -18000, 361},
  {-1018198800, -21600, 361},
  {-880214400, -18000, 361},
  {-769395600, -18000, 361},
  {-765392400, -21600, 361},
  {-746035200, -18000, 361},
  {-732733200, -21600, 361},
  {-715795200, -18000, 361},
  {-702493200, -21600, 361},
  {-684345600, -18000, 361},
  {-671043600, -21600, 361},
  {-652896000, -18000, 361},
  {-639594000, -21600, 361},
  {-620755200, -18000, 361},
  {-607626000, -21600, 361},
  {-589392000, -18000, 361},
  {-576090000, -21600, 361},
  {-557942400, -18000, 361},
  {-544640400, -21600, 361},
  {-526492800, -18000, 361},
  {-513190800, -21600, 361},
  {-495043200, -18000, 361},
  {-481741200, -21600, 361},
  {-463593600, -18000, 361},
  {-450291600, -21600, 361},
  {-431539200, -18000, 361},
  {-418237200, -21600, 361},
  {-400089600, -18000, 361},
  {-386787600, -21600, 361},
  {-368640000, -18000, 361},
  {-355338000, -21600, 361},
  {-337190400, -18000, 361},
  {-321469200, -21600, 361},
  {-305740800, -18000, 361},
  {-292438800, -21600, 361},
  {-210787200, -18000, 361},
  {-198090000, -21600, 361},
  {-116438400, -18000, 361},
  {-100108800, -21600, 361},
  {-84384000, -18000, 361},
  {-68659200, -21600, 361},
  {-52934400, -18000, 361},
  {-37209600, -21600, 361},
  {-21484800, -18000, 361},
  {-5760000, -21600, 361},
  {9964800, -18000, 361},
  {25689600, -21600, 361},
  {41414400, -18000, 361},
  {57744000, -21600, 361},
  {73468800, -18000, 361},
  {89193600, -21600, 361},
  {104918400, -18000, 361},
  {120643200, -21600, 361},
  {136368000, -18000, 361},
  {152092800, -21600, 361},
  {167817600, -18000, 361},
  {183542400, -21600, 361},
  {199267200, -18000, 361},
  {215596800, -21600, 361},
  {230716800, -18000, 361},
  {247046400, -21600, 361},
  {262771200, -18000, 361},
  {278496000, -21600, 361},
  {294220800, -18000, 361},
  {309945600, -21600, 361},
  {325670400, -18000, 361},
  {341395200, -21600, 361},
  {357120000, -18000, 361},
  {372844800, -21600, 361},
  {388569600, -18000, 361},
  {404899200, -21600, 361},
  {420019200, -18000, 361},
  {436348800, -21600, 361},
  {452073600, -18000, 361},
  {467798400, -21600, 361},
  {483523200, -18000, 361},
  {499248000, -21600, 361},
  {514972800, -18000, 361},
  {530697600, -21600, 361},
  {544608000, -18000, 361},
  {562147200, -21600, 361},
  {576057600, -18000, 361},
  {594201600, -21600, 361},
  {607507200, -18000, 361},
  {625651200, -21600, 361},
  {638956800, -18000, 361},
  {657100800, -21600, 361},
  {671011200, -18000, 361},
  {688550400, -21600, 361},
  {702460800, -18000, 361},
  {720000000, -21600, 361},
  {733910400, -18000, 361},
  {752054400, -21600, 361},
  {765360000, -18000, 361},
  {783504000, -21600, 361},
  {796809600, -18000, 361},
  {814953600, -21600, 361},
  {828864000, -18000, 361},
  {846403200, -21600, 361},
  {860313600, -18000, 361},
  {877852800, -21600, 361},
  {891763200, -18000, 361},
  {909302400, -21600, 361},
  {923212800, -18000, 361},
  {941356800, -21600, 361},
  {954662400, -18000, 361},
  {972806400, -21600, 361},
  {986112000, -18000, 361},
  {1004256000, -21600, 361},
  {1018166400, -18000, 361},
  {1035705600, -21600, 361},
  {1049616000, -18000, 361},
  {1067155200, -21600, 361},
  {1081065600, -18000, 361},
  {1099209600, -21600, 361},
  {1112515200, -18000, 361},
  {1130659200, -21600, 361},
  {1136095200, -21600, 361},
  {1143964800, -18000, 361},
  {1162105200, -21600, 361},
  {1173600000, -18000, 361},
  {1194159600, -21600, 361},
  {1205049600, -18000, 361},
  {1225609200, -21600, 361},
  {1236499200, -18000, 361},
  {1257058800, -21600, 361},
  {1268553600, -18000, 361},
  {1289113200, -21600, 361},
  {1300003200, -18000, 361},
  {1320562800, -21600, 361},
  {1331452800, -18000, 361},
  {1352012400, -21600, 361},
  {1362902400, -18000, 361},
  {1383462000, -21600, 361},
  {1394352000, -18000, 361},
  {1414911600, -21600, 361},
  {1425801600, -18000, 361},
  {1446361200, -21600, 361},
  {1457856000, -18000, 361},
  {1478415600, -21600, 361},
  {1489305600, -18000, 361},
  {1509865200, -21600, 361},
  {1520755200, -18000, 361},
  {1541314800, -21600, 361},
  {1552204800, -18000, 361},
  {1572764400, -21600, 361},
  {1583654400, -18000, 361},
  {1604214000, -21600, 361},
  {1615708800, -18000, 361},
  {1636268400, -21600, 361},
  {1647158400, -18000, 361},
  {1667718000, -21600, 361},
  {1678608000, -18000, 361},
  {1699167600, -21600, 361},
  {1710057600, -18000, 361},
  {1730617200, -21600, 361},
  {1741507200, -18000, 361},
  {1762066800, -21600, 361},
  {1772956800, -18000, 361},
  {1793516400, -21600, 361},
  {1805011200, -18000, 361},
  {1825570800, -21600, 361},
  {1836460800, -18000, 361},
  {1857020400, -21600, 361},
  {1867910400, -18000, 361},
  {1888470000, -21600, 361},
  {1899360000, -18000, 361},
  {1919919600, -21600, 361},
  {1930809600, -18000, 361},
  {1951369200, -21600, 361},
  {1962864000, -18000, 361},
  {1983423600, -21600, 361},
  {1994313600, -18000, 361},
  {2014873200, -21600, 361},
  {2025763200, -18000, 361},
  {2046322800, -21600, 361},
  {2057212800, -18000, 361},
  {2077772400, -21600, 361},
  {2088662400, -18000, 361},
  {2109222000, -21600, 361},
  {2120112000, -18000, 361},
  {2140671600, -21600, 361},
  {INT64_MIN, -25116, 362},
  {-2030202084, -25200, 362},
  {-1632063600, -21600, 362},
  {-1614787200, -25200, 362},
  {-1251651600, -21600, 362},
  {-1238349600, -25200, 362},
  {-1220202000, -21600, 362},
  {-1206900000, -25200, 362},
  {-1188752400, -21600, 362},
  {-1175450400, -25200, 362},
  {-1156698000, -21600, 362},
  {-1144000800, -25200, 362},
  {-1125248400, -21600, 362},
  {-1111946400, -25200, 362},
  {-1032714000, -21600, 362},
  {-1016992800, -25200, 362},
  {-1001264400, -21600, 362},
  {-986148000, -25200, 362},
  {-969814800, -21600, 362},
  {-954093600, -25200, 362},
  {-937760400, -21600, 362},
  {-922039200, -25200, 362},
  {-906310800, -21600, 362},
  {-890589600, -25200, 362},
  {-880210800, -21600, 362},
  {-769395600, -21600, 362},
  {-765388800, -25200, 362},
  {-748450800, -21600, 362},
  {-732729600, -25200, 362},
  {-715791600, -21600, 362},
  {-702489600, -25200, 362},
  {-684342000, -21600, 362},
  {-671040000, -25200, 362},
  {-652892400, -21600, 362},
  {-639590400, -25200, 362},
  {-620838000, -21600, 362},
  {-608140800, -25200, 362},
  {-589388400, -21600, 362},
  {-576086400, -25200, 362},
  {-557938800, -21600, 362},
  {-544636800, -25200, 362},
  {-526489200, -21600, 362},
  {-513187200, -25200, 362},
  {-495039600, -21600, 362},
  {-481737600, -25200, 362},
  {-463590000, -21600, 362},
  {-450288000, -25200, 362},
  {-431535600, -21600, 362},
  {-418233600, -25200, 362},
  {-400086000, -21600, 362},
  {-386784000, -25200, 362},
  {-337186800, -21600, 362},
  {-321465600, -25200, 362},
  {-305737200, -21600, 362},
  {-1632070800, -14400, 363},
  {-1614794400, -18000, 363},
  {-1601753400, -14400, 363},
  {-1583697600, -18000, 363},
  {-1567357200, -14400, 363},
  {-1554667200, -18000, 363},
  {-1534698000, -14400, 363},
  {-1524074400, -18000, 363},
  {-1503248400, -14400, 363},
  {-1492365600, -18000, 363},
  {-1471798800, -14400, 363},
  {-1460916000, -18000, 363},
  {-1440954000, -14400, 363},
  {-1428861600, -18000, 363},
  {-1409504400, -14400, 363},
  {-1397412000, -18000, 363},
  {-1378054800, -14400, 363},
  {-1365962400, -18000, 363},
  {-1346605200, -14400, 363},
  {-1333908000, -18000, 363},
  {-1315155600, -14400, 363},
  {-1301853600, -18000, 363},
  {-1283706000, -14400, 363},
  {-1270404000, -18000, 363},
  {-1252256400, -14400, 363},
  {-1238954400, -18000, 363},
  {-1220806800, -14400, 363},
  {-1207504800, -18000, 363},
  {-1188752400, -14400, 363},
  {-1176055200, -18000, 363},
  {-1157302800, -14400, 363},
  {-1144000800, -18000, 363},
  {-1125853200, -14400, 363},
  {-1112551200, -18000, 363},
  {-1094403600, -14400, 363},
  {-1081101600, -18000, 363},
  {-1062954000, -14400, 363},
  {-1049652000, -18000, 363},
  {-1031504400, -14400, 363},
  {-1018202400, -18000, 363},
  {-1000054800, -14400, 363},
  {-986752800, -18000, 363},
  {-968000400, -14400, 363},
  {-955303200, -18000, 363},
  {-936550800, -14400, 363},
  {-880218000, -14400, 363},
  {-769395600, -14400, 363},
  {-765396000, -18000, 363},
  {-747248400, -14400, 363},
  {-733946400, -18000, 363},
  {-715806000, -14400, 363},
  {-702504000, -18000, 363},
  {-684356400, -14400, 363},
  {-671054400, -18000, 363},
  {-652906800, -14400, 363},
  {-634161600, -18000, 363},
  {-620845200, -14400, 363},
  {-602704800, -18000, 363},
  {-589395600, -14400, 363},
  {-576093600, -18000, 363},
  {-557946000, -14400, 363},
  {-544644000, -18000, 363},
  {-526496400, -14400, 363},
  {-513194400, -18000, 363},
  {-495046800, -14400, 363},
  {-481744800, -18000, 363},
  {-463597200, -14400, 363},
  {-450295200, -18000, 363},
  {-431542800, -14400, 363},
  {-418240800, -18000, 363},
  {-400093200, -14400, 363},
  {-384372000, -18000, 363},
  {-368643600, -14400, 363},
  {-352922400, -18000, 363},
  {-337194000, -14400, 363},
  {-321472800, -18000, 363},
  {-305744400, -14400, 363},
  {-289418400, -18000, 363},
  {-273690000, -14400, 363},
  {-257968800, -18000, 363},
  {-242240400, -14400, 363},
  {-226519200, -18000, 363},
  {-210790800, -14400, 363},
  {-195069600, -18000, 363},
  {-179341200, -14400, 363},
  {-163620000, -18000, 363},
  {-147891600, -14400, 363},
  {-131565600, -18000, 363},
  {-116442000, -14400, 363},
  {-100116000, -18000, 363},
  {-84387600, -14400, 363},
  {-68666400, -18000, 363},
  {-52938000, -14400, 363},
  {-37216800, -18000, 363},
  {-21488400, -14400, 363},
  {-5767200, -18000, 363},
  {9961200, -14400, 363},
  {25682400, -18000, 363},
  {41410800, -14400, 363},
  {57736800, -18000, 363},
  {73465200, -14400, 363},
  {89186400, -18000, 363},
  {104914800, -14400, 363},
  {120636000, -18000, 363},
  {136364400, -14400, 363},
  {152085600, -18000, 363},
  {167814000, -14400, 363},
  {183535200, -18000, 363},
  {199263600, -14400, 363},
  {215589600, -18000, 363},
  {230713200, -14400, 363},
  {247039200, -18000, 363},
  {262767600, -14400, 363},
  {278488800, -18000, 363},
  {294217200, -14400, 363},
  {309938400, -18000, 363},
  {325666800, -14400, 363},
  {341388000, -18000, 363},
  {357116400, -14400, 363},
  {372837600, -18000, 363},
  {388566000, -14400, 363},
  {404892000, -18000, 363},
  {420015600, -14400, 363},
  {436341600, -18000, 363},
  {452070000, -14400, 363},
  {467791200, -18000, 363},
  {483519600, -14400, 363},
  {499240800, -18000, 363},
  {514969200, -14400, 363},
  {530690400, -18000, 363},
  {544604400, -14400, 363},
  {562140000, -18000, 363},
  {576054000, -14400, 363},
  {594194400, -18000, 363},
  {607503600, -14400, 363},
  {625644000, -18000, 363},
  {638953200, -14400, 363},
  {657093600, -18000, 363},
  {671007600, -14400, 363},
  {688543200, -18000, 363},
  {702457200, -14400, 363},
  {719992800, -18000, 363},
  {733906800, -14400, 363},
  {752047200, -18000, 363},
  {765356400, -14400, 363},
  {783496800, -18000, 363},
  {796806000, -14400, 363},
  {814946400, -18000, 363},
  {828860400, -14400, 363},
  {846396000, -18000, 363},
  {860310000, -14400, 363},
  {877845600, -18000, 363},
  {891759600, -14400, 363},
  {909295200, -18000, 363},
  {923209200, -14400, 363},
  {941349600, -18000, 363},
  {954658800, -14400, 363},
  {972799200, -18000, 363},
  {986108400, -14400, 363},
  {1004248800, -18000, 363},
  {1018162800, -14400, 363},
  {1035698400, -18000, 363},
  {1049612400, -14400, 363},
  {1067148000, -18000, 363},
  {1081062000, -14400, 363},
  {1099202400, -18000, 363},
  {1112511600, -14400, 363},
  {1130652000, -18000, 363},
  {1143961200, -14400, 363},
  {1162101600, -18000, 363},
  {1173596400, -14400, 363},
  {1194156000, -18000, 363},
  {1205046000, -14400, 363},
  {1225605600, -18000, 363},
  {1236495600, -14400, 363},
  {1257055200, -18000, 363},
  {1268550000, -14400, 363},
  {1289109600, -18000, 363},
  {1299999600, -14400, 363},
  {1320559200, -18000, 363},
  {1331449200, -14400, 363},
  {1352008800, -18000, 363},
  {1362898800, -14400, 363},
  {1383458400, -18000, 363},
  {1394348400, -14400, 363},
  {1414908000, -18000, 363},
  {1425798000, -14400, 363},
  {1446357600, -18000, 363},
  {1457852400, -14400, 363},
  {1478412000, -18000, 363},
  {1489302000, -14400, 363},
  {1509861600, -18000, 363},
  {1520751600, -14400, 363},
  {1541311200, -18000, 363},
  {1552201200, -14400, 363},
  {1572760800, -18000, 363},
  {1583650800, -14400, 363},
  {1604210400, -18000, 363},
  {1615705200, -14400, 363},
  {1636264800, -18000, 363},
  {1647154800, -14400, 363},
  {1667714400, -18000, 363},
  {1678604400, -14400, 363},
  {1699164000, -18000, 363},
  {1710054000, -14400, 363},
  {1730613600, -18000, 363},
  {1741503600, -14400, 363},
  {1762063200, -18000, 363},
  {1772953200, -14400, 363},
  {1793512800, -18000, 363},
  {1805007600, -14400, 363},
  {1825567200, -18000, 363},
  {1836457200, -14400, 363},
  {1857016800, -18000, 363},
  {1867906800, -14400, 363},
  {1888466400, -18000, 363},
  {1899356400, -14400, 363},
  {1919916000, -18000, 363},
  {1930806000, -14400, 363},
  {1951365600, -18000, 363},
  {1962860400, -14400, 363},
  {1983420000, -18000, 363},
  {1994310000, -14400, 363},
  {2014869600, -18000, 363},
  {2025759600, -14400, 363},
  {2046319200, -18000, 363},
  {2057209200, -14400, 363},
  {2077768800, -18000, 363},
  {2088658800, -14400, 363},
  {2109218400, -18000, 363},
  {2120108400, -14400, 363},
  {2140668000, -18000, 363},
  {INT64_MIN, -27232, 364},
  {-1998663968, -25200, 364},
  {-1632063600, -21600, 364},
  {-1614787200, -25200, 364},
  {-1600614000, -21600, 364},
  {-1596816000, -25200, 364},
  {-1567954800, -21600, 364},
  {-1551628800, -25200, 364},
  {-1536505200, -21600, 364},
  {-1523203200, -25200, 364},
  {-1504450800, -21600, 364},
  {-1491753600, -25200, 364},
  {-1473001200, -21600, 364},
  {-1459699200, -25200, 364},
  {-880210800, -21600, 364},
  {-769395600, -21600, 364},
  {-765388800, -25200, 364},
  {-715791600, -21600, 364},
  {-702489600, -25200, 364},
  {-84380400, -21600, 364},
  {-68659200, -25200, 364},
  {-21481200, -21600, 364},
  {-5760000, -25200, 364},
  {73472400, -21600, 364},
  {89193600, -25200, 364},
  {104922000, -21600, 364},
  {120643200, -25200, 364},
  {136371600, -21600, 364},
  {152092800, -25200, 364},
  {167821200, -21600, 364},
  {183542400, -25200, 364},
  {199270800, -21600, 364},
  {215596800, -25200, 364},
  {230720400, -21600, 364},
  {247046400, -25200, 364},
  {262774800, -21600, 364},
  {278496000, -25200, 364},
  {294224400, -21600, 364},
  {309945600, -25200, 364},
  {325674000, -21600, 364},
  {341395200, -25200, 364},
  {357123600, -21600, 364},
  {372844800, -25200, 364},
  {388573200, -21600, 364},
  {404899200, -25200, 364},
  {420022800, -21600, 364},
  {436348800, -25200, 364},
  {452077200, -21600, 364},
  {467798400, -25200, 364},
  {483526800, -21600, 364},
  {499248000, -25200, 364},
  {514976400, -21600, 364},
  {530697600, -25200, 364},
  {544611600, -21600, 364},
  {562147200, -25200, 364},
  {576061200, -21600, 364},
  {594201600, -25200, 364},
  {607510800, -21600, 364},
  {625651200, -25200, 364},
  {638960400, -21600, 364},
  {657100800, -25200, 364},
  {671014800, -21600, 364},
  {688550400, -25200, 364},
  {702464400, -21600, 364},
  {720000000, -25200, 364},
  {733914000, -21600, 364},
  {752054400, -25200, 364},
  {765363600, -21600, 364},
  {783504000, -25200, 364},
  {796813200, -21600, 364},
  {814953600, -25200, 364},
  {828867600, -21600, 364},
  {846403200, -25200, 364},
  {860317200, -21600, 364},
  {877852800, -25200, 364},
  {891766800, -21600, 364},
  {909302400, -25200, 364},
  {923216400, -21600, 364},
  {941356800, -25200, 364},
  {954666000, -21600, 364},
  {972806400, -25200, 364},
  {986115600, -21600, 364},
  {1004256000, -25200, 364},
  {1018170000, -21600, 364},
  {1035705600, -25200, 364},
  {1049619600, -21600, 364},
  {1067155200, -25200, 364},
  {1081069200, -21600, 364},
  {1099209600, -25200, 364},
  {1112518800, -21600, 364},
  {1130659200, -25200, 364},
  {1143968400, -21600, 364},
  {1162108800, -25200, 364},
  {1173603600, -21600, 364},
  {1194163200, -25200, 364},
  {1205053200, -21600, 364},
  {1225612800, -25200, 364},
  {1236502800, -21600, 364},
  {1257062400, -25200, 364},
  {1268557200, -21600, 364},
  {1289116800, -25200, 364},
  {1300006800, -21600, 364},
  {1320566400, -25200, 364},
  {1331456400, -21600, 364},
  {1352016000, -25200, 364},
  {1362906000, -21600, 364},
  {1383465600, -25200, 364},
  {1394355600, -21600, 364},
  {1414915200, -25200, 364},
  {1425805200, -21600, 364},
  {1446364800, -25200, 364},
  {1457859600, -21600, 364},
  {1478419200, -25200, 364},
  {1489309200, -21600, 364},
  {1509868800, -25200, 364},
  {1520758800, -21600, 364},
  {1541318400, -25200, 364},
  {1552208400, -21600, 364},
  {1572768000, -25200, 364},
  {1583658000, -21600, 364},
  {1604217600, -25200, 364},
  {1615712400, -21600, 364},
  {1636272000, -25200, 364},
  {1647162000, -21600, 364},
  {1667721600, -25200, 364},
  {1678611600, -21600, 364},
  {1699171200, -25200, 364},
  {1710061200, -21600, 364},
  {1730620800, -25200, 364},
  {1741510800, -21600, 364},
  {1762070400, -25200, 364},
  {1772960400, -21600, 364},
  {1793520000, -25200, 364},
  {1805014800, -21600, 364},
  {1825574400, -25200, 364},
  {1836464400, -21600, 364},
  {1857024000, -25200, 364},
  {1867914000, -21600, 364},
  {1888473600, -25200, 364},
  {1899363600, -21600, 364},
  {1919923200, -25200, 364},
  {1930813200, -21600, 364},
  {1951372800, -25200, 364},
  {1962867600, -21600, 364},
  {1983427200, -25200, 364},
  {1994317200, -21600, 364},
  {2014876800, -25200, 364},
  {2025766800, -21600, 364},
  {2046326400, -25200, 364},
  {2057216400, -21600, 364},
  {2077776000, -25200, 364},
  {2088666000, -21600, 364},
  {2109225600, -25200, 364},
  {2120115600, -21600, 364},
  {2140675200, -25200, 364},
  {-1664130548, -9052, 365},
  {-1650137348, -12652, 365},
  {-1632076148, -9052, 365},
  {-1614799748, -12652, 365},
  {-1598650148, -9052, 365},
  {-1590100148, -12652, 365},
  {-1567286948, -9052, 365},
  {-1551565748, -12652, 365},
  {-1535837348, -9052, 365},
  {-1520116148, -12652, 365},
  {-1503782948, -9052, 365},
  {-1488666548, -12652, 365},
  {-1472333348, -9052, 365},
  {-1457216948, -12652, 365},
  {-1440883748, -9052, 365},
  {-1425767348, -12652, 365},
  {-1409434148, -9052, 365},
  {-1394317748, -12652, 365},
  {-1377984548, -9052, 365},
  {-1362263348, -12652, 365},
  {-1346534948, -9052, 365},
  {-1330813748, -12652, 365},
  {-1314480548, -9052, 365},
  {-1299364148, -12652, 365},
  {-1283030948, -9052, 365},
  {-1267914548, -12652, 365},
  {-1251581348, -9052, 365},
  {-1236464948, -12652, 365},
  {-1220131748, -9052, 365},
  {-1205015348, -12652, 365},
  {-1188682148, -9052, 365},
  {-1172960948, -12652, 365},
  {-1156627748, -9052, 365},
  {-1141511348, -12652, 365},
  {-1125178148, -9052, 365},
  {-1110061748, -12652, 365},
  {-1096921748, -12600, 365},
  {-1093728600, -9000, 365},
  {-1078612200, -12600, 365},
  {-1061670600, -9000, 365},
  {-1048973400, -12600, 365},
  {-1030221000, -9000, 365},
  {-1017523800, -12600, 365},
  {-998771400, -9000, 365},
  {-986074200, -12600, 365},
  {-966717000, -9000, 365},
  {-954624600, -12600, 365},
  {-935267400, -9000, 365},
  {-922570200, -12600, 365},
  {-903817800, -9000, 365},
  {-891120600, -12600, 365},
  {-872368200, -9000, 365},
  {-769395600, -9000, 365},
  {-765401400, -12600, 365},
  {-746044200, -9000, 365},
  {-733347000, -12600, 365},
  {-714594600, -9000, 365},
  {-701897400, -12600, 365},
  {-683145000, -9000, 365},
  {-670447800, -12600, 365},
  {-651695400, -9000, 365},
  {-638998200, -12600, 365},
  {-619641000, -9000, 365},
  {-606943800, -12600, 365},
  {-589401000, -9000, 365},
  {-576099000, -12600, 365},
  {-557951400, -9000, 365},
  {-544649400, -12600, 365},
  {-526501800, -9000, 365},
  {-513199800, -12600, 365},
  {-495052200, -9000, 365},
  {-481750200, -12600, 365},
  {-463602600, -9000, 365},
  {-450300600, -12600, 365},
  {-431548200, -9000, 365},
  {-418246200, -12600, 365},
  {-400098600, -9000, 365},
  {-386796600, -12600, 365},
  {-368649000, -9000, 365},
  {-355347000, -12600, 365},
  {-337199400, -9000, 365},
  {-323897400, -12600, 365},
  {-305749800, -9000, 365},
  {-289423800, -12600, 365},
  {-273695400, -9000, 365},
  {-257974200, -12600, 365},
  {-242245800, -9000, 365},
  {-226524600, -12600, 365},
  {-210796200, -9000, 365},
  {-195075000, -12600, 365},
  {-179346600, -9000, 365},
  {-163625400, -12600, 365},
  {-147897000, -9000, 365},
  {-131571000, -12600, 365},
  {-116447400, -9000, 365},
  {-100121400, -12600, 365},
  {-84393000, -9000, 365},
  {-68671800, -12600, 365},
  {-52943400, -9000, 365},
  {-37222200, -12600, 365},
  {-21493800, -9000, 365},
  {-5772600, -12600, 365},
  {9955800, -9000, 365},
  {25677000, -12600, 365},
  {41405400, -9000, 365},
  {57731400, -12600, 365},
  {73459800, -9000, 365},
  {89181000, -12600, 365},
  {104909400, -9000, 365},
  {120630600, -12600, 365},
  {136359000, -9000, 365},
  {152080200, -12600, 365},
  {167808600, -9000, 365},
  {183529800, -12600, 365},
  {199258200, -9000, 365},
  {215584200, -12600, 365},
  {230707800, -9000, 365},
  {247033800, -12600, 365},
  {262762200, -9000, 365},
  {278483400, -12600, 365},
  {294211800, -9000, 365},
  {309933000, -12600, 365},
  {325661400, -9000, 365},
  {341382600, -12600, 365},
  {357111000, -9000, 365},
  {372832200, -12600, 365},
  {388560600, -9000, 365},
  {404886600, -12600, 365},
  {420010200, -9000, 365},
  {436336200, -12600, 365},
  {452064600, -9000, 365},
  {467785800, -12600, 365},
  {483514200, -9000, 365},
  {499235400, -12600, 365},
  {514963800, -9000, 365},
  {530685000, -12600, 365},
  {544591860, -9000, 365},
  {562127460, -12600, 365},
  {576041460, -5400, 365},
  {594178260, -12600, 365},
  {607491060, -9000, 365},
  {625631460, -12600, 365},
  {638940660, -9000, 365},
  {657081060, -12600, 365},
  {670995060, -9000, 365},
  {688530660, -12600, 365},
  {702444660, -9000, 365},
  {719980260, -12600, 365},
  {733894260, -9000, 365},
  {752034660, -12600, 365},
  {765343860, -9000, 365},
  {783484260, -12600, 365},
  {796793460, -9000, 365},
  {814933860, -12600, 365},
  {828847860, -9000, 365},
  {846383460, -12600, 365},
  {860297460, -9000, 365},
  {877833060, -12600, 365},
  {891747060, -9000, 365},
  {909282660, -12600, 365},
  {923196660, -9000, 365},
  {941337060, -12600, 365},
  {954646260, -9000, 365},
  {972786660, -12600, 365},
  {986095860, -9000, 365},
  {1004236260, -12600, 365},
  {1018150260, -9000, 365},
  {1035685860, -12600, 365},
  {1049599860, -9000, 365},
  {1067135460, -12600, 365},
  {1081049460, -9000, 365},
  {1099189860, -12600, 365},
  {1112499060, -9000, 365},
  {1130639460, -12600, 365},
  {1143948660, -9000, 365},
  {1162089060, -12600, 365},
  {1173583860, -9000, 365},
  {1194143460, -12600, 365},
  {1205033460, -9000, 365},
  {1225593060, -12600, 365},
  {1236483060, -9000, 365},
  {1257042660, -12600, 365},
  {1268537460, -9000, 365},
  {1289097060, -12600, 365},
  {1299987060, -9000, 365},
  {1320553800, -12600, 365},
  {1331443800, -9000, 365},
  {1352003400, -12600, 365},
  {1362893400, -9000, 365},
  {1383453000, -12600, 365},
  {1394343000, -9000, 365},
  {1414902600, -12600, 365},
  {1425792600, -9000, 365},
  {1446352200, -12600, 365},
  {1457847000, -9000, 365},
  {1478406600, -12600, 365},
  {1489296600, -9000, 365},
  {1509856200, -12600, 365},
  {1520746200, -9000, 365},
  {1541305800, -12600, 365},
  {1552195800, -9000, 365},
  {1572755400, -12600, 365},
  {1583645400, -9000, 365},
  {1604205000, -12600, 365},
  {1615699800, -9000, 365},
  {1636259400, -12600, 365},
  {1647149400, -9000, 365},
  {1667709000, -12600, 365},
  {1678599000, -9000, 365},
  {1699158600, -12600, 365},
  {1710048600, -9000, 365},
  {1730608200, -12600, 365},
  {1741498200, -9000, 365},
  {1762057800, -12600, 365},
  {1772947800, -9000, 365},
  {1793507400, -12600, 365},
  {1805002200, -9000, 365},
  {1825561800, -12600, 365},
  {1836451800, -9000, 365},
  {1857011400, -12600, 365},
  {1867901400, -9000, 365},
  {1888461000, -12600, 365},
  {1899351000, -9000, 365},
  {1919910600, -12600, 365},
  {1930800600, -9000, 365},
  {1951360200, -12600, 365},
  {1962855000, -9000, 365},
  {1983414600, -12600, 365},
  {1994304600, -9000, 365},
  {2014864200, -12600, 365},
  {2025754200, -9000, 365},
  {2046313800, -12600, 365},
  {2057203800, -9000, 365},
  {2077763400, -12600, 365},
  {2088653400, -9000, 365},
  {2109213000, -12600, 365},
  {2120103000, -9000, 365},
  {2140662600, -12600, 365},
  {-1632060000, -25200, 366},
  {-1614783600, -28800, 366},
  {-880207200, -25200, 366},
  {-769395600, -25200, 366},
  {-765385200, -28800, 366},
  {-747237600, -25200, 366},
  {-732726000, -28800, 366},
  {-715788000, -25200, 366},
  {-702486000, -28800, 366},
  {-684338400, -25200, 366},
  {-671036400, -28800, 366},
  {-652888800, -25200, 366},
  {-639586800, -28800, 366},
  {-620834400, -25200, 366},
  {-608137200, -28800, 366},
  {-589384800, -25200, 366},
  {-576082800, -28800, 366},
  {-557935200, -25200, 366},
  {-544633200, -28800, 366},
  {-526485600, -25200, 366},
  {-513183600, -28800, 366},
  {-495036000, -25200, 366},
  {-481734000, -28800, 366},
  {-463586400, -25200, 366},
  {-450284400, -28800, 366},
  {-431532000, -25200, 366},
  {-418230000, -28800, 366},
  {-400082400, -25200, 366},
  {-386780400, -28800, 366},
  {-368632800, -25200, 366},
  {-355330800, -28800, 366},
  {-337183200, -25200, 366},
  {-323881200, -28800, 366},
  {-305733600, -25200, 366},
  {-292431600, -28800, 366},
  {-273679200, -25200, 366},
  {-260982000, -28800, 366},
  {-242229600, -25200, 366},
  {-226508400, -28800, 366},
  {-210780000, -25200, 366},
  {-195058800, -28800, 366},
  {-179330400, -25200, 366},
  {-163609200, -28800, 366},
  {-147880800, -25200, 366},
  {-131554800, -28800, 366},
  {-116431200, -25200, 366},
  {-100105200, -28800, 366},
  {-84376800, -25200, 366},
  {-68655600, -28800, 366},
  {-52927200, -25200, 366},
  {-37206000, -28800, 366},
  {-21477600, -25200, 366},
  {-5756400, -28800, 366},
  {9972000, -25200, 366},
  {25693200, -28800, 366},
  {41421600, -25200, 366},
  {57747600, -28800, 366},
  {73476000, -25200, 366},
  {89197200, -28800, 366},
  {104925600, -25200, 366},
  {120646800, -28800, 366},
  {136375200, -25200, 366},
  {152096400, -28800, 366},
  {167824800, -25200, 366},
  {183546000, -28800, 366},
  {199274400, -25200, 366},
  {215600400, -28800, 366},
  {230724000, -25200, 366},
  {247050000, -28800, 366},
  {262778400, -25200, 366},
  {278499600, -28800, 366},
  {294228000, -25200, 366},
  {309949200, -28800, 366},
  {325677600, -25200, 366},
  {341398800, -28800, 366},
  {357127200, -25200, 366},
  {372848400, -28800, 366},
  {388576800, -25200, 366},
  {404902800, -28800, 366},
  {420026400, -25200, 366},
  {436352400, -28800, 366},
  {452080800, -25200, 366},
  {467802000, -28800, 366},
  {483530400, -25200, 366},
  {499251600, -28800, 366},
  {514980000, -25200, 366},
  {530701200, -28800, 366},
  {544615200, -25200, 366},
  {562150800, -28800, 366},
  {576064800, -25200, 366},
  {594205200, -28800, 366},
  {607514400, -25200, 366},
  {625654800, -28800, 366},
  {638964000, -25200, 366},
  {657104400, -28800, 366},
  {671018400, -25200, 366},
  {688554000, -28800, 366},
  {702468000, -25200, 366},
  {720003600, -28800, 366},
  {733917600, -25200, 366},
  {752058000, -28800, 366},
  {765367200, -25200, 366},
  {783507600, -28800, 366},
  {796816800, -25200, 366},
  {814957200, -28800, 366},
  {828871200, -25200, 366},
  {846406800, -28800, 366},
  {860320800, -25200, 366},
  {877856400, -28800, 366},
  {891770400, -25200, 366},
  {909306000, -28800, 366},
  {923220000, -25200, 366},
  {941360400, -28800, 366},
  {954669600, -25200, 366},
  {972810000, -28800, 366},
  {986119200, -25200, 366},
  {1004259600, -28800, 366},
  {1018173600, -25200, 366},
  {1035709200, -28800, 366},
  {1049623200, -25200, 366},
  {1067158800, -28800, 366},
  {1081072800, -25200, 366},
  {1099213200, -28800, 366},
  {1112522400, -25200, 366},
  {1130662800, -28800, 366},
  {1143972000, -25200, 366},
  {1162112400, -28800, 366},
  {1173607200, -25200, 366},
  {1194166800, -28800, 366},
  {1205056800, -25200, 366},
  {1225616400, -28800, 366},
  {1236506400, -25200, 366},
  {1257066000, -28800, 366},
  {1268560800, -25200, 366},
  {1289120400, -28800, 366},
  {1300010400, -25200, 366},
  {1320570000, -28800, 366},
  {1331460000, -25200, 366},
  {1352019600, -28800, 366},
  {1362909600, -25200, 366},
  {1383469200, -28800, 366},
  {1394359200, -25200, 366},
  {1414918800, -28800, 366},
  {1425808800, -25200, 366},
  {1446368400, -28800, 366},
  {1457863200, -25200, 366},
  {1478422800, -28800, 366},
  {1489312800, -25200, 366},
  {1509872400, -28800, 366},
  {1520762400, -25200, 366},
  {1541322000, -28800, 366},
  {1552212000, -25200, 366},
  {1572771600, -28800, 366},
  {1583661600, -25200, 366},
  {1604221200, -28800, 366},
  {1615716000, -25200, 366},
  {1636275600, -28800, 366},
  {1647165600, -25200, 366},
  {1667725200, -28800, 366},
  {1678615200, -25200, 366},
  {1699174800, -28800, 366},
  {1710064800, -25200, 366},
  {1730624400, -28800, 366},
  {1741514400, -25200, 366},
  {1762074000, -28800, 366},
  {1772964000, -25200, 366},
  {1793523600, -28800, 366},
  {1805018400, -25200, 366},
  {1825578000, -28800, 366},
  {1836468000, -25200, 366},
  {1857027600, -28800, 366},
  {1867917600, -25200, 366},
  {1888477200, -28800, 366},
  {1899367200, -25200, 366},
  {1919926800, -28800, 366},
  {1930816800, -25200, 366},
  {1951376400, -28800, 366},
  {1962871200, -25200, 366},
  {1983430800, -28800, 366},
  {1994320800, -25200, 366},
  {2014880400, -28800, 366},
  {2025770400, -25200, 366},
  {2046330000, -28800, 366},
  {2057220000, -25200, 366},
  {2077779600, -28800, 366},
  {2088669600, -25200, 366},
  {2109229200, -28800, 366},
  {2120119200, -25200, 366},
  {2140678800, -28800, 366},
  {INT64_MIN, -25116, 367},
  {-2030202084, -25200, 367},
  {-1632063600, -21600, 367},
  {-1614787200, -25200, 367},
  {-1251651600, -21600, 367},
  {-1238349600, -25200, 367},
  {-1220202000, -21600, 367},
  {-1206900000, -25200, 367},
  {-1188752400, -21600, 367},
  {-1175450400, -25200, 367},
  {-1156698000, -21600, 367},
  {-1144000800, -25200, 367},
  {-1125248400, -21600, 367},
  {-1111946400, -25200, 367},
  {-1032714000, -21600, 367},
  {-1016992800, -25200, 367},
  {-1001264400, -21600, 367},
  {-986148000, -25200, 367},
  {-969814800, -21600, 367},
  {-954093600, -25200, 367},
  {-937760400, -21600, 367},
  {-922039200, -25200, 367},
  {-906310800, -21600, 367},
  {-890589600, -25200, 367},
  {-880210800, -21600, 367},
  {-769395600, -21600, 367},
  {-765388800, -25200, 367},
  {-748450800, -21600, 367},
  {-732729600, -25200, 367},
  {-715791600, -21600, 367},
  {-702489600, -25200, 367},
  {-684342000, -21600, 367},
  {-671040000, -25200, 367},
  {-652892400, -21600, 367},
  {-639590400, -25200, 367},
  {-620838000, -21600, 367},
  {-608140800, -25200, 367},
  {-589388400, -21600, 367},
  {-576086400, -25200, 367},
  {-557938800, -21600, 367},
  {-544636800, -25200, 367},
  {-526489200, -21600, 367},
  {-513187200, -25200, 367},
  {-495039600, -21600, 367},
  {-481737600, -25200, 367},
  {-463590000, -21600, 367},
  {-450288000, -25200, 367},
  {-431535600, -21600, 367},
  {-418233600, -25200, 367},
  {-400086000, -21600, 367},
  {-386784000, -25200, 367},
  {-337186800, -21600, 367},
  {-321465600, -25200, 367},
  {-305737200, -21600, 367},
  {-1632056400, -28800, 368},
  {-1615125600, -32400, 368},
  {-1596978000, -28800, 368},
  {-1583164800, -32400, 368},
  {-880203600, -28800, 368},
  {-769395600, -28800, 368},
  {-765381600, -32400, 368},
  {-147884400, -25200, 368},
  {-131554800, -32400, 368},
  {-110552400, -28800, 368},
  {325677600, -25200, 368},
  {341398800, -28800, 368},
  {357127200, -25200, 368},
  {372848400, -28800, 368},
  {388576800, -25200, 368},
  {404902800, -28800, 368},
  {420026400, -25200, 368},
  {436352400, -28800, 368},
  {452080800, -25200, 368},
  {467802000, -28800, 368},
  {483530400, -25200, 368},
  {499251600, -28800, 368},
  {514980000, -25200, 368},
  {530701200, -28800, 368},
  {544615200, -25200, 368},
  {562150800, -28800, 368},
  {576064800, -25200, 368},
  {594205200, -28800, 368},
  {607514400, -25200, 368},
  {625654800, -28800, 368},
  {638964000, -25200, 368},
  {657104400, -28800, 368},
  {671018400, -25200, 368},
  {688554000, -28800, 368},
  {702468000, -25200, 368},
  {720003600, -28800, 368},
  {733917600, -25200, 368},
  {752058000, -28800, 368},
  {765367200, -25200, 368},
  {783507600, -28800, 368},
  {796816800, -25200, 368},
  {814957200, -28800, 368},
  {828871200, -25200, 368},
  {846406800, -28800, 368},
  {860320800, -25200, 368},
  {877856400, -28800, 368},
  {891770400, -25200, 368},
  {909306000, -28800, 368},
  {923220000, -25200, 368},
  {941360400, -28800, 368},
  {954669600, -25200, 368},
  {972810000, -28800, 368},
  {986119200, -25200, 368},
  {1004259600, -28800, 368},
  {1018173600, -25200, 368},
  {1035709200, -28800, 368},
  {1049623200, -25200, 368},
  {1067158800, -28800, 368},
  {1081072800, -25200, 368},
  {1099213200, -28800, 368},
  {1112522400, -25200, 368},
  {1130662800, -28800, 368},
  {1143972000, -25200, 368},
  {1162112400, -28800, 368},
  {1173607200, -25200, 368},
  {1194166800, -28800, 368},
  {1205056800, -25200, 368},
  {1225616400, -28800, 368},
  {1236506400, -25200, 368},
  {1257066000, -28800, 368},
  {1268560800, -25200, 368},
  {1289120400, -28800, 368},
  {1300010400, -25200, 368},
  {1320570000, -28800, 368},
  {1331460000, -25200, 368},
  {1352019600, -28800, 368},
  {1362909600, -25200, 368},
  {1383469200, -28800, 368},
  {1394359200, -25200, 368},
  {1414918800, -28800, 368},
  {1425808800, -25200, 368},
  {1446368400, -28800, 368},
  {1457863200, -25200, 368},
  {1478422800, -28800, 368},
  {1489312800, -25200, 368},
  {1509872400, -28800, 368},
  {1520762400, -25200, 368},
  {1541322000, -28800, 368},
  {1552212000, -25200, 368},
  {1572771600, -28800, 368},
  {1583661600, -25200, 368},
  {1604221200, -28800, 368},
  {1615716000, -25200, 368},
  {1636275600, -28800, 368},
  {1647165600, -25200, 368},
  {1667725200, -28800, 368},
  {1678615200, -25200, 368},
  {1699174800, -28800, 368},
  {1710064800, -25200, 368},
  {1730624400, -28800, 368},
  {1741514400, -25200, 368},
  {1762074000, -28800, 368},
  {1772964000, -25200, 368},
  {1793523600, -28800, 368},
  {1805018400, -25200, 368},
  {1825578000, -28800, 368},
  {1836468000, -25200, 368},
  {1857027600, -28800, 368},
  {1867917600, -25200, 368},
  {1888477200, -28800, 368},
  {1899367200, -25200, 368},
  {1919926800, -28800, 368},
  {1930816800, -25200, 368},
  {1951376400, -28800, 368},
  {1962871200, -25200, 368},
  {1983430800, -28800, 368},
  {1994320800, -25200, 368},
  {2014880400, -28800, 368},
  {2025770400, -25200, 368},
  {2046330000, -28800, 368},
  {2057220000, -25200, 368},
  {2077779600, -28800, 368},
  {2088669600, -25200, 368},
  {2109229200, -28800, 368},
  {2120119200, -25200, 368},
  {2140678800, -28800, 368},
  {-1893439034, -18000, 369},
  {-1688410800, -16966, 369},
  {-1619983034, -14400, 369},
  {-1593806400, -16966, 369},
  {-1335986234, -14400, 369},
  {-1317585600, -18000, 369},
  {-1304362800, -14400, 369},
  {-1286049600, -18000, 369},
  {-1272826800, -14400, 369},
  {-1254513600, -18000, 369},
  {-1241290800, -14400, 369},
  {-1222977600, -18000, 369},
  {-1209754800, -14400, 369},
  {-1191355200, -18000, 369},
  {-1178132400, -14400, 369},
  {-870552000, -18000, 369},
  {-865278000, -14400, 369},
  {-736376400, -18000, 369},
  {-713646000, -14400, 369},
  {-36619200, -10800, 369},
  {-23922000, -14400, 369},
  {-3355200, -10800, 369},
  {7527600, -14400, 369},
  {24465600, -10800, 369},
  {37767600, -14400, 369},
  {55915200, -10800, 369},
  {69217200, -14400, 369},
  {87969600, -10800, 369},
  {100666800, -14400, 369},
  {118209600, -10800, 369},
  {132116400, -14400, 369},
  {150868800, -10800, 369},
  {163566000, -14400, 369},
  {182318400, -10800, 369},
  {195620400, -14400, 369},
  {213768000, -10800, 369},
  {227070000, -14400, 369},
  {245217600, -10800, 369},
  {258519600, -14400, 369},
  {277272000, -10800, 369},
  {289969200, -14400, 369},
  {308721600, -10800, 369},
  {321418800, -14400, 369},
  {340171200, -10800, 369},
  {353473200, -14400, 369},
  {371620800, -10800, 369},
  {384922800, -14400, 369},
  {403070400, -10800, 369},
  {416372400, -14400, 369},
  {434520000, -10800, 369},
  {447822000, -14400, 369},
  {466574400, -10800, 369},
  {479271600, -14400, 369},
  {498024000, -10800, 369},
  {510721200, -14400, 369},
  {529473600, -10800, 369},
  {545194800, -14400, 369},
  {560923200, -10800, 369},
  {574225200, -14400, 369},
  {591768000, -10800, 369},
  {605674800, -14400, 369},
  {624427200, -10800, 369},
  {637729200, -14400, 369},
  {653457600, -10800, 369},
  {668574000, -14400, 369},
  {687326400, -10800, 369},
  {700628400, -14400, 369},
  {718776000, -10800, 369},
  {732078000, -14400, 369},
  {750225600, -10800, 369},
  {763527600, -14400, 369},
  {781675200, -10800, 369},
  {794977200, -14400, 369},
  {813729600, -10800, 369},
  {826426800, -14400, 369},
  {845179200, -10800, 369},
  {859690800, -14400, 369},
  {876628800, -10800, 369},
  {889930800, -14400, 369},
  {906868800, -10800, 369},
  {923194800, -14400, 369},
  {939528000, -10800, 369},
  {952830000, -14400, 369},
  {971582400, -10800, 369},
  {984279600, -14400, 369},
  {1003032000, -10800, 369},
  {1015729200, -14400, 369},
  {1034481600, -10800, 369},
  {1047178800, -14400, 369},
  {1065931200, -10800, 369},
  {1079233200, -14400, 369},
  {1097380800, -10800, 369},
  {1110682800, -14400, 369},
  {1128830400, -10800, 369},
  {1142132400, -14400, 369},
  {1160884800, -10800, 369},
  {1173582000, -14400, 369},
  {1192334400, -10800, 369},
  {1206846000, -14400, 369},
  {1223784000, -10800, 369},
  {1237086000, -14400, 369},
  {1255233600, -10800, 369},
  {1270350000, -14400, 369},
  {1286683200, -10800, 369},
  {1304823600, -14400, 369},
  {1313899200, -10800, 369},
  {1331434800, -14400, 369},
  {1350187200, -10800, 369},
  {1362884400, -14400, 369},
  {1381636800, -10800, 369},
  {1394334000, -14400, 369},
  {1413086400, -10800, 369},
  {1426388400, -14400, 369},
  {1444536000, -10800, 369},
  {1457838000, -14400, 369},
  {1475985600, -10800, 369},
  {1489287600, -14400, 369},
  {1508040000, -10800, 369},
  {1520737200, -14400, 369},
  {1539489600, -10800, 369},
  {1552186800, -14400, 369},
  {1570939200, -10800, 369},
  {1584241200, -14400, 369},
  {1602388800, -10800, 369},
  {1615690800, -14400, 369},
  {1633838400, -10800, 369},
  {1647140400, -14400, 369},
  {1665288000, -10800, 369},
  {1678590000, -14400, 369},
  {1697342400, -10800, 369},
  {1710039600, -14400, 369},
  {1728792000, -10800, 369},
  {1741489200, -14400, 369},
  {1760241600, -10800, 369},
  {1773543600, -14400, 369},
  {1791691200, -10800, 369},
  {1804993200, -14400, 369},
  {1823140800, -10800, 369},
  {1836442800, -14400, 369},
  {1855195200, -10800, 369},
  {1867892400, -14400, 369},
  {1886644800, -10800, 369},
  {1899342000, -14400, 369},
  {1918094400, -10800, 369},
  {1930791600, -14400, 369},
  {1949544000, -10800, 369},
  {1962846000, -14400, 369},
  {1980993600, -10800, 369},
  {1994295600, -14400, 369},
  {2012443200, -10800, 369},
  {2025745200, -14400, 369},
  {2044497600, -10800, 369},
  {2057194800, -14400, 369},
  {2075947200, -10800, 369},
  {2088644400, -14400, 369},
  {2107396800, -10800, 369},
  {2120698800, -14400, 369},
  {2138846400, -10800, 369},
  {INT64_MIN, -26248, 370},
  {-1178124152, -21600, 370},
  {-870552000, -25200, 370},
  {-865278000, -21600, 370},
  {-736376400, -25200, 370},
  {-36619200, -21600, 370},
  {-23922000, -25200, 370},
  {-3355200, -21600, 370},
  {7527600, -25200, 370},
  {24465600, -21600, 370},
  {37767600, -25200, 370},
  {55915200, -21600, 370},
  {69217200, -25200, 370},
  {87969600, -21600, 370},
  {100666800, -25200, 370},
  {118209600, -21600, 370},
  {132116400, -25200, 370},
  {150868800, -21600, 370},
  {163566000, -25200, 370},
  {182318400, -21600, 370},
  {195620400, -25200, 370},
  {213768000, -21600, 370},
  {227070000, -25200, 370},
  {245217600, -21600, 370},
  {258519600, -25200, 370},
  {277272000, -21600, 370},
  {289969200, -25200, 370},
  {308721600, -21600, 370},
  {321418800, -25200, 370},
  {340171200, -21600, 370},
  {353473200, -25200, 370},
  {371620800, -21600, 370},
  {384922800, -21600, 370},
  {403070400, -18000, 370},
  {416372400, -21600, 370},
  {434520000, -18000, 370},
  {447822000, -21600, 370},
  {466574400, -18000, 370},
  {479271600, -21600, 370},
  {498024000, -18000, 370},
  {510721200, -21600, 370},
  {529473600, -18000, 370},
  {545194800, -21600, 370},
  {560923200, -18000, 370},
  {574225200, -21600, 370},
  {591768000, -18000, 370},
  {605674800, -21600, 370},
  {624427200, -18000, 370},
  {637729200, -21600, 370},
  {653457600, -18000, 370},
  {668574000, -21600, 370},
  {687326400, -18000, 370},
  {700628400, -21600, 370},
  {718776000, -18000, 370},
  {732078000, -21600, 370},
  {750225600, -18000, 370},
  {763527600, -21600, 370},
  {781675200, -18000, 370},
  {794977200, -21600, 370},
  {813729600, -18000, 370},
  {826426800, -21600, 370},
  {845179200, -18000, 370},
  {859690800, -21600, 370},
  {876628800, -18000, 370},
  {889930800, -21600, 370},
  {906868800, -18000, 370},
  {923194800, -21600, 370},
  {939528000, -18000, 370},
  {952830000, -21600, 370},
  {971582400, -18000, 370},
  {984279600, -21600, 370},
  {1003032000, -18000, 370},
  {1015729200, -21600, 370},
  {1034481600, -18000, 370},
  {1047178800, -21600, 370},
  {1065931200, -18000, 370},
  {1079233200, -21600, 370},
  {1097380800, -18000, 370},
  {1110682800, -21600, 370},
  {1128830400, -18000, 370},
  {1142132400, -21600, 370},
  {1160884800, -18000, 370},
  {1173582000, -21600, 370},
  {1192334400, -18000, 370},
  {1206846000, -21600, 370},
  {1223784000, -18000, 370},
  {1237086000, -21600, 370},
  {1255233600, -18000, 370},
  {1270350000, -21600, 370},
  {1286683200, -18000, 370},
  {1304823600, -21600, 370},
  {1313899200, -18000, 370},
  {1331434800, -21600, 370},
  {1350187200, -18000, 370},
  {1362884400, -21600, 370},
  {1381636800, -18000, 370},
  {1394334000, -21600, 370},
  {1413086400, -18000, 370},
  {1426388400, -21600, 370},
  {1444536000, -18000, 370},
  {1457838000, -21600, 370},
  {1475985600, -18000, 370},
  {1489287600, -21600, 370},
  {1508040000, -18000, 370},
  {1520737200, -21600, 370},
  {1539489600, -18000, 370},
  {1552186800, -21600, 370},
  {1570939200, -18000, 370},
  {1584241200, -21600, 370},
  {1602388800, -18000, 370},
  {1615690800, -21600, 370},
  {1633838400, -18000, 370},
  {1647140400, -21600, 370},
  {1665288000, -18000, 370},
  {1678590000, -21600, 370},
  {1697342400, -18000, 370},
  {1710039600, -21600, 370},
  {1728792000, -18000, 370},
  {1741489200, -21600, 370},
  {1760241600, -18000, 370},
  {1773543600, -21600, 370},
  {1791691200, -18000, 370},
  {1804993200, -21600, 370},
  {1823140800, -18000, 370},
  {1836442800, -21600, 370},
  {1855195200, -18000, 370},
  {1867892400, -21600, 370},
  {1886644800, -18000, 370},
  {1899342000, -21600, 370},
  {1918094400, -18000, 370},
  {1930791600, -21600, 370},
  {1949544000, -18000, 370},
  {1962846000, -21600, 370},
  {1980993600, -18000, 370},
  {1994295600, -21600, 370},
  {2012443200, -18000, 370},
  {2025745200, -21600, 370},
  {2044497600, -18000, 370},
  {2057194800, -21600, 370},
  {2075947200, -18000, 370},
  {2088644400, -21600, 370},
  {2107396800, -18000, 370},
  {2120698800, -21600, 370},
  {2138846400, -18000, 370},
  {INT64_MIN, -19776, 371},
  {-1402813824, -18000, 371},
  {-1311534000, -14400, 371},
  {-1300996800, -18000, 371},
  {-933534000, -14400, 371},
  {-925675200, -18000, 371},
  {-902084400, -14400, 371},
  {-893620800, -18000, 371},
  {-870030000, -14400, 371},
  {-862171200, -18000, 371},
  {-775681200, -14400, 371},
  {-767822400, -18000, 371},
  {-744231600, -14400, 371},
  {-736372800, -18000, 371},
  {-144702000, -14400, 371},
  {-134251200, -18000, 371},
  {-113425200, -14400, 371},
  {-102542400, -18000, 371},
  {-86295600, -14400, 371},
  {-72907200, -18000, 371},
  {-54154800, -14400, 371},
  {-41457600, -18000, 371},
  {-21495600, -14400, 371},
  {-5774400, -18000, 371},
  {9954000, -14400, 371},
  {25675200, -18000, 371},
  {41403600, -14400, 371},
  {57729600, -18000, 371},
  {73458000, -14400, 371},
  {87364800, -18000, 371},
  {104907600, -14400, 371},
  {118900800, -18000, 371},
  {136357200, -14400, 371},
  {150436800, -18000, 371},
  {167806800, -14400, 371},
  {183528000, -18000, 371},
  {199256400, -14400, 371},
  {215582400, -18000, 371},
  {230706000, -14400, 371},
  {247032000, -18000, 371},
  {263365200, -14400, 371},
  {276667200, -18000, 371},
  {290581200, -14400, 371},
  {308721600, -18000, 371},
  {322030800, -14400, 371},
  {340171200, -18000, 371},
  {358318800, -14400, 371},
  {371620800, -18000, 371},
  {389768400, -14400, 371},
  {403070400, -18000, 371},
  {421218000, -14400, 371},
  {434520000, -18000, 371},
  {452667600, -14400, 371},
  {466574400, -18000, 371},
  {484117200, -14400, 371},
  {498024000, -18000, 371},
  {511333200, -14400, 371},
  {529473600, -18000, 371},
  {542782800, -14400, 371},
  {560923200, -18000, 371},
  {574837200, -14400, 371},
  {592372800, -18000, 371},
  {606286800, -14400, 371},
  {623822400, -18000, 371},
  {638946000, -14400, 371},
  {655876800, -18000, 371},
  {671000400, -14400, 371},
  {687330000, -18000, 371},
  {702450000, -14400, 371},
  {718779600, -18000, 371},
  {733899600, -14400, 371},
  {750229200, -18000, 371},
  {765349200, -14400, 371},
  {781678800, -18000, 371},
  {796798800, -14400, 371},
  {813128400, -18000, 371},
  {828853200, -14400, 371},
  {844578000, -18000, 371},
  {860302800, -14400, 371},
  {876632400, -18000, 371},
  {891147600, -14400, 371},
  {909291600, -18000, 371},
  {922597200, -14400, 371},
  {941346000, -18000, 371},
  {954651600, -14400, 371},
  {972795600, -18000, 371},
  {986101200, -14400, 371},
  {1004245200, -18000, 371},
  {1018155600, -14400, 371},
  {1035694800, -18000, 371},
  {1049605200, -14400, 371},
  {1067144400, -18000, 371},
  {1081054800, -14400, 371},
  {1162098000, -18000, 371},
  {1173589200, -14400, 371},
  {1193547600, -18000, 371},
  {1205643600, -14400, 371},
  {1224997200, -18000, 371},
  {1236488400, -14400, 371},
  {1256446800, -18000, 371},
  {1268542800, -14400, 371},
  {1288501200, -18000, 371},
  {1300597200, -14400, 371},
  {1319950800, -18000, 371},
  {1331442000, -14400, 371},
  {1351400400, -18000, 371},
  {1362891600, -14400, 371},
  {1382850000, -18000, 371},
  {1394341200, -14400, 371},
  {1414299600, -18000, 371},
  {1425790800, -14400, 371},
  {1445749200, -18000, 371},
  {1457845200, -14400, 371},
  {1477803600, -18000, 371},
  {1489294800, -14400, 371},
  {1509253200, -18000, 371},
  {1520744400, -14400, 371},
  {1540702800, -18000, 371},
  {1552194000, -14400, 371},
  {1572152400, -18000, 371},
  {1583643600, -14400, 371},
  {1603602000, -18000, 371},
  {1615698000, -14400, 371},
  {1635656400, -18000, 371},
  {1647147600, -14400, 371},
  {1667106000, -18000, 371},
  {1678597200, -14400, 371},
  {1698555600, -18000, 371},
  {1710046800, -14400, 371},
  {1730005200, -18000, 371},
  {1741496400, -14400, 371},
  {1761454800, -18000, 371},
  {1772946000, -14400, 371},
  {1792904400, -18000, 371},
  {1805000400, -14400, 371},
  {1824958800, -18000, 371},
  {1836450000, -14400, 371},
  {1856408400, -18000, 371},
  {1867899600, -14400, 371},
  {1887858000, -18000, 371},
  {1899349200, -14400, 371},
  {1919307600, -18000, 371},
  {1930798800, -14400, 371},
  {1950757200, -18000, 371},
  {1962853200, -14400, 371},
  {1982811600, -18000, 371},
  {1994302800, -14400, 371},
  {2014261200, -18000, 371},
  {2025752400, -14400, 371},
  {2045710800, -18000, 371},
  {2057202000, -14400, 371},
  {2077160400, -18000, 371},
  {2088651600, -14400, 371},
  {2108610000, -18000, 371},
  {2120101200, -14400, 371},
  {2140059600, -18000, 371},
  {228877200, 10800, 372},
  {243997200, 7200, 372},
  {260326800, 10800, 372},
  {276051600, 7200, 372},
  {291776400, 10800, 372},
  {307501200, 7200, 372},
  {323830800, 10800, 372},
  {338950800, 7200, 372},
  {354675600, 10800, 372},
  {370400400, 7200, 372},
  {386125200, 10800, 372},
  {401850000, 7200, 372},
  {417574800, 10800, 372},
  {433299600, 7200, 372},
  {449024400, 10800, 372},
  {465354000, 7200, 372},
  {481078800, 10800, 372},
  {496803600, 7200, 372},
  {512528400, 10800, 372},
  {528253200, 7200, 372},
  {543978000, 10800, 372},
  {559702800, 7200, 372},
  {575427600, 10800, 372},
  {591152400, 7200, 372},
  {606877200, 10800, 372},
  {622602000, 7200, 372},
  {638326800, 10800, 372},
  {654656400, 7200, 372},
  {670381200, 10800, 372},
  {686106000, 7200, 372},
  {701830800, 10800, 372},
  {717555600, 7200, 372},
  {733280400, 10800, 372},
  {749005200, 7200, 372},
  {764730000, 10800, 372},
  {780454800, 7200, 372},
  {796179600, 10800, 372},
  {811904400, 7200, 372},
  {828234000, 10800, 372},
  {846378000, 7200, 372},
  {859683600, 10800, 372},
  {877827600, 7200, 372},
  {891133200, 10800, 372},
  {909277200, 7200, 372},
  {922582800, 10800, 372},
  {941331600, 7200, 372},
  {954032400, 10800, 372},
  {972781200, 7200, 372},
  {985482000, 10800, 372},
  {1004230800, 7200, 372},
  {1017536400, 10800, 372},
  {1035680400, 7200, 372},
  {1048986000, 10800, 372},
  {1067130000, 7200, 372},
  {1080435600, 10800, 372},
  {1099184400, 7200, 372},
  {1111885200, 10800, 372},
  {1130634000, 7200, 372},
  {1143334800, 10800, 372},
  {1162083600, 7200, 372},
  {1174784400, 10800, 372},
  {1193533200, 7200, 372},
  {1206838800, 10800, 372},
  {1224982800, 7200, 372},
  {1238288400, 10800, 372},
  {1256432400, 7200, 372},
  {1269738000, 10800, 372},
  {1288486800, 7200, 372},
  {1301187600, 10800, 372},
  {1319936400, 7200, 372},
  {1332637200, 10800, 372},
  {1351386000, 7200, 372},
  {1364691600, 10800, 372},
  {1382835600, 7200, 372},
  {1396141200, 10800, 372},
  {1414285200, 7200, 372},
  {1427590800, 10800, 372},
  {1445734800, 7200, 372},
  {1459040400, 10800, 372},
  {1477789200, 7200, 372},
  {1490490000, 10800, 372},
  {1509238800, 7200, 372},
  {1521939600, 10800, 372},
  {1540688400, 7200, 372},
  {1553994000, 10800, 372},
  {1572138000, 7200, 372},
  {1585443600, 10800, 372},
  {1603587600, 7200, 372},
  {1616893200, 10800, 372},
  {1635642000, 7200, 372},
  {1648342800, 10800, 372},
  {1667091600, 7200, 372},
  {1679792400, 10800, 372},
  {1698541200, 7200, 372},
  {1711846800, 10800, 372},
  {1729990800, 7200, 372},
  {1743296400, 10800, 372},
  {1761440400, 7200, 372},
  {1774746000, 10800, 372},
  {1792890000, 7200, 372},
  {1806195600, 10800, 372},
  {1824944400, 7200, 372},
  {1837645200, 10800, 372},
  {1856394000, 7200, 372},
  {1869094800, 10800, 372},
  {1887843600, 7200, 372},
  {1901149200, 10800, 372},
  {1919293200, 7200, 372},
  {1932598800, 10800, 372},
  {1950742800, 7200, 372},
  {1964048400, 10800, 372},
  {1982797200, 7200, 372},
  {1995498000, 10800, 372},
  {2014246800, 7200, 372},
  {2026947600, 10800, 372},
  {2045696400, 7200, 372},
  {2058397200, 10800, 372},
  {2077146000, 7200, 372},
  {2090451600, 10800, 372},
  {2108595600, 7200, 372},
  {2121901200, 10800, 372},
  {2140045200, 7200, 372},
  {INT64_MIN, -18000, 373},
  {-1633280400, -14400, 374},
  {-1615140000, -18000, 374},
  {-1601830800, -14400, 374},
  {-1583690400, -18000, 374},
  {-880218000, -14400, 374},
  {-769395600, -14400, 374},
  {-765396000, -18000, 374},
  {-84387600, -14400, 374},
  {-68666400, -18000, 374},
  {-52938000, -14400, 374},
  {-37216800, -18000, 374},
  {-21488400, -14400, 374},
  {-5767200, -18000, 374},
  {9961200, -14400, 374},
  {25682400, -18000, 374},
  {41410800, -14400, 374},
  {57736800, -18000, 374},
  {73465200, -14400, 374},
  {89186400, -18000, 374},
  {104914800, -14400, 374},
  {120636000, -18000, 374},
  {126687600, -14400, 374},
  {152085600, -18000, 374},
  {162370800, -14400, 374},
  {183535200, -18000, 374},
  {199263600, -14400, 374},
  {215589600, -18000, 374},
  {230713200, -14400, 374},
  {247039200, -18000, 374},
  {262767600, -14400, 374},
  {278488800, -18000, 374},
  {294217200, -14400, 374},
  {309938400, -18000, 374},
  {325666800, -14400, 374},
  {341388000, -18000, 374},
  {357116400, -14400, 374},
  {372837600, -18000, 374},
  {388566000, -14400, 374},
  {404892000, -18000, 374},
  {420015600, -14400, 374},
  {436341600, -18000, 374},
  {452070000, -14400, 374},
  {467791200, -18000, 374},
  {483519600, -14400, 374},
  {499240800, -18000, 374},
  {514969200, -14400, 374},
  {530690400, -18000, 374},
  {544604400, -14400, 374},
  {562140000, -18000, 374},
  {576054000, -14400, 374},
  {594194400, -18000, 374},
  {607503600, -14400, 374},
  {625644000, -18000, 374},
  {638953200, -14400, 374},
  {657093600, -18000, 374},
  {671007600, -14400, 374},
  {688543200, -18000, 374},
  {702457200, -14400, 374},
  {719992800, -18000, 374},
  {733906800, -14400, 374},
  {752047200, -18000, 374},
  {765356400, -14400, 374},
  {783496800, -18000, 374},
  {796806000, -14400, 374},
  {814946400, -18000, 374},
  {828860400, -14400, 374},
  {846396000, -18000, 374},
  {860310000, -14400, 374},
  {877845600, -18000, 374},
  {891759600, -14400, 374},
  {909295200, -18000, 374},
  {923209200, -14400, 374},
  {941349600, -18000, 374},
  {954658800, -14400, 374},
  {972799200, -18000, 374},
  {986108400, -14400, 374},
  {1004248800, -18000, 374},
  {1018162800, -14400, 374},
  {1035698400, -18000, 374},
  {1049612400, -14400, 374},
  {1067148000, -18000, 374},
  {1081062000, -14400, 374},
  {1099202400, -18000, 374},
  {1112511600, -14400, 374},
  {1130652000, -18000, 374},
  {1143961200, -14400, 374},
  {1162101600, -18000, 374},
  {1173596400, -14400, 374},
  {1194156000, -18000, 374},
  {1205046000, -14400, 374},
  {1225605600, -18000, 374},
  {1236495600, -14400, 374},
  {1257055200, -18000, 374},
  {1268550000, -14400, 374},
  {1289109600, -18000, 374},
  {1299999600, -14400, 374},
  {1320559200, -18000, 374},
  {1331449200, -14400, 374},
  {1352008800, -18000, 374},
  {1362898800, -14400, 374},
  {1383458400, -18000, 374},
  {1394348400, -14400, 374},
  {1414908000, -18000, 374},
  {1425798000, -14400, 374},
  {1446357600, -18000, 374},
  {1457852400, -14400, 374},
  {1478412000, -18000, 374},
  {1489302000, -14400, 374},
  {1509861600, -18000, 374},
  {1520751600, -14400, 374},
  {1541311200, -18000, 374},
  {1552201200, -14400, 374},
  {1572760800, -18000, 374},
  {1583650800, -14400, 374},
  {1604210400, -18000, 374},
  {1615705200, -14400, 374},
  {1636264800, -18000, 374},
  {1647154800, -14400, 374},
  {1667714400, -18000, 374},
  {1678604400, -14400, 374},
  {1699164000, -18000, 374},
  {1710054000, -14400, 374},
  {1730613600, -18000, 374},
  {1741503600, -14400, 374},
  {1762063200, -18000, 374},
  {1772953200, -14400, 374},
  {1793512800, -18000, 374},
  {1805007600, -14400, 374},
  {1825567200, -18000, 374},
  {1836457200, -14400, 374},
  {1857016800, -18000, 374},
  {1867906800, -14400, 374},
  {1888466400, -18000, 374},
  {1899356400, -14400, 374},
  {1919916000, -18000, 374},
  {1930806000, -14400, 374},
  {1951365600, -18000, 374},
  {1962860400, -14400, 374},
  {1983420000, -18000, 374},
  {1994310000, -14400, 374},
  {2014869600, -18000, 374},
  {2025759600, -14400, 374},
  {2046319200, -18000, 374},
  {2057209200, -14400, 374},
  {2077768800, -18000, 374},
  {2088658800, -14400, 374},
  {2109218400, -18000, 374},
  {2120108400, -14400, 374},
  {2140668000, -18000, 374},
  {-929844000, 10800, 375},
  {-923108400, 7200, 375},
  {-906170400, 10800, 375},
  {-892868400, 7200, 375},
  {-875844000, 10800, 375},
  {-857790000, 7200, 375},
  {-844308000, 10800, 375},
  {-825822000, 7200, 375},
  {-812685600, 10800, 375},
  {-794199600, 7200, 375},
  {-779853600, 10800, 375},
  {-762663600, 7200, 375},
  {-399088800, 10800, 375},
  {-386650800, 7200, 375},
  {-368330400, 10800, 375},
  {-355114800, 7200, 375},
  {-336790800, 10800, 375},
  {-323654400, 7200, 375},
  {-305168400, 10800, 375},
  {-292032000, 7200, 375},
  {-273632400, 10800, 375},
  {-260496000, 7200, 375},
  {-242096400, 10800, 375},
  {-228960000, 7200, 375},
  {-210560400, 10800, 375},
  {-197424000, 7200, 375},
  {-178938000, 10800, 375},
  {-165801600, 7200, 375},
  {-147402000, 10800, 375},
  {-134265600, 7200, 375},
  {-115866000, 10800, 375},
  {-102643200, 7200, 375},
  {-84330000, 10800, 375},
  {-71107200, 7200, 375},
  {-52707600, 10800, 375},
  {-39484800, 7200, 375},
  {-21171600, 10800, 375},
  {-7948800, 7200, 375},
  {10364400, 10800, 375},
  {23587200, 7200, 375},
  {41900400, 10800, 375},
  {55123200, 7200, 375},
  {73522800, 10800, 375},
  {86745600, 7200, 375},
  {105058800, 10800, 375},
  {118281600, 7200, 375},
  {136594800, 10800, 375},
  {149817600, 7200, 375},
  {168130800, 10800, 375},
  {181353600, 7200, 375},
  {199753200, 10800, 375},
  {212976000, 7200, 375},
  {231289200, 10800, 375},
  {244512000, 7200, 375},
  {262825200, 10800, 375},
  {276048000, 7200, 375},
  {294361200, 10800, 375},
  {307584000, 7200, 375},
  {325983600, 10800, 375},
  {339206400, 7200, 375},
  {357519600, 10800, 375},
  {370742400, 7200, 375},
  {396399600, 10800, 375},
  {402278400, 7200, 375},
  {426812400, 10800, 375},
  {433814400, 7200, 375},
  {452214000, 10800, 375},
  {465436800, 7200, 375},
  {483750000, 10800, 375},
  {496972800, 7200, 375},
  {515286000, 10800, 375},
  {528508800, 7200, 375},
  {546822000, 10800, 375},
  {560044800, 7200, 375},
  {578444400, 10800, 375},
  {591667200, 7200, 375},
  {610412400, 10800, 375},
  {623203200, 7200, 375},
  {641516400, 10800, 375},
  {654739200, 7200, 375},
  {673052400, 10800, 375},
  {686275200, 7200, 375},
  {704674800, 10800, 375},
  {717897600, 7200, 375},
  {736210800, 10800, 375},
  {749433600, 7200, 375},
  {767746800, 10800, 375},
  {780969600, 7200, 375},
  {799020000, 10800, 375},
  {812322000, 7200, 375},
  {830469600, 10800, 375},
  {843771600, 7200, 375},
  {861919200, 10800, 375},
  {875221200, 7200, 375},
  {893368800, 10800, 375},
  {906670800, 7200, 375},
  {925423200, 10800, 375},
  {938725200, 7200, 375},
  {956872800, 10800, 375},
  {970174800, 7200, 375},
  {988322400, 10800, 375},
  {1001624400, 7200, 375},
  {1019772000, 10800, 375},
  {1033074000, 7200, 375},
  {1051221600, 10800, 375},
  {1064523600, 7200, 375},
  {1083276000, 10800, 375},
  {1096578000, 7200, 375},
  {1114725600, 10800, 375},
  {1128027600, 7200, 375},
  {1146175200, 10800, 375},
  {1158872400, 7200, 375},
  {1177624800, 10800, 375},
  {1189112400, 7200, 375},
  {1209074400, 10800, 375},
  {1219957200, 7200, 375},
  {1240524000, 10800, 375},
  {1250802000, 7200, 375},
  {1272578400, 10800, 375},
  {1281474000, 7200, 375},
  {1284069600, 10800, 375},
  {1285880400, 7200, 375},
  {INT64_MIN, -1521, 376},
  {-1691962479, 2079, 376},
  {-1680471279, 0, 376},
  {-1664143200, 3600, 376},
  {-1650146400, 0, 376},
  {-1633903200, 3600, 376},
  {-1617487200, 0, 376},
  {-1601848800, 3600, 376},
  {-1586037600, 0, 376},
  {-1570399200, 3600, 376},
  {-1552168800, 0, 376},
  {-1538344800, 3600, 376},
  {-1522533600, 0, 376},
  {-1517011200, 0, 376},
  {-1507500000, 3600, 376},
  {-1490565600, 0, 376},
  {-1473631200, 3600, 376},
  {-1460930400, 0, 376},
  {-1442786400, 3600, 376},
  {-1428876000, 0, 376},
  {-1410732000, 3600, 376},
  {-1396216800, 0, 376},
  {-1379282400, 3600, 376},
  {-1364767200, 0, 376},
  {-1348437600, 3600, 376},
  {-1333317600, 0, 376},
  {-1315778400, 3600, 376},
  {-1301263200, 0, 376},
  {-1284328800, 3600, 376},
  {-1269813600, 0, 376},
  {-1253484000, 3600, 376},
  {-1238364000, 0, 376},
  {-1221429600, 3600, 376},
  {-1206914400, 0, 376},
  {-1189980000, 3600, 376},
  {-1175464800, 0, 376},
  {-1159135200, 3600, 376},
  {-1143410400, 0, 376},
  {-1126476000, 3600, 376},
  {-1111960800, 0, 376},
  {-1095631200, 3600, 376},
  {-1080511200, 0, 376},
  {-1063576800, 3600, 376},
  {-1049061600, 0, 376},
  {-1032127200, 3600, 376},
  {-1017612000, 0, 376},
  {-1001282400, 3600, 376},
  {-986162400, 0, 376},
  {-969228000, 3600, 376},
  {-950479200, 0, 376},
  {-942012000, 3600, 376},
  {-733359600, 0, 376},
  {-719445600, 3600, 376},
  {-699490800, 0, 376},
  {-684972000, 3600, 376},
  {-668037600, 0, 376},
  {-654732000, 3600, 376},
  {-636588000, 0, 376},
  {-622072800, 3600, 376},
  {-605743200, 0, 376},
  {-590623200, 3600, 376},
  {-574293600, 0, 376},
  {-558568800, 3600, 376},
  {-542239200, 0, 376},
  {-527119200, 3600, 376},
  {-512604000, 0, 376},
  {-496274400, 3600, 376},
  {-481154400, 0, 376},
  {-464220000, 3600, 376},
  {-449704800, 0, 376},
  {-432165600, 3600, 376},
  {-417650400, 0, 376},
  {-401320800, 3600, 376},
  {-386200800, 0, 376},
  {-369266400, 3600, 376},
  {-354751200, 0, 376},
  {-337816800, 3600, 376},
  {-323301600, 0, 376},
  {-306972000, 3600, 376},
  {-291852000, 0, 376},
  {-276732000, 3600, 376},
  {-257983200, 0, 376},
  {-245282400, 3600, 376},
  {-226533600, 0, 376},
  {-213228000, 3600, 376},
  {-195084000, 0, 376},
  {-182383200, 3600, 376},
  {-163634400, 0, 376},
  {-150933600, 3600, 376},
  {-132184800, 0, 376},
  {-119484000, 3600, 376},
  {-100735200, 0, 376},
  {-88034400, 3600, 376},
  {-68680800, 0, 376},
  {-59004000, 3600, 376},
  {-37242000, 3600, 376},
  {57722400, 0, 376},
  {69818400, 3600, 376},
  {89172000, 0, 376},
  {101268000, 3600, 376},
  {120621600, 0, 376},
  {132717600, 3600, 376},
  {152071200, 0, 376},
  {164167200, 3600, 376},
  {183520800, 0, 376},
  {196221600, 3600, 376},
  {214970400, 0, 376},
  {227671200, 3600, 376},
  {246420000, 0, 376},
  {259120800, 3600, 376},
  {278474400, 0, 376},
  {290570400, 3600, 376},
  {309924000, 0, 376},
  {322020000, 3600, 376},
  {341373600, 0, 376},
  {354675600, 3600, 376},
  {372819600, 0, 376},
  {386125200, 3600, 376},
  {404269200, 0, 376},
  {417574800, 3600, 376},
  {435718800, 0, 376},
  {449024400, 3600, 376},
  {467773200, 0, 376},
  {481078800, 3600, 376},
  {499222800, 0, 376},
  {512528400, 3600, 376},
  {530672400, 0, 376},
  {543978000, 3600, 376},
  {562122000, 0, 376},
  {575427600, 3600, 376},
  {593571600, 0, 376},
  {606877200, 3600, 376},
  {625626000, 0, 376},
  {638326800, 3600, 376},
  {657075600, 0, 376},
  {670381200, 3600, 376},
  {688525200, 0, 376},
  {701830800, 3600, 376},
  {719974800, 0, 376},
  {733280400, 3600, 376},
  {751424400, 0, 376},
  {764730000, 3600, 376},
  {782874000, 0, 376},
  {796179600, 3600, 376},
  {814323600, 0, 376},
  {820454400, 0, 376},
  {828234000, 3600, 376},
  {846378000, 0, 376},
  {859683600, 3600, 376},
  {877827600, 0, 376},
  {891133200, 3600, 376},
  {909277200, 0, 376},
  {922582800, 3600, 376},
  {941331600, 0, 376},
  {954032400, 3600, 376},
  {972781200, 0, 376},
  {985482000, 3600, 376},
  {1004230800, 0, 376},
  {1017536400, 3600, 376},
  {1035680400, 0, 376},
  {1048986000, 3600, 376},
  {1067130000, 0, 376},
  {1080435600, 3600, 376},
  {1099184400, 0, 376},
  {1111885200, 3600, 376},
  {1130634000, 0, 376},
  {1143334800, 3600, 376},
  {1162083600, 0, 376},
  {1174784400, 3600, 376},
  {1193533200, 0, 376},
  {1206838800, 3600, 376},
  {1224982800, 0, 376},
  {1238288400, 3600, 376},
  {1256432400, 0, 376},
  {1269738000, 3600, 376},
  {1288486800, 0, 376},
  {1301187600, 3600, 376},
  {1319936400, 0, 376},
  {1332637200, 3600, 376},
  {1351386000, 0, 376},
  {1364691600, 3600, 376},
  {1382835600, 0, 376},
  {1396141200, 3600, 376},
  {1414285200, 0, 376},
  {1427590800, 3600, 376},
  {1445734800, 0, 376},
  {1459040400, 3600, 376},
  {1477789200, 0, 376},
  {1490490000, 3600, 376},
  {1509238800, 0, 376},
  {1521939600, 3600, 376},
  {1540688400, 0, 376},
  {1553994000, 3600, 376},
  {1572138000, 0, 376},
  {1585443600, 3600, 376},
  {1603587600, 0, 376},
  {1616893200, 3600, 376},
  {1635642000, 0, 376},
  {1648342800, 3600, 376},
  {1667091600, 0, 376},
  {1679792400, 3600, 376},
  {1698541200, 0, 376},
  {1711846800, 3600, 376},
  {1729990800, 0, 376},
  {1743296400, 3600, 376},
  {1761440400, 0, 376},
  {1774746000, 3600, 376},
  {1792890000, 0, 376},
  {1806195600, 3600, 376},
  {1824944400, 0, 376},
  {1837645200, 3600, 376},
  {1856394000, 0, 376},
  {1869094800, 3600, 376},
  {1887843600, 0, 376},
  {1901149200, 3600, 376},
  {1919293200, 0, 376},
  {1932598800, 3600, 376},
  {1950742800, 0, 376},
  {1964048400, 3600, 376},
  {1982797200, 0, 376},
  {1995498000, 3600, 376},
  {2014246800, 0, 376},
  {2026947600, 3600, 376},
  {2045696400, 0, 376},
  {2058397200, 3600, 376},
  {2077146000, 0, 376},
  {2090451600, 3600, 376},
  {2108595600, 0, 376},
  {2121901200, 3600, 376},
  {2140045200, 0, 376},
  {INT64_MIN, 0, 377},
  {INT64_MIN, 0, 378},
  {INT64_MIN, -3600, 379},
  {INT64_MIN, -36000, 380},
  {INT64_MIN, -39600, 381},
  {INT64_MIN, -43200, 382},
  {INT64_MIN, -7200, 383},
  {INT64_MIN, -10800, 384},
  {INT64_MIN, -14400, 385},
  {INT64_MIN, -18000, 386},
  {INT64_MIN, -21600, 387},
  {INT64_MIN, -25200, 388},
  {INT64_MIN, -28800, 389},
  {INT64_MIN, -32400, 390},
  {INT64_MIN, 0, 391},
  {INT64_MIN, 3600, 392},
  {INT64_MIN, 36000, 393},
  {INT64_MIN, 39600, 394},
  {INT64_MIN, 43200, 395},
  {INT64_MIN, 46800, 396},
  {INT64_MIN, 50400, 397},
  {INT64_MIN, 7200, 398},
  {INT64_MIN, 10800, 399},
  {INT64_MIN, 14400, 400},
  {INT64_MIN, 18000, 401},
  {INT64_MIN, 21600, 402},
  {INT64_MIN, 25200, 403},
  {INT64_MIN, 28800, 404},
  {INT64_MIN, 32400, 405},
  {INT64_MIN, 0, 406},
  {INT64_MIN, 0, 407},
  {INT64_MIN, 0, 408},
  {INT64_MIN, 0, 409},
  {INT64_MIN, 0, 410},
  {INT64_MIN, 0, 411},
  {-1693700372, 4772, 412},
  {-1680484772, 1172, 412},
  {-1663453172, 4772, 412},
  {-1650147572, 1172, 412},
  {-1633213172, 4772, 412},
  {-1617488372, 1172, 412},
  {-1601158772, 4772, 412},
  {-1586038772, 1172, 412},
  {-1569709172, 4772, 412},
  {-1554589172, 1172, 412},
  {-1538259572, 4772, 412},
  {-1523139572, 1172, 412},
  {-1507501172, 4772, 412},
  {-1490566772, 1172, 412},
  {-1470176372, 4772, 412},
  {-1459117172, 1172, 412},
  {-1443997172, 4772, 412},
  {-1427667572, 1172, 412},
  {-1406672372, 4772, 412},
  {-1396217972, 1172, 412},
  {-1376950772, 4772, 412},
  {-1364768372, 1172, 412},
  {-1345414772, 4772, 412},
  {-1333318772, 1172, 412},
  {-1313792372, 4772, 412},
  {-1301264372, 1172, 412},
  {-1282256372, 4772, 412},
  {-1269814772, 1172, 412},
  {-1250720372, 4772, 412},
  {-1238365172, 1172, 412},
  {-1219184372, 4772, 412},
  {-1206915572, 1172, 412},
  {-1186957172, 4772, 412},
  {-1175465972, 1172, 412},
  {-1156025972, 4772, 412},
  {-1143411572, 1172, 412},
  {-1124489972, 4772, 412},
  {-1111961972, 1172, 412},
  {-1092953972, 4772, 412},
  {-1080512372, 1172, 412},
  {-1061331572, 4772, 412},
  {-1049062772, 1172, 412},
  {-1029190772, 4772, 412},
  {-1025745572, 4800, 412},
  {-1017613200, 1200, 412},
  {-998259600, 4800, 412},
  {-986163600, 1200, 412},
  {-966723600, 4800, 412},
  {-954109200, 1200, 412},
  {-935022000, 7200, 412},
  {-857257200, 3600, 412},
  {-844556400, 7200, 412},
  {-828226800, 3600, 412},
  {-812502000, 7200, 412},
  {-796777200, 3600, 412},
  {-781052400, 7200, 412},
  {-766623600, 3600, 412},
  {220921200, 3600, 412},
  {228877200, 7200, 412},
  {243997200, 3600, 412},
  {260326800, 7200, 412},
  {276051600, 3600, 412},
  {291776400, 7200, 412},
  {307501200, 3600, 412},
  {323830800, 7200, 412},
  {338950800, 3600, 412},
  {354675600, 7200, 412},
  {370400400, 3600, 412},
  {386125200, 7200, 412},
  {401850000, 3600, 412},
  {417574800, 7200, 412},
  {433299600, 3600, 412},
  {449024400, 7200, 412},
  {465354000, 3600, 412},
  {481078800, 7200, 412},
  {496803600, 3600, 412},
  {512528400, 7200, 412},
  {528253200, 3600, 412},
  {543978000, 7200, 412},
  {559702800, 3600, 412},
  {575427600, 7200, 412},
  {591152400, 3600, 412},
  {606877200, 7200, 412},
  {622602000, 3600, 412},
  {638326800, 7200, 412},
  {654656400, 3600, 412},
  {670381200, 7200, 412},
  {686106000, 3600, 412},
  {701830800, 7200, 412},
  {717555600, 3600, 412},
  {733280400, 7200, 412},
  {749005200, 3600, 412},
  {764730000, 7200, 412},
  {780454800, 3600, 412},
  {796179600, 7200, 412},
  {811904400, 3600, 412},
  {828234000, 7200, 412},
  {846378000, 3600, 412},
  {859683600, 7200, 412},
  {877827600, 3600, 412},
  {891133200, 7200, 412},
  {909277200, 3600, 412},
  {922582800, 7200, 412},
  {941331600, 3600, 412},
  {954032400, 7200, 412},
  {972781200, 3600, 412},
  {985482000, 7200, 412},
  {1004230800, 3600, 412},
  {1017536400, 7200, 412},
  {1035680400, 3600, 412},
  {1048986000, 7200, 412},
  {1067130000, 3600, 412},
  {1080435600, 7200, 412},
  {1099184400, 3600, 412},
  {1111885200, 7200, 412},
  {1130634000, 3600, 412},
  {1143334800, 7200, 412},
  {1162083600, 3600, 412},
  {1174784400, 7200, 412},
  {1193533200, 3600, 412},
  {1206838800, 7200, 412},
  {1224982800, 3600, 412},
  {1238288400, 7200, 412},
  {1256432400, 3600, 412},
  {1269738000, 7200, 412},
  {1288486800, 3600, 412},
  {1301187600, 7200, 412},
  {1319936400, 3600, 412},
  {1332637200, 7200, 412},
  {1351386000, 3600, 412},
  {1364691600, 7200, 412},
  {1382835600, 3600, 412},
  {1396141200, 7200, 412},
  {1414285200, 3600, 412},
  {1427590800, 7200, 412},
  {1445734800, 3600, 412},
  {1459040400, 7200, 412},
  {1477789200, 3600, 412},
  {1490490000, 7200, 412},
  {1509238800, 3600, 412},
  {1521939600, 7200, 412},
  {1540688400, 3600, 412},
  {1553994000, 7200, 412},
  {1572138000, 3600, 412},
  {1585443600, 7200, 412},
  {1603587600, 3600, 412},
  {1616893200, 7200, 412},
  {1635642000, 3600, 412},
  {1648342800, 7200, 412},
  {1667091600, 3600, 412},
  {1679792400, 7200, 412},
  {1698541200, 3600, 412},
  {1711846800, 7200, 412},
  {1729990800, 3600, 412},
  {1743296400, 7200, 412},
  {1761440400, 3600, 412},
  {1774746000, 7200, 412},
  {1792890000, 3600, 412},
  {1806195600, 7200, 412},
  {1824944400, 3600, 412},
  {1837645200, 7200, 412},
  {1856394000, 3600, 412},
  {1869094800, 7200, 412},
  {1887843600, 3600, 412},
  {1901149200, 7200, 412},
  {1919293200, 3600, 412},
  {1932598800, 7200, 412},
  {1950742800, 3600, 412},
  {1964048400, 7200, 412},
  {1982797200, 3600, 412},
  {1995498000, 7200, 412},
  {2014246800, 3600, 412},
  {2026947600, 7200, 412},
  {2045696400, 3600, 412},
  {2058397200, 7200, 412},
  {2077146000, 3600, 412},
  {2090451600, 7200, 412},
  {2108595600, 3600, 412},
  {2121901200, 7200, 412},
  {2140045200, 3600, 412},
  {INT64_MIN, 0, 413},
  {-733881600, 3600, 413},
  {481078800, 7200, 413},
  {496803600, 3600, 413},
  {512528400, 7200, 413},
  {528253200, 3600, 413},
  {543978000, 7200, 413},
  {559702800, 3600, 413},
  {575427600, 7200, 413},
  {591152400, 3600, 413},
  {606877200, 7200, 413},
  {622602000, 3600, 413},
  {638326800, 7200, 413},
  {654656400, 3600, 413},
  {670381200, 7200, 413},
  {686106000, 3600, 413},
  {701830800, 7200, 413},
  {717555600, 3600, 413},
  {733280400, 7200, 413},
  {749005200, 3600, 413},
  {764730000, 7200, 413},
  {780454800, 3600, 413},
  {796179600, 7200, 413},
  {811904400, 3600, 413},
  {828234000, 7200, 413},
  {846378000, 3600, 413},
  {859683600, 7200, 413},
  {877827600, 3600, 413},
  {891133200, 7200, 413},
  {909277200, 3600, 413},
  {922582800, 7200, 413},
  {941331600, 3600, 413},
  {954032400, 7200, 413},
  {972781200, 3600, 413},
  {985482000, 7200, 413},
  {1004230800, 3600, 413},
  {1017536400, 7200, 413},
  {1035680400, 3600, 413},
  {1048986000, 7200, 413},
  {1067130000, 3600, 413},
  {1080435600, 7200, 413},
  {1099184400, 3600, 413},
  {1111885200, 7200, 413},
  {1130634000, 3600, 413},
  {1143334800, 7200, 413},
  {1162083600, 3600, 413},
  {1174784400, 7200, 413},
  {1193533200, 3600, 413},
  {1206838800, 7200, 413},
  {1224982800, 3600, 413},
  {1238288400, 7200, 413},
  {1256432400, 3600, 413},
  {1269738000, 7200, 413},
  {1288486800, 3600, 413},
  {1301187600, 7200, 413},
  {1319936400, 3600, 413},
  {1332637200, 7200, 413},
  {1351386000, 3600, 413},
  {1364691600, 7200, 413},
  {1382835600, 3600, 413},
  {1396141200, 7200, 413},
  {1414285200, 3600, 413},
  {1427590800, 7200, 413},
  {1445734800, 3600, 413},
  {1459040400, 7200, 413},
  {1477789200, 3600, 413},
  {1490490000, 7200, 413},
  {1509238800, 3600, 413},
  {1521939600, 7200, 413},
  {1540688400, 3600, 413},
  {1553994000, 7200, 413},
  {1572138000, 3600, 413},
  {1585443600, 7200, 413},
  {1603587600, 3600, 413},
  {1616893200, 7200, 413},
  {1635642000, 3600, 413},
  {1648342800, 7200, 413},
  {1667091600, 3600, 413},
  {1679792400, 7200, 413},
  {1698541200, 3600, 413},
  {1711846800, 7200, 413},
  {1729990800, 3600, 413},
  {1743296400, 7200, 413},
  {1761440400, 3600, 413},
  {1774746000, 7200, 413},
  {1792890000, 3600, 413},
  {1806195600, 7200, 413},
  {1824944400, 3600, 413},
  {1837645200, 7200, 413},
  {1856394000, 3600, 413},
  {1869094800, 7200, 413},
  {1887843600, 3600, 413},
  {1901149200, 7200, 413},
  {1919293200, 3600, 413},
  {1932598800, 7200, 413},
  {1950742800, 3600, 413},
  {1964048400, 7200, 413},
  {1982797200, 3600, 413},
  {1995498000, 7200, 413},
  {2014246800, 3600, 413},
  {2026947600, 7200, 413},
  {2045696400, 3600, 413},
  {2058397200, 7200, 413},
  {2077146000, 3600, 413},
  {2090451600, 7200, 413},
  {2108595600, 3600, 413},
  {2121901200, 7200, 413},
  {2140045200, 3600, 413},
  {INT64_MIN, 5692, 414},
  {-1686101632, 7200, 414},
  {-1182996000, 10800, 414},
  {-1178161200, 7200, 414},
  {-906861600, 10800, 414},
  {-904878000, 7200, 414},
  {-857257200, 3600, 414},
  {-844477200, 7200, 414},
  {-828237600, 3600, 414},
  {-812422800, 7200, 414},
  {-552362400, 10800, 414},
  {-541652400, 7200, 414},
  {166485600, 10800, 414},
  {186184800, 7200, 414},
  {198028800, 10800, 414},
  {213753600, 7200, 414},
  {228873600, 10800, 414},
  {244080000, 7200, 414},
  {260323200, 10800, 414},
  {275446800, 7200, 414},
  {291798000, 10800, 414},
  {307407600, 7200, 414},
  {323388000, 10800, 414},
  {338936400, 7200, 414},
  {354675600, 10800, 414},
  {370400400, 7200, 414},
  {386125200, 10800, 414},
  {401850000, 7200, 414},
  {417574800, 10800, 414},
  {433299600, 7200, 414},
  {449024400, 10800, 414},
  {465354000, 7200, 414},
  {481078800, 10800, 414},
  {496803600, 7200, 414},
  {512528400, 10800, 414},
  {528253200, 7200, 414},
  {543978000, 10800, 414},
  {559702800, 7200, 414},
  {575427600, 10800, 414},
  {591152400, 7200, 414},
  {606877200, 10800, 414},
  {622602000, 7200, 414},
  {638326800, 10800, 414},
  {654656400, 7200, 414},
  {670381200, 10800, 414},
  {686106000, 7200, 414},
  {701830800, 10800, 414},
  {717555600, 7200, 414},
  {733280400, 10800, 414},
  {749005200, 7200, 414},
  {764730000, 10800, 414},
  {780454800, 7200, 414},
  {796179600, 10800, 414},
  {811904400, 7200, 414},
  {828234000, 10800, 414},
  {846378000, 7200, 414},
  {859683600, 10800, 414},
  {877827600, 7200, 414},
  {891133200, 10800, 414},
  {909277200, 7200, 414},
  {922582800, 10800, 414},
  {941331600, 7200, 414},
  {954032400, 10800, 414},
  {972781200, 7200, 414},
  {985482000, 10800, 414},
  {1004230800, 7200, 414},
  {1017536400, 10800, 414},
  {1035680400, 7200, 414},
  {1048986000, 10800, 414},
  {1067130000, 7200, 414},
  {1080435600, 10800, 414},
  {1099184400, 7200, 414},
  {1111885200, 10800, 414},
  {1130634000, 7200, 414},
  {1143334800, 10800, 414},
  {1162083600, 7200, 414},
  {1174784400, 10800, 414},
  {1193533200, 7200, 414},
  {1206838800, 10800, 414},
  {1224982800, 7200, 414},
  {1238288400, 10800, 414},
  {1256432400, 7200, 414},
  {1269738000, 10800, 414},
  {1288486800, 7200, 414},
  {1301187600, 10800, 414},
  {1319936400, 7200, 414},
  {1332637200, 10800, 414},
  {1351386000, 7200, 414},
  {1364691600, 10800, 414},
  {1382835600, 7200, 414},
  {1396141200, 10800, 414},
  {1414285200, 7200, 414},
  {1427590800, 10800, 414},
  {1445734800, 7200, 414},
  {1459040400, 10800, 414},
  {1477789200, 7200, 414},
  {1490490000, 10800, 414},
  {1509238800, 7200, 414},
  {1521939600, 10800, 414},
  {1540688400, 7200, 414},
  {1553994000, 10800, 414},
  {1572138000, 7200, 414},
  {1585443600, 10800, 414},
  {1603587600, 7200, 414},
  {1616893200, 10800, 414},
  {1635642000, 7200, 414},
  {1648342800, 10800, 414},
  {1667091600, 7200, 414},
  {1679792400, 10800, 414},
  {1698541200, 7200, 414},
  {1711846800, 10800, 414},
  {1729990800, 7200, 414},
  {1743296400, 10800, 414},
  {1761440400, 7200, 414},
  {1774746000, 10800, 414},
  {1792890000, 7200, 414},
  {1806195600, 10800, 414},
  {1824944400, 7200, 414},
  {1837645200, 10800, 414},
  {1856394000, 7200, 414},
  {1869094800, 10800, 414},
  {1887843600, 7200, 414},
  {1901149200, 10800, 414},
  {1919293200, 7200, 414},
  {1932598800, 10800, 414},
  {1950742800, 7200, 414},
  {1964048400, 10800, 414},
  {1982797200, 7200, 414},
  {1995498000, 10800, 414},
  {2014246800, 7200, 414},
  {2026947600, 10800, 414},
  {2045696400, 7200, 414},
  {2058397200, 10800, 414},
  {2077146000, 7200, 414},
  {2090451600, 10800, 414},
  {2108595600, 7200, 414},
  {2121901200, 10800, 414},
  {2140045200, 7200, 414},
  {-1691964000, 3600, 415},
  {-1680472800, 0, 415},
  {-1664143200, 3600, 415},
  {-1650146400, 0, 415},
  {-1633903200, 3600, 415},
  {-1617487200, 0, 415},
  {-1601848800, 3600, 415},
  {-1586037600, 0, 415},
  {-1570399200, 3600, 415},
  {-1552168800, 0, 415},
  {-1538344800, 3600, 415},
  {-1522533600, 0, 415},
  {-1507500000, 3600, 415},
  {-1490565600, 0, 415},
  {-1473631200, 3600, 415},
  {-1460930400, 0, 415},
  {-1442786400, 3600, 415},
  {-1428876000, 0, 415},
  {-1410732000, 3600, 415},
  {-1396216800, 0, 415},
  {-1379282400, 3600, 415},
  {-1364767200, 0, 415},
  {-1348437600, 3600, 415},
  {-1333317600, 0, 415},
  {-1315778400, 3600, 415},
  {-1301263200, 0, 415},
  {-1284328800, 3600, 415},
  {-1269813600, 0, 415},
  {-1253484000, 3600, 415},
  {-1238364000, 0, 415},
  {-1221429600, 3600, 415},
  {-1206914400, 0, 415},
  {-1189980000, 3600, 415},
  {-1175464800, 0, 415},
  {-1159135200, 3600, 415},
  {-1143410400, 0, 415},
  {-1126476000, 3600, 415},
  {-1111960800, 0, 415},
  {-1095631200, 3600, 415},
  {-1080511200, 0, 415},
  {-1063576800, 3600, 415},
  {-1049061600, 0, 415},
  {-1032127200, 3600, 415},
  {-1017612000, 0, 415},
  {-1001282400, 3600, 415},
  {-986162400, 0, 415},
  {-969228000, 3600, 415},
  {-950479200, 0, 415},
  {-942012000, 3600, 415},
  {-904518000, 7200, 415},
  {-896050800, 3600, 415},
  {-875487600, 7200, 415},
  {-864601200, 3600, 415},
  {-844038000, 7200, 415},
  {-832546800, 3600, 415},
  {-812588400, 7200, 415},
  {-798073200, 3600, 415},
  {-781052400, 7200, 415},
  {-772066800, 3600, 415},
  {-764805600, 0, 415},
  {-748476000, 3600, 415},
  {-733356000, 0, 415},
  {-719445600, 3600, 415},
  {-717030000, 7200, 415},
  {-706748400, 3600, 415},
  {-699487200, 0, 415},
  {-687996000, 3600, 415},
  {-668037600, 0, 415},
  {-654732000, 3600, 415},
  {-636588000, 0, 415},
  {-622072800, 3600, 415},
  {-605743200, 0, 415},
  {-590623200, 3600, 415},
  {-574293600, 0, 415},
  {-558568800, 3600, 415},
  {-542239200, 0, 415},
  {-527119200, 3600, 415},
  {-512604000, 0, 415},
  {-496274400, 3600, 415},
  {-481154400, 0, 415},
  {-464220000, 3600, 415},
  {-449704800, 0, 415},
  {-432165600, 3600, 415},
  {-417650400, 0, 415},
  {-401320800, 3600, 415},
  {-386200800, 0, 415},
  {-369266400, 3600, 415},
  {-354751200, 0, 415},
  {-337816800, 3600, 415},
  {-323301600, 0, 415},
  {-306972000, 3600, 415},
  {-291852000, 0, 415},
  {-276732000, 3600, 415},
  {-257983200, 0, 415},
  {-245282400, 3600, 415},
  {-226533600, 0, 415},
  {-213228000, 3600, 415},
  {-195084000, 0, 415},
  {-182383200, 3600, 415},
  {-163634400, 0, 415},
  {-150933600, 3600, 415},
  {-132184800, 0, 415},
  {-119484000, 3600, 415},
  {-100735200, 0, 415},
  {-88034400, 3600, 415},
  {-68680800, 0, 415},
  {-59004000, 3600, 415},
  {-37242000, 3600, 415},
  {57722400, 0, 415},
  {69818400, 3600, 415},
  {89172000, 0, 415},
  {101268000, 3600, 415},
  {120621600, 0, 415},
  {132717600, 3600, 415},
  {152071200, 0, 415},
  {164167200, 3600, 415},
  {183520800, 0, 415},
  {196221600, 3600, 415},
  {214970400, 0, 415},
  {227671200, 3600, 415},
  {246420000, 0, 415},
  {259120800, 3600, 415},
  {278474400, 0, 415},
  {290570400, 3600, 415},
  {309924000, 0, 415},
  {322020000, 3600, 415},
  {341373600, 0, 415},
  {354675600, 3600, 415},
  {372819600, 0, 415},
  {386125200, 3600, 415},
  {404269200, 0, 415},
  {417574800, 3600, 415},
  {435718800, 0, 415},
  {449024400, 3600, 415},
  {467773200, 0, 415},
  {481078800, 3600, 415},
  {499222800, 0, 415},
  {512528400, 3600, 415},
  {530672400, 0, 415},
  {543978000, 3600, 415},
  {562122000, 0, 415},
  {575427600, 3600, 415},
  {593571600, 0, 415},
  {606877200, 3600, 415},
  {625626000, 0, 415},
  {638326800, 3600, 415},
  {657075600, 0, 415},
  {670381200, 3600, 415},
  {688525200, 0, 415},
  {701830800, 3600, 415},
  {719974800, 0, 415},
  {733280400, 3600, 415},
  {751424400, 0, 415},
  {764730000, 3600, 415},
  {782874000, 0, 415},
  {796179600, 3600, 415},
  {814323600, 0, 415},
  {820454400, 0, 415},
  {828234000, 3600, 415},
  {846378000, 0, 415},
  {859683600, 3600, 415},
  {877827600, 0, 415},
  {891133200, 3600, 415},
  {909277200, 0, 415},
  {922582800, 3600, 415},
  {941331600, 0, 415},
  {954032400, 3600, 415},
  {972781200, 0, 415},
  {985482000, 3600, 415},
  {1004230800, 0, 415},
  {1017536400, 3600, 415},
  {1035680400, 0, 415},
  {1048986000, 3600, 415},
  {1067130000, 0, 415},
  {1080435600, 3600, 415},
  {1099184400, 0, 415},
  {1111885200, 3600, 415},
  {1130634000, 0, 415},
  {1143334800, 3600, 415},
  {1162083600, 0, 415},
  {1174784400, 3600, 415},
  {1193533200, 0, 415},
  {1206838800, 3600, 415},
  {1224982800, 0, 415},
  {1238288400, 3600, 415},
  {1256432400, 0, 415},
  {1269738000, 3600, 415},
  {1288486800, 0, 415},
  {1301187600, 3600, 415},
  {1319936400, 0, 415},
  {1332637200, 3600, 415},
  {1351386000, 0, 415},
  {1364691600, 3600, 415},
  {1382835600, 0, 415},
  {1396141200, 3600, 415},
  {1414285200, 0, 415},
  {1427590800, 3600, 415},
  {1445734800, 0, 415},
  {1459040400, 3600, 415},
  {1477789200, 0, 415},
  {1490490000, 3600, 415},
  {1509238800, 0, 415},
  {1521939600, 3600, 415},
  {1540688400, 0, 415},
  {1553994000, 3600, 415},
  {1572138000, 0, 415},
  {1585443600, 3600, 415},
  {1603587600, 0, 415},
  {1616893200, 3600, 415},
  {1635642000, 0, 415},
  {1648342800, 3600, 415},
  {1667091600, 0, 415},
  {1679792400, 3600, 415},
  {1698541200, 0, 415},
  {1711846800, 3600, 415},
  {1729990800, 0, 415},
  {1743296400, 3600, 415},
  {1761440400, 0, 415},
  {1774746000, 3600, 415},
  {1792890000, 0, 415},
  {1806195600, 3600, 415},
  {1824944400, 0, 415},
  {1837645200, 3600, 415},
  {1856394000, 0, 415},
  {1869094800, 3600, 415},
  {1887843600, 0, 415},
  {1901149200, 3600, 415},
  {1919293200, 0, 415},
  {1932598800, 3600, 415},
  {1950742800, 0, 415},
  {1964048400, 3600, 415},
  {1982797200, 0, 415},
  {1995498000, 3600, 415},
  {2014246800, 0, 415},
  {2026947600, 3600, 415},
  {2045696400, 0, 415},
  {2058397200, 3600, 415},
  {2077146000, 0, 415},
  {2090451600, 3600, 415},
  {2108595600, 0, 415},
  {2121901200, 3600, 415},
  {2140045200, 0, 415},
  {-905824800, 7200, 416},
  {-857257200, 3600, 416},
  {-844556400, 7200, 416},
  {-828226800, 3600, 416},
  {-812502000, 7200, 416},
  {-796777200, 3600, 416},
  {-788922000, 3600, 416},
  {-777942000, 7200, 416},
  {-766623600, 3600, 416},
  {407199600, 3600, 416},
  {417574800, 7200, 416},
  {433299600, 3600, 416},
  {449024400, 7200, 416},
  {465354000, 3600, 416},
  {481078800, 7200, 416},
  {496803600, 3600, 416},
  {512528400, 7200, 416},
  {528253200, 3600, 416},
  {543978000, 7200, 416},
  {559702800, 3600, 416},
  {575427600, 7200, 416},
  {591152400, 3600, 416},
  {606877200, 7200, 416},
  {622602000, 3600, 416},
  {638326800, 7200, 416},
  {654656400, 3600, 416},
  {670381200, 7200, 416},
  {686106000, 3600, 416},
  {701830800, 7200, 416},
  {717555600, 3600, 416},
  {733280400, 7200, 416},
  {749005200, 3600, 416},
  {764730000, 7200, 416},
  {780454800, 3600, 416},
  {796179600, 7200, 416},
  {811904400, 3600, 416},
  {828234000, 7200, 416},
  {846378000, 3600, 416},
  {859683600, 7200, 416},
  {877827600, 3600, 416},
  {891133200, 7200, 416},
  {909277200, 3600, 416},
  {922582800, 7200, 416},
  {941331600, 3600, 416},
  {954032400, 7200, 416},
  {972781200, 3600, 416},
  {985482000, 7200, 416},
  {1004230800, 3600, 416},
  {1017536400, 7200, 416},
  {1035680400, 3600, 416},
  {1048986000, 7200, 416},
  {1067130000, 3600, 416},
  {1080435600, 7200, 416},
  {1099184400, 3600, 416},
  {1111885200, 7200, 416},
  {1130634000, 3600, 416},
  {1143334800, 7200, 416},
  {1162083600, 3600, 416},
  {1174784400, 7200, 416},
  {1193533200, 3600, 416},
  {1206838800, 7200, 416},
  {1224982800, 3600, 416},
  {1238288400, 7200, 416},
  {1256432400, 3600, 416},
  {1269738000, 7200, 416},
  {1288486800, 3600, 416},
  {1301187600, 7200, 416},
  {1319936400, 3600, 416},
  {1332637200, 7200, 416},
  {1351386000, 3600, 416},
  {1364691600, 7200, 416},
  {1382835600, 3600, 416},
  {1396141200, 7200, 416},
  {1414285200, 3600, 416},
  {1427590800, 7200, 416},
  {1445734800, 3600, 416},
  {1459040400, 7200, 416},
  {1477789200, 3600, 416},
  {1490490000, 7200, 416},
  {1509238800, 3600, 416},
  {1521939600, 7200, 416},
  {1540688400, 3600, 416},
  {1553994000, 7200, 416},
  {1572138000, 3600, 416},
  {1585443600, 7200, 416},
  {1603587600, 3600, 416},
  {1616893200, 7200, 416},
  {1635642000, 3600, 416},
  {1648342800, 7200, 416},
  {1667091600, 3600, 416},
  {1679792400, 7200, 416},
  {1698541200, 3600, 416},
  {1711846800, 7200, 416},
  {1729990800, 3600, 416},
  {1743296400, 7200, 416},
  {1761440400, 3600, 416},
  {1774746000, 7200, 416},
  {1792890000, 3600, 416},
  {1806195600, 7200, 416},
  {1824944400, 3600, 416},
  {1837645200, 7200, 416},
  {1856394000, 3600, 416},
  {1869094800, 7200, 416},
  {1887843600, 3600, 416},
  {1901149200, 7200, 416},
  {1919293200, 3600, 416},
  {1932598800, 7200, 416},
  {1950742800, 3600, 416},
  {1964048400, 7200, 416},
  {1982797200, 3600, 416},
  {1995498000, 7200, 416},
  {2014246800, 3600, 416},
  {2026947600, 7200, 416},
  {2045696400, 3600, 416},
  {2058397200, 7200, 416},
  {2077146000, 3600, 416},
  {2090451600, 7200, 416},
  {2108595600, 3600, 416},
  {2121901200, 7200, 416},
  {2140045200, 3600, 416},
  {-1693706400, 7200, 417},
  {-1680483600, 3600, 417},
  {-1663455600, 7200, 417},
  {-1650150000, 3600, 417},
  {-1632006000, 7200, 417},
  {-1618700400, 3600, 417},
  {-938905200, 7200, 417},
  {-857257200, 3600, 417},
  {-844556400, 7200, 417},
  {-828226800, 3600, 417},
  {-812502000, 7200, 417},
  {-796777200, 3600, 417},
  {-781052400, 7200, 417},
  {-776563200, 10800, 417},
  {-765936000, 7200, 417},
  {-761180400, 3600, 417},
  {-757386000, 3600, 417},
  {-748479600, 7200, 417},
  {-733273200, 3600, 417},
  {-717631200, 7200, 417},
  {-714610800, 10800, 417},
  {-710380800, 7200, 417},
  {-701910000, 3600, 417},
  {-684975600, 7200, 417},
  {-670460400, 3600, 417},
  {-654130800, 7200, 417},
  {-639010800, 3600, 417},
  {315529200, 3600, 417},
  {323830800, 7200, 417},
  {338950800, 3600, 417},
  {354675600, 7200, 417},
  {370400400, 3600, 417},
  {386125200, 7200, 417},
  {401850000, 3600, 417},
  {417574800, 7200, 417},
  {433299600, 3600, 417},
  {449024400, 7200, 417},
  {465354000, 3600, 417},
  {481078800, 7200, 417},
  {496803600, 3600, 417},
  {512528400, 7200, 417},
  {528253200, 3600, 417},
  {543978000, 7200, 417},
  {559702800, 3600, 417},
  {575427600, 7200, 417},
  {591152400, 3600, 417},
  {606877200, 7200, 417},
  {622602000, 3600, 417},
  {638326800, 7200, 417},
  {654656400, 3600, 417},
  {670381200, 7200, 417},
  {686106000, 3600, 417},
  {701830800, 7200, 417},
  {717555600, 3600, 417},
  {733280400, 7200, 417},
  {749005200, 3600, 417},
  {764730000, 7200, 417},
  {780454800, 3600, 417},
  {796179600, 7200, 417},
  {811904400, 3600, 417},
  {828234000, 7200, 417},
  {846378000, 3600, 417},
  {859683600, 7200, 417},
  {877827600, 3600, 417},
  {891133200, 7200, 417},
  {909277200, 3600, 417},
  {922582800, 7200, 417},
  {941331600, 3600, 417},
  {954032400, 7200, 417},
  {972781200, 3600, 417},
  {985482000, 7200, 417},
  {1004230800, 3600, 417},
  {1017536400, 7200, 417},
  {1035680400, 3600, 417},
  {1048986000, 7200, 417},
  {1067130000, 3600, 417},
  {1080435600, 7200, 417},
  {1099184400, 3600, 417},
  {1111885200, 7200, 417},
  {1130634000, 3600, 417},
  {1143334800, 7200, 417},
  {1162083600, 3600, 417},
  {1174784400, 7200, 417},
  {1193533200, 3600, 417},
  {1206838800, 7200, 417},
  {1224982800, 3600, 417},
  {1238288400, 7200, 417},
  {1256432400, 3600, 417},
  {1269738000, 7200, 417},
  {1288486800, 3600, 417},
  {1301187600, 7200, 417},
  {1319936400, 3600, 417},
  {1332637200, 7200, 417},
  {1351386000, 3600, 417},
  {1364691600, 7200, 417},
  {1382835600, 3600, 417},
  {1396141200, 7200, 417},
  {1414285200, 3600, 417},
  {1427590800, 7200, 417},
  {1445734800, 3600, 417},
  {1459040400, 7200, 417},
  {1477789200, 3600, 417},
  {1490490000, 7200, 417},
  {1509238800, 3600, 417},
  {1521939600, 7200, 417},
  {1540688400, 3600, 417},
  {1553994000, 7200, 417},
  {1572138000, 3600, 417},
  {1585443600, 7200, 417},
  {1603587600, 3600, 417},
  {1616893200, 7200, 417},
  {1635642000, 3600, 417},
  {1648342800, 7200, 417},
  {1667091600, 3600, 417},
  {1679792400, 7200, 417},
  {1698541200, 3600, 417},
  {1711846800, 7200, 417},
  {1729990800, 3600, 417},
  {1743296400, 7200, 417},
  {1761440400, 3600, 417},
  {1774746000, 7200, 417},
  {1792890000, 3600, 417},
  {1806195600, 7200, 417},
  {1824944400, 3600, 417},
  {1837645200, 7200, 417},
  {1856394000, 3600, 417},
  {1869094800, 7200, 417},
  {1887843600, 3600, 417},
  {1901149200, 7200, 417},
  {1919293200, 3600, 417},
  {1932598800, 7200, 417},
  {1950742800, 3600, 417},
  {1964048400, 7200, 417},
  {1982797200, 3600, 417},
  {1995498000, 7200, 417},
  {2014246800, 3600, 417},
  {2026947600, 7200, 417},
  {2045696400, 3600, 417},
  {2058397200, 7200, 417},
  {2077146000, 3600, 417},
  {2090451600, 7200, 417},
  {2108595600, 3600, 417},
  {2121901200, 7200, 417},
  {2140045200, 3600, 417},
  {-1693706400, 7200, 418},
  {-1680483600, 3600, 418},
  {-1663455600, 7200, 418},
  {-1650150000, 3600, 418},
  {-1632006000, 7200, 418},
  {-1618700400, 3600, 418},
  {-938905200, 7200, 418},
  {-857257200, 3600, 418},
  {-844556400, 7200, 418},
  {-828226800, 3600, 418},
  {-812502000, 7200, 418},
  {-798073200, 3600, 418},
  {-780534000, 7200, 418},
  {-761180400, 3600, 418},
  {-746578800, 7200, 418},
  {-733359600, 3600, 418},
  {-716425200, 7200, 418},
  {-701910000, 3600, 418},
  {-684975600, 7200, 418},
  {-670460400, 3600, 418},
  {-654217200, 7200, 418},
  {-639010800, 3600, 418},
  {283993200, 3600, 418},
  {291776400, 7200, 418},
  {307501200, 3600, 418},
  {323830800, 7200, 418},
  {338950800, 3600, 418},
  {354675600, 7200, 418},
  {370400400, 3600, 418},
  {386125200, 7200, 418},
  {401850000, 3600, 418},
  {417574800, 7200, 418},
  {433299600, 3600, 418},
  {449024400, 7200, 418},
  {465354000, 3600, 418},
  {481078800, 7200, 418},
  {496803600, 3600, 418},
  {512528400, 7200, 418},
  {528253200, 3600, 418},
  {543978000, 7200, 418},
  {559702800, 3600, 418},
  {575427600, 7200, 418},
  {591152400, 3600, 418},
  {606877200, 7200, 418},
  {622602000, 3600, 418},
  {638326800, 7200, 418},
  {654656400, 3600, 418},
  {670381200, 7200, 418},
  {686106000, 3600, 418},
  {701830800, 7200, 418},
  {717555600, 3600, 418},
  {733280400, 7200, 418},
  {749005200, 3600, 418},
  {764730000, 7200, 418},
  {780454800, 3600, 418},
  {796179600, 7200, 418},
  {811904400, 3600, 418},
  {828234000, 7200, 418},
  {846378000, 3600, 418},
  {859683600, 7200, 418},
  {877827600, 3600, 418},
  {891133200, 7200, 418},
  {909277200, 3600, 418},
  {922582800, 7200, 418},
  {941331600, 3600, 418},
  {954032400, 7200, 418},
  {972781200, 3600, 418},
  {985482000, 7200, 418},
  {1004230800, 3600, 418},
  {1017536400, 7200, 418},
  {1035680400, 3600, 418},
  {1048986000, 7200, 418},
  {1067130000, 3600, 418},
  {1080435600, 7200, 418},
  {1099184400, 3600, 418},
  {1111885200, 7200, 418},
  {1130634000, 3600, 418},
  {1143334800, 7200, 418},
  {1162083600, 3600, 418},
  {1174784400, 7200, 418},
  {1193533200, 3600, 418},
  {1206838800, 7200, 418},
  {1224982800, 3600, 418},
  {1238288400, 7200, 418},
  {1256432400, 3600, 418},
  {1269738000, 7200, 418},
  {1288486800, 3600, 418},
  {1301187600, 7200, 418},
  {1319936400, 3600, 418},
  {1332637200, 7200, 418},
  {1351386000, 3600, 418},
  {1364691600, 7200, 418},
  {1382835600, 3600, 418},
  {1396141200, 7200, 418},
  {1414285200, 3600, 418},
  {1427590800, 7200, 418},
  {1445734800, 3600, 418},
  {1459040400, 7200, 418},
  {1477789200, 3600, 418},
  {1490490000, 7200, 418},
  {1509238800, 3600, 418},
  {1521939600, 7200, 418},
  {1540688400, 3600, 418},
  {1553994000, 7200, 418},
  {1572138000, 3600, 418},
  {1585443600, 7200, 418},
  {1603587600, 3600, 418},
  {1616893200, 7200, 418},
  {1635642000, 3600, 418},
  {1648342800, 7200, 418},
  {1667091600, 3600, 418},
  {1679792400, 7200, 418},
  {1698541200, 3600, 418},
  {1711846800, 7200, 418},
  {1729990800, 3600, 418},
  {1743296400, 7200, 418},
  {1761440400, 3600, 418},
  {1774746000, 7200, 418},
  {1792890000, 3600, 418},
  {1806195600, 7200, 418},
  {1824944400, 3600, 418},
  {1837645200, 7200, 418},
  {1856394000, 3600, 418},
  {1869094800, 7200, 418},
  {1887843600, 3600, 418},
  {1901149200, 7200, 418},
  {1919293200, 3600, 418},
  {1932598800, 7200, 418},
  {1950742800, 3600, 418},
  {1964048400, 7200, 418},
  {1982797200, 3600, 418},
  {1995498000, 7200, 418},
  {2014246800, 3600, 418},
  {2026947600, 7200, 418},
  {2045696400, 3600, 418},
  {2058397200, 7200, 418},
  {2077146000, 3600, 418},
  {2090451600, 7200, 418},
  {2108595600, 3600, 418},
  {2121901200, 7200, 418},
  {2140045200, 3600, 418},
  {INT64_MIN, 0, 419},
  {-1740355200, 3600, 419},
  {-1693702800, 7200, 419},
  {-1680483600, 3600, 419},
  {-1663455600, 7200, 419},
  {-1650150000, 3600, 419},
  {-1632006000, 7200, 419},
  {-1618700400, 3600, 419},
  {-1613826000, 0, 419},
  {-1604278800, 3600, 419},
  {-1585530000, 0, 419},
  {-1574038800, 3600, 419},
  {-1552266000, 0, 419},
  {-1539997200, 3600, 419},
  {-1520557200, 0, 419},
  {-1507510800, 3600, 419},
  {-1490576400, 0, 419},
  {-1473642000, 3600, 419},
  {-1459126800, 0, 419},
  {-1444006800, 3600, 419},
  {-1427677200, 0, 419},
  {-1411952400, 3600, 419},
  {-1396227600, 0, 419},
  {-1379293200, 3600, 419},
  {-1364778000, 0, 419},
  {-1348448400, 3600, 419},
  {-1333328400, 0, 419},
  {-1316394000, 3600, 419},
  {-1301263200, 0, 419},
  {-1284328800, 3600, 419},
  {-1269813600, 0, 419},
  {-1253484000, 3600, 419},
  {-1238364000, 0, 419},
  {-1221429600, 3600, 419},
  {-1206914400, 0, 419},
  {-1191189600, 3600, 419},
  {-1175464800, 0, 419},
  {-1160344800, 3600, 419},
  {-1143410400, 0, 419},
  {-1127685600, 3600, 419},
  {-1111960800, 0, 419},
  {-1096840800, 3600, 419},
  {-1080511200, 0, 419},
  {-1063576800, 3600, 419},
  {-1049061600, 0, 419},
  {-1033336800, 3600, 419},
  {-1017612000, 0, 419},
  {-1002492000, 3600, 419},
  {-986162400, 0, 419},
  {-969228000, 3600, 419},
  {-950479200, 0, 419},
  {-942012000, 3600, 419},
  {-934668000, 7200, 419},
  {-857257200, 3600, 419},
  {-844556400, 7200, 419},
  {-828226800, 3600, 419},
  {-812502000, 7200, 419},
  {-799293600, 7200, 419},
  {-798073200, 3600, 419},
  {-781052400, 7200, 419},
  {-766623600, 3600, 419},
  {-745455600, 7200, 419},
  {-733273200, 3600, 419},
  {220921200, 3600, 419},
  {228877200, 7200, 419},
  {243997200, 3600, 419},
  {260326800, 7200, 419},
  {276051600, 3600, 419},
  {291776400, 7200, 419},
  {307501200, 3600, 419},
  {323830800, 7200, 419},
  {338950800, 3600, 419},
  {354675600, 7200, 419},
  {370400400, 3600, 419},
  {386125200, 7200, 419},
  {401850000, 3600, 419},
  {417574800, 7200, 419},
  {433299600, 3600, 419},
  {449024400, 7200, 419},
  {465354000, 3600, 419},
  {481078800, 7200, 419},
  {496803600, 3600, 419},
  {512528400, 7200, 419},
  {528253200, 3600, 419},
  {543978000, 7200, 419},
  {559702800, 3600, 419},
  {575427600, 7200, 419},
  {591152400, 3600, 419},
  {606877200, 7200, 419},
  {622602000, 3600, 419},
  {638326800, 7200, 419},
  {654656400, 3600, 419},
  {670381200, 7200, 419},
  {686106000, 3600, 419},
  {701830800, 7200, 419},
  {717555600, 3600, 419},
  {733280400, 7200, 419},
  {749005200, 3600, 419},
  {764730000, 7200, 419},
  {780454800, 3600, 419},
  {796179600, 7200, 419},
  {811904400, 3600, 419},
  {828234000, 7200, 419},
  {846378000, 3600, 419},
  {859683600, 7200, 419},
  {877827600, 3600, 419},
  {891133200, 7200, 419},
  {909277200, 3600, 419},
  {922582800, 7200, 419},
  {941331600, 3600, 419},
  {954032400, 7200, 419},
  {972781200, 3600, 419},
  {985482000, 7200, 419},
  {1004230800, 3600, 419},
  {1017536400, 7200, 419},
  {1035680400, 3600, 419},
  {1048986000, 7200, 419},
  {1067130000, 3600, 419},
  {1080435600, 7200, 419},
  {1099184400, 3600, 419},
  {1111885200, 7200, 419},
  {1130634000, 3600, 419},
  {1143334800, 7200, 419},
  {1162083600, 3600, 419},
  {1174784400, 7200, 419},
  {1193533200, 3600, 419},
  {1206838800, 7200, 419},
  {1224982800, 3600, 419},
  {1238288400, 7200, 419},
  {1256432400, 3600, 419},
  {1269738000, 7200, 419},
  {1288486800, 3600, 419},
  {1301187600, 7200, 419},
  {1319936400, 3600, 419},
  {1332637200, 7200, 419},
  {1351386000, 3600, 419},
  {1364691600, 7200, 419},
  {1382835600, 3600, 419},
  {1396141200, 7200, 419},
  {1414285200, 3600, 419},
  {1427590800, 7200, 419},
  {1445734800, 3600, 419},
  {1459040400, 7200, 419},
  {1477789200, 3600, 419},
  {1490490000, 7200, 419},
  {1509238800, 3600, 419},
  {1521939600, 7200, 419},
  {1540688400, 3600, 419},
  {1553994000, 7200, 419},
  {1572138000, 3600, 419},
  {1585443600, 7200, 419},
  {1603587600, 3600, 419},
  {1616893200, 7200, 419},
  {1635642000, 3600, 419},
  {1648342800, 7200, 419},
  {1667091600, 3600, 419},
  {1679792400, 7200, 419},
  {1698541200, 3600, 419},
  {1711846800, 7200, 419},
  {1729990800, 3600, 419},
  {1743296400, 7200, 419},
  {1761440400, 3600, 419},
  {1774746000, 7200, 419},
  {1792890000, 3600, 419},
  {1806195600, 7200, 419},
  {1824944400, 3600, 419},
  {1837645200, 7200, 419},
  {1856394000, 3600, 419},
  {1869094800, 7200, 419},
  {1887843600, 3600, 419},
  {1901149200, 7200, 419},
  {1919293200, 3600, 419},
  {1932598800, 7200, 419},
  {1950742800, 3600, 419},
  {1964048400, 7200, 419},
  {1982797200, 3600, 419},
  {1995498000, 7200, 419},
  {2014246800, 3600, 419},
  {2026947600, 7200, 419},
  {2045696400, 3600, 419},
  {2058397200, 7200, 419},
  {2077146000, 3600, 419},
  {2090451600, 7200, 419},
  {2108595600, 3600, 419},
  {2121901200, 7200, 419},
  {2140045200, 3600, 419},
  {INT64_MIN, 6264, 420},
  {-1213148664, 7200, 420},
  {-1187056800, 10800, 420},
  {-1175479200, 7200, 420},
  {-1159754400, 10800, 420},
  {-1144029600, 7200, 420},
  {-1127700000, 10800, 420},
  {-1111975200, 7200, 420},
  {-1096250400, 10800, 420},
  {-1080525600, 7200, 420},
  {-1064800800, 10800, 420},
  {-1049076000, 7200, 420},
  {-1033351200, 10800, 420},
  {-1017626400, 7200, 420},
  {-1001901600, 10800, 420},
  {-986176800, 7200, 420},
  {-970452000, 10800, 420},
  {-954727200, 7200, 420},
  {296604000, 10800, 420},
  {307486800, 7200, 420},
  {323816400, 10800, 420},
  {338940000, 7200, 420},
  {354672000, 10800, 420},
  {370396800, 7200, 420},
  {386121600, 10800, 420},
  {401846400, 7200, 420},
  {417571200, 10800, 420},
  {433296000, 7200, 420},
  {449020800, 10800, 420},
  {465350400, 7200, 420},
  {481075200, 10800, 420},
  {496800000, 7200, 420},
  {512524800, 10800, 420},
  {528249600, 7200, 420},
  {543974400, 10800, 420},
  {559699200, 7200, 420},
  {575424000, 10800, 420},
  {591148800, 7200, 420},
  {606873600, 10800, 420},
  {622598400, 7200, 420},
  {638323200, 10800, 420},
  {654652800, 7200, 420},
  {662680800, 7200, 420},
  {670370400, 10800, 420},
  {686095200, 7200, 420},
  {701820000, 10800, 420},
  {717544800, 7200, 420},
  {733269600, 10800, 420},
  {748994400, 7200, 420},
  {757375200, 7200, 420},
  {764719200, 10800, 420},
  {780440400, 7200, 420},
  {796168800, 10800, 420},
  {811890000, 7200, 420},
  {828223200, 10800, 420},
  {846363600, 7200, 420},
  {859683600, 10800, 420},
  {877827600, 7200, 420},
  {891133200, 10800, 420},
  {909277200, 7200, 420},
  {922582800, 10800, 420},
  {941331600, 7200, 420},
  {954032400, 10800, 420},
  {972781200, 7200, 420},
  {985482000, 10800, 420},
  {1004230800, 7200, 420},
  {1017536400, 10800, 420},
  {1035680400, 7200, 420},
  {1048986000, 10800, 420},
  {1067130000, 7200, 420},
  {1080435600, 10800, 420},
  {1099184400, 7200, 420},
  {1111885200, 10800, 420},
  {1130634000, 7200, 420},
  {1143334800, 10800, 420},
  {1162083600, 7200, 420},
  {1174784400, 10800, 420},
  {1193533200, 7200, 420},
  {1206838800, 10800, 420},
  {1224982800, 7200, 420},
  {1238288400, 10800, 420},
  {1256432400, 7200, 420},
  {1269738000, 10800, 420},
  {1288486800, 7200, 420},
  {1301187600, 10800, 420},
  {1319936400, 7200, 420},
  {1332637200, 10800, 420},
  {1351386000, 7200, 420},
  {1364691600, 10800, 420},
  {1382835600, 7200, 420},
  {1396141200, 10800, 420},
  {1414285200, 7200, 420},
  {1427590800, 10800, 420},
  {1445734800, 7200, 420},
  {1459040400, 10800, 420},
  {1477789200, 7200, 420},
  {1490490000, 10800, 420},
  {1509238800, 7200, 420},
  {1521939600, 10800, 420},
  {1540688400, 7200, 420},
  {1553994000, 10800, 420},
  {1572138000, 7200, 420},
  {1585443600, 10800, 420},
  {1603587600, 7200, 420},
  {1616893200, 10800, 420},
  {1635642000, 7200, 420},
  {1648342800, 10800, 420},
  {1667091600, 7200, 420},
  {1679792400, 10800, 420},
  {1698541200, 7200, 420},
  {1711846800, 10800, 420},
  {1729990800, 7200, 420},
  {1743296400, 10800, 420},
  {1761440400, 7200, 420},
  {1774746000, 10800, 420},
  {1792890000, 7200, 420},
  {1806195600, 10800, 420},
  {1824944400, 7200, 420},
  {1837645200, 10800, 420},
  {1856394000, 7200, 420},
  {1869094800, 10800, 420},
  {1887843600, 7200, 420},
  {1901149200, 10800, 420},
  {1919293200, 7200, 420},
  {1932598800, 10800, 420},
  {1950742800, 7200, 420},
  {1964048400, 10800, 420},
  {1982797200, 7200, 420},
  {1995498000, 10800, 420},
  {2014246800, 7200, 420},
  {2026947600, 10800, 420},
  {2045696400, 7200, 420},
  {2058397200, 10800, 420},
  {2077146000, 7200, 420},
  {2090451600, 10800, 420},
  {2108595600, 7200, 420},
  {2121901200, 10800, 420},
  {2140045200, 7200, 420},
  {-1693706400, 7200, 421},
  {-1680483600, 3600, 421},
  {-1663455600, 7200, 421},
  {-1650150000, 3600, 421},
  {-1640998800, 3600, 421},
  {-1633212000, 7200, 421},
  {-1617577200, 3600, 421},
  {-1600466400, 7200, 421},
  {-1587250800, 3600, 421},
  {-1569708000, 7200, 421},
  {-1554332400, 3600, 421},
  {-906937200, 7200, 421},
  {-857257200, 3600, 421},
  {-844556400, 7200, 421},
  {-828226800, 3600, 421},
  {-812502000, 7200, 421},
  {-796777200, 3600, 421},
  {-788922000, 3600, 421},
  {-778471200, 7200, 421},
  {-762487200, 3600, 421},
  {-749689200, 7200, 421},
  {-733359600, 3600, 421},
  {-717634800, 7200, 421},
  {-701910000, 3600, 421},
  {-686185200, 7200, 421},
  {-670460400, 3600, 421},
  {-654130800, 7200, 421},
  {-639010800, 3600, 421},
  {-621990000, 7200, 421},
  {-605660400, 3600, 421},
  {-492656400, 7200, 421},
  {-481168800, 3600, 421},
  {-461120400, 7200, 421},
  {-449632800, 3600, 421},
  {-428547600, 7200, 421},
  {-418269600, 3600, 421},
  {-397094400, 7200, 421},
  {-386809200, 3600, 421},
  {323827200, 7200, 421},
  {338950800, 3600, 421},
  {354675600, 7200, 421},
  {370400400, 3600, 421},
  {386125200, 7200, 421},
  {401850000, 3600, 421},
  {417574800, 7200, 421},
  {433299600, 3600, 421},
  {449024400, 7200, 421},
  {465354000, 3600, 421},
  {481078800, 7200, 421},
  {496803600, 3600, 421},
  {512528400, 7200, 421},
  {528253200, 3600, 421},
  {543978000, 7200, 421},
  {559702800, 3600, 421},
  {575427600, 7200, 421},
  {591152400, 3600, 421},
  {606877200, 7200, 421},
  {622602000, 3600, 421},
  {638326800, 7200, 421},
  {654656400, 3600, 421},
  {670381200, 7200, 421},
  {686106000, 3600, 421},
  {701830800, 7200, 421},
  {717555600, 3600, 421},
  {733280400, 7200, 421},
  {749005200, 3600, 421},
  {764730000, 7200, 421},
  {780454800, 3600, 421},
  {796179600, 7200, 421},
  {811904400, 3600, 421},
  {828234000, 7200, 421},
  {846378000, 3600, 421},
  {859683600, 7200, 421},
  {877827600, 3600, 421},
  {891133200, 7200, 421},
  {909277200, 3600, 421},
  {922582800, 7200, 421},
  {941331600, 3600, 421},
  {954032400, 7200, 421},
  {972781200, 3600, 421},
  {985482000, 7200, 421},
  {1004230800, 3600, 421},
  {1017536400, 7200, 421},
  {1035680400, 3600, 421},
  {1048986000, 7200, 421},
  {1067130000, 3600, 421},
  {1080435600, 7200, 421},
  {1099184400, 3600, 421},
  {1111885200, 7200, 421},
  {1130634000, 3600, 421},
  {1143334800, 7200, 421},
  {1162083600, 3600, 421},
  {1174784400, 7200, 421},
  {1193533200, 3600, 421},
  {1206838800, 7200, 421},
  {1224982800, 3600, 421},
  {1238288400, 7200, 421},
  {1256432400, 3600, 421},
  {1269738000, 7200, 421},
  {1288486800, 3600, 421},
  {1301187600, 7200, 421},
  {1319936400, 3600, 421},
  {1332637200, 7200, 421},
  {1351386000, 3600, 421},
  {1364691600, 7200, 421},
  {1382835600, 3600, 421},
  {1396141200, 7200, 421},
  {1414285200, 3600, 421},
  {1427590800, 7200, 421},
  {1445734800, 3600, 421},
  {1459040400, 7200, 421},
  {1477789200, 3600, 421},
  {1490490000, 7200, 421},
  {1509238800, 3600, 421},
  {1521939600, 7200, 421},
  {1540688400, 3600, 421},
  {1553994000, 7200, 421},
  {1572138000, 3600, 421},
  {1585443600, 7200, 421},
  {1603587600, 3600, 421},
  {1616893200, 7200, 421},
  {1635642000, 3600, 421},
  {1648342800, 7200, 421},
  {1667091600, 3600, 421},
  {1679792400, 7200, 421},
  {1698541200, 3600, 421},
  {1711846800, 7200, 421},
  {1729990800, 3600, 421},
  {1743296400, 7200, 421},
  {1761440400, 3600, 421},
  {1774746000, 7200, 421},
  {1792890000, 3600, 421},
  {1806195600, 7200, 421},
  {1824944400, 3600, 421},
  {1837645200, 7200, 421},
  {1856394000, 3600, 421},
  {1869094800, 7200, 421},
  {1887843600, 3600, 421},
  {1901149200, 7200, 421},
  {1919293200, 3600, 421},
  {1932598800, 7200, 421},
  {1950742800, 3600, 421},
  {1964048400, 7200, 421},
  {1982797200, 3600, 421},
  {1995498000, 7200, 421},
  {2014246800, 3600, 421},
  {2026947600, 7200, 421},
  {2045696400, 3600, 421},
  {2058397200, 7200, 421},
  {2077146000, 3600, 421},
  {2090451600, 7200, 421},
  {2108595600, 3600, 421},
  {2121901200, 7200, 421},
  {2140045200, 3600, 421},
  {INT64_MIN, 6900, 422},
  {-1637114100, 6264, 422},
  {-1213148664, 7200, 422},
  {-1187056800, 10800, 422},
  {-1175479200, 7200, 422},
  {-1159754400, 10800, 422},
  {-1144029600, 7200, 422},
  {-1127700000, 10800, 422},
  {-1111975200, 7200, 422},
  {-1096250400, 10800, 422},
  {-1080525600, 7200, 422},
  {-1064800800, 10800, 422},
  {-1049076000, 7200, 422},
  {-1033351200, 10800, 422},
  {-1017626400, 7200, 422},
  {-1001901600, 10800, 422},
  {-986176800, 7200, 422},
  {-970452000, 10800, 422},
  {-954727200, 7200, 422},
  {-927165600, 10800, 422},
  {-898138800, 7200, 422},
  {-857257200, 3600, 422},
  {-844556400, 7200, 422},
  {-828226800, 3600, 422},
  {-812502000, 7200, 422},
  {-800157600, 10800, 422},
  {354920400, 14400, 422},
  {370728000, 10800, 422},
  {386456400, 14400, 422},
  {402264000, 10800, 422},
  {417992400, 14400, 422},
  {433800000, 10800, 422},
  {449614800, 14400, 422},
  {465346800, 10800, 422},
  {481071600, 14400, 422},
  {496796400, 10800, 422},
  {512521200, 14400, 422},
  {528246000, 10800, 422},
  {543970800, 14400, 422},
  {559695600, 10800, 422},
  {575420400, 14400, 422},
  {591145200, 10800, 422},
  {606870000, 14400, 422},
  {622594800, 10800, 422},
  {631141200, 10800, 422},
  {641941200, 7200, 422},
  {670377600, 10800, 422},
  {686102400, 7200, 422},
  {694216800, 7200, 422},
  {701820000, 10800, 422},
  {717541200, 7200, 422},
  {733269600, 10800, 422},
  {748990800, 7200, 422},
  {764719200, 10800, 422},
  {780440400, 7200, 422},
  {796168800, 10800, 422},
  {811890000, 7200, 422},
  {828223200, 10800, 422},
  {846363600, 7200, 422},
  {859683600, 10800, 422},
  {877827600, 7200, 422},
  {891133200, 10800, 422},
  {909277200, 7200, 422},
  {922582800, 10800, 422},
  {941331600, 7200, 422},
  {954032400, 10800, 422},
  {972781200, 7200, 422},
  {985482000, 10800, 422},
  {1004230800, 7200, 422},
  {1017536400, 10800, 422},
  {1035680400, 7200, 422},
  {1048986000, 10800, 422},
  {1067130000, 7200, 422},
  {1080435600, 10800, 422},
  {1099184400, 7200, 422},
  {1111885200, 10800, 422},
  {1130634000, 7200, 422},
  {1143334800, 10800, 422},
  {1162083600, 7200, 422},
  {1174784400, 10800, 422},
  {1193533200, 7200, 422},
  {1206838800, 10800, 422},
  {1224982800, 7200, 422},
  {1238288400, 10800, 422},
  {1256432400, 7200, 422},
  {1269738000, 10800, 422},
  {1288486800, 7200, 422},
  {1301187600, 10800, 422},
  {1319936400, 7200, 422},
  {1332637200, 10800, 422},
  {1351386000, 7200, 422},
  {1364691600, 10800, 422},
  {1382835600, 7200, 422},
  {1396141200, 10800, 422},
  {1414285200, 7200, 422},
  {1427590800, 10800, 422},
  {1445734800, 7200, 422},
  {1459040400, 10800, 422},
  {1477789200, 7200, 422},
  {1490490000, 10800, 422},
  {1509238800, 7200, 422},
  {1521939600, 10800, 422},
  {1540688400, 7200, 422},
  {1553994000, 10800, 422},
  {1572138000, 7200, 422},
  {1585443600, 10800, 422},
  {1603587600, 7200, 422},
  {1616893200, 10800, 422},
  {1635642000, 7200, 422},
  {1648342800, 10800, 422},
  {1667091600, 7200, 422},
  {1679792400, 10800, 422},
  {1698541200, 7200, 422},
  {1711846800, 10800, 422},
  {1729990800, 7200, 422},
  {1743296400, 10800, 422},
  {1761440400, 7200, 422},
  {1774746000, 10800, 422},
  {1792890000, 7200, 422},
  {1806195600, 10800, 422},
  {1824944400, 7200, 422},
  {1837645200, 10800, 422},
  {1856394000, 7200, 422},
  {1869094800, 10800, 422},
  {1887843600, 7200, 422},
  {1901149200, 10800, 422},
  {1919293200, 7200, 422},
  {1932598800, 10800, 422},
  {1950742800, 7200, 422},
  {1964048400, 10800, 422},
  {1982797200, 7200, 422},
  {1995498000, 10800, 422},
  {2014246800, 7200, 422},
  {2026947600, 10800, 422},
  {2045696400, 7200, 422},
  {2058397200, 10800, 422},
  {2077146000, 7200, 422},
  {2090451600, 10800, 422},
  {2108595600, 7200, 422},
  {2121901200, 10800, 422},
  {2140045200, 7200, 422},
  {-1692496800, 7200, 423},
  {-1680490800, 3600, 423},
  {-935110800, 7200, 423},
  {-857257200, 3600, 423},
  {-844556400, 7200, 423},
  {-828226800, 3600, 423},
  {-812502000, 7200, 423},
  {-796777200, 3600, 423},
  {-781052400, 7200, 423},
  {-769388400, 3600, 423},
  {-747010800, 7200, 423},
  {-736383600, 3600, 423},
  {-715215600, 7200, 423},
  {-706748400, 3600, 423},
  {-683161200, 7200, 423},
  {-675298800, 3600, 423},
  {315529200, 3600, 423},
  {323830800, 7200, 423},
  {338950800, 3600, 423},
  {354675600, 7200, 423},
  {370400400, 3600, 423},
  {386125200, 7200, 423},
  {401850000, 3600, 423},
  {417574800, 7200, 423},
  {433299600, 3600, 423},
  {449024400, 7200, 423},
  {465354000, 3600, 423},
  {481078800, 7200, 423},
  {496803600, 3600, 423},
  {512528400, 7200, 423},
  {528253200, 3600, 423},
  {543978000, 7200, 423},
  {559702800, 3600, 423},
  {575427600, 7200, 423},
  {591152400, 3600, 423},
  {606877200, 7200, 423},
  {622602000, 3600, 423},
  {638326800, 7200, 423},
  {654656400, 3600, 423},
  {670381200, 7200, 423},
  {686106000, 3600, 423},
  {701830800, 7200, 423},
  {717555600, 3600, 423},
  {733280400, 7200, 423},
  {749005200, 3600, 423},
  {764730000, 7200, 423},
  {780454800, 3600, 423},
  {796179600, 7200, 423},
  {811904400, 3600, 423},
  {828234000, 7200, 423},
  {846378000, 3600, 423},
  {859683600, 7200, 423},
  {877827600, 3600, 423},
  {891133200, 7200, 423},
  {909277200, 3600, 423},
  {922582800, 7200, 423},
  {941331600, 3600, 423},
  {954032400, 7200, 423},
  {972781200, 3600, 423},
  {985482000, 7200, 423},
  {1004230800, 3600, 423},
  {1017536400, 7200, 423},
  {1035680400, 3600, 423},
  {1048986000, 7200, 423},
  {1067130000, 3600, 423},
  {1080435600, 7200, 423},
  {1099184400, 3600, 423},
  {1111885200, 7200, 423},
  {1130634000, 3600, 423},
  {1143334800, 7200, 423},
  {1162083600, 3600, 423},
  {1174784400, 7200, 423},
  {1193533200, 3600, 423},
  {1206838800, 7200, 423},
  {1224982800, 3600, 423},
  {1238288400, 7200, 423},
  {1256432400, 3600, 423},
  {1269738000, 7200, 423},
  {1288486800, 3600, 423},
  {1301187600, 7200, 423},
  {1319936400, 3600, 423},
  {1332637200, 7200, 423},
  {1351386000, 3600, 423},
  {1364691600, 7200, 423},
  {1382835600, 3600, 423},
  {1396141200, 7200, 423},
  {1414285200, 3600, 423},
  {1427590800, 7200, 423},
  {1445734800, 3600, 423},
  {1459040400, 7200, 423},
  {1477789200, 3600, 423},
  {1490490000, 7200, 423},
  {1509238800, 3600, 423},
  {1521939600, 7200, 423},
  {1540688400, 3600, 423},
  {1553994000, 7200, 423},
  {1572138000, 3600, 423},
  {1585443600, 7200, 423},
  {1603587600, 3600, 423},
  {1616893200, 7200, 423},
  {1635642000, 3600, 423},
  {1648342800, 7200, 423},
  {1667091600, 3600, 423},
  {1679792400, 7200, 423},
  {1698541200, 3600, 423},
  {1711846800, 7200, 423},
  {1729990800, 3600, 423},
  {1743296400, 7200, 423},
  {1761440400, 3600, 423},
  {1774746000, 7200, 423},
  {1792890000, 3600, 423},
  {1806195600, 7200, 423},
  {1824944400, 3600, 423},
  {1837645200, 7200, 423},
  {1856394000, 3600, 423},
  {1869094800, 7200, 423},
  {1887843600, 3600, 423},
  {1901149200, 7200, 423},
  {1919293200, 3600, 423},
  {1932598800, 7200, 423},
  {1950742800, 3600, 423},
  {1964048400, 7200, 423},
  {1982797200, 3600, 423},
  {1995498000, 7200, 423},
  {2014246800, 3600, 423},
  {2026947600, 7200, 423},
  {2045696400, 3600, 423},
  {2058397200, 7200, 423},
  {2077146000, 3600, 423},
  {2090451600, 7200, 423},
  {2108595600, 3600, 423},
  {2121901200, 7200, 423},
  {2140045200, 3600, 423},
  {INT64_MIN, -1521, 424},
  {-1691962479, 2079, 424},
  {-1680471279, 0, 424},
  {-1664143200, 3600, 424},
  {-1650146400, 0, 424},
  {-1633903200, 3600, 424},
  {-1617487200, 0, 424},
  {-1601848800, 3600, 424},
  {-1586037600, 0, 424},
  {-1570399200, 3600, 424},
  {-1552168800, 0, 424},
  {-1538344800, 3600, 424},
  {-1522533600, 0, 424},
  {-1517011200, 0, 424},
  {-1507500000, 3600, 424},
  {-1490565600, 0, 424},
  {-1473631200, 3600, 424},
  {-1460930400, 0, 424},
  {-1442786400, 3600, 424},
  {-1428876000, 0, 424},
  {-1410732000, 3600, 424},
  {-1396216800, 0, 424},
  {-1379282400, 3600, 424},
  {-1364767200, 0, 424},
  {-1348437600, 3600, 424},
  {-1333317600, 0, 424},
  {-1315778400, 3600, 424},
  {-1301263200, 0, 424},
  {-1284328800, 3600, 424},
  {-1269813600, 0, 424},
  {-1253484000, 3600, 424},
  {-1238364000, 0, 424},
  {-1221429600, 3600, 424},
  {-1206914400, 0, 424},
  {-1189980000, 3600, 424},
  {-1175464800, 0, 424},
  {-1159135200, 3600, 424},
  {-1143410400, 0, 424},
  {-1126476000, 3600, 424},
  {-1111960800, 0, 424},
  {-1095631200, 3600, 424},
  {-1080511200, 0, 424},
  {-1063576800, 3600, 424},
  {-1049061600, 0, 424},
  {-1032127200, 3600, 424},
  {-1017612000, 0, 424},
  {-1001282400, 3600, 424},
  {-986162400, 0, 424},
  {-969228000, 3600, 424},
  {-950479200, 0, 424},
  {-942012000, 3600, 424},
  {-733359600, 0, 424},
  {-719445600, 3600, 424},
  {-699490800, 0, 424},
  {-684972000, 3600, 424},
  {-668037600, 0, 424},
  {-654732000, 3600, 424},
  {-636588000, 0, 424},
  {-622072800, 3600, 424},
  {-605743200, 0, 424},
  {-590623200, 3600, 424},
  {-574293600, 0, 424},
  {-558568800, 3600, 424},
  {-542239200, 0, 424},
  {-527119200, 3600, 424},
  {-512604000, 0, 424},
  {-496274400, 3600, 424},
  {-481154400, 0, 424},
  {-464220000, 3600, 424},
  {-449704800, 0, 424},
  {-432165600, 3600, 424},
  {-417650400, 0, 424},
  {-401320800, 3600, 424},
  {-386200800, 0, 424},
  {-369266400, 3600, 424},
  {-354751200, 0, 424},
  {-337816800, 3600, 424},
  {-323301600, 0, 424},
  {-306972000, 3600, 424},
  {-291852000, 0, 424},
  {-276732000, 3600, 424},
  {-257983200, 0, 424},
  {-245282400, 3600, 424},
  {-226533600, 0, 424},
  {-213228000, 3600, 424},
  {-195084000, 0, 424},
  {-182383200, 3600, 424},
  {-163634400, 0, 424},
  {-150933600, 3600, 424},
  {-132184800, 0, 424},
  {-119484000, 3600, 424},
  {-100735200, 0, 424},
  {-88034400, 3600, 424},
  {-68680800, 0, 424},
  {-59004000, 3600, 424},
  {-37242000, 3600, 424},
  {57722400, 0, 424},
  {69818400, 3600, 424},
  {89172000, 0, 424},
  {101268000, 3600, 424},
  {120621600, 0, 424},
  {132717600, 3600, 424},
  {152071200, 0, 424},
  {164167200, 3600, 424},
  {183520800, 0, 424},
  {196221600, 3600, 424},
  {214970400, 0, 424},
  {227671200, 3600, 424},
  {246420000, 0, 424},
  {259120800, 3600, 424},
  {278474400, 0, 424},
  {290570400, 3600, 424},
  {309924000, 0, 424},
  {322020000, 3600, 424},
  {341373600, 0, 424},
  {354675600, 3600, 424},
  {372819600, 0, 424},
  {386125200, 3600, 424},
  {404269200, 0, 424},
  {417574800, 3600, 424},
  {435718800, 0, 424},
  {449024400, 3600, 424},
  {467773200, 0, 424},
  {481078800, 3600, 424},
  {499222800, 0, 424},
  {512528400, 3600, 424},
  {530672400, 0, 424},
  {543978000, 3600, 424},
  {562122000, 0, 424},
  {575427600, 3600, 424},
  {593571600, 0, 424},
  {606877200, 3600, 424},
  {625626000, 0, 424},
  {638326800, 3600, 424},
  {657075600, 0, 424},
  {670381200, 3600, 424},
  {688525200, 0, 424},
  {701830800, 3600, 424},
  {719974800, 0, 424},
  {733280400, 3600, 424},
  {751424400, 0, 424},
  {764730000, 3600, 424},
  {782874000, 0, 424},
  {796179600, 3600, 424},
  {814323600, 0, 424},
  {820454400, 0, 424},
  {828234000, 3600, 424},
  {846378000, 0, 424},
  {859683600, 3600, 424},
  {877827600, 0, 424},
  {891133200, 3600, 424},
  {909277200, 0, 424},
  {922582800, 3600, 424},
  {941331600, 0, 424},
  {954032400, 3600, 424},
  {972781200, 0, 424},
  {985482000, 3600, 424},
  {1004230800, 0, 424},
  {1017536400, 3600, 424},
  {1035680400, 0, 424},
  {1048986000, 3600, 424},
  {1067130000, 0, 424},
  {1080435600, 3600, 424},
  {1099184400, 0, 424},
  {1111885200, 3600, 424},
  {1130634000, 0, 424},
  {1143334800, 3600, 424},
  {1162083600, 0, 424},
  {1174784400, 3600, 424},
  {1193533200, 0, 424},
  {1206838800, 3600, 424},
  {1224982800, 0, 424},
  {1238288400, 3600, 424},
  {1256432400, 0, 424},
  {1269738000, 3600, 424},
  {1288486800, 0, 424},
  {1301187600, 3600, 424},
  {1319936400, 0, 424},
  {1332637200, 3600, 424},
  {1351386000, 0, 424},
  {1364691600, 3600, 424},
  {1382835600, 0, 424},
  {1396141200, 3600, 424},
  {1414285200, 0, 424},
  {1427590800, 3600, 424},
  {1445734800, 0, 424},
  {1459040400, 3600, 424},
  {1477789200, 0, 424},
  {1490490000, 3600, 424},
  {1509238800, 0, 424},
  {1521939600, 3600, 424},
  {1540688400, 0, 424},
  {1553994000, 3600, 424},
  {1572138000, 0, 424},
  {1585443600, 3600, 424},
  {1603587600, 0, 424},
  {1616893200, 3600, 424},
  {1635642000, 0, 424},
  {1648342800, 3600, 424},
  {1667091600, 0, 424},
  {1679792400, 3600, 424},
  {1698541200, 0, 424},
  {1711846800, 3600, 424},
  {1729990800, 0, 424},
  {1743296400, 3600, 424},
  {1761440400, 0, 424},
  {1774746000, 3600, 424},
  {1792890000, 0, 424},
  {1806195600, 3600, 424},
  {1824944400, 0, 424},
  {1837645200, 3600, 424},
  {1856394000, 0, 424},
  {1869094800, 3600, 424},
  {1887843600, 0, 424},
  {1901149200, 3600, 424},
  {1919293200, 0, 424},
  {1932598800, 3600, 424},
  {1950742800, 0, 424},
  {1964048400, 3600, 424},
  {1982797200, 0, 424},
  {1995498000, 3600, 424},
  {2014246800, 0, 424},
  {2026947600, 3600, 424},
  {2045696400, 0, 424},
  {2058397200, 3600, 424},
  {2077146000, 0, 424},
  {2090451600, 3600, 424},
  {2108595600, 0, 424},
  {2121901200, 3600, 424},
  {2140045200, 0, 424},
  {-1691964000, 3600, 425},
  {-1680472800, 0, 425},
  {-1664143200, 3600, 425},
  {-1650146400, 0, 425},
  {-1633903200, 3600, 425},
  {-1617487200, 0, 425},
  {-1601848800, 3600, 425},
  {-1586037600, 0, 425},
  {-1570399200, 3600, 425},
  {-1552168800, 0, 425},
  {-1538344800, 3600, 425},
  {-1522533600, 0, 425},
  {-1507500000, 3600, 425},
  {-1490565600, 0, 425},
  {-1473631200, 3600, 425},
  {-1460930400, 0, 425},
  {-1442786400, 3600, 425},
  {-1428876000, 0, 425},
  {-1410732000, 3600, 425},
  {-1396216800, 0, 425},
  {-1379282400, 3600, 425},
  {-1364767200, 0, 425},
  {-1348437600, 3600, 425},
  {-1333317600, 0, 425},
  {-1315778400, 3600, 425},
  {-1301263200, 0, 425},
  {-1284328800, 3600, 425},
  {-1269813600, 0, 425},
  {-1253484000, 3600, 425},
  {-1238364000, 0, 425},
  {-1221429600, 3600, 425},
  {-1206914400, 0, 425},
  {-1189980000, 3600, 425},
  {-1175464800, 0, 425},
  {-1159135200, 3600, 425},
  {-1143410400, 0, 425},
  {-1126476000, 3600, 425},
  {-1111960800, 0, 425},
  {-1095631200, 3600, 425},
  {-1080511200, 0, 425},
  {-1063576800, 3600, 425},
  {-1049061600, 0, 425},
  {-1032127200, 3600, 425},
  {-1017612000, 0, 425},
  {-1001282400, 3600, 425},
  {-986162400, 0, 425},
  {-969228000, 3600, 425},
  {-950479200, 0, 425},
  {-942012000, 3600, 425},
  {-904518000, 7200, 425},
  {-896050800, 3600, 425},
  {-875487600, 7200, 425},
  {-864601200, 3600, 425},
  {-844038000, 7200, 425},
  {-832546800, 3600, 425},
  {-812588400, 7200, 425},
  {-798073200, 3600, 425},
  {-781052400, 7200, 425},
  {-772066800, 3600, 425},
  {-764805600, 0, 425},
  {-748476000, 3600, 425},
  {-733356000, 0, 425},
  {-719445600, 3600, 425},
  {-717030000, 7200, 425},
  {-706748400, 3600, 425},
  {-699487200, 0, 425},
  {-687996000, 3600, 425},
  {-668037600, 0, 425},
  {-654732000, 3600, 425},
  {-636588000, 0, 425},
  {-622072800, 3600, 425},
  {-605743200, 0, 425},
  {-590623200, 3600, 425},
  {-574293600, 0, 425},
  {-558568800, 3600, 425},
  {-542239200, 0, 425},
  {-527119200, 3600, 425},
  {-512604000, 0, 425},
  {-496274400, 3600, 425},
  {-481154400, 0, 425},
  {-464220000, 3600, 425},
  {-449704800, 0, 425},
  {-432165600, 3600, 425},
  {-417650400, 0, 425},
  {-401320800, 3600, 425},
  {386125200, 7200, 425},
  {401850000, 3600, 425},
  {417574800, 7200, 425},
  {433299600, 3600, 425},
  {449024400, 7200, 425},
  {465354000, 3600, 425},
  {481078800, 7200, 425},
  {496803600, 3600, 425},
  {512528400, 7200, 425},
  {528253200, 3600, 425},
  {543978000, 7200, 425},
  {559702800, 3600, 425},
  {575427600, 7200, 425},
  {591152400, 3600, 425},
  {606877200, 7200, 425},
  {622602000, 3600, 425},
  {638326800, 7200, 425},
  {654656400, 3600, 425},
  {670381200, 7200, 425},
  {686106000, 3600, 425},
  {701830800, 7200, 425},
  {717555600, 3600, 425},
  {733280400, 7200, 425},
  {749005200, 3600, 425},
  {764730000, 7200, 425},
  {780454800, 3600, 425},
  {796179600, 7200, 425},
  {811904400, 3600, 425},
  {828234000, 7200, 425},
  {846378000, 3600, 425},
  {859683600, 7200, 425},
  {877827600, 3600, 425},
  {891133200, 7200, 425},
  {909277200, 3600, 425},
  {922582800, 7200, 425},
  {941331600, 3600, 425},
  {954032400, 7200, 425},
  {972781200, 3600, 425},
  {985482000, 7200, 425},
  {1004230800, 3600, 425},
  {1017536400, 7200, 425},
  {1035680400, 3600, 425},
  {1048986000, 7200, 425},
  {1067130000, 3600, 425},
  {1080435600, 7200, 425},
  {1099184400, 3600, 425},
  {1111885200, 7200, 425},
  {1130634000, 3600, 425},
  {1143334800, 7200, 425},
  {1162083600, 3600, 425},
  {1174784400, 7200, 425},
  {1193533200, 3600, 425},
  {1206838800, 7200, 425},
  {1224982800, 3600, 425},
  {1238288400, 7200, 425},
  {1256432400, 3600, 425},
  {1269738000, 7200, 425},
  {1288486800, 3600, 425},
  {1301187600, 7200, 425},
  {1319936400, 3600, 425},
  {1332637200, 7200, 425},
  {1351386000, 3600, 425},
  {1364691600, 7200, 425},
  {1382835600, 3600, 425},
  {1396141200, 7200, 425},
  {1414285200, 3600, 425},
  {1427590800, 7200, 425},
  {1445734800, 3600, 425},
  {1459040400, 7200, 425},
  {1477789200, 3600, 425},
  {1490490000, 7200, 425},
  {1509238800, 3600, 425},
  {1521939600, 7200, 425},
  {1540688400, 3600, 425},
  {1553994000, 7200, 425},
  {1572138000, 3600, 425},
  {1585443600, 7200, 425},
  {1603587600, 3600, 425},
  {1616893200, 7200, 425},
  {1635642000, 3600, 425},
  {1648342800, 7200, 425},
  {1667091600, 3600, 425},
  {1679792400, 7200, 425},
  {1698541200, 3600, 425},
  {1711846800, 7200, 425},
  {1729990800, 3600, 425},
  {1743296400, 7200, 425},
  {1761440400, 3600, 425},
  {1774746000, 7200, 425},
  {1792890000, 3600, 425},
  {1806195600, 7200, 425},
  {1824944400, 3600, 425},
  {1837645200, 7200, 425},
  {1856394000, 3600, 425},
  {1869094800, 7200, 425},
  {1887843600, 3600, 425},
  {1901149200, 7200, 425},
  {1919293200, 3600, 425},
  {1932598800, 7200, 425},
  {1950742800, 3600, 425},
  {1964048400, 7200, 425},
  {1982797200, 3600, 425},
  {1995498000, 7200, 425},
  {2014246800, 3600, 425},
  {2026947600, 7200, 425},
  {2045696400, 3600, 425},
  {2058397200, 7200, 425},
  {2077146000, 3600, 425},
  {2090451600, 7200, 425},
  {2108595600, 3600, 425},
  {2121901200, 7200, 425},
  {2140045200, 3600, 425},
  {-1691964000, 3600, 426},
  {-1680472800, 0, 426},
  {-1664143200, 3600, 426},
  {-1650146400, 0, 426},
  {-1633903200, 3600, 426},
  {-1617487200, 0, 426},
  {-1601848800, 3600, 426},
  {-1586037600, 0, 426},
  {-1570399200, 3600, 426},
  {-1552168800, 0, 426},
  {-1538344800, 3600, 426},
  {-1522533600, 0, 426},
  {-1507500000, 3600, 426},
  {-1490565600, 0, 426},
  {-1473631200, 3600, 426},
  {-1460930400, 0, 426},
  {-1442786400, 3600, 426},
  {-1428876000, 0, 426},
  {-1410732000, 3600, 426},
  {-1396216800, 0, 426},
  {-1379282400, 3600, 426},
  {-1364767200, 0, 426},
  {-1348437600, 3600, 426},
  {-1333317600, 0, 426},
  {-1315778400, 3600, 426},
  {-1301263200, 0, 426},
  {-1284328800, 3600, 426},
  {-1269813600, 0, 426},
  {-1253484000, 3600, 426},
  {-1238364000, 0, 426},
  {-1221429600, 3600, 426},
  {-1206914400, 0, 426},
  {-1189980000, 3600, 426},
  {-1175464800, 0, 426},
  {-1159135200, 3600, 426},
  {-1143410400, 0, 426},
  {-1126476000, 3600, 426},
  {-1111960800, 0, 426},
  {-1095631200, 3600, 426},
  {-1080511200, 0, 426},
  {-1063576800, 3600, 426},
  {-1049061600, 0, 426},
  {-1032127200, 3600, 426},
  {-1017612000, 0, 426},
  {-1001282400, 3600, 426},
  {-986162400, 0, 426},
  {-969228000, 3600, 426},
  {-950479200, 0, 426},
  {-942012000, 3600, 426},
  {-904518000, 7200, 426},
  {-896050800, 3600, 426},
  {-875487600, 7200, 426},
  {-864601200, 3600, 426},
  {-844038000, 7200, 426},
  {-832546800, 3600, 426},
  {-812588400, 7200, 426},
  {-798073200, 3600, 426},
  {-781052400, 7200, 426},
  {-772066800, 3600, 426},
  {-764805600, 0, 426},
  {-748476000, 3600, 426},
  {-733356000, 0, 426},
  {-719445600, 3600, 426},
  {-717030000, 7200, 426},
  {-706748400, 3600, 426},
  {-699487200, 0, 426},
  {-687996000, 3600, 426},
  {-668037600, 0, 426},
  {-654732000, 3600, 426},
  {-636588000, 0, 426},
  {-622072800, 3600, 426},
  {-605743200, 0, 426},
  {-590623200, 3600, 426},
  {-574293600, 0, 426},
  {-558568800, 3600, 426},
  {-542239200, 0, 426},
  {-527119200, 3600, 426},
  {-512604000, 0, 426},
  {-496274400, 3600, 426},
  {-481154400, 0, 426},
  {-464220000, 3600, 426},
  {-449704800, 0, 426},
  {-432165600, 3600, 426},
  {-417650400, 0, 426},
  {-401320800, 3600, 426},
  {-386200800, 0, 426},
  {-369266400, 3600, 426},
  {-354751200, 0, 426},
  {-337816800, 3600, 426},
  {-323301600, 0, 426},
  {-306972000, 3600, 426},
  {-291852000, 0, 426},
  {-276732000, 3600, 426},
  {-257983200, 0, 426},
  {-245282400, 3600, 426},
  {-226533600, 0, 426},
  {-213228000, 3600, 426},
  {-195084000, 0, 426},
  {-182383200, 3600, 426},
  {-163634400, 0, 426},
  {-150933600, 3600, 426},
  {-132184800, 0, 426},
  {-119484000, 3600, 426},
  {-100735200, 0, 426},
  {-88034400, 3600, 426},
  {-68680800, 0, 426},
  {-59004000, 3600, 426},
  {-37242000, 3600, 426},
  {57722400, 0, 426},
  {69818400, 3600, 426},
  {89172000, 0, 426},
  {101268000, 3600, 426},
  {120621600, 0, 426},
  {132717600, 3600, 426},
  {152071200, 0, 426},
  {164167200, 3600, 426},
  {183520800, 0, 426},
  {196221600, 3600, 426},
  {214970400, 0, 426},
  {227671200, 3600, 426},
  {246420000, 0, 426},
  {259120800, 3600, 426},
  {278474400, 0, 426},
  {290570400, 3600, 426},
  {309924000, 0, 426},
  {322020000, 3600, 426},
  {341373600, 0, 426},
  {354675600, 3600, 426},
  {372819600, 0, 426},
  {386125200, 3600, 426},
  {404269200, 0, 426},
  {417574800, 3600, 426},
  {435718800, 0, 426},
  {449024400, 3600, 426},
  {467773200, 0, 426},
  {481078800, 3600, 426},
  {499222800, 0, 426},
  {512528400, 3600, 426},
  {530672400, 0, 426},
  {543978000, 3600, 426},
  {562122000, 0, 426},
  {575427600, 3600, 426},
  {593571600, 0, 426},
  {606877200, 3600, 426},
  {625626000, 0, 426},
  {638326800, 3600, 426},
  {657075600, 0, 426},
  {670381200, 3600, 426},
  {688525200, 0, 426},
  {701830800, 3600, 426},
  {719974800, 0, 426},
  {733280400, 3600, 426},
  {751424400, 0, 426},
  {764730000, 3600, 426},
  {782874000, 0, 426},
  {796179600, 3600, 426},
  {814323600, 0, 426},
  {820454400, 0, 426},
  {828234000, 3600, 426},
  {846378000, 0, 426},
  {859683600, 3600, 426},
  {877827600, 0, 426},
  {891133200, 3600, 426},
  {909277200, 0, 426},
  {922582800, 3600, 426},
  {941331600, 0, 426},
  {954032400, 3600, 426},
  {972781200, 0, 426},
  {985482000, 3600, 426},
  {1004230800, 0, 426},
  {1017536400, 3600, 426},
  {1035680400, 0, 426},
  {1048986000, 3600, 426},
  {1067130000, 0, 426},
  {1080435600, 3600, 426},
  {1099184400, 0, 426},
  {1111885200, 3600, 426},
  {1130634000, 0, 426},
  {1143334800, 3600, 426},
  {1162083600, 0, 426},
  {1174784400, 3600, 426},
  {1193533200, 0, 426},
  {1206838800, 3600, 426},
  {1224982800, 0, 426},
  {1238288400, 3600, 426},
  {1256432400, 0, 426},
  {1269738000, 3600, 426},
  {1288486800, 0, 426},
  {1301187600, 3600, 426},
  {1319936400, 0, 426},
  {1332637200, 3600, 426},
  {1351386000, 0, 426},
  {1364691600, 3600, 426},
  {1382835600, 0, 426},
  {1396141200, 3600, 426},
  {1414285200, 0, 426},
  {1427590800, 3600, 426},
  {1445734800, 0, 426},
  {1459040400, 3600, 426},
  {1477789200, 0, 426},
  {1490490000, 3600, 426},
  {1509238800, 0, 426},
  {1521939600, 3600, 426},
  {1540688400, 0, 426},
  {1553994000, 3600, 426},
  {1572138000, 0, 426},
  {1585443600, 3600, 426},
  {1603587600, 0, 426},
  {1616893200, 3600, 426},
  {1635642000, 0, 426},
  {1648342800, 3600, 426},
  {1667091600, 0, 426},
  {1679792400, 3600, 426},
  {1698541200, 0, 426},
  {1711846800, 3600, 426},
  {1729990800, 0, 426},
  {1743296400, 3600, 426},
  {1761440400, 0, 426},
  {1774746000, 3600, 426},
  {1792890000, 0, 426},
  {1806195600, 3600, 426},
  {1824944400, 0, 426},
  {1837645200, 3600, 426},
  {1856394000, 0, 426},
  {1869094800, 3600, 426},
  {1887843600, 0, 426},
  {1901149200, 3600, 426},
  {1919293200, 0, 426},
  {1932598800, 3600, 426},
  {1950742800, 0, 426},
  {1964048400, 3600, 426},
  {1982797200, 0, 426},
  {1995498000, 3600, 426},
  {2014246800, 0, 426},
  {2026947600, 3600, 426},
  {2045696400, 0, 426},
  {2058397200, 3600, 426},
  {2077146000, 0, 426},
  {2090451600, 3600, 426},
  {2108595600, 0, 426},
  {2121901200, 3600, 426},
  {2140045200, 0, 426},
  {INT64_MIN, 5992, 427},
  {-1535938792, 7200, 427},
  {-875671200, 10800, 427},
  {-859863600, 7200, 427},
  {354672000, 10800, 427},
  {370396800, 7200, 427},
  {386121600, 10800, 427},
  {401846400, 7200, 427},
  {417574800, 10800, 427},
  {433299600, 7200, 427},
  {449024400, 10800, 427},
  {465354000, 7200, 427},
  {481078800, 10800, 427},
  {496803600, 7200, 427},
  {512528400, 10800, 427},
  {528253200, 7200, 427},
  {543978000, 10800, 427},
  {559702800, 7200, 427},
  {575427600, 10800, 427},
  {591152400, 7200, 427},
  {606877200, 10800, 427},
  {622602000, 7200, 427},
  {638326800, 10800, 427},
  {654656400, 7200, 427},
  {670381200, 10800, 427},
  {686106000, 7200, 427},
  {701830800, 10800, 427},
  {717555600, 7200, 427},
  {733280400, 10800, 427},
  {749005200, 7200, 427},
  {764730000, 10800, 427},
  {780454800, 7200, 427},
  {796179600, 10800, 427},
  {811904400, 7200, 427},
  {828234000, 10800, 427},
  {846378000, 7200, 427},
  {859683600, 10800, 427},
  {877827600, 7200, 427},
  {891133200, 10800, 427},
  {909277200, 7200, 427},
  {922582800, 10800, 427},
  {941331600, 7200, 427},
  {954032400, 10800, 427},
  {972781200, 7200, 427},
  {985482000, 10800, 427},
  {1004230800, 7200, 427},
  {1017536400, 10800, 427},
  {1035680400, 7200, 427},
  {1048986000, 10800, 427},
  {1067130000, 7200, 427},
  {1080435600, 10800, 427},
  {1099184400, 7200, 427},
  {1111885200, 10800, 427},
  {1130634000, 7200, 427},
  {1143334800, 10800, 427},
  {1162083600, 7200, 427},
  {1174784400, 10800, 427},
  {1193533200, 7200, 427},
  {1206838800, 10800, 427},
  {1224982800, 7200, 427},
  {1238288400, 10800, 427},
  {1256432400, 7200, 427},
  {1269738000, 10800, 427},
  {1288486800, 7200, 427},
  {1301187600, 10800, 427},
  {1319936400, 7200, 427},
  {1332637200, 10800, 427},
  {1351386000, 7200, 427},
  {1364691600, 10800, 427},
  {1382835600, 7200, 427},
  {1396141200, 10800, 427},
  {1414285200, 7200, 427},
  {1427590800, 10800, 427},
  {1445734800, 7200, 427},
  {1459040400, 10800, 427},
  {1477789200, 7200, 427},
  {1490490000, 10800, 427},
  {1509238800, 7200, 427},
  {1521939600, 10800, 427},
  {1540688400, 7200, 427},
  {1553994000, 10800, 427},
  {1572138000, 7200, 427},
  {1585443600, 10800, 427},
  {1603587600, 7200, 427},
  {1616893200, 10800, 427},
  {1635642000, 7200, 427},
  {1648342800, 10800, 427},
  {1667091600, 7200, 427},
  {1679792400, 10800, 427},
  {1698541200, 7200, 427},
  {1711846800, 10800, 427},
  {1729990800, 7200, 427},
  {1743296400, 10800, 427},
  {1761440400, 7200, 427},
  {1774746000, 10800, 427},
  {1792890000, 7200, 427},
  {1806195600, 10800, 427},
  {1824944400, 7200, 427},
  {1837645200, 10800, 427},
  {1856394000, 7200, 427},
  {1869094800, 10800, 427},
  {1887843600, 7200, 427},
  {1901149200, 10800, 427},
  {1919293200, 7200, 427},
  {1932598800, 10800, 427},
  {1950742800, 7200, 427},
  {1964048400, 10800, 427},
  {1982797200, 7200, 427},
  {1995498000, 10800, 427},
  {2014246800, 7200, 427},
  {2026947600, 10800, 427},
  {2045696400, 7200, 427},
  {2058397200, 10800, 427},
  {2077146000, 7200, 427},
  {2090451600, 10800, 427},
  {2108595600, 7200, 427},
  {2121901200, 10800, 427},
  {2140045200, 7200, 427},
  {-1691964000, 3600, 428},
  {-1680472800, 0, 428},
  {-1664143200, 3600, 428},
  {-1650146400, 0, 428},
  {-1633903200, 3600, 428},
  {-1617487200, 0, 428},
  {-1601848800, 3600, 428},
  {-1586037600, 0, 428},
  {-1570399200, 3600, 428},
  {-1552168800, 0, 428},
  {-1538344800, 3600, 428},
  {-1522533600, 0, 428},
  {-1507500000, 3600, 428},
  {-1490565600, 0, 428},
  {-1473631200, 3600, 428},
  {-1460930400, 0, 428},
  {-1442786400, 3600, 428},
  {-1428876000, 0, 428},
  {-1410732000, 3600, 428},
  {-1396216800, 0, 428},
  {-1379282400, 3600, 428},
  {-1364767200, 0, 428},
  {-1348437600, 3600, 428},
  {-1333317600, 0, 428},
  {-1315778400, 3600, 428},
  {-1301263200, 0, 428},
  {-1284328800, 3600, 428},
  {-1269813600, 0, 428},
  {-1253484000, 3600, 428},
  {-1238364000, 0, 428},
  {-1221429600, 3600, 428},
  {-1206914400, 0, 428},
  {-1189980000, 3600, 428},
  {-1175464800, 0, 428},
  {-1159135200, 3600, 428},
  {-1143410400, 0, 428},
  {-1126476000, 3600, 428},
  {-1111960800, 0, 428},
  {-1095631200, 3600, 428},
  {-1080511200, 0, 428},
  {-1063576800, 3600, 428},
  {-1049061600, 0, 428},
  {-1032127200, 3600, 428},
  {-1017612000, 0, 428},
  {-1001282400, 3600, 428},
  {-986162400, 0, 428},
  {-969228000, 3600, 428},
  {-950479200, 0, 428},
  {-942012000, 3600, 428},
  {-904518000, 7200, 428},
  {-896050800, 3600, 428},
  {-875487600, 7200, 428},
  {-864601200, 3600, 428},
  {-844038000, 7200, 428},
  {-832546800, 3600, 428},
  {-812588400, 7200, 428},
  {-798073200, 3600, 428},
  {-781052400, 7200, 428},
  {-772066800, 3600, 428},
  {-764805600, 0, 428},
  {-748476000, 3600, 428},
  {-733356000, 0, 428},
  {-719445600, 3600, 428},
  {-717030000, 7200, 428},
  {-706748400, 3600, 428},
  {-699487200, 0, 428},
  {-687996000, 3600, 428},
  {-668037600, 0, 428},
  {-654732000, 3600, 428},
  {-636588000, 0, 428},
  {-622072800, 3600, 428},
  {-605743200, 0, 428},
  {-590623200, 3600, 428},
  {-574293600, 0, 428},
  {-558568800, 3600, 428},
  {-542239200, 0, 428},
  {-527119200, 3600, 428},
  {-512604000, 0, 428},
  {-496274400, 3600, 428},
  {-481154400, 0, 428},
  {-464220000, 3600, 428},
  {-449704800, 0, 428},
  {-432165600, 3600, 428},
  {-417650400, 0, 428},
  {-401320800, 3600, 428},
  {-386200800, 0, 428},
  {-369266400, 3600, 428},
  {-354751200, 0, 428},
  {-337816800, 3600, 428},
  {-323301600, 0, 428},
  {-306972000, 3600, 428},
  {-291852000, 0, 428},
  {-276732000, 3600, 428},
  {-257983200, 0, 428},
  {-245282400, 3600, 428},
  {-226533600, 0, 428},
  {-213228000, 3600, 428},
  {-195084000, 0, 428},
  {-182383200, 3600, 428},
  {-163634400, 0, 428},
  {-150933600, 3600, 428},
  {-132184800, 0, 428},
  {-119484000, 3600, 428},
  {-100735200, 0, 428},
  {-88034400, 3600, 428},
  {-68680800, 0, 428},
  {-59004000, 3600, 428},
  {-37242000, 3600, 428},
  {57722400, 0, 428},
  {69818400, 3600, 428},
  {89172000, 0, 428},
  {101268000, 3600, 428},
  {120621600, 0, 428},
  {132717600, 3600, 428},
  {152071200, 0, 428},
  {164167200, 3600, 428},
  {183520800, 0, 428},
  {196221600, 3600, 428},
  {214970400, 0, 428},
  {227671200, 3600, 428},
  {246420000, 0, 428},
  {259120800, 3600, 428},
  {278474400, 0, 428},
  {290570400, 3600, 428},
  {309924000, 0, 428},
  {322020000, 3600, 428},
  {341373600, 0, 428},
  {354675600, 3600, 428},
  {372819600, 0, 428},
  {386125200, 3600, 428},
  {404269200, 0, 428},
  {417574800, 3600, 428},
  {435718800, 0, 428},
  {449024400, 3600, 428},
  {467773200, 0, 428},
  {481078800, 3600, 428},
  {499222800, 0, 428},
  {512528400, 3600, 428},
  {530672400, 0, 428},
  {543978000, 3600, 428},
  {562122000, 0, 428},
  {575427600, 3600, 428},
  {593571600, 0, 428},
  {606877200, 3600, 428},
  {625626000, 0, 428},
  {638326800, 3600, 428},
  {657075600, 0, 428},
  {670381200, 3600, 428},
  {688525200, 0, 428},
  {701830800, 3600, 428},
  {719974800, 0, 428},
  {733280400, 3600, 428},
  {751424400, 0, 428},
  {764730000, 3600, 428},
  {782874000, 0, 428},
  {796179600, 3600, 428},
  {814323600, 0, 428},
  {820454400, 0, 428},
  {828234000, 3600, 428},
  {846378000, 0, 428},
  {859683600, 3600, 428},
  {877827600, 0, 428},
  {891133200, 3600, 428},
  {909277200, 0, 428},
  {922582800, 3600, 428},
  {941331600, 0, 428},
  {954032400, 3600, 428},
  {972781200, 0, 428},
  {985482000, 3600, 428},
  {1004230800, 0, 428},
  {1017536400, 3600, 428},
  {1035680400, 0, 428},
  {1048986000, 3600, 428},
  {1067130000, 0, 428},
  {1080435600, 3600, 428},
  {1099184400, 0, 428},
  {1111885200, 3600, 428},
  {1130634000, 0, 428},
  {1143334800, 3600, 428},
  {1162083600, 0, 428},
  {1174784400, 3600, 428},
  {1193533200, 0, 428},
  {1206838800, 3600, 428},
  {1224982800, 0, 428},
  {1238288400, 3600, 428},
  {1256432400, 0, 428},
  {1269738000, 3600, 428},
  {1288486800, 0, 428},
  {1301187600, 3600, 428},
  {1319936400, 0, 428},
  {1332637200, 3600, 428},
  {1351386000, 0, 428},
  {1364691600, 3600, 428},
  {1382835600, 0, 428},
  {1396141200, 3600, 428},
  {1414285200, 0, 428},
  {1427590800, 3600, 428},
  {1445734800, 0, 428},
  {1459040400, 3600, 428},
  {1477789200, 0, 428},
  {1490490000, 3600, 428},
  {1509238800, 0, 428},
  {1521939600, 3600, 428},
  {1540688400, 0, 428},
  {1553994000, 3600, 428},
  {1572138000, 0, 428},
  {1585443600, 3600, 428},
  {1603587600, 0, 428},
  {1616893200, 3600, 428},
  {1635642000, 0, 428},
  {1648342800, 3600, 428},
  {1667091600, 0, 428},
  {1679792400, 3600, 428},
  {1698541200, 0, 428},
  {1711846800, 3600, 428},
  {1729990800, 0, 428},
  {1743296400, 3600, 428},
  {1761440400, 0, 428},
  {1774746000, 3600, 428},
  {1792890000, 0, 428},
  {1806195600, 3600, 428},
  {1824944400, 0, 428},
  {1837645200, 3600, 428},
  {1856394000, 0, 428},
  {1869094800, 3600, 428},
  {1887843600, 0, 428},
  {1901149200, 3600, 428},
  {1919293200, 0, 428},
  {1932598800, 3600, 428},
  {1950742800, 0, 428},
  {1964048400, 3600, 428},
  {1982797200, 0, 428},
  {1995498000, 3600, 428},
  {2014246800, 0, 428},
  {2026947600, 3600, 428},
  {2045696400, 0, 428},
  {2058397200, 3600, 428},
  {2077146000, 0, 428},
  {2090451600, 3600, 428},
  {2108595600, 0, 428},
  {2121901200, 3600, 428},
  {2140045200, 0, 428},
  {INT64_MIN, 7016, 429},
  {-1869875816, 7200, 429},
  {-1693706400, 10800, 429},
  {-1680490800, 7200, 429},
  {-1570413600, 10800, 429},
  {-1552186800, 7200, 429},
  {-1538359200, 10800, 429},
  {-1522551600, 7200, 429},
  {-1507514400, 10800, 429},
  {-1490583600, 7200, 429},
  {-1440208800, 10800, 429},
  {-1428030000, 7200, 429},
  {-1409709600, 10800, 429},
  {-1396494000, 7200, 429},
  {-931140000, 10800, 429},
  {-922762800, 7200, 429},
  {-917834400, 10800, 429},
  {-892436400, 7200, 429},
  {-875844000, 10800, 429},
  {-857358000, 7200, 429},
  {-781063200, 10800, 429},
  {-764737200, 7200, 429},
  {-744343200, 10800, 429},
  {-733806000, 7200, 429},
  {-716436000, 10800, 429},
  {-701924400, 7200, 429},
  {-684986400, 10800, 429},
  {-670474800, 7200, 429},
  {-654141600, 10800, 429},
  {-639025200, 7200, 429},
  {-621828000, 10800, 429},
  {-606970800, 7200, 429},
  {-590032800, 10800, 429},
  {-575434800, 7200, 429},
  {-235620000, 10800, 429},
  {-228279600, 7200, 429},
  {-177732000, 10800, 429},
  {-165726000, 7200, 429},
  {10533600, 10800, 429},
  {23835600, 7200, 429},
  {41983200, 10800, 429},
  {55285200, 7200, 429},
  {74037600, 10800, 429},
  {87339600, 7200, 429},
  {107910000, 10800, 429},
  {121219200, 7200, 429},
  {133920000, 10800, 429},
  {152676000, 7200, 429},
  {165362400, 10800, 429},
  {183502800, 7200, 429},
  {202428000, 10800, 429},
  {215557200, 7200, 429},
  {228866400, 10800, 429},
  {245797200, 7200, 429},
  {260316000, 10800, 429},
  {277246800, 14400, 429},
  {308779200, 10800, 429},
  {323827200, 14400, 429},
  {340228800, 10800, 429},
  {354672000, 14400, 429},
  {371678400, 10800, 429},
  {386121600, 14400, 429},
  {403128000, 10800, 429},
  {428446800, 14400, 429},
  {433886400, 10800, 429},
  {482792400, 10800, 429},
  {496702800, 7200, 429},
  {512524800, 10800, 429},
  {528249600, 7200, 429},
  {543974400, 10800, 429},
  {559699200, 7200, 429},
  {575424000, 10800, 429},
  {591148800, 7200, 429},
  {606873600, 10800, 429},
  {622598400, 7200, 429},
  {638323200, 10800, 429},
  {654652800, 7200, 429},
  {670374000, 10800, 429},
  {686098800, 7200, 429},
  {701823600, 10800, 429},
  {717548400, 7200, 429},
  {733273200, 10800, 429},
  {748998000, 7200, 429},
  {764722800, 10800, 429},
  {780447600, 7200, 429},
  {796172400, 10800, 429},
  {811897200, 7200, 429},
  {828226800, 10800, 429},
  {846370800, 7200, 429},
  {859676400, 10800, 429},
  {877820400, 7200, 429},
  {891126000, 10800, 429},
  {909270000, 7200, 429},
  {922575600, 10800, 429},
  {941324400, 7200, 429},
  {954025200, 10800, 429},
  {972774000, 7200, 429},
  {985474800, 10800, 429},
  {1004223600, 7200, 429},
  {1017529200, 10800, 429},
  {1035673200, 7200, 429},
  {1048978800, 10800, 429},
  {1067122800, 7200, 429},
  {1080428400, 10800, 429},
  {1099177200, 7200, 429},
  {1111878000, 10800, 429},
  {1130626800, 7200, 429},
  {1143327600, 10800, 429},
  {1162076400, 7200, 429},
  {1167602400, 7200, 429},
  {1174784400, 10800, 429},
  {1193533200, 7200, 429},
  {1206838800, 10800, 429},
  {1224982800, 7200, 429},
  {1238288400, 10800, 429},
  {1256432400, 7200, 429},
  {1269738000, 10800, 429},
  {1288486800, 7200, 429},
  {1301274000, 10800, 429},
  {1319936400, 7200, 429},
  {1332637200, 10800, 429},
  {1351386000, 7200, 429},
  {1364691600, 10800, 429},
  {1382835600, 7200, 429},
  {1396141200, 10800, 429},
  {1414285200, 7200, 429},
  {1427590800, 10800, 429},
  {1445734800, 7200, 429},
  {1459040400, 10800, 429},
  {1477789200, 7200, 429},
  {1490490000, 10800, 429},
  {1509238800, 7200, 429},
  {1521939600, 10800, 429},
  {1540688400, 7200, 429},
  {1553994000, 10800, 429},
  {1572138000, 7200, 429},
  {1585443600, 10800, 429},
  {1603587600, 7200, 429},
  {1616893200, 10800, 429},
  {1635642000, 7200, 429},
  {1648342800, 10800, 429},
  {1667091600, 7200, 429},
  {1679792400, 10800, 429},
  {1698541200, 7200, 429},
  {1711846800, 10800, 429},
  {1729990800, 7200, 429},
  {1743296400, 10800, 429},
  {1761440400, 7200, 429},
  {1774746000, 10800, 429},
  {1792890000, 7200, 429},
  {1806195600, 10800, 429},
  {1824944400, 7200, 429},
  {1837645200, 10800, 429},
  {1856394000, 7200, 429},
  {1869094800, 10800, 429},
  {1887843600, 7200, 429},
  {1901149200, 10800, 429},
  {1919293200, 7200, 429},
  {1932598800, 10800, 429},
  {1950742800, 7200, 429},
  {1964048400, 10800, 429},
  {1982797200, 7200, 429},
  {1995498000, 10800, 429},
  {2014246800, 7200, 429},
  {2026947600, 10800, 429},
  {2045696400, 7200, 429},
  {2058397200, 10800, 429},
  {2077146000, 7200, 429},
  {2090451600, 10800, 429},
  {2108595600, 7200, 429},
  {2121901200, 10800, 429},
  {2140045200, 7200, 429},
  {-1691964000, 3600, 430},
  {-1680472800, 0, 430},
  {-1664143200, 3600, 430},
  {-1650146400, 0, 430},
  {-1633903200, 3600, 430},
  {-1617487200, 0, 430},
  {-1601848800, 3600, 430},
  {-1586037600, 0, 430},
  {-1570399200, 3600, 430},
  {-1552168800, 0, 430},
  {-1538344800, 3600, 430},
  {-1522533600, 0, 430},
  {-1507500000, 3600, 430},
  {-1490565600, 0, 430},
  {-1473631200, 3600, 430},
  {-1460930400, 0, 430},
  {-1442786400, 3600, 430},
  {-1428876000, 0, 430},
  {-1410732000, 3600, 430},
  {-1396216800, 0, 430},
  {-1379282400, 3600, 430},
  {-1364767200, 0, 430},
  {-1348437600, 3600, 430},
  {-1333317600, 0, 430},
  {-1315778400, 3600, 430},
  {-1301263200, 0, 430},
  {-1284328800, 3600, 430},
  {-1269813600, 0, 430},
  {-1253484000, 3600, 430},
  {-1238364000, 0, 430},
  {-1221429600, 3600, 430},
  {-1206914400, 0, 430},
  {-1189980000, 3600, 430},
  {-1175464800, 0, 430},
  {-1159135200, 3600, 430},
  {-1143410400, 0, 430},
  {-1126476000, 3600, 430},
  {-1111960800, 0, 430},
  {-1095631200, 3600, 430},
  {-1080511200, 0, 430},
  {-1063576800, 3600, 430},
  {-1049061600, 0, 430},
  {-1032127200, 3600, 430},
  {-1017612000, 0, 430},
  {-1001282400, 3600, 430},
  {-986162400, 0, 430},
  {-969228000, 3600, 430},
  {-950479200, 0, 430},
  {-942012000, 3600, 430},
  {-904518000, 7200, 430},
  {-896050800, 3600, 430},
  {-875487600, 7200, 430},
  {-864601200, 3600, 430},
  {-844038000, 7200, 430},
  {-832546800, 3600, 430},
  {-812588400, 7200, 430},
  {-798073200, 3600, 430},
  {-781052400, 7200, 430},
  {-772066800, 3600, 430},
  {-764805600, 0, 430},
  {-748476000, 3600, 430},
  {-733356000, 0, 430},
  {-719445600, 3600, 430},
  {-717030000, 7200, 430},
  {-706748400, 3600, 430},
  {-699487200, 0, 430},
  {-687996000, 3600, 430},
  {-668037600, 0, 430},
  {-654732000, 3600, 430},
  {-636588000, 0, 430},
  {-622072800, 3600, 430},
  {-605743200, 0, 430},
  {-590623200, 3600, 430},
  {-574293600, 0, 430},
  {-558568800, 3600, 430},
  {-542239200, 0, 430},
  {-527119200, 3600, 430},
  {-512604000, 0, 430},
  {-496274400, 3600, 430},
  {-481154400, 0, 430},
  {-464220000, 3600, 430},
  {-449704800, 0, 430},
  {-432165600, 3600, 430},
  {-417650400, 0, 430},
  {-401320800, 3600, 430},
  {-386200800, 0, 430},
  {-369266400, 3600, 430},
  {-354751200, 0, 430},
  {-337816800, 3600, 430},
  {-323301600, 0, 430},
  {-306972000, 3600, 430},
  {-291852000, 0, 430},
  {-276732000, 3600, 430},
  {-257983200, 0, 430},
  {-245282400, 3600, 430},
  {-226533600, 0, 430},
  {-213228000, 3600, 430},
  {-195084000, 0, 430},
  {-182383200, 3600, 430},
  {-163634400, 0, 430},
  {-150933600, 3600, 430},
  {-132184800, 0, 430},
  {-119484000, 3600, 430},
  {-100735200, 0, 430},
  {-88034400, 3600, 430},
  {-68680800, 0, 430},
  {-59004000, 3600, 430},
  {-37242000, 3600, 430},
  {57722400, 0, 430},
  {69818400, 3600, 430},
  {89172000, 0, 430},
  {101268000, 3600, 430},
  {120621600, 0, 430},
  {132717600, 3600, 430},
  {152071200, 0, 430},
  {164167200, 3600, 430},
  {183520800, 0, 430},
  {196221600, 3600, 430},
  {214970400, 0, 430},
  {227671200, 3600, 430},
  {246420000, 0, 430},
  {259120800, 3600, 430},
  {278474400, 0, 430},
  {290570400, 3600, 430},
  {309924000, 0, 430},
  {322020000, 3600, 430},
  {341373600, 0, 430},
  {354675600, 3600, 430},
  {372819600, 0, 430},
  {386125200, 3600, 430},
  {404269200, 0, 430},
  {417574800, 3600, 430},
  {435718800, 0, 430},
  {449024400, 3600, 430},
  {467773200, 0, 430},
  {481078800, 3600, 430},
  {499222800, 0, 430},
  {512528400, 3600, 430},
  {530672400, 0, 430},
  {543978000, 3600, 430},
  {562122000, 0, 430},
  {575427600, 3600, 430},
  {593571600, 0, 430},
  {606877200, 3600, 430},
  {625626000, 0, 430},
  {638326800, 3600, 430},
  {657075600, 0, 430},
  {670381200, 3600, 430},
  {688525200, 0, 430},
  {701830800, 3600, 430},
  {719974800, 0, 430},
  {733280400, 3600, 430},
  {751424400, 0, 430},
  {764730000, 3600, 430},
  {782874000, 0, 430},
  {796179600, 3600, 430},
  {814323600, 0, 430},
  {820454400, 0, 430},
  {828234000, 3600, 430},
  {846378000, 0, 430},
  {859683600, 3600, 430},
  {877827600, 0, 430},
  {891133200, 3600, 430},
  {909277200, 0, 430},
  {922582800, 3600, 430},
  {941331600, 0, 430},
  {954032400, 3600, 430},
  {972781200, 0, 430},
  {985482000, 3600, 430},
  {1004230800, 0, 430},
  {1017536400, 3600, 430},
  {1035680400, 0, 430},
  {1048986000, 3600, 430},
  {1067130000, 0, 430},
  {1080435600, 3600, 430},
  {1099184400, 0, 430},
  {1111885200, 3600, 430},
  {1130634000, 0, 430},
  {1143334800, 3600, 430},
  {1162083600, 0, 430},
  {1174784400, 3600, 430},
  {1193533200, 0, 430},
  {1206838800, 3600, 430},
  {1224982800, 0, 430},
  {1238288400, 3600, 430},
  {1256432400, 0, 430},
  {1269738000, 3600, 430},
  {1288486800, 0, 430},
  {1301187600, 3600, 430},
  {1319936400, 0, 430},
  {1332637200, 3600, 430},
  {1351386000, 0, 430},
  {1364691600, 3600, 430},
  {1382835600, 0, 430},
  {1396141200, 3600, 430},
  {1414285200, 0, 430},
  {1427590800, 3600, 430},
  {1445734800, 0, 430},
  {1459040400, 3600, 430},
  {1477789200, 0, 430},
  {1490490000, 3600, 430},
  {1509238800, 0, 430},
  {1521939600, 3600, 430},
  {1540688400, 0, 430},
  {1553994000, 3600, 430},
  {1572138000, 0, 430},
  {1585443600, 3600, 430},
  {1603587600, 0, 430},
  {1616893200, 3600, 430},
  {1635642000, 0, 430},
  {1648342800, 3600, 430},
  {1667091600, 0, 430},
  {1679792400, 3600, 430},
  {1698541200, 0, 430},
  {1711846800, 3600, 430},
  {1729990800, 0, 430},
  {1743296400, 3600, 430},
  {1761440400, 0, 430},
  {1774746000, 3600, 430},
  {1792890000, 0, 430},
  {1806195600, 3600, 430},
  {1824944400, 0, 430},
  {1837645200, 3600, 430},
  {1856394000, 0, 430},
  {1869094800, 3600, 430},
  {1887843600, 0, 430},
  {1901149200, 3600, 430},
  {1919293200, 0, 430},
  {1932598800, 3600, 430},
  {1950742800, 0, 430},
  {1964048400, 3600, 430},
  {1982797200, 0, 430},
  {1995498000, 3600, 430},
  {2014246800, 0, 430},
  {2026947600, 3600, 430},
  {2045696400, 0, 430},
  {2058397200, 3600, 430},
  {2077146000, 0, 430},
  {2090451600, 3600, 430},
  {2108595600, 0, 430},
  {2121901200, 3600, 430},
  {2140045200, 0, 430},
  {-1693706400, 7200, 431},
  {-1680483600, 3600, 431},
  {-1663455600, 7200, 431},
  {-1650150000, 3600, 431},
  {-1632006000, 7200, 431},
  {-1618700400, 3600, 431},
  {-938905200, 7200, 431},
  {-857257200, 3600, 431},
  {-844556400, 7200, 431},
  {-828226800, 3600, 431},
  {-812502000, 7200, 431},
  {-796777200, 3600, 431},
  {-788922000, 7200, 431},
  {-778730400, 10800, 431},
  {-762663600, 7200, 431},
  {-757389600, 10800, 431},
  {354920400, 14400, 431},
  {370728000, 10800, 431},
  {386456400, 14400, 431},
  {402264000, 10800, 431},
  {417992400, 14400, 431},
  {433800000, 10800, 431},
  {449614800, 14400, 431},
  {465346800, 10800, 431},
  {481071600, 14400, 431},
  {496796400, 10800, 431},
  {512521200, 14400, 431},
  {528246000, 10800, 431},
  {543970800, 14400, 431},
  {559695600, 10800, 431},
  {575420400, 14400, 431},
  {591145200, 10800, 431},
  {606870000, 14400, 431},
  {622594800, 10800, 431},
  {638319600, 14400, 431},
  {654649200, 10800, 431},
  {670374000, 10800, 431},
  {686102400, 7200, 431},
  {701816400, 10800, 431},
  {717537600, 7200, 431},
  {733276800, 10800, 431},
  {749001600, 7200, 431},
  {764726400, 10800, 431},
  {780451200, 7200, 431},
  {796176000, 10800, 431},
  {811900800, 7200, 431},
  {828230400, 10800, 431},
  {846374400, 7200, 431},
  {859680000, 10800, 431},
  {877824000, 7200, 431},
  {891129600, 10800, 431},
  {909273600, 7200, 431},
  {922579200, 10800, 431},
  {941328000, 7200, 431},
  {954028800, 10800, 431},
  {972777600, 7200, 431},
  {985478400, 10800, 431},
  {1004227200, 7200, 431},
  {1017532800, 10800, 431},
  {1035676800, 7200, 431},
  {1048982400, 10800, 431},
  {1067126400, 7200, 431},
  {1080432000, 10800, 431},
  {1099180800, 7200, 431},
  {1111881600, 10800, 431},
  {1130630400, 7200, 431},
  {1143331200, 10800, 431},
  {1162080000, 7200, 431},
  {1174780800, 10800, 431},
  {1193529600, 7200, 431},
  {1206835200, 10800, 431},
  {1224979200, 7200, 431},
  {1238284800, 10800, 431},
  {1256428800, 7200, 431},
  {1269734400, 10800, 431},
  {1288483200, 7200, 431},
  {1301184000, 10800, 431},
  {INT64_MIN, 7324, 432},
  {-1441159324, 7200, 432},
  {-1247536800, 10800, 432},
  {-892522800, 7200, 432},
  {-857257200, 3600, 432},
  {-844556400, 7200, 432},
  {-828226800, 3600, 432},
  {-825382800, 10800, 432},
  {354920400, 14400, 432},
  {370728000, 10800, 432},
  {386456400, 14400, 432},
  {402264000, 10800, 432},
  {417992400, 14400, 432},
  {433800000, 10800, 432},
  {449614800, 14400, 432},
  {465346800, 10800, 432},
  {481071600, 14400, 432},
  {496796400, 10800, 432},
  {512521200, 14400, 432},
  {528246000, 10800, 432},
  {543970800, 14400, 432},
  {559695600, 10800, 432},
  {575420400, 14400, 432},
  {591145200, 10800, 432},
  {606870000, 14400, 432},
  {622594800, 10800, 432},
  {631141200, 10800, 432},
  {646786800, 7200, 432},
  {701820000, 10800, 432},
  {717541200, 7200, 432},
  {733269600, 10800, 432},
  {748990800, 7200, 432},
  {764719200, 10800, 432},
  {780440400, 7200, 432},
  {796179600, 10800, 432},
  {811904400, 7200, 432},
  {828234000, 10800, 432},
  {846378000, 7200, 432},
  {859683600, 10800, 432},
  {877827600, 7200, 432},
  {891133200, 10800, 432},
  {909277200, 7200, 432},
  {922582800, 10800, 432},
  {941331600, 7200, 432},
  {954032400, 10800, 432},
  {972781200, 7200, 432},
  {985482000, 10800, 432},
  {1004230800, 7200, 432},
  {1017536400, 10800, 432},
  {1035680400, 7200, 432},
  {1048986000, 10800, 432},
  {1067130000, 7200, 432},
  {1080435600, 10800, 432},
  {1099184400, 7200, 432},
  {1111885200, 10800, 432},
  {1130634000, 7200, 432},
  {1143334800, 10800, 432},
  {1162083600, 7200, 432},
  {1174784400, 10800, 432},
  {1193533200, 7200, 432},
  {1206838800, 10800, 432},
  {1224982800, 7200, 432},
  {1238288400, 10800, 432},
  {1256432400, 7200, 432},
  {1269738000, 10800, 432},
  {1288486800, 7200, 432},
  {1301187600, 10800, 432},
  {1319936400, 7200, 432},
  {1332637200, 10800, 432},
  {1351386000, 7200, 432},
  {1364691600, 10800, 432},
  {1382835600, 7200, 432},
  {1396141200, 10800, 432},
  {1414285200, 7200, 432},
  {1427590800, 10800, 432},
  {1445734800, 7200, 432},
  {1459040400, 10800, 432},
  {1477789200, 7200, 432},
  {1490490000, 10800, 432},
  {1509238800, 7200, 432},
  {1521939600, 10800, 432},
  {1540688400, 7200, 432},
  {1553994000, 10800, 432},
  {1572138000, 7200, 432},
  {1585443600, 10800, 432},
  {1603587600, 7200, 432},
  {1616893200, 10800, 432},
  {1635642000, 7200, 432},
  {1648342800, 10800, 432},
  {1667091600, 7200, 432},
  {1679792400, 10800, 432},
  {1698541200, 7200, 432},
  {1711846800, 10800, 432},
  {1729990800, 7200, 432},
  {1743296400, 10800, 432},
  {1761440400, 7200, 432},
  {1774746000, 10800, 432},
  {1792890000, 7200, 432},
  {1806195600, 10800, 432},
  {1824944400, 7200, 432},
  {1837645200, 10800, 432},
  {1856394000, 7200, 432},
  {1869094800, 10800, 432},
  {1887843600, 7200, 432},
  {1901149200, 10800, 432},
  {1919293200, 7200, 432},
  {1932598800, 10800, 432},
  {1950742800, 7200, 432},
  {1964048400, 10800, 432},
  {1982797200, 7200, 432},
  {1995498000, 10800, 432},
  {2014246800, 7200, 432},
  {2026947600, 10800, 432},
  {2045696400, 7200, 432},
  {2058397200, 10800, 432},
  {2077146000, 7200, 432},
  {2090451600, 10800, 432},
  {2108595600, 7200, 432},
  {2121901200, 10800, 432},
  {2140045200, 7200, 432},
  {INT64_MIN, -2192, 433},
  {-1830381808, 0, 433},
  {-1689555600, 3600, 433},
  {-1677801600, 0, 433},
  {-1667437200, 3600, 433},
  {-1647738000, 0, 433},
  {-1635814800, 3600, 433},
  {-1616202000, 0, 433},
  {-1604365200, 3600, 433},
  {-1584666000, 0, 433},
  {-1572742800, 3600, 433},
  {-1553043600, 0, 433},
  {-1541206800, 3600, 433},
  {-1521507600, 0, 433},
  {-1442451600, 3600, 433},
  {-1426813200, 0, 433},
  {-1379293200, 3600, 433},
  {-1364778000, 0, 433},
  {-1348448400, 3600, 433},
  {-1333328400, 0, 433},
  {-1316394000, 3600, 433},
  {-1301274000, 0, 433},
  {-1284339600, 3600, 433},
  {-1269824400, 0, 433},
  {-1221440400, 3600, 433},
  {-1206925200, 0, 433},
  {-1191200400, 3600, 433},
  {-1175475600, 0, 433},
  {-1127696400, 3600, 433},
  {-1111971600, 0, 433},
  {-1096851600, 3600, 433},
  {-1080522000, 0, 433},
  {-1063587600, 3600, 433},
  {-1049072400, 0, 433},
  {-1033347600, 3600, 433},
  {-1017622800, 0, 433},
  {-1002502800, 3600, 433},
  {-986173200, 0, 433},
  {-969238800, 3600, 433},
  {-950490000, 0, 433},
  {-942022800, 3600, 433},
  {-922669200, 0, 433},
  {-906944400, 3600, 433},
  {-891133200, 0, 433},
  {-877309200, 3600, 433},
  {-873684000, 7200, 433},
  {-864007200, 3600, 433},
  {-857955600, 0, 433},
  {-845859600, 3600, 433},
  {-842839200, 7200, 433},
  {-831348000, 3600, 433},
  {-825901200, 0, 433},
  {-814410000, 3600, 433},
  {-810784800, 7200, 433},
  {-799898400, 3600, 433},
  {-794451600, 0, 433},
  {-782960400, 3600, 433},
  {-779335200, 7200, 433},
  {-768448800, 3600, 433},
  {-763002000, 0, 433},
  {-749091600, 3600, 433},
  {-733366800, 0, 433},
  {-717631200, 3600, 433},
  {-701906400, 0, 433},
  {-686181600, 3600, 433},
  {-670456800, 0, 433},
  {-654732000, 3600, 433},
  {-639007200, 0, 433},
  {-591832800, 3600, 433},
  {-575503200, 0, 433},
  {-559778400, 3600, 433},
  {-544053600, 0, 433},
  {-528328800, 3600, 433},
  {-512604000, 0, 433},
  {-496879200, 3600, 433},
  {-481154400, 0, 433},
  {-465429600, 3600, 433},
  {-449704800, 0, 433},
  {-433980000, 3600, 433},
  {-417650400, 0, 433},
  {-401925600, 3600, 433},
  {-386200800, 0, 433},
  {-370476000, 3600, 433},
  {-354751200, 0, 433},
  {-339026400, 3600, 433},
  {-323301600, 0, 433},
  {-307576800, 3600, 433},
  {-291852000, 0, 433},
  {-276127200, 3600, 433},
  {-260402400, 0, 433},
  {-244677600, 3600, 433},
  {-228348000, 0, 433},
  {-212623200, 3600, 433},
  {-196898400, 0, 433},
  {-181173600, 3600, 433},
  {-165448800, 0, 433},
  {-149724000, 3600, 433},
  {-133999200, 0, 433},
  {-118274400, 3600, 433},
  {212544000, 0, 433},
  {228268800, 3600, 433},
  {243993600, 0, 433},
  {260323200, 3600, 433},
  {276048000, 0, 433},
  {291772800, 3600, 433},
  {307501200, 0, 433},
  {323222400, 3600, 433},
  {338950800, 0, 433},
  {354675600, 3600, 433},
  {370400400, 0, 433},
  {386125200, 3600, 433},
  {401850000, 0, 433},
  {417578400, 3600, 433},
  {433299600, 0, 433},
  {449024400, 3600, 433},
  {465354000, 0, 433},
  {481078800, 3600, 433},
  {496803600, 0, 433},
  {512528400, 3600, 433},
  {528253200, 0, 433},
  {543978000, 3600, 433},
  {559702800, 0, 433},
  {575427600, 3600, 433},
  {591152400, 0, 433},
  {606877200, 3600, 433},
  {622602000, 0, 433},
  {638326800, 3600, 433},
  {654656400, 0, 433},
  {670381200, 3600, 433},
  {686106000, 0, 433},
  {701830800, 3600, 433},
  {717555600, 3600, 433},
  {733280400, 7200, 433},
  {749005200, 3600, 433},
  {764730000, 7200, 433},
  {780454800, 3600, 433},
  {796179600, 7200, 433},
  {811904400, 3600, 433},
  {828234000, 3600, 433},
  {846378000, 0, 433},
  {859683600, 3600, 433},
  {877827600, 0, 433},
  {891133200, 3600, 433},
  {909277200, 0, 433},
  {922582800, 3600, 433},
  {941331600, 0, 433},
  {954032400, 3600, 433},
  {972781200, 0, 433},
  {985482000, 3600, 433},
  {1004230800, 0, 433},
  {1017536400, 3600, 433},
  {1035680400, 0, 433},
  {1048986000, 3600, 433},
  {1067130000, 0, 433},
  {1080435600, 3600, 433},
  {1099184400, 0, 433},
  {1111885200, 3600, 433},
  {1130634000, 0, 433},
  {1143334800, 3600, 433},
  {1162083600, 0, 433},
  {1174784400, 3600, 433},
  {1193533200, 0, 433},
  {1206838800, 3600, 433},
  {1224982800, 0, 433},
  {1238288400, 3600, 433},
  {1256432400, 0, 433},
  {1269738000, 3600, 433},
  {1288486800, 0, 433},
  {1301187600, 3600, 433},
  {1319936400, 0, 433},
  {1332637200, 3600, 433},
  {1351386000, 0, 433},
  {1364691600, 3600, 433},
  {1382835600, 0, 433},
  {1396141200, 3600, 433},
  {1414285200, 0, 433},
  {1427590800, 3600, 433},
  {1445734800, 0, 433},
  {1459040400, 3600, 433},
  {1477789200, 0, 433},
  {1490490000, 3600, 433},
  {1509238800, 0, 433},
  {1521939600, 3600, 433},
  {1540688400, 0, 433},
  {1553994000, 3600, 433},
  {1572138000, 0, 433},
  {1585443600, 3600, 433},
  {1603587600, 0, 433},
  {1616893200, 3600, 433},
  {1635642000, 0, 433},
  {1648342800, 3600, 433},
  {1667091600, 0, 433},
  {1679792400, 3600, 433},
  {1698541200, 0, 433},
  {1711846800, 3600, 433},
  {1729990800, 0, 433},
  {1743296400, 3600, 433},
  {1761440400, 0, 433},
  {1774746000, 3600, 433},
  {1792890000, 0, 433},
  {1806195600, 3600, 433},
  {1824944400, 0, 433},
  {1837645200, 3600, 433},
  {1856394000, 0, 433},
  {1869094800, 3600, 433},
  {1887843600, 0, 433},
  {1901149200, 3600, 433},
  {1919293200, 0, 433},
  {1932598800, 3600, 433},
  {1950742800, 0, 433},
  {1964048400, 3600, 433},
  {1982797200, 0, 433},
  {1995498000, 3600, 433},
  {2014246800, 0, 433},
  {2026947600, 3600, 433},
  {2045696400, 0, 433},
  {2058397200, 3600, 433},
  {2077146000, 0, 433},
  {2090451600, 3600, 433},
  {2108595600, 0, 433},
  {2121901200, 3600, 433},
  {2140045200, 0, 433},
  {-905824800, 7200, 434},
  {-857257200, 3600, 434},
  {-844556400, 7200, 434},
  {-828226800, 3600, 434},
  {-812502000, 7200, 434},
  {-796777200, 3600, 434},
  {-788922000, 3600, 434},
  {-777942000, 7200, 434},
  {-766623600, 3600, 434},
  {407199600, 3600, 434},
  {417574800, 7200, 434},
  {433299600, 3600, 434},
  {449024400, 7200, 434},
  {465354000, 3600, 434},
  {481078800, 7200, 434},
  {496803600, 3600, 434},
  {512528400, 7200, 434},
  {528253200, 3600, 434},
  {543978000, 7200, 434},
  {559702800, 3600, 434},
  {575427600, 7200, 434},
  {591152400, 3600, 434},
  {606877200, 7200, 434},
  {622602000, 3600, 434},
  {638326800, 7200, 434},
  {654656400, 3600, 434},
  {670381200, 7200, 434},
  {686106000, 3600, 434},
  {701830800, 7200, 434},
  {717555600, 3600, 434},
  {733280400, 7200, 434},
  {749005200, 3600, 434},
  {764730000, 7200, 434},
  {780454800, 3600, 434},
  {796179600, 7200, 434},
  {811904400, 3600, 434},
  {828234000, 7200, 434},
  {846378000, 3600, 434},
  {859683600, 7200, 434},
  {877827600, 3600, 434},
  {891133200, 7200, 434},
  {909277200, 3600, 434},
  {922582800, 7200, 434},
  {941331600, 3600, 434},
  {954032400, 7200, 434},
  {972781200, 3600, 434},
  {985482000, 7200, 434},
  {1004230800, 3600, 434},
  {1017536400, 7200, 434},
  {1035680400, 3600, 434},
  {1048986000, 7200, 434},
  {1067130000, 3600, 434},
  {1080435600, 7200, 434},
  {1099184400, 3600, 434},
  {1111885200, 7200, 434},
  {1130634000, 3600, 434},
  {1143334800, 7200, 434},
  {1162083600, 3600, 434},
  {1174784400, 7200, 434},
  {1193533200, 3600, 434},
  {1206838800, 7200, 434},
  {1224982800, 3600, 434},
  {1238288400, 7200, 434},
  {1256432400, 3600, 434},
  {1269738000, 7200, 434},
  {1288486800, 3600, 434},
  {1301187600, 7200, 434},
  {1319936400, 3600, 434},
  {1332637200, 7200, 434},
  {1351386000, 3600, 434},
  {1364691600, 7200, 434},
  {1382835600, 3600, 434},
  {1396141200, 7200, 434},
  {1414285200, 3600, 434},
  {1427590800, 7200, 434},
  {1445734800, 3600, 434},
  {1459040400, 7200, 434},
  {1477789200, 3600, 434},
  {1490490000, 7200, 434},
  {1509238800, 3600, 434},
  {1521939600, 7200, 434},
  {1540688400, 3600, 434},
  {1553994000, 7200, 434},
  {1572138000, 3600, 434},
  {1585443600, 7200, 434},
  {1603587600, 3600, 434},
  {1616893200, 7200, 434},
  {1635642000, 3600, 434},
  {1648342800, 7200, 434},
  {1667091600, 3600, 434},
  {1679792400, 7200, 434},
  {1698541200, 3600, 434},
  {1711846800, 7200, 434},
  {1729990800, 3600, 434},
  {1743296400, 7200, 434},
  {1761440400, 3600, 434},
  {1774746000, 7200, 434},
  {1792890000, 3600, 434},
  {1806195600, 7200, 434},
  {1824944400, 3600, 434},
  {1837645200, 7200, 434},
  {1856394000, 3600, 434},
  {1869094800, 7200, 434},
  {1887843600, 3600, 434},
  {1901149200, 7200, 434},
  {1919293200, 3600, 434},
  {1932598800, 7200, 434},
  {1950742800, 3600, 434},
  {1964048400, 7200, 434},
  {1982797200, 3600, 434},
  {1995498000, 7200, 434},
  {2014246800, 3600, 434},
  {2026947600, 7200, 434},
  {2045696400, 3600, 434},
  {2058397200, 7200, 434},
  {2077146000, 3600, 434},
  {2090451600, 7200, 434},
  {2108595600, 3600, 434},
  {2121901200, 7200, 434},
  {2140045200, 3600, 434},
  {-1691964000, 3600, 435},
  {-1680472800, 0, 435},
  {-1664143200, 3600, 435},
  {-1650146400, 0, 435},
  {-1633903200, 3600, 435},
  {-1617487200, 0, 435},
  {-1601848800, 3600, 435},
  {-1586037600, 0, 435},
  {-1570399200, 3600, 435},
  {-1552168800, 0, 435},
  {-1538344800, 3600, 435},
  {-1522533600, 0, 435},
  {-1507500000, 3600, 435},
  {-1490565600, 0, 435},
  {-1473631200, 3600, 435},
  {-1460930400, 0, 435},
  {-1442786400, 3600, 435},
  {-1428876000, 0, 435},
  {-1410732000, 3600, 435},
  {-1396216800, 0, 435},
  {-1379282400, 3600, 435},
  {-1364767200, 0, 435},
  {-1348437600, 3600, 435},
  {-1333317600, 0, 435},
  {-1315778400, 3600, 435},
  {-1301263200, 0, 435},
  {-1284328800, 3600, 435},
  {-1269813600, 0, 435},
  {-1253484000, 3600, 435},
  {-1238364000, 0, 435},
  {-1221429600, 3600, 435},
  {-1206914400, 0, 435},
  {-1189980000, 3600, 435},
  {-1175464800, 0, 435},
  {-1159135200, 3600, 435},
  {-1143410400, 0, 435},
  {-1126476000, 3600, 435},
  {-1111960800, 0, 435},
  {-1095631200, 3600, 435},
  {-1080511200, 0, 435},
  {-1063576800, 3600, 435},
  {-1049061600, 0, 435},
  {-1032127200, 3600, 435},
  {-1017612000, 0, 435},
  {-1001282400, 3600, 435},
  {-986162400, 0, 435},
  {-969228000, 3600, 435},
  {-950479200, 0, 435},
  {-942012000, 3600, 435},
  {-904518000, 7200, 435},
  {-896050800, 3600, 435},
  {-875487600, 7200, 435},
  {-864601200, 3600, 435},
  {-844038000, 7200, 435},
  {-832546800, 3600, 435},
  {-812588400, 7200, 435},
  {-798073200, 3600, 435},
  {-781052400, 7200, 435},
  {-772066800, 3600, 435},
  {-764805600, 0, 435},
  {-748476000, 3600, 435},
  {-733356000, 0, 435},
  {-719445600, 3600, 435},
  {-717030000, 7200, 435},
  {-706748400, 3600, 435},
  {-699487200, 0, 435},
  {-687996000, 3600, 435},
  {-668037600, 0, 435},
  {-654732000, 3600, 435},
  {-636588000, 0, 435},
  {-622072800, 3600, 435},
  {-605743200, 0, 435},
  {-590623200, 3600, 435},
  {-574293600, 0, 435},
  {-558568800, 3600, 435},
  {-542239200, 0, 435},
  {-527119200, 3600, 435},
  {-512604000, 0, 435},
  {-496274400, 3600, 435},
  {-481154400, 0, 435},
  {-464220000, 3600, 435},
  {-449704800, 0, 435},
  {-432165600, 3600, 435},
  {-417650400, 0, 435},
  {-401320800, 3600, 435},
  {-386200800, 0, 435},
  {-369266400, 3600, 435},
  {-354751200, 0, 435},
  {-337816800, 3600, 435},
  {-323301600, 0, 435},
  {-306972000, 3600, 435},
  {-291852000, 0, 435},
  {-276732000, 3600, 435},
  {-257983200, 0, 435},
  {-245282400, 3600, 435},
  {-226533600, 0, 435},
  {-213228000, 3600, 435},
  {-195084000, 0, 435},
  {-182383200, 3600, 435},
  {-163634400, 0, 435},
  {-150933600, 3600, 435},
  {-132184800, 0, 435},
  {-119484000, 3600, 435},
  {-100735200, 0, 435},
  {-88034400, 3600, 435},
  {-68680800, 0, 435},
  {-59004000, 3600, 435},
  {-37242000, 3600, 435},
  {57722400, 0, 435},
  {69818400, 3600, 435},
  {89172000, 0, 435},
  {101268000, 3600, 435},
  {120621600, 0, 435},
  {132717600, 3600, 435},
  {152071200, 0, 435},
  {164167200, 3600, 435},
  {183520800, 0, 435},
  {196221600, 3600, 435},
  {214970400, 0, 435},
  {227671200, 3600, 435},
  {246420000, 0, 435},
  {259120800, 3600, 435},
  {278474400, 0, 435},
  {290570400, 3600, 435},
  {309924000, 0, 435},
  {322020000, 3600, 435},
  {341373600, 0, 435},
  {354675600, 3600, 435},
  {372819600, 0, 435},
  {386125200, 3600, 435},
  {404269200, 0, 435},
  {417574800, 3600, 435},
  {435718800, 0, 435},
  {449024400, 3600, 435},
  {467773200, 0, 435},
  {481078800, 3600, 435},
  {499222800, 0, 435},
  {512528400, 3600, 435},
  {530672400, 0, 435},
  {543978000, 3600, 435},
  {562122000, 0, 435},
  {575427600, 3600, 435},
  {593571600, 0, 435},
  {606877200, 3600, 435},
  {625626000, 0, 435},
  {638326800, 3600, 435},
  {657075600, 0, 435},
  {670381200, 3600, 435},
  {688525200, 0, 435},
  {701830800, 3600, 435},
  {719974800, 0, 435},
  {733280400, 3600, 435},
  {751424400, 0, 435},
  {764730000, 3600, 435},
  {782874000, 0, 435},
  {796179600, 3600, 435},
  {814323600, 0, 435},
  {820454400, 0, 435},
  {828234000, 3600, 435},
  {846378000, 0, 435},
  {859683600, 3600, 435},
  {877827600, 0, 435},
  {891133200, 3600, 435},
  {909277200, 0, 435},
  {922582800, 3600, 435},
  {941331600, 0, 435},
  {954032400, 3600, 435},
  {972781200, 0, 435},
  {985482000, 3600, 435},
  {1004230800, 0, 435},
  {1017536400, 3600, 435},
  {1035680400, 0, 435},
  {1048986000, 3600, 435},
  {1067130000, 0, 435},
  {1080435600, 3600, 435},
  {1099184400, 0, 435},
  {1111885200, 3600, 435},
  {1130634000, 0, 435},
  {1143334800, 3600, 435},
  {1162083600, 0, 435},
  {1174784400, 3600, 435},
  {1193533200, 0, 435},
  {1206838800, 3600, 435},
  {1224982800, 0, 435},
  {1238288400, 3600, 435},
  {1256432400, 0, 435},
  {1269738000, 3600, 435},
  {1288486800, 0, 435},
  {1301187600, 3600, 435},
  {1319936400, 0, 435},
  {1332637200, 3600, 435},
  {1351386000, 0, 435},
  {1364691600, 3600, 435},
  {1382835600, 0, 435},
  {1396141200, 3600, 435},
  {1414285200, 0, 435},
  {1427590800, 3600, 435},
  {1445734800, 0, 435},
  {1459040400, 3600, 435},
  {1477789200, 0, 435},
  {1490490000, 3600, 435},
  {1509238800, 0, 435},
  {1521939600, 3600, 435},
  {1540688400, 0, 435},
  {1553994000, 3600, 435},
  {1572138000, 0, 435},
  {1585443600, 3600, 435},
  {1603587600, 0, 435},
  {1616893200, 3600, 435},
  {1635642000, 0, 435},
  {1648342800, 3600, 435},
  {1667091600, 0, 435},
  {1679792400, 3600, 435},
  {1698541200, 0, 435},
  {1711846800, 3600, 435},
  {1729990800, 0, 435},
  {1743296400, 3600, 435},
  {1761440400, 0, 435},
  {1774746000, 3600, 435},
  {1792890000, 0, 435},
  {1806195600, 3600, 435},
  {1824944400, 0, 435},
  {1837645200, 3600, 435},
  {1856394000, 0, 435},
  {1869094800, 3600, 435},
  {1887843600, 0, 435},
  {1901149200, 3600, 435},
  {1919293200, 0, 435},
  {1932598800, 3600, 435},
  {1950742800, 0, 435},
  {1964048400, 3600, 435},
  {1982797200, 0, 435},
  {1995498000, 3600, 435},
  {2014246800, 0, 435},
  {2026947600, 3600, 435},
  {2045696400, 0, 435},
  {2058397200, 3600, 435},
  {2077146000, 0, 435},
  {2090451600, 3600, 435},
  {2108595600, 0, 435},
  {2121901200, 3600, 435},
  {2140045200, 0, 435},
  {INT64_MIN, 1476, 436},
  {-2069713476, 3600, 436},
  {-1692496800, 7200, 436},
  {-1680483600, 3600, 436},
  {-1662343200, 7200, 436},
  {-1650157200, 3600, 436},
  {-1632006000, 7200, 436},
  {-1618700400, 3600, 436},
  {-1612659600, 0, 436},
  {-1604278800, 3600, 436},
  {-1585519200, 0, 436},
  {-1574038800, 3600, 436},
  {-1552258800, 0, 436},
  {-1539997200, 3600, 436},
  {-1520550000, 0, 436},
  {-1507510800, 3600, 436},
  {-1490572800, 0, 436},
  {-1473642000, 3600, 436},
  {-1459119600, 0, 436},
  {-1444006800, 3600, 436},
  {-1427673600, 0, 436},
  {-1411866000, 3600, 436},
  {-1396224000, 0, 436},
  {-1379293200, 3600, 436},
  {-1364774400, 0, 436},
  {-1348448400, 3600, 436},
  {-1333324800, 0, 436},
  {-1316394000, 3600, 436},
  {-1301270400, 0, 436},
  {-1284339600, 3600, 436},
  {-1269813600, 0, 436},
  {-1253484000, 3600, 436},
  {-1238364000, 0, 436},
  {-1221429600, 3600, 436},
  {-1206914400, 0, 436},
  {-1191189600, 3600, 436},
  {-1175464800, 0, 436},
  {-1160344800, 3600, 436},
  {-1143410400, 0, 436},
  {-1127685600, 3600, 436},
  {-1111960800, 0, 436},
  {-1096840800, 3600, 436},
  {-1080511200, 0, 436},
  {-1063576800, 3600, 436},
  {-1049061600, 0, 436},
  {-1033336800, 3600, 436},
  {-1017612000, 0, 436},
  {-1002492000, 3600, 436},
  {-986162400, 0, 436},
  {-969228000, 3600, 436},
  {-950479200, 0, 436},
  {-942012000, 3600, 436},
  {-935186400, 7200, 436},
  {-857257200, 3600, 436},
  {-844556400, 7200, 436},
  {-828226800, 3600, 436},
  {-812502000, 7200, 436},
  {-797986800, 3600, 436},
  {-781052400, 7200, 436},
  {-766623600, 3600, 436},
  {-745455600, 7200, 436},
  {-733273200, 3600, 436},
  {220921200, 3600, 436},
  {228877200, 7200, 436},
  {243997200, 3600, 436},
  {260326800, 7200, 436},
  {276051600, 3600, 436},
  {291776400, 7200, 436},
  {307501200, 3600, 436},
  {323830800, 7200, 436},
  {338950800, 3600, 436},
  {354675600, 7200, 436},
  {370400400, 3600, 436},
  {386125200, 7200, 436},
  {401850000, 3600, 436},
  {417574800, 7200, 436},
  {433299600, 3600, 436},
  {449024400, 7200, 436},
  {465354000, 3600, 436},
  {481078800, 7200, 436},
  {496803600, 3600, 436},
  {512528400, 7200, 436},
  {528253200, 3600, 436},
  {543978000, 7200, 436},
  {559702800, 3600, 436},
  {575427600, 7200, 436},
  {591152400, 3600, 436},
  {606877200, 7200, 436},
  {622602000, 3600, 436},
  {638326800, 7200, 436},
  {654656400, 3600, 436},
  {670381200, 7200, 436},
  {686106000, 3600, 436},
  {701830800, 7200, 436},
  {717555600, 3600, 436},
  {733280400, 7200, 436},
  {749005200, 3600, 436},
  {764730000, 7200, 436},
  {780454800, 3600, 436},
  {796179600, 7200, 436},
  {811904400, 3600, 436},
  {828234000, 7200, 436},
  {846378000, 3600, 436},
  {859683600, 7200, 436},
  {877827600, 3600, 436},
  {891133200, 7200, 436},
  {909277200, 3600, 436},
  {922582800, 7200, 436},
  {941331600, 3600, 436},
  {954032400, 7200, 436},
  {972781200, 3600, 436},
  {985482000, 7200, 436},
  {1004230800, 3600, 436},
  {1017536400, 7200, 436},
  {1035680400, 3600, 436},
  {1048986000, 7200, 436},
  {1067130000, 3600, 436},
  {1080435600, 7200, 436},
  {1099184400, 3600, 436},
  {1111885200, 7200, 436},
  {1130634000, 3600, 436},
  {1143334800, 7200, 436},
  {1162083600, 3600, 436},
  {1174784400, 7200, 436},
  {1193533200, 3600, 436},
  {1206838800, 7200, 436},
  {1224982800, 3600, 436},
  {1238288400, 7200, 436},
  {1256432400, 3600, 436},
  {1269738000, 7200, 436},
  {1288486800, 3600, 436},
  {1301187600, 7200, 436},
  {1319936400, 3600, 436},
  {1332637200, 7200, 436},
  {1351386000, 3600, 436},
  {1364691600, 7200, 436},
  {1382835600, 3600, 436},
  {1396141200, 7200, 436},
  {1414285200, 3600, 436},
  {1427590800, 7200, 436},
  {1445734800, 3600, 436},
  {1459040400, 7200, 436},
  {1477789200, 3600, 436},
  {1490490000, 7200, 436},
  {1509238800, 3600, 436},
  {1521939600, 7200, 436},
  {1540688400, 3600, 436},
  {1553994000, 7200, 436},
  {1572138000, 3600, 436},
  {1585443600, 7200, 436},
  {1603587600, 3600, 436},
  {1616893200, 7200, 436},
  {1635642000, 3600, 436},
  {1648342800, 7200, 436},
  {1667091600, 3600, 436},
  {1679792400, 7200, 436},
  {1698541200, 3600, 436},
  {1711846800, 7200, 436},
  {1729990800, 3600, 436},
  {1743296400, 7200, 436},
  {1761440400, 3600, 436},
  {1774746000, 7200, 436},
  {1792890000, 3600, 436},
  {1806195600, 7200, 436},
  {1824944400, 3600, 436},
  {1837645200, 7200, 436},
  {1856394000, 3600, 436},
  {1869094800, 7200, 436},
  {1887843600, 3600, 436},
  {1901149200, 7200, 436},
  {1919293200, 3600, 436},
  {1932598800, 7200, 436},
  {1950742800, 3600, 436},
  {1964048400, 7200, 436},
  {1982797200, 3600, 436},
  {1995498000, 7200, 436},
  {2014246800, 3600, 436},
  {2026947600, 7200, 436},
  {2045696400, 3600, 436},
  {2058397200, 7200, 436},
  {2077146000, 3600, 436},
  {2090451600, 7200, 436},
  {2108595600, 3600, 436},
  {2121901200, 7200, 436},
  {2140045200, 3600, 436},
  {-1661734800, 3600, 437},
  {-1648429200, 0, 437},
  {-1631926800, 3600, 437},
  {-1616893200, 0, 437},
  {-1601254800, 3600, 437},
  {-1585357200, 0, 437},
  {-1442451600, 3600, 437},
  {-1427677200, 0, 437},
  {-1379293200, 3600, 437},
  {-1364778000, 0, 437},
  {-1348448400, 3600, 437},
  {-1333328400, 0, 437},
  {-1316394000, 3600, 437},
  {-1301274000, 0, 437},
  {-1284339600, 3600, 437},
  {-1269824400, 0, 437},
  {-1029114000, 3600, 437},
  {-1017622800, 0, 437},
  {-1002848400, 3600, 437},
  {-986173200, 0, 437},
  {-969238800, 3600, 437},
  {-954118800, 0, 437},
  {-940208400, 3600, 437},
  {-873079200, 7200, 437},
  {-862538400, 3600, 437},
  {-842839200, 7200, 437},
  {-828237600, 3600, 437},
  {-811389600, 7200, 437},
  {-796010400, 3600, 437},
  {-779940000, 7200, 437},
  {-765421200, 3600, 437},
  {-748490400, 7200, 437},
  {-733888800, 3600, 437},
  {-652327200, 7200, 437},
  {-639190800, 3600, 437},
  {135122400, 7200, 437},
  {150246000, 3600, 437},
  {167176800, 7200, 437},
  {181695600, 3600, 437},
  {196812000, 7200, 437},
  {212540400, 3600, 437},
  {228866400, 7200, 437},
  {243990000, 3600, 437},
  {260402400, 7200, 437},
  {276044400, 3600, 437},
  {291776400, 7200, 437},
  {307501200, 3600, 437},
  {323830800, 7200, 437},
  {338950800, 3600, 437},
  {354675600, 7200, 437},
  {370400400, 3600, 437},
  {386125200, 7200, 437},
  {401850000, 3600, 437},
  {417574800, 7200, 437},
  {433299600, 3600, 437},
  {449024400, 7200, 437},
  {465354000, 3600, 437},
  {481078800, 7200, 437},
  {496803600, 3600, 437},
  {512528400, 7200, 437},
  {528253200, 3600, 437},
  {543978000, 7200, 437},
  {559702800, 3600, 437},
  {575427600, 7200, 437},
  {591152400, 3600, 437},
  {606877200, 7200, 437},
  {622602000, 3600, 437},
  {638326800, 7200, 437},
  {654656400, 3600, 437},
  {670381200, 7200, 437},
  {686106000, 3600, 437},
  {701830800, 7200, 437},
  {717555600, 3600, 437},
  {733280400, 7200, 437},
  {749005200, 3600, 437},
  {764730000, 7200, 437},
  {780454800, 3600, 437},
  {796179600, 7200, 437},
  {811904400, 3600, 437},
  {828234000, 7200, 437},
  {846378000, 3600, 437},
  {859683600, 7200, 437},
  {877827600, 3600, 437},
  {891133200, 7200, 437},
  {909277200, 3600, 437},
  {922582800, 7200, 437},
  {941331600, 3600, 437},
  {954032400, 7200, 437},
  {972781200, 3600, 437},
  {985482000, 7200, 437},
  {1004230800, 3600, 437},
  {1017536400, 7200, 437},
  {1035680400, 3600, 437},
  {1048986000, 7200, 437},
  {1067130000, 3600, 437},
  {1080435600, 7200, 437},
  {1099184400, 3600, 437},
  {1111885200, 7200, 437},
  {1130634000, 3600, 437},
  {1143334800, 7200, 437},
  {1162083600, 3600, 437},
  {1174784400, 7200, 437},
  {1193533200, 3600, 437},
  {1206838800, 7200, 437},
  {1224982800, 3600, 437},
  {1238288400, 7200, 437},
  {1256432400, 3600, 437},
  {1269738000, 7200, 437},
  {1288486800, 3600, 437},
  {1301187600, 7200, 437},
  {1319936400, 3600, 437},
  {1332637200, 7200, 437},
  {1351386000, 3600, 437},
  {1364691600, 7200, 437},
  {1382835600, 3600, 437},
  {1396141200, 7200, 437},
  {1414285200, 3600, 437},
  {1427590800, 7200, 437},
  {1445734800, 3600, 437},
  {1459040400, 7200, 437},
  {1477789200, 3600, 437},
  {1490490000, 7200, 437},
  {1509238800, 3600, 437},
  {1521939600, 7200, 437},
  {1540688400, 3600, 437},
  {1553994000, 7200, 437},
  {1572138000, 3600, 437},
  {1585443600, 7200, 437},
  {1603587600, 3600, 437},
  {1616893200, 7200, 437},
  {1635642000, 3600, 437},
  {1648342800, 7200, 437},
  {1667091600, 3600, 437},
  {1679792400, 7200, 437},
  {1698541200, 3600, 437},
  {1711846800, 7200, 437},
  {1729990800, 3600, 437},
  {1743296400, 7200, 437},
  {1761440400, 3600, 437},
  {1774746000, 7200, 437},
  {1792890000, 3600, 437},
  {1806195600, 7200, 437},
  {1824944400, 3600, 437},
  {1837645200, 7200, 437},
  {1856394000, 3600, 437},
  {1869094800, 7200, 437},
  {1887843600, 3600, 437},
  {1901149200, 7200, 437},
  {1919293200, 3600, 437},
  {1932598800, 7200, 437},
  {1950742800, 3600, 437},
  {1964048400, 7200, 437},
  {1982797200, 3600, 437},
  {1995498000, 7200, 437},
  {2014246800, 3600, 437},
  {2026947600, 7200, 437},
  {2045696400, 3600, 437},
  {2058397200, 7200, 437},
  {2077146000, 3600, 437},
  {2090451600, 7200, 437},
  {2108595600, 3600, 437},
  {2121901200, 7200, 437},
  {2140045200, 3600, 437},
  {-1690851600, 7200, 438},
  {-1680483600, 3600, 438},
  {-1664758800, 7200, 438},
  {-1649034000, 3600, 438},
  {-1635123600, 7200, 438},
  {-1616979600, 3600, 438},
  {-1604278800, 7200, 438},
  {-1585530000, 3600, 438},
  {-1571014800, 7200, 438},
  {-1555290000, 3600, 438},
  {-932432400, 7200, 438},
  {-857257200, 3600, 438},
  {-844556400, 7200, 438},
  {-828226800, 3600, 438},
  {-812502000, 7200, 438},
  {-796777200, 3600, 438},
  {-781052400, 7200, 438},
  {-766717200, 3600, 438},
  {-750898800, 7200, 438},
  {-733359600, 3600, 438},
  {-719456400, 7200, 438},
  {-701917200, 3600, 438},
  {-689209200, 7200, 438},
  {-670460400, 3600, 438},
  {-114051600, 7200, 438},
  {-103168800, 3600, 438},
  {-81997200, 7200, 438},
  {-71719200, 3600, 438},
  {-50547600, 7200, 438},
  {-40269600, 3600, 438},
  {-18493200, 7200, 438},
  {-8215200, 3600, 438},
  {12956400, 7200, 438},
  {23234400, 3600, 438},
  {43801200, 7200, 438},
  {54687600, 3600, 438},
  {75855600, 7200, 438},
  {86738400, 3600, 438},
  {102380400, 7200, 438},
  {118105200, 3600, 438},
  {135730800, 7200, 438},
  {148518000, 3600, 438},
  {167187600, 7200, 438},
  {180489600, 3600, 438},
  {198637200, 7200, 438},
  {211939200, 3600, 438},
  {230086800, 7200, 438},
  {243388800, 3600, 438},
  {261536400, 7200, 438},
  {274838400, 3600, 438},
  {292986000, 7200, 438},
  {306288000, 3600, 438},
  {323312400, 7200, 438},
  {338342400, 3600, 438},
  {354675600, 7200, 438},
  {370400400, 3600, 438},
  {386125200, 7200, 438},
  {401850000, 3600, 438},
  {417574800, 7200, 438},
  {433299600, 3600, 438},
  {449024400, 7200, 438},
  {465354000, 3600, 438},
  {481078800, 7200, 438},
  {496803600, 3600, 438},
  {512528400, 7200, 438},
  {528253200, 3600, 438},
  {543978000, 7200, 438},
  {559702800, 3600, 438},
  {575427600, 7200, 438},
  {591152400, 3600, 438},
  {606877200, 7200, 438},
  {622602000, 3600, 438},
  {638326800, 7200, 438},
  {654656400, 3600, 438},
  {670381200, 7200, 438},
  {686106000, 3600, 438},
  {701830800, 7200, 438},
  {717555600, 3600, 438},
  {733280400, 7200, 438},
  {749005200, 3600, 438},
  {764730000, 7200, 438},
  {780454800, 3600, 438},
  {796179600, 7200, 438},
  {811904400, 3600, 438},
  {828234000, 7200, 438},
  {846378000, 3600, 438},
  {859683600, 7200, 438},
  {877827600, 3600, 438},
  {891133200, 7200, 438},
  {909277200, 3600, 438},
  {922582800, 7200, 438},
  {941331600, 3600, 438},
  {954032400, 7200, 438},
  {972781200, 3600, 438},
  {985482000, 7200, 438},
  {1004230800, 3600, 438},
  {1017536400, 7200, 438},
  {1035680400, 3600, 438},
  {1048986000, 7200, 438},
  {1067130000, 3600, 438},
  {1080435600, 7200, 438},
  {1099184400, 3600, 438},
  {1111885200, 7200, 438},
  {1130634000, 3600, 438},
  {1143334800, 7200, 438},
  {1162083600, 3600, 438},
  {1174784400, 7200, 438},
  {1193533200, 3600, 438},
  {1206838800, 7200, 438},
  {1224982800, 3600, 438},
  {1238288400, 7200, 438},
  {1256432400, 3600, 438},
  {1269738000, 7200, 438},
  {1288486800, 3600, 438},
  {1301187600, 7200, 438},
  {1319936400, 3600, 438},
  {1332637200, 7200, 438},
  {1351386000, 3600, 438},
  {1364691600, 7200, 438},
  {1382835600, 3600, 438},
  {1396141200, 7200, 438},
  {1414285200, 3600, 438},
  {1427590800, 7200, 438},
  {1445734800, 3600, 438},
  {1459040400, 7200, 438},
  {1477789200, 3600, 438},
  {1490490000, 7200, 438},
  {1509238800, 3600, 438},
  {1521939600, 7200, 438},
  {1540688400, 3600, 438},
  {1553994000, 7200, 438},
  {1572138000, 3600, 438},
  {1585443600, 7200, 438},
  {1603587600, 3600, 438},
  {1616893200, 7200, 438},
  {1635642000, 3600, 438},
  {1648342800, 7200, 438},
  {1667091600, 3600, 438},
  {1679792400, 7200, 438},
  {1698541200, 3600, 438},
  {1711846800, 7200, 438},
  {1729990800, 3600, 438},
  {1743296400, 7200, 438},
  {1761440400, 3600, 438},
  {1774746000, 7200, 438},
  {1792890000, 3600, 438},
  {1806195600, 7200, 438},
  {1824944400, 3600, 438},
  {1837645200, 7200, 438},
  {1856394000, 3600, 438},
  {1869094800, 7200, 438},
  {1887843600, 3600, 438},
  {1901149200, 7200, 438},
  {1919293200, 3600, 438},
  {1932598800, 7200, 438},
  {1950742800, 3600, 438},
  {1964048400, 7200, 438},
  {1982797200, 3600, 438},
  {1995498000, 7200, 438},
  {2014246800, 3600, 438},
  {2026947600, 7200, 438},
  {2045696400, 3600, 438},
  {2058397200, 7200, 438},
  {2077146000, 3600, 438},
  {2090451600, 7200, 438},
  {2108595600, 3600, 438},
  {2121901200, 7200, 438},
  {2140045200, 3600, 438},
  {INT64_MIN, 5992, 439},
  {-1535938792, 7200, 439},
  {-875671200, 10800, 439},
  {-859863600, 7200, 439},
  {354672000, 10800, 439},
  {370396800, 7200, 439},
  {386121600, 10800, 439},
  {401846400, 7200, 439},
  {417574800, 10800, 439},
  {433299600, 7200, 439},
  {449024400, 10800, 439},
  {465354000, 7200, 439},
  {481078800, 10800, 439},
  {496803600, 7200, 439},
  {512528400, 10800, 439},
  {528253200, 7200, 439},
  {543978000, 10800, 439},
  {559702800, 7200, 439},
  {575427600, 10800, 439},
  {591152400, 7200, 439},
  {606877200, 10800, 439},
  {622602000, 7200, 439},
  {638326800, 10800, 439},
  {654656400, 7200, 439},
  {670381200, 10800, 439},
  {686106000, 7200, 439},
  {701830800, 10800, 439},
  {717555600, 7200, 439},
  {733280400, 10800, 439},
  {749005200, 7200, 439},
  {764730000, 10800, 439},
  {780454800, 7200, 439},
  {796179600, 10800, 439},
  {811904400, 7200, 439},
  {828234000, 10800, 439},
  {846378000, 7200, 439},
  {859683600, 10800, 439},
  {877827600, 7200, 439},
  {891133200, 10800, 439},
  {909277200, 7200, 439},
  {922582800, 10800, 439},
  {941331600, 7200, 439},
  {954032400, 10800, 439},
  {972781200, 7200, 439},
  {985482000, 10800, 439},
  {1004230800, 7200, 439},
  {1017536400, 10800, 439},
  {1035680400, 7200, 439},
  {1048986000, 10800, 439},
  {1067130000, 7200, 439},
  {1080435600, 10800, 439},
  {1099184400, 7200, 439},
  {1111885200, 10800, 439},
  {1130634000, 7200, 439},
  {1143334800, 10800, 439},
  {1162083600, 7200, 439},
  {1174784400, 10800, 439},
  {1193533200, 7200, 439},
  {1206838800, 10800, 439},
  {1224982800, 7200, 439},
  {1238288400, 10800, 439},
  {1256432400, 7200, 439},
  {1269738000, 10800, 439},
  {1288486800, 7200, 439},
  {1301187600, 10800, 439},
  {1319936400, 7200, 439},
  {1332637200, 10800, 439},
  {1351386000, 7200, 439},
  {1364691600, 10800, 439},
  {1382835600, 7200, 439},
  {1396141200, 10800, 439},
  {1414285200, 7200, 439},
  {1427590800, 10800, 439},
  {1445734800, 7200, 439},
  {1459040400, 10800, 439},
  {1477789200, 7200, 439},
  {1490490000, 10800, 439},
  {1509238800, 7200, 439},
  {1521939600, 10800, 439},
  {1540688400, 7200, 439},
  {1553994000, 10800, 439},
  {1572138000, 7200, 439},
  {1585443600, 10800, 439},
  {1603587600, 7200, 439},
  {1616893200, 10800, 439},
  {1635642000, 7200, 439},
  {1648342800, 10800, 439},
  {1667091600, 7200, 439},
  {1679792400, 10800, 439},
  {1698541200, 7200, 439},
  {1711846800, 10800, 439},
  {1729990800, 7200, 439},
  {1743296400, 10800, 439},
  {1761440400, 7200, 439},
  {1774746000, 10800, 439},
  {1792890000, 7200, 439},
  {1806195600, 10800, 439},
  {1824944400, 7200, 439},
  {1837645200, 10800, 439},
  {1856394000, 7200, 439},
  {1869094800, 10800, 439},
  {1887843600, 7200, 439},
  {1901149200, 10800, 439},
  {1919293200, 7200, 439},
  {1932598800, 10800, 439},
  {1950742800, 7200, 439},
  {1964048400, 10800, 439},
  {1982797200, 7200, 439},
  {1995498000, 10800, 439},
  {2014246800, 7200, 439},
  {2026947600, 10800, 439},
  {2045696400, 7200, 439},
  {2058397200, 10800, 439},
  {2077146000, 7200, 439},
  {2090451600, 10800, 439},
  {2108595600, 7200, 439},
  {2121901200, 10800, 439},
  {2140045200, 7200, 439},
  {INT64_MIN, 6600, 440},
  {-1441158600, 7200, 440},
  {-1247536800, 10800, 440},
  {-899780400, 7200, 440},
  {-857257200, 3600, 440},
  {-844556400, 7200, 440},
  {-828226800, 3600, 440},
  {-812502000, 7200, 440},
  {-804650400, 10800, 440},
  {354920400, 14400, 440},
  {370728000, 10800, 440},
  {386456400, 14400, 440},
  {402264000, 10800, 440},
  {417992400, 14400, 440},
  {433800000, 10800, 440},
  {449614800, 14400, 440},
  {465346800, 10800, 440},
  {481071600, 14400, 440},
  {496796400, 10800, 440},
  {512521200, 14400, 440},
  {528246000, 10800, 440},
  {543970800, 14400, 440},
  {559695600, 10800, 440},
  {575420400, 14400, 440},
  {591145200, 10800, 440},
  {606870000, 14400, 440},
  {622594800, 10800, 440},
  {631141200, 10800, 440},
  {670374000, 10800, 440},
  {686102400, 7200, 440},
  {701820000, 10800, 440},
  {717544800, 7200, 440},
  {733276800, 10800, 440},
  {749001600, 7200, 440},
  {764726400, 10800, 440},
  {780451200, 7200, 440},
  {796176000, 10800, 440},
  {811900800, 7200, 440},
  {828230400, 10800, 440},
  {846374400, 7200, 440},
  {859680000, 10800, 440},
  {877824000, 7200, 440},
  {891129600, 10800, 440},
  {909273600, 7200, 440},
  {922579200, 10800, 440},
  {941328000, 7200, 440},
  {954028800, 10800, 440},
  {972777600, 7200, 440},
  {985478400, 10800, 440},
  {1004227200, 7200, 440},
  {1017532800, 10800, 440},
  {1035676800, 7200, 440},
  {1048982400, 10800, 440},
  {1067126400, 7200, 440},
  {1080432000, 10800, 440},
  {1099180800, 7200, 440},
  {1111881600, 10800, 440},
  {1130630400, 7200, 440},
  {1143331200, 10800, 440},
  {1162080000, 7200, 440},
  {1174780800, 10800, 440},
  {1193529600, 7200, 440},
  {1206835200, 10800, 440},
  {1224979200, 7200, 440},
  {1238284800, 10800, 440},
  {1256428800, 7200, 440},
  {1269734400, 10800, 440},
  {1288483200, 7200, 440},
  {1301184000, 10800, 440},
  {INT64_MIN, 561, 441},
  {-1855958961, 0, 441},
  {-1689814800, 3600, 441},
  {-1680397200, 0, 441},
  {-1665363600, 3600, 441},
  {-1648342800, 0, 441},
  {-1635123600, 3600, 441},
  {-1616893200, 0, 441},
  {-1604278800, 3600, 441},
  {-1585443600, 0, 441},
  {-1574038800, 3600, 441},
  {-1552266000, 0, 441},
  {-1539997200, 3600, 441},
  {-1520557200, 0, 441},
  {-1507510800, 3600, 441},
  {-1490576400, 0, 441},
  {-1470618000, 3600, 441},
  {-1459126800, 0, 441},
  {-1444006800, 3600, 441},
  {-1427677200, 0, 441},
  {-1411952400, 3600, 441},
  {-1396227600, 0, 441},
  {-1379293200, 3600, 441},
  {-1364778000, 0, 441},
  {-1348448400, 3600, 441},
  {-1333328400, 0, 441},
  {-1316394000, 3600, 441},
  {-1301274000, 0, 441},
  {-1284339600, 3600, 441},
  {-1269824400, 0, 441},
  {-1253494800, 3600, 441},
  {-1238374800, 0, 441},
  {-1221440400, 3600, 441},
  {-1206925200, 0, 441},
  {-1191200400, 3600, 441},
  {-1175475600, 0, 441},
  {-1160355600, 3600, 441},
  {-1143421200, 0, 441},
  {-1127696400, 3600, 441},
  {-1111971600, 0, 441},
  {-1096851600, 3600, 441},
  {-1080522000, 0, 441},
  {-1063587600, 3600, 441},
  {-1049072400, 0, 441},
  {-1033347600, 3600, 441},
  {-1017622800, 0, 441},
  {-1002502800, 3600, 441},
  {-986173200, 0, 441},
  {-969238800, 3600, 441},
  {-950490000, 0, 441},
  {-942012000, 3600, 441},
  {-904438800, 7200, 441},
  {-891136800, 3600, 441},
  {-877827600, 7200, 441},
  {-857257200, 3600, 441},
  {-844556400, 7200, 441},
  {-828226800, 3600, 441},
  {-812502000, 7200, 441},
  {-796266000, 3600, 441},
  {-781052400, 7200, 441},
  {-766623600, 3600, 441},
  {196819200, 7200, 441},
  {212540400, 3600, 441},
  {228877200, 7200, 441},
  {243997200, 3600, 441},
  {260326800, 7200, 441},
  {276051600, 3600, 441},
  {291776400, 7200, 441},
  {307501200, 3600, 441},
  {323830800, 7200, 441},
  {338950800, 3600, 441},
  {354675600, 7200, 441},
  {370400400, 3600, 441},
  {386125200, 7200, 441},
  {401850000, 3600, 441},
  {417574800, 7200, 441},
  {433299600, 3600, 441},
  {449024400, 7200, 441},
  {465354000, 3600, 441},
  {481078800, 7200, 441},
  {496803600, 3600, 441},
  {512528400, 7200, 441},
  {528253200, 3600, 441},
  {543978000, 7200, 441},
  {559702800, 3600, 441},
  {575427600, 7200, 441},
  {591152400, 3600, 441},
  {606877200, 7200, 441},
  {622602000, 3600, 441},
  {638326800, 7200, 441},
  {654656400, 3600, 441},
  {670381200, 7200, 441},
  {686106000, 3600, 441},
  {701830800, 7200, 441},
  {717555600, 3600, 441},
  {733280400, 7200, 441},
  {749005200, 3600, 441},
  {764730000, 7200, 441},
  {780454800, 3600, 441},
  {796179600, 7200, 441},
  {811904400, 3600, 441},
  {828234000, 7200, 441},
  {846378000, 3600, 441},
  {859683600, 7200, 441},
  {877827600, 3600, 441},
  {891133200, 7200, 441},
  {909277200, 3600, 441},
  {922582800, 7200, 441},
  {941331600, 3600, 441},
  {954032400, 7200, 441},
  {972781200, 3600, 441},
  {985482000, 7200, 441},
  {1004230800, 3600, 441},
  {1017536400, 7200, 441},
  {1035680400, 3600, 441},
  {1048986000, 7200, 441},
  {1067130000, 3600, 441},
  {1080435600, 7200, 441},
  {1099184400, 3600, 441},
  {1111885200, 7200, 441},
  {1130634000, 3600, 441},
  {1143334800, 7200, 441},
  {1162083600, 3600, 441},
  {1174784400, 7200, 441},
  {1193533200, 3600, 441},
  {1206838800, 7200, 441},
  {1224982800, 3600, 441},
  {1238288400, 7200, 441},
  {1256432400, 3600, 441},
  {1269738000, 7200, 441},
  {1288486800, 3600, 441},
  {1301187600, 7200, 441},
  {1319936400, 3600, 441},
  {1332637200, 7200, 441},
  {1351386000, 3600, 441},
  {1364691600, 7200, 441},
  {1382835600, 3600, 441},
  {1396141200, 7200, 441},
  {1414285200, 3600, 441},
  {1427590800, 7200, 441},
  {1445734800, 3600, 441},
  {1459040400, 7200, 441},
  {1477789200, 3600, 441},
  {1490490000, 7200, 441},
  {1509238800, 3600, 441},
  {1521939600, 7200, 441},
  {1540688400, 3600, 441},
  {1553994000, 7200, 441},
  {1572138000, 3600, 441},
  {1585443600, 7200, 441},
  {1603587600, 3600, 441},
  {1616893200, 7200, 441},
  {1635642000, 3600, 441},
  {1648342800, 7200, 441},
  {1667091600, 3600, 441},
  {1679792400, 7200, 441},
  {1698541200, 3600, 441},
  {1711846800, 7200, 441},
  {1729990800, 3600, 441},
  {1743296400, 7200, 441},
  {1761440400, 3600, 441},
  {1774746000, 7200, 441},
  {1792890000, 3600, 441},
  {1806195600, 7200, 441},
  {1824944400, 3600, 441},
  {1837645200, 7200, 441},
  {1856394000, 3600, 441},
  {1869094800, 7200, 441},
  {1887843600, 3600, 441},
  {1901149200, 7200, 441},
  {1919293200, 3600, 441},
  {1932598800, 7200, 441},
  {1950742800, 3600, 441},
  {1964048400, 7200, 441},
  {1982797200, 3600, 441},
  {1995498000, 7200, 441},
  {2014246800, 3600, 441},
  {2026947600, 7200, 441},
  {2045696400, 3600, 441},
  {2058397200, 7200, 441},
  {2077146000, 3600, 441},
  {2090451600, 7200, 441},
  {2108595600, 3600, 441},
  {2121901200, 7200, 441},
  {2140045200, 3600, 441},
  {INT64_MIN, 9000, 442},
  {-1688265000, 9048, 442},
  {-1656819048, 12648, 442},
  {-1641353448, 9048, 442},
  {-1627965048, 16248, 442},
  {-1618716648, 12648, 442},
  {-1596429048, 16248, 442},
  {-1593829848, 14400, 442},
  {-1589860800, 10800, 442},
  {-1542427200, 14400, 442},
  {-1539493200, 18000, 442},
  {-1525323600, 14400, 442},
  {-1522728000, 10800, 442},
  {-1491188400, 7200, 442},
  {-1247536800, 10800, 442},
  {354920400, 14400, 442},
  {370728000, 10800, 442},
  {386456400, 14400, 442},
  {402264000, 10800, 442},
  {417992400, 14400, 442},
  {433800000, 10800, 442},
  {449614800, 14400, 442},
  {465346800, 10800, 442},
  {481071600, 14400, 442},
  {496796400, 10800, 442},
  {512521200, 14400, 442},
  {528246000, 10800, 442},
  {543970800, 14400, 442},
  {559695600, 10800, 442},
  {575420400, 14400, 442},
  {591145200, 10800, 442},
  {606870000, 14400, 442},
  {622594800, 10800, 442},
  {638319600, 14400, 442},
  {654649200, 10800, 442},
  {670374000, 10800, 442},
  {686102400, 7200, 442},
  {695779200, 10800, 442},
  {701812800, 14400, 442},
  {717534000, 10800, 442},
  {733273200, 14400, 442},
  {748998000, 10800, 442},
  {764722800, 14400, 442},
  {780447600, 10800, 442},
  {796172400, 14400, 442},
  {811897200, 10800, 442},
  {828226800, 14400, 442},
  {846370800, 10800, 442},
  {859676400, 14400, 442},
  {877820400, 10800, 442},
  {891126000, 14400, 442},
  {909270000, 10800, 442},
  {922575600, 14400, 442},
  {941324400, 10800, 442},
  {954025200, 14400, 442},
  {972774000, 10800, 442},
  {985474800, 14400, 442},
  {1004223600, 10800, 442},
  {1017529200, 14400, 442},
  {1035673200, 10800, 442},
  {1048978800, 14400, 442},
  {1067122800, 10800, 442},
  {1080428400, 14400, 442},
  {1099177200, 10800, 442},
  {1111878000, 14400, 442},
  {1130626800, 10800, 442},
  {1143327600, 14400, 442},
  {1162076400, 10800, 442},
  {1174777200, 14400, 442},
  {1193526000, 10800, 442},
  {1206831600, 14400, 442},
  {1224975600, 10800, 442},
  {1238281200, 14400, 442},
  {1256425200, 10800, 442},
  {1269730800, 14400, 442},
  {1288479600, 10800, 442},
  {1301180400, 14400, 442},
  {INT64_MIN, 8008, 443},
  {-1518920008, 7200, 443},
  {166572000, 10800, 443},
  {182293200, 7200, 443},
  {200959200, 10800, 443},
  {213829200, 7200, 443},
  {228866400, 10800, 443},
  {243982800, 7200, 443},
  {260316000, 10800, 443},
  {276123600, 7200, 443},
  {291765600, 10800, 443},
  {307486800, 7200, 443},
  {323820000, 10800, 443},
  {338936400, 7200, 443},
  {354664800, 10800, 443},
  {370386000, 7200, 443},
  {386114400, 10800, 443},
  {401835600, 7200, 443},
  {417564000, 10800, 443},
  {433285200, 7200, 443},
  {449013600, 10800, 443},
  {465339600, 7200, 443},
  {481068000, 10800, 443},
  {496789200, 7200, 443},
  {512517600, 10800, 443},
  {528238800, 7200, 443},
  {543967200, 10800, 443},
  {559688400, 7200, 443},
  {575416800, 10800, 443},
  {591138000, 7200, 443},
  {606866400, 10800, 443},
  {622587600, 7200, 443},
  {638316000, 10800, 443},
  {654642000, 7200, 443},
  {670370400, 10800, 443},
  {686091600, 7200, 443},
  {701820000, 10800, 443},
  {717541200, 7200, 443},
  {733269600, 10800, 443},
  {748990800, 7200, 443},
  {764719200, 10800, 443},
  {780440400, 7200, 443},
  {796168800, 10800, 443},
  {811890000, 7200, 443},
  {828223200, 10800, 443},
  {843944400, 7200, 443},
  {859672800, 10800, 443},
  {875394000, 7200, 443},
  {891122400, 10800, 443},
  {909277200, 7200, 443},
  {922582800, 10800, 443},
  {941331600, 7200, 443},
  {954032400, 10800, 443},
  {972781200, 7200, 443},
  {985482000, 10800, 443},
  {1004230800, 7200, 443},
  {1017536400, 10800, 443},
  {1035680400, 7200, 443},
  {1048986000, 10800, 443},
  {1067130000, 7200, 443},
  {1080435600, 10800, 443},
  {1099184400, 7200, 443},
  {1111885200, 10800, 443},
  {1130634000, 7200, 443},
  {1143334800, 10800, 443},
  {1162083600, 7200, 443},
  {1174784400, 10800, 443},
  {1193533200, 7200, 443},
  {1206838800, 10800, 443},
  {1224982800, 7200, 443},
  {1238288400, 10800, 443},
  {1256432400, 7200, 443},
  {1269738000, 10800, 443},
  {1288486800, 7200, 443},
  {1301187600, 10800, 443},
  {1319936400, 7200, 443},
  {1332637200, 10800, 443},
  {1351386000, 7200, 443},
  {1364691600, 10800, 443},
  {1382835600, 7200, 443},
  {1396141200, 10800, 443},
  {1414285200, 7200, 443},
  {1427590800, 10800, 443},
  {1445734800, 7200, 443},
  {1459040400, 10800, 443},
  {1477789200, 7200, 443},
  {1490490000, 10800, 443},
  {1509238800, 7200, 443},
  {1521939600, 10800, 443},
  {1540688400, 7200, 443},
  {1553994000, 10800, 443},
  {1572138000, 7200, 443},
  {1585443600, 10800, 443},
  {1603587600, 7200, 443},
  {1616893200, 10800, 443},
  {1635642000, 7200, 443},
  {1648342800, 10800, 443},
  {1667091600, 7200, 443},
  {1679792400, 10800, 443},
  {1698541200, 7200, 443},
  {1711846800, 10800, 443},
  {1729990800, 7200, 443},
  {1743296400, 10800, 443},
  {1761440400, 7200, 443},
  {1774746000, 10800, 443},
  {1792890000, 7200, 443},
  {1806195600, 10800, 443},
  {1824944400, 7200, 443},
  {1837645200, 10800, 443},
  {1856394000, 7200, 443},
  {1869094800, 10800, 443},
  {1887843600, 7200, 443},
  {1901149200, 10800, 443},
  {1919293200, 7200, 443},
  {1932598800, 10800, 443},
  {1950742800, 7200, 443},
  {1964048400, 10800, 443},
  {1982797200, 7200, 443},
  {1995498000, 10800, 443},
  {2014246800, 7200, 443},
  {2026947600, 10800, 443},
  {2045696400, 7200, 443},
  {2058397200, 10800, 443},
  {2077146000, 7200, 443},
  {2090451600, 10800, 443},
  {2108595600, 7200, 443},
  {2121901200, 10800, 443},
  {2140045200, 7200, 443},
  {-1691884800, 7200, 444},
  {-1680573600, 3600, 444},
  {-927511200, 7200, 444},
  {-857257200, 3600, 444},
  {-844556400, 7200, 444},
  {-828226800, 3600, 444},
  {-812502000, 7200, 444},
  {-796777200, 3600, 444},
  {-781052400, 7200, 444},
  {-765327600, 3600, 444},
  {-340844400, 7200, 444},
  {-324514800, 3600, 444},
  {-308790000, 7200, 444},
  {-293065200, 3600, 444},
  {-277340400, 7200, 444},
  {-261615600, 3600, 444},
  {-245890800, 7200, 444},
  {-230166000, 3600, 444},
  {-214441200, 7200, 444},
  {-198716400, 3600, 444},
  {-182991600, 7200, 444},
  {-166662000, 3600, 444},
  {-147913200, 7200, 444},
  {-135212400, 3600, 444},
  {315529200, 3600, 444},
  {323830800, 7200, 444},
  {338950800, 3600, 444},
  {354675600, 7200, 444},
  {370400400, 3600, 444},
  {386125200, 7200, 444},
  {401850000, 3600, 444},
  {417574800, 7200, 444},
  {433299600, 3600, 444},
  {449024400, 7200, 444},
  {465354000, 3600, 444},
  {481078800, 7200, 444},
  {496803600, 3600, 444},
  {512528400, 7200, 444},
  {528253200, 3600, 444},
  {543978000, 7200, 444},
  {559702800, 3600, 444},
  {575427600, 7200, 444},
  {591152400, 3600, 444},
  {606877200, 7200, 444},
  {622602000, 3600, 444},
  {638326800, 7200, 444},
  {654656400, 3600, 444},
  {670381200, 7200, 444},
  {686106000, 3600, 444},
  {701830800, 7200, 444},
  {717555600, 3600, 444},
  {733280400, 7200, 444},
  {749005200, 3600, 444},
  {764730000, 7200, 444},
  {780454800, 3600, 444},
  {796179600, 7200, 444},
  {811904400, 3600, 444},
  {828234000, 7200, 444},
  {846378000, 3600, 444},
  {859683600, 7200, 444},
  {877827600, 3600, 444},
  {891133200, 7200, 444},
  {909277200, 3600, 444},
  {922582800, 7200, 444},
  {941331600, 3600, 444},
  {954032400, 7200, 444},
  {972781200, 3600, 444},
  {985482000, 7200, 444},
  {1004230800, 3600, 444},
  {1017536400, 7200, 444},
  {1035680400, 3600, 444},
  {1048986000, 7200, 444},
  {1067130000, 3600, 444},
  {1080435600, 7200, 444},
  {1099184400, 3600, 444},
  {1111885200, 7200, 444},
  {1130634000, 3600, 444},
  {1143334800, 7200, 444},
  {1162083600, 3600, 444},
  {1174784400, 7200, 444},
  {1193533200, 3600, 444},
  {1206838800, 7200, 444},
  {1224982800, 3600, 444},
  {1238288400, 7200, 444},
  {1256432400, 3600, 444},
  {1269738000, 7200, 444},
  {1288486800, 3600, 444},
  {1301187600, 7200, 444},
  {1319936400, 3600, 444},
  {1332637200, 7200, 444},
  {1351386000, 3600, 444},
  {1364691600, 7200, 444},
  {1382835600, 3600, 444},
  {1396141200, 7200, 444},
  {1414285200, 3600, 444},
  {1427590800, 7200, 444},
  {1445734800, 3600, 444},
  {1459040400, 7200, 444},
  {1477789200, 3600, 444},
  {1490490000, 7200, 444},
  {1509238800, 3600, 444},
  {1521939600, 7200, 444},
  {1540688400, 3600, 444},
  {1553994000, 7200, 444},
  {1572138000, 3600, 444},
  {1585443600, 7200, 444},
  {1603587600, 3600, 444},
  {1616893200, 7200, 444},
  {1635642000, 3600, 444},
  {1648342800, 7200, 444},
  {1667091600, 3600, 444},
  {1679792400, 7200, 444},
  {1698541200, 3600, 444},
  {1711846800, 7200, 444},
  {1729990800, 3600, 444},
  {1743296400, 7200, 444},
  {1761440400, 3600, 444},
  {1774746000, 7200, 444},
  {1792890000, 3600, 444},
  {1806195600, 7200, 444},
  {1824944400, 3600, 444},
  {1837645200, 7200, 444},
  {1856394000, 3600, 444},
  {1869094800, 7200, 444},
  {1887843600, 3600, 444},
  {1901149200, 7200, 444},
  {1919293200, 3600, 444},
  {1932598800, 7200, 444},
  {1950742800, 3600, 444},
  {1964048400, 7200, 444},
  {1982797200, 3600, 444},
  {1995498000, 7200, 444},
  {2014246800, 3600, 444},
  {2026947600, 7200, 444},
  {2045696400, 3600, 444},
  {2058397200, 7200, 444},
  {2077146000, 3600, 444},
  {2090451600, 7200, 444},
  {2108595600, 3600, 444},
  {2121901200, 7200, 444},
  {2140045200, 3600, 444},
  {INT64_MIN, 561, 445},
  {-1855958901, 0, 445},
  {-1689814800, 3600, 445},
  {-1680397200, 0, 445},
  {-1665363600, 3600, 445},
  {-1648342800, 0, 445},
  {-1635123600, 3600, 445},
  {-1616893200, 0, 445},
  {-1604278800, 3600, 445},
  {-1585443600, 0, 445},
  {-1574038800, 3600, 445},
  {-1552266000, 0, 445},
  {-1539997200, 3600, 445},
  {-1520557200, 0, 445},
  {-1507510800, 3600, 445},
  {-1490576400, 0, 445},
  {-1470618000, 3600, 445},
  {-1459126800, 0, 445},
  {-1444006800, 3600, 445},
  {-1427677200, 0, 445},
  {-1411952400, 3600, 445},
  {-1396227600, 0, 445},
  {-1379293200, 3600, 445},
  {-1364778000, 0, 445},
  {-1348448400, 3600, 445},
  {-1333328400, 0, 445},
  {-1316394000, 3600, 445},
  {-1301274000, 0, 445},
  {-1284339600, 3600, 445},
  {-1269824400, 0, 445},
  {-1253494800, 3600, 445},
  {-1238374800, 0, 445},
  {-1221440400, 3600, 445},
  {-1206925200, 0, 445},
  {-1191200400, 3600, 445},
  {-1175475600, 0, 445},
  {-1160355600, 3600, 445},
  {-1143421200, 0, 445},
  {-1127696400, 3600, 445},
  {-1111971600, 0, 445},
  {-1096851600, 3600, 445},
  {-1080522000, 0, 445},
  {-1063587600, 3600, 445},
  {-1049072400, 0, 445},
  {-1033347600, 3600, 445},
  {-1017622800, 0, 445},
  {-1002502800, 3600, 445},
  {-986173200, 0, 445},
  {-969238800, 3600, 445},
  {-950490000, 0, 445},
  {-942012000, 3600, 445},
  {-932436000, 7200, 445},
  {-857257200, 3600, 445},
  {-844556400, 7200, 445},
  {-828226800, 3600, 445},
  {-812502000, 7200, 445},
  {-800071200, 7200, 445},
  {-796266000, 3600, 445},
  {-781052400, 7200, 445},
  {-766623600, 3600, 445},
  {196819200, 7200, 445},
  {212540400, 3600, 445},
  {228877200, 7200, 445},
  {243997200, 3600, 445},
  {260326800, 7200, 445},
  {276051600, 3600, 445},
  {291776400, 7200, 445},
  {307501200, 3600, 445},
  {323830800, 7200, 445},
  {338950800, 3600, 445},
  {354675600, 7200, 445},
  {370400400, 3600, 445},
  {386125200, 7200, 445},
  {401850000, 3600, 445},
  {417574800, 7200, 445},
  {433299600, 3600, 445},
  {449024400, 7200, 445},
  {465354000, 3600, 445},
  {481078800, 7200, 445},
  {496803600, 3600, 445},
  {512528400, 7200, 445},
  {528253200, 3600, 445},
  {543978000, 7200, 445},
  {559702800, 3600, 445},
  {575427600, 7200, 445},
  {591152400, 3600, 445},
  {606877200, 7200, 445},
  {622602000, 3600, 445},
  {638326800, 7200, 445},
  {654656400, 3600, 445},
  {670381200, 7200, 445},
  {686106000, 3600, 445},
  {701830800, 7200, 445},
  {717555600, 3600, 445},
  {733280400, 7200, 445},
  {749005200, 3600, 445},
  {764730000, 7200, 445},
  {780454800, 3600, 445},
  {796179600, 7200, 445},
  {811904400, 3600, 445},
  {828234000, 7200, 445},
  {846378000, 3600, 445},
  {859683600, 7200, 445},
  {877827600, 3600, 445},
  {891133200, 7200, 445},
  {909277200, 3600, 445},
  {922582800, 7200, 445},
  {941331600, 3600, 445},
  {954032400, 7200, 445},
  {972781200, 3600, 445},
  {985482000, 7200, 445},
  {1004230800, 3600, 445},
  {1017536400, 7200, 445},
  {1035680400, 3600, 445},
  {1048986000, 7200, 445},
  {1067130000, 3600, 445},
  {1080435600, 7200, 445},
  {1099184400, 3600, 445},
  {1111885200, 7200, 445},
  {1130634000, 3600, 445},
  {1143334800, 7200, 445},
  {1162083600, 3600, 445},
  {1174784400, 7200, 445},
  {1193533200, 3600, 445},
  {1206838800, 7200, 445},
  {1224982800, 3600, 445},
  {1238288400, 7200, 445},
  {1256432400, 3600, 445},
  {1269738000, 7200, 445},
  {1288486800, 3600, 445},
  {1301187600, 7200, 445},
  {1319936400, 3600, 445},
  {1332637200, 7200, 445},
  {1351386000, 3600, 445},
  {1364691600, 7200, 445},
  {1382835600, 3600, 445},
  {1396141200, 7200, 445},
  {1414285200, 3600, 445},
  {1427590800, 7200, 445},
  {1445734800, 3600, 445},
  {1459040400, 7200, 445},
  {1477789200, 3600, 445},
  {1490490000, 7200, 445},
  {1509238800, 3600, 445},
  {1521939600, 7200, 445},
  {1540688400, 3600, 445},
  {1553994000, 7200, 445},
  {1572138000, 3600, 445},
  {1585443600, 7200, 445},
  {1603587600, 3600, 445},
  {1616893200, 7200, 445},
  {1635642000, 3600, 445},
  {1648342800, 7200, 445},
  {1667091600, 3600, 445},
  {1679792400, 7200, 445},
  {1698541200, 3600, 445},
  {1711846800, 7200, 445},
  {1729990800, 3600, 445},
  {1743296400, 7200, 445},
  {1761440400, 3600, 445},
  {1774746000, 7200, 445},
  {1792890000, 3600, 445},
  {1806195600, 7200, 445},
  {1824944400, 3600, 445},
  {1837645200, 7200, 445},
  {1856394000, 3600, 445},
  {1869094800, 7200, 445},
  {1887843600, 3600, 445},
  {1901149200, 7200, 445},
  {1919293200, 3600, 445},
  {1932598800, 7200, 445},
  {1950742800, 3600, 445},
  {1964048400, 7200, 445},
  {1982797200, 3600, 445},
  {1995498000, 7200, 445},
  {2014246800, 3600, 445},
  {2026947600, 7200, 445},
  {2045696400, 3600, 445},
  {2058397200, 7200, 445},
  {2077146000, 3600, 445},
  {2090451600, 7200, 445},
  {2108595600, 3600, 445},
  {2121901200, 7200, 445},
  {2140045200, 3600, 445},
  {-905824800, 7200, 446},
  {-857257200, 3600, 446},
  {-844556400, 7200, 446},
  {-828226800, 3600, 446},
  {-812502000, 7200, 446},
  {-796777200, 3600, 446},
  {-788922000, 3600, 446},
  {-777942000, 7200, 446},
  {-766623600, 3600, 446},
  {407199600, 3600, 446},
  {417574800, 7200, 446},
  {433299600, 3600, 446},
  {449024400, 7200, 446},
  {465354000, 3600, 446},
  {481078800, 7200, 446},
  {496803600, 3600, 446},
  {512528400, 7200, 446},
  {528253200, 3600, 446},
  {543978000, 7200, 446},
  {559702800, 3600, 446},
  {575427600, 7200, 446},
  {591152400, 3600, 446},
  {606877200, 7200, 446},
  {622602000, 3600, 446},
  {638326800, 7200, 446},
  {654656400, 3600, 446},
  {670381200, 7200, 446},
  {686106000, 3600, 446},
  {701830800, 7200, 446},
  {717555600, 3600, 446},
  {733280400, 7200, 446},
  {749005200, 3600, 446},
  {764730000, 7200, 446},
  {780454800, 3600, 446},
  {796179600, 7200, 446},
  {811904400, 3600, 446},
  {828234000, 7200, 446},
  {846378000, 3600, 446},
  {859683600, 7200, 446},
  {877827600, 3600, 446},
  {891133200, 7200, 446},
  {909277200, 3600, 446},
  {922582800, 7200, 446},
  {941331600, 3600, 446},
  {954032400, 7200, 446},
  {972781200, 3600, 446},
  {985482000, 7200, 446},
  {1004230800, 3600, 446},
  {1017536400, 7200, 446},
  {1035680400, 3600, 446},
  {1048986000, 7200, 446},
  {1067130000, 3600, 446},
  {1080435600, 7200, 446},
  {1099184400, 3600, 446},
  {1111885200, 7200, 446},
  {1130634000, 3600, 446},
  {1143334800, 7200, 446},
  {1162083600, 3600, 446},
  {1174784400, 7200, 446},
  {1193533200, 3600, 446},
  {1206838800, 7200, 446},
  {1224982800, 3600, 446},
  {1238288400, 7200, 446},
  {1256432400, 3600, 446},
  {1269738000, 7200, 446},
  {1288486800, 3600, 446},
  {1301187600, 7200, 446},
  {1319936400, 3600, 446},
  {1332637200, 7200, 446},
  {1351386000, 3600, 446},
  {1364691600, 7200, 446},
  {1382835600, 3600, 446},
  {1396141200, 7200, 446},
  {1414285200, 3600, 446},
  {1427590800, 7200, 446},
  {1445734800, 3600, 446},
  {1459040400, 7200, 446},
  {1477789200, 3600, 446},
  {1490490000, 7200, 446},
  {1509238800, 3600, 446},
  {1521939600, 7200, 446},
  {1540688400, 3600, 446},
  {1553994000, 7200, 446},
  {1572138000, 3600, 446},
  {1585443600, 7200, 446},
  {1603587600, 3600, 446},
  {1616893200, 7200, 446},
  {1635642000, 3600, 446},
  {1648342800, 7200, 446},
  {1667091600, 3600, 446},
  {1679792400, 7200, 446},
  {1698541200, 3600, 446},
  {1711846800, 7200, 446},
  {1729990800, 3600, 446},
  {1743296400, 7200, 446},
  {1761440400, 3600, 446},
  {1774746000, 7200, 446},
  {1792890000, 3600, 446},
  {1806195600, 7200, 446},
  {1824944400, 3600, 446},
  {1837645200, 7200, 446},
  {1856394000, 3600, 446},
  {1869094800, 7200, 446},
  {1887843600, 3600, 446},
  {1901149200, 7200, 446},
  {1919293200, 3600, 446},
  {1932598800, 7200, 446},
  {1950742800, 3600, 446},
  {1964048400, 7200, 446},
  {1982797200, 3600, 446},
  {1995498000, 7200, 446},
  {2014246800, 3600, 446},
  {2026947600, 7200, 446},
  {2045696400, 3600, 446},
  {2058397200, 7200, 446},
  {2077146000, 3600, 446},
  {2090451600, 7200, 446},
  {2108595600, 3600, 446},
  {2121901200, 7200, 446},
  {2140045200, 3600, 446},
  {-1693706400, 7200, 447},
  {-1680483600, 3600, 447},
  {-1663455600, 7200, 447},
  {-1650150000, 3600, 447},
  {-1632006000, 7200, 447},
  {-1618700400, 3600, 447},
  {-938905200, 7200, 447},
  {-857257200, 3600, 447},
  {-844556400, 7200, 447},
  {-828226800, 3600, 447},
  {-812502000, 7200, 447},
  {-798073200, 3600, 447},
  {-780534000, 7200, 447},
  {-761180400, 3600, 447},
  {-746578800, 7200, 447},
  {-733359600, 3600, 447},
  {-716425200, 7200, 447},
  {-701910000, 3600, 447},
  {-684975600, 7200, 447},
  {-670460400, 3600, 447},
  {-654217200, 7200, 447},
  {-639010800, 3600, 447},
  {283993200, 3600, 447},
  {291776400, 7200, 447},
  {307501200, 3600, 447},
  {323830800, 7200, 447},
  {338950800, 3600, 447},
  {354675600, 7200, 447},
  {370400400, 3600, 447},
  {386125200, 7200, 447},
  {401850000, 3600, 447},
  {417574800, 7200, 447},
  {433299600, 3600, 447},
  {449024400, 7200, 447},
  {465354000, 3600, 447},
  {481078800, 7200, 447},
  {496803600, 3600, 447},
  {512528400, 7200, 447},
  {528253200, 3600, 447},
  {543978000, 7200, 447},
  {559702800, 3600, 447},
  {575427600, 7200, 447},
  {591152400, 3600, 447},
  {606877200, 7200, 447},
  {622602000, 3600, 447},
  {638326800, 7200, 447},
  {654656400, 3600, 447},
  {670381200, 7200, 447},
  {686106000, 3600, 447},
  {701830800, 7200, 447},
  {717555600, 3600, 447},
  {733280400, 7200, 447},
  {749005200, 3600, 447},
  {764730000, 7200, 447},
  {780454800, 3600, 447},
  {796179600, 7200, 447},
  {811904400, 3600, 447},
  {828234000, 7200, 447},
  {846378000, 3600, 447},
  {859683600, 7200, 447},
  {877827600, 3600, 447},
  {891133200, 7200, 447},
  {909277200, 3600, 447},
  {922582800, 7200, 447},
  {941331600, 3600, 447},
  {954032400, 7200, 447},
  {972781200, 3600, 447},
  {985482000, 7200, 447},
  {1004230800, 3600, 447},
  {1017536400, 7200, 447},
  {1035680400, 3600, 447},
  {1048986000, 7200, 447},
  {1067130000, 3600, 447},
  {1080435600, 7200, 447},
  {1099184400, 3600, 447},
  {1111885200, 7200, 447},
  {1130634000, 3600, 447},
  {1143334800, 7200, 447},
  {1162083600, 3600, 447},
  {1174784400, 7200, 447},
  {1193533200, 3600, 447},
  {1206838800, 7200, 447},
  {1224982800, 3600, 447},
  {1238288400, 7200, 447},
  {1256432400, 3600, 447},
  {1269738000, 7200, 447},
  {1288486800, 3600, 447},
  {1301187600, 7200, 447},
  {1319936400, 3600, 447},
  {1332637200, 7200, 447},
  {1351386000, 3600, 447},
  {1364691600, 7200, 447},
  {1382835600, 3600, 447},
  {1396141200, 7200, 447},
  {1414285200, 3600, 447},
  {1427590800, 7200, 447},
  {1445734800, 3600, 447},
  {1459040400, 7200, 447},
  {1477789200, 3600, 447},
  {1490490000, 7200, 447},
  {1509238800, 3600, 447},
  {1521939600, 7200, 447},
  {1540688400, 3600, 447},
  {1553994000, 7200, 447},
  {1572138000, 3600, 447},
  {1585443600, 7200, 447},
  {1603587600, 3600, 447},
  {1616893200, 7200, 447},
  {1635642000, 3600, 447},
  {1648342800, 7200, 447},
  {1667091600, 3600, 447},
  {1679792400, 7200, 447},
  {1698541200, 3600, 447},
  {1711846800, 7200, 447},
  {1729990800, 3600, 447},
  {1743296400, 7200, 447},
  {1761440400, 3600, 447},
  {1774746000, 7200, 447},
  {1792890000, 3600, 447},
  {1806195600, 7200, 447},
  {1824944400, 3600, 447},
  {1837645200, 7200, 447},
  {1856394000, 3600, 447},
  {1869094800, 7200, 447},
  {1887843600, 3600, 447},
  {1901149200, 7200, 447},
  {1919293200, 3600, 447},
  {1932598800, 7200, 447},
  {1950742800, 3600, 447},
  {1964048400, 7200, 447},
  {1982797200, 3600, 447},
  {1995498000, 7200, 447},
  {2014246800, 3600, 447},
  {2026947600, 7200, 447},
  {2045696400, 3600, 447},
  {2058397200, 7200, 447},
  {2077146000, 3600, 447},
  {2090451600, 7200, 447},
  {2108595600, 3600, 447},
  {2121901200, 7200, 447},
  {2140045200, 3600, 447},
  {-1632008184, 9384, 448},
  {-1618702584, 5784, 448},
  {-1601681784, 9384, 448},
  {-1597275384, 5784, 448},
  {-1377308184, 7200, 448},
  {-928029600, 10800, 448},
  {-899521200, 7200, 448},
  {-857257200, 3600, 448},
  {-844556400, 7200, 448},
  {-828226800, 3600, 448},
  {-812502000, 7200, 448},
  {-796777200, 3600, 448},
  {-795834000, 10800, 448},
  {354920400, 14400, 448},
  {370728000, 10800, 448},
  {386456400, 14400, 448},
  {402264000, 10800, 448},
  {417992400, 14400, 448},
  {433800000, 10800, 448},
  {449614800, 14400, 448},
  {465346800, 10800, 448},
  {481071600, 14400, 448},
  {496796400, 10800, 448},
  {512521200, 14400, 448},
  {528246000, 10800, 448},
  {543970800, 14400, 448},
  {559695600, 10800, 448},
  {575420400, 14400, 448},
  {591145200, 10800, 448},
  {606870000, 10800, 448},
  {622598400, 7200, 448},
  {638323200, 10800, 448},
  {654652800, 7200, 448},
  {670377600, 10800, 448},
  {686102400, 7200, 448},
  {701827200, 10800, 448},
  {717552000, 7200, 448},
  {733276800, 10800, 448},
  {749001600, 7200, 448},
  {764726400, 10800, 448},
  {780451200, 7200, 448},
  {796176000, 10800, 448},
  {811900800, 7200, 448},
  {828230400, 10800, 448},
  {843955200, 7200, 448},
  {853797600, 7200, 448},
  {859683600, 10800, 448},
  {877827600, 7200, 448},
  {891133200, 10800, 448},
  {909277200, 7200, 448},
  {922582800, 10800, 448},
  {941331600, 7200, 448},
  {951775200, 7200, 448},
  {985482000, 10800, 448},
  {1004230800, 7200, 448},
  {1017536400, 10800, 448},
  {1035680400, 7200, 448},
  {1048986000, 10800, 448},
  {1067130000, 7200, 448},
  {1080435600, 10800, 448},
  {1099184400, 7200, 448},
  {1111885200, 10800, 448},
  {1130634000, 7200, 448},
  {1143334800, 10800, 448},
  {1162083600, 7200, 448},
  {1174784400, 10800, 448},
  {1193533200, 7200, 448},
  {1206838800, 10800, 448},
  {1224982800, 7200, 448},
  {1238288400, 10800, 448},
  {1256432400, 7200, 448},
  {1269738000, 10800, 448},
  {1288486800, 7200, 448},
  {1301187600, 10800, 448},
  {1319936400, 7200, 448},
  {1332637200, 10800, 448},
  {1351386000, 7200, 448},
  {1364691600, 10800, 448},
  {1382835600, 7200, 448},
  {1396141200, 10800, 448},
  {1414285200, 7200, 448},
  {1427590800, 10800, 448},
  {1445734800, 7200, 448},
  {1459040400, 10800, 448},
  {1477789200, 7200, 448},
  {1490490000, 10800, 448},
  {1509238800, 7200, 448},
  {1521939600, 10800, 448},
  {1540688400, 7200, 448},
  {1553994000, 10800, 448},
  {1572138000, 7200, 448},
  {1585443600, 10800, 448},
  {1603587600, 7200, 448},
  {1616893200, 10800, 448},
  {1635642000, 7200, 448},
  {1648342800, 10800, 448},
  {1667091600, 7200, 448},
  {1679792400, 10800, 448},
  {1698541200, 7200, 448},
  {1711846800, 10800, 448},
  {1729990800, 7200, 448},
  {1743296400, 10800, 448},
  {1761440400, 7200, 448},
  {1774746000, 10800, 448},
  {1792890000, 7200, 448},
  {1806195600, 10800, 448},
  {1824944400, 7200, 448},
  {1837645200, 10800, 448},
  {1856394000, 7200, 448},
  {1869094800, 10800, 448},
  {1887843600, 7200, 448},
  {1901149200, 10800, 448},
  {1919293200, 7200, 448},
  {1932598800, 10800, 448},
  {1950742800, 7200, 448},
  {1964048400, 10800, 448},
  {1982797200, 7200, 448},
  {1995498000, 10800, 448},
  {2014246800, 7200, 448},
  {2026947600, 10800, 448},
  {2045696400, 7200, 448},
  {2058397200, 10800, 448},
  {2077146000, 7200, 448},
  {2090451600, 10800, 448},
  {2108595600, 7200, 448},
  {2121901200, 10800, 448},
  {2140045200, 7200, 448},
  {-1690851600, 7200, 449},
  {-1680483600, 3600, 449},
  {-1664758800, 7200, 449},
  {-1649034000, 3600, 449},
  {-1635123600, 7200, 449},
  {-1616979600, 3600, 449},
  {-1604278800, 7200, 449},
  {-1585530000, 3600, 449},
  {-1571014800, 7200, 449},
  {-1555290000, 3600, 449},
  {-932432400, 7200, 449},
  {-857257200, 3600, 449},
  {-844556400, 7200, 449},
  {-828226800, 3600, 449},
  {-812502000, 7200, 449},
  {-804823200, 7200, 449},
  {-798080400, 3600, 449},
  {-781052400, 7200, 449},
  {-766717200, 3600, 449},
  {-750898800, 7200, 449},
  {-733359600, 3600, 449},
  {-719456400, 7200, 449},
  {-701917200, 3600, 449},
  {-689209200, 7200, 449},
  {-670460400, 3600, 449},
  {-114051600, 7200, 449},
  {-103168800, 3600, 449},
  {-81997200, 7200, 449},
  {-71719200, 3600, 449},
  {-50547600, 7200, 449},
  {-40269600, 3600, 449},
  {-18493200, 7200, 449},
  {-8215200, 3600, 449},
  {12956400, 7200, 449},
  {23234400, 3600, 449},
  {43801200, 7200, 449},
  {54687600, 3600, 449},
  {75855600, 7200, 449},
  {86738400, 3600, 449},
  {107910000, 7200, 449},
  {118188000, 3600, 449},
  {138754800, 7200, 449},
  {149637600, 3600, 449},
  {170809200, 7200, 449},
  {181090800, 3600, 449},
  {202258800, 7200, 449},
  {212540400, 3600, 449},
  {233103600, 7200, 449},
  {243990000, 3600, 449},
  {265158000, 7200, 449},
  {276044400, 3600, 449},
  {296607600, 7200, 449},
  {307494000, 3600, 449},
  {315529200, 3600, 449},
  {323830800, 7200, 449},
  {338950800, 3600, 449},
  {354675600, 7200, 449},
  {370400400, 3600, 449},
  {386125200, 7200, 449},
  {401850000, 3600, 449},
  {417574800, 7200, 449},
  {433299600, 3600, 449},
  {449024400, 7200, 449},
  {465354000, 3600, 449},
  {481078800, 7200, 449},
  {496803600, 3600, 449},
  {512528400, 7200, 449},
  {528253200, 3600, 449},
  {543978000, 7200, 449},
  {559702800, 3600, 449},
  {575427600, 7200, 449},
  {591152400, 3600, 449},
  {606877200, 7200, 449},
  {622602000, 3600, 449},
  {638326800, 7200, 449},
  {654656400, 3600, 449},
  {670381200, 7200, 449},
  {686106000, 3600, 449},
  {701830800, 7200, 449},
  {717555600, 3600, 449},
  {733280400, 7200, 449},
  {749005200, 3600, 449},
  {764730000, 7200, 449},
  {780454800, 3600, 449},
  {796179600, 7200, 449},
  {811904400, 3600, 449},
  {828234000, 7200, 449},
  {846378000, 3600, 449},
  {859683600, 7200, 449},
  {877827600, 3600, 449},
  {891133200, 7200, 449},
  {909277200, 3600, 449},
  {922582800, 7200, 449},
  {941331600, 3600, 449},
  {954032400, 7200, 449},
  {972781200, 3600, 449},
  {985482000, 7200, 449},
  {1004230800, 3600, 449},
  {1017536400, 7200, 449},
  {1035680400, 3600, 449},
  {1048986000, 7200, 449},
  {1067130000, 3600, 449},
  {1080435600, 7200, 449},
  {1099184400, 3600, 449},
  {1111885200, 7200, 449},
  {1130634000, 3600, 449},
  {1143334800, 7200, 449},
  {1162083600, 3600, 449},
  {1174784400, 7200, 449},
  {1193533200, 3600, 449},
  {1206838800, 7200, 449},
  {1224982800, 3600, 449},
  {1238288400, 7200, 449},
  {1256432400, 3600, 449},
  {1269738000, 7200, 449},
  {1288486800, 3600, 449},
  {1301187600, 7200, 449},
  {1319936400, 3600, 449},
  {1332637200, 7200, 449},
  {1351386000, 3600, 449},
  {1364691600, 7200, 449},
  {1382835600, 3600, 449},
  {1396141200, 7200, 449},
  {1414285200, 3600, 449},
  {1427590800, 7200, 449},
  {1445734800, 3600, 449},
  {1459040400, 7200, 449},
  {1477789200, 3600, 449},
  {1490490000, 7200, 449},
  {1509238800, 3600, 449},
  {1521939600, 7200, 449},
  {1540688400, 3600, 449},
  {1553994000, 7200, 449},
  {1572138000, 3600, 449},
  {1585443600, 7200, 449},
  {1603587600, 3600, 449},
  {1616893200, 7200, 449},
  {1635642000, 3600, 449},
  {1648342800, 7200, 449},
  {1667091600, 3600, 449},
  {1679792400, 7200, 449},
  {1698541200, 3600, 449},
  {1711846800, 7200, 449},
  {1729990800, 3600, 449},
  {1743296400, 7200, 449},
  {1761440400, 3600, 449},
  {1774746000, 7200, 449},
  {1792890000, 3600, 449},
  {1806195600, 7200, 449},
  {1824944400, 3600, 449},
  {1837645200, 7200, 449},
  {1856394000, 3600, 449},
  {1869094800, 7200, 449},
  {1887843600, 3600, 449},
  {1901149200, 7200, 449},
  {1919293200, 3600, 449},
  {1932598800, 7200, 449},
  {1950742800, 3600, 449},
  {1964048400, 7200, 449},
  {1982797200, 3600, 449},
  {1995498000, 7200, 449},
  {2014246800, 3600, 449},
  {2026947600, 7200, 449},
  {2045696400, 3600, 449},
  {2058397200, 7200, 449},
  {2077146000, 3600, 449},
  {2090451600, 7200, 449},
  {2108595600, 3600, 449},
  {2121901200, 7200, 449},
  {2140045200, 3600, 449},
  {INT64_MIN, 7200, 450},
  {INT64_MIN, 12036, 450},
  {-1593825636, 10800, 450},
  {-1247540400, 14400, 450},
  {-1102305600, 14400, 450},
  {354916800, 18000, 450},
  {370724400, 14400, 450},
  {386452800, 18000, 450},
  {402260400, 14400, 450},
  {417988800, 18000, 450},
  {433796400, 14400, 450},
  {449611200, 18000, 450},
  {465343200, 14400, 450},
  {481068000, 18000, 450},
  {496792800, 14400, 450},
  {512517600, 18000, 450},
  {528242400, 14400, 450},
  {543967200, 18000, 450},
  {559692000, 14400, 450},
  {575416800, 18000, 450},
  {591141600, 14400, 450},
  {606866400, 14400, 450},
  {622594800, 10800, 450},
  {638319600, 14400, 450},
  {654649200, 10800, 450},
  {670374000, 10800, 450},
  {686102400, 10800, 450},
  {687916800, 14400, 450},
  {701809200, 18000, 450},
  {717530400, 14400, 450},
  {733269600, 18000, 450},
  {748994400, 14400, 450},
  {764719200, 18000, 450},
  {780444000, 14400, 450},
  {796168800, 18000, 450},
  {811893600, 14400, 450},
  {828223200, 18000, 450},
  {846367200, 14400, 450},
  {859672800, 18000, 450},
  {877816800, 14400, 450},
  {891122400, 18000, 450},
  {909266400, 14400, 450},
  {922572000, 18000, 450},
  {941320800, 14400, 450},
  {954021600, 18000, 450},
  {972770400, 14400, 450},
  {985471200, 18000, 450},
  {1004220000, 14400, 450},
  {1017525600, 18000, 450},
  {1035669600, 14400, 450},
  {1048975200, 18000, 450},
  {1067119200, 14400, 450},
  {1080424800, 18000, 450},
  {1099173600, 14400, 450},
  {1111874400, 18000, 450},
  {1130623200, 14400, 450},
  {1143324000, 18000, 450},
  {1162072800, 14400, 450},
  {1174773600, 18000, 450},
  {1193522400, 14400, 450},
  {1206828000, 18000, 450},
  {1224972000, 14400, 450},
  {1238277600, 18000, 450},
  {1256421600, 14400, 450},
  {1269727200, 14400, 450},
  {1288479600, 10800, 450},
  {1301180400, 14400, 450},
  {-1690851600, 7200, 451},
  {-1680483600, 3600, 451},
  {-1664758800, 7200, 451},
  {-1649034000, 3600, 451},
  {-1635123600, 7200, 451},
  {-1616979600, 3600, 451},
  {-1604278800, 7200, 451},
  {-1585530000, 3600, 451},
  {-1571014800, 7200, 451},
  {-1555290000, 3600, 451},
  {-932432400, 7200, 451},
  {-857257200, 3600, 451},
  {-844556400, 7200, 451},
  {-828226800, 3600, 451},
  {-812502000, 7200, 451},
  {-804823200, 7200, 451},
  {-798080400, 3600, 451},
  {-781052400, 7200, 451},
  {-766717200, 3600, 451},
  {-750898800, 7200, 451},
  {-733359600, 3600, 451},
  {-719456400, 7200, 451},
  {-701917200, 3600, 451},
  {-689209200, 7200, 451},
  {-670460400, 3600, 451},
  {-114051600, 7200, 451},
  {-103168800, 3600, 451},
  {-81997200, 7200, 451},
  {-71719200, 3600, 451},
  {-50547600, 7200, 451},
  {-40269600, 3600, 451},
  {-18493200, 7200, 451},
  {-8215200, 3600, 451},
  {12956400, 7200, 451},
  {23234400, 3600, 451},
  {43801200, 7200, 451},
  {54687600, 3600, 451},
  {75855600, 7200, 451},
  {86738400, 3600, 451},
  {107910000, 7200, 451},
  {118188000, 3600, 451},
  {138754800, 7200, 451},
  {149637600, 3600, 451},
  {170809200, 7200, 451},
  {181090800, 3600, 451},
  {202258800, 7200, 451},
  {212540400, 3600, 451},
  {233103600, 7200, 451},
  {243990000, 3600, 451},
  {265158000, 7200, 451},
  {276044400, 3600, 451},
  {296607600, 7200, 451},
  {307494000, 3600, 451},
  {315529200, 3600, 451},
  {323830800, 7200, 451},
  {338950800, 3600, 451},
  {354675600, 7200, 451},
  {370400400, 3600, 451},
  {386125200, 7200, 451},
  {401850000, 3600, 451},
  {417574800, 7200, 451},
  {433299600, 3600, 451},
  {449024400, 7200, 451},
  {465354000, 3600, 451},
  {481078800, 7200, 451},
  {496803600, 3600, 451},
  {512528400, 7200, 451},
  {528253200, 3600, 451},
  {543978000, 7200, 451},
  {559702800, 3600, 451},
  {575427600, 7200, 451},
  {591152400, 3600, 451},
  {606877200, 7200, 451},
  {622602000, 3600, 451},
  {638326800, 7200, 451},
  {654656400, 3600, 451},
  {670381200, 7200, 451},
  {686106000, 3600, 451},
  {701830800, 7200, 451},
  {717555600, 3600, 451},
  {733280400, 7200, 451},
  {749005200, 3600, 451},
  {764730000, 7200, 451},
  {780454800, 3600, 451},
  {796179600, 7200, 451},
  {811904400, 3600, 451},
  {828234000, 7200, 451},
  {846378000, 3600, 451},
  {859683600, 7200, 451},
  {877827600, 3600, 451},
  {891133200, 7200, 451},
  {909277200, 3600, 451},
  {922582800, 7200, 451},
  {941331600, 3600, 451},
  {954032400, 7200, 451},
  {972781200, 3600, 451},
  {985482000, 7200, 451},
  {1004230800, 3600, 451},
  {1017536400, 7200, 451},
  {1035680400, 3600, 451},
  {1048986000, 7200, 451},
  {1067130000, 3600, 451},
  {1080435600, 7200, 451},
  {1099184400, 3600, 451},
  {1111885200, 7200, 451},
  {1130634000, 3600, 451},
  {1143334800, 7200, 451},
  {1162083600, 3600, 451},
  {1174784400, 7200, 451},
  {1193533200, 3600, 451},
  {1206838800, 7200, 451},
  {1224982800, 3600, 451},
  {1238288400, 7200, 451},
  {1256432400, 3600, 451},
  {1269738000, 7200, 451},
  {1288486800, 3600, 451},
  {1301187600, 7200, 451},
  {1319936400, 3600, 451},
  {1332637200, 7200, 451},
  {1351386000, 3600, 451},
  {1364691600, 7200, 451},
  {1382835600, 3600, 451},
  {1396141200, 7200, 451},
  {1414285200, 3600, 451},
  {1427590800, 7200, 451},
  {1445734800, 3600, 451},
  {1459040400, 7200, 451},
  {1477789200, 3600, 451},
  {1490490000, 7200, 451},
  {1509238800, 3600, 451},
  {1521939600, 7200, 451},
  {1540688400, 3600, 451},
  {1553994000, 7200, 451},
  {1572138000, 3600, 451},
  {1585443600, 7200, 451},
  {1603587600, 3600, 451},
  {1616893200, 7200, 451},
  {1635642000, 3600, 451},
  {1648342800, 7200, 451},
  {1667091600, 3600, 451},
  {1679792400, 7200, 451},
  {1698541200, 3600, 451},
  {1711846800, 7200, 451},
  {1729990800, 3600, 451},
  {1743296400, 7200, 451},
  {1761440400, 3600, 451},
  {1774746000, 7200, 451},
  {1792890000, 3600, 451},
  {1806195600, 7200, 451},
  {1824944400, 3600, 451},
  {1837645200, 7200, 451},
  {1856394000, 3600, 451},
  {1869094800, 7200, 451},
  {1887843600, 3600, 451},
  {1901149200, 7200, 451},
  {1919293200, 3600, 451},
  {1932598800, 7200, 451},
  {1950742800, 3600, 451},
  {1964048400, 7200, 451},
  {1982797200, 3600, 451},
  {1995498000, 7200, 451},
  {2014246800, 3600, 451},
  {2026947600, 7200, 451},
  {2045696400, 3600, 451},
  {2058397200, 7200, 451},
  {2077146000, 3600, 451},
  {2090451600, 7200, 451},
  {2108595600, 3600, 451},
  {2121901200, 7200, 451},
  {2140045200, 3600, 451},
  {-905824800, 7200, 452},
  {-857257200, 3600, 452},
  {-844556400, 7200, 452},
  {-828226800, 3600, 452},
  {-812502000, 7200, 452},
  {-796777200, 3600, 452},
  {-788922000, 3600, 452},
  {-777942000, 7200, 452},
  {-766623600, 3600, 452},
  {407199600, 3600, 452},
  {417574800, 7200, 452},
  {433299600, 3600, 452},
  {449024400, 7200, 452},
  {465354000, 3600, 452},
  {481078800, 7200, 452},
  {496803600, 3600, 452},
  {512528400, 7200, 452},
  {528253200, 3600, 452},
  {543978000, 7200, 452},
  {559702800, 3600, 452},
  {575427600, 7200, 452},
  {591152400, 3600, 452},
  {606877200, 7200, 452},
  {622602000, 3600, 452},
  {638326800, 7200, 452},
  {654656400, 3600, 452},
  {670381200, 7200, 452},
  {686106000, 3600, 452},
  {701830800, 7200, 452},
  {717555600, 3600, 452},
  {733280400, 7200, 452},
  {749005200, 3600, 452},
  {764730000, 7200, 452},
  {780454800, 3600, 452},
  {796179600, 7200, 452},
  {811904400, 3600, 452},
  {828234000, 7200, 452},
  {846378000, 3600, 452},
  {859683600, 7200, 452},
  {877827600, 3600, 452},
  {891133200, 7200, 452},
  {909277200, 3600, 452},
  {922582800, 7200, 452},
  {941331600, 3600, 452},
  {954032400, 7200, 452},
  {972781200, 3600, 452},
  {985482000, 7200, 452},
  {1004230800, 3600, 452},
  {1017536400, 7200, 452},
  {1035680400, 3600, 452},
  {1048986000, 7200, 452},
  {1067130000, 3600, 452},
  {1080435600, 7200, 452},
  {1099184400, 3600, 452},
  {1111885200, 7200, 452},
  {1130634000, 3600, 452},
  {1143334800, 7200, 452},
  {1162083600, 3600, 452},
  {1174784400, 7200, 452},
  {1193533200, 3600, 452},
  {1206838800, 7200, 452},
  {1224982800, 3600, 452},
  {1238288400, 7200, 452},
  {1256432400, 3600, 452},
  {1269738000, 7200, 452},
  {1288486800, 3600, 452},
  {1301187600, 7200, 452},
  {1319936400, 3600, 452},
  {1332637200, 7200, 452},
  {1351386000, 3600, 452},
  {1364691600, 7200, 452},
  {1382835600, 3600, 452},
  {1396141200, 7200, 452},
  {1414285200, 3600, 452},
  {1427590800, 7200, 452},
  {1445734800, 3600, 452},
  {1459040400, 7200, 452},
  {1477789200, 3600, 452},
  {1490490000, 7200, 452},
  {1509238800, 3600, 452},
  {1521939600, 7200, 452},
  {1540688400, 3600, 452},
  {1553994000, 7200, 452},
  {1572138000, 3600, 452},
  {1585443600, 7200, 452},
  {1603587600, 3600, 452},
  {1616893200, 7200, 452},
  {1635642000, 3600, 452},
  {1648342800, 7200, 452},
  {1667091600, 3600, 452},
  {1679792400, 7200, 452},
  {1698541200, 3600, 452},
  {1711846800, 7200, 452},
  {1729990800, 3600, 452},
  {1743296400, 7200, 452},
  {1761440400, 3600, 452},
  {1774746000, 7200, 452},
  {1792890000, 3600, 452},
  {1806195600, 7200, 452},
  {1824944400, 3600, 452},
  {1837645200, 7200, 452},
  {1856394000, 3600, 452},
  {1869094800, 7200, 452},
  {1887843600, 3600, 452},
  {1901149200, 7200, 452},
  {1919293200, 3600, 452},
  {1932598800, 7200, 452},
  {1950742800, 3600, 452},
  {1964048400, 7200, 452},
  {1982797200, 3600, 452},
  {1995498000, 7200, 452},
  {2014246800, 3600, 452},
  {2026947600, 7200, 452},
  {2045696400, 3600, 452},
  {2058397200, 7200, 452},
  {2077146000, 3600, 452},
  {2090451600, 7200, 452},
  {2108595600, 3600, 452},
  {2121901200, 7200, 452},
  {2140045200, 3600, 452},
  {INT64_MIN, 8160, 453},
  {-1441160160, 7200, 453},
  {-1247536800, 10800, 453},
  {-888894000, 7200, 453},
  {-857257200, 3600, 453},
  {-844556400, 7200, 453},
  {-828226800, 3600, 453},
  {-812502000, 7200, 453},
  {-811648800, 10800, 453},
  {354920400, 14400, 453},
  {370728000, 10800, 453},
  {386456400, 14400, 453},
  {402264000, 10800, 453},
  {417992400, 14400, 453},
  {433800000, 10800, 453},
  {449614800, 14400, 453},
  {465346800, 10800, 453},
  {481071600, 14400, 453},
  {496796400, 10800, 453},
  {512521200, 14400, 453},
  {528246000, 10800, 453},
  {543970800, 14400, 453},
  {559695600, 10800, 453},
  {575420400, 14400, 453},
  {591145200, 10800, 453},
  {606870000, 14400, 453},
  {622594800, 10800, 453},
  {631141200, 10800, 453},
  {646786800, 7200, 453},
  {701820000, 10800, 453},
  {717541200, 7200, 453},
  {733269600, 10800, 453},
  {748990800, 7200, 453},
  {764719200, 10800, 453},
  {767739600, 14400, 453},
  {780436800, 10800, 453},
  {796165200, 14400, 453},
  {811886400, 10800, 453},
  {828219600, 14400, 453},
  {828230400, 14400, 453},
  {846374400, 10800, 453},
  {852066000, 10800, 453},
  {859683600, 10800, 453},
  {877827600, 7200, 453},
  {891133200, 10800, 453},
  {909277200, 7200, 453},
  {922582800, 10800, 453},
  {941331600, 7200, 453},
  {954032400, 10800, 453},
  {972781200, 7200, 453},
  {985482000, 10800, 453},
  {1004230800, 7200, 453},
  {1017536400, 10800, 453},
  {1035680400, 7200, 453},
  {1048986000, 10800, 453},
  {1067130000, 7200, 453},
  {1080435600, 10800, 453},
  {1099184400, 7200, 453},
  {1111885200, 10800, 453},
  {1130634000, 7200, 453},
  {1143334800, 10800, 453},
  {1162083600, 7200, 453},
  {1174784400, 10800, 453},
  {1193533200, 7200, 453},
  {1206838800, 10800, 453},
  {1224982800, 7200, 453},
  {1238288400, 10800, 453},
  {1256432400, 7200, 453},
  {1269738000, 10800, 453},
  {1288486800, 7200, 453},
  {1301187600, 10800, 453},
  {1319936400, 7200, 453},
  {1332637200, 10800, 453},
  {1351386000, 7200, 453},
  {1364691600, 10800, 453},
  {1382835600, 7200, 453},
  {1396141200, 10800, 453},
  {1414285200, 7200, 453},
  {1427590800, 10800, 453},
  {1445734800, 7200, 453},
  {1459040400, 10800, 453},
  {1477789200, 7200, 453},
  {1490490000, 10800, 453},
  {1509238800, 7200, 453},
  {1521939600, 10800, 453},
  {1540688400, 7200, 453},
  {1553994000, 10800, 453},
  {1572138000, 7200, 453},
  {1585443600, 10800, 453},
  {1603587600, 7200, 453},
  {1616893200, 10800, 453},
  {1635642000, 7200, 453},
  {1648342800, 10800, 453},
  {1667091600, 7200, 453},
  {1679792400, 10800, 453},
  {1698541200, 7200, 453},
  {1711846800, 10800, 453},
  {1729990800, 7200, 453},
  {1743296400, 10800, 453},
  {1761440400, 7200, 453},
  {1774746000, 10800, 453},
  {1792890000, 7200, 453},
  {1806195600, 10800, 453},
  {1824944400, 7200, 453},
  {1837645200, 10800, 453},
  {1856394000, 7200, 453},
  {1869094800, 10800, 453},
  {1887843600, 7200, 453},
  {1901149200, 10800, 453},
  {1919293200, 7200, 453},
  {1932598800, 10800, 453},
  {1950742800, 7200, 453},
  {1964048400, 10800, 453},
  {1982797200, 7200, 453},
  {1995498000, 10800, 453},
  {2014246800, 7200, 453},
  {2026947600, 10800, 453},
  {2045696400, 7200, 453},
  {2058397200, 10800, 453},
  {2077146000, 7200, 453},
  {2090451600, 10800, 453},
  {2108595600, 7200, 453},
  {2121901200, 10800, 453},
  {2140045200, 7200, 453},
  {-905824800, 7200, 454},
  {-857257200, 3600, 454},
  {-844556400, 7200, 454},
  {-828226800, 3600, 454},
  {-812502000, 7200, 454},
  {-796777200, 3600, 454},
  {-788922000, 3600, 454},
  {-777942000, 7200, 454},
  {-766623600, 3600, 454},
  {407199600, 3600, 454},
  {417574800, 7200, 454},
  {433299600, 3600, 454},
  {449024400, 7200, 454},
  {465354000, 3600, 454},
  {481078800, 7200, 454},
  {496803600, 3600, 454},
  {512528400, 7200, 454},
  {528253200, 3600, 454},
  {543978000, 7200, 454},
  {559702800, 3600, 454},
  {575427600, 7200, 454},
  {591152400, 3600, 454},
  {606877200, 7200, 454},
  {622602000, 3600, 454},
  {638326800, 7200, 454},
  {654656400, 3600, 454},
  {670381200, 7200, 454},
  {686106000, 3600, 454},
  {701830800, 7200, 454},
  {717555600, 3600, 454},
  {733280400, 7200, 454},
  {749005200, 3600, 454},
  {764730000, 7200, 454},
  {780454800, 3600, 454},
  {796179600, 7200, 454},
  {811904400, 3600, 454},
  {828234000, 7200, 454},
  {846378000, 3600, 454},
  {859683600, 7200, 454},
  {877827600, 3600, 454},
  {891133200, 7200, 454},
  {909277200, 3600, 454},
  {922582800, 7200, 454},
  {941331600, 3600, 454},
  {954032400, 7200, 454},
  {972781200, 3600, 454},
  {985482000, 7200, 454},
  {1004230800, 3600, 454},
  {1017536400, 7200, 454},
  {1035680400, 3600, 454},
  {1048986000, 7200, 454},
  {1067130000, 3600, 454},
  {1080435600, 7200, 454},
  {1099184400, 3600, 454},
  {1111885200, 7200, 454},
  {1130634000, 3600, 454},
  {1143334800, 7200, 454},
  {1162083600, 3600, 454},
  {1174784400, 7200, 454},
  {1193533200, 3600, 454},
  {1206838800, 7200, 454},
  {1224982800, 3600, 454},
  {1238288400, 7200, 454},
  {1256432400, 3600, 454},
  {1269738000, 7200, 454},
  {1288486800, 3600, 454},
  {1301187600, 7200, 454},
  {1319936400, 3600, 454},
  {1332637200, 7200, 454},
  {1351386000, 3600, 454},
  {1364691600, 7200, 454},
  {1382835600, 3600, 454},
  {1396141200, 7200, 454},
  {1414285200, 3600, 454},
  {1427590800, 7200, 454},
  {1445734800, 3600, 454},
  {1459040400, 7200, 454},
  {1477789200, 3600, 454},
  {1490490000, 7200, 454},
  {1509238800, 3600, 454},
  {1521939600, 7200, 454},
  {1540688400, 3600, 454},
  {1553994000, 7200, 454},
  {1572138000, 3600, 454},
  {1585443600, 7200, 454},
  {1603587600, 3600, 454},
  {1616893200, 7200, 454},
  {1635642000, 3600, 454},
  {1648342800, 7200, 454},
  {1667091600, 3600, 454},
  {1679792400, 7200, 454},
  {1698541200, 3600, 454},
  {1711846800, 7200, 454},
  {1729990800, 3600, 454},
  {1743296400, 7200, 454},
  {1761440400, 3600, 454},
  {1774746000, 7200, 454},
  {1792890000, 3600, 454},
  {1806195600, 7200, 454},
  {1824944400, 3600, 454},
  {1837645200, 7200, 454},
  {1856394000, 3600, 454},
  {1869094800, 7200, 454},
  {1887843600, 3600, 454},
  {1901149200, 7200, 454},
  {1919293200, 3600, 454},
  {1932598800, 7200, 454},
  {1950742800, 3600, 454},
  {1964048400, 7200, 454},
  {1982797200, 3600, 454},
  {1995498000, 7200, 454},
  {2014246800, 3600, 454},
  {2026947600, 7200, 454},
  {2045696400, 3600, 454},
  {2058397200, 7200, 454},
  {2077146000, 3600, 454},
  {2090451600, 7200, 454},
  {2108595600, 3600, 454},
  {2121901200, 7200, 454},
  {2140045200, 3600, 454},
  {-857257200, 3600, 455},
  {-844556400, 7200, 455},
  {-828226800, 3600, 455},
  {-812502000, 7200, 455},
  {-796777200, 3600, 455},
  {-788922000, 3600, 455},
  {-781048800, 7200, 455},
  {291762000, 10800, 455},
  {307576800, 7200, 455},
  {323816400, 10800, 455},
  {339026400, 7200, 455},
  {355266000, 10800, 455},
  {370393200, 7200, 455},
  {386715600, 10800, 455},
  {401846400, 7200, 455},
  {417571200, 10800, 455},
  {433296000, 7200, 455},
  {449020800, 10800, 455},
  {465350400, 7200, 455},
  {481075200, 10800, 455},
  {496800000, 7200, 455},
  {512524800, 10800, 455},
  {528249600, 7200, 455},
  {543974400, 10800, 455},
  {559699200, 7200, 455},
  {575424000, 10800, 455},
  {591148800, 7200, 455},
  {606873600, 10800, 455},
  {622598400, 7200, 455},
  {638323200, 10800, 455},
  {654652800, 7200, 455},
  {662680800, 7200, 455},
  {670370400, 10800, 455},
  {686091600, 7200, 455},
  {701820000, 10800, 455},
  {717541200, 7200, 455},
  {733269600, 10800, 455},
  {748990800, 7200, 455},
  {764719200, 10800, 455},
  {780440400, 7200, 455},
  {796168800, 10800, 455},
  {811890000, 7200, 455},
  {828223200, 10800, 455},
  {846363600, 7200, 455},
  {859683600, 10800, 455},
  {877827600, 7200, 455},
  {891133200, 10800, 455},
  {909277200, 7200, 455},
  {922582800, 10800, 455},
  {941331600, 7200, 455},
  {954032400, 10800, 455},
  {972781200, 7200, 455},
  {985482000, 10800, 455},
  {1004230800, 7200, 455},
  {1017536400, 10800, 455},
  {1035680400, 7200, 455},
  {1048986000, 10800, 455},
  {1067130000, 7200, 455},
  {1080435600, 10800, 455},
  {1099184400, 7200, 455},
  {1111885200, 10800, 455},
  {1130634000, 7200, 455},
  {1143334800, 10800, 455},
  {1162083600, 7200, 455},
  {1174784400, 10800, 455},
  {1193533200, 7200, 455},
  {1206838800, 10800, 455},
  {1224982800, 7200, 455},
  {1238288400, 10800, 455},
  {1256432400, 7200, 455},
  {1269738000, 10800, 455},
  {1288486800, 7200, 455},
  {1301187600, 10800, 455},
  {1319936400, 7200, 455},
  {1332637200, 10800, 455},
  {1351386000, 7200, 455},
  {1364691600, 10800, 455},
  {1382835600, 7200, 455},
  {1396141200, 10800, 455},
  {1414285200, 7200, 455},
  {1427590800, 10800, 455},
  {1445734800, 7200, 455},
  {1459040400, 10800, 455},
  {1477789200, 7200, 455},
  {1490490000, 10800, 455},
  {1509238800, 7200, 455},
  {1521939600, 10800, 455},
  {1540688400, 7200, 455},
  {1553994000, 10800, 455},
  {1572138000, 7200, 455},
  {1585443600, 10800, 455},
  {1603587600, 7200, 455},
  {1616893200, 10800, 455},
  {1635642000, 7200, 455},
  {1648342800, 10800, 455},
  {1667091600, 7200, 455},
  {1679792400, 10800, 455},
  {1698541200, 7200, 455},
  {1711846800, 10800, 455},
  {1729990800, 7200, 455},
  {1743296400, 10800, 455},
  {1761440400, 7200, 455},
  {1774746000, 10800, 455},
  {1792890000, 7200, 455},
  {1806195600, 10800, 455},
  {1824944400, 7200, 455},
  {1837645200, 10800, 455},
  {1856394000, 7200, 455},
  {1869094800, 10800, 455},
  {1887843600, 7200, 455},
  {1901149200, 10800, 455},
  {1919293200, 7200, 455},
  {1932598800, 10800, 455},
  {1950742800, 7200, 455},
  {1964048400, 10800, 455},
  {1982797200, 7200, 455},
  {1995498000, 10800, 455},
  {2014246800, 7200, 455},
  {2026947600, 10800, 455},
  {2045696400, 7200, 455},
  {2058397200, 10800, 455},
  {2077146000, 7200, 455},
  {2090451600, 10800, 455},
  {2108595600, 7200, 455},
  {2121901200, 10800, 455},
  {2140045200, 7200, 455},
  {-1692496800, 7200, 456},
  {-1680483600, 3600, 456},
  {323830800, 7200, 456},
  {338950800, 3600, 456},
  {354675600, 7200, 456},
  {370400400, 3600, 456},
  {386125200, 7200, 456},
  {401850000, 3600, 456},
  {417574800, 7200, 456},
  {433299600, 3600, 456},
  {449024400, 7200, 456},
  {465354000, 3600, 456},
  {481078800, 7200, 456},
  {496803600, 3600, 456},
  {512528400, 7200, 456},
  {528253200, 3600, 456},
  {543978000, 7200, 456},
  {559702800, 3600, 456},
  {575427600, 7200, 456},
  {591152400, 3600, 456},
  {606877200, 7200, 456},
  {622602000, 3600, 456},
  {638326800, 7200, 456},
  {654656400, 3600, 456},
  {670381200, 7200, 456},
  {686106000, 3600, 456},
  {701830800, 7200, 456},
  {717555600, 3600, 456},
  {733280400, 7200, 456},
  {749005200, 3600, 456},
  {764730000, 7200, 456},
  {780454800, 3600, 456},
  {796179600, 7200, 456},
  {811904400, 3600, 456},
  {828234000, 7200, 456},
  {846378000, 3600, 456},
  {859683600, 7200, 456},
  {877827600, 3600, 456},
  {891133200, 7200, 456},
  {909277200, 3600, 456},
  {922582800, 7200, 456},
  {941331600, 3600, 456},
  {954032400, 7200, 456},
  {972781200, 3600, 456},
  {985482000, 7200, 456},
  {1004230800, 3600, 456},
  {1017536400, 7200, 456},
  {1035680400, 3600, 456},
  {1048986000, 7200, 456},
  {1067130000, 3600, 456},
  {1080435600, 7200, 456},
  {1099184400, 3600, 456},
  {1111885200, 7200, 456},
  {1130634000, 3600, 456},
  {1143334800, 7200, 456},
  {1162083600, 3600, 456},
  {1174784400, 7200, 456},
  {1193533200, 3600, 456},
  {1206838800, 7200, 456},
  {1224982800, 3600, 456},
  {1238288400, 7200, 456},
  {1256432400, 3600, 456},
  {1269738000, 7200, 456},
  {1288486800, 3600, 456},
  {1301187600, 7200, 456},
  {1319936400, 3600, 456},
  {1332637200, 7200, 456},
  {1351386000, 3600, 456},
  {1364691600, 7200, 456},
  {1382835600, 3600, 456},
  {1396141200, 7200, 456},
  {1414285200, 3600, 456},
  {1427590800, 7200, 456},
  {1445734800, 3600, 456},
  {1459040400, 7200, 456},
  {1477789200, 3600, 456},
  {1490490000, 7200, 456},
  {1509238800, 3600, 456},
  {1521939600, 7200, 456},
  {1540688400, 3600, 456},
  {1553994000, 7200, 456},
  {1572138000, 3600, 456},
  {1585443600, 7200, 456},
  {1603587600, 3600, 456},
  {1616893200, 7200, 456},
  {1635642000, 3600, 456},
  {1648342800, 7200, 456},
  {1667091600, 3600, 456},
  {1679792400, 7200, 456},
  {1698541200, 3600, 456},
  {1711846800, 7200, 456},
  {1729990800, 3600, 456},
  {1743296400, 7200, 456},
  {1761440400, 3600, 456},
  {1774746000, 7200, 456},
  {1792890000, 3600, 456},
  {1806195600, 7200, 456},
  {1824944400, 3600, 456},
  {1837645200, 7200, 456},
  {1856394000, 3600, 456},
  {1869094800, 7200, 456},
  {1887843600, 3600, 456},
  {1901149200, 7200, 456},
  {1919293200, 3600, 456},
  {1932598800, 7200, 456},
  {1950742800, 3600, 456},
  {1964048400, 7200, 456},
  {1982797200, 3600, 456},
  {1995498000, 7200, 456},
  {2014246800, 3600, 456},
  {2026947600, 7200, 456},
  {2045696400, 3600, 456},
  {2058397200, 7200, 456},
  {2077146000, 3600, 456},
  {2090451600, 7200, 456},
  {2108595600, 3600, 456},
  {2121901200, 7200, 456},
  {2140045200, 3600, 456},
  {-1638322740, 3600, 457},
  {-1632006000, 7200, 457},
  {-1618700400, 3600, 457},
  {-1593824400, 5940, 457},
  {-1535938740, 7200, 457},
  {-927943200, 10800, 457},
  {-892954800, 7200, 457},
  {-857257200, 3600, 457},
  {-844556400, 7200, 457},
  {-828226800, 3600, 457},
  {-812502000, 7200, 457},
  {-797652000, 10800, 457},
  {354920400, 14400, 457},
  {370728000, 10800, 457},
  {386456400, 14400, 457},
  {402264000, 10800, 457},
  {417992400, 14400, 457},
  {433800000, 10800, 457},
  {449614800, 14400, 457},
  {465346800, 10800, 457},
  {481071600, 14400, 457},
  {496796400, 10800, 457},
  {512521200, 14400, 457},
  {528246000, 10800, 457},
  {543970800, 14400, 457},
  {559695600, 10800, 457},
  {575420400, 14400, 457},
  {591145200, 10800, 457},
  {606870000, 10800, 457},
  {622598400, 7200, 457},
  {638323200, 10800, 457},
  {654652800, 7200, 457},
  {670377600, 10800, 457},
  {686102400, 7200, 457},
  {701827200, 10800, 457},
  {717552000, 7200, 457},
  {733276800, 10800, 457},
  {749001600, 7200, 457},
  {764726400, 10800, 457},
  {780451200, 7200, 457},
  {796176000, 10800, 457},
  {811900800, 7200, 457},
  {828230400, 10800, 457},
  {846374400, 7200, 457},
  {859680000, 10800, 457},
  {877824000, 7200, 457},
  {891129600, 10800, 457},
  {906411600, 10800, 457},
  {909277200, 7200, 457},
  {922582800, 10800, 457},
  {941331600, 7200, 457},
  {941407200, 7200, 457},
  {1017536400, 10800, 457},
  {1035680400, 7200, 457},
  {1048986000, 10800, 457},
  {1067130000, 7200, 457},
  {1080435600, 10800, 457},
  {1099184400, 7200, 457},
  {1111885200, 10800, 457},
  {1130634000, 7200, 457},
  {1143334800, 10800, 457},
  {1162083600, 7200, 457},
  {1174784400, 10800, 457},
  {1193533200, 7200, 457},
  {1206838800, 10800, 457},
  {1224982800, 7200, 457},
  {1238288400, 10800, 457},
  {1256432400, 7200, 457},
  {1269738000, 10800, 457},
  {1288486800, 7200, 457},
  {1301187600, 10800, 457},
  {1319936400, 7200, 457},
  {1332637200, 10800, 457},
  {1351386000, 7200, 457},
  {1364691600, 10800, 457},
  {1382835600, 7200, 457},
  {1396141200, 10800, 457},
  {1414285200, 7200, 457},
  {1427590800, 10800, 457},
  {1445734800, 7200, 457},
  {1459040400, 10800, 457},
  {1477789200, 7200, 457},
  {1490490000, 10800, 457},
  {1509238800, 7200, 457},
  {1521939600, 10800, 457},
  {1540688400, 7200, 457},
  {1553994000, 10800, 457},
  {1572138000, 7200, 457},
  {1585443600, 10800, 457},
  {1603587600, 7200, 457},
  {1616893200, 10800, 457},
  {1635642000, 7200, 457},
  {1648342800, 10800, 457},
  {1667091600, 7200, 457},
  {1679792400, 10800, 457},
  {1698541200, 7200, 457},
  {1711846800, 10800, 457},
  {1729990800, 7200, 457},
  {1743296400, 10800, 457},
  {1761440400, 7200, 457},
  {1774746000, 10800, 457},
  {1792890000, 7200, 457},
  {1806195600, 10800, 457},
  {1824944400, 7200, 457},
  {1837645200, 10800, 457},
  {1856394000, 7200, 457},
  {1869094800, 10800, 457},
  {1887843600, 7200, 457},
  {1901149200, 10800, 457},
  {1919293200, 7200, 457},
  {1932598800, 10800, 457},
  {1950742800, 7200, 457},
  {1964048400, 10800, 457},
  {1982797200, 7200, 457},
  {1995498000, 10800, 457},
  {2014246800, 7200, 457},
  {2026947600, 10800, 457},
  {2045696400, 7200, 457},
  {2058397200, 10800, 457},
  {2077146000, 7200, 457},
  {2090451600, 10800, 457},
  {2108595600, 7200, 457},
  {2121901200, 10800, 457},
  {2140045200, 7200, 457},
  {INT64_MIN, 4760, 458},
  {-1767230360, 3600, 458},
  {-932346000, 7200, 458},
  {-857257200, 3600, 458},
  {-844556400, 7200, 458},
  {-843519600, 3600, 458},
  {136854000, 7200, 458},
  {149896800, 3600, 458},
  {168130800, 7200, 458},
  {181432800, 3600, 458},
  {199839600, 7200, 458},
  {213141600, 3600, 458},
  {231894000, 7200, 458},
  {244591200, 3600, 458},
  {263257200, 7200, 458},
  {276040800, 3600, 458},
  {294706800, 7200, 458},
  {307490400, 3600, 458},
  {326156400, 7200, 458},
  {339458400, 3600, 458},
  {357087600, 7200, 458},
  {370389600, 3600, 458},
  {389142000, 7200, 458},
  {402444000, 3600, 458},
  {419468400, 7200, 458},
  {433807200, 3600, 458},
  {449622000, 7200, 458},
  {465354000, 3600, 458},
  {481078800, 7200, 458},
  {496803600, 3600, 458},
  {512528400, 7200, 458},
  {528253200, 3600, 458},
  {543978000, 7200, 458},
  {559702800, 3600, 458},
  {575427600, 7200, 458},
  {591152400, 3600, 458},
  {606877200, 7200, 458},
  {622602000, 3600, 458},
  {638326800, 7200, 458},
  {654656400, 3600, 458},
  {670381200, 7200, 458},
  {686106000, 3600, 458},
  {701830800, 7200, 458},
  {717555600, 3600, 458},
  {733280400, 7200, 458},
  {749005200, 3600, 458},
  {764730000, 7200, 458},
  {780454800, 3600, 458},
  {796179600, 7200, 458},
  {811904400, 3600, 458},
  {828234000, 7200, 458},
  {846378000, 3600, 458},
  {859683600, 7200, 458},
  {877827600, 3600, 458},
  {891133200, 7200, 458},
  {909277200, 3600, 458},
  {922582800, 7200, 458},
  {941331600, 3600, 458},
  {954032400, 7200, 458},
  {972781200, 3600, 458},
  {985482000, 7200, 458},
  {1004230800, 3600, 458},
  {1017536400, 7200, 458},
  {1035680400, 3600, 458},
  {1048986000, 7200, 458},
  {1067130000, 3600, 458},
  {1080435600, 7200, 458},
  {1099184400, 3600, 458},
  {1111885200, 7200, 458},
  {1130634000, 3600, 458},
  {1143334800, 7200, 458},
  {1162083600, 3600, 458},
  {1174784400, 7200, 458},
  {1193533200, 3600, 458},
  {1206838800, 7200, 458},
  {1224982800, 3600, 458},
  {1238288400, 7200, 458},
  {1256432400, 3600, 458},
  {1269738000, 7200, 458},
  {1288486800, 3600, 458},
  {1301187600, 7200, 458},
  {1319936400, 3600, 458},
  {1332637200, 7200, 458},
  {1351386000, 3600, 458},
  {1364691600, 7200, 458},
  {1382835600, 3600, 458},
  {1396141200, 7200, 458},
  {1414285200, 3600, 458},
  {1427590800, 7200, 458},
  {1445734800, 3600, 458},
  {1459040400, 7200, 458},
  {1477789200, 3600, 458},
  {1490490000, 7200, 458},
  {1509238800, 3600, 458},
  {1521939600, 7200, 458},
  {1540688400, 3600, 458},
  {1553994000, 7200, 458},
  {1572138000, 3600, 458},
  {1585443600, 7200, 458},
  {1603587600, 3600, 458},
  {1616893200, 7200, 458},
  {1635642000, 3600, 458},
  {1648342800, 7200, 458},
  {1667091600, 3600, 458},
  {1679792400, 7200, 458},
  {1698541200, 3600, 458},
  {1711846800, 7200, 458},
  {1729990800, 3600, 458},
  {1743296400, 7200, 458},
  {1761440400, 3600, 458},
  {1774746000, 7200, 458},
  {1792890000, 3600, 458},
  {1806195600, 7200, 458},
  {1824944400, 3600, 458},
  {1837645200, 7200, 458},
  {1856394000, 3600, 458},
  {1869094800, 7200, 458},
  {1887843600, 3600, 458},
  {1901149200, 7200, 458},
  {1919293200, 3600, 458},
  {1932598800, 7200, 458},
  {1950742800, 3600, 458},
  {1964048400, 7200, 458},
  {1982797200, 3600, 458},
  {1995498000, 7200, 458},
  {2014246800, 3600, 458},
  {2026947600, 7200, 458},
  {2045696400, 3600, 458},
  {2058397200, 7200, 458},
  {2077146000, 3600, 458},
  {2090451600, 7200, 458},
  {2108595600, 3600, 458},
  {2121901200, 7200, 458},
  {2140045200, 3600, 458},
  {INT64_MIN, 6900, 459},
  {-1637114100, 6264, 459},
  {-1213148664, 7200, 459},
  {-1187056800, 10800, 459},
  {-1175479200, 7200, 459},
  {-1159754400, 10800, 459},
  {-1144029600, 7200, 459},
  {-1127700000, 10800, 459},
  {-1111975200, 7200, 459},
  {-1096250400, 10800, 459},
  {-1080525600, 7200, 459},
  {-1064800800, 10800, 459},
  {-1049076000, 7200, 459},
  {-1033351200, 10800, 459},
  {-1017626400, 7200, 459},
  {-1001901600, 10800, 459},
  {-986176800, 7200, 459},
  {-970452000, 10800, 459},
  {-954727200, 7200, 459},
  {-927165600, 10800, 459},
  {-898138800, 7200, 459},
  {-857257200, 3600, 459},
  {-844556400, 7200, 459},
  {-828226800, 3600, 459},
  {-812502000, 7200, 459},
  {-800157600, 10800, 459},
  {354920400, 14400, 459},
  {370728000, 10800, 459},
  {386456400, 14400, 459},
  {402264000, 10800, 459},
  {417992400, 14400, 459},
  {433800000, 10800, 459},
  {449614800, 14400, 459},
  {465346800, 10800, 459},
  {481071600, 14400, 459},
  {496796400, 10800, 459},
  {512521200, 14400, 459},
  {528246000, 10800, 459},
  {543970800, 14400, 459},
  {559695600, 10800, 459},
  {575420400, 14400, 459},
  {591145200, 10800, 459},
  {606870000, 14400, 459},
  {622594800, 10800, 459},
  {631141200, 10800, 459},
  {641941200, 7200, 459},
  {670377600, 10800, 459},
  {686102400, 7200, 459},
  {694216800, 7200, 459},
  {701820000, 10800, 459},
  {717541200, 7200, 459},
  {733269600, 10800, 459},
  {748990800, 7200, 459},
  {764719200, 10800, 459},
  {780440400, 7200, 459},
  {796168800, 10800, 459},
  {811890000, 7200, 459},
  {828223200, 10800, 459},
  {846363600, 7200, 459},
  {859683600, 10800, 459},
  {877827600, 7200, 459},
  {891133200, 10800, 459},
  {909277200, 7200, 459},
  {922582800, 10800, 459},
  {941331600, 7200, 459},
  {954032400, 10800, 459},
  {972781200, 7200, 459},
  {985482000, 10800, 459},
  {1004230800, 7200, 459},
  {1017536400, 10800, 459},
  {1035680400, 7200, 459},
  {1048986000, 10800, 459},
  {1067130000, 7200, 459},
  {1080435600, 10800, 459},
  {1099184400, 7200, 459},
  {1111885200, 10800, 459},
  {1130634000, 7200, 459},
  {1143334800, 10800, 459},
  {1162083600, 7200, 459},
  {1174784400, 10800, 459},
  {1193533200, 7200, 459},
  {1206838800, 10800, 459},
  {1224982800, 7200, 459},
  {1238288400, 10800, 459},
  {1256432400, 7200, 459},
  {1269738000, 10800, 459},
  {1288486800, 7200, 459},
  {1301187600, 10800, 459},
  {1319936400, 7200, 459},
  {1332637200, 10800, 459},
  {1351386000, 7200, 459},
  {1364691600, 10800, 459},
  {1382835600, 7200, 459},
  {1396141200, 10800, 459},
  {1414285200, 7200, 459},
  {1427590800, 10800, 459},
  {1445734800, 7200, 459},
  {1459040400, 10800, 459},
  {1477789200, 7200, 459},
  {1490490000, 10800, 459},
  {1509238800, 7200, 459},
  {1521939600, 10800, 459},
  {1540688400, 7200, 459},
  {1553994000, 10800, 459},
  {1572138000, 7200, 459},
  {1585443600, 10800, 459},
  {1603587600, 7200, 459},
  {1616893200, 10800, 459},
  {1635642000, 7200, 459},
  {1648342800, 10800, 459},
  {1667091600, 7200, 459},
  {1679792400, 10800, 459},
  {1698541200, 7200, 459},
  {1711846800, 10800, 459},
  {1729990800, 7200, 459},
  {1743296400, 10800, 459},
  {1761440400, 7200, 459},
  {1774746000, 10800, 459},
  {1792890000, 7200, 459},
  {1806195600, 10800, 459},
  {1824944400, 7200, 459},
  {1837645200, 10800, 459},
  {1856394000, 7200, 459},
  {1869094800, 10800, 459},
  {1887843600, 7200, 459},
  {1901149200, 10800, 459},
  {1919293200, 7200, 459},
  {1932598800, 10800, 459},
  {1950742800, 7200, 459},
  {1964048400, 10800, 459},
  {1982797200, 7200, 459},
  {1995498000, 10800, 459},
  {2014246800, 7200, 459},
  {2026947600, 10800, 459},
  {2045696400, 7200, 459},
  {2058397200, 10800, 459},
  {2077146000, 7200, 459},
  {2090451600, 10800, 459},
  {2108595600, 7200, 459},
  {2121901200, 10800, 459},
  {2140045200, 7200, 459},
  {-938905200, 7200, 460},
  {-857257200, 3600, 460},
  {-844556400, 7200, 460},
  {-828226800, 3600, 460},
  {-812502000, 7200, 460},
  {-796874400, 7200, 460},
  {-794714400, 3600, 460},
  {-773456400, 10800, 460},
  {354920400, 14400, 460},
  {370728000, 10800, 460},
  {386456400, 14400, 460},
  {402264000, 10800, 460},
  {417992400, 14400, 460},
  {433800000, 10800, 460},
  {449614800, 14400, 460},
  {465346800, 10800, 460},
  {481071600, 14400, 460},
  {496796400, 10800, 460},
  {512521200, 14400, 460},
  {528246000, 10800, 460},
  {543970800, 14400, 460},
  {559695600, 10800, 460},
  {575420400, 14400, 460},
  {591145200, 10800, 460},
  {606870000, 14400, 460},
  {622594800, 10800, 460},
  {631141200, 10800, 460},
  {646786800, 3600, 460},
  {670384800, 7200, 460},
  {701820000, 10800, 460},
  {717541200, 7200, 460},
  {733269600, 10800, 460},
  {748990800, 7200, 460},
  {764719200, 10800, 460},
  {780440400, 7200, 460},
  {796179600, 10800, 460},
  {811904400, 7200, 460},
  {828234000, 10800, 460},
  {846378000, 7200, 460},
  {859683600, 10800, 460},
  {877827600, 7200, 460},
  {891133200, 10800, 460},
  {909277200, 7200, 460},
  {922582800, 10800, 460},
  {941331600, 7200, 460},
  {954032400, 10800, 460},
  {972781200, 7200, 460},
  {985482000, 10800, 460},
  {1004230800, 7200, 460},
  {1017536400, 10800, 460},
  {1035680400, 7200, 460},
  {1048986000, 10800, 460},
  {1067130000, 7200, 460},
  {1080435600, 10800, 460},
  {1099184400, 7200, 460},
  {1111885200, 10800, 460},
  {1130634000, 7200, 460},
  {1143334800, 10800, 460},
  {1162083600, 7200, 460},
  {1174784400, 10800, 460},
  {1193533200, 7200, 460},
  {1206838800, 10800, 460},
  {1224982800, 7200, 460},
  {1238288400, 10800, 460},
  {1256432400, 7200, 460},
  {1269738000, 10800, 460},
  {1288486800, 7200, 460},
  {1301187600, 10800, 460},
  {1319936400, 7200, 460},
  {1332637200, 10800, 460},
  {1351386000, 7200, 460},
  {1364691600, 10800, 460},
  {1382835600, 7200, 460},
  {1396141200, 10800, 460},
  {1414285200, 7200, 460},
  {1427590800, 10800, 460},
  {1445734800, 7200, 460},
  {1459040400, 10800, 460},
  {1477789200, 7200, 460},
  {1490490000, 10800, 460},
  {1509238800, 7200, 460},
  {1521939600, 10800, 460},
  {1540688400, 7200, 460},
  {1553994000, 10800, 460},
  {1572138000, 7200, 460},
  {1585443600, 10800, 460},
  {1603587600, 7200, 460},
  {1616893200, 10800, 460},
  {1635642000, 7200, 460},
  {1648342800, 10800, 460},
  {1667091600, 7200, 460},
  {1679792400, 10800, 460},
  {1698541200, 7200, 460},
  {1711846800, 10800, 460},
  {1729990800, 7200, 460},
  {1743296400, 10800, 460},
  {1761440400, 7200, 460},
  {1774746000, 10800, 460},
  {1792890000, 7200, 460},
  {1806195600, 10800, 460},
  {1824944400, 7200, 460},
  {1837645200, 10800, 460},
  {1856394000, 7200, 460},
  {1869094800, 10800, 460},
  {1887843600, 7200, 460},
  {1901149200, 10800, 460},
  {1919293200, 7200, 460},
  {1932598800, 10800, 460},
  {1950742800, 7200, 460},
  {1964048400, 10800, 460},
  {1982797200, 7200, 460},
  {1995498000, 10800, 460},
  {2014246800, 7200, 460},
  {2026947600, 10800, 460},
  {2045696400, 7200, 460},
  {2058397200, 10800, 460},
  {2077146000, 7200, 460},
  {2090451600, 10800, 460},
  {2108595600, 7200, 460},
  {2121901200, 10800, 460},
  {2140045200, 7200, 460},
  {INT64_MIN, 3600, 461},
  {354675600, 7200, 461},
  {370400400, 3600, 461},
  {386125200, 7200, 461},
  {401850000, 3600, 461},
  {417574800, 7200, 461},
  {433299600, 3600, 461},
  {449024400, 7200, 461},
  {465354000, 3600, 461},
  {481078800, 7200, 461},
  {496803600, 3600, 461},
  {512528400, 7200, 461},
  {528253200, 3600, 461},
  {543978000, 7200, 461},
  {559702800, 3600, 461},
  {575427600, 7200, 461},
  {591152400, 3600, 461},
  {606877200, 7200, 461},
  {622602000, 3600, 461},
  {638326800, 7200, 461},
  {654656400, 3600, 461},
  {670381200, 7200, 461},
  {686106000, 3600, 461},
  {701830800, 7200, 461},
  {717555600, 3600, 461},
  {733280400, 7200, 461},
  {749005200, 3600, 461},
  {764730000, 7200, 461},
  {780454800, 3600, 461},
  {796179600, 7200, 461},
  {811904400, 3600, 461},
  {828234000, 7200, 461},
  {846378000, 3600, 461},
  {859683600, 7200, 461},
  {877827600, 3600, 461},
  {891133200, 7200, 461},
  {909277200, 3600, 461},
  {922582800, 7200, 461},
  {941331600, 3600, 461},
  {954032400, 7200, 461},
  {972781200, 3600, 461},
  {985482000, 7200, 461},
  {1004230800, 3600, 461},
  {1017536400, 7200, 461},
  {1035680400, 3600, 461},
  {1048986000, 7200, 461},
  {1067130000, 3600, 461},
  {1080435600, 7200, 461},
  {1099184400, 3600, 461},
  {1111885200, 7200, 461},
  {1130634000, 3600, 461},
  {1143334800, 7200, 461},
  {1162083600, 3600, 461},
  {1174784400, 7200, 461},
  {1193533200, 3600, 461},
  {1206838800, 7200, 461},
  {1224982800, 3600, 461},
  {1238288400, 7200, 461},
  {1256432400, 3600, 461},
  {1269738000, 7200, 461},
  {1288486800, 3600, 461},
  {1301187600, 7200, 461},
  {1319936400, 3600, 461},
  {1332637200, 7200, 461},
  {1351386000, 3600, 461},
  {1364691600, 7200, 461},
  {1382835600, 3600, 461},
  {1396141200, 7200, 461},
  {1414285200, 3600, 461},
  {1427590800, 7200, 461},
  {1445734800, 3600, 461},
  {1459040400, 7200, 461},
  {1477789200, 3600, 461},
  {1490490000, 7200, 461},
  {1509238800, 3600, 461},
  {1521939600, 7200, 461},
  {1540688400, 3600, 461},
  {1553994000, 7200, 461},
  {1572138000, 3600, 461},
  {1585443600, 7200, 461},
  {1603587600, 3600, 461},
  {1616893200, 7200, 461},
  {1635642000, 3600, 461},
  {1648342800, 7200, 461},
  {1667091600, 3600, 461},
  {1679792400, 7200, 461},
  {1698541200, 3600, 461},
  {1711846800, 7200, 461},
  {1729990800, 3600, 461},
  {1743296400, 7200, 461},
  {1761440400, 3600, 461},
  {1774746000, 7200, 461},
  {1792890000, 3600, 461},
  {1806195600, 7200, 461},
  {1824944400, 3600, 461},
  {1837645200, 7200, 461},
  {1856394000, 3600, 461},
  {1869094800, 7200, 461},
  {1887843600, 3600, 461},
  {1901149200, 7200, 461},
  {1919293200, 3600, 461},
  {1932598800, 7200, 461},
  {1950742800, 3600, 461},
  {1964048400, 7200, 461},
  {1982797200, 3600, 461},
  {1995498000, 7200, 461},
  {2014246800, 3600, 461},
  {2026947600, 7200, 461},
  {2045696400, 3600, 461},
  {2058397200, 7200, 461},
  {2077146000, 3600, 461},
  {2090451600, 7200, 461},
  {2108595600, 3600, 461},
  {2121901200, 7200, 461},
  {2140045200, 3600, 461},
  {-1690851600, 7200, 462},
  {-1680483600, 3600, 462},
  {-1664758800, 7200, 462},
  {-1649034000, 3600, 462},
  {-1635123600, 7200, 462},
  {-1616979600, 3600, 462},
  {-1604278800, 7200, 462},
  {-1585530000, 3600, 462},
  {-1571014800, 7200, 462},
  {-1555290000, 3600, 462},
  {-932432400, 7200, 462},
  {-857257200, 3600, 462},
  {-844556400, 7200, 462},
  {-828226800, 3600, 462},
  {-812502000, 7200, 462},
  {-804823200, 7200, 462},
  {-798080400, 3600, 462},
  {-781052400, 7200, 462},
  {-766717200, 3600, 462},
  {-750898800, 7200, 462},
  {-733359600, 3600, 462},
  {-719456400, 7200, 462},
  {-701917200, 3600, 462},
  {-689209200, 7200, 462},
  {-670460400, 3600, 462},
  {-114051600, 7200, 462},
  {-103168800, 3600, 462},
  {-81997200, 7200, 462},
  {-71719200, 3600, 462},
  {-50547600, 7200, 462},
  {-40269600, 3600, 462},
  {-18493200, 7200, 462},
  {-8215200, 3600, 462},
  {12956400, 7200, 462},
  {23234400, 3600, 462},
  {43801200, 7200, 462},
  {54687600, 3600, 462},
  {75855600, 7200, 462},
  {86738400, 3600, 462},
  {107910000, 7200, 462},
  {118188000, 3600, 462},
  {138754800, 7200, 462},
  {149637600, 3600, 462},
  {170809200, 7200, 462},
  {181090800, 3600, 462},
  {202258800, 7200, 462},
  {212540400, 3600, 462},
  {233103600, 7200, 462},
  {243990000, 3600, 462},
  {265158000, 7200, 462},
  {276044400, 3600, 462},
  {296607600, 7200, 462},
  {307494000, 3600, 462},
  {315529200, 3600, 462},
  {323830800, 7200, 462},
  {338950800, 3600, 462},
  {354675600, 7200, 462},
  {370400400, 3600, 462},
  {386125200, 7200, 462},
  {401850000, 3600, 462},
  {417574800, 7200, 462},
  {433299600, 3600, 462},
  {449024400, 7200, 462},
  {465354000, 3600, 462},
  {481078800, 7200, 462},
  {496803600, 3600, 462},
  {512528400, 7200, 462},
  {528253200, 3600, 462},
  {543978000, 7200, 462},
  {559702800, 3600, 462},
  {575427600, 7200, 462},
  {591152400, 3600, 462},
  {606877200, 7200, 462},
  {622602000, 3600, 462},
  {638326800, 7200, 462},
  {654656400, 3600, 462},
  {670381200, 7200, 462},
  {686106000, 3600, 462},
  {701830800, 7200, 462},
  {717555600, 3600, 462},
  {733280400, 7200, 462},
  {749005200, 3600, 462},
  {764730000, 7200, 462},
  {780454800, 3600, 462},
  {796179600, 7200, 462},
  {811904400, 3600, 462},
  {828234000, 7200, 462},
  {846378000, 3600, 462},
  {859683600, 7200, 462},
  {877827600, 3600, 462},
  {891133200, 7200, 462},
  {909277200, 3600, 462},
  {922582800, 7200, 462},
  {941331600, 3600, 462},
  {954032400, 7200, 462},
  {972781200, 3600, 462},
  {985482000, 7200, 462},
  {1004230800, 3600, 462},
  {1017536400, 7200, 462},
  {1035680400, 3600, 462},
  {1048986000, 7200, 462},
  {1067130000, 3600, 462},
  {1080435600, 7200, 462},
  {1099184400, 3600, 462},
  {1111885200, 7200, 462},
  {1130634000, 3600, 462},
  {1143334800, 7200, 462},
  {1162083600, 3600, 462},
  {1174784400, 7200, 462},
  {1193533200, 3600, 462},
  {1206838800, 7200, 462},
  {1224982800, 3600, 462},
  {1238288400, 7200, 462},
  {1256432400, 3600, 462},
  {1269738000, 7200, 462},
  {1288486800, 3600, 462},
  {1301187600, 7200, 462},
  {1319936400, 3600, 462},
  {1332637200, 7200, 462},
  {1351386000, 3600, 462},
  {1364691600, 7200, 462},
  {1382835600, 3600, 462},
  {1396141200, 7200, 462},
  {1414285200, 3600, 462},
  {1427590800, 7200, 462},
  {1445734800, 3600, 462},
  {1459040400, 7200, 462},
  {1477789200, 3600, 462},
  {1490490000, 7200, 462},
  {1509238800, 3600, 462},
  {1521939600, 7200, 462},
  {1540688400, 3600, 462},
  {1553994000, 7200, 462},
  {1572138000, 3600, 462},
  {1585443600, 7200, 462},
  {1603587600, 3600, 462},
  {1616893200, 7200, 462},
  {1635642000, 3600, 462},
  {1648342800, 7200, 462},
  {1667091600, 3600, 462},
  {1679792400, 7200, 462},
  {1698541200, 3600, 462},
  {1711846800, 7200, 462},
  {1729990800, 3600, 462},
  {1743296400, 7200, 462},
  {1761440400, 3600, 462},
  {1774746000, 7200, 462},
  {1792890000, 3600, 462},
  {1806195600, 7200, 462},
  {1824944400, 3600, 462},
  {1837645200, 7200, 462},
  {1856394000, 3600, 462},
  {1869094800, 7200, 462},
  {1887843600, 3600, 462},
  {1901149200, 7200, 462},
  {1919293200, 3600, 462},
  {1932598800, 7200, 462},
  {1950742800, 3600, 462},
  {1964048400, 7200, 462},
  {1982797200, 3600, 462},
  {1995498000, 7200, 462},
  {2014246800, 3600, 462},
  {2026947600, 7200, 462},
  {2045696400, 3600, 462},
  {2058397200, 7200, 462},
  {2077146000, 3600, 462},
  {2090451600, 7200, 462},
  {2108595600, 3600, 462},
  {2121901200, 7200, 462},
  {2140045200, 3600, 462},
  {-1693706400, 7200, 463},
  {-1680483600, 3600, 463},
  {-1663455600, 7200, 463},
  {-1650150000, 3600, 463},
  {-1632006000, 7200, 463},
  {-1618700400, 3600, 463},
  {-1577926800, 3600, 463},
  {-1569711600, 7200, 463},
  {-1555801200, 3600, 463},
  {-938905200, 7200, 463},
  {-857257200, 3600, 463},
  {-844556400, 7200, 463},
  {-828226800, 3600, 463},
  {-812502000, 7200, 463},
  {-796777200, 3600, 463},
  {-781052400, 7200, 463},
  {-780188400, 3600, 463},
  {-757386000, 3600, 463},
  {-748479600, 7200, 463},
  {-733359600, 3600, 463},
  {-717634800, 7200, 463},
  {-701910000, 3600, 463},
  {-684975600, 7200, 463},
  {-670460400, 3600, 463},
  {323823600, 7200, 463},
  {338940000, 3600, 463},
  {354675600, 7200, 463},
  {370400400, 3600, 463},
  {386125200, 7200, 463},
  {401850000, 3600, 463},
  {417574800, 7200, 463},
  {433299600, 3600, 463},
  {449024400, 7200, 463},
  {465354000, 3600, 463},
  {481078800, 7200, 463},
  {496803600, 3600, 463},
  {512528400, 7200, 463},
  {528253200, 3600, 463},
  {543978000, 7200, 463},
  {559702800, 3600, 463},
  {575427600, 7200, 463},
  {591152400, 3600, 463},
  {606877200, 7200, 463},
  {622602000, 3600, 463},
  {638326800, 7200, 463},
  {654656400, 3600, 463},
  {670381200, 7200, 463},
  {686106000, 3600, 463},
  {701830800, 7200, 463},
  {717555600, 3600, 463},
  {733280400, 7200, 463},
  {749005200, 3600, 463},
  {764730000, 7200, 463},
  {780454800, 3600, 463},
  {796179600, 7200, 463},
  {811904400, 3600, 463},
  {828234000, 7200, 463},
  {846378000, 3600, 463},
  {859683600, 7200, 463},
  {877827600, 3600, 463},
  {891133200, 7200, 463},
  {909277200, 3600, 463},
  {922582800, 7200, 463},
  {941331600, 3600, 463},
  {954032400, 7200, 463},
  {972781200, 3600, 463},
  {985482000, 7200, 463},
  {1004230800, 3600, 463},
  {1017536400, 7200, 463},
  {1035680400, 3600, 463},
  {1048986000, 7200, 463},
  {1067130000, 3600, 463},
  {1080435600, 7200, 463},
  {1099184400, 3600, 463},
  {1111885200, 7200, 463},
  {1130634000, 3600, 463},
  {1143334800, 7200, 463},
  {1162083600, 3600, 463},
  {1174784400, 7200, 463},
  {1193533200, 3600, 463},
  {1206838800, 7200, 463},
  {1224982800, 3600, 463},
  {1238288400, 7200, 463},
  {1256432400, 3600, 463},
  {1269738000, 7200, 463},
  {1288486800, 3600, 463},
  {1301187600, 7200, 463},
  {1319936400, 3600, 463},
  {1332637200, 7200, 463},
  {1351386000, 3600, 463},
  {1364691600, 7200, 463},
  {1382835600, 3600, 463},
  {1396141200, 7200, 463},
  {1414285200, 3600, 463},
  {1427590800, 7200, 463},
  {1445734800, 3600, 463},
  {1459040400, 7200, 463},
  {1477789200, 3600, 463},
  {1490490000, 7200, 463},
  {1509238800, 3600, 463},
  {1521939600, 7200, 463},
  {1540688400, 3600, 463},
  {1553994000, 7200, 463},
  {1572138000, 3600, 463},
  {1585443600, 7200, 463},
  {1603587600, 3600, 463},
  {1616893200, 7200, 463},
  {1635642000, 3600, 463},
  {1648342800, 7200, 463},
  {1667091600, 3600, 463},
  {1679792400, 7200, 463},
  {1698541200, 3600, 463},
  {1711846800, 7200, 463},
  {1729990800, 3600, 463},
  {1743296400, 7200, 463},
  {1761440400, 3600, 463},
  {1774746000, 7200, 463},
  {1792890000, 3600, 463},
  {1806195600, 7200, 463},
  {1824944400, 3600, 463},
  {1837645200, 7200, 463},
  {1856394000, 3600, 463},
  {1869094800, 7200, 463},
  {1887843600, 3600, 463},
  {1901149200, 7200, 463},
  {1919293200, 3600, 463},
  {1932598800, 7200, 463},
  {1950742800, 3600, 463},
  {1964048400, 7200, 463},
  {1982797200, 3600, 463},
  {1995498000, 7200, 463},
  {2014246800, 3600, 463},
  {2026947600, 7200, 463},
  {2045696400, 3600, 463},
  {2058397200, 7200, 463},
  {2077146000, 3600, 463},
  {2090451600, 7200, 463},
  {2108595600, 3600, 463},
  {2121901200, 7200, 463},
  {2140045200, 3600, 463},
  {INT64_MIN, 5040, 464},
  {-1672536240, 5736, 464},
  {-1585100136, 3600, 464},
  {-1561251600, 7200, 464},
  {-1553565600, 3600, 464},
  {-928198800, 10800, 464},
  {-900126000, 7200, 464},
  {-857257200, 3600, 464},
  {-844556400, 7200, 464},
  {-828226800, 3600, 464},
  {-812502000, 7200, 464},
  {-802144800, 10800, 464},
  {354920400, 14400, 464},
  {370728000, 10800, 464},
  {386456400, 14400, 464},
  {402264000, 10800, 464},
  {417992400, 14400, 464},
  {433800000, 10800, 464},
  {449614800, 14400, 464},
  {465346800, 10800, 464},
  {481071600, 14400, 464},
  {496796400, 10800, 464},
  {512521200, 14400, 464},
  {528246000, 10800, 464},
  {543970800, 14400, 464},
  {559695600, 10800, 464},
  {575420400, 14400, 464},
  {591145200, 10800, 464},
  {606870000, 14400, 464},
  {622594800, 10800, 464},
  {638319600, 14400, 464},
  {654649200, 10800, 464},
  {670374000, 10800, 464},
  {686102400, 7200, 464},
  {701827200, 10800, 464},
  {717552000, 7200, 464},
  {733276800, 10800, 464},
  {749001600, 7200, 464},
  {764726400, 10800, 464},
  {780451200, 7200, 464},
  {796176000, 10800, 464},
  {811900800, 7200, 464},
  {828230400, 10800, 464},
  {846374400, 7200, 464},
  {859680000, 10800, 464},
  {877824000, 7200, 464},
  {883605600, 7200, 464},
  {891133200, 7200, 464},
  {909277200, 3600, 464},
  {922582800, 7200, 464},
  {941331600, 7200, 464},
  {1041372000, 7200, 464},
  {1048986000, 10800, 464},
  {1067130000, 7200, 464},
  {1080435600, 10800, 464},
  {1099184400, 7200, 464},
  {1111885200, 10800, 464},
  {1130634000, 7200, 464},
  {1143334800, 10800, 464},
  {1162083600, 7200, 464},
  {1174784400, 10800, 464},
  {1193533200, 7200, 464},
  {1206838800, 10800, 464},
  {1224982800, 7200, 464},
  {1238288400, 10800, 464},
  {1256432400, 7200, 464},
  {1269738000, 10800, 464},
  {1288486800, 7200, 464},
  {1301187600, 10800, 464},
  {1319936400, 7200, 464},
  {1332637200, 10800, 464},
  {1351386000, 7200, 464},
  {1364691600, 10800, 464},
  {1382835600, 7200, 464},
  {1396141200, 10800, 464},
  {1414285200, 7200, 464},
  {1427590800, 10800, 464},
  {1445734800, 7200, 464},
  {1459040400, 10800, 464},
  {1477789200, 7200, 464},
  {1490490000, 10800, 464},
  {1509238800, 7200, 464},
  {1521939600, 10800, 464},
  {1540688400, 7200, 464},
  {1553994000, 10800, 464},
  {1572138000, 7200, 464},
  {1585443600, 10800, 464},
  {1603587600, 7200, 464},
  {1616893200, 10800, 464},
  {1635642000, 7200, 464},
  {1648342800, 10800, 464},
  {1667091600, 7200, 464},
  {1679792400, 10800, 464},
  {1698541200, 7200, 464},
  {1711846800, 10800, 464},
  {1729990800, 7200, 464},
  {1743296400, 10800, 464},
  {1761440400, 7200, 464},
  {1774746000, 10800, 464},
  {1792890000, 7200, 464},
  {1806195600, 10800, 464},
  {1824944400, 7200, 464},
  {1837645200, 10800, 464},
  {1856394000, 7200, 464},
  {1869094800, 10800, 464},
  {1887843600, 7200, 464},
  {1901149200, 10800, 464},
  {1919293200, 7200, 464},
  {1932598800, 10800, 464},
  {1950742800, 7200, 464},
  {1964048400, 10800, 464},
  {1982797200, 7200, 464},
  {1995498000, 10800, 464},
  {2014246800, 7200, 464},
  {2026947600, 10800, 464},
  {2045696400, 7200, 464},
  {2058397200, 10800, 464},
  {2077146000, 7200, 464},
  {2090451600, 10800, 464},
  {2108595600, 7200, 464},
  {2121901200, 10800, 464},
  {2140045200, 7200, 464},
  {INT64_MIN, 10660, 465},
  {-1577761060, 10800, 465},
  {-1411873200, 10800, 465},
  {-1247540400, 14400, 465},
  {-256881600, 14400, 465},
  {354916800, 18000, 465},
  {370724400, 14400, 465},
  {386452800, 18000, 465},
  {402260400, 14400, 465},
  {417988800, 18000, 465},
  {433796400, 14400, 465},
  {449611200, 18000, 465},
  {465343200, 14400, 465},
  {481068000, 18000, 465},
  {496792800, 14400, 465},
  {512517600, 18000, 465},
  {528242400, 14400, 465},
  {543967200, 18000, 465},
  {559692000, 14400, 465},
  {575416800, 18000, 465},
  {591141600, 14400, 465},
  {606866400, 14400, 465},
  {622594800, 10800, 465},
  {638319600, 14400, 465},
  {654649200, 10800, 465},
  {670374000, 14400, 465},
  {701820000, 14400, 465},
  {717534000, 10800, 465},
  {733273200, 14400, 465},
  {748998000, 10800, 465},
  {764722800, 14400, 465},
  {780447600, 10800, 465},
  {796172400, 14400, 465},
  {811897200, 10800, 465},
  {828226800, 14400, 465},
  {846370800, 10800, 465},
  {859676400, 14400, 465},
  {877820400, 10800, 465},
  {891126000, 14400, 465},
  {909270000, 10800, 465},
  {922575600, 14400, 465},
  {941324400, 10800, 465},
  {954025200, 14400, 465},
  {972774000, 10800, 465},
  {985474800, 14400, 465},
  {1004223600, 10800, 465},
  {1017529200, 14400, 465},
  {1035673200, 10800, 465},
  {1048978800, 14400, 465},
  {1067122800, 10800, 465},
  {1080428400, 14400, 465},
  {1099177200, 10800, 465},
  {1111878000, 14400, 465},
  {1130626800, 10800, 465},
  {1143327600, 14400, 465},
  {1162076400, 10800, 465},
  {1174777200, 14400, 465},
  {1193526000, 10800, 465},
  {1206831600, 14400, 465},
  {1224975600, 10800, 465},
  {1238281200, 14400, 465},
  {1256425200, 10800, 465},
  {1269730800, 14400, 465},
  {1288479600, 10800, 465},
  {1301180400, 14400, 465},
  {INT64_MIN, 5040, 466},
  {-1717032240, 3600, 466},
  {-1693706400, 7200, 466},
  {-1680483600, 3600, 466},
  {-1663455600, 7200, 466},
  {-1650150000, 3600, 466},
  {-1632006000, 7200, 466},
  {-1618700400, 7200, 466},
  {-1600473600, 10800, 466},
  {-1587168000, 7200, 466},
  {-1501725600, 3600, 466},
  {-931734000, 7200, 466},
  {-857257200, 3600, 466},
  {-844556400, 7200, 466},
  {-828226800, 3600, 466},
  {-812502000, 7200, 466},
  {-796874400, 7200, 466},
  {-796608000, 3600, 466},
  {-778726800, 7200, 466},
  {-762660000, 3600, 466},
  {-748486800, 7200, 466},
  {-733273200, 3600, 466},
  {-715215600, 7200, 466},
  {-701910000, 3600, 466},
  {-684975600, 7200, 466},
  {-670460400, 3600, 466},
  {-654130800, 7200, 466},
  {-639010800, 3600, 466},
  {-397094400, 7200, 466},
  {-386812800, 3600, 466},
  {-371088000, 7200, 466},
  {-355363200, 3600, 466},
  {-334195200, 7200, 466},
  {-323308800, 3600, 466},
  {-307584000, 7200, 466},
  {-291859200, 3600, 466},
  {-271296000, 7200, 466},
  {-260409600, 3600, 466},
  {-239846400, 7200, 466},
  {-228960000, 3600, 466},
  {-208396800, 7200, 466},
  {-197510400, 3600, 466},
  {-176342400, 7200, 466},
  {-166060800, 3600, 466},
  {220921200, 3600, 466},
  {228873600, 7200, 466},
  {243993600, 3600, 466},
  {260323200, 7200, 466},
  {276048000, 3600, 466},
  {291772800, 7200, 466},
  {307497600, 3600, 466},
  {323827200, 7200, 466},
  {338947200, 3600, 466},
  {354672000, 7200, 466},
  {370396800, 3600, 466},
  {386121600, 7200, 466},
  {401846400, 3600, 466},
  {417571200, 7200, 466},
  {433296000, 3600, 466},
  {449020800, 7200, 466},
  {465350400, 3600, 466},
  {481075200, 7200, 466},
  {496800000, 3600, 466},
  {512524800, 7200, 466},
  {528249600, 3600, 466},
  {543974400, 7200, 466},
  {559699200, 3600, 466},
  {567990000, 3600, 466},
  {575427600, 7200, 466},
  {591152400, 3600, 466},
  {606877200, 7200, 466},
  {622602000, 3600, 466},
  {638326800, 7200, 466},
  {654656400, 3600, 466},
  {670381200, 7200, 466},
  {686106000, 3600, 466},
  {701830800, 7200, 466},
  {717555600, 3600, 466},
  {733280400, 7200, 466},
  {749005200, 3600, 466},
  {764730000, 7200, 466},
  {780454800, 3600, 466},
  {796179600, 7200, 466},
  {811904400, 3600, 466},
  {828234000, 7200, 466},
  {846378000, 3600, 466},
  {859683600, 7200, 466},
  {877827600, 3600, 466},
  {891133200, 7200, 466},
  {909277200, 3600, 466},
  {922582800, 7200, 466},
  {941331600, 3600, 466},
  {954032400, 7200, 466},
  {972781200, 3600, 466},
  {985482000, 7200, 466},
  {1004230800, 3600, 466},
  {1017536400, 7200, 466},
  {1035680400, 3600, 466},
  {1048986000, 7200, 466},
  {1067130000, 3600, 466},
  {1080435600, 7200, 466},
  {1099184400, 3600, 466},
  {1111885200, 7200, 466},
  {1130634000, 3600, 466},
  {1143334800, 7200, 466},
  {1162083600, 3600, 466},
  {1174784400, 7200, 466},
  {1193533200, 3600, 466},
  {1206838800, 7200, 466},
  {1224982800, 3600, 466},
  {1238288400, 7200, 466},
  {1256432400, 3600, 466},
  {1269738000, 7200, 466},
  {1288486800, 3600, 466},
  {1301187600, 7200, 466},
  {1319936400, 3600, 466},
  {1332637200, 7200, 466},
  {1351386000, 3600, 466},
  {1364691600, 7200, 466},
  {1382835600, 3600, 466},
  {1396141200, 7200, 466},
  {1414285200, 3600, 466},
  {1427590800, 7200, 466},
  {1445734800, 3600, 466},
  {1459040400, 7200, 466},
  {1477789200, 3600, 466},
  {1490490000, 7200, 466},
  {1509238800, 3600, 466},
  {1521939600, 7200, 466},
  {1540688400, 3600, 466},
  {1553994000, 7200, 466},
  {1572138000, 3600, 466},
  {1585443600, 7200, 466},
  {1603587600, 3600, 466},
  {1616893200, 7200, 466},
  {1635642000, 3600, 466},
  {1648342800, 7200, 466},
  {1667091600, 3600, 466},
  {1679792400, 7200, 466},
  {1698541200, 3600, 466},
  {1711846800, 7200, 466},
  {1729990800, 3600, 466},
  {1743296400, 7200, 466},
  {1761440400, 3600, 466},
  {1774746000, 7200, 466},
  {1792890000, 3600, 466},
  {1806195600, 7200, 466},
  {1824944400, 3600, 466},
  {1837645200, 7200, 466},
  {1856394000, 3600, 466},
  {1869094800, 7200, 466},
  {1887843600, 3600, 466},
  {1901149200, 7200, 466},
  {1919293200, 3600, 466},
  {1932598800, 7200, 466},
  {1950742800, 3600, 466},
  {1964048400, 7200, 466},
  {1982797200, 3600, 466},
  {1995498000, 7200, 466},
  {2014246800, 3600, 466},
  {2026947600, 7200, 466},
  {2045696400, 3600, 466},
  {2058397200, 7200, 466},
  {2077146000, 3600, 466},
  {2090451600, 7200, 466},
  {2108595600, 3600, 466},
  {2121901200, 7200, 466},
  {2140045200, 3600, 466},
  {-905824800, 7200, 467},
  {-857257200, 3600, 467},
  {-844556400, 7200, 467},
  {-828226800, 3600, 467},
  {-812502000, 7200, 467},
  {-796777200, 3600, 467},
  {-788922000, 3600, 467},
  {-777942000, 7200, 467},
  {-766623600, 3600, 467},
  {407199600, 3600, 467},
  {417574800, 7200, 467},
  {433299600, 3600, 467},
  {449024400, 7200, 467},
  {465354000, 3600, 467},
  {481078800, 7200, 467},
  {496803600, 3600, 467},
  {512528400, 7200, 467},
  {528253200, 3600, 467},
  {543978000, 7200, 467},
  {559702800, 3600, 467},
  {575427600, 7200, 467},
  {591152400, 3600, 467},
  {606877200, 7200, 467},
  {622602000, 3600, 467},
  {638326800, 7200, 467},
  {654656400, 3600, 467},
  {670381200, 7200, 467},
  {686106000, 3600, 467},
  {701830800, 7200, 467},
  {717555600, 3600, 467},
  {733280400, 7200, 467},
  {749005200, 3600, 467},
  {764730000, 7200, 467},
  {780454800, 3600, 467},
  {796179600, 7200, 467},
  {811904400, 3600, 467},
  {828234000, 7200, 467},
  {846378000, 3600, 467},
  {859683600, 7200, 467},
  {877827600, 3600, 467},
  {891133200, 7200, 467},
  {909277200, 3600, 467},
  {922582800, 7200, 467},
  {941331600, 3600, 467},
  {954032400, 7200, 467},
  {972781200, 3600, 467},
  {985482000, 7200, 467},
  {1004230800, 3600, 467},
  {1017536400, 7200, 467},
  {1035680400, 3600, 467},
  {1048986000, 7200, 467},
  {1067130000, 3600, 467},
  {1080435600, 7200, 467},
  {1099184400, 3600, 467},
  {1111885200, 7200, 467},
  {1130634000, 3600, 467},
  {1143334800, 7200, 467},
  {1162083600, 3600, 467},
  {1174784400, 7200, 467},
  {1193533200, 3600, 467},
  {1206838800, 7200, 467},
  {1224982800, 3600, 467},
  {1238288400, 7200, 467},
  {1256432400, 3600, 467},
  {1269738000, 7200, 467},
  {1288486800, 3600, 467},
  {1301187600, 7200, 467},
  {1319936400, 3600, 467},
  {1332637200, 7200, 467},
  {1351386000, 3600, 467},
  {1364691600, 7200, 467},
  {1382835600, 3600, 467},
  {1396141200, 7200, 467},
  {1414285200, 3600, 467},
  {1427590800, 7200, 467},
  {1445734800, 3600, 467},
  {1459040400, 7200, 467},
  {1477789200, 3600, 467},
  {1490490000, 7200, 467},
  {1509238800, 3600, 467},
  {1521939600, 7200, 467},
  {1540688400, 3600, 467},
  {1553994000, 7200, 467},
  {1572138000, 3600, 467},
  {1585443600, 7200, 467},
  {1603587600, 3600, 467},
  {1616893200, 7200, 467},
  {1635642000, 3600, 467},
  {1648342800, 7200, 467},
  {1667091600, 3600, 467},
  {1679792400, 7200, 467},
  {1698541200, 3600, 467},
  {1711846800, 7200, 467},
  {1729990800, 3600, 467},
  {1743296400, 7200, 467},
  {1761440400, 3600, 467},
  {1774746000, 7200, 467},
  {1792890000, 3600, 467},
  {1806195600, 7200, 467},
  {1824944400, 3600, 467},
  {1837645200, 7200, 467},
  {1856394000, 3600, 467},
  {1869094800, 7200, 467},
  {1887843600, 3600, 467},
  {1901149200, 7200, 467},
  {1919293200, 3600, 467},
  {1932598800, 7200, 467},
  {1950742800, 3600, 467},
  {1964048400, 7200, 467},
  {1982797200, 3600, 467},
  {1995498000, 7200, 467},
  {2014246800, 3600, 467},
  {2026947600, 7200, 467},
  {2045696400, 3600, 467},
  {2058397200, 7200, 467},
  {2077146000, 3600, 467},
  {2090451600, 7200, 467},
  {2108595600, 3600, 467},
  {2121901200, 7200, 467},
  {2140045200, 3600, 467},
  {INT64_MIN, 8400, 468},
  {-1441160400, 7200, 468},
  {-1247536800, 10800, 468},
  {-894769200, 7200, 468},
  {-857257200, 3600, 468},
  {-844556400, 7200, 468},
  {-828226800, 3600, 468},
  {-826419600, 10800, 468},
  {354920400, 14400, 468},
  {370728000, 10800, 468},
  {386456400, 14400, 468},
  {402264000, 10800, 468},
  {417992400, 14400, 468},
  {433800000, 10800, 468},
  {449614800, 14400, 468},
  {465346800, 10800, 468},
  {481071600, 14400, 468},
  {496796400, 10800, 468},
  {512521200, 14400, 468},
  {528246000, 10800, 468},
  {543970800, 14400, 468},
  {559695600, 10800, 468},
  {575420400, 14400, 468},
  {591145200, 10800, 468},
  {606870000, 14400, 468},
  {622594800, 10800, 468},
  {638319600, 14400, 468},
  {654649200, 10800, 468},
  {670374000, 10800, 468},
  {686091600, 7200, 468},
  {701820000, 10800, 468},
  {717541200, 7200, 468},
  {733269600, 10800, 468},
  {748990800, 7200, 468},
  {764719200, 10800, 468},
  {780440400, 7200, 468},
  {796179600, 10800, 468},
  {811904400, 7200, 468},
  {828234000, 10800, 468},
  {846378000, 7200, 468},
  {859683600, 10800, 468},
  {877827600, 7200, 468},
  {891133200, 10800, 468},
  {909277200, 7200, 468},
  {922582800, 10800, 468},
  {941331600, 7200, 468},
  {954032400, 10800, 468},
  {972781200, 7200, 468},
  {985482000, 10800, 468},
  {1004230800, 7200, 468},
  {1017536400, 10800, 468},
  {1035680400, 7200, 468},
  {1048986000, 10800, 468},
  {1067130000, 7200, 468},
  {1080435600, 10800, 468},
  {1099184400, 7200, 468},
  {1111885200, 10800, 468},
  {1130634000, 7200, 468},
  {1143334800, 10800, 468},
  {1162083600, 7200, 468},
  {1174784400, 10800, 468},
  {1193533200, 7200, 468},
  {1206838800, 10800, 468},
  {1224982800, 7200, 468},
  {1238288400, 10800, 468},
  {1256432400, 7200, 468},
  {1269738000, 10800, 468},
  {1288486800, 7200, 468},
  {1301187600, 10800, 468},
  {1319936400, 7200, 468},
  {1332637200, 10800, 468},
  {1351386000, 7200, 468},
  {1364691600, 10800, 468},
  {1382835600, 7200, 468},
  {1396141200, 10800, 468},
  {1414285200, 7200, 468},
  {1427590800, 10800, 468},
  {1445734800, 7200, 468},
  {1459040400, 10800, 468},
  {1477789200, 7200, 468},
  {1490490000, 10800, 468},
  {1509238800, 7200, 468},
  {1521939600, 10800, 468},
  {1540688400, 7200, 468},
  {1553994000, 10800, 468},
  {1572138000, 7200, 468},
  {1585443600, 10800, 468},
  {1603587600, 7200, 468},
  {1616893200, 10800, 468},
  {1635642000, 7200, 468},
  {1648342800, 10800, 468},
  {1667091600, 7200, 468},
  {1679792400, 10800, 468},
  {1698541200, 7200, 468},
  {1711846800, 10800, 468},
  {1729990800, 7200, 468},
  {1743296400, 10800, 468},
  {1761440400, 7200, 468},
  {1774746000, 10800, 468},
  {1792890000, 7200, 468},
  {1806195600, 10800, 468},
  {1824944400, 7200, 468},
  {1837645200, 10800, 468},
  {1856394000, 7200, 468},
  {1869094800, 10800, 468},
  {1887843600, 7200, 468},
  {1901149200, 10800, 468},
  {1919293200, 7200, 468},
  {1932598800, 10800, 468},
  {1950742800, 7200, 468},
  {1964048400, 10800, 468},
  {1982797200, 7200, 468},
  {1995498000, 10800, 468},
  {2014246800, 7200, 468},
  {2026947600, 10800, 468},
  {2045696400, 7200, 468},
  {2058397200, 10800, 468},
  {2077146000, 7200, 468},
  {2090451600, 10800, 468},
  {2108595600, 7200, 468},
  {2121901200, 10800, 468},
  {2140045200, 7200, 468},
  {-904435200, 7200, 469},
  {-891129600, 3600, 469},
  {-872985600, 7200, 469},
  {-859680000, 3600, 469},
  {354675600, 7200, 469},
  {370400400, 3600, 469},
  {386125200, 7200, 469},
  {401850000, 3600, 469},
  {417574800, 7200, 469},
  {433299600, 3600, 469},
  {449024400, 7200, 469},
  {465354000, 3600, 469},
  {481078800, 7200, 469},
  {496803600, 3600, 469},
  {512528400, 7200, 469},
  {528253200, 3600, 469},
  {543978000, 7200, 469},
  {559702800, 3600, 469},
  {575427600, 7200, 469},
  {591152400, 3600, 469},
  {606877200, 7200, 469},
  {622602000, 3600, 469},
  {638326800, 7200, 469},
  {654656400, 3600, 469},
  {670381200, 7200, 469},
  {686106000, 3600, 469},
  {701830800, 7200, 469},
  {717555600, 3600, 469},
  {733280400, 7200, 469},
  {749005200, 3600, 469},
  {764730000, 7200, 469},
  {780454800, 3600, 469},
  {796179600, 7200, 469},
  {811904400, 3600, 469},
  {828234000, 7200, 469},
  {846378000, 3600, 469},
  {859683600, 7200, 469},
  {877827600, 3600, 469},
  {891133200, 7200, 469},
  {909277200, 3600, 469},
  {922582800, 7200, 469},
  {941331600, 3600, 469},
  {954032400, 7200, 469},
  {972781200, 3600, 469},
  {985482000, 7200, 469},
  {1004230800, 3600, 469},
  {1017536400, 7200, 469},
  {1035680400, 3600, 469},
  {1048986000, 7200, 469},
  {1067130000, 3600, 469},
  {1080435600, 7200, 469},
  {1099184400, 3600, 469},
  {1111885200, 7200, 469},
  {1130634000, 3600, 469},
  {1143334800, 7200, 469},
  {1162083600, 3600, 469},
  {1174784400, 7200, 469},
  {1193533200, 3600, 469},
  {1206838800, 7200, 469},
  {1224982800, 3600, 469},
  {1238288400, 7200, 469},
  {1256432400, 3600, 469},
  {1269738000, 7200, 469},
  {1288486800, 3600, 469},
  {1301187600, 7200, 469},
  {1319936400, 3600, 469},
  {1332637200, 7200, 469},
  {1351386000, 3600, 469},
  {1364691600, 7200, 469},
  {1382835600, 3600, 469},
  {1396141200, 7200, 469},
  {1414285200, 3600, 469},
  {1427590800, 7200, 469},
  {1445734800, 3600, 469},
  {1459040400, 7200, 469},
  {1477789200, 3600, 469},
  {1490490000, 7200, 469},
  {1509238800, 3600, 469},
  {1521939600, 7200, 469},
  {1540688400, 3600, 469},
  {1553994000, 7200, 469},
  {1572138000, 3600, 469},
  {1585443600, 7200, 469},
  {1603587600, 3600, 469},
  {1616893200, 7200, 469},
  {1635642000, 3600, 469},
  {1648342800, 7200, 469},
  {1667091600, 3600, 469},
  {1679792400, 7200, 469},
  {1698541200, 3600, 469},
  {1711846800, 7200, 469},
  {1729990800, 3600, 469},
  {1743296400, 7200, 469},
  {1761440400, 3600, 469},
  {1774746000, 7200, 469},
  {1792890000, 3600, 469},
  {1806195600, 7200, 469},
  {1824944400, 3600, 469},
  {1837645200, 7200, 469},
  {1856394000, 3600, 469},
  {1869094800, 7200, 469},
  {1887843600, 3600, 469},
  {1901149200, 7200, 469},
  {1919293200, 3600, 469},
  {1932598800, 7200, 469},
  {1950742800, 3600, 469},
  {1964048400, 7200, 469},
  {1982797200, 3600, 469},
  {1995498000, 7200, 469},
  {2014246800, 3600, 469},
  {2026947600, 7200, 469},
  {2045696400, 3600, 469},
  {2058397200, 7200, 469},
  {2077146000, 3600, 469},
  {2090451600, 7200, 469},
  {2108595600, 3600, 469},
  {2121901200, 7200, 469},
  {2140045200, 3600, 469},
  {-1691964000, 3600, 470},
  {-1680472800, 0, 470},
  {-1664143200, 3600, 470},
  {-1650146400, 0, 470},
  {-1633903200, 3600, 470},
  {-1617487200, 0, 470},
  {-1601848800, 3600, 470},
  {-1586037600, 0, 470},
  {-1570399200, 3600, 470},
  {-1552168800, 0, 470},
  {-1538344800, 3600, 470},
  {-1522533600, 0, 470},
  {-1507500000, 3600, 470},
  {-1490565600, 0, 470},
  {-1473631200, 3600, 470},
  {-1460930400, 0, 470},
  {-1442786400, 3600, 470},
  {-1428876000, 0, 470},
  {-1410732000, 3600, 470},
  {-1396216800, 0, 470},
  {-1379282400, 3600, 470},
  {-1364767200, 0, 470},
  {-1348437600, 3600, 470},
  {-1333317600, 0, 470},
  {-1315778400, 3600, 470},
  {-1301263200, 0, 470},
  {-1284328800, 3600, 470},
  {-1269813600, 0, 470},
  {-1253484000, 3600, 470},
  {-1238364000, 0, 470},
  {-1221429600, 3600, 470},
  {-1206914400, 0, 470},
  {-1189980000, 3600, 470},
  {-1175464800, 0, 470},
  {-1159135200, 3600, 470},
  {-1143410400, 0, 470},
  {-1126476000, 3600, 470},
  {-1111960800, 0, 470},
  {-1095631200, 3600, 470},
  {-1080511200, 0, 470},
  {-1063576800, 3600, 470},
  {-1049061600, 0, 470},
  {-1032127200, 3600, 470},
  {-1017612000, 0, 470},
  {-1001282400, 3600, 470},
  {-986162400, 0, 470},
  {-969228000, 3600, 470},
  {-950479200, 0, 470},
  {-942012000, 3600, 470},
  {-904518000, 7200, 470},
  {-896050800, 3600, 470},
  {-875487600, 7200, 470},
  {-864601200, 3600, 470},
  {-844038000, 7200, 470},
  {-832546800, 3600, 470},
  {-812588400, 7200, 470},
  {-798073200, 3600, 470},
  {-781052400, 7200, 470},
  {-772066800, 3600, 470},
  {-764805600, 0, 470},
  {-748476000, 3600, 470},
  {-733356000, 0, 470},
  {-719445600, 3600, 470},
  {-717030000, 7200, 470},
  {-706748400, 3600, 470},
  {-699487200, 0, 470},
  {-687996000, 3600, 470},
  {-668037600, 0, 470},
  {-654732000, 3600, 470},
  {-636588000, 0, 470},
  {-622072800, 3600, 470},
  {-605743200, 0, 470},
  {-590623200, 3600, 470},
  {-574293600, 0, 470},
  {-558568800, 3600, 470},
  {-542239200, 0, 470},
  {-527119200, 3600, 470},
  {-512604000, 0, 470},
  {-496274400, 3600, 470},
  {-481154400, 0, 470},
  {-464220000, 3600, 470},
  {-449704800, 0, 470},
  {-432165600, 3600, 470},
  {-417650400, 0, 470},
  {-401320800, 3600, 470},
  {-386200800, 0, 470},
  {-369266400, 3600, 470},
  {-354751200, 0, 470},
  {-337816800, 3600, 470},
  {-323301600, 0, 470},
  {-306972000, 3600, 470},
  {-291852000, 0, 470},
  {-276732000, 3600, 470},
  {-257983200, 0, 470},
  {-245282400, 3600, 470},
  {-226533600, 0, 470},
  {-213228000, 3600, 470},
  {-195084000, 0, 470},
  {-182383200, 3600, 470},
  {-163634400, 0, 470},
  {-150933600, 3600, 470},
  {-132184800, 0, 470},
  {-119484000, 3600, 470},
  {-100735200, 0, 470},
  {-88034400, 3600, 470},
  {-68680800, 0, 470},
  {-59004000, 3600, 470},
  {-37242000, 3600, 470},
  {57722400, 0, 470},
  {69818400, 3600, 470},
  {89172000, 0, 470},
  {101268000, 3600, 470},
  {120621600, 0, 470},
  {132717600, 3600, 470},
  {152071200, 0, 470},
  {164167200, 3600, 470},
  {183520800, 0, 470},
  {196221600, 3600, 470},
  {214970400, 0, 470},
  {227671200, 3600, 470},
  {246420000, 0, 470},
  {259120800, 3600, 470},
  {278474400, 0, 470},
  {290570400, 3600, 470},
  {309924000, 0, 470},
  {322020000, 3600, 470},
  {341373600, 0, 470},
  {354675600, 3600, 470},
  {372819600, 0, 470},
  {386125200, 3600, 470},
  {404269200, 0, 470},
  {417574800, 3600, 470},
  {435718800, 0, 470},
  {449024400, 3600, 470},
  {467773200, 0, 470},
  {481078800, 3600, 470},
  {499222800, 0, 470},
  {512528400, 3600, 470},
  {530672400, 0, 470},
  {543978000, 3600, 470},
  {562122000, 0, 470},
  {575427600, 3600, 470},
  {593571600, 0, 470},
  {606877200, 3600, 470},
  {625626000, 0, 470},
  {638326800, 3600, 470},
  {657075600, 0, 470},
  {670381200, 3600, 470},
  {688525200, 0, 470},
  {701830800, 3600, 470},
  {719974800, 0, 470},
  {733280400, 3600, 470},
  {751424400, 0, 470},
  {764730000, 3600, 470},
  {782874000, 0, 470},
  {796179600, 3600, 470},
  {814323600, 0, 470},
  {820454400, 0, 470},
  {828234000, 3600, 470},
  {846378000, 0, 470},
  {859683600, 3600, 470},
  {877827600, 0, 470},
  {891133200, 3600, 470},
  {909277200, 0, 470},
  {922582800, 3600, 470},
  {941331600, 0, 470},
  {954032400, 3600, 470},
  {972781200, 0, 470},
  {985482000, 3600, 470},
  {1004230800, 0, 470},
  {1017536400, 3600, 470},
  {1035680400, 0, 470},
  {1048986000, 3600, 470},
  {1067130000, 0, 470},
  {1080435600, 3600, 470},
  {1099184400, 0, 470},
  {1111885200, 3600, 470},
  {1130634000, 0, 470},
  {1143334800, 3600, 470},
  {1162083600, 0, 470},
  {1174784400, 3600, 470},
  {1193533200, 0, 470},
  {1206838800, 3600, 470},
  {1224982800, 0, 470},
  {1238288400, 3600, 470},
  {1256432400, 0, 470},
  {1269738000, 3600, 470},
  {1288486800, 0, 470},
  {1301187600, 3600, 470},
  {1319936400, 0, 470},
  {1332637200, 3600, 470},
  {1351386000, 0, 470},
  {1364691600, 3600, 470},
  {1382835600, 0, 470},
  {1396141200, 3600, 470},
  {1414285200, 0, 470},
  {1427590800, 3600, 470},
  {1445734800, 0, 470},
  {1459040400, 3600, 470},
  {1477789200, 0, 470},
  {1490490000, 3600, 470},
  {1509238800, 0, 470},
  {1521939600, 3600, 470},
  {1540688400, 0, 470},
  {1553994000, 3600, 470},
  {1572138000, 0, 470},
  {1585443600, 3600, 470},
  {1603587600, 0, 470},
  {1616893200, 3600, 470},
  {1635642000, 0, 470},
  {1648342800, 3600, 470},
  {1667091600, 0, 470},
  {1679792400, 3600, 470},
  {1698541200, 0, 470},
  {1711846800, 3600, 470},
  {1729990800, 0, 470},
  {1743296400, 3600, 470},
  {1761440400, 0, 470},
  {1774746000, 3600, 470},
  {1792890000, 0, 470},
  {1806195600, 3600, 470},
  {1824944400, 0, 470},
  {1837645200, 3600, 470},
  {1856394000, 0, 470},
  {1869094800, 3600, 470},
  {1887843600, 0, 470},
  {1901149200, 3600, 470},
  {1919293200, 0, 470},
  {1932598800, 3600, 470},
  {1950742800, 0, 470},
  {1964048400, 3600, 470},
  {1982797200, 0, 470},
  {1995498000, 3600, 470},
  {2014246800, 0, 470},
  {2026947600, 3600, 470},
  {2045696400, 0, 470},
  {2058397200, 3600, 470},
  {2077146000, 0, 470},
  {2090451600, 3600, 470},
  {2108595600, 0, 470},
  {2121901200, 3600, 470},
  {2140045200, 0, 470},
  {-1691964000, 3600, 471},
  {-1680472800, 0, 471},
  {-1664143200, 3600, 471},
  {-1650146400, 0, 471},
  {-1633903200, 3600, 471},
  {-1617487200, 0, 471},
  {-1601848800, 3600, 471},
  {-1586037600, 0, 471},
  {-1570399200, 3600, 471},
  {-1552168800, 0, 471},
  {-1538344800, 3600, 471},
  {-1522533600, 0, 471},
  {-1507500000, 3600, 471},
  {-1490565600, 0, 471},
  {-1473631200, 3600, 471},
  {-1460930400, 0, 471},
  {-1442786400, 3600, 471},
  {-1428876000, 0, 471},
  {-1410732000, 3600, 471},
  {-1396216800, 0, 471},
  {-1379282400, 3600, 471},
  {-1364767200, 0, 471},
  {-1348437600, 3600, 471},
  {-1333317600, 0, 471},
  {-1315778400, 3600, 471},
  {-1301263200, 0, 471},
  {-1284328800, 3600, 471},
  {-1269813600, 0, 471},
  {-1253484000, 3600, 471},
  {-1238364000, 0, 471},
  {-1221429600, 3600, 471},
  {-1206914400, 0, 471},
  {-1189980000, 3600, 471},
  {-1175464800, 0, 471},
  {-1159135200, 3600, 471},
  {-1143410400, 0, 471},
  {-1126476000, 3600, 471},
  {-1111960800, 0, 471},
  {-1095631200, 3600, 471},
  {-1080511200, 0, 471},
  {-1063576800, 3600, 471},
  {-1049061600, 0, 471},
  {-1032127200, 3600, 471},
  {-1017612000, 0, 471},
  {-1001282400, 3600, 471},
  {-986162400, 0, 471},
  {-969228000, 3600, 471},
  {-950479200, 0, 471},
  {-942012000, 3600, 471},
  {-904518000, 7200, 471},
  {-896050800, 3600, 471},
  {-875487600, 7200, 471},
  {-864601200, 3600, 471},
  {-844038000, 7200, 471},
  {-832546800, 3600, 471},
  {-812588400, 7200, 471},
  {-798073200, 3600, 471},
  {-781052400, 7200, 471},
  {-772066800, 3600, 471},
  {-764805600, 0, 471},
  {-748476000, 3600, 471},
  {-733356000, 0, 471},
  {-719445600, 3600, 471},
  {-717030000, 7200, 471},
  {-706748400, 3600, 471},
  {-699487200, 0, 471},
  {-687996000, 3600, 471},
  {-668037600, 0, 471},
  {-654732000, 3600, 471},
  {-636588000, 0, 471},
  {-622072800, 3600, 471},
  {-605743200, 0, 471},
  {-590623200, 3600, 471},
  {-574293600, 0, 471},
  {-558568800, 3600, 471},
  {-542239200, 0, 471},
  {-527119200, 3600, 471},
  {-512604000, 0, 471},
  {-496274400, 3600, 471},
  {-481154400, 0, 471},
  {-464220000, 3600, 471},
  {-449704800, 0, 471},
  {-432165600, 3600, 471},
  {-417650400, 0, 471},
  {-401320800, 3600, 471},
  {-386200800, 0, 471},
  {-369266400, 3600, 471},
  {-354751200, 0, 471},
  {-337816800, 3600, 471},
  {-323301600, 0, 471},
  {-306972000, 3600, 471},
  {-291852000, 0, 471},
  {-276732000, 3600, 471},
  {-257983200, 0, 471},
  {-245282400, 3600, 471},
  {-226533600, 0, 471},
  {-213228000, 3600, 471},
  {-195084000, 0, 471},
  {-182383200, 3600, 471},
  {-163634400, 0, 471},
  {-150933600, 3600, 471},
  {-132184800, 0, 471},
  {-119484000, 3600, 471},
  {-100735200, 0, 471},
  {-88034400, 3600, 471},
  {-68680800, 0, 471},
  {-59004000, 3600, 471},
  {-37242000, 3600, 471},
  {57722400, 0, 471},
  {69818400, 3600, 471},
  {89172000, 0, 471},
  {101268000, 3600, 471},
  {120621600, 0, 471},
  {132717600, 3600, 471},
  {152071200, 0, 471},
  {164167200, 3600, 471},
  {183520800, 0, 471},
  {196221600, 3600, 471},
  {214970400, 0, 471},
  {227671200, 3600, 471},
  {246420000, 0, 471},
  {259120800, 3600, 471},
  {278474400, 0, 471},
  {290570400, 3600, 471},
  {309924000, 0, 471},
  {322020000, 3600, 471},
  {341373600, 0, 471},
  {354675600, 3600, 471},
  {372819600, 0, 471},
  {386125200, 3600, 471},
  {404269200, 0, 471},
  {417574800, 3600, 471},
  {435718800, 0, 471},
  {449024400, 3600, 471},
  {467773200, 0, 471},
  {481078800, 3600, 471},
  {499222800, 0, 471},
  {512528400, 3600, 471},
  {530672400, 0, 471},
  {543978000, 3600, 471},
  {562122000, 0, 471},
  {575427600, 3600, 471},
  {593571600, 0, 471},
  {606877200, 3600, 471},
  {625626000, 0, 471},
  {638326800, 3600, 471},
  {657075600, 0, 471},
  {670381200, 3600, 471},
  {688525200, 0, 471},
  {701830800, 3600, 471},
  {719974800, 0, 471},
  {733280400, 3600, 471},
  {751424400, 0, 471},
  {764730000, 3600, 471},
  {782874000, 0, 471},
  {796179600, 3600, 471},
  {814323600, 0, 471},
  {820454400, 0, 471},
  {828234000, 3600, 471},
  {846378000, 0, 471},
  {859683600, 3600, 471},
  {877827600, 0, 471},
  {891133200, 3600, 471},
  {909277200, 0, 471},
  {922582800, 3600, 471},
  {941331600, 0, 471},
  {954032400, 3600, 471},
  {972781200, 0, 471},
  {985482000, 3600, 471},
  {1004230800, 0, 471},
  {1017536400, 3600, 471},
  {1035680400, 0, 471},
  {1048986000, 3600, 471},
  {1067130000, 0, 471},
  {1080435600, 3600, 471},
  {1099184400, 0, 471},
  {1111885200, 3600, 471},
  {1130634000, 0, 471},
  {1143334800, 3600, 471},
  {1162083600, 0, 471},
  {1174784400, 3600, 471},
  {1193533200, 0, 471},
  {1206838800, 3600, 471},
  {1224982800, 0, 471},
  {1238288400, 3600, 471},
  {1256432400, 0, 471},
  {1269738000, 3600, 471},
  {1288486800, 0, 471},
  {1301187600, 3600, 471},
  {1319936400, 0, 471},
  {1332637200, 3600, 471},
  {1351386000, 0, 471},
  {1364691600, 3600, 471},
  {1382835600, 0, 471},
  {1396141200, 3600, 471},
  {1414285200, 0, 471},
  {1427590800, 3600, 471},
  {1445734800, 0, 471},
  {1459040400, 3600, 471},
  {1477789200, 0, 471},
  {1490490000, 3600, 471},
  {1509238800, 0, 471},
  {1521939600, 3600, 471},
  {1540688400, 0, 471},
  {1553994000, 3600, 471},
  {1572138000, 0, 471},
  {1585443600, 3600, 471},
  {1603587600, 0, 471},
  {1616893200, 3600, 471},
  {1635642000, 0, 471},
  {1648342800, 3600, 471},
  {1667091600, 0, 471},
  {1679792400, 3600, 471},
  {1698541200, 0, 471},
  {1711846800, 3600, 471},
  {1729990800, 0, 471},
  {1743296400, 3600, 471},
  {1761440400, 0, 471},
  {1774746000, 3600, 471},
  {1792890000, 0, 471},
  {1806195600, 3600, 471},
  {1824944400, 0, 471},
  {1837645200, 3600, 471},
  {1856394000, 0, 471},
  {1869094800, 3600, 471},
  {1887843600, 0, 471},
  {1901149200, 3600, 471},
  {1919293200, 0, 471},
  {1932598800, 3600, 471},
  {1950742800, 0, 471},
  {1964048400, 3600, 471},
  {1982797200, 0, 471},
  {1995498000, 3600, 471},
  {2014246800, 0, 471},
  {2026947600, 3600, 471},
  {2045696400, 0, 471},
  {2058397200, 3600, 471},
  {2077146000, 0, 471},
  {2090451600, 3600, 471},
  {2108595600, 0, 471},
  {2121901200, 3600, 471},
  {2140045200, 0, 471},
  {INT64_MIN, 0, 472},
  {INT64_MIN, 0, 473},
  {INT64_MIN, 0, 474},
  {INT64_MIN, 0, 475},
  {INT64_MIN, 0, 476},
  {INT64_MIN, -36000, 477},
  {INT64_MIN, 27396, 478},
  {-2056692996, 28800, 478},
  {-907389000, 32400, 478},
  {-891667800, 28800, 478},
  {-884246400, 32400, 478},
  {-766746000, 28800, 478},
  {-747981000, 32400, 478},
  {-728544600, 28800, 478},
  {-717049800, 32400, 478},
  {-694503000, 28800, 478},
  {-683785800, 32400, 478},
  {-668064600, 28800, 478},
  {-654755400, 32400, 478},
  {-636615000, 28800, 478},
  {-623305800, 32400, 478},
  {-605165400, 28800, 478},
  {-591856200, 32400, 478},
  {-573715800, 28800, 478},
  {-559801800, 32400, 478},
  {-542352600, 28800, 478},
  {-528352200, 32400, 478},
  {-510211800, 28800, 478},
  {-498112200, 32400, 478},
  {-478762200, 28800, 478},
  {-466662600, 32400, 478},
  {-446707800, 28800, 478},
  {-435213000, 32400, 478},
  {-415258200, 28800, 478},
  {-403158600, 32400, 478},
  {-383808600, 28800, 478},
  {-371709000, 32400, 478},
  {-352359000, 28800, 478},
  {-340259400, 32400, 478},
  {-320909400, 28800, 478},
  {-308809800, 32400, 478},
  {-288855000, 28800, 478},
  {-277360200, 32400, 478},
  {-257405400, 28800, 478},
  {-245910600, 32400, 478},
  {-225955800, 28800, 478},
  {-213856200, 32400, 478},
  {-194506200, 28800, 478},
  {-182406600, 32400, 478},
  {-163056600, 28800, 478},
  {-148537800, 32400, 478},
  {-132816600, 28800, 478},
  {-117088200, 32400, 478},
  {-101367000, 28800, 478},
  {-85638600, 32400, 478},
  {-69312600, 28800, 478},
  {-53584200, 32400, 478},
  {-37863000, 28800, 478},
  {-22134600, 32400, 478},
  {-6413400, 28800, 478},
  {9315000, 32400, 478},
  {25036200, 28800, 478},
  {40764600, 32400, 478},
  {56485800, 28800, 478},
  {72214200, 32400, 478},
  {88540200, 28800, 478},
  {104268600, 32400, 478},
  {119989800, 28800, 478},
  {126041400, 32400, 478},
  {151439400, 28800, 478},
  {167167800, 32400, 478},
  {182889000, 28800, 478},
  {198617400, 32400, 478},
  {214338600, 28800, 478},
  {295385400, 32400, 478},
  {309292200, 28800, 478},
  {INT64_MIN, -5268, 479},
  {-1956609132, -3600, 479},
  {-1668211200, 0, 479},
  {-1647212400, -3600, 479},
  {-1636675200, 0, 479},
  {-1613430000, -3600, 479},
  {-968025600, 0, 479},
  {-949615200, -3600, 479},
  {-942008400, 0, 479},
  {-920239200, -3600, 479},
  {-909957600, 0, 479},
  {-888789600, -3600, 479},
  {-877903200, 0, 479},
  {-857944800, -3600, 479},
  {-846453600, 0, 479},
  {-826495200, -3600, 479},
  {-815004000, 0, 479},
  {-795045600, -3600, 479},
  {-783554400, 0, 479},
  {-762991200, -3600, 479},
  {-752104800, 0, 479},
  {-731541600, -3600, 479},
  {-717631200, 0, 479},
  {-700092000, -3600, 479},
  {-686181600, 0, 479},
  {-668642400, -3600, 479},
  {-654732000, 0, 479},
  {-636588000, -3600, 479},
  {-623282400, 0, 479},
  {-605743200, -3600, 479},
  {-591832800, 0, 479},
  {-573688800, -3600, 479},
  {-559778400, 0, 479},
  {-542239200, -3600, 479},
  {-528328800, 0, 479},
  {-510789600, -3600, 479},
  {-496879200, 0, 479},
  {-479340000, -3600, 479},
  {-465429600, 0, 479},
  {-447890400, -3600, 479},
  {-433980000, 0, 479},
  {-415836000, -3600, 479},
  {-401925600, 0, 479},
  {-384386400, -3600, 479},
  {-370476000, 0, 479},
  {-352936800, -3600, 479},
  {-339026400, 0, 479},
  {-321487200, -3600, 479},
  {-307576800, 0, 479},
  {-290037600, -3600, 479},
  {-276127200, 0, 479},
  {-258588000, -3600, 479},
  {-244677600, 0, 479},
  {-226533600, -3600, 479},
  {-212623200, 0, 479},
  {-195084000, -3600, 479},
  {-181173600, 0, 479},
  {-163634400, -3600, 479},
  {-149724000, 0, 479},
  {-132184800, -3600, 479},
  {-118274400, 0, 479},
  {-100735200, -3600, 479},
  {-86824800, 0, 479},
  {-68680800, -3600, 479},
  {-54770400, 0, 479},
  {INT64_MIN, 11404, 480},
  {-1846293004, 10800, 480},
  {-499924800, 14400, 480},
  {-492062400, 10800, 480},
  {INT64_MIN, 17380, 481},
  {-1988167780, 18000, 481},
  {820436400, 21600, 481},
  {INT64_MIN, 25200, 482},
  {INT64_MIN, 23400, 483},
  {INT64_MIN, 10384, 484},
  {-1846291984, 10800, 484},
  {INT64_MIN, 0, 485},
  {-631152000, 18000, 485},
  {INT64_MIN, 13308, 486},
  {-2006653308, 14400, 486},
  {INT64_MIN, 17640, 487},
  {-315636840, 18000, 487},
  {INT64_MIN, 13800, 488},
  {-1988164200, 14400, 488},
  {403041600, 18000, 488},
  {417034800, 14400, 488},
  {1224972000, 18000, 488},
  {1238274000, 14400, 488},
  {INT64_MIN, 10856, 489},
  {-1846292456, 10800, 489},
  {INT64_MIN, 13312, 490},
  {-1848886912, 14400, 490},
  {INT64_MIN, 12344, 491},
  {-1704165944, 12344, 491},
  {-757394744, 12600, 491},
  {247177800, 14400, 491},
  {259272000, 18000, 491},
  {277758000, 14400, 491},
  {283982400, 12600, 491},
  {290809800, 16200, 491},
  {306531000, 12600, 491},
  {322432200, 16200, 491},
  {338499000, 12600, 491},
  {673216200, 16200, 491},
  {685481400, 12600, 491},
  {701209800, 16200, 491},
  {717103800, 12600, 491},
  {732745800, 16200, 491},
  {748639800, 12600, 491},
  {764281800, 16200, 491},
  {780175800, 12600, 491},
  {795817800, 16200, 491},
  {811711800, 12600, 491},
  {827353800, 16200, 491},
  {843247800, 12600, 491},
  {858976200, 16200, 491},
  {874870200, 12600, 491},
  {890512200, 16200, 491},
  {906406200, 12600, 491},
  {922048200, 16200, 491},
  {937942200, 12600, 491},
  {953584200, 16200, 491},
  {969478200, 12600, 491},
  {985206600, 16200, 491},
  {1001100600, 12600, 491},
  {1016742600, 16200, 491},
  {1032636600, 12600, 491},
  {1048278600, 16200, 491},
  {1064172600, 12600, 491},
  {1079814600, 16200, 491},
  {1095708600, 12600, 491},
  {1111437000, 16200, 491},
  {1127331000, 12600, 491},
  {1206045000, 16200, 491},
  {1221939000, 12600, 491},
  {1237667400, 16200, 491},
  {1253561400, 12600, 491},
  {1269203400, 16200, 491},
  {1285097400, 12600, 491},
  {1300739400, 16200, 491},
  {1316633400, 12600, 491},
  {1332275400, 16200, 491},
  {1348169400, 12600, 491},
  {1363897800, 16200, 491},
  {1379791800, 12600, 491},
  {1395433800, 16200, 491},
  {1411327800, 12600, 491},
  {1426969800, 16200, 491},
  {1442863800, 12600, 491},
  {1458505800, 16200, 491},
  {1474399800, 12600, 491},
  {1490128200, 16200, 491},
  {1506022200, 12600, 491},
  {1521664200, 16200, 491},
  {1537558200, 12600, 491},
  {1553200200, 16200, 491},
  {1569094200, 12600, 491},
  {1584736200, 16200, 491},
  {1600630200, 12600, 491},
  {1616358600, 16200, 491},
  {1632252600, 12600, 491},
  {1647894600, 16200, 491},
  {1663788600, 12600, 491},
  {1679430600, 16200, 491},
  {1695324600, 12600, 491},
  {1710966600, 16200, 491},
  {1726860600, 12600, 491},
  {1742589000, 16200, 491},
  {1758483000, 12600, 491},
  {1774125000, 16200, 491},
  {1790019000, 12600, 491},
  {1805661000, 16200, 491},
  {1821555000, 12600, 491},
  {1837197000, 16200, 491},
  {1853091000, 12600, 491},
  {1868733000, 16200, 491},
  {1884627000, 12600, 491},
  {1900355400, 16200, 491},
  {1916249400, 12600, 491},
  {1931891400, 16200, 491},
  {1947785400, 12600, 491},
  {1963427400, 16200, 491},
  {1979321400, 12600, 491},
  {1994963400, 16200, 491},
  {2010857400, 12600, 491},
  {2026585800, 16200, 491},
  {2042479800, 12600, 491},
  {2058121800, 16200, 491},
  {2074015800, 12600, 491},
  {2089657800, 16200, 491},
  {2105551800, 12600, 491},
  {2121193800, 16200, 491},
  {2137087800, 12600, 491},
  {INT64_MIN, 8440, 492},
  {-1641003640, 7200, 492},
  {-933645600, 10800, 492},
  {-857358000, 7200, 492},
  {-844300800, 10800, 492},
  {-825822000, 7200, 492},
  {-812685600, 10800, 492},
  {-794199600, 7200, 492},
  {-779853600, 10800, 492},
  {-762656400, 7200, 492},
  {-748310400, 10800, 492},
  {-731127600, 7200, 492},
  {-681962400, 14400, 492},
  {-673243200, 10800, 492},
  {-667962000, 7200, 492},
  {-652327200, 10800, 492},
  {-636426000, 7200, 492},
  {-622087200, 10800, 492},
  {-608947200, 7200, 492},
  {-591847200, 10800, 492},
  {-572486400, 7200, 492},
  {-558576000, 10800, 492},
  {-542851200, 7200, 492},
  {-527731200, 10800, 492},
  {-514425600, 7200, 492},
  {-490845600, 10800, 492},
  {-482986800, 7200, 492},
  {-459475200, 10800, 492},
  {-451537200, 7200, 492},
  {-428551200, 10800, 492},
  {-418262400, 7200, 492},
  {-400032000, 10800, 492},
  {-387428400, 7200, 492},
  {142380000, 10800, 492},
  {150843600, 7200, 492},
  {167176800, 10800, 492},
  {178664400, 7200, 492},
  {482277600, 10800, 492},
  {495579600, 7200, 492},
  {516751200, 10800, 492},
  {526424400, 7200, 492},
  {545436000, 10800, 492},
  {558478800, 7200, 492},
  {576540000, 10800, 492},
  {589237200, 7200, 492},
  {609890400, 10800, 492},
  {620773200, 7200, 492},
  {638316000, 10800, 492},
  {651618000, 7200, 492},
  {669765600, 10800, 492},
  {683672400, 7200, 492},
  {701820000, 10800, 492},
  {715726800, 7200, 492},
  {733701600, 10800, 492},
  {747176400, 7200, 492},
  {765151200, 10800, 492},
  {778021200, 7200, 492},
  {796600800, 10800, 492},
  {810075600, 7200, 492},
  {826840800, 10800, 492},
  {842821200, 7200, 492},
  {858895200, 10800, 492},
  {874184400, 7200, 492},
  {890344800, 10800, 492},
  {905029200, 7200, 492},
  {923011200, 10800, 492},
  {936313200, 7200, 492},
  {955670400, 10800, 492},
  {970783200, 7200, 492},
  {986770800, 10800, 492},
  {1001282400, 7200, 492},
  {1017356400, 10800, 492},
  {1033941600, 7200, 492},
  {1048806000, 10800, 492},
  {1065132000, 7200, 492},
  {1081292400, 10800, 492},
  {1095804000, 7200, 492},
  {1112313600, 10800, 492},
  {1128812400, 7200, 492},
  {1143763200, 10800, 492},
  {1159657200, 7200, 492},
  {1175212800, 10800, 492},
  {1189897200, 7200, 492},
  {1206662400, 10800, 492},
  {1223161200, 7200, 492},
  {1238112000, 10800, 492},
  {1254006000, 7200, 492},
  {1269561600, 10800, 492},
  {1284246000, 7200, 492},
  {1301616000, 10800, 492},
  {1317510000, 7200, 492},
  {1333065600, 10800, 492},
  {1348354800, 7200, 492},
  {1364515200, 10800, 492},
  {1378594800, 7200, 492},
  {1395964800, 10800, 492},
  {1411858800, 7200, 492},
  {1427414400, 10800, 492},
  {1442703600, 7200, 492},
  {1459468800, 10800, 492},
  {1475967600, 7200, 492},
  {1490918400, 10800, 492},
  {1506207600, 7200, 492},
  {1522368000, 10800, 492},
  {1537052400, 7200, 492},
  {1553817600, 10800, 492},
  {1570316400, 7200, 492},
  {1585267200, 10800, 492},
  {1601161200, 7200, 492},
  {1616716800, 10800, 492},
  {1631401200, 7200, 492},
  {1648771200, 10800, 492},
  {1664665200, 7200, 492},
  {1680220800, 10800, 492},
  {1695510000, 7200, 492},
  {1711670400, 10800, 492},
  {1728169200, 7200, 492},
  {1743120000, 10800, 492},
  {1759014000, 7200, 492},
  {1774569600, 10800, 492},
  {1789858800, 7200, 492},
  {1806019200, 10800, 492},
  {1823122800, 7200, 492},
  {1838073600, 10800, 492},
  {1853362800, 7200, 492},
  {1869523200, 10800, 492},
  {1884207600, 7200, 492},
  {1900972800, 10800, 492},
  {1917471600, 7200, 492},
  {1932422400, 10800, 492},
  {1947711600, 7200, 492},
  {1963872000, 10800, 492},
  {1978556400, 7200, 492},
  {1995926400, 10800, 492},
  {2011820400, 7200, 492},
  {2027376000, 10800, 492},
  {2042060400, 7200, 492},
  {2058825600, 10800, 492},
  {2075324400, 7200, 492},
  {2090275200, 10800, 492},
  {2106169200, 7200, 492},
  {2121724800, 10800, 492},
  {2136409200, 7200, 492},
  {INT64_MIN, -18432, 493},
  {-1827687168, -18000, 493},
  {136364400, -14400, 493},
  {152085600, -18000, 493},
  {162370800, -14400, 493},
  {183535200, -18000, 493},
  {199263600, -14400, 493},
  {215589600, -18000, 493},
  {230713200, -14400, 493},
  {247039200, -18000, 493},
  {262767600, -14400, 493},
  {278488800, -18000, 493},
  {294217200, -14400, 493},
  {309938400, -18000, 493},
  {325666800, -14400, 493},
  {341388000, -18000, 493},
  {357116400, -14400, 493},
  {372837600, -18000, 493},
  {388566000, -14400, 493},
  {404892000, -18000, 493},
  {420015600, -14400, 493},
  {436341600, -18000, 493},
  {INT64_MIN, 32400, 494},
  {-1009875600, 32400, 494},
  {-683794800, 36000, 494},
  {-672393600, 32400, 494},
  {-654764400, 36000, 494},
  {-640944000, 32400, 494},
  {-620290800, 36000, 494},
  {-609494400, 32400, 494},
  {-588841200, 36000, 494},
  {-578044800, 32400, 494},
  {INT64_MIN, 39600, 495},
  {-7988400, -43200, 495},
  {745848000, 43200, 495},
  {INT64_MIN, 3164, 496},
  {-1577926364, 3600, 496},
  {-574902000, 7200, 496},
  {-568087200, 3600, 496},
  {-512175600, 7200, 496},
  {-504928800, 3600, 496},
  {-449888400, 7200, 496},
  {-441856800, 3600, 496},
  {-347158800, 7200, 496},
  {378684000, 3600, 496},
  {386463600, 7200, 496},
  {402271200, 3600, 496},
  {417999600, 7200, 496},
  {433807200, 3600, 496},
  {449622000, 7200, 496},
  {465429600, 3600, 496},
  {481590000, 7200, 496},
  {496965600, 3600, 496},
  {512953200, 7200, 496},
  {528674400, 3600, 496},
  {544230000, 7200, 496},
  {560037600, 3600, 496},
  {575852400, 7200, 496},
  {591660000, 3600, 496},
  {607388400, 7200, 496},
  {623196000, 3600, 496},
  {641775600, 7200, 496},
  {844034400, 3600, 496},
  {860108400, 7200, 496},
  {875916000, 7200, 496},
  {-1693706400, 7200, 497},
  {-1680483600, 3600, 497},
  {-1663455600, 7200, 497},
  {-1650150000, 3600, 497},
  {-1632006000, 7200, 497},
  {-1618700400, 3600, 497},
  {-938905200, 7200, 497},
  {-857257200, 3600, 497},
  {-844556400, 7200, 497},
  {-828226800, 3600, 497},
  {-812502000, 7200, 497},
  {-796777200, 3600, 497},
  {-781052400, 7200, 497},
  {-766623600, 3600, 497},
  {228877200, 7200, 497},
  {243997200, 3600, 497},
  {260326800, 7200, 497},
  {276051600, 3600, 497},
  {291776400, 7200, 497},
  {307501200, 3600, 497},
  {323830800, 7200, 497},
  {338950800, 3600, 497},
  {354675600, 7200, 497},
  {370400400, 3600, 497},
  {386125200, 7200, 497},
  {401850000, 3600, 497},
  {417574800, 7200, 497},
  {433299600, 3600, 497},
  {449024400, 7200, 497},
  {465354000, 3600, 497},
  {481078800, 7200, 497},
  {496803600, 3600, 497},
  {512528400, 7200, 497},
  {528253200, 3600, 497},
  {543978000, 7200, 497},
  {559702800, 3600, 497},
  {575427600, 7200, 497},
  {591152400, 3600, 497},
  {606877200, 7200, 497},
  {622602000, 3600, 497},
  {638326800, 7200, 497},
  {654656400, 3600, 497},
  {670381200, 7200, 497},
  {686106000, 3600, 497},
  {701830800, 7200, 497},
  {717555600, 3600, 497},
  {733280400, 7200, 497},
  {749005200, 3600, 497},
  {764730000, 7200, 497},
  {780454800, 3600, 497},
  {796179600, 7200, 497},
  {811904400, 3600, 497},
  {828234000, 7200, 497},
  {846378000, 3600, 497},
  {859683600, 7200, 497},
  {877827600, 3600, 497},
  {891133200, 7200, 497},
  {909277200, 3600, 497},
  {922582800, 7200, 497},
  {941331600, 3600, 497},
  {954032400, 7200, 497},
  {972781200, 3600, 497},
  {985482000, 7200, 497},
  {1004230800, 3600, 497},
  {1017536400, 7200, 497},
  {1035680400, 3600, 497},
  {1048986000, 7200, 497},
  {1067130000, 3600, 497},
  {1080435600, 7200, 497},
  {1099184400, 3600, 497},
  {1111885200, 7200, 497},
  {1130634000, 3600, 497},
  {1143334800, 7200, 497},
  {1162083600, 3600, 497},
  {1174784400, 7200, 497},
  {1193533200, 3600, 497},
  {1206838800, 7200, 497},
  {1224982800, 3600, 497},
  {1238288400, 7200, 497},
  {1256432400, 3600, 497},
  {1269738000, 7200, 497},
  {1288486800, 3600, 497},
  {1301187600, 7200, 497},
  {1319936400, 3600, 497},
  {1332637200, 7200, 497},
  {1351386000, 3600, 497},
  {1364691600, 7200, 497},
  {1382835600, 3600, 497},
  {1396141200, 7200, 497},
  {1414285200, 3600, 497},
  {1427590800, 7200, 497},
  {1445734800, 3600, 497},
  {1459040400, 7200, 497},
  {1477789200, 3600, 497},
  {1490490000, 7200, 497},
  {1509238800, 3600, 497},
  {1521939600, 7200, 497},
  {1540688400, 3600, 497},
  {1553994000, 7200, 497},
  {1572138000, 3600, 497},
  {1585443600, 7200, 497},
  {1603587600, 3600, 497},
  {1616893200, 7200, 497},
  {1635642000, 3600, 497},
  {1648342800, 7200, 497},
  {1667091600, 3600, 497},
  {1679792400, 7200, 497},
  {1698541200, 3600, 497},
  {1711846800, 7200, 497},
  {1729990800, 3600, 497},
  {1743296400, 7200, 497},
  {1761440400, 3600, 497},
  {1774746000, 7200, 497},
  {1792890000, 3600, 497},
  {1806195600, 7200, 497},
  {1824944400, 3600, 497},
  {1837645200, 7200, 497},
  {1856394000, 3600, 497},
  {1869094800, 7200, 497},
  {1887843600, 3600, 497},
  {1901149200, 7200, 497},
  {1919293200, 3600, 497},
  {1932598800, 7200, 497},
  {1950742800, 3600, 497},
  {1964048400, 7200, 497},
  {1982797200, 3600, 497},
  {1995498000, 7200, 497},
  {2014246800, 3600, 497},
  {2026947600, 7200, 497},
  {2045696400, 3600, 497},
  {2058397200, 7200, 497},
  {2077146000, 3600, 497},
  {2090451600, 7200, 497},
  {2108595600, 3600, 497},
  {2121901200, 7200, 497},
  {2140045200, 3600, 497},
  {INT64_MIN, -25200, 498},
  {-1633273200, -21600, 499},
  {-1615132800, -25200, 499},
  {-1601823600, -21600, 499},
  {-1583683200, -25200, 499},
  {-880210800, -21600, 499},
  {-769395600, -21600, 499},
  {-765388800, -25200, 499},
  {-84380400, -21600, 499},
  {-68659200, -25200, 499},
  {-52930800, -21600, 499},
  {-37209600, -25200, 499},
  {-21481200, -21600, 499},
  {-5760000, -25200, 499},
  {9968400, -21600, 499},
  {25689600, -25200, 499},
  {41418000, -21600, 499},
  {57744000, -25200, 499},
  {73472400, -21600, 499},
  {89193600, -25200, 499},
  {104922000, -21600, 499},
  {120643200, -25200, 499},
  {126694800, -21600, 499},
  {152092800, -25200, 499},
  {162378000, -21600, 499},
  {183542400, -25200, 499},
  {199270800, -21600, 499},
  {215596800, -25200, 499},
  {230720400, -21600, 499},
  {247046400, -25200, 499},
  {262774800, -21600, 499},
  {278496000, -25200, 499},
  {294224400, -21600, 499},
  {309945600, -25200, 499},
  {325674000, -21600, 499},
  {341395200, -25200, 499},
  {357123600, -21600, 499},
  {372844800, -25200, 499},
  {388573200, -21600, 499},
  {404899200, -25200, 499},
  {420022800, -21600, 499},
  {436348800, -25200, 499},
  {452077200, -21600, 499},
  {467798400, -25200, 499},
  {483526800, -21600, 499},
  {499248000, -25200, 499},
  {514976400, -21600, 499},
  {530697600, -25200, 499},
  {544611600, -21600, 499},
  {562147200, -25200, 499},
  {576061200, -21600, 499},
  {594201600, -25200, 499},
  {607510800, -21600, 499},
  {625651200, -25200, 499},
  {638960400, -21600, 499},
  {657100800, -25200, 499},
  {671014800, -21600, 499},
  {688550400, -25200, 499},
  {702464400, -21600, 499},
  {720000000, -25200, 499},
  {733914000, -21600, 499},
  {752054400, -25200, 499},
  {765363600, -21600, 499},
  {783504000, -25200, 499},
  {796813200, -21600, 499},
  {814953600, -25200, 499},
  {828867600, -21600, 499},
  {846403200, -25200, 499},
  {860317200, -21600, 499},
  {877852800, -25200, 499},
  {891766800, -21600, 499},
  {909302400, -25200, 499},
  {923216400, -21600, 499},
  {941356800, -25200, 499},
  {954666000, -21600, 499},
  {972806400, -25200, 499},
  {986115600, -21600, 499},
  {1004256000, -25200, 499},
  {1018170000, -21600, 499},
  {1035705600, -25200, 499},
  {1049619600, -21600, 499},
  {1067155200, -25200, 499},
  {1081069200, -21600, 499},
  {1099209600, -25200, 499},
  {1112518800, -21600, 499},
  {1130659200, -25200, 499},
  {1143968400, -21600, 499},
  {1162108800, -25200, 499},
  {1173603600, -21600, 499},
  {1194163200, -25200, 499},
  {1205053200, -21600, 499},
  {1225612800, -25200, 499},
  {1236502800, -21600, 499},
  {1257062400, -25200, 499},
  {1268557200, -21600, 499},
  {1289116800, -25200, 499},
  {1300006800, -21600, 499},
  {1320566400, -25200, 499},
  {1331456400, -21600, 499},
  {1352016000, -25200, 499},
  {1362906000, -21600, 499},
  {1383465600, -25200, 499},
  {1394355600, -21600, 499},
  {1414915200, -25200, 499},
  {1425805200, -21600, 499},
  {1446364800, -25200, 499},
  {1457859600, -21600, 499},
  {1478419200, -25200, 499},
  {1489309200, -21600, 499},
  {1509868800, -25200, 499},
  {1520758800, -21600, 499},
  {1541318400, -25200, 499},
  {1552208400, -21600, 499},
  {1572768000, -25200, 499},
  {1583658000, -21600, 499},
  {1604217600, -25200, 499},
  {1615712400, -21600, 499},
  {1636272000, -25200, 499},
  {1647162000, -21600, 499},
  {1667721600, -25200, 499},
  {1678611600, -21600, 499},
  {1699171200, -25200, 499},
  {1710061200, -21600, 499},
  {1730620800, -25200, 499},
  {1741510800, -21600, 499},
  {1762070400, -25200, 499},
  {1772960400, -21600, 499},
  {1793520000, -25200, 499},
  {1805014800, -21600, 499},
  {1825574400, -25200, 499},
  {1836464400, -21600, 499},
  {1857024000, -25200, 499},
  {1867914000, -21600, 499},
  {1888473600, -25200, 499},
  {1899363600, -21600, 499},
  {1919923200, -25200, 499},
  {1930813200, -21600, 499},
  {1951372800, -25200, 499},
  {1962867600, -21600, 499},
  {1983427200, -25200, 499},
  {1994317200, -21600, 499},
  {2014876800, -25200, 499},
  {2025766800, -21600, 499},
  {2046326400, -25200, 499},
  {2057216400, -21600, 499},
  {2077776000, -25200, 499},
  {2088666000, -21600, 499},
  {2109225600, -25200, 499},
  {2120115600, -21600, 499},
  {2140675200, -25200, 499},
  {INT64_MIN, -28084, 500},
  {-1514736000, -25200, 500},
  {-1451667600, -28800, 500},
  {-1343062800, -25200, 500},
  {-1234803600, -28800, 500},
  {-1222963200, -25200, 500},
  {-1207242000, -28800, 500},
  {-873820800, -25200, 500},
  {-769395600, -25200, 500},
  {-761677200, -28800, 500},
  {-686073600, -25200, 500},
  {-661539600, -28800, 500},
  {-495036000, -25200, 500},
  {-481734000, -28800, 500},
  {-463586400, -25200, 500},
  {-450284400, -28800, 500},
  {-431532000, -25200, 500},
  {-418230000, -28800, 500},
  {-400082400, -25200, 500},
  {-386780400, -28800, 500},
  {-368632800, -25200, 500},
  {-355330800, -28800, 500},
  {-337183200, -25200, 500},
  {-323881200, -28800, 500},
  {-305733600, -25200, 500},
  {-292431600, -28800, 500},
  {199274400, -25200, 500},
  {215600400, -28800, 500},
  {230724000, -25200, 500},
  {247050000, -28800, 500},
  {262778400, -25200, 500},
  {278499600, -28800, 500},
  {294228000, -25200, 500},
  {309949200, -28800, 500},
  {325677600, -25200, 500},
  {341398800, -28800, 500},
  {357127200, -25200, 500},
  {372848400, -28800, 500},
  {388576800, -25200, 500},
  {404902800, -28800, 500},
  {420026400, -25200, 500},
  {436352400, -28800, 500},
  {452080800, -25200, 500},
  {467802000, -28800, 500},
  {483530400, -25200, 500},
  {499251600, -28800, 500},
  {514980000, -25200, 500},
  {530701200, -28800, 500},
  {544615200, -25200, 500},
  {562150800, -28800, 500},
  {576064800, -25200, 500},
  {594205200, -28800, 500},
  {607514400, -25200, 500},
  {625654800, -28800, 500},
  {638964000, -25200, 500},
  {657104400, -28800, 500},
  {671018400, -25200, 500},
  {688554000, -28800, 500},
  {702468000, -25200, 500},
  {720003600, -28800, 500},
  {733917600, -25200, 500},
  {752058000, -28800, 500},
  {765367200, -25200, 500},
  {783507600, -28800, 500},
  {796816800, -25200, 500},
  {814957200, -28800, 500},
  {828871200, -25200, 500},
  {846406800, -28800, 500},
  {860320800, -25200, 500},
  {877856400, -28800, 500},
  {891770400, -25200, 500},
  {909306000, -28800, 500},
  {923220000, -25200, 500},
  {941360400, -28800, 500},
  {954669600, -25200, 500},
  {972810000, -28800, 500},
  {986119200, -25200, 500},
  {1004259600, -28800, 500},
  {1018173600, -25200, 500},
  {1035709200, -28800, 500},
  {1049623200, -25200, 500},
  {1067158800, -28800, 500},
  {1081072800, -25200, 500},
  {1099213200, -28800, 500},
  {1112522400, -25200, 500},
  {1130662800, -28800, 500},
  {1143972000, -25200, 500},
  {1162112400, -28800, 500},
  {1175421600, -25200, 500},
  {1193562000, -28800, 500},
  {1207476000, -25200, 500},
  {1225011600, -28800, 500},
  {1238925600, -25200, 500},
  {1256461200, -28800, 500},
  {1268560800, -25200, 500},
  {1289120400, -28800, 500},
  {1300010400, -25200, 500},
  {1320570000, -28800, 500},
  {1331460000, -25200, 500},
  {1352019600, -28800, 500},
  {1362909600, -25200, 500},
  {1383469200, -28800, 500},
  {1394359200, -25200, 500},
  {1414918800, -28800, 500},
  {1425808800, -25200, 500},
  {1446368400, -28800, 500},
  {1457863200, -25200, 500},
  {1478422800, -28800, 500},
  {1489312800, -25200, 500},
  {1509872400, -28800, 500},
  {1520762400, -25200, 500},
  {1541322000, -28800, 500},
  {1552212000, -25200, 500},
  {1572771600, -28800, 500},
  {1583661600, -25200, 500},
  {1604221200, -28800, 500},
  {1615716000, -25200, 500},
  {1636275600, -28800, 500},
  {1647165600, -25200, 500},
  {1667725200, -28800, 500},
  {1678615200, -25200, 500},
  {1699174800, -28800, 500},
  {1710064800, -25200, 500},
  {1730624400, -28800, 500},
  {1741514400, -25200, 500},
  {1762074000, -28800, 500},
  {1772964000, -25200, 500},
  {1793523600, -28800, 500},
  {1805018400, -25200, 500},
  {1825578000, -28800, 500},
  {1836468000, -25200, 500},
  {1857027600, -28800, 500},
  {1867917600, -25200, 500},
  {1888477200, -28800, 500},
  {1899367200, -25200, 500},
  {1919926800, -28800, 500},
  {1930816800, -25200, 500},
  {1951376400, -28800, 500},
  {1962871200, -25200, 500},
  {1983430800, -28800, 500},
  {1994320800, -25200, 500},
  {2014880400, -28800, 500},
  {2025770400, -25200, 500},
  {2046330000, -28800, 500},
  {2057220000, -25200, 500},
  {2077779600, -28800, 500},
  {2088669600, -25200, 500},
  {2109229200, -28800, 500},
  {2120119200, -25200, 500},
  {2140678800, -28800, 500},
  {INT64_MIN, -25540, 501},
  {-1514739600, -25200, 501},
  {-1343066400, -21600, 501},
  {-1234807200, -25200, 501},
  {-1220292000, -21600, 501},
  {-1207159200, -25200, 501},
  {-1191344400, -21600, 501},
  {-873828000, -25200, 501},
  {-661539600, -28800, 501},
  {28800, -25200, 501},
  {828867600, -21600, 501},
  {846403200, -25200, 501},
  {860317200, -21600, 501},
  {877852800, -25200, 501},
  {891766800, -21600, 501},
  {909302400, -25200, 501},
  {923216400, -21600, 501},
  {941356800, -25200, 501},
  {954666000, -21600, 501},
  {972806400, -25200, 501},
  {989139600, -21600, 501},
  {1001836800, -25200, 501},
  {1018170000, -21600, 501},
  {1035705600, -25200, 501},
  {1049619600, -21600, 501},
  {1067155200, -25200, 501},
  {1081069200, -21600, 501},
  {1099209600, -25200, 501},
  {1112518800, -21600, 501},
  {1130659200, -25200, 501},
  {1143968400, -21600, 501},
  {1162108800, -25200, 501},
  {1175418000, -21600, 501},
  {1193558400, -25200, 501},
  {1207472400, -21600, 501},
  {1225008000, -25200, 501},
  {1238922000, -21600, 501},
  {1256457600, -25200, 501},
  {1270371600, -21600, 501},
  {1288512000, -25200, 501},
  {1301821200, -21600, 501},
  {1319961600, -25200, 501},
  {1333270800, -21600, 501},
  {1351411200, -25200, 501},
  {1365325200, -21600, 501},
  {1382860800, -25200, 501},
  {1396774800, -21600, 501},
  {1414310400, -25200, 501},
  {1428224400, -21600, 501},
  {1445760000, -25200, 501},
  {1459674000, -21600, 501},
  {1477814400, -25200, 501},
  {1491123600, -21600, 501},
  {1509264000, -25200, 501},
  {1522573200, -21600, 501},
  {1540713600, -25200, 501},
  {1554627600, -21600, 501},
  {1572163200, -25200, 501},
  {1586077200, -21600, 501},
  {1603612800, -25200, 501},
  {1617526800, -21600, 501},
  {1635667200, -25200, 501},
  {1648976400, -21600, 501},
  {1667116800, -25200, 501},
  {1680426000, -21600, 501},
  {1698566400, -25200, 501},
  {1712480400, -21600, 501},
  {1730016000, -25200, 501},
  {1743930000, -21600, 501},
  {1761465600, -25200, 501},
  {1775379600, -21600, 501},
  {1792915200, -25200, 501},
  {1806829200, -21600, 501},
  {1824969600, -25200, 501},
  {1838278800, -21600, 501},
  {1856419200, -25200, 501},
  {1869728400, -21600, 501},
  {1887868800, -25200, 501},
  {1901782800, -21600, 501},
  {1919318400, -25200, 501},
  {1933232400, -21600, 501},
  {1950768000, -25200, 501},
  {1964682000, -21600, 501},
  {1982822400, -25200, 501},
  {1996131600, -21600, 501},
  {2014272000, -25200, 501},
  {2027581200, -21600, 501},
  {2045721600, -25200, 501},
  {2059030800, -21600, 501},
  {2077171200, -25200, 501},
  {2091085200, -21600, 501},
  {2108620800, -25200, 501},
  {2122534800, -21600, 501},
  {2140070400, -25200, 501},
  {INT64_MIN, -23796, 502},
  {-1514739600, -25200, 502},
  {-1343066400, -21600, 502},
  {-1234807200, -25200, 502},
  {-1220292000, -21600, 502},
  {-1207159200, -25200, 502},
  {-1191344400, -21600, 502},
  {-975261600, -18000, 502},
  {-963169200, -21600, 502},
  {-917114400, -18000, 502},
  {-907354800, -21600, 502},
  {-821901600, -18000, 502},
  {-810068400, -21600, 502},
  {-627501600, -18000, 502},
  {-612990000, -21600, 502},
  {828864000, -18000, 502},
  {846399600, -21600, 502},
  {860313600, -18000, 502},
  {877849200, -21600, 502},
  {891763200, -18000, 502},
  {909298800, -21600, 502},
  {923212800, -18000, 502},
  {941353200, -21600, 502},
  {954662400, -18000, 502},
  {972802800, -21600, 502},
  {989136000, -18000, 502},
  {1001833200, -21600, 502},
  {1018166400, -18000, 502},
  {1035702000, -21600, 502},
  {1049616000, -18000, 502},
  {1067151600, -21600, 502},
  {1081065600, -18000, 502},
  {1099206000, -21600, 502},
  {1112515200, -18000, 502},
  {1130655600, -21600, 502},
  {1143964800, -18000, 502},
  {1162105200, -21600, 502},
  {1175414400, -18000, 502},
  {1193554800, -21600, 502},
  {1207468800, -18000, 502},
  {1225004400, -21600, 502},
  {1238918400, -18000, 502},
  {1256454000, -21600, 502},
  {1270368000, -18000, 502},
  {1288508400, -21600, 502},
  {1301817600, -18000, 502},
  {1319958000, -21600, 502},
  {1333267200, -18000, 502},
  {1351407600, -21600, 502},
  {1365321600, -18000, 502},
  {1382857200, -21600, 502},
  {1396771200, -18000, 502},
  {1414306800, -21600, 502},
  {1428220800, -18000, 502},
  {1445756400, -21600, 502},
  {1459670400, -18000, 502},
  {1477810800, -21600, 502},
  {1491120000, -18000, 502},
  {1509260400, -21600, 502},
  {1522569600, -18000, 502},
  {1540710000, -21600, 502},
  {1554624000, -18000, 502},
  {1572159600, -21600, 502},
  {1586073600, -18000, 502},
  {1603609200, -21600, 502},
  {1617523200, -18000, 502},
  {1635663600, -21600, 502},
  {1648972800, -18000, 502},
  {1667113200, -21600, 502},
  {1680422400, -18000, 502},
  {1698562800, -21600, 502},
  {1712476800, -18000, 502},
  {1730012400, -21600, 502},
  {1743926400, -18000, 502},
  {1761462000, -21600, 502},
  {1775376000, -18000, 502},
  {1792911600, -21600, 502},
  {1806825600, -18000, 502},
  {1824966000, -21600, 502},
  {1838275200, -18000, 502},
  {1856415600, -21600, 502},
  {1869724800, -18000, 502},
  {1887865200, -21600, 502},
  {1901779200, -18000, 502},
  {1919314800, -21600, 502},
  {1933228800, -18000, 502},
  {1950764400, -21600, 502},
  {1964678400, -18000, 502},
  {1982818800, -21600, 502},
  {1996128000, -18000, 502},
  {2014268400, -21600, 502},
  {2027577600, -18000, 502},
  {2045718000, -21600, 502},
  {2059027200, -18000, 502},
  {2077167600, -21600, 502},
  {2091081600, -18000, 502},
  {2108617200, -21600, 502},
  {2122531200, -18000, 502},
  {2140066800, -21600, 502},
  {-1330335000, 45000, 503},
  {-1320057000, 41400, 503},
  {-1300699800, 43200, 503},
  {-1287396000, 41400, 503},
  {-1269250200, 43200, 503},
  {-1255946400, 41400, 503},
  {-1237800600, 43200, 503},
  {-1224496800, 41400, 503},
  {-1206351000, 43200, 503},
  {-1192442400, 41400, 503},
  {-1174901400, 43200, 503},
  {-1160992800, 41400, 503},
  {-1143451800, 43200, 503},
  {-1125914400, 41400, 503},
  {-1112607000, 43200, 503},
  {-1094464800, 41400, 503},
  {-1081157400, 43200, 503},
  {-1063015200, 41400, 503},
  {-1049707800, 43200, 503},
  {-1031565600, 41400, 503},
  {-1018258200, 43200, 503},
  {-1000116000, 41400, 503},
  {-986808600, 43200, 503},
  {-968061600, 41400, 503},
  {-955359000, 43200, 503},
  {-936612000, 41400, 503},
  {-923304600, 43200, 503},
  {-757425600, 43200, 503},
  {152632800, 46800, 503},
  {162309600, 43200, 503},
  {183477600, 46800, 503},
  {194968800, 43200, 503},
  {215532000, 46800, 503},
  {226418400, 43200, 503},
  {246981600, 46800, 503},
  {257868000, 43200, 503},
  {278431200, 46800, 503},
  {289317600, 43200, 503},
  {309880800, 46800, 503},
  {320767200, 43200, 503},
  {341330400, 46800, 503},
  {352216800, 43200, 503},
  {372780000, 46800, 503},
  {384271200, 43200, 503},
  {404834400, 46800, 503},
  {415720800, 43200, 503},
  {436284000, 46800, 503},
  {447170400, 43200, 503},
  {467733600, 46800, 503},
  {478620000, 43200, 503},
  {499183200, 46800, 503},
  {510069600, 43200, 503},
  {530632800, 46800, 503},
  {541519200, 43200, 503},
  {562082400, 46800, 503},
  {573573600, 43200, 503},
  {594136800, 46800, 503},
  {605023200, 43200, 503},
  {623772000, 46800, 503},
  {637682400, 43200, 503},
  {655221600, 46800, 503},
  {669132000, 43200, 503},
  {686671200, 46800, 503},
  {700581600, 43200, 503},
  {718120800, 46800, 503},
  {732636000, 43200, 503},
  {749570400, 46800, 503},
  {764085600, 43200, 503},
  {781020000, 46800, 503},
  {795535200, 43200, 503},
  {812469600, 46800, 503},
  {826984800, 43200, 503},
  {844524000, 46800, 503},
  {858434400, 43200, 503},
  {875973600, 46800, 503},
  {889884000, 43200, 503},
  {907423200, 46800, 503},
  {921938400, 43200, 503},
  {938872800, 46800, 503},
  {953388000, 43200, 503},
  {970322400, 46800, 503},
  {984837600, 43200, 503},
  {1002376800, 46800, 503},
  {1016287200, 43200, 503},
  {1033826400, 46800, 503},
  {1047736800, 43200, 503},
  {1065276000, 46800, 503},
  {1079791200, 43200, 503},
  {1096725600, 46800, 503},
  {1111240800, 43200, 503},
  {1128175200, 46800, 503},
  {1142690400, 43200, 503},
  {1159624800, 46800, 503},
  {1174140000, 43200, 503},
  {1191074400, 46800, 503},
  {1207404000, 43200, 503},
  {1222524000, 46800, 503},
  {1238853600, 43200, 503},
  {1253973600, 46800, 503},
  {1270303200, 43200, 503},
  {1285423200, 46800, 503},
  {1301752800, 43200, 503},
  {1316872800, 46800, 503},
  {1333202400, 43200, 503},
  {1348927200, 46800, 503},
  {1365256800, 43200, 503},
  {1380376800, 46800, 503},
  {1396706400, 43200, 503},
  {1411826400, 46800, 503},
  {1428156000, 43200, 503},
  {1443276000, 46800, 503},
  {1459605600, 43200, 503},
  {1474725600, 46800, 503},
  {1491055200, 43200, 503},
  {1506175200, 46800, 503},
  {1522504800, 43200, 503},
  {1538229600, 46800, 503},
  {1554559200, 43200, 503},
  {1569679200, 46800, 503},
  {1586008800, 43200, 503},
  {1601128800, 46800, 503},
  {1617458400, 43200, 503},
  {1632578400, 46800, 503},
  {1648908000, 43200, 503},
  {1664028000, 46800, 503},
  {1680357600, 43200, 503},
  {1695477600, 46800, 503},
  {1712412000, 43200, 503},
  {1727532000, 46800, 503},
  {1743861600, 43200, 503},
  {1758981600, 46800, 503},
  {1775311200, 43200, 503},
  {1790431200, 46800, 503},
  {1806760800, 43200, 503},
  {1821880800, 46800, 503},
  {1838210400, 43200, 503},
  {1853330400, 46800, 503},
  {1869660000, 43200, 503},
  {1885384800, 46800, 503},
  {1901714400, 43200, 503},
  {1916834400, 46800, 503},
  {1933164000, 43200, 503},
  {1948284000, 46800, 503},
  {1964613600, 43200, 503},
  {1979733600, 46800, 503},
  {1996063200, 43200, 503},
  {2011183200, 46800, 503},
  {2027512800, 43200, 503},
  {2042632800, 46800, 503},
  {2058962400, 43200, 503},
  {2074687200, 46800, 503},
  {2091016800, 43200, 503},
  {2106136800, 46800, 503},
  {2122466400, 43200, 503},
  {2137586400, 46800, 503},
  {INT64_MIN, 44028, 504},
  {-410271228, 45900, 504},
  {152632800, 49500, 504},
  {162309600, 45900, 504},
  {183477600, 49500, 504},
  {194968800, 45900, 504},
  {215532000, 49500, 504},
  {226418400, 45900, 504},
  {246981600, 49500, 504},
  {257868000, 45900, 504},
  {278431200, 49500, 504},
  {289317600, 45900, 504},
  {309880800, 49500, 504},
  {320767200, 45900, 504},
  {341330400, 49500, 504},
  {352216800, 45900, 504},
  {372780000, 49500, 504},
  {384271200, 45900, 504},
  {404834400, 49500, 504},
  {415720800, 45900, 504},
  {436284000, 49500, 504},
  {447170400, 45900, 504},
  {467733600, 49500, 504},
  {478620000, 45900, 504},
  {499183200, 49500, 504},
  {510069600, 45900, 504},
  {530632800, 49500, 504},
  {541519200, 45900, 504},
  {562082400, 49500, 504},
  {573573600, 45900, 504},
  {594136800, 49500, 504},
  {605023200, 45900, 504},
  {623772000, 49500, 504},
  {637682400, 45900, 504},
  {655221600, 49500, 504},
  {669132000, 45900, 504},
  {686671200, 49500, 504},
  {700581600, 45900, 504},
  {718120800, 49500, 504},
  {732636000, 45900, 504},
  {749570400, 49500, 504},
  {764085600, 45900, 504},
  {781020000, 49500, 504},
  {795535200, 45900, 504},
  {812469600, 49500, 504},
  {826984800, 45900, 504},
  {844524000, 49500, 504},
  {858434400, 45900, 504},
  {875973600, 49500, 504},
  {889884000, 45900, 504},
  {907423200, 49500, 504},
  {921938400, 45900, 504},
  {938872800, 49500, 504},
  {953388000, 45900, 504},
  {970322400, 49500, 504},
  {984837600, 45900, 504},
  {1002376800, 49500, 504},
  {1016287200, 45900, 504},
  {1033826400, 49500, 504},
  {1047736800, 45900, 504},
  {1065276000, 49500, 504},
  {1079791200, 45900, 504},
  {1096725600, 49500, 504},
  {1111240800, 45900, 504},
  {1128175200, 49500, 504},
  {1142690400, 45900, 504},
  {1159624800, 49500, 504},
  {1174140000, 45900, 504},
  {1191074400, 49500, 504},
  {1207404000, 45900, 504},
  {1222524000, 49500, 504},
  {1238853600, 45900, 504},
  {1253973600, 49500, 504},
  {1270303200, 45900, 504},
  {1285423200, 49500, 504},
  {1301752800, 45900, 504},
  {1316872800, 49500, 504},
  {1333202400, 45900, 504},
  {1348927200, 49500, 504},
  {1365256800, 45900, 504},
  {1380376800, 49500, 504},
  {1396706400, 45900, 504},
  {1411826400, 49500, 504},
  {1428156000, 45900, 504},
  {1443276000, 49500, 504},
  {1459605600, 45900, 504},
  {1474725600, 49500, 504},
  {1491055200, 45900, 504},
  {1506175200, 49500, 504},
  {1522504800, 45900, 504},
  {1538229600, 49500, 504},
  {1554559200, 45900, 504},
  {1569679200, 49500, 504},
  {1586008800, 45900, 504},
  {1601128800, 49500, 504},
  {1617458400, 45900, 504},
  {1632578400, 49500, 504},
  {1648908000, 45900, 504},
  {1664028000, 49500, 504},
  {1680357600, 45900, 504},
  {1695477600, 49500, 504},
  {1712412000, 45900, 504},
  {1727532000, 49500, 504},
  {1743861600, 45900, 504},
  {1758981600, 49500, 504},
  {1775311200, 45900, 504},
  {1790431200, 49500, 504},
  {1806760800, 45900, 504},
  {1821880800, 49500, 504},
  {1838210400, 45900, 504},
  {1853330400, 49500, 504},
  {1869660000, 45900, 504},
  {1885384800, 49500, 504},
  {1901714400, 45900, 504},
  {1916834400, 49500, 504},
  {1933164000, 45900, 504},
  {1948284000, 49500, 504},
  {1964613600, 45900, 504},
  {1979733600, 49500, 504},
  {1996063200, 45900, 504},
  {2011183200, 49500, 504},
  {2027512800, 45900, 504},
  {2042632800, 49500, 504},
  {2058962400, 45900, 504},
  {2074687200, 49500, 504},
  {2091016800, 45900, 504},
  {2106136800, 49500, 504},
  {2122466400, 45900, 504},
  {2137586400, 49500, 504},
  {-1633273200, -21600, 505},
  {-1615132800, -25200, 505},
  {-1601823600, -21600, 505},
  {-1583683200, -25200, 505},
  {-1570374000, -21600, 505},
  {-1551628800, -25200, 505},
  {-1538924400, -21600, 505},
  {-1534089600, -25200, 505},
  {-880210800, -21600, 505},
  {-769395600, -21600, 505},
  {-765388800, -25200, 505},
  {-147884400, -21600, 505},
  {-131558400, -25200, 505},
  {-116434800, -21600, 505},
  {-100108800, -25200, 505},
  {-84380400, -21600, 505},
  {-68659200, -25200, 505},
  {-52930800, -21600, 505},
  {-37209600, -25200, 505},
  {-21481200, -21600, 505},
  {-5760000, -25200, 505},
  {9968400, -21600, 505},
  {25689600, -25200, 505},
  {41418000, -21600, 505},
  {57744000, -25200, 505},
  {73472400, -21600, 505},
  {89193600, -25200, 505},
  {104922000, -21600, 505},
  {120643200, -25200, 505},
  {126694800, -21600, 505},
  {152092800, -25200, 505},
  {162378000, -21600, 505},
  {183542400, -25200, 505},
  {199270800, -21600, 505},
  {215596800, -25200, 505},
  {230720400, -21600, 505},
  {247046400, -25200, 505},
  {262774800, -21600, 505},
  {278496000, -25200, 505},
  {294224400, -21600, 505},
  {309945600, -25200, 505},
  {325674000, -21600, 505},
  {341395200, -25200, 505},
  {357123600, -21600, 505},
  {372844800, -25200, 505},
  {388573200, -21600, 505},
  {404899200, -25200, 505},
  {420022800, -21600, 505},
  {436348800, -25200, 505},
  {452077200, -21600, 505},
  {467798400, -25200, 505},
  {483526800, -21600, 505},
  {499248000, -25200, 505},
  {514976400, -21600, 505},
  {530697600, -25200, 505},
  {544611600, -21600, 505},
  {562147200, -25200, 505},
  {576061200, -21600, 505},
  {594201600, -25200, 505},
  {607510800, -21600, 505},
  {625651200, -25200, 505},
  {638960400, -21600, 505},
  {657100800, -25200, 505},
  {671014800, -21600, 505},
  {688550400, -25200, 505},
  {702464400, -21600, 505},
  {720000000, -25200, 505},
  {733914000, -21600, 505},
  {752054400, -25200, 505},
  {765363600, -21600, 505},
  {783504000, -25200, 505},
  {796813200, -21600, 505},
  {814953600, -25200, 505},
  {828867600, -21600, 505},
  {846403200, -25200, 505},
  {860317200, -21600, 505},
  {877852800, -25200, 505},
  {891766800, -21600, 505},
  {909302400, -25200, 505},
  {923216400, -21600, 505},
  {941356800, -25200, 505},
  {954666000, -21600, 505},
  {972806400, -25200, 505},
  {986115600, -21600, 505},
  {1004256000, -25200, 505},
  {1018170000, -21600, 505},
  {1035705600, -25200, 505},
  {1049619600, -21600, 505},
  {1067155200, -25200, 505},
  {1081069200, -21600, 505},
  {1099209600, -25200, 505},
  {1112518800, -21600, 505},
  {1130659200, -25200, 505},
  {1143968400, -21600, 505},
  {1162108800, -25200, 505},
  {1173603600, -21600, 505},
  {1194163200, -25200, 505},
  {1205053200, -21600, 505},
  {1225612800, -25200, 505},
  {1236502800, -21600, 505},
  {1257062400, -25200, 505},
  {1268557200, -21600, 505},
  {1289116800, -25200, 505},
  {1300006800, -21600, 505},
  {1320566400, -25200, 505},
  {1331456400, -21600, 505},
  {1352016000, -25200, 505},
  {1362906000, -21600, 505},
  {1383465600, -25200, 505},
  {1394355600, -21600, 505},
  {1414915200, -25200, 505},
  {1425805200, -21600, 505},
  {1446364800, -25200, 505},
  {1457859600, -21600, 505},
  {1478419200, -25200, 505},
  {1489309200, -21600, 505},
  {1509868800, -25200, 505},
  {1520758800, -21600, 505},
  {1541318400, -25200, 505},
  {1552208400, -21600, 505},
  {1572768000, -25200, 505},
  {1583658000, -21600, 505},
  {1604217600, -25200, 505},
  {1615712400, -21600, 505},
  {1636272000, -25200, 505},
  {1647162000, -21600, 505},
  {1667721600, -25200, 505},
  {1678611600, -21600, 505},
  {1699171200, -25200, 505},
  {1710061200, -21600, 505},
  {1730620800, -25200, 505},
  {1741510800, -21600, 505},
  {1762070400, -25200, 505},
  {1772960400, -21600, 505},
  {1793520000, -25200, 505},
  {1805014800, -21600, 505},
  {1825574400, -25200, 505},
  {1836464400, -21600, 505},
  {1857024000, -25200, 505},
  {1867914000, -21600, 505},
  {1888473600, -25200, 505},
  {1899363600, -21600, 505},
  {1919923200, -25200, 505},
  {1930813200, -21600, 505},
  {1951372800, -25200, 505},
  {1962867600, -21600, 505},
  {1983427200, -25200, 505},
  {1994317200, -21600, 505},
  {2014876800, -25200, 505},
  {2025766800, -21600, 505},
  {2046326400, -25200, 505},
  {2057216400, -21600, 505},
  {2077776000, -25200, 505},
  {2088666000, -21600, 505},
  {2109225600, -25200, 505},
  {2120115600, -21600, 505},
  {2140675200, -25200, 505},
  {INT64_MIN, 29152, 506},
  {-1325491552, 28800, 506},
  {-933494400, 32400, 506},
  {-923130000, 28800, 506},
  {-908784000, 32400, 506},
  {-891594000, 28800, 506},
  {515520000, 32400, 506},
  {527007600, 28800, 506},
  {545155200, 32400, 506},
  {558457200, 28800, 506},
  {576604800, 32400, 506},
  {589906800, 28800, 506},
  {608659200, 32400, 506},
  {621961200, 28800, 506},
  {640108800, 32400, 506},
  {653410800, 28800, 506},
  {671558400, 32400, 506},
  {684860400, 28800, 506},
  {-1633269600, -25200, 507},
  {-1615129200, -28800, 507},
  {-1601820000, -25200, 507},
  {-1583679600, -28800, 507},
  {-880207200, -25200, 507},
  {-769395600, -25200, 507},
  {-765385200, -28800, 507},
  {-84376800, -25200, 507},
  {-68655600, -28800, 507},
  {-52927200, -25200, 507},
  {-37206000, -28800, 507},
  {-21477600, -25200, 507},
  {-5756400, -28800, 507},
  {9972000, -25200, 507},
  {25693200, -28800, 507},
  {41421600, -25200, 507},
  {57747600, -28800, 507},
  {73476000, -25200, 507},
  {89197200, -28800, 507},
  {104925600, -25200, 507},
  {120646800, -28800, 507},
  {126698400, -25200, 507},
  {152096400, -28800, 507},
  {162381600, -25200, 507},
  {183546000, -28800, 507},
  {199274400, -25200, 507},
  {215600400, -28800, 507},
  {230724000, -25200, 507},
  {247050000, -28800, 507},
  {262778400, -25200, 507},
  {278499600, -28800, 507},
  {294228000, -25200, 507},
  {309949200, -28800, 507},
  {325677600, -25200, 507},
  {341398800, -28800, 507},
  {357127200, -25200, 507},
  {372848400, -28800, 507},
  {388576800, -25200, 507},
  {404902800, -28800, 507},
  {420026400, -25200, 507},
  {436352400, -28800, 507},
  {452080800, -25200, 507},
  {467802000, -28800, 507},
  {483530400, -25200, 507},
  {499251600, -28800, 507},
  {514980000, -25200, 507},
  {530701200, -28800, 507},
  {544615200, -25200, 507},
  {562150800, -28800, 507},
  {576064800, -25200, 507},
  {594205200, -28800, 507},
  {607514400, -25200, 507},
  {625654800, -28800, 507},
  {638964000, -25200, 507},
  {657104400, -28800, 507},
  {671018400, -25200, 507},
  {688554000, -28800, 507},
  {702468000, -25200, 507},
  {720003600, -28800, 507},
  {733917600, -25200, 507},
  {752058000, -28800, 507},
  {765367200, -25200, 507},
  {783507600, -28800, 507},
  {796816800, -25200, 507},
  {814957200, -28800, 507},
  {828871200, -25200, 507},
  {846406800, -28800, 507},
  {860320800, -25200, 507},
  {877856400, -28800, 507},
  {891770400, -25200, 507},
  {909306000, -28800, 507},
  {923220000, -25200, 507},
  {941360400, -28800, 507},
  {954669600, -25200, 507},
  {972810000, -28800, 507},
  {986119200, -25200, 507},
  {1004259600, -28800, 507},
  {1018173600, -25200, 507},
  {1035709200, -28800, 507},
  {1049623200, -25200, 507},
  {1067158800, -28800, 507},
  {1081072800, -25200, 507},
  {1099213200, -28800,