# Copyright 2020 Huawei Technologies Co., Ltd
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ============================================================================
"""Trigger data manager load."""

from mindinsight.datavisual.data_transform.data_manager import DATA_MANAGER
from mindinsight.datavisual.common.log import logger
from mindinsight.conf import settings


def init_module(app):
    """
    Interface to init module.

    Args:
        app (Flask): An instance of Flask.

    """
    # Just to suppress pylint warning about unused arg.
    logger.debug("App: %s", type(app))
    # Register cache item updater here, before start load data.
    DATA_MANAGER.start_load_data(reload_interval=int(settings.RELOAD_INTERVAL),
                                 max_threads_count=int(settings.MAX_THREADS_COUNT))
