# MindInsight Commands

<a href="https://gitee.com/mindspore/docs/blob/r0.6/tutorials/source_en/advanced_use/mindinsight_commands.md" target="_blank"><img src="../_static/logo_source.png"></a>

<!-- TOC -->

- [MindInsight Commands](#mindinsight-commands)
    - [View the Command Help Information](#view-the-command-help-information)
    - [View the Version Information](#view-the-version-information)
    - [Start the Service](#start-the-service)
    - [View the Service Process Information](#view-the-service-process-information)
    - [Stop the Service](#stop-the-service)

<!-- /TOC -->

## View the Command Help Information

```shell
mindinsight --help
```

## View the Version Information

```shell
mindinsight --version
```

## Start the Service

```shell
mindinsight start [-h] [--config <CONFIG>] [--workspace <WORKSPACE>]
                  [--port <PORT>] [--url-path-prefix <URL_PATH_PREFIX>]
                  [--reload-interval <RELOAD_INTERVAL>]
                  [--summary-base-dir <SUMMARY_BASE_DIR>]
```

Optional parameters as follows:

|Name|Argument|Description|Type|Default|Scope|Specifications|
|---|---|---|---|---|---|---|
|`-h, --help`|Optional|Displays the help information about the start command.|-|-|-|-|
|`--config <CONFIG>`|Optional|Specifies the configuration file or module.|str|Empty string|-|Physical file path (file:/path/to/config.py) or a module path (python:path.to.config.module) that can be identified by Python.|
|`--workspace <WORKSPACE>`|Optional|Specifies the working directory.|str|$HOME/mindinsight|-|-|
|`--port <PORT>`|Optional|Specifies the port number of the web visualization service.|int|8080|1~65535|-|
|`--url-path-prefix <URL_PATH_PREFIX>`|Optional|Specifies the URL path prefix of the web visualization service.|str|Empty string|-|URL path prefix consists of segments separated by slashes. Each segment supports alphabets / digits / underscores / dashes / dots, but not single dot or double dots.|
|`--reload-interval <RELOAD_INTERVAL>`|Optional|Specifies the interval (unit: second) for loading data.|int|3|-|The value 0 indicates that data is loaded only once.|
|`--summary-base-dir <SUMMARY_BASE_DIR>`|Optional|Specifies the root directory for loading training log data.|str|./|-|MindInsight traverses the direct subdirectories in this directory and searches for log files. If a direct subdirectory contains log files, it is identified as the log file directory. If a root directory contains log files, it is identified as the log file directory.|

> When the service is started, the parameter values of the command line are saved as the environment variables of the process and start with `MINDINSIGHT_`, for example, `MINDINSIGHT_CONFIG`, `MINDINSIGHT_WORKSPACE`, and `MINDINSIGHT_PORT`.

## View the Service Process Information

MindInsight provides user with web services. Run the following command to view the running web service process:

```shell
ps -ef | grep mindinsight
```

Run the following command to access the working directory `WORKSPACE` corresponding to the service process based on the service process ID:

```shell
lsof -p <PID> | grep access
```

Output with the working directory `WORKSPACE` as follows:

```shell
gunicorn  <PID>  <USER>  <FD>  <TYPE>  <DEVICE>  <SIZE/OFF>  <NODE>  <WORKSPACE>/log/gunicorn/access.log
```

## Stop the Service

```shell
mindinsight stop [-h] [--port PORT]
```

Optional parameters as follows:

|Name|Argument|Description|Type|Default|Scope|Specifications|
|---|---|---|---|---|---|---|
|`-h, --help`|Optional|Displays the help information about the stop command.|-|-|-|-|
|`--port <PORT>`|Optional|Specifies the port number of the web visualization service.|int|8080|1~65535|-|
