#include "src/cuda/warp_perspective/common.h"

#include "megdnn/oprs.h"
#include "src/common/utils.h"

namespace megdnn {
namespace cuda {
namespace warp_perspective {

BorderMode get_bmode(param::WarpPerspective::BorderMode bmode) {
    using BMode = WarpPerspective::BorderMode;
    switch (bmode) {
        case BMode::REFLECT_101:
            return BORDER_REFLECT_101;
        case BMode::REPLICATE:
            return BORDER_REPLICATE;
        case BMode::REFLECT:
            return BORDER_REFLECT;
        case BMode::WRAP:
            return BORDER_WRAP;
        case BMode::CONSTANT:
            return BORDER_CONSTANT;
        case BMode::TRANSPARENT:
            return BORDER_TRANSPARENT;
        case BMode::ISOLATED:
            return BORDER_ISOLATED;
        default:
            megdnn_throw("impossible");
    }
}

InterpolationMode get_imode(param::WarpPerspective::InterpolationMode imode) {
    using IMode = param::WarpPerspective::InterpolationMode;
    switch (imode) {
        case IMode::NEAREST:
            return INTER_NEAREST;
        case IMode::LINEAR:
            return INTER_LINEAR;
        case IMode::AREA:
            return INTER_AREA;
        case IMode::CUBIC:
            return INTER_CUBIC;
        case IMode::LANCZOS4:
            return INTER_LANCZOS4;
        default:
            megdnn_throw("impossible");
    }
}

}  // namespace warp_perspective
}  // namespace cuda
}  // namespace megdnn

// vim: syntax=cpp.doxygen
